<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'de', version '4.1'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Alle Abhängigkeiten sind vollständig.';
$string['competencies'] = 'Kompetenzen';
$string['competenciesarenotenabled'] = 'Kompetenzen sind nicht aktiviert.';
$string['competenciessettings'] = 'Einstellungen für Kompetenzen';
$string['completeplanstask'] = 'Lernpläne abschließen, die abgelaufen sind';
$string['coursecompetencyoutcome_complete'] = 'Kompetenz abschließen';
$string['coursecompetencyoutcome_evidence'] = 'Belege anhängen';
$string['coursecompetencyoutcome_none'] = 'Abwarten';
$string['coursecompetencyoutcome_recommend'] = 'Zur Prüfung einsenden';
$string['coursemodulecompetencyoutcome_complete'] = 'Kompetenz abschließen';
$string['coursemodulecompetencyoutcome_evidence'] = 'Belege anhängen';
$string['coursemodulecompetencyoutcome_none'] = 'Abwarten';
$string['coursemodulecompetencyoutcome_recommend'] = 'Zur Prüfung einsenden';
$string['deletecompetencyratings'] = 'Kompetenzwertungen löschen';
$string['duplicateditemname'] = '{$a} (Kopie)';
$string['enablecompetencies'] = 'Kompetenzen aktivieren';
$string['enablecompetencies_desc'] = 'Kompetenzen ermöglichen es, Nutzer/innen anhand von Lernplänen zu beurteilen.';
$string['errorcannotchangeapastduedate'] = 'Der Fälligkeitstermin ist vorbei. Es kann nichts mehr geändert werden.';
$string['errorcannotsetduedateinthepast'] = 'Der Fälligkeitstermin kann nicht in der Vergangenheit liegen.';
$string['errorcannotsetduedatetoosoon'] = 'Der Fälligkeitstermin liegt zu nah.';
$string['errorcompetencyrule'] = 'Die Regel für die Kurskompetenz \'{$a}\' ist unbekannt.';
$string['errorcoursecompetencyrule'] = 'Die Regel für die Kurskompetenz \'{$a}\' ist unbekannt.';
$string['errorinvalidcourse'] = 'Falscher Kurs';
$string['errornocompetency'] = 'Die Kompetenz \'{$a}\' kann nicht gefunden werden.';
$string['errorplanstatus'] = 'Der Lernplanstatus \'{$a}\' ist unbekannt.';
$string['errorscalealreadyused'] = 'Die Skala kann nicht geändert werden, weil sie bereits in Gebrauch ist.';
$string['errorscaleconfiguration'] = 'Die Skala muss durch konfiguriert werden. In der ersten Spalte wird der Wert festgelegt, der bei automatischer Feststellung einer Kompetenz vergeben wird. In der zweiten Spalte werden Werte hinterlegt, die bei manueller Bewertung zur Auswahl stehen sollen.';
$string['errorusercomptencystatus'] = 'Der Nutzerkompetenzstatus \'{$a}\' ist unbekannt.';
$string['eventcompetencycreated'] = 'Kompetenz angelegt';
$string['eventcompetencydeleted'] = 'Kompetenz gelöscht';
$string['eventcompetencyframeworkcreated'] = 'Kompetenzrahmen angelegt';
$string['eventcompetencyframeworkdeleted'] = 'Kompetenzrahmen gelöscht';
$string['eventcompetencyframeworkupdated'] = 'Kompetenzrahmen aktualisiert';
$string['eventcompetencyframeworkviewed'] = 'Kompetenzrahmen angezeigt';
$string['eventcompetencyupdated'] = 'Kompetenz aktualisiert';
$string['eventcompetencyviewed'] = 'Kompetenz angezeigt';
$string['eventevidencecreated'] = 'Beleg angelegt';
$string['eventplanapproved'] = 'Lernplan überprüft';
$string['eventplancompleted'] = 'Lernplan abgeschlossen';
$string['eventplancreated'] = 'Lernplan angelegt';
$string['eventplandeleted'] = 'Lernplan gelöscht';
$string['eventplanreopened'] = 'Lernplan erneut geöffnet';
$string['eventplanreviewrequestcancelled'] = 'Anfrage zur Lernplanprüfung abgebrochen';
$string['eventplanreviewrequested'] = 'Lernplanprüfung angefragt';
$string['eventplanreviewstarted'] = 'Lernplanprüfung begonnen';
$string['eventplanreviewstopped'] = 'Lernplanprüfung angehalten';
$string['eventplanunapproved'] = 'Lernplan nicht genehmigt';
$string['eventplanunlinked'] = 'Lernplan nicht verlinkt';
$string['eventplanupdated'] = 'Lernplan aktualisiert';
$string['eventplanviewed'] = 'Lernplan angezeigt';
$string['eventtemplatecreated'] = 'Vorlage für Lernplan angelegt';
$string['eventtemplatedeleted'] = 'Vorlage für Lernplan gelöscht';
$string['eventtemplateupdated'] = 'Vorlage für Lernplan aktualisiert';
$string['eventtemplateviewed'] = 'Vorlage für Lernplan angezeigt';
$string['eventusercompetencyplanviewed'] = 'Nutzerkompetenzplan angezeigt';
$string['eventusercompetencyrated'] = 'Nutzerkompetenz bewertet';
$string['eventusercompetencyratedincourse'] = 'Nutzerkompetenz im Kurs bewertet';
$string['eventusercompetencyratedinplan'] = 'Nutzerkompetenz im Lernplan bewertet';
$string['eventusercompetencyreviewrequestcancelled'] = 'Anfrage zur Nutzerkompetenzprüfung abgebrochen';
$string['eventusercompetencyreviewrequested'] = 'Nutzerkompetenzprüfung angefragt';
$string['eventusercompetencyreviewstarted'] = 'Nutzerkompetenzprüfung begonnen';
$string['eventusercompetencyreviewstopped'] = 'Nutzerkompetenzprüfung angehalten';
$string['eventusercompetencyviewed'] = 'Nutzerkompetenz angezeigt';
$string['eventusercompetencyviewedincourse'] = 'Nutzerkompetenz im Kurs angezeigt';
$string['eventusercompetencyviewedinplan'] = 'Nutzerkompetenz im Lernplan angezeigt';
$string['eventuserevidencecreated'] = 'Beleg über Vorkenntnisse angelegt';
$string['eventuserevidencedeleted'] = 'Beleg über Vorkenntnisse gelöscht';
$string['eventuserevidenceupdated'] = 'Beleg über Vorkenntnisse aktualisiert';
$string['evidence_competencyrule'] = 'Die Kompetenzregel wurde erfüllt.';
$string['evidence_coursecompleted'] = 'Der Kurs \'{$a}\' wurde abgeschlossen.';
$string['evidence_coursemodulecompleted'] = 'Die Aktivität \'{$a}\' wurde abgeschlossen.';
$string['evidence_courserestored'] = 'Die Bewertung wurde zusammen mit dem Kurs \'{$a}\' wiederhergestellt.';
$string['evidence_evidenceofpriorlearninglinked'] = 'Der Beleg über Vorkenntnisse \'{$a}\' wurde verlinkt.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'Der Beleg über Vorkenntnisse \'{$a}\' wurde freigegeben.';
$string['evidence_manualoverride'] = 'Die Kompetenzbewertung wurde manuell vergeben.';
$string['evidence_manualoverrideincourse'] = 'Die Kompetenzbewertung wurde manuell im Kurs \'{$a}\' vorgenommen.';
$string['evidence_manualoverrideinplan'] = 'Die Kompetenzbewertung wurde manuell im Lernplan \'{$a}\' vorgenommen.';
$string['invalidevidencedesc'] = 'Ungültige Belegbeschreibung';
$string['invalidgrade'] = 'Ungültige Bewertung';
$string['invalidpersistenterror'] = 'Fehler: {$a}';
$string['invalidplan'] = 'Ungültiger Lernplan';
$string['invalidtaxonomy'] = 'Ungültige Taxonomie: {$a}';
$string['invalidurl'] = 'Die URL ist ungültig. Überprüfen Sie, ob die URL mit http:// bzw. https:// anfängt.';
$string['nouserplanswithcompetency'] = 'Diese Kompetenz ist in keinem Lernplan enthalten.';
$string['planstatusactive'] = 'Aktiv';
$string['planstatuscomplete'] = 'Vollständig';
$string['planstatusdraft'] = 'Entwurf';
$string['planstatusinreview'] = 'Überprüfung läuft';
$string['planstatuswaitingforreview'] = 'Überprüfung abwarten';
$string['pointsrequiredaremet'] = 'Erforderliche Punktzahl erreicht';
$string['privacy:evidence:action:complete'] = 'Kompetenz abschließen falls unbewertet';
$string['privacy:evidence:action:log'] = 'Log-Aktion';
$string['privacy:evidence:action:override'] = 'Kompetenzbewertung überschreiben';
$string['privacy:metadata:competency'] = 'Aufzeichnung der Kompetenzen';
$string['privacy:metadata:competency_coursecomp'] = 'Aufzeichnung der Kompetenzen eines Kurses';
$string['privacy:metadata:competency_coursecompsetting'] = 'Aufzeichnung der Kompetenzeinstellungen eines Kurses';
$string['privacy:metadata:competency_evidence'] = 'Aufzeichnung des Nachweises für einen Kompetenzstatus';
$string['privacy:metadata:competency_framework'] = 'Aufzeichnung der Kompetenzrahmen';
$string['privacy:metadata:competency_modulecomp'] = 'Aufzeichnung der Kompetzenzen, die mit einem Modul verbunden sind';
$string['privacy:metadata:competency_plan'] = 'Aufzeichnung der Lernpläne';
$string['privacy:metadata:competency_plancomp'] = 'Aufzeichnung der Kompetenzen in einem Lernplan';
$string['privacy:metadata:competency_relatedcomp'] = 'Aufzeichnung der Verbindung zwischen Kompetenzen';
$string['privacy:metadata:competency_template'] = 'Aufzeichnung von Lernplanvorlagen';
$string['privacy:metadata:competency_templatecohort'] = 'Aufzeichnung von Lernplanvorlagen einer globalen Gruppe';
$string['privacy:metadata:competency_templatecomp'] = 'Aufzeichnung von Kompetenzen einer Lernplanvorlage';
$string['privacy:metadata:competency_usercomp'] = 'Aufzeichnung des Nutzerstatus für eine Kompetenz';
$string['privacy:metadata:competency_usercompcourse'] = 'Aufzeichnung des Nutzerstatus für eine Kompetenz in einem Kurs';
$string['privacy:metadata:competency_usercompplan'] = 'Aufzeichnung des Status für Kompetenzen in einem Lernplan';
$string['privacy:metadata:competency_userevidence'] = 'Aufzeichnung des Nachweis aus anderen Lernprozessen';
$string['privacy:metadata:competency_userevidencecomp'] = 'Aufzeichnung der Kompetenzen, die mit früheren Lernprozessen verbunden sind';
$string['privacy:metadata:core_comments'] = 'Kommentare zu Lernplänen und Kompetenzen';
$string['privacy:metadata:evidence:action'] = 'Aktionstypen für Nachweis';
$string['privacy:metadata:evidence:actionuserid'] = 'Nutzerleistung für Aktion';
$string['privacy:metadata:evidence:desca'] = 'Beschreibung der optionalen Parameter der Zuordnung von Nachweisen';
$string['privacy:metadata:evidence:desccomponent'] = 'Beschreibung der Komponente der Zuordnung von Nachweisen';
$string['privacy:metadata:evidence:descidentifier'] = 'Identifier der Beschreibung der Zuordnung von Nachweisen';
$string['privacy:metadata:evidence:grade'] = 'Bewertung, die mit dem Nachweis verbunden ist';
$string['privacy:metadata:evidence:note'] = 'Nicht verwendete Notiz für Nachweis';
$string['privacy:metadata:evidence:url'] = 'Mit Nachweis verbundene URL';
$string['privacy:metadata:plan:description'] = 'Beschreibung des Lernplans';
$string['privacy:metadata:plan:duedate'] = 'Fälligkeitsdatum für Lernplan';
$string['privacy:metadata:plan:name'] = 'Name des Lernplans';
$string['privacy:metadata:plan:reviewerid'] = 'ID des Prüfers für den Lernplan';
$string['privacy:metadata:plan:status'] = 'Status des Lernplans';
$string['privacy:metadata:plan:userid'] = 'ID der Person, die dem Lernplan zugeordnet ist';
$string['privacy:metadata:timecreated'] = 'Erstelldatum des Datensatzes';
$string['privacy:metadata:timemodified'] = 'Bearbeitungsdatum des Datensatzes';
$string['privacy:metadata:usercomp:grade'] = 'Bewertung für Kompetenz';
$string['privacy:metadata:usercomp:proficiency'] = 'Ob Fähigkeit erreicht wurde';
$string['privacy:metadata:usercomp:reviewerid'] = 'ID des Prüfers';
$string['privacy:metadata:usercomp:status'] = 'Status der Kompetenz';
$string['privacy:metadata:usercomp:userid'] = 'ID der Person, die die Kompetenz hält';
$string['privacy:metadata:userevidence:description'] = 'Beschreibung des Nachweises';
$string['privacy:metadata:userevidence:name'] = 'Name des Nachweises für frühere Lernprozesse';
$string['privacy:metadata:userevidence:url'] = 'URL, mit Nachweis verbunden';
$string['privacy:metadata:usermodified'] = 'Person, die den Datensatz erstellt oder bearbeitet hat';
$string['privacy:path:plans'] = 'Lernpläne';
$string['privacy:path:relatedtome'] = 'Mir zugeordnet';
$string['privacy:path:userevidence'] = 'Nachweis frührerer Lernprozesse';
$string['pushcourseratingstouserplans'] = 'Kursbewertungen in die individuellen Lernpläne übertragen';
$string['pushcourseratingstouserplans_desc'] = 'Standardwert zur Aktualisierung von individuellen Lernplänen, wenn die Kurskompetenzen bewertet sind.';
$string['syncplanscohorts'] = 'Lernpläne aus der Vorlage für globale Gruppen synchronisieren';
$string['taxonomy_behaviour'] = 'Verhalten';
$string['taxonomy_competency'] = 'Kompetenz';
$string['taxonomy_concept'] = 'Konzept';
$string['taxonomy_domain'] = 'Domain';
$string['taxonomy_indicator'] = 'Indikator';
$string['taxonomy_level'] = 'Level';
$string['taxonomy_outcome'] = 'Ergebnis';
$string['taxonomy_practice'] = 'Praxis';
$string['taxonomy_proficiency'] = 'Fähigkeitsgrad';
$string['taxonomy_skill'] = 'Fähigkeit';
$string['taxonomy_value'] = 'Wert';
$string['usercommentedonacompetency'] = '{$a->fullname} hat die Kompetenz \'{$a->competency}\' kommentiert:

{$a->comment}

Siehe: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} hat die Kompetenz \'{$a->competency}\' kommentiert:</p>
<div>{$a->comment}</div>
<p>Siehe: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} hat die Kompetenz \'{$a->competency}\' kommentiert.';
$string['usercommentedonacompetencysubject'] = '{$a} hat eine Kompetenz kommentiert.';
$string['usercommentedonaplan'] = '{$a->fullname} hat den Lernplan \'{$a->plan}\' kommentiert:

{$a->comment}

Siehe: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} hat den Lernplan \'{$a->plan}\' kommentiert: </p>
<div>{$a->comment}</div>
<p>Siehe: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} hat den Lernplan \'{$a->plan}\' kommentiert.';
$string['usercommentedonaplansubject'] = '{$a} hat einem Lernplan kommentiert.';
$string['usercompetencystatus_idle'] = 'Abwarten';
$string['usercompetencystatus_inreview'] = 'Überprüfung läuft';
$string['usercompetencystatus_waitingforreview'] = 'Überprüfung abwarten';
$string['userplans'] = 'Nutzerlernpläne';
