<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_fordson', language 'sk', version '4.1'.
 *
 * @package     theme_fordson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconsize'] = 'Veľkosť ikony aktivity';
$string['activityiconsize_desc'] = 'Nastavenie veľkosti ikony aktivity použitej v kurze.';
$string['activitylinkstitle'] = 'Aktivity';
$string['activitylinkstitle_desc'] = 'Zobrazenie všetkých aktivít v kurze';
$string['activitymenu'] = 'Zobraziť zoskupené menu aktivít';
$string['activitymenu_desc'] = 'Zobraziť zoskupené zoznamy aktivít na paneloch študentov a učiteľov. Toto menu zobrazuje zoskupený zoznam všetkých aktivít pre študenta a učiteľa.';
$string['advancedsettings'] = 'Pokročilé nastavenia';
$string['alert'] = 'Výstraha domovskej stránky';
$string['alert_desc'] = 'Toto je špeciálne upozornenie zobrazujúce sa na hlavnej stránke.';
$string['backgroundimage'] = 'Predvolený obrázok pozadia stránky';
$string['backgroundimage_desc'] = 'Obrázok pozadia pre stránky';
$string['backtotop'] = 'Prerolovanie na začiatok stránky';
$string['badges'] = 'Odznaky';
$string['badges_desc'] = 'Ocenenie vašich študentov';
$string['blockdisplay'] = 'Blok Zobrazenie možností umiestnenia';
$string['blockdisplay_desc'] = 'Vyberte spôsob zobrazenia blokov na domovskej stránke a na stránkach kurzov. Fordson pridáva skladací blok s 3 stĺpcami, ktorý môže užívateľ skryť. Ak chcete použiť jeden stĺpec napravo pre bloky, vyberte voľbu Boost default.
Predvolená možnosť tiež presunie tlačidlo Pridať blok do navigácie v ľavej časti stránky.
Odporúčame použiť voľbu "Single Column Boost Default" ak používate akékoľvek Boost rozloženie stránky z nastavení vyššie.';
$string['blockdisplay_off'] = 'Predvolený Jeden stĺpec (Single Column Boost Default)';
$string['blockdisplay_on'] = 'Predvolené tri stĺpce (Three Column Fordson Default)';
$string['blockwidthfordson'] = 'Šírka stĺpca v  bloku';
$string['blockwidthfordson_desc'] = 'Prispôsobiť šírku stĺpca bloku';
$string['blog'] = 'Blog URL';
$string['blogdesc'] = 'Zadajte URL adresu blogu vašej spoločnosti (napr. http://blog.dearbornschools.org)';
$string['bodybackground'] = 'Farba pozadia stránky';
$string['bodybackground_desc'] = 'Hlavná farba použitá pre pozadie stránky';
$string['brandColour'] = 'Firemná farba';
$string['brandColour_desc'] = 'Hlavná farba vašej značky (firemná farba)';
$string['branddanger'] = 'Firemná farba - výstraha';
$string['branddanger_desc'] = 'Firemná farba, ktorá sa zobrazí pri bezpečnostných výstrahách a pod.';
$string['brandemail'] = 'Email organizácie';
$string['brandemaildesc'] = 'Emailová adresa organizácie zobrazená v päte stránky.';
$string['brandinfo'] = 'Firemná farba - informácia';
$string['brandinfo_desc'] = 'Firemná farba, ktorá sa zobrazí pri informačných upozorneniach a pod.';
$string['brandorganization'] = 'Názov organizácie';
$string['brandorganizationdesc'] = 'Názov organizácie zobrazený v päte stránky.';
$string['brandphone'] = 'Telefón organizácie';
$string['brandphonedesc'] = 'Telefónne číslo zobrazené v päte stránky.';
$string['brandprimary'] = 'Firemná farba (Brand Primary)';
$string['brandprimary_desc'] = 'Vaša hlavná firemná farba';
$string['brandsuccess'] = 'Firemná farba - úspech';
$string['brandsuccess_desc'] = 'Firemná farba, ktorá sa zobrazí pri úspešných hláseniach, tlačidlách a pod.';
$string['brandwarning'] = 'Firemná farba - varovanie';
$string['brandwarning_desc'] = 'Firemná farba, ktorá sa zobrazí pri varovaniach';
$string['brandwebsite'] = 'Webová stránka spoločnosti';
$string['brandwebsitedesc'] = 'Adresa webovej stránky zobrazená v päte stránky.';
$string['breadcrumbbkg'] = 'Farba pozadia riadkovej navigácie (Breadcrumb)';
$string['breadcrumbbkg_desc'] = 'Farba pozadia riadkovej navigácie (Breadcrumb)';
$string['cardbkg'] = 'Farba pozadia obsahu riadkovej navigácie (Breadcrumb)';
$string['cardbkg_desc'] = 'Farba pozadia obsahu pre obsah kurzu a blokov.';
$string['catsicon'] = 'Ikona kategórie';
$string['catsicon_desc'] = 'Vyberte ikonu pre kategórie kurzu';
$string['choosereadme'] = 'Fordson poskytuje predvolený motív Boost jedinečný vizuálny zážitok s funkciami prispôsobenia, ako sú výber farieb a vylepšený zážitok z domovskej stránky.';
$string['colours_desc'] = 'Výber farieb vám umožní prispôsobiť vzhľad a dojem z hlavných prvkov na stránke. Ak používate predvoľbu, ktorá nie je predvolená, budete musieť odstrániť všetky vlastné farby nižšie, aby ste dosiahli najlepšie výsledky, pretože tieto prepíšu predvoľbu s nežiaducimi výsledkami. Nastavenie bude mať zvyčajne predvolené farby, ktoré chcete vidieť predtým, ako ich prispôsobíte tu.';
$string['colours_headingsub'] = 'Nastavenie farby';
$string['colours_settings'] = 'Farby';
$string['configtitle'] = 'Fordson';
$string['contentsettings'] = 'Oblasti obsahu';
$string['courseactivities'] = 'Aktivity kurzu';
$string['courseblockpanelbtn'] = 'Bloky kurzu';
$string['courseblockpanelbtnclose'] = 'Zavrieť';
$string['courseboxheight'] = 'Výška dlaždíc kurzu';
$string['courseboxheight_desc'] = 'Ovládanie výšky dlaždíc kurzu na hlavnej stránke a kategóriách kurzu.';
$string['courseeditingcog'] = 'Zobraziť predvolené nastavenie menu kurzu';
$string['courseeditingcog_desc'] = 'Ak používate Ovládací panel kurzu (Course Managment Panel), predvolená ponuka je skrytá. Zaškrtnutím tohto políčka môžete zobraziť predvolené menu a Ovládací panel učiteľa. To je ideálne, ak používate doplnok tretej strany, ktorý používa menu kurzu na prístup k nastaveniam.';
$string['coursehome'] = 'Domov';
$string['courseinfo'] = 'Opis kurzu';
$string['coursemanage'] = 'Nastavenie kurzu';
$string['coursemanage_desc'] = 'Spravujte celý kurz';
$string['coursemanagementbutton'] = 'Nastavenie kurzu';
$string['coursemanagementinfo'] = 'Menu ovládacieho panela kurzu';
$string['coursemanagementinfodesc'] = 'Fordson poskytuje jedinečný a organizovaný panel pre správu kurzov, ku ktorému môžu učitelia pristupovať odkiaľkoľvek v rámci kurzu, aby získali prístup k odkazom na správu kurzov. Študenti majú prístup aj k informačnému panelu študentských kurzov, ktorý obsahuje informácie týkajúce sa predmetu. Dôrazne sa odporúča ponechať toto zapnuté.';
$string['coursemanagementtextbox'] = 'Informácia o nastavení kurzu';
$string['coursemanagementtextbox_desc'] = 'Pridajte správu pre učiteľov do ovládacieho panelu kurzu na každej stránke kurzu.';
$string['coursemanagementtoggle'] = 'Zobraziť ovládacie panely kurzu pre študentov a učiteľov';
$string['coursemanagementtoggle_desc'] = 'Zobrazí odkazy na správu kurzu pre učiteľov, ktoré poskytujú prehľad všetkých prepojení, ktoré potrebujú na správu svojho kurzu a používateľov. Bude tiež zobrazovať panel prehľadu kurzu pre študentov so známkami, ukončením kurzu a ďalšími položkami z kurzu.';
$string['coursestaff'] = 'Učitelia kurzov';
$string['coursestyle1'] = 'Štýl dlaždice - 1 (šípka)';
$string['coursestyle10'] = 'Predvolené Moodle zobrazenie kurzu';
$string['coursestyle2'] = 'Štýl dlaždice - 2 (rolovanie na hor)';
$string['coursestyle3'] = 'Štýl dlaždice - 3 (obrázok v pozadí)';
$string['coursestyle4'] = 'Štýl dlaždice - 4 (so sumárom kurzu)';
$string['coursestyle5'] = 'Horizontálny štýl - 1 (obrázok vľavo a sumár kurzu vpravo)';
$string['coursestyle6'] = 'Horizontálny štýl - 2 (obrázok na pozadí a sumár kurzu pod)';
$string['coursestyle7'] = 'Horizontálny štýl - 3 (Len nadpis a obrázok na pozadí)';
$string['coursestyle8'] = 'Horizontálny štýl - dva stĺpce (obrázok pozadí a sumár kurzu)';
$string['coursestyle9'] = 'Horizontálny štýl - firemné školenia (len text s kompletným sumárom)';
$string['coursetileinfo'] = 'Možnosti zobrazenia kurzu';
$string['coursetileinfodesc'] = 'Tieto nastavenia vám umožňujú prispôsobiť, ako sa budú kurzy zobrazovať na titulnej stránke, ako aj kategórie kurzov.';
$string['coursetilestyle'] = 'Zobrazenie kurzu';
$string['coursetilestyle_desc'] = 'Pri prezeraní kategórií kurzov si môžete vybrať z nasledujúcich štýlov na zobrazenie kurzov. <a href="https://goo.gl/fMXzSo" target="_new">Viac informácií o téme Fordson 3.5 </a>';
$string['createinfo'] = 'Tlačidlo na vytvorenie špeciálneho kurzu';
$string['createinfodesc'] = 'Toto tlačidlo sa zobrazí na domovskej stránke, keď používateľ môže vytvárať nové kurzy. Toto tlačidlo sa zobrazí ľuďom s úlohou Tvorcu kurzu na úrovni lokality.';
$string['currentinparentheses'] = '(súčasný)';
$string['customloginheading'] = 'Vlastná prihlasovacia stránka';
$string['customlogininfo'] = 'Nastavenie vlastnej prihlasovacej stránky';
$string['customlogininfo_desc'] = 'Umožňuje vytvoriť vlastnú prihlasovaciu stránku.  Medzi ďalšie nastavenia, ktoré sa zobrazia na prihlasovacej stránke, patria:<br>
<b>* Site Administration > Security > Site Policies > Force Users To Login = Make sure this is checked so that users will be taken to your custom login page.<br>
* Site Administration > Appearance > Logos > Logo = Upload an image here and it will appear above the login form.<br>
* Fordson > Custom Image Settings > Default Login Image can be used to change the background image for the login page. <br>
* Fordson > Content Areas > Homepage Alert can be used to provide a notice on the top of the page. </b>';
$string['dashactivityoverview'] = 'PREHĽAD ČINNOSTÍ';
$string['displaybottom'] = 'Zobrazenie v dolnej časti stránky';
$string['displaymycourses'] = 'Zobrazenie zapísaných kurzov';
$string['displaymycoursesdesc'] = 'Zobrazenie zapísaných kurzov pre užívateľov na hornej navigačnej lište.';
$string['displaythiscourse'] = 'Zobraziť Menu tohto kurzu';
$string['displaythiscoursedesc'] = 'Na hornom navigačnom paneli sa používateľom zobrazia odkazy na sekciu  v ponuke kurzov. Obsahuje položky ponuky, ktoré sa predtým nachádzali v ponuke navigácie.';
$string['displaytop'] = 'Zobraziť v hornej časti stránky';
$string['drawerbkg'] = 'Farba pozadia bočnej ponuky';
$string['drawerbkg_desc'] = 'Farba pozadia bočnej ponuky pre menu na ľavej strane.';
$string['editoff'] = 'Vypnúť úpravy';
$string['editon'] = 'Zapnúť úpravy';
$string['enablecategoryicon'] = 'Zobraziť ikony kategórií';
$string['enablecategoryicon_desc'] = 'Po zaškrtnutí sa kategórie kurzov zobrazia ako ikony';
$string['enhancedmydashboard'] = 'Rozšírená nástenka';
$string['enhancedmydashboard_desc'] = 'Zapnutím tejto možnosti sa Nástenka rozšíri tak, aby zahŕňala všetky funkcie Fordson, ako je napríklad formulár jednoduchého zápisu, posuvníky blokov, lišta navigácie ikon, vlastný text domovskej stránky, SlideShow a ďalšie.';
$string['enrollcoursecard'] = 'Prístup';
$string['facebook'] = 'Facebook URL';
$string['facebookdesc'] = 'Zadajte URL adresu Facebookovej stránky (napr. http://www.facebook.com/vasprofil)';
$string['favicon'] = 'Ikona stránky (favicon)';
$string['favicon_desc'] = 'Zmente ikonu stránky (favicon) pre tému Fordson. Použite obrázok s priehľadným pozadím a výškou 32px. Podporované formáty: PNG, JPG, ICO';
$string['feature1info'] = 'Vlastnosť 1';
$string['feature2info'] = 'Vlastnosť 2';
$string['feature3info'] = 'Vlastnosť 3';
$string['featureimage'] = 'Obrázok';
$string['featureimage_desc'] = 'Tento obrázok sa zobrazí vedľa textu v riadku.';
$string['featureinfo_desc'] = 'Prvok pozostáva z obrázka a textu, ktorý sa zobrazí na vlastnej prihlasovacej stránke v riadku. Aby sa prvok zobrazil, musíte pridať obrázok aj text.';
$string['featuretext'] = 'Text prvku';
$string['featuretext_desc'] = 'Tento text sa zobrazí vedľa odporúčaného obrázka v riadku. Použite nadpis 4 na vygenerovanie špeciálneho názvu v textovom poli. V editori Atto H4 je nadpis médium Medium';
$string['flickr'] = 'Flickr URl';
$string['flickrdesc'] = 'Zadajte URL adresu stránky Flickr. (napr. http://www.flickr.com/)';
$string['footerbkg'] = 'Farba pozadia päty stránky';
$string['footerbkg_desc'] = 'Farba pozadia päty stránky v dolnej časti.';
$string['footerdesc'] = 'Nasledujúce položky vám umožňujú pridať informácie o organizácii do päty témy.';
$string['footerheading'] = 'Päta';
$string['footerheadingsocial'] = 'Ikony sociálnych sietí';
$string['footerheadingsub'] = 'Prispôsobte si pätu domovskej stránky';
$string['footnote'] = 'Päta stránky - text';
$string['footnotedesc'] = 'Editor pre záznam v päte stránky';
$string['fploginform'] = 'Farba prihlasovacieho formulára';
$string['fploginform_desc'] = 'Farba pozadia prihlasovacieho formulára na vlastnej domovskej stránke.';
$string['fpsignup'] = 'Prihlásiť sa';
$string['fptextbox'] = 'Uvítacia správa po overení užívateľa';
$string['fptextbox_desc'] = 'Po overení používateľa sa toto textové pole zobrazí na domovskej stránke. Je ideálny na zverejnenie uvítacej správy a poskytnutie pokynov pre žiaka.';
$string['fptextboxlogout'] = 'Uvítacia správa pre návštevníka';
$string['fptextboxlogout_desc'] = 'Toto textové pole sa zobrazí na domovskej stránke pre návštevníkov a je ideálne na zadanie uvítacej správy alebo odkazu na prihlasovaciu stránku.';
$string['frontpagemycoursessorting'] = 'Moje kurzy zoradené podľa posledného prístupu';
$string['frontpagemycoursessorting_desc'] = 'Po zaškrtnutí sa zobrazia Moje kurzy (zapísané kurzy) podľa posledného prístupu používateľa. Toto prepíše nastavenie „Zoradiť moje kurzy“ v časti Navigácia. Ak nie je pole zaškrtnuté, úvodná stránka sa zobrazí ako zvyčajne. Voľba zahŕňa Moje kurzy zobrazené v rozbaľovacej ponuke v hornej časti stránky, ako aj Moje zapísané kurzy zobrazené na domovskej stránke webu. Toto nemá vplyv na nástenku a jej bloky';
$string['generalcontentinfo'] = 'Všeobecné nastavenia zobrazenie obsahu';
$string['generalcontentinfodesc'] = 'Nasledujúce možnosti vám pomôžu prispôsobiť spôsob zobrazovania obsahu a zapnúť ďalšie funkcie pre Fordson.';
$string['generalsettings'] = 'Všeobecné nastavenia';
$string['googleplus'] = 'URL adresa Google+';
$string['googleplusdesc'] = 'Zadajte URL adresu profilu na Google+. (napr. https://google.com/)';
$string['gutterwidth'] = 'Odsadenie obsahu';
$string['gutterwidth_desc'] = 'Nastavenie vzdialenosti sprava a zľava v hlavnom obsahu';
$string['headerdefaultimage'] = 'Predvolený obrázok hlavičky';
$string['headerdefaultimage_desc'] = 'Predvolený obrázok hlavičky stránky kurzu a iných stránok';
$string['headerimagepadding'] = 'Výška obrázku hlavičky';
$string['headerimagepadding_desc'] = 'Nastavenie vzdialenosti a výšky obrázku hlavičky v kurzoch.';
$string['headerlogo'] = 'Logo v hlavičke';
$string['headerlogo_desc'] = 'Logo bude zobrazené v hornej časti stránky v oblasti pre hlavičku. Obrázok bude automaticky prispôsobený responzívnemu režimu zmeny veľkosti.';
$string['homemyclasses'] = '';
$string['iconnavheading'] = 'Ikona navigácie v hlavičke';
$string['iconnavheadingsub'] = 'Vytvorenie tlačidiel z ikon pre použitie na domovskej stránke. Ikony môžu vytvárať odkazy na ľubovolné stránky.';
$string['iconwidth'] = 'Šírka ikony na domovskej stránke';
$string['iconwidth_desc'] = 'Šírka 8 jednotlivých ikon na navigačnej lište ikon domovskej stránky.';
$string['iconwidthinfo'] = 'Nastavenie šírky tlačidla s ikonou';
$string['iconwidthinfodesc'] = 'Vyberte šírku, ktorá umožní, aby sa text odkazu zmestil do navigačných tlačidiel ikon.';
$string['ilearnsecurebrowser'] = 'Tento kvíz je zabezpečený prehliadačom iLearn (na vykonanie tohto testu musíte použiť Chromebook používajúci aplikáciu iLearn)';
$string['imagesettings'] = 'Vlastné nastavenie obrázku';
$string['instagram'] = 'Instagram URL';
$string['instagramdesc'] = 'Zadajte URL adresu vášho Instagramového profilu (napr. http://instagram.com/)';
$string['layoutinfo'] = 'Nastavenie rozloženia';
$string['layoutinfodesc'] = 'Nastavenie rozloženia stránky s výberom dizajnu.';
$string['learningcontentpadding'] = 'Rozostup výukového obsahu';
$string['learningcontentpadding_desc'] = 'Nastavenie miesta medzi hornou časťou stránky a obsahovou časťou kurzu. Vzdialenosť by mala byť menšia ako výška obrázku v hlavičke.';
$string['linkedin'] = 'LinkedIn URL';
$string['linkedindesc'] = 'Zadajte URL adresu vášho profilu LinkedIn (napr. http://www.linkedin.com)';
$string['loginimage'] = 'Predvolený obrázok pri prihlásení';
$string['loginimage_desc'] = 'Obrázok pozadia prihlasovacej stránky';
$string['loginnavicon1'] = 'Prihlasovacia ikona 1';
$string['loginnavicon2'] = 'Prihlasovacia ikona 2';
$string['loginnavicon3'] = 'Prihlasovacia ikona 3';
$string['loginnavicon4'] = 'Prihlasovacia ikona 4';
$string['loginnavicontext'] = 'Popis';
$string['loginnavicontextdesc'] = 'Text, ktorý sa zobrazí pod ikonou. Aby ste dosiahli najlepšie výsledky, použite čo najkratší text.';
$string['loginnavicontitletext'] = 'Nadpis';
$string['loginnavicontitletextdesc'] = 'Tento text sa zobrazí ako nadpis pod ikonou.';
$string['logintopimage'] = 'Banner (obrázok) na prihlasovacej stránke';
$string['logintopimage_desc'] = 'ento obrázok sa zobrazí na prihlasovacej stránke napravo od prihlasovacieho formulára. To je ideálne pre logo alebo banner s priehľadným pozadím.';
$string['marketboxbuttoncolor'] = 'Farba tlačidla marketingového poľa';
$string['marketboxbuttoncolor_desc'] = 'Farba pozadia tlačidla pre marketingové pole';
$string['marketboxcolor'] = 'Farba pozadia bloku marketingového poľa';
$string['marketboxcolor_desc'] = 'Farba pozadia marketingového poľa';
$string['marketboxcontentcolor'] = 'Farba pozadia obsahu marketingového poľa';
$string['marketboxcontentcolor_desc'] = 'Farba pozadia obsahu marketingového poľa. To je miesto, kde sa text objaví v marketingovom poli a môže sa líšiť od farby pozadia poľa, aby upozornil na text.';
$string['marketing1'] = 'Marketingový spot 1';
$string['marketing2'] = 'Marketingový spot 2';
$string['marketing3'] = 'Marketingový spot 3';
$string['marketing4'] = 'Marketingový spot 4';
$string['marketing5'] = 'Marketingový spot 5';
$string['marketing6'] = 'Marketingový spot  6';
$string['marketing7'] = 'Marketingový spot 7';
$string['marketing8'] = 'Marketingový spot 8';
$string['marketing9'] = 'Marketingový spot 9';
$string['marketingbuttontext'] = 'Text tlačidla';
$string['marketingbuttontextdesc'] = 'Text';
$string['marketingbuttonurl'] = 'Link URL';
$string['marketingbuttonurldesc'] = 'URL adresa smerujúca na tlačidlo.';
$string['marketingcontent'] = 'Obsah';
$string['marketingcontentdesc'] = 'Obsah, ktorý sa zobrazí v marketingovej oblasti. Uveďte krátky a výstižný text.';
$string['marketingdesc'] = 'Táto téma poskytuje možnosť povoliť tri marketingové alebo reklamné spoty priamo pod prezentáciou. Umožňujú ľahkú identifikáciu základných informácií pre vašich používateľov a poskytuje priame odkazy na stránky. Môže byť použité aj ako odkaz na rýchlu navigáciu na stránku s dôležitým obsahom.';
$string['marketingheading'] = 'Dlaždice marketingového obsahu';
$string['marketingheadingsub'] = 'Tri umiestnenia na hlavnej stránke na pridanie informácií a odkazov';
$string['marketingheight'] = 'Výška obrázku pre marketingový obsah';
$string['marketingheightdesc'] = 'Ak chcete zobraziť obrázky ako marketingový obsah, tu môžete nastaviť výšku obrázka.';
$string['marketingicon'] = 'Ikona';
$string['marketingicondesc'] = 'Zadajte meno ikony, ktorá sa použije ako tlačidlo. <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">Zoznam ikon nájdete tu</a>. Do poľa stačí zadať názov (napríklad "star").';
$string['marketingimage'] = 'Obrázok';
$string['marketingimage_desc'] = 'Umožňuje zobraziť obrázok ako marketingový obsah.';
$string['marketinginfodesc'] = 'Nastavenie pre marketingový obsah. Ak chcete, aby sa objavil marketingový obsah, musíte zadať názov.';
$string['marketingstyle'] = 'Výber štýlu dlaždíc pre marketingový obsah';
$string['marketingstyle1'] = 'Zvýraznená horná časť dlaždice';
$string['marketingstyle2'] = 'Štýl poznámkového lístku';
$string['marketingstyle3'] = 'Jednoduchý štýl';
$string['marketingstyle4'] = 'Štýl s tieňom';
$string['marketingstyle_desc'] = 'Vyberte si z nasledujúcich marketingových štýlov. Tým sa zmení vzhľad a štýl marketingových objektov na domovskej stránke lokality.';
$string['marketingtitle'] = 'Nadpis';
$string['marketingtitledesc'] = 'Nadpis zobrazujúci sa v marketingovom obsahu. Ak chcete, aby sa objavil marketingový obsah, musíte zadať názov.';
$string['marketingurltarget'] = 'Adresa odkazu';
$string['marketingurltargetdesc'] = 'Vyberte, ako sa má odkaz otvoriť';
$string['marketingurltargetnew'] = 'Nová stránka';
$string['marketingurltargetparent'] = 'V nadradenom ráme (to isté okno)';
$string['marketingurltargetself'] = 'Aktuálna stránka';
$string['markettextbg'] = 'Pozadie textu marketingových dlaždíc';
$string['markettextbg_desc'] = 'Farba pozadia v ktorom bude vypísaný text marketingového obsahu.';
$string['menusettings'] = 'Nastavenie menu';
$string['myclasses'] = 'Moje triedy';
$string['mycomp'] = 'Moje kompetencie';
$string['mycourses'] = 'Moje kurzy';
$string['mycoursesinfo'] = 'Zoznam dynamicky zapísaných kurzov a Menu navigácie kurzu';
$string['mycoursesinfodesc'] = 'Na hornom navigačnom paneli zobrazuje používateľovi dynamický zoznam zapísaných kurzov. Tým sa tiež riadi rozbaľovacia ponuka navigácie kurzu pre každý jednotlivý kurz';
$string['mycoursetitle'] = 'Výber položky';
$string['mycoursetitledesc'] = 'Z rozbalovacej ponuky vyberte funkciu, ktorá sa zobrazí v hornom navigačnom paneli.';
$string['mycred'] = 'Moje poverenia';
$string['mygradestext'] = 'Moje známky';
$string['mylectures'] = 'Moje prednášky';
$string['mylessons'] = 'Moje lekcie';
$string['mymodules'] = 'Moje moduly';
$string['myplans'] = 'Moje plány';
$string['myprofessionaldevelopment'] = 'Môj profesionálny rast';
$string['myprograms'] = 'Moje programy';
$string['myprogresspercentage'] = '% plnenia';
$string['myprogresstext'] = 'Môj pokrok';
$string['mytraining'] = 'Môj tréning';
$string['myunits'] = 'Moje položky';
$string['navbarcolorswitch'] = 'Prepnutie farby navigačnej lišty';
$string['navbarcolorswitch_desc'] = 'Táto funkcia mení farbu navigačného panela na základe role používateľa. Študent uvidí jednu farbu a učiteľ uvidí inú farbu. Je to užitočné, keď učiteľ zmení rolu. Pomôže mu to rozlíšiť medzi názorom študenta a názorom učiteľa.';
$string['navbarcolorswitch_off'] = 'Nemeniť farbu navigačnej lišty na základe role.';
$string['navbarcolorswitch_on'] = 'Zmeniť farbu navigačnej lišty na základe role.';
$string['navdrawerbtn'] = 'Navigácia';
$string['navicon'] = 'Ikona';
$string['navicon1'] = 'Ikona domovskej stránky 1';
$string['navicon2'] = 'Ikona domovskej stránky 2';
$string['navicon3'] = 'Ikona domovskej stránky 3';
$string['navicon4'] = 'Ikona domovskej stránky 4';
$string['navicon5'] = 'Ikona domovskej stránky 5';
$string['navicon6'] = 'Ikona domovskej stránky 6';
$string['navicon7'] = 'Ikona domovskej stránky 7';
$string['navicon8'] = 'Ikona domovskej stránky 8';
$string['naviconbutton1textdefault'] = 'Nástenka';
$string['naviconbutton2textdefault'] = 'Kalendár';
$string['naviconbutton3textdefault'] = 'Odzaky';
$string['naviconbutton4textdefault'] = 'Všetky kurzy';
$string['naviconbuttoncreatetextdefault'] = 'Vytvoriť kurz';
$string['naviconbuttontext'] = 'Text odkazu';
$string['naviconbuttontextdesc'] = 'Text ktorý sa zobrazí pod ikonou';
$string['naviconbuttonurl'] = 'URL adresa odkazu';
$string['naviconbuttonurldesc'] = 'URL adresa, na ktorú bude tlačidlo odkazovať. Môžete odkazovať na akékoľvek webové stránky vrátane externých webových stránok, stačí zadať správnu adresu URL. Ak je váš web Moodle v podadresári, predvolená adresa URL nebude fungovať. Upravte adresu URL tak, aby odrážala podadresár. Príklad: ak je „moodle“ vaším podadresárom, bude potrebné zmeniť adresu URL na / moodle / my /';
$string['navicondesc'] = 'Zadajte meno ikony, ktorá sa použije ako tlačidlo. <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">Zoznam ikon nájdete tu</a>. Do poľa stačí zadať názov (napríklad "star").';
$string['naviconslidedesc'] = 'Navrhovaný text ikony: arrow-circle-down  (šípka-kruh-nadol). Alebo vyberte zo  <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">zoznamu ikon </a>. Do poľa stačí zadať názov (napríklad "star").';
$string['noenrolments'] = 'Momentálne nie ste nikde zapísaný';
$string['nomycourses'] = 'Nie ste zapísaný do žiadneho kurzu';
$string['pagelayout'] = 'Výber rozloženia';
$string['pagelayout1'] = 'Predvolené Boost rozloženie';
$string['pagelayout2'] = 'Plná šírka / Obrázok v hlavičke';
$string['pagelayout3'] = 'Centrovaný obsah / Prekrývajúci sa obrázok hornej hlavičky';
$string['pagelayout4'] = 'Centrovaný obsah / Obrázok hlavičky na celú obrazovku';
$string['pagelayout5'] = 'Predvolené Boost rozloženie / Obrázok hlavičky v rámčeku názvu kurzu';
$string['pagelayout_desc'] = 'Vyberte si z nasledujúcich rozložení. Niektoré rozloženia stránky vyžadujú ďalšie úpravy v ponuke "Predvolené úpravy stránky". Dbajte na to, aby ste venovali pozornosť: medzerám medzi obsahovými blokmi kurzov, výške obrázka v záhlaví a vzájomným vzdialenostiam obsahových blokov, pretože tieto ovplyvňujú umiestnenie a vzdialenosti obrázka hlavičky vľavo a vpravo od hlavného obsahu výučby a prípadné ich nechcené prekrývanie sa, alebo nesprávne zobrazovanie na stránkach. <a href="https://goo.gl/fMXzSo" target="_new">Prečítajte si dokumentáciu (EN) Fordson 3.5 Theme</a>';
$string['pinterest'] = 'URL adresa Pinterest';
$string['pinterestdesc'] = 'Zadajte URL adresu pre stránku Pinterest  (napr. http://pinterest.com/)';
$string['pluginname'] = 'Fordson';
$string['preset'] = 'Prednastavenie témy';
$string['preset_desc'] = 'Vyberte predvoľbu, aby ste výrazne zmenili vzhľad témy. <a href="https://goo.gl/fMXzSo" target="_new">Prečítajte si dokumentáciu (EN) Fordson 3.5 Theme</a>';
$string['presetadjustmentsettings'] = 'Prednastavené úpravy';
$string['presetfiles'] = 'Ďalšie súbory predvolieb témy';
$string['presetfiles_desc'] = 'Predvolené súbory je možné použiť na dramatickú zmenu vzhľadu témy.
Informácie o vytváraní a zdieľaní vašich vlastných predvolených súborov nájdete na stránke https://docs.moodle.org/dev/Boost_Presets.';
$string['presets_settings'] = 'Predvoľby';
$string['privacy:metadata'] = 'Téma Fordson neukladá žiadne osobné údaje používateľa.';
$string['qbank'] = 'Banka otázok';
$string['qbank_desc'] = 'Vytvorenie a spravovanie otázok kvízu';
$string['rawscss'] = 'Raw SCSS';
$string['rawscss_desc'] = 'Toto pole sa používa na vloženie kódu SCSS, ktorý sa doplní na koniec šablóny so štýlmi.';
$string['rawscsspre'] = 'Raw initial SCSS';
$string['rawscsspre_desc'] = 'Do tohto poľa môžete vložiť kód SCSS, ktorý bude vložený pred všetkým ostatným.   Toto nastavenie sa použije na definovanie premenných vo väčšine prípadov.';
$string['region-fp-a'] = 'Stĺpec A';
$string['region-fp-b'] = 'Stĺpec B';
$string['region-fp-c'] = 'Stĺpec C';
$string['region-side-pre'] = 'Vpravo';
$string['section_mods'] = 'Moduly:';
$string['sectionlayout'] = 'Výber typu sekcie';
$string['sectionlayout1'] = 'Boost Default';
$string['sectionlayout2'] = 'Zvýraznený nadpis témy -  tučné písmo';
$string['sectionlayout3'] = 'Kartotéka';
$string['sectionlayout4'] = 'Moderný - centrovaný nadpis témy s grafickým zvýraznením';
$string['sectionlayout5'] = 'Jednoduchý nadpis témy - grafické zvýraznenie spodnej časti témy';
$string['sectionlayout6'] = 'Zvýraznený nadpis témy - grafické zvýraznenie hornej časti témy';
$string['sectionlayout7'] = 'Vysokoškolský študent - formálny dizajn';
$string['sectionlayout8'] = 'Firemný študent - prehľadný formát';
$string['sectionlayout_desc'] = 'Vyberte štýl ktorý bude použitý pre formát kurzu: Tématický formát/Týždenný formát. <a href="https://goo.gl/fMXzSo" target="_new">Prečítajte si dokumentáciu (EN) Fordson 3.5 Theme</a>';
$string['setting_navdrawersettings'] = 'Nastavenie horného navigačného panelu';
$string['setting_navdrawersettings_desc'] = 'Povolenie funkcie rozbaľovacieho menu Boost. Fordson nevyžaduje navigačný panel na navigáciu. Nahradili sme ho rozbaľovacou ponukou Jump-to-section. Nižšie môžete zapnúť panel pre navigáciu.';
$string['showactivitynav'] = 'Zobrazenie navigácie aktivít';
$string['showactivitynav_desc'] = 'Zrušením zaškrtnutia tohto políčka vypnete navigáciu aktivít v dolnej časti stránok s aktivitami.';
$string['showblockregions'] = 'Zobraziť ďalšie oblasti pre bloky na Hlavnej stránke';
$string['showblockregions_desc'] = 'Na titulnej stránke zapne ďalšie tri oblasti blokov. Zobrazia sa tesne pod navigačným panelom s ikonami.';
$string['showcourseadminstudents'] = 'Sprístupniť študentom nástroje Administrátora';
$string['showcourseadminstudents_desc'] = 'Týmto sa študentom zobrazia nastavenia kurzu. Je to potrebné, ak im chcete povoliť, aby sa odhlásili z kurzov.';
$string['showcourseheaderimage'] = 'Zobraziť obrázok pre kurz v hlavičke kurzu';
$string['showcourseheaderimage_desc'] = 'Umožnite učiteľom prispôsobiť obrázok záhlavia kurzu nahratím obrázku do nastavenia kurzu.';
$string['showcustomlogin'] = 'Povoliť vlastné prihlásenie';
$string['showcustomlogin_desc'] = 'Musíte povoliť, ak chcete aktivovať nastavenia nižšie.';
$string['showloginform'] = 'Zobraziť prihlasovací formulár';
$string['showloginform_desc'] = 'Zrušte zaškrtnutie  políčka, ak chcete skryť formulár prihlásenia na domovskej stránke pre neprihlásených používateľov.';
$string['shownavclosed'] = 'Menu stránky  je štandardne zbalené';
$string['shownavclosed_desc'] = 'Menu stránky  zostane zbalené pre všetkých používateľov na každej stránke (hlavná stránka, kurzy, fórum a pod.).';
$string['shownavdrawer'] = 'Zobraziť Menu stránky (navigácie vľavo)';
$string['shownavdrawer_desc'] = 'Téma Fordson eliminovala potrebu Menu pre navigáciu. Ovládanie je zabezpečené pomocou rozbaľovacej ponuky na navigáciu v kurze (umiestnenej na hornej lište). Ak musíte Menu pre navigáciu, zaškrtnutím tohto políčka ju znova povolíte.';
$string['showonlygroupteachers'] = 'Zobraziť iba učiteľov skupiny';
$string['showonlygroupteachers_desc'] = 'Aj je povolené, študenti uvidia iba učiteľov, ktorí sú v tej istej skupine. Študentom sa zobrazí ponuka v správe kurzu.';
$string['showslideshow'] = 'Aktivovať prezentáciu';
$string['showslideshow_desc'] = 'Zapnutím zapnete možnosť prezentácie (automatická zmena obrázkov zaradených do prezentácie).';
$string['showstudentcompletion'] = 'Zobraziť študentom informáciu o absolvovaní';
$string['showstudentcompletion_desc'] = 'Študentom sa zobrazia informácie o priebehu absolvovania kurzov na Nástenke. Aby sa tieto informácie zobrazili musí mať kurz povolené zobrazenie informácií o absolvovaní kurzu.';
$string['showstudentgrades'] = 'Zobraziť známky študentom';
$string['showstudentgrades_desc'] = 'Študentom sa zobrazia známky na nástenke. Aby sa tieto informácie zobrazili musí mať kurz povolené zobrazovanie známok.';
$string['siteadminquicklink'] = 'Administratíva portálu';
$string['skype'] = 'Skype';
$string['skypedesc'] = 'Zadajte užívateľské meno Skype';
$string['slide1info'] = 'Snímka 1';
$string['slide1infodesc'] = 'Informácie o snímke 1';
$string['slide2info'] = 'Snímka 2';
$string['slide2infodesc'] = 'Informácie o snímke 2';
$string['slide3info'] = 'Snímka 3';
$string['slide3infodesc'] = 'Informácie o snímke 1';
$string['slidecontent'] = 'Popis snímky';
$string['slidecontent_desc'] = 'Pridajte popis pre túto snímku.';
$string['slideimage'] = 'Obrázok';
$string['slideimage_desc'] = 'Pridajte obrázok pozadia pre túto snímku.';
$string['sliderinfo'] = 'Tlačidlo s výsuvným obsahom';
$string['sliderinfodesc'] = 'Toto tlačidlo zobrazí / skryje špeciálne textové pole, ktoré sa posúva nadol z navigačnej . Je ideálne pre zobrazenie jednoduchých informácií o kurze, upozornenia na podmienky štúdia (vyžadované, aktualizačné, dôležité a pod.), alebo pre zobrazenie pomocníka pre kurz (jednoduchý help systém).';
$string['slideshowheight'] = 'Výška priestoru pre prezentáciu (SlideShow)';
$string['slideshowheight_desc'] = 'Nastavte výšku';
$string['slideshowsettings'] = 'Prezentácia';
$string['slidetextbox'] = 'Text výsuvného obsahu';
$string['slidetextbox_desc'] = 'Tento text  sa zobrazí po stlačení tlačidla.';
$string['slidetitle'] = 'Nadpis snímky';
$string['slidetitle_desc'] = 'Zadajte nadpis pre túto snímku';
$string['sociallink'] = 'Vlastná adresa sociálnej siete';
$string['sociallinkdesc'] = 'Zadajte URL adresu na sociálnu sieť ktorú používate (napr. http://dearbornschools.org)';
$string['sociallinkicon'] = 'Ikona';
$string['sociallinkicondesc'] = 'Zadajte názov ikony z knižnice FontAwesome pre váš link.  <br />Zoznam ikon nájdete na:  https://fontawesome.com/v4.7.0/icons/';
$string['socialnetworks'] = 'Sociálne siete';
$string['studentdashboardtextbox'] = 'Správna na nástenke študenta';
$string['studentdashboardtextbox_desc'] = 'Pridajte správu pre študentov, ktorá sa zobrazí študentom  na každej stránke kurzu v ovládacom paneli.';
$string['studentdashbutton'] = 'Nástenka kurzu';
$string['textcontentinfo'] = 'Vlastný obsah';
$string['textcontentinfodesc'] = 'Použite textové polia nižšie na pridanie špecifických informácií pre používateľov.';
$string['thiscourse'] = 'Kurz';
$string['thismyclasses'] = 'Trieda';
$string['thismycomp'] = 'Kompetencia';
$string['thismycourses'] = 'Kurz';
$string['thismycred'] = 'Poverenia';
$string['thismylectures'] = 'Prednáška';
$string['thismylessons'] = 'LekciaTáto lekcia';
$string['thismymodules'] = 'Modul';
$string['thismyplans'] = 'Plán';
$string['thismyprofessionaldevelopment'] = 'Profesionálny rozvoj';
$string['thismyprograms'] = 'Program';
$string['thismytraining'] = 'Tréning';
$string['thismyunits'] = 'Jednotka';
$string['titletooltip'] = 'Popis názvu kurzu';
$string['titletooltip_desc'] = 'Ak používate skrátený názov kuru, môžete zadať podrobný názov. Zaškrtnite toto políčko aby sa zobrazil popis.';
$string['togglemarketing'] = 'Pozícia marketigového obsahu';
$string['togglemarketing_desc'] = 'Vyberte kde sa na domovskej stránke zobrazí marketingový obsah.';
$string['topnavbarbg'] = 'Nastavenie horného navigačného menu';
$string['topnavbarbg_desc'] = 'Farba pozadia pre horné navigačné menu';
$string['topnavbarteacherbg'] = 'Farba pozadia navigačného menu pre učiteľa';
$string['topnavbarteacherbg_desc'] = 'Zmena farby pozadia navigačného menu, keď sa užívateľ prepne do role učiteľa. Môže slúžiť na upozornenie užívateľa, že používa systém v roli učiteľa. Odporúčame použiť kontrastnú farbu oproti bežnej farbe navigačného menu.
Aby táto ponuka fungovala musí byť zapnutá v nastaveniach Menu. Skontrolujte nastavenia farby navigačného menu (navbarcolorswitch setting).';
$string['trimsummary'] = 'Skrátená sumarizácia kurzu';
$string['trimsummary_desc'] = 'Zadajte počet znakov, ktoré sa zobrazia ako skrátená sumarizácia kurzu.';
$string['trimtitle'] = 'Skrátený názov kurzu';
$string['trimtitle_desc'] = 'Zadajte počet znakov, ktoré sa zobrazia ako skrátený názov kurzu.';
$string['tumblr'] = 'URL adresa Tumblr';
$string['tumblrdesc'] = 'Zadajte URL adresu Tumblr. (napr. http://www.tumblr.com)';
$string['twitter'] = 'URL adresa Twitter';
$string['twitterdesc'] = 'Zadajte URL adresu vášho Tweetu (napr. http://twitter.com/)';
$string['userlinks'] = 'User Links';
$string['userlinks_desc'] = 'Správa študentov';
$string['viewsectionmodules'] = 'Zobraziť moduly sekcie';
$string['vimeo'] = 'Vimeo URL';
$string['vimeodesc'] = 'Zadajte URL adresu pre váš Vimeo kanál (napr. http://vimeo.com/)';
$string['vk'] = 'VKontakte URL';
$string['vkdesc'] = 'Zadajte URL adresu VKontakte (napr.  http://www.vk.com/)';
$string['website'] = 'Adresa webstránky';
$string['websitedesc'] = 'Zadajte URL adresu vašej webovej stránky';
$string['youtube'] = 'Adresa YouTube';
$string['youtubedesc'] = 'Zadajte URL adresu na váš YouTube kanál (http://youtube.com)';
