<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_stack', language 'sk', version '4.1'.
 *
 * @package     qtype_stack
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ATAlgEquiv_SA_not_equation'] = 'Vaša odpoveď by mala byť rovnica, ale nie je.';
$string['ATAlgEquiv_SA_not_expression'] = 'Odpoveďou by mal byť výraz, nie rovnica, nerovnosť, zoznam, množina alebo matica.';
$string['ATAlgEquiv_SA_not_function'] = 'Vaša odpoveď by mala byť funkcia definovaná pomocou operátora <tt>: = </tt>, ale nie je.';
$string['ATAlgEquiv_SA_not_inequality'] = 'Vaša odpoveď by mala byť nerovnosť, ale nie je.';
$string['ATAlgEquiv_SA_not_list'] = 'Vašou odpoveďou by mal byť zoznam, ale nie je. Upozorňujeme, že syntaxou na vstup do zoznamu je uzavretie hodnôt oddelených čiarkami do hranatých zátvoriek.';
$string['ATAlgEquiv_SA_not_logic'] = 'Vaša odpoveď by mala byť rovnica, nerovnosť alebo ich logická kombinácia, ale nie je.';
$string['ATAlgEquiv_SA_not_matrix'] = 'Vaša odpoveď by mala byť matica, ale nie je.';
$string['ATAlgEquiv_SA_not_realset'] = 'Vaša odpoveď by mala byť podmnožinou reálnych čísel. Môže to byť sada čísel alebo súbor intervalov.';
$string['ATAlgEquiv_SA_not_set'] = 'Vaša odpoveď by mala byť určitá, ale nie je. Všimnite si, že syntaxou na zadanie množiny je uzavretie hodnôt oddelených čiarkami zloženými zátvorkami.';
$string['ATAlgEquiv_SA_not_string'] = 'Vaša odpoveď by mal byť reťazec, ale nie je.';
$string['ATAlgEquiv_TA_not_equation'] = 'Zadali ste rovnicu, ale tu sa rovnica neočakáva. Možno ste napísali niečo ako „y = 2 * x + 1“, keď ste potrebovali napísať iba „2 * x + 1“.';
$string['ATCompSquare_SA_not_depend_var'] = 'Vaša odpoveď by mala závisieť od premennej {$a->m0}, ale nie je to tak!';
$string['ATCompSquare_false_no_summands'] = 'Vyplnený štvorec má tvar \\ (a (\\ cdots \\ cdots) ^ 2 + b \\), kde \\ (a \\) a \\ (b \\) nezávisiá od vašej premennej. Zdá sa, že viac ako jeden z vašich sčítancov závisí od premennej v odpovedi.';
$string['ATCompSquare_not_AlgEquiv'] = 'Zdá sa, že vaša odpoveď je v správnom tvare, ale nie je rovnocenná so správnou odpoveďou.';
$string['ATDiff_error_list'] = 'Test odpovede zlyhal. Obráťte sa na správcu systému';
$string['ATDiff_int'] = 'Vyzerá to, že ste sa namiesto toho integrovali!';
$string['ATEquivFirst_SA_not_list'] = 'Prvým argumentom v rámci testu odpovedí Equiv by mal byť zoznam, ale test zlyhal. Kontaktujte svojho učiteľa.';
$string['ATEquivFirst_SA_wrong_end'] = 'Vaša konečná odpoveď nie je v správnom tvare.';
$string['ATEquivFirst_SA_wrong_start'] = 'Prvý riadok vášho argumentu musí byť „{$a->m0}“.';
$string['ATEquivFirst_SB_not_list'] = 'Druhým argumentom v rámci testu odpovedí Equiv by mal byť zoznam, ale test zlyhal. Kontaktujte svojho učiteľa.';
$string['ATEquiv_SA_not_list'] = 'Prvým argumentom v rámci testu odpovedí Equiv by mal byť zoznam, ale test zlyhal. Kontaktujte svojho učiteľa.';
$string['ATEquiv_SB_not_list'] = 'Druhým argumentom v rámci testu odpovedí Equiv by mal byť zoznam, ale test zlyhal. Kontaktujte svojho učiteľa.';
$string['ATFacForm_error_list'] = 'Test odpovede zlyhal. Kontaktujte správcu systému';
$string['ATFacForm_isfactored'] = 'Vaša odpoveď je zohľadnená, výborne.';
$string['ATFacForm_notalgequiv'] = 'Upozorňujeme, že vaša odpoveď nie je algebraicky ekvivalentná správnej odpovedi. Určite ste urobili niečo zle.';
$string['ATFacForm_notfactored'] = 'Vaša odpoveď nie je zohľadnená.';
$string['ATFacForm_notpoly'] = 'Tento výraz (číslo, premenná, alebo ich kombinácia) by mal byť mnohočlen, ale nie je.';
$string['ATInequality_backwards'] = 'Zdá sa, že vaša nerovnosť je obrátená.';
$string['ATInequality_nonstrict'] = 'Vaša nerovnosť by mala byť ostrá, ale nie je!';
$string['ATInequality_strict'] = 'Vaša nerovnosť by nemala byť ostrá !';
$string['ATInt_EqFormalDiff'] = 'Formálna derivácia vašej odpovede sa vyrovná výrazu, ktorý vás požiadal o integráciu. Vaša odpoveď sa však od správnej odpovede významne líši, to znamená nielen napríklad integračná konštanta. Spýtajte sa na to svojho učiteľa.';
$string['ATInt_STACKERROR_OptList'] = 'Test odpovede sa nepodarilo vykonať správne: upozornite prosím svojho učiteľa. Ak je voľbou ATInt zoznam, musí obsahovať presne dva prvky, ale nie.';
$string['ATInt_const'] = 'Musíte pridať konštantu integrácie, inak sa to zdá byť správne. Výborne.';
$string['ATInt_const_int'] = 'Musíte pridať konštantu integrácie. To by mala byť ľubovoľná konštanta, nie číslo.';
$string['ATInt_diff'] = 'Zdá sa, že ste sa namiesto toho diferencovali!';
$string['ATInt_error_list'] = 'Test odpovede zlyhal. Kontaktujte svojho správcu systému';
$string['ATInt_generic'] = 'Derivácia vašej odpovede by sa mala rovnať výrazu, ktorý ste mali zintegrovať, a to: {$a->m0}.  V skutočnosti je derivácia vašej odpovede vo vzťahu k {$a->m1}:{$a->m2} takže asi ste urobili niečo zle!';
$string['ATInt_logabs'] = 'Váš učiteľ môže očakávať, že použijete výsledok \\(\\int\\frac{1}{x} dx = \\log(|x|)+c\\) namiesto (\\int\\frac{1}{x} dx = \\log(x)+c\\). Spýtajte sa na to svojho učiteľa.';
$string['ATInt_logabs_inconsistent'] = 'Zdá sa, že medzi používaním \\ (\\log (...) \\) a \\ (\\log (| ... |) \\) sú nezrovnalosti. Spýtajte sa na to svojho učiteľa.';
$string['ATInt_weirdconst'] = 'Formálna derivácia vašej odpovede sa vyrovná výrazu, ktorý ste mali zintegrovať. Máte však zvláštnu konštantu integrácie. Spýtajte sa na to svojho učiteľa.';
$string['ATLevenshtein_upper_not_boolean'] = 'Možnosť rozlišovania malých a veľkých písmen v Levenshteinovom teste odpovede musí byť boolovská, ale nie je. Test zlyhal. Kontaktujte svojho učiteľa.';
$string['ATList_wrongentries'] = 'Položky podčiarknuté červenou farbou nižšie sú nesprávne. {$a->m0}';
$string['ATList_wronglen'] = 'Váš zoznam by mal obsahovať prvky {$a->m0}, ale v skutočnosti má {$a->m1}.';
$string['ATLowestTerms_entries'] = 'Nasledujúce pojmy vo vašej odpovedi nie sú najkratšie výrazy. {$a->m0} Skúste to znova.';
$string['ATLowestTerms_not_rat'] = 'Od menovateľa vášho zlomku musíte vyčistiť nasledujúce: {$a->m0}';
$string['ATLowestTerms_wrong'] = 'V odpovedi musíte zrušiť zlomky.';
$string['ATMatrix_wrongentries'] = 'Položky podčiarknuté červenou farbou nižšie sú nesprávne. {$a->m0}';
$string['ATMatrix_wrongsz'] = 'Vaša matica by mala byť {$a->m0} x {$a->m1}, ale v skutočnosti je {$a->m2} x {$a->m3}.';
$string['ATNumDecPlacesWrong_OptNotInt'] = 'Pre ATNumDecPlacesWrong musí byť možnosť testu kladné celé číslo, v skutočnosti bolo prijaté „{$a->opt}“.';
$string['ATNumDecPlaces_Float'] = 'Vaša odpoveď musí byť číslo s pohyblivou desatinnou čiarkou, ale nie je.';
$string['ATNumDecPlaces_NoDP'] = 'Vaša odpoveď musí byť desatinné číslo vrátane desatinnej čiarky.';
$string['ATNumDecPlaces_OptNotInt'] = 'Pre ATNumDecPlaces musí byť možnosť testu kladné celé číslo, v skutočnosti bolo prijaté „{$a->opt}“.';
$string['ATNumDecPlaces_Wrong_DPs'] = 'Vaša odpoveď bola poskytnutá na nesprávny počet desatinných miest.';
$string['ATNumSigFigs_Inaccurate'] = 'Presnosť vašej odpovede nie je správna. Buď ste nezaokrúhľovali správne, alebo ste zaokrúhľovali strednú odpoveď, ktorá spôsobuje chybu.';
$string['ATNumSigFigs_NotDecimal'] = 'Vaša odpoveď by mala byť desatinné číslo, ale nie je!';
$string['ATNumSigFigs_WrongDigits'] = 'Vaša odpoveď obsahuje nesprávny počet platných číslic.';
$string['ATNumSigFigs_WrongSign'] = 'Vaša odpoveď obsahuje nesprávne algebraické znamienko.';
$string['ATNumSigFigs_error_list'] = 'Test odpovede zlyhal. Obráťte sa na správcu systému';
$string['ATNum_OutofRange'] = 'Numerický výraz je mimo podporovaného rozsahu. Prosím, kontaktujte svojho učiteľa.';
$string['ATNumerical_FAILED'] = 'Vašou odpoveďou by malo byť číslo s pohyblivou rádovou čiarkou alebo zoznam alebo množina čísel. To nie je.';
$string['ATNumerical_SA_not_list'] = 'Vašou odpoveďou by mal byť zoznam, ale nie je. Upozorňujeme, že syntaxou na vstup do zoznamu je uzavretie hodnôt oddelených čiarkami do hranatých zátvoriek.';
$string['ATNumerical_SA_not_number'] = 'Vaša odpoveď by mala byť číslo s pohyblivou rádovou čiarkou, ale nie je.';
$string['ATNumerical_SA_not_set'] = 'Vaša odpoveď by mala byť množina, ale nie je. Všimnite si, že syntaxou na zadanie množiny je uzavretie hodnôt oddelených čiarkami zloženými zátvorkami.';
$string['ATNumerical_SB_not_number'] = 'Hodnota dodaná pre odpoveď učiteľa by mala byť číslo s pohyblivou rádovou čiarkou, ale nie je. Ide o internú chybu testu. Opýtajte sa na to svojho učiteľa.';
$string['ATNumerical_STACKERROR_tol'] = 'Číselná tolerancia pre ATNumerical by mala byť číslo s pohyblivou rádovou čiarkou, ale nie je. Toto je interná chyba testu. Spýtajte sa na to svojho učiteľa.';
$string['ATPartFrac_denom_ret'] = 'Ak je vaša odpoveď napísaná ako jeden zlomok, menovateľ by bol {$a-> m0}. V skutočnosti by to malo byť {$a-> m1}.';
$string['ATPartFrac_diff_variables'] = 'Premenné vo vašej odpovedi sa líšia od premenných v otázke. Skontrolujte ich.';
$string['ATPartFrac_error_list'] = 'Test odpovede zlyhal. Prosím, kontaktujte svojho administrátora.';
$string['ATPartFrac_ret_expression'] = 'Vaša odpoveď ako jeden zlomok je {$a-> m0}';
$string['ATSRegExp_SA_not_string'] = 'Prvý argument pre test odpovede SRegExp musí byť reťazec. Test zlyhal. Prosím, kontaktujte svojho učiteľa.';
$string['ATSRegExp_SB_not_string'] = 'Druhým argumentom pre test odpovede SRegExp musí byť reťazec. Test zlyhal. Prosím, kontaktujte svojho učiteľa.';
$string['ATSet_wrongentries'] = 'Nasledujúce položky sú nesprávne, aj keď sa môžu javiť v zjednodušenej podobe odvodené  od tej, ktorú ste skutočne zadali. {$a->m0}';
$string['ATSet_wrongsz'] = 'Vaša množina by mala mať {$a->m0} rôznych prvkov, ale v skutočnosti ich má {$a->m1}.';
$string['ATSets_SA_not_set'] = 'Vaša odpoveď by mala byť určitá, ale nie je. Upozorňujeme, že syntaxou na zadanie množiny je uzavretie hodnôt, oddelených čiarkami, zloženými zátvorkami.';
$string['ATSets_SB_not_set'] = 'Test odpovedí „Sety“ očakáva, že jeho druhým argumentom bude množina. Toto je chyba. Kontaktujte svojho učiteľa.';
$string['ATSets_duplicates'] = 'Zdá sa, že vaša množina obsahuje duplicitné záznamy!';
$string['ATSets_missingentries'] = 'Vo vašej množine chýba nasledovné. {$a->m0}';
$string['ATSets_wrongentries'] = 'Tieto položky by nemali byť prvkami vašej množiny. {$a->m0}';
$string['ATSingleFrac_div'] = 'Vaša odpoveď obsahuje zložené zlomky. Musíte ich zjednodušiť a svoju odpoveď napísať ako jediný (jednoduchý) zlomok.';
$string['ATSingleFrac_error_list'] = 'Test odpovede zlyhal. Kontaktujte svojho správcu systému.';
$string['ATSingleFrac_part'] = 'Vaša odpoveď musí byť zlomok v tvare \\( {a}\\over{b} \\).';
$string['ATSingleFrac_ret_exp'] = 'Vaša odpoveď nie je algebraicky ekvivalentná správnej odpovedi. Museli ste urobiť niečo zle.';
$string['ATSingleFrac_var'] = 'Premenné vo vašej odpovedi sa líšia od premenných v tejto otázke. Skontrolujte ich.';
$string['ATSubstEquiv_Opt_List'] = 'Možnosť k tomuto testu odpovede musí byť zoznam. Nastala chyba. Prosím, kontaktujte svojho učiteľa.';
$string['ATSysEquiv_SA_extra_variables'] = 'Vaša odpoveď obsahuje príliš veľa premenných!';
$string['ATSysEquiv_SA_missing_variables'] = 'Vaša odpoveď nemá jednu alebo viac premenných!';
$string['ATSysEquiv_SA_not_eq_list'] = 'Vaša odpoveď by mala byť zoznam rovníc, ale nie je!';
$string['ATSysEquiv_SA_not_list'] = 'Vaša odpoveď by mala byť zoznam, ale nie je!';
$string['ATSysEquiv_SA_not_poly_eq_list'] = 'Jedna alebo viac vašich rovníc nie je polynóm!';
$string['ATSysEquiv_SA_system_overdetermined'] = 'Položky podčiarknuté červenou farbou nižšie sú nesprávne. {$a->m0}';
$string['ATSysEquiv_SA_system_underdetermined'] = 'Rovnice vo vašom systéme sa zdajú byť správne, ale potrebujete okrem nich aj ďalšie.';
$string['ATSysEquiv_SA_wrong_variables'] = 'Vaša odpoveď používa nesprávne premenné!';
$string['ATSysEquiv_SB_not_eq_list'] = 'Odpoveď učiteľa nie je zoznam rovníc, ale mal by byť.';
$string['ATSysEquiv_SB_not_list'] = 'Odpoveď učiteľa nie je zoznam. Kontaktujte svojho učiteľa.';
$string['ATSysEquiv_SB_not_poly_eq_list'] = 'Odpoveďou učiteľa by mal byť zoznam polynomiálnych rovníc, ale nie je. Kontaktujte svojho učiteľa.';
$string['ATUnits_SA_bad_units'] = 'Vaša odpoveď musí obsahovať jednotky a na pripojenie jednotiek k hodnote musíte použiť násobenie, napr. <code> 3.2*m/s </code>.';
$string['ATUnits_SA_errorbounds_invalid'] = 'Vaša odpoveď má chybové intervaly. V takom prípade neoznačujte chybové intervaly, použite len  množstvo a jednotky.';
$string['ATUnits_SA_excess_units'] = 'Vo vašej odpovedi sú použité jednotky (alebo premenné), ale nemali by byť.';
$string['ATUnits_SA_no_units'] = 'Vaša odpoveď musí obsahovať jednotky';
$string['ATUnits_SA_not_expression'] = 'Vaša odpoveď má byť číslo s jednotkou. Nepoužívajte množiny, zoznamy, rovnice alebo matice.';
$string['ATUnits_SA_only_units'] = 'Vaša odpoveď má byť číslo s jednotkou. Vaša odpoveď obsahuje len jednotky.';
$string['ATUnits_SO_wrong_units'] = 'Jednotky zadané pre číselnú toleranciu sa musia zhodovať s jednotkami použitými pri odpovedi učiteľa. Toto je interná chyba testu. Spýtajte sa na to svojho učiteľa.';
$string['ATUnits_compatible_units'] = 'Vaše jednotky sa líšia od tých, ktoré používa učiteľ, ale sú s nimi kompatibilné. Číselné hodnoty sa na konvertujú prevádzajú na základné jednotky SI.';
$string['ATUnits_correct_numerical'] = 'Prosím, pozorne si skontrolujte vaše jednotky.';
$string['ATUnits_incompatible_units'] = 'Vaše jednotky nie sú kompatibilné s jednotkami, ktoré používa učiteľ.';
$string['AT_EmptySA'] = 'Pokus o vykonanie testu odpovedí s prázdnou odpoveďou študenta, pravdepodobne problém s overením CAS pri vytváraní otázky.';
$string['AT_EmptyTA'] = 'Pokus o vykonanie testu odpovedí s prázdnou odpoveďou učiteľa, pravdepodobne problém s overením CAS pri vytváraní otázky.';
$string['AT_InvalidOptions'] = 'Pole možnosti je neplatné. {$a->errors}';
$string['AT_MissingOptions'] = 'Chýbajúca možnosť pri vykonávaní testu.';
$string['AT_raw_sans_needed'] = 'Niektoré testy odpovedí sa spoliehajú na nespracovaný vstup od študenta, a preto by pole „SAns“ uzla malo byť názvom vstupu otázky. Namiesto toho skontrolujte nasledujúce (prt.node), ktoré vyzerá ako vypočítaná hodnota: {$a->prt}';
$string['Bad_assignment'] = 'Vypísanie hodnôt premennej by ste mali urobiť nasledujúcim spôsobom: {$a->m0}. Prosím, upravte si svoj vstup.';
$string['CommaError'] = 'Vaša odpoveď obsahuje čiarky, ktoré nie sú súčasťou zoznamu, množiny alebo matice. <ul> <li> Ak ste chceli napísať text do zoznamu, prosím, použite <tt> {...} </tt>, </li> <li> Ak ste chceli napísať text do množiny, prosím, použite < tt> {...} </tt>. </li> </ul>';
$string['Equiv_Illegal_list'] = 'Zoznamy nie sú povolené, ak sa uvažuje na základe rovnosti.';
$string['Equiv_Illegal_matrix'] = 'Matice nie sú povolené, ak sa uvažuje ekvivalentne.';
$string['Equiv_Illegal_set'] = 'Množiny nie sú povolené, ak sa uvažuje ekvivalentne.';
$string['FacForm_UnPick_morework'] = 'Ešte stále by ste mohli urobiť viac práce na výraze {$a->m0}.';
$string['Illegal_control_flow'] = 'Vaša odpoveď obsahuje príkazy riadiacej štruktúry, ako napríklad <code>if</code> – podmienené vetvenie alebo <code> do </code> – cyklus , ktoré sú tu zakázané; ako odpoveď by ste mali pravdepodobne uviesť výsledok týchto príkazov.';
$string['Illegal_floats'] = 'Vaša odpoveď obsahuje desatinné čísla, ktoré v tejto otázke nie sú povolené. Musíte zadávať čísla ako zlomky. Mali by ste napríklad napísať 1/3, nie 0.3333, čo je napokon iba aproximácia jednej tretiny.';
$string['Illegal_groupping'] = 'Vaša odpoveď obsahuje zátvorky používané na skupinové operácie, ktoré sú tu zakázané. Pravdepodobne by ste výraz mali upraviť, aby ste ich eliminovali.';
$string['Illegal_groups'] = 'Vaša odpoveď obsahuje hodnotiace skupiny \'\'(a, b, c)\'\', ktoré tu nie sú povolené.';
$string['Illegal_identifiers_in_units'] = 'Vstup obsahuje názov premennej, pričom sa očakávajú iba jednotky.';
$string['Illegal_illegal_operation_in_units'] = 'Funkcia <code>{$a}</code> nie je povolená v tomto vstupe.';
$string['Illegal_illegal_power_of_ten_in_units'] = 'Hodnota nesmie obsahovať mocniny čísla 10 s neceločíselným mocniteľom.';
$string['Illegal_input_form_units'] = 'Tento vstup očakáva číselnú hodnotu, za ktorou nasleduje alebo ju vynásobí výraz definujúci jednotku, napr. <code>1.23*W/m^2</code>. Upozorňujeme, že tu požadovaná jednotka môže byť niečo iné.';
$string['Illegal_lists'] = 'Vaša odpoveď obsahuje zoznamy typu "[a,b,c]" , ktoré tu nie sú povolené.';
$string['Illegal_sets'] = 'Vaša odpoveď obsahuje množiny "{a,b,c}"\', ktoré tu nie sú povolené.';
$string['Illegal_singleton_floats'] = 'Tento vstup neakceptuje desatinné čísla v danom tvare. Tento vstup si vyžaduje číselnú hodnotu, uvedenú v jednej z nasledujúcich foriem: <code>{$a->forms}</code>';
$string['Illegal_singleton_integer'] = 'Tento vstup neprijíma celočíselné hodnoty. Tento vstup si vyžaduje číselnú hodnotu uvedenú v jednom z nasledujúcich tvarov: <code>{$a->forms}</code>';
$string['Illegal_singleton_power'] = 'Tento vstup si vyžaduje číselnú hodnotu uvedenú v jednej z nasledujúcich foriem: <code>{$a- forms}</code>';
$string['Illegal_strings'] = 'Vaša odpoveď obsahuje „reťazce“ (angl. "strings"), ktoré tu nie sú povolené.';
$string['Illegal_x10'] = 'Zdá sa, že vaša odpoveď používa znak „x“ ako symbol násobenia. Na násobenie použite znak <code>*</code>.';
$string['Interval_backwards'] = 'Pri konštrukcii skutočného intervalu hodnôt je potrebné zoradiť koncové body. {$a->m0} by malo byť {$a->m1}.';
$string['Interval_illegal_entries'] = 'Pri konštrukcii skutočných množín by sa nemalo objavovať nasledovné: {$a->m0}';
$string['Interval_notinterval'] = 'Očakával sa interval hodnôt, ale namiesto toho máme {$a->m0}.';
$string['Interval_wrongnumargs'] = 'Zostavenie intervalu hodnôt musí obsahovať presne dva argumenty, takže musí ísť o chybu: {$a->m0}.';
$string['Lowest_Terms'] = 'Vaša odpoveď obsahuje zlomky, ktoré nie sú zjednodušené. Zjednodušte ich a skúste to znova.';
$string['Maxima_Args'] = 'args (argumenty): argument musí byť zložitý výraz.';
$string['Maxima_DivisionZero'] = 'Delenie nulou.';
$string['Subst'] = 'Vaša odpoveď by bola správna, ak by ste použili nasledujúcu substitúciu premenných. {$a->m0}';
$string['TEST_FAILED'] = 'Test odpovedí zlyhal správne: upozornite svojho učiteľa.{$a->errors}';
$string['TEST_FAILED_Q'] = 'Test odpovedí zlyhal správne: upozornite svojho učiteľa.';
$string['Variable_function'] = 'Vo vašom výraze sa {$a->m0} objavilo aj ako premenná, aj ako funkcia. Prosím, upravte váš vstup. Buď vložte symboly <code>*</code>, aby ste odstránili funkcie, alebo upravte vašu otázku tak, aby všetky spomínané premenné boli funkcie.';
$string['addanothernode'] = 'Pridajte ďalší uzlový bod (vetvenie)';
$string['addanothertestcase'] = 'Pridajte ďalší testovací prípad ...';
$string['addatestcase'] = 'Pridajte testovací prípad...';
$string['addingatestcase'] = 'Pridanie testovacieho prípadu k otázke {$a}';
$string['alg_indices_fact'] = 'Manipulácia s indexami sa riadi týmito pravidlami:
\\[a^ma^n = a^{m+n}\\]
\\[\\frac{a^m}{a^n} = a^{m-n}\\]
\\[(a^m)^n = a^{mn}\\]
\\[a^0 = 1\\]
\\[a^{-m} = \\frac{1}{a^m}\\]
\\[a^{\\frac{1}{n}} = \\sqrt[n]{a}\\]
\\[a^{\\frac{m}{n}} = \\left(\\sqrt[n]{a}\\right)^m\\]';
$string['alg_indices_name'] = 'Pravidlá pre narábanie s indexami';
$string['alg_inequalities_fact'] = '\\[a>b \\hbox{ znamená } a \\hbox{ je väčšie ako } b.\\]
\\[ a < b \\hbox{ znamená } a \\hbox{ je menšie ako } b.\\]
\\[a\\geq b \\hbox{ znamená } a \\hbox{ je väčšie alebo rovné } b.\\]
\\[a\\leq b \\hbox{ znamená } a \\hbox{ je menšie alebo rovné } b.\\]';
$string['alg_inequalities_name'] = 'Nerovnosti';
$string['alg_logarithms_name'] = 'Princípy logaritmov';
$string['alg_partial_fractions_name'] = 'Parciálne zlomky';
$string['alg_quadratic_formula_fact'] = 'Ak máme kvadratickú rovnicu tvaru:
\\[ax ^ 2 + bx + c = 0, \\]
potom sú riešenia tejto rovnice dané kvadratickým vzorcom:
\\[x = \\ frac {-b \\ pm \\ sqrt {b ^ 2 - 4ac}} {2a}. \\]';
$string['alg_quadratic_formula_name'] = 'Kvadratický vzorec';
$string['all'] = 'Všetko';
$string['allnodefeedbackmustusethesameformat'] = 'All the feedback for all the nodes in a PRT must use the same text format.';
$string['allowwords'] = 'Povolené slová';
$string['allowwords_help'] = 'V predvolenom nastavení nie sú povolené ľubovoľné názvy funkcií alebo premenných s dĺžkou viac ako dva znaky. Toto je zoznam povolených názvov funkcií alebo premenných oddelených čiarkami pre odpovede študenta.';
$string['allowwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Allow_Words';
$string['alreadydeployed'] = 'Variant zodpovedajúci tejto otázke je už nasadený.';
$string['ansnotemismatch'] = '[Nesúlad odpovedí]';
$string['answernote'] = 'Poznámka k odpovedi';
$string['answernote_err'] = 'Poznámky k odpovedi nesmú obsahovať znak |. Tento znak je vložený programom STACK a neskôr sa použije na automatické rozdelenie odpovedí.';
$string['answernote_err2'] = 'Poznámky k odpovedi nemusia obsahovať znaky ";" alebo ":". Tieto znaky sa používajú na rozdelenie súhrnných reťazcov pokusov o otázky v nástrojoch na vytváranie prehľadov offline.';
$string['answernote_help'] = 'Toto je značka, ktorá je kľúčová pre účely nahlasovania. Je navrhnutá tak, aby zaznamenala jedinečnú cestu stromom a výsledok každého testu odpovedí. Toto sa generuje automaticky, ale dá sa zmeniť na niečo zmysluplné.';
$string['answernote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md#Answer_note';
$string['answernotedefaultfalse'] = '{$a->prtname}-{$a->nodename}-F';
$string['answernotedefaulttrue'] = '{$a->prtname}-{$a->nodename}-T';
$string['answernoterequired'] = 'Poznámka s odpoveďou nesmie byť prázdna.';
$string['answernoteunique'] = 'V tomto potenciálnom strome odpovedí boli zistené duplicitné odpovede.';
$string['answertest'] = 'Test odpovede';
$string['answertest_help'] = 'Test odpovedí sa používa na porovnanie dvoch výrazov s cieľom zistiť, či vyhovujú niektorým matematickým kritériám.';
$string['answertest_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['assumepositive'] = 'Predpokladajme pozitívne';
$string['assumepositive_help'] = 'Táto voľba nastavuje hodnotu Maxima premennej assume_pos.';
$string['assumepositive_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Positive';
$string['assumereal'] = 'Predpokladajme reálne';
$string['assumereal_help'] = 'Táto možnosť nastavuje premennú assume_real.';
$string['assumereal_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Real';
$string['autosimplify'] = 'Automatické zjednodušenie';
$string['autosimplify_help'] = 'Nastaví pre túto otázku premennú "simp" v rámci Maxima. Napr. premenné v otázkach, text otázky atď. Hodnota nastavená v každom potenciálnom strome odozvy to prehodnotí pri všetkých výrazoch definovaných v strome.';
$string['autosimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['autosimplifyprt'] = 'Automatické zjednodušenie';
$string['autosimplifyprt_help'] = 'Nastaví pre túto otázku premennú "simp" v rámci Maxima. Všimnite si, či sú výrazy v poznámkach PRT pred použitím zjednodušené, to závisí od testu odpovedí. Napríklad argumenty pre AlgEquiv sú zjednodušené, zatiaľ čo argumenty pre EqualComAss nie.';
$string['autosimplifyprt_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['basicquestionreport'] = 'Jednoduchá otázka používa záznam';
$string['basicquestionreport_help'] = 'Generuje veľmi základnú správu o pokusoch tejto otázky na serveri. Je to užitočné pre rozhodnutie, ktorý PRT test je možné pridať, aby sa zlepšila spätná väzba vzhľadom na to, čo študent v skutočnosti robí. (Väčšina otázok sa používa iba na jednom mieste)';
$string['basicreportinputsummary'] = 'Nespracované vstupy bez ohľadu na to, ktorý variant bol použitý.';
$string['booleangotunrecognisedvalue'] = 'Neplatný vstup.';
$string['boxsize'] = 'Rozmery vstupného poľa';
$string['boxsize_help'] = 'Šírka html formulára.';
$string['boxsize_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Box_Size';
$string['bulktestcontinuefromhere'] = 'Začnite znova alebo pokračujte od tohoto miesta';
$string['bulktestindexintro'] = 'Kliknutím na ktorýkoľvek link spustí všetky testy otázok v STACK v tomto kontexte.';
$string['bulktestnodeployedseeds'] = 'Táto otázka má náhodné varianty, ale nemá nasadené inicializácie náhodných čísel.';
$string['bulktestnogeneralfeedback'] = 'Táto otázka nemá všeobecnú spätnú väzbu.';
$string['bulktestnotests'] = 'Táto otázka nemá žiadne testy.';
$string['bulktestrun'] = 'Spustiť všetky testy otázok pre všetky otázky v systéme (pomalé, iba správca)';
$string['bulktesttitle'] = 'Spúšťanie všetkých testov otázok v {$a}';
$string['calc_chain_rule_name'] = 'Reťazové pravidlo';
$string['calc_diff_standard_derivatives_name'] = 'Jednoduché derivácie';
$string['calc_int_methods_parts_name'] = 'Integrácia pomocou metódy Per partes';
$string['calc_int_methods_substitution_name'] = 'Integrovanie pomocou substitúcie';
$string['calc_int_standard_integrals_name'] = 'Jednoduché integrály';
$string['calc_rules_name'] = 'Pravidlá pre kalkulus';
$string['casdisplay'] = 'Zobrazenie CAS';
$string['cassuitecolerrors'] = 'Chyby CAS';
$string['castext'] = 'Text CAS';
$string['casvalue'] = 'Hodnota CAS';
$string['checkanswertype'] = 'Skontrolujte typ odpovede';
$string['checkanswertype_help'] = 'Ak áno, odpovede iného „typu“ (napr. Výraz, rovnica, matica, zoznam, množina) sú zamietnuté ako neplatné.';
$string['checkanswertype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Check_Type';
$string['clearthecache'] = 'Vyčistiť vyrovnávaciu pamäť';
$string['complexno'] = 'Význam a zobrazenie sqrt(-1)';
$string['complexno_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#sqrt_minus_one.';
$string['createtestcase'] = 'Vytvorte testovací prípad';
$string['currentlyselectedvariant'] = 'Toto je variant zobrazený nižšie';
$string['ddl_badanswer'] = 'Pole pre správnu odpoveď pre tento vstup je chybné: <code>{$a}</code>.';
$string['ddl_duplicates'] = 'Pri generovaní možností vstupu boli nájdené duplicitné hodnoty.';
$string['ddl_empty'] = 'Pre túto rozbaľovaciu ponuku neboli poskytnuté žiadne možnosti.';
$string['ddl_nocorrectanswersupplied'] = 'Učiteľ neuviedol aspoň jednu správnu odpoveď.';
$string['ddl_runtime'] = 'Vstup vygeneroval nasledujúcu runtime chybu, ktorá vám zabráni odpovedať. Kontaktujte svojho učiteľa.';
$string['ddl_unknown'] = 'STACK zaznamenal <code>{$a}</code>, ale táto možnosť nie je uvedená učiteľom.';
$string['defaultprtpartiallycorrectfeedback'] = 'Vaša odpoveď je čiastočne správna.';
$string['deploymanysuccess'] = 'Počet úspešne vytvorených, otestovaných a nasadených nových variantov: {$a->no}.';
$string['deployoutoftime'] = 'Časový limit bol prekročený o približne {$a->time} sekúnd. Skúste znova.';
$string['deployremoveall'] = 'Zrušiť nasadenie všetkých variantov';
$string['dropdowngotunrecognisedvalue'] = 'Neplatný vstup.';
$string['editingtestcase'] = 'Úpravy testovacieho prípadu {$a->no} pre otázku {$a->question}';
$string['editquestioninthequestionbank'] = 'Upravte túto otázku';
$string['editthistestcase'] = 'Upravte tento testovací prípad.';
$string['equiv_AND'] = 'a';
$string['equiv_ANDOR'] = 'a/alebo - neurčitosť!';
$string['equiv_IMPLIES'] = 'naznačuje';
$string['equiv_LET'] = 'Nech';
$string['equiv_MISSINGVAR'] = 'Chýbajúce úlohy';
$string['equiv_NAND'] = 'nand';
$string['equiv_NOR'] = 'alebo';
$string['equiv_OR'] = 'alebo';
$string['equiv_SAMEROOTS'] = '(Rovnaké korene)';
$string['equiv_XNOR'] = 'xnor';
$string['equiv_XOR'] = 'xor';
$string['equivfirstline'] = 'Vo svojej argumentácii ste použili nesprávny prvý riadok!';
$string['equivnocomments'] = 'V tomto type vstupu nemáte povolenie používať komentáre. Pracujte prosím iba riadok po riadku.';
$string['errors'] = 'Chyby';
$string['exceptionmessage'] = '{$a}';
$string['expectedanswernote'] = 'Očakávaná odpoveď';
$string['expectedoutcomes'] = 'Očakávané PRT výstupy : [použité vstupy]';
$string['expectedpenalty'] = 'Očakávané penále';
$string['expectedscore'] = 'Očakávaný výsledok';
$string['exportthisquestion'] = 'Exportovať túto otázku';
$string['exportthisquestion_help'] = 'Týmto sa vytvorí exportný súbor Moodle XML, ktorý obsahuje iba túto jednu otázku. Jeden príklad, kedy je to užitočné - ak si myslíte, že táto otázka demonštruje chybu v STACKe, ktorú by ste chceli nahlásiť a poslať vývojárom.';
$string['false'] = 'Nepravda';
$string['falsebranch'] = 'Nesprávna vetva';
$string['feedbackstyle'] = 'PRT štýl spätnej väzby';
$string['feedbackstyle1'] = 'Štandardný';
$string['feedbackstyle2'] = 'Kompaktný';
$string['feedbackstyle3'] = 'Len znaky';
$string['feedbackstyle_help'] = 'Kontroluje, ako spätná väzba PRT je zobrazená.';
$string['feedbackstyle_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['feedbackvariables'] = 'Premenné spätnej väzby';
$string['feedbackvariables_help'] = 'Premenné spätnej väzby vám umožňujú pred vstupom do stromu manipulovať s ktorýmkoľvek zo vstupov spolu s premennými otázok. Tu definované premenné sa môžu použiť kdekoľvek inde v tomto strome.';
$string['feedbackvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Feedback_variables';
$string['fieldshouldnotcontainplaceholder'] = '{$a->field} nesmie obsahovať žiadne [[{$a->type}:...]] platné symboly.';
$string['fixdollars'] = 'Opraviť značky dolára';
$string['forbidfloat'] = 'Zakázať desatinné čísla';
$string['forbidfloat_help'] = 'Ak je nastavená hodnota áno, potom bude akákoľvek odpoveď študenta, ktorá obsahuje desatinné číslo, odmietnutá ako neplatná.';
$string['forbidfloat_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbid_Floats';
$string['forbidwords'] = 'Zakázané slová';
$string['forbidwords_help'] = 'Toto je zoznam textových reťazcov oddelených čiarkami, ktoré sú v odpovedi študenta zakázané.';
$string['forbidwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbidden_Words';
$string['generalfeedback'] = 'Všeobecná spätná väzba';
$string['generalfeedback_help'] = 'Všeobecná spätná väzba je CASText. Po vyskúšaní otázky sa študentovi zobrazí všeobecná spätná väzba, známa aj ako „vypracované riešenie“. Na rozdiel od spätnej väzby, ktorá závisí od odpovede študenta, sa všetkým študentom zobrazuje rovnaký všeobecný text spätnej väzby. Môže to závisieť od premenných otázky použitých vo variante otázky.';
$string['generalfeedback_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#general_feedback';
$string['greek_alphabet_name'] = 'Grécka abeceda';
$string['healthautomaxoptintro'] = 'Pre najlepší výkon potrebujeme optimalizovať systém "maxima" na linuxovom stroji. Použite stránku "healthcheck" doplnku a pozrite si dokumentáciu k tomuto problému.';
$string['healthcheckcache_db'] = 'Výsledky CAS sú ukladané do vyrovnávacej pamäti databázy.';
$string['healthcheckcache_none'] = 'Výsledky CAS nie sú ukladané do vyrovnávacej pamäti';
$string['healthcheckcache_otherdb'] = 'Výsledky CAS sú ukladané do vyrovnávacej pamäti inej databázy.';
$string['healthcheckcachestatus'] = 'Vyrovnavácia pamäť momentálne obsahuje {$a} vstupov.';
$string['healthcheckconnectintro'] = 'Snažíme sa vyhodnotiť nasledujúci CAS text:';
$string['healthchecklatexintro'] = 'STACK generuje LaTeX za chodu a umožňuje učiteľom využívať LaTeX notáciu v otázkach. Predpokladá, že LaTeX bude konvertovaný pomocou Moodle filtra. Nižšie sú uvedené ukážky zobrazených a vložených výrazov v LaTeX-e, ktoré by sa mali správne zobraziť vo vašom prehliadači. Problémy tu indikujú nesprávne nastavenie Moodle filtra, nie sú chybami samotného STACKU. STACK používa iba samotnú notáciu jedného a dvoch dolárov, ale niektorí autori otázok sa môžu spoliehať na iné formy.';
$string['hyp_functions_name'] = 'Hyperbolické funkcie';
$string['hyp_inverse_functions_name'] = 'Inverzné hyperbolické funkcie';
$string['illegalcaschars'] = 'Znaky @, $ a \\ nie sú povolené pre CAS vstup.';
$string['inputdisplayed'] = 'Zobrazené ako';
$string['inputentered'] = 'Zadaná hodnota';
$string['inputexpression'] = 'Vstup testu';
$string['inputextraoptions'] = 'Špeciálne možnosti';
$string['inputextraoptions_help'] = 'Niektoré typy vstupu vyžadujú na svoje fungovanie ďalšie možnosti. Tu ich môžete zadať. Táto hodnota je výrazom CAS.';
$string['inputextraoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Extra options';
$string['inputheading'] = 'Vstup:  {$a}';
$string['inputinvalidparamater'] = 'Neplatný rozmer';
$string['inputname'] = 'Názov vstupu';
$string['inputnameform'] = 'Názvy vstupu môžu byť iba písmená a za nimi (voliteľne) čísla. \'{$a}\' je neplatný.';
$string['inputnamelength'] = 'Názvy vstupov nemôžu byť dlhšie ako 18 znakov. Názov \'{$a}\' je príliš dlhý.';
$string['inputoptionunknown'] = 'Daný vstup nepodporuje možnosť \'{$a}\'.';
$string['inputremovedconfirm'] = 'Potvrdzujem, že chcem odstrániť túto premennú z otázky.';
$string['inputremovedconfirmbelow'] = 'Vstup \'{$a}\' bol odstránený. Prosím, potvrďte to nižšie.';
$string['inputs'] = 'Vstupy';
$string['inputstatus'] = 'Stav';
$string['inputstatusname'] = 'Prázdny';
$string['inputstatusnameinvalid'] = 'Neplatný';
$string['inputstatusnamescore'] = 'Skóre (body)';
$string['inputstatusnamevalid'] = 'Platný';
$string['inputtest'] = 'Test vstupu';
$string['inputtype'] = 'Typ vstupu';
$string['inputtype_help'] = 'Toto určuje typ vstupného prvku, napr. pole formulára, vstup pre pravda/nepravda, vstup pre textovú oblasť.';
$string['inputtype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md';
$string['inputtypealgebraic'] = 'Algebraický vstup';
$string['inputtypeboolean'] = 'Pravda/Nepravda';
$string['inputtypecheckbox'] = 'Začiarkavacie políčko';
$string['inputtypedropdown'] = 'Rozbaľovací zoznam';
$string['inputtypeequiv'] = 'Zdôvodnenie ekvivalencie';
$string['inputtypematrix'] = 'Matica';
$string['inputtypenotes'] = 'Záznamy';
$string['inputtypenumerical'] = 'Numerický';
$string['inputtypesinglechar'] = 'Jeden znak';
$string['inputtypestring'] = 'Reťazec';
$string['inputtypetextarea'] = 'Textová oblasť';
$string['inputtypeunits'] = 'Jednotky';
$string['inputtypevarmatrix'] = 'Matica premenlivých rozmerov';
$string['inputwillberemoved'] = 'Tento vstup už nie je uvedený v texte otázky. Ak otázku teraz uložíte, údaje o tomto vstupe sa stratia. Potvrďte, prosím, že to chcete urobiť. Prípadne upravte text otázky, aby ste vrátili späť zástupné symboly:  \'[[input:{$a}]]\' a \'[[validation:{$a}]]\'.';
$string['insertspaces'] = 'Hviezdičky (*) vkladajte len pre určenie medzier';
$string['insertstars'] = 'Vložte hviezdičky (*)';
$string['insertstars_help'] = 'Táto možnosť poskytuje množstvo rôznych možností vkladania hviezdičiek (*), pri ktorých je implikované násobenie. Prečítajte si podrobnejšiu dokumentáciu.';
$string['insertstars_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Insert_Stars';
$string['insertstarsassumesinglechar'] = 'Vložte hviezdičky (*) za predpokladu jednoznakových názvov premenných';
$string['insertstarsno'] = 'Nevkladajte hviezdičky (*)';
$string['insertstarsspaces'] = 'Vkladajte hviezdičky pre násobenie a pre medzery';
$string['insertstarsspacessinglechar'] = 'Vložte hviezdičky, reprezentujúce jednoznakové premenné, navrhované a pre medzery';
$string['insertstarsyes'] = 'Vkladajte hviezdičky len pre predpokladané násobenie';
$string['inversetrig'] = 'Inverzné trigonometrické funkcie';
$string['inversetrig_help'] = 'Určuje, ako sa inverzné trigonometrické funkcie zobrazujú na výstupe CAS.';
$string['inversetrig_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#inverse_trig';
$string['irred_Q_commonint'] = 'Musíte vyňať spoločného deliteľa.';
$string['irred_Q_optional_fac'] = 'Mohli by ste urobiť viac práce, pretože {$a->m0} je možné ďalej spracovať. Avšak nemusíte.';
$string['logicsymbol'] = 'Logické symboly';
$string['logicsymbol_help'] = 'Určuje, ako sa majú logické symboly zobrazovať vo výstupe CAS.';
$string['logicsymbol_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#logicsymbol';
$string['logicsymbollang'] = 'Jazyk';
$string['logicsymbolsymbol'] = 'Symbolický';
$string['matrixparens'] = 'Východzí tvar zátvoriek matice';
$string['matrixparens_help'] = 'Ovláda predvolený tvar maticových zátvoriek, keď sa zobrazujú vo výstupe CAS.';
$string['matrixparens_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Matrix.md#matrixparens';
$string['multiplicationsign'] = 'Znak pre násobenie';
$string['multiplicationsign_help'] = 'Určuje, ako sa zobrazujú znaky násobenia.';
$string['multiplicationsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#multiplication';
$string['mustverify'] = 'Študent musí overiť';
$string['mustverify_help'] = 'Určuje, či sa vstup študenta predloží späť ako vynútený dvojkrokový proces predtým, ako sa tento vstup sprístupní mechanizmu bodovania. Syntaktické chyby sú vždy spätne nahlasované.';
$string['mustverify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Student_must_verify';
$string['mustverifyshowvalidation'] = 'Nemôžete si zvoliť vyžadovanie dvojstupňovej validácie, ale po prvom kroku nebude študentovi zobrazovať výsledky validácie. To dáva študenta do nemožnej pozície.';
$string['namealreadyused'] = 'Tento názov ste už použili.';
$string['newnameforx'] = 'Nové meno pre \'{$a}\'';
$string['next'] = 'Ďalší';
$string['nodehelp'] = 'Uzol stromu odpovede';
$string['nodehelp_help'] = '### Answer test (Test odpovede)
Test odpovede sa používa na porovnanie dvoch výrazov s cieľom zistiť, či vyhovujú niektorým matematickým kritériám.

### SAns (Odpoveď študenta)
Toto je prvý argument k funkcii testu odpovede. V asymetrických testoch sa to považuje za „odpoveď študenta“, aj keď to môže byť akýkoľvek platný výraz CAS a môže závisieť od premenných v otázkach alebo od premenných spätnej väzby.

### TAns (Odpoveď učiteľa)
Toto je druhý argument k funkcii testu odpovede. V asymetrických testoch sa to považuje za „odpoveď učiteľa“, aj keď to môže byť akýkoľvek platný výraz CAS a môže závisieť od premenných v otázkach alebo od premenných spätnej väzby.

### Test options (Možnosti testu)
Toto pole umožňuje testom odpovedí prijať možnosť, napr. premenná alebo číselná presnosť.

### Quiet (Tiché)
Ak je nastavená hodnota áno, tak akákoľvek spätná väzba, automaticky generovaná testami odpovedí, je potlačená a študentovi sa nezobrazí. Polia spätnej väzby vo vetvách nie sú touto voľbou ovplyvnené.';
$string['nodeloopdetected'] = 'Tento link vytvára cyklus v strome potenciálnych odpovedí (angl. PRT, slov. SPO).';
$string['nodenotused'] = 'Žiadne iné uzly (angl. nodes) v SPO (angl. PRT) nie sú pripojené k tomuto uzlu.';
$string['nodex'] = 'Uzol {$a}';
$string['nodexdelete'] = 'Vymazať uzol (angl. node) {$a}';
$string['nodexfalsefeedback'] = 'Nesprávna spätná väzba uzlu (angl. node) {$a}';
$string['nodextruefeedback'] = 'Správna spätná väzba uzlu (angl. node) {$a}';
$string['nodexwhenfalse'] = 'Uzol (angl. node) {$a} sa zobrazí, keď nesprávne';
$string['nodexwhentrue'] = 'Uzol (angl. node) {$a} sa zobrazí, keď správne';
$string['nonempty'] = 'Toto nesmie byť prázdne';
$string['noprtsifnoinputs'] = 'Otázka bez vstupov nemôže mať SPO (angl. PRT)';
$string['notanswered'] = '(Neuvedená odpoveď)';
$string['notavalidname'] = 'Neplatný názov';
$string['notestcasesyet'] = 'Zatiaľ neboli pridané žiadne vzory testov.';
$string['numericalinputdp'] = 'Musíte zadať presne  \\( {$a} \\) desatinných miest.';
$string['numericalinputmaxdp'] = 'Musíte zadať najviac \\( {$a} \\) desatinných miest.';
$string['numericalinputmaxsf'] = 'Musíte zadať najviac \\( {$a} \\) platných znakov.';
$string['numericalinputmindp'] = 'Musíte zadať najmenej \\( {$a} \\) desatinných miest.';
$string['numericalinputminmaxerr'] = 'Požadovaný minimálny počet číselných miest presahuje maximálny počet miest!';
$string['numericalinputminsf'] = 'Musíte zadať najmenej \\( {$a} \\) platných znakov.';
$string['numericalinputminsfmaxdperr'] = 'Nezadávajte požiadavky na desatinné miesta aj na platné číslice súčasne v rovnakom vstupe.';
$string['numericalinputmustfloat'] = 'Tento vstup vyžaduje desatinné číslo s pohyblivou hodnotou.';
$string['numericalinputmustint'] = 'Tento vstup očakáva jednoznačne celé číslo.';
$string['numericalinputmustnumber'] = 'Tento vstup očakáva číslo.';
$string['numericalinputmustrational'] = 'Tento vstup vyžaduje zlomok alebo racionálne číslo.';
$string['numericalinputoptboolerr'] = 'Hodnota možnosti <code>{$a->opt}</code> by mala byť boolovská, ale je  <code>{$a->val}</code>.';
$string['numericalinputoptinterr'] = 'Hodnota možnosti <code>{$a->opt}</code> by malo byť celé číslo, ale je <code>{$a->val}</code>.';
$string['numericalinputsf'] = 'Musíte zadať presne \\ ({$a} \\) platných čísel.';
$string['numericalinputvarsforbidden'] = 'Tento vstup vyžaduje číslo, teda nesmie obsahovať premenné.';
$string['options'] = 'Možnosti';
$string['overallresult'] = 'Celkový výsledok';
$string['penalty'] = 'Penále';
$string['penalty_help'] = 'Systém pokút odvodí túto hodnotu od výsledku každého PRT za každý platný pokus, ktorý nie je úplne správny.';
$string['penalty_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Feedback.md';
$string['penaltyerror'] = 'Penále (pokuta) musí byť číselná hodnota medzi 0 a 1.';
$string['penaltyerror2'] = 'Penále musí byť buď prázdne alebo číselná hodnotu od 0 do 1.';
$string['phpcasstring'] = 'PHP výstup';
$string['phpsuitecolerror'] = 'PHP chyby';
$string['pleaseananswerallparts'] = 'Prosím, odpovedzte na všetky časti otázky.';
$string['pleasecheckyourinputs'] = 'Prosím, overte, či to, čo ste zadali, bolo interpretované, ako je očakávané.';
$string['pluginname'] = 'STACK';
$string['pluginname_help'] = 'STACK je hodnotiaci systém pre matematiku.';
$string['pluginnameadding'] = 'Pridanie otázky typu STACK';
$string['pluginnameediting'] = 'Úprava otázky typu STACK';
$string['pluginnamesummary'] = 'STACK poskytuje matematické otázky pre kvíz (test) v Moodle. Používa systém počítačovej algebry na zisťovanie matematických atribútov odpovedí študenta.';
$string['privacy:metadata'] = 'Otázky typu STACK neukladajú žiadne osobné informácie.';
$string['prtcorrectfeedback'] = 'Štandardná spätná väzba pre správne odpovede';
$string['prtheading'] = 'Strom potenciálnych odpovedí (angl. PRT, slov. SPO): {$a}';
$string['prtincorrectfeedback'] = 'Štandardná spätná väzba pre nesprávne odpovede';
$string['prtmustbesetup'] = 'Tento PRT (strom potenciálnych odpovedí) musí byť nastavený pred uložením otázky.';
$string['prtname'] = 'Názov PRT (stromu potenciálnych odpovedí, SPO)';
$string['prtnamelength'] = 'Názvy PRT nemôžu byť dlhšie ako 18 znakov. \'{$a}\' je príliš dlhý.';
$string['prtnodesheading'] = 'Uzly stromu potenciálnych odpovedí  ({$a})';
$string['prtpartiallycorrectfeedback'] = 'Štandardná spätná väzba pre čiastočne správnu odpoveď';
$string['prtremovedconfirm'] = 'Potvrdzujem, že chcem z tejto otázky odstrániť tento potenciálny strom odpovedí.';
$string['prtremovedconfirmbelow'] = 'Strom potenciálnych odpovedí "{$a}"  bol odstránený. Potvrďte to nižšie.';
$string['prtruntimeerror'] = 'Uzol {$a->node} vygeneroval nasledujúcu chybu: {$a->error}';
$string['prts'] = 'Stromy potenciálnych odpovedí';
$string['prtwillbecomeactivewhen'] = 'Tento potenciálny strom odpovedí bude aktívny, keď študent odpovie: {$a}';
$string['prtwillberemoved'] = 'Tento potenciálny strom odpovedí už nie je uvedený v texte otázky alebo v konkrétnej spätnej väzbe. Ak otázku teraz uložíte, údaje o tomto strome potenciálnych odpovedí sa stratia. Potvrďte, že to chcete urobiť. Prípadne upravte text otázky alebo konkrétnu spätnú väzbu, aby ste vrátili zástupný symbol \'[[feedback:{$a}]]\'.';
$string['qm_error'] = 'Vaša odpoveď obsahuje otázniky, ?, ktoré nie sú v povolené odpovediach . Mali by ste ich nahradiť konkrétnou hodnotou.';
$string['questiondoesnotuserandomisation'] = 'Táto otázka nepoužíva randomizáciu.';
$string['questionnotdeployedyet'] = 'Zatiaľ neboli nasadené žiadne varianty tejto otázky.';
$string['questionnote'] = 'Poznámka k otázke';
$string['questionnote_help'] = 'Poznámka k otázke je CASText. Zmyslom poznámky k otázke je rozlíšiť medzi náhodnými verziami tejto otázky. Dve verzie otázok sú rovnaké vtedy, ak sú poznámky k otázkam identické. V neskoršej analýze je veľmi užitočné zanechať zmysluplný dotazník.';
$string['questionnote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Question_note.md';
$string['questionnotempty'] = 'Poznámky k otázke nemôžu byť prázdne, keď sa v premenných otázok objaví funkcia rand (). Poznámka k otázke sa používa na rozlíšenie medzi rôznymi náhodnými verziami tej istej otázky.';
$string['questionpreview'] = 'Náhľad otázky';
$string['questionsimplify'] = 'Zjednodušenie úrovne otázok';
$string['questionsimplify_help'] = 'Nastaví pre celú otázku globálnu premennú „simp“ v rámci Maxima.';
$string['questionsimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['questiontests'] = 'Otázkové testy';
$string['questiontestsdefault'] = '(Predvolené)';
$string['questiontestsfor'] = 'Otázkové testy pre zdroj  {$a}';
$string['questiontestspass'] = 'Všetky testové otázky prešli.';
$string['questiontext'] = 'Text otázky';
$string['questiontext_help'] = 'Text otázky je CASText. Toto je „otázka“, ktorú študent v skutočnosti vidí. Do tohto poľa musíte vložiť vstupné prvky a validačné reťazce, a to iba do tohto poľa. Napríklad  `[[input:ans1]] [[validation:ans1]]`.';
$string['questiontext_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#question_text';
$string['questiontextfeedbacklanguageproblems'] = 'V značkách spätnej väzby sú nezrovnalosti medzi jazykmi .';
$string['questiontextfeedbackonlycontain'] = 'Text otázky spojený s konkrétnou spätnou väzbou by mal obsahovať token \'{$a}\'  len raz.';
$string['questiontextmustcontain'] = 'Text otázky musí obsahovať token \'{$a}\'.';
$string['questiontextnonempty'] = 'Text otázky nesmie byť prázdny.';
$string['questiontextonlycontain'] = 'Text otázky by mal obsahovať token \'{$a}\' iba raz.';
$string['questiontextplaceholderswhitespace'] = 'Zástupné symboly nesmú obsahovať medzery. Zdá sa, že tento ich má: \'{$a}\'.';
$string['questionvalue'] = 'Hodnota otázky';
$string['questionvaluepostive'] = 'Hodnota otázky musí byť nezáporná.';
$string['questionvariables'] = 'Premenné v otázke';
$string['questionvariables_help'] = 'Toto pole umožňuje definovať a manipulovať s premennými CAS, napr. vytvoriť náhodné verzie. Sú k dispozícii pre všetky ostatné časti otázky.';
$string['questionvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Question_variables';
$string['questionvariablevalues'] = 'Hodnoty premenných otázok';
$string['quiet_help'] = 'Ak je nastavená hodnota áno, akákoľvek spätná väzba automaticky generovaná testami odpovedí je potlačená a študentovi sa nezobrazí. Polia spätnej väzby vo vetveniach nie sú touto voľbou ovplyvnené.';
$string['renamequestionparts'] = 'Prmenuj časti otázky';
$string['replacedollarscount'] = 'Táto kategória obsahuje  {$a} otázok typu STACK.';
$string['replacedollarsin'] = 'Opravené oddeľovače pre matematiku v poli {$a}';
$string['replacedollarsindex'] = 'Kontexty s otázkami STACK';
$string['replacedollarsindexintro'] = 'Kliknutím na niektorý z odkazov sa dostanete na stránku, kde môžete skontrolovať otázky týkajúce sa oddeľovačov matematiky v starom štýle a automaticky ich opraviť. Ak máte príliš veľa otázok (tisíce) v jednom kontexte, veľkosť výstupu pravdepodobne zaplaví váš webový prehliadač. V takom prípade pridajte do adresy URL parameter preview = 0 a skúste to znova.';
$string['replacedollarsindextitle'] = 'Nahraďte $ v texte otázok';
$string['replacedollarsnoproblems'] = 'Nenašli sa žiadne problémové oddeľovače.';
$string['replacedollarstitle'] = 'Nahradiť $s v textoch otázkok v {$a}';
$string['requirelowestterms'] = 'Vyžadujte najjednoduchšie podmienky';
$string['requirelowestterms_help'] = 'Keď je táto možnosť nastavená na áno, akékoľvek koeficienty alebo iné racionálne čísla vo výraze musia byť napísané čo najjednoduchšie. V opačnom prípade je odpoveď zamietnutá ako neplatná.';
$string['requirelowestterms_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Require_lowest_terms';
$string['runquestiontests'] = 'Testy otázok a nasadené verzie';
$string['runtimeerror'] = 'Táto otázka vygenerovala neočakávanú internú chybu. Prosím hľadajte radu, napr. od učiteľa.';
$string['runtimefielderr'] = 'Pole  ""{$a->field}"" vygenerovalo nasledujúcu chybu: {$a->err}';
$string['sans'] = 'SAns';
$string['sans_help'] = 'Toto je prvý argument k funkcii testu odpovede. V asymetrických testoch sa to považuje za „odpoveď študenta“, aj keď to môže byť akýkoľvek platný výraz CAS a môže závisieť od premenných otázok alebo premenných spätnej väzby.';
$string['sans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['sansrequired'] = 'SAns niesmie byť prázdny.';
$string['scoreerror'] = 'Skóre musí byť číselná hodnota od 0 do 1.';
$string['seedx'] = 'Zdroj  {$a}';
$string['seethisquestioninthequestionbank'] = 'Túto otázku nájdete v banke otázok';
$string['settingajaxvalidation'] = 'Bežná kontrola';
$string['settingajaxvalidation_desc'] = 'Ak je toto nastavenie zapnuté, aktuálny vstup študentov bude overený vždy, keď pozastavia svoje zadávanie. To dáva lepšiu používateľskú skúsenosť, ale pravdepodobne to zvýši zaťaženie servera.';
$string['settingcasdebugging'] = 'Odstraňovanie chýb CAS';
$string['settingcasmaximaversion'] = 'Verzia Maxima';
$string['settingcasmaximaversion_desc'] = 'Používaná verzia Maxima';
$string['settingcasresultscache_db'] = 'Údaje vyrovnávacej pamäti v databáze';
$string['settingcasresultscache_desc'] = 'Toto nastavenie určuje, či sa volania CAS ukladajú do medzipamäte. Toto nastavenie by malo byť zapnuté, pokiaľ nerobíte vývoj, ktorý zahŕňa zmenu kódu Maxima. Aktuálny stav vyrovnávacej pamäte sa zobrazuje na stránke kontroly stavu. Ak zmeníte svoje nastavenia, napr. príkaz gnuplot, budete musieť vyčistiť medzipamäť, aby ste videli účinky týchto zmien.';
$string['settingdefaultinputoptions'] = 'Predvolené možnosti vstupu';
$string['settingdefaultinputoptions_desc'] = 'Použité, keď sa vytvára nová otázka, alebo keď sa pridáva nový vstup do existujúcej otázky.';
$string['settingdefaultquestionoptions'] = 'Predvolené možnosti vstupu';
$string['settingdefaultquestionoptions_desc'] = 'Použité, keď sa vytvára nová otázka.';
$string['settingmathsdisplay'] = 'Filter pre matematiku';
$string['settingmathsdisplay_tex'] = 'Moodle TeX-ovský filter';
$string['settingmaximalibraries'] = 'Načítať voliteľné knižnice Maxima';
$string['settingmaximalibraries_error'] = 'Nasledujúci balík nie je podporovaný: {$a}';
$string['settingmaximalibraries_failed'] = 'Zdá sa, akoby sa nepodarilo načítať niektoré z balíkov Maxima, o ktoré ste žiadali. Informácie o tejto chybe nájdete v pokynoch na inštaláciu.';
$string['settingparsercacheinputlength_desc'] = 'Analyzátor výrazov sa pri dlhých výrazoch (napríklad zložité premenné otázok) dosť spomalí. Výsledok syntaktickej analýzy preto ukladáme do medzipamäte dlhšej ako tento limit. V ideálnom prípade by malo byť toto nastavenie nastavené na hodnotu, pri ktorej vyhľadávanie v pamäti cache trvá asi tak dlho ako samotná syntaktická analýza. 50 znakov je toho kvalifikovaný odhad. Ak je nastavená na 0, vyrovnávacia pamäť je deaktivovaná.';
$string['settingplatformmaximacommandopt'] = 'Optimalizovaný príkaz pre Maxima';
$string['settingplatformtype'] = 'Druh platformy';
$string['settingplatformtype_desc'] = 'STACK potrebuje vedieť, aký operačný systém je spustený. Možnosť „Server“ poskytuje lepší výkon za cenu, že je potrebné zriadiť ďalší server. Možnosť „Linux (optimalizovaný)“ je vysvetlená na stránke Optimalizácia Maxima v dokumentácii.';
$string['settingplatformtypelinux'] = 'Linux';
$string['settingplatformtypelinuxoptimised'] = 'Optimalizované pre Linux';
$string['settingplatformtypeserver'] = 'Server';
$string['settingreplacedollars'] = 'Nahraďte <code>$</code> a <code>$$</code>';
$string['settingsmathsdisplayheading'] = 'Možnosti zobrazovania výpočtov';
$string['settingsmaximasettings'] = 'Pripájanie k Maxima';
$string['settingusefullinks'] = 'Užitočné linky';
$string['showingundeployedvariant'] = 'Zobrazuje sa nenasadený variant: {$a}';
$string['showvalidation'] = 'Zobraziť overenie';
$string['showvalidation_help'] = 'Zobrazí akúkoľvek spätnú väzbu z tohto vstupu vrátane potvrdenia ich vyjadrenia v tradičnej dvojrozmernej notácii. Syntaktické chyby sa hlásia vždy.';
$string['showvalidation_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Show_validation';
$string['showvalidationcompact'] = 'Áno, kompaktný';
$string['showvalidationno'] = 'Nie';
$string['showvalidationyes'] = 'Áno, so zoznamom premenných';
$string['showvalidationyesnovars'] = 'Áno, bez zoznamu premenných';
$string['singlechargotmorethanone'] = 'Sem môžete vložiť len jeden znak.';
$string['specificfeedback'] = 'Špecifická spätná väzba';
$string['specificfeedback_help'] = 'V tomto bloku sa predvolene zobrazí spätná väzba pre každý potenciálny strom odpovedí. Môže byť presunutý do textu otázky. V takom prípade bude mať Moodle menšiu kontrolu nad tým, kedy sa zobrazuje rôznymi spôsobmi správania. Tento blok nie je CASText.';
$string['sqrtsign'] = 'Odmocniny iracionálnych čísiel';
$string['sqrtsign_help'] = 'Riadi, ako sa zobrazujú odmocniny iracionálnych čísiel.';
$string['sqrtsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#surd';
$string['stack:usediagnostictools'] = 'Použiť STACK nástroje';
$string['stackBlock_missmatch'] = 'nemá žiadne zhody.';
$string['stackBlock_unknownBlock'] = 'Nasledujúci blok nie je známy:';
$string['stackCas_CASError'] = 'CAS vrátil nasledovný(é) problém(y):';
$string['stackCas_CASErrorCaused'] = 'spôsobilo nasledujúcu chybu:';
$string['stackCas_MissingAt'] = 'Chýba Vám značka  <code>@</code>.';
$string['stackCas_MissingCloseDisplay'] = 'Chýba <code>\\]</code>.';
$string['stackCas_MissingCloseHTML'] = 'Chýba Vám uzatváracia html značka.';
$string['stackCas_MissingCloseInline'] = 'Chýba <code>\\)</code>.';
$string['stackCas_MissingClosingRawCAS'] = 'Chýba <code>#}</code>.';
$string['stackCas_MissingClosingTeXCAS'] = 'Chýba <code>@}</code>.';
$string['stackCas_MissingDollar'] = 'Chýba vám znak <code>$</code>.';
$string['stackCas_MissingOpenDisplay'] = 'Chýba <code>\\[</code>.';
$string['stackCas_MissingOpenHTML'] = 'Chýba otváracia značnka html kódu.';
$string['stackCas_MissingOpenInline'] = 'Chýba <code>\\(</code>.';
$string['stackCas_MissingOpenRawCAS'] = 'Chýba <code>{#</code>.';
$string['stackCas_MissingOpenTeXCAS'] = 'Chýba <code>{@</code>.';
$string['stackCas_MissingStars'] = 'Vyzerá to tak, že vám chýbajú * znaky. Možno ste chceli zadať nasledovné {$a->cmd}.';
$string['stackCas_MissingString'] = 'Chýbajú vám úvodzovky <code>"</code>.';
$string['stackCas_StringOperation'] = 'Vyzerá to tak, že istý reťazec (string) je na nesprávnom mieste. Problém je nasledovný: <code>{$a->issue}</code>.';
$string['stackCas_allFailed'] = 'CAS nedokázal vrátiť žiadne hodnotené výrazy. Skontrolujte svoje spojenie s CAS.';
$string['stackCas_apostrophe'] = 'Apostrofy nie sú povolené v odpovediach.';
$string['stackCas_applyfunmakestring'] = 'Názov funkcie nemôže byť reťazec v <code>{$a->type}</code>.';
$string['stackCas_applyingnonobviousfunction'] = 'Zdá sa, že toto volanie funkcie {$a->problem} nemá ľahko viditeľný názov funkcie. Z bezpečnostných dôvodov možno budete musieť zjednodušiť volanie, aby validátor videl názov funkcie.';
$string['stackCas_badLogIn'] = 'Zadali ste výraz <tt>In</tt>. Prirodzený logaritmus sa zadáva ako <tt>ln</tt> s malými písmenami. ("Lima November" nie "India November", teda písmeno L a nie I.)';
$string['stackCas_callingasfunction'] = 'Volanie výsledku volania funkcie je zakázané {$a->problem}, lambdy sú stále povolené.';
$string['stackCas_errorpos'] = 'Približne v riadku {$a->line} znak {$a->col}.';
$string['stackCas_failedReturn'] = 'CAS zlyhal vrátiť údaje.';
$string['stackCas_failedReturnOne'] = 'CAS zlyhal vrátiť niektoré údaje.';
$string['stackCas_failedValidation'] = 'CASText zlyhal pri overovaní.';
$string['stackCas_finalChar'] = '\'{$a->char}\' je neplatný konečný znak v {$a->cmd}';
$string['stackCas_forbiddenChar'] = 'Príkazy CAS nesmú obsahovať nasledujúce znaky: {$a->char}.';
$string['stackCas_forbiddenFunction'] = 'Zakázaná funkcia: {$a->forbid}.';
$string['stackCas_forbiddenOperator'] = 'Zakázaný operátor: {$a->forbid}.';
$string['stackCas_forbiddenVariable'] = 'Zakázaná premenná alebo konštanta : {$a->forbid}.';
$string['stackCas_forbiddenWord'] = 'Výraz {$a->forbid} je zakázaný.';
$string['stackCas_forbiddenntuple'] = 'V tomto vstupe nie sú povolená koordináty.';
$string['stackCas_inputsdefined'] = 'Ako premenné nemusíte používať názvy vstupov. Pokúsili ste sa definovať <code>{$a}</code>';
$string['stackCas_invalidCommand'] = 'CAS príkazy sú neplatné.';
$string['stackCas_missingLeftBracket'] = 'Vo výraze vám chýba ľavá zátvorka <span class="stacksyntaxexample">{$a->zátvorka}</span>: {$a->cmd}.';
$string['stackCas_missingRightBracket'] = 'Vo výraze vám chýba pravá zátvorka <span class="stacksyntaxexample">{$a->zátvorka}</span>: {$a->cmd}.';
$string['stackCas_nested_function_declaration'] = 'Definícia funkcie v rámci inej funkcie je teraz zakázaná, použite premenovanie funkcie, ak potrebujete zmeniť definície funkcií z inej funkcie.';
$string['stackCas_newline'] = 'V odpovediach nie sú povolené znaky nového riadku.';
$string['stackCas_noFunction'] = 'Použitie funkcie {$a->forbid} v člene {$a->term} nie je v tomto kontexte povolené.';
$string['stackCas_operatorAsVariable'] = 'Operátor {$a->op} je interpretovaný ako premenná, skontrolujte syntax.';
$string['stackCas_overlyComplexSubstitutionGraphOrRandomisation'] = 'Kód otázky obsahuje príliš zložité substitúcie alebo vytvára randomizáciu inkrementálnym a ťažko overiteľným spôsobom, validácia vypršala; zjednodušte otázku a pozrite dokumentáciu.';
$string['stackCas_overrecursivesignatures'] = 'Kód otázky obsahuje príliš veľa funkcií definovaných prostredníctvom mapovania';
$string['stackCas_percent'] = 'Vo výraze {$a->expr} bol nájdený %.';
$string['stackCas_qmarkoperators'] = 'Otázniky nie sú dovolené v odpovediach.';
$string['stackCas_redefine_built_in'] = 'Predefinovanie vstavanej funkcie "{$a->name}" je zakázané.';
$string['stackCas_redefinitionOfConstant'] = 'Redefinovanie kľúčových konštánt je zakázané: {$a->constant}.';
$string['stackCas_reserved_function'] = 'Názov funkcie "{$a->name}" nie je v tejto otázke povolený. Kontaktujte svojho učiteľa.';
$string['stackCas_spaces'] = 'Vo výraze {$a->expr} sa našli nepovolené medzery.';
$string['stackCas_spuriousop'] = 'Neznámy operátor: {$a->cmd}.';
$string['stackCas_studentInputAsFunction'] = 'Použitie vstupu od študenta ako názvu funkcie nie je povolené.';
$string['stackCas_trigexp'] = 'Nemôžete získať mocninu spúšťacej funkcie napísaním {$a->forbid}. Druhá mocnina hodnoty \\(\\{$a->identifier}(x)\\) sa zadá ako <tt>{$a->identifier}(x)^2</tt>. Inverzná k \\(\\{$a->identifier}(x)\\) sa píše <tt>a{$a->identifier}(x)</tt> a nie \\(\\{$a->identifier}^{-1}(x)\\) .';
$string['stackCas_triginv'] = 'Inverzné trigonárne funkcie sa zapisujú ako {$a->goodinv}, a nie {$a->badinv}.';
$string['stackCas_trigop'] = 'Na argument musíte použiť {$a->trig}. Zdá sa, že máte {$a->forbid}, čo vyzerá, že ste sa pokúsili použiť {$a->trig} ako názov premennej.';
$string['stackCas_trigparens'] = 'Keď použijete funkciu trig na jej argumenty, musíte použiť okrúhle zátvorky, nie hranaté zátvorky. Napr. {$a->forbid}.';
$string['stackCas_trigspace'] = 'Ak chcete použiť funkciu trig na jej argumenty, musíte použiť zátvorky, nie medzery. Napríklad namiesto toho použite {$a->trig}.';
$string['stackCas_underscores'] = 'Nasledujúce použitie znakov podčiarknutia nie je povolené: {$a}.';
$string['stackCas_unencpsulated_comma'] = 'Čiarka vo vašom výraze sa objaví zvláštnym spôsobom. Čiarky sa používajú na oddelenie položiek v zoznamoch, množinách atď. V číslach s pohyblivou desatinnou čiarkou musíte použiť bodku, nie čiarku.';
$string['stackCas_unitssynonym'] = 'Zdá sa, že máte jednotky {$a->forbid}. Mali ste na mysli {$a->unit} ?';
$string['stackCas_unknownFunction'] = 'Neznáma funkcia: {$a->forbid} v člene {$a->term}.';
$string['stackDoc_404'] = 'Error číslo 404';
$string['stackDoc_404message'] = 'Súbor nenájdený.';
$string['stackDoc_AnswerTestResults'] = '# Výsledky testu odpovedí

Táto stránka odhaľuje výsledky spustených testov odpovedí na testovacích prípadoch STACK. Táto stránka je automaticky generovaná z testov jednotiek STACK a je navrhnutá tak, aby ukázala autorom otázok, čo testy odpovedí skutočne robia. To zahŕňuje prípady, keď testy odpovedí momentálne zlyhajú, čo dáva očakávanú negatívnu známku. Komentáre a ďalšie testovacie prípady sú veľmi vítané.';
$string['stackDoc_directoryStructure'] = 'Adresárová štruktúra';
$string['stackDoc_docs'] = 'STACK dokumentácia';
$string['stackDoc_licence'] = 'Dokumentácia STACK je licencovaná podľa <a rel="license" href="http://creativecommons.org/licenses/by-sa/4.0/">Creative Commons Attribution-ShareAlike 4.0 International License</a>.';
$string['stackDoc_siteMap'] = 'Mapa stránok';
$string['stackDoc_siteMap_en'] = 'Mapa stránok po anglicky';
$string['stackDoc_version'] = 'Vaša stránka zobrazuje STACK vo verzii {$a}.';
$string['stackInstall_input_title'] = 'Testovacia sada na overenie študentských vstupov';
$string['stackInstall_testsuite_choose'] = 'Prosím, vyberte test odpovede';
$string['stackInstall_testsuite_errors'] = 'Táto otázka vygenerovala pri spustení nasledujúce chyby.';
$string['stackInstall_testsuite_fail'] = 'Neprešli všetky testy!';
$string['stackInstall_testsuite_failingtests'] = 'Testy, ktoré zlyhali';
$string['stackInstall_testsuite_failingupgrades'] = 'Otázky, ktoré pri aktualizácii zlyhali.';
$string['stackInstall_testsuite_intro'] = 'Táto stránka vám umožňuje vidieť príklady testov odpovedí a otestovať, či testy odpovedí STACK fungujú správne. Upozorňujeme, že prostredníctvom webového rozhrania je možné kontrolovať iba testy odpovedí. Ak je značka záporná, znamená to očakávané zlyhanie, pričom -1 je zlyhanie v dôsledku očakávanej internej chyby.';
$string['stackInstall_testsuite_nodeployedseeds'] = 'Otázky s náhodnými variantmi, ale bez nasadených semien';
$string['stackInstall_testsuite_nogeneralfeedback'] = 'Otázky bez všeobecnej spätnej väzby: študenti oceňujú, keď otázky majú vypracované riešenia!';
$string['stackInstall_testsuite_notests'] = 'Otázky bez testov: pridajte nejaké!';
$string['stackInstall_testsuite_pass'] = 'Všetky testy prešli!';
$string['stackInstall_testsuite_title'] = 'Testovací balík pre testy odpovede STACK';
$string['stackOptions_AnsTest_values_AlgEquiv'] = 'Algebraický ekvivalent';
$string['stackOptions_AnsTest_values_Expanded'] = 'Rozšírený';
$string['stackOptions_AnsTest_values_SameType'] = 'Rovnaký typ';
$string['stackOptions_AnsTest_values_String'] = 'Reťazec';
$string['stackversionerroralt'] = 'Alternatíva je  {$a}.';
$string['stackversionnone'] = 'Táto otázka nebola zmenená, odkedy bolo zavedené číslovanie variantov otázok v STACK 4.2. Prosím, pozorne skontrolujte vašu otázku.';
$string['stackversionnow'] = 'Súčasná verzia STACK je {$a}.';
$string['stackversionregexp'] = 'Test odpovede RegExp nie je podporovaný po STACK verzii 4.3. Namiesto toho použite nový SRegExp.';
$string['stop'] = '[zastav]';
$string['strictsyntax'] = 'Prísna syntax';
$string['strictsyntax_help'] = 'Táto možnosť sa už nepoužíva a bude odstránená.';
$string['strictsyntax_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/';
$string['strlengtherror'] = 'Tento reťazec nesmie byť dlhší ako 255 znakov.';
$string['studentValidation_invalidAnswer'] = 'Táto odpoveď je nesprávna.';
$string['studentValidation_listofunits'] = 'Jednotky nájdené vo vašej odpovedi boli {$a}';
$string['studentValidation_listofvariables'] = 'Premenné nájdené vo vašej odpovedi boli: {$a}';
$string['studentValidation_notes'] = '(Tento vstup nie je automaticky vyhodnotený STACK-om.)';
$string['studentValidation_yourLastAnswer'] = 'Vaša posledná odpoveď bola interpretovaná nasledovne: {$a}';
$string['studentanswer'] = 'Odpoveď študenta';
$string['syntaxattribute_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['syntaxattributeplaceholder'] = 'Zástupný symbol';
$string['syntaxattributevalue'] = 'Hodnota';
$string['syntaxhint'] = 'Nápoveda syntaxe';
$string['syntaxhint_help'] = 'Nápoveda o syntaxe sa objaví v odpoveďovom poli vždy, keď to študent ponechá prázdne.';
$string['syntaxhint_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['tans'] = 'Odpoveď učiteľa (TAns)';
$string['tans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['tansrequired'] = 'Odpoveď učiteľa (TAns) musí byť prázdna.';
$string['teacheranswer'] = 'Odpoveď učiteľa (TAns)';
$string['teacheranswerempty'] = 'Tento vstup môže zostať prázdny.';
$string['teacheranswershow'] = 'Správna odpoveď je \\( {$a->display} \\), čo môže byť zadané ako: {$a->value}';
$string['teacheranswershow_disp'] = 'Správna odpoveď je {$a->display}.';
$string['teacheranswershow_mcq'] = 'Správna odpoveď je: {$a->display}.';
$string['teacheranswershownotes'] = 'Pre tento vstup nie je poskytnutá správna odpoveď.';
$string['teachersanswer'] = 'Modelová odpoveď';
$string['teachersanswer_help'] = 'Učiteľ musí pre každý vstup určiť vzorovú odpoveď. Musí to byť platný reťazec Maxima a môže byť vytvorený z premenných otázky.';
$string['teachersanswer_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#model_answer';
$string['testcasexresult'] = 'Testovací prípad {$a->no} {$a->result}';
$string['testingquestion'] = 'Testovacia otázka {$a}';
$string['testingquestionvariants'] = 'Príprava variantov otázok';
$string['testinputs'] = 'Testovacie vstupy';
$string['testinputsimpwarning'] = 'Upozorňujeme, že testovacie vstupy sú vždy <em>nezjednodušené</em> bez ohľadu na nastavenie otázky alebo možnosti PRT. Použite <tt>ev (...,simp)</tt> na zjednodušenie častí alebo všetkých testovacích vstupných výrazov.';
$string['testoptions'] = 'Možnosti testu';
$string['testoptions_help'] = 'Toto pole umožňuje odpoveďovým testom akceptovať možnosť, napr. premenná alebo numerická presnosť.';
$string['testoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['testoptionsinvalid'] = 'Možnosti (nastavenia) testu sú neplatné: {$a}';
$string['testoptionsrequired'] = 'Pre tento test sú potrebné možnosti (nastavenia) testu.';
$string['testpassesandfails'] = '{$a->passes} správne a {$a->fails} nesprávny.';
$string['testsuitecolerror'] = 'Chyby CAS';
$string['testsuitecolpassed'] = 'Prešiel ?';
$string['testsuitefail'] = 'Neprešiel';
$string['testsuitefeedback'] = 'Spätná väzba';
$string['testsuiteknownfail'] = 'Očakávané zlyhanie';
$string['testsuiteknownfailmaths'] = 'Očakávané zlyhanie (matematika)';
$string['testsuitenotests'] = 'Počet testov: {$a->no}.';
$string['testsuitepass'] = 'Prechod';
$string['testsuiteteststook'] = 'Testy trvali {$a->time} sekúnd.';
$string['testsuiteteststookeach'] = 'Priemer za test : {$a->time} sekúnd.';
$string['testthisvariant'] = 'Prepnite na testovanie tohto variantu';
$string['texdisplaystyle'] = 'Rovnica v tvare, ako sa zobrazí';
$string['texinlinestyle'] = 'Rovnica v riadku';
$string['tidyquestion'] = 'Nástroj tvorby otázok STACK: vyčistenie';
$string['tidyquestionx'] = 'Premenujte časti otázky {$a}';
$string['trig_degrees_radians_fact'] = '';
$string['trig_degrees_radians_name'] = 'Uhly a radiány';
$string['trig_standard_identities_name'] = 'Štandardná trigonometrická rovnosť';
$string['trig_standard_values_name'] = 'Štandardné trigonometrické hodnoty';
$string['true'] = 'Pravda';
$string['truebranch'] = 'Pravdivá vetva';
$string['undeploy'] = 'Zrušiť nasadenie';
$string['unrecognisedfactstags'] = 'Nasledujúce faktické značky (tágy) nie sú rozpoznané: {$a->tags}.';
$string['variant'] = 'Variant';
$string['variantsselectionseed'] = 'Náhodná skupina';
$string['variantsselectionseed_help'] = 'Toto políčko môžete zvyčajne nechať prázdne. Ak však chcete, aby dve rôzne otázky v kvíze používali rovnaké inicializácie generátora náhodných čísel, zadajte do tohto poľa rovnaký reťazec pre dve otázky (a nasadite rovnakú skupinu inicializácii, ak používate nasadené verzie) a inicializácie generátora náhodných čísel pre dve otázky budú synchronizované.';
$string['verifyquestionandupdate'] = 'Overte text otázky a aktualizujte formulár';
$string['version'] = 'Verzia';
$string['yamlrecommended'] = 'Pre STACK sa odporúča inštalácia knižnice YAML.';
$string['youmustconfirm'] = 'Tu musíte potvrdiť.';
