<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'treasurehunt', language 'pt', version '4.1'.
 *
 * @package     treasurehunt
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitytoend'] = 'Primeiro tem de completar a atividade selecionada';
$string['activitytoend_help'] = 'A atividade selecionada deve ser concluída antes que a dica atual seja mostrada.
Para que as atividades da disciplina sejam mostradas na lista deve ser ativada a conclusão das atividades na configuração do Moodle, na disciplina e na própria atividade.';
$string['activitytoendovercome'] = 'Atividade \'<strong>{$a}</strong>\' superada';
$string['activitytoendwarning'] = 'Primeiro deve completar a atividade por resolver';
$string['actnotavailableyet'] = 'A atividade ainda não está disponível';
$string['add'] = 'Adicionar';
$string['addingroad'] = 'A adicionar caminho';
$string['addingstage'] = 'A adicionar etapa';
$string['addroad_tour'] = 'Adicione um ou mais caminhos a serem percorridos pelos seus alunos.';
$string['addsimplequestion'] = 'Adicionar uma pergunta simples';
$string['addsimplequestion_help'] = 'Adiciona uma pergunta simples antes de mostrar a dica desta etapa';
$string['addstage_tour'] = 'Cada caminho deve ter duas ou mais etapas. Cada etapa fornece uma dica para descobrir a próxima.';
$string['aerialmap'] = 'Satélite';
$string['aerialview'] = 'Satélite';
$string['allowattemptsfromdate'] = 'Permitir tentativas a partir de';
$string['allowattemptsfromdate_help'] = 'Se ativar esta opção, os alunos não poderão jogar antes desta data.
Se desativar, os alunos poderão começar a jogar de imediato.';
$string['alwaysshowdescription'] = 'Mostrar sempre a descrição';
$string['alwaysshowdescription_help'] = 'Se desativada, a descrição acima da caça ao tesouro só ficará visível para os alunos na data "Permitir tentativas a partir de".';
$string['answerwarning'] = 'É necessário primeiro responder à pergunta';
$string['areyousure'] = 'Tem a certeza?';
$string['attempt'] = 'Tentativa';
$string['attempthistory'] = 'Histórico da tentativa';
$string['attemptsdeleted'] = 'Apagadas as tentativas de caça ao tesouro';
$string['autolocate_tour'] = 'Durante o jogo, pode geolocalizar-se usando o GPS do seu dispositivo com este botão. Dê permissões para usar "localização" quando solicitado.
Mostrar a sua <b>localização atual</b>.<br> (conceda permissões para usar a localização" quando solicitado)';
$string['availability'] = 'Disponibilidade';
$string['availableplayerstyles'] = 'Estilos de ecrã do jogo disponíveis.';
$string['back'] = 'Voltar';
$string['backtocourse'] = 'Voltar à disciplina';
$string['baselayers'] = 'Camadas de base';
$string['basemaps'] = 'Base dos mapas';
$string['bigbutton_play_tour'] = 'Este é o seu melhor amigo. <br>Um clique e irão aparecer <b>desafios</b> ou valiosas <b>dicas</b>.';
$string['browsemode'] = 'Explorar';
$string['cancel'] = 'Cancelar';
$string['changecamera'] = 'Mudar de câmara';
$string['changetogroupmode'] = 'O modo de jogo mudou para jogar em grupos';
$string['changetoindividualmode'] = 'O modo de jogo mudou para o jogo individual';
$string['changetoplaywithmove'] = 'O modo de jogo foi alterado para "Jogar com localização GPS".';
$string['changetoplaywithoutmoving'] = 'O modo de jogo mudou para o jogo estático';
$string['cleartreasurehunt'] = 'Repor a caça ao tesouro';
$string['cleartreasurehunt_done'] = 'A atividade foi reposta. Toda a atividade dos participantes foi apagada.';
$string['cleartreasurehuntconfirm'] = 'Tenha cuidado com esta ação. Se continuar, todas as atividades registadas serão apagadas. Normalmente, esta ação só é necessária se precisar alterar o número de caminhos ou etapas mas a atividade está bloqueada porque alguém já começou a jogar.';
$string['clue'] = 'Dica';
$string['completionfinish'] = 'É necessário terminar o caminho.';
$string['completionfinish_help'] = 'Está concluído quando o utilizador passar todas as etapas num caminho.';
$string['configintro'] = 'Os valores que definir aqui configuram os valores predefinidos que serão utilizados no formulário das configurações quando criar uma nova caça ao tesouro.';
$string['configmaximumgrade'] = 'Nota máxima predefinida para a classificação da caça ao tesouro.';
$string['confirm'] = 'Confirmar';
$string['confirmdeletestage'] = 'A etapa foi apagada com sucesso';
$string['continue'] = 'Continuar';
$string['correctanswer'] = 'Resposta correta.';
$string['customlayername'] = 'Título da camada';
$string['customlayername_help'] = 'Se usar uma camada personalizada, é necessário um título para mostrar nos mapas ou aos seus utilizadores. Se o título estiver vazio, a camada personalizada está totalmente desativada.';
$string['customlayerservicearcgis'] = 'Serviço Mosaicos REST do Arcgis (experimental)';
$string['customlayerserviceimage'] = 'Imagem carregada';
$string['customlayerservicetiled'] = 'Imagem XYZ em mosaico';
$string['customlayerservicetype'] = 'Tipo da camada personalizada';
$string['customlayerservicetype_help'] = 'A camada personalizada pode ser um serviço WMS, um servidor de mosaicos {x}{y}{z}, um serviço de mosaicos REST do ArcGIS (experimental) ou uma imagem carregada.';
$string['customlayerservicewms'] = 'Serviço WMS';
$string['customlayertype'] = 'Tipo de camada';
$string['customlayertype_help'] = 'A camada pode ser apenas visível em segundo plano ou pode ser uma camadas por cima da base predefinida dos mapas.';
$string['customlayerwms'] = 'URL do serviço web de mapa (WMS, servidor de mosaico XYZ)';
$string['customlayerwms_help'] = 'Usar uma camada de mapa de um serviço OGC WMS ou de um servidor de mosaicos REST do ArcGIS. Por exemplo: <ul><li>O WMS de Ecossistemas Florestais da EUNIS pode ser configurado da seguinte forma: WMS: <code style="overflow-wrap: break-word;word-wrap: break-word;">http://bio.discomap.eea.europa.eu/arcgis/services/Ecosystem/Ecosystems/MapServer/WMSServer</code> PARÂMETROS: <code>LAYERS=4</code>)</li><li>Serviço de mosaicos XYZ (apenas para Espanha) <code>https://tms-ign-base.idee.es/1.0.0/IGNBaseTodo/{z}/{x}/{-y}.jpeg</code></li><li>(Experimental) Os serviços de mosaicos REST do ArcGIS podem ser <code>http://services.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer</code> ou <code>https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer</code></li></ul>';
$string['custommapbaselayer'] = 'A imagem é mostrada como uma opção ADICIONAL do plano de fundo do mapa';
$string['custommapimageerror'] = 'Não é possível carregar a imagem personalizada. Verifique as configurações da atividade.';
$string['custommapimagefile'] = 'Imagem personalizada para o mapa';
$string['custommapimagefile_help'] = 'Carregue uma imagem de resolução suficiente e preencha os 4 campos seguintes com as coordenadas da projeção no chão';
$string['custommaplayertype'] = 'Tipo de camada personalizada';
$string['custommaplayertype_help'] = 'A camada personalizada pode ser a única visível no fundo ou pode ser sobreposta aos mapas base padrão.';
$string['custommapmaxlat'] = 'Latitude Norte';
$string['custommapmaxlat_help'] = 'Latitude Norte da imagem. Use "." como ponto decimal. Menor que 85 graus e maior que a latitude Sul.';
$string['custommapmaxlon'] = 'Longitude Este';
$string['custommapmaxlon_help'] = 'Longitude Este da imagem. Use "." como ponto decimal. Menor que 180 graus e maior que a longitude Oeste.';
$string['custommapminlat'] = 'Latitude Sul';
$string['custommapminlat_help'] = 'Latitude Sul da imagem. Use "." como ponto decimal. Maior que -85 graus e menor que a latitude Norte.';
$string['custommapminlon'] = 'Longitude Oeste';
$string['custommapminlon_help'] = 'Longitude Oeste da imagem. Use "." como ponto decimal. Maior que -180 graus e menor que a longitude Este.';
$string['custommapnolayer'] = 'Nenhum mapa personalizado';
$string['custommapnongeographic'] = 'A imagem não é geográfica e será a única camada no mapa.';
$string['custommaponlybaselayer'] = 'A imagem é mostrada como a ÚNICA opção do plano de fundo do mapa';
$string['custommapoverlaylayer'] = 'A imagem está renderizada acima do mapa predefinido';
$string['custommapping'] = 'Mapa personalizado';
$string['custompreserveaspectratio'] = 'Preservar a proporção';
$string['custompreserveaspectratio_help'] = 'Se ativar esta opção, a imagem será redimensionada (Este-Oeste) para se ajustar à latitude geográfica (Norte-Sul), mantendo a proporção. Isto é necessário para permitir que as imagens SVG sejam renderizadas sem pixelização.';
$string['customwmsparams'] = 'Parâmetros extra do Web map service';
$string['customwmsparams_help'] = 'Estes parâmetros definem a aparência do mapa. A configuração usa o seguinte formato: "LAYERS=background,streets;STYLES=blue,default" (Por exemplo EUNIS Forest Ecosystems WMS pode ser configurado por:
WMS: <code style="overflow-wrap: break-word;word-wrap: break-word;">http://bio.discomap.eea.europa.eu/arcgis/services/Ecosystem/Ecosystems/MapServer/WMSServer</code>
PARÂMETROS: <code>LAYERS=4</code>)';
$string['cutoffdate'] = 'Data limite';
$string['cutoffdate_help'] = 'Se definir uma data, a caça ao tesouro não aceitará tentativas após esta data sem uma extensão de prazo.';
$string['cutoffdatefromdatevalidation'] = 'A data limite deve ser após à data de permitir submissões.';
$string['datechanged'] = 'Data alterada';
$string['defaultplayerstyle'] = 'Estilo de ecrã do jogo predefinido';
$string['discoveredlocation'] = 'Localização encontrada';
$string['donetutorial'] = 'Fim';
$string['drawmode'] = 'Desenhar';
$string['editactivity_help'] = 'Pode encontrar um tutorial passo a passo sobre como criar atividades de caça ao tesouro <a href="http://juacas.github.io/moodle-mod_treasurehunt/create_activity.html"> nesta página.</a>';
$string['editend_tour'] = 'Aproveite para criar jogos emocionantes para os seus alunos!';
$string['editingroad'] = 'A editar caminho';
$string['editingstage'] = 'A editar etapa';
$string['editingtreasurehunt'] = 'A editar caça ao tesouro';
$string['edition'] = 'Painel de edição';
$string['edition_help'] = 'Para ativar a criação geométrica e os botões no painel de edição. A etapa que deseja editar deve ser selecionada';
$string['editmode'] = 'Editar';
$string['editroad'] = 'Editar caminho';
$string['editstage'] = 'Editar etapa';
$string['edittreasurehunt'] = 'Alterar caminhos e etapas';
$string['errcorrectanswers'] = 'Tem de selecionar uma resposta correta';
$string['errcorrectsetanswerblank'] = 'A resposta correta está definida, mas a resposta está em branco';
$string['erremptystage'] = 'Todas as etapas devem ter pelo menos uma geometria para que o caminho seja válido';
$string['errnocorrectanswers'] = 'Deve haver apenas uma resposta correta';
$string['errnumeric'] = 'Tem de inserir um número decimal válido';
$string['error'] = 'Erro';
$string['errpenalizationexceed'] = 'A penalização não pode ser superior a 100';
$string['errpenalizationfall'] = 'A penalização não pode ser inferior a 0';
$string['errsendinganswer'] = 'O caminho foi atualizado enquanto estava a enviar a resposta. Tente novamente.';
$string['errsendinglocation'] = 'O caminho foi atualizado enquanto estava a enviar a localização. Tente novamente';
$string['errvalidroad'] = 'Deve haver pelo menos duas etapas que tenham pelo menos uma geometria para que o caminho seja válido';
$string['eventattemptsubmitted'] = 'Tentativa submetida';
$string['eventattemptsucceded'] = 'Etapa concluída';
$string['eventhuntsucceded'] = 'Caça ao tesouro concluída com sucesso.';
$string['eventplayerentered'] = 'Jogador iniciou';
$string['eventroadcreated'] = 'Caminho criado';
$string['eventroaddeleted'] = 'Caminho apagado';
$string['eventroadupdated'] = 'Caminho atualizado';
$string['eventstagecreated'] = 'Etapa criada';
$string['eventstagedeleted'] = 'Etapa apagada';
$string['eventstageupdated'] = 'Etapa atualizada';
$string['exit'] = 'Voltar à disciplina';
$string['failedlocation'] = 'Falha na localização';
$string['faillocation'] = 'Não é o local correto';
$string['findplace'] = 'Procurar um lugar';
$string['gamemode'] = 'Modo do jogo';
$string['gamemodeinfo'] = 'Modo de jogo: {$a}';
$string['gameupdatetime'] = 'Tempo de atualização do jogo';
$string['gameupdatetime_help'] = 'Intervalo de tempo, em segundos, entre as atualizações do jogo de um utilizador.
Deve ser o maior possível para serem feitos poucos pedidos de atualização, mas mais tempo passará para relatar uma possível alteração.
Deve ser superior a 0 segundos, mas o tempo será definido por predefinição.';
$string['geolocation_needed'] = 'Para jogar este jogo, é necessária a sua localização geográfica.
<p>Para ativar, vá às configurações do seu navegador-> Configurações do site->Localização e remova a evicção para este site.
<p>De seguida, recarregue esta página e responda "SIM" quando o seu navegador lhe solicitar se deseja partilhar a sua localização.
<p>Para usar o GPS para localizar este dispositivo durante o jogo, o servidor deve ser acedido por um URL HTTPS seguro. Além disso, apenas o modo "Jogar sem movimentar" pode ser usado e os jogadores precisam de apontar manualmente cada etapa no mapa. Entre em contacto com o seu administrador se não conseguir resolver este problema.';
$string['geolocation_needed_title'] = 'Esta aplicação precisa de geolocalização';
$string['geolocation_problem'] = 'A localização por GPS está com problemas.';
$string['grade_explaination_fromabsolutetime'] = '{$a->rawscore}-{$a->penalization}%: Terminou a caça ao tesouro em {$a->yourtime}. O melhor tempo foi {$a->besttime}. Foi penalizado em {$a->penalization}% devido a {$a->nolocationsfailed} locais errados e {$a->noanswersfailed} respostas erradas.';
$string['grade_explaination_fromposition'] = '{$a->rawscore}-{$a->penalization}%: Descobriu {$a->nosuccessfulstages} etapas na posição {$a->position}. Foi penalizado em {$a->penalization}% devido a {$a->nolocationsfailed} locais errados e {$a->noanswersfailed} respostas erradas.';
$string['grade_explaination_fromstages'] = '{$a->rawscore}-{$a->penalization}%: Descobriu {$a->nosuccessfulstages} de {$a->nostages} etapas. Foi penalizado em {$a->penalization}% devido a {$a->nolocationsfailed} locais errados e {$a->noanswersfailed} respostas erradas.';
$string['grade_explaination_fromtime'] = '{$a->rawscore}-{$a->penalization}%: Gastou {$a->yourtime} para completar a caça ao tesouro. O melhor tempo foi {$a->besttime}. Teve uma penalização de {$a->penalization}% devido a {$a->nolocationsfailed} locais errados e {$a->noanswersfailed} respostas erradas.';
$string['grade_explaination_temporary'] = 'Caça ao tesouro não terminada. Obteve 50% da pontuação das etapas: {$a->rawscore}- {$a->penalization}%: Descobriu {$a->nosuccessfulstages} de {$a->nostages} etapas. Foi penalizado em {$a->penalization}% devido a {$a->nolocationsfailed} locais errados e {$a->noanswersfailed} respostas erradas.';
$string['gradefromabsolutetime'] = 'Avaliação pela duração da caça';
$string['gradefromposition'] = 'Avaliação pela posição na classificação';
$string['gradefromstages'] = 'Avaliação pelas etapas';
$string['gradefromtime'] = 'Avaliação pelo tempo final';
$string['grademethod'] = 'Método de avaliação';
$string['grademethod_help'] = '<p><b>Avaliação pelas etapas</b></p>
<p>Cada jogador (ou equipa) é avaliado proporcionalmente pelo número de etapas resolvidas, sendo 100% quando um caminho está completamente resolvido e 0% quando nenhuma etapa está resolvida.</p>
<p><b>Avaliação pela duração da caça</b></p>
<p>O "caçador" que termina o caminho em menos tempo ganha a corrida e obtém o melhor tempo. O medição do tempo é feita a partir do momento em que a etapa inicial é desbloqueada. Isto significa que os participantes podem jogar em momentos diferentes. A nota é calculada interpolando o tempo final, sendo 50% o tempo final da caça e 100% o melhor tempo final. Os jogadores que não terminem a caça recebem uma nota inferior a 50 calculada apenas pelo número de etapas resolvidas.</p>
<p><b>Avaliação pelo tempo final</b></p>
<p>O "caçador" que termina em primeiro lugar é o vencedor da caça. Supõe-se que todos os caçadores jogam simultaneamente. A nota é calculada interpolando o tempo final, sendo 50% o tempo final da caça e 100% o melhor tempo final. Os jogadores que não terminaem a caça recebem uma nota inferior a 50 calculada apenas pelo número de etapas resolvidas.</p>
<p><b>Avaliação pela posição na classificação</b></p>
<p>A pontuação é calculada interpolando a posição na grelha, sendo 100% a pontuação para o primeiro jogador e 50% para o último jogador.
Os jogadores que não terminem a caça recebem uma nota inferior a 50% calculada apenas pelo número de etapas resolvidas.</p>';
$string['grademethodinfo'] = 'Método de avaliação: {$a->type}. Penalização de localização: {$a->gradepenlocation}%. Penalização de resposta: {$a->gradepenanswer}%';
$string['gradepenanswer'] = 'Penalização por errar na resposta';
$string['gradepenlocation'] = 'Penalização por falhar na localização';
$string['gradepenlocation_help'] = 'A penalização é expressa em % da nota. Por exemplo, se a penalização for 5.4, um jogador com 3 falhas penalizará a sua nota em 16,2%, ou seja, receberá 83,8% da nota calculada pelo resto dos critérios.';
$string['gradesdeleted'] = 'Apagadas as avaliações da caça ao tesouro';
$string['gradingsummary'] = 'Resumo da avaliação';
$string['group'] = 'Grupo';
$string['groupactivityovercome'] = 'Atividade para a etapa {$a->position} foi concluída com sucesso por {$a->user}  {$a->date}';
$string['groupid'] = 'Grupo atribuído ao caminho';
$string['groupid_help'] = 'Os utilizadores deste grupo são atribuídos a este caminho quando o jogo começar. Se houver apenas um caminho e a opção selecionada for "Nenhum", todos os participantes da atividade poderão jogar';
$string['groupingid'] = 'Agrupamento atribuído ao caminho';
$string['groupingid_help'] = 'Os grupos deste agrupamento serão atribuídos a este caminho quando o jogo começar';
$string['groupinvalidroad'] = '{$a} atribuiu um caminho inválido.';
$string['grouplocationfailed'] = '<b>Ocorreu um erro cal localização da "etapa {$a->position}"</b> por {$a->user} {$a->date}';
$string['grouplocationovercome'] = '<b>Localização bem sucedida na etapa {$a->position}</b> por {$a->user} {$a->date}';
$string['groupmode'] = 'Alunos jogam em grupo';
$string['groupmode_help'] = 'Se ativar esta opção, os alunos serão divididos em grupos com base na configuração dos grupos das disciplinas.
Qualquer membro da equipa pode resolver a etapa atual e o progresso é comum a todos os elementos do grupo.<br/>
Permite "paralelizar" a caça e abranger mais área. Os participantes vêem a mesma informação, mas orientados pela equipa.';
$string['groupmultipleroads'] = '{$a} tem mais de um caminho atribuído.';
$string['groupquestionfailed'] = '<b>Resposta incorreta na etapa \'{$a->position}\'</b> por {$a->user} - {$a->date}';
$string['groupquestionovercome'] = '<b>Resposta correta na etapa \'{$a->position}\'</b> por {$a->user} - {$a->date}';
$string['groups'] = 'Grupos';
$string['groupstageovercome'] = '<b>Etapa {$a->position} superada</b> por {$a->user} {$a->date}';
$string['hello'] = 'Olá';
$string['history'] = 'Histórico';
$string['huntcompleted'] = 'Já completou esta caça ao tesouro';
$string['incorrectanswer'] = 'Resposta incorreta.';
$string['info'] = 'Informação';
$string['infovalidatelocation'] = 'Validar a localização desta etapa';
$string['invalidassignedroad'] = 'O caminho especificado não está validado';
$string['invalroadid'] = 'O caminho não está validado';
$string['lastsuccessfulstage_tour'] = 'Neste painel, pode verificar a sua última etapa bem sucedida. Pode ser sua a etapa bem sucedida do seu grupo.';
$string['layers'] = 'Camadas';
$string['loading'] = 'A carregar';
$string['localizationbuttondisabled'] = 'Desativar botão de localização';
$string['localizationbuttondisabled_help'] = 'Se selecionada, o botão de localização será desativado na interface do leitor.';
$string['lockactivitiessection'] = 'Restringir as atividades apenas a esta etapa.';
$string['lockactivity'] = 'Permitir apenas nesta etapa';
$string['lockactivity_help'] = 'Bloquear o acesso às atividades selecionadas se o utilizador não estiver nesta etapa. Esta definição define automaticamente as restrições para as atividades escolhidas. AVISO: Esta opção apenas oferece uma configuração automática básica. Se editar manualmente as restrições de uma atividade, esta poderá deixar de aparecer aqui e a configuração automática poderá não funcionar.';
$string['lockactivityannounce'] = 'Se o módulo <a href="https://github.com/juacas/moodle-availability_treasurehunt">Condição de acesso com base na Caça ao tesouro</a> estiver ativado neste site, pode tornar qualquer atividade indisponível quando o utilizador não estiver a trabalhar nesta etapa.';
$string['lockedaclue'] = 'Tem de completar a atividade \'<strong>{$a}</strong>\' para desbloquear a dica';
$string['lockedaqclue'] = 'Tem de completar a atividade \'<strong>{$a}</strong>\' e responder corretamente à seguinte questão para desbloquear a dica';
$string['lockedclue'] = 'Dica bloqueada';
$string['lockedqclue'] = 'Tem de responder corretamente à seguinte questão para desbloquear a dica';
$string['locktimeediting'] = 'Bloqueio do tempo de edição';
$string['locktimeediting_help'] = 'Tempo em segundos com o qual um utilizador pode editar uma instância sem renovar o bloqueio.
Deve ser o maior possível para serem feitos poucos pedidos de renovação de bloqueio, mas mais tempo é bloqueada a página de edição assim que o utilizador termina.
Deve ser superior a 5 segundos, mas o tempo será definido por predefinição.';
$string['map_tour'] = 'Neste mapa pode gerir todos os componentes de um divertido jogo com geolocalização.';
$string['mapplay_tour'] = 'O <b>map</b>mostra todas as suas tentativas!<br>Etapas superadas: <img src="pix/success_mark.png" width="28"/><br>Etapas não superadas: <img src="pix/failure_mark.png" width="28"/>';
$string['mapplaymobile_tour'] = 'O <b>mapa</b> mostra todas as suas tentativas! <br>Com sucesso: <img src="{$a->successurl}" width="28"/><br>Não conseguidas: <img src="{$a->failureurl}" width="28"/>';
$string['mapview'] = 'Vista do mapa';
$string['modify'] = 'Modificar';
$string['modulename'] = 'Caça ao tesouro';
$string['modulename_help'] = 'Este módulo será usado para executar uma atividade de geolocalização.
Pode ser exterior, interior ou com mapas virtuais de caça ao tesouro com geolocalização e códigos QR.
Este módulo para o Moodle permite organizar jogos ao ar livre com os seus alunos.
Caça ao tesouro implementa uma aplicação de jogo baseada no navegador (não é necessário instalar qualquer aplicação nativa) e um editor geográfico para codificar as etapas do jogo.
O jogo pode ser configurado com uma gama de opções que tornam o módulo muito flexível e útil em muitas situações: individual/equipa,
movimentação/marcação no pc, pontuar a partir do tempo obtido, posição, conclusão, etc.
<p><b><a href = "https://juacas.github.io/moodle-mod_treasurehunt/index.html"> Mais informações na apresentação e no tutorial online. </a></p></b>';
$string['modulenameplural'] = 'Caças ao tesouro';
$string['movingplay'] = 'Jogar em movimento';
$string['multiplegroupingsplay'] = 'O seu grupo atribuiu mais de um caminho, por isso não possa jogar a atividade.';
$string['multiplegroupsplay'] = 'Atribuiu mais de um caminho, por isso não pode jogar a atividade.';
$string['multiplegroupssameroadplay'] = 'Pertence a mais de um grupo atribuído ao mesmo caminho, por isso não pode jogar a atividade.';
$string['multipleteamsplay'] = 'Membro de mais de um grupo, por isso, incapaz de realizar a atividade.';
$string['mustanswerquestion'] = 'Tem de responder corretamente à pergunta antes de continuar';
$string['mustcompleteactivity'] = 'Tem de superar a atividade a concluir antes de continuar';
$string['mustcompleteboth'] = 'Tem de responder corretamente à pergunta e superar a atividade a concluir antes de continuar';
$string['nextcamera'] = 'Mudar de câmara';
$string['nextstep'] = 'Seguinte';
$string['noanswerselected'] = 'Tem de selecionar uma resposta';
$string['noattempts'] = 'Ainda não fez nenhuma tentativa';
$string['noexsitsstage'] = 'Não existe a etapa número {$a} na base de dados. Recarregue a página';
$string['nogroupassigned'] = 'Nenhum grupo atribuído a este caminho';
$string['nogroupingplay'] = 'Não tem nenhum grupo atribuído ao caminho, por isso não pode jogar a atividade.';
$string['nogroupplay'] = 'Não tem nenhum caminho atribuído, por isso não pode jogar a atividade.';
$string['nogrouproad'] = '\'{$a}\' não tem caminhos atribuidos.';
$string['nomarks'] = 'Primeiro marque no mapa o ponto desejado. Coloque o <img src="pix/my_location.png" width="28"/>';
$string['nomarksmobile'] = 'Marque primeiro no mapa o ponto desejado.';
$string['noresults'] = 'Nenhum resultado encontrado';
$string['noroads'] = 'Ainda não foram adicionados caminhos';
$string['notchangeorderstage'] = 'Não pode alterar a ordem das etapas depois de serem feitas tentativas no caminho';
$string['notcreatestage'] = 'Já foram feitas tentativas neste caminho, não pode adicionar mais etapas';
$string['notdeletestage'] = 'Já foram feitas tentativas neste caminho, não pode apagar qualquer etapa';
$string['noteam'] = 'Não é membro de qualquer grupo';
$string['notreasurehunts'] = 'Não existe caça ao tesouro nesta disciplina';
$string['nouserassigned'] = 'Nenhum utilizador atribuído a este caminho';
$string['nouserattempts'] = '{$a} não fez nenhuma tentativa';
$string['nouserroad'] = '\'{$a}\' não tem nenhum caminho atribuído.';
$string['nousersprogress'] = 'Nenhum utilizador/grupo avançou neste caminho.';
$string['outoftime'] = 'Fora do prazo';
$string['overcomefirststage'] = 'Para descobrir a primeira etapa, deve começar a partir da área marcada no mapa';
$string['overlaylayers'] = 'Camadas de sobreposição';
$string['pegmanlabel'] = 'Visualize no StreetView';
$string['play'] = 'Jogar';
$string['playend_tour'] = '<span style = "font-size: 1.5em; font-weight: bold">Aprecie a caça ao tesouro</span><br>com os seus companheiros!';
$string['playerbootstrap'] = 'Bootstrap';
$string['playerclassic'] = 'Clássico';
$string['playerhelp_tour'] = 'Esta demonstração ao utilizador pode ser visualizada sempre que pretender.';
$string['playerstyle'] = 'Estilo de ecrã do jogo';
$string['playerstyle_help'] = 'Podem existir vários estilos de ecrã de jogo que os professores podem escolher.';
$string['playstagewithoutmoving'] = 'Descobrir a etapa sem se movimentar';
$string['playstagewithoutmoving_help'] = 'Se ativar esta opção, os alunos podem descobrir esta etapa sem se movimentarem para qualquer lugar.
Para fazer isso, cada vez que o aluno faz um simples clique no mapa é criada uma marca a indicar o último ponto desejado, apagando a anterior, se existir. Após a conclusão da etapa, o jogo mudará para as configurações predefinidas da atividade';
$string['playstagewithqr'] = 'Descobrir a etapa ao ler este texto QR';
$string['playstagewithqr_help'] = 'Se esta opção tiver um valor, os alunos podem descobrir esta etapa se lerem um código QR disponível neste local.';
$string['playwithoutmoving'] = 'Jogar sem movimentar';
$string['playwithoutmoving_help'] = 'Se ativar esta opção, os alunos podem jogar dos seus computadores sem se deslocarem para os locais. Para fazer isso, toda a vez que o aluno faz um simples clique no mapa é criada uma marca, apagando a anterior se houver, indicando o último ponto desejado.';
$string['pluginadministration'] = 'Administração da caça ao tesouro';
$string['pluginname'] = 'Caça ao tesouro';
$string['preview'] = 'Pré-visualização';
$string['prevstep'] = 'Anterior';
$string['qrreaded'] = 'Código QR lido:';
$string['question'] = 'Pergunta';
$string['remove'] = 'Apagar';
$string['remove_tour'] = 'Pode apagar partes das geometrias dos locais. Basta selecionar um polígono e, depois, pressionar este botão.';
$string['removealltreasurehuntattempts'] = 'Apagadas todas as tentativas de caças ao tesouro';
$string['removedactivitytoend'] = 'Foi apagada a atividade a completar';
$string['removedquestion'] = 'A pergunta foi apagada';
$string['removeroadwarning'] = 'Se apagar o caminho, todas as etapas associadas serão apagadas e não será possível recuperar';
$string['removewarning'] = 'Se remover, não poderá recuperar';
$string['restrictionsdiscoverstage'] = 'Restrições para descobrir a etapa';
$string['reviewofplay'] = 'Rever o jogo';
$string['road'] = 'Caminho';
$string['roadended'] = 'Este caminho está completo. Parabéns! Fez a caça ao tesouro. Pode verificar o seu histórico no mapa.';
$string['roadmap'] = 'Caminho';
$string['roadname'] = 'Nome do caminho';
$string['roads_tour'] = 'Nesta área encontrará os diferentes caminhos do seu jogo. Selecione um deles para editar as etapas.';
$string['roadview'] = 'Caminho';
$string['save'] = 'Guardar';
$string['save_tour'] = 'Depois de desenhar os seus locais, não se esqueça de guardar as alterações.';
$string['saveemptyridle'] = 'Todas as etapas modificadas devem ter geometria antes de guardar';
$string['savewarning'] = 'Não gravou as alterações.';
$string['scanQR_generatebutton'] = 'Criar código QR';
$string['scanQR_scanbutton'] = 'Ler código QR';
$string['search'] = 'Procurar';
$string['searching'] = 'A procurar';
$string['searchlocation'] = 'Procurar localização';
$string['searchlocation_tour'] = 'Nesta área de pesquisa pode encontrar o seu caminho rapidamente';
$string['searchpaneldisabled'] = 'Desativar o painel de pesquisa no leitor';
$string['searchpaneldisabled_help'] = 'Se selecionada, a barra de pesquisa será desativada na interface do leitor.';
$string['send'] = 'Enviar';
$string['sendlocationcontent'] = 'Essa ação não pode ser desfeita.';
$string['sendlocationtitle'] = 'Tem a certeza de que pretende enviar esta localização?';
$string['showboard'] = 'Mostrar progresso dos outros alunos';
$string['showboard_help'] = 'Se ativar esta opção, o progresso dos outros alunos será mostrado na página de atividades.';
$string['showclue'] = 'Mostra dica';
$string['showdistancehint'] = 'Mostrar dica de distância';
$string['showdistancehint_help'] = 'Se estiver ativada, a opção apresenta uma indicação da distância até à etapa seguinte.
Esta indicação será apresentada na interface do jogador quando o utilizador estiver próximo da etapa seguinte.';
$string['showheadinghint'] = 'Mostrar dica de direção';
$string['showheadinghint_help'] = 'Se ativada, a opção apresentará uma dica sobre a direção para a etapa seguinte.
Esta dica será apresentada na interface do jogador quando o utilizador estiver próximo da etapa seguinte.';
$string['showinzonehint'] = 'Mostrar dica de zona';
$string['showinzonehint_help'] = 'Se ativada, a dica será apresentada ao jogador quando este estiver na zona da etapa seguinte.
Esta dica será mostrada na interface do jogador quando o utilizador estiver na zona da etapa seguinte.';
$string['shownextareahint'] = 'Mostrar dica da próxima área';
$string['shownextareahint_help'] = 'Se ativada, a opção permitirá ao jogador visualizar a área da etapa seguinte.';
$string['skiptutorial'] = 'Sair';
$string['stage'] = 'Etapa';
$string['stageclue'] = 'Dica para localizar a próxima etapa';
$string['stageclue_help'] = 'Aqui deve indicar a dica para chegar ao próximo local.
Caso seja a última etapa, deve deixar uma mensagem de feedback indicando que a caça ao tesouro terminou.';
$string['stagename'] = 'Nome da etapa';
$string['stageovercome'] = 'Etapa superada';
$string['stages'] = 'Etapas';
$string['stages_tour'] = 'Nesta área encontrará as etapas do caminho selecionado. Selecione cada etapa para ampliar a localização atual no mapa e comece a editar as suas geometrias clicando nelas e nos botões Editar/Desenhar acima.';
$string['start'] = 'Iniciar';
$string['startfromhere'] = 'Só pode começar a partir daqui';
$string['state'] = 'Estado';
$string['successlocation'] = 'É o lugar certo!';
$string['timeago'] = '{$a->shortduration} atrás';
$string['timeagolong'] = '{$a->shortduration} atrás ({$a->date})';
$string['timeat'] = 'em {$a->date}';
$string['timeexceeded'] = 'Excedeu o tempo limite para a atividade. Este janela serve apenas para rever o jogo';
$string['timetocome'] = 'daqui a {$a->shortduration}';
$string['timetocomelong'] = 'daqui a {$a->shortduration} ({$a->date})';
$string['totalprogress'] = 'Progresso total';
$string['totaltime'] = 'Tempo total';
$string['trackusers'] = 'Rastrear trajetórias';
$string['trackusers_help'] = 'Registar os caminhos criados pelos utilizadores. Eles podem ser vistos na janela "Visualizador de trilhos".<br/>
As posições do utilizador são registadas entre tentativas de validação (com todas as solicitações de pesquisa).<br/>
Se o utilizador tiver o GPS desativado, o único local que ele poderá denunciar é o dos códigos QR digitalizados.<br/>
Se esta opção estiver <b>desativada</b>, os únicos locais registados são os das tentativas de validação.';
$string['trackviewer'] = 'Seguir participantes';
$string['trackviewerrefreshtracks'] = 'Atualizar trajetórias a cada {$a} segundos.';
$string['treasurehunt'] = 'Caça ao tesouro';
$string['treasurehunt:addinstance'] = 'Adicionar nova caça ao tesouro';
$string['treasurehunt:addroad'] = 'Adicionar caminho';
$string['treasurehunt:addstage'] = 'Adicionar etapa';
$string['treasurehunt:editroad'] = 'Editar caminho';
$string['treasurehunt:editstage'] = 'Editar etapa';
$string['treasurehunt:enterplayer'] = 'Acesso à interface do jogador';
$string['treasurehunt:managetreasure'] = 'Gerir Caça ao tesouro';
$string['treasurehunt:managetreasurehunt'] = 'Gerir Caça ao tesouro';
$string['treasurehunt:play'] = 'Jogar';
$string['treasurehunt:view'] = 'Ver a Caça ao tesouro';
$string['treasurehunt:viewusershistoricalattempts'] = 'Ver histórico da tentativa dos utilizadores';
$string['treasurehuntclosed'] = 'Esta caça ao tesouro terminou {$a}';
$string['treasurehuntcloses'] = 'Esta caça ao tesouro termina em';
$string['treasurehuntcloseson'] = 'Esta caça ao tesouro irá terminar {$a}';
$string['treasurehuntislocked'] = 'Neste momento {$a} está a editar esta caça ao tesouro. Tente editar daqui a alguns minutos.';
$string['treasurehuntname'] = 'Nome da caça ao tesouro';
$string['treasurehuntnotavailable'] = 'A caça ao tesouro estará disponível {$a}';
$string['treasurehuntopenedon'] = 'Esta caça ao tesouro iniciou {$a}';
$string['treasurehuntopens'] = 'A caça ao tesouro inicia em';
$string['updates'] = 'Atualizações';
$string['updatetimes'] = 'Atualização dos tempos';
$string['user'] = 'Utilizador';
$string['useractivityovercome'] = '<b>Atividade Moodle para a etapa \'{$a->position}\' foi concluída com sucesso</b> {$a->date}';
$string['userattempthistory'] = 'Histórico da tentativa de {$a}';
$string['userinvalidroad'] = '\'{$a}\' atribuiu um caminho inválido.';
$string['userlocationfailed'] = '<b>Falha na localização da "etapa {$a->position}"</b> - {$a->date}';
$string['userlocationovercome'] = '<b>Localização bem sucedida da etapa \'{$a->position}\'</b> {$a->date}';
$string['usermultipleroads'] = '\'{$a}\' tem mais de um caminho atribuido.';
$string['usermultiplesameroad'] = '\'{$a}\' pertence a mais de um grupo atribuído ao mesmo caminho.';
$string['userprogress'] = 'Progresso do utilizador foi atualizado com sucesso';
$string['userquestionfailed'] = '<b>Resposta incorreta à etapa \'{$a->position}\'</b> - {$a->date}';
$string['userquestionovercome'] = '<b>Resposta correta à etapa \'{$a->position}\'</b> - {$a->date}';
$string['usersprogress'] = 'Progresso do utilizador';
$string['usersprogress_help'] = 'Indica o progresso das etapas de cada aluno/grupo de alunos de acordo com as cores:
<p>A cor <b>verde</b> indica que a etapa foi superada sem falhas.</p>
<p>A cor <b>amarelo</b> indica que a etapa foi superada com falhas.</p>
<p>A cor <b>vermelho</b> indica que a etapa não foi superada e houve várias falhas.</p>
<p>A cor <b>cinzento</b> indica que a etapa não foi superada e que nenhuma falha foi cometida.</p>';
$string['userstageovercome'] = '<b>Etapa {$a->position} superada</b> - {$a->date}';
$string['validatelocation'] = 'Validar localização';
$string['validatelocation_tour'] = 'Tem a certeza sobre a localização de uma etapa?<br><b>Envie a sua posição</b> e verifique se está correto.';
$string['validateqr'] = 'Ler código QR';
$string['warmatchanswer'] = 'A resposta não corresponde à pergunta';
$string['warnqrscanner'] = '<table><tr><td>Esta caça ao tesouro inclui {$a} etapa(s) com código QR. Certifique-se de que o seu dispositivo consegue ler códigos QR a partir do navegador web. Uma visão da câmara deverá aparecer abaixo. Tente ler qualquer código QR como o que é aqui apresentado.</td><td> <a href="pix/qr.png">
<img src="pix/qr.png" align="top" width="100"></a></td></tr></table>';
$string['warnqrscannererror'] = 'Esta caça ao tesouro inclui {$a} etapas com códigos QR.
Parece que o seu dispositivo não pode usar a câmara com esta aplicação. Por favor, dê permissões para aceder à câmara.
Se não conseguir ativar a câmara, o dispositivo pode não ser adequado para jogar a Caça ao Tesouro.';
$string['warnqrscannersuccess'] = 'Esta Caça ao Tesouro inclui {$a} etapas com QRCodes.
Aparentemente passou num teste QR com este dispositivo.';
$string['warnunsecuregeolocation'] = 'A geolocalização poderá não funcionar no seu servidor. Esta é uma situação <b>GRAVE</b> causada pela má configuração do seu servidor. A geolocalização é proibida para servidores não protegidos, que usam HTTP em vez de HTTPS. Para usar o GPS e localizar os alunos durante o jogo, o servidor deve ser acedido por um URL HTTPS seguro. Além disso, apenas o modo "Jogar sem movimentar" pode ser usado e os jogadores precisam de apontar manualmente cada etapa no mapa. Contacte com o administrador. (Referências <a href="https://www.chromestatus.com/feature/5636088701911040">Chrome</a>, <a href="https://blog.mozilla.org/security/2015/04/30/deprecating-non-secure-http/">Firefox</a>)';
$string['warnusersgroup'] = 'Os seguintes utilizadores pertencem a mais de um grupo: {$a}, portanto, não conseguem "jogar" a atividade.';
$string['warnusersgrouping'] = 'Os seguintes grupos pertencem a mais de um agrupamento: {$a}, portanto, não conseguem "jogar" a atividade.';
$string['warnusersoutside'] = 'Os seguintes utilizadores não pertencem a nenhum grupo/agrupamento: {$a}, por isso, não conseguem "jogar" a atividade.';
$string['webserviceerror'] = 'Ocorreu um erro na comunicação com o servidor. Pode ser um problema temporário; tente novamente mais tarde. Se o problema persistir, contacte o administrador.';
$string['welcome_edit_tour'] = 'Bem-vindo(a) à página inicial da caça ao tesouro.';
$string['welcome_play_tour'] = '<span style="font-size: 1.5em; font-weight: bold">Bem-vindo à Caça ao tesouro!</span><br>Este mapa e as dicas serão o seu guia.';
