<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_arialist', language 'pt', version '4.1'.
 *
 * @package     theme_arialist
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
	<div class="theme_screenshot">

		<h2>Arialist</h2>
		<img src="arialist/pix/screenshot.png" />

		<h3>Fórum sobre os Temas:</h3>
		<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

		<h3>Autores do Tema</h3>
		<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>

		<h3>Documentação sobre o Tema:</h3>
		<p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p>

		<h3>Reporte um bug:</h3>
		<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
	</div>

	<div class="theme_description">

		<h2>Descrição</h2>
		<p>Arialist é um tema muito simples com duas colunas.</p>

		<h2>Especificações</h2>
		<p>Este tema é construído sobre o temas Base do Moodle Base e Canvas. Se desejar modificar este tema, recomendamos que o duplique e altere o nome antes de fazer as suas alterações. Assim, evita que o seu tema personalizado seja substituído em atualizações futuras do Moodle e ainda guarda os arquivos originais se fizer algum erro. Pode consultar mais informações sobre como modificar temas em <a href="http://docs.moodle.org/en/Theme">MoodleDocs</a></p>
	<h2>Autores</h2>
	<p>Este tema foi desenvolvido e é mantido por Patrick Malley da NewSchool Learning. Pode contatá-lo através do e-mail contact@newschoollearning.com.</p>
		<h2>Licença</h2>
		<p>Este e todos os outros temas incluídos no core do Moodle, são licenciados sob a <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.
	</div>
</div>';
$string['configtitle'] = 'Configurações do tema Arialist';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Qualquer CSS que inserir aqui será adicionado a cada página permitindo-o personalizar facilmente o seu tema.';
$string['linkcolor'] = 'Cor dos links';
$string['linkcolordesc'] = 'Configura a cor dos links para o tema';
$string['logo'] = 'Logótipo';
$string['logodesc'] = 'Insira o URL de uma imagem para usar como logótipo para este site. Deve ser http://www.yoursite.com/path/to/logo.png';
$string['pluginname'] = 'Arialist';
$string['region-side-post'] = 'Direita';
$string['region-side-pre'] = 'Esquerda';
$string['regionwidth'] = 'Largura da coluna';
$string['regionwidthdesc'] = 'Esta opção define a largura das duas regiões dos blocos que formam as colunas da esquerda e direita.';
$string['tagline'] = 'Slogan';
$string['taglinedesc'] = 'Insira um curto slogan para ser exibido acima do nome do site na página principal. <br /><em>(Não será exibido como logótipo.)</em>';
