<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'sl', version '4.1'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aggregategrades'] = 'Ponovno izračunajte ocene';
$string['aggregation'] = 'Združevanje ocen';
$string['allocate'] = 'Dodelite prispevke';
$string['allocatedetails'] = 'pričakovano: {$a->expected}<br />oddano: {$a->submitted}<br />dodeliti: {$a->allocate}';
$string['allocation'] = 'Dodelitev prispevka';
$string['allocationconfigured'] = 'Dodelitev je konfigurirana';
$string['allocationdone'] = 'Dodelitev je končana';
$string['allocationerror'] = 'Napaka pri dodelitvi';
$string['allowedfiletypesforoverallfeedback'] = 'Dovoljeni tipi datotek priponk v pripombi';
$string['allowedfiletypesforoverallfeedback_help'] = 'Tipi datotek priponk v pripombi se lahko opredelijo s seznamom dovoljenih tipov datotek. Če je polje prazno, bodo dovoljeni vsi formati.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'Dovoljeni tipi datotek priponk v prispevku';
$string['allowedfiletypesforsubmission_help'] = 'Tipi datotek priponk v prispeveku se lahko opredelijo s seznamom dovoljenih tipov datotek. Če je polje prazno, bodo dovoljeni vsi formati.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'Vsi prispevki ({$a})';
$string['alreadygraded'] = 'Že ocenjeno';
$string['areaconclusion'] = 'Zaključno besedilo';
$string['areainstructauthors'] = 'Navodila za oddajo';
$string['areainstructreviewers'] = 'Navodila za vrednotenje';
$string['areaoverallfeedbackattachment'] = 'Skupne priponke pripomb';
$string['areaoverallfeedbackcontent'] = 'Skupno besedilo pripomb';
$string['areasubmissionattachment'] = 'Priponke prispevka';
$string['areasubmissioncontent'] = 'Besedila prispevkov';
$string['assess'] = 'Vrednoti';
$string['assessedexample'] = 'Vrednoten vzorčni prispevek';
$string['assessedsubmission'] = 'Vrednoten prispevek';
$string['assessingexample'] = 'Vrednotenje vzorčnega prispevka';
$string['assessingsubmission'] = 'Vrednotenje prispevka';
$string['assessment'] = 'Vrednotenje';
$string['assessmentby'] = 'od <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'Ovrednotenje od {$a}';
$string['assessmentbyyourself'] = 'Vaše ovrednotenje';
$string['assessmentdeleted'] = 'Vrednotenje ni več dodeljeno';
$string['assessmentend'] = 'Rok ovrednotenja';
$string['assessmentendbeforestart'] = 'Rok ovrednotenja ne more biti določen pred začetkom vrednotenja';
$string['assessmentenddatetime'] = 'Rok ovrednotenja: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} (rok ovrednotenja)';
$string['assessmentform'] = 'Obrazec ovrednotenja';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">Ovrednotenje</a> oddaje <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = 'Referenčno vrednotenje';
$string['assessmentreferenceconflict'] = 'Ni možno vrednotiti primera oddaje, za katerega ste podali referenčno ovrednotenje.';
$string['assessmentreferenceneeded'] = 'Vrednotiti morate ta vzorčni prispevek, da določite referenčno vrednotenje. Kliknite gumb \'Nadaljuj\' za vrednotenje prispevka.';
$string['assessments'] = 'Vrednotenja';
$string['assessmentsettings'] = 'Nastavitve vrednotenja';
$string['assessmentstart'] = 'Začetek vrednotenja';
$string['assessmentstartdatetime'] = 'Odprto za vrednotenje od {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} se odpre za vrednotenje';
$string['assessmentweight'] = 'Teža vrednotenja';
$string['assignedassessments'] = 'Dodeljene prispevki za vrednotenje';
$string['assignedassessmentsnone'] = 'Nimate dodeljenih prispevkov za vrednotenje';
$string['backtoeditform'] = 'Nazaj na urejanje obrazca';
$string['byfullname'] = 'od <a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = 'od {$a}';
$string['calculategradinggrades'] = 'Izračunajte ocene ovrednotenj';
$string['calculategradinggradesdetails'] = 'pričakovano: {$a->expected}<br />izračunano: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Izračunajte ocene oddaj';
$string['calculatesubmissiongradesdetails'] = 'pričakovano: {$a->expected}<br />izračunano: {$a->calculated}';
$string['chooseuser'] = 'Izberite uporabnika ...';
$string['clearaggregatedgrades'] = 'Počistite vse združene ocene';
$string['clearaggregatedgrades_help'] = 'Združene ocene za oddajo in ocene za ovrednotenje bodo ponastavljene. Lahko jih ponovno izračunate v fazi ocenjevanja.';
$string['clearaggregatedgradesconfirm'] = 'Ste prepričani, da želite počistiti združene ocene za prispevke in ocene za vrednotenje?';
$string['clearassessments'] = 'Počistite vrednotenja';
$string['clearassessments_help'] = 'Ocene za oddajo in ocene za ovrednotenje bodo ponastavljene. Podatki o tem, kako je obrazec za ovrednotenje izpolnjen, so ohranjeni, vendar morajo vsi pregledovalci ponovno odpreti obrazec za ovrednotenje in ga ponovno shraniti, če želijo, da se ocene ponovno izračunajo.';
$string['clearassessmentsconfirm'] = 'Ste prepričani, da želite počistiti vse ocene vrednotenj? Sami potem ne boste mogli dobiti nazaj podatkov, prejemniki bodo morali ponovno vrednotiti dodeljene prispevke.';
$string['conclusion'] = 'Zaključek';
$string['conclusion_help'] = 'Zaključno besedilo je sodelujočim prikazano ob koncu dejavnosti.';
$string['configexamplesmode'] = 'Privzeti način primerov ovrednotenja v delavnicah';
$string['configgrade'] = 'Privzeta najvišja ocena za oddajo v delavnicah';
$string['configgradedecimals'] = 'Privzeto število decimalk, ki bodo prikazane po decimalni vejici pri prikazu ocen.';
$string['configgradinggrade'] = 'Privzeta najvišja ocena za vrednotenje v delavnicah';
$string['configmaxbytes'] = 'Privzeta največja velikost datoteke za oddajo za vse delavnice na tem spletnem mestu (odvisno od omejitev predmeta in ostalih lokalnih nastavitev)';
$string['configstrategy'] = 'Privzeta strategija ocenjevanja v delavnicah';
$string['createsubmission'] = 'Dodaj prispevek';
$string['crontask'] = 'Obdelava podatkov v ozadju za modul delavnice';
$string['daysago'] = '{$a} dni nazaj';
$string['daysleft'] = 'Število preostalih dni: {$a}';
$string['daystoday'] = 'danes';
$string['daystomorrow'] = 'jutri';
$string['daysyesterday'] = 'včeraj';
$string['deadlinesignored'] = 'Časovne omejitve za vas ne veljajo';
$string['deletesubmission'] = 'Izbriši oddajo';
$string['editassessmentform'] = 'Uredite obrazec za vrednotenje';
$string['editassessmentformstrategy'] = 'Uredite obrazec za vrednotenje ({$a})';
$string['editingassessmentform'] = 'Urejanje obrazca za vrednotenje';
$string['editingsubmission'] = 'Urejanje prispevka';
$string['editsubmission'] = 'Uredi oddajo';
$string['err_multiplesubmissions'] = 'Med urejanjem tega obrazca je bila shranjena druga različica prispevka. Več prispevkov na uporabnika ni dovoljenih.';
$string['err_removegrademappings'] = 'Ni mogoče odstraniti neuporabljenih preslikav ocen';
$string['evaluategradeswait'] = 'Prosimo, počakajte, da so pregledana ovrednotenja in izračunane ocene';
$string['evaluation'] = 'Ocenjevanje ovrednotenja';
$string['evaluationmethod'] = 'Metoda ocenjevanja vrednotenja';
$string['evaluationmethod_help'] = 'Metoda ocenjevanja ovrednotenja določa, kako je izračunana ocena za ovrednotenje. Ocene lahko večkrat izračunate na podlagi spremenjenih nastavitev, dokler niste zadovoljni z rezultatom.';
$string['evaluationsettings'] = 'Nastavitve ocenjevanja';
$string['eventassessableuploaded'] = 'Prispevek je bil naložen.';
$string['eventassessmentevaluated'] = 'Vrednotenje ocenjeno';
$string['eventassessmentevaluationsreset'] = 'Ocene ovrednotenj so ponastavljene';
$string['eventassessmentreevaluated'] = 'Ovrednotenje je bilo ponovno ocenjeno';
$string['eventphaseswitched'] = 'Faza je preklopljena';
$string['eventsubmissionassessed'] = 'Prispevek je ovrednoten';
$string['eventsubmissionassessmentsreset'] = 'Vrednotenja prispevkov so počiščena';
$string['eventsubmissioncreated'] = 'Oddaja ustvarjena';
$string['eventsubmissiondeleted'] = 'Oddaja izbrisana';
$string['eventsubmissionreassessed'] = 'Prispevek ponovno ovrednotena';
$string['eventsubmissionupdated'] = 'Prispevek posodobljen';
$string['eventsubmissionviewed'] = 'Prispevek ogledan';
$string['example'] = 'Primer oddaje';
$string['exampleadd'] = 'Dodajte vzorčni prispevek';
$string['exampleassess'] = 'Ovrednotite vzorčni prispevek';
$string['exampleassessments'] = 'Primer oddaje za vrednotenje';
$string['exampleassesstask'] = 'Ovrednotite primere';
$string['exampleassesstaskdetails'] = 'pričakovano: {$a->expected}<br />ovrednoteno: {$a->assessed}';
$string['examplecomparing'] = 'Primerjava vrednotenj vzorčnega prispevka';
$string['exampledelete'] = 'Izbriši primer';
$string['exampledeleteconfirm'] = 'Ste prepričani, da želite izbrisati primer oddaje? Kliknite gumb ‚Nadaljuj\' za izbris primera oddaje.';
$string['exampleedit'] = 'Uredite primer';
$string['exampleediting'] = 'Urejanje primera';
$string['exampleneedassessed'] = 'Najprej morate ovrednotiti vse primere oddaj';
$string['exampleneedsubmission'] = 'Najprej morate oddati svoje delo in ovrednotiti vse primere oddaj';
$string['examplesbeforeassessment'] = 'Primeri so na voljo po lastni oddaji in morajo biti ovrednoteni pred vrednotenjem vrstnikov';
$string['examplesbeforesubmission'] = 'Primeri morajo biti ovrednoteni pred lastno oddajo';
$string['examplesmode'] = 'Način vrednotenja primerov';
$string['examplesubmissions'] = 'Primeri oddaj';
$string['examplesvoluntary'] = 'Vrednotenje vzorčnega prispevka je prostovoljno';
$string['exportsubmission'] = 'Izvozite to stran';
$string['feedbackauthor'] = 'Pripombe za avtorja';
$string['feedbackauthorattachment'] = 'Priponka';
$string['feedbackby'] = 'Povratne informacije od {$a}';
$string['feedbackreviewer'] = 'Pripombe za pregledovalca';
$string['feedbacksettings'] = 'Pripombe';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Podane ocene';
$string['grade_grading_name'] = 'Vrednotenje';
$string['grade_submission_name'] = 'Prispevek';
$string['gradecalculated'] = 'Izračunana ocena za prispevek';
$string['gradedecimals'] = 'Decimalna mesta v ocenah';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Ocena: {$a->received} od {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (vrednotenje)';
$string['gradeitemsubmission'] = '{$a->workshopname} (prispevek)';
$string['gradeover'] = 'Preglasi oceno za prispevek';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Poročilo o ocenah delavnice';
$string['gradetopassgrading'] = 'Ocena ovrednotenja za uspešno opravljanje';
$string['gradetopasssubmission'] = 'Ocena oddaje za uspešno opravljanje';
$string['gradinggrade'] = 'Ocena vrednotenja';
$string['gradinggrade_help'] = 'Ta nastavitev določa najvišjo oceno, ki jo udeleženci lahko dobijo za ovrednotenje prispevka.';
$string['gradinggradecalculated'] = 'Izračunana ocena za vrednotenje';
$string['gradinggradeof'] = 'Ocena za vrednotenje (od {$a})';
$string['gradinggradeover'] = 'Preglasite oceno za vrednotenje';
$string['gradingsettings'] = 'Nastavitve ocenjevanja';
$string['groupnoallowed'] = 'Nimate dovoljenja za dostop do katere koli skupine v tej delavnici';
$string['iamsure'] = 'Ja, sem prepričan/-a.';
$string['indicator:cognitivedepth'] = 'Kognitivna delavnica';
$string['indicator:cognitivedepth_help'] = 'Ta kazalnik temelji na kognitivni globini, ki jo udeleženec doseže v Dejavnosti delavnice.';
$string['indicator:cognitivedepthdef'] = 'Kognitivna delavnica';
$string['indicator:cognitivedepthdef_help'] = 'Sodelujoči je dosegel ta odstotek kognitivne naloge, ki jo ponujajo Dejavnosti delavnice v tem intervalu analize (Ravni = Brez ogleda, Ogled, Oddaja, Ogled pripomb, Komentiranje pripomb, Ponovna oddaja po ogledu pripomb)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Delavnica družabno';
$string['indicator:socialbreadth_help'] = 'Ta kazalnik temelji na socialni širini, ki jo udeleženec doseže v Dejavnosti delavnice.';
$string['indicator:socialbreadthdef'] = 'Delavnica družabno';
$string['indicator:socialbreadthdef_help'] = 'Sodelujoči je dosegel ta odstotek družbenega udejstvovanja, ki ga ponujajo Dejavnosti delavnice v tem intervalu analize (Ravni = Brez sodelovanja, Sodelujoči sam, Sodelujoči z drugimi)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Informacije';
$string['instructauthors'] = 'Navodila za oddajo';
$string['instructreviewers'] = 'Navodila za vrednotenje';
$string['introduction'] = 'Opis';
$string['latesubmissions'] = 'Pozne oddaje';
$string['latesubmissions_desc'] = 'Dovolite prispevke po roku';
$string['latesubmissions_help'] = 'Če je omogočeno, lahko avtor odda svoje delo po roku za oddajo ali med fazo vrednotenja. Poznih prispevkov pa ne more urejati.';
$string['latesubmissionsallowed'] = 'Pozne oddaje so dovoljene';
$string['legacyallocationplugincron'] = 'Dodelitev podedovanega pripomočka cron delavnici';
$string['maxbytes'] = 'Največja velikost datoteke prispevka';
$string['modulename'] = 'Delavnica';
$string['modulename_help'] = 'Dejavnost Delavnica omogoča zbiranje, pregledovanje in medsebojno vrednotenje dela udeležencev.

Udeleženci lahko oddajo svoje izdelke v poljubnem digitalnem formatu (npr. preglednica, film), lahko pa besedilo vnesejo neposredno v polje z urejevalnikom besedila.

Oddaje se vrednotijo na podlagi strategije, ki jo izbere izvajalec. Proces navzkrižnega medsebojnega vrednotenja se lahko predhodno vadi s pomočjo pripravljenega primera oddaje in referenčnega ovrednotenja tega primera, ki ga zagotovi izvajalec. Udeleženci imajo priložnost pregledati in ovrednotiti več oddaj vrstnikov. Oddaje in pregledovalci so po potrebi lahko tudi anonimni.

Udeleženci delavnice dobijo dve oceni - oceno oddaje in oceno ovrednotenja. Obe sta zabeleženi v redovalnici.';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'Delavnice';
$string['myassessments'] = 'Moja vrednotenja';
$string['mysubmission'] = 'Moj prispevek';
$string['nattachments'] = 'Največje število priponk prispevka';
$string['noexamples'] = 'V tej delavnici še ni primerov';
$string['noexamplesformready'] = 'Preden pripravite primer oddaje, morate urediti obrazec za vrednotenje';
$string['nogradeyet'] = 'Ni še ocene';
$string['nosubmissionfound'] = 'Za tega uporabnika ni najdenih prispevkov';
$string['nosubmissions'] = 'V tej delavnici še ni prispevkov';
$string['nosubmissiontype'] = 'Na voljo mora biti vsaj en tip oddaje';
$string['notassessed'] = 'Še ni ovrednoteno';
$string['nothingfound'] = 'Ničesar za prikaz';
$string['nothingtoreview'] = 'Ni ničesar za pregled';
$string['notoverridden'] = 'Ni bilo preglašeno';
$string['noworkshops'] = 'V tem predmetu ni delavnic';
$string['noyoursubmission'] = 'Svojega dela še niste oddali';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Končne pripombe';
$string['overallfeedbackfiles'] = 'Največje število priponk v pripombah';
$string['overallfeedbackmaxbytes'] = 'Največja velikost priponk v pripombah';
$string['overallfeedbackmode'] = 'Način za skupne pripombe';
$string['overallfeedbackmode_0'] = 'Onemogočeno';
$string['overallfeedbackmode_1'] = 'Omogočeno in izbirno';
$string['overallfeedbackmode_2'] = 'Omogočeno in obvezno';
$string['overallfeedbackmode_help'] = 'Če je omogočeno, se besedilno polje prikaže na dnu obrazca za ovrednotenje. Pregledovalci lahko tam podajo skupno ovrednotenje oddaje ali dodatne obrazložitve na podano ovrednotenje.';
$string['page-mod-workshop-x'] = 'Katera koli stran z modulom delavnice';
$string['participant'] = 'Sodelujoči';
$string['participantrevierof'] = 'Udeleženec je pregledovalec od';
$string['participantreviewedby'] = 'Prispevek udeleženca pregleduje';
$string['phaseassessment'] = 'Faza vrednotenja';
$string['phaseclosed'] = 'Zaprto';
$string['phaseevaluation'] = 'Faza ocenjevanja';
$string['phasesetup'] = 'Faza nastavitve';
$string['phasesoverlap'] = 'Faza oddaje in faza vrednotenja se ne smeta prekrivati';
$string['phasesubmission'] = 'Faza oddaje';
$string['pluginadministration'] = 'Skrbništvo delavnice';
$string['pluginname'] = 'Delavnica';
$string['prepareexamples'] = 'Pripravi vzorčne prispevke';
$string['previewassessmentform'] = 'Predogled';
$string['privacy:metadata:aggregatedgradinggrade'] = 'Združena ocena ovrednotenj, ki jih je uporabnik opravil v tej delavnici';
$string['privacy:metadata:assessmentgrade'] = 'Združena ocena prispevkov na podlagi vrednotenja';
$string['privacy:metadata:assessmentgradinggrade'] = 'Ocena za opravljeno vrednotenje';
$string['privacy:metadata:assessmentgradinggradeover'] = 'Ocena za ročni prepis ocene opravljenega vrednotenja';
$string['privacy:metadata:assessmentid'] = 'ID vrednotenja';
$string['privacy:metadata:authorid'] = 'ID avtorja prispevka';
$string['privacy:metadata:dimensiongrade'] = 'Ocena v dani dimenziji vrednotenja';
$string['privacy:metadata:dimensionid'] = 'ID dimenzije vrednotenja';
$string['privacy:metadata:example'] = 'Ta nastavitev določa, če ta zapis predstavlja vzorčni prispevek';
$string['privacy:metadata:feedbackauthor'] = 'Pripombe za avtorja';
$string['privacy:metadata:feedbackauthorformat'] = 'Besedilni format povratne informacije za avtorja';
$string['privacy:metadata:feedbackreviewer'] = 'Povratne informacije za uporabnika, ki je vrednotil';
$string['privacy:metadata:feedbackreviewerformat'] = 'Besedilni format povratne informacije za uporabnika, ki je vrednotil';
$string['privacy:metadata:late'] = 'Ali je bil prispevek naložen po roku';
$string['privacy:metadata:peercomment'] = 'Komentar na podano oceno od uporabnika, ki je vrednotil';
$string['privacy:metadata:peercommentformat'] = 'Besedilni format komentarja podane ocene';
$string['privacy:metadata:preference:perpage'] = 'Število prispevkov, ki jih uporabnik želi videti na eni strani';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'Strnjena/razširijena oblika okenca »Primeri prispevkov«.';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'Strnjena/razširijena oblika okenca »Poročilo o prispevkih v delavnici«.';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'Strnjena/razširijena oblika okenca »Obrazec za vrednotenje«.';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'Strnjena/razširijena oblika okenca »Prispevki dodeljeni za vrednotenje«.';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'Strnjena/razširijena oblika okenca »Orodjarna delavnice«.';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'Strnjena/razširijena oblika okenca »Zaključek«.';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'Strnjena/razširijena oblika okenca »Vzorčni prispevki za vrednotenje«.';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'Strnjena/razširijena oblika okenca »Vzorčni prispevki za vrednotenje«.';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'Strnjena/razširijena oblika okenca »Poročilo o ocenah iz delavnice«.';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'Strnjena/razširijena oblika okenca »Navodila za oddajo«.';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'Strnjena/razširijena oblika okenca »Navodila za vrednotenje«.';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'Strnjena/razširijena oblika okenca »Uvod«.';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'Strnjena/razširijena oblika okenca »Povprečje pripomb«.';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'Strnjena/razširijena oblika okenca »Vaš prispevek«.';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'Strnjena/razširijena oblika okenca »Objavljeni prispevki«.';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'Strnjena/razširijena oblika okenca »Vaše ocene«.';
$string['privacy:metadata:published'] = 'Ta nastavitev določa, če naj bo prispevek objavljen za vse udeležence, ko se delavnica zapre';
$string['privacy:metadata:reviewerid'] = 'ID uporabnika, ki vrednoti';
$string['privacy:metadata:strategy'] = 'Podvtičnik za ime strategije ocenjevanja, ki razlaga vrednosti zapisa';
$string['privacy:metadata:submissioncontent'] = 'Vsebina prispevka';
$string['privacy:metadata:submissioncontentformat'] = 'Besedilni format vsebine prispevka';
$string['privacy:metadata:submissiongrade'] = 'Združena ocena prispevka, napisana kot decimalno število od 0 do 100';
$string['privacy:metadata:submissiongradeover'] = 'Ročno prepisana vrednost združene ocene';
$string['privacy:metadata:submissionid'] = 'ID prispevka';
$string['privacy:metadata:submissiontitle'] = 'Naslov prispevka';
$string['privacy:metadata:subsystem:corefiles'] = 'Modul delavnice shranjuje datoteke, ugnezdene v ali pripete besedilu prispevka';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'Modul delavnice ima vgrajeno podporo za sisteme za preprečevanje plagiarizma';
$string['privacy:metadata:timeaggregated'] = 'Kdaj je bila združena ocena nazadnje preračunana';
$string['privacy:metadata:timecreated'] = 'Kdaj je bil ta zapis ustvarjen v podatkovni bazi';
$string['privacy:metadata:timemodified'] = 'Kdaj je bil ta zapis nazadnje spremenjen v podatkovni bazi';
$string['privacy:metadata:userid'] = 'ID uporabnika, za katerega je združena ocena izračunana';
$string['privacy:metadata:weight'] = 'Teža vrednotenja';
$string['privacy:metadata:workshopaggregations'] = 'Ima združene ocene za ovrednotenje';
$string['privacy:metadata:workshopassessments'] = 'Ima podatke o dodeljenih vrednotenjih prispevkov v modulu delavnice';
$string['privacy:metadata:workshopgrades'] = 'Ima podatke o tem, kako so bili obrazci za ovrednotenje izpolnjeni z ocenami in komentarji';
$string['privacy:metadata:workshopid'] = 'ID dejavnosti v delavnici';
$string['privacy:metadata:workshopsubmissions'] = 'Ima podatke o prispevkih v modulu delavnice';
$string['privacy:request:delete:content'] = 'Vsebina je bila izbrisana (to je zahteval uporabnik ali pa je vsebina potekla)';
$string['privacy:request:delete:title'] = '[Izbrisano]';
$string['publishedsubmissions'] = 'Objavljene oddaje';
$string['publishsubmission'] = 'Objavite prispevek';
$string['publishsubmission_help'] = 'Objavljeni prispevki so na voljo ostalim, ko se delavnica zapre.';
$string['reassess'] = 'Ponovno ovrednoti';
$string['receivedgrades'] = 'Prejete ocene';
$string['recentassessments'] = 'Vrednotenja delavnice:';
$string['recentsubmissions'] = 'Prispevki delavnice:';
$string['resetassessments'] = 'Izbriši vsa vrednotenja';
$string['resetassessments_help'] = 'Lahko izbrišete samo dodeljeno ovrednotenje, ne da bi to vplivalo na oddaje. Pri izbrisu oddaj bo izbrisano tudi njihovo ovrednotenje, pri čemer je ta možnost prezrta. To vključuje tudi ovrednotenje primerov oddaj.';
$string['resetphase'] = 'Preklopite na fazo nastavitev';
$string['resetphase_help'] = 'Če je omogočeno, bodo vse delavnice v začetni fazi nastavitev.';
$string['resetsubmissions'] = 'Izbriši vse prispevke';
$string['resetsubmissions_help'] = 'Vsi prispevki in njihova vrednotenja bodo izbrisani. To ne vpliva na vzorčne prispevke.';
$string['saveandclose'] = 'Shrani in zapri';
$string['saveandcontinue'] = 'Shrani in nadaljuj urejanje';
$string['saveandpreview'] = 'Shrani in pojdi na predogled';
$string['saveandshownext'] = 'Shrani in prikaži naslednjo';
$string['search:activity'] = 'Delavnica - podatki o dejavnosti';
$string['selfassessmentdisabled'] = 'Samovrednotenje je onemogočeno';
$string['showingperpage'] = 'Prikaz {$a} elementov na stran';
$string['showingperpagechange'] = 'Spremenite ...';
$string['someuserswosubmission'] = 'Vsaj en avtor še ni oddal svojega dela';
$string['sortasc'] = 'Naraščajoča razvrstitev';
$string['sortdesc'] = 'Padajoča razvrstitev';
$string['strategy'] = 'Strategija ocenjevanja';
$string['strategy_help'] = 'Strategija ocenjevanja določa uporabljen obrazec za vrednotenje in metodo ocenjevanja prispevkov. Na voljo so štiri možnosti:

* Zbirno ocenjevanje - Komentarji in ocene so dodeljene glede na določene vidike.
* Komentarji - Komentarji so dodeljeni glede na določene vidike, brez ocen.
* Število napak - Komentarji in vrednotenje tipa da/ne so dodeljeni glede na določene trditve.
* Rubrika - Vrednotenje z oceno je dodeljeno na podlagi doseganja posamezne ravni vnaprej določenih kriterijev. Rubrike vsebujejo opise različnih ravni uspešnosti';
$string['strategyhaschanged'] = 'Strategija ocenjevanja se je spremenila, med tem ko je bil odprt obrazec za urejanje.';
$string['submission'] = 'Oddaja';
$string['submissionattachment'] = 'Priponka';
$string['submissionby'] = 'Prispevek osebe {$a}';
$string['submissioncontent'] = 'Vsebina oddaje';
$string['submissiondeleteconfirm'] = 'Ste prepričani, da želite izbrisati ta prispevek?';
$string['submissiondeleteconfirmassess'] = 'Ste prepričani, da želite izbrisati ta prispevek? To bo izbrisalo tudi {$a->count} povezanih vrednotenj, kar lahko vpliva na ocene pregledovalcev.';
$string['submissionend'] = 'Rok za oddajo';
$string['submissionendbeforestart'] = 'Rok za oddajo ne more biti pred datumom začetka oddaj';
$string['submissionenddatetime'] = 'Rok za oddajo: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} Rok za oddajo';
$string['submissionendswitch'] = 'Preklopite v naslednjo fazo po roku oddaj';
$string['submissionendswitch_help'] = 'Če ja nastavljen rok oddaje in je polje obkljukano, se bo delavnica samodejno preklopila v fazo ovrednotenja po poteku roka oddaj.

Če to omogočite, je priporočljivo nastaviti tudi metodo samodejnega dodeljevanja. Če oddaje niso dodeljene, ocenjevanje ne bo možno, četudi je delavnica v fazi vrednotenja.';
$string['submissiongrade'] = 'Ocena za oddajo';
$string['submissiongrade_help'] = 'Ta nastavitev določa najvišjo oceno, ki jo lahko dobite za oddano delo.';
$string['submissiongradeof'] = 'Ocena za prispevek (od {$a})';
$string['submissionlastmodified'] = 'Zadnja sprememba';
$string['submissionrequiredcontent'] = 'Vnesti morate besedilo ali dodati datoteko.';
$string['submissionrequiredfile'] = 'Dodati morate datoteko ali vnesti besedilo.';
$string['submissionsettings'] = 'Nastavitve oddaje';
$string['submissionsreport'] = 'Poročilo o prispevkih v delavnici';
$string['submissionstart'] = 'Odprto za oddaje od';
$string['submissionstartdatetime'] = 'Odprto za oddaje od {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} (odprto za prispevke)';
$string['submissiontitle'] = 'Naslov';
$string['submissiontypedisabled'] = 'Ta tip oddaje je onemogočen za to delavnico.';
$string['submissiontypefileavailable'] = 'Datoteka v priponki <span class="accesshide">omogočena</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">Datoteka v priponki</span> zahtevana';
$string['submissiontypes'] = 'Tipi prispevkov';
$string['submissiontypetextavailable'] = 'Spletno besedilo<span class="accesshide"> omogočeno</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">Spletno besedilo </span>zahtevano';
$string['submittednotsubmitted'] = 'Oddano ({$a->submitted}) / ni oddano ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Metoda dodelitve prispevkov';
$string['subplugintype_workshopallocation_plural'] = 'Metode dodelitve prispevkov';
$string['subplugintype_workshopeval'] = 'Metoda ocenjevanja vrednotenja';
$string['subplugintype_workshopeval_plural'] = 'Metode ocenjevanja vrednotenja';
$string['subplugintype_workshopform'] = 'Strategija ocenjevanja';
$string['subplugintype_workshopform_plural'] = 'Strategije ocenjevanja';
$string['switchingphase'] = 'Preklapljanje faze';
$string['switchphase'] = 'Preklopi fazo';
$string['switchphase10'] = 'Preklopite na fazo nastavitev';
$string['switchphase10info'] = 'Sedaj boste preklopili delavnico v <strong>Fazo nastavitve</strong>. V tej fazi uporabniki ne morejo spreminjati svojih oddaj ali ovrednotenj. Izvajalci lahko uporabljajo to fazo za spreminjanje nastavitev delavnice, strategije ocenjevanja ali prilagodijo obrazce za ovrednotenje.';
$string['switchphase20'] = 'Preklopite v fazo oddaje';
$string['switchphase20info'] = 'Sedaj boste preklopili delavnico v <strong>Fazo oddaje</strong>. Med to fazo lahko udeleženci oddajo svoje delo (znotraj datumov dostopa do oddaj, če so nastavljeni). Izvajalci lahko dodelijo oddaje za pregled vrstnikov.';
$string['switchphase30'] = 'Preklopite v fazo vrednotenja';
$string['switchphase30auto'] = 'Delavnica se bo samodejno preklopila v fazo vrednotenja po {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'Sedaj boste preklopili delavnico v <strong>Fazo vrednotenja</strong>. V tej fazi lahko pregledovalci ovrednotijo oddaje, ki so jim bile dodeljene (znotraj datumov dostopa do oddaj, če so nastavljeni).';
$string['switchphase40'] = 'Preklopite v fazo ocenjevanja';
$string['switchphase40info'] = 'Sedaj boste preklopili delavnico v <strong>Fazo ocenjevanja</strong>. V tej fazi uporabniki ne morejo spreminjati svojih oddaj ali ovrednotenj. Izvajalci lahko uporabljajo orodja za evalvacijo vrednotenj za izračun končnih ocen in podajo povratne informacije za pregledovalce.';
$string['switchphase50'] = 'Zaprite delavnico';
$string['switchphase50info'] = 'Sedaj boste zaprli delavnico. Izračunane ocene se bodo prikazale v redovalnici. Udeleženci si lahko ogledajo svoje oddaje in podana ovrednotenja vrstnikov.';
$string['switchphaseauto'] = 'Preklop je načrtovan';
$string['switchphasenext'] = 'Preklopite na naslednjo fazo';
$string['taskassesspeers'] = 'Ovrednotite kolege';
$string['taskassesspeersdetails'] = 'skupno: {$a->total}<br />v obdelavi: {$a->todo}';
$string['taskassessself'] = 'Ovrednotite svojo oddajo';
$string['taskconclusion'] = 'Podajte zaključno sporočilo dejavnosti';
$string['taskdone'] = 'Naloga opravljena';
$string['taskfail'] = 'Naloga neuspešno opravljena';
$string['taskinfo'] = 'Podatki o nalogi';
$string['taskinstructauthors'] = 'Dodajte navodila za oddajo';
$string['taskinstructreviewers'] = 'Dodajte navodila za vrednotenje';
$string['taskintro'] = 'Nastavite opis delavnice';
$string['tasksubmit'] = 'Oddajte svoje delo';
$string['tasktodo'] = 'Naloge za opraviti';
$string['toolbox'] = 'Orodja delavnice';
$string['undersetup'] = 'Delavnica se trenutno nastavlja. Prosimo, počakajte, dokler se ne preklopi na naslednjo fazo.';
$string['useexamples'] = 'Uporabite primere';
$string['useexamples_desc'] = 'Primeri oddaj so namenjeni vadenju ovrednotenja';
$string['useexamples_help'] = 'Če je omogočeno, lahko uporabniki poskušajo ovrednotiti enega ali več vzorčnih prispevkov in primerjajo svoje vrednotenje z referenčnim vrednotenjem. Ocena ni všteta v oceno za vrednotenje.';
$string['usepeerassessment'] = 'Uporabite vrednotenje kolegov';
$string['usepeerassessment_desc'] = 'Udeleženci lahko vrednotijo delo drugih';
$string['usepeerassessment_help'] = 'Če je omogočeno, lahko udeleženec ovrednoti oddaje drugih sodelujočih in dobi oceno za ovrednotenje poleg ocene za svoj prispevek.';
$string['userdatecreated'] = 'oddano: <span>{$a}</span>';
$string['userdatemodified'] = 'spremenjeno: <span>{$a}</span>';
$string['userplan'] = 'Načrtovalec delavnice';
$string['userplan_help'] = 'Načrtovalec delavnice prikaže vse faze dejavnosti in naredi seznam opravil za vsako fazo. Trenutna faza je poudarjena, dokončanje opravila je označeno s kljukico.';
$string['userplanaccessibilityskip'] = 'Skočite na trenutne naloge';
$string['userplanaccessibilitytitle'] = 'Časovnica delavnice s/z {$a} fazo/fazami';
$string['userplancurrentphase'] = 'Trenutna faza';
$string['useselfassessment'] = 'Uporabite samoocenjevanje';
$string['useselfassessment_desc'] = 'Udeleženci lahko ovrednotijo svoje delo';
$string['useselfassessment_help'] = 'Če je omogočeno, se lahko uporabniku za vrednotenje dodeli njegovo oddajo, s čimer dobi poleg ocene za svojo oddajo še oceno za vrednotenje.';
$string['viewworkshopsummary'] = 'Poglejte povzetek delavnice';
$string['weightinfo'] = 'Teža: {$a}';
$string['withoutsubmission'] = 'Pregledovalec brez svojih prispevkov';
$string['workshop:addinstance'] = 'Dodajte novo delavnico';
$string['workshop:allocate'] = 'Dodelite prispevke za pregled';
$string['workshop:deletesubmissions'] = 'Izbrišite prispevke';
$string['workshop:editdimensions'] = 'Uredite obrazce za vrednotenje';
$string['workshop:exportsubmissions'] = 'Izvozite prispevke';
$string['workshop:ignoredeadlines'] = 'Prezrite časovne omejitve';
$string['workshop:manageexamples'] = 'Uredite vzorčne prispevke';
$string['workshop:overridegrades'] = 'Prepišite izračunane ocene';
$string['workshop:peerassess'] = 'Ovrednotenje kolega';
$string['workshop:publishsubmissions'] = 'Objavite prispevke';
$string['workshop:submit'] = 'Oddaj';
$string['workshop:switchphase'] = 'Preklopi fazo';
$string['workshop:view'] = 'Ogled delavnice';
$string['workshop:viewallassessments'] = 'Ogled vseh vrednotenj';
$string['workshop:viewallsubmissions'] = 'Ogled vseh prispevkov';
$string['workshop:viewauthornames'] = 'Oglejte si imena avtorjev';
$string['workshop:viewauthorpublished'] = 'Oglejte si avtorje objavljenih prispevkov';
$string['workshop:viewpublishedsubmissions'] = 'Oglejte si objavljene prispevke';
$string['workshop:viewreviewernames'] = 'Oglejte si imena pregledovalcev';
$string['workshopname'] = 'Ime delavnice';
$string['yourassessmentfor'] = 'Vaše ovrednotenje za {$a}';
$string['yourgrades'] = 'Vaše ocene';
$string['yoursubmission'] = 'Vaša oddaja';
