<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'sl', version '4.1'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Ukazi za ocenjevalni vmesnik';
$string['actionsforpost'] = 'Ukazi za objavo';
$string['activityoverview'] = 'Na forumu so nove objave';
$string['addanewdiscussion'] = 'Dodaj novo temo razprave';
$string['addanewquestion'] = 'Dodaj novo vprašanje';
$string['addanewtopic'] = 'Dodaj novo temo';
$string['addtofavourites'] = 'Označi to razpravo z zvezdico';
$string['advancedsearch'] = 'Napredno iskanje';
$string['alldiscussions'] = 'Vse razprave';
$string['allforums'] = 'Vsi forumi';
$string['allowdiscussions'] = 'Ali sme {$a} objavljati v tem forumu?';
$string['allowsallsubscribe'] = 'Ta forum dovoli vsem, da se naročijo nanj ali ne';
$string['allowsdiscussions'] = 'Ta forum dovoli vsaki osebi, da začne eno temo razprave.';
$string['allsubscribe'] = 'Naroči se na vse forume';
$string['allunsubscribe'] = 'Odjavi naročnino na vse forume';
$string['allusers'] = 'Vsi uporabniki';
$string['alreadyfirstpost'] = 'To je že prva objava v razpravi';
$string['anyfile'] = 'Katerakoli datoteka';
$string['areaattachment'] = 'Priponke';
$string['areapost'] = 'Sporočila';
$string['attachment'] = 'Priponka';
$string['attachment_help'] = 'V forumsko objavo lahko poljubno pripnete eno ali več datotek. Če pripnete sliko, bo prikazana po sporočilu.';
$string['attachmentname'] = 'Priponka {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Priponk ne morete izvoziti brez ID objave';
$string['attachments'] = 'Priponke';
$string['attachmentswordcount'] = 'Priponke in število besed';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} zasebno odgovarja na objavo, katere avtor je {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} odgovarja na objavo, katere avtor je {$a->author}';
$string['availability'] = 'Razpoložljivost';
$string['blockafter'] = 'Prag objav za blokiranje';
$string['blockafter_help'] = 'Ta nastavitev določa največje število objav, ki jih lahko uporabnik objavi v določenem obdobju.
Uporabniki z zmožnostjo mod/forum:postwithoutthrottling so izvzeti iz te omejitve.';
$string['blockperiod'] = 'Časovno obdobje za blokiranje';
$string['blockperiod_help'] = 'Udeležencem lahko preprečite, da objavijo več kot določeno število objav v določenem obdobju. Uporabniki z zmožnostjo mod/forum:postwithoutthrottling so izvzeti iz te omejitve.';
$string['blockperioddisabled'] = 'Ne blokiraj';
$string['blogforum'] = 'Standardni forum, prikazan v obliki bloga';
$string['bynameondate'] = 'od {$a->name} - {$a->date}';
$string['cachedef_forum_is_tracked'] = 'Spremljanje stanja na forumu za uporabnika';
$string['calendardue'] = 'Rok za {$a}';
$string['cancelreply'] = 'Prekliči odgovor';
$string['cannotadd'] = 'V ta forum ne morem dodati razprave';
$string['cannotadddiscussion'] = 'Če želite v ta forum dodati razpravo, morate biti član skupine.';
$string['cannotadddiscussionall'] = 'Nimate dovoljenja, da bi dodali novo temo razprave za vse sodelujoče.';
$string['cannotadddiscussiongroup'] = 'Ne morete ustvariti razprave, ker niste udeleženec katere od skupin.';
$string['cannotaddsubscriber'] = 'V ta forum ne morem dodati naročnika z id {$a}!';
$string['cannotaddteacherforumto'] = 'Ni bilo mogoče dodati primerka pretvorjenega učiteljskega foruma v odsek 0 tega predmeta';
$string['cannotcreatediscussion'] = 'Nove razprave ni bilo mogoče ustvariti';
$string['cannotcreateinstanceforteacher'] = 'Ne morem ustvariti novega primerka modula predmeta za učiteljski forum';
$string['cannotdeletepost'] = 'Te objave ne morete izbrisati!';
$string['cannoteditposts'] = 'Objav drugih ljudi ne morete urejati!';
$string['cannotexportforum'] = 'Tega foruma ne morete izvoziti';
$string['cannotfavourite'] = 'Žal nimate dovoljenja za označevanje razprav z zvezdicami.';
$string['cannotfinddiscussion'] = 'V tem forumu ne morem najti razprave';
$string['cannotfindfirstpost'] = 'V tem forumu ne morem najti prve objave';
$string['cannotfindorcreateforum'] = 'Za to spletno mesto ne morem najti ali ustvariti foruma glavnih obvestil';
$string['cannotfindparentpost'] = 'Glavne nadrejene kategorije objave {$a} ni bilo mogoče najti';
$string['cannotmovefromsingleforum'] = 'Ni mogoče premakniti razprav iz enostavnega enorazpravnega foruma';
$string['cannotmovenotvisible'] = 'Forum ni viden';
$string['cannotmovetonotexist'] = 'Ne morete se premakniti na izbrani forum - forum ne obstaja!';
$string['cannotmovetonotfound'] = 'Ciljnega foruma ni mogoče najti v tem predmetu.';
$string['cannotmovetosingleforum'] = 'Ni mogoče premakniti razprave v enostaven enorazpravni forum';
$string['cannotpindiscussions'] = 'Žal nimate dovoljenja za pripenjanje razprav.';
$string['cannotpurgecachedrss'] = 'Predpomnilniških virov RSS ne morem očistiti za vir oz. lokacijo foruma(ov) - preverite datoteko z dovoljenjem za uporabo forumov';
$string['cannotremovesubscriber'] = 'Iz foruma ni bilo mogoče odstraniti naročnika z id {$a}!';
$string['cannotreply'] = 'Na to objavo ne morete odgovoriti';
$string['cannotsplit'] = 'Razprav iz tega foruma ni mogoče razdeliti';
$string['cannotsubscribe'] = 'Če se želite naročiti, morate biti član skupine.';
$string['cannottrack'] = 'Sledenja temu forumu ni bilo mogoče ustaviti';
$string['cannotunsubscribe'] = 'Ne morem preklicati naročnine za ta forum';
$string['cannotupdatepost'] = 'Te objave ni mogoče posodobiti';
$string['cannotviewpostyet'] = 'Ne morete brati vprašanj drugih udeležencev v tej razpravi, ker še niste ničesar objavili';
$string['cannotviewusersposts'] = 'Uporabnik še ni objavil nobenih objav, ki bi si jih lahko ogledali.';
$string['cleanreadtime'] = 'Ob kateri uri naj se stare objave označijo kot prebrane';
$string['clicktofavourite'] = 'Te razprave niste označili z zvezdico. Kliknite, da to storite.';
$string['clicktolockdiscussion'] = 'Kliknite, če želite zakleniti to razpravo';
$string['clicktosubscribe'] = 'Na to razpravo niste naročeni. Kliknite za prijavo.';
$string['clicktounfavourite'] = 'To razpravo ste označili z zvezdico. Kliknite, če želite zvezdico odstraniti.';
$string['clicktounlockdiscussion'] = 'Kliknite, če želite to razpravo odkleniti';
$string['clicktounsubscribe'] = 'Naročeni ste na to razpravo. Kliknite za preklic naročnine.';
$string['close'] = 'Zapri';
$string['closegrader'] = 'Zapri ocenjevalnik';
$string['completiondetail:discussions'] = 'Začnite razprave: {$a}';
$string['completiondetail:posts'] = 'Ustvarite objave: {$a}';
$string['completiondetail:replies'] = 'Objavite odgovore: {$a}';
$string['completiondiscussions'] = 'Udeleženec mora ustvariti razprave:';
$string['completiondiscussionsdesc'] = 'Udeleženec mora ustvariti vsaj {$a} razprav';
$string['completiondiscussionsgroup'] = 'Zahtevaj razprave';
$string['completiondiscussionshelp'] = 'zahtevan je zaključek razprav';
$string['completionposts'] = 'Udeleženec mora objaviti razprave ali odgovore:';
$string['completionpostsdesc'] = 'Udeleženec mora objaviti vsaj {$a} razprav ali odgovorov';
$string['completionpostsgroup'] = 'Zahtevaj objave';
$string['completionpostshelp'] = 'zahtevane so razprave ali odgovori, če želite končati';
$string['completionreplies'] = 'Udeleženec mora objaviti odgovore:';
$string['completionrepliesdesc'] = 'Udeleženec mora objaviti vsaj {$a} odgovorov';
$string['completionrepliesgroup'] = 'Zahtevaj odgovore';
$string['completionreplieshelp'] = 'zahtevani so odgovori, če želite končati';
$string['configcleanreadtime'] = 'Ob kateri uri naj se očistijo stare objave iz tabele »prebrano«.';
$string['configdigestmailtime'] = 'Osebe, ki se odločijo za prejemanje e-pošte v obliki izvlečka, bodo izvlečke prejemale dnevno. Ta nastavitev nadzoruje, ob katerem času dneva bo dnevna e-pošta poslana (poslal jo bo naslednji cron, ki bo zagnan po tej uri).';
$string['configdisplaymode'] = 'Privzet način prikaza za razprave, če ta ni nastavljen.';
$string['configenablerssfeeds'] = 'To stikalo omogoča možnost virov RSS za vse forume. Vire boste še vedno morali ročno vključiti v nastavitvah za vsak forum.';
$string['configenabletimedposts'] = 'Izberite \'da\', če želite omogočiti nastavite časovnih obdobij prikaza pri dodajanju nove razprave na forum.';
$string['configlongpost'] = 'Vsaka objava, daljša od te dolžine (v znakih brez HTML), bo obravnavana kot predolga. Objave, prikazane na naslovni strani spletnega mesta, straneh družbene oblike predmetov ali profilih uporabnikov, so okrajšane na naraven prelom nekje med vrednostima forum_shortpost in forum_longpost.';
$string['configmanydiscussions'] = 'Največje število razprav, prikazanih na eni strani foruma';
$string['configmaxattachments'] = 'Privzeto največje število priponk, dovoljenih za eno objavo.';
$string['configmaxbytes'] = 'Privzeta največja velikost za vse priponke foruma na tem spletnem mestu (odvisna od omejitev predmeta in drugih lokalnih nastavitev)';
$string['configoldpostdays'] = 'Število dni, po katerih se vse objave obravnavajo kot prebrane.';
$string['configreplytouser'] = 'Naj objava v forumu, poslana po e-pošti, vsebuje uporabnikov e-poštni naslov, da lahko prejemniki odgovorijo osebno in ne prek foruma? Tudi če je nastavljeno na »Da«, lahko uporabniki v svojem profilu izberejo, naj bo njihov elektronski naslov tajen.';
$string['configrssarticlesdefault'] = 'Če so viri RSS omogočeni, je nastavljeno privzeto število člankov (razprav ali objav).';
$string['configrsstypedefault'] = 'Če so viri RSS omogočeni, je nastavljen privzeti tip dejavnosti.';
$string['configshortpost'] = 'Vsaka objava, ki je krajša od te vrednosti (v znakih brez HTML), je obravnavana kot kratka (glej spodaj).';
$string['configsubscriptiontype'] = 'Privzeta nastavitev za način naročanja.';
$string['configtrackingtype'] = 'Privzeta nastavitev za sledenje prebranih objav.';
$string['configtrackreadposts'] = 'Nastavite na »da«, če želite sledenje prebranih/neprebranih za vsakega uporabnika.';
$string['configusermarksread'] = 'Če »da«, mora uporabnik ročno označiti objavo kot prebrano. Če »ne«, je objava ob ogledu označena kot prebrana.';
$string['confirmsubscribe'] = 'Ali se res želite naročiti na forum \'{$a}\'?';
$string['confirmsubscribediscussion'] = 'Se res želite naročiti na razpravo \'{$a->discussion}\' na forumu \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Res želite preklicati naročnino na forum \'{$a}\'?';
$string['confirmunsubscribediscussion'] = 'Res želite preklicati naročnino za razpravo \'{$a->discussion}\' na forumu \'{$a->forum}\'?';
$string['couldnotadd'] = 'Zaradi neznane napake vaše objave ni bilo mogoče dodati';
$string['couldnotdeletereplies'] = 'Te objave ni mogoče izbrisati, saj je nekdo nanjo že odgovoril';
$string['couldnotupdate'] = 'Zaradi neznane napake vaše objave ni bilo mogoče posodobiti';
$string['created'] = 'Ustvarjeno';
$string['crontask'] = 'Forumova poštna in vzdrževalna dela';
$string['cutoffdate'] = 'Zadnji možni rok za oddajo';
$string['cutoffdate_help'] = 'Če je nastavljen, na forumu ne bo mogoče objavljati po tem datumu.';
$string['cutoffdatereached'] = 'Zaključni datum za objavljanje na tem forumu je dosežen, zato objavljanje ni več možno.';
$string['cutoffdatevalidation'] = 'Zadnji možni rok za oddajo ne more biti pred rokom za oddajo.';
$string['delete'] = 'Izbriši';
$string['deleteddiscussion'] = 'Tema razprave je bila izbrisana';
$string['deletedpost'] = 'Objava je bila izbrisana';
$string['deletedposts'] = 'Te objave so bile izbrisane';
$string['deleteduser'] = 'Izbrisan uporabnik';
$string['deletesure'] = 'Ali ste prepričani, da želite izbrisati to objavo?';
$string['deletesureplural'] = 'Ali ste prepričani, da želite izbrisati to objavo in vse odgovore nanjo? (objave: {$a})';
$string['digestmailheader'] = 'To je vaš dnevni zbirni izvleček novih objav iz forumov strani {$a->sitename}. Če želite spremeniti privzete nastavitve prejemanja e-pošte iz forumov, pojdite na {$a->userprefs}.';
$string['digestmailpost'] = 'Spremenite nastavitve izvlečkov foruma';
$string['digestmailpostlink'] = 'Spremenite nastavitve izvlečka foruma: {$a}';
$string['digestmailprefs'] = 'vaš profil uporabnika';
$string['digestmailsubject'] = '{$a}: izvleček foruma';
$string['digestmailtime'] = 'Ura za pošiljanje izvlečkov po e-pošti';
$string['digestsentusers'] = 'E-poštni izvlečki uspešno poslani {$a} uporabnikom.';
$string['disallowsubscribe'] = 'Naročnine niso dovoljene';
$string['disallowsubscribeteacher'] = 'Naročnine niso dovoljene (razen za učitelje)';
$string['disallowsubscription'] = 'Naročnina';
$string['disallowsubscription_help'] = 'Nastavitve tega foruma vam onemogočajo naročnino na razprave.';
$string['discussion'] = 'Razprava';
$string['discussionlistsortbycreatedasc'] = 'Razvrsti po datumu nastanka v naraščajočem vrstnem redu';
$string['discussionlistsortbycreateddesc'] = 'Razvrsti po datumu nastanka v padajočem vrstnem redu';
$string['discussionlistsortbydiscussionasc'] = 'Razvrsti po imenu razprave v naraščajočem vrstnem redu';
$string['discussionlistsortbydiscussiondesc'] = 'Razvrsti po imenu razprave v padajočem vrstnem redu';
$string['discussionlistsortbygroupasc'] = 'Razvrsti po skupinah v naraščajočem vrstnem redu';
$string['discussionlistsortbygroupdesc'] = 'Razvrsti po skupinah v padajočem vrstnem redu';
$string['discussionlistsortbylastpostasc'] = 'Razvrsti po datumu nastanka zadnje objave v naraščajočem vrstnem redu';
$string['discussionlistsortbylastpostdesc'] = 'Razvrsti po datumu nastanka zadnje objave v padajočem vrstnem redu';
$string['discussionlistsortbyrepliesasc'] = 'Razvrsti po številu odgovorov v naraščajočem vrstnem redu';
$string['discussionlistsortbyrepliesdesc'] = 'Razvrsti po številu odgovorov v padajočem vrstnem redu';
$string['discussionlistsortbystarterasc'] = 'Razvrsti po imenu začetnika razprave v naraščajočem vrstnem redu';
$string['discussionlistsortbystarterdesc'] = 'Razvrsti po imenu začetnika razprave v padajočem vrstnem redu';
$string['discussionlocked'] = 'Ta razprava je zaklenjena, zato nanjo ni več mogoče odgovarjati.';
$string['discussionlockingdisabled'] = 'Ne zaklepaj razprav';
$string['discussionlockingheader'] = 'Zaklepanje razprave';
$string['discussionmoved'] = 'Ta razprava je bila premaknjena v \'{$a}\'.';
$string['discussionmovedpost'] = 'Ta razprava je bila premaknjena v <a href="{$a->discusshref}">sem</a> v forumu <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Ime razprave';
$string['discussionnownotsubscribed'] = '{$a->name} NE bo obveščen/a o novih objavah v \'{$a->discussion}\' na \'{$a->forum}\'';
$string['discussionnowsubscribed'] = '{$a->name} bo obveščen/a o novih objavah v \'{$a->discussion}\' na \'{$a->forum}\'';
$string['discussionpin'] = 'Pripni';
$string['discussionpinned'] = 'Pripeto';
$string['discussionpinned_help'] = 'Pripete razprave se bodo pojavile na vrhu foruma.';
$string['discussions'] = 'Razprave';
$string['discussionsplit'] = 'Razprava je bila razdeljena';
$string['discussionsstartedby'] = 'Razprave, ki jih je začel/a {$a}';
$string['discussionsstartedbyrecent'] = 'Razprave, ki jih je nedavno začel/a {$a}';
$string['discussionsstartedbyuserincourse'] = 'Razprave, ki jih je začel/-a {$a->fullname} pri predmetu {$a->coursename}';
$string['discussionstartedby'] = 'Razpravo je začel {$a}';
$string['discussionsubscribed'] = 'Naročeni ste se na to razpravo.';
$string['discussionsubscribestart'] = 'Pošlji mi obvestila o novih objavah v tej razpravi';
$string['discussionsubscribestop'] = 'Ne želim prejemati obvestil o novih objavah v tej razpravi';
$string['discussionsubscription'] = 'Naročnina na razpravo';
$string['discussionsubscription_help'] = 'Če se naročite na razpravo, boste prejemali obvestila o novih objavah v tej razpravi.';
$string['discussionunpin'] = 'Odpni';
$string['discussionunsubscribed'] = 'Naročnina na to razpravo je preklicana.';
$string['discussthistopic'] = 'Razpravljaj o tej temi';
$string['discusstopicname'] = 'Sodeluj v razpravi o temi: {$a}';
$string['displayend'] = 'Konec prikaza';
$string['displayend_help'] = 'Ta nastavitev določa, ali naj bo forumska objava skrita po določenem datumu. Skrbniki lahko vedno vidijo forumske objave.';
$string['displayenddate'] = 'Prikaži konec: {$a}.';
$string['displaymode'] = 'Način prikaza';
$string['displayperiod'] = 'Obdobje prikaza';
$string['displaystart'] = 'Začetek prikaza';
$string['displaystart_help'] = 'Ta nastavitev določa, ali naj bo forumska objava prikazana po določenem datumu. Skrbniki lahko vedno vidijo forumske objave.';
$string['displaystartdate'] = 'Prikaži začetek: {$a}.';
$string['displaywordcount'] = 'Prikaži število besed';
$string['displaywordcount_help'] = 'Nastavitev določa, ali naj se število besed za vsako objavo prikaže ali ne.';
$string['duedate'] = 'Rok';
$string['duedate_help'] = 'To je takrat, ko objavljanje na forumu zapade. Čeprav je ta datum prikazan v koledarju kot datum zapadlosti za forum, je objavljanje dovoljeno tudi po tem datumu. Nastavite zaključni datum, da preprečite objavljanje na forumu po določenem datumu.';
$string['duedatetodisplayincalendar'] = 'Datum zapadlosti za prikaz v koledarju';
$string['eachuserforum'] = 'Vsaka oseba objavi eno razpravo';
$string['edit'] = 'Uredi';
$string['editedby'] = 'Uredil/-a {$a->name} – izvirni prispevek {$a->date}';
$string['editedpostupdated'] = 'Objava osebe {$a} je posodobljena';
$string['editing'] = 'Urejanje';
$string['emaildigestcompleteshort'] = 'Celotne objave';
$string['emaildigestdefault'] = 'Privzeto ({$a})';
$string['emaildigestoffshort'] = 'Brez izvlečka';
$string['emaildigestsubjectsshort'] = 'Samo zadeve';
$string['emaildigesttype'] = 'Možnosti e-poštnega izvlečka';
$string['emaildigesttype_help'] = 'Tip obvestila, ki ga boste prejeli za vsak forum.

* Privzeto – sledite nastavitvam izvlečkov v svojem profilu uporabnika. Če posodobite svoj profil, bo spremembra vidna tudi tukaj;
* Brez izvlečka – prejeli boste eno e-poštno sporočilo za vsako forumsko objavo;
* Izvleček – celotne objave - prejeli boste en e-poštni izvleček na dan, ki bo vsebovalo celotno vsebino vsake forumske objave;
* Izvleček – samo zadeve – prejeli boste en e-poštni izvleček na dan, ki bo vseboval predmet vsake forumske objave.';
$string['emptymessage'] = 'Nekaj je bilo narobe z vašo objavo. Morda ste jo pustili prazno ali pa je bila priponka prevelika. Vaše spremembe NISO bile shranjene.';
$string['errorcannotlock'] = 'Nimate dovoljenja za zaklepanje razprav.';
$string['erroremptymessage'] = 'Sporočilo objave ne sme biti prazno';
$string['erroremptysubject'] = 'Zadeva objave ne sme biti prazna.';
$string['errorenrolmentrequired'] = 'Za dostop do vsebine morate biti vpisani v ta predmet';
$string['errorwhiledelete'] = 'Pri brisanju zapisa je prišlo do napake.';
$string['eventassessableuploaded'] = 'Objavljena je bila vsebina.';
$string['eventcoursesearched'] = 'Predmet pregledan';
$string['eventdiscussioncreated'] = 'Razprava je bila ustvarjena';
$string['eventdiscussiondeleted'] = 'Razprava je bila izbrisana';
$string['eventdiscussionmoved'] = 'Razprava je bila premaknjena';
$string['eventdiscussionpinned'] = 'Razprava je bila pripeta';
$string['eventdiscussionsubscriptioncreated'] = 'Naročnina na razpravo je bila ustvarjena';
$string['eventdiscussionsubscriptiondeleted'] = 'Naročnina na razpravo je bila izbrisana';
$string['eventdiscussionunpinned'] = 'Razprava je bila odpeta';
$string['eventdiscussionupdated'] = 'Razprava je bila posodobljena';
$string['eventdiscussionviewed'] = 'Razprava je bila ogledana';
$string['eventpostcreated'] = 'Objava je bila ustvarjena';
$string['eventpostdeleted'] = 'Objava je bila izbrisana';
$string['eventpostupdated'] = 'Objava je bila posodobljena';
$string['eventreadtrackingdisabled'] = 'Onemogočili ste sledenje branja objav';
$string['eventreadtrackingenabled'] = 'Omogočili ste sledenje branja objav';
$string['eventsubscribersviewed'] = 'Naročniki so bili ogledani';
$string['eventsubscriptioncreated'] = 'Naročnina je ustvarjena';
$string['eventsubscriptiondeleted'] = 'Naročnina je izbrisana';
$string['eventuserreportviewed'] = 'Poročilo uporabnika je bilo ogledano';
$string['everyonecanchoose'] = 'Vsi se lahko naročijo';
$string['everyonecannowchoose'] = 'Zdaj se lahko vsi naročijo';
$string['everyoneisnowsubscribed'] = 'Zdaj so vsi naročeni na ta forum';
$string['everyoneissubscribed'] = 'Vsi so naročeni na ta forum';
$string['existingsubscribers'] = 'Obstoječi naročniki';
$string['export'] = 'Izvozi';
$string['exportattachmentname'] = 'Izvozi priponko {$a} v portfelj';
$string['exportdiscussion'] = 'Izvoz celotno razpravo v portfelj';
$string['exporthumandates'] = 'Datumi v človeku berljivi obliki';
$string['exporthumandates_help'] = 'Ali naj bodo datumi izvoženi v človeku berljivi obliki ali kot časovni žig (zaporedje številk).';
$string['exportoptions'] = 'Možnosti izvoza';
$string['exportstriphtml'] = 'Odstrani HTML';
$string['exportstriphtml_help'] = 'Ali naj bodo oznake HTML, kakršni sta p in br, odstranjene iz sporočila objave na forumu.';
$string['favourites'] = 'Označeno z zvezdico';
$string['favouriteupdated'] = 'Vaša možnost označevanja z zvezdico je bila posodobljena.';
$string['firstpost'] = 'Prva objava';
$string['forcedreadtracking'] = 'Omogoči prisilno sledenje prebranih objav';
$string['forcedreadtracking_desc'] = 'Omogoči, da forum prisilno sledi prebranim objavam. Določenim uporabnikom se bo zmanjšala učinkovitost delovanja sistema, še posebej pri predmetih z veliko forumi in objavami. Če to funkcijo izklopite, postanejo vsi forumi, ki so bili predhodno določeni kot prisilni, spet izbirni.';
$string['forcesubscribed'] = 'Naročnina na ta forum je obvezna za vse';
$string['forcesubscribed_help'] = 'Nastavitve tega foruma vam onemogočajo odjavo od razprav.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Dodaj nov forum';
$string['forum:addnews'] = 'Dodaj obvestila';
$string['forum:addquestion'] = 'Dodaj vprašanje';
$string['forum:allowforcesubscribe'] = 'Omogoči prisilno naročanje';
$string['forum:canoverridecutoff'] = 'Objavljaj na forumu po poteku roka.';
$string['forum:canoverridediscussionlock'] = 'Odgovori na zaklenjene razprave';
$string['forum:canposttomygroups'] = 'Objavljate v vseh skupinah, do katerih imate dostop';
$string['forum:cantogglefavourite'] = 'Označi razprave z zvezdicami';
$string['forum:createattachment'] = 'Ustvari priponke';
$string['forum:deleteanypost'] = 'Zbriši vse objave (kadarkoli)';
$string['forum:deleteownpost'] = 'Zbriši svoje objave (znotraj skrajnega roka)';
$string['forum:editanypost'] = 'Uredi katerokoli objavo';
$string['forum:exportdiscussion'] = 'Izvozi celotno razpravo';
$string['forum:exportforum'] = 'Izvoz foruma';
$string['forum:exportownpost'] = 'Izvozi svojo objavo';
$string['forum:exportpost'] = 'Izvozi objavo';
$string['forum:grade'] = 'Ocenjevanje foruma';
$string['forum:managesubscriptions'] = 'Upravljaj z naročniki';
$string['forum:movediscussions'] = 'Premakni razprave';
$string['forum:pindiscussions'] = 'Pripni razprave';
$string['forum:postprivatereply'] = 'Na objave odgovarjaj zasebno';
$string['forum:postwithoutthrottling'] = 'Izključi iz praga objave';
$string['forum:rate'] = 'Oceni objave';
$string['forum:readprivatereplies'] = 'Ogled zasebnih odgovorov';
$string['forum:replynews'] = 'Odgovori na obvestila';
$string['forum:replypost'] = 'Odgovori na objave';
$string['forum:splitdiscussions'] = 'Razdeli razprave';
$string['forum:startdiscussion'] = 'Začni nove razprave';
$string['forum:viewallratings'] = 'Poglej vse neobdelane ocenitve, ki so jih dali posamezniki';
$string['forum:viewanyrating'] = 'Ogled vseh ocen, ki jih je kdorkoli prejel';
$string['forum:viewdiscussion'] = 'Poglej razprave';
$string['forum:viewhiddentimedposts'] = 'Poglej skrite časovno omejene objave';
$string['forum:viewqandawithoutposting'] = 'Vedno prikaži objave z vprašanji in odgovori';
$string['forum:viewrating'] = 'Poglej vse svoje ocene';
$string['forum:viewsubscribers'] = 'Poglej naročnike';
$string['forumauthorhidden'] = 'Avtor (skrit)';
$string['forumblockingalmosttoomanyposts'] = 'Bližate se pragu dovoljenega števila objav. Objavili ste {$a->numposts}-krat v obdobju {$a->blockperiod}, omejitev objav pa je {$a->blockafter} na obdobje.';
$string['forumbodydeleted'] = 'Vsebina tega foruma je bila odstranjena in do nje ni več mogoče dostopati.';
$string['forumbodyhidden'] = 'Te objave si ne morete ogledati. Verjetno zato, ker še niste objavili v razpravi, ker najdaljši dovoljeni čas za urejanje še ni minil, ker se razprava še ni začela ali ker je razprava že potekla.';
$string['forumgrader'] = 'Ocenjevalnik foruma';
$string['forumgradingnavigation'] = 'Navigacija po ocenjevanju foruma';
$string['forumgradingpanel'] = 'Podokno za ocenjevanje foruma';
$string['forumintro'] = 'Opis';
$string['forumname'] = 'Ime foruma';
$string['forumposts'] = 'Forumske objave';
$string['forums'] = 'Forumi';
$string['forumsubjectdeleted'] = 'Ta forumska objava je bila odstranjena';
$string['forumsubjecthidden'] = 'Zadeva (skrito)';
$string['forumtracked'] = 'Sledenje neprebranim objavam je omogočeno';
$string['forumtrackednot'] = 'Sledenje neprebranim objavam je onemogočeno';
$string['forumtype'] = 'Tip foruma';
$string['forumtype_help'] = 'Na voljo je 5 različnih tipov foruma:

* Enojna preprosta razprava – samo ena tema za razpravo, v kateri lahko vsi sodelujejo (ni mogoče uporabiti pri ločenih skupinah).
* Forum vprašanj in odgovorov – udeleženci morajo najprej objaviti svoje mnenje, šele nato lahko vidijo objave drugih.
* Standardni forum za splošno rabo – odprt forum, kjer lahko kdorkoli kadarkoli začne novo razpravo.
* Standardni forum, prikazan v obliki bloga – odprt forum, kjer lahko kdorkoli kadarkoli začne novo razpravo. Teme za razpravo so prikazane na eni strani s povezavami »Razprava o tej temi«.
* Vsaka oseba objavi eno razpravo – vsak udeleženec lahko objavi natančno eno novo temo za razpravo, v kateri lahko nato vsi sodelujejo.';
$string['generalforum'] = 'Standardni forum za splošno rabo';
$string['generalforums'] = 'Splošni forumi';
$string['grade_forum_header'] = 'Ocenjevanje celotnega foruma';
$string['grade_forum_name'] = 'Celoten forum';
$string['grade_forum_title'] = 'Ocena';
$string['grade_rating_name'] = 'Ocena';
$string['graded'] = 'Ocenjeno';
$string['gradedby'] = 'Ocenil';
$string['gradeforrating'] = 'Ocena za ocenitev: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Ocena za ocenitev je skrita';
$string['gradeforwholeforum'] = 'Ocena za forum: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Ocena za forum je skrita';
$string['gradeitem:forum'] = 'Forum';
$string['gradeitemnameforrating'] = 'Ocena ocenitve za: {$a->name}';
$string['gradeitemnameforwholeforum'] = 'Ocena celotnega foruma za: {$a->name}';
$string['grades:gradesavedfor'] = 'Ocena shranjena za: {$a->fullname}';
$string['grades:gradesavefailed'] = 'Ocene ni bilo mogoče shraniti za {$a->fullname} : {$a->error}';
$string['gradeusers'] = 'Oceni uporabnike';
$string['grading'] = 'Ocenjevanje';
$string['gradingstatus'] = 'Stanje ocene:';
$string['hiddenforumpost'] = 'Skrite objave na forumu';
$string['hidegraderpanel'] = 'Skrij podokno za ocenjevanje';
$string['hidepreviousrepliescount'] = 'Skrij prejšnje odgovore ({$a})';
$string['hideusersearch'] = 'Skrij iskanje uporabnikov';
$string['indexoutoftotal'] = '{$a->index} od {$a->total}';
$string['indicator:cognitivedepth'] = 'Forum kognitivno';
$string['indicator:cognitivedepth_help'] = 'Indikator temelji na oceni kognitivne širine, ki jo je udeleženec dosegel v dejavnosti Forum.';
$string['indicator:cognitivedepthdef'] = 'Forum kognitivno';
$string['indicator:cognitivedepthdef_help'] = 'Sodelujoči je v tem intervalu analize dosegel ta odstotek kognitivne angažiranosti, ki jo ponujajo aktivnosti foruma tekom intervala te analize (Ravni = Brez ogleda, Ogled, Oddaja, Ogled pripomb, Komentiranje povratnih informacij, Ponovna oddaja po ogledu povratnih informacij)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Forum družbeno';
$string['indicator:socialbreadth_help'] = 'Indikator temelji na oceni družbene širine, ki jo je udeleženec dosegel v dejavnosti Forum.';
$string['indicator:socialbreadthdef'] = 'Forum družbeno';
$string['indicator:socialbreadthdef_help'] = 'Sodelujoči je v tem intervalu analize dosegel ta odstotek družbene angažiranosti, ki jo ponujajo aktivnosti foruma tekom intervala te analize (Ravni = Brez udeležbe, Samo udeleženec, Udeleženec z drugimi udeleženci)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = 'v {$a}';
$string['inreplyto'] = 'V odgovor na {$a}';
$string['introblog'] = 'Objave na tem forumu so bile sem kopirane samodejno iz blogov uporabnikov v tem predmetu, ker ti blog vnosi niso več na voljo';
$string['intronews'] = 'Splošne novice in obvestila';
$string['introsocial'] = 'Odprt forum za pogovor o poljubni temi';
$string['introteacher'] = 'Forum z opombami in razpravami samo za učitelje';
$string['invalidaccess'] = 'Nepravilen dostop do te strani';
$string['invaliddigestsetting'] = 'Določili ste neveljavno nastavitev e-poštnega izvlečka';
$string['invaliddiscussionid'] = 'ID razprave je napačen ali ne obstaja več';
$string['invalidforcesubscribe'] = 'Neveljavni način prisilnega naročanja';
$string['invalidforumid'] = 'ID foruma je nepravilen';
$string['invalidparentpostid'] = 'ID nadrejene objave je nepravilen';
$string['invalidpostid'] = 'Nepravilen ID objave - {$a}';
$string['lastpost'] = 'Zadnja objava';
$string['learningforums'] = 'Izobraževalni forumi';
$string['lockdiscussion'] = 'Zakleni to razpravo';
$string['lockdiscussionafter'] = 'Po obdobju nedejavnosti razprave zakleni';
$string['lockdiscussionafter_help'] = 'Razprave se lahko samodejno zaklenejo, ko po zadnjem odgovoru poteče določen čas.

Uporabniki, ki lahko odgovarjajo na zaklenjene razprave, lahko razpravo odklenejo, tako da nanjo odgovorijo.';
$string['locked'] = 'Zaklenjeno';
$string['lockupdated'] = 'Možnost zaklepanja je bila posodobljena.';
$string['longpost'] = 'Dolga objava';
$string['mailnow'] = 'Obvestila o objavah na forumu pošlji takoj, brez zakasnitve za urejenja';
$string['managesubscriptionsoff'] = 'Končaj upravljanje z naročninami';
$string['managesubscriptionson'] = 'Upravljaj z naročniki';
$string['manydiscussions'] = 'Razprav na stran';
$string['markalldread'] = 'Označi vse objave v tej razpravi kot prebrane.';
$string['markallread'] = 'Označi vse objave v tem forumu kot prebrane.';
$string['markasread'] = 'Označi kot prebrano';
$string['markasreadonnotification'] = 'Ko pošiljam obvestila o objavah na forumu';
$string['markasreadonnotification_help'] = 'Ko ste obveščeni o objavi na forumu, lahko izberete, ali naj se objava hkrati označi kot prebrana za namene sledenja forumu.';
$string['markasreadonnotificationno'] = 'Ne označi objave kot prebrano';
$string['markasreadonnotificationyes'] = 'Označi objavo kot prebrano';
$string['markread'] = 'Označi kot prebrano';
$string['markreadbutton'] = 'Označi<br />kot prebrano';
$string['markunread'] = 'Označi kot neprebrano';
$string['markunreadbutton'] = 'Označi<br />kot neprebrano';
$string['maxattachments'] = 'Največje število priponk';
$string['maxattachments_help'] = 'Ta nastavitev določa največje število datotek, ki jih lahko pripnemo forumski objavi.';
$string['maxattachmentsize'] = 'Največja velikost priponke';
$string['maxattachmentsize_help'] = 'Ta nastavitev določa največjo velikost datoteke, ki jo lahko pripnemo forumski objavi.';
$string['maxtimehaspassed'] = 'Časovno obdobje za urejanje te objave ({$a}) je poteklo!';
$string['message'] = 'Sporočilo';
$string['messageinboundattachmentdisallowed'] = 'Vašega odgovora ni bilo mogoče objaviti, ker vsebuje priponko, forum pa ne dovoli priponk.';
$string['messageinboundfilecountexceeded'] = 'Vašega odgovora ni bilo mogoče objaviti, ker vsebuje več priponk, kot jih forum dovoli ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Vašega odgovora ni bilo mogoče objaviti, ker je skupna velikost priponk ({$a->filesize}) večja, kot jo forum dovoli ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Vašega odgovora ni bilo mogoče objaviti, ker forum trenutno ni na voljo.';
$string['messageinboundnopostforum'] = 'Vašega odgovora ni bilo mogoče objaviti, ker nimate dovoljenja za objavljanje v forumu {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Vašega odgovora ni bilo mogoče objaviti. Presegli ste prag dovoljenih objav, nastavljen za ta forum';
$string['messageprovider:digests'] = 'Naročeni forumski izvlečki';
$string['messageprovider:posts'] = 'Naročene forumske objave';
$string['missingsearchterms'] = 'Naslednji iskani izrazi se pojavijo zgolj v oznakah HTML tega sporočila:';
$string['modeflatnewestfirst'] = 'Prikaži odgovore ravno, najprej najnovejše';
$string['modeflatoldestfirst'] = 'Prikaži odgovore ravno, najprej najstarejše';
$string['modenested'] = 'Prikaži odgovore v vgnezdeni obliki';
$string['modenestedv2'] = 'Prikaži odgovore v eksperimentalni ugnezdeni obliki';
$string['modethreaded'] = 'Prikaži odgovore kot niz';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Modul dejavnosti na forumu omogoča sodelujočim izvajanje asinhronih razprav – razprav, ki se vršijo skozi daljše časovno obdobje.

Izbirate lahko med več tipi forumov, kot so privzeti forum, kjer lahko vsakdo kadarkoli začne novo razpravo; forum, kjer vsak sodelujoči lahko objavi samo eno razpravo; ali forum vprašanj in odgovorov, kjer morajo sodelujoči najprej objaviti svoj odgovor, preden lahko preberejo objave drugih sodelujočih. Učitelj lahko omogoči pripenjanje datotek k objavam. Pripete slike se prikažejo v objavi na forumu.

Sodelujoči se na forumu lahko naročijo na prejemanje obvestil o novih objavah. Učitelj lahko nastavi način obvestil na izbirna, prisilna ali samodejna, ali pa naročanje na obvestila prepreči. Po potrebi lahko sodelujočim v določenem časovnem obdobju onemogoči več kot določeno število objav in s tem posameznikom prepreči, da prevzamejo razpravo.

Objave na forumih lahko ocenjujejo učitelji ali sodelujoči (vrstniško vrednotenje). Ocenitve se lahko seštejejo v končno oceno, ki je zabeležena v redovalnici.

Forumi se lahko uporabljajo v različne namene:

* kot prostor za druženje in spoznavanje sodelujočih,
* za obvestila predmeta (uporaba foruma novic s prisilno naročnino,
* za razpravo o vsebini predmeta ali študijskega gradiva,
* za nadaljevanje razprave s predavanj,
* za razprave med učitelji (uporaba skritega foruma),
* kot podporni center, kjer lahko svetujejo tutorji in drugi sodelujoči,
* kot podporno okolje za individualno komunikacijo med učiteljem in sodelujočim (uporaba foruma z ločenimi skupinami in enim sodelujočim na skupino),
* za dodatne dejavnosti, npr. reševanje miselnih problemov (ang. brain teasers).';
$string['modulename_link'] = 'mod/forum/pogled';
$string['modulenameplural'] = 'Forumi';
$string['more'] = 'več';
$string['movedmarker'] = '(Premaknjeno)';
$string['movethisdiscussionlabel'] = 'Premakni trenutno razpravo na določen forum';
$string['movethisdiscussionto'] = 'Premakni to razpravo v ...';
$string['mustprovidediscussionorpost'] = 'Za izvoz morate priskrbeti ID razprave ali ID objave';
$string['myprofileotherdis'] = 'Razprave v forumu';
$string['myprofileowndis'] = 'Moje razprave v forumu';
$string['myprofileownpost'] = 'Moje objave v forumu';
$string['namenews'] = 'Obvestila';
$string['namenews_help'] = 'Forum novic je poseben forum, ki se samodejno ustvari za vsak predmet. V vsakem predmetu imate lahko le en forum novic. Novice lahko objavljajo le učitelji in skrbniki. Blok "Zadnje novice" prikazuje nedavne objave.';
$string['namesocial'] = 'Družabni forum';
$string['nameteacher'] = 'Učiteljski forum';
$string['newforumposts'] = 'Nove objave v forumu';
$string['nextdiscussiona'] = 'Naslednja razprava: {$a}';
$string['nextuser'] = 'Shrani spremembe in nadaljuj k naslednjemu uporabniku';
$string['noattachments'] = 'Ta objava ne vsebuje priponk';
$string['nodiscussions'] = 'V tem forumu še ni tem razprave';
$string['nodiscussionsstartedby'] = '{$a} še ni začel nobene razprave';
$string['nodiscussionsstartedbyyou'] = 'Začeli niste še nobene razprave';
$string['noguestpost'] = 'Gostom objavljanje ni dovoljeno.';
$string['noguestsubscribe'] = 'Žal gostom naročanje ni dovoljeno.';
$string['noguesttracking'] = 'Žal gostom nastavljanje možnosti sledenja ni dovoljeno.';
$string['nomorepostscontaining'] = 'Ni bilo mogoče najti nobene objave, ki bi vsebovala \'{$a}\'';
$string['nonews'] = 'Ni še objavljenih obvestil';
$string['noonecansubscribenow'] = 'Naročnine odslej niso dovoljene';
$string['nopermissiontosubscribe'] = 'Nimate dovoljenja za ogled naročnikov na forum';
$string['nopermissiontoview'] = 'Nimate dovoljenja za ogled te objave';
$string['nopostforum'] = 'Žal nimate dovoljenja za objavljanje v tem forumu';
$string['noposts'] = 'Ni objav';
$string['nopostsmadebyuser'] = '{$a} ni še ničesar objavil';
$string['nopostsmadebyyou'] = 'Še ničesar niste objavili';
$string['noquestions'] = 'V tem forumu še ni vprašanj';
$string['nosubscribers'] = 'Za ta forum še ni naročnikov';
$string['notexists'] = 'Razprava ne obstaja več';
$string['notgraded'] = 'Neocenjeno';
$string['nothingnew'] = 'Nič novega za {$a}';
$string['notingroup'] = 'Za ogled foruma morate biti del skupine.';
$string['notinstalled'] = 'Forumski modul ni nameščen';
$string['notlocked'] = 'Zakleni';
$string['notpartofdiscussion'] = 'Ta objava ni del razprave!';
$string['notrackforum'] = 'Ne sledi neprebranim objavam';
$string['notsubscribed'] = 'Naročite se';
$string['nousersmatch'] = 'Za dane kriterije ni bilo najdenih uporabnikov';
$string['noviewdiscussionspermission'] = 'Nimate dovoljenja za ogled razprav v tem forumu';
$string['nowallsubscribed'] = 'Naročeni ste na vse forume v {$a}.';
$string['nowallunsubscribed'] = 'Naročnina na vse forume v {$a} je preklicana.';
$string['nowgradinguser'] = 'Ocenjujete {$a}';
$string['nownotsubscribed'] = '{$a->name} NE bo obveščen o novih objavah v \'{$a->forum}\'.';
$string['nownottracking'] = '{$a->name} ne sledi več \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} bo obveščen o novih objavah v \'{$a->forum}\'.';
$string['nowtracking'] = '{$a->name} zdaj sledi \'{$a->forum}\'.';
$string['numberofreplies'] = 'Število odgovorov: {$a}';
$string['numposts'] = 'Št. objav: {$a}';
$string['olderdiscussions'] = 'Starejše razprave';
$string['oldertopics'] = 'Starejše teme';
$string['oldpostdays'] = 'Prebrano po dneh';
$string['page-mod-forum-discuss'] = 'Stran modula forum z nizom razprav';
$string['page-mod-forum-view'] = 'Glavna stran modula forum';
$string['page-mod-forum-x'] = 'Katerakoli stran modula forum';
$string['parent'] = 'Pokaži nadrejenega';
$string['parentofthispost'] = 'Nadrejeni te objave';
$string['permalink'] = 'Trajna povezava';
$string['permanentlinktoparentpost'] = 'Stalna povezava do nadrejene objave';
$string['permanentlinktopost'] = 'Stalna povezava do te objave';
$string['pindiscussion'] = 'Pripni to razpravo';
$string['pinupdated'] = 'Možnost pripetja je bila posodobljena.';
$string['pluginadministration'] = 'Skrbništvo foruma';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Vaša objava je bila uspešno dodana.</p> <p>Imate {$a} za urejanje objave, če želite karkoli spremeniti.</p>';
$string['postaddedsuccess'] = 'Vaša objava je bila uspešno dodana.';
$string['postaddedtimeleft'] = 'Imate {$a} za urejanje objave, če želite karkoli spremeniti.';
$string['postbymailsuccess'] = 'Vaša forumska objava z zadevo "{$a->subject}" je bila uspešno dodana. Ogledate si jo lahko na {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'Vaša <a href="{$a->discussionurl}">forumska objava</a> z zadevo "{$a->subject}" je bila uspešno dodana.';
$string['postbyuser'] = '{$a->post}, {$a->user}';
$string['postincontext'] = 'Oglej si objavo v kontekstu';
$string['postisprivatereply'] = 'To je zasebni odgovor. Drugi sodelujoči ga ne morejo videti.';
$string['postmailinfo'] = 'To je kopija sporočila, objavljenega na spletni strani {$a}.

Če želite nanj odgovoriti, kliknite na to povezavo:';
$string['postmailinfolink'] = 'To je kopija sporočila, objavljenega v {$a->coursename}.

Če želite nanj odgovoriti, kliknite na to povezavo: {$a->replylink}';
$string['postmailnow'] = '<p>Ta objava bo avtomatsko poslana vsem naročnikom foruma.</p>';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Večinoma ločeno znanje';
$string['postrating2'] = 'Ločeno in povezano';
$string['postrating3'] = 'Večinoma povezano znanje';
$string['posts'] = 'Objave';
$string['postsfrom'] = 'Objave od';
$string['postsmadebyuser'] = 'Objave udeleženca {$a}';
$string['postsmadebyuserincourse'] = 'Razprave, ki jih je začel/-a {$a->fullname} pri predmetu {$a->coursename}';
$string['poststo'] = 'Objave do';
$string['posttoforum'] = 'Objavi v forumu';
$string['posttomygroups'] = 'Objavi kopijo v vseh skupinah';
$string['posttomygroups_help'] = 'Objavite kopijo tega sporočila v vseh skupinah, do katerih imate dostop. Sodelujoči v skupinah, do katerih nimate dostopa, te objave ne bodo videli';
$string['postupdated'] = 'Vaša objava je posodobljena';
$string['potentialsubscribers'] = 'Potencialni naročniki';
$string['prevdiscussiona'] = 'Prejšnja razprava: {$a}';
$string['previoususer'] = 'Shrani spremembe in nadaljuj k prejšnjemu uporabniku';
$string['privacy:digesttypenone'] = 'Za ta forum nimamo podatkov, povezanih z želenim tipom forumskih izvlečkov.';
$string['privacy:digesttypepreference'] = 'Izbrali ste naslednji tip forumskih izvlečkov: »{$a->type}«.';
$string['privacy:discussionsubscriptionpreference'] = 'Za ta forum ste izbrali sledečo možnost naročnine na razpravo: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Forum uporablja podsistem ocen, ki podpira ocenjevanje objav.';
$string['privacy:metadata:core_tag'] = 'Forum uporablja podsistem oznak, ki podpira označevanje objav.';
$string['privacy:metadata:forum_digests'] = 'Informacije o nastavitvah izvlečkov za vsak forum.';
$string['privacy:metadata:forum_digests:forum'] = 'Forum, na katerega ste naročeni.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Nastavitve izvlečkov.';
$string['privacy:metadata:forum_digests:userid'] = 'ID uporabnika z nastavitvami izvlečka.';
$string['privacy:metadata:forum_discussion_subs'] = 'Informacije o naročninah na individualne forumske razprave';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'ID razprave, na katero ste se naročili.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Začetek naročnine.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'ID uporabnika, ki je naročen na razpravo.';
$string['privacy:metadata:forum_discussions'] = 'Informacije o individualnih forumskih razpravah, ki jih je uporabnik ustvaril';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - kaj je shranjeno v tem polju';
$string['privacy:metadata:forum_discussions:name'] = 'Ime razprave, ki ga je izbral avtor.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Čas zadnje spremembe razprave.';
$string['privacy:metadata:forum_discussions:userid'] = 'ID uporabnika, ki je ustvaril razpravo';
$string['privacy:metadata:forum_discussions:usermodified'] = 'ID uporabnika, ki je zadnji spremenil razpravo.';
$string['privacy:metadata:forum_grades'] = 'Podatki o ocenah za ta forum';
$string['privacy:metadata:forum_grades:forum'] = 'Ocenjeni forum';
$string['privacy:metadata:forum_grades:grade'] = 'Dodeljena ocena';
$string['privacy:metadata:forum_grades:userid'] = 'Ocenjeni uporabnik';
$string['privacy:metadata:forum_posts'] = 'Informacije o nastavitvah izvlečkov za vsak forum.';
$string['privacy:metadata:forum_posts:created'] = 'Čas, ko je bila objava ustvarjena.';
$string['privacy:metadata:forum_posts:discussion'] = 'Razprava, v kateri se nahaja objava.';
$string['privacy:metadata:forum_posts:message'] = 'Sporočilo forumske objave.';
$string['privacy:metadata:forum_posts:modified'] = 'Čas zadnje spremembe objave.';
$string['privacy:metadata:forum_posts:parent'] = 'Nadrejena objava, h kateri je bil dodan odgovor.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'ID uporabnika, kateremu je bil poslan ta odgovor.';
$string['privacy:metadata:forum_posts:subject'] = 'Zadeva forumske objave.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Sporočilo forumske objave.';
$string['privacy:metadata:forum_posts:userid'] = 'ID uporabnika, ki je avtor forumske objave.';
$string['privacy:metadata:forum_queue'] = 'Začasni dnevnik objav, ki bodo poslane po e-pošti v obliki izvlečka';
$string['privacy:metadata:forum_queue:discussionid'] = 'ID razprave v forumu';
$string['privacy:metadata:forum_queue:postid'] = 'ID forumske objave';
$string['privacy:metadata:forum_queue:timemodified'] = 'Spremenjeni čas izvirne objave';
$string['privacy:metadata:forum_queue:userid'] = 'Uporabnik, ki mora dobiti obvestilo o objavi';
$string['privacy:metadata:forum_read'] = 'Informacije o objavah, ki jih je uporabnik prebral.';
$string['privacy:metadata:forum_read:discussionid'] = 'Razprava, v kateri se nahaja objava.';
$string['privacy:metadata:forum_read:firstread'] = 'Čas, ko je bila objava prvič prebrana.';
$string['privacy:metadata:forum_read:lastread'] = 'Čas, ko je bila objava nazadnje prebrana.';
$string['privacy:metadata:forum_read:postid'] = 'Prebrana objava.';
$string['privacy:metadata:forum_read:userid'] = 'ID uporabnika, s katerim je povezan ta zapis.';
$string['privacy:metadata:forum_subscriptions'] = 'Informacije o forumih, na katere se je naročil uporabnik.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Forum, na katerega ste naročeni.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'ID uporabnika, s katerim je povezana naročnina na forum.';
$string['privacy:metadata:forum_track_prefs'] = 'Informacije o forumih, za katere se je uporabnik odločil, da bo sledil prebranim objavam.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Forum, ki ima omogočeno sledenje prebranih objav.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'ID uporabnika, s katerim je povezana nastavitev sledenja temu forumu.';
$string['privacy:metadata:preference:autosubscribe'] = 'Možnost naročnine na razprave, ko odgovarjate na objave v njih.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Želeni vrstni red razvrščanja za seznam razprav';
$string['privacy:metadata:preference:maildigest'] = 'Nastavitev elektronskega pošiljanja izvlečkov po celotnem spletnem mestu';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Možnost označevanja forumskih objav kot prebranih, ko jih prejmete kot sporočila.';
$string['privacy:metadata:preference:trackforums'] = 'Možnost omogočenja sledenja prebranih objav.';
$string['privacy:postwasread'] = 'Ta objava je bila prvič prebrana {$a->firstread} in nazadnje {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Izbrali ste, da ne boste sledili objavam, ki ste jih prebrali v tem forumu.';
$string['privacy:request:delete:discussion:name'] = 'Izbriši na avtorjevo zahtevo';
$string['privacy:request:delete:post:message'] = 'Vsebina te objave je bila izbrisana na avtorjevo zahtevo.';
$string['privacy:request:delete:post:subject'] = 'Izbriši na avtorjevo zahtevo';
$string['privacy:subscribedtoforum'] = 'Naročeni ste na ta forum.';
$string['privatereply'] = 'Zasebni odgovor';
$string['privatereply_help'] = 'Zasebni odgovor lahko vidi samo avtor objave, na katero odgovarjate in uporabniki, ki imajo vpogled v zasebne odgovore.';
$string['processingdigest'] = 'Obdelava e-poštnega izvlečka za uporabnika {$a}';
$string['processingpost'] = 'Obdelava objave {$a}';
$string['prune'] = 'Razdeli';
$string['prunedpost'] = 'Iz te objave je bila ustvarjena nova razprava';
$string['pruneheading'] = 'Razdeli razpravo in premakni to objavo v novo razpravo';
$string['qandaforum'] = 'Forum vprašanj in odgovorov';
$string['qandanotify'] = 'To je forum vprašanj in odgovorov. Če želite videli druge odzive na ta vprašanja, morate najprej objaviti svoj odgovor';
$string['re'] = 'Re:';
$string['readtherest'] = 'Preberi preostanek te teme';
$string['removeallforumtags'] = 'Odstrani vse oznake foruma';
$string['removefromfavourites'] = 'Odstrani zvezdico pri tej razpravi';
$string['replies'] = 'Odgovori';
$string['repliesmany'] = 'Št. odgovorov do zdaj: {$a}';
$string['repliesone'] = 'Št. odgovorov do zdaj: {$a}';
$string['reply'] = 'Odgovor';
$string['reply_handler'] = 'Odgovori na forumske objave prek e-pošte';
$string['reply_handler_name'] = 'Odgovori na forumske objave';
$string['replyauthorself'] = '{$a} (vi)';
$string['replyforum'] = 'Odgovori na forum';
$string['replyingtoauthor'] = 'Odgovarjate na objavo od {$a}...';
$string['replyplaceholder'] = 'Napišite svoj odgovor …';
$string['replytopostbyemail'] = 'Odgovorite lahko prek e-pošte.';
$string['replytouser'] = 'Uporabi e-poštni naslov v odgovoru';
$string['resetdigests'] = 'Izbriši vse uporabniške nastavitve izvlečkov foruma';
$string['resetforums'] = 'Izbriši objave od';
$string['resetforumsall'] = 'Izbriši vse objave';
$string['resetsubscriptions'] = 'Izbriši vse naročnine na forum';
$string['resettrackprefs'] = 'Odstrani vse nastavitve za sledenje forumov';
$string['rssarticles'] = 'Število nedavnih člankov RSS';
$string['rssarticles_help'] = 'Ta nastavitev določa številko člankov (razprav ali objav), ki jih lahko vsebuje vir RSS. Običajno je sprejemljivo število med 5 in 20.';
$string['rsssubscriberssdiscussions'] = 'Vir RSS za razprave';
$string['rsssubscriberssposts'] = 'Vir RSS za objave';
$string['rsstype'] = 'Vir RSS za to dejavnost';
$string['rsstype_help'] = 'Če želite omogočiti vir RSS za to dejavnost, izberite razprave ali objave, ki naj jih vsebuje vir.';
$string['rsstypedefault'] = 'Tip vira RSS';
$string['search'] = 'Išči';
$string['search:activity'] = 'Forum - informacije o dejavnosti';
$string['search:post'] = 'Forum - objave';
$string['searchdatefrom'] = 'Objave morajo biti novejše od';
$string['searchdateto'] = 'Objave morajo biti starejše od';
$string['searchforumintro'] = 'Vnesite iskalne izraze v eno ali več sledečih polj:';
$string['searchforums'] = 'Išči po forumih';
$string['searchfullwords'] = 'Te besede se morajo pojaviti kot cele besede';
$string['searchnotwords'] = 'Teh besed NE sme biti v objavi';
$string['searcholderposts'] = 'Išči starejše objave ...';
$string['searchphrase'] = 'V objavi se mora pojaviti natanko ta fraza';
$string['searchresults'] = 'Rezultati iskanja';
$string['searchsubject'] = 'V zadevi morajo biti te besede';
$string['searchtags'] = 'Označeno z';
$string['searchuser'] = 'To ime se mora ujemati z avtorjem';
$string['searchuserid'] = 'Moodle ID avtorja';
$string['searchusers'] = 'Iskanje uporabnikov';
$string['searchwhichforums'] = 'Izberite, po katerih forumih želite iskati';
$string['searchwords'] = 'Kjerkoli v objavi se lahko pojavijo te besede';
$string['seeallposts'] = 'Oglejte si vse objave tega uporabnika';
$string['sendstudentnotificationsdefault'] = 'Privzeta nastavitev za "Opozori udeležence"';
$string['sendstudentnotificationsdefault_help'] = 'Nastavi privzeto vrednost za potrditveno polje »Opozori udeležence« na obrazcu za ocenjevanje.';
$string['sendstudentnotificationsno'] = 'Ne';
$string['sendstudentnotificationsyes'] = 'Da, pošiljaj obvestila udeležencu';
$string['settings'] = 'Nastavitve';
$string['shortpost'] = 'Kratka objava';
$string['showgraderpanel'] = 'Prikaži podokno za ocenjevanje';
$string['showingcountoftotaldiscussions'] = 'Seznam razprav. Prikaz {$a->count} od {$a->total} razprav';
$string['showmoreusers'] = 'Prikaži več uporabnikov';
$string['showpreviousrepliescount'] = 'Prikaži prejšnje odgovore ({$a})';
$string['showsubscribers'] = 'Prikaži/uredi trenutne naročnike';
$string['showusersearch'] = 'Prikaži iskanje uporabnikov';
$string['singleforum'] = 'Enojna preprosta razprava';
$string['smallmessage'] = '{$a->user} je objavil v {$a->forumname}';
$string['smallmessagedigest'] = 'Izvleček foruma vsebuje {$a} sporočil';
$string['starredonly'] = 'Išči samo razprave, označene z zvezdico';
$string['startedby'] = 'Začel/-a';
$string['subject'] = 'Zadeva';
$string['subscribe'] = 'Naroči se na ta forum';
$string['subscribeall'] = 'Naroči vse na ta forum';
$string['subscribed'] = 'Naročen';
$string['subscribediscussion'] = 'Naroči se na to razpravo';
$string['subscribeenrolledonly'] = 'Oprostite toda samo vpisanim uporabnikom je dovoljeno naročiti se na obvestila o objavi na forumu.';
$string['subscribenone'] = 'Odjavi vse iz tega foruma';
$string['subscribers'] = 'Naročniki';
$string['subscriberstowithcount'] = 'Naročeni na "{$a->name}" ({$a->count})';
$string['subscribestart'] = 'Pošlji mi obvestila o novih objavah na tem forumu';
$string['subscribestop'] = 'Ne želim biti obveščen o novih objavah na tem forumu';
$string['subscription'] = 'Naročnina';
$string['subscription_help'] = 'Če ste naročeni na forum, boste prejeli obvestilo o novih objavah na forumu. Običajno lahko sami izberete ali želite ali ne želite biti naročeni. Včasih je lahko naročnina vsiljena, tako da vsi prejmejo obvestila.';
$string['subscriptionandtracking'] = 'Naročnina in sledenje';
$string['subscriptionauto'] = 'Samodejno naročanje';
$string['subscriptiondisabled'] = 'Naročanje onemogočeno';
$string['subscriptionforced'] = 'Prisilno naročanje';
$string['subscriptionmode'] = 'Način naročanja';
$string['subscriptionmode_help'] = 'Ko je sodelujoči naročen na forum bo prejemal obvestila o objavah na forumu. Na voljo so 4 tipi naročnin:

* Izbirna naročnina – Sodelujoči lahko izberejo ali želijo biti naročeni
* Prisiljena naročnina – Vsi so naročeni in se ne morejo odnaročiti
* Avtomatska naročnina – Na začetku so vsi naročeni, a lahko naročnino kadarkoli prekličejo
* Naročnina onemogočena – Naročnina ni dovoljena';
$string['subscriptionoptional'] = 'Neobvezno naročanje';
$string['subscriptions'] = 'Naročnine';
$string['tagarea_forum_posts'] = 'Forumske objave';
$string['tagsdeleted'] = 'Forumske oznake so bile izbrisane';
$string['thisforumhasduedate'] = 'Datum zapadlosti za objavljanje na tem forumu je {$a}.';
$string['thisforumisdue'] = 'Datum zapadlosti za objavljanje na tem forumu je bil {$a}.';
$string['thisforumisthrottled'] = 'Ta forum ima omejitev števila dovoljenih objav v določenem časovnem obdobju – to je trenutno nastavljeno na {$a->blockafter} objav v obdobju {$a->blockperiod}';
$string['timed'] = 'Časovno omejeno';
$string['timeddiscussion'] = 'Časovno omejena razprava';
$string['timedhidden'] = 'Časovno omejeno stanje: skrito za udeležence';
$string['timedposts'] = 'Časovno omejene objave';
$string['timedvisible'] = 'Časovno omejeno stanje: vidno za vse uporabnike';
$string['timestartenderror'] = 'Končni datum prikaza ne more biti pred začetnim datumom';
$string['togglediscussionmenu'] = 'Preklopi v meni za razprave';
$string['togglefullscreen'] = 'Preklopi v celozaslonski način';
$string['togglesettingsdrawer'] = 'Preklopi v nastavitveni predal';
$string['trackforum'] = 'Sledi neprebrane objave';
$string['tracking'] = 'Sledenje';
$string['trackingoff'] = 'Izključeno';
$string['trackingon'] = 'Prisiljeno';
$string['trackingoptional'] = 'Neobvezno';
$string['trackingtype'] = 'Sledenje prebranih objav';
$string['trackingtype_help'] = 'Sledenje branega, z označevanjem novih objav, omogoča sodelujočim, da enostavno preverijo, katerih objav še niso videli.

Če je nastavljeno na neobvezno lahko sodelujoči izberejo ali želijo sledenje vklopiti ali izklopiti. To storijo s povezavo v ukaznem meniju ali skrbniškem bloku (odvisno od teme). Uporabniki morajo tudi omogočiti sledenje v nastavitvah foruma v svojem profilu.

Če je v skrbništvu spletnega mesta omogočena možnost \'Omogoči vsiljeno sledenje prebranih objav\', je na voljo dodatna možnost – Vsiljeno. To pomeni, da je sledenje branja vklopljeno ne glede na uporabnikove nastavitve foruma.';
$string['trackreadposts_header'] = 'Sledenje forumu';
$string['unlockdiscussion'] = 'Odkleni razpravo';
$string['unpindiscussion'] = 'Odpni razpravo';
$string['unread'] = 'Neprebrano';
$string['unreadpost'] = 'Neprebrana objava';
$string['unreadposts'] = 'Neprebrane objave';
$string['unreadpostsnumber'] = 'Št. neprebranih objav: {$a}';
$string['unreadpostsone'] = 'Št. neprebranih objav: 1';
$string['unsubscribe'] = 'Odjavi naročnino na ta forum';
$string['unsubscribeall'] = 'Odjavi naročnino na vse forume';
$string['unsubscribeallconfirm'] = 'Trenutno ste naročeni na {$a->forums} forumov in {$a->discussions} razprav. Ali resnično želite odpovedati naročnino na vse forume in razprave ter onemogočiti samodejno naročanje na razprave?';
$string['unsubscribeallconfirmdiscussions'] = 'Trenutno ste naročeni na {$a->discussions} razprav. Ali se res želite odjaviti z vseh razprav in onemogočiti samodejno naročanje na razprave?';
$string['unsubscribeallconfirmforums'] = 'Trenutno ste naročeni na {$a->forums} forumov. Ali se res želite odjaviti z vseh forumov in razprav in onemogočiti samodejno naročanje na razprave?';
$string['unsubscribealldone'] = 'Vse vaše neobvezne naročnine na forumih so bile odstranjene, še vedno pa boste lahko prejeli obvestila iz forumov, ki imajo vsiljeno naročnino. Obvestila iz forumov lahko upravljate v nastavitvah obvestil v vašem profilu';
$string['unsubscribeallempty'] = 'Žal niste naročeni na noben forum. Vsa obvestila iz tega strežnika lahko onemogočite v nastavitvah obvestil v vašem profilu.';
$string['unsubscribed'] = 'Odjavljena naročnina';
$string['unsubscribediscussion'] = 'Odjavi naročnino na to razpravo';
$string['unsubscribediscussionlink'] = 'Odjavi naročnino na to razpravo: {$a}';
$string['unsubscribelink'] = 'Odjavi naročnino na ta forum: {$a}';
$string['unsubscribeshort'] = 'Odjavi';
$string['useexperimentalui'] = 'Uporabi pogled eksperimentalne ugnezdene razprave';
$string['usermarksread'] = 'Ročno označevanje prebranih sporočil';
$string['usernavigation'] = 'Navigacija med uporabniki';
$string['usersforumposts'] = 'Uporabnikove objave na forumu';
$string['viewalldiscussions'] = 'Oglej si vse razprave';
$string['viewconversation'] = 'Ogled razprave';
$string['viewgrades'] = 'Poglej ocene';
$string['viewparentpost'] = 'Ogled nadrejene objave';
$string['viewthediscussion'] = 'Poglej razpravo';
$string['warnafter'] = 'Prag objav za opozorilo';
$string['warnafter_help'] = 'Udeleženci lahko prejmejo opozorilo, ko se približajo največjemu dovoljenemu številu objav v določenem obdobju. Ta nastavitev določa, po koliko objavah bodo opozorjeni. Uporabniki z zmožnostjo mod/forum:postwithoutthrottling so izvzeti iz omejitev števila objav.';
$string['warnformorepost'] = 'Pozor! V tem forumu je več kot ena razprava - uporabljajte najnovejšo';
$string['yournewquestion'] = 'Vaše novo vprašanje';
$string['yournewtopic'] = 'Vaša nova tema razprave';
$string['yourreply'] = 'Vaš odgovor';
