<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'sl', version '4.1'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TODO';
$string['activityisscheduledfordeletion'] = 'Brisanje dejavnosti v teku...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" ni veljavna vrednost za starost.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" ima več ali manj kot eno vejico kot ločitveni znak.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" ni veljavna vrednost za državo.';
$string['agedigitalconsentmapinvaliddefault'] = 'Privzeta (*) vrednost manjka.';
$string['agelocationverificationdisabled'] = 'Preverjanje starosti in lokacije onemogočeno';
$string['alreadyloggedin'] = 'Že ste prijavljeni kot {$a}, morate se odjaviti, preden se lahko prijavite kot drug uporabnik.';
$string['authnotexisting'] = 'Avtorizacijski vtičnik ne obstaja';
$string['backupcontainexternal'] = 'Ta datoteka varnostne kopije vsebuje zunanje gostitelje omrežja Moodle, ki niso lokalno konfigurirani';
$string['backuptablefail'] = 'Tabele varnostnih kopij ni mogoče uspešno nastaviti!';
$string['blockcannotconfig'] = 'Ta blok ne podpira globalne konfiguracije';
$string['blockcannotinistantiate'] = 'Težava pri izdelavi objekta bloka';
$string['blockcannotread'] = 'Ne morem prebrati podatkov za id bloka = {$a}';
$string['blockdoesnotexist'] = 'Ta blok ne obstaja';
$string['blockdoesnotexistonpage'] = 'Ta blok (id={$a->instanceid}) ne obstaja na tej strani ({$a->url}).';
$string['blocknameconflict'] = 'Težava pri poimenovanju: blok {$a->name} ima enak naslov kot obstoječi blok: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Povratni klic komentarja je odklonil ta komentar.';
$string['cannotaddcoursemodule'] = 'Novega modula predmeta ni mogoče dodati';
$string['cannotaddcoursemoduletosection'] = 'Novega modula predmeta ni mogoče dodati v ta odsek';
$string['cannotaddmodule'] = '{$a} modula ni mogoče dodati na seznam modulov!';
$string['cannotaddnewmodule'] = 'Novega modula od {$a} ni mogoče dodati';
$string['cannotaddrss'] = 'Nimate dovoljenja, da bi dodali vire RSS';
$string['cannotaddthisblocktype'] = 'Ne morete dodati {$a} bloka na to stran.';
$string['cannotassignrole'] = 'Ni mogoče dodeliti vloge v predmetu';
$string['cannotassignrolehere'] = 'Ni vam dovoljena dodelitev te vloge (id = {$a->roleid}) v tem kontekstu ({$a->context})';
$string['cannotassignselfasparent'] = 'Sebe ne morete določiti za nadrejenega!';
$string['cannotcallscript'] = 'Tega skripta ne morete poklicati na tak način';
$string['cannotcallusgetselecteduser'] = 'Ne morete klicati user_selector::get_selected_user če je omogočena večizbirnost.';
$string['cannotcreatebackupdir'] = 'Mape s podatki varnostne kopije ni mogoče ustvariti. Skrbnik spletnega mesta mora urediti dovoljenja za datoteko';
$string['cannotcreatecategory'] = 'Kategorija ni vstavljena';
$string['cannotcreatedboninstall'] = '<p>Podatkovne zbirke ni bilo mogoče ustvariti.</p>
<p>Navedena podatkovna zbirka ne obstaja in navedeni uporabnik nima dovoljenja, da ustvari podatkovno zbirko.</p>
<p>Skrbnik spletnega mesta mora potrditi konfiguracijo podatkovne zbirke.</p>';
$string['cannotcreategroup'] = 'Napaka pri ustvarjanju skupine';
$string['cannotcreatelangbase'] = 'Napaka: Osnovne jezikovne mape ni mogoče ustvariti';
$string['cannotcreatelangdir'] = 'Jezikovne mape ni mogoče ustvariti';
$string['cannotcreateorfindstructs'] = 'Napaka pri iskanju ali kreiranju struktur odsekov za ta predmet';
$string['cannotcreatepopupwin'] = 'Nedoločen element - pojavnega okna ni mogoče ustvariti';
$string['cannotcreatesitedir'] = 'Mape spletnega mesta ni mogoče ustvariti. Skrbnik spletnega mesta mora urediti datotečna dovoljenja.';
$string['cannotcreatetempdir'] = 'Začasnega imenika ni mogoče ustvariti';
$string['cannotcreateuploaddir'] = 'Mape za nalaganje ni mogoče ustvariti. Skrbnik spletnega mesta mora urediti dovoljenja za datoteko.';
$string['cannotcustomisefiltersblockuser'] = 'Ne morete prilagajati nastavitev filtrov v kontekstu uporabnika ali bloka.';
$string['cannotdeletebackupids'] = 'Prejšnjih varnostnih kopij id-jev ni mogoče izbrisati';
$string['cannotdeletecategorycourse'] = 'Predmeta \'{$a}\' ni mogoče izbrisati.';
$string['cannotdeletecategoryquestions'] = 'Iz te kategorije ne morem izbrisati vprašanj \'{$a}\'';
$string['cannotdeletecourse'] = 'Nimate dovoljenja za izbris tega predmeta';
$string['cannotdeletecustomfield'] = 'Napaka pri izbrisu podatkov polja po meri';
$string['cannotdeletedir'] = '{$a} ni mogoče izbrisati';
$string['cannotdeletefile'] = 'Te datoteke ne morem izbrisati';
$string['cannotdeleterole'] = 'Ni mogoče izbrisati, ker {$a}';
$string['cannotdeleterolewithid'] = 'Vloge z ID {$a} ni mogoče izbrisati';
$string['cannotdeletethisrole'] = 'Te vloge ne morete izbrisati, ker jo uporablja sistem ali ker je to zadnja vloga s skrbniškimi zmožnostmi.';
$string['cannotdisableformat'] = 'Prevzetega formata ne morete onemogočiti.';
$string['cannotdownloadcomponents'] = 'Komponent ni mogoče prenesti';
$string['cannotdownloadlanguageupdatelist'] = 'Seznama posodobitev jezika ni mogoče prenesti z download.moodle.org';
$string['cannotdownloadzipfile'] = 'Datoteke ZIP ni mogoče prenesti';
$string['cannoteditcomment'] = 'Tega komentarja ne morete urejati!';
$string['cannoteditcommentexpired'] = 'Urejanje ni mogoče. Čas je potekel!';
$string['cannoteditpostorblog'] = 'Ne morete objavljati objav ali urejati blogov';
$string['cannoteditsiteform'] = 'Ne morete urejati spletnega mesta predmeta s tem obrazcem';
$string['cannotedituserpreferences'] = 'Ne morete urejati nastavitev tega uporabnika';
$string['cannotedityourprofile'] = 'Lastnega profila ne morete urejati';
$string['cannotexecduringupgrade'] = 'Ni izvedljivo med nadgradnjo';
$string['cannotfindcategory'] = 'Zapisa kategorije iz podatkovne zbirke z ID-jem {$a} ni mogoče najti';
$string['cannotfindcomponent'] = 'Komponente ni mogoče najti';
$string['cannotfindcontext'] = 'Konteksta ni mogoče najti';
$string['cannotfindcourse'] = 'Predmeta ni mogoče najti';
$string['cannotfinddocs'] = 'Jezikovnih datotek "{$a}" ni mogoče najti';
$string['cannotfindgradeitem'] = 'Ne morem najti grade_item';
$string['cannotfindgroup'] = 'Skupine ni mogoče najti';
$string['cannotfindhelp'] = '"{$a}" datotek za jezikovno pomoč ni mogoče najti';
$string['cannotfindinfo'] = 'Ni mogoče najti informacij za: "{$a}"';
$string['cannotfindlang'] = '"{$a}" jezikovnega paketa ni mogoče najti!';
$string['cannotfindteacher'] = 'Učitelja ni mogoče najti';
$string['cannotfinduser'] = 'Ne najdem uporabnika imenovanega "{$a}"';
$string['cannotgeoplugin'] = 'Ni mogoče vzpostaviti povezave s strežnikom geoPlugin na http://www.geoplugin.com, preverite nastavitve proxy strežnika ali bolje namestite podatkovno datoteko MaxMind GeoLite City.';
$string['cannotgetblock'] = 'Iz podatkovne zbirke ni mogoče pridobiti blokov';
$string['cannotgetcats'] = 'Zapisa kategorije ni mogoče dobiti';
$string['cannotgetdata'] = 'Podatkov ni mogoče dobiti';
$string['cannotgradeuser'] = 'Ne morem oceniti tega uporabnika';
$string['cannothaveparentcate'] = 'Kategorija predmeta ne more imeti nadrejenega!';
$string['cannotimport'] = 'Napaka pri uvozu';
$string['cannotimportformat'] = 'Oprostite, uvoz tega formata še ni podprt!';
$string['cannotimportgrade'] = 'Napaka pri uvozu ocene';
$string['cannotinsertgrade'] = 'Ni mogoče vstaviti ocene brez id-ja predmeta!';
$string['cannotinsertrate'] = 'Ni bilo mogoče vstaviti nove ocene ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Novega zapisa z ID {$a} ni mogoče dodati';
$string['cannotmailconfirm'] = 'Napaka pri pošiljanju potrdilne e-pošte o spremembi gesla';
$string['cannotmanualctrack'] = 'Dejavnost ne zagotavlja sledenja ročne zaključenosti';
$string['cannotmapfield'] = 'Zaznane kolizije preslikav - dve polji se preslikata v polje z isto oceno {$a}';
$string['cannotmarktopic'] = 'Za ta predmet ni bilo mogoče označiti izbrane teme';
$string['cannotmigratedatacomments'] = 'Podatkov komentarjev modula ni mogoče preseliti';
$string['cannotmodulename'] = 'Ime modula ni mogoče dobiti v vgrajeno krmarjenje';
$string['cannotmoduletype'] = 'Vrsto modula ni mogoče dobiti v vgrajeno krmarjenje';
$string['cannotmovecategory'] = 'Kategorije ni mogoče premakniti';
$string['cannotmovecourses'] = 'Predmetov iz ene kategorije ni mogoče prenesti v drugo.';
$string['cannotmoverolewithid'] = 'Ne morete premakniti vloge z ID-jem {$a}';
$string['cannotopencsv'] = 'Ne morem odpreti CSV datoteke';
$string['cannotopenfile'] = 'Ne mroem odpreti datoteke ({$a})';
$string['cannotopenforwrit'] = 'Ni mogoče odpreti za pisanje: {$a}';
$string['cannotopentemplate'] = 'Ni mogoče odpreti datoteke predloge ({$a})';
$string['cannotopenzip'] = 'Datoteke ZIP ni mogoče odpreti, najverjetneje je napaka v končnici ZIP na 64-bitnem operacijskem sistemu.';
$string['cannotoverridebaserole'] = 'Zmogljivosti osnovnih vlog ni mogoče povoziti';
$string['cannotoverriderolehere'] = 'Ni vam dovoljeno da povozite te vloge (id = {$a->roleid}) v tem kontekstu ({$a->context})';
$string['cannotreadfile'] = 'Ne morem brati datoteke ({$a})';
$string['cannotreadtmpfile'] = 'Napaka pri branju začasne datoteke';
$string['cannotreaduploadfile'] = 'Naložene datoteke ni mogoče prebrati';
$string['cannotremovefrommeta'] = 'Izbranega predmeta ni mogoče odstraniti iz tega meta predmeta!';
$string['cannotreprocessgrades'] = 'Ocen za to dejavnost {$a} ni mogoče ponovno obdelati';
$string['cannotresetguestpwd'] = 'Ne morete ponastaviti gesla gosta';
$string['cannotresetmail'] = 'Napaka pri ponastavitvi gesla in';
$string['cannotresetthisrole'] = 'Te vloge ni mogoče ponastaviti';
$string['cannotrestore'] = 'Prišlo je do napake in obnovitev ni mogoče dokončati.!';
$string['cannotrestoreadminorcreator'] = 'Nov predmet lahko obnovi le ustvarjalec ali skrbnik!';
$string['cannotrestoreadminoredit'] = 'Izbran predmet lahko obnovi le učitelj ali skrbnik!';
$string['cannotsaveagreement'] = 'Vašega strinjanja ni mogoče shraniti';
$string['cannotsaveblock'] = 'Napaka pri shranjevanju konfiguracije bloka';
$string['cannotsavecomment'] = 'Komentarja ni mogoče shraniti';
$string['cannotsavedata'] = 'Podatkov ni mogoče shraniti';
$string['cannotsavefile'] = 'Datoteke "{$a}" ni mogoče shraniti!';
$string['cannotsavemd5file'] = 'Datoteke MD5 ni možno shraniti';
$string['cannotsavezipfile'] = 'Datoteke ZIP ni možno shraniti';
$string['cannotservefile'] = 'Datoteke ni mogoče poslati zaradi napačne konfiguracije strežnika.';
$string['cannotsetparentforcatoritem'] = 'Za kategorijo predmeta ali predmet ni mogoče določiti nadrejenega!';
$string['cannotsetpassword'] = 'Uporabniškega gesla ni mogoče nastaviti!';
$string['cannotsetprefgrade'] = 'Ni mogoče prikazati nastavitev združenega pogleda za {$a} za to ocenjevalno kategorijo';
$string['cannotsettheme'] = 'Teme ni mogoče nastaviti!';
$string['cannotsetupblock'] = 'Tabele blokov ni mogoče uspešno nastaviti!';
$string['cannotsetupcapformod'] = 'Zmožnosti za {$a} ni mogoče nastaviti';
$string['cannotsetupcapforplugin'] = 'Zmožnosti za {$a} ni mogoče nastaviti';
$string['cannotshowhidecoursesincategory'] = 'Predmetov v kategoriji {$a} ni mogoče prikazati/skriti.';
$string['cannotsignup'] = 'Ne morete ustvariti novega računa, ker ste že prijavljeni kot {$a}.';
$string['cannotunassigncap'] = 'Opuščene zmožnosti {$a->cap} ni mogoče preklicati od vloge {$a->role}';
$string['cannotunassignrolefrom'] = 'Tega uporabnika ni mogoče preklicati z id vloge: {$a}';
$string['cannotunzipfile'] = 'Datoteke ni mogoče razširiti';
$string['cannotupdatemod'] = 'Ni mogoče posodobiti {$a}';
$string['cannotupdatepasswordonextauth'] = 'Posodabljanje gesla na zunanjem auth ni uspelo: {$a}. Za več podrobnosti si oglejte dnevnik strežnika.';
$string['cannotupdateprofile'] = 'Napaka pri nalaganju uporabniških zapisov';
$string['cannotupdaterecord'] = 'Zapisa z ID {$a} ni mogoče posodobiti';
$string['cannotupdaterss'] = 'RSS ni mogoče posodobiti';
$string['cannotupdatesubcourse'] = 'Podrejenega predmeta ni mogoče posodobiti!';
$string['cannotupdateusermsgpref'] = 'Ne morem posodobiti preferenc uporabniških sporočil';
$string['cannotupdateuseronexauth'] = 'Napaka pri posodabljanju uporabniških podatkov na zunanjem vtičniku za preverjanje pristnosti: {$a}. Za več podrobnosti si oglejte dnevnike strežnika.';
$string['cannotuploadfile'] = 'Napaka pri procesiranju naložene datoteke';
$string['cannotuseadmin'] = 'Dostop do te strani je omogočen samo skrbnikom';
$string['cannotuseadminadminorteacher'] = 'Dostop do te strani je omogočen samo učiteljem ali skrbnikom';
$string['cannotusepage'] = 'Dostop do te strani je omogočen samo učiteljem in skrbnikom';
$string['cannotusepage2'] = 'Te strani ne morete uporabljati';
$string['cannotviewcategory'] = 'Nimate dovoljenja za ogled tega seznama predmetov.';
$string['cannotviewprofile'] = 'Profila tega uporabnika ne morete videti';
$string['cannotviewreport'] = 'Tega poročila ne morete pogledati';
$string['cannotwritefile'] = 'Pisanje v datoteko ({$a}) ni možno';
$string['categoryerror'] = 'Napaka kategorije';
$string['categoryidnumbertaken'] = 'Številka ID je že uporabljena za drugo kategorijo';
$string['categorynamerequired'] = 'Ime kategorije je obvezno';
$string['categorytoolong'] = 'Ime kategorije je predolgo';
$string['commentmisconf'] = 'ID komentarja ni pravilno konfiguriran';
$string['componentisuptodate'] = 'Komponenta je posodobljena';
$string['confirmationnotenabled'] = 'V tem spletnem mestu potrditev ni omogočena';
$string['confirmsesskeybad'] = 'Oprostite, toda vašega ključa seje ni možno potrditi za izvedbo tega dejanja. Ta varnostna možnost preprečuje nenamerno ali zlonamerno izvajanje pomembnih funkcij v vašem imenu. Prepričajte se, da ste res želeli izvesti to funkcijo.';
$string['contenttypenotfound'] = 'Tip zbirke vsebin \'{$a}\' ne obstaja ali ni prepoznan.';
$string['couldnotassignrole'] = 'Med dodeljevanjem vaše vloge se je pojavila resna, a neznana napaka.';
$string['couldnotupdatenoexistinguser'] = 'Uporabnika ni mogoče posodobiti - uporabnik ne obstaja';
$string['couldnotverifyagedigitalconsent'] = 'Napaka pri preverjanju digitalne preverbe starosti.<br/>Prosimo, kontaktirajte administratorja.';
$string['countriesphpempty'] = 'Napaka: datoteka countries.php v jezikovnem paketu {$a} je prazna ali manjka.';
$string['coursedoesnotbelongtocategory'] = 'Predmet ne pripada tej kategoriji';
$string['courseformatnotfound'] = 'Format predmeta \'{$a}‘ ne obstaja ali ga ni mogoče prepoznati.';
$string['coursegroupunknown'] = 'Predmet, ki ustreza skupini {$a} ni določen';
$string['courseidnotfound'] = 'Id predmeta ne obstaja.';
$string['courseidnumbertaken'] = 'Številka ID je že uporabljena za drug predmet ({$a})';
$string['coursemisconf'] = 'Predmet je napačno nastavljen';
$string['courserequestdisabled'] = 'Zahteve za predmet je onemogočil skrbnik.';
$string['csvcolumnduplicates'] = 'Zaznani podvojeni stolpci';
$string['csvemptyfile'] = 'Datoteka CSV je prazna';
$string['csvfewcolumns'] = 'Premalo stolpcev, preverite nastavitev ločitvenih znakov';
$string['csvfileerror'] = 'Napaka v formatu datoteke CSV. Prosimo preverite ali se število naslovov in stolpcev ujema ter ali sta ločevalec in kodiranje datotek pravilna: {$a}';
$string['csvinvalidcols'] = '<b>Napačna CSV datoteka:</b> Prva vrstica mora vsebovati "Polja Glave" in datoteka mora biti vrsta od <br />"Razširjena Polja/Z vejico ločena"<br />ali<br /> "Razširjena Polja z CAVV kodo rezultata/ločeno z vejicami"';
$string['csvinvalidcolsnum'] = 'Napačna CSV datoteka - vsaka vrstica mora vsebovati 49 ali 70 polj';
$string['csvloaderror'] = 'Prišlo je do napake med nalaganjem CSV datoteke: {$a}';
$string['csvnodata'] = 'Neveljavna CVS datoteka - CVS datoteka ima naslove, vendar ne vsebuje nobenih podatkov.';
$string['csvweirdcolumns'] = 'Napačen format datoteke CSV - število stolpcev ni stalno!';
$string['dbconnectionfailed'] = '<p>Napaka: Povezava s podatkovno zbirko je bila prekinjena</p>
<p>Podatkovna zbirka je lahko preobremenjena ali ne deluje pravilno.</p>
<p>Skrbnik spletnega mesta naj tudi preveri, da so bili podrobnejši podatki podatkovne zbirke pravilno določeni v config.php</p>';
$string['dbdriverproblem'] = '<p>Napaka: odkrita je bila težava pri gonilniku podatkovne zbirke</p>
<p>Skrbnik spletnega mesta naj preveri konfiguracijo strežnika</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Odkrita je bila resna težava v seji podatkovne zbirke.<br /><br />Obvestite skrbnika strežnika.';
$string['dbsessionhandlerproblem'] = 'Nastavitev seje podatkovne zbirke ni uspela. Obvestite skrbnika strežnika.';
$string['dbsessionmysqlpacketsize'] = 'Odkrita je bila resna napaka v seji. Prosimo obvestite skrbnika sistema. Ta napaka je najverjetneje nastala zaradi nizke vrednosti v  MySQL nastavitvi max_allowed_packet.';
$string['dbupdatefailed'] = 'Posodobitev podatkovne zbirke ni uspela';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" ni mogoče spremeniti. Najdena je odvisnost z {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Napaka pri izvajanju DLL sql';
$string['ddlfieldalreadyexists'] = 'Polje "{$a}" že obstaja';
$string['ddlfieldnotexist'] = 'Polje "{$a->fieldname}" ne obstaja v tabeli "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabela "{$a}" že obstaja';
$string['ddltablenotexist'] = 'Tabela "{$a}" ne obstaja';
$string['ddlunknownerror'] = 'Neznana napaka v knjižnici DLL';
$string['ddlxmlfileerror'] = 'Najdene so napake v podatkovni zbirki XML';
$string['ddsequenceerror'] = 'Nepravilna definicja tabele "{$a}"; Obstaja lahko samo en avtomatični stolpec, ki mora biti definiran kot ključ.';
$string['destinationcmnotexit'] = 'Modul za ciljni predmet ne obstaja';
$string['detectedbrokenplugin'] = 'Vtičnik "{$a}" je poškodovan ali zastarel. Ni mogoče nadaljevati.';
$string['dmlexceptiononinstall'] = '<p>Prišlo je do napake podatkovne zbirke [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Napaka pri razčlenevanju SQL poizvedbe';
$string['dmlreadexception'] = 'Napaka pri branju iz podatkovne zbirke';
$string['dmltransactionexception'] = 'Napaka pri branju iz podatkovne baze';
$string['dmlwriteexception'] = 'Napaka pri pisanju v podatkovno bazo';
$string['downgradedcore'] = 'NAPAKA!!! Koda, ki jo uporabljate, je STAREJŠA od različice, ki je bila uporabljena za ustvarjanje te podatkovne zbirke!';
$string['downloadedfilecheckfailed'] = 'Preverjanje prenesene datoteke ni uspelo';
$string['duplicatefieldname'] = 'Zaznano podvojeno ime polja "{$a}"';
$string['duplicatenosupport'] = '\'{$a->modname}\' dejavnosti ni bilo mogoče podvojiti, ker modul {$a->modtype} ne podpira varnostnega kopiranja ali obnavljanja.';
$string['duplicateparaminsql'] = 'NAPAKA: Podvojeno ime parametra v povpraševanju';
$string['duplicaterolename'] = 'Vloga z imenom {$a} že obstaja!';
$string['duplicateroleshortname'] = 'Vloga s tem kratkim imenom že obstaja!';
$string['duplicateusername'] = 'Podvojeno uporabniško ime - zapis preskočen';
$string['emailfail'] = 'Pošiljanje e-pošte ni uspelo';
$string['enddatebeforestartdate'] = 'Končni datum predmeta mora biti za začetnim datumom predmeta.';
$string['error'] = 'Prišlo je do napake';
$string['error_question_answers_missing_in_db'] = 'Odgovora, ki se ujema z »{$a->answer}«, ni bilo mogoče najti v tabeli podatkovne zbirke vprašanja_odgovori. To se je zgodilo med obnavljanjem vprašanja z id {$a->filequestionid} v datoteki varnostne kopije, ki se ujema z obstoječim vprašanjem z id {$a->dbquestionid} v podatkovni zbirki.';
$string['errorcleaningdirectory'] = 'Napaka ob čiščenju imenika "{$a}"';
$string['errorcopyingfiles'] = 'Napaka pri kopiranju datotek';
$string['errorcreatingdirectory'] = 'Napaka pri ustvarjanju imenika "{$a}"';
$string['errorcreatingfile'] = 'Napaka pri ustvarjanju datoteke "{$a}"';
$string['errorcreatingrole'] = 'Napaka pri ustvarjanju vloge';
$string['errorfetchingrssfeed'] = 'Napaka pri pridobivanju vira RSS.';
$string['erroronline'] = 'Napaka v vrstici {$a}';
$string['erroroutput'] = 'Izhodna napaka, samodejno preusmeritev onemogočena.';
$string['errorparsingxml'] = 'Napaka pri razčlenjevanju XML: {$a->errorstring} pri vrstici {$a->errorline}, znak {$a->errorchar}';
$string['errorprocessingarchive'] = 'Napaka pri obdelavi datoteke arhiva';
$string['errorreadingfile'] = 'Napaka pri branju datoteke "{$a}"';
$string['errorsavingrequest'] = 'Prišlo je do napake med shranjevanjem vaše zahteve.';
$string['errorsettinguserpref'] = 'Napaka pri nastavljanju uporabniške nastavitve';
$string['errorunzippingfiles'] = 'Napaka pri razširjanju datotek';
$string['expiredkey'] = 'Ključ je pretekel';
$string['externalauthpassworderror'] = 'Neprazno geslo pri zunanjem preverjanju pristnosti';
$string['externalfilenolocation'] = 'Zunanja datoteka nima poti do mesta';
$string['failtoloadblocks'] = 'Eden ali več blokov je registriranih v podatkovni zbirki, nobenega ni bilo mogoče naložitii!';
$string['fieldrequired'] = '"{$a}" je zahtevano polje';
$string['fileexists'] = 'Datoteka obstaja';
$string['filemismatch'] = 'Neujemanje imena pomožne datoteke. Datoteka "{$a->current}" bi morala biti {$a->file}';
$string['filenotfound'] = 'Zahtevane datoteke ni mogoče najti';
$string['filenotreadable'] = 'Datoteka ni berljiva';
$string['filterdoesnothavelocalconfig'] = 'Filter {$a} ne dovoljuje lokalnih nastavitev.';
$string['filternotactive'] = 'Filter {$a} ni aktiviran';
$string['filternotenabled'] = 'Filter ni omogočen!';
$string['filternotinstalled'] = 'Filter {$a} ni nameščen';
$string['forumblockingtoomanyposts'] = 'Presegli ste nastavljen prag dovoljenih objav za ta forum';
$string['functionalityremoved'] = 'Poskušate dostopai do odstranjene funkcije.';
$string['generalexceptionmessage'] = 'Izjema - {$a}';
$string['gradecantregrade'] = 'Prišlo je do napake med izračunavanjem ocen: {$a}';
$string['gradepubdisable'] = 'Objavljanje ocen je onemogočeno';
$string['gradesneedregrading'] = 'Ocene predmeta je treba znova izračunati';
$string['groupalready'] = 'Uporabnik že pripada skupini {$a}';
$string['groupexistforcourse'] = 'Skupina "{$a}" že obstaja v tem predmetu';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Skupina "{$a->name}" z id številko "{$a->idnumber}"  že obstaja v tem predmetu';
$string['grouphasidnumber'] = 'Skupina "{$a}" ima id številko in jo je mogoče samodejno ustvaril zunanji sistem. Za odstranitev te skupine nimate dovoljenja.';
$string['groupinghasidnumber'] = 'Skupek "{$a}" ima id številko in ga je mogoče samodejno ustvaril zunanji sistem. Za odstranitev tega skupka nimate dovoljenja.';
$string['groupingnotaddederror'] = 'Skupek "{$a}" ni dodan';
$string['groupnotaddederror'] = 'Skupina "{$a}" ni dodana';
$string['groupnotaddedtogroupingerror'] = 'Skupina {$a->groupname} je uspešno dodana skupku "{$a->groupingname}"';
$string['groupunknown'] = 'Skupina {$a} ni povezana z določenim predmetom';
$string['groupusernotmember'] = 'Uporabnik ni član te skupine.';
$string['guestcantaccessprofiles'] = 'Gostje ne morejo dostopati do profilov uporabnikov. Če želite nadaljevati, se morate vpisati s polnim uporabniškim računom.';
$string['guestnocomment'] = 'Gostom ni dovoljeno objavljanje komentarjev!';
$string['guestnoeditprofile'] = 'Gost ne more urejati svojega profila';
$string['guestnoeditprofileother'] = 'Profila gostujočega uporabnika ni mogoče urejati';
$string['guestnorate'] = 'Gostom ni dovoljeno ocenjevanje vnosov ni dovoljeno';
$string['guestsarenotallowed'] = 'Gost nima dostopa do tega';
$string['hackdetected'] = 'Zaznan je bil vdor!';
$string['hashpoolproblem'] = 'Nepravilna vsebina datoteke skupine virov {$a}.';
$string['headersent'] = 'Naslovne celice so že poslane';
$string['idnumbertaken'] = 'Številka ID je že uporabljena v drugem predmetu';
$string['idnumbertoolong'] = 'Številka ID je predolga';
$string['importformatnotimplement'] = 'Oprostite, uvoz tega formata še ni podprt!';
$string['incorrectext'] = 'Datoteka ima nepravilno končnico';
$string['inplaceeditableerror'] = 'Napaka pri klicanju posodobitve procesorja';
$string['installproblem'] = 'Obnovitev po napakah med namestitvijo po navadi ni mogoča, morda boste morali ustvariti novo podatkovno zbirko ali uporabiti drugo predpono podatkovne zbirke, če želite znova zagnati namestitev.';
$string['internalauthpassworderror'] = 'Manjkajoče geslo ali neveljaven pravilnik za gesla za notranje preverjanje prisotnosti';
$string['invalidaccess'] = 'Nepravilen dostop do te strani';
$string['invalidaccessparameter'] = 'Nepravilni parameter dostopa';
$string['invalidaction'] = 'Nepravilni parameter dejanja';
$string['invalidactivityid'] = 'Neveljavni ID dejavnosti';
$string['invalidadminsettingname'] = 'Nepravilne nastavitve skrbnika ({$a})';
$string['invalidargorconf'] = 'Ni veljavnih argumentov ali nepravilna konfiguracija strežnika';
$string['invalidarguments'] = 'Brez veljavnih dobavljenih argumentov';
$string['invalidblockinstance'] = 'Neveljavni element bloka za: {$a}';
$string['invalidbulkenrolop'] = 'Dobavljenih ni bilo pravilnih argumentov.';
$string['invalidcategory'] = 'Nepravilna kategorija!';
$string['invalidcategoryid'] = 'Nepravilni ID kategorije!';
$string['invalidcomment'] = 'Komentar je nepravilen';
$string['invalidcommentarea'] = 'Nepravilno področje komentarja';
$string['invalidcommentid'] = 'Nepravilni ID komentarja';
$string['invalidcommentitemid'] = 'Nepravilni ID elementa komentarja';
$string['invalidcommentparam'] = 'Nepravilni parametri komentarja';
$string['invalidcomponent'] = 'Nepravilno ime komponente';
$string['invalidconfirmdata'] = 'Nepravilni potrditveni podatki';
$string['invalidcontentid'] = 'Neveljavna ID vsebina';
$string['invalidcontext'] = 'Neveljaven okvir';
$string['invalidcountrycode'] = 'Nepravilna koda države: {$a}';
$string['invalidcourse'] = 'Neveljavni predmet';
$string['invalidcourseformat'] = 'Neveljaven format predmeta';
$string['invalidcourseid'] = 'Uporabiti želite neveljavni ID predmeta';
$string['invalidcourselevel'] = 'Nepravilni kontekstni nivo';
$string['invalidcoursemodule'] = 'Neveljavni ID modula predmeta';
$string['invalidcoursenameshort'] = 'Nepravilno kratko ime predmeta';
$string['invaliddata'] = 'Oddani podatki niso pravilni';
$string['invaliddatarootpermissions'] = 'Zaznana so nepravilna dovoljenja za ustvarjanje imenika. Za več podrobnosti zaženite razhroščevanje.';
$string['invaliddevicetype'] = 'Napačna vrsta naprave';
$string['invalidelementid'] = 'Napačni ID elementa!';
$string['invalidentry'] = 'Ta vnos ni dovoljen!';
$string['invalidevent'] = 'Neveljavni dogodek';
$string['invalidfieldname'] = '"{$a}" ni veljavno ime polja';
$string['invalidfiletype'] = '"{$a}" ni veljavna vrsta datoteke';
$string['invalidformatpara'] = 'Napačen format za izbran parameter';
$string['invalidformdata'] = 'Napačni podatki obrazca';
$string['invalidfunction'] = 'Napačna funkcija';
$string['invalidgradeitemid'] = 'Napačen ID elementa ocene';
$string['invalidgroupid'] = 'Določen je napačen ID skupine';
$string['invalidipformat'] = 'Neveljavna oblika naslova IP';
$string['invaliditemid'] = 'Napačen ID predmeta';
$string['invalidkey'] = 'Napačen ključ';
$string['invalidlanguagecode'] = 'Nepravilna koda jezika: {$a}';
$string['invalidlegacy'] = 'Napačna definicija dediščine vloge za vrsto: {$a}';
$string['invalidmd5'] = 'Spremenljivka preverjanja je bila napačna - poskusite ponovno';
$string['invalidmode'] = 'Nepravilni način ({$a})';
$string['invalidmodule'] = 'Neveljavni modul';
$string['invalidmoduleid'] = 'Neveljavni ID modula: {$a}';
$string['invalidmodulename'] = 'Neveljavno ime modula: {$a}';
$string['invalidnum'] = 'Nepravilna numerična vrednost';
$string['invalidnumkey'] = 'Polje $conditions ne sme vsebovati numeričnih ključev, popravite kodo!';
$string['invalidoutcome'] = 'Napačen ID rezultata';
$string['invalidpagesize'] = 'Neveljavna velikost strani';
$string['invalidpasswordpolicy'] = 'Neveljavni pravilnik za gesla';
$string['invalidpaymentmethod'] = 'Nepravilna metoda plačina: {$a}';
$string['invalidqueryparam'] = 'NAPAKA: Napačno število porametrov povpraševanja. Pričakovano {$a->expected}, dobljeno {$a->actual}.';
$string['invalidratingarea'] = 'Nepravilno območje ocenjevanja';
$string['invalidrecord'] = 'Podatkovnega zapisa v tabeli podatkovne zbirke {$a} ni mogoče najti.';
$string['invalidrecordunknown'] = 'Ne najdem podatkovnega zapisa v podatkovni bazi.';
$string['invalidrequest'] = 'Neveljavna zahteva';
$string['invalidrole'] = 'Neveljavna vloga';
$string['invalidroleid'] = 'Neveljavnii ID vloge';
$string['invalidscaleid'] = 'Nepravilni ID merila';
$string['invalidsection'] = 'Modul zapisov predmeta vsebuje neveljavni odsek';
$string['invalidsesskey'] = 'Vaša seja je verjetno potekla. Prosimo, da se ponovno vpišete.';
$string['invalidshortname'] = 'Nepravilno kratko ime predmeta';
$string['invalidsourcefield'] = 'Neveljaven osnutek izvornega polja datoteke';
$string['invalidstatedetected'] = 'Nekaj se je zalomilo: {$a}. To se ne bi smelo zgoditi.';
$string['invalidurl'] = 'Neveljaven URL';
$string['invaliduser'] = 'Neveljaven uporabnik';
$string['invaliduserdata'] = 'Neveljavni podatki o uporabniku: {$a}';
$string['invaliduserfield'] = 'Neveljavno uporabniško polje: {$a}';
$string['invaliduserid'] = 'Neveljaven ID uporabnika';
$string['invalidusername'] = 'Navedeno uporabniško ime vsebuje neveljavne znake';
$string['invalidusernameblank'] = 'Uporabniško ime ne sme biti prazno';
$string['invalidxmlfile'] = '"{$a}" ni veljavna datoteka XML';
$string['iplookupfailed'] = 'Geo-lokacijske informacije IP naslova {$a} ni mogoče najti';
$string['iplookupprivate'] = 'Informacij o zasebnem IP naslovu ni mogoče prikazati';
$string['ipmismatch'] = 'Naslov IP odjemalca se ne ujema';
$string['listcantmovedown'] = 'Element je zadnji med vrstniki, zato ga ni mogoče premakniti nižje.';
$string['listcantmoveleft'] = 'Element nima nadrejenih elementov, zato ga ni mogoče premakniti levo';
$string['listcantmoveright'] = 'Ker element nima vrstnika, pod katerega bi ga premaknili, ga ni mogoče premakniti desno. Premaknite ga pod vrstnika - potem ga boste lahko premaknili desno.';
$string['listcantmoveup'] = 'Element je prvi med vrstniki, zato ga ni mogoče premakniti višje';
$string['listnochildren'] = 'Podrejenih elementov ni mogoče najti';
$string['listnoitem'] = 'Elementa ni mogoče najti';
$string['listnopeers'] = 'Vrstnikov elementa ni mogoče najti';
$string['listupdatefail'] = 'Napaka podatkovne zbirke pri poskusu urejanja hierarhije elementov';
$string['logfilenotavailable'] = 'Dnevniški zapisi niso na voljo';
$string['loginasnoenrol'] = 'Možnosti vpisa in izpisa v predmetu ni mogoče uporabljati med sejo "Prijavite se kot"';
$string['loginasonecourse'] = 'V predmet ne morete vstopiti.<br/> Pred vstopom v druge predmete morate končati sejo "Prijavite se kot".';
$string['maxareabytes'] = 'Velikost datoteke je večja od prostora, ki je še na voljo na tem območju.';
$string['maxbytesfile'] = 'Datoteka {$a->file} je prevelika. Največja velikost, ki jo lahko naložite, je {$a->size}.';
$string['messageundeliveredbynotificationsettings'] = 'Sporočilo ne mogoče poslati, saj se pošiljanje osebnih sporočil med uporabniki (v nastavitvah obvestil) onemogočil skrbnik spletne strani.';
$string['messagingdisable'] = 'Na tem spletnem mestu je pošiljanje sporočil onemogočeno';
$string['mimetexisnotexist'] = 'Vaš sistem ni nastavljen za izvajanje mimeTeX. Prenesti morate ustrezno izvorno kodo C iz <a href="http://www.forkosh.com/mimetex.zip"> http://www.forkosh.com/mimetex.zip</a>, jo prevesti in prenesti zagonsko datoteko v vašo mapo moodle/filter/tex/.';
$string['mimetexnotexecutable'] = 'Mimtex po meri ni izvršljiv!';
$string['missing_moodle_backup_xml_file'] = 'V varnostni kopiji manjka datoteka XML: {$a}';
$string['missingfield'] = 'Manjka polje "{$a}"';
$string['missingkeyinsql'] = 'NAPAKA: manjkajoč parameter "{$a}" pri povpraševanju';
$string['missingparam'] = 'Manjka potreben parameter ({$a})';
$string['missingparameter'] = 'Manjkajoč parameter';
$string['missingrequiredfield'] = 'Eno izmed zahtevanih polj manjka';
$string['missinguseranditemid'] = 'Manjkajoč id uporabnika ali id elementa';
$string['missingvarname'] = 'Manjka zahtevano ime spremenljivke!';
$string['mixedtypesqlparam'] = 'NAPAKA: Mešane vrste parametrov poizvedb sql!!';
$string['mnetdisable'] = 'MNET je onemogočen';
$string['mnetlocal'] = 'Oddaljeni uporabniki MNET se ne morejo prijaviti lokalno';
$string['moduledisable'] = 'Ta modul ({$a}) je bil onemogočen za ta predmet';
$string['moduledoesnotexist'] = 'Ta modul ne obstaja';
$string['moduleinstancedoesnotexist'] = 'Element tega modula ne obstaja';
$string['modulemissingcode'] = 'Modulu {$a} manjka potrebna koda za izvajanje te funkcije';
$string['movecatcontentstoroot'] = 'Premikanje vsebine kategorije v koren ni dovoljeno. Vsebino morate premakniti v obstoječo kategorijo!';
$string['movecatcontentstoselected'] = 'Nekatere kategorije vsebin ne mogoče premakniti v izbrano kategorijo.';
$string['movecategorynotpossible'] = 'Kategorije \'{$a}\' ne morete premakniti v izbrano kategorijo.';
$string['movecategoryownparent'] = 'Kategorija \'{$a}\' ne more biti sama sebi nadrejena kategorija.';
$string['movecategoryparentconflict'] = 'Kategorija \'{$a}\' ne more biti podkategorija ene izmed lastnih podkategorij.';
$string['mssqlrcsmodemissing'] = 'Podatkovna zbirka ne uporablja pričakovanega načina READ_COMMITTED_SNAPSHOT, kar lahko vodi do napačnih rezultatov, zlasti v primerih visoke hkratnosti. Omogočite uporabo za pravilno obnašanje. Za več informacij glejte dokumentacijo <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Installing MSSQL for PHP</a>.';
$string['multiplerecordsfound'] = 'Najdenih je več zapisov, pričakovan je bil samo en zapis.';
$string['multiplerestorenotallow'] = 'Večkratna obnovitev izvedbe ni dovoljena!';
$string['mustbeloggedin'] = 'Če želite to narediti, morate biti prijavljeni';
$string['mustbeteacher'] = 'Za ogled te strani morate biti učitelj';
$string['myisamproblem'] = 'Tabele v podatkovnih zbirk uporabljajo pogon MyISAM. Priporočljiva je uporaba pogona ACID s popolno transakcijsko podporo, kot je InnoDB.';
$string['needcopy'] = 'Najprej morate nekaj kopirati!';
$string['needcoursecategroyid'] = 'Določena mora biti kategorija ali id predmeta';
$string['needphpext'] = 'Dodati morate podporo {$a} vaši namestitvi PHP';
$string['noadmins'] = 'Ni skrbnikov!';
$string['noblocks'] = 'Ni najdenih blokov!';
$string['nocapabilitytousethisservice'] = 'Uporabnik nima potrebnih zmožnosti za uporabo tega servisa';
$string['nocategorydelete'] = 'Kategorije \'{$a}\' ni mogoče izbrisati!';
$string['nocontext'] = 'Predmet ni v veljavnem kontekstu';
$string['nodata'] = 'Ni podatkov';
$string['noexistingcategory'] = 'Ni obstoječe kategorije';
$string['nofile'] = 'Datoteka ni določena';
$string['nofiltersenabled'] = 'Filtri niso omogočeni.';
$string['nofolder'] = 'Zahtevana mapa ne obstaja';
$string['noformdesc'] = 'Za to aktivnost ni mogoče najti opisne datoteke za obrazec formslib.';
$string['noguest'] = 'Tukaj ni gostov!';
$string['noinstances'] = 'V tem predmetu ni nobenega elementa modula {$a}!';
$string['nologinas'] = 'Nimate dovoljenja za prijavo kot ta uporabnik';
$string['nonmeaningfulcontent'] = 'Brez smiselne vsebine';
$string['noparticipants'] = 'Za ta predmet ni najdenih sodelujočih';
$string['noparticipatorycms'] = 'Nimate sodelovalnih modulov predmeta, o katerih bi lahko poročali';
$string['nopermissions'] = 'Žal trenutno nimate dovoljenje za to dejanje ({$a}).';
$string['nopermissiontocomment'] = 'Ne morete dodajati komentarjev';
$string['nopermissiontodelentry'] = 'Tega komentarja ne morete izbrisati!';
$string['nopermissiontoeditcomment'] = 'Ne morete urejati objav drugih ljudi!';
$string['nopermissiontohide'] = 'Nimate dovoljenja za skritje!';
$string['nopermissiontoimportact'] = 'Nimate potrebovanih dovoljenj za uvoz dejavnosti v ta predmet';
$string['nopermissiontolock'] = 'Nimate dovoljenja za zaklenitev!';
$string['nopermissiontomanagegroup'] = 'Nimate potrebnih dovoljenj za upravljanje skupin';
$string['nopermissiontorate'] = 'Ocenjevanje elementov ni dovoljeno!';
$string['nopermissiontoshow'] = 'Nimate dovoljenj za ogled tega!';
$string['nopermissiontounlock'] = 'Nimate dovoljenj za odklep!';
$string['nopermissiontoupdatecalendar'] = 'Oprostite, vendar trenutno nimate dovoljenja za posodobitev dogodka na koledarju.';
$string['nopermissiontoviewgrades'] = 'Ne morete si ogledati ocen.';
$string['nopermissiontoviewletergrade'] = 'Nimate dovoljenja za ogled črkovnih ocen';
$string['nopermissiontoviewpage'] = 'Te strani ne smete gledati';
$string['nosite'] = 'Ne morem najti vrhnjega predmeta!';
$string['nositeid'] = 'Manjka ID spletnega mesta';
$string['nostartdatenoenddate'] = 'Končni datum predmeta je mogoče določiti le, če je določen tudi začetni datum.';
$string['nostatstodisplay'] = 'Na voljo za prikaz ni nobenih podatkov';
$string['notallowedtoupdateprefremotely'] = 'Ni vam dovoljena oddaljena posodobitev te uporabniške nastavitve';
$string['notavailable'] = 'To trenutno ni na voljo';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Niste član skupine tega predmeta';
$string['notownerofkey'] = 'Niste lastnik tega ključa';
$string['nousers'] = 'Uporabnik ne obstaja!';
$string['oauth1accesstoken'] = 'OAuth 1.0 napaka: Nismo pridobili žetona za dostop.';
$string['oauth1requesttoken'] = 'OAuth 1.0 napaka: Nismo pridobili žetona za dostop - ponudnik storitev morda ni na voljo.';
$string['onlyadmins'] = 'To lahko storijo samo skrbniki';
$string['onlyeditingteachers'] = 'To lahko storijo samo učitelji s pravico urejanja';
$string['onlyeditown'] = 'Urejate lahko samo svoje podatke';
$string['orderidnotfound'] = 'ID naročila {$a} ni najden';
$string['pagenotexist'] = '<p>Prišlo je do nenavadne napake (poskus dostopa do strani, ki ne obstaja):</p>{$a}';
$string['pagenotexisttitle'] = 'Napaka 404: Datoteke ni mogoče najti';
$string['pathdoesnotstartslash'] = 'Veljavni argumenti niso dobavljeni, pot se ne začne s poševnico!';
$string['pleasereport'] = 'Če boste uspeli, nam sporočite, kaj ste poskušali narediti, ko je prišlo do napake:';
$string['pluginrequirementsnotmet'] = 'Vtičnika "{$a->pluginname}" ({$a->pluginversion}) ni bilo mogoče namestiti. Zahteva novejšo različico Moodla (trenutno uporabljate {$a->currentmoodle}, vendar potrebujete {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Vtičnik "{$a->pluginname}" {$a->pluginversion} ne podpira te verzije moodula {$a->moodleversion}. Poiščite informacije o vtičniku, da lahko najdete podprte različice.';
$string['prefixcannotbeempty'] = '<p>Napaka: predpona tabele podatkovne zbirke ne more biti prazna ({$a})</p>
<p>Skrbnik spletnega mesta mora odpraviti to težavo.</p>';
$string['prefixtoolong'] = '<p>Napaka: predpona tabele podatkovne zbirke je predolga ({$a->dbfamily})</p>
<p>Skrbnik spletnega mesta mora odpraviti to napako. Največja dolžina predpone tabele v {$a->dbfamily} znaša {$a->maxlength} znakov.</p>';
$string['privatefilesupload'] = 'Nalaganje neposredno na območje za zasebne datoteke uporabnika ni več podprto. Datoteke naložite na območje za osnutke in jih nato premestite z core_user::add_user_private_files';
$string['processingstops'] = 'Obdelava se na tem mestu konča. Preostali zapisi so prezrti.';
$string['protected_cc_not_supported'] = 'Zaščitene kartuše niso podprte.';
$string['querystringcannotbeempty'] = 'Niz poizvedbe ne more biti prazen.';
$string['redirecterrordetected'] = 'Zaznana je bila nepodprta preusmeritev, izvajanje skripta je bilo zaustavljeno';
$string['refoundto'] = 'Ne morem povrniti na {$a}';
$string['refoundtoorigi'] = 'Povrnjeno na prvotno vrednost: {$a}';
$string['registrationdisabled'] = 'Registracija je onemogočena na tem spletnem mestu';
$string['remotedownloaderror'] = '<p>Prenos komponente na vaš strežnik ni uspel. Prosimo, da preverite nastavitve prehodnega strežnika. Priporočamo uporabo razširitve cURL za PHP.<br /><br />Datoteko <a href="{$a->url}">{$a->url}</a> morate prenesti ročno - skopirajte jo v imenik "{$a->dest}" in razširite.</p>';
$string['remotedownloadnotallowed'] = 'Nalaganje komponent na vaš strežnik ni dovoljeno (allow_url_fopen je onemogočen).<br /><br />Ročno morate prenesti datoteko <a href="{$a->url}">{$a->url}</a>, jo kopirati v imenik "{$a->dest}" na vašem strežniku in jo tam razširiti.';
$string['reportnotavailable'] = 'Ta vrsta poročila je na voljo samo za to stran predmeta';
$string['requirecorrectaccess'] = 'Neveljaven url ali vrata.';
$string['requireloginerror'] = 'Predmet ali dejavnost ni na voljo.';
$string['restore_path_element_missingmethod'] = 'Manjka obnovitvena metoda {$a}. Določiti jo mora razvijalec.';
$string['restore_path_element_noobject'] = 'Obnovitveni objekt {$a} ni objekt.';
$string['restorechecksumfailed'] = 'Prišlo je do težave z obnovljenimi informacijami, ki so bile shranjene v vaši seji. Preverite spomin PHP/omejitve velikosti paketa DB. Obnovitev ustavljena.';
$string['restrictedcontextexception'] = 'Izvajanje zunanje funkcije krši omejitve vsebine.';
$string['restricteduser'] = 'Vaš trenutni račun "{$a}" ne sme narediti tega';
$string['reverseproxyabused'] = 'Obratni posredniški strežnik je omogočen, zato neposreden dostop do strežnika ni mogoč.<br />Obrnite se na skrbnika strežnika.';
$string['rpcerror'] = 'Komunikacija MNET ni uspela! Tukaj je sporočilo o napaki, ki ga posredujte skrbniku: {$a}';
$string['scheduledbackupsdisabled'] = 'Ustvarjanje vnaprej določenih varnostnih kopij je onemogočil skrbnik strežnika';
$string['secretalreadyused'] = 'Povezava za potrditev spremembe gesla je že bila uporabljena, geslo ni bilo spremenjeno';
$string['sectionnotexist'] = 'Ta odsek ne obstaja';
$string['sendmessage'] = 'Pošljite sporočilo';
$string['sendmessagesent'] = 'Hvala za vaš odziv na:<br>{$a}';
$string['serverconnection'] = 'Napaka pri vzpostavljanju povezave s strežnikom';
$string['servicedonotexist'] = 'Ta storitev ne obstaja';
$string['sessioncookiesdisable'] = 'Nepravilna uporaba require_key_login() - piškotki seje morajo biti onemogočeni!';
$string['sessiondiskfull'] = 'Particija seje je polna. Trenutno prijava ni mogoča. Obvestite skrbnika strežnika.';
$string['sessionerroruser'] = 'Vaša seja je potekla. Prijavite se znova.';
$string['sessionerroruser2'] = 'Zaznana je bila napaka strežnika, ki vpliva na vašo sejo za prijavo. Prijavite se znova ali ponovno zaženite brskalnik.';
$string['sessionexpired'] = 'Seja je potekla';
$string['sessionhandlerproblem'] = 'Program za obravnavo sej je napačno konfiguriran';
$string['sessionipnomatch'] = 'Vaša IP številka se je spremenila, odkar ste se prvič prijavili. Ta varnostna funkcija preprečuje zlonamerno krajo vaše identitete, medtem ko ste prijavljeni na tej strani. Navadni uporabniki tega sporočila ne bi smeli videti - za pomoč prosite skrbnika spletnega mesta.';
$string['sessionipnomatch2'] = '<p>Vaša IP številka se je spremenila, odkar ste se prvič prijavili. Ta varnostna funkcija preprečuje zlonamerno krajo vaše identitete, medtem ko ste prijavljeni na tej strani. To napako lahko vidite, ko uporabljate brezžično omrežje ali če preklapljate med različnimi omrežji. Za več pomoči prosite skrbnika spletnega mesta.</p>
<p>Če želite nadaljevati, pritisnite tipko F5, da osvežite to stran.</p>';
$string['sessionwaiterr'] = 'Med čakanjem na zaklepanje seje je čas potekel.<br />Počakajte trenutne zahteve, da se zaključijo, in poskusite ponovno kasneje.';
$string['shortnametaken'] = 'Kratko ime že uporablja drug predmet ({$a})';
$string['sitepolicynotagreed'] = 'Ni v skladu s pravilnikom mesta: <a href=«{$a}«>Kliknite tukaj, da odprete spletno mesto pravilnika.</a>';
$string['socksnotsupported'] = 'Proxy SOCKS5 v PHP4 ni podprt';
$string['spellcheckernotconf'] = 'Črkovalnik ni konfiguriran';
$string['sslonlyaccess'] = 'Iz varnostnih razlogov so dovoljene samo povezave https.';
$string['statscatchupmode'] = 'Statistika je trenutno v načinu sledenja. Do zdaj je bilo obdelanih {$a->daysdone} dni in na obdelavo čaka {$a->dayspending} dni. Kmalu spet preverite!';
$string['statsdisable'] = 'Statistika ni omogočena.';
$string['statsnodata'] = 'Podatki za to kombinacijo predmeta in časovnega obdobja niso na voljo';
$string['storedfilecannotcreatefile'] = 'Lokalne datoteke skupine virov ni mogoče ustvariti, preverite dovoljenja v podatkovnem korenu in nezaseden prostor na disku.';
$string['storedfilecannotcreatefiledirs'] = 'Lokalnih map za skupke datotek ni mogoče ustvariti. Preverite dovoljenja v korenski mapi.';
$string['storedfilecannotread'] = 'Datoteke ni mogoče prebrati. Ali datoteka ne obstaja ali pa je prišlo do težave z dovoljenjem.';
$string['storedfilecannotreadfile'] = 'Datoteke \'{$a}\' ni mogoče prebrati. Ali datoteka ne obstaja ali pa je prišlo do težave z dovoljenjem.';
$string['storedfilenotcreated'] = 'Datoteke "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}" ni mogoče ustvariti';
$string['storedfileproblem'] = 'Neznana izjema, ki se navezuje na lokalne datoteke ({$a})';
$string['tagdisabled'] = 'Oznake so onemogočene!';
$string['tagnotfound'] = 'Izbrane oznake ni v podatkovni bazi';
$string['targetdatabasenotempty'] = 'Ciljna podatkovna zbirka ni prazna. Prenos je prekinjen iz varnostnih razlogov.';
$string['textconditionsnotallowed'] = 'Primerjava pogojev tekstovnih stolpcev ni dovoljena. Pri povpraševanju uporabite sql_compare_text().';
$string['themenotinstall'] = 'Ta tema ni nameščena!';
$string['tokengenerationfailed'] = 'Ne morem ustvariti novega žetona.';
$string['transactionvoid'] = 'Transakcija ne more biti razveljavljena, ker je že bila razveljavljena';
$string['unenrolerror'] = 'Prišlo je do napake med poskusom izpisa te osebe';
$string['unicodeupgradeerror'] = 'Žal vaša podatkovna zbirka ni v standardu Unicode in trenutna verzija Moodla vaše podatkovne zbirke ne more posodobiti v Unicode. Najprej naredite nadgradnjo na Moodle 1.7.x in v tej verziji na Skrbniški strani izvedete Unicode posodobitev. Za tem boste lahko prešli na Moodle {$a}';
$string['unknowaction'] = 'Neznano dejanje!';
$string['unknowcategory'] = 'Kategorija ni poznana!';
$string['unknowcontext'] = 'To je neznan kontekst ({$a}) v get_child_contexts!';
$string['unknowformat'] = 'Format ni poznan ({$a})';
$string['unknownbackupexporterror'] = 'Neznana napaka pri pripravi informacij za uvoz';
$string['unknownblockregion'] = 'Regija bloka \'{$a}\' na tej strani ni prepoznana.';
$string['unknowncontext'] = 'To je neznan kontekst.';
$string['unknowncourse'] = 'Neznan predmet z imenom "{$a}"';
$string['unknowncourseidnumber'] = 'Neznan ID predmeta "{$a}"';
$string['unknowncourserequest'] = 'Neznana zahteva za predmet';
$string['unknowncoursesection'] = 'Neznan odsek predmeta v predmetu "{$a}"';
$string['unknownevent'] = 'Neznan dogodek';
$string['unknownfiletype'] = 'Napaka neznane vrste filtra';
$string['unknowngroup'] = 'Neznana skupina "{$a}"';
$string['unknownhelp'] = 'Neznana tema pomoči {$a}';
$string['unknownjsinrequirejs'] = 'Javascript knjižnice {$a} ni mogoče najti.';
$string['unknownmodulename'] = 'Neznano ime modula za obrazec';
$string['unknownrole'] = 'Neznana vloga "{$a}"';
$string['unknownsortcolumn'] = 'Neznan razvrstilni stolpec {$a}';
$string['unknownuseraction'] = 'Tega uporabniškega dejanja ni mogoče razumeti';
$string['unknownuserselector'] = 'Nepoznan uporabniški izbirnik';
$string['unknoworder'] = 'Nepoznano naročanje';
$string['unknowparamtype'] = 'Neznana vrsta parametra: {$a}';
$string['unknowquestiontype'] = 'Tip vprašanja ({$a}) ni podprt';
$string['unknowuploadaction'] = 'Napaka: Neznano dejanje nalaganja ({$a})';
$string['unspecifycourseid'] = 'Določiti morate id predmeta, kratko ime ali id številko';
$string['unsupportedevent'] = 'Tip dogodka ({$a}) ni podprt';
$string['unsupportedstate'] = 'Stanje zaključenosti ni podprto';
$string['unsupportedwebserver'] = 'Programska oprema spletnega strežnika ({$a}) ni podprta.';
$string['upgraderequires19'] = 'Napaka: na strežnik je bila nameščena nova različica Moodla, vendar nadgradnja iz prejšnjih različic ni podprta .<br />Najprej posodobite na zadnjo različico 1.9.x. Lahko se tudi vrnete na prejšnjo različico s ponovno namestitvijo prvotnih datotek.';
$string['upgraderunning'] = 'Stran je v posodabljanju, poskusite pozneje.';
$string['urlnotdefinerss'] = 'URL ni definiran za vir RSS';
$string['useradmineditadmin'] = 'Samo skrbnikoi smejo spreminjati ostalie skrbniške računov';
$string['useradminodelete'] = 'Skrbniških računov ni mogoče izbrisati';
$string['userautherror'] = 'Neznan vtičnik za preverjanje pristnosti';
$string['userauthunsupported'] = 'Vtičnik za preverjanje pristnosti ni podprt tukaj';
$string['useremailduplicate'] = 'Podvojen e-poštni naslov';
$string['usermustbemnet'] = 'Uporabniki v MNET dostopnem kontrolnem seznamu morajo biti oddaljeni MNET uporabniki';
$string['usernamelowercase'] = 'Uporabniško ime mora imeti male črke';
$string['usernotaddederror'] = 'Uporabnik ni bil dodan - napaka';
$string['usernotaddedregistered'] = 'Uporabnik ni bil dodan - že registriran';
$string['usernotavailable'] = 'Podrobnosti tega uporabnika vam niso na voljo';
$string['usernotdeletedadmin'] = 'Uporabnik ni izbrisan - skrbniških računov ni mogoče izbrisati';
$string['usernotdeleteddeleted'] = 'Uporabnik je že izbrisan.';
$string['usernotdeletederror'] = 'Uporabnik ni izbrisan - napaka';
$string['usernotdeletedmissing'] = 'Uporabniškega imena ni mogoče najti - uporabnik ni izbrisan';
$string['usernotdeletedoff'] = 'Uporabnik ni izbrisan - brisanje ni dovoljeno';
$string['usernotfullysetup'] = 'Uporabnik ni v celoti nastavljen';
$string['usernotincourse'] = 'Ta uporabnik ni v tem predmetu!';
$string['usernotrenamedadmin'] = 'Skrbniških uporabniških imen ni mogoče preimenovati';
$string['usernotrenamedexists'] = 'Uporabnik ni preimenovan - novo uporabniško ime je že uporabljeno';
$string['usernotrenamedmissing'] = 'Uporabnik ni preimenovan - starega uporabniškega imena ni bilo mogočenajti';
$string['usernotrenamedoff'] = 'Uporabnik ni preimenovan - preimenovanje ni dovoljeno';
$string['usernotupdatedadmin'] = 'Posodobitev skrbniških računov ni mogoča';
$string['usernotupdatederror'] = 'Uporabnik ni posodobljen - napaka';
$string['usernotupdatednotexists'] = 'Uporabnik ni posodobljen - uporabnik ne obstaja';
$string['userquotalimit'] = 'Dosegli ste limito kvote vaše datoteke.';
$string['userselectortoomany'] = 'user_selector je dobil več kot enega izbranega uporabnika, čeprav je večkratni izbor napačen.';
$string['verifyagedigitalconsentnotpossible'] = 'Žal digitalna preverba starostne privolitve trenutno ni na voljo.';
$string['wrongcall'] = 'Ta skript je napačno klican';
$string['wrongcontextid'] = 'ID konteksta je napačen (ni ga mogoče najti)';
$string['wrongdestpath'] = 'Napačna ciljna pot';
$string['wrongroleid'] = 'Napačen ID vloge!';
$string['wrongsourcebase'] = 'Napačna osnova URL vira';
$string['wrongusernamepassword'] = 'Napačen uporabnik/geslo';
$string['wrongzipfilename'] = 'Napačno ime datoteke ZIP';
$string['wscouldnotcreateecoursenopermission'] = 'WS - predmeta ni mogoče ustvariti - brez dovoljenja';
$string['wwwrootmismatch'] = 'Zaznan je bil nepravilni dostop, do tega strežnika je mogoče dostopati le prek naslovov "{$a}".<br />Obvestite skrbnika strežnika.';
$string['wwwrootslash'] = 'Zaznan je bil nepravilni $CFG->wwwroot v config.php, ne sme vsebovati poševnice <br />Prosimo obvestite skrbnika strežnika.';
$string['xmldberror'] = 'Napaka XMLDB!';
$string['youcannotdeletecategory'] = 'Kategorije \'{$a}\' ni mogoče izbrisati, ker nimate dovoljenja za brisanje vsebine ali premik vsebine drugam.';
