<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'sl', version '4.1'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Naslov';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Vstavi/uredi zaznamek';
$string['advanced:backcolor_desc'] = 'Izberite barvo ozadja';
$string['advanced:block'] = 'Oblika';
$string['advanced:blockquote'] = 'Daljši citat';
$string['advanced:blockquote_desc'] = 'Daljši citat';
$string['advanced:bold_desc'] = 'Krepko (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Vstavi/odstrani seznamske točke';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Vstavi posebni znak';
$string['advanced:cleanup_desc'] = 'Prečisti kodo';
$string['advanced:clipboard_msg'] = 'Funkcije kopiraj/izreži/prilepi niso na voljo v brskalnikih Mozilla in Firefox.
Ali želite več informacij o tem?';
$string['advanced:code'] = 'Koda';
$string['advanced:code_desc'] = 'Uredi kodo HTML';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopiraj';
$string['advanced:custom1_desc'] = 'Opis tule';
$string['advanced:cut_desc'] = 'Izreži';
$string['advanced:dd'] = 'Definicija – opis';
$string['advanced:div'] = 'Blok';
$string['advanced:dt'] = 'Definicija – izraz';
$string['advanced:font_size'] = 'Velikost pisave';
$string['advanced:fontdefault'] = 'Družina pisave';
$string['advanced:forecolor_desc'] = 'Izberite barvo pisave';
$string['advanced:h1'] = 'Naslov 1';
$string['advanced:h2'] = 'Naslov 2';
$string['advanced:h3'] = 'Naslov 3';
$string['advanced:h4'] = 'Naslov 4';
$string['advanced:h5'] = 'Naslov 5';
$string['advanced:h6'] = 'Naslov 6';
$string['advanced:help_desc'] = 'Pomoč';
$string['advanced:help_shortcut'] = 'Za orodno vrstico pritisnite ALT-F10. Za pomoč pritisnite ALT-0';
$string['advanced:hr_desc'] = 'Vstavi vodoravno črto';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Vstavi/uredi sliko';
$string['advanced:image_props_desc'] = 'Lastnosti slike';
$string['advanced:indent_desc'] = 'Povečaj zamik';
$string['advanced:italic_desc'] = 'Ležeče (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Poravnava na sredino';
$string['advanced:justifyfull_desc'] = 'Polna poravnava';
$string['advanced:justifyleft_desc'] = 'Poravnava levo';
$string['advanced:justifyright_desc'] = 'Poravnava desno';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Vstavi/uredi povezavo';
$string['advanced:more_colors'] = 'Več barv';
$string['advanced:newdocument'] = 'Ste prepričani, da želite odstraniti vsebino?';
$string['advanced:newdocument_desc'] = 'Nov dokument';
$string['advanced:numlist_desc'] = 'Vstavi/odstrani seznam';
$string['advanced:outdent_desc'] = 'Zmanjšaj zamik';
$string['advanced:paragraph'] = 'Odstavek';
$string['advanced:paste_desc'] = 'Prilepi';
$string['advanced:path'] = 'Pot';
$string['advanced:pre'] = 'Predoblikovano';
$string['advanced:redo_desc'] = 'Uveljavi (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Odstrani oblikovanje';
$string['advanced:rich_text_area'] = 'Območje obogatenega besedila';
$string['advanced:samp'] = 'Primer kode';
$string['advanced:shortcuts_desc'] = 'Pomoč za dostopnost';
$string['advanced:striketrough_desc'] = 'Prečrtano';
$string['advanced:style_select'] = 'Izberite slog';
$string['advanced:sub_desc'] = 'Podpisano';
$string['advanced:sup_desc'] = 'Nadpisano';
$string['advanced:toolbar'] = 'Orodna vrstica';
$string['advanced:toolbar_focus'] = 'Preskok na orodjarno - Alt+Q, preskok v urejevalnik - Alt-Z, preskok na pot elementa - Alt-X';
$string['advanced:underline_desc'] = 'Podčrtano (Ctrl+U)';
$string['advanced:undo_desc'] = 'Razveljavi (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Odstrani povezavo';
$string['advanced:visualaid_desc'] = 'Preklop prikaza vodil';
$string['advanced_dlg:'] = '';
$string['advanced_dlg:about_author'] = 'Avtor';
$string['advanced_dlg:about_general'] = 'Vizitka';
$string['advanced_dlg:about_help'] = 'Pomoč';
$string['advanced_dlg:about_license'] = 'Licenca';
$string['advanced_dlg:about_loaded'] = 'Naloženi vsadki';
$string['advanced_dlg:about_plugin'] = 'Vtičnik';
$string['advanced_dlg:about_plugins'] = 'Vtičniki';
$string['advanced_dlg:about_title'] = 'O TinyMCE';
$string['advanced_dlg:about_version'] = 'Različica';
$string['advanced_dlg:accessibility_help'] = 'Pomoč za dostopnost';
$string['advanced_dlg:accessibility_usage_title'] = 'Splošni uporaba';
$string['advanced_dlg:anchor_invalid'] = 'Prosimo, navedite veljavno ime zaznamka';
$string['advanced_dlg:anchor_name'] = 'Ime zaznamka';
$string['advanced_dlg:anchor_title'] = 'Vstavi/uredi zaznamek';
$string['advanced_dlg:charmap_title'] = 'Izberite posebni znak';
$string['advanced_dlg:charmap_usage'] = 'Za krmarjenje uporabite levo in desno puščico.';
$string['advanced_dlg:code_title'] = 'Urejevalnik kode HTML';
$string['advanced_dlg:code_wordwrap'] = 'Prelomi vrstice';
$string['advanced_dlg:colorpicker_color'] = 'Barva:';
$string['advanced_dlg:colorpicker_name'] = 'Ime:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Poimenovane';
$string['advanced_dlg:colorpicker_named_title'] = 'Poimenovane barve';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paleta';
$string['advanced_dlg:colorpicker_palette_title'] = 'Barve palete';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Izbirnik';
$string['advanced_dlg:colorpicker_picker_title'] = 'Izbor barve';
$string['advanced_dlg:colorpicker_title'] = 'Izberite barvo';
$string['advanced_dlg:image_align'] = 'Poravnava';
$string['advanced_dlg:image_align_baseline'] = 'Osnovna črta';
$string['advanced_dlg:image_align_bottom'] = 'Spodaj';
$string['advanced_dlg:image_align_left'] = 'Levo';
$string['advanced_dlg:image_align_middle'] = 'Sredina';
$string['advanced_dlg:image_align_right'] = 'Desno';
$string['advanced_dlg:image_align_textbottom'] = 'Dno besedila';
$string['advanced_dlg:image_align_texttop'] = 'Vrh besedila';
$string['advanced_dlg:image_align_top'] = 'Vrh';
$string['advanced_dlg:image_alt'] = 'Opis slike';
$string['advanced_dlg:image_border'] = 'Obroba';
$string['advanced_dlg:image_dimensions'] = 'Dimenzije';
$string['advanced_dlg:image_hspace'] = 'Prostor le/de';
$string['advanced_dlg:image_list'] = 'Seznam slik';
$string['advanced_dlg:image_src'] = 'URL slike';
$string['advanced_dlg:image_title'] = 'Vstavi/uredi sliko';
$string['advanced_dlg:image_vspace'] = 'Prostor zg/sp';
$string['advanced_dlg:invalid_color_value'] = 'Neveljavna vrednost barve';
$string['advanced_dlg:link_is_email'] = 'Vnešeni URL ima obliko e-naslova. Ali želite dodati zahtevano predpono \'mailto:\'?';
$string['advanced_dlg:link_is_external'] = 'Vnešeni URL ima obliko zunanje povezave. Ali želite dodati zahtevano predpono \'http://?';
$string['advanced_dlg:link_list'] = 'Seznam povezav';
$string['advanced_dlg:link_target'] = 'Cilj';
$string['advanced_dlg:link_target_blank'] = 'Odpri povezavo v novem oknu';
$string['advanced_dlg:link_target_same'] = 'Odpri povezavo v istem oknu';
$string['advanced_dlg:link_title'] = 'Vstavi/uredi povezavo';
$string['advanced_dlg:link_titlefield'] = 'Naslov';
$string['advanced_dlg:link_url'] = 'Naslov URL';
$string['advhr:advhr_desc'] = 'Vstavi vodoravno črto';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Običajno';
$string['advhr_dlg:noshade'] = 'Brez senčenja';
$string['advhr_dlg:size'] = 'Višina';
$string['advhr_dlg:width'] = 'Širina';
$string['advhr_dlg:widthunits'] = 'Enote';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Vstavi/uredi sliko';
$string['advimage_dlg:align'] = 'Poravnava';
$string['advimage_dlg:align_baseline'] = 'Osnovna črta';
$string['advimage_dlg:align_bottom'] = 'Spodaj';
$string['advimage_dlg:align_left'] = 'Levo';
$string['advimage_dlg:align_middle'] = 'Sredina';
$string['advimage_dlg:align_right'] = 'Desno';
$string['advimage_dlg:align_textbottom'] = 'Dno besedila';
$string['advimage_dlg:align_texttop'] = 'Vrh besedila';
$string['advimage_dlg:align_top'] = 'Vrh';
$string['advimage_dlg:alt'] = 'Opis slike';
$string['advimage_dlg:alt_image'] = 'Nadomestna slika';
$string['advimage_dlg:border'] = 'Obroba';
$string['advimage_dlg:classes'] = 'Razredi';
$string['advimage_dlg:constrain_proportions'] = 'Zakleni razmerje';
$string['advimage_dlg:dialog_title'] = 'Vstavi/uredi sliko';
$string['advimage_dlg:dimensions'] = 'Dimenzije';
$string['advimage_dlg:example_img'] = 'Predogled izgleda';
$string['advimage_dlg:general'] = 'Splošno';
$string['advimage_dlg:height'] = 'Višina';
$string['advimage_dlg:hspace'] = 'Prostor le/de';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Seznam slik';
$string['advimage_dlg:langcode'] = 'Koda jezika';
$string['advimage_dlg:langdir'] = 'Smer jezika';
$string['advimage_dlg:list'] = 'Seznam slik';
$string['advimage_dlg:long_desc'] = 'Povezava do opisa';
$string['advimage_dlg:ltr'] = 'Od leve proti desni';
$string['advimage_dlg:map'] = 'Karta slike';
$string['advimage_dlg:misc'] = 'Razno';
$string['advimage_dlg:missing_alt'] = 'Ali zares želite nadaljevati, ne da bi določili opis slike? Slika brez opisa ne bo na voljo uporabnikom, ki slabo vidijo, imajo izklopljen prikaz slik ali uporabljajo tekstni brskalnik.';
$string['advimage_dlg:mouseout'] = 'pri miški izven';
$string['advimage_dlg:mouseover'] = 'pri miški nad';
$string['advimage_dlg:preview'] = 'Predogled';
$string['advimage_dlg:rtl'] = 'Od desne proti levi';
$string['advimage_dlg:src'] = 'URL slike';
$string['advimage_dlg:style'] = 'Slog';
$string['advimage_dlg:swap_image'] = 'Zamenjava slike';
$string['advimage_dlg:tab_advanced'] = 'Napredno';
$string['advimage_dlg:tab_appearance'] = 'Izgled';
$string['advimage_dlg:tab_general'] = 'Splošno';
$string['advimage_dlg:title'] = 'Naslov';
$string['advimage_dlg:vspace'] = 'Prostor zg/sp';
$string['advimage_dlg:width'] = 'Širina';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Vstavi/uredi povezavo';
$string['advlink_dlg:accesskey'] = 'Tipka dostopa';
$string['advlink_dlg:advanced_props'] = 'Napredne lastnosti';
$string['advlink_dlg:advanced_tab'] = 'Napredno';
$string['advlink_dlg:anchor_names'] = 'Sidra';
$string['advlink_dlg:classes'] = 'Razredi';
$string['advlink_dlg:encoding'] = 'Kodiranje ciljnih znakov';
$string['advlink_dlg:event_props'] = 'Dogodki';
$string['advlink_dlg:events_tab'] = 'Dogodki';
$string['advlink_dlg:general_props'] = 'Splošne lastnosti';
$string['advlink_dlg:general_tab'] = 'Splošno';
$string['advlink_dlg:height'] = 'Višina';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'Vnešeni URL ima obliko e-naslova. Ali želite dodati zahtevano predpono \'mailto:\'?';
$string['advlink_dlg:is_external'] = 'Vnešeni URL ima obliko zunanje povezave. Ali želite dodati zahtevano predpono \'http://?';
$string['advlink_dlg:langcode'] = 'Koda jezika';
$string['advlink_dlg:langdir'] = 'Smer jezika';
$string['advlink_dlg:link_list'] = 'Seznam povezav';
$string['advlink_dlg:list'] = 'Seznam povezav';
$string['advlink_dlg:ltr'] = 'Od leve proti desni';
$string['advlink_dlg:mime'] = 'Ciljni tip MIME';
$string['advlink_dlg:popup'] = 'Dodatno okno JavaScript';
$string['advlink_dlg:popup_dependent'] = 'Odvisno (le za Mozillo/Firefox)';
$string['advlink_dlg:popup_location'] = 'Prikaži vrstico naslova';
$string['advlink_dlg:popup_menubar'] = 'Prikaži meni';
$string['advlink_dlg:popup_name'] = 'Ime okna';
$string['advlink_dlg:popup_opts'] = 'Možnosti';
$string['advlink_dlg:popup_position'] = 'Položaj (X/Y)';
$string['advlink_dlg:popup_props'] = 'Lastnosti pojavnega okna';
$string['advlink_dlg:popup_resizable'] = 'Omogoči spremembo velikosti okna';
$string['advlink_dlg:popup_return'] = 'Vstavi \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Prikaži drsnike';
$string['advlink_dlg:popup_size'] = 'Velikost';
$string['advlink_dlg:popup_statusbar'] = 'Prikaži vrstico stanja';
$string['advlink_dlg:popup_tab'] = 'Pojavno okno';
$string['advlink_dlg:popup_toolbar'] = 'Prikaži orodno vrstico';
$string['advlink_dlg:popup_url'] = 'Pojavno okno URL';
$string['advlink_dlg:rel'] = 'Odnos strani do cilja';
$string['advlink_dlg:rev'] = 'Odnos cilja do strani';
$string['advlink_dlg:rtl'] = 'Od desne proti levi';
$string['advlink_dlg:style'] = 'Slog';
$string['advlink_dlg:tabindex'] = 'Zap. št.';
$string['advlink_dlg:target'] = 'Cilj';
$string['advlink_dlg:target_blank'] = 'Odpri v novem oknu';
$string['advlink_dlg:target_langcode'] = 'Ciljni jezik';
$string['advlink_dlg:target_name'] = 'Ime cilja';
$string['advlink_dlg:target_parent'] = 'Odpri v nadrejenem oknu / okviru';
$string['advlink_dlg:target_same'] = 'Odpri v tem oknu / okviru';
$string['advlink_dlg:target_top'] = 'Odpri v vrhnjem okviru (nadomesti vse okvire)';
$string['advlink_dlg:title'] = 'Vstavi/uredi povezavo';
$string['advlink_dlg:titlefield'] = 'Naslov';
$string['advlink_dlg:url'] = 'Naslov URL';
$string['advlink_dlg:width'] = 'Širina';
$string['advlist:circle'] = 'Krog';
$string['advlist:def'] = 'Privzeto';
$string['advlist:disc'] = 'Disk';
$string['advlist:lower_alpha'] = 'Majhna \'alfa';
$string['advlist:lower_greek'] = 'Majhna \'greek';
$string['advlist:lower_roman'] = 'Majhna \'roman';
$string['advlist:square'] = 'Kvadrat';
$string['advlist:types'] = 'Tipi';
$string['advlist:upper_alpha'] = 'Velika \'alfa';
$string['advlist:upper_roman'] = 'Velika \'roman';
$string['aria:rich_text_area'] = 'Območje obogatenega besedila';
$string['autosave:restore_content'] = 'Obnovi samodejno shranjeno vsebino.';
$string['autosave:unload_msg'] = 'Ce se premaknete na drugo stran, bodo narejene spremembe izgubljene!';
$string['autosave:warning_message'] = 'Če obnovite shranjeno vsebino, boste izgubili vso vsebino, ki je trenutno v urejevalniku besedila.

Ali ste prepričani, da želite obnoviti shranjeno vsebino?';
$string['availablebuttons'] = 'Razpoložljivi gumbi';
$string['colors:000000'] = 'Črna';
$string['colors:000080'] = 'Mornarsko modra';
$string['colors:0000FF'] = 'Modra';
$string['colors:003300'] = 'Temno zelena';
$string['colors:003366'] = 'Temno azurno modra';
$string['colors:008000'] = 'Zelena';
$string['colors:008080'] = 'Zelenomodra';
$string['colors:00CCFF'] = 'Nebesno modra';
$string['colors:00FF00'] = 'Rumenozelena';
$string['colors:00FFFF'] = 'Akvamarin';
$string['colors:333300'] = 'Temno olivno zelena';
$string['colors:333333'] = 'Temno siva';
$string['colors:333399'] = 'Indigo';
$string['colors:3366FF'] = 'Kraljevsko modra';
$string['colors:339966'] = 'Morsko zelena';
$string['colors:33CCCC'] = 'Turkizna';
$string['colors:666699'] = 'Sivomodra';
$string['colors:800000'] = 'Kostanjeva';
$string['colors:800080'] = 'Vijoličasta';
$string['colors:808000'] = 'Olivno zelena';
$string['colors:808080'] = 'Siva';
$string['colors:993300'] = 'Temno oranžna';
$string['colors:993366'] = 'Rjava';
$string['colors:999999'] = 'Srednje sivo';
$string['colors:99CC00'] = 'Rumeno-zelena';
$string['colors:99CCFF'] = 'Svetla nebesno modra';
$string['colors:C0C0C0'] = 'Srebrna';
$string['colors:CC99FF'] = 'Rdečkasto vijolična';
$string['colors:CCFFCC'] = 'Bledo zelena';
$string['colors:CCFFFF'] = 'Bledo cijan';
$string['colors:FF0000'] = 'Rdeča';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Oranžna';
$string['colors:FF9900'] = 'Jantarna';
$string['colors:FF99CC'] = 'Rožnata';
$string['colors:FFCC00'] = 'Zlata';
$string['colors:FFCC99'] = 'Breskova';
$string['colors:FFFF00'] = 'Rumena';
$string['colors:FFFF99'] = 'Svetlo rumena';
$string['colors:FFFFFF'] = 'Bela';
$string['common:apply'] = 'Uporabi';
$string['common:browse'] = 'Prebrskaj';
$string['common:cancel'] = 'Prekliči';
$string['common:class_name'] = 'Razred';
$string['common:clipboard_msg'] = 'Funkcije kopiraj/izreži/prilepi niso na voljo v brskalnikih Mozilla in Firefox.
Ali želite več informacij o tem?';
$string['common:clipboard_no_support'] = 'Trenutno ni podporto v vašem brskalniku. Uporabite bližnjice na tipkovnici.';
$string['common:close'] = 'Zapri';
$string['common:edit_confirm'] = 'Želite uporabiti način \'videz ne vara\' (WYSIWYG) za to vnosno polje?';
$string['common:insert'] = 'Vstavi';
$string['common:invalid_data'] = 'Napaka: vnešene so bile neveljavne vrednosti, označene so z rdečo.';
$string['common:invalid_data_min'] = '{#field} mora biti številka, večja od {#min}';
$string['common:invalid_data_number'] = '{#field} mora biti številka';
$string['common:invalid_data_size'] = '{#field} mora biti številka ali odstotek';
$string['common:more_colors'] = 'Več barv';
$string['common:not_set'] = '-- ni nastavljeno --';
$string['common:popup_blocked'] = 'Žal vaše orodje za preprečevanje odpiranja pojavnih oken (popup-blocker) ne omogoča prikaza pojavnega okna izbranega orodja. Preprečevanje odpiranja oken morate onemogočiti, če elite uporabljati orodje.';
$string['common:update'] = 'Posodobi';
$string['common:value'] = '(vrednost)';
$string['contextmenu:align'] = 'Poravnava';
$string['contextmenu:center'] = 'Sredina';
$string['contextmenu:full'] = 'Polno';
$string['contextmenu:left'] = 'Levo';
$string['contextmenu:right'] = 'Desno';
$string['customconfig'] = 'Konfiguracija po meri';
$string['customconfig_desc'] = 'Napredna konfiguracija po meri TinyMCE v formatu JSON, na primer: {"option1" : "value2", "option2" : "value2"}. Vse naštete nastavitve preglasijo privzete nastavitve in nastavitve vtičnika.';
$string['customtoolbar'] = 'Orodna vrstica urejevalnika';
$string['customtoolbar_desc'] = 'V vsaki vrstici je seznam imen gumbov, ločenih z vejico. Za ločevanje po skupinah uporabite "wrap", prazne vrstice se ne upoštevajo. Seznam privzetih gumbov TinyMCE najdete na <a href="{$a}" target="_blank">{$a}</a>. <br />Prva vrstica je vedno na vidnem mestu, medtem ko lahko drugo in tretjo orodno vrstico poljubno nastavite.';
$string['directionality:ltr_desc'] = 'Smer od leve proti desni';
$string['directionality:rtl_desc'] = 'Smer od desne proti levi';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Smeški';
$string['emotions_dlg:cool'] = 'Kul';
$string['emotions_dlg:cry'] = 'Jok';
$string['emotions_dlg:desc'] = 'Smeški';
$string['emotions_dlg:embarassed'] = 'V zadregi';
$string['emotions_dlg:foot_in_mouth'] = 'Zarečeni kruh';
$string['emotions_dlg:frown'] = 'Nagubano čelo';
$string['emotions_dlg:innocent'] = 'Nedolžen';
$string['emotions_dlg:kiss'] = 'Poljub';
$string['emotions_dlg:laughing'] = 'Smeh';
$string['emotions_dlg:money_mouth'] = 'Zlati kljun';
$string['emotions_dlg:sealed'] = 'Zapečateno';
$string['emotions_dlg:smile'] = 'Nasmeh';
$string['emotions_dlg:surprised'] = 'Presenečen';
$string['emotions_dlg:title'] = 'Vstavi čustveni simbol';
$string['emotions_dlg:tongue_out'] = 'Kaže jezik';
$string['emotions_dlg:undecided'] = 'Neodločen';
$string['emotions_dlg:usage'] = 'Za krmarjenje uporabite levo in desno puščico.';
$string['emotions_dlg:wink'] = 'pomežik';
$string['emotions_dlg:yell'] = 'Krik';
$string['fontselectlist'] = 'Seznam pisav, ki so na voljo';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Lastnosti dokumenta';
$string['fullpage_dlg:active_color'] = 'Barva dejavne povezave';
$string['fullpage_dlg:add'] = 'Dodaj element';
$string['fullpage_dlg:add_base'] = 'Osnova';
$string['fullpage_dlg:add_comment'] = 'Komentar';
$string['fullpage_dlg:add_link'] = 'Povezava';
$string['fullpage_dlg:add_meta'] = 'Element Meta';
$string['fullpage_dlg:add_script'] = 'Skript';
$string['fullpage_dlg:add_style'] = 'Slog';
$string['fullpage_dlg:add_title'] = 'Naslov';
$string['fullpage_dlg:advanced_props'] = 'Napredno';
$string['fullpage_dlg:advanced_tab'] = 'Napredno';
$string['fullpage_dlg:appearance_bgprops'] = 'Lastnosti ozadja';
$string['fullpage_dlg:appearance_linkprops'] = 'Barve povezav';
$string['fullpage_dlg:appearance_marginprops'] = 'Robovi telesa';
$string['fullpage_dlg:appearance_style'] = 'Lastnosti slogov';
$string['fullpage_dlg:appearance_tab'] = 'Izgled';
$string['fullpage_dlg:appearance_textprops'] = 'Lastnosti besedila';
$string['fullpage_dlg:author'] = 'Avtor';
$string['fullpage_dlg:base_element'] = 'Osnova';
$string['fullpage_dlg:bgcolor'] = 'Barva ozadja';
$string['fullpage_dlg:bgimage'] = 'Slika ozadja';
$string['fullpage_dlg:bottom_margin'] = 'Spodnji rob';
$string['fullpage_dlg:charset'] = 'Charset';
$string['fullpage_dlg:comment_element'] = 'Komentar';
$string['fullpage_dlg:content'] = 'Vsebina';
$string['fullpage_dlg:copyright'] = 'Avtorske pravice';
$string['fullpage_dlg:defer'] = 'Odloži';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'Kodiranje znakov';
$string['fullpage_dlg:font_face'] = 'Vrsta pisave';
$string['fullpage_dlg:font_size'] = 'Velikost pisave';
$string['fullpage_dlg:fontface'] = 'Družina pisave';
$string['fullpage_dlg:fontsize'] = 'Velikost pisave';
$string['fullpage_dlg:general_props'] = 'Splošno';
$string['fullpage_dlg:head_elements'] = 'Elementi glave';
$string['fullpage_dlg:hover_color'] = 'Barva nakazane povezave';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'Href lang';
$string['fullpage_dlg:info'] = 'Informacije';
$string['fullpage_dlg:langcode'] = 'Koda jezika';
$string['fullpage_dlg:langdir'] = 'Smer jezika';
$string['fullpage_dlg:langprops'] = 'Jezik in kodiranje';
$string['fullpage_dlg:language'] = 'Jezik';
$string['fullpage_dlg:left_margin'] = 'Levi rob';
$string['fullpage_dlg:link_color'] = 'Barva povezave';
$string['fullpage_dlg:link_element'] = 'Povezava';
$string['fullpage_dlg:ltr'] = 'Od leve proti desni';
$string['fullpage_dlg:media'] = 'Predstavnostna datoteka';
$string['fullpage_dlg:meta_description'] = 'Opis';
$string['fullpage_dlg:meta_element'] = 'Element Meta';
$string['fullpage_dlg:meta_index_follow'] = 'Indeksiraj in sledi povezavam';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indeksiraj a ne sledi povezavam';
$string['fullpage_dlg:meta_keywords'] = 'Ključne besede';
$string['fullpage_dlg:meta_noindex_follow'] = 'Ne indeksiraj, a sledi pvoezavam';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Ne indeksiraj in ne sledi povezavam';
$string['fullpage_dlg:meta_props'] = 'Meta podatki';
$string['fullpage_dlg:meta_robots'] = 'Roboti';
$string['fullpage_dlg:meta_tab'] = 'Splošno';
$string['fullpage_dlg:meta_title'] = 'Naslov';
$string['fullpage_dlg:movedown'] = 'Premakni izbrani element navzdol';
$string['fullpage_dlg:moveup'] = 'Premakni izbrani element navzgor';
$string['fullpage_dlg:name'] = 'Ime';
$string['fullpage_dlg:properties'] = 'Lastnosti';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Odstrani izbrani element';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Desni rob';
$string['fullpage_dlg:rtl'] = 'Od desne proti levi';
$string['fullpage_dlg:script_element'] = 'Skript';
$string['fullpage_dlg:src'] = 'Vir';
$string['fullpage_dlg:style'] = 'Slog';
$string['fullpage_dlg:style_element'] = 'Slog';
$string['fullpage_dlg:stylesheet'] = 'Slogovna datoteka';
$string['fullpage_dlg:target'] = 'Cilj';
$string['fullpage_dlg:text_color'] = 'Barva pisave';
$string['fullpage_dlg:textcolor'] = 'Barva';
$string['fullpage_dlg:title'] = 'Lastnosti dokumenta';
$string['fullpage_dlg:title_element'] = 'Naslov';
$string['fullpage_dlg:top_margin'] = 'Zgornji rob';
$string['fullpage_dlg:type'] = 'Tip';
$string['fullpage_dlg:value'] = 'Vrednost';
$string['fullpage_dlg:visited_color'] = 'Barva obiskane povezave';
$string['fullpage_dlg:xml_pi'] = 'Najava XML';
$string['fullscreen:desc'] = 'Preklopi celozaslonski način';
$string['iespell:download'] = 'ieSpell ni zaznan. Ga želite namestiti?';
$string['iespell:iespell_desc'] = 'Zaženi preverjanje črkovanja';
$string['insertdatetime:date_fmt'] = '%d.%m.%Y';
$string['insertdatetime:day_long'] = 'nedelja,ponedeljek,torek,sreda,četrtek,petek,sobota,nedelja';
$string['insertdatetime:day_short'] = 'ned,pon,tor,sre,čet,pet,sob,ned';
$string['insertdatetime:insertdate_desc'] = 'Vstavi datum';
$string['insertdatetime:inserttime_desc'] = 'Vstavi čas';
$string['insertdatetime:months_long'] = 'januar,februar,marec,april,maj,junij,julij,avgust,september,oktober,november,december';
$string['insertdatetime:months_short'] = 'jan,feb,mar,apr,maj,jun,jul,avg,sep,okt,nov,dec';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Preklopi absolutno pozicijo';
$string['layer:backward_desc'] = 'Premakni v ozadje';
$string['layer:content'] = 'Nov sloj...';
$string['layer:forward_desc'] = 'Premakni v ospredje';
$string['layer:insertlayer_desc'] = 'Vstavi nov sloj';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Vstavi/uredi vdelano predstavnostno datoteko';
$string['media:edit'] = 'Uredi vdelano multimedijsko vsebino';
$string['media_dlg:advanced'] = 'Napredno';
$string['media_dlg:align'] = 'Poravnaj';
$string['media_dlg:align_bottom'] = 'Spodaj';
$string['media_dlg:align_bottom_left'] = 'Spodaj levo';
$string['media_dlg:align_bottom_right'] = 'Spodaj desno';
$string['media_dlg:align_center'] = 'Sredina';
$string['media_dlg:align_left'] = 'Levo';
$string['media_dlg:align_right'] = 'Desno';
$string['media_dlg:align_top'] = 'Vrh';
$string['media_dlg:align_top_left'] = 'Zgoraj levo';
$string['media_dlg:align_top_right'] = 'Zgoraj desno';
$string['media_dlg:altsource1'] = 'Nadomestni vir 1';
$string['media_dlg:altsource2'] = 'Nadomestni vir 2';
$string['media_dlg:audio'] = 'Zvok HTML5';
$string['media_dlg:autogotourl'] = 'Samodejno na URL';
$string['media_dlg:autohref'] = '"AutoHREF"';
$string['media_dlg:autostart'] = 'Samodejno začni';
$string['media_dlg:balance'] = 'Ravnovesje';
$string['media_dlg:base'] = 'Osnova';
$string['media_dlg:baseurl'] = 'Osnovni URL';
$string['media_dlg:bgcolor'] = 'Ozadje';
$string['media_dlg:cache'] = 'Predpomnjenje';
$string['media_dlg:captioningid'] = 'Oznaka podnapisov';
$string['media_dlg:center'] = 'Sredina';
$string['media_dlg:class_name'] = 'Razred';
$string['media_dlg:console'] = 'Konzola';
$string['media_dlg:constrain_proportions'] = 'Zakleni razmerje';
$string['media_dlg:controller'] = 'Nadzorni element';
$string['media_dlg:controls'] = 'Nadzorni elementi';
$string['media_dlg:correction'] = 'Brez popravkov';
$string['media_dlg:currentmarker'] = 'Trenutna oznaka';
$string['media_dlg:currentposition'] = 'Trenutni položaj';
$string['media_dlg:defaultframe'] = 'Privzeti okvir';
$string['media_dlg:embedded_audio_options'] = 'Možnosti vedelanega zvoka';
$string['media_dlg:embeddedaudio'] = 'Vdelan avdio';
$string['media_dlg:enabled'] = 'Omogočeno';
$string['media_dlg:enablejavascript'] = 'Omogoči JavaScript';
$string['media_dlg:endtime'] = 'Čas zaključka';
$string['media_dlg:file'] = 'Datoteka/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Možnosti Flash';
$string['media_dlg:flashvars'] = '"Flashvars"';
$string['media_dlg:fullscreen'] = 'Celozaslonski način';
$string['media_dlg:general'] = 'Splošno';
$string['media_dlg:hidden'] = 'Skrito';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'v-razmik';
$string['media_dlg:html5_audio_options'] = 'Nastavitve zvoka';
$string['media_dlg:html5_video_options'] = 'Nastavitve videa HTML5';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Slika stanja';
$string['media_dlg:invokeurls'] = 'Naslovi URL';
$string['media_dlg:kioskmode'] = 'Način \'kiosk';
$string['media_dlg:list'] = 'Seznam';
$string['media_dlg:liveconnect'] = '"SWLiveConnect"';
$string['media_dlg:loop'] = 'Zanka';
$string['media_dlg:maintainaspect'] = 'Zakleni pogled';
$string['media_dlg:menu'] = 'Prikaži meni';
$string['media_dlg:mute'] = 'Tihi način';
$string['media_dlg:name'] = 'Ime';
$string['media_dlg:nojava'] = 'Brez Jave';
$string['media_dlg:numloop'] = 'Št. zank';
$string['media_dlg:play'] = 'Samodejno predvajaj';
$string['media_dlg:playcount'] = 'Število predvajanj';
$string['media_dlg:playeveryframe'] = 'Predvajaj vsak okvir';
$string['media_dlg:poster'] = 'Prispevek';
$string['media_dlg:prefetch'] = 'Vnaprejšnje branje';
$string['media_dlg:preload'] = 'Vnaprejšnje nalaganje';
$string['media_dlg:preload_auto'] = 'Odloči naj se uporabnikov brskalnik';
$string['media_dlg:preload_metadata'] = 'Vnaprej naloži video metapodatke';
$string['media_dlg:preload_none'] = 'Ne naloži vnaprej';
$string['media_dlg:preview'] = 'Predogled';
$string['media_dlg:progress'] = 'Napredek';
$string['media_dlg:qt_options'] = 'Možnosti Quicktime';
$string['media_dlg:qt_stream_warn'] = 'Pretočne RTSP vire je potrebno dodati v izvorno polje QT v zavihku napredno.
V izvorno polje dodajte tudi nepretočno različico.';
$string['media_dlg:qtsrc'] = 'Vir QT';
$string['media_dlg:qtsrcchokespeed'] = '"Choke speed"';
$string['media_dlg:quality'] = 'Kakovost';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Oceni';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Možnosti Real Media Player';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Lestvica';
$string['media_dlg:scriptcallbacks'] = 'Klicani skript';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Možnosti Shockwave';
$string['media_dlg:shuffle'] = 'Premešaj';
$string['media_dlg:size'] = 'Dimenzije';
$string['media_dlg:sound'] = 'Zvok';
$string['media_dlg:source'] = 'Vir';
$string['media_dlg:starttime'] = 'Čas začetka';
$string['media_dlg:stretchtofit'] = 'Razširi';
$string['media_dlg:swstretchhalign'] = 'Raztegni vodoravno poravnano';
$string['media_dlg:swstretchstyle'] = 'Slog raztegovanja';
$string['media_dlg:swstretchvalign'] = 'Raztegni vodoravno poravnano';
$string['media_dlg:target'] = 'Cilj';
$string['media_dlg:targetcache'] = 'Ciljno predpomnjenje';
$string['media_dlg:title'] = 'Vstavi/uredi vdelano predstavnostno datoteko';
$string['media_dlg:type'] = 'Tip';
$string['media_dlg:uimode'] = 'Način uporabniškega vmesnika';
$string['media_dlg:video'] = 'Video HTML5';
$string['media_dlg:volume'] = 'Glasnost';
$string['media_dlg:vspace'] = 'n-razmik';
$string['media_dlg:windowlessvideo'] = 'Video brez okna';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = '"WMode"';
$string['media_dlg:wmp_options'] = 'Možnosti Windows Media Player';
$string['nonbreaking:nonbreaking_desc'] = 'Vstavi nedeljivi presledek';
$string['pagebreak:desc'] = 'Vstavi prelom strani za tiskanje';
$string['paste:paste_text_desc'] = 'Prilepi kot golo besedilo';
$string['paste:paste_word_desc'] = 'Prilepi iz Word-a';
$string['paste:plaintext_mode'] = '\'Prilepi\' je sedaj v načinu golega besedila. Ponovno kliknite, da preklopite nazaj na običajni \'prilepi\' način. Potem ko boste izvedli lepljenje, se bodo nastavitve vrnile v običajen način za lepljenje.';
$string['paste:plaintext_mode_stick'] = '\'Prilepi\' je sedaj v načinu golega besedila. Ponovno kliknite, da preklopite nazaj na običajni \'prilepi\' način.';
$string['paste:selectall_desc'] = 'Izberi vse';
$string['paste_dlg:text_linebreaks'] = 'Obdrži prelome vrstic';
$string['paste_dlg:text_title'] = 'Uporabite kombinacijo tipk CTRL+V, da prilepite besedilo v okno.';
$string['paste_dlg:word_title'] = 'Uporabite kombinacijo tipk CTRL+V, da prilepite besedilo v okno.';
$string['pluginname'] = 'TinyMCE HTML urejevalnik';
$string['preview:preview_desc'] = 'Predogled';
$string['print:print_desc'] = 'Natisni';
$string['privacy:metadata'] = 'Vtičnik urejevalnik TinyMCE HTML ne shranjuje osebnih podatkov.';
$string['save:cancel_desc'] = 'Prekliči vse spremembe';
$string['save:save_desc'] = 'Shrani';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Najdi/zamenjaj';
$string['searchreplace:search_desc'] = 'Najdi';
$string['searchreplace_dlg:allreplaced'] = 'Vse pojavitve iskanega niza so bile zamenjane.';
$string['searchreplace_dlg:direction'] = 'Smer';
$string['searchreplace_dlg:down'] = 'navzdol';
$string['searchreplace_dlg:findnext'] = 'Najdi nasled.';
$string['searchreplace_dlg:findwhat'] = 'Išči';
$string['searchreplace_dlg:mcase'] = 'Razlikovanje velikih in malih črk';
$string['searchreplace_dlg:notfound'] = 'Iskanje zaključeno. Iskanega niza ni bilo mogoče najti.';
$string['searchreplace_dlg:replace'] = 'Zamenjaj';
$string['searchreplace_dlg:replace_title'] = 'Najdi/zamenjaj';
$string['searchreplace_dlg:replaceall'] = 'Zamenjaj vse';
$string['searchreplace_dlg:replacewith'] = 'Zamenjaj z';
$string['searchreplace_dlg:search_title'] = 'Najdi';
$string['searchreplace_dlg:searchnext_desc'] = 'Najdi znova';
$string['searchreplace_dlg:up'] = 'Gor';
$string['settings'] = 'Splošne nastavitve';
$string['simple:bold_desc'] = 'Krepko (Ctrl+B)';
$string['simple:bullist_desc'] = 'Vstavi/odstrani seznamske točke';
$string['simple:cleanup_desc'] = 'Prečisti kodo';
$string['simple:italic_desc'] = 'Ležeče (Ctrl+I)';
$string['simple:numlist_desc'] = 'Vstavi/odstrani seznam';
$string['simple:redo_desc'] = 'Uveljavi (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Prečrtano';
$string['simple:underline_desc'] = 'Podčrtano (Ctrl+U)';
$string['simple:undo_desc'] = 'Razveljavi (Ctrl+Z)';
$string['spellchecker:desc'] = 'Preklopi črkovalnik';
$string['spellchecker:ignore_word'] = 'Prezri besedo';
$string['spellchecker:ignore_words'] = 'Prezri vse';
$string['spellchecker:langs'] = 'Jeziki';
$string['spellchecker:learn_word'] = 'Zapomni si besedo';
$string['spellchecker:menu'] = 'Nastavitve črkovalnika';
$string['spellchecker:no_mpell'] = 'Napačnega črkovanja nisem našel.';
$string['spellchecker:no_sug'] = 'Ni predlogov';
$string['spellchecker:sug'] = 'Predlogi';
$string['spellchecker:wait'] = 'Počakajte ...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Uredi sloge CSS';
$string['style_dlg:apply'] = 'Uporabi';
$string['style_dlg:background'] = 'Ozadje';
$string['style_dlg:background_attachment'] = 'Priponka';
$string['style_dlg:background_color'] = 'Barva ozadja';
$string['style_dlg:background_hpos'] = 'Vodoravni položaj';
$string['style_dlg:background_image'] = 'Slika ozadja';
$string['style_dlg:background_repeat'] = 'Ponovi';
$string['style_dlg:background_tab'] = 'Ozadje';
$string['style_dlg:background_vpos'] = 'Navpični položaj';
$string['style_dlg:block'] = 'Blokiraj';
$string['style_dlg:block_display'] = 'Prikaži';
$string['style_dlg:block_letterspacing'] = 'Razmik znakov';
$string['style_dlg:block_tab'] = 'Blokiraj';
$string['style_dlg:block_text_align'] = 'Poravnava besedila';
$string['style_dlg:block_text_indent'] = 'Zamik besedila';
$string['style_dlg:block_vertical_alignment'] = 'Navpična poravnava';
$string['style_dlg:block_whitespace'] = 'Beli prostor';
$string['style_dlg:block_wordspacing'] = 'Razmik besed';
$string['style_dlg:border'] = 'Obroba';
$string['style_dlg:border_tab'] = 'Obroba';
$string['style_dlg:bottom'] = 'Spodaj';
$string['style_dlg:box'] = 'Polje';
$string['style_dlg:box_clear'] = 'Počisti';
$string['style_dlg:box_float'] = 'Plavajoče';
$string['style_dlg:box_height'] = 'Višina';
$string['style_dlg:box_tab'] = 'Polje';
$string['style_dlg:box_width'] = 'Širina';
$string['style_dlg:bullet_image'] = 'Slika seznamske točke';
$string['style_dlg:clip'] = 'Obreži';
$string['style_dlg:color'] = 'Barva';
$string['style_dlg:height'] = 'Višina';
$string['style_dlg:left'] = 'Levo';
$string['style_dlg:list'] = 'Seznam';
$string['style_dlg:list_tab'] = 'Seznam';
$string['style_dlg:list_type'] = 'Tip';
$string['style_dlg:margin'] = 'Rob';
$string['style_dlg:overflow'] = 'Prelivanje';
$string['style_dlg:padding'] = 'Podlaganje';
$string['style_dlg:placement'] = 'Položaj';
$string['style_dlg:position'] = 'Pozicija';
$string['style_dlg:positioning_tab'] = 'Položaj';
$string['style_dlg:positioning_type'] = 'Tip';
$string['style_dlg:right'] = 'Desno';
$string['style_dlg:same'] = 'Enako za vse';
$string['style_dlg:style'] = 'Slog';
$string['style_dlg:text'] = 'Besedilo';
$string['style_dlg:text_blink'] = 'Utripajoče';
$string['style_dlg:text_case'] = 'Velikost';
$string['style_dlg:text_color'] = 'Barva';
$string['style_dlg:text_decoration'] = 'Okras';
$string['style_dlg:text_font'] = 'Pisava';
$string['style_dlg:text_lineheight'] = 'Višina vrstice';
$string['style_dlg:text_none'] = 'Brez';
$string['style_dlg:text_overline'] = 'nadčrtano';
$string['style_dlg:text_props'] = 'Besedilo';
$string['style_dlg:text_size'] = 'Velikost';
$string['style_dlg:text_striketrough'] = 'prečrtano';
$string['style_dlg:text_style'] = 'Slog';
$string['style_dlg:text_tab'] = 'Besedilo';
$string['style_dlg:text_underline'] = 'Podčrtano';
$string['style_dlg:text_variant'] = 'Različica';
$string['style_dlg:text_weight'] = 'Utež';
$string['style_dlg:title'] = 'Uredi sloge CSS';
$string['style_dlg:toggle_insert_span'] = 'Vstavi razpon pri izbiri';
$string['style_dlg:top'] = 'Vrh';
$string['style_dlg:visibility'] = 'Vidnost';
$string['style_dlg:width'] = 'Širina';
$string['style_dlg:zindex'] = 'Indeks-Z';
$string['subplugintype_tinymce'] = 'Vtičnik';
$string['subplugintype_tinymce_plural'] = 'Vtičniki';
$string['table:cell'] = 'Celica';
$string['table:cell_desc'] = 'Lastnosti celice';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '100';
$string['table:col'] = 'Stolpec';
$string['table:col_after_desc'] = 'Vstavi stolpec pod';
$string['table:col_before_desc'] = 'Vstavi stolpec pred';
$string['table:copy_row_desc'] = 'Kopiraj vrstico';
$string['table:cut_row_desc'] = 'Izreži vrstico';
$string['table:del'] = 'Izbriši tabelo';
$string['table:delete_col_desc'] = 'Izbriši stolpec';
$string['table:delete_row_desc'] = 'Izbriši vrstico';
$string['table:desc'] = 'Vstavi/posodobi tabelo';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Spoji celice';
$string['table:paste_row_after_desc'] = 'Prilepi vrstico po';
$string['table:paste_row_before_desc'] = 'Prilepi vrstico pred';
$string['table:props_desc'] = 'Lastnosti tabele';
$string['table:row'] = 'Vrstica';
$string['table:row_after_desc'] = 'Vstavi vrstico pod';
$string['table:row_before_desc'] = 'Vstavi vrstico nad';
$string['table:row_desc'] = 'Lastnosti vrstice';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Razcepi celico';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Napredne lastnosti';
$string['table_dlg:advanced_tab'] = 'Napredno';
$string['table_dlg:align'] = 'Poravnava';
$string['table_dlg:align_bottom'] = 'Spodaj';
$string['table_dlg:align_default'] = 'Privzeto';
$string['table_dlg:align_left'] = 'Levo';
$string['table_dlg:align_middle'] = 'Sredina';
$string['table_dlg:align_right'] = 'Desno';
$string['table_dlg:align_top'] = 'Vrh';
$string['table_dlg:bgcolor'] = 'Barva ozadja';
$string['table_dlg:bgimage'] = 'Slika ozadja';
$string['table_dlg:border'] = 'Obroba';
$string['table_dlg:bordercolor'] = 'Barva obrobe';
$string['table_dlg:caption'] = 'Opis tabele';
$string['table_dlg:cell_all'] = 'Posodobi vse celice tabele';
$string['table_dlg:cell_cell'] = 'Posodobi trenutno celico';
$string['table_dlg:cell_col'] = 'Posodobi vse celice v stolpcu';
$string['table_dlg:cell_limit'] = 'Presegli ste dovoljeno število celic: {$cells}.';
$string['table_dlg:cell_row'] = 'Posodobi vse celice vrstice';
$string['table_dlg:cell_title'] = 'Lastnosti celice';
$string['table_dlg:cell_type'] = 'Tip celice';
$string['table_dlg:cellpadding'] = 'Podlaganje celic';
$string['table_dlg:cellspacing'] = 'Razmik celic';
$string['table_dlg:col_limit'] = 'Presegli ste dovoljeno število stolpcev: {$cols}.';
$string['table_dlg:colgroup'] = 'Skup. stolp.';
$string['table_dlg:cols'] = 'Stolpci';
$string['table_dlg:frame'] = 'Okvir';
$string['table_dlg:frame_all'] = 'vse';
$string['table_dlg:frame_cols'] = 'stolpci';
$string['table_dlg:frame_groups'] = 'skupine';
$string['table_dlg:frame_none'] = 'brez';
$string['table_dlg:frame_rows'] = 'vrstice';
$string['table_dlg:general_props'] = 'Splošne lastnosti';
$string['table_dlg:general_tab'] = 'Splošno';
$string['table_dlg:height'] = 'Višina';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Koda jezika';
$string['table_dlg:langdir'] = 'Smer jezika';
$string['table_dlg:ltr'] = 'Od leve proti desni';
$string['table_dlg:merge_cells_title'] = 'Spoji celice';
$string['table_dlg:mime'] = 'Ciljni tip MIME';
$string['table_dlg:missing_scope'] = 'Ste prepričani, da želite nadaljevati brez določenega dosega glave celice? Brez dosega je razumevanje tabele lahko oteženo ljudem s posebnimi potrebami!';
$string['table_dlg:row_all'] = 'Posodobi vse vrstice';
$string['table_dlg:row_even'] = 'Posodobi sode vrstice';
$string['table_dlg:row_limit'] = 'Presegli ste dovoljeno število vrstic: {$rows}.';
$string['table_dlg:row_odd'] = 'Posodobi lihe vrstice';
$string['table_dlg:row_row'] = 'Posodobi trenutno vrstico';
$string['table_dlg:row_title'] = 'Lastnosti vrstice';
$string['table_dlg:rowgroup'] = 'Skup. vrst.';
$string['table_dlg:rows'] = 'Vrstice';
$string['table_dlg:rowtype'] = 'Vrstica v tabeli';
$string['table_dlg:rtl'] = 'Od desne proti levi';
$string['table_dlg:rules'] = 'Pravila';
$string['table_dlg:rules_above'] = 'nad';
$string['table_dlg:rules_below'] = 'pod';
$string['table_dlg:rules_border'] = 'obroba';
$string['table_dlg:rules_box'] = 'polje';
$string['table_dlg:rules_hsides'] = 'v-strani';
$string['table_dlg:rules_lhs'] = 'l-strani';
$string['table_dlg:rules_rhs'] = 'd-strani';
$string['table_dlg:rules_void'] = 'prazno';
$string['table_dlg:rules_vsides'] = 'n-strani';
$string['table_dlg:scope'] = 'Doseg';
$string['table_dlg:style'] = 'Slog';
$string['table_dlg:summary'] = 'Povzetek';
$string['table_dlg:tbody'] = 'Telo tabele';
$string['table_dlg:td'] = 'Podatki';
$string['table_dlg:tfoot'] = 'Noga';
$string['table_dlg:th'] = 'Glava';
$string['table_dlg:thead'] = 'Glava';
$string['table_dlg:title'] = 'Vstavi/posodobi tabelo';
$string['table_dlg:valign'] = 'Navpična poravnava';
$string['table_dlg:width'] = 'Širina';
$string['template:desc'] = 'Vstavi pripravljeno vsebino predloge';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'nedelja,ponedeljek,torek,sreda,četrtek,petek,sobota,nedelja';
$string['template_dlg:day_short'] = 'ned,pon,tor,sre,čet,pet,sob,ned';
$string['template_dlg:desc'] = 'Vstavi pripravljeno vsebino predloge';
$string['template_dlg:desc_label'] = 'Opis';
$string['template_dlg:label'] = 'Predloga';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'januar,februar,marec,april,maj,junij,julij,avgust,september,oktober,november,december';
$string['template_dlg:months_short'] = 'jan,feb,mar,apr,maj,jun,jul,avg,sep,okt,nov,dec';
$string['template_dlg:preview'] = 'Predogled';
$string['template_dlg:select'] = 'Izberite predlogo';
$string['template_dlg:title'] = 'Predloge';
$string['template_dlg:warning'] = 'Opozorilo: Pri posodabljanju predloge lahko izgubite nekatere podatke.';
$string['visualblocks:desc'] = 'Prikaži/skrij elemente bloka';
$string['visualchars:desc'] = 'Preklopi prikaz nadzornih znakov.';
$string['wordcount:words'] = 'Besede:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Okrajšava';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Kratica';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Vstavi/uredi atribute';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citat';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Izbrisano';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Vstavljeno';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Atributi';
$string['xhtmlxtras_dlg:attribs_title'] = 'Vstavi/uredi atribute';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Atributi';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Dogodki';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Tipka dostopa';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Citat';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Razred';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Datum/čas';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Jezik';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Smer pisave';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Slog';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Zap. št.';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Naslov';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Od leve proti desni';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Od desne proti levi';
$string['xhtmlxtras_dlg:events_tab'] = 'Dogodki';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Atributi elementa';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Dogodki elementa';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Splošne nastavitve';
$string['xhtmlxtras_dlg:general_tab'] = 'Splošno';
$string['xhtmlxtras_dlg:insert_date'] = 'Vstavi trenutni datum/čas';
$string['xhtmlxtras_dlg:option_ltr'] = 'Od leve proti desni';
$string['xhtmlxtras_dlg:option_rtl'] = 'Od desne proti levi';
$string['xhtmlxtras_dlg:remove'] = 'Odstrani';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Okrajšava';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Kratica';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Citat';
$string['xhtmlxtras_dlg:title_del_element'] = 'Izbrisano';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Vstavljeno';
