<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'hu', version '4.1'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Elfogadás';
$string['accept_grades'] = 'Értékelések elfogadása az eszköztől';
$string['accept_grades_admin'] = 'Értékelések elfogadása az eszköztől';
$string['accept_grades_admin_help'] = 'Annak megadása, hogy az eszköz szolgáltatója az eszköz különböző példányainál hozzáadhat, frissíthet, beolvashat és törölhet-e értékeléseket.

Bizonyos szolgáltatók támogatják az eszközzel végzett tevékenységek során szerzett értékelések Moodle-ba való visszaírását, ily módon javítva az eszköz rendszerbe integrálását.';
$string['accept_grades_help'] = 'Annak megadása, hogy az eszköz szolgáltatója kizárólag az eszköz ezen példányánál adhat hozzá, frissíthet, olvashat be és törölhet értékeléseket.

Bizonyos szolgáltatók támogatják az eszközzel végzett tevékenységek során szerzett értékelések Moodle-ba való visszaírását, ily módon javítva az eszköz rendszerbe integrálását.

Ezt a beállítást az eszköz konfigurálása fölülírhatja.';
$string['accepted'] = 'Elfogadva';
$string['action'] = 'Lépés';
$string['activate'] = 'Bekapcsol';
$string['activatetoadddescription'] = 'Leírás hozzáadása előtt be kell kapcsolnia az eszközt.';
$string['active'] = 'Aktív';
$string['activity'] = 'Tevékenység';
$string['add_ltiadv'] = 'LTI Advantage hozzáadása';
$string['add_ltilegacy'] = 'Legacy LTI hozzáadása';
$string['addnewapp'] = 'Külső alkalmazás bekapcsolása';
$string['addserver'] = 'Új megbízható szerver hozzáadása';
$string['addtype'] = 'Előre beállított eszköz hozzáadása';
$string['allow'] = 'Engedélyez';
$string['allowsetting'] = 'Eszköz számára 8K beállítás Moodle-ban való tárolásának engedélyezése';
$string['always'] = 'Mindig';
$string['autoaddtype'] = 'Eszköz hozzáadása';
$string['automatic'] = 'Automatikus, az eszköz webcíme alapján';
$string['baseurl'] = 'Alapvető webcím/eszközregisztrációs név';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'LTI OAuth alapszöveg';
$string['basiclti_endpoint'] = 'LTI indítási végpontja';
$string['basiclti_in_new_window'] = 'Tevékenysége új ablakban nyílt meg.';
$string['basiclti_in_new_window_open'] = 'Megnyitás új ablakban';
$string['basiclti_parameters'] = 'LTI indítási paraméterei';
$string['basicltiactivities'] = 'LTI-tevékenységek';
$string['basicltifieldset'] = 'Egyéni példa mezőhalmaza';
$string['basicltiintro'] = 'Tevékenység-leírás';
$string['basicltiname'] = 'Tevékenység neve';
$string['basicltisettings'] = 'Alapvető LTI-beállítások';
$string['cachedef_keyset'] = 'Gyorsítótárba helyezi az eszközök kulcskészletére vonatkozó adatokat';
$string['cancel'] = 'Törlés';
$string['cancelled'] = 'Törölve';
$string['cannot_delete'] = 'Az eszköz beállításait nem törölheti.';
$string['cannot_edit'] = 'Az eszköz beállításait nem szerkesztheti.';
$string['capabilities'] = 'Lehetőségek';
$string['capabilities_help'] = 'Válassza ki az eszközt rendelkezésre bocsátónak felajánlani kívánt lehetőségeket. Több lehetőséget választhat.';
$string['capabilitiesrequired'] = 'Az eszköznek bekapcsoláshoz  az alábbi adatokat kell elérnie:';
$string['cleanaccesstokens'] = 'Külső eszköz lejárt hozzáférési tokenek eltávolítására';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Kattintson a folytatáshoz</a>';
$string['clientidadmin'] = 'Ügyfél-azonosító';
$string['clientidadmin_help'] = 'Az ügyfél-azonosító egyfajta egyedi érték egy eszköz azonosítására.
Automatikusan jön létre minden egyes LTI 1.3-ban bevezetett JWT biztonsági profilt használó eszközhöz, és részét képezi az eszköz szolgáltatójához továbbított adatoknak a csatlakozás részéről való beállításához.';
$string['comment'] = 'Megjegyzés';
$string['configpassword'] = 'Távoli eszköz alapértelmezett jelszava';
$string['configpreferheight'] = 'Alapértelmezett egyéni magasság';
$string['configpreferwidget'] = 'Segédeszköz beállítása alapértelmezett indításként';
$string['configpreferwidth'] = 'Alapértelmezett egyéni szélesség';
$string['configresourceurl'] = 'Alapértelmezett tananyag-URL';
$string['configtoolurl'] = 'Alapértelmezett távoli eszközhöz tartozó webcím';
$string['configtypes'] = 'LTI-alkalmazások bekapcsolása';
$string['configured'] = 'Beállítva';
$string['confirmtoolactivation'] = 'Biztosan bekapcsolja az eszközt?';
$string['contentitem'] = 'Tartalmi tételhez kapcsolódó üzenet';
$string['contentitem_deeplinking'] = 'Támogatja a Deep Linkinget [mélységi kapcsolást] (Tartalomelemhez kapcsolódó üzenet)';
$string['contentitem_deeplinking_help'] = 'Bejelölése esetén a \'Tartalom kiválasztása\' elérhető lesz külső eszköz hozzáadása esetén';
$string['contentitem_help'] = 'Bejelölése esetén a \'Tartalom kiválasztása\' elérhető lesz külső eszköz hozzáadása esetén';
$string['contentitem_multiple_description'] = 'Kurzusa az alábbi elemekkel bővül:';
$string['contentitem_multiple_graded'] = 'Értékelt tevékenység (Legjobb értékelés: {$a})';
$string['course_tool_types'] = 'Kurzuseszközök';
$string['courseactivitiesorresources'] = 'Kurzustevékenységek vagy tananyagok';
$string['courseid'] = 'Kurzus azonosítószáma';
$string['courseinformation'] = 'Kurzusadatok';
$string['courselink'] = 'Áttérés a kurzusra';
$string['coursemisconf'] = 'A kurzus beállítása hibás';
$string['createdon'] = 'Létrehozás dátuma';
$string['curllibrarymissing'] = 'A külső eszköz használatához telepíteni kell a PHP cURL bővítményt.';
$string['custom'] = 'Egyedi paraméterek';
$string['custom_config'] = 'Egyedi eszközbeállítás használata';
$string['custom_help'] = 'Az egyéni paraméterek az eszközt rendelkezésre bocsátó által használt beállítások. Egyéni paraméterekkel lehet pl. a tőle származó konkrét tananyagot megjeleníteni. Az egyes paramétereket soronként kell "név=érték" formában megadni, pl.: "fejezet=3".

Ellenkező értelmű utasítás hiányában célszerű a mezőt változatlanul hagyni.';
$string['custominstr'] = 'Egyéni paraméterek';
$string['debuglaunch'] = 'Hibakeresési lehetőség';
$string['debuglaunchoff'] = 'Szokásos indítás';
$string['debuglaunchon'] = 'Hibakeresés indítása';
$string['default'] = 'Alapértelmezett';
$string['default_launch_container'] = 'Alapértelmezett indítási tároló';
$string['default_launch_container_help'] = 'Az indítási tároló befolyásolja az eszköz megjelenítését kurzusból való indítása esetén. Egyes indítási tárolók nagyobb képernyőterületet használnak, mások esetén inkább a Moodle-lal való integráltság kerül előtérbe.

* **Alapértelmezett** - Az eszközbeállítás szerinti indítási tároló használata.
* **Beágyazás** - Az eszköz a legtöbb tevékenységtípushoz hasonlóan a meglévő Moodle-ablakban jelenik meg.
* **Beágyazás blokkok nélkül** - Az eszköz csak az oldal tetején a navigációs eszközökkel, a meglévő Moodle-ablakban jelenik meg.
* **Új ablak** - Az eszköz új ablakban jelenik meg, elfoglalva az összes rendelkezésre álló területet.
A böngészőtől függően egy új fület vagy egy előugró ablakot nyit meg.
Előfordulhat, hogy a böngésző megakadályozza új ablak megnyitását.';
$string['delegate'] = 'Tanárhoz irányítás';
$string['delegate_tool'] = 'A  Deep Linkingben [mélységi kapcsolásban] megadottak szerint, vagy Átadás a tanárnak';
$string['delete'] = 'Törlés';
$string['delete_confirmation'] = 'Biztosan törölni kívánja az előre beállított eszközt?';
$string['deletetype'] = 'Előre beállított  eszköz törlése';
$string['display_description'] = 'Indításkor a tevékenység leírásának megjelenítése';
$string['display_description_help'] = 'Kiválasztása esetén a (fent megadott) tevékenység leírása az eszközt biztosító tartalma fölött jelenik meg.

A leírás választhatóan további utasításokat tartalmazhat az eszközt elindítók számára.

A leírás nem jelenik meg, ha az eszközt indítási tárolója új ablakban jelenik meg.';
$string['display_name'] = 'A tevékenység nevének megjelenítése indításkor';
$string['display_name_help'] = 'Kiválasztása esetén a (fent megadott) tevékenység leírása az eszközt biztosító tartalma fölött jelenik meg.

A címet ő is megjelenítheti. Ezzel előzhető meg a cím kétszeri kijelzése.

A leírás nem jelenik meg, ha az eszközt indítási tárolója új ablakban jelenik meg.';
$string['domain_mismatch'] = 'Az eszköz URL doménje nem egyezik az eszköz beállításával.';
$string['donot'] = 'Ne küldje el';
$string['donotaccept'] = 'Ne fogadja el';
$string['donotallow'] = 'Ne engedélyezze';
$string['duplicateregurl'] = 'Ezt a regisztrációs webcímet  már használják.';
$string['dynreg_update_btn_new'] = 'Új külső eszközként regisztrálás';
$string['dynreg_update_btn_update'] = 'Frissítés';
$string['dynreg_update_name'] = 'Eszköz neve';
$string['dynreg_update_notools'] = 'Nincs eszköz a környezetben';
$string['dynreg_update_text'] = 'Vannak a doménhez regisztrált külső eszközök. Frissít egy meglévőt vagy létrehoz egy újat?';
$string['dynreg_update_url'] = 'Alapvető webcím';
$string['dynreg_update_version'] = 'LTI verziója';
$string['dynreg_update_warn_dupdomain'] = 'Egy doménen belül nem tanácsos több külső eszkőzt fenntartani.';
$string['editdescription'] = 'Az eszközről ide kattintva adhat leírást.';
$string['edittype'] = 'Előre beállított eszköz szerkesztése';
$string['embed'] = 'Beágyazás';
$string['embed_no_blocks'] = 'Beágyazás blokkok nélkül';
$string['enableemailnotification'] = 'Értesítések küldése';
$string['enableemailnotification_help'] = 'Bekapcsolása esetén a tanulók e-mailben értesítést kapnak az eszközzel kapcsolatos leadott munkáik értékeléséről';
$string['enterkeyandsecret'] = 'Adja meg fogyasztói kulcsát és a megosztott titkos jelet.';
$string['enterkeyandsecret_help'] = 'Ha kapott fogyasztói kulcsot és/vagy megosztott titkos jelet, írja be ide';
$string['errorbadurl'] = 'A webcím nem egy érvényes eszköz vagy kazetta webcíme.';
$string['errorincorrectconsumerkey'] = 'A fogyasztói kulcs hibás.';
$string['errorinvaliddata'] = 'Érvénytelen adat: {$a}';
$string['errorinvalidmediatype'] = 'Érvénytelen médiatípus: {$a}';
$string['errorinvalidresponseformat'] = 'Érvénytelen tartalmi tételhez kapcsolódó  válaszformátum.';
$string['errormisconfig'] = 'Hibás eszközbeállítás. Kérje meg a Moodle-rendszergazdát, hogy javítsa ki.';
$string['errortooltypenotfound'] = 'Az LTI eszköztípus nem található.';
$string['existing_window'] = 'Létező ablak';
$string['extensions'] = 'LTI-bővítményszolgáltatások';
$string['external_tool_type'] = 'Előre beállított eszköz';
$string['external_tool_type_help'] = '* **Automatikus, az eszköz webcímén alapuló** - A legjobb eszközbeállítás kiválasztása automatikus. Ha a Moodle nem ismeri fel az eszköz webcímét, akkor az eszközbeállítást kézzel kell elvégezni.
* **Adott előre beállított eszköz** - Az adott eszköz beállítását használja a külső eszköz szolgáltatójával való kommunikáció során. Ha az eszköz webcíme nem az eszköz szolgáltatójáé, figyelmeztetés jelenik meg. Egyes esetekben nem szükséges az eszköz webcímét megadni.
* **Egyedi beállítás** - Előfordulhat, hogy kézzel kell megadnia a fogyasztókulcsot és a megosztott titkos jelet. Ha nem rendelkezik ezekkel, kérhet egyet az eszköz szolgáltatójától. Nem minden eszköz igényel fogyasztókulcsot és megosztott titkos jelet. Ez esetben a mezőket üresen hagyhatja.

### Előre beállított eszköz szerkesztése

Az előre beállított eszköz lenyíló listája után három ikon érhető el:

* **Hozzáadás** - Kurzusszintű eszközbeállítás létrehozása. A kurzusban előforduló összes külső eszköz használhatja az eszközbeállítást.
* **Szerkesztés** - A lenyíló listáról válasszon ki egy kurzusszintű eszköztípust, majd kattintson az ikonra. Az eszközbeállítás részleteit szerkesztheti.
* **Törlés** - Törli a kiválasztott kurzusszintű eszköztípust.';
$string['external_tool_types'] = 'Előre beállított eszközök';
$string['failedtoconnect'] = 'A Moodle nem tudott kapcsolatot teremteni a(z) "{$a}" rendszerrel.';
$string['failedtocreatetooltype'] = 'Nem sikerült új eszközt létrehozni. Ellenőrizze a webcímet és próbálja meg újra.';
$string['failedtodeletetoolproxy'] = 'Nem sikerült az eszköz bejegyzését törölni. Látogasson el a "Külső eszközök bejegyzéseinek kezelése" pontra és törölje kézi úton.';
$string['filter_basiclti_configlink'] = 'Állítsa be kedvenc portáljait és azok jelszavait.';
$string['filter_basiclti_password'] = 'Jelszó megadása kötelező';
$string['filterconfig'] = 'LTI-adminisztráció';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'A hibás beállítás helyett használjon egy létezőt.';
$string['fixnew'] = 'Új beállítás';
$string['fixnewconf'] = 'A hibás beállítás helyett adjon meg egy újat.';
$string['fixold'] = 'Létező használata';
$string['force_ssl'] = 'SSL előírása';
$string['force_ssl_help'] = 'Kiválasztása esetén az ezen eszközszolgáltatóhoz érkező kezdeményezésekkel SSL-t kell használni.

Emellett az eszközszolgáltatótól érkező minden webszolgáltatási kérelem is SSL-t fog használni.

Használata esetén győződjön meg arrólk, hogy mind a Moodle, mind az eszközszolgáltató támogatja az SSL-t.';
$string['forced_help'] = 'Ezt a beállítást egy kurzus- vagy portálszintű eszköz beállítása írja elő.';
$string['generaltool'] = 'Általános eszköz';
$string['global_tool_types'] = 'Előre beállított eszközök';
$string['grading'] = 'Értékelés útvonala';
$string['icon_url'] = 'Ikonos URL';
$string['icon_url_help'] = 'Ikonos URL esetén a tevékenységhez tartozó kurzuslistában az ikon módosítható. Alapbeállítás szerinti LTI-ikon helyett megadhat egy olyat, amely utal a tevékenység típusára.';
$string['id'] = 'Azonosító';
$string['indicator:cognitivedepth'] = 'Kognitív LTI';
$string['indicator:cognitivedepth_help'] = 'Ez a jelző a tanuló által az LTI-tevékenység kapcsán elért kognitív mélységen alapul.';
$string['indicator:cognitivedepthdef'] = 'Kognitív LTI';
$string['indicator:cognitivedepthdef_help'] = 'A résztvevő az elemzési időszak alatt az LTI tevékenységei során kognitív elfoglaltság terén ezt a százalékot érte el (Szintek - Nincs megtekintés, Megtekintés, Leadás, Visszajelzés megtekintése)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Társas LTI';
$string['indicator:socialbreadth_help'] = 'Ez a jelző a tanuló által az LTI-tevékenység kapcsán elért társas lefedettségen alapul.';
$string['indicator:socialbreadthdef'] = 'Társas LTI';
$string['indicator:socialbreadthdef_help'] = 'A résztvevő az elemzési időszak alatt az LTI tevékenységei során társas elfoglaltság terén ezt a százalékot érte el (Szintek - Nincs részvétel, Egyedüli részvétel, Másokkal együtt való részvétel)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['initiatelogin'] = 'Bejelentkezési webcím inicializálása';
$string['initiatelogin_help'] = 'Az eszköz azon webcíme, amelyre a bejelentkezés inicializálásának kérelmeit küldik. Erre a webcímre van szükség egy üzenet eszköz részére való elküldéséhez.';
$string['invalidid'] = 'Hibás LTI-azonosító';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'A nyilvános kulcs típusa';
$string['keytype_help'] = 'Az eszköz hitelesítésére használt módszer.';
$string['keytype_keyset'] = 'A kulcskészlet webcíme';
$string['keytype_rsa'] = 'RSA-kulcs';
$string['launch_in_moodle'] = 'Eszköz indítása a Moddle-ban';
$string['launch_in_popup'] = 'Eszköz indítása előugró ablakban';
$string['launch_url'] = 'Eszköz webcíme';
$string['launch_url_help'] = 'Az eszköz webcíme a külső eszköz webcíme, mely egyéb információkat is tartalmazhat, pl. a megjelenítendő tananyagot. Ha nem tudja pontosan, hogyan kell megadni az eszköz webcímét, forduljon az eszközszolgáltatóhoz.

Megadhat egy kazettás webcímet is, ha van, mely esetben az űrlap többi adata automatikusan kitöltődik.

Ha kiválasztott egy konkrét előre beállított eszközt, előfordulhat, hogy nem kell megadnia az eszköz webcímét. Ilyen fordulhat elő például, ha az eszköz hivatkozása csak az eszközszolgáltató rendszerébe való bekapcsolódáshoz szükséges, de nem egy konkrét tananyag eléréséhez.';
$string['launchinpopup'] = 'Tároló indítása';
$string['launchinpopup_help'] = 'Az indítási tároló befolyásolja az eszköz kurzusból való indításakori megjelenését. Egyes indítási tárolók több területet engedélyeznek az eszköz számára, míg mások jobban egybeépülnek a Moodle környezetével.
* **Alapbeállítás** - Az eszköz beállítása szerinti indítási tároló használata.
* **Beágyazás** - Az eszköz a meglévő Moodle-ablakban jelenik meg a többi tevékenységtípus többségéhez hasonlóan.
* **Beágyazás blokkok nélkül** - Az eszköz a meglévő Moodle-ablakban jelenik meg, az oldal tetején a csak a navigációs kezelőszervekkel.
* **Új ablak** - Az eszköz egy új ablakban jelenik meg, a rendelkezésre álló területet elfoglalva.
   A böngészőtől függően új fülön vagy előbukkanó ablakban jelenik meg.
   Elképzelhető, hogy a böngésző nem engedélyezi az új ablak megnyitását.';
$string['launchoptions'] = 'Indítási lehetőségek';
$string['leaveblank'] = 'Ha nincs rájuk szüksége, hagyja üresen.';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Kurzushoz tartozó eszközbeállítások hozzáadása';
$string['lti:addinstance'] = 'Új külső eszköz hozzáadása';
$string['lti:addmanualinstance'] = 'Kézzel beállított eszköz hozzáadása';
$string['lti:addpreconfiguredinstance'] = 'Előre beállított eszköz hozzáadása';
$string['lti:admin'] = 'Az eszköz indításakor legyen rendszergazda';
$string['lti:grade'] = 'Külső eszköztől kapott értékelések megtekintése';
$string['lti:manage'] = 'Legyen oktató az eszköz indítása esetén';
$string['lti:requesttooladd'] = 'Eszköz portálszintű beállításának kérése';
$string['lti:view'] = 'Külső eszköztevékenységek indítása';
$string['lti_administration'] = 'Előre beállított eszköz szerkesztése';
$string['lti_errormsg'] = 'Az eszköztől a következő hibaüzenet érkezett: "{$a}"';
$string['lti_launch_error'] = 'Hiba a külső eszköz indítása közben';
$string['lti_launch_error_tool_request'] = 'Ha egy rendszergazdától szeretné kérni az eszköz beállítását, kattintson a(z) <a href="{$a->admin_request_url}" target="_top">here</a>.pontra.';
$string['lti_launch_error_unsigned_help'] = 'Ezt a hibát előidézheti egy hiányzó vásárlói kulcs és az eszközszolgáltatóhoz kapcsolódó megosztott kód.
Ha rendelkezik vásárlói kulccsal és az eszközszolgáltatóhoz kapcsolódó megosztott kóddal, megadhatja őket a külső eszközpéldány szerkesztése közben  (a részletes lehetőségek látsszanak!).</p>
<p>Vagy pedig <a href="{$a->course_tool_editor}">hozzon létre egy kurzusszintű eszközszolgáltatói beállítást</a>.</p>.';
$string['lti_tool_request_added'] = 'Az eszköz-beállítási kérelem leadása sikerült. Előfordulhat, hogy a beállítás elvégzéséhez rendszergazdához kell fordulnia.';
$string['lti_tool_request_existing'] = 'Az eszköz tartományához más adtak le eszközbeállítást.';
$string['ltisettings'] = 'LTI-beállítások';
$string['ltiunknownserviceapicall'] = 'Ismeretlen LTI-szolgáltatás meghívása.';
$string['ltiversion'] = 'LTI-verzió';
$string['ltiversion_help'] = 'Az LTI üzenetek és szolgáltatási kérelmek aláírására használt verziója: az LTI 1.0/1.1 és az LTI 2.0 OAuth 1.0A biztonsági profilt használ, míg az LTI 1.3.0 JWT-ket.';
$string['main_admin'] = 'Általános súgó';
$string['main_admin_help'] = 'Külső eszközökkel a Moodle felhasználói gond nélkül kapcsolódhatnak távoli gépeken lévő tananyagokhoz. Egy speciális indítási protokollnak köszönhetően a távoli eszköz általános adatokhoz jut a kapcsolatot kezdeményező felhasználóról. Ilyen például az intézmény neve, a kurzus-azonosító, a felhasználó azonosítója, neve vagy e-mail-címe.
Az oldalon felsorolt eszközök három csoportra különülnek el:

* **Aktív** - Ezeket az eszközszolgáltatókat rendszergazda hagyta jóvá és állította be. A portálon bármely kurzusban használhatók. Ha fogyasztókulcsot és megosztott titkos jelet ad meg, megbízhatónak feltételezett kapcsolat létesül a portál és a távoli eszköz között, ami biztonságos kommunikációs csatornát nyit meg.
* **Függő** - Ezek az eszközszolgáltatók csomagimportálás révén kerültek be, de rendszergazda általi beállításukra még nem került sor. Ettől függetlenül az oktatók használhatják ezeket az eszközöket, ha rendelkeznek fogyasztókulccsal és megosztott titkos jellel, illetve ha ezek egyike sincs előírva.
* **Elutasított** - Ezeket az eszközszolgáltatókat egy rendszergazda a portál számára nem kívánja hozzáférhetővé tenni. Ettől függetlenül az oktatók használhatják ezeket az eszközöket, ha rendelkeznek fogyasztókulccsal és megosztott titkos jellel, illetve ha ezek egyike sincs előírva.';
$string['manage_external_tools'] = 'Eszközök kezelése';
$string['manage_tool_proxies'] = 'Külső eszközregisztrációk kezelése';
$string['manage_tools'] = 'Előre beállított eszközök kezelése';
$string['manuallyaddtype'] = 'Vagy <a href="{$a}">kézzel is beállíthat egy eszközt</a>.';
$string['miscellaneous'] = 'Egyéb';
$string['misconfiguredtools'] = 'Hibásan beállított eszközpéldányok fordulnak elő.';
$string['missingparameterserror'] = 'Hibásan beállított oldal: "{$a}"';
$string['module_class_type'] = 'A Moodle modultípusa';
$string['modulename'] = 'Külső eszköz';
$string['modulename_help'] = 'A Külső eszköz tevékenységmodul lehetővé teszi, hogy a tanulók más webhelyeken található tananyagokkal és tevékenységekkel is foglalkozzanak. Például egy külső eszköz hozzáférést biztosíthat egy másik kiadó új típusú tevékenységéhez vagy tananyagaihoz.

Külső eszköz tevékenység létrehozásához olyan eszközszolgáltatóra van szükség, amely támogatja az LTI (Learning Tools Interoperability) szabványt. Egy tanár létrehozhat saját külső eszköz tevékenységet, vagy használhatja a portálszintű rendszergazda által beállított eszközt.

A külső eszközök tevékenységek több szempontból is eltérnek az egyszerű URL erőforrásoktól:

* A külső eszközök ismerik a környezetet, vagyis hozzáférnek a felhasználóra vonatkozó információkhoz, például az intézmény, a kurzus és a név adataihoz.
* A külső eszközök támogatják az adott tevékenységhez kapcsolódó értékelések olvasását, frissítését és törlését.
* A külső eszköz konfigurációi bizalmi kapcsolatot hoznak létre az Ön portálja és az eszközszolgáltató között, ami biztonságos kommunikációt tesz lehetővé a két fél között.';
$string['modulename_link'] = 'mod/lti/view';
$string['modulenameplural'] = 'Külső eszközök';
$string['modulenamepluralformatted'] = 'LTI-példányok';
$string['name'] = 'Név';
$string['never'] = 'Soha';
$string['new_window'] = 'Új ablak';
$string['no_lti_configured'] = 'Nincs beállítva külső eszköz';
$string['no_lti_pending'] = 'Nincs beállításra váró külső eszköz';
$string['no_lti_rejected'] = 'Nincs elutasított külső eszköz';
$string['no_lti_tools'] = 'Nincs külső eszköz beállítva.';
$string['no_tp_accepted'] = 'Nincs elfogadott külső eszközregisztráció.';
$string['no_tp_cancelled'] = 'Nincs törölt külső eszközregisztráció.';
$string['no_tp_configured'] = 'Nincs beállítva nem regisztrált külső eszközregisztráció.';
$string['no_tp_pending'] = 'Nincs várakozó külső eszközregisztráció.';
$string['no_tp_rejected'] = 'Nincs elutasított külső eszközregisztráció.';
$string['noattempts'] = 'Ezen eszközpéldányon nem történt próbálkozás';
$string['noltis'] = 'Nincsenek külső eszközpéldányok';
$string['noprofileservice'] = 'Nincs profilszolgáltatás';
$string['noservers'] = 'Nincs szerver';
$string['notypes'] = 'Jelenleg a Moodle-ban nincs beállítva LTI-eszköz. Hozzáadáshoz kattintson a Telepítés pontra.';
$string['noviewusers'] = 'Nincs az eszköz használatára jogosult felhasználó.';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'Az LTI 1.3-hoz érvényes openssl.cnf-et kell beállítani és a webszerver számára elérhetővé tenni. A beállításért forduljon a portál rendszergazdájához.';
$string['optionalsettings'] = 'Választható beállítások';
$string['organization'] = 'Szervezet adatai';
$string['organizationdescr'] = 'Szervezet leírása';
$string['organizationid_default'] = 'Alapvető szervezet azonosítója';
$string['organizationid_default_help'] = 'Szervezet azonosítójaként használandó érték. A portálazonosító a Moodle adott telepítését azonosítja.';
$string['organizationidguid'] = 'Szervezet azonosítója';
$string['organizationidguid_help'] = 'A Moodle telepítésének egyedi azonosítója, melyet az eszköz a platform-előfordulás GUID-jaként kap meg.';
$string['organizationurl'] = 'Szervezet webcíme';
$string['organizationurl_help'] = 'A Moodle adott példányának alapvető webcíme.

Ha a mező üresen marad, a portál beállítása szerinti érték lesz az alapbeállítás.';
$string['pagesize'] = 'Leadott munkák száma oldalanként';
$string['parameter'] = 'Eszközparaméterek';
$string['parameter_help'] = 'Az eszközparaméterek az eszközt rendelkezésre bocsátó által az elfogadott eszközproxi által továbbítani kért beállítások';
$string['password'] = 'Megosztott titkos jel';
$string['password_admin'] = 'Megosztott titkos jel';
$string['password_admin_help'] = 'A megosztott titkos jel egyfajta jelszó az eszköz eléréséhez. Az eszközszolgáltatótól kapott fogyasztói kulccsal együtt kell megadni.

Előfordulhat, hogy a Moodle részéről biztonságos kommunikációt elő nem író és kiegészítő szolgáltatásokat (pl. értékelések lejelentése) nem kínáló eszközök nem írják elő megosztott titkos jel használatát.';
$string['password_help'] = 'Előre beállított eszközök esetén itt nem szükséges megosztott titkos jelet megadni, mivel a megosztott titkos jel megadására a beállítás közben kerül sor.

Ezt a mezőt egy még be nem állított eszközszolgáltatóhoz való kapcsolat létrehozásához kell kitölteni.
Ha az eszközszolgáltatót a kurzus során többször igénybe veszi, akkor kapóra jöhet egy kurzuseszköz-beállítás.

A megosztott titkos jel egyfajta jelszó az eszköz eléréséhez. Az eszközszolgáltatótól kapott fogyasztói kulccsal együtt kell megadni.

Előfordulhat, hogy a Moodle részéről biztonságos kommunikációt elő nem író és kiegészítő szolgáltatásokat (pl. értékelések lejelentése) nem kínáló eszközök nem írják elő megosztott titkos jel használatát.';
$string['pending'] = 'Függőben';
$string['pluginadministration'] = 'Külső eszköz adminisztrációja';
$string['pluginname'] = 'Külső eszköz';
$string['preferheight'] = 'Választott magasság';
$string['preferwidget'] = 'Választott eszközindítás';
$string['preferwidth'] = 'Választott szélesség';
$string['press_to_submit'] = 'Nyomja le a tevékenység elindításához';
$string['privacy'] = 'Magántitok';
$string['privacy:metadata:coursefullname'] = 'Az LTI Consumerből elért kurzus teljes neve';
$string['privacy:metadata:courseid'] = 'Az LTI Consumerből elért kurzus azonosítója';
$string['privacy:metadata:courseidnumber'] = 'Az LTI Consumerből elért kurzus azonosítószáma';
$string['privacy:metadata:courseshortname'] = 'Az LTI Consumerből elért kurzus rövid neve';
$string['privacy:metadata:createdby'] = 'A rekordot létrehozó felhasználó';
$string['privacy:metadata:email'] = 'Az LTI Consumerbe belépő felhasználó e-mail-címe';
$string['privacy:metadata:externalpurpose'] = 'Az LTI Consumer felhasználói adatokat és környezetet ad át az LTI-szolgáltatónak.';
$string['privacy:metadata:firstname'] = 'Az LTI Consumerbe belépő felhasználó keresztneve';
$string['privacy:metadata:fullname'] = 'Az LTI Consumerbe belépő felhasználó teljes neve';
$string['privacy:metadata:lastname'] = 'Az LTI Consumerbe belépő felhasználó vezetékneve';
$string['privacy:metadata:lti_submission'] = 'LTI-hez kapcsolódó leadott munka';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'A leadott munka időbélyegzője';
$string['privacy:metadata:lti_submission:dateupdated'] = 'A leadott munka módosításának az időbélyegzője';
$string['privacy:metadata:lti_submission:gradepercent'] = 'A felhasználó értékelése százalékban';
$string['privacy:metadata:lti_submission:originalgrade'] = 'A felhasználó eredeti értékelése';
$string['privacy:metadata:lti_submission:userid'] = 'Az LTI-tevékenységhez munkát leadó felhasználó azonosítója';
$string['privacy:metadata:lti_tool_proxies'] = 'LTI-proxyk';
$string['privacy:metadata:lti_tool_proxies:name'] = 'Az LTI-proxy neve';
$string['privacy:metadata:lti_types'] = 'LTI-típusok';
$string['privacy:metadata:lti_types:name'] = 'Az LTI-típus neve';
$string['privacy:metadata:role'] = 'Az LTI Consumerbe belépő felhasználó kurzusban betöltött szerepe';
$string['privacy:metadata:timecreated'] = 'A rekord létrehozásának dátuma';
$string['privacy:metadata:timemodified'] = 'A rekord módosításának dátuma';
$string['privacy:metadata:userid'] = 'Az LTI Consumerbe belépő felhasználó azonosítója';
$string['privacy:metadata:useridnumber'] = 'Az LTI Consumerbe belépő felhasználó azonosítószáma';
$string['privacy:metadata:username'] = 'Az LTI Consumerbe belépő felhasználó felhasználóneve';
$string['publickey'] = 'Nyilvános kulcs';
$string['publickey_help'] = 'Az eszköz által bejövő üzenetek és szolgáltatási kérelmek aláírásának ellenőrzésére használt nyilvános kulcs (PEM-formában).';
$string['publickeyset'] = 'Nyilvános kulcskészlet';
$string['publickeyset_help'] = 'Az a nyilvános kulcskészlet, amelyből a Moodle a bejövő üzenetek aláírásához és a szolgáltatáskérés ellenőrzéséhez kinyeri az eszköz nyilvános kulcsát.';
$string['quickgrade'] = 'Gyors értékelés engedélyezése';
$string['quickgrade_help'] = 'Bekapcsolása esetén több eszköz értékelhető egyetlen oldalon. Adja meg az értékeléseket és fűzzön hozzájuk megjegyzéseket, majd az összes módosítás mentéséhez kattintson az "Összes visszajelzés mentése" pontra.';
$string['redirect'] = 'Átirányítása másodperceken belül megtörténik. Ha mégsem, nyomja meg a gombot.';
$string['redirectionuris'] = 'Átirányítási URI(-k)';
$string['redirectionuris_help'] = 'URI-k (soronként egy) felsorolása, melyeket az eszköz hitelesítési kérelmekhez használ. Legalább egyet rögzíteni kell egy üzenet eszköz részére való elküldéséhez.';
$string['register'] = 'Nyilvántartás';
$string['register_warning'] = 'A  regisztrációs oldal megnyitása eltart egy ideig. Ha nem jelenik meg, ellenőrizze, helyes webcímet adott-e meg a beállítások között. Ha a Moodle https-t használ, ügyeljen rá, hogy a beállítandó eszköz támogassa a https használatát, és a webcímben https-t adjon meg .';
$string['registertype'] = 'Új külső eszközregisztráció beállítása';
$string['registration_options'] = 'Regisztrációs lehetőségek';
$string['registrationname'] = 'Az eszközszolgáltató neve';
$string['registrationname_help'] = 'Adja meg a regisztrálandó eszközt rendelkezésre bocsátó nevét.';
$string['registrationurl'] = 'Regisztrációs URL';
$string['registrationurl_help'] = 'A regisztrációs webcímet az eszközt rendelkezésre bocsátó szolgáltatja azon a helyen, ahová a regisztrációs kérelmet küldeni kell.';
$string['reject'] = 'Elutasítás';
$string['rejected'] = 'Elutasítva';
$string['resource'] = 'Tananyag';
$string['resourcekey'] = 'Fogyasztókulcs';
$string['resourcekey_admin'] = 'Fogyasztókulcs';
$string['resourcekey_admin_help'] = 'A fogyasztói kulcs egyfajta felhasználónév az eszköz eléréséhez. Az eszközszolgáltatót azon Moodle-portál egyedi azonosítására használja, amelyről a felhasználók elindították az eszközt.

A fogyasztói kulcsot az eszközszolgáltató adja meg, annak módja eszközszolgáltatónként változik. Lehet automatikus folyamat, és lehet az eszközszolgáltatóval folytatott párbeszéd eredménye.

Előfordulhat, hogy a Moodle részéről biztonságos kommunikációt elő nem író és kiegészítő szolgáltatásokat (pl. értékelések lejelentése) nem kínáló eszközök nem írják elő megosztott titkos jel használatát.';
$string['resourcekey_help'] = 'Előre beállított eszközök esetén itt nem szükséges tananyagkulcsot megadni, mivel a fogyasztói kulcs megadására a beállítás közben kerül sor.

Ezt a mezőt egy még be nem állított eszközszolgáltatóhoz való kapcsolat létrehozásához kell kitölteni.
Ha az eszközszolgáltatót a kurzus során többször igénybe veszi, akkor kapóra jöhet egy kurzuseszköz-beállítás.

A fogyasztói kulcs egyfajta felhasználónév az eszköz eléréséhez. Az eszközszolgáltatót azon Moodle-portál egyedi azonosítására használja, amelyről a felhasználók elindították az eszközt.

A fogyasztói kulcsot az eszközszolgáltató adja meg;annak módja eszközszolgáltatónként változik. Lehet automatikus folyamat, és lehet az eszközszolgáltatóval folytatott párbeszéd eredménye.

Előfordulhat, hogy a Moodle részéről biztonságos kommunikációt elő nem író és kiegészítő szolgáltatásokat (pl. értékelések lejelentése) nem kínáló eszközök nem írják elő megosztott titkos jel használatát.';
$string['resourceurl'] = 'Tananyag webcíme';
$string['return_to_course'] = 'A kurzushoz való visszatéréshez kattintson ide: <a href="{$a->link}" target="_top">here</a>.';
$string['saveallfeedback'] = 'Minden visszajelzésem elmentése';
$string['search:activity'] = 'Külső eszköz tevékenységei';
$string['secure_icon_url'] = 'Biztonságos ikonwebcím';
$string['secure_icon_url_help'] = 'Hasonló az ikonos webcímhez, de csak akkor használatos, amikor a felhasználó a Moodle-t biztonságos SSL-en keresztül éri el. A mező célja annak megelőzése, hogy a böngésző figyelmeztesse a felhasználót, ha nem biztonságos képet kíván megjeleníteni.';
$string['secure_launch_url'] = 'Eszköz biztonságos webcíme';
$string['secure_launch_url_help'] = 'Hasonló az eszköz webcíméhez, csak akkor használatos, amikor biztonságos elérésre van szükség. A Moodle az eszköz biztonságos webcímét választja, ha a portált SSL-en keresztül érik el, vagy ha az eszköz beállítása mindenkor SSL-t ír elő.

Az eszköz webcímét https címhez beállítva előírható az SSL-en keresztüli indítás, a mező pedig üresen maradhat.';
$string['selectcontent'] = 'Tartalom kiválasztása';
$string['send'] = 'Küldés';
$string['services'] = 'Szolgáltatások';
$string['services_help'] = 'Válassza ki az eszközt rendelkezésre bocsátónak felajánlani kívánt szolgáltatásokat. Több szolgáltatást választhat.';
$string['setupoptions'] = 'Beállítási lehetőségek';
$string['share_email'] = 'Indító e-mailjének megosztása az eszközzel';
$string['share_email_admin'] = 'Indító e-mailjének megosztása az eszközzel';
$string['share_email_admin_help'] = 'Adja meg, hogy az eszközt elindító felhasználó e-mail címét megosztja-e az eszközszolgáltatóval.
Az eszközszolgáltatónak szüksége lehet az indítók e-mail címére akár a felületen azonos névvel rendelkező más felhasználóktól való megkülönböztetés, akár felhasználóknak az eszközön belüli tevékenysége alapján való e-mail küldése végett.';
$string['share_email_help'] = 'Adja meg, hogy az eszközt elindító felhasználó e-mail-címét megosztja-e az eszközszolgáltatóval.
Az eszközszolgáltatónak szüksége lehet az indítók e-mail-címére akár a felületen azonos névvel rendelkező más felhasználóktól való megkülönböztetés, akár felhasználóknak az eszközön belüli tevékenysége alapján való e-mail küldése végett.

Ne feledje, hogy ezt a beállítást az eszköz beállítása felülírhatja.';
$string['share_name'] = 'Indító nevének megosztása az eszközzel';
$string['share_name_admin'] = 'Indító nevének megosztása az eszközzel';
$string['share_name_admin_help'] = 'Adja meg, hogy az eszközt elindító felhasználó teljes nevét megosztja-e az eszközszolgáltatóval.
Az eszközszolgáltatónak szüksége lehet az indítók nevére ahhoz, hogy az eszközön belül értelmes tájékoztatást jeleníthessen meg.';
$string['share_name_help'] = 'Adja meg, hogy az eszközt elindító felhasználó teljes nevét megosztja-e az eszközszolgáltatóval.
Az eszközszolgáltatónak szüksége lehet az indítók nevére ahhoz, hogy az eszközön belül értelmes tájékoztatást jeleníthessen meg.

Ne feledje, hogy ezt a beállítást az eszköz beállítása felülírhatja.';
$string['share_roster'] = 'Kurzus névjegyzékéhez való hozzáférés engedélyezése az eszköz számára';
$string['share_roster_admin'] = 'Az eszköz hozzáférhet a kurzus névjegyzékéhez';
$string['share_roster_admin_help'] = 'Adja meg, hogy az eszköz hozzáférhet-e az azt elindító eszközfajta kurzusait felvett felhasználók névjegyzékéhez.';
$string['share_roster_help'] = 'Adja meg, hogy az eszköz hozzáférhet-e a kurzust felvett felhasználók névjegyzékéhez.

Ne feledje, hogy ezt a beállítást az eszköz beállítása felülírhatja.';
$string['show_in_course_activity_chooser'] = 'A tevékenységválasztóban és előre beállított eszközként jelenjen meg.';
$string['show_in_course_lti1'] = 'Eszközbeállítás használata';
$string['show_in_course_lti1_help'] = 'Az eszköz megjeleníthető egy tanár számára a tevékenységválasztóban egy kurzushoz való hozzáadáshoz, és megjelenhet az előre beállított eszköz lenyíló menüjében külső eszköz kurzushoz való hozzáadása közben. Választhatóan az eszközbeállítás csak akkor lehet használható, ha külső eszköz kurzushoz való hozzáadása közben az eszköz pontos webcímét adják meg.';
$string['show_in_course_lti2'] = 'Eszközbeállítás használata';
$string['show_in_course_lti2_help'] = 'Az eszköz megjeleníthető egy tanár számára a tevékenységválasztóban egy kurzushoz való hozzáadáshoz, és megjelenhet az előre beállított eszköz lenyíló menüjében külső eszköz kurzushoz való hozzáadása közben.';
$string['show_in_course_no'] = 'Ne jelenjen meg, csak az eszköz egyező webcíméhez legyen használatos.';
$string['show_in_course_preconfigured'] = 'Külső eszköz hozzáadásakor előre beállított eszközként jelenjen meg.';
$string['sitehost'] = 'Portál gazdagépneve';
$string['siteid'] = 'Portál azonosítója';
$string['size'] = 'Méretadatok';
$string['submission'] = 'Leadás';
$string['submissions'] = 'Leadott munkák';
$string['submissionsfor'] = '{$a} leadott munkái';
$string['subplugintype_ltiresource'] = 'LTI-szolgáltató forrása';
$string['subplugintype_ltiresource_plural'] = 'LTI-szolgáltató forrásai';
$string['subplugintype_ltiservice'] = 'LTI-szolgáltató';
$string['subplugintype_ltiservice_plural'] = 'LTI-szolgáltatók';
$string['subplugintype_ltisource'] = 'LTI-tananyag';
$string['subplugintype_ltisource_plural'] = 'LTI-tananyagok';
$string['successfullycreatedtooltype'] = 'Új eszköz létrehozása sikerült!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'A kiválasztott tartalomból sikerült elérni az eszköz beállítását.';
$string['toggle_debug_data'] = 'Hibakeresési adatok ki-/bekapcsolása';
$string['tool_config_not_found'] = 'Ehhez a webcímhez nincs eszközbeállítás';
$string['tool_settings'] = 'Eszközbeállítások';
$string['tooldescription'] = 'Eszköz leírása';
$string['tooldescription_help'] = 'Az eszköz leírását a tanárok a tevékenységlistán fogják látni.

Tartalmazza az eszköz célját, rendeltetését, és egyéb, a tanárok számára szükséges adatokat.';
$string['tooldetailsaccesstokenurl'] = 'Hozzáférési token webcíme';
$string['tooldetailsauthrequesturl'] = 'Hitelesítési kérelem webcíme';
$string['tooldetailsclientid'] = 'Ügyfél-azonosító';
$string['tooldetailsdeploymentid'] = 'Telepítési azonosító';
$string['tooldetailsmailtosubject'] = 'LTI-eszköz konfigurációja';
$string['tooldetailsmodalemail'] = 'E-mail';
$string['tooldetailsmodallink'] = 'Konfigurációs részletek megtekintése';
$string['tooldetailsmodaltitle'] = 'Eszközkonfigurációs részletek';
$string['tooldetailsplatformid'] = 'Platformazonosító';
$string['tooldetailspublickeyseturl'] = 'Nyilvános kulcskészlet webcíme';
$string['toolisbeingused'] = 'Az eszközt {$a} alkalommal használják.';
$string['toolisnotbeingused'] = 'Az eszközt még nem használják.';
$string['toolproxy'] = 'Külső eszközregisztrációk';
$string['toolproxy_help'] = 'A külső eszközregisztrációkkal a Moodle rendszergazdája egy LTI 2.0-t támogató eszközt rendelkezésre bocsátótól származó eszközproxy külső eszközeit állíthatja be. A folyamat elindításához mindössze az eszközt rendelkezésre bocsátótól kapott regisztrációs webcímre van szükség. A lehetőségek és szolgáltatások kiválasztására az új regisztráció beállítása során van lehetőség.

Az oldalon szereplő eszközregisztrációk négy csoportra oszlanak:

* **Beállítva** - Az eszközregisztrációk be vannak állítva, de a regisztrációs folyamat még nem kezdődött el.
* **Folyamatban** - Az eszközregisztrációk regisztrációs folyamata elkezdődött, de még nem ért véget. Nyissa meg és mentse el a beállításokat a \'Beállítva\' csoporthoz való visszatéréshez.
* **Elfogadva** - Az eszközregisztrációkat jóváhagyták; az eszközproxy megadott forrásai \'Folyamatban\' kezdő állapotban jelennek meg az előre beállított eszközök oldalán.
* **Elutasítva** - A regisztrációs folyamat során elutasított eszközregisztrációk.  Nyissa meg és mentse el a beállításokat a \'Beállítva\' csoporthoz való visszatéréshez, így a folyamatot újrakezdheti.';
$string['toolproxyregistration'] = 'Külső eszközregisztráció';
$string['toolregistration'] = 'Külső eszközregisztráció';
$string['toolsetup'] = 'Külső eszköz beállítása';
$string['tooltypeadded'] = 'Előre beállított eszköz hozzáadva';
$string['tooltypedeleted'] = 'Előre beállított eszköz törölve';
$string['tooltypenotdeleted'] = 'Az előre beállított eszközt nem sikerült törölni.';
$string['tooltypes'] = 'Eszközök';
$string['tooltypeupdated'] = 'Előre beállított eszköz frissítve';
$string['toolurl'] = 'Eszköz webcíme';
$string['toolurl_contentitemselectionrequest'] = 'Tartalomválasztó webcím';
$string['toolurl_contentitemselectionrequest_help'] = 'A Tartalomválasztó webcím az eszközszolgáltató tartalomválasztó oldalát indítja el. Ha üres, az eszköz webcímét használja.';
$string['toolurl_help'] = 'Az eszköz webcíme az eszköz webcímeit kapcsolja össze a helyes eszközbeállítással. A webcím előtt a http(s) használata nem kötelező.

Emellett az eszköz alapvető webcíme az eszköz webcímeként használatos, ha a külső eszköz példányában nincs megadva az eszköz webcíme.

Például a *tool.com* alapvető webcíme egyezik a következőkkel:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

A *www.tool.com/quizzes* alapvető webcíme egyezik a következőkkel::

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

A *quiz.tool.com* alapvető webcíme egyezik a következőkkel:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Ha azonos domén esetén két eltérő eszközbeállítás létezik, a specifikusabb egyezés használatára kerül sor.

Megadhat egy kazettás webcímet is, ha van, mely esetben az űrlap többi adata automatikusan kitöltődik.';
$string['toolurlplaceholder'] = 'Eszköz-URL...';
$string['typename'] = 'Eszköz neve';
$string['typename_help'] = 'Az eszköz neve az eszközszolgáltatót azonosítja a Moodle-ban. A megadott nevet az oktatók a kurzusokon belül külső eszközök hozzáadása során látják.';
$string['types'] = 'Típusok';
$string['unabletocreatetooltype'] = 'Az eszköz nem hozható létre';
$string['unabletofindtooltype'] = '{$a->id} esetén nem található az eszköz';
$string['unknownstate'] = 'Ismeretlen állapot';
$string['update'] = 'Frissítés';
$string['useraccountinformation'] = 'Felhasználói fiók adatai';
$string['userpersonalinformation'] = 'Felhasználó személyes adatai';
$string['using_tool_cartridge'] = 'Eszközkazetta használata';
$string['using_tool_configuration'] = 'Eszközbeállítás használata';
$string['validurl'] = 'Az érvényes URL kezdete http(s)://';
$string['viewsubmissions'] = 'A leadások és értékelő képernyő megtekintése';
