<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'surveypro', language 'es', version '4.1'.
 *
 * @package     surveypro
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abandoned_submission_deleted'] = 'Respuesta abandonada eliminada';
$string['action'] = 'Elementos preexistentes';
$string['action_help'] = 'Operar sobre elementos que ya están presentes en la encuesta con la acción siguiente.';
$string['addnewsubmission'] = 'Nueva respuesta';
$string['anonymous'] = 'Respuestas anónimas';
$string['anonymous_help'] = 'La tabla de manejo de respuestas no mostrará al propietario de las respuestas y los informes y la exportación serán anónimos.';
$string['answerisnoanswer'] = 'Respuesta rechazada';
$string['answernotsubmitted'] = 'Respuesta no enviada';
$string['apply'] = 'Aplicar';
$string['applymastertemplates'] = '<a href="{$a}">Aplicar plantillas maestras</a>';
$string['applyusertemplatedenied01'] = 'No tiene permiso para aplicar una plantilla maestra porque la encuesta actual ya ha sido contestada';
$string['applyusertemplatedenied02'] = 'No tiene permiso para aplicar una plantilla de usuario por encima de una plantilla maestra';
$string['applyusertemplates'] = '<a href="{$a}">Aplicar plantillas de usuario</a>';
$string['arrayexpected'] = 'Se espera un arreglo (una matriz) en {$a}';
$string['attemptinfo'] = 'Información de encuesta y respuestas';
$string['availability'] = 'Disponibilidad';
$string['availability_fs'] = 'Disponibilidad';
$string['available_title'] = 'Elemento disponible. Haga clic para reservar.';
$string['badchildparentvalue'] = 'Condición mal formada: "{$a}".<br>Podría ser que nunca sea verificada.';
$string['badtablenamefound'] = 'Error de procesamiento al leer XML. "{$a}" se ha encontrado como nombre de tabla y, lo más probable, es que sea inválido.';
$string['basic_editthanks'] = 'Gracias. ¡Su respuesta ha sido modificada exitosamente!';
$string['basic_submitthanks'] = 'Gracias. ¡Su respuesta ha sido enviada exitosamente!';
$string['branching'] = 'Ramificación';
$string['bulkaction'] = 'Acciones masivas';
$string['bulkaction_help'] = 'Use este menú para realizar acciones contra elementos como se describen por etiquetas.';
$string['calendar_close_description'] = 'Surveypro "{$a}" cerrado.';
$string['calendar_close_time'] = 'Surveypro "{$a}" ya no está disponiblee.';
$string['calendar_open_description'] = 'Llene surveypro "{$a}", por favor.';
$string['calendar_open_time'] = 'Surveypro "{$a}" está disponible.';
$string['canneversubmit'] = 'No tiene permiso para enviar una respuesta';
$string['cannotsubmittooearly'] = 'La encuesta aun no está abierta. Tiene que esperar hasta {$a}';
$string['cannotsubmittoolate'] = 'La encuesta se ha cerrado en {$a}';
$string['captcha'] = 'Añadir CAPTCHA';
$string['captcha_help'] = 'Añadir a esta colección el CAPTCHA para aumentar la seguridad.';
$string['category'] = 'Categoría de curso';
$string['changeorder_title'] = 'Reordenar';
$string['closed'] = 'Esta encuesta se cerró en';
$string['closedsubmissions'] = 'Respuestas cerradas';
$string['collesactual'] = 'COLLES (Actual/Real)';
$string['collespreferred'] = 'COLLES (Favorita)';
$string['common_fs'] = 'Ajustes generales';
$string['completiondetail:entries'] = 'Hacer entradas: {$a}';
$string['completionsubmit'] = 'Este es el título de la \'ayuda\'. ¿Dónde aparece?';
$string['completionsubmit_check'] = 'Los estudiantes deben, al menos, enviar la encuesta';
$string['completionsubmit_group'] = 'Requerir envío';
$string['completionsubmit_group_help'] = 'La encuesta se considerada completa cuando el estudiante la envía al menos el número de veces que está escrito aquí.';
$string['completionsubmitdesc'] = 'Número mínimo de envíos requeridos: {$a}';
$string['confirm_delete1item'] = 'Está seguro de querer eliminar el elemento de \'{$a->pluginname}\': {$a->content}';
$string['confirm_delete1utemplate'] = 'Está seguro de querer eliminar la plantilla del usuario "{$a}"';
$string['confirm_deleteallitems'] = '¿Confirma que desea eliminar TODOS los elementos?';
$string['confirm_deleteallresponses'] = '¿Está seguro de querer eliminar TODAS las respuestas guardadas?';
$string['confirm_deletechainitems'] = 'El elemento actual tiene elemento(s) hijo(s) que también van a ser eliminados. La posición del/de los elemento(s) hijo es: {$a}.';
$string['confirm_deletehiddenitems'] = '¿Confirma que desea eliminar TODOS los elementos  ocultos?';
$string['confirm_deletemyresponse_modified'] = '¿Está seguro de querer eliminar la respuesta creada en {$a->timecreated} y modificada en {$a->timemodified}?';
$string['confirm_deletemyresponse_original'] = '¿Está seguro de querer eliminar la respuesta creada en {$a->timecreated} y nunca modificada?';
$string['confirm_deleteotherresponse_modified'] = '¿Está seguro de querer eliminar la respuesta perteneciente a {$a->fullname}, creada en {$a->timecreated} y modificada en {$a->timemodified}?';
$string['confirm_deleteotherresponse_original'] = '¿Está seguro de querer eliminar la respuesta perteneciente a {$a->fullname}, creada en {$a->timecreated} y nunca modificada?';
$string['confirm_deletevisibleitems'] = '¿Está seguro de querer eliminar TODOS los elementos  visibles?';
$string['confirm_dropmultilang'] = 'La encuesta actual soporta multi idioma como importación desde una plantilla maestra.<br>Esto significa que la encuesta muestra preguntas y etiquetas de acuerdo al idioma preferido del usuario (si estuviera disponible).<br>Al editar este tipo de encuesta, perderá el soporte multi idioma, regresando a las etiquetas indiferenciadas estándares para toda la encuesta.<br>Tenga en cuenta que una vez que pierda el soporte multi idioma dado al generar nuevamente una plantilla maestra, ya no tendrá idiomas sin datos y, finalmente, la pérdida del soporte multi idioma no puede deshacerse.<br>¿Está seguro de querer editar esta encuesta multi idioma?';
$string['confirm_duplicatemyresponse_modified'] = '¿Está seguro de querer duplicar la respuesta creada en {$a->timecreated} y modificada en {$a->timemodified}?';
$string['confirm_duplicatemyresponse_original'] = '¿Está seguro de querer duplicar la respuesta creada en {$a->timecreated} y nunca modificada?';
$string['confirm_duplicateotherresponse_modified'] = '¿Está seguro de querer duplicar la respuesta perteneciente a {$a->fullname}, creada en {$a->timecreated} y modificada en {$a->timemodified}?';
$string['confirm_duplicateotherresponse_original'] = '¿Está seguro de querer duplicar la respuesta perteneciente a {$a->fullname}, creada en {$a->timecreated} y nunca modificada?';
$string['confirm_free1item'] = 'Haciendo disponible el elemento "{$a->itemcontent}" va a hacer accesible también a su ancestro.<br> El ancestro es el elemento en posición: {$a->ancestors}.<br>¿Confirma esta acción?';
$string['confirm_freechainitems'] = 'Haciendo disponible el elemento "{$a->itemcontent}" va a hacer accesibles todas sus dependencias.<br>Las dependencias son los elementos en posición: {$a->dependencies}.<br>¿Confirma esta acción?';
$string['confirm_freechainitems_newparent'] = 'Haciendo disponible el elemento "{$a->itemcontent}", todas las dependencias del elemento "{$a->parentcontent}" serán hechas accesibles también.<br>Por lo que, además del elemento seleccionado, va a hacer disponibles los elementos en posición: {$a->dependencies}.<br>¿Confirma esta acción?';
$string['confirm_hide1item'] = 'Ocultando el elemento "{$a->itemcontent}" su dependencia se ocultará también.<br>La dependencia es el elemento en posición: {$a->dependencies}.<br>¿Confirma esta acción?';
$string['confirm_hideallitems'] = '¿Confirma que desea ocultar TODOS los elementos?';
$string['confirm_hidechainitems'] = 'Ocultando el elemento "{$a->itemcontent}" todas sus dependencias se ocultarán también.<br>Las dependencias son los elementos en posición: {$a->dependencies}.<br>¿Confirma esta acción?';
$string['confirm_reserve1item'] = 'Al reservar el elemento "{$a->parentcontent}" también va a reservar su dependencia.<br>La dependencia es el elemento en posición: {$a->dependencies}.<br>¿Confirma esta acción?';
$string['confirm_reservechainitems'] = 'Al reservar el elemento "{$a->itemcontent}" también va a reservar todas sus dependencias.<br>Las dependencias son los elementos en posición: {$a->dependencies}.<br>¿Confirma esta acción?';
$string['confirm_reservechainitems_newparent'] = 'Al reservar el elemento "{$a->itemcontent}", todas las dependencias del elemento "{$a->parentcontent}" también se reservarán.<br>Por lo tanto, además del elemento elegido, va a reservar los elementos en posición: {$a->dependencies}.<br>¿Confirma esta acción?';
$string['confirm_show1item'] = 'Mostrando el elemento {$a->lastitem} va a mostrar a su(s) ancestro(s).<br>Los ancestros son los elementos en posición: {$a->ancestors}.<br>¿Confirma esta acción?';
$string['confirm_showallitems'] = '¿Confirma que desea mostrar TODOS los elementos  ?';
$string['confirm_showchainitems'] = 'Mostrando el elemento {$a->lastitem} va a mostrar todos sus ancestros.<br>Los ancestros son los elementos en posición: {$a->ancestors}.<br>¿Confirma esta acción?';
$string['content'] = 'Contenido';
$string['content_editor'] = 'Contenido';
$string['content_editor_err'] = 'El contenido es obligatorio';
$string['content_editor_help'] = 'El contenido del elemento tal y como se le mostrará al usuario remoto.';
$string['content_err'] = 'El contenido es obligatorio';
$string['content_help'] = 'El contenido del elemento tal como será mostrado al usuario remoto.';
$string['count_allitems'] = 'Encuesta construida en {$a} elementos.';
$string['count_hiddenitems'] = '({$a} ocultos)';
$string['count_pages'] = 'Dividida en {$a} páginas.';
$string['course'] = 'Curso';
$string['currentcategory'] = 'La categoría del curso';
$string['currentcourse'] = 'Este curso';
$string['currenttotemplate'] = 'Guardar encuesta actual como plantilla maestra en formato ZIP.<br>Para instalar una plantilla maestra, descomprímala a mod/surveypro/template/ y visite la página de notificaciones.';
$string['customnumber'] = 'Elemento número';
$string['customnumber_header'] = '#';
$string['customnumber_help'] = 'Use este campo para darle un número personalizado al elemento. Puede ser un número natural como 1 o cualquier otro que necesite: 1a, A, 1.1.a, #1, A, A.1... Tenga en cuenta que es responsable de la coherencia de esos números. Por lo tanto, tenga cuidado si planea cambiar el orden de los elementos.';
$string['dataimport'] = 'Importar datos';
$string['deleteabandoned_task'] = 'Eliminando envíos incompletos';
$string['deleteallitems'] = 'Eliminar todos los elementos';
$string['deleteallsubmissions'] = 'Eliminar todas las respuestas';
$string['deletehiddenitems'] = 'Eliminar elementos ocultos';
$string['deletepluginmessage'] = 'Usted está a punto de eliminar completamente el plugin de encuesta "{$a}". Esto eliminará completamente todo en la base de datos relacionado con este plugin. ¿Está SEGURO de querer continuar?';
$string['deletevisibleitems'] = 'Eliminar elementos visibles';
$string['deletingplugin'] = 'Eliminando plugin {$a}.';
$string['downloadformat'] = 'Formato de descarga';
$string['downloadpdf'] = 'descargar a PDF';
$string['downloadtocsv'] = 'valores separados por comas';
$string['downloadtotsv'] = 'valores separados por TAB';
$string['downloadtoxls'] = 'excel';
$string['downloadtozipbysubmission'] = 'descargar adjuntos por ítem a ZIP';
$string['downloadtozipbyuser'] = 'descargar adjuntos por usuario a ZIP';
$string['downloadtype'] = 'Tipo de archivo de descarga';
$string['duplicateemail'] = 'Las direcciones de correo electrónico deben ser diferentes unas de otras';
$string['editcopy'] = 'Editar copia';
$string['editingcopy'] = 'Está editando una copia de la respuesta original para poder preservar el historial de su trabajo.';
$string['emptyanswer'] = 'Respuesta vacía';
$string['emptydownload'] = 'No se encontraron respuestas para exportar';
$string['enteruniquename'] = 'Por favor elija un nombre único o seleccione la opción "{$a->overwrite}" dado que "{$a->filename}" ya existe en el contexto elegido';
$string['event_all_submissions_exported'] = 'Todos los envíos han sido exportados';
$string['event_all_submissions_viewed'] = 'Todos los envíos han sido vistos';
$string['event_all_usertemplates_viewed'] = 'Todas las plantillas de usuario han sido vistas';
$string['event_form_previewed'] = 'El diseño de la encuesta ha sido previsualizado';
$string['event_item_created'] = 'Se ha creado un elemento';
$string['event_item_deleted'] = 'Se ha eliminado un elemento';
$string['event_item_hidden'] = 'Se ha ocultado un elemento';
$string['event_item_modified'] = 'Se ha modificado un elemento';
$string['event_item_shown'] = 'Se ha mostrado un elemento';
$string['event_mailneverstarted_sent'] = 'Email enviado para encuesta jamás iniciada';
$string['event_mailoneshotmp_sent'] = 'Email enviado para encuesta abandonada de un intento multi página';
$string['event_mailpauseresume_sent'] = 'Email enviado para encuesta pausada abandonada';
$string['event_mastertemplate_applied'] = 'Se ha aplicado una plantilla maestra';
$string['event_mastertemplate_saved'] = 'Se ha guardado una plantilla maestra';
$string['event_submission_created'] = 'Se ha creado una respuesta';
$string['event_submission_deleted'] = 'Se ha eliminado una respuesta';
$string['event_submission_modified'] = 'Se ha modificado una respuesta';
$string['event_submission_viewed'] = 'Se ha visto una respuesta';
$string['event_submissions_imported'] = 'Respuestas importadas';
$string['event_submissiontopdf_downloaded'] = 'Se ha descargado una respuesta en pdf';
$string['event_usertemplate_applied'] = 'Se ha aplicado una plantilla de usuario';
$string['event_usertemplate_deleted'] = 'Se ha eliminado una plantilla de usuario';
$string['event_usertemplate_exported'] = 'Se ha exportado una plantilla de usuario';
$string['event_usertemplate_imported'] = 'Se ha importado una plantilla de usuario';
$string['event_usertemplate_saved'] = 'Se ha guardado una plantilla de usuario';
$string['exporttemplate'] = 'exportar plantilla';
$string['extranote'] = 'Nota adicional';
$string['extranote_help'] = 'Escriba aquí una descripción/nota acerca de la información adicional que el usuario debería conocer acerca de este elemento.';
$string['extranoteinsearch'] = 'Nota extra en formato de búsqueda';
$string['extranoteinsearch_descr'] = '¿Se necesitan notas del usuario en el formato para búsqueda?';
$string['feedback_delete1item'] = 'El elemento de \'{$a->pluginname}\' : {$a->content} ha sido eliminado exitosamente';
$string['feedback_delete1response'] = 'La respuesta del usuario ha sido eliminada exitosamente';
$string['feedback_delete1utemplate'] = 'La plantilla de usuario "{$a}" fue eliminada exitosamente';
$string['feedback_deleteallitems'] = 'Todos los elementos fueron eliminados exitosamente';
$string['feedback_deleteallresponses'] = 'Todas las respuestas de esta encuesta han sido eliminadas exitosamente';
$string['feedback_deletechainitems'] = 'El \'{$a->pluginname}\' elemento: {$a->content} y elemento(s) descendiente(s) ha(n) sido eliminado(s) exitosamente';
$string['feedback_deletehiddenitems'] = 'Todos los elementos ocultos han sido eliminados exitosamente';
$string['feedback_deletevisibleitems'] = 'Todos los elementos visibles fueron eliminados exitosamente';
$string['feedback_dropmultilang'] = 'Se descartó multilang (multi idioma) para la plantilla maestra cargada. Ahora los elementos son editables.';
$string['feedback_duplicateresponse'] = 'La respuesta del usuario ha sido duplicada exitosamente';
$string['feedback_hideallitems'] = 'Todos los elementos fueron ocultados exitosamente';
$string['feedback_itemadd_ko'] = 'El elemento nuevo no ha sido añadido';
$string['feedback_itemadd_ok'] = 'El elemento ha sido añadido exitosamente';
$string['feedback_itemediting_freechainitems'] = 'Al liberar este elemento, algunos elementos de los que desciende fueron liberados también.';
$string['feedback_itemediting_hidechainitems'] = 'Al ocultar este elemento, algunos elementos dependientes fueron ocultados también.';
$string['feedback_itemediting_ko'] = 'Ocurrió un error al guardar el elemento';
$string['feedback_itemediting_ok'] = 'El elemento ha sido modificado exitosamente';
$string['feedback_itemediting_reservechainitems'] = 'Al reservar este elemento, algunos elementos descendientes fueron reservados también.';
$string['feedback_itemediting_showchainitems'] = 'Al mostrar este elemento, algunos elementos ascendientes fueron mostrados también.';
$string['feedback_showallitems'] = 'Todos los elementos fueron mostrados exitosamente';
$string['field'] = 'elemento de campo';
$string['fieldplugin'] = 'Plugin de Elemento';
$string['fillinginstructioninsearch'] = 'Instrucción de rellenado en formato de búsqueda';
$string['fillinginstructioninsearch_descr'] = '¿Se necesitan instrucciones para el llenado en el formato para búsqueda?';
$string['forcedoptionalitem_title'] = 'Elemento opcional forzado debido al valor por defecto.';
$string['format'] = 'elemento de formato';
$string['formatplugin'] = 'Plugin de formato';
$string['free'] = 'libre';
$string['fullwidth'] = 'superior izquierdo (ancho completo)';
$string['gotolist'] = 'Continuar hacia lista de respuestas';
$string['hassubmissions_alert'] = 'Esta encuesta ya ha sido contestada al menos una vez.<br>Por favor proceda con extrema cautela y sólamente haga cambios neutros que no comprometan la validez de toda la encuesta.<br><br>TENGA EN CUENTA: Al añadir un nuevo elemento, el estado de cada respuesta ya enviada se cambiará obligatoriamente al estado "en progreso".';
$string['hassubmissions_alert_activitycompletion'] = '<br>Con la modificación de elementos, el estado de finalización de la actividad también cambiará.<br>Ha sido advertido.';
$string['hassubmissions_danger'] = '<br>Las respuestas "En progreso"...<ul><li>están sujetas a eliminación en 4 horas si no estuviera permitida la opción guardar/continuar;</li><li>están sujetas a eliminación en el número de horas configurado en la página de configuraciones de surveypro.</li></ul>';
$string['hidden'] = 'Oculto';
$string['hidden_help'] = 'Use esta opción para ocultar el elemento. Los elementos ocultos no estarán disponibles para nadie. Puede considerar a estos elementos como que no son parte de la encuesta.';
$string['hideallitems'] = 'Ocultar todos los elementos';
$string['hidefield_title'] = 'Elemento visible. Hacer clic para ocultar.';
$string['hideinstructions'] = 'Ocultar instrucciones de rellenado';
$string['hideinstructions_help'] = 'Use esta casilla para mostrar/ocultar instrucciones de rellenado para este elemento.';
$string['hideitems'] = 'Ocultar';
$string['hideshow'] = 'Ocultar/Mostrar';
$string['history'] = 'Preservar historial';
$string['history_help'] = 'Al preservar el historial, los usuarios ya no podrán modificar directamente una respuesta cerrada. Las modificaciones de las respuestas cerradas se guardarán como una copia nueva, dejando la original intacta y conservando el historial.';
$string['ierr_invalidinput'] = 'Valor introducido incorrecto';
$string['ierr_missingparentcontent'] = 'Tiene que especificar un contenido paterno o de lo contrario vaciar el campo "{$a}"';
$string['ierr_missingparentid'] = 'Tiene que seleccionar un elemento para ramificar la encuesta. De lo contario debe vaciar el campo "{$a}"';
$string['ierr_notalloweddefault'] = '"{$a}" no es un valor predeterminado permitido para elementos "requeridos"';
$string['ignoreitems'] = 'Ignorar';
$string['import_attachmentsnotallowed'] = 'Parece que está tratando de importar anexos para los siguientes elementos:{$a}<br>Esto no está permitido por ahora.';
$string['import_breakingmaxentries'] = 'La importación asignará {$a->totalentries} respuestas al usuario con ID {$a->userid}. Esto excede el número máximo permitido que ha sido configurado en {$a->maxentries}.';
$string['import_columnscountchanges'] = 'El número de las columnas cambia en el archivo';
$string['import_duplicateheader'] = 'El encabezado "{$a}" fue encontrado, al menos, dos veces';
$string['import_emptyrequiredvalue'] = 'La cadena de caracteres vacía en la columna {$a->col} no está permitida. La respuesta al elemento "{$a->plugin}":<br>{$a->content} es necesaria.<br>La fila donde se produce el problema es:<br>"{$a->row}"';
$string['import_extraheaderfound'] = 'Algunos campos en el archivo seleccionado no se encontraron entre las variables de este surveypro.<br>Son estos:{$a}';
$string['import_invalidtimecreated'] = 'La hora de creación (timecreated) "{$a}" no es válida';
$string['import_invalidtimemodified'] = 'La hora de modificación (timemodified) "{$a}" no es válida';
$string['import_invaliduserid'] = 'El identificador de usuario (userid) "{$a}" no es válido';
$string['import_missingheaders'] = '{$a->childheader} (se esperaba: {$a->missingparentheader})';
$string['import_missingtimecreated'] = 'Dejar la hora de creación vacía no es válido';
$string['import_missinguserid'] = 'Dejar el id de usuario (userid) vacío no es válido';
$string['import_noanswertorequired'] = 'El valor "{$a->value}" encontrado en la columna {$a->col} no está permitido. La respuesta al elemento "{$a->plugin}":<br>{$a->content} es necesaria.<br>La fila en la que se encuentra el error es:<br>"{$a->row}"';
$string['import_nullnotallowed'] = 'El valor "{$a->value}" encontrado en la columna {$a->col}no está permitido. La respuesta al elemento "{$a->plugin}":<br>{$a->content} no puede ser nula porque el elemento no está prohibido por su padre en esta respuesta.<br>La fila en la que se encuentra el error es:<br>"{$a->row}"';
$string['import_nullwithoutparent'] = 'El valor "{$a->value}" encontrado en la columna {$a->col} no está permitido. La respuesta al elemento "{$a->plugin}":<br>{$a->content} no puede ser nula porque el elemento no está condicionado por una relación padre/hijo.<br>La fila en la que se encuentra el error es:<br>"{$a->row}"';
$string['import_orphanchild'] = 'Parece que los siguientes elementos hijos están huérfanos:{$a}<br>Las respuestas no serán importadas.';
$string['import_positionnotinteger'] = 'La posición "{$a->position}" para el "{$a->plugin}" elemento:<br>{$a->content} encontrado en la columna {$a->csvcol} no es un número entero.{$a->prettywarning}';
$string['import_positionoutofbound'] = 'La posición "{$a->position}" para el elemento "{$a->plugin}":<br>{$a->content} encontrado en la columna {$a->csvcol} está fuera de los límites. Los límites son: "{$a->bounds}".{$a->prettywarning}';
$string['import_prettywarning'] = '<br><br>¿Está seguro de que está importando datos sin procesar y no un archivo con algún tipo de estilo?';
$string['import_rawwarning'] = '(Advertencia: Los archivos con nombre de propietario no pueden ser importados de nuevo)';
$string['importfile'] = 'Elegir archivos a importar';
$string['importusertemplates'] = '<a href="{$a}">Importar plantilas de usuario</a>';
$string['includedates'] = 'Incluir fechas de creación y de modificación';
$string['includehidden'] = 'Incluir elementos ocultos';
$string['includenames'] = 'Incluir nombre del propietario';
$string['includereserved'] = 'Incluir elementos reservados';
$string['incorrectaccessdetected'] = 'Acceso incorrecto detectado';
$string['indent'] = 'Indentar';
$string['indent_help'] = 'La indentación del elemento o margen izquierdo que el elemento respetará una vez que se dibuje.';
$string['inprogresssubmissions'] = 'Respuestas en progreso';
$string['inputclean'] = 'La entrada será limpiada de espacios finales cuando se guarde';
$string['insearchform'] = 'Formulario de búsqueda';
$string['insearchform_help'] = '¿Será usado este elemento en el formulario de búsqueda?';
$string['insearchform_title'] = 'Elemento buscable. Haga clic para hacerlo no buscable.';
$string['invalidtypeorplugin'] = 'Se proporcionaron un tipo o plugin no válido como propiedades de elemento en la plantilla';
$string['invitedefault'] = 'Invitar';
$string['item'] = 'Elemento';
$string['itemlist'] = 'Lista de elementos';
$string['keepinprogress'] = 'Conservar respuestas "en progreso"';
$string['keepinprogress_help'] = 'No eliminar respuestas "en progreso" a pesar de la política del módulo. Las respuestas "En progreso" se suponía que fueran descartadas para garantizar siempre una buena confibilidad a la base de datos final. Si, por cualquier razón, necesitara recoger también las respuestas "en progreso", active esta casilla.';
$string['layout'] = 'Diseño';
$string['layout_branchingvalidation'] = 'Validación ramificada';
$string['layout_edititem'] = 'Editar elemento';
$string['layout_items'] = 'Elementos';
$string['layout_itemsetup'] = 'Configuración de elemento';
$string['layout_preview'] = 'Previsualización';
$string['left'] = 'izquierda';
$string['likelast'] = 'Como la última respuesta';
$string['mailcontentdefault'] = 'Usuario {FULLNAME} añadió una respuesta a "{SURVEYPRONAME}"';
$string['mailcontenteditor'] = 'Mensaje de notificación';
$string['mailcontenteditor_help'] = 'El contenido del mensaje personalizado que será enviado cuando se envíe la respuesta. Si se solicita un correo de notificación cuando se envíe la respuesta y este mensaje no se facilita, se usará el contenido predeterminado del correo electrónico.<br><br>Uso:<ul><li>{FIRSTNAME}</li><li>{LASTNAME}</li><li>{FULLNAME}</li><li>{COURSENAME}</li><li>{SURVEYPRONAME}</li><li>{SURVEYPROURL}</li></ul>para obtener<ul><li>el nombre del usuario</li><li>los apellidos</li><li>el nombre completo del usuario</li><li>el nombre del curso</li><li>el nombre de este surveypro</li><li>la url de este surveypro</li></ul>Tenga cuidado: el mensaje predeterminado es multi idioma, su mensaje personalizado será usado tal cual lo escriba y nunca será traducido.';
$string['mailextraaddresses'] = 'Más direcciones';
$string['mailextraaddresses_help'] = 'Algunas direcciones de correo electrónico adicionales para notificarles las nuevas respuestas. Se espera que haya una dirección por fila.';
$string['mailroles'] = 'Roles a los que notificar';
$string['mailroles_help'] = 'Enviar un correo electrónico a cada componente de los roles seleccionados en cada respuesta. Los roles están pensados para el nivel del curso, por lo que se ignora cualquier división en grupos. El correo electrónico solamente avisará sobre de la respuesta del usuario, no acerca del contenido ni de los detalles del remitente.';
$string['managesurveyprofieldplugins'] = 'Gestionar plugins de campo';
$string['managesurveyproformatplugins'] = 'Gestionar plugins de formato';
$string['managesurveyproreportplugins'] = 'Gestionar plugins de informe';
$string['managesurveyprotemplateplugins'] = 'Gestionar plugins de plantilla';
$string['manageusertemplates'] = '<a href="{$a}">Gestionar plantillas de usuario</a>';
$string['mastertemplate'] = 'Plantillas maestras';
$string['mastertemplate_help'] = 'Elija una plantilla maestra, como por ejemplo una de las clásicas proporcionadas por defecto, o una personalizada añadida a esta instancia de surveypro. Los tipos de encuesta clásicos son:<ul>
<li>ATTLS: Attitudes To Thinking and Learning Survey (Encuesta de Actitudes Hacia el Pensamiento y Aprendizaje).<br>Para más detalles, vea la documentación en <a href="https://docs.moodle.org/31/en/Survey_settings#ATTLS_-_Attitudes_to_Thinking_and_Learning_Survey" name="ATTLS" title="ATTLS">ATTLS</a>.</li>
<li>COLLES: Constructivist On-Line Learning Environment Survey (Encuesta Constructivista de Ambiente de Aprendizaje En-Línea).<br>Para más detalles, vea la documentación en <a href="https://docs.moodle.org/31/en/Survey_settings#COLLES_-_Constructivist_On-Line_Learning_Environment_Survey" name="COLLES" title="COLLES">COLLES</a>.</li>
<li>CRITICAL INCIDENTS.<br>Para más detalles, vea la documentación en <a href="https://docs.moodle.org/31/en/Survey_settings#Critical_incidents" name="Critical incidents" title="Critical incidents">Critical incidents</a></li></ul>';
$string['mastertemplateaddendum'] = '<br>No puede aplicar esta plantilla maestra hasta que la desinstale, corrija todos los problemas y vuelva a instalarla.';
$string['mastertemplatename'] = 'Nombre de plantilla maestra';
$string['mastertemplatename_help'] = 'Elija el nombre de la plantilla maestra que será descargada en formato ZIP.';
$string['mastertemplateplugin'] = 'Plugin de plantilla maestra';
$string['maxentries'] = 'Máximos intentos permitidos';
$string['maxentries_help'] = 'El número máximo de respuestas que un estudiante tiene permitido enviar para esta actividad.';
$string['maxinputdelay'] = 'Retraso máximo para contestar';
$string['maxinputdelay_descr'] = 'El retraso en horas máximo permitido para que los usuarios envíen una encuesta. Incluso cuando al usuario se le permita detener la introducción de datos y reiniciarlo después, tras el tiempo definido aquí las respuestas parciales se eliminarán. El valor por defecto es de 168 horas que equivalen a una semana. Ajuste esto a cero (0) si realmente desea permitir respuestas parciales (lo que no se recomienda).';
$string['missingfile'] = 'Al parecer no se seleccionó ningun archivo';
$string['missingitemplugin'] = 'A uno o más ítems de la plantilla les falta el plugin';
$string['missingitemtype'] = 'A uno o más ítems de la plantilla les falta el tipo';
$string['missingitemversion'] = 'A uno o más ítems de la plantilla les falta la versión';
$string['missingmandatory'] = 'No se ha encontrado ninguna contestación obligatoria de esta respuesta. Por esto, las respuestas generales se han marcado como "{$a}".<br>Para corregir este problema, por favor edite la respuesta y revise los contenidos de los elementos página por página.';
$string['missingvalidation'] = 'Algunas contestaciones de esta respuesta han sido identificadas como no verificadas. Por esto, la respuesta general la sido marcada como "{$a}".<br>Sus datos no son necesariamente incorrectos, pero necesitan validación antes del almacenamiento definitivo.<br>Para corregir este problema, por favor edite la respuesta y revise los contenidos de los elementos página por página.';
$string['module'] = 'Esta instancia de encuesta';
$string['modulename'] = 'Surveypro';
$string['modulename_help'] = 'Surveypro le permite crear encuestas personalizadas, tanto como encuestas tipo ATTLS, COLLES y CRITICAL INCIDENTS. También puede guardar y reutilizar partes de, o toda su encuesta personalizada.';
$string['modulename_link'] = 'mod/surveypro/view';
$string['modulenameplural'] = 'surveys';
$string['modulesettinghdr'] = 'Ajustes de Surveypro';
$string['mtemplate'] = 'Plantillas maestras';
$string['mtemplate_apply'] = 'Aplicar';
$string['mtemplate_save'] = 'Guardar';
$string['mtemplatessection'] = 'Sección de plantillas maestras';
$string['neverstartedemail'] = 'Correo electrónico para encuesta no iniciada';
$string['neverstartedemail_help'] = 'Enviar un correo electrónico de recordatorio a usuarios que no empezaron su primer envío';
$string['newpageforchild'] = 'Las ramas aumentan las páginas';
$string['newpageforchild_help'] = 'Use esta opción para forzar una página nueva después de cada elemento que ramifica.';
$string['newsubmissionbody'] = '{$a->username} envió una nueva respuesta en "{$a->surveyproname}". Puede revisarlo <a title="{$a->title}" href="{$a->href}">aquí</a>';
$string['newsubmissionsubject'] = 'Nueva respuesta';
$string['nextformpage'] = 'Página siguiente >>';
$string['noanswer'] = 'Sin respuesta';
$string['noattachmentfound'] = 'No se han encontrado adjuntos';
$string['noitemsfound'] = 'Esta plantilla aun es un trabajo en progreso.<br>Por favor inténtelo de nuevo más tarde.';
$string['noitemsfoundadmin'] = 'Esta plantilla no tiene elementos. Por favor añádalos desde "{$a}".';
$string['nomoreitems'] = 'En base a las respuestas proporcionadas, ya no quedan más elementos para mostrar.<br>Su encuesta está terminada. Solo tiene que enviar{$a}.';
$string['nomoresubmissionsallowed'] = 'El número máximo de {$a} respuestas ya se ha alcanzado.<br>No se permiten más intentos';
$string['nomtemplates'] = 'Faltan plantillas maestras';
$string['nomtemplates_help'] = 'El creador del curso probablemente limitó la instanciación de cada plantilla maestra. Contacte con su creador del curso para más detalles.';
$string['nomtemplates_message'] = 'Lo sentimos. No aparece ninguna plantilla maestra disponible en esta instancia de sitio Moodle.';
$string['noreportsfound'] = 'No hay informes en esta instalación de Surveypro.';
$string['nosubmissionsforenrolled'] = 'No se encontraron respuestas en esta encuesta para estudiantes inscritos.';
$string['note'] = 'Nota:';
$string['nothingtodownload'] = 'Nada para descargar';
$string['notinsearchform_title'] = 'Elemento no buscable. Haga clic para hacerlo buscable.';
$string['numinstances'] = 'Instancias';
$string['oneshotemail'] = 'Encuesta de un paso con correo electrónico de recordatorio';
$string['oneshotnoemail'] = 'Encuesta de un paso sin correo electrónico de recordatorio';
$string['onlyfinalizationallowed'] = 'pero solamente para finalización de aquellos que todavía están "{$a->inprogress}" en la página "{$a->surveyproresponses}".';
$string['onlyreserveditemhere'] = 'La página actual solamente contiene elementos reservados a los cuales no puede acceder';
$string['onlyreview'] = 'o revisar';
$string['opened'] = 'Hora de apertura';
$string['optionalitem_title'] = 'Elemento opcional. Haga clic para hacer obligatorio al elemento.';
$string['outputstyle'] = 'Estilo de salida';
$string['overwrite'] = 'Reemplazar plantilla más antigua';
$string['overwrite_help'] = 'Al seleccionar esta casilla sobrescribirá una plantilla más antigua con el mismo nombre. Si deja esta casilla sin seleccionar, en caso de conflictos se le pedirá un nuevo nombre único.';
$string['pagexofy'] = 'Página {$a->formpage} de {$a->userformpagecount}';
$string['parentconstraints'] = 'Restricciones paternas';
$string['parentcontent'] = 'Contenido paterno';
$string['parentcontent_help'] = 'Esto es lo que se espera que responda el usuario al elemento paterno para habilitar/mostrar este elemento.';
$string['parentelement_help'] = 'El elemento cuya respuesta, durante la compilación del cuestionario, determina el acceso al elemento actual.';
$string['parentelement_title'] = 'Elemento paterno';
$string['parentformat'] = 'Defina el formato "{$a->fieldname}" tal y como se muestra aquí: {$a->examples}';
$string['parentid'] = 'Elemento paterno';
$string['parentid_header'] = 'Relación';
$string['parentid_help'] = 'Los elementos paternos le permiten crear ramificaciones condicionales. Los elementos atenuados en la lista identifican elementos paternos ocultos. Muéstrelos para tenerlos disponibles en la lista.<br>Los elementos marcados con un asterisco están reservados.';
$string['pause'] = 'Pausa';
$string['pauseresume'] = 'Permitir Guardar/Continuar';
$string['pauseresume_help'] = 'Permitir pausar una encuesta para poder continuarla y enviarla después. También puede enviar un correo electrónico para recordarles que no han finalizado la encuesta.';
$string['pauseresumeemail'] = 'Permitir pausar/continuar con correo electrónico de recordatorio';
$string['pauseresumenoemail'] = 'Permitir pausar/continuar sin correo electrónico de recordatorio';
$string['plugin'] = 'Elemento';
$string['pluginadministration'] = 'Administración de Surveypro';
$string['pluginname'] = 'Surveypro';
$string['pluginname_help'] = 'Escriba aquí el nombre del plugin de encuesta que va a guardar.';
$string['plugintype'] = 'Tipo de plugin';
$string['position'] = 'Posición de la pregunta';
$string['position_help'] = 'Use esta opción para elegir la posición del contenido del elemento. Puede ser hacia la izquierda de la interfaz del usuario, en una fila dedicada justo arriba de la interfaz para introducir la respuesta o en una fila dedicada justo arriba de la interfaz que abarca a toda la fila.<br>Nota: la posición izquierda fuerza a los contenidos del elemento a texto plano sin imágenes.<br>¡Las dos posiciones \'superiores\' usualmente son utilizadas para contenidos que son más largos que unas cuantas palabras y son necesarias para preguntas que contienen imágenes!';
$string['previewmode'] = 'Está en \'{$a}\': se supone que no deben de mostrarse los botones para guardar datos';
$string['previousformpage'] = '<< Página anterior';
$string['privacy:metadata:answer'] = 'Respuestas a elementos de surveypros.';
$string['privacy:metadata:answer:content'] = 'Campo donde son almacenados las respuestas a elementos.';
$string['privacy:metadata:answer:contentformat'] = 'Campo que almacena el formato de las respuestas a los ítems.';
$string['privacy:metadata:submission'] = 'Respuestas a surveypros.';
$string['privacy:metadata:submission:status'] = 'El estado global de la respuesta proporcionada por el usuario.';
$string['privacy:metadata:submission:timecreated'] = 'La hora en que se publicó la respuesta.';
$string['privacy:metadata:submission:timemodified'] = 'La hora en que se modificó la respuesta.';
$string['privacy:metadata:submission:userid'] = 'El ID del usuario que envió su respuesta.';
$string['privacy:metadata:surveyprofieldpluginsummary'] = 'Datos de campo para el surveypro.';
$string['privacy:metadata:surveyproformatpluginsummary'] = 'Datos de formato para el surveypro.';
$string['privacy:metadata:surveyproreportpluginsummary'] = 'Datos de informe para el surveypro.';
$string['privacy:metadata:surveyprotemplatepluginsummary'] = 'Datos de plantilla para el surveypro.';
$string['privacy:metadata:uploadedfiles'] = 'Archivos subidos en el marco de respuestas.';
$string['privacy:path:fileupload'] = 'Respuesta {$a}';
$string['raw'] = 'Sin formato (para su posterior importación en Surveypro; es posible que no se respete "{$a}";)';
$string['readonlyaccess'] = 'Acceso de solo lectura';
$string['relation_status'] = 'Estado';
$string['reminder_neverstarted_task'] = 'Recordatorio para encuesta jamás iniciada';
$string['reminder_oneshot_task'] = 'Recordatorio para encuesta detenida';
$string['reminder_pauseresume_task'] = 'Recordatorio para encuesta pausada por demasiado tiempo';
$string['reminder_subject'] = 'Recordatorio de Surveypro desde {$a}';
$string['reminderoneshot_content1'] = 'Estimado {$a->fullname}<br>al parecer su contribución a la encuesta "{$a->surveyproname}" aun no está enviada.';
$string['reminderoneshot_content2'] = '<br>Será eliminada en menos de dos horas.';
$string['reminderoneshot_content3'] = '<br>Por favor considere iniciar sesión de nuevo en {$a} y enviarla pronto.<br><br>El equipo de enseñanza en línea';
$string['reminderpaused_content1'] = 'Estimado {$a->fullname}<br>al parecer su contribución a la encuesta "{$a->surveyproname}" está pausada desde hace mucho tiempo.';
$string['reminderpaused_content2'] = '<br>Hay un gran riesgo de tenerla descartada.';
$string['reminderpaused_content3'] = '<br>Por favor considere iniciar sesión de nuevo en {$a} y enviarla.<br><br>El equipo de enseñanza en línea';
$string['remindneverstarted_content'] = 'Estimado {$a->fullname}<br> al parecer su contribución a la encuesta "{$a->surveyproname}" aun no ha iniciado.<br>Por favor considere iniciar sesión de nuevo en {$a->surveyprourl} y empezarla cuanto antes.<br><br>El equipo de enseñanza en línea';
$string['reportederror'] = '{$a}';
$string['reportederroritembase'] = '%s realizando la validación xsd del "surveypro_item" para el plugin "%s"';
$string['reportederrorplugin'] = '%s realizando la validación xsd del plugin "%s"';
$string['reportplugin'] = 'Plugin de informe';
$string['reports'] = 'Informes';
$string['reportsection'] = 'Sección de informes';
$string['required'] = 'Obligatorio';
$string['required_help'] = '¿Será forzado el usuario a contestar este elemento?';
$string['requireditem_title'] = 'Elemento obligatorio. Haga clic para hacer opcional al elemento.';
$string['reserved'] = 'Reservado';
$string['reserved_help'] = '¿Este elemento solamente estará disponible para usuarios con un permiso especial, o generalmente estará disponible para cada usuario?';
$string['reserved_title'] = 'Elemento reservado. Haga clic para liberarlo.';
$string['response'] = 'respuesta';
$string['responseauthor'] = 'Autor:';
$string['responses'] = 'respuestas';
$string['responsetimecreated'] = 'Respuesta enviada en:';
$string['responsetimemodified'] = ', Última midificación en:';
$string['revieworpause'] = ', revisar o pausar';
$string['reviewsubmissions'] = 'Revisar envíos de Surveypro';
$string['riskyeditdeadline'] = 'Fecha límite de sesión de modificación con riesgo';
$string['riskyeditdeadline_help'] = 'Permitir a los usuarios que tienen permitido gestionar elementos de la encuesta forzar modificaciones de esta encuesta, aunque ya estuvieran contestados.';
$string['runreport'] = '<a href="{$a->href}">Ejecutar informe de {$a->reportname}</a>';
$string['save'] = 'Guardar';
$string['saveasnew'] = 'Guardar como nuevo';
$string['savemastertemplates'] = '<a href="{$a}">Guardar plantillas maestras</a>';
$string['saveusertemplates'] = '<a href="{$a}">Guardar plantillas de usuario</a>';
$string['schemavalidationfailed'] = 'La plantilla usa un archivo XML inválido. Por favor verifíquelo';
$string['settings'] = 'Surveypro';
$string['sharinglevel'] = 'Nivel de compartir';
$string['sharinglevel_help'] = 'Elija en qué nivel será compartida su plantilla con otros cursos. Si elige "curso", esta plantilla estará disponible SOLAMENTE en este curso. Si elige categoría de curso, esta plantilla estará disponible SOLAMENTE para cursos que compartan la misma "categoría" de curso con este curso. Si elige "sitio", esta plantilla estará disponible para todos y cada uno de los cursos en esta plataforma.';
$string['showallitems'] = 'Mostrar todos los elementos';
$string['showallsubmissions'] = 'Mostrar todas las respuestas';
$string['showfield_title'] = 'Elemento oculto. Haga clic para mostrar.';
$string['sortindex'] = 'Orden';
$string['specializations'] = 'Configuraciones específicas de {$a}';
$string['star'] = '*';
$string['startyear'] = 'Año mínimo permitido';
$string['startyear_help'] = 'Definir el menor año que cada pregunta requerirá.';
$string['status'] = 'Estado de respuestas';
$string['statusboth'] = 'ambas cerradas y en progreso';
$string['statusclosed'] = 'cerrada';
$string['statusinprogress'] = 'en progreso';
$string['stopyear'] = 'Año máximo permitido';
$string['stopyear_help'] = 'Definir el año más alto que cada pregunta requerirá.';
$string['submission'] = 'Intento';
$string['submissions'] = 'Respuestas';
$string['submissions_all_1_1'] = '1 respuesta enviada por 1 usuario';
$string['submissions_all_1_many'] = '1 respuesta enviada por {$a->usercount} usuarios';
$string['submissions_all_many_1'] = '{$a->submissions} respuestas enviadas por 1 usuario';
$string['submissions_all_many_many'] = '{$a->submissions} respuestas enviadas por {$a->usercount} usuarios';
$string['submissions_detail_1_1'] = '1 respuesta  \'{$a->status}\' enviada por 1 usuario';
$string['submissions_detail_1_many'] = '1 respuesta \'{$a->status}\' enviada por {$a->usercount} usuarios';
$string['submissions_detail_many_1'] = '{$a->submissions} respuestas  \'{$a->status}\' enviadas por 1 usuario';
$string['submissions_detail_many_many'] = '{$a->submissions} respuestas  \'{$a->status}\' enviadas por  {$a->usercount} usuarios';
$string['submissions_welcome'] = 'Vista general de respuestas';
$string['submissionslist'] = 'Lista de respuestas';
$string['surveypro'] = 'encuesta';
$string['surveypro:accessownreports'] = 'Acceder a informes propios';
$string['surveypro:accessreports'] = 'Acceder a informes';
$string['surveypro:accessreserveditems'] = 'Acceder a elementos reservados';
$string['surveypro:addinstance'] = 'Añadir una nueva actividad de encuesta';
$string['surveypro:additems'] = 'Añadir elementos de encuesta';
$string['surveypro:alwaysseeowner'] = 'Ver propietario de respuestas inclusive en encuestas anónimas';
$string['surveypro:applymastertemplates'] = 'Aplicar plantilla maestra';
$string['surveypro:applyusertemplates'] = 'Aplicar plantillas de usuario';
$string['surveypro:deleteotherssubmissions'] = 'Eliminar respuestas de otros usuarios';
$string['surveypro:deleteownsubmissions'] = 'Eliminar respuestas propias';
$string['surveypro:deleteusertemplates'] = 'Eliminar plantillas de usuario';
$string['surveypro:downloadusertemplates'] = 'Descargar plantillas de usuario';
$string['surveypro:duplicateotherssubmissions'] = 'Duplicar respuestas de otros usuarios';
$string['surveypro:duplicateownsubmissions'] = 'Duplicar respuestas propias';
$string['surveypro:editotherssubmissions'] = 'Editar respuestas de otros usuarios';
$string['surveypro:editownsubmissions'] = 'Editar respuestas propias';
$string['surveypro:exportresponses'] = 'Exportar respuestas recolectadas';
$string['surveypro:ignoremaxentries'] = 'Los envíos no están limitados por la configuración de máximas entradas';
$string['surveypro:importresponses'] = 'Importar datos';
$string['surveypro:importusertemplates'] = 'Subir plantillas de usuario';
$string['surveypro:manageitems'] = 'Gestionar elementos de encuesta';
$string['surveypro:manageusertemplates'] = 'Gestionar plantillas de usuario';
$string['surveypro:preview'] = 'Previsualizar una encuesta';
$string['surveypro:savemastertemplates'] = 'Guardar pantilla maestra';
$string['surveypro:savetopdfotherssubmissions'] = 'Descargar a PDF respuestas de otros usuarios';
$string['surveypro:savetopdfownsubmissions'] = 'Descargar envío propio en PDF';
$string['surveypro:saveusertemplates'] = 'Guardar plantillas de usuario';
$string['surveypro:searchsubmissions'] = 'Buscar respuestas';
$string['surveypro:seeotherssubmissions'] = 'Ver respuestas de otros usuarios';
$string['surveypro:submit'] = 'Enviar respuestas';
$string['surveypro:view'] = 'Ver encuestas';
$string['surveypro_dashboard'] = 'Tablero';
$string['surveypro_edit'] = 'Editar respuesta';
$string['surveypro_insert'] = 'Nueva respuesta';
$string['surveypro_readonly'] = 'Solo lectura';
$string['surveypro_responses'] = 'Respuestas';
$string['surveypro_view_search'] = 'Buscar';
$string['surveyprofieldpluginname'] = 'Plugin de elemento Campo';
$string['surveyproformatpluginname'] = 'Plugin de elemento Ítem';
$string['surveyproname'] = 'Nombre de Surveypro';
$string['surveyproname_help'] = 'Elegir el nombre de este surveypro.';
$string['surveyproreportpluginname'] = 'Plugin de informe';
$string['surveyprotemplatepluginname'] = 'Plugin de plantilla maestra';
$string['system'] = 'Sitio';
$string['templatelist'] = 'lista de plantilas disponibles';
$string['templatename'] = 'Nombre de plantilla';
$string['templatename_help'] = 'Escriba aquí el nombre de la plantilla que va a guardar.';
$string['thankspageeditor'] = 'Página de agradecimiento en línea';
$string['thankspageeditor_help'] = 'El código html de lapágina web que el usuario obtiene en cada momento de cierre de respuesta.';
$string['timeclose'] = 'Diaponible hasta';
$string['timeclose_help'] = 'La última fecha disponible para que que los estudiantes llenen una encuesta.';
$string['timecreated'] = 'Creado';
$string['timemodified'] = 'Modificado';
$string['timeopen'] = 'Disponible a partir de';
$string['timeopen_help'] = 'La primera fecha disponible para que los estudiantes llenen una encuesta.';
$string['tools'] = 'Herramientas';
$string['tools_export'] = 'Exportar';
$string['tools_import'] = 'Importar';
$string['top'] = 'superior';
$string['translatedstring'] = '$string[\'{$a->stringkey}\'] = \'Traducción al Inglés de la cadena de caracteres correspondiente del archivo de idioma "{$a->userlang}" \';';
$string['trimonsave'] = 'Limpiar respuesta en el momento de guardar';
$string['trimonsave_help'] = 'Eliminar espacios sobrantes al principio y final de la entrada del usuario.';
$string['typefield'] = 'Campos';
$string['typeformat'] = 'Formatos';
$string['typeplugin'] = 'Tipo';
$string['typeplugin_help'] = 'Esta es la lista de elementos disponibles. Los elementos de la encuesta son de dos tipos: tipo "campo" y tipo "formato". Elija el elemento que mejor se adapte a sus necesidades.';
$string['uerr_willbetrimmed'] = 'Se eliminarán los espacios sobrantes de la respuesta';
$string['unaccesiblepages_note'] = '(Algunas páginas podrían no estar accesibles debido a falta de permisos)';
$string['unavailableelement_title'] = 'Elemento no disponible. Vuelva a mostrarlo para hacerlo disponible.';
$string['unhandledvalue'] = 'Valor no manejado de retorno de {$a}';
$string['unixtime'] = 'hora Unix';
$string['unlimited'] = 'Ilimitados';
$string['unreservable_title'] = 'elemento de acceso libre. No reservable.';
$string['unsearchable_title'] = 'Elemento no se puede buscar. Irrastreable';
$string['user'] = 'Usuario';
$string['usercanceled'] = 'Acción cancelada por el usuario';
$string['userenrolled'] = 'Usuario inscrito: 1';
$string['usersenrolled'] = 'Usuarios inscritos: {$a}';
$string['userstyle'] = 'Hoja de estilo personalizada';
$string['userstyle_help'] = 'Añada aquí una o más hojas de estilo en cascada (css) que quiera aplicar a esta encuesta.';
$string['usertemplateinfo'] = 'Plantillas de usuario';
$string['usertemplateinfo_help'] = 'Elija la plantilla de usuario que desea añadir a su encuesta.';
$string['utemplate'] = 'Plantillas de usuario';
$string['utemplate_apply'] = 'Aplicar';
$string['utemplate_import'] = 'Importar';
$string['utemplate_manage'] = 'Gestionar';
$string['utemplate_save'] = 'Guardar';
$string['utemplatessection'] = 'Sección de plantillas del usuario';
$string['validation'] = 'Opciones de validación';
$string['variable'] = 'Variable';
$string['variable_help'] = 'El nombre de la variable una vez descargada.';
$string['verbose'] = 'Bonito (para lectura por humanos)';
$string['versionmismatch'] = 'No concuerda versión para plugin {$a->plugin} {$a->type}. La plantilla usa la versión: {$a->currentversion} mientras que su plugin surveypro usa la versión {$a->versiondisk}';
$string['visiblesonly'] = 'Solo elementos visibles';
$string['visiblesonly_help'] = 'Incluir en la plantilla solo elementos visibles.';
$string['welcome_dataexport'] = 'Use esta página para exportar respuestas de esta encuesta. <br>Están disponibles tanto en un formato de software estadístico como uno más legible por humanos. El contenido exportable depende del "{$a}" elegido para cada elemento (si estuviera disponible).';
$string['welcome_dataimport'] = 'Use esta página para importar respuestas a esta encuesta.<br>Se espera que los encabezados del archivo CSV a importar coincidan con los "nombres de variables" de los elementos de la encuesta.<br>
Actualmente no está permitida la importación de elementos anexos.<br>Los encabezados desconocidos romperán el proceso de importación.<br>"Ownerid" (ID del propietario) puede ser incluido entre los encabezados. Asignará la propiedad de cada respuesta importada (aunque la encuesta fuese anónima).<br>Si falta la columna de "Ownerid" en el archivo CSV, las respuestas importadas serán automáticamente asignadas al usuario que está ejecutando la importación.<br>
Se permite la importación de archivos CSV a los que les falten elementos requeridos, pero si fueran incluídos, estos deben de poseer valores válidos y no vacíos.<br>Los archivos de importación a los que les falten elementos requeridos están permitidos y las respuestas importadas serán marcadas como "in progress" (en progreso).<br>El proceso de importación se rompe si condujese a exceder el número máximo de respuestas permitidas a los usuarios (si estuviera configurado)';
$string['welcome_emptysurvey'] = 'Para crear una encuesta nueva puede añadir elementos de uno en uno para construir la encuesta que mejor se ajuste a sus necesidades<br>o aplicar una plantilla maestra para tener una encuesta estándar completa en una sola operación.';
$string['welcome_mtemplateapply'] = 'Puede construir su encuesta aplicando un conjunto de elementos tomados de una plantilla maestra.<br>Tenga cuidado: todos los demás elementos preexistentes (si hubiera) serán eliminados definitivamente JUNTO CON TODOS LOS DATOS QUE YA SE HABÍAN RECOGIDO.';
$string['welcome_relationvalidation'] = 'Este informe le permite verificar la confiabilidad de la encuesta actual. Revisa la validez de cada relación padre-hijo, marcando las malas relaciones, que nunca le permitirían al elemento hijo ser parte de la encuesta, con un mensaje en la columna "{$a}".';
$string['welcome_utemplateapply'] = 'Puede construir sus encuestas aplicando un conjunto de elementos tomados de una plantilla maestra.<br>Las plantillas de usuario ya deberían de haberse subido desde la página "{$a->uploadpage}" o haber sido guardadas desde la página  "{$a->savepage}".';
$string['welcome_utemplateimport'] = 'Puede importar plantillas de usuario para aplicarlas después.<br>Las plantillas de usuario son archivos  XML como los que puede guardar desde la página "{$a}".';
$string['welcome_utemplatesave'] = 'Guardar una plantilla de usuario con la estructura de la encuesta actual.<br>Las plantillas de usuario son útiles para añadir rápidamente a su encuesta conjuntos estáticos de ítems predefinidos. En cualquier momento puede descargarlas y compartirlas con otros usuarios de Moodle o reutilizarlas en sus propias encuestas. Sea cuidadoso con el "{$a}" si quiere reutilizar sus plantillas sin descargarlas y subirlas otra vez.';
$string['willclose'] = 'Hora de cierre';
$string['willopen'] = 'Esta encuesta se abrirá en';
$string['wrong_direction_found'] = '$direction inválida proporcionada a {$a->methodname} en conjunto con $startingpage == {$a->startingpage}';
$string['wrong_sharinglevel_found'] = '$sharinglevel = "{$a->sharinglevel}" inválido proporcionado a {$a->methodname}';
$string['wrong_userdatarec_found'] = '$userdatarec = \'{$a}\' inválida no ha sido remplazada';
$string['wrongrelation'] = '"{$a}" nunca coincidirá';
$string['xmltemplate_help'] = 'Elija la plantilla que quiera descargar como archivo ZIP para compartirlo con otros usuarios de Moodle.';
$string['xsdnotfound'] = 'No se encontró esquema de validación XSD para su plantilla XML<br>Su código necesita ser arreglado por un desarrollador.';
$string['yes_deleteallitems'] = 'Eliminar cada elemento';
$string['yes_deletehiddenitems'] = 'Eliminar cada elemento oculto';
$string['yes_deletevisibleitems'] = 'Eliminar cada elemento visible';
$string['yes_hideallitems'] = 'Ocultar cada elemento';
$string['yes_showallitems'] = 'Mostrar cada elemento';
$string['yoursubmissions'] = 'Sus respuestas \'{$a->status}\': {$a->responsescount}';
