<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_exacomp', language 'es', version '4.1'.
 *
 * @package     block_exacomp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['LA_FRI'] = 'VIE';
$string['LA_MON'] = 'LUN';
$string['LA_THU'] = 'JUE';
$string['LA_TUE'] = 'MAR';
$string['LA_WED'] = 'MIÉ';
$string['LA_assessment'] = 'evaluación';
$string['LA_backtoview'] = 'volver a la vista original';
$string['LA_enddate'] = 'fecha final';
$string['LA_from_m'] = 'de';
$string['LA_from_n'] = 'de';
$string['LA_learning'] = '¿Qué puedo aprender?';
$string['LA_no_example'] = 'no hay un ejemplo disponible';
$string['LA_no_learningagenda'] = 'No hay calendario de aprendizaje disponible para esta semana.';
$string['LA_no_student_selected'] = '- no hay estudiantes seleccionados -';
$string['LA_plan'] = 'plan de trabajo';
$string['LA_select_student'] = 'Por favor seleccione un estudiante para ver su agenda de aprendizaje.';
$string['LA_startdate'] = 'fecha de inicio';
$string['LA_student'] = 'Est';
$string['LA_teacher'] = 'Prof';
$string['LA_to'] = 'hasta';
$string['LA_todo'] = '¿Qué hago yo?';
$string['access_roles'] = 'Roles con acceso a webservice';
$string['active_show'] = 'activos (mostrarlos)';
$string['add_competence_insert_learning_progress'] = 'Para insertar una nueva competencia primeramente debe seleccionar o añadir unnivel de dificultad';
$string['add_content_to_crosssub'] = 'El Asunto interdisciplinario todavía está vacío';
$string['add_crosssub'] = 'Crear Asunto interdisciplinario';
$string['add_descriptors_to_crosssub'] = 'Añadir competencia a Asunto interdisciplinario';
$string['add_drafts_to_course'] = 'Añadir borradores al curso';
$string['add_example_for_all_students_to_schedule'] = 'Atención: Aquí Usted puede añadir ejemplos de las agendas de todos los estudiantes. Esto requiere confirmación extra.';
$string['add_example_for_all_students_to_schedule_confirmation'] = 'Usted está a punto de añadir  los ejemplos a las agendas de todos los estudiantes. ¿Quiere continuar?';
$string['add_example_for_group_to_schedule'] = 'Atención: Aquí puede añadir ejemplos a las agendas de todos los estudiantes del grupo seleccionado. Esto requiere confirmación adicional.';
$string['add_example_for_group_to_schedule_confirmation'] = 'Que tal si añade los ejemplos a las agendas de todos los estudiantes de este grupo. ¿desea continuar?';
$string['add_new_importtask'] = 'Añadir un nuevo trabajo de importación';
$string['add_new_taxonomie'] = 'Añadir un nuevo nivel de dificultad';
$string['add_niveau'] = 'Añadir nivel';
$string['admin_config_pending'] = 'La pre-selección de rejillas de competencia necesita ser realizada por el administrador de Moodle';
$string['all_modules'] = 'todas las actividades';
$string['all_students'] = 'todos los estudiantes';
$string['allniveaus'] = 'Todos los niveles de dificultad';
$string['allow_resubmission'] = 'Añadir un nuevo envío para este ejemplo';
$string['allow_resubmission_info'] = 'No está permitido re-enviar el ejemplo.';
$string['allstudents'] = 'Todos los estudiantes';
$string['also_taxonomies_from_import'] = 'También hay niveles de dificultad de la importación';
$string['apply_filter'] = 'aplicar filtro';
$string['assessment_SelfEval_useVerbose'] = 'opciones de retroalimentación verbosa para estudiantes';
$string['assessment_date'] = 'fecha de la evaluación';
$string['assign_dakora_teacher'] = 'asignar profesor para asuntos interdisciplinarios';
$string['assign_descriptor_no_crosssubjects_available'] = 'Ho hay Asuntos interdisciplinarios disponibles.';
$string['assign_descriptor_to_crosssubject'] = 'Asignar la competencia "{$a}" a los siguientes Asuntos-interdisciplinarios:';
$string['assigndone'] = 'tarea hecha:';
$string['assigned_example'] = 'Ejemplo Asignado';
$string['assignments'] = 'Tareas';
$string['associated_activities'] = 'Actividades Moodle Asociadas:';
$string['available_crosssubjects'] = 'Asuntos Interdisciplinarios no publicados';
$string['block_exacomp_elove_student_self_assessment_head'] = 'Permitir auto-evaluación para estudiantes en la App Elove';
$string['block_exacomp_external_trainer'] = 'Entrenador';
$string['block_exacomp_external_trainer_allstudents'] = 'Todos los Estudiantes';
$string['block_exacomp_external_trainer_assign'] = 'Asignar entrenador externo';
$string['block_exacomp_external_trainer_assign_body'] = 'Esto es necesario para usar la App Elove.';
$string['block_exacomp_external_trainer_assign_head'] = 'Permitir asignación de entrenadores externos para estudiantes.';
$string['block_exacomp_external_trainer_student'] = 'Estudiante';
$string['block_exacomp_logging_body'] = 'Las acciones relevantes se anotarán en bitácoras.';
$string['block_exacomp_logging_head'] = 'Activar bitácora';
$string['block_exacomp_notifications_body'] = 'Los usuarios serán notificados después de las acciones relevantes';
$string['block_exacomp_notifications_head'] = 'activar notificaciones';
$string['blocking_event'] = 'Crear evento bloqueador';
$string['blocking_event_create'] = 'Añadir al almacenamiento de planeación';
$string['blocking_event_title'] = 'título';
$string['blocktitle'] = 'Rejilla de competencia';
$string['cachedef_visibility_cache'] = 'Caché para mejorar desempeño mientras se revisan visibilidades';
$string['childcompetencies_compProfile'] = 'Competencias infantiles';
$string['choose_student'] = 'Elegir estudiantes:';
$string['choosecourse'] = 'Seleccionar curso:';
$string['choosecoursetemplate'] = 'Seleccionar curso plantilla:';
$string['choosedaterange'] = 'Elija un rango de fecha:';
$string['choosestudent'] = 'Seleccionar estudiante:';
$string['choosesubject'] = 'Seleccionar asunto:';
$string['choosetopic'] = 'Seleccionar tema';
$string['city'] = 'Ciudad';
$string['cleardaterange'] = 'Borrar rango';
$string['columnselect'] = 'Selección de columna';
$string['comp'] = 'Tema';
$string['comp_-1'] = 'sin información';
$string['comp_-1_short'] = 'si';
$string['comp_0'] = 'no ganado';
$string['comp_0_short'] = 'ng';
$string['comp_1'] = 'parcialmente';
$string['comp_1_short'] = 'pg';
$string['comp_2'] = 'mayoritariamente';
$string['comp_2_short'] = 'mg';
$string['comp_3'] = 'completamente';
$string['comp_3_short'] = 'cg';
$string['comp_based'] = 'ordenar por competencias';
$string['comp_field_idea'] = 'Habilidad';
$string['competence_associations'] = 'Asociaciones';
$string['competence_associations_explaination'] = 'El material {$a} está asociado con los siguientes estándares:';
$string['competence_grid_additionalinfo'] = 'calificación';
$string['competence_grid_niveau'] = 'nivel de dificultad';
$string['competence_locked'] = 'Existe evaluación o material de aprendizaje es usado';
$string['competencegrid_nodata'] = 'En caso que la rejilla de competencias esté vacía, no se podrá asignar al sujeto seleccionado en un nivel en la base de datos. Esto se puede solucionar asociando resultados con niveles en www.edustandars.org y re-importando el archivo xml.';
$string['completed_config'] = 'La configuración de Exabis Competencies está completa.';
$string['comps_and_material'] = 'resultados y ejercicios';
$string['conf_badges'] = 'configurar insignias';
$string['conf_comps'] = 'configurar competencias';
$string['confirm_delete'] = '¿Realmente desea eliminar este Asunto interdisciplinario?';
$string['create_docx'] = 'generar DOCX';
$string['create_docx_report'] = 'generar docx';
$string['create_html'] = 'generar vista previa HTML';
$string['create_html_report'] = 'generar previsualización HTML';
$string['create_new_area'] = 'Área nueva';
$string['create_new_crosssub'] = 'Crear nuevo Asunto interdisciplinario';
$string['create_new_topic'] = 'Nuevo tema';
$string['create_pdf'] = 'generar PDF';
$string['create_pdf_report'] = 'generar PDF';
$string['create_report'] = 'generar informe';
$string['cross_based'] = 'Para Temas Iterdisciplinarios';
$string['crosssubject'] = 'Asunto interdisciplinario';
$string['crosssubject_drafts'] = 'Borrador de Asunto interdisciplinario';
$string['crosssubject_files'] = 'archivos temascruzados';
$string['dakora_string1'] = 'frase en inglés1';
$string['dakora_string2'] = 'frase en inglés2';
$string['dakora_string3'] = 'frase en inglés3';
$string['dakora_teachers'] = 'ProfesoresDakora';
$string['dataerr'] = '¡Se requiere a lo menos un vínculo o archivo!';
$string['de:unittest_string2'] = 'resultados_unittest_frase2';
$string['de:unittest_string3'] = 'resultados_unittest_frase3';
$string['delete_confirmation'] = 'De verdad desea eliminar este ejemplo?';
$string['delete_confirmation_descr'] = '¿Realmente desea eliminar la competencia "{$a}"?';
$string['delete_crosssub'] = 'Eliminar Asunto interdisciplinario';
$string['delete_drafts'] = 'Eliminar borradores seleccionados';
$string['delete_level_from_another_source'] = 'Contenido de otra fuente. Estos solamente pueden ser eliminados por el administrador.';
$string['delete_level_has_children_from_another_source'] = '¡Tiene hijos de otra fuente!';
$string['delete_niveau'] = 'Eliminar nivel';
$string['delete_own'] = 'Eliminar resultados/estándares individuales';
$string['delete_own_confirm'] = '¿Está Usted seguro de querer eliminarlos  resultados/estándares individuales ?';
$string['delete_success'] = 'Los resultados/estándares individuales han sido eliminados';
$string['delete_unconnected_examples'] = 'Si Usted está des-seleccionando tópicos que están asociados con ejemplos usados en la agenda semanal, estos ejemplos serán removidos.';
$string['description'] = 'Descripción';
$string['description_edit_badge_comps'] = 'Aquí puede asociar la insignia seleccionada con resultados.';
$string['description_example'] = 'Descripción';
$string['descriptor'] = 'competencia';
$string['descriptor_add_category'] = 'Añadir nuevo nivel de dificultad:';
$string['descriptor_categories'] = 'Editar nivel de dificultad:';
$string['descriptor_child'] = 'competencia hija';
$string['descriptors'] = 'resultados/estándar';
$string['deselect_all'] = 'des-seleccionar todo';
$string['dest_course'] = 'Destino de actividades importadas';
$string['difficulty_group_report'] = 'nivel de dificultad';
$string['dismiss_gradingisold'] = '¿Desea olvidar esta advertencia?';
$string['display_settings'] = 'mostrar configuraciones';
$string['do_demo_import'] = 'importar datos demostrativos para ver como funciona la rejilla de Competencia Exabis';
$string['doimport'] = 'importar descriptores';
$string['doimport_again'] = 'Importar rejillas de competencia/resultados adicionales';
$string['doimport_own'] = 'importar descriptores propios';
$string['empty_pre_planning_confirm'] = 'Los ejemplos añadidos de todos los profesores son eliminados. ¿Esta seguro de querer hacer esto?';
$string['empty_pre_planning_storage'] = 'Vaciar almacenamiento de planeación';
$string['empty_trash'] = 'Vaciar cesto de basura';
$string['enable_rest'] = 'Protocolo REST no habilitado';
$string['eportitem_notshared'] = '(no compartido)';
$string['eportitem_shared'] = '(compartido)';
$string['eportitems'] = 'Artefactos ePortafolio enviados:';
$string['evaluationdate'] = 'Fecha de la Evaluación';
$string['eventscompetenceassigned'] = 'Competencia asignada';
$string['eventscrosssubjectadded'] = 'Asunto interdisciplinario añadido';
$string['eventsexampleadded'] = 'Ejemplo añadido a agenda semanal';
$string['eventsexamplecommented'] = 'Ejemplo comentado';
$string['eventsexamplegraded'] = 'Ejemplo calificado';
$string['eventsexamplesubmitted'] = 'Ejemplo enviado';
$string['eventsimportcompleted'] = 'Importación completada';
$string['exa_evaluation'] = 'material de aprendizaje';
$string['exacomp:addinstance'] = 'Añadir un bloque de competencias exabis';
$string['exacomp:admin'] = 'vista general de acciones de administrador en un curso';
$string['exacomp:assignstudents'] = 'Asignar entrenadores externos';
$string['exacomp:deleteexamples'] = 'borrar ejemplo';
$string['exacomp:myaddinstance'] = 'Añadir un bloque de competencias exabis a mi Moodle';
$string['exacomp:student'] = 'vista general de acciones de estudiante en un curso';
$string['exacomp:teacher'] = 'vista general de acciones de profesor en un curso';
$string['exacomp:use'] = 'usar Rejilla de Competencia Exabis';
$string['exacomp_not_found'] = 'Exacompservice no encontrado';
$string['examp_based'] = 'ordenar por ejemplos';
$string['example'] = 'Ejemplo';
$string['example_add_taxonomy'] = 'Añadir nueva taxonomía';
$string['example_pool'] = 'Lote de ejemplos';
$string['example_sorting_notice'] = 'Pro favor primeramente guarde los cambios.';
$string['example_submission_header'] = 'Editar ejemplo {$a}';
$string['example_submission_info'] = 'Usted está a punto de editar el ejemplo "{$a}". Su envbío será guardado en Exabis ePortfolio y los profesores podrán verlo allí.';
$string['example_submission_message'] = 'El estudiante {$a->student} entregó un nuevo envío en {$a->course}.';
$string['example_submission_subject'] = 'Envío nuevo';
$string['example_trash'] = 'Cesto de basura';
$string['example_upload_header'] = 'Subir mi propio ejemplo/trabajo';
$string['exaport_not_found'] = 'Exaportservice no encontrado';
$string['existing_crosssub'] = 'asuntos cruzados esistentes en este curso';
$string['explainconfig'] = 'Paa usar el módulo de competencias exabis debe elegir su tipo-de-escuela. Los datos apropiados serán entonces importados a partir del archivo-XML.';
$string['explaineditactivities_subjects'] = 'Aquí puede asociar tareas con descriptores.';
$string['export_all_standards'] = 'Exportar todas las rejillas de competencia de esta instalación Moodle';
$string['export_selective'] = 'Seleccionar rejillas de competencia para exportar';
$string['extern_task'] = 'Trabajo esterno';
$string['filerequired'] = 'Debe seleccionarse un archivo';
$string['files'] = 'Archivos';
$string['filteredtaxonomies'] = 'Los ejemplos son filtrados de acuerdo a las taxonomías siguientes:';
$string['first_configuration_step'] = 'El primer paso de la configuración es importar algunos datos hacia Rejilla de Competencia Exabis.';
$string['from'] = 'de';
$string['globalgradings'] = 'calificaciones globales';
$string['grade_Deficient'] = 'deficiente';
$string['grade_Insufficient'] = 'insuficiente';
$string['grade_Satisfactory'] = 'satisfactoria';
$string['grade_Sufficient'] = 'suficiente';
$string['grade_Verygood'] = 'muy buena';
$string['grade_good'] = 'buena';
$string['grading'] = 'Calificación';
$string['grading_scheme'] = 'esquema de calificación';
$string['groupcategory'] = 'Categoría';
$string['header_edit_mode'] = 'El modo de edición está activado';
$string['help_crosssubject'] = 'La compilación de un asunto es hecha para toda la intalación Moodle (la escuela) usando la pestaña de la ruta de aprendizaje. Auí Usted puede selectivamente desactivar competencias, subcompetencias y materiales específicos-de-curso. El material de aprendizaje individual también puede ser añadido. Esto es entonces añadido automáticamente  a las rutas de aprendizaje.';
$string['hide_solution'] = 'Ocultar solución';
$string['hide_solution_disabled'] = 'La solución ya estaba oculta para todos los estudiantes';
$string['hideevaluation'] = 'Para ocultar auto-evaluación haga  click <a href="{$a}">aquí</a>';
$string['hideevaluation_student'] = 'Para ocultar evaluación del entrenador haga  click <a href="{$a}">aquí</a>';
$string['import_activate_scheduled_tasks'] = 'Activar estos trabajos';
$string['import_activities'] = 'Importar actividaddes desde un curso de plantilla hacia su curso';
$string['import_category_mapping_column_exacomp'] = 'Título niveldificultad Exacomp';
$string['import_category_mapping_column_level'] = 'Nivel';
$string['import_category_mapping_column_level_descriptor'] = 'Competencia / Competencia hija';
$string['import_category_mapping_column_level_example'] = 'Material';
$string['import_category_mapping_column_xml'] = 'Título XML';
$string['import_category_mapping_needed'] = 'Esquema de calificación donde XML es diferente del esquema exacomp. Por favor configure las correlaciones correctamente e intente importar de nuevo.';
$string['import_from_related_komet'] = 'mportar/actualizar desde KOMET relacionado inmediatamente';
$string['import_mapping_as_is'] = 'Usar como está';
$string['import_mapping_delete'] = 'Eliminar';
$string['import_max_execution_time'] = 'Importante: El límite actual en Serversettings limita la Importación a que corra hasta un máximo de {$a} segundos. Si la importación tarda más, no se importarán ningún dato y el navegado puede mostrar "500 Internal Server Error"  (Error 500 Interno del Servidor).';
$string['import_select_file'] = 'Seleccionar archivo:';
$string['import_selectgrids_needed'] = 'Seleccionar asuntos para importación:';
$string['import_source'] = 'Importado desde: {$a}';
$string['import_used_preselected_from_previous'] = 'Si previamente se ha importado un XML, estos valores están pre-seleccionados';
$string['importdone'] = 'los datos han sido importados desde XML';
$string['importfail'] = 'ha ocurrido un error durante la importación';
$string['importinfo'] = 'Por favor cree sus rejillas de competencias en  <a href="http://www.edustandards.org">www.edustandards.org</a> or visit <a href="https://eeducation.at/index.php?id=155&L=0">https://eeducation.at/index.php?id=155&L=0</a>  para descargar un archivo XML existente.';
$string['importpending'] = '¡no se importó ningun dato!';
$string['importsuccess'] = 'los datos fueron importados correctamente!';
$string['importsuccess_own'] = 'los datos propios fueron importados correctamente!';
$string['importtask_all_subjects'] = 'Todos los asuntos';
$string['importtask_disabled'] = 'Deshabilitado';
$string['importtask_title'] = 'Título';
$string['importwebservice'] = 'Es posible mantener los datos actualizados mediante <a href="{$a}">webservice</a>.';
$string['infolink'] = 'Información adicional:';
$string['innersection1'] = 'Vista de rejilla';
$string['innersection2'] = 'Estadísticas';
$string['innersection3'] = 'Comparación: Profesor-Estudiante';
$string['instruction'] = 'Instrucciones';
$string['instruction_content'] = 'Esta es una vista general para recursos educativos que están asociados con estándares y marcar competencias para estudiantes. Los estudiantes pueden valorar sus competencias. Las actividades de Moodle que fueron seleccionadas por estudiantes son mostradas con un ícono rojo. Los artefactos de ePortafolios de estudiantes son mostrados en íconos azules.';
$string['inwork'] = '{$a->inWork}/{$a->total} en trabajo';
$string['isgraded'] = 'El ejemplo ya está calificado y por lo tanto ya no es posible un envío';
$string['legend_activities'] = 'Actividades Moodle';
$string['legend_eportfolio'] = 'ePortfolio';
$string['legend_notask'] = 'No se han enviado actividades/eexámenes para este resultado';
$string['legend_upload'] = 'Suba su propio trabajo/ejemplo';
$string['link'] = 'Enlace';
$string['linkerr'] = '¡El enlace dado no es válido!';
$string['links'] = 'enlaces';
$string['local'] = 'Local';
$string['manage_crosssubs'] = 'Regresar a vista general';
$string['materials_compProfile'] = 'Materiales';
$string['messageprovider:comment'] = 'Comentarios del profesor para un ejemplo';
$string['messageprovider:grading'] = 'Notificar al estudiante que un profesor calificó competencias';
$string['messageprovider:self_assessment'] = 'Estudiante valoró algunas competencias propias';
$string['messageprovider:submission'] = 'Notificarle al profesor que un estudiante ha enviado un ítem';
$string['messageprovider:weekly_schedule'] = 'El profesor añadió ejemplo nuevo a la agenda semanal';
$string['messagetocourse'] = 'Mandar mensaje a todos los estudiantes';
$string['module_filter'] = 'filtrar actividades';
$string['module_used_availabilitycondition_competences'] = 'Otorgar competencias exabis relacionadas cuando se cumpla la condición';
$string['move_down'] = 'Mover abajo';
$string['move_up'] = 'Mover arriba';
$string['my_badges'] = 'Mis Insignias';
$string['my_comps'] = 'Mis Competencias';
$string['mybadges'] = 'Mis insignias';
$string['n1.unit'] = '1. unidad';
$string['n10.unit'] = '10. unidad';
$string['n2.unit'] = '2. unidad';
$string['n3.unit'] = '3. unidad';
$string['n4.unit'] = '4. unidad';
$string['n5.unit'] = '5. unidad';
$string['n6.unit'] = '6. unidad';
$string['n7.unit'] = '7. unidad';
$string['n8.unit'] = '8. unidad';
$string['n9.unit'] = '9. unidad';
$string['name'] = 'Nombre';
$string['name_example'] = 'Nombre';
$string['new'] = 'nuevo';
$string['new_column'] = 'nueva columna';
$string['new_crosssub'] = 'Crear nuevo asunto interdisciplinario';
$string['new_niveau'] = 'Nuevo progreso de aprendizaje';
$string['newer_grading_tooltip'] = 'La calificación podría no estar actualizada. </br> Un descriptorhijo ha sido calificado.';
$string['newsubmission'] = 'Envío Nuevo';
$string['next_step'] = 'Este paso de la configuración ha sido completado. Haga clic aquí para continuar la configuración.';
$string['next_step_first_teacher_step'] = 'Haga clic aquí para continuar la configuración.';
$string['next_step_teacher'] = 'La configuración que tiene que ser hecha por el administrador ahora ya está completada. Para continuar con la configuración específica del curso, haga clic aquí.';
$string['niveau'] = 'Nivel de Dificultad';
$string['niveau_filter'] = 'Filtrar Niveles de dificultad';
$string['niveau_short'] = 'Nivel';
$string['no_activities_selected'] = 'por favor, asocie actividades de Moodle con competencias';
$string['no_activities_selected_student'] = 'Todavía no hay datos disponibles';
$string['no_badges_yet'] = 'no hay insignias disponibles';
$string['no_course_activities'] = 'No se encontraron actividades Moodle en este curso - haga clic aquí para crear algunas.';
$string['no_crosssubjs'] = 'Sin asuntos interdisciplinarios disponibles.';
$string['no_entries_found'] = 'no se encontraron entradas';
$string['no_external_trainer'] = 'Sin entrenadores esternos asignados';
$string['no_permission'] = 'Permisos no configurados';
$string['no_specification'] = 'sin valoraciones';
$string['no_student'] = '-- sin  participantes seleccionados --';
$string['no_student_edit'] = 'modo edición - sin participante';
$string['no_students_crosssub'] = 'Sin estudiantes asignados a este asunto interdisciplinario.';
$string['no_topics_selected'] = 'La configuración de Rejilla de Competencia Exabis aun no está completada. Por favor elija un tópico con el cual a Usted le gustaría asociar actividades Moodle';
$string['nocrosssubsub'] = 'Asuntos Interdisciplinarios Generales';
$string['noschedules_pre_planning_storage'] = 'El almacenamiento de pre-planeación ha sido vaciado; use la rejilla de competencia para poner nuevos ejemplos en el almacenamiento de pre-planeación.';
$string['nostudents'] = 'Sin estudiantes';
$string['notification_example_comment_body'] = 'Estimado/a {$a->receiver}, </br></br>{$a->teacher} comentó en {$a->course} el ejemplo {$a->example}.</br></br> Este mensaje ha sido generado desde el sitio Moodle {$a->site}.';
$string['notification_example_comment_context'] = 'Comentario';
$string['notification_example_comment_subject'] = '{$a->site}: Nuevo comentario para ejemplo {$a->example}';
$string['notification_grading_body'] = 'Estimado/a {$a->receiver}, </br></br>Usted tiene nuevas calificaciones en {$a->course} de {$a->teacher}.</br></br> Este mensaje ha sido generado desde el sitio Moodle {$a->site}.';
$string['notification_grading_context'] = 'Calificación';
$string['notification_grading_subject'] = '{$a->site}: Nueva calificación en curso {$a->course}';
$string['notification_self_assessment_body'] = 'Estimado/a Sr./Sra./Srita. {$a->receiver}, </br></br> {$a->student} tiene nuevas auto-evaluaciones en {$a->course}.</br></br> Este mensaje ha sido generado desde el sitio Moodle {$a->site}.';
$string['notification_self_assessment_context'] = 'auto evaluación';
$string['notification_self_assessment_subject'] = '{$a->site}: Nuevas auto evaluaciones en {$a->course}';
$string['notification_submission_body'] = 'Estimado/a Sr./Sra/Srita {$a->receiver}, </br></br> {$a->student} envió {$a->example} on {$a->date} en {$a->time}. El envío puede verse en ePortfolio: <a href={$a->viewurl}>{$a->example}</a> </br></br> Este mensaje ha sido generado desde el sitio Moodle {$a->site}.';
$string['notification_submission_context'] = 'Envío';
$string['notification_submission_subject'] = '{$a->site}: {$a->student} envió una solución para {$a->example}';
$string['notification_weekly_schedule_body'] = 'Estimado/a {$a->receiver}, </br></br>{$a->teacher} añadió un ejemplo en {$a->course} a la agenda semanal de usted.</br></br> Este mensaje ha sido generado desde el sitio Moodle {$a->site}.';
$string['notification_weekly_schedule_context'] = 'Agenda semanal';
$string['notification_weekly_schedule_subject'] = '{$a->site}: Nuevo ejemplo en la agenda';
$string['noxmlfile'] = 'No hay datos disponibles para importar. Por favor visite <a href="https://github.com/gtn/edustandards">https://github.com/gtn/edustandards</a> para descargar los resultados requeridos al directorio XML del bloque.';
$string['numb'] = 'Número';
$string['number_of_found_students'] = 'número de estudiantes encontrados';
$string['number_of_students'] = 'número de estudiantes';
$string['oldxmlfile'] = 'Usted está empleando un archivo XML obsoleto. Por favor cree nuevos resultados/estándares en <a href="http://www.edustandards.org">www.edustandards.org</a> o visite <a href="http://www.github.com/gtn/edustandards">github.com/gtn/edustandards</a> para descargar un archivo XML disponible al directorio de bloques XML.';
$string['opencomps'] = 'elija sus competencias';
$string['optional_step'] = 'Aun no hay participantes en su curso. Si Usted quiere inscribir algunos por favor use este enlace.';
$string['output_current_assessments'] = 'salida de evaluaciones actuales';
$string['override_notice1'] = 'Esta entrada fue editada por';
$string['override_notice2'] = 'antes. ¿Continuar?';
$string['overview'] = 'Esta es una vista general de todos los estudiantes y las competencias del curso.';
$string['own_additions'] = 'Adiciones curriculares:';
$string['participating_student'] = 'estudiante';
$string['pendingbadges'] = 'Insignias pendientes';
$string['period'] = 'período';
$string['periodselect'] = 'Seleccionar período';
$string['pluginname'] = 'Competencias Exabis';
$string['points_limit_forcourse'] = 'Valor más altopara Puntos';
$string['pre_planning_storage'] = 'Almacenamiento de planeación';
$string['pre_planning_storage_added'] = 'Ejemplo añadido al planeamiento de pre-planeación';
$string['pre_planning_storage_already_contains'] = 'El ejemplo ya está en el almacenamiento de planeación.';
$string['pre_planning_storage_disabled'] = 'Ejemplo oculto no puede añadirse al almacenamiento de planeación.';
$string['print'] = 'Imprimir';
$string['profile_settings_choose_courses'] = 'Al usar Rejilla de Competencia Exabis los entrenadores valoran las competencias de Usted en varios asuntos. Usted puede seleccionar cuales cursos incluir en el perfil de competencia.';
$string['profoundness_0'] = 'no alcanzada';
$string['profoundness_1'] = 'Parcialmente ganada';
$string['profoundness_2'] = 'Completamente ganada';
$string['profoundness_basic'] = 'Competencia básca';
$string['profoundness_description'] = 'Descripción';
$string['profoundness_entirely'] = 'Enteramente  lograda';
$string['profoundness_extended'] = 'Competencia extendida';
$string['profoundness_mainly'] = 'Principalmente lograda';
$string['progress'] = 'Progreso';
$string['ready_to_activate'] = 'Esta insignia está lista para ser activada:';
$string['really_delete'] = '¿Listo para eliminar?';
$string['report_competencefield'] = 'campo de competencia';
$string['report_learniningmaterial'] = 'material de aprendizaje';
$string['report_subject'] = 'estandar educativo';
$string['report_type'] = 'tipo de informe';
$string['reports'] = 'Tipo de informe';
$string['result'] = 'resultado';
$string['save'] = 'cambios fueron exitosos';
$string['save_as_draft'] = 'Guardar asunto interdisciplinario como borrador';
$string['save_changes_competence_evaluation'] = 'Los cambios fueron guardados';
$string['save_crosssub'] = 'Guardar cambios';
$string['save_pre_planning_selection'] = 'Añadir ejemplos seleccionados a agenda semanal de estudiantes seleccionados';
$string['save_selection'] = 'Guardar selección';
$string['save_success'] = 'cambios exitosos';
$string['scheduler_import_settings'] = 'Configuraciones para importación del agendador';
$string['schedulerimport'] = 'Importar trabajos del agendador';
$string['second_configuration_step'] = 'En este paso de la configuración, Usted tiene que pre-seleccionar rejillas de competencia..';
$string['select_all'] = 'seleccionar todos';
$string['select_student'] = 'Por favor, seleccione primeramente un estudiante';
$string['select_student_weekly_schedule'] = 'Por favor seleccione un estudiante para ver su agenda semanal.';
$string['selfEvalVerbose.1'] = 'no aplica';
$string['selfEvalVerbose.2'] = 'generalmente no cierto';
$string['selfEvalVerbose.3'] = 'generalmente aplica';
$string['selfEvalVerbose.4'] = 'verdadero';
$string['selfEvalVerbose.defaultValue_long'] = 'no aplica; realmente falso; realmente aplica; cierto';
$string['selfEvalVerbose.defaultValue_short'] = 'na; rf; ra; c';
$string['selfEvalVerboseExample.1'] = 'sin resolver';
$string['selfEvalVerboseExample.2'] = 'resuelto con ayuda';
$string['selfEvalVerboseExample.3'] = 'resueto independientemente';
$string['selfEvalVerboseExample.defaultValue_long'] = 'no-resuelto; resuelto con ayuda; resuelto independientemente';
$string['selfEvalVerboseExample.defaultValue_short'] = 'nr; ra; ri';
$string['selfevaluation'] = 'auto evaluación';
$string['selfevaluation_short'] = 'AuEva';
$string['seperatordaterange'] = 'a';
$string['settings_addblock_to_newcourse'] = 'Añadir bloque a nuevo curso';
$string['settings_addblock_to_newcourse_description'] = 'El bloque "Rejilla de Competencias Exabis" será añadido a cada nuevo curso automáticamente. La posición del bloque insertado depende del tema Moodle seleccionadowill be added to every new course automatically. Position of inserted block depends on selected Moodle theme';
$string['settings_addblock_to_newcourse_option_left'] = 'a la región Izquierda';
$string['settings_addblock_to_newcourse_option_no'] = 'No';
$string['settings_addblock_to_newcourse_option_right'] = 'A la región Derecha';
$string['settings_addblock_to_newcourse_option_yes'] = 'Si';
$string['settings_additional_grading'] = 'Calificación adaptada';
$string['settings_additional_grading_description'] = 'Calificación limitada de "no ganado(0)" - "completamente ganado(3)"';
$string['settings_admin_preconfiguration_none'] = 'Sin preconfiguración';
$string['settings_admin_scheme'] = 'Configuración Predefinida';
$string['settings_admin_scheme_description'] = 'La calificación puede hacerse en diferentes niveles de dificultad.';
$string['settings_admin_scheme_none'] = 'sin niveles globales de dificultad';
$string['settings_assessment_SelfEval'] = 'Valoración del estudiante';
$string['settings_assessment_SelfEval_verboses'] = 'Verbosas para auto-evaluacion';
$string['settings_assessment_SelfEval_verboses_edit'] = 'editar verbosas';
$string['settings_assessment_SelfEval_verboses_long_columntitle'] = 'Largo';
$string['settings_assessment_SelfEval_verboses_short_columntitle'] = 'corto';
$string['settings_assessment_SelfEval_verboses_validate_error_long'] = 'Títulos largos: hasta 4 entradas, delimitador ";", máximo 20 caracteres por entrda (4 para formato corto)';
$string['settings_assessment_diffLevel'] = 'Nivel de evaluación global';
$string['settings_assessment_diffLevel_options'] = 'Opciones de Nivel de Dificultad';
$string['settings_assessment_diffLevel_options_default'] = 'F,R,D,MD';
$string['settings_assessment_diffLevel_options_description'] = 'lista de Niveles de Dificultad; por ejemplo F,R,D,MD';
$string['settings_assessment_grade_limit'] = 'Valor más alto para calificación';
$string['settings_assessment_grade_limit_description'] = 'calificación de esquema de evaluación, límite para entrada';
$string['settings_assessment_grade_verbose'] = 'calificaciones verbalizadas (ES)';
$string['settings_assessment_grade_verbose_default'] = 'muy buena, buena, satisfactoria, suficiente, deficiente, insuficiente';
$string['settings_assessment_grade_verbose_description'] = 'Valores verbalizados de las calificaciones, separados por comas. El número debe coincidir con el valor de "Calificación más alta"  de arriba. Por ejemplo: Muy bien, Bien, Suficiente, Pobre, Insuficiente';
$string['settings_assessment_points_limit'] = 'Valor más alto para puntos';
$string['settings_assessment_points_limit_description'] = 'puntos del esquema de valoración, límite para entrada';
$string['settings_assessment_scheme_0'] = 'Ninguno';
$string['settings_assessment_scheme_1'] = 'Calificación';
$string['settings_assessment_scheme_2'] = 'Verbosa';
$string['settings_assessment_scheme_3'] = 'Puntos';
$string['settings_assessment_scheme_4'] = 'Si/No';
$string['settings_assessment_target_childcomp'] = 'Competencia hija';
$string['settings_assessment_target_comp'] = 'Competencia';
$string['settings_assessment_target_example'] = 'Material';
$string['settings_assessment_target_subject'] = 'Asunto';
$string['settings_assessment_target_theme'] = 'Tema (inerdisciplinario)';
$string['settings_assessment_target_topic'] = 'Tópico';
$string['settings_assessment_verbose_options'] = 'Opciones Verbosas (ES)';
$string['settings_assessment_verbose_options_default'] = 'no ganada, parcialmente ganada, principalmente ganada, completamente ganada';
$string['settings_assessment_verbose_options_description'] = 'lista de Opciones Verbosas; por ejemplo, no ganada, parcialmente ganada, principalmente ganada, completamente ganada';
$string['settings_assessment_verbose_options_short'] = 'Opciones verbosas (ES) cortas';
$string['settings_assessment_verbose_options_short_default'] = 'Mb, B, Su, Po, In';
$string['settings_assessment_verbose_options_short_description'] = 'lista de Opciones Verbosas; por ejemplo, no ganada, parcialmente ganada, principalmente ganada, completamente ganada';
$string['settings_autotest'] = 'Calificación automática mediante actividades Moodle';
$string['settings_autotest_description'] = 'Las Competencias o Tareas que están asociadas con actividades son ganadas automáticamente si se alcanza el requerimiento de finalización de la actividad.';
$string['settings_configxmlserverurl'] = 'URL es un archivo XML, el cual es usado para mantener las entradas de la base de datos actualizadas';
$string['settings_default_de_value'] = 'valor DE';
$string['settings_disable_js_assign_competencies'] = 'deshabilitar JS en la selección del estudiante en la página de "Rejilla de competencia"';
$string['settings_disable_js_assign_competencies_description'] = 'Si la "Rejilla de competencia" tiene un tiempo muy largo de generación de página, esta casilla podría resolver este problema.';
$string['settings_example_autograding'] = 'valoración automática de materiales paternos';
$string['settings_example_autograding_description'] = 'Cuando todos los ejemplos hijos hayan sido calificados,  el material paterno debería de ser valorado automáticamente.';
$string['settings_explanation_tooltipp'] = 'Los resultados del informe de grupo se reducen por los filtros de arriba a abajo pero no de abajo a arriba.
P.ej., si está activo un filtro simple "dificultad nivel G" entonces este será el resultado:
- todos los estándares educativos
- todos los campos de competencias
- competencias filtradas por el nivel de dificultad G y
- competencias hijas de las que tienen nivel de dificultad G.';
$string['settings_heading_apps'] = 'Configuración para Apps';
$string['settings_heading_assessment'] = 'Evaluación';
$string['settings_heading_general'] = 'General';
$string['settings_heading_performance'] = 'desempeño';
$string['settings_heading_performance_description'] = 'Intente cambiar estos parámetros si algunas páginas funcionan muy lentamente. Puede haber cambios en visualización/sabilidad.';
$string['settings_heading_scheme'] = 'Esquema de evaluación genérico';
$string['settings_heading_technical'] = 'Administrativo';
$string['settings_heading_visualisation'] = 'Visualización';
$string['settings_interval'] = 'Duración de la unidad';
$string['settings_interval_description'] = 'Duración de las unidades en la agenda';
$string['settings_new_app_login'] = 'Usar App-Ingreso SSO';
$string['settings_new_app_login_description'] = 'El nuevo App-Ingreso le permite a los usuarios el ingresar con todos los plugins para ingreso de Moodle. Esta configuración no es compatible con el plugin de ludificación (gamification).';
$string['settings_periods'] = 'Entradas del horario';
$string['settings_periods_description'] = 'La agenda semanal puede ser adaptada a cualquier horario. Use una fila en el área de texto para cada entrada de hora. Usted puede usar cualquier formato que prefiers, como por ejemplo "1a hora" o  "07:30 - 09:00".';
$string['settings_schedulebegin'] = 'Principio de agenda';
$string['settings_schedulebegin_description'] = 'Tiempo de inicio para la primera unidad en la agenda. Formato hh:mm';
$string['settings_scheduleunits'] = 'Cantidad de unidades';
$string['settings_scheduleunits_description'] = 'Cantidad de unidades en la agenda';
$string['settings_sourceId'] = 'ID del origen';
$string['settings_sourceId_description'] = 'ID generada automáticamente de esta instalación Exacomp. Esta ID no puede ser cambiada';
$string['settings_testlimit'] = 'Porcentaje-del-examen necesario para ganar competencia';
$string['settings_testlimit_description'] = 'Este porcentaje tiene que alcanzarse para ganar la competencia';
$string['settings_usebadges'] = 'Conectar con Insignias Moodle';
$string['settings_usebadges_description'] = 'Activar para asociar insignias con competencias';
$string['settings_xmlserverurl'] = 'URL del servidor';
$string['share_crosssub'] = 'Compartir asunto interdisciplinario con participantes';
$string['share_crosssub_for_further_use'] = 'Compartir el asunto interdisciplinario con estudiantes.';
$string['share_crosssub_with_all'] = 'Compartir el asunto interdisciplinario "{$a}" con todos los participantes:';
$string['share_crosssub_with_students'] = 'Compartir el asunto interdisciplinario "{$a}" con los siguientes participantes:';
$string['show_all_course_examples'] = 'Mostrar ejemplos de todos los cursos';
$string['show_all_descriptors'] = 'Mostrar todos los resultados en vista general';
$string['show_all_taxonomies'] = 'Todas las taxonomías';
$string['show_course_crosssubs'] = 'Mostrar asuntos interdisciplinarios usados';
$string['show_solution'] = 'Mostrar solución';
$string['showevaluation'] = 'Para mostrar auto-evaluación, hacer clic <a href="{$a}">aquí</a>';
$string['showevaluation_student'] = 'Para mostrar evaluación-por-entrenador, hacer clic <a href="{$a}">aquí</a>';
$string['solution'] = 'Solución';
$string['sorting'] = 'elegir ordenamiento:';
$string['specificcontent'] = 'prioridades específicas-del-sitio';
$string['statistic'] = 'Vista general';
$string['statistic_type_descriptor'] = 'Cambiar a estadísticas descritoras';
$string['statistic_type_example'] = 'Cambiar a estadísticas ejemplo';
$string['student'] = 'Estudiante';
$string['student_assessment'] = 'evaluación del estudiante';
$string['students_competences'] = 'competencias del estudiante';
$string['studentshortcut'] = 'Est';
$string['subject'] = 'asunto';
$string['subject_singular'] = 'Campo de competencia';
$string['submission'] = 'Envío';
$string['submissionmissing'] = 'Debe enviarse al menos un enlace o archivo';
$string['submit_example'] = 'Enviar';
$string['tab_admin_configuration'] = 'Pre-selección de rejillas de competencia';
$string['tab_admin_import'] = 'Importar/Exportar';
$string['tab_admin_settings'] = 'Configuraciones Administrativas';
$string['tab_admin_taxonomies'] = 'Niveles de dificultad';
$string['tab_badges'] = 'Mis insignias';
$string['tab_competence_overview'] = 'Rejilla de Competencia';
$string['tab_competence_profile'] = 'Perfil de Competencia';
$string['tab_competence_profile_profile'] = 'Perfil';
$string['tab_competence_profile_settings'] = 'Configuraciones';
$string['tab_cross_subjects'] = 'Asuntos Interdisciplinarios';
$string['tab_cross_subjects_course'] = 'Asuntos Interdisciplinarios del Curso';
$string['tab_cross_subjects_overview'] = 'Vista General';
$string['tab_examples'] = 'Ejemplos y trabajos';
$string['tab_group_reports'] = 'Informes de grupo';
$string['tab_help'] = 'Ayuda';
$string['tab_profoundness'] = 'Competencias Básicas y Extendidas';
$string['tab_student_all'] = 'Todas las competencias ganadas';
$string['tab_teacher_report_annex'] = 'Anexar';
$string['tab_teacher_report_annex_delete_template'] = 'eliminar';
$string['tab_teacher_report_annex_template'] = 'plantilla docx';
$string['tab_teacher_report_annex_title'] = 'Anexo al informe de progreso educativo';
$string['tab_teacher_report_general'] = 'Informe general';
$string['tab_teacher_report_profoundness'] = 'Competencias básicas y extendidas';
$string['tab_teacher_report_profoundness_title'] = 'Competencias básicas y extendidas';
$string['tab_teacher_settings'] = 'Configuraciones';
$string['tab_teacher_settings_assignactivities'] = 'Asignar actividades Moodle';
$string['tab_teacher_settings_badges'] = 'Editar insignias';
$string['tab_teacher_settings_configuration'] = 'Configuración';
$string['tab_teacher_settings_new_subject'] = 'Crear nuevo asunto';
$string['tab_teacher_settings_selection'] = 'Selección de asunto';
$string['tab_teacher_settings_selection_st'] = 'Selección de tipo-de-escuela';
$string['tab_teacher_settings_taxonomies'] = 'Niveles de dificultad';
$string['tab_weekly_schedule'] = 'Agenda Semanal';
$string['task_example'] = 'Trabajos';
$string['taxonomies'] = 'taxonomías';
$string['taxonomy'] = 'Taxonomía';
$string['taxonomy_was_deleted'] = 'Nivel de dificultad fue eliminado';
$string['teacher'] = 'Profesor';
$string['teacher_assessment'] = 'evaluación del profesor';
$string['teacher_first_configuration_step'] = 'El primer paso en la configuración del curso es ajustar configuraciones generales para su curso.';
$string['teacher_second_configuration_step'] = 'Een el segundo paso de la configuración tienen que seleccionarse los tópicos en los cuales trabajar.';
$string['teacher_third_configuration_step'] = 'El paso siguiente es asociar actividades de Moodle con competencias';
$string['teacher_tipp'] = 'sugerencia';
$string['teacher_tipp_1'] = 'Esta competencia ha sido asociada con';
$string['teacher_tipp_2'] = 'Las actividades Moodle se han alcanzado con';
$string['teacher_tipp_3'] = 'resultados.';
$string['teacherevaluation'] = 'evaluación del entrenador';
$string['teacherevaluation_short'] = 'Prof';
$string['teachershortcut'] = 'P';
$string['textalign'] = 'Alternar alineación del texto';
$string['tick_some'] = '¡Por favor, haga una selección!';
$string['timeline_available'] = 'Disponible';
$string['titlenotemtpy'] = 'Se necesita un nombre.';
$string['to'] = 'para';
$string['to_award'] = 'Para otorgar esta insignia en exacomp Usted tiene que configurar competencias';
$string['to_award_role'] = 'Para otorgar esta insignia en exacomp Usted tiene que añadir el criterio "Expedición manual por rol"';
$string['to_weekly_schedule'] = 'Hacia agenda semanal';
$string['topic'] = 'Tópico';
$string['topic_3dchart'] = 'Gráfica 3D';
$string['topic_3dchart_empty'] = 'Sin calificaciones disponibles';
$string['total'] = 'total';
$string['total_example'] = 'Ejemplo Completo';
$string['unittest_string'] = 'result_unittest_frase';
$string['unknown_src'] = 'Origen desconocido';
$string['unload_notice'] = '¿Está seguro? Los cambios no guardados se perderán.';
$string['use_available_crosssub'] = 'USar borrador para crear nuevo asunto interdisciplinario:';
$string['use_grade_verbose_competenceprofile'] = 'calificaciones verbosas perfil de competencia';
$string['use_grade_verbose_competenceprofile_descr'] = 'usar calificaciones verbosas en perfil de competencia';
$string['use_isglobal'] = 'curso global';
$string['usenostudents'] = 'Usar sin estudiantes';
$string['usenumbering'] = 'Habilitar numeración automática en la rejilla de competencia';
$string['useprofoundness'] = 'Usar competencias básicas y eextendidas';
$string['usernosubmission'] = 'no ha enviado ninguna tarea asociada con este descriptor';
$string['uses_activities'] = 'Yo trabajo con actividades Moodle';
$string['usesubjectgrading'] = 'Habilitar calificaciones de asunto';
$string['usetopicgrading'] = 'Habilitar calificaciones de tópico';
$string['value_not_allowed'] = 'Error: Los valores necesitan ser números entre 1.0 y 6.0';
$string['value_too_large'] = 'Error: Valores arriba de {limit} no están permitidos';
$string['value_too_low'] = 'Error: Valores abajo de 1.0 no están permitidos';
$string['warning_use_activities'] = 'Advertencia: Usted está ahora trabajando con actividades de Moodle que están asociadas con competencias. Por favor verifique que que sean usados los mismos resultados de antes.';
$string['weekly_schedule'] = 'Agenda semanal';
$string['weekly_schedule_added'] = 'Ejemplo añadido a la agenda semanal';
$string['weekly_schedule_added_all'] = 'Ejemplo añadido a la agenda semanal de todos los eestudiantes.';
$string['weekly_schedule_already_existing_for_one'] = 'El ejemplo ya ha sido añadido al menos a una agenda semanal de estudiante.';
$string['weekly_schedule_already_exists'] = 'El ejeemplo ya está en la agenda semanal';
$string['weekly_schedule_disabled'] = 'Eejemplo oculto no puede ser añadido a agenda semanal';
$string['weekly_schedule_link_to_grid'] = 'Para añadir ejemplos a la agenda, por favor use la vista general';
$string['yes_no_No'] = 'No';
$string['yes_no_Yes'] = 'Si';
