<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_learnr', language 'sr_cr', version '4.1'.
 *
 * @package     theme_learnr
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconcoloradministrationsetting'] = 'Боја иконице активности за ”Администрација”';
$string['activityiconcoloradministrationsetting_desc'] = 'Боја иконице активности за ”Администрација”';
$string['activityiconcolorassessmentsetting'] = 'Боја иконице активности за ”Процена”';
$string['activityiconcolorassessmentsetting_desc'] = 'Боја иконице активности за ”Процена”';
$string['activityiconcolorcollaborationsetting'] = 'Боја иконице активности за ”Сарадња”';
$string['activityiconcolorcollaborationsetting_desc'] = 'Боја иконице активности за ”Сарадња”';
$string['activityiconcolorcommunicationsetting'] = 'Боја иконице активности за ”Комуникација”';
$string['activityiconcolorcommunicationsetting_desc'] = 'Боја иконице активности за ”Комуникација”';
$string['activityiconcolorcontentsetting'] = 'Боја иконице активности за ”Садржај”';
$string['activityiconcolorcontentsetting_desc'] = 'Боја иконице активности за ”Садржај”';
$string['activityiconcolorinterfacesetting'] = 'Боја иконице активности за ”Интерфејс”';
$string['activityiconcolorinterfacesetting_desc'] = 'Боја иконице активности за ”Интерфејс”';
$string['activityiconcolorsheading'] = 'Боје иконица активности';
$string['activitynavigation'] = 'Навигација кроз активности';
$string['activitynavigationsetting'] = 'Елементи навигације кроз активности';
$string['activitynavigationsetting_desc'] = 'Са овим подешавање елементи за прелазак на претходну и следећу активност/ресурс, као и падајући мени за прелазак на одређену активност/ресурс ће бити приказани. Овакви елементи корисничког интерфејса су већ постојали у Boost теми у основној инсталацији Moodlea све до верзије Moodle 3.11, али су уклоњени у верзији 4.0. Са темом LearnR, можете вратити ове елементе.';
$string['additionalresourcesfileurlpersistent'] = 'URL адреса (трајна)';
$string['additionalresourcesfileurlrevisioned'] = 'URL адреса (ревидирана)';
$string['additionalresourcesheading'] = 'Додатни ресурси';
$string['additionalresourceslistsetting'] = 'Списак додатних ресурса';
$string['additionalresourceslistsetting_desc'] = 'Ово је списак датотека које сте поставили у поље за датотеке додатних ресурса. Наведене URL адресе се могу користити како бисте линкове као овим датотекама употребили у свом прилагођеном CSS опису стилова, у фусноти или где год је потребно да користите постављене датотеке, а где директно постављање датотека није могуће.';
$string['additionalresourcessetting'] = 'Додатни ресурси';
$string['additionalresourcessetting_desc'] = 'Са овим подешавањем можете да поставите додатне ресурсе у тему. Предност постављање датотека у ову поље за датотека је у томе што се оне могу испоручити без провере да ли је корисник пријављен. То је и разлог зашто треба да додајете само датотеке које нису критичне. Свима треба да буде дозвољен приступ који  не треба да буде заштићен валидном пријавом. Чим поставите барем једну датотеку у ово поље за датотеке и сачувате подешавања, у наставку ове странице ће се појавити списак који ће вам дати URL адресу коју можете користити за повезивање са одговарајућом датотеком.';
$string['backgroundimagesetting'] = 'Позадинска слика';
$string['backgroundimagesetting_desc'] = 'Овде можете да поставите прилагођену слику која ће бити приказана као позадина сајта. Позадинска слика коју овде поставите ће заменити позадинску слику у вашим датотекама  са предефинисаним подешавањима теме.';
$string['backgroundimagesheading'] = 'Опште позадинске слике';
$string['backtotop'] = 'Повратак на врх';
$string['backtotopbuttonsetting'] = 'Дугме \'Повратак на врх\'';
$string['backtotopbuttonsetting_desc'] = 'Са овим подешавањем, дугме за повратак на врх ће се појавити у доњем десном углу странице чим корисник скролује страницу надоле. Овакво дугме је већ постојало у Boost графичкој теми у Moodle основној инсталацији све до верзије Moodle 3.11, али је уклоњено у верзији 4.0. Уз LearnR, можете повратити ово дугме.';
$string['bgdark'] = 'Тамна боја навигационе траке';
$string['bgdark_desc'] = 'Мења вредност класе .bg-dark class.';
$string['bgwhite'] = 'Светла боја навигационе траке';
$string['bgwhite_desc'] = 'Мења вредност класе .bg-white class.';
$string['blockregionoutsidebottomwidth'] = 'Ширина региона блокова за регион \'Споља (доле)\'.';
$string['blockregionoutsidebottomwidth_desc'] = 'Са овим подешавањем можете подесити ширину региона блокова \'Споља (доле)\' који се приказује испод главног садржаја. Можете бирати између пуне ширине, ширине садржаја курса и ширине читавог екрана.';
$string['blockregionoutsideleftwidth'] = 'Ширина региона блокова за регион \'Споља (лево)\'.';
$string['blockregionoutsideleftwidth_desc'] = 'Са овим подешавањем можете подесити ширину региона блокова \'Споља (лево)\'. који се приказају лево од главног садржаја. Подразумевано, LearnR користи ширину од 300 пиксела. Можете да унесете друге вредности засноване на пикселима као што је 200 пиксела, али такође можете да унесете вредност засновану на процентима као што је 10% или вредност ширине оквира за приказ (viewport) као што је 10vw.';
$string['blockregionoutsiderightwidth'] = 'Ширина региона блокова за регион \'Споља (десно)\'.';
$string['blockregionoutsiderightwidth_desc'] = 'Са овим подешавањем можете подесити ширину региона блокова \'Споља (десно)\'. који се приказају десно од главног садржаја. Подразумевано, LearnR користи ширину од 300 пиксела. Можете да унесете друге вредности засноване на пикселима као што је 200 пиксела, али такође можете да унесете вредност засновану на процентима као што је 10% или вредност ширине оквира за приказ (viewport) као што је 10vw.';
$string['blockregionoutsidetopwidth'] = 'Ширина региона блокова за регион \'Споља (горе)\'.';
$string['blockregionoutsidetopwidth_desc'] = 'Са овим подешавањем можете подесити ширину региона блокова \'Споља (горе)\' који се приказује на самом врху странице. Можете бирати између пуне ширине, ширине садржаја курса и ширине читавог екрана.';
$string['blockregionsforlayout'] = 'Додатни региони блокова за страницу типа \'{$a}\'';
$string['blockregionsforlayout_desc'] = 'Са овим подешавањем можете да омогућите додатне регионе блокова за страницу типа \'{$a}\'';
$string['blockregionsheading'] = 'Додатни региони блокова';
$string['blockregionsheading_desc'] = '<p>LearnR пружа велики број додатних региона за блокове који се могу користити за додавање и приказивање блокова на читавој Moodle страници:</p>
<ul><li><em>Спољни региони блокова</em> постављени су на све четири стране Moodle странице. Могу се користити за приказивање блокова који прате приказану Moodle страницу, али директно не припадају главном садржају.</li>
<li><em>Регион блокова заглавља</em> се налази између региона Споља (горе) и главног садржаја странице. Може се користити за приказивање блока као информације у заглављу курса.</li>
<li><em>Региони блокова садржаја</em> се постављају директно изнад и испод главног садржаја у региону главног садржаја. Могу се користити за додавање блокова у сам ток садржаја курса.</li>
<li><em>Региони блокова подножја</em> налазе се на дну странице између региона Споља (доле) и фусноте. Имате на располагању три региона подножја за прављење стубаца са блоковима ако је потребно.</li>
<li>The <em>Регион блокова ”Ван странице”</em> је нека врста  специјалног региона јер се приказује преко целе Moodle странице као фиока. Фиока се отвара помоћу специјалне иконице од 9 тачака (три реда са по три тачкице) смештене у самом горњем десном углу навигационе траке. На располагању су вам три оваква региона за креирање стубаца са блоковима уколико је то потребно</li></ul>
<p>Молимо вас да обратите пажњу:</p>
<ul><li>Стандардно, сви додатни региони блокова су онемогућени. Омогућите поједине регионе блокова на одређеним врстама страницама у складу са својим потребама. Покушајте да будете што је могуће више фокусирани – превише региона блокова може довести до непотребне дистракције крајњих корисника.</li>
<li>Чим се омогући додатни регион блокова, он постаје видљив свим ауторизованим корисницима, а могу га уређивати предавачи и менаџери (наравно, у зависности од чињенице да ли је одређеном кориснику дозвољено да уређује одређену Moodle страницу). Али постоје и могућности  theme/learnr:viewregion* и theme/learnr:editregion* који вам омогућавају да фино подесите употребу сваког региона са блоковима зависно од ваших потреба.</li>
<li>Региони блокова Споља (лево), Споља (десно), Садржај (горњи), Садржај (доњи) и Заглавље нису доступни за све врсте страница.</li></ul>';
$string['blockregionsheading_experimental'] = 'Имајте на уму: <em>региони блокова Споља (лево) и Споља (десно) </em> у потпуности функционишу у тренутном стању имплементације, али се морају <em>сматрати као експериментални</em> пошто се још увек не приказују правилно на екранима средње ширине Имајући ово у виду, користите их пажљиво. Овај проблем ће бити решен у наредној верзији графичке теме.';
$string['blocksgeneralheading'] = 'Општи блокови';
$string['blockstab'] = 'Блокови';
$string['bodybg'] = 'Боја позадине тела странице';
$string['bodybg_desc'] = 'Промените боју позадине тела странице.';
$string['bootstrapcolordangersetting'] = 'Bootstrap боја за "Опасност"';
$string['bootstrapcolordangersetting_desc'] = 'Bootstrap боја за "Опасност"';
$string['bootstrapcolorinfosetting'] = 'Bootstrap боја за "Инфо"';
$string['bootstrapcolorinfosetting_desc'] = 'Bootstrap боја за "Инфо"';
$string['bootstrapcolorsheading'] = 'Bootstrap боје';
$string['bootstrapcolorsuccesssetting'] = 'Bootstrap боја за "Успех"';
$string['bootstrapcolorsuccesssetting_desc'] = 'Bootstrap боја за "Успех"';
$string['bootstrapcolorwarningsetting'] = 'Bootstrap боја за "Упозорење"';
$string['bootstrapcolorwarningsetting_desc'] = 'Bootstrap боја за "Упозорење"';
$string['bootstrapdangercolor'] = 'Боја опасности';
$string['bootstrapdarkcolor'] = 'Тамна боја';
$string['bootstrapinfocolor'] = 'Инфо боја';
$string['bootstraplightcolor'] = 'Светла боја';
$string['bootstrapnone'] = 'Без Bootstrap боје';
$string['bootstrapprimarycolor'] = 'Примарна боја';
$string['bootstrapsecondarycolor'] = 'Секундарна боја';
$string['bootstrapsuccesscolor'] = 'Боја успеха';
$string['bootstrapwarningcolor'] = 'Боја упозорења';
$string['brandcolorsheading'] = 'Бренд боје';
$string['brandingtab'] = 'Брендирање';
$string['cachedef_flavours'] = 'Визуелни идентитети који се примењују на дату ID ознаку категорије странице за тренутног корисника';
$string['cachedef_fontawesome'] = 'FontAwesome датотеке (које су постављене у LearnR подешавањима)';
$string['choosereadme'] = '<p>Графичка тема LearnR је у потпуности инспирисанa темама LearnR и Fordson. Одликују је изванредне карактеристике, побољшања корисничког искуства (UX) и бројне функционалности. Да бисмо ствари подигли на виши ниво, уградили смо многе карактеристике, стилове и најпопуларније функционалности теме Fordson.</p><p>LearnR тему одржава<br />Moodle an Hochschulen e.V.,</p><p>у сарадњи са<br />lern.link GmbH</p><p>заједно са<br />bdecent GmbH</p>';
$string['closeoffcanvas'] = 'Затвори фиоку ”Ван странице”';
$string['configtitle'] = 'LearnR';
$string['configtitlecontent'] = 'Садржај';
$string['configtitlefeel'] = 'Навигација & Блокови';
$string['configtitleflavours'] = 'Визуелни идентитети';
$string['configtitlefunctionality'] = 'Функционалност';
$string['configtitlelook'] = 'Изглед';
$string['contactcontentsetting'] = 'Садржај странице за контакт';
$string['contactcontentsetting_desc'] = 'У овом подешавању можете додати садржај у формату обогаћеног текста који ће бити приказан на страници за (што није исто што и стандардна Moodle страница \'Контактирајте подршку сајта\').';
$string['contactdisabled'] = 'Страница за контакт је онемогућена на овом сајту. Овде нема шта да се види.';
$string['contactheading'] = 'Контакт';
$string['contactlinkpositionboth'] = 'Додајте линк ка страници за контакт у фусноту и на иконицу у подножју (знак питања).';
$string['contactlinkpositionfooter'] = 'Додајте линк ка страници за контакт на иконицу у подножју (знак питања).';
$string['contactlinkpositionfootnote'] = 'Додајте линк ка страници за контакт у фусноту';
$string['contactlinkpositionnone'] = 'Немојте аутоматски приказивати линк ка страници за контакт';
$string['contactlinkpositionsetting'] = 'Позиција линк ка страници за контакт';
$string['contactlinkpositionsetting_desc'] = 'У овом подешавању можете да конфигуришете да ли ће се линк ка страници за контакт аутоматски додати на Moodle страницу. Ако не желите да аутоматски приказујете линк, можете ручно додати линк ка {$a->url} са било ког места у Moodleu.';
$string['contactpagetitledefault'] = 'Контакт';
$string['contactpagetitlesetting'] = 'Наслов странице за контакт';
$string['contactpagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов странице за контакт. Овај текст ће се такође користити као текст линка ка страници за контакт ако у складу са тим конфигуришете подешавање \'Позиција линка ка страници за контакт\'.';
$string['contentwidthheading'] = 'Ширина садржаја';
$string['courseactivitiesbtntext'] = 'Активности на курсу';
$string['courseblockpanelbtn'] = 'Управљање курсом';
$string['courseblockpanelbtnclose'] = 'Затвори';
$string['courseboxheight'] = 'Висина плочице курса';
$string['courseboxheight_desc'] = 'Контролишите висину плочице курса на насловној страни и на страници категорије курсева.';
$string['coursecontentmaxwidthsetting'] = 'Максимална ширина садржаја курса';
$string['coursecontentmaxwidthsetting_desc'] = 'Са овим подешавањем, можете изменити ширину садржаја Moodle курса без ручних измена SCSS скупа стилова. Ова ширина се користи као ширина странице на страницама курса и у оквиру неколико активности. Стандардно, Moodle користи максималну ширину садржаја курса од 830 пиксела. Можете да унесете друге вредности засноване на пикселима као што је 1200 пиксела, али такође можете да унесете вредност засновану на процентима као што је 100% или вредност ширине оквира за приказ (viewport) као што је 90vw.';
$string['courseenrollmentcode'] = 'Кôд за упис на курс';
$string['courseheaderheading'] = 'Заглавље курса';
$string['courseheaderimageenabled'] = 'Прикажите слику курса у заглављу курса';
$string['courseheaderimageenabled_desc'] = 'Када је омогућена ова опција, слика курса (која се може поставити у подешавањима курса) је приказана, како у заглављу курса, исто тако и на страници \'Моји курсеви\' где су увек слике курсева и приказају.';
$string['courseheaderimagefallback'] = 'Резервна слика заглавља курса';
$string['courseheaderimagefallback_desc'] = 'Ако поставите слику у овом подешавању, она ће се користи као резервна слика и биће приказана се у заглављу курса ако слика курса није постављена у подешавањима неког курса. Ако пак овде не поставите слику, слика заглавља курса ће бити приказана само у одређеном курсу уколико је слика курса учитана у подешавањима овог конкретног курса.';
$string['courseheaderimageheight'] = 'Висина слике заглавља курса';
$string['courseheaderimageheight_desc'] = 'Са овим подешавањем контролишете висину приказане слике заглавља курса.';
$string['courseheaderimagelayout'] = 'Изглед слике заглавља курса';
$string['courseheaderimagelayout_desc'] = 'Са овим подешавањем контролишете изглед слике заглавља курса и наслова курса.';
$string['courseheaderimagelayoutheadingabove'] = 'Наслов курса изнад слике курса';
$string['courseheaderimagelayoutstackeddark'] = 'Наслов курса преко слике курса (бела боја фонта за тамне позадинске слике)';
$string['courseheaderimagelayoutstackedlight'] = 'Наслов курса преко слике курса (црна боја фонта за светле позадинске слике)';
$string['courseheaderimageposition'] = 'Позиција слике заглавља курса';
$string['courseheaderimageposition_desc'] = 'Са овим подешавањем контролишете позиционирање слике унутар контејнера слике заглавља курса. Прва вредност је хоризонтални а друга вертикални положај.';
$string['coursemanagementbutton'] = 'Управљање курсом';
$string['coursemanagetitle'] = 'Курс';
$string['courserelatedhintsheading'] = 'Савети везани за курс';
$string['coursestab'] = 'Курсеви';
$string['coursestyle1'] = 'Стил плочица један';
$string['coursestyle2'] = 'Стил плочица два';
$string['coursestyle3'] = 'Стил плочица три';
$string['coursestyle4'] = 'Стил плочице четири са резимеом курса';
$string['coursestyle5'] = 'Хоризонтални стил један';
$string['coursestyle6'] = 'Хоризонтална позадинска слике са свим детаљима';
$string['coursestyle7'] = 'Хоризонтална позадинска слике само са насловом и именима предавача';
$string['coursestyle8'] = 'Стандардни приказ Moodle курса';
$string['coursetab'] = 'Курс';
$string['coursetilestyle'] = 'Приказ плочица курсева';
$string['coursetilestyle_desc'] = 'Када гледате категорије курсева, можете бирати између следећих стилова за приказ курсева на почетној страници и у подручју категорија курсева.';
$string['createinfo'] = 'Специјално дугме за креирање курса';
$string['createinfodesc'] = 'Ово дугме се појављује на почетној страници када корисник може да креира нове курсеве. Дугме ће видети они са улогом креатора курса на нивоу сајта.';
$string['cssh5pheading'] = 'Необрађени CSS за H5P';
$string['cssh5psetting'] = 'Необрађени CSS за H5P';
$string['cssh5psetting_desc'] = 'Користите ово поље како бисте навели CSS кôд који ће модули mod_h5p и mod_hvp применити на презентацију H5P садржаја. Прегледајте H5P типове садржаја како бисте пронашли потребне CSS селекторе.';
$string['customfontsfileurlpersistent'] = 'URL адреса (трајна)';
$string['customfontsfileurlrevisioned'] = 'URL адреса (ревидирана)';
$string['customfontsheading'] = 'Прилагођени фонтови';
$string['customfontslistsetting'] = 'Списак прилагођених фонтова';
$string['customfontslistsetting_desc'] = 'Ово је списак фонтова које сте поставили у поље за датотеке прилагођених фонтова. Дати CSS одломци кôда се могу користити за додавање ових фонтова у ваш прилагођени SCSS. Имајте на уму да ћете за сада морати сами да водите рачуна о вредности формата фонта, као и о CSS својствима породице фонтова, стила фонта и тежине фонта јер LearnR још увек није у стању да анализира синтаксу датотеке фонтова.';
$string['customfontssetting'] = 'Прилагођени фонтови';
$string['customfontssetting_desc'] = 'Са овим подешавањем можете да поставите прилагођене фонтове у тему. Предност постављања фонтова у овај простор за датотеке је у томе што се ти фонтови могу испоручити без провере да ли је корисник пријављен и могу се користити као локално инсталирани фонтови свуда на сајту. Чим поставите барем један фонт у ово подручје за датотека и сачувате подешавања, испод ће се појавити списак која ће вам дати CSS одломке кôда које можете користити као шаблон за референцирање одређених фонтова у вашем прилагођеном SCSS-у.';
$string['drawerbg'] = 'Боја позадине фиоке';
$string['drawerbg_desc'] = 'Промените боју позадине фиоке.';
$string['easyenrollbtn'] = 'Кôдови за упис';
$string['emailbrandinghtmldemobody'] = '<p>Тело е-поруке овде почиње.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>Тело е-поруке се овде завршава.</p>';
$string['emailbrandinghtmlheading'] = 'Преглед е-поште - HTML';
$string['emailbrandinghtmlintro'] = 'Ово је преглед е-поште у HTML формату, засноване на префиксима и суфиксима брендирања који су тренутно подешени у језичком пакету.';
$string['emailbrandinghtmlnopreview'] = 'До сада, е-поруке у HTML формату нису биле прилагођене у оквиру ове функције. Е-поруке ће се састављати и слати нормално.';
$string['emailbrandinginstruction'] = 'Како да';
$string['emailbrandinginstruction0'] = 'Са овом LearnR функцијом, можете применити брендирање на сву е-пошту коју Moodle шаље.';
$string['emailbrandinginstructionli1'] = 'Идите на <a href="{$a->url}" target="_blank">страницу за прилагођавање језика</a> како бисте отворили <em>{$a->lang}</em> језички пакет за уређивање.';
$string['emailbrandinginstructionli2'] = 'Потражите и измените ове стрингове у <code>theme_learnr</code> језичком пакету:';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Овај исечак кôда ће бити додат <em>на почетак / пре тела</em> свих <em>е-порука у HTML формату</em> које Moodle шаље.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Овај исечак кôда ће бити додат   <em>на крај / након тела</em> свих <em>е-порука у HTML формату</em> које Moodle шаље.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Овај исечак кôда ће бити додат <em>на почетак / пре тела</em> свих <em> е-порука у формату обичног текста </em> које Moodle шаље.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Овај исечак кôда ће бити додат <em>на крај / након тела</em> свих <em> е-порука у формату обичног текста </em> које Moodle шаље.';
$string['emailbrandinginstructionli3'] = 'Сачувајте промене језичког пакета.';
$string['emailbrandinginstructionli4'] = 'Вратите се на ову страницу и погледајте прегледе е-поште у наставку ове странице.';
$string['emailbrandingintroheading'] = 'Увод';
$string['emailbrandingintronote'] = 'Имајте на уму: ово је напредна функционалност која користи нека заобилазна решења како би се обезбедиле опција за брендирање е-поште. Молимо вас да пажљиво пратите упутства.';
$string['emailbrandingpitfalls'] = 'Замке';
$string['emailbrandingpitfalls0'] = 'Користећи ову функцију, требало би да буде те свесни неких замки које постоје:';
$string['emailbrandingpitfallsli1'] = 'Обавезно је да измените стрингове језичког пакета <em>тренутног подразумеваног језика</em> на овом сајту. Чак и ако имате инсталирано више језичких пакета, ефекта ће имати само промене подразумеваног језика ће.';
$string['emailbrandingpitfallsli2'] = 'Уважавање језика примаоца е-поште није могуће. Због тога, требало би да користите језички неутралне термине у оквиру одломака кôда за брендирања е-поште.';
$string['emailbrandingpitfallsli3'] = 'Ако икада промените подразумевани језик сајта у будућности, мораћете да мигрирате измењене стрингове језичког пакета у нови подразумевани језички пакет.';
$string['emailbrandingpitfallsli4'] = 'У е-порукама формату обичног текста, постоји прелом реда и празан ред који се аутоматски додаје после префикса, као и празан ред који се аутоматски додаје испред суфикса. Ово је зато да би се осигурало да суфикс и префикс не стоје директно уз тело е-поруке.';
$string['emailbrandingpitfallsli5'] = 'У е-порукама у HTML формату, префикс и суфикс се директно додају испред и изнад тела е-поруке. Ово је зато да бисте били сигурни да можете лако да радите са HTML ознакама, али ћете морати сами да водите рачуна о свим размацима око тела е-поруке.';
$string['emailbrandingpitfallsli6'] = 'У е-порукама у HTML формату, можете отворити HTML ознаку у исечку кôда префикса и затворити ознаку у исечку кôда суфикса без проблема. Само запамтите да креирате исправан HTML у резултирајућој е-поруци.';
$string['emailbrandingtab'] = 'Брендирање е-поште';
$string['emailbrandingtextdemobody'] = 'Тело е-поруке овде почиње.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Тело е-поруке се овде завршава.';
$string['emailbrandingtextheading'] = 'Преглед е-поште - обичан текст';
$string['emailbrandingtextintro'] = 'Ово је преглед е-поште у формату обичног текста, засноване на префиксима и суфиксима брендирања који су тренутно подешени у језичком пакету.';
$string['emailbrandingtextnopreview'] = 'До сада, е-поруке у формату обичног текста нису биле прилагођене у оквиру ове функције. Е-поруке ће се састављати и слати нормално.';
$string['enablecontactsetting'] = 'Омогући страницу за контакт';
$string['enablehelpsetting'] = 'Омогући страницу за помоћ';
$string['enableimprintsetting'] = 'Омогући импресум';
$string['enablemaintenancesetting'] = 'Омогући страницу са информацијама о одржавању';
$string['enrollcoursecard'] = 'Прикажи курс';
$string['error:infobannerdismissnonotdismissible'] = 'Дати инфо банер се не може одбацити';
$string['error:infobannerdismissnonotvalid'] = 'Наведени број инфо банера није исправан';
$string['exporttomistar'] = 'Извоз у MIStar';
$string['faviconheading'] = 'Фавиконица';
$string['faviconheading_desc'] = 'Имајте на уму: LearnR има сопствено поље за постављање фавиконице и не користи фавиконицу из <a href="{$a}">подешавања фавиконице основне инсталације Moodlea</a>.<br />LearnR вам посебно омогућава да заобиђете постављену фавиконицу у оквиру његових визуелних идентитета .';
$string['faviconsetting'] = 'Фавиконица';
$string['faviconsetting_desc'] = 'Овде можете да поставите прилагођену слику (у .ico или .png формату) коју ће веб читач приказати као фавиконицу вашег Moodle сајта. Ако не поставите своју прилагођену фавиконицу, користиће се стандардна Moodle фавиконица.';
$string['flavoursappliesto'] = 'Примењује се на';
$string['flavoursapplytocategories'] = 'Примените на категорије курсева';
$string['flavoursapplytocategories_help'] = 'Овде дефинишете да ли овај визуелни идентитет треба применити на категорије курсева.';
$string['flavoursapplytocategories_ids'] = 'Категорије курсева';
$string['flavoursapplytocategories_ids_help'] = 'Овде дефинишете једну или више засебних категорија курсева на које треба применити овај визуелни идентитет. Чим се приказана Moodle страница налази унутар једне од конфигурисаних категорија курса, визуелни идентитет ће бити примењен.';
$string['flavoursapplytocohorts'] = 'Примените на кохорте';
$string['flavoursapplytocohorts_help'] = 'Овде дефинишете да ли овај визуелни идентитет треба применити на кохорте.';
$string['flavoursapplytocohorts_ids'] = 'Кохорте';
$string['flavoursapplytocohorts_ids_help'] = 'Овде дефинишете једну или више засебних кохорти на које треба применити овај визуелни идентитет. Чим је корисник члан једне од конфигурисаних кохорти, визуелни идентитет ће бити примењен.<br /><br />Имајте у виду да, ако дефинишете више од једне кохорте, нема потребе да корисник буде члан свих кохорти у исто време.<br /><br />Такође, имајте на уму да се у тренутном стању имплементације кохорте третирају као да су системске.';
$string['flavoursbackgroundimage'] = 'Позадинска слика';
$string['flavoursbackgroundimage_help'] = 'Са овим подешавањем визуелни идентитет ће заменити позадинску слику која је конфигурисана у подешавањима изгледа теме LearnR.';
$string['flavoursbacktooverview'] = 'Назад на преглед визуелних идентитета';
$string['flavourscreateflavour'] = 'Креирај визуелни идентитет';
$string['flavourscustomcss'] = 'Прилагођени CSS';
$string['flavourscustomcss_help'] = 'Са овим подешавањем можете унети прилагођени CSS за визуелни идентитет. Биће додат у стек CSS кôда који се шаље веб читачу чим се примени визуелни идентитет. Имајте на уму да у тренутном стању имплементације, ово подешавање дозвољава коришћење само прилагођеног CSS-а, али не и SCSS-а.';
$string['flavoursdelete'] = 'Обриши';
$string['flavoursdeleteconfirmation'] = 'Да ли заиста желите да обришете визуелни идентитет <em>{$a}</em>?';
$string['flavoursdeleteflavour'] = 'Обриши визуелни идентитет';
$string['flavoursdescription'] = 'Опис';
$string['flavoursdescription_help'] = 'Опис визуелног идентитета користи се интерно само како би вам омогућио да идентификујете одређени визуелни идентитет на списку.';
$string['flavoursedit'] = 'Уреди';
$string['flavourseditflavour'] = 'Уреди визуелни идентитет';
$string['flavoursfavicon'] = 'Фавиконица';
$string['flavoursfavicon_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити фавиконицу која је конфигурисана у подешавањима изгледа LearnR теме.';
$string['flavoursflavours'] = 'Визуелни идентитети';
$string['flavoursgeneralsettings'] = 'Општа подешавања';
$string['flavoursincludesubcategories'] = 'Укључите поткатегорије';
$string['flavoursincludesubcategories_help'] = 'Ако је означено, визуелни идентитет ће бити примењен и на поткатегорије изабраних категорија.';
$string['flavourslogo'] = 'Лого';
$string['flavourslogo_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити логотип који је конфигурисан у подешавањима изгледа теме LearnR.';
$string['flavourslogocompact'] = 'Компактан лого';
$string['flavourslogocompact_help'] = 'Са овим подешавањем, визуелни идентитет ће заменити логотип који је конфигурисан у подешавањима изгледа теме LearnR.';
$string['flavoursnothingtodisplay'] = 'Још увек није креиран ниједан визуелни идентитет. Молимо вас да направите свој први визуелни идентитет како бисте покренули ствари.';
$string['flavoursnotificationcreated'] = 'Визуелни идентитет је успешно креиран';
$string['flavoursnotificationdeleted'] = 'Визуелни идентитет је успешно обрисан';
$string['flavoursnotificationedited'] = 'Визуелни идентитет је успешно едитован';
$string['flavoursoverview_desc'] = '<p>Визуелни идентитети LearnR тема нуде могућност да измените  поједина подешавања изгледа Moodlea у одређеним контекстима. На овој страници можете креирати визуелне идентитете и управљати њима.</p><p>Унутар сваког идентитета дефинишете да ли га треба применити на одређене категорије курсева или одређене кохорте. Након тога, током сваког приказивања Moodle странице, LearnR проверава да ли је визуелни идентитет применљив. Имајте на уму да се за свако приказивање Moodle странице примењује само први одговарајући визуелни идентитет са списка, а преостали се занемарују. Стога је редослед визуелних идентитета на овој страници кључан.</p><p>Такође имајте на уму да се након сваке промене коју направите у скупу визуелних идентитета, кеш теме чисти. Ово је неопходно како бисте били сигурни да су веб читачу сва подешавања испоручена прописно и ажурно.</p>';
$string['flavourspreview'] = 'Преглед';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Преглед визуелног идентитета';
$string['flavourstitle'] = 'Наслов';
$string['flavourstitle_help'] = 'Наслов визуелног идентитета се користи само интерно да би вам омогућио да документујете одређени идентитет на листи визуелних идентитета.';
$string['fontawesomecheck-fa6free-fallback-description'] = 'Новије FontAwesome верзије користе идентификаторе старијих иконица како би их ремапирали на новије иконице (или, како би неке од њих одстранили). Ако видите мапу иконице хомогеног (солидног) изгледа на левој страни, ваша FontAwesome верзија 6 исправно приказује ремапиране иконице из FontAwesome верзије 4.';
$string['fontawesomecheck-fa6free-fallback-title'] = 'FontAwesome 4 резерва';
$string['fontawesomecheck-fa6free-filter-description'] = 'Пошто имате инсталиран додатак за FontAwesome филтер, требало би да будете сигурни да филтер правилно рукује новим FontAwesome 6 иконицама. Ако видите иконицу корисника на левој страни, филтер ради исправно са иконицама FontAwesome верзије 6.';
$string['fontawesomecheck-fa6free-filter-title'] = 'FontAwesome филтер';
$string['fontawesomecheck-fa6free-general-description'] = 'Ако видите иконицу штрикле на левој страни, FontAwesome генерално нормално функционише на вашем сајту.';
$string['fontawesomecheck-fa6free-general-title'] = 'Општа функционалност';
$string['fontawesomecheck-fa6free-newstuff-description'] = 'У поређењу са FontAwesome 4 скупом иконица, новије FontAwesome верзије испоручују се са додатним иконицама  Ако видите иконицу вируса на левој страни, ваша FontAwesome 6 верзија исправно приказује нове иконице.';
$string['fontawesomecheck-fa6free-newstuff-title'] = 'FontAwesome 6 иконице';
$string['fontawesomecheckssetting'] = 'FontAwesome провере';
$string['fontawesomecheckssetting_desc'] = 'Овде можете визуелно да проверите да ли су FontAwesome датотеке правилно постављене и додате на Moodle страницу. Ако једна од провера не успе, проверите још једном да ли сте исправно поставили све обавезне датотеке.';
$string['fontawesomefilessetting'] = 'FontAwesome датотеке';
$string['fontawesomefilessetting_desc'] = 'Са овим подешавањем можете да поставите новије FontAwesome датотеке у Moodle. Морате сами да поставите FontAwesome датотека у Moodle због ограничења везаних за лиценцирања. Идите на <a href="https://fontawesome.com">fontawesome.com</a>, преузмите FontAwesome пакет и поставите га овде.';
$string['fontawesomefilesstructurenote'] = 'Имајте на уму да датотеке морају бити постављене са правилном структуром директоријума и исправним називима датотека. Почните креирањем <em>css</em> и <em>webfonts</em> директоријума у бирачу датотека, поставите <em>fa-solid-900.woff2</em> датотеку у <em>webfonts</em> директоријум и сачувајте страницу са подешавањима. Чим то урадите, у наставку ће се појавити списак датотека који вам помаже да идентификујете и поставите праве датотеке у ове директоријуме.';
$string['fontawesomeheading'] = 'FontAwesome';
$string['fontawesomelistfileinfo-fa6free-css-brands.min.css'] = 'Ово је додатна CSS датотека која додаје фонт за FontAwesome бренд иконице на Moodle страницу.';
$string['fontawesomelistfileinfo-fa6free-css-fontawesome.min.css'] = 'Ово је главна CSS датотека која додаје све доступне FontAwesome глифове на Moodle страницу.';
$string['fontawesomelistfileinfo-fa6free-css-regular.min.css'] = 'Ово је додатна CSS датотека која додаје фонт за FontAwesome обичне иконице на Moodle страницу.';
$string['fontawesomelistfileinfo-fa6free-css-solid.min.css'] = 'Ово је додатна CSS датотека која додаје фонт за FontAwesome иконице хомогеног (солидног) изгледа на Moodle страницу.';
$string['fontawesomelistfileinfo-fa6free-css-v4-font-face.min.css'] = 'Ово је CSS датотека која осигурава да се FontAwesome 4 иконице и даље правилно приказују у Moodleu.';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.ttf'] = 'Ово је датотека фонта за FontAwesome бренд иконице (у TTF формату).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.woff2'] = 'Ово је датотека фонта за FontAwesome бренд иконице (у WOFF2 формату).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.ttf'] = 'Ово је датотека фонта за FontAwesome обичне иконице (у TTF формату).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.woff2'] = 'Ово је датотека фонта за FontAwesome обичне иконице (у WOFF2 формату).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.ttf'] = 'Ово је датотека фонта за FontAwesome иконице хомогеног (солидног) изгледа (у TTF формату).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.woff2'] = 'Ово је датотека фонта за FontAwesome иконице хомогеног (солидног) изгледа (у WOFF2 формату).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.ttf'] = 'Ово је датотека фонта за компатибилност FontAwesome верзијом 4 (у TTF формату).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.woff2'] = 'Ово је датотека фонта за компатибилност FontAwesome верзијом 4 (у WOFF2 формату).';
$string['fontawesomelistmandatorymissing'] = 'Ово је обавезна датотека која омогућава да FontAwesome функционише, али није правилно учитана. Покушајте да је правилно поставите.';
$string['fontawesomelistmandatoryuploaded'] = 'Ово је обавезна датотека која омогућава да FontAwesome функционише, и правилно је постављена.';
$string['fontawesomelistnote'] = 'Имајте на уму да, уколико поставите само делић обавезних датотека, FontAwesome иконице могу изгледати као покварене на Moodle страници. Ово се не може поправити док не поставите све обавезне датотеке или поново уклоните све датотеке.';
$string['fontawesomelistoptionalmissing'] = 'Ово је опциона датотека за побољшање скупа FontAwesome иконица  али није постављена. Ово је сасвим ОК, све док вам ова датотека не затреба.';
$string['fontawesomelistoptionaluploaded'] = 'Ово је опциона датотека за побољшање скупа FontAwesome иконица и правилно је постављена.';
$string['fontawesomelistsetting'] = 'Списак FontAwesome датотека';
$string['fontawesomelistsetting_desc'] = 'Ово је списак FontAwesome датотека које сте поставили на сервер у горње простор за FontAwesome датотеке. Овде су наведене све датотеке које су валидне за конфигурисану FontAwesome верзију; друге датотеке које сте можда поставили, али који нису валидне или потребне FontAwesome датотеке се занемарују. FontAwesome датотеке се аутоматски додају на Moodle странице и имају непосредан ефекат чим сачувате ово подешавање.';
$string['fontawesomeversionfa6free'] = 'Бесплатно ажурирање на FontAwesome 6';
$string['fontawesomeversionnone'] = 'Задржите FontAwesome 4 (како је испоручено са Moodle основном инсталацијом)';
$string['fontawesomeversionsetting'] = 'FontAwesome верзија';
$string['fontawesomeversionsetting_desc'] = 'Основна Moodle инсталација се испоручује са  FontAwesome 4 иконицама које су сасвим ОК, али је FontAwesome прилично унапређен. Уколико желите да користите новије FontAwesome иконице, то можете учинити помоћу овог подешавања. Чим изаберете другу верзију, осим FontAwesome 4, појавиће се додатна подешавања где можете да поставите новије FontAwesome верзије.';
$string['footertab'] = 'Подножје';
$string['footnoteheading'] = 'Фуснота';
$string['footnotesetting'] = 'Фуснота';
$string['footnotesetting_desc'] = 'Шта год да додате у ово текстуално поље, садржај ће бити приказан на крају странице, у подножју (не у плутајућем подножју) на свакој страници која користи распореде "drawers", "columns2" или "login". Садржај у овом поље могу бити, на пример ауторска права, услови коришћења или назив ваше организације.<br/> Ако желите поново да уклоните фусноту, само обришите садржај текстуалног поља.';
$string['gradebooktitle'] = 'Књига оцена';
$string['h5pcontentmaxwidthsetting'] = 'Максимална ширина H5P банке садржаја';
$string['h5pcontentmaxwidthsetting_desc'] = 'Са овим подешавањем, можете изменити ширину Moodle H5P банке садржаја курса без ручних измена SCSS скупа стилова. Ова ширина се користи за H5P едитор унутар банке садржаја. Она се <em>не</em> користи за ширину H5P активности. Стандардно, Moodle користи максималну ширину H5P банке садржаја од 960 пиксела. Можете да унесете друге вредности засноване на пикселима као што је 1200 пиксела, али такође можете да унесете вредност засновану на процентима као што је 100% или вредност ширине оквира за приказ (viewport) као што је 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Садржај странице за помоћ';
$string['helpcontentsetting_desc'] = 'У овом подешавању можете додати садржај у формату обогаћеног текста који ће бити приказан на страници за помоћ.';
$string['helpdisabled'] = 'Страница за помоћ је онемогућена на овом сајту. Овде нема шта да се види.';
$string['helpheading'] = 'Помоћ';
$string['helplinkpositionboth'] = 'Додајте линк ка страници за помоћ у фусноту и на иконицу у подножју (знак питања).';
$string['helplinkpositionfooter'] = 'Додајте линк ка страници за помоћ на иконицу у подножју (знак питања).';
$string['helplinkpositionfootnote'] = 'Додајте линк ка страници за помоћ у фусноту';
$string['helplinkpositionnone'] = 'Немојте аутоматски приказивати линк ка страници за помоћ';
$string['helplinkpositionsetting'] = 'Позиција линка ка страници за помоћ';
$string['helplinkpositionsetting_desc'] = 'У овом подешавању можете да конфигуришете да ли ће се линк ка страници за помоћ аутоматски додати на Moodle страницу. Ако не желите да аутоматски приказујете линк, можете ручно додати линк ка {$a->url} са било ког места у Moodleu.';
$string['helppagetitledefault'] = 'Помоћ';
$string['helppagetitlesetting'] = 'Наслов странице за помоћ';
$string['helppagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов странице за помоћ. Овај текст ће се користити и као текст линка ка страници за помоћи ако у складу с тим конфигуришете подешавање \'Позиција линка ка страници за помоћ\'.';
$string['hideloginform'] = 'Сакриј образац за пријаву';
$string['hideloginform_desc'] = '<b>БУДИТЕ ПАЖЉИВИ! Провера ове функције ће уклонити образац за пријаву.</b> Сакријте образац за пријаву само ако користите неки други метод пријављивања, као што је нпр. Google Login, и када никада немате потребу да користите образац за пријаву. Да бисте се повратили образац, морате да уклоните датотеку  /moodle/theme/learnr/templates/core/loginform.mustache. Брисање ове датотеке ће омогућити да се образац за пријаву поново појави, у случају да никако не будете могли да приступите обрасцу.';
$string['hidenodesprimarynavigationsetting'] = 'Сакриј чворове у примарној навигацији';
$string['hidenodesprimarynavigationsetting_desc'] = 'Са овим подешавањем можете да сакријете један или више чворова из примарне навигације';
$string['iconnavbartab'] = 'Навигација иконицама';
$string['iconnavheading'] = 'Навигација иконицама';
$string['iconnavinfo'] = 'Контролни панел - навигација иконицама';
$string['iconnavinfo_desc'] = 'Креирајте дугмад са иконицама за употребу на почетној страници. Дугмад се појављују на врху странице на контролном панелу.';
$string['imprintcontentsetting'] = 'Садржај импресума';
$string['imprintcontentsetting_desc'] = 'У овом подешавању можете додати садржај у формату обогаћеног текста који ће бити приказан на страници са импресумом.';
$string['imprintdisabled'] = 'Страница са импресумом је онемогућена на овом сајту. Овде нема шта да се види.';
$string['imprintheading'] = 'Импресум';
$string['imprintlinkpositionboth'] = 'Додајте линк ка страници са импресумом у фусноту и на иконицу у подножју (знак питања).';
$string['imprintlinkpositionfooter'] = 'Додајте линк ка страници са импресумом на иконицу у подножју (знак питања).';
$string['imprintlinkpositionfootnote'] = 'Додајте линк ка страници са импресумом у фусноту';
$string['imprintlinkpositionnone'] = 'Немојте аутоматски приказивати линк ка страници са импресумом';
$string['imprintlinkpositionsetting'] = 'Позиција линка ка страници са импресумом';
$string['imprintlinkpositionsetting_desc'] = 'У овом подешавању можете да конфигуришете да ли ће се линк ка страници са импресумом аутоматски додати на Moodle страницу. Ако не желите да аутоматски приказујете линк, можете ручно додати линк ка {$a->url} са било ког места у Moodleu.';
$string['imprintpagetitledefault'] = 'Импресум';
$string['imprintpagetitlesetting'] = 'Наслов странице са импресумом';
$string['imprintpagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов странице са импресумом. Овај текст ће се користити и као текст линка ка страници са импресумом ако у складу с тим конфигуришете подешавање \'Позиција линка ка страници са импресумом\'.';
$string['infobannerbsclasssetting'] = 'Bootstrap класа инфо банера {$a->no}';
$string['infobannerbsclasssetting_desc'] = 'Са овим подешавањем, можете да изаберете Bootstrap стил са којим ће инфо банер {$a->no} бити приказан. Ако изаберете опцију \'Без Bootstrap боје\', инфо банер ће бити приказан без било какве Bootstrap боје, што вам даје слободу да сами стилизујете банер у едитору текста.';
$string['infobannerclose'] = 'Затвори';
$string['infobannercontentsetting'] = 'Садржај инфо банера {$a->no}';
$string['infobannercontentsetting_desc'] = 'Овде уносите информације које треба да буду приказане у инфо банеру {$a->no}.';
$string['infobannerdismissconfirm'] = 'Да ли заиста желите да ресетујете видљивост инфо банера {$a->no} и да га поново прикажете свим корисницима који су га претходно одбацили?';
$string['infobannerdismissfail'] = 'Ресетовање видљивости инфо банера {$a->no} није успело за најмање једног корисника';
$string['infobannerdismissiblesetting'] = 'Инфо банер {$a->no} се може одбацити';
$string['infobannerdismissiblesetting_desc'] = 'Са овим подешавањем можете учинити да инфо банер {$a->no} може да се одбаци. Ако корисник кликне на дугме  X у инфо банеру, банер ће за овог корисника бити трајно сакривен. Видљивост се никако не ресетује аутоматски, чак и ако промените садржај инфо банера. Ако желите да ресетујете видљивост инфо банера, кликните на дугме \'Ресетуј видљивост\'.';
$string['infobannerdismissreset'] = 'Ресетуј видљивост одбаченог инфо банера';
$string['infobannerdismissresetbutton'] = 'Ресетуј видљивост инфо банера {$a->no}';
$string['infobannerdismisssuccess'] = 'Видљивост инфо банера {$a->no} је ресетована';
$string['infobannerenabledsetting'] = 'Омогући инфо банер {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Са овим подешавањем можете омогућити инфо банер {$a->no}.';
$string['infobannerendsetting'] = 'Време завршетка приказивања инфо банера {$a->no}';
$string['infobannerendsetting_desc'] = 'Са овим подешавањем можете да дефинишете до када треба да буде приказан инфо банер {$a->no}. Конфигурисано време се третира као време сервера, а не као време корисника.';
$string['infobannerheading'] = 'Инфо банер {$a->no}';
$string['infobannermodeperpetual'] = 'Трајно';
$string['infobannermodesetting'] = 'Режим приказа инфо банера {$a->no}';
$string['infobannermodesetting_desc'] = 'Са овим подешавањем можете да дефинишете да ли инфо банер {$a->no} треба да буде трајни (који се увек приказује) или временски ограничени банер (који се приказује само у конфигурисаном временском интервалу)';
$string['infobannermodetimebased'] = 'Временски ограничено';
$string['infobannerordersetting'] = 'Позиција а инфо банера {$a->no}';
$string['infobannerordersetting_desc'] = 'Са овим подешавањем дефинишете позицију инфо банера {$a->no}. Стандардно, инфо банери су поређани одозго према доле, као што их видите на овој страници са подешавањима. Међутим, са овим подешавањем можете инфо банеру да доделите другу позицију. Ако доделите исту позицију за два или више инфо банера, они ће бити поново поређани према редоследу на овој страници са подешавањима.';
$string['infobannerpageloginpage'] = 'Страница за пријаву';
$string['infobannerpagessetting'] = 'Врсте страница за приказ банера са информацијама {$a->no}';
$string['infobannerpagessetting_desc'] = 'Са овим подешавањем, можете да изаберете врсте страница на којима инфо банер {$а->но} треба да буде приказан.';
$string['infobannerstartsetting'] = 'Време почетка приказивања инфо банера {$a->no}';
$string['infobannerstartsetting_desc'] = 'Са овим подешавањем, можете да дефинишете од када треба да буде приказан инфо банер {$a->no}. Конфигурисано време се третира као време сервера, а не као време корисника.';
$string['infobannertab'] = 'Инфо банер';
$string['javascriptdisabledhint'] = 'Савет ако је JavaScript онемогућен';
$string['javascriptdisabledhint_desc'] = 'Са овим подешавањем на врху Moodle странице ће се појавити савет ако JavaScript није омогућен. Ово је посебно корисно јер неколико Moodle функција не ради без JavaScripta.';
$string['javascriptdisabledhinttext'] = 'JavaScript је онемогућен у вашем веб читачу.<br />Многе Moodle функције неће бити употребљиве или ће изгледати као да не раде.<br />Омогућите JavaScript како би Moodle могао нормално да функционише.';
$string['javascriptheading'] = 'JavaScript';
$string['latestcourses'] = 'Скорашњи курсеви';
$string['learnr:configure'] = 'Конфигурисање теме као не-администратор';
$string['learnr:editregioncontentlower'] = 'Уређивање региона блокова Садржај (доњи)';
$string['learnr:editregioncontentupper'] = 'Уређивање региона блокова Садржај (горњи)';
$string['learnr:editregionfootercenter'] = 'Уређивање региона блокова Подножје (центар)';
$string['learnr:editregionfooterleft'] = 'Уређивање региона блокова Подножје (лево)';
$string['learnr:editregionfooterright'] = 'Уређивање региона блокова Подножје (десно)';
$string['learnr:editregionheader'] = 'Уређивање региона блокова Заглавља';
$string['learnr:editregionoffcanvascenter'] = 'Уређивање региона блокова Ван-странице (центар)';
$string['learnr:editregionoffcanvasleft'] = 'Уређивање региона блокова Ван-странице (лево)';
$string['learnr:editregionoffcanvasright'] = 'Уређивање региона блокова Ван-странице (десно)';
$string['learnr:editregionoutsidebottom'] = 'Уређивање региона блокова Споља (доле)';
$string['learnr:editregionoutsideleft'] = 'Уређивање региона блокова Споља (лево)';
$string['learnr:editregionoutsideright'] = 'Уређивање региона блокова Споља (десно)';
$string['learnr:editregionoutsidetop'] = 'Уређивање региона блокова Споља (горе)';
$string['learnr:viewhintcourseselfenrol'] = 'Способност да се види савет за неограничени самостални упис на видљивим курсевима.';
$string['learnr:viewhintinhiddencourse'] = 'Способност да се види савет у сакривеним активностима';
$string['learnr:viewregioncontentlower'] = 'Способност да се види регион блокова Садржај (доњи)';
$string['learnr:viewregioncontentupper'] = 'Способност да се види регион блокова Садржај (горњи)';
$string['learnr:viewregionfootercenter'] = 'Способност да се види регион блокова Подножје (центар)';
$string['learnr:viewregionfooterleft'] = 'Способност да се види регион блокова Подножје (лево)';
$string['learnr:viewregionfooterright'] = 'Способност да се види регион блокова Подножје (десно)';
$string['learnr:viewregionheader'] = 'Способност да се види регион блокова Заглавље';
$string['learnr:viewregionoffcanvascenter'] = 'Способност да се види регион блокова Ван-странице (центар)';
$string['learnr:viewregionoffcanvasleft'] = 'Способност да се види регион блокова Ван-странице (лево)';
$string['learnr:viewregionoffcanvasright'] = 'Способност да се види регион блокова Ван-странице (десно)';
$string['learnr:viewregionoutsidebottom'] = 'Способност да се види регион блокова Споља (доле)';
$string['learnr:viewregionoutsideleft'] = 'Способност да се види регион блокова Споља (лево)';
$string['learnr:viewregionoutsideright'] = 'Способност да се види регион блокова Споља (десно)';
$string['learnr:viewregionoutsidetop'] = 'Способност да се види регион блокова Споља (горе)';
$string['loginbackgroundimage'] = 'Позадинске слике странице за пријаву';
$string['loginbackgroundimage_desc'] = 'Слике која ће бити приказана као позадина странице за пријаву. Једна од ових слика ће бити насумично изабрана и приказана када корисник приступи страници за пријаву. Проверите да се у називу датотеке не користе знакови који нису ASCII, уколико желите да прикажете текст за позадинске слике странице за пријаву.';
$string['loginbackgroundimagesheading'] = 'Позадинске слике странице за пријаву';
$string['loginbackgroundimagetextsetting'] = 'Прикажи текст за позадинске слике странице за пријаву';
$string['loginbackgroundimagetextsetting_desc'] = 'Са овим опционим подешавањем можете додати текст, нпр. обавештење о ауторским правима на позадинске слике које сте поставили. Овај текст ће се појавити на врху подножја странице за пријаву. Међутим, због величине екрана, текст се приказује само на екранима већих величина.<br/>
Сваки ред се састоји од идентификатора датотеке (назив датотеке), текста који треба да се прикаже и боје текста (елементи у реду су одвојени вертикалном цртом |). Сваку појединачни ставку у овом подешавању треба написати у новом реду. <br/>
На пример:<br/>
background-image-1.jpg|Copyright: CC0|dark<br/>
Као боју текста можете користити вредности "тамно" или "светло".<бр />
Можете дефинисати текстове за произвољан број ваших постављених позадинских слика странице за пријаву. Текстови ће бити додати само оним сликама које одговарају њиховом називу датотеке са идентификатором наведеним у овом подешавању.';
$string['loginformheading'] = 'Образац за пријаву';
$string['loginformpositionsetting'] = 'Позиција обрасца за пријаву';
$string['loginformpositionsetting_center'] = 'Централно';
$string['loginformpositionsetting_desc'] = 'Са овим подешавањем можете оптимизовати образац за пријаву тако да одговара већем броју позадинских слика. Стандардно, образац за пријаву се приказује у центру странице за пријаву. Алтернативно, можете да га померите лево или десно на страници за пријаву како би се остали делови позадинске слике јасно видели. Наравно, ово подешавање можете променити и ако позадинска слика уопште није постављена.';
$string['loginformpositionsetting_left'] = 'Поравнато лево';
$string['loginformpositionsetting_right'] = 'Поравнато десно';
$string['loginformtransparencysetting'] = 'Транспарентност обрасца за пријаву';
$string['loginformtransparencysetting_desc'] = 'Са овим подешавањем, можете учинити да образац за пријаву буде мало провидан како би се позадинска слика јасније видела.';
$string['loginpagetab'] = 'Страница за пријаву';
$string['logocompactsetting'] = 'Компактан лого';
$string['logocompactsetting_desc'] = 'Овде можете да поставите компактну верзију истог логотипа као што је горњи, као што је амблем, штит или иконица. Ова слика се посебно користи у траци за навигацију на врху сваке Moodle странице. Слика треба да буде јасна чак и при малим величинама.';
$string['logosetting'] = 'Лого';
$string['logosetting_desc'] = 'Овде можете да поставите лого који ће се користити као декорација. Ова слика се посебно користи на страници за пријаву и може бити прилично високе резолуције јер ће бити смањена за употребу.';
$string['logosheading'] = 'Логотипи';
$string['logosheading_desc'] = 'Имајте на уму: LearnR има сопствено поље за постављање логотипа и не користи лого из <a href="{$a}">подешавања логотипа основне инсталације Moodlea</a>.<br />LearnR вам посебно омогућава да поставите више формата слика него што нуди основна инсталација Moodlea. Такође вам даје могућност да измените постављене логотипе у оквиру његових визуелних идентитета.';
$string['maintenancecontentsetting'] = 'Садржај странице са информацијама о одржавању';
$string['maintenancecontentsetting_desc'] = 'У овом подешавању можете додати садржај у формату обогаћеног текста који ће бити приказан на страници са информацијама о одржавању (што није исто што и стандардна Moodle страница са режимом одржавања).';
$string['maintenancedisabled'] = 'Страница са информацијама о одржавању је онемогућена на овом сајту. Овде нема шта да се види.';
$string['maintenanceheading'] = 'Одржавање';
$string['maintenancelinkpositionboth'] = 'Додајте линк ка страници са информацијама о одржавању у фусноту и на иконицу у подножју (знак питања).';
$string['maintenancelinkpositionfooter'] = 'Додајте линк ка страници са информацијама о одржавању на иконицу у подножју (знак питања).';
$string['maintenancelinkpositionfootnote'] = 'Додајте линк ка са информацијама о одржавању у фусноту';
$string['maintenancelinkpositionnone'] = 'Немојте аутоматски приказивати линк ка страници са са информацијама о одржавању';
$string['maintenancelinkpositionsetting'] = 'Позиција линка ка страници са информацијама о одржавању';
$string['maintenancelinkpositionsetting_desc'] = 'У овом подешавању можете да конфигуришете да ли ће се линк ка страници са информацијама о одржавању аутоматски додати на Moodle страницу. Ако не желите да аутоматски приказујете линк, можете ручно додати линк ка {$a->url} са било ког места у Moodleu.';
$string['maintenancepagetitledefault'] = 'Одржавање';
$string['maintenancepagetitlesetting'] = 'Наслов странице са информацијама о одржавању';
$string['maintenancepagetitlesetting_desc'] = 'У овом подешавању можете дефинисати наслов странице са информацијама о одржавању. Овај текст ће се користити и као текст линка ка страници са са информацијама о одржавању ако у складу с тим конфигуришете подешавање \'Позиција линка ка страници са информацијама о одржавању\'.';
$string['manageuserstitle'] = 'Корисници';
$string['marketingurltarget'] = 'Одредиште линка';
$string['marketingurltargetdesc'] = 'Изаберите како треба да се отвори линк';
$string['marketingurltargetnew'] = 'Нова страница';
$string['marketingurltargetparent'] = 'Надређени оквир';
$string['marketingurltargetself'] = 'Текућа страница';
$string['mediumcontentmaxwidthsetting'] = 'Максимална ширина средишњег садржаја';
$string['mediumcontentmaxwidthsetting_desc'] = 'Са овим подешавањем, можете изменити ширину средишњег садржаја Moodleа без ручних измена SCSS скупа стилова. Ова ширина странице се користи у одређеним активностима као што је то активност \'База података\'. Стандардно, Moodle користи максималну ширину средишњег садржаја од 1120 пиксела. Можете да унесете друге вредности засноване на пикселима као што је 1200 пиксела, али такође можете да унесете вредност засновану на процентима као што је 100% или вредност ширине оквира за приказ (viewport) као што је 90vw.';
$string['misctab'] = 'Разно';
$string['mobileappearanceheading'] = 'Изглед на мобилним уређајима';
$string['mobilecss'] = 'Додатни CSS за мобилну апликацију';
$string['mobilecss_desc'] = 'Са овим подешавањем можете унети прилагођени CSS кôд како бисте прилагодили интерфејс своје мобилне апликације. CSS кôд ће бити додат само у приказ мобилне апликације ове Moodle инстанце, и неће бити приказан у верзији за веб читач. Прочитајте више о овој функцији на href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">Moodle развојни документи</a>';
$string['mobilecss_donotchange'] = 'Овај корак је неопходан како би се послао CSS кôд у апликацију за мобилне уређаје. Не мењајте URL адресу тамо осим ако заиста не желите да поново уклоните CSS кôд из апликације за мобилне уређаје.';
$string['mobilecss_overwrite'] = 'Чим додате било који CSS кôд у ово подешавање и сачувате га, <a href="{$a->url}">Moodle основно подешавање <em>mobilecssurl</em></a> ће аутоматски бити замењено URL адресом LearnR theme. Тренутно је ово подешавање постављено на  <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Чим додате било који CSS кôд у ово подешавање и сачувате га, <a href="{$a->url}">Moodle основно подешавање <em>mobilecssurl</em></a> ће аутоматски бити постављено на URL адресу LearnR теме.';
$string['mobiletab'] = 'Апликација за мобилне уређаје';
$string['myprogresspercentage'] = '%';
$string['navbarcolorsetting'] = 'Боја навигационе траке';
$string['navbarcolorsetting_dark'] = 'Тамна навигациона трака са светлом бојом фонта';
$string['navbarcolorsetting_desc'] = 'Са овим подешавањем можете променити боју навигационе траке из подразумеване светле у тамну или обојену навигациону траку.';
$string['navbarcolorsetting_light'] = 'Светла навигациона трака са тамном бојом фонта (неизмењено, онако како је изворно подешено у основној Moodle инсталацији)';
$string['navbarcolorsetting_primarydark'] = 'Примарна боја навигационе трака са светлом бојом фонта';
$string['navbarcolorsetting_primarylight'] = 'Примарна боја навигационе траке са тамном бојом фонта';
$string['navbarheading'] = 'Навигациона трака';
$string['navicon'] = 'Иконица';
$string['navicon1'] = 'Иконица почетне странице један';
$string['navicon2'] = 'Иконица почетне странице два';
$string['navicon3'] = 'Иконица почетне странице три';
$string['navicon4'] = 'Иконица почетне странице четири';
$string['navicon5'] = 'Иконица почетне странице пет';
$string['navicon6'] = 'Иконица почетне странице шест';
$string['navicon7'] = 'Иконица почетне странице седам';
$string['navicon8'] = 'Иконица почетне странице осам';
$string['naviconbuttoncreatetextdefault'] = 'Креирај курс';
$string['naviconbuttontext'] = 'Текст линка';
$string['naviconbuttontextdesc'] = 'Текст који ће се појавити испод иконице.';
$string['naviconbuttonurl'] = 'URL адреса линка';
$string['naviconbuttonurldesc'] = 'URL адреса са којом је дугме повезано. Дугме можете да повежете са било којом адресом, укључујући и спољашње веб сајтове, само унесите одговарајућу URL адресу. Ако је ваш Moodle сајт у поддиректоријуму, подразумевана URL адреса неће функционисати. Подесите URL адресу тако да она одржава позицију поддиректоријум. На пример, ако је назив вашег поддиректоријума "moodle", онда би URL адресу требало променити у /moodle/my/';
$string['navicondesc'] = 'Назив иконице коју желите да користите. Списак иконица можете наћи <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">овде</a>. Унесите само оно што следи иза "fa-",", нпр. "star".';
$string['naviconslidedesc'] = 'Предлажемо да као текст иконице користите: arrow-circle-down, или изаберите са списка иконица који можете наћи <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">овде</a>. Унесите само оно што следи иза "fa-",", нпр. "star".';
$string['navigationheading'] = 'Навигација';
$string['navigationtab'] = 'Навигација';
$string['nomycourses'] = 'Нисте уписани ни на један курс';
$string['openoffcanvas'] = 'Отвори фиоку ”Ван странице”';
$string['outsideregionsheading'] = 'Спољни региони';
$string['outsideregionsheading_desc'] = 'Спољни региони, не само да се могу укључити помоћу горњих подешавања, већ се њихов изглед такође може прилагодити.';
$string['outsideregionsplacement'] = 'Хоризонтални положај спољних региона';
$string['outsideregionsplacement_desc'] = 'Са овим подешавањем можете да контролишете да ли на већим екранима, региони блокова \'Споља (лево)\' и \'Споља (десно)\' треба да буду постављени близу главног садржаја странице или близу ивица екрана.';
$string['outsideregionsplacementnearwindowedges'] = 'Прикажите регионе \'Споља (лево)\' и \'Споља (десно)\' близу ивица екрана';
$string['outsideregionsplacementnextmaincontent'] = 'Прикажите регионе \'Споља (лево)\' и \'Споља (десно)\' поред главног садржаја странице';
$string['outsideregionswidthcoursecontentwidth'] = 'Ширина садржаја курса';
$string['outsideregionswidthfullwidth'] = 'Пуна ширина';
$string['outsideregionswidthherowidth'] = 'Херо ширина';
$string['pagenavbuttonsbg'] = 'Дугмад за фиоке, помоћ, повратак на врх';
$string['pagenavbuttonsbg_desc'] = 'Промените боју дугмади бочних фиока, дугмета за помоћ и дугмета за повратак на врх.';
$string['pagetab'] = 'Страница';
$string['pagewidthheading'] = 'Ширина странице';
$string['pluginname'] = 'LearnR';
$string['presetheading'] = 'Предефинисана подешавања теме';
$string['primarynavigationheading'] = 'Примарна навигација';
$string['privacy:metadata'] = 'Тема LearnR не чува никакве личне податке о било ком кориснику.';
$string['progresstitle'] = 'Напредак';
$string['region-content-lower'] = 'Садржај (доњи)';
$string['region-content-upper'] = 'Садржај (горњи)';
$string['region-footer-center'] = 'Подножје (центар)';
$string['region-footer-left'] = 'Подножје (лево)';
$string['region-footer-right'] = 'Подножје (десно)';
$string['region-header'] = 'Заглавље';
$string['region-none'] = 'Ниједан';
$string['region-offcanvas-center'] = 'Ван странице (центар)';
$string['region-offcanvas-left'] = 'Ван странице (лево)';
$string['region-offcanvas-right'] = 'Ван странице (десно)';
$string['region-outside-bottom'] = 'Споља (доле)';
$string['region-outside-left'] = 'Споља (лево)';
$string['region-outside-right'] = 'Споља (десно)';
$string['region-outside-top'] = 'Споља (горе)';
$string['resourcescachecontrolnote'] = 'Имајте на уму да се датотеке шаљу веб читачу са подешеним заглављем \'Контрола-Кеша\' које говори веб читачу да кешира датотеку. Ако сте сигурни да нећете мењати датотеку у блиској будућности, можете да користите трајну URL адресу за повезивање са датотеком. Међутим, ако планирате да мењате датотеку, с времена на време, али да задржите њен исти назив, било би боље да користите ревидирану URL адресу и поново повежете датотеку сваки пут када је ажурирате како бисте избегли да веб читач приказује кеширану, застареле верзије датотеке.';
$string['resourcestab'] = 'Ресурси';
$string['scrollspy'] = 'Чувар позиције клизне траке';
$string['scrollspysetting'] = 'Чувар позиције клизне траке';
$string['scrollspysetting_desc'] = 'Са овим подешавањем, након укључивања/искључивања прекидача режима уређивање, позиција клизне траке у веб читачу (тј. место на којем је корисник био у тренутку када је укључио режим уређивање) биће сачувана.';
$string['scssheading'] = 'Необрађен SCSS';
$string['scsstab'] = 'SCSS';
$string['sections-bars'] = 'Стил једнобојне траке';
$string['sections-boost'] = 'Boost стандардно';
$string['sections-boxed'] = 'Стил кутије';
$string['sections-learnr'] = 'LearnR стандардни стил';
$string['sectionstyle'] = 'Бирач стила секција на курсу';
$string['sectionstyle_desc'] = 'Изаберите стил за секције на курсу.';
$string['showadvertonpages'] = 'Бирач страница за рекламе';
$string['showadvertonpages-course'] = 'Почетна страница курса';
$string['showadvertonpages-dash'] = 'Страница контролног панела';
$string['showadvertonpages-home'] = 'Почетна страница';
$string['showadvertonpages-mycourses'] = 'Страница \'Моји курсеви\'';
$string['showadvertonpages_desc'] = 'Изаберите на којим страницама желите да буду приказане рекламне плочице.';
$string['showcourseactivities'] = 'Прикажи мени активности на курсу';
$string['showcourseactivities_desc'] = 'Прикажи иконицу менија активности на курсу у заглављу.';
$string['showcourseindexnav'] = 'Прикажи фиоке странице';
$string['showcourseindexnav_desc'] = 'Искључите ово подешавање како бисте сакрили навигационе панеле фиока. Није препоручљиво, али може бити корисно за инсталације Moodlea за корпорације или организације. Уклањање фиока поједностављује кориснички интерфејс и може бити пожељно за једноставније обуке.

Прикажите или сакријте навигациону фиоку са индексом курса.';
$string['showcoursemanagement'] = 'Прикажи Управљање Курсом';
$string['showcoursemanagement_desc'] = 'Управљање Курсом је панел са скупом најчешће коришћених линкова за предаваче. Ово је клизни панел чији се прекидач (за укључивање/искључивање) налази у заглављу курса';
$string['showeasyenrolbtn'] = 'Прикажи дугме за Једноставан Упис';
$string['showeasyenrolbtn_desc'] = 'Прикажите брзу везу у заглављу за додатак \'Једноставан Упис\'. Ово омогућава предавачима да лако и брзо дођу до својих кôдова за упис док су на курсу.';
$string['showhintcourseguestaccessgeneral'] = 'Тренутно посматрате овај курс као <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Да бисте имали пун приступ курсу, можете <a href="{$a->url}">самостално да се упишете на овај курс</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Са овим подешавањем, када корисник приступа курсу у улози госта,  у заглављу курса ће се појавити савет. Ако курс даје могућност за самостални упис, кориснику ће такође бити приказан линк до странице за упис.';
$string['showhintcoursehiddengeneral'] = 'Овај курс је тренутно <strong>сакривен</strong>. Само уписани предавачи могу приступити овом курсу када је сакривен.';
$string['showhintcoursehiddensetting'] = 'Прикажи савет у сакривеним курсевима';
$string['showhintcoursehiddensetting_desc'] = 'Са овим подешавањем, савет ће се појавити у заглављу курса све док је курс сакривен. Ово помаже да се одмах, на први поглед идентификује статус видљивости курса, без потребе да се она проверава у подешавањима курса.';
$string['showhintcoursehiddensettingslink'] = 'Видљивост можете променити у <a href="{$a->url}">подешавањима курс</a>.';
$string['showhintcourseselfenrolfrom'] = 'Инстанца уписа <strong>{$a->name}</strong> дозвољава неограничени самостални упис од {$a->from} па надаље.';
$string['showhintcourseselfenrolfromuntil'] = 'Инстанца уписа <strong>{$a->name}</strong> дозвољава неограничени самостални упис од {$a->from} до {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Ако не желите да било који корисник Moodlea има слободан приступ овом курсу, молимо вас да ограничите подешавања самосталног уписа.';
$string['showhintcourseselfenrolsetting'] = 'Прикажи савет за самостални упис без лозинке за упис';
$string['showhintcourseselfenrolsetting_desc'] = 'Са овим подешавањем, у заглављу курса ће се појавити савет ако је курс видљив и ако је, тренутно, могућ упис без лозинке за упис.';
$string['showhintcourseselfenrolsince'] = 'Инстанца уписа <strong>{$a->name}</strong> тренутно дозвољава неограничени самостални упис.';
$string['showhintcourseselfenrolsinceuntil'] = 'Инстанца уписа <strong>{$a->name}</strong> дозвољава неограничени самостални упис до {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Овај курс је тренутно видљив свима и могућ је <strong>самостални упис без лозинке за упис<strong>.';
$string['showhintcourseselfenrolstartfuture'] = 'Овај курс је тренутно видљив свима и планирано је да <strong>самостални упис без лозинке за упис<strong> постане могућ.';
$string['showhintcourseselfenrolunlimited'] = 'Инстанца уписа <strong>{$a->name}</strong> дозвољава неограничени самостални упис на неодређено време.';
$string['showhintcourseselfenroluntil'] = 'Инстанца уписа <strong>{$a->name}</strong> дозвољава неограничени самостални упис до {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Прикажи савет корисницима који приступају као гости';
$string['showlatestcourses'] = 'Прикажи падајући мени са најновијим курсевима';
$string['showlatestcourses_desc'] = 'Ово ће, у падајућем менију десно од наслова курса, приказати последњих 7 курсева које је корисник посетио . У овом тренутку, то није део главне навигације, већ елемент навигације на страницама курса.';
$string['showprogressbar'] = 'Прикажи траку напредовања на курсу';
$string['showprogressbar_desc'] = 'Прикажите траку напредовања за полазника на врху сваке странице главног курса.';
$string['showswitchedroleincoursesetting'] = 'Прикажи савет за измењену улогу';
$string['showswitchedroleincoursesetting_desc'] = 'Са овим подешавањем, у заглављу курса ће се појавити савет уколико је корисник променио улогу на курсу. Стандардно, ове информације се приказују само у близини слике корисника у корисничком менију. Ако омогућите ову опцију, можете такође да прикажете ове информације - заједно са линком \'Повратак на моју нормалну улогу\' - и на самој страници курса.';
$string['sliderinfo'] = 'Специјално дугме-иконица за клизно текстуално поље';
$string['sliderinfodesc'] = 'Ово дугме ће приказати/сакрити посебно текстуално поље који се појављује (као клизни прозор) одмах испод навигационе траке са иконицама. Ово је идеално за приказивање различтих врста порука, попут рекламирања популарних курсева, пружања неопходне помоћи или навођење потребне обуке за особље, итд.';
$string['slidetextbox'] = 'Слајд - поље за текст';
$string['slidetextbox_desc'] = 'Садржај овог поља за текст биће приказано када се притисне дугме слајда.';
$string['staticpagestab'] = 'Статичне странице';
$string['switchedroleto'] = 'Тренутно гледате овај курс са улогом: <strong>{$a->role}</strong>';
$string['templateemailhtmlprefix'] = '';
$string['templateemailhtmlsuffix'] = '';
$string['templateemailtextprefix'] = '';
$string['templateemailtextsuffix'] = '';
$string['tilebackgroundimagepositionsetting'] = 'Позиција позадинске слике рекламне плочице {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Са овим подешавањем контролишете позиционирање позадинске слике унутар контејнера рекламне плочице  {$a->no}. Прва вредност је хоризонтални, друга вертикални положај.';
$string['tilebackgroundimagesetting'] = 'Позадинска слика рекламне плочице {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Овде можете да поставите датотеку слике која ће бити приказана као позадинска слика иза садржаја рекламне плочице {$a->no}. Проверите да ли је садржај и даље читљив на позадинској слици. Ово је опционо подешавање, рекламна плочица ће бити приказана чак и ако не поставите позадинску слику.';
$string['tilecolumnssetting'] = 'Број колона рекламних плочица по реду';
$string['tilecolumnssetting_desc'] = 'Овде дефинишете број колона по реду у приказаној мрежи рекламних плочица. Имајте на уму да се овај број колона односи на десктоп/веће екране. На мањим екранима и мобилним екранима, колоне рекламних плочица се аутоматски пакују.';
$string['tilecontentsetting'] = 'Садржај рекламне плочице {$a->no}';
$string['tilecontentsetting_desc'] = 'Овде уносите садржај који треба да буде приказан у рекламној плочици {$a->no}. Садржај се приказује у средини плочице. Ово је опционо подешавање, рекламна плочица ће бити приказана чак и ако не поставите никакав садржај.';
$string['tileenabledsetting'] = 'Омогући рекламну плочицу {$a->no}';
$string['tileenabledsetting_desc'] = 'Са овим подешавањем можете омогућити рекламну плочицу {$a->no}.';
$string['tilefrontpagepositionsetting'] = 'Позиција рекламних плочица на насловној страници';
$string['tilefrontpagepositionsetting_after'] = 'Након садржаја насловне странице';
$string['tilefrontpagepositionsetting_before'] = 'Пре садржаја насловне странице';
$string['tilefrontpagepositionsetting_desc'] = 'Рекламне плочице се приказују само на насловној страници сајта. Са овим подешавањем контролишете да ли се рекламне плочице приказују пре или после садржаја насловне странице. Ако на насловној страници сајта желите да прикажете само рекламне плочице  и ништа друго, сав остали садржај насловне странице можете уклонити променом <a href="{$a->url}">подешавања насловне странице</a>.';
$string['tileheading'] = 'Рекламна плочица {$a->no}';
$string['tileheightsetting'] = 'Висина рекламних плочица';
$string['tileheightsetting_desc'] = 'Са овим подешавање контролишете висину рекламних плочица. Конфигурисана висина је минимална висина сваке плочице. Ако је садржај плочице већи од ове висине, цео ред плочица биће аутоматски увећан по потреби.';
$string['tilelinksetting'] = 'URL адреса линка рекламне плочице {$a->no}';
$string['tilelinksetting_desc'] = 'Овде можете подесити (Moodle-интерну или екстерну) URL адресу која ће бити понуђена као линк за дугме за на дну рекламне плочице {$a->no}. Ово је опционо подешавање, рекламне плочице ће бити приказана чак и ако не подесите URL адресу линка.';
$string['tilelinktargetsetting'] = 'Одредиште линка рекламне плочице {$a->no}';
$string['tilelinktargetsetting_desc'] = 'Овде можете да подесите одредиште линка који је постављен као линк дугмета чим поставите URL адресу линка у рекламној плочици {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Нова картица';
$string['tilelinktargetsetting_samewindow'] = 'Исти прозор';
$string['tilelinktitlefallback'] = 'Линк';
$string['tilelinktitlesetting'] = 'Наслов линка рекламне плочице {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Овде можете подесити наслов линка, који се користи као натпис на дугмета линка чим унесете URL адресе линка у рекламну плочицу {$a->no}. Имајте на уму да уколико унесете URL адресу, али не и наслов линка, дугме линка биће означено натписом \'Линк\'';
$string['tileordersetting'] = 'Позиција рекламне плочице {$a->no}';
$string['tileordersetting_desc'] = 'Са овим подешавањем дефинишете позицију рекламне плочице {$a->no}. Стандардно, рекламне плочице су поређане одозго према доле и са лева на десно, као што их видите на овој страници са подешавањима. Међутим, са овим подешавањем можете рекламној плочици да доделите другу позицију. Ако доделите исту позицију за две или више рекламних плочица, оне ће бити поново поређане према редоследу на овој страници са подешавањима.';
$string['tilesgeneralheading'] = 'Општа подешавања рекламних плочица';
$string['tilestab'] = 'Рекламне плочице';
$string['tiletitlesetting'] = 'Наслов рекламне плочице {$a->no}';
$string['tiletitlesetting_desc'] = 'Овде уносите наслов који треба да буде приказан у рекламној плочици {$a->no}. Ово је опционо подешавање, рекламна плочица ће бити приказана чак и ако не унесете њен наслов.';
$string['trimsummary'] = 'Скратите резиме курса';
$string['trimsummary_desc'] = 'Унесите број како бисте скратили дужину резимеа курса. Овај број представља број знакова који ће бити приказани.';
$string['trimtitle'] = 'Скратите наслов курса';
$string['trimtitle_desc'] = 'Унесите број како бисте скратили дужину наслова. Овај број представља број знакова који ће бити приказани.';
$string['upgradenotice_2022080922'] = 'Од овог верзије, LearnR има сопствени лого и подешавања компактног логотипа, и више не користи ове датотеке из основних подешавања Moodlea.';
$string['upgradenotice_2022080922_copied'] = 'Постојеће подешавање <strong>{$a}</strong> копирано је из основних подешавања Moodlea у LearnR подешавање {$a} током ове надоградње. Молимо вас да још једном проверите резултат.';
$string['upgradenotice_2022080922_logo'] = 'лого';
$string['upgradenotice_2022080922_logocompact'] = 'компактан лого';
$string['upgradenotice_2022080922_notcopied'] = 'Подешавање <strong>{$a}</strong> у оквиру теме LearnR је сада празно. Ако од сада желите да користите {$а} у оквиру теме LearnR, само га касније поставите у LearnR подешавање {$a}.';
$string['userreportgradebook'] = 'Извештај о кориснику';
$string['viewallcourses'] = 'Прикажи све курсеве';
