<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'cachestore_memcache', language 'sr_cr', version '4.1'.
 *
 * @package     cachestore_memcache
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['clustered'] = 'Омогући груписане сервере';
$string['clustered_help'] = 'Ова опција се користи за подешавање функционалности која дозвољава једно читање и више постављања.

Намера је да се такво подешавање користи ради креирање напредног складишта за конфигурације са балансираним учитавањем. Складиште ће преузимати садржаје са једног сервера (обично локалног), али ће их смештати на више сервера (све који су одређени као расположиви за балансирање учитавања). За кеш са веома високим односом читања и постављања ово обезбеђује значајно облажавање оптерећења мреже.

Кад је ово подешавање укључено горе наведени сервери се користе за прибављање садржаја.';
$string['clusteredheader'] = 'Раздвој сервере';
$string['pluginname'] = 'Memcache';
$string['prefix'] = 'Префикс кључа';
$string['prefix_help'] = 'Овај префикс се користи за све називе кључева на memcache серверу.
* Ако имате само једну инстанцу Moodlea која користи овај сервер, можете да оставите ову вредност као подразумевану.
* Због ограничења дужине кључа, максимално је дозвољено 5 карактера.';
$string['prefixinvalid'] = 'Префикс није валидан. Можете да користите само a-z A-Z 0-9-_.';
$string['privacy:metadata:memcache'] = 'Додатак за кеширање Memcache кратко чува податке, као део своје функционалности. Ови подаци се чувају на Memcache серверу одакле се редовно уклањају.';
$string['privacy:metadata:memcache:data'] = 'Различити подаци који се чувају у кешу';
$string['servers'] = 'Сервери';
$string['servers_help'] = 'Ова опција подешава сервере које треба да користи овај memcache адаптер.
Сервери треба да буду дефинисани по један у сваком реду, а дефиниција се састоји од адресе сервера, и опционо од порта и тежине.
Ако порт није дефинисан користи се подразумевани порт (11211).

На пример:
<pre>
server.url.com
ipaddress:port
servername:port:weight
</pre>

Ако је опција "Омогући груписане сервере" укључена испод, онда овде мора да буде само један сервер. То је обично име које се односи на локални сервер, нешто попут 127.0.0.1 или localhost.';
$string['serversclusterinvalid'] = 'Тачно један сервер је потребан када је омогућена груписање.';
$string['sessionhandlerconflict'] = 'Упозорење: memcache инстанца ({$a}) је подешена тако да користи исти memcache сервер као сесије. Чишћење кеша ће са собом повући и чишћење сесија.';
$string['setservers'] = 'Подеси сервере';
$string['setservers_help'] = 'Ово је списак сервера који ће бити ажурирани када се измене подаци у кешу. У општем случају наведен је пун назив сваког сервера у групи расположивих. Мора бити укључен сервер наведен под опцијом "Сервери" изнад, чак и ако је дат под другим називом.
Сервери треба да буду дефинисани по један у сваком реду, а дефиниција се састоји од адресе сервера, и опционо од порта.
Ако порт није дефинисан користи се подразумевани порт (11211).

На пример:
<pre>
server.url.com
ipaddress:port
</pre>';
$string['testservers'] = 'Тест сервери';
$string['testservers_desc'] = 'Један или више стрингова за конекцију спрам којих ће се тестирати memcache сервери. Ако је специфициран тестни сервер memcache перформансе се могу тестирати коришћењем странице за кеш перформансе у блоку за администрацију.
На пример: 127.0.0.1:11211';
