<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'cs', version '4.1'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Přílohy aktivity úkol';
$string['activitydate:submissionsdue'] = 'Termín:';
$string['activitydate:submissionsopen'] = 'Otevření:';
$string['activitydate:submissionsopened'] = 'Otevřené:';
$string['activityeditor'] = 'Pokyny k činnosti';
$string['activityeditor_help'] = 'Akce, které má student pro tento úkol provést. Zobrazuje se pouze na stránce odevzdání, kde student upravuje a odesílá svůj úkol.';
$string['activityoverview'] = 'Máte jeden či více nových úkolů (klikněte zde pro zobrazení).';
$string['addattempt'] = 'Povolit další pokus';
$string['addnewattempt'] = 'Přidat nový pokus';
$string['addnewattempt_help'] = 'Tímto se vytvoří nový čistý formulář, na kterém můžete začít pracovat od začátku.';
$string['addnewattemptfromprevious'] = 'Přidat nový pokus na základě posledního odevzdání';
$string['addnewattemptfromprevious_help'] = 'Tímto se vytvoří kopie předchozího odevzdání, na které budete moci dále pracovat.';
$string['addnewgroupoverride'] = 'Přidat skupinové přenastavení';
$string['addnewuseroverride'] = 'Přidat přenastavení uživatele';
$string['addsubmission'] = 'Přidat řešení úkolu';
$string['addsubmission_help'] = 'Dosud jste neodevzdali řešení úkolu.';
$string['allocatedmarker'] = 'Přidělení hodnotitelé';
$string['allocatedmarker_help'] = 'Hodnotitelé přidělené tomuto řešení úkolu.';
$string['allowsubmissions'] = 'Povolit uživateli pokračování v hodnocení odevzdaného úkolu.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Detaily úkolu a formulář pro odevzdání bude dostupný od <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Povolit odevzdání úkolů od';
$string['allowsubmissionsfromdate_help'] = 'Je-li povoleno, studenti nebudou moci odevzdat svá řešení před nastaveným okamžikem. Není-li povoleno, studenti mohou odevzdávat okamžitě.';
$string['allowsubmissionsfromdatesummary'] = 'Odevzdat úkol bude možné od <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Povolit změny odevzdaného úkolu';
$string['alwaysshowdescription'] = 'Povolit zobrazení popisu';
$string['alwaysshowdescription_help'] = 'Pokud je zakázáno, výše uvedený popis úkolu bude studentům viditelný pouze ode dne „Povolit odevzdávat od“.';
$string['applytoteam'] = 'Použít hodnocení pro celou skupinu';
$string['assign:addinstance'] = 'Přidat nový úkol';
$string['assign:editothersubmission'] = 'Upravit další řešení studentů';
$string['assign:exportownsubmission'] = 'Exportovat vlastní řešení do portfolia';
$string['assign:grade'] = 'Známkovat úkoly';
$string['assign:grantextension'] = 'Poskytnout prodloužení';
$string['assign:manageallocations'] = 'Správa přidělení hodnotitelů k odevzdaným úkolům';
$string['assign:managegrades'] = 'Revize a zveřejnění známek';
$string['assign:manageoverrides'] = 'Správa  přenastavení úkolu';
$string['assign:receivegradernotifications'] = 'Zasílat oznámení o řešení úkolu hodnotiteli';
$string['assign:releasegrades'] = 'Zveřejnění známek';
$string['assign:revealidentities'] = 'Ukázat identitu studentů';
$string['assign:reviewgrades'] = 'Přezkoumání známek';
$string['assign:showhiddengrader'] = 'Zobrazte totožnost skrytého hodnotitele';
$string['assign:submit'] = 'Odevzdávat úkoly';
$string['assign:view'] = 'Zobrazit úkoly';
$string['assign:viewblinddetails'] = 'Zobrazit identitu studentů v případě anonymního odevzdání';
$string['assign:viewgrades'] = 'Zobrazit známky';
$string['assign:viewownsubmissionsummary'] = 'Zobrazit vlastní souhrn odeslání';
$string['assignfeedback'] = 'Modul hodnocení';
$string['assignfeedbackpluginname'] = 'Modul hodnocení';
$string['assignmentisdue'] = 'Úkol má být hotov do';
$string['assignmentmail'] = '{$a->grader} ohodnotil  vaše řešení úkolu  "{$a->assignment}".

Hodnocení naleznete u svého úkolu na adrese:
{$a->url}.';
$string['assignmentmailhtml'] = '<p>{$a->grader} ohodnotil  vaše řešení úkolu  <i>"{$a->assignment}"</i>. </p>
<p>Hodnocení naleznete u <a href="{$a->url}">svého úkolu</p>.';
$string['assignmentmailsmall'] = '{$a->grader} ohodnotil vaše řešení úkolu "{$a->assignment}". Více informací najdete na stránce s vaším řešením.';
$string['assignmentname'] = 'Název úkolu';
$string['assignmentplugins'] = 'Rozšíření typu úkol';
$string['assignmentsperpage'] = 'Úkolů na stránku';
$string['assignsubmission'] = 'Rozšíření typu odevzdaný úkol';
$string['assignsubmissionpluginname'] = 'Rozšíření typu odevzdaný úkol';
$string['assigntimeleft'] = 'Zbývající čas';
$string['attemptheading'] = 'Pokus č. {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Předchozí pokusy';
$string['attemptnumber'] = 'Číslo pokusu';
$string['attemptreopenmethod'] = 'Další pokusy';
$string['attemptreopenmethod_help'] = 'Toto nastavení určuje, zda student může provádět další pokusy řešení. U každého pokusu se známka a zpětná vazba ukládají a mohou si je zobrazit učitel i student. Dostupné možnosti jsou:


* Nikdy - Odevzdané řešení nelze znovu otevřít.
* Ručně - Učitel může odevzdaná řešení znovu otevřít.
* Automaticky dokud neuspěje - Odevzdané řešení je automaticky otevřeno, dokud za něj není udělena známka potřebná pro splnění úkolu,  která je  nastavena v klasifikaci kurzu.';
$string['attemptreopenmethod_manual'] = 'Ručně';
$string['attemptreopenmethod_none'] = 'Nikdy';
$string['attemptreopenmethod_untilpass'] = 'Automaticky dokud neuspěje';
$string['attemptsettings'] = 'Nastavení pokusů';
$string['availability'] = 'Dostupnost';
$string['back'] = 'Zpět';
$string['backtoassignment'] = 'Zpět k úkolu';
$string['batchoperationconfirmaddattempt'] = 'Povolit další pokus pro označená odevzdaná řešení?';
$string['batchoperationconfirmdownloadselected'] = 'Uložit  označená odevzdaná řešení?';
$string['batchoperationconfirmgrantextension'] = 'Poskytnout prodloužení pro všechny vybrané odevzdané úkoly?';
$string['batchoperationconfirmlock'] = 'Zamknout všechny vybrané odevzdané úkoly?';
$string['batchoperationconfirmremovesubmission'] = 'Odstranit vybraná řešení úkolu?';
$string['batchoperationconfirmreverttodraft'] = 'Vrátit vybrané odevzdané úkoly do stavu návrh?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Nastavit přidělení známek všech vybraných odevzdaných úkolech?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Nastavit zpracování známek všech vybraných odevzdaných úkolech?';
$string['batchoperationconfirmunlock'] = 'Odemknout všechny vybrané odevzdané úkoly?';
$string['batchoperationlock'] = 'zamknout odevzdané úkoly';
$string['batchoperationreverttodraft'] = 'vrátit odevzdaný úkol do stavu návrh';
$string['batchoperationsdescription'] = 'S označenými:';
$string['batchoperationunlock'] = 'odemknout odevzdané úkoly';
$string['batchsetallocatedmarker'] = 'Nastavit přidělení hodnotitele pro {$a} vybrané uživatele.';
$string['batchsetmarkingworkflowstateforusers'] = 'Nastavit zpracování známky pro {$a} vybrané uživatele.';
$string['beginassignment'] = 'Zahájit úkol';
$string['blindmarking'] = 'Anonymní odevzdání';
$string['blindmarking_help'] = 'Anonymní odevzdání skryje pro hodnotitele identitu studentů. Jakmile bude odevzdán úkol nebo hodnocení tohoto úkolu, bude uzamčeno nastavení anonymního odevzdání.';
$string['blindmarkingenabledwarning'] = 'Pro tuto činnost je povoleno anonymní odevzdání úkolu. Hodnocení nebude přidáno do klasifikace, dokud nebudou identifikační údaje studentů zveřejněny prostřednictvím nabídky akcí hodnocení.';
$string['cachedef_overrides'] = 'Informace o přenastavení uživatele a skupiny';
$string['calendardue'] = '{$a} má být hotov do tohoto data';
$string['calendargradingdue'] = '{$a} má už být ohodnocen';
$string['caneditsubmission'] = 'Řešení úkolu můžete upravit po uplynutí časového limitu, bude však označen jako pozdní.';
$string['changefilters'] = 'Změnit filtry';
$string['changeuser'] = 'Změnit uživatele';
$string['choosegradingaction'] = 'Akce oznámkování';
$string['choosemarker'] = 'Výběr ...';
$string['chooseoperation'] = 'Vyberte operaci';
$string['clickexpandreviewpanel'] = 'Kliknutím rozbalíte panel revize známek';
$string['collapsegradepanel'] = 'Sbalit panel známek';
$string['collapsereviewpanel'] = 'Sbalit panel revize známek';
$string['comment'] = 'Komentář';
$string['completiondetail:submit'] = 'Vytvořit odpověď';
$string['completionsubmit'] = 'Student musí  odevzdat úkol';
$string['configshowrecentsubmissions'] = 'Všem zobrazovat upozornění o odevzdaných úkolech v přehledu nedávné činnosti.';
$string['confirmbatchgradingoperation'] = 'Jste si jist, že chcete {$a->operation} pro {$a->count} studenty?';
$string['confirmstart'] = 'Vaše řešení úkolu bude mít časový limit {$a}. Když začnete, časovač začne odpočítávat a nelze jej pozastavit.';
$string['confirmsubmission'] = 'Jste si jisti, že chcete odeslat svou práci k hodnocení? Nebudete moci provádět žádné další změny.';
$string['confirmsubmissionheading'] = 'Odeslat potvrzení';
$string['conversionexception'] = 'Nelze konvertovat úkol. Výjimka je: {$a}.';
$string['couldnotconvertgrade'] = 'Nelze konvertovat hodnocení úkolu uživatele {$a}.';
$string['couldnotconvertsubmission'] = 'Nelze konvertovat odevzdaný úkol uživatele {$a}.';
$string['couldnotcreatecoursemodule'] = 'Nelze vytvořit modul kurzu.';
$string['couldnotcreatenewassignmentinstance'] = 'Nelze vytvořit novou instanci úkolu.';
$string['couldnotfindassignmenttoupgrade'] = 'Nelze nalézt staré instance úkolů k aktualizaci.';
$string['crontask'] = 'Zpracování pro modul úkol na pozadí';
$string['currentassigngrade'] = 'Aktuální známka v úkolu';
$string['currentattempt'] = 'Toto je pokus č. {$a}.';
$string['currentattemptof'] = 'Toto je pokus č. {$a->attemptnumber} (celkem je povoleno {$a->maxattempts} pokusů).';
$string['currentgrade'] = 'Momentální známka v klasifikaci kurzu';
$string['cutoffdate'] = 'Datum ukončení';
$string['cutoffdate_help'] = 'Pokud je nastaveno, po tomto datu nebudou bez prodloužení přijímány úkoly. Pokud není nastaveno, budou úkoly vždy přijaty.';
$string['cutoffdatecolon'] = 'Datum ukončení: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Datum ukončení nemůže být před datem povolujícího odevzdání úkolu.';
$string['cutoffdatevalidation'] = 'Datum ukončení nesmí předcházet termínu odevzdání.';
$string['defaultlayout'] = 'Obnovit původní vzhled';
$string['defaultsettings'] = 'Výchozí nastavení úkolu';
$string['defaultsettings_help'] = 'Tato nastavení definují výchozí hodnoty pro nové úkoly.';
$string['defaultteam'] = 'Výchozí skupina';
$string['deleteallsubmissions'] = 'Odstranit všechna řešení úkolu';
$string['description'] = 'Popis';
$string['disabled'] = 'Zakázáno';
$string['downloadall'] = 'Uložit odevzdané úkoly';
$string['downloadasfolders'] = 'Stáhnout odevzdané úkoly do složek';
$string['downloadasfolders_help'] = 'Odevzdaný úkoly mohou být staženy do složek.. Každý úkol bude umístěn do samostatné složky, se strukturou složek zachované pro všechny podsložky  a soubory nebudou přejmenovány.';
$string['downloadselectedsubmissions'] = 'Uložit vybrané odevzdané úkoly';
$string['duedate'] = 'Termín odevzdání';
$string['duedate_help'] = 'Určuje, do jakého termínu musí studenti odevzdat svoji práci. Řešení je možno odevzdat i po tomto termínu, ale budou v tom případě označena jako pozdní odevzdání. Abyste zabránili odeslání po určitém datu, nastavte datum ukončení,';
$string['duedateaftersubmissionvalidation'] = 'Termín odevzdání musí být po datu povolujícího odevzdání úkolu.';
$string['duedatecolon'] = 'Termín odevzdání: {$a}';
$string['duedatereached'] = 'Termín pro odevzdání tohoto úkolu vypršel';
$string['duedatevalidation'] = 'Datum termínu odevzdání nemůže být před datem povolujícího odevzdání úkolu.';
$string['duplicateoverride'] = 'Duplikovat přenastavení';
$string['editaction'] = 'Akce ...';
$string['editattemptfeedback'] = 'Úprava hodnocení pro pokus č. {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Upravujete hodnocení k odevzdanému řešení, které není nejnovější. Toto je pokus č. {$a->attemptnumber} z celkového počtu {$a->totalattempts}.';
$string['editingstatus'] = 'Stav úprav';
$string['editonline'] = 'Upravit online';
$string['editoverride'] = 'Upravit přenastavení';
$string['editsubmission'] = 'Upravit řešení úkolu';
$string['editsubmission_help'] = 'Stále můžete provádět  změny ve vašem odevzdaném řešení úkolu.';
$string['editsubmissionother'] = 'Upravit řešení úkolu {$a}';
$string['enabled'] = 'Povoleno';
$string['enabletimelimit'] = 'Povolit úkoly s časovým limitem';
$string['enabletimelimit_help'] = 'Pokud je povoleno, můžete nastavit časový limit na stránce nastavení úkolu.';
$string['errornosubmissions'] = 'Žádná odevzdaná řešení ke stažení.';
$string['errorquickgradingvsadvancedgrading'] = 'Hodnocení nebylo uloženo, neboť tento úkol v současné době využívá pokročilé hodnocení';
$string['errorrecordmodified'] = 'Hodnocení nebylo uloženo, protože někdo změnil jeden nebo více záznamů poté, co jste načetli tuto stránku.';
$string['eventallsubmissionsdownloaded'] = 'Všechny odevzdané úkoly se stahují';
$string['eventassessablesubmitted'] = 'Úkol byl odeslán.';
$string['eventbatchsetmarkerallocationviewed'] = 'Zobrazeno přidělení hodnotitelů';
$string['eventbatchsetworkflowstateviewed'] = 'Zobrazení nastavení zpracování známek';
$string['eventextensiongranted'] = 'Bylo poskytnuto prodloužení termínu.';
$string['eventfeedbackupdated'] = 'Komentář aktualizován';
$string['eventfeedbackviewed'] = 'Komentář zobrazen';
$string['eventgradingformviewed'] = 'Hodnotící formulář zobrazen';
$string['eventgradingtableviewed'] = 'Zobrazena tabulka známek';
$string['eventidentitiesrevealed'] = 'Identita studentů byla odhalena.';
$string['eventmarkerupdated'] = 'Přidělený hodnotitel byl aktualizován.';
$string['eventoverridecreated'] = 'Vytvořeno  přenastavení úkolu';
$string['eventoverridedeleted'] = 'Odstraněno přenastavení úkolu';
$string['eventoverrideupdated'] = 'Aktualizováno přenastavení úkolu';
$string['eventremovesubmissionformviewed'] = 'Zobrazeno potvrzení odstranění úkolů.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Zobrazena stránka s potvrzením odhalením identity.';
$string['eventstatementaccepted'] = 'Uživatel přijal prohlášení o odevzdaném úkolu.';
$string['eventsubmissionconfirmationformviewed'] = 'Zobrazen formulář potvrzení řešení úkolu.';
$string['eventsubmissioncreated'] = 'Vytvořeno řešení úkolu.';
$string['eventsubmissionduplicated'] = 'Uživatel zopakoval své řešení úkolu.';
$string['eventsubmissionformviewed'] = 'Zobrazen formulář pro řešení úkolu.';
$string['eventsubmissiongraded'] = 'Odevzdaný úkol byl oznámkován.';
$string['eventsubmissionlocked'] = 'Odevzdaný úkol byl pro uživatele zamčen.';
$string['eventsubmissionremoved'] = 'Řešení úkolu odstraněno.';
$string['eventsubmissionstatusupdated'] = 'Stav odevzdaného úkolu byl aktualizován.';
$string['eventsubmissionstatusviewed'] = 'Byl zobrazen stav odevzdaného úkolu.';
$string['eventsubmissionunlocked'] = 'Odevzdaný úkol byl uživateli odemčen.';
$string['eventsubmissionupdated'] = 'Uživatel uložit svůj úkol.';
$string['eventsubmissionviewed'] = 'Zobrazeno řešení úkolu.';
$string['eventworkflowstateupdated'] = 'Stav zpracování byl aktualizován.';
$string['expandreviewpanel'] = 'Rozbalit panel revize známek';
$string['extensionduedate'] = 'Prodloužený termín odevzdání';
$string['extensionnotafterduedate'] = 'Prodloužený termín odevzdání musí být po termínu odevzdání';
$string['extensionnotafterfromdate'] = 'Prodloužený termín odevzdání musí být po datu umožňující odevzdání úkolu';
$string['feedback'] = 'Hodnocení';
$string['feedbackavailableanonhtml'] = 'Máte nové hodnocení u o vašeho odevzdaného úkolu "<i>{$a->assignment}</i>"<br /><br />
Hodnocení si můžete zobrazit u svého <a href="{$a->url}">odevzdaného úkolu</a>.';
$string['feedbackavailableanonsmall'] = 'Nové hodnocení úkolu {$a->assignment}';
$string['feedbackavailableanontext'] = 'Máte nové hodnocení u o vašeho odevzdaného úkolu "{$a->assignment}"

Hodnocení si můžete zobrazit u svého odevzdaného úkolu:

  {$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} ohodnotil váš odevzdaný úkol "<i>{$a->assignment}</i>".<br /><br />
Hodnocení si můžete zobrazit u svého <a href="{$a->url}">odevzdaného úkolu</a>.';
$string['feedbackavailablesmall'] = '{$a->username} ohodnotil úkol {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} ohodnotil váš odevzdaný úkol "{$a->assignment}".

Hodnocení si můžete zobrazit u svého odevzdaného úkolu:

    {$a->url}';
$string['feedbackplugin'] = 'Modul hodnocení';
$string['feedbackpluginforgradebook'] = 'Modul hodnoncení, který vkládá komentáře do klasifikace';
$string['feedbackpluginforgradebook_help'] = 'Pouze jeden z modulů hodnocení může vkládat údaje do klasifikace kurzu.';
$string['feedbackplugins'] = 'Moduly hodnocení';
$string['feedbacksettings'] = 'Nastavení hodnocení';
$string['feedbacktypes'] = 'Typy hodnocení';
$string['filesubmissions'] = 'Odevzdat soubor(y)';
$string['filter'] = 'Filtr';
$string['filterdraft'] = 'Návrh';
$string['filtergrantedextension'] = 'Prodloužení povoleno';
$string['filternone'] = 'Bez filtru';
$string['filternotsubmitted'] = 'Neodevzdáno';
$string['filterrequiregrading'] = 'Požadováno hodnocení';
$string['filtersubmitted'] = 'Odevzdáno';
$string['fixrescalednullgrades'] = 'Tento úkol obsahuje některé chybné známky.  Tyto známky <a href="{$a->link}"> můžete automaticky opravit </a>. To může mít vliv na součty kurzů.';
$string['fixrescalednullgradesconfirm'] = 'Opravdu chcete opravit chybné známky? Všechny známky, kterých se to týká,  budou odstraněny. Může to mít vliv na součty kurzů.';
$string['fixrescalednullgradesdone'] = 'Známky byly opraveny.';
$string['gradeabovemaximum'] = 'Hodnocení musí být menší nebo rovno {$a}.';
$string['gradebelowzero'] = 'Hodnocení musí být větší nebo rovno nule.';
$string['gradebreakdown'] = 'Rozpis známek';
$string['gradecanbechanged'] = 'Známka může být změněna';
$string['gradechangessaveddetail'] = 'Změny hodnocení byly uloženy';
$string['graded'] = 'Udělena známka';
$string['gradedby'] = 'Hodnoceno';
$string['gradedfollowupsubmit'] = 'Ohodnoceno - znovu odesláno';
$string['gradedon'] = 'Hodnoceno dne';
$string['gradeitem:submissions'] = 'Odevzdané úkoly';
$string['gradelocked'] = 'Známka je v klasifikaci kurzu zamčena nebo přepsána.';
$string['gradeoutof'] = 'Hodnoceno z celkových {$a}';
$string['gradeoutofhelp'] = 'Hodnocení';
$string['gradeoutofhelp_help'] = 'Zde zadejte známku za úkol studenta. Může obsahovat desetetinná místa.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} upravil(a) své vypracování úkolu <em>"{$a->assignment}"</em> (upraveno {$a->timeupdated}).<br /><br />Aktualizované řešení je <a href="{$a->url}">dostupné zde</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} aktualizoval svůj odevzdaný úkol {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} upravil(a) své vypracování úkolu "{$a->assignment}" (upraveno {$a->timeupdated}).

Aktualizované řešení je dostupné na:

{$a->url}.';
$string['gradestudent'] = 'Hodnocení studenta: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Hodnocení {$a}';
$string['grading'] = 'Hodnocení';
$string['gradingchangessaved'] = 'Změny známek byly uloženy';
$string['gradingduedate'] = 'Připomenout mi termín známkování';
$string['gradingduedate_help'] = 'Předpokládaný termín, do kterého by mělo být dokončeno známkování odevzdaných úkolů. Toto datum se používá pro stanovení priorit oznámení Nástěnky učitelům.';
$string['gradingdueduedatevalidation'] = 'Připomenutí termínu známkování podle data nemůže být dříve, než je konečný termín odevzdání úkolu.';
$string['gradingduefromdatevalidation'] = 'Připomenutí termínu známkování podle data nemůže být dříve, než je povoleno odevzdání úkolu.';
$string['gradingmethodpreview'] = 'Kriteria hodnocení';
$string['gradingoptions'] = 'Možnosti';
$string['gradingstatus'] = 'Stav hodnocení';
$string['gradingstudent'] = 'Hodnocený student';
$string['gradingsummary'] = 'Souhrn hodnocení';
$string['grantextension'] = 'Poskytnout prodloužení';
$string['grantextensionforusers'] = 'Poskytnout prodloužení pro {$a} studentů';
$string['groupoverrides'] = 'Přenastavení skupiny';
$string['groupoverridesdeleted'] = 'Přenastavení skupiny odstraněno';
$string['groupsnone'] = 'V tomto kurzu nejsou žádné skupiny, ke kterým máte přístup.';
$string['groupsubmissionsettings'] = 'Nastavení skupinového řešení';
$string['hiddenuser'] = 'Účastník';
$string['hidegrader'] = 'Skrýt studentům identitu hodnotitele';
$string['hidegrader_help'] = 'Pokud je tato možnost povolena, není zobrazena identita uživatele, který hodnotí odeslané zadání, takže studenti nemohou vidět, kdo známkoval jejich práci.

Toto nastavení nemá žádný vliv na pole komentářů na stránce s klasifikací.';
$string['hideshow'] = 'Skrýt/zobrazit';
$string['inactiveoverridehelp'] = '* Toto přepsání není aktivní, protože přístup uživatele k aktivitě je omezen. Důvodem může být přiřazení skupin nebo rolí, jiná omezení přístupu nebo skrytá aktivita.';
$string['indicator:cognitivedepth'] = 'Kognitivní Úkol';
$string['indicator:cognitivedepth_help'] = 'Tento ukazatel je založen na studentem získané kognitivní hloubce v aktivitě úkol.';
$string['indicator:cognitivedepthdef'] = 'Kognitivní Úkol';
$string['indicator:cognitivedepthdef_help'] = 'Během tohoto intervalu analýzy dosáhl účastník tohoto procenta kognitivní angažovanosti nabízené aktivitami Úkol (Úrovně = Bez zobrazení, Zobrazení, Odevzdání, Zobrazení zpětné vazby, Komentář ke zpětné vazbě, Nové odevzdání po zobrazení zpětné vazby)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sociální Úkol';
$string['indicator:socialbreadth_help'] = 'Tento ukazatel je založen na studentem získané sociální šířce v aktivitě úkol.';
$string['indicator:socialbreadthdef'] = 'Sociální Úkol';
$string['indicator:socialbreadthdef_help'] = 'Během tohoto intervalu analýzy dosáhl účastník tohoto procenta sociální angažovanosti nabízené aktivitou Úkol (Úrovně = Bez účasti, Účastník sám, Účastník s ostatními)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'Soubory s návody';
$string['introattachments'] = 'Další soubory';
$string['introattachments_help'] = 'V zadání úkolu mohou být zadány další soubory, jako například šablony pro řešení úkolu.';
$string['invalidfloatforgrade'] = 'Neplatné hodnocení: {$a}';
$string['invalidgradeforscale'] = 'Pro aktuální škálu není poskytnuté hodnocení správné.';
$string['invalidoverrideid'] = 'Neplatné id přenastavení';
$string['lastmodifiedgrade'] = 'Poslední změna (hodnocení)';
$string['lastmodifiedsubmission'] = 'Poslední změna (odevzdaný úkol)';
$string['latesubmissions'] = 'Zpožděné odevzdané úkoly';
$string['latesubmissionsaccepted'] = 'Povoleno do  {$a}';
$string['loading'] = 'Nahrávám ...';
$string['locksubmissionforstudent'] = 'Zamezit odevzdání úkolu studenta: (id={$a->id}, celé jméno={$a->fullname}).';
$string['locksubmissions'] = 'Zamknout odevzdání úkolů';
$string['manageassignfeedbackplugins'] = 'Správa modulů pro hodnocení úkolů';
$string['manageassignsubmissionplugins'] = 'Správa modulů pro odevzdání úkolů';
$string['marker'] = 'Hodnotitel';
$string['markerfilter'] = 'Filtr hodnotitele';
$string['markerfilternomarker'] = 'Žádný hodnotitel';
$string['markingallocation'] = 'Použijte přidělení známek';
$string['markingallocation_help'] = 'Je-li povoleno spolu s postupem známkování, mohou být hodnotitelé přiděleni studentům.';
$string['markingworkflow'] = 'Použít postup známkování';
$string['markingworkflow_help'] = 'Je-li povoleno, musí známky, než jsou studentům zveřejněny, projít řadou stavů postupu. To dovoluje více kol známkováni a umožňuje, aby všechny známky byly studentům zveřejněny najednou.';
$string['markingworkflowstate'] = 'Stav postupu známkování';
$string['markingworkflowstate_help'] = 'Možné stavy workflow  (v závislosti na nastavení):

* Neznámkováno - hodnotitel dosud nezačat
* Známkováno - hodnotitel zahájil známkování, ale dosud neskončil
* Známkování ukončeno - hodnotitel dokončil známkování, ale může se vrátit ke kontrole a opravě
* Recenzováno - recenzent odpovědný za kontrolu kvality provádí recenzi hodnocení
* Připraveno ke zveřejnění - odpovědný učitel je spokojený s označením, ale může počkat  se na zveřejněním známek
* Zveřejněno - studenti mají přístup ke známkám a komentářům';
$string['markingworkflowstateinmarking'] = 'Známkováno';
$string['markingworkflowstateinreview'] = 'Revidováno';
$string['markingworkflowstatenotmarked'] = 'Bez známky';
$string['markingworkflowstatereadyforrelease'] = 'Připraveno ke zveřejnění';
$string['markingworkflowstatereadyforreview'] = 'Známkování dokončeno';
$string['markingworkflowstatereleased'] = 'Zveřejněno';
$string['maxattempts'] = 'Nejvyšší počet pokusů';
$string['maxattempts_help'] = 'Nejvyšší možný počet pokusů na řešení úkolu pro každého studenta. Po dosažení tohoto počtu již nebude možno znovu otevřít řešení úkolu.';
$string['maxgrade'] = 'Maximální známka';
$string['maxperpage'] = 'Maximum úkolů na stránku';
$string['maxperpage_help'] = 'Maximální počet úkolů zobrazených hodnotiteli na stránce pro známkování. Toto nastavení je užitečné, aby se zabránilo překročení časových limitů na kurzech s velmi velkými počty studentů.';
$string['messageprovider:assign_notification'] = 'Oznámení úkolu';
$string['modulename'] = 'Úkol';
$string['modulename_help'] = 'Úkoly umožňují učiteli zadat úkoly, hodnotit odevzdané řešení a komentovat je.

Studenti mohou odevzdat libovolný soubor, jako  dokumenty textových aplikací, tabulky, obrázky nebo audio a video. Alternativně nebo současně může úkol požadovat, aby studenti napsali text přímo do textového pole. Úkol může být použit také pro připomenutí jiných povinností studentů, které neprobíhají přímo v Moodle - např. odevzdání výkresu.

Učitel může zobrazit odevzdané úkoly, připojit zpětnou vazbu a soubor, komentáře nebo nahrát audio odpověď.

Úkoly mohou být hodnoceny jednoduchým přímým hodnocením, případně pokročilou metodou. Výsledná známka je zapsána do klasifikace.';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Úkoly';
$string['moreusers'] = '{$a} více ...';
$string['multipleteams'] = 'Člen více než jedné skupiny';
$string['multipleteams_desc'] = 'Tento úkol vyžaduje řešení úkolu ve skupinách. Jste členem více než jedné skupiny. Aby bylo možné  odeslat řešení úkolu, musíte být členem pouze jedné skupiny. Obraťte se na svého učitele, aby aktualizoval vaše členství ve skupině.';
$string['multipleteamsgrader'] = 'Člen více než jedné skupiny, nemůže odevzdat řešení úkolu.';
$string['newsubmissions'] = 'Odevzdané úkoly';
$string['nextuser'] = 'Další uživatel';
$string['noattempt'] = 'Neodevzdáno';
$string['noclose'] = 'Není datum ukončení';
$string['nofiles'] = 'Žádný soubor.';
$string['nofilters'] = 'Bez filtru';
$string['nograde'] = 'Žádné hodnocení.';
$string['nogroupoverrides'] = 'V současné době neexistují žádná přenastavení skupiny.';
$string['nomoresubmissionsaccepted'] = 'Povoleny pouze pro účastníky, kterým byl prodloužen termín';
$string['none'] = 'Nic';
$string['noonlinesubmissions'] = 'Tento úkol nevyžaduje odpověď online';
$string['noopen'] = 'Není datum zahájení';
$string['nooverridedata'] = 'Je nutné přenastavit alespoň jedno nastavení úkolu.';
$string['nosavebutnext'] = 'Další';
$string['nosubmission'] = 'K tomuto úkolu nebylo nic odevzdáno';
$string['nosubmissionyet'] = 'Dosud nebyla odeslána žádná řešení úkolů';
$string['noteam'] = 'Není členem žádné skupiny';
$string['noteam_desc'] = 'Tento úkol vyžaduje řešení úkolu ve skupinách. Nejste členem žádné skupiny, takže nelze vytvořit řešení úkolu. Obraťte se na učitele, kteří vás přidají do skupiny.';
$string['noteamgrader'] = 'Není členem žádné skupiny, nemůže odevzdat řešení úkolu.';
$string['notgraded'] = 'Nehodnoceno';
$string['notgradedyet'] = 'Známka zatím neudělena';
$string['notifications'] = 'Oznámení';
$string['nouseroverrides'] = 'Momentálně neexistují žádná uživatelská přenastavení.';
$string['nousers'] = 'Žádní uživatelé';
$string['nousersselected'] = 'Nevybrán uživatel';
$string['numberofdraftsubmissions'] = 'Návrhy';
$string['numberofparticipants'] = 'Účastníci';
$string['numberofsubmissionsneedgrading'] = 'Nutno ohodnotit';
$string['numberofsubmissionsneedgradinglabel'] = 'Vyžaduje hodnocení: {$a}';
$string['numberofsubmittedassignments'] = 'Odevzdáno';
$string['numberofteams'] = 'Skupiny';
$string['offline'] = 'Nejsou požadovány odpovědi online';
$string['open'] = 'Otevřeno';
$string['opensubmissionexists'] = 'Otevřené zadání úkolu již existuje.';
$string['outlinegrade'] = 'Hodnocení: {$a}';
$string['outof'] = '{$a->current} ze {$a->total}';
$string['overdue'] = 'Úkol má zpoždění: {$a}';
$string['override'] = 'Přenastavení';
$string['overridedeletegroupsure'] = 'Jste si jisti, že chcete smazat přenastavení pro skupinu {$a}?';
$string['overridedeleteusersure'] = 'Jste si jisti, že chcete smazat přenastavení pro uživatele {$a}?';
$string['overridegroup'] = 'Přenastavit skupinu';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Přenastavit';
$string['overrideuser'] = 'Přenastavit uživatele';
$string['overrideusereventname'] = '{$a->assign} -  Přenastavit';
$string['page-mod-assign-view'] = 'Hlavní stránka úkolu';
$string['page-mod-assign-x'] = 'Jakákoliv stránka úkolu';
$string['paramtimeremaining'] = '{$a} zůstává';
$string['participant'] = 'Účastník';
$string['pluginadministration'] = 'Správa úkolu';
$string['pluginname'] = 'Úkol';
$string['preventsubmissionnotingroup'] = 'Pro odevzdání úkolu vyžadovat zařazení do týmu';
$string['preventsubmissionnotingroup_help'] = 'Pokud je povoleno, nebudou uživatelé, kteří nejsou členy skupiny/týmu, schopni odevzdat úkol.';
$string['preventsubmissions'] = 'Zabránit uživateli provést další odevzdání k tomuto úkolu.';
$string['preventsubmissionsshort'] = 'Zabránit změnám v odevzdaných úkolech';
$string['previous'] = 'Předchozí';
$string['previoususer'] = 'Předchozí uživatel';
$string['privacy:attemptpath'] = 'pokus  {$a}';
$string['privacy:blindmarkingidentifier'] = 'Identifikátor používaný pro anonymní odevzdání';
$string['privacy:gradepath'] = 'známka';
$string['privacy:metadata:assigndownloadasfolders'] = 'Předvolba uživatele, zda by se do složek mělo stahovat více odevzdaných souborů';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Data zpětné vazby pro úkol.';
$string['privacy:metadata:assignfilter'] = 'Možnosti filtrů, jako jsou například "Odevzdáno", "Neodevzdáno", "Požadováno hodnocení" a "Prodloužení povoleno"';
$string['privacy:metadata:assigngrades'] = 'Uloží  známky uživatele v úkolu';
$string['privacy:metadata:assignmarkerfilter'] = 'Filtrování souhrnu úkolu podle známky.';
$string['privacy:metadata:assignmentid'] = 'Identifikátor úkolu';
$string['privacy:metadata:assignmessageexplanation'] = 'Zprávy jsou studentům zasílány prostřednictvím systému zasílání zpráv.';
$string['privacy:metadata:assignoverrides'] = 'Uložení přepíše informace úkolu';
$string['privacy:metadata:assignperpage'] = 'Počet úkolů zobrazených na stránku.';
$string['privacy:metadata:assignquickgrading'] = 'Předvolba, zda se používá rychlé hodnocení nebo ne.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Uloží uživatelské informace o odevzdaných úkolech';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Odevzdané údaje úkolu.';
$string['privacy:metadata:assignuserflags'] = 'Uloží uživatelská metadata, například jako datum prodloužení termínu';
$string['privacy:metadata:assignusermapping'] = 'Mapování pro anonymní odevzdání';
$string['privacy:metadata:assignworkflowfilter'] = 'Filtrování podle různých stavů pracovního postupu.';
$string['privacy:metadata:grade'] = 'Číselná známka pro odevzdané řešení úkolu. Může být stanovena škálou/ pokročilých hodnocení atd., ale bude vždy převedena zpět na číslo s plovoucí desetinnou čárkou.';
$string['privacy:metadata:grader'] = 'ID uživatele hodnotitele.';
$string['privacy:metadata:groupid'] = 'ID skupiny, jemuž je uživatel členem.';
$string['privacy:metadata:latest'] = 'Velmi zjednodušuje dotazy, které chtějí znát informace o posledním pokusu.';
$string['privacy:metadata:mailed'] = 'Byla tomuto uživateli odeslána pošta?';
$string['privacy:metadata:timecreated'] = 'Čas vytvoření';
$string['privacy:metadata:timestarted'] = 'Čas zahájení';
$string['privacy:metadata:userid'] = 'ID uživatele';
$string['privacy:studentpath'] = 'odevzdané úkoly studenta';
$string['privacy:submissionpath'] = 'odevzdaný úkol';
$string['quickgrading'] = 'Rychlé hodnocení';
$string['quickgrading_help'] = 'Rychlé hodnocení umožňuje známkovat úkoly (a očekávané výstupy) v tabulce hodnocení odevzdaných úkolů. Není kompatibilní s pokročilým známkováním a není doporučeno hodnocení více hodnotiteli.';
$string['quickgradingchangessaved'] = 'Změny hodnocení uloženy';
$string['quickgradingresult'] = 'Rychlé hodnocení';
$string['recordid'] = 'Identifikátor';
$string['relativedatessubmissionduedateafter'] = '{$a->datediffstr} po zahájení kurzu';
$string['relativedatessubmissionduedatebefore'] = '{$a->datediffstr} před zahájením kurzu';
$string['relativedatessubmissiontimeleft'] = 'Vypočítáno pro každého studenta';
$string['removeallgroupoverrides'] = 'Smazat všechny přenastavení skupin';
$string['removealluseroverrides'] = 'Smazat všechny přenastavení uživatele';
$string['removesubmission'] = 'Odstranit řešení úkolu';
$string['removesubmissionconfirm'] = 'Opravdu chcete odstranit příspěvek?';
$string['removesubmissionconfirmforstudent'] = 'Opravdu chcete odstranit příspěvek  {$a}?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'Opravdu chcete odstranit příspěvek {$a}? Vezměte prosím na vědomí, že to neresetuje časový limit studenta. Přidáním uživatelského přepsání časového limitu můžete poskytnout více času.';
$string['removesubmissionconfirmwithtimelimit'] = 'Opravdu chcete svůj příspěvek odstranit? Vezměte prosím na vědomí, že to neresetuje váš časový limit.';
$string['removesubmissionforstudent'] = 'Odstranit odevzdané úkoly pro studenta: (id={$a->id}, celé jméno={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Znovuotevření před dokončením není kompatibilní s anonymním odevzdání, protože do odhalení identity studentů nejsou známky uvolněny.';
$string['requireallteammemberssubmit'] = 'Požadováno potvrzení všech členů skupiny';
$string['requireallteammemberssubmit_help'] = 'Je-li povoleno, musí všichni členové skupiny nejprve kliknout na tlačítko Odeslat a teprve poté bude skupinová práce považována za odevzdanou. Pokud je možnost nastavena na „Ne“, bude práce považována za odevzdanou, jakmile kterýkoli člen skupiny klikne na tlačítko Odeslat. (Podmíněno volbou "Ano" u Požadovat, aby studenti klikli na tlačítko Odeslat)';
$string['requiresubmissionstatement'] = 'Požadovat, aby studenti souhlasili s předloženým prohlášením, které se týká všech odevzdaných prací v tomto Úkolu.';
$string['requiresubmissionstatement_help'] = 'Požadovat, aby studenti pro řešení tohoto úkolu přijali předložené prohlášení';
$string['revealidentities'] = 'Odhalit identitu studentů';
$string['revealidentitiesconfirm'] = 'Jste si jisti, že chcete v úkolu zobrazit identitu studentů? Tuto operaci nelze vrátit zpět. Poté, co bude zobrazena identita studentů, budou známky uvolněny do přehledu známek.';
$string['reverttodefaults'] = 'Vrátit úkol na výchozí hodnoty';
$string['reverttodraft'] = 'Vrátit úkol do stavu návrh';
$string['reverttodraftforgroup'] = 'Vrátit řešení úkolu na koncept pro skupinu {$a}.';
$string['reverttodraftforstudent'] = 'Vrátit úkol do stavu návrh pro studenta: (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Vrátit úkol do stavu návrh';
$string['reviewed'] = 'Revidováno';
$string['save'] = 'Uložit';
$string['saveallquickgradingchanges'] = 'Uložit všechny změny hodnocení';
$string['saveandcontinue'] = 'Uložit a pokračovat';
$string['savechanges'] = 'Uložit změny';
$string['savegradingresult'] = 'Známka';
$string['savenext'] = 'Uložit a zobrazit další';
$string['saveoverrideandstay'] = 'Uložit a vložit další přenastavení';
$string['savingchanges'] = 'Uložit změny...';
$string['scale'] = 'Měřítko';
$string['search:activity'] = 'Úkoly - informace';
$string['selectedusers'] = 'Vybraní uživatelé';
$string['selectlink'] = 'Vybrat ...';
$string['selectuser'] = 'Vybrat  {$a}';
$string['sendlatenotifications'] = 'Zaslat oznámení hodnotitelům o pozdním odevzdání úkolu';
$string['sendlatenotifications_help'] = 'Je-li povoleno, hodnotitelé (obvykle učitelé) obdrží zprávu, kdykoli student odevzdá úkol pozdě (tj. po stanoveném termínu odevzdání). Metody zpráv jsou konfigurovatelné.';
$string['sendnotifications'] = 'Zaslat oznámení hodnotitelům o odevzdání úkolu';
$string['sendnotifications_help'] = 'Je-li povoleno, hodnotitelé (obvykle učitelé) obdrží zprávu, kdykoli student odevzdá úkol (brzy, včas i pozdě). Metody zpráv jsou konfigurovatelné.';
$string['sendstudentnotifications'] = 'Informovat studenta';
$string['sendstudentnotifications_help'] = 'Pro odeslání oznámení o aktualizovaném hodnocení nebo zpětné vazbě zaškrtněte toto políčko . Pokud úkol používá pracovní postup hodnocení nebo jsou hodnocení v přehledu známek skrytá, oznámení nebude odesláno, dokud nebude hodnocení uvolněno.';
$string['sendstudentnotificationsdefault'] = 'Výchozí nastavení "Informovat studenta"';
$string['sendstudentnotificationsdefault_help'] = 'Mělo by být při hodnocení každého studenta ve výchozím nastavení zaškrtnuto „Informovat studenta“?';
$string['sendsubmissionreceipts'] = 'Zaslat potvrzení o odevzdání úkolu studentům';
$string['sendsubmissionreceipts_help'] = 'Tento přepínač umožní studentům přijetí zprávy. Studenti obdrží oznámení pokaždé, když úspěšně odevzdají řešení úkolu.';
$string['setmarkerallocationforlog'] = 'Nastavit přidělení hodnotitelů: (id = {$a->id}, jméno = {$a->fullname}, hodnotitel = {$a->marker}).';
$string['setmarkingallocation'] = 'Nastavit přidělení hodnotitele';
$string['setmarkingworkflowstate'] = 'Nastavení postupu známkování';
$string['setmarkingworkflowstateforlog'] = 'Nastavení postupu známkování: (id = {$a->id}, jméno = {$a->fullname}, stav = {$a->state}).';
$string['settings'] = 'Nastavení úkolu';
$string['showrecentsubmissions'] = 'Zobrazovat nedávná odevzdání';
$string['status'] = 'Stav';
$string['studentnotificationworkflowstateerror'] = 'Označení stavu pracovního postupu "Zveřejněno" musí být zasláno studentům.';
$string['submission'] = 'Odevzdané úkoly';
$string['submissionattachments'] = 'Zobrazovat soubory pouze při odesílání řešení';
$string['submissionattachments_help'] = 'Zaškrtnutím tohoto políčka zobrazíte soubory pouze na stránce s odesláním. V opačném případě se soubory zobrazí jak na stránce úkolu, tak na stránce odeslání.';
$string['submissioncopiedhtml'] = '<p>Vytvořili jste kopii odevzdaného úkolu <i>"{$a->assignment}".</i></p>
<p>
Stav vašeho řešení si můžete <a href="{$a->url}">prohlédnout zde</a>.</p>';
$string['submissioncopiedsmall'] = 'Zkopírovali jste předchozí odevzdaný úkol {$a->assignment}';
$string['submissioncopiedtext'] = 'Zkopírovali jste předchozí odevzdaný úkol "{$a->assignment}"

Stav odevzdaného úkolu si můžete prohlédnout:

    {$a->url}';
$string['submissiondrafts'] = 'Požadovat, aby studenti klikli na tlačítko Odeslat';
$string['submissiondrafts_help'] = 'Je-li povoleno, budou studenti muset potvrdit pomocí tlačítka Odeslat, že předložené řešení úkolu je končené. To umožňuje studentům, aby svou pracovní verzi úkolu uchovávali v systému. Pokud se nastavení změní z "Ne" na "Ano" až poté, co již někteří studenti svá řešení předložili, budou odevzdané práce považovány za konečné.';
$string['submissioneditable'] = 'Student může upravit tento úkol';
$string['submissionempty'] = 'Nic nebylo odevzdáno';
$string['submissionlog'] = 'Student: {$a->fullname}, Stav: {$a->status}';
$string['submissionmodified'] = 'Odevzdali jste řešení úkolu. Opusťte prosím tuto stránku a zkuste to znovu.';
$string['submissionmodifiedgroup'] = 'Řešení úkolu bylo někým upraveno. Opusťte prosím tuto stránku a zkuste to znovu.';
$string['submissionnotcopiedinvalidstatus'] = 'Řešení úkolu nelze zkopírovat, protože bylo novým otevřením upraveno.';
$string['submissionnoteditable'] = 'Student nemůže upravit tento úkol';
$string['submissionnotopen'] = 'Tento úkol není otevřen pro odeslání';
$string['submissionnotready'] = 'Tento úkol není připraven k odevzdání:';
$string['submissionplugins'] = 'Moduly odevzdání úkolu';
$string['submissionreceipthtml'] = '<p>Odeslali jste řešení úkolu "<i>{$a->assignment}</i>"</p> <p>
Stav vašeho odevzdaného úkolu <a href="{$a->url}">si můžete zobrazit</a>.</p>';
$string['submissionreceiptotherhtml'] = 'Vaše řešení úkolu "<i>{$a->assignment}</i>"  bylo odesláno.<br /><br />
Stav vašeho odevzdaného úkolu <a href="{$a->url}">si můžete zobrazit</a>.';
$string['submissionreceiptothersmall'] = 'Vaše řešení úkolu {$a->assignment} bylo odesláno.';
$string['submissionreceiptothertext'] = 'Vaše řešení úkolu "{$a->assignment}"  bylo odesláno.
Stav vašeho odevzdaného úkolu si můžete zobrazit:

{$a->url}';
$string['submissionreceipts'] = 'Odeslat potvrzení o odevzdání';
$string['submissionreceiptsmall'] = 'Odeslali jste řešení úkolu {$a->assignment}';
$string['submissionreceipttext'] = 'Odeslali jste
řešení úkolu "{$a->assignment}"

Stav vašeho odevzdaného úkolu můžete zobrazit na:

    {$a->url}';
$string['submissionsclosed'] = 'Odevzdávání uzavřeno';
$string['submissionsettings'] = 'Nastavení odevzdávání úkolů';
$string['submissionslocked'] = 'V tomto úkolu nelze odevzdat práci';
$string['submissionslockedshort'] = 'Změny odevzdaných úkolů nejsou povoleny';
$string['submissionstatement'] = 'Prohlášení';
$string['submissionstatement_help'] = 'Prohlášení, které student musí potvrdit, aby mohl odevzdat svou práci.';
$string['submissionstatementacceptedlog'] = 'Prohlášení přijaté uživatelem {$a}';
$string['submissionstatementdefault'] = 'Prohlašuji, že jsem tento úkol vypracoval/a samostatně, s výjimkou uvedeného využití děl jiných autorů.';
$string['submissionstatementteamsubmission'] = 'Prohlášení o skupinovém řešení úkolu';
$string['submissionstatementteamsubmission_help'] = 'Prohlášení, které student musí potvrdit, aby mohl odevzdat práci své skupiny.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Prohlášení o skupinovém řešení úkolu, které odevzdávají všichni členové skupiny';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Prohlášení, které student musí potvrdit, aby mohl odevzdat práci jako člen skupiny.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Prohlašuji, že toto řešení úkolu je moje práce jako člena skupiny, s výjimkou uvedeného využití děl jiných autorů.';
$string['submissionstatementteamsubmissiondefault'] = 'Prohlašuji, že toto řešení úkolu je práce mé skupiny, s výjimkou uvedeného využití děl jiných autorů.';
$string['submissionstatus'] = 'Stav odevzdání úkolu';
$string['submissionstatus_'] = 'Neodesláno';
$string['submissionstatus_draft'] = 'Návrh (neodesláno)';
$string['submissionstatus_marked'] = 'Udělena známka';
$string['submissionstatus_new'] = 'Žádné řešení úkolu';
$string['submissionstatus_reopened'] = 'Znovu otevřeno';
$string['submissionstatus_submitted'] = 'Odesláno k hodnocení';
$string['submissionstatusheading'] = 'Stav odevzdání úkolu';
$string['submissionsummary'] = '{$a->status}. Poslední změna {$a->timemodified}';
$string['submissionteam'] = 'Skupina';
$string['submissiontypes'] = 'Typy úkolů';
$string['submitaction'] = 'Odeslat';
$string['submitassignment'] = 'Odevzdat úkol';
$string['submitassignment_help'] = 'Po odevzdání úkolu nebudete moci provádět žádné změny.';
$string['submitforgrading'] = 'Odeslat k hodnocení';
$string['submitted'] = 'Odevzdáno';
$string['submittedearly'] = 'Úkoly byly odevzdány {$a} včas';
$string['submittedlate'] = 'Úkoly byly odevzdány {$a} po termínu';
$string['submittedlateshort'] = '{$a} po termínu';
$string['submittedovertime'] = 'Řešení úkolu bylo odesláno {$a} po časovém limitu';
$string['submittedundertime'] = 'Řešení úkolu bylo odesláno {$a} před časovém limitu';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Doplněk komentáře';
$string['subplugintype_assignfeedback_plural'] = 'Doplňky komentáře';
$string['subplugintype_assignsubmission'] = 'Doplněk řešení úkolu';
$string['subplugintype_assignsubmission_plural'] = 'Doplňky řešení úkolu';
$string['teamname'] = 'Tým: {$a}';
$string['teamsubmission'] = 'Studenti odevzdávají úkol ve skupinách';
$string['teamsubmission_help'] = 'Pokud je povoleno, budou studenti rozděleni do skupin na základě výchozí sady skupin nebo vlastního seskupení. Skupinové řešení úkolu bude sdíleno mezi členy skupiny a všichni členové skupiny uvidí vzájemné změny v řešení.';
$string['teamsubmissiongroupingid'] = 'Seskupení pro studentské skupiny';
$string['teamsubmissiongroupingid_help'] = 'Toto seskupení bude v úkolu použito k určení skupin, do kterých budou studenti rozděleni. Pokud není nastavena, použije se výchozí skupina.';
$string['textinstructions'] = 'Návod k úkolu';
$string['timelimit'] = 'Časový limit';
$string['timelimit_help'] = 'Je-li povoleno, časový limit je uveden na stránce úkolu a během úkolu se zobrazuje odpočítávací měřič.';
$string['timelimitnotenabled'] = 'Pro úkol není povolen časový limit.';
$string['timelimitpassed'] = 'Časový limit vypršel';
$string['timemodified'] = 'Naposledy změněno';
$string['timeremaining'] = 'Zbývá';
$string['timeremainingcolon'] = 'Zbývající čas: {$a}';
$string['togglezoom'] = 'Oblast přiblížít/oddálit';
$string['ungroupedusers'] = 'Nastavení "Vyžadovat zařazení do skupiny" je zapnuto a někteří uživatelé nejsou  zařazeni do skupiny, bude jim to bránit v odevzdání úkolu.';
$string['ungroupedusersoptional'] = 'Nastavení „Skupinové řešení“ je povoleno a někteří uživatelé buď nejsou členy žádné skupiny, nebo jsou členy více než jedné skupiny. Mějte prosím na paměti, že tito studenti budou přihlášeni jako členové „Výchozí skupiny“.';
$string['unlimitedattempts'] = 'Bez omezení';
$string['unlimitedattemptsallowed'] = 'Počet pokusů není omezen.';
$string['unlimitedpages'] = 'Bez omezení';
$string['unlocksubmissionforstudent'] = 'Povolit odevzdání studentům: (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'Odemknout odevzdané úkoly';
$string['unsavedchanges'] = 'Neuložené změny';
$string['unsavedchangesquestion'] = 'Některé změny hodnocení nebyly uloženy. Chcete změny uložit a pokračovat?';
$string['updategrade'] = 'Aktualizovat hodnocení';
$string['updatetable'] = 'Uložit a aktualizovat tabulku';
$string['upgradenotimplemented'] = 'Aktualizace není implementována pro modul ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Výchozí nastavení přiřazení uživatele';
$string['userextensiondate'] = 'Prodloužení poskytnuto do: {$a}';
$string['usergrade'] = 'Známka uživatele';
$string['useridlistnotcached'] = 'Změny známek nebyly uloženy, protože nebylo možné určit, pro která řešení byla.';
$string['useroverrides'] = 'Přenastavení uživatele';
$string['useroverridesdeleted'] = 'Přenastavení uživatele odtraněna';
$string['usersnone'] = 'K tomuto úkolu nemají přístup žádní studenti';
$string['usersubmissioncannotberemoved'] = 'Řešení úkolu {$a} nelze odstranit.';
$string['userswhoneedtosubmit'] = 'Uživatelé, kteří potřebují odevzdat úkol:  {$a}';
$string['validmarkingworkflowstates'] = 'Platné stavy postupu známkování';
$string['viewadifferentattempt'] = 'Zobrazit jiný pokus';
$string['viewbatchmarkingallocation'] = 'Zobrazena stránka přidělených hodnotitelů';
$string['viewbatchsetmarkingworkflowstate'] = 'Zobrazena stránka nastavení zpracování známek';
$string['viewfeedback'] = 'Zobrazit hodnocení';
$string['viewfeedbackforuser'] = 'Zobrazit hodnocení pro uživatele: {$a}';
$string['viewfull'] = 'Kompletní zobrazení';
$string['viewfullgradingpage'] = 'Otevřít stránku pro kompletní hodnocení';
$string['viewgradebook'] = 'Zobrazit známky';
$string['viewgrading'] = 'Zobrazit všechny odevzdané úkoly';
$string['viewgradingformforstudent'] = 'Zobrazit známky studenta: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Zobrazit stránku s vlastním odevzdaným úkolem.';
$string['viewownsubmissionstatus'] = 'Zobrazit stránku se stavem vlastního odevzdaného úkolu.';
$string['viewrevealidentitiesconfirm'] = 'Zobrazit stránku s potvrzením odhalené identity studentů';
$string['viewsubmission'] = 'Zobrazit odevzdané úkoly';
$string['viewsubmissionforuser'] = 'Zobrazit odevzdané úkoly uživatele: {$a}';
$string['viewsubmissiongradingtable'] = 'Zobrazit tabulku hodnocení odevzdaných úkolů.';
$string['viewsummary'] = 'Zobrazit přehled';
$string['workflowfilter'] = 'Filtr postupu';
$string['xofy'] = '{$a->x} z {$a->y}';
