<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'ar', version '4.1'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'الإجراء';
$string['actionsmenu'] = 'قائمة الإجراءات';
$string['add'] = 'أضف مدخل';
$string['addcomment'] = 'أضف تعليق';
$string['addedby'] = 'مضاف من قِبل';
$string['addentries'] = 'أضف مدخلات';
$string['addtemplate'] = 'إضافة مظهر الإدخال';
$string['advancedsearch'] = 'بحث متقدم';
$string['allowcomments'] = 'السماح بالتعليقات على المصطلحات';
$string['alttext'] = 'النص البديل';
$string['approvalstatus'] = 'حالة الموافقة';
$string['approve'] = 'اسمح/وافق';
$string['approved'] = 'تم الموافقة';
$string['areacontent'] = 'حقول';
$string['ascending'] = 'تصاعدي';
$string['asearchtemplate'] = 'مظهر البحث المتقدم';
$string['atmaxentry'] = 'لقد قمت بإدخال الحد الأقصى المسموح به للمدخلات!';
$string['authorfirstname'] = 'الاسم الأول';
$string['authorlastname'] = 'الاسم الأخير';
$string['autogenallforms'] = 'قم بتوليد كل القوالب الافتراضية';
$string['autolinkurl'] = 'ربط عنوان الإنترنت تلقائياً';
$string['availablefromdate'] = 'متاح من';
$string['availabletags'] = 'الوسوم المتاحة';
$string['availabletags_help'] = 'الوسوم هي عناصر نائبة في المظهر، والتي سيتم استبدالها ببيانات أو عناصر أخرى، مثل أيقونة التحرير عند تحرير أو معاينة المدخلات.

الحقول تكون بشكل [[fieldname]]. كل الوسوم الأخرى تكون بشكل ##sometag##.

الوسوم المتواجدة في قائمة "الوسوم المتاحة" حصراً يمكن استعمالها للقالب الحالي.';
$string['availabletodate'] = 'متاح إلى';
$string['availabletodatevalidation'] = 'تاريخ متاح إلى لا يمكن أن يكون قبل تاريخ متاح من.';
$string['blank'] = 'فارغ';
$string['buttons'] = 'إجراءات';
$string['bynameondate'] = 'حسب  {$a->name} - {$a->date}';
$string['calendarend'] = '{$a} تُغلق';
$string['calendarstart'] = '{$a} تُفتح';
$string['cancel'] = 'ألغي';
$string['cannotaccesspresentsother'] = 'ليس مسموحاً لك بالوصول إلى التحضيرات المسبقة لمستخدمين آخرين';
$string['cannotadd'] = 'لا يمكن إضافة مدخلات';
$string['cannotapplypreset'] = 'خطأ عند تطبيق التحضير المسبق.';
$string['cannotdeletepreset'] = 'خطأ عند حذف التحضير المسبق';
$string['cannotoverwritepreset'] = 'خطأ عند الكتابة فوق التحضير المسبق!';
$string['cannotunziptopreset'] = 'تعذر فك الضغط إلى مجلد التحضير المسبق';
$string['checkbox'] = 'مربعات التأشير';
$string['chooseexportfields'] = 'إختر الحقل الذي تريد تصديره:';
$string['chooseexportformat'] = 'إختر الصيغة التي تريد التصدير بها:';
$string['chooseorupload'] = 'إختر الملف';
$string['choosepreset'] = 'ملف التحضير المسبق';
$string['closebeforeopen'] = 'لقد حددت تاريخ الإنهاء قبل تاريخ البدء';
$string['columns'] = 'أعمدة';
$string['comment'] = 'تعليق';
$string['commentdeleted'] = 'أحذف التعليق';
$string['commentempty'] = 'التعليق كان فارغا';
$string['comments'] = 'التعليقات';
$string['commentsaved'] = 'تم حفظ التعليقات';
$string['commentsn'] = '{$a} تعليق (تعليقات)';
$string['commentsoff'] = 'ميزة التعليقات غير مُمَكَّنة';
$string['completiondetail:entries'] = 'وضع المدخلات: {$a}';
$string['completionentries'] = 'يتطلب مدخلات';
$string['completionentriescount'] = 'عدد المدخلات';
$string['completionentriesdesc'] = 'أقل عدد من المدخلات المطلوبة: {$a}';
$string['configenablerssfeeds'] = 'هذا المفتاح سيمكن احتمالية تغذيةالاخبار لكل قواعد البيانات. يجب عليك تشغيل إعدادات التغذية يدويا لكل قاعدة بيانات.';
$string['confirmdeletefield'] = 'أنت على وشك حذف هذا الحقل، هل أنت متأكد؟';
$string['confirmdeleterecord'] = 'هل فعلا ترغب في حذف هذا السجل؟';
$string['confirmdeleterecords'] = 'هل أنت متأكد من رغبتك في حذف هذه المدخلات؟';
$string['createactivity'] = 'إنشئ الحقول الخاصة بك لجمع البيانات، أو استعمل تحضيرًا مسبقًا يشتمل على حقول جاهزة.';
$string['createfields'] = 'إنشاء حقول لجمع أنواع مختلفة من البيانات.';
$string['createtemplates'] = 'القوالب تُعرِّف واجهة النشاط العائد لك. بمجرد إنشائك للحقول سيتم إنشاء القوالب تلقائيًا. بدلاً من ذلك، يمكنك استعمال تحضير مسبق، والذي يشتمل على حقول وقوالب.';
$string['csstemplate'] = 'تعليمات CSS مخصصة';
$string['csvfailed'] = 'لا يمكن قراءة البيانات من ملف الـCSV';
$string['csvfile'] = 'ملف CSV';
$string['csvimport'] = 'إستيراد ملف CSV';
$string['csvimport_help'] = 'يمكن استيراد المدخلات عبر ملف نصي عادي يضم قائمة بأسماء الحقول في السطر الأول، ثم البيانات بشكل سجل واحد لكل سطر.';
$string['csvwithselecteddelimiter'] = '<acronym title="قيم مفصولة بفوارز">CSV</acronym> نص مع فاصلة محددة:';
$string['data:addinstance'] = 'إضافة قاعدة بيانات جديدة';
$string['data:approve'] = 'الموافقة على المدخلات وإلغاء موافقاتها';
$string['data:comment'] = 'كتابة التعليقات';
$string['data:exportallentries'] = 'تصدير كل مدخلات قاعدة البيانات';
$string['data:exportentry'] = 'تصدير مدخل قاعدة البيانات';
$string['data:exportownentry'] = 'تصدير مدخل قاعدة البيانات العائد له';
$string['data:exportuserinfo'] = 'تصدير معلومات المستخدم';
$string['data:managecomments'] = 'إدارة التعليقات';
$string['data:manageentries'] = 'إدارة المدخلات';
$string['data:managetemplates'] = 'إدارة القوالب';
$string['data:manageuserpresets'] = 'إدارة جميع القوالب المعدة مسبقاً';
$string['data:rate'] = 'تقييم المدخلات';
$string['data:readentry'] = 'قراءة المدخلات';
$string['data:view'] = 'معاينة نشاط قاعدة البيانات';
$string['data:viewallratings'] = 'معاينة كل التقييمات الخام المقدمة من قبل الأفراد';
$string['data:viewalluserpresets'] = 'معاينة التحضيرات المسبقة لكل المستخدمين';
$string['data:viewanyrating'] = 'معاينة إجمالي التقييمات التي حصل عليها أي شخص';
$string['data:viewentry'] = 'معاينة المدخلات';
$string['data:viewrating'] = 'معاينة التقييم الإجمالي الذي تلقيته';
$string['data:writeentry'] = 'كتابة المدخلات';
$string['date'] = 'تاريخ';
$string['dateentered'] = 'التاريخ المدخل';
$string['datemodified'] = 'آخر تعديل:';
$string['defaultfielddelimiter'] = '(الافتراضي هو حرف الفارزة)';
$string['defaultfieldenclosure'] = '(الافتراضي هو لا شيء)';
$string['defaultsortfield'] = 'اتجاه الفرز الافتراضي';
$string['delcheck'] = 'خانة الحذف بالجملة';
$string['delete'] = 'حذف';
$string['deleteallentries'] = 'حذف كل المدخلات';
$string['deletecomment'] = 'هل فعلا ترغب في حذف هذا التعليق؟';
$string['deleteconfirm'] = 'أتريد حذف التحضير المسبق {$a}؟';
$string['deleted'] = 'تم الحذف';
$string['deleteentry'] = 'حذف الإدخال';
$string['deletefield'] = 'حذف الحقل';
$string['deletenotenrolled'] = 'إحذف مدخلات المستخدمين غير المنضمين';
$string['deletewarning'] = 'حذف التحضير المسبق يزيله من قائمة التحضيرات المسبقة المتاحة في كل المقررات.';
$string['descending'] = 'تنازليا';
$string['directorynotapreset'] = '{$a->directory}  لا يوجد تعيين مسبق: ملفات مفقودة {$a->missing_files}';
$string['disapprove'] = 'إلغاء الموافقة';
$string['download'] = 'تنزيل ملفات';
$string['edit'] = 'تحرير';
$string['editcomment'] = 'تحرير التعليق';
$string['editentry'] = 'تحرير المدخل';
$string['editfield'] = 'تحرير الحقل';
$string['editordisable'] = 'تعطيل المحرر';
$string['editorenable'] = 'تمكين محرر النصوص البرمجية';
$string['editpreset'] = 'تحرير التحضير المسبق';
$string['emptyadd'] = 'مظهر الإضافة فارغ، يجري إنشاء نموذج إفتراضي...';
$string['emptyaddform'] = 'لم تقم بإملاء أي حقول!';
$string['emptypresetname'] = 'اسم التحضير المسبق أو الملف لا يمكن أن يكونا فارغين';
$string['enabletemplateeditorcheck'] = 'هل أنت متأكد من رغبتك في تمكين المحرر؟ هذا قد ينتج عنه تعديل المحتوى عند حفظ القالب.';
$string['entries'] = 'مدخلات';
$string['entrieslefttoadd'] = 'عليك إضافة {$a->entriesleft} مدخل/مدخلات إضافية من أجل إكمال هذا النشاط.';
$string['entrieslefttoaddtoview'] = 'عليك إضافة {$a->entrieslefttoview} مدخل/مدخلات إضافية قبل أن تتمكن من معاينة مدخلات المشاركين الآخرين.';
$string['entry'] = 'مدخل';
$string['entrysaved'] = 'لقد تم حفظ مدخلك';
$string['errormustbeteacher'] = 'ينبغي أن تكون معلمًا لتستعمل هذه الصفحة!';
$string['errormustsupplyvalue'] = 'عليك إعطاء قيمة هنا.';
$string['errorpresetexists'] = 'هناك سلفاً تحضير مسبق بالاسم المحدد.';
$string['errorpresetexistsbutnotoverwrite'] = 'هناك سلفاً تحضير مسبق بالاسم المحدد. إختر اسمًا مختلفًا.';
$string['errorpresetnotfound'] = 'تعذر العثور على التحضير المسبق {$a}.';
$string['eventfieldcreated'] = 'حقل تم إنشاؤه';
$string['eventfielddeleted'] = 'حقل تم حذفه';
$string['eventfieldupdated'] = 'حقل تم تحديثه';
$string['eventrecordcreated'] = 'سجل تم إنشاؤه';
$string['eventrecorddeleted'] = 'سجل تم حذفه';
$string['eventrecordupdated'] = 'سجل تم تحديثه';
$string['eventtemplateupdated'] = 'مظهر تم تحديثه';
$string['eventtemplateviewed'] = 'مظاهر تمت معاينتها';
$string['example'] = 'مثال وحدة قاعدة بيانات';
$string['excel'] = 'Excel';
$string['expired'] = 'عذراً، تم إغلاق هذا النشاط في {$a} وهو غير متوفر الآن.';
$string['export'] = 'تصدير';
$string['exportaszip'] = 'تصدير كملف مضغوط';
$string['exportaszip_help'] = 'التصدير بصيغة الملف المضغوط zip تسمح لك بحفظ القوالب والحقول بمثابة ملف تحضير مسبق لغرض التنزيل. يمكن عندها استيراد الملف المضغوط إلى مقرر آخر.';
$string['exportedtozip'] = 'التصدير لملف مضغوظ مؤقت';
$string['exportentries'] = 'تصدير المدخلات';
$string['exportformat'] = 'صيغة التصدير';
$string['exportoptions'] = 'خيارات التصدير';
$string['exportownentries'] = 'أتريد تصدير مدخلاتك؟ ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'تصدير التحضير المسبق';
$string['failedpresetdelete'] = 'وقع خطأ عند حذف التحضير المسبق.';
$string['fieldadded'] = 'تمت إضافة حقل';
$string['fieldallowautolink'] = 'السماح بالربط التلقائي';
$string['fielddeleted'] = 'تم حذف حقل';
$string['fielddelimiter'] = 'فاصل الحقل';
$string['fielddescription'] = 'وصف الحقل';
$string['fieldenclosure'] = 'مضمن حقل';
$string['fieldheight'] = 'أرتفاع';
$string['fieldheightlistview'] = 'الارتفاع (بالبكسل) للمعاينة بالقائمة';
$string['fieldheightsingleview'] = 'الارتفاع (بالبكسل) للمعاينة المنفردة';
$string['fieldids'] = 'معرف الحقل';
$string['fieldmappings'] = 'تعيينات الحقل';
$string['fieldmappings_help'] = 'هذه القائمة تسمح لك بالاحتفاظ بالبيانات من قاعدة البيانات الموجودة. لحفظ بيانات حقل ما عليك تعيينه إلى حقل جديد حيث ستظهر البيانات. يمكن أيضاً ترك أي حقل فارغاً، دون نسخ أي بيانات فيه. أي حقل قديم غير معين إلى حقل جديد سيتم فقده وبياناته ستتم إزالتها.
يمكنك فقط تعيين الحقول ذات النوع المماثل، لذلك فإن كل قائمة منسدلة ستتضمن حقولاً مختلفة في كل منها. كذلك عليك أن تكون حذراً كي لا تقوم بتعيين حقل قديم إلى أكثر من حقل جديد واحد.';
$string['fieldname'] = 'اسم الحقل';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'الحقول الآتية في ملفك غير معروفة في قاعدة البيانات هذه: {$a}';
$string['fieldoptions'] = 'خيارات (كل واحد في سطر)';
$string['fields'] = 'حقول';
$string['fieldshelp'] = 'إنشئ الحقول لجمع البيانات من مختلف الأنواع. الحقول تُعرِّف الهيكل الذي تظهر به المُدخلات في قاعدة بياناتك.';
$string['fieldsnavigation'] = 'التنقل في حقول ما بعد المرحلة الإعدادية';
$string['fieldupdated'] = 'تم تحديث الحقل';
$string['fieldwidth'] = 'العرض';
$string['fieldwidthlistview'] = 'العُرض (بالبكسل) للمعاينة بالقائمة';
$string['fieldwidthsingleview'] = 'العُرض (بالبكسل) للمعاينة المنفردة';
$string['file'] = 'الملف';
$string['fileencoding'] = 'الترميز';
$string['filesnotgenerated'] = 'لم يتم تشغل كل الملفات: {$a}';
$string['filtername'] = 'ربط تلقائي لقاعدة البيانات';
$string['footer'] = 'تذييل الصفحة';
$string['forcelinkname'] = 'اجبر كتابة اسم للرابط';
$string['foundnorecords'] = 'لم يتم العثور على سجلات (<a href="{$a->reseturl}">مسح الكل</a>)';
$string['foundrecords'] = 'تم العثور على {$a->num} من أصل {$a->max} من السجلات. <a href="{$a->reseturl}">مسح الكل</a>';
$string['fromfile'] = 'من ملف مضغوط';
$string['fromfile_help'] = 'إن ميزة الاستيراد من ملف مضغوط zip تسمح لك باستعراض تحضير مسبق ورفعه بمثابة مظهر وحقول محضرة مسبقاً.';
$string['generateerror'] = 'لم يتم إنشاء كل الملفات!';
$string['header'] = 'راس الصفحة';
$string['headeraddtemplate'] = 'تعريف الواجهة المخصصة لإضافة المدخلات أو تحريرها.';
$string['headerasearchtemplate'] = 'تعريف واجهة البحث المتقدم.';
$string['headercsstemplate'] = 'إضافة أنماط CSS مخصصة للمظاهر.';
$string['headerjstemplate'] = 'إضافة نصوص برمجية مخصصة من Javascript لقوالب: القائمة، المنفرد أو إضافة مُدخل.';
$string['headerlisttemplate'] = 'تعريف شكل ظهور المعاينة بالقائمة.';
$string['headerrsstemplate'] = 'تعريف شكل ظهور المُدخلات في التغذية الإخبارية.';
$string['headersingletemplate'] = 'تعريف شكل ظهور المعاينة المنفردة.';
$string['id'] = 'مُعرَّف المُدخل';
$string['importandapply'] = 'استيراد التحضير المسبق وتطبيقه';
$string['importapreset'] = 'استيراد تحضير مسبق';
$string['importentries'] = 'استورد المدخلات';
$string['importpreset'] = 'استيراد التحضير المسبق';
$string['importpreset_desc'] = 'سيتم تطبيق التحضير المسبق على هذا النشاط، عبر إنشاء الحقول والقوالب.
لن يظهر في قائمة التحضيرات المسبقة.';
$string['importpresetmissingcapability'] = 'ليست لديك صلاحية استيراد التحضير المسبق.';
$string['importsuccess'] = 'تم تطبيق التحضير المسبق.';
$string['includeapproval'] = 'تضمين حالة الموافقة';
$string['includetags'] = 'تضمين الوسوم';
$string['includetime'] = 'تضمين وقت الإضافة/التعديل';
$string['includeuserdetails'] = 'تضمين تفاصيل المستخدم';
$string['indicator:cognitivedepth'] = 'قاعدة البيانات معرفياً';
$string['indicator:cognitivedepth_help'] = 'هذا المؤشر مبني على عمق الحالة المعرفية التي وصلها الطالب في نشاط قاعدة البيانات.';
$string['indicator:cognitivedepthdef'] = 'قاعدة البيانات معرفياً';
$string['indicator:cognitivedepthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة المعرفية التي وفرتها نشاطات قاعدة البيانات خلال فترة التحليل هذه (المستويات = لا معاينة، معاينة، تقديم)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'قاعدة البيانات إجتماعياً';
$string['indicator:socialbreadth_help'] = 'هذا المؤشر مبني على عمق التوسع الاجتماعي الذي وصله الطالب في نشاط قاعدة البيانات.';
$string['indicator:socialbreadthdef'] = 'قاعدة البيانات إجتماعياً';
$string['indicator:socialbreadthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة الاجتماعية التي وفرتها نشاطات المحادثة خلال فترة التحليل هذه (المستويات = لا مشاركة، المشاركة منفرداً)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'لمعاينة قاعدة البيانات يجب توفر مدخلات أكثر';
$string['intro'] = 'الوصف';
$string['invalidaccess'] = 'لم يتم الوصول إلى هذه الصفحة بشكل صحيح';
$string['invalidfieldid'] = 'معرف الحقل غير صحيح';
$string['invalidfieldname'] = 'الرجاء اختيار اسم أخر لهذا الحقل';
$string['invalidfieldtype'] = 'نوع الحقل غير صحيح';
$string['invalidid'] = 'معرف البيانات غير صحيح';
$string['invalidpreset'] = '{$a} ليس تحضيراً مسبقاً.';
$string['invalidrecord'] = 'سجل غير صحيح';
$string['invalidurl'] = 'عنوان الأنترنت المدخل غير صحيح';
$string['jstemplate'] = 'نصوص Javascript مخصصة';
$string['latitude'] = 'خطّ العرض';
$string['latlong'] = 'الإحداثيات';
$string['latlongboth'] = 'خطا الطول والعرض مطلوبان كلاهما.';
$string['latlongdownloadallhint'] = 'قم بتنزيل رابط لكل المدخلات بمثابة KML';
$string['latlongkmllabelling'] = 'كيف يتم تعريف العناصر في ملفات ك أم إل (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'الربط لعرض الخخدمات';
$string['latlongotherfields'] = 'حقول أخرى';
$string['list'] = 'معاينة القائمة';
$string['listtemplate'] = 'قالب المعاينة بالقائمة';
$string['listview'] = 'معاينة قائمة';
$string['longitude'] = 'خط الطول';
$string['manageapproved'] = 'إسمح بتحرير المدخلات الموافق عليها';
$string['manageapproved_help'] = 'السماح للطلاب بتحرير أو الحذف مُدخلاتهم بعد الموافقة عليها. المُدخلات المعدلة ستحتاج إلى إعادة منح الموافقة.';
$string['managefields'] = 'إدارة الحقول';
$string['mapexistingfield'] = 'التعيين إلى {$a}';
$string['mapnewfield'] = 'إنشاء حقل جديد';
$string['mapping:applypresets'] = 'تطبيق التحضير المسبق';
$string['mapping:dialogtitle:usepreset'] = 'أتريد تطبيق التحضير المسبق {$a}؟';
$string['mapping:fieldstocreate'] = 'الحقول التي سيتم إنشاؤها: {$a}';
$string['mapping:fieldstodelete'] = 'الحقول الموجودة التي سيتم حذفها: {$a}';
$string['mapping:mapfields'] = 'تعيين الحقول';
$string['mapping:warningmessagedelete'] = 'إذا كانت الحقول المزمع حذفها من نفس نوع الحقول الجديدة في التحضير المسبق الذي تريد تطبيقه، فقد تتمكن من تعيينها في تعيين الحقول.';
$string['mapping:warningmessagedeleteandcreate'] = 'إذا كانت الحقول المزمع حذفها من نفس نوع الحقول المراد إنشاؤها، فقد تتمكن من تعيينها في تعيين الحقول.';
$string['mappingwarning'] = 'جميع الحقول القديمة التي تم تعينها إلى حقول جديدة ستفقد وكل بيانات هذه الحقول سوف تنقل.';
$string['maxentries'] = 'أقصى عدد من المدخلات';
$string['maxentries_help'] = 'أقصى عدد من المدخلات يسمح للطالب بتقديمها لهذا النشاط.';
$string['maxsize'] = 'الحجم الأقصى';
$string['menu'] = 'قائمة';
$string['menuchoose'] = 'إختر...';
$string['missingdata'] = 'ينبغي تقديم مُعرَّف البيانات أو المكون إلى صنف الحقل.';
$string['missingfield'] = 'خطأ مبرمج: ينبغي عليك تحديد الحقل و/أو البيانات عند تعريف صنف الحقل.';
$string['missingfieldtype'] = 'تعذر العثور على نوع الحقل لـ {$a->name}';
$string['missingfieldtypeimport'] = 'لم يتم استيراد الحقول الآتية لأن أنواع الحقول المتعلقة بها غير منصبة:';
$string['missingfieldtypes'] = 'الحقول الآتية لم يتم تنصيب أنواع الحقول العائدة لها ولن يتم تضمينها في نموذج إضافة المُدخلات. ستحتاج إلى فحص قالب إضافة المدخلات وإزالة أسماء تلك الحقول.';
$string['modulename'] = 'قاعدة بيانات';
$string['modulename_help'] = 'وحدة نشاط قاعدة البيانات تُمكن المشاركين من إنشاء مجموعة من المدخلات وإدامتها والبحث فيها (بعبارة أخرى، سجلات). هيكل المدخلات يُعرَّف من قبل المعلم بمثابة عدد من الحقول. أنواع الحقول تشمل: خانة الاختيار، أزرار الاختيار، قائمة منسدلة، منطقة نص، رابط، صورة، وملف مرفوع.

التصميم المرئي للمعلومات عند إدراج مدخلات قاعدة البيانات، معاينتها، وتحريرها يمكن السيطرة عليه بواسطة مظاهر قاعدة البيانات. يمكن مشاركة نشاطات قاعدة البيانات ما بين المقررات الدراسية كتحضيرات مسبقة، كما يمكن أيضاً للمعلم استيراد مدخلات قاعدة البيانات وتصديرها.

إذا تم تمكين مرشح الربط التلقائي لقاعدة البيانات، سيتم ربط أي مدخلات في قاعدة البيانات تلقائياً حيثما ظهرت الكلمات أو العبارات الخاصة بها في المقرر.

يمكن للمعلم السماح بالتعليقات على المدخلات. يمكن أيضاً تقييم المدخلات من قبل المعلم أو الطلاب (التقييم المناظر). يمكن تجميع التقييمات للخروج بعلامة نهائية قابلة للتسجيل في سجل التقديرات.

نشاطات قاعدة البيانات لديها استعمالات عديدة، مثل:

* مجموعة تعاونية من روابط ويب، كتب، تنقيحات الكتب، مراجع المجلات... إلخ.
* لعرض ما ينشئه الطلاب من صور، ملصقات، مواقع ويب، أو أشعار لأغراض المراجعة وحصد تعليقات الزملاء.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'قواعد بيانات';
$string['more'] = 'المزيد';
$string['moreurl'] = 'المزيد من عناوين الأنترنت';
$string['movezipfailed'] = 'لا يمكن نقل الملف المضغوط';
$string['multientry'] = 'المدخل المكرر';
$string['multimenu'] = 'قائمة (عدة خيارات)';
$string['multipletags'] = 'تم العثور على عدة وسوم! لم يتم حفظ القالب';
$string['newentry'] = 'مدخل جديد';
$string['newfield'] = 'إنشاء حقل';
$string['newfield_help'] = 'الحقل يسمح بإدخال البيانات. كل مدخل في نشاط قاعدة البيانات يمكن أن يكون فيه حقول متعددة ذات أنواع متعددة، مثل حقل التاريخ، الذي يسمح للمشاركين بانتقاء اليوم، الشهر، السنة من قائمة منسدلة، حقل صورة، يسمح للمشاركين برفع ملف صورة، أو حقل خانة تأشير، يسمح للمشاركين بتحديد خيار واحد أو أكثر.

كل حقل ينبغي أن يكون له اسم فريد. وصف الحقل إختياري.';
$string['noaccess'] = 'ليست لديك صلاحية الوصول إلى هذه الصفحة';
$string['nodefinedfields'] = 'القيمة المحددة لا تحوي حقول معرفة!';
$string['nofieldcontent'] = 'لم يتم العثور على محتوى الحقل';
$string['nofieldindatabase'] = 'ليست هناك حقول معرفة لقاعدة البيانات هذه.';
$string['nofields'] = 'لا حقول بعد';
$string['nolisttemplate'] = 'لم يتم تعريف قالب المعاينة بالقائمة بعد';
$string['nomatch'] = 'لم يتم العثور على مدخلات مطابقة!';
$string['nomaximum'] = 'لا يوجد حد أقصى';
$string['nopreviewavailable'] = 'لا يتوفر استعراض لـ {$a}';
$string['norecords'] = 'لا توجد مُدخلات بعد';
$string['nosingletemplate'] = 'لم يتم تعريف قالب المعاينة المنفردة بعد';
$string['notapproved'] = 'بانتظار الموافقة';
$string['notapprovederror'] = 'لم تتم الموافقة على المُدخل بعد';
$string['notemplates'] = 'لا مظاهر بعد';
$string['notinjectivemap'] = 'ليست خريطة قابلة للحقن';
$string['notopenyet'] = 'عذراً، هذا النشاط لن يتاح حتى {$a}';
$string['number'] = 'رقم';
$string['numberrssarticles'] = 'مدخلات في خدمة التغذية الإخبارية';
$string['numnotapproved'] = 'ينتظر';
$string['numrecords'] = '{$a} سجلات';
$string['ods'] = '<acronym title="جدول OpenDocument">ODS</acronym> (OpenOffice)';
$string['openafterclose'] = 'لقد قمت بجعل تاريخ الفتح بعد تاريخ الإغلاق';
$string['optionaldescription'] = 'وصف مختصر (اختياري)';
$string['optionalfilename'] = 'اسم الملف (اختياري)';
$string['other'] = 'أخرى';
$string['overrwritedesc'] = 'استبدال التحضير المسبق بهذا الاسم والكتابة على محتوياته';
$string['overwrite'] = 'الكتابة فوق';
$string['overwritesettings'] = 'الكتابة على الإعدادات الحالية مثل التعليقات، التقييمات، إلخ.';
$string['page-mod-data-x'] = 'أي صفحة لوحدة نشاط قاعدة البيانات';
$string['pagesize'] = 'عدد المدخلات لكل صفحة';
$string['participants'] = 'مشاركون';
$string['picture'] = 'صورة';
$string['pleaseaddsome'] = 'لطفاً، أنشئ بعضاً منها أدناه، أو <a href="{$a}">إختر مجموعة سبق تعريفها</a> للبدء.';
$string['pluginadministration'] = 'إدارة نشاط قاعدة البيانات';
$string['pluginname'] = 'قاعدة البيانات';
$string['portfolionotfile'] = 'التصدير إلى محفظة بدلاً من ملف (csv و leap2a حصراً)';
$string['presetdeleted'] = 'تم حذف التحضير المسبق.';
$string['presetinfo'] = 'سيتم نشر القالب إذا تم حفظه كتحضير مسبق. المستخدمون الآخرون سيتمكنون من استعماله في قواعد بياناتهم.';
$string['presetnotselected'] = 'لم يتم تحديد أي تحضير مسبق.';
$string['presets'] = 'التحضيرات المسبقة';
$string['presetshelp'] = 'إختر التحضير المسبق لاستعماله كنقطة بدء.';
$string['preview'] = 'استعراض {$a}';
$string['privacy:metadata:commentpurpose'] = 'التعليقات على سجلات قاعدة البيانات';
$string['privacy:metadata:data_content'] = 'محتوى الحقل';
$string['privacy:metadata:data_content:content'] = 'المحتوى';
$string['privacy:metadata:data_content:content1'] = 'المحتوى الإضافي 1';
$string['privacy:metadata:data_content:content2'] = 'المحتوى الإضافي 2';
$string['privacy:metadata:data_content:content3'] = 'المحتوى الإضافي 3';
$string['privacy:metadata:data_content:content4'] = 'المحتوى الإضافي 4';
$string['privacy:metadata:data_content:fieldid'] = 'مُعرَّف تعريف الحقل';
$string['privacy:metadata:data_records'] = 'السجلات في نشاط قاعدة البيانات';
$string['privacy:metadata:data_records:approved'] = 'حالة الموافقة';
$string['privacy:metadata:data_records:groupid'] = 'المجموعة';
$string['privacy:metadata:data_records:timecreated'] = 'وقت إنشاء السجل';
$string['privacy:metadata:data_records:timemodified'] = 'وقت آخر تعديل للسجل';
$string['privacy:metadata:data_records:userid'] = 'المستخدم الذي أنشأ السجل';
$string['privacy:metadata:datafieldnpluginsummary'] = 'الحقول لوحدة نشاط قاعدة البيانات';
$string['privacy:metadata:filepurpose'] = 'الملف المرفق بسجل قاعدة البيانات';
$string['privacy:metadata:ratingpurpose'] = 'التقييمات لسجلات قاعدة البيانات';
$string['privacy:metadata:tagpurpose'] = 'الوسوم لسجلات قاعدة البيانات';
$string['radiobutton'] = 'أزاريراختياريه دائرية';
$string['recordapproved'] = 'تمت الموافقة على المصطلح';
$string['recorddeleted'] = 'تم حذف السجل';
$string['recorddisapproved'] = 'المدخل غير موافق عليه';
$string['recordsnotsaved'] = 'لم يتم حفظ أي إدخال، الرجاء التأكد من تنسيق الملف المرفوع.';
$string['recordssaved'] = 'تم حفظ السجل/السجلات';
$string['removealldatatags'] = 'إزالة كل وسوم قاعدة البيانات';
$string['requireapproval'] = 'يتطلب الموافقة';
$string['requireapproval_help'] = 'تنبغي الموافقة على المدخلات من قبل المعلم قبل أن تكون قابلة للمعاينة من طرف الآخرين.';
$string['required'] = 'مطلوبة';
$string['requiredentries'] = 'المدخلات المطلوبة للإكمال (قديم)';
$string['requiredentries_help'] = 'عند تعيينه، سيتم عرض رسالة تبين عدد المدخلات المطلوبة للإكمال. لاحظ أن هذا الإعداد لا صلة له بإكمال النشاط.

بالنسبة إلى المدخلات المطلوبة لإكمال النشاط، ينبغي استعمال الإعداد الجديد لإكمال النشاط \'المدخلات المطلوبة\'. لإزالة هذا الإعداد نهائياً، اضبطه على \'لا شيء\'، ثم إحفظ التغييرات.
لطفاً، استعمل حقول المدخلات المطلوبة في إكمال النشاط بدلاً عنه.';
$string['requiredentriestoview'] = 'المدخلات المطلوبة قبل المعاينة';
$string['requiredentriestoview_help'] = 'عدد المدخلات التي على الطالب تقديمها قبل أن يتمكن من معاينة إدخالات الطلبة الآخرين.

هذا غير متوافق مع مرشح الربط التلقائي لقاعدة البيانات.';
$string['requiredentrieswarning'] = 'هذا الإعداد قد تم استبداله بإعداد آخر لإكمال النشاط، وهو "المدخلات المطلوبة"';
$string['requiredfield'] = 'حقل إجباري';
$string['resetalltemplates'] = 'إعادة تعيين كل القوالب';
$string['resetalltemplatesconfirm'] = 'أنت على وشك إزالة كل القوالب لتحضيرك المسبق. إذا أردت استعادة القوالب لاحقًا، عليك اختيار التحضير المسبق مرة أخرى في تبويب \'التحضيرات المسبقة\'.';
$string['resetalltemplatesconfirmtitle'] = 'أتريد إعادة تعيين كل القوالب؟';
$string['resetsettings'] = 'إعادة تعيين المرشحات';
$string['resettemplate'] = 'إعادة تعيين المظهر';
$string['resettemplateconfirm'] = 'هذا من شأنه إزالة {$a} بشكل دائم لتحضيرك المسبق الحالي.';
$string['resettemplateconfirmtitle'] = 'أتريد إعادة تعيين القالب؟';
$string['resizingimages'] = 'تغير حجم مصغرة صورة';
$string['rows'] = 'صفوف';
$string['rssglobaldisabled'] = 'عطل. مشاهدة متغيرات أعدادات الموقع.';
$string['rsstemplate'] = 'مظهر خدمة التغذية الإخبارية';
$string['rsstitletemplate'] = 'مظهر عنوان خدمة التغذية الإخبارية';
$string['rsstype'] = 'خدمة تغذية المعلومات لهذا النشاط';
$string['save'] = 'حفظ';
$string['saveandadd'] = 'احفظ وأضف إلى أخر';
$string['saveandview'] = 'أحفظ وعاين';
$string['saveaspreset'] = 'نشر التحضير المسبق في هذا الموقع';
$string['saveaspreset_help'] = 'إن ميزة الحفظ بمثابة تحضير مسبق تنشر القوالب والحقول بشكل تحضير مسبق يمكن للآخرين في الموقع استعماله. (يمكنك حذفه من قائمة التحضيرات المسبقة في أي وقت).';
$string['saveaspresetmissingcapability'] = 'المستخدم ليست لديه الصلاحية لحفظ قاعدة البيانات كتحضير مسبق.';
$string['savedataaspreset'] = 'حفظ كل الحقول والقوالب ونشرها كتحضير مسبق في هذ الموقع';
$string['savesettings'] = 'حفظ الإعدادات';
$string['savesuccess'] = 'تم الحفظ بنجاح. <a href="{$a->url}">استعراض التحضير المسبق</a>';
$string['savetemplate'] = 'حفظ القالب';
$string['search'] = 'بحث';
$string['search:activity'] = 'قاعدة البيانات - معلومات النشاط';
$string['search:entry'] = 'قاعدة البيانات - المدخلات';
$string['searchresults'] = 'المُدخلات التي تتضمن "{$a}"';
$string['selectedrequired'] = 'كل المختار مطلوب';
$string['selectexportoptions'] = 'حدد خيارات التصدير';
$string['selectfields'] = 'إختر الحقول';
$string['showall'] = 'عرض كل المدخلات';
$string['showmore'] = 'إظهار المزيد';
$string['single'] = 'معاينة فردية';
$string['singletemplate'] = 'قالب المعاينة الفردية';
$string['singleview'] = 'معاينة منفردة';
$string['startbuilding'] = 'إبدأ ببناء نشاطك';
$string['subplugintype_datafield'] = 'نوع حقل قاعدة البيانات';
$string['subplugintype_datafield_plural'] = 'أنواع حقول قاعدة البيانات';
$string['subplugintype_datapreset'] = 'تحضير مسبق';
$string['subplugintype_datapreset_plural'] = 'إعدادات مسبقة';
$string['tagarea_data_records'] = 'سجلات البيانات';
$string['tags'] = 'الوسوم';
$string['tagsdeleted'] = 'تم حذف وسوم قاعدة البيانات';
$string['teachersandstudents'] = '{$a->teachers} معلمون و {$a->students} طلاب';
$string['templatereset'] = 'إعادة تعيين القالب';
$string['templateresetall'] = 'إعادة تعيين كل القوالب';
$string['templates'] = 'مظاهر';
$string['templatesaved'] = 'تم حفظ القالب';
$string['templatesnavigation'] = 'التنقل في قوالب ما بعد المرحلة الإعدادية';
$string['text'] = 'نص';
$string['textarea'] = 'منطقة النص';
$string['timeadded'] = 'وقت الإضافة';
$string['timemodified'] = 'وقت التعديل';
$string['todatabase'] = 'هذا إلى قاعدة البيانات';
$string['type'] = 'نوع الحقل';
$string['undefinedprocessactionmethod'] = 'لا توجد منهجية عمل محددة في البيانات المعدة مسبقاً للقيام بعمل "{$a}"';
$string['unknown'] = 'حقل غير معروف';
$string['unsupportedexport'] = 'تعذر تصدير ({$a->fieldtype}).';
$string['unsupportedfields'] = 'حقول غير مدعومة';
$string['unsupportedfieldslist'] = 'لا يمكن تصدير الحقول الآتية';
$string['updatefield'] = 'تحديث حقل موجود';
$string['uploadfile'] = 'رفع الملف';
$string['uploadrecords'] = 'رفع المدخلات من ملف';
$string['uploadrecords_help'] = 'يمكن تحميل المدخلات عبر ملف نصي. تنسيق الملف ينبغي أن يكون كما يلي:

* كل سطر في الملف يتضمن سجلاً واحداً
* كل سجل هو سلسلة من البيانات مفصولة بالفاصلة المحددة
* السجل الأول يتضمن قائمة بأسماء الحقول تُعرف صيغة باقي محتويات الملف

طوق الحقل هو رمز يحيط بكل حقل في كل سجل. يمكن تركه عادة دون ضبط.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'الرابط';
$string['usedate'] = 'تضمين في البحث';
$string['usepredefinedset'] = 'استعمل مجموعة معرَّفة مسبقًا';
$string['usepreset'] = 'استعمل هذا التحضير المسبق';
$string['usestandard'] = 'استخدم إعداد مسبق';
$string['usestandard_help'] = 'لاستعمال تحضير مسبق متوافر على مستوى الموقع، إختره من القائمة. (إذا كنت قد أضفت تحضيراً مسبقاً إلى القائمة مستعملاً ميزة الحفظ بمثابة تحضير مسبق، فسيكون لك خيار حذفه).';
$string['viewfromdate'] = 'للقراءة فقط بدءاً من';
$string['viewnavigation'] = 'التنقل في وضع معاينة ما بعد المرحلة الإعدادية';
$string['viewtemplates'] = 'معاينة القوالب';
$string['viewtodate'] = 'للقراءة فقط حتى';
$string['viewtodatevalidation'] = 'تاريخ للقراءة فقط حتى لا يمكن أن يكون قبل تاريخ للقراءة فقط بدءاً من.';
$string['wrongdataid'] = 'مُعرَّف البيانات المعطى خاطئ';
