<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_degrade', language 'uk', version '4.1'.
 *
 * @package     theme_degrade
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['background_color'] = 'Колір фону';
$string['background_color_default'] = 'Тема за замовчуванням {$a}';
$string['background_color_desc'] = 'Колір фону верхньої частини та підвалу!';
$string['background_text_color'] = 'Колір тексту';
$string['background_text_color_desc'] = 'Колір тексту у верхній частині та підвалі!';
$string['choosereadme'] = 'Degrade - це тема, створена з увагою до деталей, щоб принести яскраві кольори в Moodle.';
$string['contact_address'] = 'Адреса';
$string['contact_email'] = 'Електронна пошта';
$string['contact_phone'] = 'Номер телефону';
$string['content_pagefonts'] = 'Додаткові шрифти Google';
$string['content_pagefonts_desc'] = 'Додайте тут посилання @import з Google для додаткових шрифтів.<br>Ви можете додати кілька імпортів.<br><a href="https://fonts.google.com/selection/embed" target="google">Код для вбудовування</a><br><img src="{$a}" style="max-width: 100%;width: 420px;">';
$string['content_type_default'] = 'Moodle за замовчуванням';
$string['content_type_empty'] = '(Немає контенту)';
$string['content_type_footer'] = 'Тип контенту для підвалу';
$string['content_type_footer_desc'] = 'Оберіть тип контенту, який ви хочете відображати в підвалі.';
$string['content_type_home'] = 'Тип контенту для головної сторінки';
$string['content_type_home_desc'] = 'Оберіть тип контенту, який ви хочете відображати на головній сторінці.';
$string['content_type_html'] = 'Сторінка, яка буде створена за допомогою редактора';
$string['continuar'] = 'Продовжити навчання';
$string['countlesson'] = '{$a} урок';
$string['countlessons'] = '{$a} уроки';
$string['course_access'] = 'Доступ до курсу';
$string['course_moore'] = 'Детальніше';
$string['customcss_desc'] = 'Будь-які правила CSS, які ви додаєте в це текстове поле, будуть застосовані до всіх сторінок, що дозволяє легко налаштувати цю тему.';
$string['custommenuitems'] = 'Користувацькі елементи верхнього меню';
$string['custommenuitems_desc'] = 'Ви можете створити користувацьке меню поряд з верхніми меню. Кореневе меню повинно починатися без відступів, а підменю повинні передувати дефісу (-). Кількість дефісів визначає глибину елемента. Таким чином, елементи з одним дефісом з\'являються в підменю під попереднім елементом верхнього рівня, а елементи з двома дефісами з\'являються в підменю під попереднім підменю.
Вміст кожного елемента меню повинен складатися з до трьох елементів (<strong>мітка</strong> | <strong>URL</strong> | <strong>підказка</strong> | <strong>мова</strong>), кожен розділений символом «|».
<ul>
<li><strong>мітка</strong>: Це текст, який буде відображатися в елементі меню. Ви повинні вказати мітку для кожного елемента меню.</li>
<li><strong>URL</strong>: Це URL, на який користувач буде перенаправлений при натисканні на елемент меню. Це необов\'язково, якщо не вказано, елемент не буде мати посилання.</li>
<li><strong>підказка</strong>: Якщо ви вказали URL, ви також можете вибрати підказку для створеного посилання. Це необов\'язково, і якщо не вказано, для елемента меню буде використано мітку як підказку.</li>
<li><strong>мова</strong>: Ви можете додати код мови (або список кодів мов) як четвертий елемент рядка. Рядок буде відображатися тільки якщо користувач вибрав вказану мову(і).</li>
</ul>
Нижче наведено приклад того, як створити користувацьке меню:
<blockquote><pre>
Курси
-Усі курси | /course/
-Мої курси
--Приклад курсу
---Приклад курсу 7 | /course/view.php?id=7
---Приклад курсу 9 | /course/view.php?id=9
--Тестовий курс
---Тестовий курс 2 | /course/view.php?id=2
---Тестовий курс 5 | /course/view.php?id=5
Google
-Google будь-якою мовою | https://google.com/" target="_blank
-Google в Мексиці | https://www.google.com.mx/" target="_blank|Google Label|en
-Google португальською | https://google.com.br/" target="_blank|Google Label|pt,pt_br,pt_br_kids
Сторінка підтримки | https://support.com/" target="_blank
</pre></blockquote>
Для Moodle з підтримкою кількох мов значення <strong>мітки</strong> повинно бути відформатовано як <strong>"langstringname,componentname"</strong>.
<blockquote><pre>
profile,moodle | /user/profile.php
messages,message | /message/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Advanced_theme_settings" target="_blank">Додаткова інформація про меню</a>';
$string['editor_link_footer'] = 'Редагувати Footer Block для мови {$a}';
$string['editor_link_footer_all'] = 'Редагувати Footer Block для всіх мов';
$string['editor_link_home'] = 'Редагувати домашню сторінку для мови {$a}';
$string['editor_link_home_all'] = 'Редагувати домашню сторінку для всіх мов';
$string['favicon'] = 'Іконка сайту';
$string['favicon_desc'] = 'Іконка сайту відображається поруч з назвою сторінки на вкладці браузера. Якщо не надано власної іконки, буде показано стандартну іконку Moodle.';
$string['fontfamily'] = 'Шрифти для тексту сайту';
$string['fontfamily_desc'] = 'Виберіть шрифт, який ви хочете використовувати для тексту на вашому Moodle сайті.';
$string['fontfamily_menus'] = 'Шрифти для меню';
$string['fontfamily_menus_desc'] = 'Виберіть шрифт, який ви хочете використовувати для меню на вашому Moodle сайті.';
$string['fontfamily_sitename'] = 'Шрифт для назви сайту';
$string['fontfamily_sitename_desc'] = 'Шрифт, який буде застосований до назви сайту, якщо лого не надано.';
$string['fontfamily_title'] = 'Шрифти для заголовків';
$string['fontfamily_title_desc'] = 'Виберіть шрифт, який ви хочете використовувати для заголовків на вашому Moodle сайті.';
$string['fontpreview'] = 'Попередній перегляд списку шрифтів';
$string['footer_contact_title'] = 'Назва контактного блоку';
$string['footer_contact_title_default'] = 'Зв\'яжіться з нами';
$string['footer_contact_title_desc'] = 'Введіть назву блоку, який з\'явиться в нижньому колонтитулі з контактними даними.';
$string['footer_description'] = 'Опис';
$string['footer_description_desc'] = 'Опишіть ваш Moodle, що ви робите, і ця інформація буде показана під логотипом в нижньому колонтитулі Moodle';
$string['footer_frontpage_blockcourses_instructor'] = 'Показати ім\'я професора';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'Якщо вибрано, буде показано імена професорів у списку курсів!';
$string['footer_frontpage_blockcourses_text'] = 'Короткий текст, що пояснює блок «{$a}»';
$string['footer_frontpage_blockcourses_text_desc'] = 'Додайте текст, що розповідає про «{$a}»!';
$string['footer_links_title'] = 'Назва блоку посилань';
$string['footer_links_title_default'] = 'Важливі посилання';
$string['footer_show_copywriter'] = 'Показати «Зроблено з ❤️»';
$string['footer_show_copywriter_desc'] = 'Зніміть позначку, якщо хочете приховати «Зроблено з ❤️»';
$string['footer_social_title'] = 'Назва блоку соціальних посилань';
$string['footer_social_title_default'] = 'Слідуйте за нами в соціальних мережах';
$string['footer_social_title_desc'] = 'Введіть назву блоку, який з\'явиться в нижньому колонтитулі з даними ваших соціальних мереж.';
$string['footerblink'] = 'Посилання в Footer Block';
$string['footerblink_desc'] = 'Тут ви можете налаштувати посилання Footer Block, які будуть показані темами.<br>Кожен рядок складається з деякого тексту меню або мовного ключа або тексту, URL посилання (необов\'язково), розділених вертикальними рисками. Наприклад:<br><pre>Підтримка Moodle|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Контактний блок';
$string['footerblock_copywriter'] = 'Зроблено з ❤️';
$string['footerblock_description'] = 'Блок опису';
$string['footerblock_links'] = 'Блок посилань';
$string['footerblock_social'] = 'Соціальний блок';
$string['free_name'] = 'Безкоштовно';
$string['frontpage_about_description'] = 'Опишіть, що ви робите';
$string['frontpage_about_description_desc'] = 'Опишіть максимально за 5 рядків мету вашого Moodle';
$string['frontpage_about_enable'] = 'Увімкнути блок «Про нас»';
$string['frontpage_about_enable_desc'] = 'Якщо вибрано, блок «Про нас» з\'явиться нижче банера!';
$string['frontpage_about_info'] = 'Коробка даних {$a}';
$string['frontpage_about_logo'] = 'Інше лого для показу тут';
$string['frontpage_about_logo_desc'] = 'Якщо встановлено, це лого буде використовуватись тут замість верхнього логотипу.<br>
Порожнє значення використовує верхнє лого!';
$string['frontpage_about_number'] = 'Кількість даних';
$string['frontpage_about_number_desc'] = 'Введіть кількість інформації, згаданої вище';
$string['frontpage_about_text'] = 'Назва даних';
$string['frontpage_about_text_1_defalt'] = 'Курси';
$string['frontpage_about_text_2_defalt'] = 'Викладачі';
$string['frontpage_about_text_3_defalt'] = 'Студенти';
$string['frontpage_about_text_4_defalt'] = 'Уроки';
$string['frontpage_about_text_desc'] = 'Введіть назву даних, які будуть показані на головній сторінці';
$string['frontpage_about_title'] = 'Заголовок блоку "Про"';
$string['frontpage_about_title_default'] = 'Наша глобальна спільнота';
$string['heart'] = 'Якщо вам подобається ця тема, не забудьте натискати ❤️ на сторінці тем <a href="{$a}" target="_blank">натискаючи тут</a>';
$string['instructor'] = 'Інструктор';
$string['login_backgroundcolor'] = 'Колір фону';
$string['login_backgroundcolor_desc'] = 'Виберіть колір фону сторінки відновлення пароля';
$string['login_backgroundfoto'] = 'Фонове зображення';
$string['login_backgroundfoto_desc'] = 'Виберіть фонове зображення для сторінки відновлення пароля/створення облікового запису. За замовчуванням зображення: {$a}';
$string['login_forgot_description'] = 'Текст збоку від екрану забутого пароля';
$string['login_forgot_description_desc'] = 'Текст, який буде відображатися лише на екрані забутого пароля';
$string['login_login_description'] = 'Текст збоку від екрану входу';
$string['login_login_description_desc'] = 'Текст, який буде відображатися лише на екрані входу';
$string['login_signup_description'] = 'Текст збоку від екрану створення облікового запису';
$string['login_signup_description_desc'] = 'Текст, який буде відображатися лише на екрані створення облікового запису';
$string['login_theme'] = 'Тема входу';
$string['login_theme_block'] = 'Центральний білий блок з необов\'язковим фоном';
$string['login_theme_desc'] = 'Виберіть, яку тему ви хочете у зоні входу';
$string['login_theme_image_login'] = 'Фонове зображення і вхід з боку';
$string['login_theme_imagetext_login'] = 'Фонове зображення, текст на фоні зображення і вхід з боку';
$string['login_theme_login'] = 'Тільки екран входу, без бокового зображення';
$string['logo_color'] = 'Кольоровий логотип';
$string['logo_color_desc'] = 'Будь ласка, завантажте ваш кольоровий ЛОГО, якщо хочете включити його зверху. Цей логотип буде відображатися при прокручуванні сторінки, а меню буде відображатися на білому фоні.';
$string['logo_write'] = 'Логотип у верхньому меню при прокручуванні';
$string['logo_write_desc'] = 'Будь ласка, завантажте ваш логотип, якщо хочете включити його зверху. Цей логотип буде відображатися при прокручуванні, і меню буде відображатися на кольоровому фоні.';
$string['matricular'] = 'Зареєструватися';
$string['mycourses_color'] = 'Колір фону блоку';
$string['mycourses_color_desc'] = 'Колір фону для блоку.';
$string['mycourses_icon'] = 'Іконка';
$string['mycourses_icon_desc'] = 'Представницька іконка для блоку. Розмір іконки повинен бути 48x48 пікселів.';
$string['mycourses_info'] = 'Блок {$a}';
$string['mycourses_numblocos'] = 'Без блоків';
$string['mycourses_numblocos_desc'] = 'Скільки зображень ви хочете в SlideShow?';
$string['mycourses_numblocos_nenhum'] = 'Без слайдів на головній сторінці';
$string['mycourses_title'] = 'Короткий заголовок блоку';
$string['mycourses_title_desc'] = 'Короткий та описовий заголовок для блоку.';
$string['mycourses_url'] = 'Посилання на блок';
$string['mycourses_url_desc'] = 'URL, на який потрібно перейти при натисканні на блок. Це може бути зовнішнє посилання або внутрішнє посилання на платформі.';
$string['pluginname'] = 'Degrade';
$string['privacy:metadata'] = 'Тема Degrade не зберігає жодних особистих даних про користувачів.';
$string['settings_about_heading'] = 'Про ваш Moodle';
$string['settings_css_heading'] = 'Шрифти та CSS';
$string['settings_footer_heading'] = 'Блок футера';
$string['settings_icons_change_icons'] = 'Змінити стандартну іконку в списку курсів';
$string['settings_login_heading'] = 'Екран входу';
$string['settings_mycourses_heading'] = 'Блоки моїх курсів';
$string['settings_slideshow_heading'] = 'Слайдшоу';
$string['settings_theme_heading'] = 'Тема';
$string['settings_top_heading'] = 'Верхнє меню';
$string['sitefonts'] = 'Додаткові шрифти Google';
$string['sitefonts_desc'] = 'Вставте код @import з Google Fonts, як зазначено на зображенні нижче. Після збереження, поле "Шрифт сайту" буде оновлено, відображаючи ці шрифти. Ви можете додавати кілька @import за потреби.';
$string['slidecaption_desc'] = 'Введіть текст підпису для слайду';
$string['slideshow_image'] = 'Зображення слайду';
$string['slideshow_image_desc'] = 'Зображення має бути 1250px X 400px.';
$string['slideshow_info'] = 'Слайд {$a}';
$string['slideshow_numslides'] = 'Скільки зображень в Слайдшоу';
$string['slideshow_numslides_desc'] = 'Скільки зображень ви хочете в Слайдшоу?';
$string['slideshow_numslides_nenhum'] = 'Без слайдів на головній';
$string['slideshow_text'] = 'Короткий описовий текст для слайду';
$string['slideshow_text_desc'] = 'Вставте короткий текст про слайд.';
$string['slideshow_url'] = 'Посилання кнопки слайду';
$string['slideshow_url_desc'] = 'Вставте посилання на призначення для кнопки зображення слайду';
$string['social_facebook'] = 'Ваш Facebook';
$string['social_facebook_desc'] = 'URL Facebook вашої організації.';
$string['social_instagram'] = 'Ваш Instagram';
$string['social_instagram_desc'] = 'URL Instagram вашої організації.';
$string['social_linkedin'] = 'Ваш Linkedin';
$string['social_linkedin_desc'] = 'URL Linkedin вашої організації.';
$string['social_twitter'] = 'Ваш Twitter';
$string['social_twitter_desc'] = 'URL Twitter вашої організації.';
$string['social_youtube'] = 'Ваш Youtube';
$string['social_youtube_desc'] = 'URL Youtube вашої організації.';
$string['theme_color-color_buttons'] = 'Колір кнопок';
$string['theme_color-color_buttons_desc'] = 'Колір, що використовується для кнопок, додаючи візуальну згуртованість і підкреслюючи інтерактивні дії.';
$string['theme_color-color_names'] = 'Колір імен';
$string['theme_color-color_names_desc'] = 'Колір, який використовується для підкреслення імен або ідентифікаторів, забезпечуючи ясність та акцент на конкретній текстовій інформації.';
$string['theme_color-color_primary'] = 'Основний колір';
$string['theme_color-color_primary_desc'] = 'Основний колір теми, зазвичай використовується для підкреслення та акцентування елементів.';
$string['theme_color-color_secondary'] = 'Другорядний колір';
$string['theme_color-color_secondary_desc'] = 'Другорядний колір, який доповнює основний колір, використовується для підкреслення вторинних елементів або контрастування з основним кольором.';
$string['theme_color_desc'] = 'Виберіть кольори текстів та кнопок Moodle або натисніть лінію нижче:';
$string['theme_color_heading'] = 'Вибір кольору середовища';
$string['theme_color_sugestion'] = 'Пропозиція кольору';
$string['theme_color_sugestion_text'] = 'Натисніть на лінію, щоб застосувати колір до полів нижче:';
$string['theme_degrade_about_editbooton'] = 'Редагувати блок "Про"';
$string['theme_degrade_frontpage_bloco'] = 'Блок "{$a}"';
$string['theme_degrade_frontpage_home'] = 'Головні блоки';
$string['theme_degrade_mycourses_editbooton'] = 'Редагувати блоки';
$string['theme_degrade_slideshow_editbooton'] = 'Редагувати SlideShow';
$string['theme_login_branco'] = 'Тільки екран входу, без бокового зображення, форма на білому фоні';
$string['top_color_heading'] = 'Колір верхньої панелі при прокручуванні';
$string['top_scroll'] = 'Закріпити меню при прокручуванні сторінки';
$string['top_scroll_background_color'] = 'Колір фону верхнього меню при прокручуванні';
$string['top_scroll_background_color_desc'] = 'Встановіть колір фону при прокручуванні сторінки. Якщо поле порожнє, колір залишатиметься незмінним.';
$string['top_scroll_desc'] = 'Коли увімкнено, меню буде закріплене вгорі екрану, поки ви прокручуєте сторінку, забезпечуючи легкий доступ до опцій меню.';
$string['top_scroll_text_color'] = 'Колір тексту меню при прокручуванні';
$string['top_scroll_text_color_desc'] = 'Встановіть колір тексту меню при прокручуванні сторінки.';
$string['vvveb_footer_contact_title_default'] = 'Зв\'яжіться з нами';
$string['vvveb_home_access'] = 'Доступ до курсу';
$string['vvveb_home_automatically_catalogo'] = 'Не редагуйте. Цей блок буде автоматично замінений каталогом курсів.';
$string['vvveb_home_automatically_category'] = 'Не редагуйте. Цей блок буде автоматично замінений категоріями курсів.';
$string['vvveb_home_automatically_my_course'] = 'Не редагуйте. Цей блок буде автоматично замінений курсами, на які записаний студент.';
$string['vvveb_home_automatically_popular'] = 'Не редагуйте. Цей блок буде автоматично замінений найбільш популярними курсами.';
$string['vvveb_home_catalogo_heading'] = 'Каталог курсів';
$string['vvveb_home_category_heading'] = 'Категорії курсів';
$string['vvveb_home_mycourses_heading'] = 'Мої курси';
$string['vvveb_home_popular_course'] = 'Популярні курси';
$string['vvveb_home_team_subtitle'] = 'Ми - група професіоналів, відданих своїй справі';
$string['vvveb_home_team_title'] = 'Знайомтесь з нашою командою';
