<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'uk', version '4.1'.
 *
 * @package     install
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Некоректна специфікація адмін-каталогу';
$string['admindirname'] = 'Адмін-каталог';
$string['admindirsetting'] = 'Дуже небагато веб-хостів використовують /admin як спеціальний URL для доступу до адмін-центру. На жаль це конфліктує зі стандартним місцем розташування адмін сторінок у Moodle. Ви можете підправити це перейменувавши каталог /admin, та вказати тут нове ім\'я. Наприклад: <br /> <br /><b>moodleadmin</b><br /> <br />Це змінить адмін-лінк у Moodle.';
$string['admindirsettinghead'] = 'Налаштування Адмін-каталогу';
$string['admindirsettingsub'] = 'Дуже небагато веб-хостів використовують /admin як спеціальний URL для доступу до адмін-центру. На жаль це конфліктує зі стандартним місцем розташування адмін сторінок у Moodle. Ви можете підправити це перейменувавши каталог /admin, та вказати тут нове ім\'я. Наприклад: <br /> <br /><b>moodleadmin</b><br /> <br />Це змінить адмін-лінк у Moodle.';
$string['availablelangs'] = 'Список доступних мов';
$string['caution'] = 'Попередження';
$string['chooselanguage'] = 'Виберіть мову';
$string['chooselanguagehead'] = 'Виберіть мову';
$string['chooselanguagesub'] = 'Виберіть мову ТІЛЬКИ для процесу встановлення. Ви зможете вибрати мову для сайту та користувачів пізніше.';
$string['cliadminemail'] = 'Нова ел.адреса адміністратора';
$string['cliadminpassword'] = 'Новий пароль адміністратора';
$string['cliadminusername'] = 'Псевдоім’я адміністратора';
$string['clialreadyconfigured'] = 'Файл config.php вже створено, будь ласка, використовуйте admin/cli/install_database.php, якщо ви хочете встановити цей сайт.';
$string['clialreadyinstalled'] = 'Файл config.php вже створено, будь ласка, використовуйте admin/cli/upgrade.php, якщо ви хочете оновити ваш сайт.';
$string['cliinstallfinished'] = 'Встановлення успішно завершено.';
$string['cliinstallheader'] = 'Moodle {$a} командний рядок програми установки';
$string['climustagreelicense'] = 'У неінтерактивному режимі ви повинні погодитися з ліцензією, вказавши параметр --agree-license';
$string['cliskipdatabase'] = 'Пропуск встановлення бази даних.';
$string['clisupportemail'] = 'Електронна адреса підтримки';
$string['clitablesexist'] = 'Вже наявні таблиці бази даних; Неможливо продовжити встановлення CLI.';
$string['compatibilitysettings'] = 'Перевірка налаштувань РНР...';
$string['compatibilitysettingshead'] = 'Перевірка налаштувань РНР...';
$string['compatibilitysettingssub'] = 'Ваш сервер повинен пройти всі ці тести для запуску налаштування Moodle';
$string['configfilenotwritten'] = 'Інсталяційний скрипт не зміг автоматично створити файл config.php з вибраними вами установками, можлива причина того в правах на запис до кореневого каталогу Moodle. Ви можете вручну скопіювати наступний код у файл та назвати його config.php з тим, щоб потім записати його в цей каталог.';
$string['configfilewritten'] = 'config.php успішно створено';
$string['configurationcomplete'] = 'Налаштування завершено';
$string['configurationcompletehead'] = 'Налаштування завершено';
$string['configurationcompletesub'] = 'Moodle спробує зберегти вашу конфігурацію у файлі в кореневому каталозі Moodle-інсталяції';
$string['database'] = 'База даних';
$string['databasehead'] = 'Налаштування бази даних';
$string['databasehost'] = 'Сервер бази даних';
$string['databasename'] = 'Ім’я бази даних';
$string['databasepass'] = 'Пароль бази даних';
$string['databaseport'] = 'Порт до бази даних';
$string['databasesocket'] = 'Unix socket';
$string['databasetypehead'] = 'Виберіть драйвер бази даних';
$string['databasetypesub'] = 'Moodle підтримує різні сервери баз даних. Будь ласка, зв’яжіться з адміністратором, якщо ви не знаєте, який тип використовувати.';
$string['databaseuser'] = 'Користувач бази даних';
$string['dataroot'] = 'Каталог Даних';
$string['datarooterror'] = 'Каталог Даних не може бути знайденим чи створеним. Вкажіть правильний шлях або створіть його вручну.';
$string['datarootpermission'] = 'Права каталогу даних';
$string['datarootpublicerror'] = 'Для \'Каталогу даних\' ви визначили місце з прямим доступом з Інтернету, вам потрібно використати інший каталог.';
$string['dbconnectionerror'] = 'Не вдалося приєднатися до вказаної вами бази даних. Перевірте, будь ласка, вказані вами налаштування.';
$string['dbcreationerror'] = 'Помилка при створенні бази даних. Не можу створити вказану базу даних, використовуючи надані параметри доступу.';
$string['dbhost'] = 'Сервер бази даних';
$string['dbpass'] = 'Пароль';
$string['dbport'] = 'Порт';
$string['dbprefix'] = 'Префікс таблиць';
$string['dbtype'] = 'Тип';
$string['directorysettings'] = '<p>Будь ласка, підтвердіть місцевстановлення Moodle.</p> <p><b>Web Адреса:</b> Повна web-адреса, за якою можна добратися до Moodle. Якщо ваш сайт має декілька синонімічних адрес, то вкажіть найбільш прийнятну, яку будуть використовувати студенти. Не включайте останній слеш.</p> <p><b>Moodle Каталог:</b> Повний шлях до каталогу, де проведено встановлення. Перевірте коректність введення верхнього/нижнього регістру.</p> <p><b>Каталог даних:</b> Вам потрібен каталог, де Moodle буде зберігати завантажені файли. Цей каталог повинен бути з параметрами читання ТА ЗАПИСУ для web-користувача (зазвичай це \'nobody\' або \'apache\'), але він також повинен бути поза прямим доступом web-сервера.</p>';
$string['directorysettingshead'] = 'Будь ласка, підтвердіть місце встановлення Moodle.';
$string['directorysettingssub'] = '<b>Web Адреса:</b> Повна web-адреса, за якою можна добратися до Moodle. Якщо ваш сайт має декілька синонімічних адрес, то вкажіть найбільш прийнятну, яку будуть використовувати студенти. Не включайте останній слеш. <br /> <br /> <b>Moodle Каталог:</b> Повний шлях до каталогу, де проведено встановлення. Перевірте коректність введення верхнього/нижнього регістру. <br /> <br /> <b>Каталог даних:</b> Вам потрібен каталог, де Moodle буде зберігати завантажені файли. Цей каталог повинен бути з параметрами читання ТА ЗАПИСУ для web-користувача (зазвичай це \'nobody\' або \'apache\'), але він також повинен бути поза прямим доступом web-сервера.';
$string['dirroot'] = 'Moodle Каталог';
$string['dirrooterror'] = 'Moodle Каталог вказано некоректно - там не вдалося знайти інсталяційні файли. Значення нижче повинно бути перевстановлено.';
$string['download'] = 'Завантажити';
$string['downloadlanguagebutton'] = 'Завантажити "{$a}" мовний пакет';
$string['downloadlanguagehead'] = 'Завантажити мовний пакет';
$string['downloadlanguagenotneeded'] = 'Ви можете продовжити процес встановлення використовуючи використовуючи як типовий мовний пакет "{$a}".';
$string['downloadlanguagesub'] = 'Ви вказали на завантаження мовного пакету та продовження встановлення з його використанням.<br /><br />Якщо ви відміните завантаження мовного пакету, то встановлення продовжиться англійською мовою.';
$string['doyouagree'] = 'Ви згодні? (так/ні):';
$string['environmenthead'] = 'Перевірка залежностей...';
$string['environmentsub'] = 'Ми перевіряємо, чи відповідають різні компоненти вашої системи системним вимогам';
$string['environmentsub2'] = 'Кожен Moodle реліз вимагає деяку мінімальну версію РНР та специфічний набір додаткових розширень. Повна перевірка проводиться до початку встановлення або оновлення. Будь ласка, зв’яжіться з вашим адміністратором, якщо ви не знаєте, як встановити нову версію або налаштувати РНР.';
$string['errorsinenvironment'] = 'Залежності перевірити не вдалося!';
$string['fail'] = 'Помилка';
$string['fileuploads'] = 'Завантаження файлів';
$string['fileuploadserror'] = 'Це повинно бути включено';
$string['fileuploadshelp'] = '<p>Здається, на вашому сервері відключено завантаження файлів.</p> <p>Moodle може залишатися встановленим, але без даної можливості ви не зможете завантажувати файли курсів та фотографії користувачів.</p> <p>Для включення можливості завантаження файлів вам (або вашому адміністратору) потрібно відредагувати php.ini на вашому сервері та встановити <b>file_uploads</b> в \'1\'.</p>';
$string['inputdatadirectory'] = 'Каталог даних:';
$string['inputwebadress'] = 'Веб адреса:';
$string['inputwebdirectory'] = 'Moodle каталог:';
$string['installation'] = 'Встановлення';
$string['invaliddbprefix'] = 'Недійсний префікс. Префікс може складатися лише з малих літер та підкреслення.';
$string['langdownloaderror'] = 'На жаль, мова "{$a}" не встановлена. Встановлення буде продовжено англійською мовою.';
$string['langdownloadok'] = 'Мова "{$a}" успішно встановлена. Встановлення буде продовжено цією мовою.';
$string['memorylimit'] = 'Обмеження пам\'яті';
$string['memorylimiterror'] = 'Обмеження пам\'яті в РНР занадто низьке... це може в подальшому створювати Вам проблеми.';
$string['memorylimithelp'] = '<p>Обмеження пам\'яті в PHP на сервері зараз встановлено в {$a}.</p> <p>Це може стати проблемою при подальшій роботі Moodle, коли ви будете мати багато курсів, модулів та користувачів.</p> <p>Ми рекомендуємо сконфігурувати РНР на обмеження пам\'яті не менше 16 Мб. Це можна зробити шляхом:</p> <ol> <li>перекомпіляції PHP з параметром <i>--enable-memory-limit</i>. Це надасть можливість Moodle встановити обмеження пам\'яті самостійно.</li> <li>встановлення в php.ini змінної <b>memory_limit</b> порядка 16Mб. Якщо ви не маєте доступу до цього файлу попросіть адміністратора зробити це для вас.</li> <li>створення в корні сайту файлу .htaccess, куди добавити наступний рядок: <p><blockquote>php_value memory_limit 16M</blockquote></p> <p>Але на деяких серверах це призведе до помилок на <b>всіх</b> сторінках, тоді вам потрібно видалити .htaccess.</p></li> </ol>';
$string['mysqliextensionisnotpresentinphp'] = 'РНР не був зібраний з підтримкою розширення MySQLi. Будь ласка, перевірте ваш php.ini або перекомпілюйте РНР.';
$string['nativeauroramysql'] = 'Aurora MySQL (рідний/auroramysql)';
$string['nativeauroramysqlhelp'] = '<p>У базі даних зберігається більшість налаштувань і даних Moodle, які необхідно налаштувати тут. </p>
<p>Ім’я бази даних, ім’я користувача та пароль є обов’язковими для заповнення; префікс таблиці необов\'язковий. </p>
<p>Ім’я бази даних може містити лише буквено-цифрові символи, долар ($) та підкреслення (_). </p>
<p>Якщо база даних наразі не існує, а вказаний вами користувач має дозвіл, Moodle спробує створити нову базу даних з правильними дозволами та налаштуваннями. Цей драйвер несумісний із застарілою системою MyISAM.</p>';
$string['nativemariadb'] = 'MariaDB (native/mariadb)';
$string['nativemariadbhelp'] = '<p>У базі даних зберігається більшість налаштувань і даних Moodle, які необхідно налаштувати тут. </p>
<p>Ім’я бази даних, ім’я користувача та пароль є обов’язковими для заповнення; префікс таблиці необов\'язковий. </p>
<p>Ім’я бази даних може містити лише буквено-цифрові символи, долар ($) та підкреслення (_). </p>
<p>Якщо база даних наразі не існує, а вказаний вами користувач має дозвіл, Moodle спробує створити нову базу даних з правильними дозволами та налаштуваннями. Цей драйвер несумісний із застарілою системою MyISAM.</p>';
$string['nativemysqli'] = 'Поліпшений MySQL (native/mysqli)';
$string['nativemysqlihelp'] = '<p>У базі даних зберігається більшість налаштувань і даних Moodle, які необхідно налаштувати тут.</p>
<p>Ім’я бази даних, ім’я користувача та пароль є обов’язковими для заповнення; префікс таблиці необов\'язковий.</p>
<p>Ім’я бази даних може містити лише буквено-цифрові символи, долар ($) та підкреслення (_). </p>
<p>Якщо база даних наразі не існує, а вказаний вами користувач має дозвіл, Moodle спробує створити нову базу даних з правильними дозволами та налаштуваннями.</p>';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Тепер вам потрібно налаштувати базу даних, де будуть зберігатися дані Moodle. Ця база даних повинна вже бути створена, а також користувач та пароль для доступу до неї. Префікс таблиць є обов\'язковим.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = 'Тепер вам потрібно налаштувати базу даних, де будуть зберігатися дані Moodle. Ця база даних повинна вже бути створена, а також користувач та пароль для доступу до неї. Префікс таблиць є обов\'язковим.';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Тепер вам потрібно налаштувати базу даних, де будуть зберігатися дані Moodle. Ця база даних повинна вже бути створена, а також користувач та пароль для доступу до неї. Префікс таблиць є обов\'язковим.';
$string['nativesqlsrvnodriver'] = 'Драйвер для Microsoft SQL Server для PHP не встановлений або не налаштований належним чином.';
$string['ociextensionisnotpresentinphp'] = 'РНР не має правильної конфігурації для роботи з розширенням OCI8, яке дозволить зв\'язуватися з OCI8. Будь ласка перевірте ваш php.ini або перекомпілюйте РНР.';
$string['pass'] = 'Є';
$string['paths'] = 'Шляхи';
$string['pathserrcreatedataroot'] = 'Каталог даних ({$a->dataroot}) не може бути створений інсталятором.';
$string['pathshead'] = 'Підтвердження шляхів';
$string['pathsrodataroot'] = 'Каталог даних не має прав запису.';
$string['pathsroparentdataroot'] = 'Батьківський каталог ({$a->parent}) не має прав запису. Каталог даних ({$a->dataroot}) не може бути створений інсталятором.';
$string['pathssubadmindir'] = 'Дуже мало web хостингів використовують /admin в якості спеціальної адреси для доступу до адміністративного управління. На жаль, це суперечить стандартному розташуванню сторінок адміністрування для Moodle. Ви можете виправити це перейменуванням каталогу admin в будь-яке інше ім’я та вписати його тут. Наприклад: <em>moodleadmin</em>. Це виправить посилання на адміністрування в Moodle.';
$string['pathssubdataroot'] = '<p>Каталог, де Moodle буде зберігати всі файли, які завантажують користувачі.</p>
<p>Цей каталог повинен бути доступним для читання та запису для користувача, від імені якого запущено веб-сервер (зазвичай \'www-data\', \'nobody\', або \'apache\').</p>
<p>Цей каталог не повинен бути доступним безпосередньо з Інтернету.</p>
<p>Програма встановлення спробує створити цей каталог, якщо його не існує.</p>';
$string['pathssubdirroot'] = '<p>Повний шлях до каталогу встановлення moodle.</p>';
$string['pathssubwwwroot'] = '<p>Повна веб-адреса, за якою ваш сайт moodle буде доступним. Moodle може мати тільки одну адресу доступу. </p>
<p>Якщо ваш сайт має кілька публічних адрес, то встановіть в DNS перенаправлення всіх інших адрес на цю. </p>
<p>Якщо до вашого сайту мають одночасний доступ і з Інтернету, і з Інтранету (локальної мережі), то забезпечте доступ з локального середовища за публічною адресою. </p>
<p>Якщо ви почали встановлення з неправильної адреси, видаліть все і почніть встановлення заново.</p>';
$string['pathsunsecuredataroot'] = 'Розташування каталогу з даними не є безпечним';
$string['pathswrongadmindir'] = 'Не створено адміністративний каталог';
$string['pgsqlextensionisnotpresentinphp'] = 'В конфігурації РНР відсутнє розширення PGSQL, яке забезпечує зв’язок з PostgreSQL. Будь ласка, виправте ваш php.ini файл або перекомпілюйте РНР.';
$string['phpextension'] = '{$a} РНР розширення';
$string['phpversion'] = 'Версія РНР';
$string['phpversionhelp'] = '<p>Moodle потребує версії PHP принаймні 5.6.5 або 7.1 (7.0.x має деякі обмеження двигуна). </p>
<p>Зараз ви використовуєте версію {$a}. Ви повинні оновити PHP або перейти на хост із новішою версією PHP./<p>';
$string['releasenoteslink'] = 'Для інформації про цю версію Moodle, перегляньте специфікацію релізу на {$a}';
$string['safemode'] = 'Безпечний режим';
$string['safemodeerror'] = 'Moodle може мати проблеми з включеним безпечним режимом';
$string['safemodehelp'] = '<p>Moodle може мати певні проблеми при включеному захищеному режимі, що зазвичай виявляється в неможливості створення нових файлів.</p> <p>Захищений режим зазвичай включають на параноїдальних web-хостах, і вам краще знайти новий хост для свого Moodle-сайту.</p> <p>Ви звичайно можете продовжити встановлення, але пам\'ятайте про можливі проблеми у майбутньому.</p>';
$string['sessionautostart'] = 'Автостарт сесії';
$string['sessionautostarterror'] = 'Це повинно бути відключено';
$string['sessionautostarthelp'] = '<p>Moodle вимагає підтримки роботи сесій і не буде працювати без цього.</p> <p>Сесії повинні бути дозволені у файлі php.ini ... знайдіть параметр session.auto_start.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'РНР має неправильне налаштування розширення SQLite. Будь ласка, перевірте ваш файл php.ini або перекомпілюйте РНР.';
$string['upgradingqtypeplugin'] = 'Оновлення питання / тип модуля';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Ви бачите цю сторінку, тому що ви успішно встановили та запустили  пакет <strong>{$a->packname} {$a->packversion}</strong> на вашому комп’ютері. Вітаємо!';
$string['welcomep30'] = 'Цей випуск <strong>{$a->installername}</strong> включає в себе програми для створення середовища, в якому <strong>Moodle</strong> працюватиме, а саме:';
$string['welcomep40'] = 'Цей пакет також включає <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Використання всіх програм у цьому пакеті регулюється відповідними ліцензіями. Повний
<strong>{$a->installername}</strong> є <a href="http://www.opensource.org/docs/definition_plain.html">відкритим програмним забезпеченням</a> і розповсюджується під ліценцією <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a>.';
$string['welcomep60'] = 'Наступні сторінки будуть проводити вас через процедуру встановлення та налаштування <strong>Moodle</strong> на вашому комп’ютері. Ви можете прийняти автоматичне налаштування, а потім змінити параметри під себе.';
$string['welcomep70'] = 'Натисніть кнопку "Далі" для продовження встановлення <strong>Moodle</strong>.';
$string['wwwroot'] = 'Веб-адреса';
$string['wwwrooterror'] = '"Веб-адреса", здається, не діє - Moodle не вдасться встановити туди. Значення скинуто.';
