<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_invitation', language 'uk', version '4.1'.
 *
 * @package     enrol_invitation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a_day'] = '1 день';
$string['a_minute'] = '1 хвилина';
$string['about_hour'] = 'близько 1 години';
$string['about_x_hours'] = 'приблизно {$a} годин';
$string['accepteddescription'] = 'Користувач id {$a->userid} прийняв запрошення до курсу з id \'{$a->courseid}\'.';
$string['action_extend_invite'] = 'Подовжити запрошення';
$string['action_resend_invite'] = 'Повторно надіслати запрошення';
$string['action_revoke_invite'] = 'Відкликати запрошення';
$string['anonymoususer'] = '(невідомий)';
$string['assignrole'] = 'Призначити роль';
$string['customnamecourse'] = 'Користувацький формат';
$string['customsubjectformat'] = '{$a->shortname} - {$a->fullname}';
$string['default_subject'] = 'Запрошення на курс: {$a}';
$string['defaultinvitevalues'] = 'Значення за замовчуванням для запрошення';
$string['defaultsubjectformat'] = 'Формат теми за замовчуванням';
$string['defaultsubjectformat_desc'] = 'Це формат назви курсу за замовчуванням, який буде використано в темі листа під час надсилання запрошень. Зверніть увагу, що це вплине лише на методи реєстрації, коли вони створюються вперше. Якщо ви виберете <strong>користувацький формат</strong>, ви можете <a href="../admin/tool/customlang/">налаштувати мовний рядок <strong>\'customsubjectformat\'</strong></a> плагіна <strong>enrol_invitation</strong>, використовуючи будь-яке поєднання коротких та/або довгих назв курсів. Коли цей плагін встановлюється вперше, користувацький формат встановлюється на \'shortname - fullname\'.';
$string['deleteddescription'] = 'Користувач id {$a->userid} видалив запрошення до курсу з id \'{$a->courseid}\' для \'{$a->email}\'.';
$string['editenrolment'] = 'Редагувати реєстрацію';
$string['email_clarification'] = 'Ви можете вказати кілька електронних адрес, розділивши їх крапкою з комою, комами, пробілами або новими рядками';
$string['emailaddressnumber'] = 'Електронна адреса';
$string['emailmessageuserenrolled'] = 'Вітаємо,

{$a->userfullname} ({$a->useremail}) прийняв ваше запрошення до курсу {$a->coursefullname} як "{$a->rolename}". Ви можете перевірити статус цього запрошення, переглянувши:

* Список учасників: {$a->courseenrolledusersurl}
* Історію запрошень: {$a->invitehistoryurl}

{$a->sitename}
-------------
{$a->supportemail}';
$string['emailmsghtml'] = 'Попередній перегляд';
$string['emailmsghtml_help'] = '<p>Добрий день!</p>
<p>Ви запрошені приєднатися до такого курсу:</p>
<ul>
  <li>Назва курсу: <b>{$a->coursename}</b></li>
  <li>Дата початку: <b>{$a->start}</b></li>
  <li>Дата закінчення: <b>{$a->end}</b></li>
</ul>
{$a->message}
<p>Увійдіть, щоб підтвердити свою реєстрацію на курс.</p>
<p>Використовуючи це посилання, ви підтверджуєте, що ви є особою, якій надіслано цей лист, і для якої це запрошення призначено.</p>
<p><a class="btn btn-primary" href="{$a->inviteurl}">{$a->acceptinvitation}</a></p>
<p>Якщо ви не бажаєте приєднуватися до цього курсу, будь ласка, використайте наступне посилання:</p>
<p><a class="btn btn-danger" href="{$a->rejecturl}">{$a->rejectinvitation}</a></p>
<p>Зверніть увагу, що ці посилання будуть недійсними після <b>{$a->expiration}</b></p>
<p>Сподіваємося побачити вас на курсі.</p>';
$string['emailmsgunsubscribe'] = '<span class="apple-link">Якщо ви вважаєте, що отримали це повідомлення помилково, вам потрібна допомога або ви не бажаєте отримувати подальші запрошення на цей курс, будь ласка, зв’яжіться з:</span> <a href="mailto:{$a->supportemail}">{$a->supportemail}</a>.';
$string['emailtitleuserenrolled'] = '{$a->userfullname} прийняв запрошення до {$a->coursefullname}.';
$string['enrolconfimation'] = 'Вимагати підтвердження реєстрації від студента';
$string['err_cohortlist'] = 'Або ви повинні вибрати когорти тут.';
$string['err_userlist'] = 'Або ви повинні вибрати користувачів тут.';
$string['event_invitation_accepted'] = 'Прийнято';
$string['event_invitation_attempted'] = 'Спроба';
$string['event_invitation_deleted'] = 'Видалено';
$string['event_invitation_rejected'] = 'Відхилено';
$string['event_invitation_sent'] = 'Надіслано';
$string['event_invitation_updated'] = 'Оновлено';
$string['event_invitation_viewed'] = 'Переглянуто';
$string['expiredtoken'] = 'Токен запрошення недійсний або вже використаний.';
$string['extend_invite_sucess'] = 'Запрошення успішно подовжено';
$string['failuredescription'] = 'Помилка: Користувач id {$a->userid}, курс id \'{$a->courseid}\'. Причина: {$a->errormsg}.';
$string['half_minute'] = 'пів хвилини';
$string['header_email'] = 'Кого ви хочете запросити?';
$string['header_role'] = 'Яку роль ви хочете призначити запрошеному?';
$string['historyactions'] = 'Дії';
$string['historydateexpiration'] = 'Дата закінчення';
$string['historydatesent'] = 'Дата відправлення';
$string['historyexpires_in'] = 'закінчується через';
$string['historyinvitee'] = 'Запрошений';
$string['historyrole'] = 'Роль';
$string['historystatus'] = 'Статус';
$string['historyundefinedrole'] = 'Не вдалося знайти роль. Повторно надішліть запрошення та виберіть іншу роль.';
$string['invitation:config'] = 'Налаштувати екземпляри запрошення';
$string['invitation:enrol'] = 'Запрошувати користувачів';
$string['invitation:manage'] = 'Керування призначенням запрошень';
$string['invitation:unenrol'] = 'Скасувати реєстрацію користувачів з курсу';
$string['invitation:unenrolself'] = 'Скасувати власну реєстрацію з курсу';
$string['invitation_acceptance_title'] = 'Прийняття запрошення';
$string['invitationacceptance'] = '<p>Ви запрошені отримати доступ до <strong>{$a->coursefullname}</strong> як <strong>{$a->rolename}</strong>. Будь ласка, підтвердіть прийняття, щоб приєднатися до цього курсу.</p>';
$string['invitationacceptancebutton'] = 'Прийняти запрошення';
$string['invitationrejectbutton'] = 'Відхилити запрошення';
$string['invitationrejected'] = 'Запрошення відхилено';
$string['invitationsuccess'] = 'Запрошення успішно надіслано';
$string['inviteexpiration'] = 'Термін дії запрошення';
$string['inviteexpiration_desc'] = 'Тривалість дії запрошення (в секундах). За замовчуванням - 2 тижні.';
$string['invitehistory'] = 'Історія запрошень';
$string['inviteusers'] = 'Запросити користувачів';
$string['invtitation_rejected_notice'] = '<p>Це запрошення було відхилено.</p>';
$string['less_minute'] = 'менше хвилини';
$string['less_than_x_seconds'] = 'менше {$a} секунд';
$string['loggedinnot'] = '<p>Ви повинні увійти, перш ніж зможете прийняти це запрошення.</p>';
$string['message'] = 'Повідомлення';
$string['message_help_link'] = 'подивитися, які інструкції отримують запрошені';
$string['noenddate'] = 'Без кінцевої дати';
$string['noinvitationinstanceset'] = 'Не знайдено жодного екземпляра запрошення. Спочатку додайте екземпляр запрошення до вашого курсу.';
$string['noinvitehistory'] = 'Ще не надіслано жодного запрошення';
$string['nopermissiontosendinvitation'] = 'Немає дозволу на надсилання запрошення';
$string['norole'] = 'Будь ласка, виберіть роль.';
$string['notify_inviter'] = 'Повідомити мене на {$a->email}, коли запрошені користувачі приймуть це запрошення';
$string['notsentdescription'] = 'Користувач id {$a->userid} не зміг надіслати запрошення для курсу з id \'{$a->courseid}\' через те, що немає облікового запису з електронною адресою \'{$a->email}\'.';
$string['pluginname'] = 'Запрошення';
$string['pluginname_desc'] = 'Модуль запрошень дозволяє надсилати запрошення електронною поштою. Ці запрошення можуть бути використані лише один раз. Користувачі, які натискають на посилання в листі, автоматично реєструються.';
$string['registeredonly'] = 'Надсилати запрошення лише зареєстрованим користувачам';
$string['registeredonly_help'] = 'Запрошення буде надіслано лише на електронні адреси, які належать зареєстрованим користувачам.';
$string['rejecteddescription'] = 'Користувач id {$a->userid} відхилив запрошення до курсу з id \'{$a->courseid}\'.';
$string['reminder'] = 'Нагадування:';
$string['resend_invite_sucess'] = 'Запрошення успішно повторно надіслано';
$string['returntocourse'] = 'Повернутися до курсу';
$string['returntoinvite'] = 'Надіслати ще одне запрошення';
$string['revoke_invite_sucess'] = 'Запрошення успішно відкликано';
$string['sentdescription'] = 'Користувач id {$a->userid} надіслав запрошення до курсу з id \'{$a->courseid}\' для \'{$a->email}\'.';
$string['show_from_email'] = 'Дозволити запрошеному користувачеві зв’язатися зі мною на {$a->email} (ваша адреса буде в полі "FROM". Якщо не вибрано, поле "FROM" буде {$a->supportemail})';
$string['status'] = 'Дозволити запрошення';
$string['status_desc'] = 'Дозволити користувачам запрошувати людей реєструватися на курс за замовчуванням.';
$string['status_invite_active'] = 'Активне';
$string['status_invite_expired'] = 'Прострочене';
$string['status_invite_invalid'] = 'Недійсне';
$string['status_invite_rejected'] = 'Відхилене';
$string['status_invite_resent'] = 'Повторно надіслане';
$string['status_invite_revoked'] = 'Відкликане';
$string['status_invite_used'] = 'Прийняте';
$string['status_invite_used_expiration'] = '(доступ закінчується {$a})';
$string['status_invite_used_noaccess'] = '(більше не має доступу)';
$string['subject'] = 'Тема';
$string['unenrol'] = 'Скасувати реєстрацію користувача';
$string['unenroluser'] = 'Ви дійсно хочете скасувати реєстрацію користувача "{$a->user}" з курсу "{$a->course}"?';
$string['updateddescription'] = 'Користувач id {$a->userid} подовжив запрошення до курсу з id \'{$a->courseid}\' для \'{$a->email}\'.';
$string['used_by'] = 'від {$a->username} ({$a->roles}, {$a->useremail}) на {$a->timeused}';
$string['usedefaultvalues'] = 'Використати запрошення зі значеннями за замовчуванням';
$string['usernotmatch'] = '<p>Запрошення призначено для іншого користувача.</p>';
$string['vieweddescription'] = 'Користувач id {$a->userid} переглянув запрошення до курсу з id \'{$a->courseid}\'.';
$string['x_days'] = '{$a} днів';
$string['x_minutes'] = '{$a} хвилин';
