"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
import logging

from defence360agent.subsys import svcctl
from defence360agent.utils import (
    is_centos6_or_cloudlinux6,
    CheckRunError,
)  # NOSONAR

logger = logging.getLogger(__name__)

AIBOLIT_SVCNAME = "aibolit-resident"
AIBOLIT_MINIDAEMON_SVCNAME = "minidaemon-aibolit"


async def restart_on_sigs_or_config_update(_, is_updated):
    if is_updated:
        logger.info("ai-bolit service will be restarted")
        if is_centos6_or_cloudlinux6():
            minidaemon_service = svcctl.MinidaemonService()
            await minidaemon_service.restart(AIBOLIT_MINIDAEMON_SVCNAME)
        else:
            aibolit_service = svcctl.adaptor(AIBOLIT_SVCNAME)
            try:
                await aibolit_service.restart()
            except CheckRunError as e:
                if "is masked" in str(e):
                    logger.warning(
                        "Aibolit service is masked, skipping restart during"
                        " installation"
                    )
                    return
                raise
        logger.debug("ai-bolit service restarted")
