"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
from pathlib import Path

from imav.malwarelib.rpc.endpoints.base import (
    SubmitEndpoints as SubmitEndpointsAV,
)
from defence360agent.rpc_tools.lookup import bind
from defence360agent.utils import Scope
from imav.malwarelib.subsys.malware import HackerTrapHitsSaver


class SubmitEndpoints(SubmitEndpointsAV):
    SCOPE = Scope.IM360

    @bind("submit", "false-positive")
    async def submit_fp(self, filename, reason, scanner=None):
        result = await super().submit_fp(filename, reason, scanner=scanner)
        await HackerTrapHitsSaver.update_sa_hits(
            files_to_add=[], files_to_remove=[Path(filename)]
        )
        return result
