"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
from defence360agent.contracts.messages import MessageType
from defence360agent.feature_management.constants import AV, AV_REPORT, FULL
from defence360agent.feature_management.lookup import feature
from imav.malwarelib.model import MalwareHit
from imav.malwarelib.scan.queue_supervisor_sync import (
    QueueSupervisorSync as ScanQueue,
)
from defence360agent.rpc_tools.lookup import CommonEndpoints, bind
from defence360agent.utils import Scope


class MalwareEndpoints(CommonEndpoints):
    SCOPE = Scope.IM360

    def __init__(self, sink):
        super().__init__(sink)
        self.queue = ScanQueue(sink=sink)

    @feature(AV, [FULL, AV_REPORT])
    @bind("malware", "malicious", "restore-from-backup")
    async def restore_from_backup(self, ids, user=None) -> None:
        """Sends RestoreFromBackupTask message and releases the endpoint."""
        hits = MalwareHit.malicious_select(ids, user=user)
        if hits:
            await self._sink.process_message(
                MessageType.RestoreFromBackupTask(hits=hits, initiator=user)
            )
