"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
from imav.malwarelib.rpc.endpoints.base import (
    MaliciousEndpoints as MaliciousEndpointsAV,
)

from defence360agent.rpc_tools.lookup import bind
from defence360agent.feature_management.constants import AV, FULL, AV_REPORT
from defence360agent.feature_management.lookup import feature
from defence360agent.utils import Scope
from imav.malwarelib.subsys.malware import HackerTrapHitsSaver


class MaliciousEndpoints(MaliciousEndpointsAV):
    """Ignore malicious files.

    Additionally, to what `MaliciousEndpointsAV.malicious_move_to_ignore()`
    does, this endpoint also removes submitted filenames from
    malware_standalone_b64.list.`
    """

    SCOPE = Scope.IM360

    @feature(AV, [FULL, AV_REPORT])
    @bind("malware", "malicious", "move-to-ignore")
    async def malicious_move_to_ignore(self, ids, user=None):
        ignored = await self._malicious_move_to_ignore(ids, user)
        await HackerTrapHitsSaver.update_sa_hits(
            files_to_add=[], files_to_remove=ignored
        )

        return len(ignored)
