-- MySQL dump 10.13  Distrib 8.0.43, for Linux (x86_64)
--
-- Host: localhost    Database: mage247p8sd
-- ------------------------------------------------------
-- Server version	8.0.37

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `[[dbprefix]]admin_adobe_ims_webapi`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_adobe_ims_webapi`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]admin_adobe_ims_webapi` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `admin_user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Admin User Id',
  `access_token_hash` varchar(255) DEFAULT NULL COMMENT 'Access Token Hash',
  `access_token` text COMMENT 'Access Token',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `last_check_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Last check time',
  `access_token_expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Access Token Expires At',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[DBPREFIX]]ADMIN_ADOBE_IMS_WEBAPI_ACCESS_TOKEN_HASH` (`access_token_hash`),
  KEY `[[DBPREFIX]]ADMIN_ADOBE_IMS_WEBAPI_ADMIN_USER_ID` (`admin_user_id`),
  CONSTRAINT `[[DBPREFIX]]ADM_ADOBE_IMS_WEBAPI_ADM_USR_ID_[[DBPREFIX]]ADM_USR_USR_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `[[dbprefix]]admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Admin Adobe IMS Webapi';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_adobe_ims_webapi`
--

LOCK TABLES `[[dbprefix]]admin_adobe_ims_webapi` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_adobe_ims_webapi` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]admin_adobe_ims_webapi` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_analytics_usage_version_log`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_analytics_usage_version_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]admin_analytics_usage_version_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Log ID',
  `last_viewed_in_version` varchar(50) NOT NULL COMMENT 'Viewer last viewed on product version',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[DBPREFIX]]ADMIN_ANALYTICS_USAGE_VERSION_LOG_LAST_VIEWED_IN_VERSION` (`last_viewed_in_version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Admin Notification Viewer Log Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_analytics_usage_version_log`
--

LOCK TABLES `[[dbprefix]]admin_analytics_usage_version_log` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_analytics_usage_version_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]admin_analytics_usage_version_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_passwords`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_passwords`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]admin_passwords` (
  `password_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Password ID',
  `user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `password_hash` varchar(255) DEFAULT NULL COMMENT 'Password Hash',
  `expires` int unsigned NOT NULL DEFAULT '0' COMMENT 'Deprecated',
  `last_updated` int unsigned NOT NULL DEFAULT '0' COMMENT 'Last Updated',
  PRIMARY KEY (`password_id`),
  KEY `[[DBPREFIX]]ADMIN_PASSWORDS_USER_ID` (`user_id`),
  CONSTRAINT `[[DBPREFIX]]ADMIN_PASSWORDS_USER_ID_[[DBPREFIX]]ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Admin Passwords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_passwords`
--

LOCK TABLES `[[dbprefix]]admin_passwords` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_passwords` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]admin_passwords` VALUES (1,1,'[[admin_pass]]',0,[[timestamp]]);
/*!40000 ALTER TABLE `[[dbprefix]]admin_passwords` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_system_messages`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_system_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]admin_system_messages` (
  `identity` varchar(100) NOT NULL COMMENT 'Message ID',
  `severity` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  PRIMARY KEY (`identity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Admin System Messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_system_messages`
--

LOCK TABLES `[[dbprefix]]admin_system_messages` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_system_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]admin_system_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_user`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]admin_user` (
  `user_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'User ID',
  `firstname` varchar(32) DEFAULT NULL COMMENT 'User First Name',
  `lastname` varchar(32) DEFAULT NULL COMMENT 'User Last Name',
  `email` varchar(128) DEFAULT NULL COMMENT 'User Email',
  `username` varchar(40) DEFAULT NULL COMMENT 'User Login',
  `password` varchar(255) NOT NULL COMMENT 'User Password',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'User Created Time',
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'User Modified Time',
  `logdate` timestamp NULL DEFAULT NULL COMMENT 'User Last Login Time',
  `lognum` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'User Login Number',
  `reload_acl_flag` smallint NOT NULL DEFAULT '0' COMMENT 'Reload ACL',
  `is_active` smallint NOT NULL DEFAULT '1' COMMENT 'User Is Active',
  `extra` text COMMENT 'User Extra Data',
  `rp_token` text COMMENT 'Reset Password Link Token',
  `rp_token_created_at` timestamp NULL DEFAULT NULL COMMENT 'Reset Password Link Token Creation Date',
  `interface_locale` varchar(16) NOT NULL DEFAULT 'en_US' COMMENT 'Backend interface locale',
  `failures_num` smallint DEFAULT '0' COMMENT 'Failure Number',
  `first_failure` timestamp NULL DEFAULT NULL COMMENT 'First Failure',
  `lock_expires` timestamp NULL DEFAULT NULL COMMENT 'Expiration Lock Dates',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `[[DBPREFIX]]ADMIN_USER_USERNAME` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Admin User Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_user`
--

LOCK TABLES `[[dbprefix]]admin_user` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_user` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]admin_user` VALUES (1,'[[admin_fname]]','[[admin_lname]]','[[admin_email]]','[[admin_username]]','[[admin_pass]]','[[regtime]]','[[regtime]]',NULL,0,0,1,NULL,NULL,NULL,'en_US',0,NULL,NULL);
/*!40000 ALTER TABLE `[[dbprefix]]admin_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_user_expiration`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_user_expiration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]admin_user_expiration` (
  `user_id` int unsigned NOT NULL COMMENT 'User ID',
  `expires_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'User Expiration Date',
  PRIMARY KEY (`user_id`),
  CONSTRAINT `[[DBPREFIX]]ADMIN_USER_EXPIRATION_USER_ID_[[DBPREFIX]]ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Admin User expiration dates table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_user_expiration`
--

LOCK TABLES `[[dbprefix]]admin_user_expiration` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_user_expiration` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]admin_user_expiration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_user_session`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_user_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]admin_user_session` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `session_id` varchar(1) DEFAULT NULL COMMENT 'Deprecated: Session ID value no longer used',
  `user_id` int unsigned DEFAULT NULL COMMENT 'Admin User ID',
  `status` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Current Session status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `ip` varchar(15) NOT NULL COMMENT 'Remote user IP',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADMIN_USER_SESSION_SESSION_ID` (`session_id`),
  KEY `[[DBPREFIX]]ADMIN_USER_SESSION_USER_ID` (`user_id`),
  CONSTRAINT `[[DBPREFIX]]ADMIN_USER_SESSION_USER_ID_[[DBPREFIX]]ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Admin User sessions table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_user_session`
--

LOCK TABLES `[[dbprefix]]admin_user_session` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_user_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]admin_user_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adminnotification_inbox`
--

DROP TABLE IF EXISTS `[[dbprefix]]adminnotification_inbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]adminnotification_inbox` (
  `notification_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Notification ID',
  `severity` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  `title` varchar(255) NOT NULL COMMENT 'Title',
  `description` text COMMENT 'Description',
  `url` varchar(255) DEFAULT NULL COMMENT 'Url',
  `is_read` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification read',
  `is_remove` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification might be removed',
  PRIMARY KEY (`notification_id`),
  KEY `[[DBPREFIX]]ADMINNOTIFICATION_INBOX_SEVERITY` (`severity`),
  KEY `[[DBPREFIX]]ADMINNOTIFICATION_INBOX_IS_READ` (`is_read`),
  KEY `[[DBPREFIX]]ADMINNOTIFICATION_INBOX_IS_REMOVE` (`is_remove`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Adminnotification Inbox';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adminnotification_inbox`
--

LOCK TABLES `[[dbprefix]]adminnotification_inbox` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adminnotification_inbox` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]adminnotification_inbox` VALUES (1,4,'[[regtime]]','Disable Notice','To improve performance, collecting statistics for the Magento Report module is disabled by default. \nYou can enable it in System Config.','',0,0);
/*!40000 ALTER TABLE `[[dbprefix]]adminnotification_inbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adobe_stock_asset`
--

DROP TABLE IF EXISTS `[[dbprefix]]adobe_stock_asset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]adobe_stock_asset` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `media_gallery_id` int unsigned DEFAULT NULL COMMENT 'Media gallery ID',
  `category_id` int unsigned DEFAULT NULL COMMENT 'Category ID',
  `creator_id` int unsigned DEFAULT NULL COMMENT 'Creator ID',
  `is_licensed` int unsigned NOT NULL DEFAULT '0' COMMENT 'Is Licensed',
  `creation_date` varchar(255) DEFAULT NULL COMMENT 'Creation Date',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_ASSET_MDA_GLR_ID_[[DBPREFIX]]MDA_GLR_ASSET_ID` (`media_gallery_id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_ASSET_ID` (`id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_ASSET_CATEGORY_ID` (`category_id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_ASSET_CREATOR_ID` (`creator_id`),
  CONSTRAINT `[[DBPREFIX]]ADOBE_STOCK_ASSET_CATEGORY_ID_[[DBPREFIX]]ADOBE_STOCK_CATEGORY_ID` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]adobe_stock_category` (`id`) ON DELETE SET NULL,
  CONSTRAINT `[[DBPREFIX]]ADOBE_STOCK_ASSET_CREATOR_ID_[[DBPREFIX]]ADOBE_STOCK_CREATOR_ID` FOREIGN KEY (`creator_id`) REFERENCES `[[dbprefix]]adobe_stock_creator` (`id`) ON DELETE SET NULL,
  CONSTRAINT `[[DBPREFIX]]ADOBE_STOCK_ASSET_MDA_GLR_ID_[[DBPREFIX]]MDA_GLR_ASSET_ID` FOREIGN KEY (`media_gallery_id`) REFERENCES `[[dbprefix]]media_gallery_asset` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Adobe Stock Asset';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adobe_stock_asset`
--

LOCK TABLES `[[dbprefix]]adobe_stock_asset` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_asset` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_asset` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adobe_stock_category`
--

DROP TABLE IF EXISTS `[[dbprefix]]adobe_stock_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]adobe_stock_category` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_CATEGORY_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Adobe Stock Category';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adobe_stock_category`
--

LOCK TABLES `[[dbprefix]]adobe_stock_category` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adobe_stock_creator`
--

DROP TABLE IF EXISTS `[[dbprefix]]adobe_stock_creator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]adobe_stock_creator` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Asset creator''s name',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_CREATOR_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Adobe Stock Creator';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adobe_stock_creator`
--

LOCK TABLES `[[dbprefix]]adobe_stock_creator` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_creator` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_creator` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adobe_user_profile`
--

DROP TABLE IF EXISTS `[[dbprefix]]adobe_user_profile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]adobe_user_profile` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `admin_user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Admin User Id',
  `name` varchar(255) NOT NULL COMMENT 'Display Name',
  `email` varchar(255) NOT NULL COMMENT 'user profile email',
  `image` varchar(255) NOT NULL COMMENT 'user profile avatar',
  `account_type` varchar(255) DEFAULT NULL COMMENT 'Account Type',
  `access_token` text COMMENT 'Access Token',
  `refresh_token` text COMMENT 'Refresh Token',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `access_token_expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Access Token Expires At',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADOBE_USER_PROFILE_ADMIN_USER_ID` (`admin_user_id`),
  CONSTRAINT `[[DBPREFIX]]ADOBE_USER_PROFILE_ADMIN_USER_ID_[[DBPREFIX]]ADMIN_USER_USER_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `[[dbprefix]]admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Adobe IMS User Profile';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adobe_user_profile`
--

LOCK TABLES `[[dbprefix]]adobe_user_profile` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_user_profile` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_user_profile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]authorization_role`
--

DROP TABLE IF EXISTS `[[dbprefix]]authorization_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]authorization_role` (
  `role_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Role ID',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Role ID',
  `tree_level` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Role Tree Level',
  `sort_order` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Role Sort Order',
  `role_type` varchar(1) NOT NULL DEFAULT '0' COMMENT 'Role Type',
  `user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `user_type` varchar(16) DEFAULT NULL COMMENT 'User Type',
  `role_name` varchar(50) DEFAULT NULL COMMENT 'Role Name',
  PRIMARY KEY (`role_id`),
  KEY `[[DBPREFIX]]AUTHORIZATION_ROLE_PARENT_ID_SORT_ORDER` (`parent_id`,`sort_order`),
  KEY `[[DBPREFIX]]AUTHORIZATION_ROLE_TREE_LEVEL` (`tree_level`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COMMENT='Admin Role Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]authorization_role`
--

LOCK TABLES `[[dbprefix]]authorization_role` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]authorization_role` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]authorization_role` VALUES (1,0,1,1,'G',0,'2','Administrators'),(2,1,2,0,'U',1,'2','[[admin_username]]');
/*!40000 ALTER TABLE `[[dbprefix]]authorization_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]authorization_rule`
--

DROP TABLE IF EXISTS `[[dbprefix]]authorization_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]authorization_rule` (
  `rule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule ID',
  `role_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Role ID',
  `resource_id` varchar(255) DEFAULT NULL COMMENT 'Resource ID',
  `privileges` varchar(20) DEFAULT NULL COMMENT 'Privileges',
  `permission` varchar(10) DEFAULT NULL COMMENT 'Permission',
  PRIMARY KEY (`rule_id`),
  KEY `[[DBPREFIX]]AUTHORIZATION_RULE_RESOURCE_ID_ROLE_ID` (`resource_id`,`role_id`),
  KEY `[[DBPREFIX]]AUTHORIZATION_RULE_ROLE_ID_RESOURCE_ID` (`role_id`,`resource_id`),
  CONSTRAINT `[[DBPREFIX]]AUTHORIZATION_RULE_ROLE_ID_[[DBPREFIX]]AUTHORIZATION_ROLE_ROLE_ID` FOREIGN KEY (`role_id`) REFERENCES `[[dbprefix]]authorization_role` (`role_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Admin Rule Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]authorization_rule`
--

LOCK TABLES `[[dbprefix]]authorization_rule` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]authorization_rule` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]authorization_rule` VALUES (1,1,'Magento_Backend::all',NULL,'allow');
/*!40000 ALTER TABLE `[[dbprefix]]authorization_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]braintree_credit_prices`
--

DROP TABLE IF EXISTS `[[dbprefix]]braintree_credit_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]braintree_credit_prices` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Row ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product Id',
  `term` int NOT NULL COMMENT 'Credit Term',
  `monthly_payment` decimal(12,2) NOT NULL COMMENT 'Monthly Payment',
  `instalment_rate` decimal(12,2) NOT NULL COMMENT 'Instalment Rate',
  `cost_of_purchase` decimal(12,2) NOT NULL COMMENT 'Cost of purchase',
  `total_inc_interest` decimal(12,2) NOT NULL COMMENT 'Total Inc Interest',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[DBPREFIX]]BRAINTREE_CREDIT_PRICES_PRODUCT_ID_TERM` (`product_id`,`term`),
  KEY `[[DBPREFIX]]BRAINTREE_CREDIT_PRICES_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Braintree credit rates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]braintree_credit_prices`
--

LOCK TABLES `[[dbprefix]]braintree_credit_prices` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]braintree_credit_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]braintree_credit_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]braintree_transaction_details`
--

DROP TABLE IF EXISTS `[[dbprefix]]braintree_transaction_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]braintree_transaction_details` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `order_id` int unsigned NOT NULL COMMENT 'Order Id',
  `transaction_source` varchar(12) DEFAULT NULL COMMENT 'Transaction Source',
  PRIMARY KEY (`entity_id`),
  KEY `[[DBPREFIX]]BRAINTREE_TRANSACTION_DETAILS_ORDER_ID` (`order_id`),
  CONSTRAINT `[[DBPREFIX]]BRAINTREE_TRANSACTION_DETAILS_ORDER_ID_SALES_ORDER_ENTT_ID` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Braintree transaction details table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]braintree_transaction_details`
--

LOCK TABLES `[[dbprefix]]braintree_transaction_details` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]braintree_transaction_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]braintree_transaction_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]cache`
--

DROP TABLE IF EXISTS `[[dbprefix]]cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]cache` (
  `id` varchar(200) NOT NULL COMMENT 'Cache Id',
  `data` mediumblob COMMENT 'Cache Data',
  `create_time` int DEFAULT NULL COMMENT 'Cache Creation Time',
  `update_time` int DEFAULT NULL COMMENT 'Time of Cache Updating',
  `expire_time` int DEFAULT NULL COMMENT 'Cache Expiration Time',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]CACHE_EXPIRE_TIME` (`expire_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]cache`
--

LOCK TABLES `[[dbprefix]]cache` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]cache_tag`
--

DROP TABLE IF EXISTS `[[dbprefix]]cache_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]cache_tag` (
  `tag` varchar(100) NOT NULL COMMENT 'Tag',
  `cache_id` varchar(200) NOT NULL COMMENT 'Cache Id',
  PRIMARY KEY (`tag`,`cache_id`),
  KEY `[[DBPREFIX]]CACHE_TAG_CACHE_ID` (`cache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Tag Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]cache_tag`
--

LOCK TABLES `[[dbprefix]]cache_tag` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]cache_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]cache_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]captcha_log`
--

DROP TABLE IF EXISTS `[[dbprefix]]captcha_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]captcha_log` (
  `type` varchar(32) NOT NULL COMMENT 'Type',
  `value` varchar(255) NOT NULL COMMENT 'Value',
  `count` int unsigned NOT NULL DEFAULT '0' COMMENT 'Count',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Update Time',
  PRIMARY KEY (`type`,`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Count Login Attempts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]captcha_log`
--

LOCK TABLES `[[dbprefix]]captcha_log` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]captcha_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]captcha_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Category ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `path` varchar(255) NOT NULL COMMENT 'Tree Path',
  `position` int NOT NULL COMMENT 'Position',
  `level` int NOT NULL DEFAULT '0' COMMENT 'Tree Level',
  `children_count` int NOT NULL COMMENT 'Child Count',
  PRIMARY KEY (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_LEVEL` (`level`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_PATH` (`path`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_entity` VALUES (1,3,0,'[[regtime]]','[[regtime]]','1',0,0,39),(2,3,1,'[[regtime]]','[[regtime]]','1/2',1,1,38),(3,3,2,'[[regtime]]','[[regtime]]','1/2/3',4,2,3),(4,3,3,'[[regtime]]','[[regtime]]','1/2/3/4',1,3,0),(5,3,3,'[[regtime]]','[[regtime]]','1/2/3/5',2,3,0),(6,3,3,'[[regtime]]','[[regtime]]','1/2/3/6',3,3,0),(7,3,2,'[[regtime]]','[[regtime]]','1/2/7',5,2,6),(8,3,7,'[[regtime]]','[[regtime]]','1/2/7/8',1,3,0),(9,3,2,'[[regtime]]','[[regtime]]','1/2/9',5,2,1),(10,3,9,'[[regtime]]','[[regtime]]','1/2/9/10',1,3,0),(11,3,2,'[[regtime]]','[[regtime]]','1/2/11',3,2,8),(12,3,11,'[[regtime]]','[[regtime]]','1/2/11/12',1,3,4),(13,3,11,'[[regtime]]','[[regtime]]','1/2/11/13',2,3,2),(14,3,12,'[[regtime]]','[[regtime]]','1/2/11/12/14',1,4,0),(15,3,12,'[[regtime]]','[[regtime]]','1/2/11/12/15',2,4,0),(16,3,12,'[[regtime]]','[[regtime]]','1/2/11/12/16',3,4,0),(17,3,12,'[[regtime]]','[[regtime]]','1/2/11/12/17',4,4,0),(18,3,13,'[[regtime]]','[[regtime]]','1/2/11/13/18',1,4,0),(19,3,13,'[[regtime]]','[[regtime]]','1/2/11/13/19',2,4,0),(20,3,2,'[[regtime]]','[[regtime]]','1/2/20',2,2,8),(21,3,20,'[[regtime]]','[[regtime]]','1/2/20/21',1,3,4),(22,3,20,'[[regtime]]','[[regtime]]','1/2/20/22',2,3,2),(23,3,21,'[[regtime]]','[[regtime]]','1/2/20/21/23',1,4,0),(24,3,21,'[[regtime]]','[[regtime]]','1/2/20/21/24',2,4,0),(25,3,21,'[[regtime]]','[[regtime]]','1/2/20/21/25',3,4,0),(26,3,21,'[[regtime]]','[[regtime]]','1/2/20/21/26',4,4,0),(27,3,22,'[[regtime]]','[[regtime]]','1/2/20/22/27',1,4,0),(28,3,22,'[[regtime]]','[[regtime]]','1/2/20/22/28',2,4,0),(29,3,2,'[[regtime]]','[[regtime]]','1/2/29',6,2,4),(30,3,29,'[[regtime]]','[[regtime]]','1/2/29/30',1,3,0),(31,3,29,'[[regtime]]','[[regtime]]','1/2/29/31',2,3,0),(32,3,29,'[[regtime]]','[[regtime]]','1/2/29/32',3,3,0),(33,3,29,'[[regtime]]','[[regtime]]','1/2/29/33',4,3,0),(34,3,7,'[[regtime]]','[[regtime]]','1/2/7/34',2,3,0),(35,3,7,'[[regtime]]','[[regtime]]','1/2/7/35',3,3,0),(36,3,7,'[[regtime]]','[[regtime]]','1/2/7/36',4,3,0),(37,3,2,'[[regtime]]','[[regtime]]','1/2/37',6,2,0),(38,3,2,'[[regtime]]','[[regtime]]','1/2/38',1,2,0),(39,3,7,'[[regtime]]','[[regtime]]','1/2/7/39',5,3,0),(40,3,7,'[[regtime]]','[[regtime]]','1/2/7/40',6,3,0);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_datetime`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_datetime` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_CTGR_ENTT_DTIME_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DTIME_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DTIME_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DTIME_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_datetime`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_datetime` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_datetime` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_decimal`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_decimal` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(20,6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_CTGR_ENTT_DEC_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DEC_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DEC_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DEC_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_decimal`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_decimal` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_decimal` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_int`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_int` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_INT_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_INT_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=118 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_int`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_int` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_int` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_entity_int` VALUES (1,69,0,1,1),(2,69,0,2,1),(3,46,0,2,1),(4,69,0,3,1),(5,46,0,3,1),(6,54,0,3,0),(7,69,0,4,1),(8,46,0,4,1),(9,54,0,4,1),(10,69,0,5,1),(11,46,0,5,1),(12,54,0,5,1),(13,69,0,6,1),(14,46,0,6,1),(15,54,0,6,1),(16,69,0,7,0),(17,46,0,7,0),(18,54,0,7,0),(19,69,0,8,0),(20,46,0,8,1),(21,54,0,8,1),(22,69,0,9,1),(23,46,0,9,1),(24,54,0,9,0),(25,69,0,10,1),(26,46,0,10,1),(27,54,0,10,1),(28,69,0,11,1),(29,46,0,11,1),(30,54,0,11,0),(31,69,0,12,1),(32,46,0,12,1),(33,54,0,12,1),(34,69,0,13,1),(35,46,0,13,1),(36,54,0,13,1),(37,69,0,14,1),(38,46,0,14,1),(39,54,0,14,1),(40,69,0,15,1),(41,46,0,15,1),(42,54,0,15,1),(43,69,0,16,1),(44,46,0,16,1),(45,54,0,16,1),(46,69,0,17,1),(47,46,0,17,1),(48,54,0,17,1),(49,69,0,18,1),(50,46,0,18,1),(51,54,0,18,1),(52,69,0,19,1),(53,46,0,19,1),(54,54,0,19,1),(55,69,0,20,1),(56,46,0,20,1),(57,54,0,20,0),(58,69,0,21,1),(59,46,0,21,1),(60,54,0,21,1),(61,69,0,22,1),(62,46,0,22,1),(63,54,0,22,1),(64,69,0,23,1),(65,46,0,23,1),(66,54,0,23,1),(67,69,0,24,1),(68,46,0,24,1),(69,54,0,24,1),(70,69,0,25,1),(71,46,0,25,1),(72,54,0,25,1),(73,69,0,26,1),(74,46,0,26,1),(75,54,0,26,1),(76,69,0,27,1),(77,46,0,27,1),(78,54,0,27,1),(79,69,0,28,1),(80,46,0,28,1),(81,54,0,28,1),(82,69,0,29,0),(83,46,0,29,0),(84,54,0,29,0),(85,69,0,30,0),(86,46,0,30,1),(87,54,0,30,1),(88,69,0,31,0),(89,46,0,31,1),(90,54,0,31,1),(91,69,0,32,0),(92,46,0,32,1),(93,54,0,32,1),(94,69,0,33,0),(95,46,0,33,1),(96,54,0,33,1),(97,69,0,34,0),(98,46,0,34,1),(99,54,0,34,1),(100,69,0,35,0),(101,46,0,35,1),(102,54,0,35,1),(103,69,0,36,0),(104,46,0,36,1),(105,54,0,36,1),(106,69,0,37,1),(107,46,0,37,1),(108,54,0,37,0),(109,69,0,38,1),(110,46,0,38,1),(111,54,0,38,0),(112,69,0,39,0),(113,46,0,39,1),(114,54,0,39,0),(115,69,0,40,0),(116,46,0,40,1),(117,54,0,40,0);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_text`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_text` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` mediumtext COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_CTGR_ENTT_TEXT_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_TEXT_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_TEXT_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_text`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_text` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_text` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_varchar`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_varchar` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_CTGR_ENTT_VCHR_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_VCHR_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_VCHR_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_VCHR_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=130 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Varchar Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_varchar`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_varchar` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_varchar` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_entity_varchar` VALUES (1,45,0,1,'Root Catalog'),(2,52,0,2,'PRODUCTS'),(3,45,0,2,'Default Category'),(4,52,0,3,'PAGE'),(5,45,0,3,'Gear'),(6,119,0,3,'gear'),(7,120,0,3,'gear'),(8,45,0,4,'Bags'),(9,119,0,4,'bags'),(10,120,0,4,'gear/bags'),(11,45,0,5,'Fitness Equipment'),(12,119,0,5,'fitness-equipment'),(13,120,0,5,'gear/fitness-equipment'),(14,45,0,6,'Watches'),(15,119,0,6,'watches'),(16,120,0,6,'gear/watches'),(17,52,0,7,'PAGE'),(18,45,0,7,'Collections'),(19,119,0,7,'collections'),(20,120,0,7,'collections'),(21,45,0,8,'New Luma Yoga Collection'),(22,119,0,8,'yoga-new'),(23,120,0,8,'collections/yoga-new'),(24,52,0,9,'PAGE'),(25,45,0,9,'Training'),(26,119,0,9,'training'),(27,120,0,9,'training'),(28,45,0,10,'Video Download'),(29,119,0,10,'training-video'),(30,120,0,10,'training/training-video'),(31,52,0,11,'PAGE'),(32,45,0,11,'Men'),(33,119,0,11,'men'),(34,120,0,11,'men'),(35,45,0,12,'Tops'),(36,119,0,12,'tops-men'),(37,120,0,12,'men/tops-men'),(38,45,0,13,'Bottoms'),(39,119,0,13,'bottoms-men'),(40,120,0,13,'men/bottoms-men'),(41,45,0,14,'Jackets'),(42,119,0,14,'jackets-men'),(43,120,0,14,'men/tops-men/jackets-men'),(44,45,0,15,'Hoodies & Sweatshirts'),(45,119,0,15,'hoodies-and-sweatshirts-men'),(46,120,0,15,'men/tops-men/hoodies-and-sweatshirts-men'),(47,45,0,16,'Tees'),(48,119,0,16,'tees-men'),(49,120,0,16,'men/tops-men/tees-men'),(50,45,0,17,'Tanks'),(51,119,0,17,'tanks-men'),(52,120,0,17,'men/tops-men/tanks-men'),(53,45,0,18,'Pants'),(54,119,0,18,'pants-men'),(55,120,0,18,'men/bottoms-men/pants-men'),(56,45,0,19,'Shorts'),(57,119,0,19,'shorts-men'),(58,120,0,19,'men/bottoms-men/shorts-men'),(59,52,0,20,'PAGE'),(60,45,0,20,'Women'),(61,119,0,20,'women'),(62,120,0,20,'women'),(63,45,0,21,'Tops'),(64,119,0,21,'tops-women'),(65,120,0,21,'women/tops-women'),(66,45,0,22,'Bottoms'),(67,119,0,22,'bottoms-women'),(68,120,0,22,'women/bottoms-women'),(69,45,0,23,'Jackets'),(70,119,0,23,'jackets-women'),(71,120,0,23,'women/tops-women/jackets-women'),(72,45,0,24,'Hoodies & Sweatshirts'),(73,119,0,24,'hoodies-and-sweatshirts-women'),(74,120,0,24,'women/tops-women/hoodies-and-sweatshirts-women'),(75,45,0,25,'Tees'),(76,119,0,25,'tees-women'),(77,120,0,25,'women/tops-women/tees-women'),(78,45,0,26,'Bras & Tanks'),(79,119,0,26,'tanks-women'),(80,120,0,26,'women/tops-women/tanks-women'),(81,45,0,27,'Pants'),(82,119,0,27,'pants-women'),(83,120,0,27,'women/bottoms-women/pants-women'),(84,45,0,28,'Shorts'),(85,119,0,28,'shorts-women'),(86,120,0,28,'women/bottoms-women/shorts-women'),(87,52,0,29,'PAGE'),(88,45,0,29,'Promotions'),(89,119,0,29,'promotions'),(90,120,0,29,'promotions'),(91,45,0,30,'Women Sale'),(92,119,0,30,'women-sale'),(93,120,0,30,'promotions/women-sale'),(94,45,0,31,'Men Sale'),(95,119,0,31,'men-sale'),(96,120,0,31,'promotions/men-sale'),(97,45,0,32,'Pants'),(98,119,0,32,'pants-all'),(99,120,0,32,'promotions/pants-all'),(100,45,0,33,'Tees'),(101,119,0,33,'tees-all'),(102,120,0,33,'promotions/tees-all'),(103,45,0,34,'Erin Recommends'),(104,119,0,34,'erin-recommends'),(105,120,0,34,'collections/erin-recommends'),(106,45,0,35,'Performance Fabrics'),(107,119,0,35,'performance-fabrics'),(108,120,0,35,'collections/performance-fabrics'),(109,45,0,36,'Eco Friendly'),(110,119,0,36,'eco-friendly'),(111,120,0,36,'collections/eco-friendly'),(112,52,0,37,'PAGE'),(113,45,0,37,'Sale'),(114,119,0,37,'sale'),(115,120,0,37,'sale'),(116,52,0,38,'PAGE'),(117,45,0,38,'What\'s New'),(118,119,0,38,'what-is-new'),(119,120,0,38,'what-is-new'),(120,52,0,39,'PAGE'),(121,45,0,39,'Performance Sportswear New'),(122,63,0,39,'1column'),(123,119,0,39,'performance-new'),(124,120,0,39,'collections/performance-new'),(125,52,0,40,'PAGE'),(126,45,0,40,'Eco Collection New'),(127,63,0,40,'1column'),(128,119,0,40,'eco-new'),(129,120,0,40,'collections/eco-new');
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_product` (
  `entity_id` int NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`entity_id`,`category_id`,`product_id`),
  UNIQUE KEY `[[DBPREFIX]]CATALOG_CATEGORY_PRODUCT_CATEGORY_ID_PRODUCT_ID` (`category_id`,`product_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_PRODUCT_PRODUCT_ID` (`product_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_PRD_CTGR_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_PRD_PRD_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5166 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product To Category Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product`
--

LOCK TABLES `[[dbprefix]]catalog_category_product` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_product` VALUES (1,3,1,0),(2,4,1,0),(3,3,2,0),(4,7,2,0),(5,4,2,0),(6,3,3,0),(7,4,3,0),(8,3,4,0),(9,7,4,0),(10,4,4,0),(11,8,4,0),(12,3,5,0),(13,7,5,0),(14,4,5,0),(15,8,5,0),(16,3,6,0),(17,4,6,0),(18,3,7,0),(19,4,7,0),(20,3,8,0),(21,4,8,0),(22,3,9,0),(23,4,9,0),(24,3,10,0),(25,7,10,0),(26,4,10,0),(27,3,11,0),(28,7,11,0),(29,4,11,0),(30,3,12,0),(31,4,12,0),(32,3,13,0),(33,7,13,0),(34,4,13,0),(35,8,13,0),(36,3,14,0),(37,7,14,0),(38,4,14,0),(39,3,15,0),(40,5,15,0),(41,3,16,0),(42,7,16,0),(43,5,16,0),(44,3,17,0),(45,5,17,0),(46,3,18,0),(47,5,18,0),(48,3,19,0),(49,7,19,0),(50,5,19,0),(51,8,19,0),(52,3,20,0),(53,5,20,0),(54,3,21,0),(55,5,21,0),(56,3,22,0),(57,5,22,0),(58,3,23,0),(59,5,23,0),(60,3,24,0),(61,5,24,0),(62,3,25,0),(63,5,25,0),(64,3,26,0),(65,5,26,0),(66,3,27,0),(67,5,27,0),(68,3,28,0),(69,5,28,0),(70,3,29,0),(71,5,29,0),(72,3,30,0),(73,5,30,0),(74,3,31,0),(75,5,31,0),(76,3,32,0),(77,5,32,0),(78,3,33,0),(79,5,33,0),(80,3,34,0),(81,5,34,0),(82,3,35,0),(83,5,35,0),(84,3,36,0),(85,6,36,0),(86,3,37,0),(87,6,37,0),(88,3,38,0),(89,7,38,0),(90,6,38,0),(91,8,38,0),(92,3,39,0),(93,7,39,0),(94,6,39,0),(95,8,39,0),(96,3,40,0),(97,7,40,0),(98,6,40,0),(99,8,40,0),(100,3,41,0),(101,6,41,0),(102,3,42,0),(103,6,42,0),(104,3,43,0),(105,6,43,0),(106,3,44,0),(107,7,44,0),(108,6,44,0),(109,8,44,0),(110,3,45,0),(111,5,45,0),(112,3,46,0),(113,5,46,0),(114,15,47,-1),(115,36,47,-1),(116,2,47,-1),(117,15,48,-2),(118,36,48,-2),(119,2,48,-2),(120,15,49,-3),(121,36,49,-3),(122,2,49,-3),(123,15,50,-4),(124,36,50,-4),(125,2,50,-4),(126,15,51,-5),(127,36,51,-5),(128,2,51,-5),(129,15,52,-6),(130,36,52,-6),(131,2,52,-6),(132,15,53,-7),(133,36,53,-7),(134,2,53,-7),(135,15,54,-8),(136,36,54,-8),(137,2,54,-8),(138,15,55,-9),(139,36,55,-9),(140,2,55,-9),(141,15,56,-10),(142,36,56,-10),(143,2,56,-10),(144,15,57,-11),(145,36,57,-11),(146,2,57,-11),(147,15,58,-12),(148,36,58,-12),(149,2,58,-12),(150,15,59,-13),(151,36,59,-13),(152,2,59,-13),(153,15,60,-14),(154,36,60,-14),(155,2,60,-14),(156,15,61,-15),(157,36,61,-15),(158,2,61,-15),(159,15,62,-16),(160,36,62,-16),(161,2,62,-16),(162,15,63,-17),(163,15,64,-18),(164,15,65,-19),(165,15,66,-20),(166,15,67,-21),(167,15,68,-22),(168,15,69,-23),(169,15,70,-24),(170,15,71,-25),(171,15,72,-26),(172,15,73,-27),(173,15,74,-28),(174,15,75,-29),(175,15,76,-30),(176,15,77,-31),(177,15,78,-32),(178,15,79,-33),(179,36,79,-17),(180,2,79,-17),(181,15,80,-34),(182,36,80,-18),(183,2,80,-18),(184,15,81,-35),(185,36,81,-19),(186,2,81,-19),(187,15,82,-36),(188,36,82,-20),(189,2,82,-20),(190,15,83,-37),(191,36,83,-21),(192,2,83,-21),(193,15,84,-38),(194,36,84,-22),(195,2,84,-22),(196,15,85,-39),(197,36,85,-23),(198,2,85,-23),(199,15,86,-40),(200,36,86,-24),(201,2,86,-24),(202,15,87,-41),(203,36,87,-25),(204,2,87,-25),(205,15,88,-42),(206,36,88,-26),(207,2,88,-26),(208,15,89,-43),(209,36,89,-27),(210,2,89,-27),(211,15,90,-44),(212,36,90,-28),(213,2,90,-28),(214,15,91,-45),(215,36,91,-29),(216,2,91,-29),(217,15,92,-46),(218,36,92,-30),(219,2,92,-30),(220,15,93,-47),(221,36,93,-31),(222,2,93,-31),(223,15,94,-48),(224,36,94,-32),(225,2,94,-32),(226,15,95,-49),(227,36,95,-33),(228,2,95,-33),(229,15,96,-50),(230,36,96,-34),(231,2,96,-34),(232,15,97,-51),(233,36,97,-35),(234,2,97,-35),(235,15,98,-52),(236,36,98,-36),(237,2,98,-36),(238,15,99,-53),(239,36,99,-37),(240,2,99,-37),(241,15,100,-54),(242,36,100,-38),(243,2,100,-38),(244,15,101,-55),(245,36,101,-39),(246,2,101,-39),(247,15,102,-56),(248,36,102,-40),(249,2,102,-40),(250,15,103,-57),(251,36,103,-41),(252,2,103,-41),(253,15,104,-58),(254,36,104,-42),(255,2,104,-42),(256,15,105,-59),(257,36,105,-43),(258,2,105,-43),(259,15,106,-60),(260,36,106,-44),(261,2,106,-44),(262,15,107,-61),(263,36,107,-45),(264,2,107,-45),(265,15,108,-62),(266,36,108,-46),(267,2,108,-46),(268,15,109,-63),(269,36,109,-47),(270,2,109,-47),(271,15,110,-64),(272,36,110,-48),(273,2,110,-48),(274,15,111,-65),(275,15,112,-66),(276,15,113,-67),(277,15,114,-68),(278,15,115,-69),(279,15,116,-70),(280,15,117,-71),(281,15,118,-72),(282,15,119,-73),(283,15,120,-74),(284,15,121,-75),(285,15,122,-76),(286,15,123,-77),(287,15,124,-78),(288,15,125,-79),(289,15,126,-80),(290,15,127,-81),(291,15,128,-82),(292,15,129,-83),(293,15,130,-84),(294,15,131,-85),(295,15,132,-86),(296,15,133,-87),(297,15,134,-88),(298,15,135,-89),(299,15,136,-90),(300,15,137,-91),(301,15,138,-92),(302,15,139,-93),(303,15,140,-94),(304,15,141,-95),(305,15,142,-96),(306,15,143,-97),(307,15,144,-98),(308,15,145,-99),(309,15,146,-100),(310,15,147,-101),(311,15,148,-102),(312,15,149,-103),(313,15,150,-104),(314,15,151,-105),(315,15,152,-106),(316,15,153,-107),(317,15,154,-108),(318,15,155,-109),(319,15,156,-110),(320,15,157,-111),(321,15,158,-112),(322,15,159,-113),(323,15,160,-114),(324,15,161,-115),(325,15,162,-116),(326,15,163,-117),(327,15,164,-118),(328,15,165,-119),(329,15,166,-120),(330,15,167,-121),(331,15,168,-122),(332,15,169,-123),(333,15,170,-124),(334,15,171,-125),(335,15,172,-126),(336,15,173,-127),(337,15,174,-128),(338,15,175,-129),(339,15,176,-130),(340,15,177,-131),(341,15,178,-132),(342,15,179,-133),(343,15,180,-134),(344,15,181,-135),(345,15,182,-136),(346,15,183,-137),(347,15,184,-138),(348,15,185,-139),(349,15,186,-140),(350,15,187,-141),(351,15,188,-142),(352,15,189,-143),(353,15,190,-144),(354,15,191,-145),(355,15,192,-146),(356,15,193,-147),(357,15,194,-148),(358,15,195,-149),(359,15,196,-150),(360,15,197,-151),(361,15,198,-152),(362,15,199,-153),(363,15,200,-154),(364,15,201,-155),(365,15,202,-156),(366,15,203,-157),(367,15,204,-158),(368,15,205,-159),(369,15,206,-160),(370,15,207,-161),(371,15,208,-162),(372,15,209,-163),(373,15,210,-164),(374,15,211,-165),(375,15,212,-166),(376,15,213,-167),(377,15,214,-168),(378,15,215,-169),(379,15,216,-170),(380,15,217,-171),(381,15,218,-172),(382,15,219,-173),(383,15,220,-174),(384,15,221,-175),(385,15,222,-176),(386,15,223,-177),(387,15,224,-178),(388,15,225,-179),(389,15,226,-180),(390,15,227,-181),(391,15,228,-182),(392,15,229,-183),(393,15,230,-184),(394,15,231,-185),(395,15,232,-186),(396,15,233,-187),(397,15,234,-188),(398,15,235,-189),(399,15,236,-190),(400,15,237,-191),(401,15,238,-192),(402,15,239,-193),(403,15,240,-194),(404,15,241,-195),(405,15,242,-196),(406,15,243,-197),(407,15,244,-198),(408,15,245,-199),(409,15,246,-200),(410,15,247,-201),(411,15,248,-202),(412,15,249,-203),(413,15,250,-204),(414,15,251,-205),(415,15,252,-206),(416,15,253,-207),(417,15,254,-208),(418,14,255,-1),(419,14,256,-2),(420,14,257,-3),(421,14,258,-4),(422,14,259,-5),(423,14,260,-6),(424,14,261,-7),(425,14,262,-8),(426,14,263,-9),(427,14,264,-10),(428,14,265,-11),(429,14,266,-12),(430,14,267,-13),(431,14,268,-14),(432,14,269,-15),(433,14,270,-16),(434,14,271,-17),(435,14,272,-18),(436,14,273,-19),(437,14,274,-20),(438,14,275,-21),(439,14,276,-22),(440,14,277,-23),(441,14,278,-24),(442,14,279,-25),(443,14,280,-26),(444,14,281,-27),(445,14,282,-28),(446,14,283,-29),(447,14,284,-30),(448,14,285,-31),(449,14,286,-32),(450,14,287,-33),(451,36,287,-49),(452,2,287,-49),(453,14,288,-34),(454,36,288,-50),(455,2,288,-50),(456,14,289,-35),(457,36,289,-51),(458,2,289,-51),(459,14,290,-36),(460,36,290,-52),(461,2,290,-52),(462,14,291,-37),(463,36,291,-53),(464,2,291,-53),(465,14,292,-38),(466,36,292,-54),(467,2,292,-54),(468,14,293,-39),(469,36,293,-55),(470,2,293,-55),(471,14,294,-40),(472,36,294,-56),(473,2,294,-56),(474,14,295,-41),(475,36,295,-57),(476,2,295,-57),(477,14,296,-42),(478,36,296,-58),(479,2,296,-58),(480,14,297,-43),(481,36,297,-59),(482,2,297,-59),(483,14,298,-44),(484,36,298,-60),(485,2,298,-60),(486,14,299,-45),(487,36,299,-61),(488,2,299,-61),(489,14,300,-46),(490,36,300,-62),(491,2,300,-62),(492,14,301,-47),(493,36,301,-63),(494,2,301,-63),(495,14,302,-48),(496,36,302,-64),(497,2,302,-64),(498,14,303,-49),(499,14,304,-50),(500,14,305,-51),(501,14,306,-52),(502,14,307,-53),(503,14,308,-54),(504,14,309,-55),(505,14,310,-56),(506,14,311,-57),(507,14,312,-58),(508,14,313,-59),(509,14,314,-60),(510,14,315,-61),(511,14,316,-62),(512,14,317,-63),(513,14,318,-64),(514,14,319,-65),(515,14,320,-66),(516,14,321,-67),(517,14,322,-68),(518,14,323,-69),(519,14,324,-70),(520,14,325,-71),(521,14,326,-72),(522,14,327,-73),(523,14,328,-74),(524,14,329,-75),(525,14,330,-76),(526,14,331,-77),(527,14,332,-78),(528,14,333,-79),(529,14,334,-80),(530,14,335,-81),(531,14,336,-82),(532,14,337,-83),(533,14,338,-84),(534,14,339,-85),(535,14,340,-86),(536,14,341,-87),(537,14,342,-88),(538,14,343,-89),(539,14,344,-90),(540,14,345,-91),(541,14,346,-92),(542,14,347,-93),(543,14,348,-94),(544,14,349,-95),(545,14,350,-96),(546,14,351,-97),(547,14,352,-98),(548,14,353,-99),(549,14,354,-100),(550,14,355,-101),(551,14,356,-102),(552,14,357,-103),(553,14,358,-104),(554,14,359,-105),(555,14,360,-106),(556,14,361,-107),(557,14,362,-108),(558,14,363,-109),(559,14,364,-110),(560,14,365,-111),(561,14,366,-112),(562,14,367,-113),(563,14,368,-114),(564,14,369,-115),(565,14,370,-116),(566,14,371,-117),(567,14,372,-118),(568,14,373,-119),(569,14,374,-120),(570,14,375,-121),(571,14,376,-122),(572,14,377,-123),(573,14,378,-124),(574,14,379,-125),(575,14,380,-126),(576,14,381,-127),(577,14,382,-128),(578,14,383,-129),(579,36,383,-65),(580,2,383,-65),(581,14,384,-130),(582,36,384,-66),(583,2,384,-66),(584,14,385,-131),(585,36,385,-67),(586,2,385,-67),(587,14,386,-132),(588,36,386,-68),(589,2,386,-68),(590,14,387,-133),(591,36,387,-69),(592,2,387,-69),(593,14,388,-134),(594,36,388,-70),(595,2,388,-70),(596,14,389,-135),(597,36,389,-71),(598,2,389,-71),(599,14,390,-136),(600,36,390,-72),(601,2,390,-72),(602,14,391,-137),(603,36,391,-73),(604,2,391,-73),(605,14,392,-138),(606,36,392,-74),(607,2,392,-74),(608,14,393,-139),(609,36,393,-75),(610,2,393,-75),(611,14,394,-140),(612,36,394,-76),(613,2,394,-76),(614,14,395,-141),(615,36,395,-77),(616,2,395,-77),(617,14,396,-142),(618,36,396,-78),(619,2,396,-78),(620,14,397,-143),(621,36,397,-79),(622,2,397,-79),(623,14,398,-144),(624,36,398,-80),(625,2,398,-80),(626,14,399,-145),(627,14,400,-146),(628,14,401,-147),(629,14,402,-148),(630,14,403,-149),(631,14,404,-150),(632,14,405,-151),(633,14,406,-152),(634,14,407,-153),(635,14,408,-154),(636,14,409,-155),(637,14,410,-156),(638,14,411,-157),(639,14,412,-158),(640,14,413,-159),(641,14,414,-160),(642,14,415,-161),(643,14,416,-162),(644,14,417,-163),(645,14,418,-164),(646,14,419,-165),(647,14,420,-166),(648,14,421,-167),(649,14,422,-168),(650,14,423,-169),(651,14,424,-170),(652,14,425,-171),(653,14,426,-172),(654,14,427,-173),(655,14,428,-174),(656,14,429,-175),(657,14,430,-176),(658,16,431,-1),(659,16,432,-2),(660,16,433,-3),(661,16,434,-4),(662,16,435,-5),(663,16,436,-6),(664,16,437,-7),(665,16,438,-8),(666,16,439,-9),(667,16,440,-10),(668,16,441,-11),(669,16,442,-12),(670,16,443,-13),(671,16,444,-14),(672,16,445,-15),(673,16,446,-16),(674,16,447,-17),(675,36,447,-81),(676,2,447,-81),(677,16,448,-18),(678,36,448,-82),(679,2,448,-82),(680,16,449,-19),(681,36,449,-83),(682,2,449,-83),(683,16,450,-20),(684,36,450,-84),(685,2,450,-84),(686,16,451,-21),(687,36,451,-85),(688,2,451,-85),(689,16,452,-22),(690,36,452,-86),(691,2,452,-86),(692,16,453,-23),(693,36,453,-87),(694,2,453,-87),(695,16,454,-24),(696,36,454,-88),(697,2,454,-88),(698,16,455,-25),(699,36,455,-89),(700,2,455,-89),(701,16,456,-26),(702,36,456,-90),(703,2,456,-90),(704,16,457,-27),(705,36,457,-91),(706,2,457,-91),(707,16,458,-28),(708,36,458,-92),(709,2,458,-92),(710,16,459,-29),(711,36,459,-93),(712,2,459,-93),(713,16,460,-30),(714,36,460,-94),(715,2,460,-94),(716,16,461,-31),(717,36,461,-95),(718,2,461,-95),(719,16,462,-32),(720,36,462,-96),(721,2,462,-96),(722,16,463,-33),(723,16,464,-34),(724,16,465,-35),(725,16,466,-36),(726,16,467,-37),(727,16,468,-38),(728,16,469,-39),(729,16,470,-40),(730,16,471,-41),(731,16,472,-42),(732,16,473,-43),(733,16,474,-44),(734,16,475,-45),(735,16,476,-46),(736,16,477,-47),(737,16,478,-48),(738,16,479,-49),(739,16,480,-50),(740,16,481,-51),(741,16,482,-52),(742,16,483,-53),(743,16,484,-54),(744,16,485,-55),(745,16,486,-56),(746,16,487,-57),(747,16,488,-58),(748,16,489,-59),(749,16,490,-60),(750,16,491,-61),(751,16,492,-62),(752,16,493,-63),(753,16,494,-64),(754,16,495,-65),(755,16,496,-66),(756,16,497,-67),(757,16,498,-68),(758,16,499,-69),(759,16,500,-70),(760,16,501,-71),(761,16,502,-72),(762,16,503,-73),(763,16,504,-74),(764,16,505,-75),(765,16,506,-76),(766,16,507,-77),(767,16,508,-78),(768,16,509,-79),(769,16,510,-80),(770,16,511,-81),(771,16,512,-82),(772,16,513,-83),(773,16,514,-84),(774,16,515,-85),(775,16,516,-86),(776,16,517,-87),(777,16,518,-88),(778,16,519,-89),(779,16,520,-90),(780,16,521,-91),(781,16,522,-92),(782,16,523,-93),(783,16,524,-94),(784,16,525,-95),(785,16,526,-96),(786,16,527,-97),(787,16,528,-98),(788,16,529,-99),(789,16,530,-100),(790,16,531,-101),(791,16,532,-102),(792,16,533,-103),(793,16,534,-104),(794,16,535,-105),(795,16,536,-106),(796,16,537,-107),(797,16,538,-108),(798,16,539,-109),(799,16,540,-110),(800,16,541,-111),(801,16,542,-112),(802,16,543,-113),(803,16,544,-114),(804,16,545,-115),(805,16,546,-116),(806,16,547,-117),(807,16,548,-118),(808,16,549,-119),(809,16,550,-120),(810,16,551,-121),(811,16,552,-122),(812,16,553,-123),(813,16,554,-124),(814,16,555,-125),(815,16,556,-126),(816,16,557,-127),(817,16,558,-128),(818,16,559,-129),(819,16,560,-130),(820,16,561,-131),(821,16,562,-132),(822,16,563,-133),(823,16,564,-134),(824,16,565,-135),(825,16,566,-136),(826,16,567,-137),(827,16,568,-138),(828,16,569,-139),(829,16,570,-140),(830,16,571,-141),(831,16,572,-142),(832,16,573,-143),(833,16,574,-144),(834,16,575,-145),(835,16,576,-146),(836,16,577,-147),(837,16,578,-148),(838,16,579,-149),(839,16,580,-150),(840,16,581,-151),(841,16,582,-152),(842,16,583,-153),(843,16,584,-154),(844,16,585,-155),(845,16,586,-156),(846,16,587,-157),(847,16,588,-158),(848,16,589,-159),(849,16,590,-160),(850,16,591,-161),(851,16,592,-162),(852,16,593,-163),(853,16,594,-164),(854,16,595,-165),(855,16,596,-166),(856,16,597,-167),(857,16,598,-168),(858,16,599,-169),(859,16,600,-170),(860,16,601,-171),(861,16,602,-172),(862,16,603,-173),(863,16,604,-174),(864,16,605,-175),(865,16,606,-176),(866,16,607,-177),(867,16,608,-178),(868,16,609,-179),(869,16,610,-180),(870,16,611,-181),(871,16,612,-182),(872,16,613,-183),(873,16,614,-184),(874,16,615,-185),(875,16,616,-186),(876,16,617,-187),(877,16,618,-188),(878,16,619,-189),(879,16,620,-190),(880,16,621,-191),(881,16,622,-192),(882,17,623,-1),(883,17,624,-2),(884,17,625,-3),(885,17,626,-4),(886,17,627,-5),(887,17,628,-6),(888,17,629,-7),(889,17,630,-8),(890,17,631,-9),(891,17,632,-10),(892,17,633,-11),(893,17,634,-12),(894,17,635,-13),(895,17,636,-14),(896,17,637,-15),(897,17,638,-16),(898,17,639,-17),(899,17,640,-18),(900,17,641,-19),(901,17,642,-20),(902,17,643,-21),(903,17,644,-22),(904,17,645,-23),(905,17,646,-24),(906,17,647,-25),(907,17,648,-26),(908,17,649,-27),(909,17,650,-28),(910,17,651,-29),(911,17,652,-30),(912,17,653,-31),(913,17,654,-32),(914,17,655,-33),(915,17,656,-34),(916,17,657,-35),(917,17,658,-36),(918,17,659,-37),(919,17,660,-38),(920,17,661,-39),(921,17,662,-40),(922,17,663,-41),(923,17,664,-42),(924,17,665,-43),(925,17,666,-44),(926,17,667,-45),(927,17,668,-46),(928,17,669,-47),(929,17,670,-48),(930,17,671,-49),(931,17,672,-50),(932,17,673,-51),(933,17,674,-52),(934,17,675,-53),(935,17,676,-54),(936,17,677,-55),(937,17,678,-56),(938,17,679,-57),(939,17,680,-58),(940,17,681,-59),(941,17,682,-60),(942,17,683,-61),(943,17,684,-62),(944,17,685,-63),(945,17,686,-64),(946,17,687,-65),(947,17,688,-66),(948,17,689,-67),(949,36,689,-97),(950,2,689,-97),(951,17,690,-68),(952,36,690,-98),(953,2,690,-98),(954,17,691,-69),(955,36,691,-99),(956,2,691,-99),(957,17,692,-70),(958,36,692,-100),(959,2,692,-100),(960,17,693,-71),(961,36,693,-101),(962,2,693,-101),(963,17,694,-72),(964,36,694,-102),(965,2,694,-102),(966,17,695,-73),(967,17,696,-74),(968,17,697,-75),(969,17,698,-76),(970,17,699,-77),(971,17,700,-78),(972,17,701,-79),(973,17,702,-80),(974,17,703,-81),(975,17,704,-82),(976,17,705,-83),(977,17,706,-84),(978,17,707,-85),(979,17,708,-86),(980,17,709,-87),(981,17,710,-88),(982,17,711,-89),(983,17,712,-90),(984,17,713,-91),(985,36,713,-103),(986,2,713,-103),(987,17,714,-92),(988,36,714,-104),(989,2,714,-104),(990,17,715,-93),(991,36,715,-105),(992,2,715,-105),(993,17,716,-94),(994,36,716,-106),(995,2,716,-106),(996,17,717,-95),(997,36,717,-107),(998,2,717,-107),(999,17,718,-96),(1000,36,718,-108),(1001,2,718,-108),(1002,17,719,-97),(1003,17,720,-98),(1004,17,721,-99),(1005,17,722,-100),(1006,17,723,-101),(1007,17,724,-102),(1008,18,725,-1),(1009,32,725,-1),(1010,2,725,-109),(1011,18,726,-2),(1012,32,726,-2),(1013,2,726,-110),(1014,18,727,-3),(1015,32,727,-3),(1016,2,727,-111),(1017,18,728,-4),(1018,32,728,-4),(1019,2,728,-112),(1020,18,729,-5),(1021,32,729,-5),(1022,2,729,-113),(1023,18,730,-6),(1024,32,730,-6),(1025,2,730,-114),(1026,18,731,-7),(1027,32,731,-7),(1028,2,731,-115),(1029,18,732,-8),(1030,32,732,-8),(1031,2,732,-116),(1032,18,733,-9),(1033,32,733,-9),(1034,2,733,-117),(1035,18,734,-10),(1036,32,734,-10),(1037,2,734,-118),(1038,18,735,-11),(1039,32,735,-11),(1040,2,735,-119),(1041,18,736,-12),(1042,32,736,-12),(1043,2,736,-120),(1044,18,737,-13),(1045,32,737,-13),(1046,2,737,-121),(1047,18,738,-14),(1048,32,738,-14),(1049,35,738,-1),(1050,2,738,-122),(1051,18,739,-15),(1052,32,739,-15),(1053,35,739,-2),(1054,2,739,-123),(1055,18,740,-16),(1056,32,740,-16),(1057,35,740,-3),(1058,2,740,-124),(1059,18,741,-17),(1060,32,741,-17),(1061,35,741,-4),(1062,2,741,-125),(1063,18,742,-18),(1064,32,742,-18),(1065,35,742,-5),(1066,2,742,-126),(1067,18,743,-19),(1068,32,743,-19),(1069,35,743,-6),(1070,2,743,-127),(1071,18,744,-20),(1072,32,744,-20),(1073,35,744,-7),(1074,2,744,-128),(1075,18,745,-21),(1076,32,745,-21),(1077,35,745,-8),(1078,2,745,-129),(1079,18,746,-22),(1080,32,746,-22),(1081,35,746,-9),(1082,2,746,-130),(1083,18,747,-23),(1084,32,747,-23),(1085,35,747,-10),(1086,2,747,-131),(1087,18,748,-24),(1088,32,748,-24),(1089,35,748,-11),(1090,2,748,-132),(1091,18,749,-25),(1092,32,749,-25),(1093,35,749,-12),(1094,2,749,-133),(1095,18,750,-26),(1096,32,750,-26),(1097,35,750,-13),(1098,2,750,-134),(1099,18,751,-27),(1100,32,751,-27),(1101,8,751,-1),(1102,2,751,-135),(1103,18,752,-28),(1104,32,752,-28),(1105,8,752,-2),(1106,2,752,-136),(1107,18,753,-29),(1108,32,753,-29),(1109,8,753,-3),(1110,2,753,-137),(1111,18,754,-30),(1112,32,754,-30),(1113,8,754,-4),(1114,2,754,-138),(1115,18,755,-31),(1116,32,755,-31),(1117,8,755,-5),(1118,2,755,-139),(1119,18,756,-32),(1120,32,756,-32),(1121,8,756,-6),(1122,2,756,-140),(1123,18,757,-33),(1124,32,757,-33),(1125,8,757,-7),(1126,2,757,-141),(1127,18,758,-34),(1128,32,758,-34),(1129,8,758,-8),(1130,2,758,-142),(1131,18,759,-35),(1132,32,759,-35),(1133,8,759,-9),(1134,2,759,-143),(1135,18,760,-36),(1136,32,760,-36),(1137,8,760,-10),(1138,2,760,-144),(1139,18,761,-37),(1140,32,761,-37),(1141,8,761,-11),(1142,2,761,-145),(1143,18,762,-38),(1144,32,762,-38),(1145,8,762,-12),(1146,2,762,-146),(1147,18,763,-39),(1148,32,763,-39),(1149,8,763,-13),(1150,2,763,-147),(1151,18,764,-40),(1152,32,764,-40),(1153,2,764,-148),(1154,18,765,-41),(1155,32,765,-41),(1156,2,765,-149),(1157,18,766,-42),(1158,32,766,-42),(1159,2,766,-150),(1160,18,767,-43),(1161,32,767,-43),(1162,2,767,-151),(1163,18,768,-44),(1164,32,768,-44),(1165,2,768,-152),(1166,18,769,-45),(1167,32,769,-45),(1168,2,769,-153),(1169,18,770,-46),(1170,32,770,-46),(1171,2,770,-154),(1172,18,771,-47),(1173,32,771,-47),(1174,2,771,-155),(1175,18,772,-48),(1176,32,772,-48),(1177,2,772,-156),(1178,18,773,-49),(1179,32,773,-49),(1180,2,773,-157),(1181,18,774,-50),(1182,32,774,-50),(1183,2,774,-158),(1184,18,775,-51),(1185,32,775,-51),(1186,2,775,-159),(1187,18,776,-52),(1188,32,776,-52),(1189,2,776,-160),(1190,18,777,-53),(1191,32,777,-53),(1192,8,777,-14),(1193,2,777,-161),(1194,18,778,-54),(1195,32,778,-54),(1196,8,778,-15),(1197,2,778,-162),(1198,18,779,-55),(1199,32,779,-55),(1200,8,779,-16),(1201,2,779,-163),(1202,18,780,-56),(1203,32,780,-56),(1204,8,780,-17),(1205,2,780,-164),(1206,18,781,-57),(1207,32,781,-57),(1208,8,781,-18),(1209,2,781,-165),(1210,18,782,-58),(1211,32,782,-58),(1212,8,782,-19),(1213,2,782,-166),(1214,18,783,-59),(1215,32,783,-59),(1216,8,783,-20),(1217,2,783,-167),(1218,18,784,-60),(1219,32,784,-60),(1220,8,784,-21),(1221,2,784,-168),(1222,18,785,-61),(1223,32,785,-61),(1224,8,785,-22),(1225,2,785,-169),(1226,18,786,-62),(1227,32,786,-62),(1228,8,786,-23),(1229,2,786,-170),(1230,18,787,-63),(1231,32,787,-63),(1232,8,787,-24),(1233,2,787,-171),(1234,18,788,-64),(1235,32,788,-64),(1236,8,788,-25),(1237,2,788,-172),(1238,18,789,-65),(1239,32,789,-65),(1240,8,789,-26),(1241,2,789,-173),(1242,18,790,-66),(1243,32,790,-66),(1244,36,790,-109),(1245,2,790,-174),(1246,18,791,-67),(1247,32,791,-67),(1248,36,791,-110),(1249,2,791,-175),(1250,18,792,-68),(1251,32,792,-68),(1252,36,792,-111),(1253,2,792,-176),(1254,18,793,-69),(1255,32,793,-69),(1256,36,793,-112),(1257,2,793,-177),(1258,18,794,-70),(1259,32,794,-70),(1260,36,794,-113),(1261,2,794,-178),(1262,18,795,-71),(1263,32,795,-71),(1264,36,795,-114),(1265,2,795,-179),(1266,18,796,-72),(1267,32,796,-72),(1268,36,796,-115),(1269,2,796,-180),(1270,18,797,-73),(1271,32,797,-73),(1272,36,797,-116),(1273,2,797,-181),(1274,18,798,-74),(1275,32,798,-74),(1276,36,798,-117),(1277,2,798,-182),(1278,18,799,-75),(1279,32,799,-75),(1280,36,799,-118),(1281,2,799,-183),(1282,18,800,-76),(1283,32,800,-76),(1284,36,800,-119),(1285,2,800,-184),(1286,18,801,-77),(1287,32,801,-77),(1288,36,801,-120),(1289,2,801,-185),(1290,18,802,-78),(1291,32,802,-78),(1292,36,802,-121),(1293,2,802,-186),(1294,18,803,-79),(1295,32,803,-79),(1296,8,803,-27),(1297,2,803,-187),(1298,18,804,-80),(1299,32,804,-80),(1300,8,804,-28),(1301,2,804,-188),(1302,18,805,-81),(1303,32,805,-81),(1304,8,805,-29),(1305,2,805,-189),(1306,18,806,-82),(1307,32,806,-82),(1308,8,806,-30),(1309,2,806,-190),(1310,18,807,-83),(1311,32,807,-83),(1312,8,807,-31),(1313,2,807,-191),(1314,18,808,-84),(1315,32,808,-84),(1316,8,808,-32),(1317,2,808,-192),(1318,18,809,-85),(1319,32,809,-85),(1320,8,809,-33),(1321,2,809,-193),(1322,18,810,-86),(1323,32,810,-86),(1324,8,810,-34),(1325,2,810,-194),(1326,18,811,-87),(1327,32,811,-87),(1328,8,811,-35),(1329,2,811,-195),(1330,18,812,-88),(1331,32,812,-88),(1332,8,812,-36),(1333,2,812,-196),(1334,18,813,-89),(1335,32,813,-89),(1336,8,813,-37),(1337,2,813,-197),(1338,18,814,-90),(1339,32,814,-90),(1340,8,814,-38),(1341,2,814,-198),(1342,18,815,-91),(1343,32,815,-91),(1344,8,815,-39),(1345,2,815,-199),(1346,18,816,-92),(1347,32,816,-92),(1348,8,816,-40),(1349,2,816,-200),(1350,18,817,-93),(1351,32,817,-93),(1352,8,817,-41),(1353,2,817,-201),(1354,18,818,-94),(1355,32,818,-94),(1356,8,818,-42),(1357,2,818,-202),(1358,18,819,-95),(1359,32,819,-95),(1360,8,819,-43),(1361,2,819,-203),(1362,18,820,-96),(1363,32,820,-96),(1364,8,820,-44),(1365,2,820,-204),(1366,18,821,-97),(1367,32,821,-97),(1368,8,821,-45),(1369,2,821,-205),(1370,18,822,-98),(1371,32,822,-98),(1372,8,822,-46),(1373,2,822,-206),(1374,18,823,-99),(1375,32,823,-99),(1376,8,823,-47),(1377,2,823,-207),(1378,18,824,-100),(1379,32,824,-100),(1380,8,824,-48),(1381,2,824,-208),(1382,18,825,-101),(1383,32,825,-101),(1384,8,825,-49),(1385,2,825,-209),(1386,18,826,-102),(1387,32,826,-102),(1388,8,826,-50),(1389,2,826,-210),(1390,18,827,-103),(1391,32,827,-103),(1392,8,827,-51),(1393,2,827,-211),(1394,18,828,-104),(1395,32,828,-104),(1396,8,828,-52),(1397,2,828,-212),(1398,18,829,-105),(1399,32,829,-105),(1400,8,829,-53),(1401,34,829,-1),(1402,2,829,-213),(1403,18,830,-106),(1404,32,830,-106),(1405,8,830,-54),(1406,34,830,-2),(1407,2,830,-214),(1408,18,831,-107),(1409,32,831,-107),(1410,8,831,-55),(1411,34,831,-3),(1412,2,831,-215),(1413,18,832,-108),(1414,32,832,-108),(1415,8,832,-56),(1416,34,832,-4),(1417,2,832,-216),(1418,18,833,-109),(1419,32,833,-109),(1420,8,833,-57),(1421,34,833,-5),(1422,2,833,-217),(1423,18,834,-110),(1424,32,834,-110),(1425,8,834,-58),(1426,34,834,-6),(1427,2,834,-218),(1428,18,835,-111),(1429,32,835,-111),(1430,8,835,-59),(1431,34,835,-7),(1432,2,835,-219),(1433,18,836,-112),(1434,32,836,-112),(1435,8,836,-60),(1436,34,836,-8),(1437,2,836,-220),(1438,18,837,-113),(1439,32,837,-113),(1440,8,837,-61),(1441,34,837,-9),(1442,2,837,-221),(1443,18,838,-114),(1444,32,838,-114),(1445,8,838,-62),(1446,34,838,-10),(1447,2,838,-222),(1448,18,839,-115),(1449,32,839,-115),(1450,8,839,-63),(1451,34,839,-11),(1452,2,839,-223),(1453,18,840,-116),(1454,32,840,-116),(1455,8,840,-64),(1456,34,840,-12),(1457,2,840,-224),(1458,18,841,-117),(1459,32,841,-117),(1460,8,841,-65),(1461,34,841,-13),(1462,2,841,-225),(1463,18,842,-118),(1464,32,842,-118),(1465,34,842,-14),(1466,2,842,-226),(1467,18,843,-119),(1468,32,843,-119),(1469,34,843,-15),(1470,2,843,-227),(1471,18,844,-120),(1472,32,844,-120),(1473,34,844,-16),(1474,2,844,-228),(1475,18,845,-121),(1476,32,845,-121),(1477,34,845,-17),(1478,2,845,-229),(1479,18,846,-122),(1480,32,846,-122),(1481,34,846,-18),(1482,2,846,-230),(1483,18,847,-123),(1484,32,847,-123),(1485,34,847,-19),(1486,2,847,-231),(1487,18,848,-124),(1488,32,848,-124),(1489,34,848,-20),(1490,2,848,-232),(1491,18,849,-125),(1492,32,849,-125),(1493,34,849,-21),(1494,2,849,-233),(1495,18,850,-126),(1496,32,850,-126),(1497,34,850,-22),(1498,2,850,-234),(1499,18,851,-127),(1500,32,851,-127),(1501,34,851,-23),(1502,2,851,-235),(1503,18,852,-128),(1504,32,852,-128),(1505,34,852,-24),(1506,2,852,-236),(1507,18,853,-129),(1508,32,853,-129),(1509,34,853,-25),(1510,2,853,-237),(1511,18,854,-130),(1512,32,854,-130),(1513,34,854,-26),(1514,2,854,-238),(1515,18,855,-131),(1516,32,855,-131),(1517,34,855,-27),(1518,2,855,-239),(1519,18,856,-132),(1520,32,856,-132),(1521,34,856,-28),(1522,2,856,-240),(1523,18,857,-133),(1524,32,857,-133),(1525,34,857,-29),(1526,2,857,-241),(1527,18,858,-134),(1528,32,858,-134),(1529,34,858,-30),(1530,2,858,-242),(1531,18,859,-135),(1532,32,859,-135),(1533,34,859,-31),(1534,2,859,-243),(1535,18,860,-136),(1536,32,860,-136),(1537,34,860,-32),(1538,2,860,-244),(1539,18,861,-137),(1540,32,861,-137),(1541,34,861,-33),(1542,2,861,-245),(1543,18,862,-138),(1544,32,862,-138),(1545,34,862,-34),(1546,2,862,-246),(1547,18,863,-139),(1548,32,863,-139),(1549,34,863,-35),(1550,2,863,-247),(1551,18,864,-140),(1552,32,864,-140),(1553,34,864,-36),(1554,2,864,-248),(1555,18,865,-141),(1556,32,865,-141),(1557,34,865,-37),(1558,2,865,-249),(1559,18,866,-142),(1560,32,866,-142),(1561,34,866,-38),(1562,2,866,-250),(1563,18,867,-143),(1564,32,867,-143),(1565,34,867,-39),(1566,2,867,-251),(1567,18,868,-144),(1568,32,868,-144),(1569,2,868,-252),(1570,18,869,-145),(1571,32,869,-145),(1572,2,869,-253),(1573,18,870,-146),(1574,32,870,-146),(1575,2,870,-254),(1576,18,871,-147),(1577,32,871,-147),(1578,2,871,-255),(1579,18,872,-148),(1580,32,872,-148),(1581,2,872,-256),(1582,18,873,-149),(1583,32,873,-149),(1584,2,873,-257),(1585,18,874,-150),(1586,32,874,-150),(1587,2,874,-258),(1588,18,875,-151),(1589,32,875,-151),(1590,2,875,-259),(1591,18,876,-152),(1592,32,876,-152),(1593,2,876,-260),(1594,18,877,-153),(1595,32,877,-153),(1596,2,877,-261),(1597,18,878,-154),(1598,32,878,-154),(1599,2,878,-262),(1600,18,879,-155),(1601,32,879,-155),(1602,2,879,-263),(1603,18,880,-156),(1604,32,880,-156),(1605,2,880,-264),(1606,19,881,-1),(1607,34,881,-40),(1608,2,881,-265),(1609,19,882,-2),(1610,34,882,-41),(1611,2,882,-266),(1612,19,883,-3),(1613,34,883,-42),(1614,2,883,-267),(1615,19,884,-4),(1616,34,884,-43),(1617,2,884,-268),(1618,19,885,-5),(1619,34,885,-44),(1620,2,885,-269),(1621,19,886,-6),(1622,34,886,-45),(1623,2,886,-270),(1624,19,887,-7),(1625,34,887,-46),(1626,2,887,-271),(1627,19,888,-8),(1628,34,888,-47),(1629,2,888,-272),(1630,19,889,-9),(1631,34,889,-48),(1632,2,889,-273),(1633,19,890,-10),(1634,34,890,-49),(1635,2,890,-274),(1636,19,891,-11),(1637,34,891,-50),(1638,2,891,-275),(1639,19,892,-12),(1640,34,892,-51),(1641,2,892,-276),(1642,19,893,-13),(1643,34,893,-52),(1644,2,893,-277),(1645,19,894,-14),(1646,19,895,-15),(1647,19,896,-16),(1648,19,897,-17),(1649,19,898,-18),(1650,19,899,-19),(1651,35,899,-14),(1652,2,899,-278),(1653,19,900,-20),(1654,35,900,-15),(1655,2,900,-279),(1656,19,901,-21),(1657,35,901,-16),(1658,2,901,-280),(1659,19,902,-22),(1660,35,902,-17),(1661,2,902,-281),(1662,19,903,-23),(1663,35,903,-18),(1664,2,903,-282),(1665,19,904,-24),(1666,35,904,-19),(1667,2,904,-283),(1668,19,905,-25),(1669,35,905,-20),(1670,2,905,-284),(1671,19,906,-26),(1672,35,906,-21),(1673,2,906,-285),(1674,19,907,-27),(1675,35,907,-22),(1676,2,907,-286),(1677,19,908,-28),(1678,35,908,-23),(1679,2,908,-287),(1680,19,909,-29),(1681,35,909,-24),(1682,2,909,-288),(1683,19,910,-30),(1684,35,910,-25),(1685,2,910,-289),(1686,19,911,-31),(1687,35,911,-26),(1688,2,911,-290),(1689,19,912,-32),(1690,19,913,-33),(1691,19,914,-34),(1692,19,915,-35),(1693,19,916,-36),(1694,19,917,-37),(1695,19,918,-38),(1696,19,919,-39),(1697,19,920,-40),(1698,19,921,-41),(1699,19,922,-42),(1700,19,923,-43),(1701,19,924,-44),(1702,19,925,-45),(1703,35,925,-27),(1704,2,925,-291),(1705,19,926,-46),(1706,35,926,-28),(1707,2,926,-292),(1708,19,927,-47),(1709,35,927,-29),(1710,2,927,-293),(1711,19,928,-48),(1712,35,928,-30),(1713,2,928,-294),(1714,19,929,-49),(1715,35,929,-31),(1716,2,929,-295),(1717,19,930,-50),(1718,35,930,-32),(1719,2,930,-296),(1720,19,931,-51),(1721,35,931,-33),(1722,2,931,-297),(1723,19,932,-52),(1724,35,932,-34),(1725,2,932,-298),(1726,19,933,-53),(1727,35,933,-35),(1728,2,933,-299),(1729,19,934,-54),(1730,35,934,-36),(1731,2,934,-300),(1732,19,935,-55),(1733,35,935,-37),(1734,2,935,-301),(1735,19,936,-56),(1736,35,936,-38),(1737,2,936,-302),(1738,19,937,-57),(1739,35,937,-39),(1740,2,937,-303),(1741,19,938,-58),(1742,8,938,-66),(1743,2,938,-304),(1744,19,939,-59),(1745,8,939,-67),(1746,2,939,-305),(1747,19,940,-60),(1748,8,940,-68),(1749,2,940,-306),(1750,19,941,-61),(1751,8,941,-69),(1752,2,941,-307),(1753,19,942,-62),(1754,8,942,-70),(1755,2,942,-308),(1756,19,943,-63),(1757,8,943,-71),(1758,2,943,-309),(1759,19,944,-64),(1760,8,944,-72),(1761,2,944,-310),(1762,19,945,-65),(1763,8,945,-73),(1764,2,945,-311),(1765,19,946,-66),(1766,8,946,-74),(1767,2,946,-312),(1768,19,947,-67),(1769,8,947,-75),(1770,2,947,-313),(1771,19,948,-68),(1772,8,948,-76),(1773,2,948,-314),(1774,19,949,-69),(1775,8,949,-77),(1776,2,949,-315),(1777,19,950,-70),(1778,8,950,-78),(1779,2,950,-316),(1780,19,951,-71),(1781,31,951,-1),(1782,34,951,-53),(1783,2,951,-317),(1784,19,952,-72),(1785,31,952,-2),(1786,34,952,-54),(1787,2,952,-318),(1788,19,953,-73),(1789,31,953,-3),(1790,34,953,-55),(1791,2,953,-319),(1792,19,954,-74),(1793,31,954,-4),(1794,34,954,-56),(1795,2,954,-320),(1796,19,955,-75),(1797,31,955,-5),(1798,34,955,-57),(1799,2,955,-321),(1800,19,956,-76),(1801,31,956,-6),(1802,34,956,-58),(1803,2,956,-322),(1804,19,957,-77),(1805,31,957,-7),(1806,34,957,-59),(1807,2,957,-323),(1808,19,958,-78),(1809,31,958,-8),(1810,34,958,-60),(1811,2,958,-324),(1812,19,959,-79),(1813,31,959,-9),(1814,34,959,-61),(1815,2,959,-325),(1816,19,960,-80),(1817,31,960,-10),(1818,34,960,-62),(1819,2,960,-326),(1820,19,961,-81),(1821,31,961,-11),(1822,34,961,-63),(1823,2,961,-327),(1824,19,962,-82),(1825,31,962,-12),(1826,34,962,-64),(1827,2,962,-328),(1828,19,963,-83),(1829,31,963,-13),(1830,34,963,-65),(1831,2,963,-329),(1832,19,964,-84),(1833,31,964,-14),(1834,2,964,-330),(1835,19,965,-85),(1836,31,965,-15),(1837,2,965,-331),(1838,19,966,-86),(1839,31,966,-16),(1840,2,966,-332),(1841,19,967,-87),(1842,31,967,-17),(1843,2,967,-333),(1844,19,968,-88),(1845,31,968,-18),(1846,2,968,-334),(1847,19,969,-89),(1848,31,969,-19),(1849,2,969,-335),(1850,19,970,-90),(1851,31,970,-20),(1852,2,970,-336),(1853,19,971,-91),(1854,31,971,-21),(1855,2,971,-337),(1856,19,972,-92),(1857,31,972,-22),(1858,2,972,-338),(1859,19,973,-93),(1860,31,973,-23),(1861,2,973,-339),(1862,19,974,-94),(1863,31,974,-24),(1864,2,974,-340),(1865,19,975,-95),(1866,31,975,-25),(1867,2,975,-341),(1868,19,976,-96),(1869,31,976,-26),(1870,2,976,-342),(1871,19,977,-97),(1872,35,977,-40),(1873,2,977,-343),(1874,19,978,-98),(1875,35,978,-41),(1876,2,978,-344),(1877,19,979,-99),(1878,35,979,-42),(1879,2,979,-345),(1880,19,980,-100),(1881,35,980,-43),(1882,2,980,-346),(1883,19,981,-101),(1884,35,981,-44),(1885,2,981,-347),(1886,19,982,-102),(1887,35,982,-45),(1888,2,982,-348),(1889,19,983,-103),(1890,35,983,-46),(1891,2,983,-349),(1892,19,984,-104),(1893,35,984,-47),(1894,2,984,-350),(1895,19,985,-105),(1896,35,985,-48),(1897,2,985,-351),(1898,19,986,-106),(1899,35,986,-49),(1900,2,986,-352),(1901,19,987,-107),(1902,35,987,-50),(1903,2,987,-353),(1904,19,988,-108),(1905,35,988,-51),(1906,2,988,-354),(1907,19,989,-109),(1908,35,989,-52),(1909,2,989,-355),(1910,19,990,-110),(1911,8,990,-79),(1912,2,990,-356),(1913,19,991,-111),(1914,8,991,-80),(1915,2,991,-357),(1916,19,992,-112),(1917,8,992,-81),(1918,2,992,-358),(1919,19,993,-113),(1920,8,993,-82),(1921,2,993,-359),(1922,19,994,-114),(1923,8,994,-83),(1924,2,994,-360),(1925,19,995,-115),(1926,8,995,-84),(1927,2,995,-361),(1928,19,996,-116),(1929,8,996,-85),(1930,2,996,-362),(1931,19,997,-117),(1932,8,997,-86),(1933,2,997,-363),(1934,19,998,-118),(1935,8,998,-87),(1936,2,998,-364),(1937,19,999,-119),(1938,8,999,-88),(1939,2,999,-365),(1940,19,1000,-120),(1941,8,1000,-89),(1942,2,1000,-366),(1943,19,1001,-121),(1944,8,1001,-90),(1945,2,1001,-367),(1946,19,1002,-122),(1947,8,1002,-91),(1948,2,1002,-368),(1949,19,1003,-123),(1950,19,1004,-124),(1951,19,1005,-125),(1952,19,1006,-126),(1953,19,1007,-127),(1954,19,1008,-128),(1955,19,1009,-129),(1956,19,1010,-130),(1957,19,1011,-131),(1958,19,1012,-132),(1959,19,1013,-133),(1960,19,1014,-134),(1961,19,1015,-135),(1962,19,1016,-136),(1963,31,1016,-27),(1964,2,1016,-369),(1965,19,1017,-137),(1966,31,1017,-28),(1967,2,1017,-370),(1968,19,1018,-138),(1969,31,1018,-29),(1970,2,1018,-371),(1971,19,1019,-139),(1972,31,1019,-30),(1973,2,1019,-372),(1974,19,1020,-140),(1975,31,1020,-31),(1976,2,1020,-373),(1977,19,1021,-141),(1978,31,1021,-32),(1979,2,1021,-374),(1980,19,1022,-142),(1981,31,1022,-33),(1982,2,1022,-375),(1983,19,1023,-143),(1984,31,1023,-34),(1985,2,1023,-376),(1986,19,1024,-144),(1987,31,1024,-35),(1988,2,1024,-377),(1989,19,1025,-145),(1990,31,1025,-36),(1991,2,1025,-378),(1992,19,1026,-146),(1993,31,1026,-37),(1994,2,1026,-379),(1995,19,1027,-147),(1996,31,1027,-38),(1997,2,1027,-380),(1998,19,1028,-148),(1999,31,1028,-39),(2000,2,1028,-381),(2001,24,1029,-1),(2002,8,1029,-92),(2003,34,1029,-66),(2004,2,1029,-382),(2005,24,1030,-2),(2006,8,1030,-93),(2007,34,1030,-67),(2008,2,1030,-383),(2009,24,1031,-3),(2010,8,1031,-94),(2011,34,1031,-68),(2012,2,1031,-384),(2013,24,1032,-4),(2014,8,1032,-95),(2015,34,1032,-69),(2016,2,1032,-385),(2017,24,1033,-5),(2018,8,1033,-96),(2019,34,1033,-70),(2020,2,1033,-386),(2021,24,1034,-6),(2022,8,1034,-97),(2023,34,1034,-71),(2024,2,1034,-387),(2025,24,1035,-7),(2026,8,1035,-98),(2027,34,1035,-72),(2028,2,1035,-388),(2029,24,1036,-8),(2030,8,1036,-99),(2031,34,1036,-73),(2032,2,1036,-389),(2033,24,1037,-9),(2034,8,1037,-100),(2035,34,1037,-74),(2036,2,1037,-390),(2037,24,1038,-10),(2038,8,1038,-101),(2039,34,1038,-75),(2040,2,1038,-391),(2041,24,1039,-11),(2042,8,1039,-102),(2043,34,1039,-76),(2044,2,1039,-392),(2045,24,1040,-12),(2046,8,1040,-103),(2047,34,1040,-77),(2048,2,1040,-393),(2049,24,1041,-13),(2050,8,1041,-104),(2051,34,1041,-78),(2052,2,1041,-394),(2053,24,1042,-14),(2054,8,1042,-105),(2055,34,1042,-79),(2056,2,1042,-395),(2057,24,1043,-15),(2058,8,1043,-106),(2059,34,1043,-80),(2060,2,1043,-396),(2061,24,1044,-16),(2062,8,1044,-107),(2063,34,1044,-81),(2064,2,1044,-397),(2065,24,1045,-17),(2066,30,1045,-1),(2067,2,1045,-398),(2068,24,1046,-18),(2069,30,1046,-2),(2070,2,1046,-399),(2071,24,1047,-19),(2072,30,1047,-3),(2073,2,1047,-400),(2074,24,1048,-20),(2075,30,1048,-4),(2076,2,1048,-401),(2077,24,1049,-21),(2078,30,1049,-5),(2079,2,1049,-402),(2080,24,1050,-22),(2081,30,1050,-6),(2082,2,1050,-403),(2083,24,1051,-23),(2084,30,1051,-7),(2085,2,1051,-404),(2086,24,1052,-24),(2087,30,1052,-8),(2088,2,1052,-405),(2089,24,1053,-25),(2090,30,1053,-9),(2091,2,1053,-406),(2092,24,1054,-26),(2093,30,1054,-10),(2094,2,1054,-407),(2095,24,1055,-27),(2096,30,1055,-11),(2097,2,1055,-408),(2098,24,1056,-28),(2099,30,1056,-12),(2100,2,1056,-409),(2101,24,1057,-29),(2102,30,1057,-13),(2103,2,1057,-410),(2104,24,1058,-30),(2105,30,1058,-14),(2106,2,1058,-411),(2107,24,1059,-31),(2108,30,1059,-15),(2109,2,1059,-412),(2110,24,1060,-32),(2111,30,1060,-16),(2112,2,1060,-413),(2113,24,1061,-33),(2114,24,1062,-34),(2115,24,1063,-35),(2116,24,1064,-36),(2117,24,1065,-37),(2118,24,1066,-38),(2119,24,1067,-39),(2120,24,1068,-40),(2121,24,1069,-41),(2122,24,1070,-42),(2123,24,1071,-43),(2124,24,1072,-44),(2125,24,1073,-45),(2126,24,1074,-46),(2127,24,1075,-47),(2128,24,1076,-48),(2129,24,1077,-49),(2130,24,1078,-50),(2131,24,1079,-51),(2132,24,1080,-52),(2133,24,1081,-53),(2134,24,1082,-54),(2135,24,1083,-55),(2136,24,1084,-56),(2137,24,1085,-57),(2138,24,1086,-58),(2139,24,1087,-59),(2140,24,1088,-60),(2141,24,1089,-61),(2142,24,1090,-62),(2143,24,1091,-63),(2144,24,1092,-64),(2145,24,1093,-65),(2146,24,1094,-66),(2147,24,1095,-67),(2148,24,1096,-68),(2149,24,1097,-69),(2150,24,1098,-70),(2151,24,1099,-71),(2152,24,1100,-72),(2153,24,1101,-73),(2154,24,1102,-74),(2155,24,1103,-75),(2156,24,1104,-76),(2157,24,1105,-77),(2158,24,1106,-78),(2159,24,1107,-79),(2160,24,1108,-80),(2161,24,1109,-81),(2162,24,1110,-82),(2163,24,1111,-83),(2164,24,1112,-84),(2165,24,1113,-85),(2166,24,1114,-86),(2167,24,1115,-87),(2168,8,1115,-108),(2169,34,1115,-82),(2170,2,1115,-414),(2171,24,1116,-88),(2172,8,1116,-109),(2173,34,1116,-83),(2174,2,1116,-415),(2175,24,1117,-89),(2176,8,1117,-110),(2177,34,1117,-84),(2178,2,1117,-416),(2179,24,1118,-90),(2180,8,1118,-111),(2181,34,1118,-85),(2182,2,1118,-417),(2183,24,1119,-91),(2184,8,1119,-112),(2185,34,1119,-86),(2186,2,1119,-418),(2187,24,1120,-92),(2188,8,1120,-113),(2189,34,1120,-87),(2190,2,1120,-419),(2191,24,1121,-93),(2192,8,1121,-114),(2193,34,1121,-88),(2194,2,1121,-420),(2195,24,1122,-94),(2196,8,1122,-115),(2197,34,1122,-89),(2198,2,1122,-421),(2199,24,1123,-95),(2200,8,1123,-116),(2201,34,1123,-90),(2202,2,1123,-422),(2203,24,1124,-96),(2204,8,1124,-117),(2205,34,1124,-91),(2206,2,1124,-423),(2207,24,1125,-97),(2208,8,1125,-118),(2209,34,1125,-92),(2210,2,1125,-424),(2211,24,1126,-98),(2212,8,1126,-119),(2213,34,1126,-93),(2214,2,1126,-425),(2215,24,1127,-99),(2216,8,1127,-120),(2217,34,1127,-94),(2218,2,1127,-426),(2219,24,1128,-100),(2220,8,1128,-121),(2221,34,1128,-95),(2222,2,1128,-427),(2223,24,1129,-101),(2224,8,1129,-122),(2225,34,1129,-96),(2226,2,1129,-428),(2227,24,1130,-102),(2228,8,1130,-123),(2229,34,1130,-97),(2230,2,1130,-429),(2231,24,1131,-103),(2232,30,1131,-17),(2233,35,1131,-53),(2234,2,1131,-430),(2235,24,1132,-104),(2236,30,1132,-18),(2237,35,1132,-54),(2238,2,1132,-431),(2239,24,1133,-105),(2240,30,1133,-19),(2241,35,1133,-55),(2242,2,1133,-432),(2243,24,1134,-106),(2244,30,1134,-20),(2245,35,1134,-56),(2246,2,1134,-433),(2247,24,1135,-107),(2248,30,1135,-21),(2249,35,1135,-57),(2250,2,1135,-434),(2251,24,1136,-108),(2252,30,1136,-22),(2253,35,1136,-58),(2254,2,1136,-435),(2255,24,1137,-109),(2256,30,1137,-23),(2257,35,1137,-59),(2258,2,1137,-436),(2259,24,1138,-110),(2260,30,1138,-24),(2261,35,1138,-60),(2262,2,1138,-437),(2263,24,1139,-111),(2264,30,1139,-25),(2265,35,1139,-61),(2266,2,1139,-438),(2267,24,1140,-112),(2268,30,1140,-26),(2269,35,1140,-62),(2270,2,1140,-439),(2271,24,1141,-113),(2272,30,1141,-27),(2273,35,1141,-63),(2274,2,1141,-440),(2275,24,1142,-114),(2276,30,1142,-28),(2277,35,1142,-64),(2278,2,1142,-441),(2279,24,1143,-115),(2280,30,1143,-29),(2281,35,1143,-65),(2282,2,1143,-442),(2283,24,1144,-116),(2284,30,1144,-30),(2285,35,1144,-66),(2286,2,1144,-443),(2287,24,1145,-117),(2288,30,1145,-31),(2289,35,1145,-67),(2290,2,1145,-444),(2291,24,1146,-118),(2292,30,1146,-32),(2293,35,1146,-68),(2294,2,1146,-445),(2295,24,1147,-119),(2296,36,1147,-122),(2297,2,1147,-446),(2298,24,1148,-120),(2299,36,1148,-123),(2300,2,1148,-447),(2301,24,1149,-121),(2302,36,1149,-124),(2303,2,1149,-448),(2304,24,1150,-122),(2305,36,1150,-125),(2306,2,1150,-449),(2307,24,1151,-123),(2308,36,1151,-126),(2309,2,1151,-450),(2310,24,1152,-124),(2311,36,1152,-127),(2312,2,1152,-451),(2313,24,1153,-125),(2314,36,1153,-128),(2315,2,1153,-452),(2316,24,1154,-126),(2317,36,1154,-129),(2318,2,1154,-453),(2319,24,1155,-127),(2320,36,1155,-130),(2321,2,1155,-454),(2322,24,1156,-128),(2323,36,1156,-131),(2324,2,1156,-455),(2325,24,1157,-129),(2326,36,1157,-132),(2327,2,1157,-456),(2328,24,1158,-130),(2329,36,1158,-133),(2330,2,1158,-457),(2331,24,1159,-131),(2332,36,1159,-134),(2333,2,1159,-458),(2334,24,1160,-132),(2335,36,1160,-135),(2336,2,1160,-459),(2337,24,1161,-133),(2338,36,1161,-136),(2339,2,1161,-460),(2340,24,1162,-134),(2341,36,1162,-137),(2342,2,1162,-461),(2343,24,1163,-135),(2344,8,1163,-124),(2345,2,1163,-462),(2346,24,1164,-136),(2347,8,1164,-125),(2348,2,1164,-463),(2349,24,1165,-137),(2350,8,1165,-126),(2351,2,1165,-464),(2352,24,1166,-138),(2353,8,1166,-127),(2354,2,1166,-465),(2355,24,1167,-139),(2356,8,1167,-128),(2357,2,1167,-466),(2358,24,1168,-140),(2359,8,1168,-129),(2360,2,1168,-467),(2361,24,1169,-141),(2362,8,1169,-130),(2363,2,1169,-468),(2364,24,1170,-142),(2365,8,1170,-131),(2366,2,1170,-469),(2367,24,1171,-143),(2368,8,1171,-132),(2369,2,1171,-470),(2370,24,1172,-144),(2371,8,1172,-133),(2372,2,1172,-471),(2373,24,1173,-145),(2374,8,1173,-134),(2375,2,1173,-472),(2376,24,1174,-146),(2377,8,1174,-135),(2378,2,1174,-473),(2379,24,1175,-147),(2380,8,1175,-136),(2381,2,1175,-474),(2382,24,1176,-148),(2383,8,1176,-137),(2384,2,1176,-475),(2385,24,1177,-149),(2386,8,1177,-138),(2387,2,1177,-476),(2388,24,1178,-150),(2389,8,1178,-139),(2390,2,1178,-477),(2391,24,1179,-151),(2392,34,1179,-98),(2393,2,1179,-478),(2394,24,1180,-152),(2395,34,1180,-99),(2396,2,1180,-479),(2397,24,1181,-153),(2398,34,1181,-100),(2399,2,1181,-480),(2400,24,1182,-154),(2401,34,1182,-101),(2402,2,1182,-481),(2403,24,1183,-155),(2404,34,1183,-102),(2405,2,1183,-482),(2406,24,1184,-156),(2407,34,1184,-103),(2408,2,1184,-483),(2409,24,1185,-157),(2410,34,1185,-104),(2411,2,1185,-484),(2412,24,1186,-158),(2413,34,1186,-105),(2414,2,1186,-485),(2415,24,1187,-159),(2416,34,1187,-106),(2417,2,1187,-486),(2418,24,1188,-160),(2419,34,1188,-107),(2420,2,1188,-487),(2421,24,1189,-161),(2422,34,1189,-108),(2423,2,1189,-488),(2424,24,1190,-162),(2425,34,1190,-109),(2426,2,1190,-489),(2427,24,1191,-163),(2428,34,1191,-110),(2429,2,1191,-490),(2430,24,1192,-164),(2431,34,1192,-111),(2432,2,1192,-491),(2433,24,1193,-165),(2434,34,1193,-112),(2435,2,1193,-492),(2436,24,1194,-166),(2437,34,1194,-113),(2438,2,1194,-493),(2439,24,1195,-167),(2440,35,1195,-69),(2441,2,1195,-494),(2442,24,1196,-168),(2443,35,1196,-70),(2444,2,1196,-495),(2445,24,1197,-169),(2446,35,1197,-71),(2447,2,1197,-496),(2448,24,1198,-170),(2449,35,1198,-72),(2450,2,1198,-497),(2451,24,1199,-171),(2452,35,1199,-73),(2453,2,1199,-498),(2454,24,1200,-172),(2455,35,1200,-74),(2456,2,1200,-499),(2457,24,1201,-173),(2458,35,1201,-75),(2459,2,1201,-500),(2460,24,1202,-174),(2461,35,1202,-76),(2462,2,1202,-501),(2463,24,1203,-175),(2464,35,1203,-77),(2465,2,1203,-502),(2466,24,1204,-176),(2467,35,1204,-78),(2468,2,1204,-503),(2469,24,1205,-177),(2470,35,1205,-79),(2471,2,1205,-504),(2472,24,1206,-178),(2473,35,1206,-80),(2474,2,1206,-505),(2475,24,1207,-179),(2476,35,1207,-81),(2477,2,1207,-506),(2478,24,1208,-180),(2479,35,1208,-82),(2480,2,1208,-507),(2481,24,1209,-181),(2482,35,1209,-83),(2483,2,1209,-508),(2484,24,1210,-182),(2485,35,1210,-84),(2486,2,1210,-509),(2487,23,1211,-1),(2488,8,1211,-140),(2489,34,1211,-114),(2490,2,1211,-510),(2491,23,1212,-2),(2492,8,1212,-141),(2493,34,1212,-115),(2494,2,1212,-511),(2495,23,1213,-3),(2496,8,1213,-142),(2497,34,1213,-116),(2498,2,1213,-512),(2499,23,1214,-4),(2500,8,1214,-143),(2501,34,1214,-117),(2502,2,1214,-513),(2503,23,1215,-5),(2504,8,1215,-144),(2505,34,1215,-118),(2506,2,1215,-514),(2507,23,1216,-6),(2508,8,1216,-145),(2509,34,1216,-119),(2510,2,1216,-515),(2511,23,1217,-7),(2512,8,1217,-146),(2513,34,1217,-120),(2514,2,1217,-516),(2515,23,1218,-8),(2516,8,1218,-147),(2517,34,1218,-121),(2518,2,1218,-517),(2519,23,1219,-9),(2520,8,1219,-148),(2521,34,1219,-122),(2522,2,1219,-518),(2523,23,1220,-10),(2524,8,1220,-149),(2525,34,1220,-123),(2526,2,1220,-519),(2527,23,1221,-11),(2528,30,1221,-33),(2529,2,1221,-520),(2530,23,1222,-12),(2531,30,1222,-34),(2532,2,1222,-521),(2533,23,1223,-13),(2534,30,1223,-35),(2535,2,1223,-522),(2536,23,1224,-14),(2537,30,1224,-36),(2538,2,1224,-523),(2539,23,1225,-15),(2540,30,1225,-37),(2541,2,1225,-524),(2542,23,1226,-16),(2543,30,1226,-38),(2544,2,1226,-525),(2545,23,1227,-17),(2546,30,1227,-39),(2547,2,1227,-526),(2548,23,1228,-18),(2549,30,1228,-40),(2550,2,1228,-527),(2551,23,1229,-19),(2552,30,1229,-41),(2553,2,1229,-528),(2554,23,1230,-20),(2555,30,1230,-42),(2556,2,1230,-529),(2557,23,1231,-21),(2558,30,1231,-43),(2559,2,1231,-530),(2560,23,1232,-22),(2561,30,1232,-44),(2562,2,1232,-531),(2563,23,1233,-23),(2564,30,1233,-45),(2565,2,1233,-532),(2566,23,1234,-24),(2567,30,1234,-46),(2568,2,1234,-533),(2569,23,1235,-25),(2570,30,1235,-47),(2571,2,1235,-534),(2572,23,1236,-26),(2573,30,1236,-48),(2574,2,1236,-535),(2575,23,1237,-27),(2576,23,1238,-28),(2577,23,1239,-29),(2578,23,1240,-30),(2579,23,1241,-31),(2580,23,1242,-32),(2581,23,1243,-33),(2582,23,1244,-34),(2583,23,1245,-35),(2584,23,1246,-36),(2585,23,1247,-37),(2586,23,1248,-38),(2587,23,1249,-39),(2588,23,1250,-40),(2589,23,1251,-41),(2590,23,1252,-42),(2591,23,1253,-43),(2592,8,1253,-150),(2593,35,1253,-85),(2594,2,1253,-536),(2595,23,1254,-44),(2596,8,1254,-151),(2597,35,1254,-86),(2598,2,1254,-537),(2599,23,1255,-45),(2600,8,1255,-152),(2601,35,1255,-87),(2602,2,1255,-538),(2603,23,1256,-46),(2604,8,1256,-153),(2605,35,1256,-88),(2606,2,1256,-539),(2607,23,1257,-47),(2608,8,1257,-154),(2609,35,1257,-89),(2610,2,1257,-540),(2611,23,1258,-48),(2612,8,1258,-155),(2613,35,1258,-90),(2614,2,1258,-541),(2615,23,1259,-49),(2616,8,1259,-156),(2617,35,1259,-91),(2618,2,1259,-542),(2619,23,1260,-50),(2620,8,1260,-157),(2621,35,1260,-92),(2622,2,1260,-543),(2623,23,1261,-51),(2624,8,1261,-158),(2625,35,1261,-93),(2626,2,1261,-544),(2627,23,1262,-52),(2628,8,1262,-159),(2629,35,1262,-94),(2630,2,1262,-545),(2631,23,1263,-53),(2632,8,1263,-160),(2633,35,1263,-95),(2634,2,1263,-546),(2635,23,1264,-54),(2636,8,1264,-161),(2637,35,1264,-96),(2638,2,1264,-547),(2639,23,1265,-55),(2640,8,1265,-162),(2641,35,1265,-97),(2642,2,1265,-548),(2643,23,1266,-56),(2644,8,1266,-163),(2645,35,1266,-98),(2646,2,1266,-549),(2647,23,1267,-57),(2648,8,1267,-164),(2649,35,1267,-99),(2650,2,1267,-550),(2651,23,1268,-58),(2652,8,1268,-165),(2653,35,1268,-100),(2654,2,1268,-551),(2655,23,1269,-59),(2656,23,1270,-60),(2657,23,1271,-61),(2658,23,1272,-62),(2659,23,1273,-63),(2660,23,1274,-64),(2661,23,1275,-65),(2662,23,1276,-66),(2663,23,1277,-67),(2664,23,1278,-68),(2665,23,1279,-69),(2666,23,1280,-70),(2667,23,1281,-71),(2668,23,1282,-72),(2669,23,1283,-73),(2670,23,1284,-74),(2671,23,1285,-75),(2672,23,1286,-76),(2673,23,1287,-77),(2674,23,1288,-78),(2675,23,1289,-79),(2676,23,1290,-80),(2677,23,1291,-81),(2678,23,1292,-82),(2679,23,1293,-83),(2680,23,1294,-84),(2681,23,1295,-85),(2682,23,1296,-86),(2683,23,1297,-87),(2684,23,1298,-88),(2685,23,1299,-89),(2686,23,1300,-90),(2687,23,1301,-91),(2688,30,1301,-49),(2689,34,1301,-124),(2690,2,1301,-552),(2691,23,1302,-92),(2692,30,1302,-50),(2693,34,1302,-125),(2694,2,1302,-553),(2695,23,1303,-93),(2696,30,1303,-51),(2697,34,1303,-126),(2698,2,1303,-554),(2699,23,1304,-94),(2700,30,1304,-52),(2701,34,1304,-127),(2702,2,1304,-555),(2703,23,1305,-95),(2704,30,1305,-53),(2705,34,1305,-128),(2706,2,1305,-556),(2707,23,1306,-96),(2708,30,1306,-54),(2709,34,1306,-129),(2710,2,1306,-557),(2711,23,1307,-97),(2712,30,1307,-55),(2713,34,1307,-130),(2714,2,1307,-558),(2715,23,1308,-98),(2716,30,1308,-56),(2717,34,1308,-131),(2718,2,1308,-559),(2719,23,1309,-99),(2720,30,1309,-57),(2721,34,1309,-132),(2722,2,1309,-560),(2723,23,1310,-100),(2724,30,1310,-58),(2725,34,1310,-133),(2726,2,1310,-561),(2727,23,1311,-101),(2728,30,1311,-59),(2729,34,1311,-134),(2730,2,1311,-562),(2731,23,1312,-102),(2732,30,1312,-60),(2733,34,1312,-135),(2734,2,1312,-563),(2735,23,1313,-103),(2736,30,1313,-61),(2737,34,1313,-136),(2738,2,1313,-564),(2739,23,1314,-104),(2740,30,1314,-62),(2741,34,1314,-137),(2742,2,1314,-565),(2743,23,1315,-105),(2744,30,1315,-63),(2745,34,1315,-138),(2746,2,1315,-566),(2747,23,1316,-106),(2748,30,1316,-64),(2749,34,1316,-139),(2750,2,1316,-567),(2751,23,1317,-107),(2752,34,1317,-140),(2753,2,1317,-568),(2754,23,1318,-108),(2755,34,1318,-141),(2756,2,1318,-569),(2757,23,1319,-109),(2758,34,1319,-142),(2759,2,1319,-570),(2760,23,1320,-110),(2761,34,1320,-143),(2762,2,1320,-571),(2763,23,1321,-111),(2764,34,1321,-144),(2765,2,1321,-572),(2766,23,1322,-112),(2767,34,1322,-145),(2768,2,1322,-573),(2769,23,1323,-113),(2770,34,1323,-146),(2771,2,1323,-574),(2772,23,1324,-114),(2773,34,1324,-147),(2774,2,1324,-575),(2775,23,1325,-115),(2776,34,1325,-148),(2777,2,1325,-576),(2778,23,1326,-116),(2779,34,1326,-149),(2780,2,1326,-577),(2781,23,1327,-117),(2782,34,1327,-150),(2783,2,1327,-578),(2784,23,1328,-118),(2785,34,1328,-151),(2786,2,1328,-579),(2787,23,1329,-119),(2788,34,1329,-152),(2789,2,1329,-580),(2790,23,1330,-120),(2791,34,1330,-153),(2792,2,1330,-581),(2793,23,1331,-121),(2794,34,1331,-154),(2795,2,1331,-582),(2796,23,1332,-122),(2797,34,1332,-155),(2798,2,1332,-583),(2799,23,1333,-123),(2800,8,1333,-166),(2801,35,1333,-101),(2802,2,1333,-584),(2803,23,1334,-124),(2804,8,1334,-167),(2805,35,1334,-102),(2806,2,1334,-585),(2807,23,1335,-125),(2808,8,1335,-168),(2809,35,1335,-103),(2810,2,1335,-586),(2811,23,1336,-126),(2812,8,1336,-169),(2813,35,1336,-104),(2814,2,1336,-587),(2815,23,1337,-127),(2816,8,1337,-170),(2817,35,1337,-105),(2818,2,1337,-588),(2819,23,1338,-128),(2820,8,1338,-171),(2821,35,1338,-106),(2822,2,1338,-589),(2823,23,1339,-129),(2824,8,1339,-172),(2825,35,1339,-107),(2826,2,1339,-590),(2827,23,1340,-130),(2828,8,1340,-173),(2829,35,1340,-108),(2830,2,1340,-591),(2831,23,1341,-131),(2832,8,1341,-174),(2833,35,1341,-109),(2834,2,1341,-592),(2835,23,1342,-132),(2836,8,1342,-175),(2837,35,1342,-110),(2838,2,1342,-593),(2839,23,1343,-133),(2840,8,1343,-176),(2841,35,1343,-111),(2842,2,1343,-594),(2843,23,1344,-134),(2844,8,1344,-177),(2845,35,1344,-112),(2846,2,1344,-595),(2847,23,1345,-135),(2848,8,1345,-178),(2849,35,1345,-113),(2850,2,1345,-596),(2851,23,1346,-136),(2852,8,1346,-179),(2853,35,1346,-114),(2854,2,1346,-597),(2855,23,1347,-137),(2856,8,1347,-180),(2857,35,1347,-115),(2858,2,1347,-598),(2859,23,1348,-138),(2860,8,1348,-181),(2861,35,1348,-116),(2862,2,1348,-599),(2863,23,1349,-139),(2864,8,1349,-182),(2865,2,1349,-600),(2866,23,1350,-140),(2867,8,1350,-183),(2868,2,1350,-601),(2869,23,1351,-141),(2870,8,1351,-184),(2871,2,1351,-602),(2872,23,1352,-142),(2873,8,1352,-185),(2874,2,1352,-603),(2875,23,1353,-143),(2876,8,1353,-186),(2877,2,1353,-604),(2878,23,1354,-144),(2879,8,1354,-187),(2880,2,1354,-605),(2881,23,1355,-145),(2882,8,1355,-188),(2883,2,1355,-606),(2884,23,1356,-146),(2885,8,1356,-189),(2886,2,1356,-607),(2887,23,1357,-147),(2888,8,1357,-190),(2889,2,1357,-608),(2890,23,1358,-148),(2891,8,1358,-191),(2892,2,1358,-609),(2893,23,1359,-149),(2894,8,1359,-192),(2895,2,1359,-610),(2896,23,1360,-150),(2897,8,1360,-193),(2898,2,1360,-611),(2899,23,1361,-151),(2900,8,1361,-194),(2901,2,1361,-612),(2902,23,1362,-152),(2903,8,1362,-195),(2904,2,1362,-613),(2905,23,1363,-153),(2906,8,1363,-196),(2907,2,1363,-614),(2908,23,1364,-154),(2909,8,1364,-197),(2910,2,1364,-615),(2911,23,1365,-155),(2912,30,1365,-65),(2913,35,1365,-117),(2914,2,1365,-616),(2915,23,1366,-156),(2916,30,1366,-66),(2917,35,1366,-118),(2918,2,1366,-617),(2919,23,1367,-157),(2920,30,1367,-67),(2921,35,1367,-119),(2922,2,1367,-618),(2923,23,1368,-158),(2924,30,1368,-68),(2925,35,1368,-120),(2926,2,1368,-619),(2927,23,1369,-159),(2928,30,1369,-69),(2929,35,1369,-121),(2930,2,1369,-620),(2931,23,1370,-160),(2932,30,1370,-70),(2933,35,1370,-122),(2934,2,1370,-621),(2935,23,1371,-161),(2936,30,1371,-71),(2937,35,1371,-123),(2938,2,1371,-622),(2939,23,1372,-162),(2940,30,1372,-72),(2941,35,1372,-124),(2942,2,1372,-623),(2943,23,1373,-163),(2944,30,1373,-73),(2945,35,1373,-125),(2946,2,1373,-624),(2947,23,1374,-164),(2948,30,1374,-74),(2949,35,1374,-126),(2950,2,1374,-625),(2951,23,1375,-165),(2952,30,1375,-75),(2953,35,1375,-127),(2954,2,1375,-626),(2955,23,1376,-166),(2956,30,1376,-76),(2957,35,1376,-128),(2958,2,1376,-627),(2959,23,1377,-167),(2960,30,1377,-77),(2961,35,1377,-129),(2962,2,1377,-628),(2963,23,1378,-168),(2964,30,1378,-78),(2965,35,1378,-130),(2966,2,1378,-629),(2967,23,1379,-169),(2968,30,1379,-79),(2969,35,1379,-131),(2970,2,1379,-630),(2971,23,1380,-170),(2972,30,1380,-80),(2973,35,1380,-132),(2974,2,1380,-631),(2975,23,1381,-171),(2976,30,1381,-81),(2977,35,1381,-133),(2978,2,1381,-632),(2979,23,1382,-172),(2980,30,1382,-82),(2981,35,1382,-134),(2982,2,1382,-633),(2983,23,1383,-173),(2984,30,1383,-83),(2985,35,1383,-135),(2986,2,1383,-634),(2987,23,1384,-174),(2988,30,1384,-84),(2989,35,1384,-136),(2990,2,1384,-635),(2991,23,1385,-175),(2992,30,1385,-85),(2993,35,1385,-137),(2994,2,1385,-636),(2995,23,1386,-176),(2996,30,1386,-86),(2997,35,1386,-138),(2998,2,1386,-637),(2999,23,1387,-177),(3000,30,1387,-87),(3001,35,1387,-139),(3002,2,1387,-638),(3003,23,1388,-178),(3004,30,1388,-88),(3005,35,1388,-140),(3006,2,1388,-639),(3007,23,1389,-179),(3008,30,1389,-89),(3009,35,1389,-141),(3010,2,1389,-640),(3011,23,1390,-180),(3012,30,1390,-90),(3013,35,1390,-142),(3014,2,1390,-641),(3015,23,1391,-181),(3016,30,1391,-91),(3017,35,1391,-143),(3018,2,1391,-642),(3019,23,1392,-182),(3020,30,1392,-92),(3021,35,1392,-144),(3022,2,1392,-643),(3023,23,1393,-183),(3024,30,1393,-93),(3025,35,1393,-145),(3026,2,1393,-644),(3027,23,1394,-184),(3028,30,1394,-94),(3029,35,1394,-146),(3030,2,1394,-645),(3031,23,1395,-185),(3032,30,1395,-95),(3033,35,1395,-147),(3034,2,1395,-646),(3035,23,1396,-186),(3036,30,1396,-96),(3037,35,1396,-148),(3038,2,1396,-647),(3039,25,1397,-1),(3040,33,1397,-1),(3041,8,1397,-198),(3042,2,1397,-648),(3043,25,1398,-2),(3044,33,1398,-2),(3045,8,1398,-199),(3046,2,1398,-649),(3047,25,1399,-3),(3048,33,1399,-3),(3049,8,1399,-200),(3050,2,1399,-650),(3051,25,1400,-4),(3052,33,1400,-4),(3053,8,1400,-201),(3054,2,1400,-651),(3055,25,1401,-5),(3056,33,1401,-5),(3057,8,1401,-202),(3058,2,1401,-652),(3059,25,1402,-6),(3060,33,1402,-6),(3061,8,1402,-203),(3062,2,1402,-653),(3063,25,1403,-7),(3064,33,1403,-7),(3065,8,1403,-204),(3066,2,1403,-654),(3067,25,1404,-8),(3068,33,1404,-8),(3069,8,1404,-205),(3070,2,1404,-655),(3071,25,1405,-9),(3072,33,1405,-9),(3073,8,1405,-206),(3074,2,1405,-656),(3075,25,1406,-10),(3076,33,1406,-10),(3077,8,1406,-207),(3078,2,1406,-657),(3079,25,1407,-11),(3080,33,1407,-11),(3081,8,1407,-208),(3082,2,1407,-658),(3083,25,1408,-12),(3084,33,1408,-12),(3085,8,1408,-209),(3086,2,1408,-659),(3087,25,1409,-13),(3088,33,1409,-13),(3089,8,1409,-210),(3090,2,1409,-660),(3091,25,1410,-14),(3092,33,1410,-14),(3093,8,1410,-211),(3094,2,1410,-661),(3095,25,1411,-15),(3096,33,1411,-15),(3097,8,1411,-212),(3098,2,1411,-662),(3099,25,1412,-16),(3100,33,1412,-16),(3101,8,1412,-213),(3102,2,1412,-663),(3103,25,1413,-17),(3104,33,1413,-17),(3105,35,1413,-149),(3106,2,1413,-664),(3107,25,1414,-18),(3108,33,1414,-18),(3109,35,1414,-150),(3110,2,1414,-665),(3111,25,1415,-19),(3112,33,1415,-19),(3113,35,1415,-151),(3114,2,1415,-666),(3115,25,1416,-20),(3116,33,1416,-20),(3117,35,1416,-152),(3118,2,1416,-667),(3119,25,1417,-21),(3120,33,1417,-21),(3121,35,1417,-153),(3122,2,1417,-668),(3123,25,1418,-22),(3124,33,1418,-22),(3125,35,1418,-154),(3126,2,1418,-669),(3127,25,1419,-23),(3128,33,1419,-23),(3129,35,1419,-155),(3130,2,1419,-670),(3131,25,1420,-24),(3132,33,1420,-24),(3133,35,1420,-156),(3134,2,1420,-671),(3135,25,1421,-25),(3136,33,1421,-25),(3137,35,1421,-157),(3138,2,1421,-672),(3139,25,1422,-26),(3140,33,1422,-26),(3141,35,1422,-158),(3142,2,1422,-673),(3143,25,1423,-27),(3144,33,1423,-27),(3145,35,1423,-159),(3146,2,1423,-674),(3147,25,1424,-28),(3148,33,1424,-28),(3149,35,1424,-160),(3150,2,1424,-675),(3151,25,1425,-29),(3152,33,1425,-29),(3153,35,1425,-161),(3154,2,1425,-676),(3155,25,1426,-30),(3156,33,1426,-30),(3157,35,1426,-162),(3158,2,1426,-677),(3159,25,1427,-31),(3160,33,1427,-31),(3161,35,1427,-163),(3162,2,1427,-678),(3163,25,1428,-32),(3164,33,1428,-32),(3165,35,1428,-164),(3166,2,1428,-679),(3167,25,1429,-33),(3168,33,1429,-33),(3169,8,1429,-214),(3170,36,1429,-138),(3171,2,1429,-680),(3172,25,1430,-34),(3173,33,1430,-34),(3174,8,1430,-215),(3175,36,1430,-139),(3176,2,1430,-681),(3177,25,1431,-35),(3178,33,1431,-35),(3179,8,1431,-216),(3180,36,1431,-140),(3181,2,1431,-682),(3182,25,1432,-36),(3183,33,1432,-36),(3184,8,1432,-217),(3185,36,1432,-141),(3186,2,1432,-683),(3187,25,1433,-37),(3188,33,1433,-37),(3189,8,1433,-218),(3190,36,1433,-142),(3191,2,1433,-684),(3192,25,1434,-38),(3193,33,1434,-38),(3194,8,1434,-219),(3195,36,1434,-143),(3196,2,1434,-685),(3197,25,1435,-39),(3198,33,1435,-39),(3199,8,1435,-220),(3200,36,1435,-144),(3201,2,1435,-686),(3202,25,1436,-40),(3203,33,1436,-40),(3204,8,1436,-221),(3205,36,1436,-145),(3206,2,1436,-687),(3207,25,1437,-41),(3208,33,1437,-41),(3209,8,1437,-222),(3210,36,1437,-146),(3211,2,1437,-688),(3212,25,1438,-42),(3213,33,1438,-42),(3214,8,1438,-223),(3215,36,1438,-147),(3216,2,1438,-689),(3217,25,1439,-43),(3218,33,1439,-43),(3219,8,1439,-224),(3220,36,1439,-148),(3221,2,1439,-690),(3222,25,1440,-44),(3223,33,1440,-44),(3224,8,1440,-225),(3225,36,1440,-149),(3226,2,1440,-691),(3227,25,1441,-45),(3228,33,1441,-45),(3229,8,1441,-226),(3230,36,1441,-150),(3231,2,1441,-692),(3232,25,1442,-46),(3233,33,1442,-46),(3234,8,1442,-227),(3235,36,1442,-151),(3236,2,1442,-693),(3237,25,1443,-47),(3238,33,1443,-47),(3239,8,1443,-228),(3240,36,1443,-152),(3241,2,1443,-694),(3242,25,1444,-48),(3243,33,1444,-48),(3244,8,1444,-229),(3245,36,1444,-153),(3246,2,1444,-695),(3247,25,1445,-49),(3248,33,1445,-49),(3249,8,1445,-230),(3250,36,1445,-154),(3251,2,1445,-696),(3252,25,1446,-50),(3253,33,1446,-50),(3254,8,1446,-231),(3255,36,1446,-155),(3256,2,1446,-697),(3257,25,1447,-51),(3258,33,1447,-51),(3259,8,1447,-232),(3260,36,1447,-156),(3261,2,1447,-698),(3262,25,1448,-52),(3263,33,1448,-52),(3264,8,1448,-233),(3265,36,1448,-157),(3266,2,1448,-699),(3267,25,1449,-53),(3268,33,1449,-53),(3269,8,1449,-234),(3270,36,1449,-158),(3271,2,1449,-700),(3272,25,1450,-54),(3273,33,1450,-54),(3274,8,1450,-235),(3275,36,1450,-159),(3276,2,1450,-701),(3277,25,1451,-55),(3278,33,1451,-55),(3279,8,1451,-236),(3280,36,1451,-160),(3281,2,1451,-702),(3282,25,1452,-56),(3283,33,1452,-56),(3284,8,1452,-237),(3285,36,1452,-161),(3286,2,1452,-703),(3287,25,1453,-57),(3288,33,1453,-57),(3289,8,1453,-238),(3290,36,1453,-162),(3291,2,1453,-704),(3292,25,1454,-58),(3293,33,1454,-58),(3294,8,1454,-239),(3295,36,1454,-163),(3296,2,1454,-705),(3297,25,1455,-59),(3298,33,1455,-59),(3299,8,1455,-240),(3300,36,1455,-164),(3301,2,1455,-706),(3302,25,1456,-60),(3303,33,1456,-60),(3304,8,1456,-241),(3305,36,1456,-165),(3306,2,1456,-707),(3307,25,1457,-61),(3308,33,1457,-61),(3309,8,1457,-242),(3310,36,1457,-166),(3311,2,1457,-708),(3312,25,1458,-62),(3313,33,1458,-62),(3314,8,1458,-243),(3315,36,1458,-167),(3316,2,1458,-709),(3317,25,1459,-63),(3318,33,1459,-63),(3319,8,1459,-244),(3320,36,1459,-168),(3321,2,1459,-710),(3322,25,1460,-64),(3323,33,1460,-64),(3324,8,1460,-245),(3325,36,1460,-169),(3326,2,1460,-711),(3327,25,1461,-65),(3328,33,1461,-65),(3329,8,1461,-246),(3330,34,1461,-156),(3331,2,1461,-712),(3332,25,1462,-66),(3333,33,1462,-66),(3334,8,1462,-247),(3335,34,1462,-157),(3336,2,1462,-713),(3337,25,1463,-67),(3338,33,1463,-67),(3339,8,1463,-248),(3340,34,1463,-158),(3341,2,1463,-714),(3342,25,1464,-68),(3343,33,1464,-68),(3344,8,1464,-249),(3345,34,1464,-159),(3346,2,1464,-715),(3347,25,1465,-69),(3348,33,1465,-69),(3349,8,1465,-250),(3350,34,1465,-160),(3351,2,1465,-716),(3352,25,1466,-70),(3353,33,1466,-70),(3354,8,1466,-251),(3355,34,1466,-161),(3356,2,1466,-717),(3357,25,1467,-71),(3358,33,1467,-71),(3359,8,1467,-252),(3360,34,1467,-162),(3361,2,1467,-718),(3362,25,1468,-72),(3363,33,1468,-72),(3364,8,1468,-253),(3365,34,1468,-163),(3366,2,1468,-719),(3367,25,1469,-73),(3368,33,1469,-73),(3369,8,1469,-254),(3370,34,1469,-164),(3371,2,1469,-720),(3372,25,1470,-74),(3373,33,1470,-74),(3374,8,1470,-255),(3375,34,1470,-165),(3376,2,1470,-721),(3377,25,1471,-75),(3378,33,1471,-75),(3379,8,1471,-256),(3380,34,1471,-166),(3381,2,1471,-722),(3382,25,1472,-76),(3383,33,1472,-76),(3384,8,1472,-257),(3385,34,1472,-167),(3386,2,1472,-723),(3387,25,1473,-77),(3388,33,1473,-77),(3389,8,1473,-258),(3390,34,1473,-168),(3391,2,1473,-724),(3392,25,1474,-78),(3393,33,1474,-78),(3394,8,1474,-259),(3395,34,1474,-169),(3396,2,1474,-725),(3397,25,1475,-79),(3398,33,1475,-79),(3399,8,1475,-260),(3400,34,1475,-170),(3401,2,1475,-726),(3402,25,1476,-80),(3403,33,1476,-80),(3404,8,1476,-261),(3405,34,1476,-171),(3406,2,1476,-727),(3407,25,1477,-81),(3408,33,1477,-81),(3409,30,1477,-97),(3410,2,1477,-728),(3411,25,1478,-82),(3412,33,1478,-82),(3413,30,1478,-98),(3414,2,1478,-729),(3415,25,1479,-83),(3416,33,1479,-83),(3417,30,1479,-99),(3418,2,1479,-730),(3419,25,1480,-84),(3420,33,1480,-84),(3421,30,1480,-100),(3422,2,1480,-731),(3423,25,1481,-85),(3424,33,1481,-85),(3425,30,1481,-101),(3426,2,1481,-732),(3427,25,1482,-86),(3428,33,1482,-86),(3429,30,1482,-102),(3430,2,1482,-733),(3431,25,1483,-87),(3432,33,1483,-87),(3433,30,1483,-103),(3434,2,1483,-734),(3435,25,1484,-88),(3436,33,1484,-88),(3437,30,1484,-104),(3438,2,1484,-735),(3439,25,1485,-89),(3440,33,1485,-89),(3441,30,1485,-105),(3442,2,1485,-736),(3443,25,1486,-90),(3444,33,1486,-90),(3445,30,1486,-106),(3446,2,1486,-737),(3447,25,1487,-91),(3448,33,1487,-91),(3449,30,1487,-107),(3450,2,1487,-738),(3451,25,1488,-92),(3452,33,1488,-92),(3453,30,1488,-108),(3454,2,1488,-739),(3455,25,1489,-93),(3456,33,1489,-93),(3457,30,1489,-109),(3458,2,1489,-740),(3459,25,1490,-94),(3460,33,1490,-94),(3461,30,1490,-110),(3462,2,1490,-741),(3463,25,1491,-95),(3464,33,1491,-95),(3465,30,1491,-111),(3466,2,1491,-742),(3467,25,1492,-96),(3468,33,1492,-96),(3469,30,1492,-112),(3470,2,1492,-743),(3471,25,1493,-97),(3472,33,1493,-97),(3473,30,1493,-113),(3474,36,1493,-170),(3475,2,1493,-744),(3476,25,1494,-98),(3477,33,1494,-98),(3478,30,1494,-114),(3479,36,1494,-171),(3480,2,1494,-745),(3481,25,1495,-99),(3482,33,1495,-99),(3483,30,1495,-115),(3484,36,1495,-172),(3485,2,1495,-746),(3486,25,1496,-100),(3487,33,1496,-100),(3488,30,1496,-116),(3489,36,1496,-173),(3490,2,1496,-747),(3491,25,1497,-101),(3492,33,1497,-101),(3493,30,1497,-117),(3494,36,1497,-174),(3495,2,1497,-748),(3496,25,1498,-102),(3497,33,1498,-102),(3498,30,1498,-118),(3499,36,1498,-175),(3500,2,1498,-749),(3501,25,1499,-103),(3502,33,1499,-103),(3503,30,1499,-119),(3504,36,1499,-176),(3505,2,1499,-750),(3506,25,1500,-104),(3507,33,1500,-104),(3508,30,1500,-120),(3509,36,1500,-177),(3510,2,1500,-751),(3511,25,1501,-105),(3512,33,1501,-105),(3513,30,1501,-121),(3514,36,1501,-178),(3515,2,1501,-752),(3516,25,1502,-106),(3517,33,1502,-106),(3518,30,1502,-122),(3519,36,1502,-179),(3520,2,1502,-753),(3521,25,1503,-107),(3522,33,1503,-107),(3523,30,1503,-123),(3524,36,1503,-180),(3525,2,1503,-754),(3526,25,1504,-108),(3527,33,1504,-108),(3528,30,1504,-124),(3529,36,1504,-181),(3530,2,1504,-755),(3531,25,1505,-109),(3532,33,1505,-109),(3533,30,1505,-125),(3534,36,1505,-182),(3535,2,1505,-756),(3536,25,1506,-110),(3537,33,1506,-110),(3538,30,1506,-126),(3539,36,1506,-183),(3540,2,1506,-757),(3541,25,1507,-111),(3542,33,1507,-111),(3543,30,1507,-127),(3544,36,1507,-184),(3545,2,1507,-758),(3546,25,1508,-112),(3547,33,1508,-112),(3548,30,1508,-128),(3549,36,1508,-185),(3550,2,1508,-759),(3551,25,1509,-113),(3552,33,1509,-113),(3553,35,1509,-165),(3554,2,1509,-760),(3555,25,1510,-114),(3556,33,1510,-114),(3557,35,1510,-166),(3558,2,1510,-761),(3559,25,1511,-115),(3560,33,1511,-115),(3561,35,1511,-167),(3562,2,1511,-762),(3563,25,1512,-116),(3564,33,1512,-116),(3565,35,1512,-168),(3566,2,1512,-763),(3567,25,1513,-117),(3568,33,1513,-117),(3569,35,1513,-169),(3570,2,1513,-764),(3571,25,1514,-118),(3572,33,1514,-118),(3573,35,1514,-170),(3574,2,1514,-765),(3575,25,1515,-119),(3576,33,1515,-119),(3577,35,1515,-171),(3578,2,1515,-766),(3579,25,1516,-120),(3580,33,1516,-120),(3581,35,1516,-172),(3582,2,1516,-767),(3583,25,1517,-121),(3584,33,1517,-121),(3585,35,1517,-173),(3586,2,1517,-768),(3587,25,1518,-122),(3588,33,1518,-122),(3589,35,1518,-174),(3590,2,1518,-769),(3591,25,1519,-123),(3592,33,1519,-123),(3593,35,1519,-175),(3594,2,1519,-770),(3595,25,1520,-124),(3596,33,1520,-124),(3597,35,1520,-176),(3598,2,1520,-771),(3599,25,1521,-125),(3600,33,1521,-125),(3601,35,1521,-177),(3602,2,1521,-772),(3603,25,1522,-126),(3604,33,1522,-126),(3605,35,1522,-178),(3606,2,1522,-773),(3607,25,1523,-127),(3608,33,1523,-127),(3609,35,1523,-179),(3610,2,1523,-774),(3611,25,1524,-128),(3612,33,1524,-128),(3613,35,1524,-180),(3614,2,1524,-775),(3615,25,1525,-129),(3616,33,1525,-129),(3617,30,1525,-129),(3618,34,1525,-172),(3619,2,1525,-776),(3620,25,1526,-130),(3621,33,1526,-130),(3622,30,1526,-130),(3623,34,1526,-173),(3624,2,1526,-777),(3625,25,1527,-131),(3626,33,1527,-131),(3627,30,1527,-131),(3628,34,1527,-174),(3629,2,1527,-778),(3630,25,1528,-132),(3631,33,1528,-132),(3632,30,1528,-132),(3633,34,1528,-175),(3634,2,1528,-779),(3635,25,1529,-133),(3636,33,1529,-133),(3637,30,1529,-133),(3638,34,1529,-176),(3639,2,1529,-780),(3640,25,1530,-134),(3641,33,1530,-134),(3642,30,1530,-134),(3643,34,1530,-177),(3644,2,1530,-781),(3645,25,1531,-135),(3646,33,1531,-135),(3647,30,1531,-135),(3648,34,1531,-178),(3649,2,1531,-782),(3650,25,1532,-136),(3651,33,1532,-136),(3652,30,1532,-136),(3653,34,1532,-179),(3654,2,1532,-783),(3655,25,1533,-137),(3656,33,1533,-137),(3657,30,1533,-137),(3658,34,1533,-180),(3659,2,1533,-784),(3660,25,1534,-138),(3661,33,1534,-138),(3662,30,1534,-138),(3663,34,1534,-181),(3664,2,1534,-785),(3665,25,1535,-139),(3666,33,1535,-139),(3667,30,1535,-139),(3668,34,1535,-182),(3669,2,1535,-786),(3670,25,1536,-140),(3671,33,1536,-140),(3672,30,1536,-140),(3673,34,1536,-183),(3674,2,1536,-787),(3675,25,1537,-141),(3676,33,1537,-141),(3677,30,1537,-141),(3678,34,1537,-184),(3679,2,1537,-788),(3680,25,1538,-142),(3681,33,1538,-142),(3682,30,1538,-142),(3683,34,1538,-185),(3684,2,1538,-789),(3685,25,1539,-143),(3686,33,1539,-143),(3687,30,1539,-143),(3688,34,1539,-186),(3689,2,1539,-790),(3690,25,1540,-144),(3691,33,1540,-144),(3692,30,1540,-144),(3693,34,1540,-187),(3694,2,1540,-791),(3695,25,1541,-145),(3696,33,1541,-145),(3697,35,1541,-181),(3698,2,1541,-792),(3699,25,1542,-146),(3700,33,1542,-146),(3701,35,1542,-182),(3702,2,1542,-793),(3703,25,1543,-147),(3704,33,1543,-147),(3705,35,1543,-183),(3706,2,1543,-794),(3707,25,1544,-148),(3708,33,1544,-148),(3709,35,1544,-184),(3710,2,1544,-795),(3711,25,1545,-149),(3712,33,1545,-149),(3713,35,1545,-185),(3714,2,1545,-796),(3715,25,1546,-150),(3716,33,1546,-150),(3717,35,1546,-186),(3718,2,1546,-797),(3719,25,1547,-151),(3720,33,1547,-151),(3721,35,1547,-187),(3722,2,1547,-798),(3723,25,1548,-152),(3724,33,1548,-152),(3725,35,1548,-188),(3726,2,1548,-799),(3727,25,1549,-153),(3728,33,1549,-153),(3729,35,1549,-189),(3730,2,1549,-800),(3731,25,1550,-154),(3732,33,1550,-154),(3733,35,1550,-190),(3734,2,1550,-801),(3735,25,1551,-155),(3736,33,1551,-155),(3737,35,1551,-191),(3738,2,1551,-802),(3739,25,1552,-156),(3740,33,1552,-156),(3741,35,1552,-192),(3742,2,1552,-803),(3743,25,1553,-157),(3744,33,1553,-157),(3745,35,1553,-193),(3746,2,1553,-804),(3747,25,1554,-158),(3748,33,1554,-158),(3749,35,1554,-194),(3750,2,1554,-805),(3751,25,1555,-159),(3752,33,1555,-159),(3753,35,1555,-195),(3754,2,1555,-806),(3755,25,1556,-160),(3756,33,1556,-160),(3757,35,1556,-196),(3758,2,1556,-807),(3759,25,1557,-161),(3760,33,1557,-161),(3761,2,1557,-808),(3762,25,1558,-162),(3763,33,1558,-162),(3764,2,1558,-809),(3765,25,1559,-163),(3766,33,1559,-163),(3767,2,1559,-810),(3768,25,1560,-164),(3769,33,1560,-164),(3770,2,1560,-811),(3771,25,1561,-165),(3772,33,1561,-165),(3773,2,1561,-812),(3774,25,1562,-166),(3775,33,1562,-166),(3776,2,1562,-813),(3777,25,1563,-167),(3778,33,1563,-167),(3779,2,1563,-814),(3780,25,1564,-168),(3781,33,1564,-168),(3782,2,1564,-815),(3783,25,1565,-169),(3784,33,1565,-169),(3785,2,1565,-816),(3786,25,1566,-170),(3787,33,1566,-170),(3788,2,1566,-817),(3789,25,1567,-171),(3790,33,1567,-171),(3791,2,1567,-818),(3792,25,1568,-172),(3793,33,1568,-172),(3794,2,1568,-819),(3795,25,1569,-173),(3796,33,1569,-173),(3797,2,1569,-820),(3798,25,1570,-174),(3799,33,1570,-174),(3800,2,1570,-821),(3801,25,1571,-175),(3802,33,1571,-175),(3803,2,1571,-822),(3804,25,1572,-176),(3805,33,1572,-176),(3806,2,1572,-823),(3807,25,1573,-177),(3808,33,1573,-177),(3809,2,1573,-824),(3810,25,1574,-178),(3811,33,1574,-178),(3812,2,1574,-825),(3813,25,1575,-179),(3814,33,1575,-179),(3815,2,1575,-826),(3816,25,1576,-180),(3817,33,1576,-180),(3818,2,1576,-827),(3819,25,1577,-181),(3820,33,1577,-181),(3821,2,1577,-828),(3822,25,1578,-182),(3823,33,1578,-182),(3824,2,1578,-829),(3825,25,1579,-183),(3826,33,1579,-183),(3827,2,1579,-830),(3828,25,1580,-184),(3829,33,1580,-184),(3830,2,1580,-831),(3831,25,1581,-185),(3832,33,1581,-185),(3833,2,1581,-832),(3834,25,1582,-186),(3835,33,1582,-186),(3836,2,1582,-833),(3837,25,1583,-187),(3838,33,1583,-187),(3839,2,1583,-834),(3840,25,1584,-188),(3841,33,1584,-188),(3842,2,1584,-835),(3843,25,1585,-189),(3844,33,1585,-189),(3845,2,1585,-836),(3846,25,1586,-190),(3847,33,1586,-190),(3848,2,1586,-837),(3849,25,1587,-191),(3850,33,1587,-191),(3851,2,1587,-838),(3852,25,1588,-192),(3853,33,1588,-192),(3854,2,1588,-839),(3855,26,1589,-1),(3856,30,1589,-145),(3857,36,1589,-186),(3858,2,1589,-840),(3859,26,1590,-2),(3860,30,1590,-146),(3861,36,1590,-187),(3862,2,1590,-841),(3863,26,1591,-3),(3864,30,1591,-147),(3865,36,1591,-188),(3866,2,1591,-842),(3867,26,1592,-4),(3868,30,1592,-148),(3869,36,1592,-189),(3870,2,1592,-843),(3871,26,1593,-5),(3872,30,1593,-149),(3873,36,1593,-190),(3874,2,1593,-844),(3875,26,1594,-6),(3876,30,1594,-150),(3877,36,1594,-191),(3878,2,1594,-845),(3879,26,1595,-7),(3880,30,1595,-151),(3881,36,1595,-192),(3882,2,1595,-846),(3883,26,1596,-8),(3884,30,1596,-152),(3885,36,1596,-193),(3886,2,1596,-847),(3887,26,1597,-9),(3888,30,1597,-153),(3889,36,1597,-194),(3890,2,1597,-848),(3891,26,1598,-10),(3892,30,1598,-154),(3893,36,1598,-195),(3894,2,1598,-849),(3895,26,1599,-11),(3896,30,1599,-155),(3897,36,1599,-196),(3898,2,1599,-850),(3899,26,1600,-12),(3900,30,1600,-156),(3901,36,1600,-197),(3902,2,1600,-851),(3903,26,1601,-13),(3904,30,1601,-157),(3905,36,1601,-198),(3906,2,1601,-852),(3907,26,1602,-14),(3908,30,1602,-158),(3909,36,1602,-199),(3910,2,1602,-853),(3911,26,1603,-15),(3912,30,1603,-159),(3913,36,1603,-200),(3914,2,1603,-854),(3915,26,1604,-16),(3916,30,1604,-160),(3917,36,1604,-201),(3918,2,1604,-855),(3919,26,1605,-17),(3920,26,1606,-18),(3921,26,1607,-19),(3922,26,1608,-20),(3923,26,1609,-21),(3924,26,1610,-22),(3925,26,1611,-23),(3926,26,1612,-24),(3927,26,1613,-25),(3928,26,1614,-26),(3929,26,1615,-27),(3930,26,1616,-28),(3931,26,1617,-29),(3932,26,1618,-30),(3933,26,1619,-31),(3934,26,1620,-32),(3935,26,1621,-33),(3936,8,1621,-262),(3937,35,1621,-197),(3938,2,1621,-856),(3939,26,1622,-34),(3940,8,1622,-263),(3941,35,1622,-198),(3942,2,1622,-857),(3943,26,1623,-35),(3944,8,1623,-264),(3945,35,1623,-199),(3946,2,1623,-858),(3947,26,1624,-36),(3948,8,1624,-265),(3949,35,1624,-200),(3950,2,1624,-859),(3951,26,1625,-37),(3952,8,1625,-266),(3953,35,1625,-201),(3954,2,1625,-860),(3955,26,1626,-38),(3956,8,1626,-267),(3957,35,1626,-202),(3958,2,1626,-861),(3959,26,1627,-39),(3960,8,1627,-268),(3961,35,1627,-203),(3962,2,1627,-862),(3963,26,1628,-40),(3964,8,1628,-269),(3965,35,1628,-204),(3966,2,1628,-863),(3967,26,1629,-41),(3968,8,1629,-270),(3969,35,1629,-205),(3970,2,1629,-864),(3971,26,1630,-42),(3972,8,1630,-271),(3973,35,1630,-206),(3974,2,1630,-865),(3975,26,1631,-43),(3976,8,1631,-272),(3977,35,1631,-207),(3978,2,1631,-866),(3979,26,1632,-44),(3980,8,1632,-273),(3981,35,1632,-208),(3982,2,1632,-867),(3983,26,1633,-45),(3984,8,1633,-274),(3985,35,1633,-209),(3986,2,1633,-868),(3987,26,1634,-46),(3988,8,1634,-275),(3989,35,1634,-210),(3990,2,1634,-869),(3991,26,1635,-47),(3992,8,1635,-276),(3993,35,1635,-211),(3994,2,1635,-870),(3995,26,1636,-48),(3996,8,1636,-277),(3997,35,1636,-212),(3998,2,1636,-871),(3999,26,1637,-49),(4000,26,1638,-50),(4001,26,1639,-51),(4002,26,1640,-52),(4003,26,1641,-53),(4004,26,1642,-54),(4005,26,1643,-55),(4006,26,1644,-56),(4007,26,1645,-57),(4008,26,1646,-58),(4009,26,1647,-59),(4010,26,1648,-60),(4011,26,1649,-61),(4012,26,1650,-62),(4013,26,1651,-63),(4014,26,1652,-64),(4015,26,1653,-65),(4016,26,1654,-66),(4017,26,1655,-67),(4018,26,1656,-68),(4019,26,1657,-69),(4020,26,1658,-70),(4021,26,1659,-71),(4022,26,1660,-72),(4023,26,1661,-73),(4024,26,1662,-74),(4025,26,1663,-75),(4026,26,1664,-76),(4027,26,1665,-77),(4028,26,1666,-78),(4029,26,1667,-79),(4030,26,1668,-80),(4031,26,1669,-81),(4032,36,1669,-202),(4033,2,1669,-872),(4034,26,1670,-82),(4035,36,1670,-203),(4036,2,1670,-873),(4037,26,1671,-83),(4038,36,1671,-204),(4039,2,1671,-874),(4040,26,1672,-84),(4041,36,1672,-205),(4042,2,1672,-875),(4043,26,1673,-85),(4044,36,1673,-206),(4045,2,1673,-876),(4046,26,1674,-86),(4047,36,1674,-207),(4048,2,1674,-877),(4049,26,1675,-87),(4050,36,1675,-208),(4051,2,1675,-878),(4052,26,1676,-88),(4053,36,1676,-209),(4054,2,1676,-879),(4055,26,1677,-89),(4056,36,1677,-210),(4057,2,1677,-880),(4058,26,1678,-90),(4059,36,1678,-211),(4060,2,1678,-881),(4061,26,1679,-91),(4062,36,1679,-212),(4063,2,1679,-882),(4064,26,1680,-92),(4065,36,1680,-213),(4066,2,1680,-883),(4067,26,1681,-93),(4068,36,1681,-214),(4069,2,1681,-884),(4070,26,1682,-94),(4071,36,1682,-215),(4072,2,1682,-885),(4073,26,1683,-95),(4074,36,1683,-216),(4075,2,1683,-886),(4076,26,1684,-96),(4077,36,1684,-217),(4078,2,1684,-887),(4079,26,1685,-97),(4080,26,1686,-98),(4081,26,1687,-99),(4082,26,1688,-100),(4083,26,1689,-101),(4084,26,1690,-102),(4085,26,1691,-103),(4086,26,1692,-104),(4087,26,1693,-105),(4088,26,1694,-106),(4089,26,1695,-107),(4090,26,1696,-108),(4091,26,1697,-109),(4092,26,1698,-110),(4093,26,1699,-111),(4094,26,1700,-112),(4095,26,1701,-113),(4096,8,1701,-278),(4097,34,1701,-188),(4098,2,1701,-888),(4099,26,1702,-114),(4100,8,1702,-279),(4101,34,1702,-189),(4102,2,1702,-889),(4103,26,1703,-115),(4104,8,1703,-280),(4105,34,1703,-190),(4106,2,1703,-890),(4107,26,1704,-116),(4108,8,1704,-281),(4109,34,1704,-191),(4110,2,1704,-891),(4111,26,1705,-117),(4112,8,1705,-282),(4113,34,1705,-192),(4114,2,1705,-892),(4115,26,1706,-118),(4116,8,1706,-283),(4117,34,1706,-193),(4118,2,1706,-893),(4119,26,1707,-119),(4120,8,1707,-284),(4121,34,1707,-194),(4122,2,1707,-894),(4123,26,1708,-120),(4124,8,1708,-285),(4125,34,1708,-195),(4126,2,1708,-895),(4127,26,1709,-121),(4128,8,1709,-286),(4129,34,1709,-196),(4130,2,1709,-896),(4131,26,1710,-122),(4132,8,1710,-287),(4133,34,1710,-197),(4134,2,1710,-897),(4135,26,1711,-123),(4136,8,1711,-288),(4137,34,1711,-198),(4138,2,1711,-898),(4139,26,1712,-124),(4140,8,1712,-289),(4141,34,1712,-199),(4142,2,1712,-899),(4143,26,1713,-125),(4144,8,1713,-290),(4145,34,1713,-200),(4146,2,1713,-900),(4147,26,1714,-126),(4148,8,1714,-291),(4149,34,1714,-201),(4150,2,1714,-901),(4151,26,1715,-127),(4152,8,1715,-292),(4153,34,1715,-202),(4154,2,1715,-902),(4155,26,1716,-128),(4156,8,1716,-293),(4157,34,1716,-203),(4158,2,1716,-903),(4159,26,1717,-129),(4160,35,1717,-213),(4161,2,1717,-904),(4162,26,1718,-130),(4163,35,1718,-214),(4164,2,1718,-905),(4165,26,1719,-131),(4166,35,1719,-215),(4167,2,1719,-906),(4168,26,1720,-132),(4169,35,1720,-216),(4170,2,1720,-907),(4171,26,1721,-133),(4172,35,1721,-217),(4173,2,1721,-908),(4174,26,1722,-134),(4175,35,1722,-218),(4176,2,1722,-909),(4177,26,1723,-135),(4178,35,1723,-219),(4179,2,1723,-910),(4180,26,1724,-136),(4181,35,1724,-220),(4182,2,1724,-911),(4183,26,1725,-137),(4184,35,1725,-221),(4185,2,1725,-912),(4186,26,1726,-138),(4187,35,1726,-222),(4188,2,1726,-913),(4189,26,1727,-139),(4190,35,1727,-223),(4191,2,1727,-914),(4192,26,1728,-140),(4193,35,1728,-224),(4194,2,1728,-915),(4195,26,1729,-141),(4196,35,1729,-225),(4197,2,1729,-916),(4198,26,1730,-142),(4199,35,1730,-226),(4200,2,1730,-917),(4201,26,1731,-143),(4202,35,1731,-227),(4203,2,1731,-918),(4204,26,1732,-144),(4205,35,1732,-228),(4206,2,1732,-919),(4207,26,1733,-145),(4208,34,1733,-204),(4209,2,1733,-920),(4210,26,1734,-146),(4211,34,1734,-205),(4212,2,1734,-921),(4213,26,1735,-147),(4214,34,1735,-206),(4215,2,1735,-922),(4216,26,1736,-148),(4217,34,1736,-207),(4218,2,1736,-923),(4219,26,1737,-149),(4220,34,1737,-208),(4221,2,1737,-924),(4222,26,1738,-150),(4223,34,1738,-209),(4224,2,1738,-925),(4225,26,1739,-151),(4226,34,1739,-210),(4227,2,1739,-926),(4228,26,1740,-152),(4229,34,1740,-211),(4230,2,1740,-927),(4231,26,1741,-153),(4232,34,1741,-212),(4233,2,1741,-928),(4234,26,1742,-154),(4235,34,1742,-213),(4236,2,1742,-929),(4237,26,1743,-155),(4238,34,1743,-214),(4239,2,1743,-930),(4240,26,1744,-156),(4241,34,1744,-215),(4242,2,1744,-931),(4243,26,1745,-157),(4244,34,1745,-216),(4245,2,1745,-932),(4246,26,1746,-158),(4247,34,1746,-217),(4248,2,1746,-933),(4249,26,1747,-159),(4250,34,1747,-218),(4251,2,1747,-934),(4252,26,1748,-160),(4253,34,1748,-219),(4254,2,1748,-935),(4255,26,1749,-161),(4256,26,1750,-162),(4257,26,1751,-163),(4258,26,1752,-164),(4259,26,1753,-165),(4260,26,1754,-166),(4261,26,1755,-167),(4262,26,1756,-168),(4263,26,1757,-169),(4264,26,1758,-170),(4265,26,1759,-171),(4266,26,1760,-172),(4267,26,1761,-173),(4268,26,1762,-174),(4269,26,1763,-175),(4270,26,1764,-176),(4271,26,1765,-177),(4272,35,1765,-229),(4273,2,1765,-936),(4274,26,1766,-178),(4275,35,1766,-230),(4276,2,1766,-937),(4277,26,1767,-179),(4278,35,1767,-231),(4279,2,1767,-938),(4280,26,1768,-180),(4281,35,1768,-232),(4282,2,1768,-939),(4283,26,1769,-181),(4284,35,1769,-233),(4285,2,1769,-940),(4286,26,1770,-182),(4287,35,1770,-234),(4288,2,1770,-941),(4289,26,1771,-183),(4290,35,1771,-235),(4291,2,1771,-942),(4292,26,1772,-184),(4293,35,1772,-236),(4294,2,1772,-943),(4295,26,1773,-185),(4296,35,1773,-237),(4297,2,1773,-944),(4298,26,1774,-186),(4299,35,1774,-238),(4300,2,1774,-945),(4301,26,1775,-187),(4302,35,1775,-239),(4303,2,1775,-946),(4304,26,1776,-188),(4305,35,1776,-240),(4306,2,1776,-947),(4307,26,1777,-189),(4308,35,1777,-241),(4309,2,1777,-948),(4310,26,1778,-190),(4311,35,1778,-242),(4312,2,1778,-949),(4313,26,1779,-191),(4314,35,1779,-243),(4315,2,1779,-950),(4316,26,1780,-192),(4317,35,1780,-244),(4318,2,1780,-951),(4319,26,1781,-193),(4320,30,1781,-161),(4321,35,1781,-245),(4322,2,1781,-952),(4323,26,1782,-194),(4324,30,1782,-162),(4325,35,1782,-246),(4326,2,1782,-953),(4327,26,1783,-195),(4328,30,1783,-163),(4329,35,1783,-247),(4330,2,1783,-954),(4331,26,1784,-196),(4332,30,1784,-164),(4333,35,1784,-248),(4334,2,1784,-955),(4335,26,1785,-197),(4336,30,1785,-165),(4337,35,1785,-249),(4338,2,1785,-956),(4339,26,1786,-198),(4340,30,1786,-166),(4341,35,1786,-250),(4342,2,1786,-957),(4343,26,1787,-199),(4344,30,1787,-167),(4345,35,1787,-251),(4346,2,1787,-958),(4347,26,1788,-200),(4348,30,1788,-168),(4349,35,1788,-252),(4350,2,1788,-959),(4351,26,1789,-201),(4352,30,1789,-169),(4353,35,1789,-253),(4354,2,1789,-960),(4355,26,1790,-202),(4356,30,1790,-170),(4357,35,1790,-254),(4358,2,1790,-961),(4359,26,1791,-203),(4360,30,1791,-171),(4361,35,1791,-255),(4362,2,1791,-962),(4363,26,1792,-204),(4364,30,1792,-172),(4365,35,1792,-256),(4366,2,1792,-963),(4367,26,1793,-205),(4368,30,1793,-173),(4369,35,1793,-257),(4370,2,1793,-964),(4371,26,1794,-206),(4372,30,1794,-174),(4373,35,1794,-258),(4374,2,1794,-965),(4375,26,1795,-207),(4376,30,1795,-175),(4377,35,1795,-259),(4378,2,1795,-966),(4379,26,1796,-208),(4380,30,1796,-176),(4381,35,1796,-260),(4382,2,1796,-967),(4383,26,1797,-209),(4384,30,1797,-177),(4385,34,1797,-220),(4386,2,1797,-968),(4387,26,1798,-210),(4388,30,1798,-178),(4389,34,1798,-221),(4390,2,1798,-969),(4391,26,1799,-211),(4392,30,1799,-179),(4393,34,1799,-222),(4394,2,1799,-970),(4395,26,1800,-212),(4396,30,1800,-180),(4397,34,1800,-223),(4398,2,1800,-971),(4399,26,1801,-213),(4400,30,1801,-181),(4401,34,1801,-224),(4402,2,1801,-972),(4403,26,1802,-214),(4404,30,1802,-182),(4405,34,1802,-225),(4406,2,1802,-973),(4407,26,1803,-215),(4408,30,1803,-183),(4409,34,1803,-226),(4410,2,1803,-974),(4411,26,1804,-216),(4412,30,1804,-184),(4413,34,1804,-227),(4414,2,1804,-975),(4415,26,1805,-217),(4416,30,1805,-185),(4417,34,1805,-228),(4418,2,1805,-976),(4419,26,1806,-218),(4420,30,1806,-186),(4421,34,1806,-229),(4422,2,1806,-977),(4423,26,1807,-219),(4424,30,1807,-187),(4425,34,1807,-230),(4426,2,1807,-978),(4427,26,1808,-220),(4428,30,1808,-188),(4429,34,1808,-231),(4430,2,1808,-979),(4431,26,1809,-221),(4432,30,1809,-189),(4433,34,1809,-232),(4434,2,1809,-980),(4435,26,1810,-222),(4436,30,1810,-190),(4437,34,1810,-233),(4438,2,1810,-981),(4439,26,1811,-223),(4440,30,1811,-191),(4441,34,1811,-234),(4442,2,1811,-982),(4443,26,1812,-224),(4444,30,1812,-192),(4445,34,1812,-235),(4446,2,1812,-983),(4447,27,1813,-1),(4448,32,1813,-157),(4449,35,1813,-261),(4450,2,1813,-984),(4451,27,1814,-2),(4452,32,1814,-158),(4453,35,1814,-262),(4454,2,1814,-985),(4455,27,1815,-3),(4456,32,1815,-159),(4457,35,1815,-263),(4458,2,1815,-986),(4459,27,1816,-4),(4460,32,1816,-160),(4461,35,1816,-264),(4462,2,1816,-987),(4463,27,1817,-5),(4464,32,1817,-161),(4465,35,1817,-265),(4466,2,1817,-988),(4467,27,1818,-6),(4468,32,1818,-162),(4469,35,1818,-266),(4470,2,1818,-989),(4471,27,1819,-7),(4472,32,1819,-163),(4473,35,1819,-267),(4474,2,1819,-990),(4475,27,1820,-8),(4476,32,1820,-164),(4477,35,1820,-268),(4478,2,1820,-991),(4479,27,1821,-9),(4480,32,1821,-165),(4481,35,1821,-269),(4482,2,1821,-992),(4483,27,1822,-10),(4484,32,1822,-166),(4485,35,1822,-270),(4486,2,1822,-993),(4487,27,1823,-11),(4488,32,1823,-167),(4489,35,1823,-271),(4490,2,1823,-994),(4491,27,1824,-12),(4492,32,1824,-168),(4493,35,1824,-272),(4494,2,1824,-995),(4495,27,1825,-13),(4496,32,1825,-169),(4497,35,1825,-273),(4498,2,1825,-996),(4499,27,1826,-14),(4500,32,1826,-170),(4501,35,1826,-274),(4502,2,1826,-997),(4503,27,1827,-15),(4504,32,1827,-171),(4505,8,1827,-294),(4506,2,1827,-998),(4507,27,1828,-16),(4508,32,1828,-172),(4509,8,1828,-295),(4510,2,1828,-999),(4511,27,1829,-17),(4512,32,1829,-173),(4513,8,1829,-296),(4514,2,1829,-1000),(4515,27,1830,-18),(4516,32,1830,-174),(4517,8,1830,-297),(4518,2,1830,-1001),(4519,27,1831,-19),(4520,32,1831,-175),(4521,8,1831,-298),(4522,2,1831,-1002),(4523,27,1832,-20),(4524,32,1832,-176),(4525,8,1832,-299),(4526,2,1832,-1003),(4527,27,1833,-21),(4528,32,1833,-177),(4529,8,1833,-300),(4530,2,1833,-1004),(4531,27,1834,-22),(4532,32,1834,-178),(4533,2,1834,-1005),(4534,27,1835,-23),(4535,32,1835,-179),(4536,2,1835,-1006),(4537,27,1836,-24),(4538,32,1836,-180),(4539,2,1836,-1007),(4540,27,1837,-25),(4541,32,1837,-181),(4542,2,1837,-1008),(4543,27,1838,-26),(4544,32,1838,-182),(4545,2,1838,-1009),(4546,27,1839,-27),(4547,32,1839,-183),(4548,2,1839,-1010),(4549,27,1840,-28),(4550,32,1840,-184),(4551,2,1840,-1011),(4552,27,1841,-29),(4553,32,1841,-185),(4554,34,1841,-236),(4555,2,1841,-1012),(4556,27,1842,-30),(4557,32,1842,-186),(4558,34,1842,-237),(4559,2,1842,-1013),(4560,27,1843,-31),(4561,32,1843,-187),(4562,34,1843,-238),(4563,2,1843,-1014),(4564,27,1844,-32),(4565,32,1844,-188),(4566,34,1844,-239),(4567,2,1844,-1015),(4568,27,1845,-33),(4569,32,1845,-189),(4570,34,1845,-240),(4571,2,1845,-1016),(4572,27,1846,-34),(4573,32,1846,-190),(4574,34,1846,-241),(4575,2,1846,-1017),(4576,27,1847,-35),(4577,32,1847,-191),(4578,34,1847,-242),(4579,2,1847,-1018),(4580,27,1848,-36),(4581,32,1848,-192),(4582,34,1848,-243),(4583,2,1848,-1019),(4584,27,1849,-37),(4585,32,1849,-193),(4586,34,1849,-244),(4587,2,1849,-1020),(4588,27,1850,-38),(4589,32,1850,-194),(4590,34,1850,-245),(4591,2,1850,-1021),(4592,27,1851,-39),(4593,32,1851,-195),(4594,34,1851,-246),(4595,2,1851,-1022),(4596,27,1852,-40),(4597,32,1852,-196),(4598,34,1852,-247),(4599,2,1852,-1023),(4600,27,1853,-41),(4601,32,1853,-197),(4602,34,1853,-248),(4603,2,1853,-1024),(4604,27,1854,-42),(4605,32,1854,-198),(4606,34,1854,-249),(4607,2,1854,-1025),(4608,27,1855,-43),(4609,32,1855,-199),(4610,35,1855,-275),(4611,2,1855,-1026),(4612,27,1856,-44),(4613,32,1856,-200),(4614,35,1856,-276),(4615,2,1856,-1027),(4616,27,1857,-45),(4617,32,1857,-201),(4618,35,1857,-277),(4619,2,1857,-1028),(4620,27,1858,-46),(4621,32,1858,-202),(4622,35,1858,-278),(4623,2,1858,-1029),(4624,27,1859,-47),(4625,32,1859,-203),(4626,35,1859,-279),(4627,2,1859,-1030),(4628,27,1860,-48),(4629,32,1860,-204),(4630,35,1860,-280),(4631,2,1860,-1031),(4632,27,1861,-49),(4633,32,1861,-205),(4634,35,1861,-281),(4635,2,1861,-1032),(4636,27,1862,-50),(4637,32,1862,-206),(4638,2,1862,-1033),(4639,27,1863,-51),(4640,32,1863,-207),(4641,2,1863,-1034),(4642,27,1864,-52),(4643,32,1864,-208),(4644,2,1864,-1035),(4645,27,1865,-53),(4646,32,1865,-209),(4647,2,1865,-1036),(4648,27,1866,-54),(4649,32,1866,-210),(4650,2,1866,-1037),(4651,27,1867,-55),(4652,32,1867,-211),(4653,2,1867,-1038),(4654,27,1868,-56),(4655,32,1868,-212),(4656,2,1868,-1039),(4657,27,1869,-57),(4658,32,1869,-213),(4659,2,1869,-1040),(4660,27,1870,-58),(4661,32,1870,-214),(4662,2,1870,-1041),(4663,27,1871,-59),(4664,32,1871,-215),(4665,2,1871,-1042),(4666,27,1872,-60),(4667,32,1872,-216),(4668,2,1872,-1043),(4669,27,1873,-61),(4670,32,1873,-217),(4671,2,1873,-1044),(4672,27,1874,-62),(4673,32,1874,-218),(4674,2,1874,-1045),(4675,27,1875,-63),(4676,32,1875,-219),(4677,2,1875,-1046),(4678,27,1876,-64),(4679,32,1876,-220),(4680,36,1876,-218),(4681,2,1876,-1047),(4682,27,1877,-65),(4683,32,1877,-221),(4684,36,1877,-219),(4685,2,1877,-1048),(4686,27,1878,-66),(4687,32,1878,-222),(4688,36,1878,-220),(4689,2,1878,-1049),(4690,27,1879,-67),(4691,32,1879,-223),(4692,36,1879,-221),(4693,2,1879,-1050),(4694,27,1880,-68),(4695,32,1880,-224),(4696,36,1880,-222),(4697,2,1880,-1051),(4698,27,1881,-69),(4699,32,1881,-225),(4700,36,1881,-223),(4701,2,1881,-1052),(4702,27,1882,-70),(4703,32,1882,-226),(4704,36,1882,-224),(4705,2,1882,-1053),(4706,27,1883,-71),(4707,32,1883,-227),(4708,2,1883,-1054),(4709,27,1884,-72),(4710,32,1884,-228),(4711,2,1884,-1055),(4712,27,1885,-73),(4713,32,1885,-229),(4714,2,1885,-1056),(4715,27,1886,-74),(4716,32,1886,-230),(4717,2,1886,-1057),(4718,27,1887,-75),(4719,32,1887,-231),(4720,2,1887,-1058),(4721,27,1888,-76),(4722,32,1888,-232),(4723,2,1888,-1059),(4724,27,1889,-77),(4725,32,1889,-233),(4726,2,1889,-1060),(4727,27,1890,-78),(4728,32,1890,-234),(4729,35,1890,-282),(4730,2,1890,-1061),(4731,27,1891,-79),(4732,32,1891,-235),(4733,35,1891,-283),(4734,2,1891,-1062),(4735,27,1892,-80),(4736,32,1892,-236),(4737,35,1892,-284),(4738,2,1892,-1063),(4739,27,1893,-81),(4740,32,1893,-237),(4741,35,1893,-285),(4742,2,1893,-1064),(4743,27,1894,-82),(4744,32,1894,-238),(4745,35,1894,-286),(4746,2,1894,-1065),(4747,27,1895,-83),(4748,32,1895,-239),(4749,35,1895,-287),(4750,2,1895,-1066),(4751,27,1896,-84),(4752,32,1896,-240),(4753,35,1896,-288),(4754,2,1896,-1067),(4755,27,1897,-85),(4756,32,1897,-241),(4757,34,1897,-250),(4758,2,1897,-1068),(4759,27,1898,-86),(4760,32,1898,-242),(4761,34,1898,-251),(4762,2,1898,-1069),(4763,27,1899,-87),(4764,32,1899,-243),(4765,34,1899,-252),(4766,2,1899,-1070),(4767,27,1900,-88),(4768,32,1900,-244),(4769,34,1900,-253),(4770,2,1900,-1071),(4771,27,1901,-89),(4772,32,1901,-245),(4773,34,1901,-254),(4774,2,1901,-1072),(4775,27,1902,-90),(4776,32,1902,-246),(4777,34,1902,-255),(4778,2,1902,-1073),(4779,27,1903,-91),(4780,32,1903,-247),(4781,34,1903,-256),(4782,2,1903,-1074),(4783,28,1904,-1),(4784,8,1904,-301),(4785,36,1904,-225),(4786,2,1904,-1075),(4787,28,1905,-2),(4788,8,1905,-302),(4789,36,1905,-226),(4790,2,1905,-1076),(4791,28,1906,-3),(4792,8,1906,-303),(4793,36,1906,-227),(4794,2,1906,-1077),(4795,28,1907,-4),(4796,8,1907,-304),(4797,36,1907,-228),(4798,2,1907,-1078),(4799,28,1908,-5),(4800,8,1908,-305),(4801,36,1908,-229),(4802,2,1908,-1079),(4803,28,1909,-6),(4804,8,1909,-306),(4805,36,1909,-230),(4806,2,1909,-1080),(4807,28,1910,-7),(4808,8,1910,-307),(4809,36,1910,-231),(4810,2,1910,-1081),(4811,28,1911,-8),(4812,8,1911,-308),(4813,36,1911,-232),(4814,2,1911,-1082),(4815,28,1912,-9),(4816,8,1912,-309),(4817,36,1912,-233),(4818,2,1912,-1083),(4819,28,1913,-10),(4820,8,1913,-310),(4821,36,1913,-234),(4822,2,1913,-1084),(4823,28,1914,-11),(4824,8,1914,-311),(4825,36,1914,-235),(4826,2,1914,-1085),(4827,28,1915,-12),(4828,8,1915,-312),(4829,36,1915,-236),(4830,2,1915,-1086),(4831,28,1916,-13),(4832,8,1916,-313),(4833,36,1916,-237),(4834,2,1916,-1087),(4835,28,1917,-14),(4836,8,1917,-314),(4837,36,1917,-238),(4838,2,1917,-1088),(4839,28,1918,-15),(4840,8,1918,-315),(4841,36,1918,-239),(4842,2,1918,-1089),(4843,28,1919,-16),(4844,8,1919,-316),(4845,36,1919,-240),(4846,2,1919,-1090),(4847,28,1920,-17),(4848,30,1920,-193),(4849,2,1920,-1091),(4850,28,1921,-18),(4851,30,1921,-194),(4852,2,1921,-1092),(4853,28,1922,-19),(4854,30,1922,-195),(4855,2,1922,-1093),(4856,28,1923,-20),(4857,30,1923,-196),(4858,2,1923,-1094),(4859,28,1924,-21),(4860,30,1924,-197),(4861,2,1924,-1095),(4862,28,1925,-22),(4863,30,1925,-198),(4864,2,1925,-1096),(4865,28,1926,-23),(4866,30,1926,-199),(4867,2,1926,-1097),(4868,28,1927,-24),(4869,30,1927,-200),(4870,2,1927,-1098),(4871,28,1928,-25),(4872,30,1928,-201),(4873,2,1928,-1099),(4874,28,1929,-26),(4875,30,1929,-202),(4876,2,1929,-1100),(4877,28,1930,-27),(4878,30,1930,-203),(4879,2,1930,-1101),(4880,28,1931,-28),(4881,30,1931,-204),(4882,2,1931,-1102),(4883,28,1932,-29),(4884,30,1932,-205),(4885,2,1932,-1103),(4886,28,1933,-30),(4887,30,1933,-206),(4888,2,1933,-1104),(4889,28,1934,-31),(4890,30,1934,-207),(4891,2,1934,-1105),(4892,28,1935,-32),(4893,30,1935,-208),(4894,2,1935,-1106),(4895,28,1936,-33),(4896,8,1936,-317),(4897,35,1936,-289),(4898,2,1936,-1107),(4899,28,1937,-34),(4900,8,1937,-318),(4901,35,1937,-290),(4902,2,1937,-1108),(4903,28,1938,-35),(4904,8,1938,-319),(4905,35,1938,-291),(4906,2,1938,-1109),(4907,28,1939,-36),(4908,8,1939,-320),(4909,35,1939,-292),(4910,2,1939,-1110),(4911,28,1940,-37),(4912,8,1940,-321),(4913,35,1940,-293),(4914,2,1940,-1111),(4915,28,1941,-38),(4916,8,1941,-322),(4917,35,1941,-294),(4918,2,1941,-1112),(4919,28,1942,-39),(4920,8,1942,-323),(4921,35,1942,-295),(4922,2,1942,-1113),(4923,28,1943,-40),(4924,8,1943,-324),(4925,35,1943,-296),(4926,2,1943,-1114),(4927,28,1944,-41),(4928,8,1944,-325),(4929,35,1944,-297),(4930,2,1944,-1115),(4931,28,1945,-42),(4932,8,1945,-326),(4933,35,1945,-298),(4934,2,1945,-1116),(4935,28,1946,-43),(4936,8,1946,-327),(4937,35,1946,-299),(4938,2,1946,-1117),(4939,28,1947,-44),(4940,8,1947,-328),(4941,35,1947,-300),(4942,2,1947,-1118),(4943,28,1948,-45),(4944,8,1948,-329),(4945,35,1948,-301),(4946,2,1948,-1119),(4947,28,1949,-46),(4948,8,1949,-330),(4949,35,1949,-302),(4950,2,1949,-1120),(4951,28,1950,-47),(4952,8,1950,-331),(4953,35,1950,-303),(4954,2,1950,-1121),(4955,28,1951,-48),(4956,8,1951,-332),(4957,35,1951,-304),(4958,2,1951,-1122),(4959,28,1952,-49),(4960,28,1953,-50),(4961,28,1954,-51),(4962,28,1955,-52),(4963,28,1956,-53),(4964,28,1957,-54),(4965,28,1958,-55),(4966,28,1959,-56),(4967,28,1960,-57),(4968,28,1961,-58),(4969,28,1962,-59),(4970,28,1963,-60),(4971,28,1964,-61),(4972,28,1965,-62),(4973,28,1966,-63),(4974,28,1967,-64),(4975,28,1968,-65),(4976,30,1968,-209),(4977,2,1968,-1123),(4978,28,1969,-66),(4979,30,1969,-210),(4980,2,1969,-1124),(4981,28,1970,-67),(4982,30,1970,-211),(4983,2,1970,-1125),(4984,28,1971,-68),(4985,30,1971,-212),(4986,2,1971,-1126),(4987,28,1972,-69),(4988,30,1972,-213),(4989,2,1972,-1127),(4990,28,1973,-70),(4991,30,1973,-214),(4992,2,1973,-1128),(4993,28,1974,-71),(4994,30,1974,-215),(4995,2,1974,-1129),(4996,28,1975,-72),(4997,30,1975,-216),(4998,2,1975,-1130),(4999,28,1976,-73),(5000,30,1976,-217),(5001,2,1976,-1131),(5002,28,1977,-74),(5003,30,1977,-218),(5004,2,1977,-1132),(5005,28,1978,-75),(5006,30,1978,-219),(5007,2,1978,-1133),(5008,28,1979,-76),(5009,30,1979,-220),(5010,2,1979,-1134),(5011,28,1980,-77),(5012,30,1980,-221),(5013,2,1980,-1135),(5014,28,1981,-78),(5015,30,1981,-222),(5016,2,1981,-1136),(5017,28,1982,-79),(5018,30,1982,-223),(5019,2,1982,-1137),(5020,28,1983,-80),(5021,30,1983,-224),(5022,2,1983,-1138),(5023,28,1984,-81),(5024,28,1985,-82),(5025,28,1986,-83),(5026,28,1987,-84),(5027,28,1988,-85),(5028,28,1989,-86),(5029,28,1990,-87),(5030,28,1991,-88),(5031,8,1991,-333),(5032,2,1991,-1139),(5033,28,1992,-89),(5034,8,1992,-334),(5035,2,1992,-1140),(5036,28,1993,-90),(5037,8,1993,-335),(5038,2,1993,-1141),(5039,28,1994,-91),(5040,8,1994,-336),(5041,2,1994,-1142),(5042,28,1995,-92),(5043,8,1995,-337),(5044,2,1995,-1143),(5045,28,1996,-93),(5046,8,1996,-338),(5047,2,1996,-1144),(5048,28,1997,-94),(5049,8,1997,-339),(5050,2,1997,-1145),(5051,28,1998,-95),(5052,35,1998,-305),(5053,2,1998,-1146),(5054,28,1999,-96),(5055,35,1999,-306),(5056,2,1999,-1147),(5057,28,2000,-97),(5058,35,2000,-307),(5059,2,2000,-1148),(5060,28,2001,-98),(5061,35,2001,-308),(5062,2,2001,-1149),(5063,28,2002,-99),(5064,35,2002,-309),(5065,2,2002,-1150),(5066,28,2003,-100),(5067,35,2003,-310),(5068,2,2003,-1151),(5069,28,2004,-101),(5070,28,2005,-102),(5071,28,2006,-103),(5072,28,2007,-104),(5073,28,2008,-105),(5074,28,2009,-106),(5075,28,2010,-107),(5076,28,2011,-108),(5077,36,2011,-241),(5078,2,2011,-1152),(5079,28,2012,-109),(5080,36,2012,-242),(5081,2,2012,-1153),(5082,28,2013,-110),(5083,36,2013,-243),(5084,2,2013,-1154),(5085,28,2014,-111),(5086,36,2014,-244),(5087,2,2014,-1155),(5088,28,2015,-112),(5089,36,2015,-245),(5090,2,2015,-1156),(5091,28,2016,-113),(5092,36,2016,-246),(5093,2,2016,-1157),(5094,28,2017,-114),(5095,36,2017,-247),(5096,2,2017,-1158),(5097,28,2018,-115),(5098,34,2018,-257),(5099,2,2018,-1159),(5100,28,2019,-116),(5101,34,2019,-258),(5102,2,2019,-1160),(5103,28,2020,-117),(5104,34,2020,-259),(5105,2,2020,-1161),(5106,28,2021,-118),(5107,34,2021,-260),(5108,2,2021,-1162),(5109,28,2022,-119),(5110,34,2022,-261),(5111,2,2022,-1163),(5112,28,2023,-120),(5113,34,2023,-262),(5114,2,2023,-1164),(5115,28,2024,-121),(5116,34,2024,-263),(5117,2,2024,-1165),(5118,28,2025,-122),(5119,34,2025,-264),(5120,2,2025,-1166),(5121,28,2026,-123),(5122,34,2026,-265),(5123,2,2026,-1167),(5124,28,2027,-124),(5125,34,2027,-266),(5126,2,2027,-1168),(5127,28,2028,-125),(5128,34,2028,-267),(5129,2,2028,-1169),(5130,28,2029,-126),(5131,34,2029,-268),(5132,2,2029,-1170),(5133,28,2030,-127),(5134,34,2030,-269),(5135,2,2030,-1171),(5136,28,2031,-128),(5137,34,2031,-270),(5138,2,2031,-1172),(5139,28,2032,-129),(5140,34,2032,-271),(5141,2,2032,-1173),(5142,28,2033,-130),(5143,34,2033,-272),(5144,2,2033,-1174),(5145,28,2034,-131),(5146,34,2034,-273),(5147,2,2034,-1175),(5148,28,2035,-132),(5149,34,2035,-274),(5150,2,2035,-1176),(5151,28,2036,-133),(5152,34,2036,-275),(5153,2,2036,-1177),(5154,28,2037,-134),(5155,34,2037,-276),(5156,2,2037,-1178),(5157,28,2038,-135),(5158,34,2038,-277),(5159,2,2038,-1179),(5160,28,2039,-136),(5161,34,2039,-278),(5162,2,2039,-1180),(5163,28,2040,-137),(5164,34,2040,-279),(5165,2,2040,-1181);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_cl`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_cl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_cl` (
  `version_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Version ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  PRIMARY KEY (`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='[[dbprefix]]catalog_category_product_cl';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_cl`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_cl` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_cl` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_cl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `[[DBPREFIX]]CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_BB4A590114301ED9D94C8239D3EF6DA8` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index_replica`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `[[DBPREFIX]]CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_BB4A590114301ED9D94C8239D3EF6DA8` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index_replica`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index_replica` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_replica` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index_store1`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index_store1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index_store1` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `[[DBPREFIX]]CAT_CTGR_PRD_IDX_STORE1_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_EAA97D781ECAB4B7D46CE05989FB5FCE` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Prmg Catalog Category Product Index Store1';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index_store1`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index_store1` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_store1` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_product_index_store1` VALUES (2,2040,-1181,1,1,4),(2,2024,-1165,1,1,4),(2,2017,-1158,1,1,4),(2,2003,-1151,1,1,4),(2,1997,-1145,1,1,4),(2,1983,-1138,1,1,4),(2,1951,-1122,1,1,4),(2,1935,-1106,1,1,4),(2,1919,-1090,1,1,4),(2,1903,-1074,1,1,4),(2,1896,-1067,1,1,4),(2,1889,-1060,1,1,4),(2,1882,-1053,1,1,4),(2,1875,-1046,1,1,4),(2,1868,-1039,1,1,4),(2,1861,-1032,1,1,4),(2,1854,-1025,1,1,4),(2,1847,-1018,1,1,4),(2,1840,-1011,1,1,4),(2,1833,-1004,1,1,4),(2,1826,-997,1,1,4),(2,1819,-990,1,1,4),(2,1812,-983,1,1,4),(2,1796,-967,1,1,4),(2,1780,-951,1,1,4),(2,1748,-935,1,1,4),(2,1732,-919,1,1,4),(2,1716,-903,1,1,4),(2,1684,-887,1,1,4),(2,1636,-871,1,1,4),(2,1604,-855,1,1,4),(2,1588,-839,1,1,4),(2,1572,-823,1,1,4),(2,1556,-807,1,1,4),(2,1540,-791,1,1,4),(2,1524,-775,1,1,4),(2,1508,-759,1,1,4),(2,1492,-743,1,1,4),(2,1476,-727,1,1,4),(2,1460,-711,1,1,4),(2,1444,-695,1,1,4),(2,1428,-679,1,1,4),(2,1412,-663,1,1,4),(2,1396,-647,1,1,4),(2,1380,-631,1,1,4),(2,1364,-615,1,1,4),(2,1348,-599,1,1,4),(2,1332,-583,1,1,4),(2,1316,-567,1,1,4),(2,1268,-551,1,1,4),(2,1236,-535,1,1,4),(2,1220,-519,1,1,4),(2,1210,-509,1,1,4),(2,1194,-493,1,1,4),(2,1178,-477,1,1,4),(2,1162,-461,1,1,4),(2,1146,-445,1,1,4),(2,1130,-429,1,1,4),(2,1060,-413,1,1,4),(2,1044,-397,1,1,4),(2,1028,-381,1,1,4),(2,1002,-368,1,1,4),(2,989,-355,1,1,4),(2,976,-342,1,1,4),(2,963,-329,1,1,4),(2,950,-316,1,1,4),(2,937,-303,1,1,4),(2,911,-290,1,1,4),(2,893,-277,1,1,4),(2,880,-264,1,1,4),(2,867,-251,1,1,4),(2,854,-238,1,1,4),(2,841,-225,1,1,4),(2,828,-212,1,1,4),(2,254,-208,1,1,4),(2,815,-199,1,1,4),(2,238,-192,1,1,4),(2,622,-192,1,1,4),(2,802,-186,1,1,4),(2,222,-176,1,1,4),(2,430,-176,1,1,4),(2,606,-176,1,1,4),(2,1764,-176,1,1,4),(2,789,-173,1,1,4),(2,206,-160,1,1,4),(2,414,-160,1,1,4),(2,590,-160,1,1,4),(2,776,-160,1,1,4),(2,763,-147,1,1,4),(2,190,-144,1,1,4),(2,398,-144,1,1,4),(2,574,-144,1,1,4),(2,1015,-135,1,1,4),(2,750,-134,1,1,4),(2,174,-128,1,1,4),(2,382,-128,1,1,4),(2,558,-128,1,1,4),(2,737,-121,1,1,4),(2,158,-112,1,1,4),(2,366,-112,1,1,4),(2,542,-112,1,1,4),(2,1700,-112,1,1,4),(2,718,-108,1,1,4),(2,2010,-107,1,1,4),(2,694,-102,1,1,4),(2,724,-102,1,1,4),(2,142,-96,1,1,4),(2,350,-96,1,1,4),(2,462,-96,1,1,4),(2,526,-96,1,1,4),(2,712,-90,1,1,4),(2,1300,-90,1,1,4),(2,1990,-87,1,1,4),(2,1114,-86,1,1,4),(2,706,-84,1,1,4),(2,126,-80,1,1,4),(2,334,-80,1,1,4),(2,510,-80,1,1,4),(2,1108,-80,1,1,4),(2,1668,-80,1,1,4),(2,700,-78,1,1,4),(2,1284,-74,1,1,4),(2,688,-66,1,1,4),(2,110,-64,1,1,4),(2,302,-64,1,1,4),(2,318,-64,1,1,4),(2,494,-64,1,1,4),(2,1092,-64,1,1,4),(2,1652,-64,1,1,4),(2,1967,-64,1,1,4),(2,682,-60,1,1,4),(2,676,-54,1,1,4),(2,94,-48,1,1,4),(2,478,-48,1,1,4),(2,670,-48,1,1,4),(2,1076,-48,1,1,4),(2,924,-44,1,1,4),(2,1252,-42,1,1,4),(2,78,-32,1,1,4),(2,286,-32,1,1,4),(2,654,-32,1,1,4),(2,1620,-32,1,1,4),(2,898,-18,1,1,4),(2,62,-16,1,1,4),(2,270,-16,1,1,4),(2,446,-16,1,1,4),(2,638,-16,1,1,4),(2,1,0,1,1,4),(2,2,0,1,1,4),(2,3,0,1,1,4),(2,4,0,1,1,4),(2,5,0,1,1,4),(2,6,0,1,1,4),(2,7,0,1,1,4),(2,8,0,1,1,4),(2,9,0,1,1,4),(2,10,0,1,1,4),(2,11,0,1,1,4),(2,12,0,1,1,4),(2,13,0,1,1,4),(2,14,0,1,1,4),(2,15,0,1,1,4),(2,16,0,1,1,4),(2,17,0,1,1,4),(2,18,0,1,1,4),(2,19,0,1,1,4),(2,20,0,1,1,4),(2,21,0,1,1,4),(2,22,0,1,1,4),(2,23,0,1,1,4),(2,36,0,1,1,4),(2,37,0,1,1,4),(2,38,0,1,1,4),(2,39,0,1,1,4),(2,40,0,1,1,4),(2,41,0,1,1,4),(2,42,0,1,1,4),(2,43,0,1,1,4),(2,44,0,1,1,4),(2,45,0,1,1,4),(2,46,0,1,1,4),(3,1,0,1,1,4),(3,2,0,1,1,4),(3,3,0,1,1,4),(3,4,0,1,1,4),(3,5,0,1,1,4),(3,6,0,1,1,4),(3,7,0,1,1,4),(3,8,0,1,1,4),(3,9,0,1,1,4),(3,10,0,1,1,4),(3,11,0,1,1,4),(3,12,0,1,1,4),(3,13,0,1,1,4),(3,14,0,1,1,4),(3,15,0,1,1,4),(3,16,0,1,1,4),(3,17,0,1,1,4),(3,18,0,1,1,4),(3,19,0,1,1,4),(3,20,0,1,1,4),(3,21,0,1,1,4),(3,22,0,1,1,4),(3,23,0,1,1,4),(3,36,0,1,1,4),(3,37,0,1,1,4),(3,38,0,1,1,4),(3,39,0,1,1,4),(3,40,0,1,1,4),(3,41,0,1,1,4),(3,42,0,1,1,4),(3,43,0,1,1,4),(3,44,0,1,1,4),(3,45,0,1,1,4),(3,46,0,1,1,4),(4,1,0,1,1,4),(4,2,0,1,1,4),(4,3,0,1,1,4),(4,4,0,1,1,4),(4,5,0,1,1,4),(4,6,0,1,1,4),(4,7,0,1,1,4),(4,8,0,1,1,4),(4,9,0,1,1,4),(4,10,0,1,1,4),(4,11,0,1,1,4),(4,12,0,1,1,4),(4,13,0,1,1,4),(4,14,0,1,1,4),(5,15,0,1,1,4),(5,16,0,1,1,4),(5,17,0,1,1,4),(5,18,0,1,1,4),(5,19,0,1,1,4),(5,20,0,1,1,4),(5,21,0,1,1,4),(5,22,0,1,1,4),(5,23,0,1,1,4),(5,45,0,1,1,4),(5,46,0,1,1,4),(6,36,0,1,1,4),(6,37,0,1,1,4),(6,38,0,1,1,4),(6,39,0,1,1,4),(6,40,0,1,1,4),(6,41,0,1,1,4),(6,42,0,1,1,4),(6,43,0,1,1,4),(6,44,0,1,1,4),(7,2,0,1,1,4),(7,4,0,1,1,4),(7,5,0,1,1,4),(7,10,0,1,1,4),(7,11,0,1,1,4),(7,13,0,1,1,4),(7,14,0,1,1,4),(7,16,0,1,1,4),(7,19,0,1,1,4),(7,38,0,1,1,4),(7,39,0,1,1,4),(7,40,0,1,1,4),(7,44,0,1,1,4),(8,1997,-339,1,1,4),(8,1951,-332,1,1,4),(8,1919,-316,1,1,4),(8,1833,-300,1,1,4),(8,1716,-293,1,1,4),(8,1636,-277,1,1,4),(8,1476,-261,1,1,4),(8,1460,-245,1,1,4),(8,1444,-229,1,1,4),(8,1412,-213,1,1,4),(8,1364,-197,1,1,4),(8,1348,-181,1,1,4),(8,1268,-165,1,1,4),(8,1220,-149,1,1,4),(8,1178,-139,1,1,4),(8,1130,-123,1,1,4),(8,1044,-107,1,1,4),(8,1002,-91,1,1,4),(8,950,-78,1,1,4),(8,841,-65,1,1,4),(8,828,-52,1,1,4),(8,815,-39,1,1,4),(8,789,-26,1,1,4),(8,763,-13,1,1,4),(8,4,0,1,1,4),(8,5,0,1,1,4),(8,13,0,1,1,4),(8,19,0,1,1,4),(8,38,0,1,1,4),(8,39,0,1,1,4),(8,40,0,1,1,4),(8,44,0,1,1,4),(12,254,9792,0,1,4),(12,238,9808,0,1,4),(12,622,9808,0,1,4),(12,222,9824,0,1,4),(12,430,9824,0,1,4),(12,606,9824,0,1,4),(12,206,9840,0,1,4),(12,414,9840,0,1,4),(12,590,9840,0,1,4),(12,190,9856,0,1,4),(12,398,9856,0,1,4),(12,574,9856,0,1,4),(12,174,9872,0,1,4),(12,382,9872,0,1,4),(12,558,9872,0,1,4),(12,158,9888,0,1,4),(12,366,9888,0,1,4),(12,542,9888,0,1,4),(12,724,9898,0,1,4),(12,142,9904,0,1,4),(12,350,9904,0,1,4),(12,526,9904,0,1,4),(12,718,9904,0,1,4),(12,712,9910,0,1,4),(12,706,9916,0,1,4),(12,126,9920,0,1,4),(12,334,9920,0,1,4),(12,510,9920,0,1,4),(12,700,9922,0,1,4),(12,694,9928,0,1,4),(12,688,9934,0,1,4),(12,110,9936,0,1,4),(12,318,9936,0,1,4),(12,494,9936,0,1,4),(12,682,9940,0,1,4),(12,676,9946,0,1,4),(12,94,9952,0,1,4),(12,302,9952,0,1,4),(12,478,9952,0,1,4),(12,670,9952,0,1,4),(12,78,9968,0,1,4),(12,286,9968,0,1,4),(12,462,9968,0,1,4),(12,654,9968,0,1,4),(12,62,9984,0,1,4),(12,270,9984,0,1,4),(12,446,9984,0,1,4),(12,638,9984,0,1,4),(13,880,9844,0,1,4),(13,1028,9852,0,1,4),(13,867,9857,0,1,4),(13,1015,9865,0,1,4),(13,854,9870,0,1,4),(13,1002,9878,0,1,4),(13,841,9883,0,1,4),(13,989,9891,0,1,4),(13,828,9896,0,1,4),(13,976,9904,0,1,4),(13,815,9909,0,1,4),(13,963,9917,0,1,4),(13,802,9922,0,1,4),(13,950,9930,0,1,4),(13,789,9935,0,1,4),(13,937,9943,0,1,4),(13,776,9948,0,1,4),(13,924,9956,0,1,4),(13,763,9961,0,1,4),(13,911,9969,0,1,4),(13,750,9974,0,1,4),(13,898,9982,0,1,4),(13,737,9987,0,1,4),(13,893,9987,0,1,4),(14,430,-176,1,1,4),(14,414,-160,1,1,4),(14,398,-144,1,1,4),(14,382,-128,1,1,4),(14,366,-112,1,1,4),(14,350,-96,1,1,4),(14,334,-80,1,1,4),(14,318,-64,1,1,4),(14,302,-48,1,1,4),(14,286,-32,1,1,4),(14,270,-16,1,1,4),(15,254,-208,1,1,4),(15,238,-192,1,1,4),(15,222,-176,1,1,4),(15,206,-160,1,1,4),(15,190,-144,1,1,4),(15,174,-128,1,1,4),(15,158,-112,1,1,4),(15,142,-96,1,1,4),(15,126,-80,1,1,4),(15,110,-64,1,1,4),(15,94,-48,1,1,4),(15,78,-32,1,1,4),(15,62,-16,1,1,4),(16,622,-192,1,1,4),(16,606,-176,1,1,4),(16,590,-160,1,1,4),(16,574,-144,1,1,4),(16,558,-128,1,1,4),(16,542,-112,1,1,4),(16,526,-96,1,1,4),(16,510,-80,1,1,4),(16,494,-64,1,1,4),(16,478,-48,1,1,4),(16,462,-32,1,1,4),(16,446,-16,1,1,4),(17,724,-102,1,1,4),(17,718,-96,1,1,4),(17,712,-90,1,1,4),(17,706,-84,1,1,4),(17,700,-78,1,1,4),(17,694,-72,1,1,4),(17,688,-66,1,1,4),(17,682,-60,1,1,4),(17,676,-54,1,1,4),(17,670,-48,1,1,4),(17,654,-32,1,1,4),(17,638,-16,1,1,4),(18,880,-156,1,1,4),(18,867,-143,1,1,4),(18,854,-130,1,1,4),(18,841,-117,1,1,4),(18,828,-104,1,1,4),(18,815,-91,1,1,4),(18,802,-78,1,1,4),(18,789,-65,1,1,4),(18,776,-52,1,1,4),(18,763,-39,1,1,4),(18,750,-26,1,1,4),(18,737,-13,1,1,4),(19,1028,-148,1,1,4),(19,1015,-135,1,1,4),(19,1002,-122,1,1,4),(19,989,-109,1,1,4),(19,976,-96,1,1,4),(19,963,-83,1,1,4),(19,950,-70,1,1,4),(19,937,-57,1,1,4),(19,924,-44,1,1,4),(19,911,-31,1,1,4),(19,898,-18,1,1,4),(19,893,-13,1,1,4),(21,1812,9776,0,1,4),(21,1796,9792,0,1,4),(21,1588,9808,0,1,4),(21,1780,9808,0,1,4),(21,1396,9814,0,1,4),(21,1210,9818,0,1,4),(21,1572,9824,0,1,4),(21,1764,9824,0,1,4),(21,1380,9830,0,1,4),(21,1194,9834,0,1,4),(21,1556,9840,0,1,4),(21,1748,9840,0,1,4),(21,1364,9846,0,1,4),(21,1178,9850,0,1,4),(21,1540,9856,0,1,4),(21,1732,9856,0,1,4),(21,1348,9862,0,1,4),(21,1162,9866,0,1,4),(21,1524,9872,0,1,4),(21,1716,9872,0,1,4),(21,1332,9878,0,1,4),(21,1146,9882,0,1,4),(21,1508,9888,0,1,4),(21,1700,9888,0,1,4),(21,1316,9894,0,1,4),(21,1130,9898,0,1,4),(21,1492,9904,0,1,4),(21,1684,9904,0,1,4),(21,1300,9910,0,1,4),(21,1114,9914,0,1,4),(21,1108,9920,0,1,4),(21,1476,9920,0,1,4),(21,1668,9920,0,1,4),(21,1284,9926,0,1,4),(21,1092,9936,0,1,4),(21,1460,9936,0,1,4),(21,1652,9936,0,1,4),(21,1268,9942,0,1,4),(21,1076,9952,0,1,4),(21,1444,9952,0,1,4),(21,1636,9952,0,1,4),(21,1252,9958,0,1,4),(21,1060,9968,0,1,4),(21,1428,9968,0,1,4),(21,1620,9968,0,1,4),(21,1236,9974,0,1,4),(21,1044,9984,0,1,4),(21,1412,9984,0,1,4),(21,1604,9984,0,1,4),(21,1220,9990,0,1,4),(22,2040,9863,0,1,4),(22,2024,9879,0,1,4),(22,2017,9886,0,1,4),(22,2010,9893,0,1,4),(22,2003,9900,0,1,4),(22,1997,9906,0,1,4),(22,1903,9909,0,1,4),(22,1990,9913,0,1,4),(22,1896,9916,0,1,4),(22,1983,9920,0,1,4),(22,1889,9923,0,1,4),(22,1882,9930,0,1,4),(22,1967,9936,0,1,4),(22,1875,9937,0,1,4),(22,1868,9944,0,1,4),(22,1861,9951,0,1,4),(22,1951,9952,0,1,4),(22,1854,9958,0,1,4),(22,1847,9965,0,1,4),(22,1935,9968,0,1,4),(22,1840,9972,0,1,4),(22,1833,9979,0,1,4),(22,1919,9984,0,1,4),(22,1826,9986,0,1,4),(22,1819,9993,0,1,4),(23,1396,-186,1,1,4),(23,1380,-170,1,1,4),(23,1364,-154,1,1,4),(23,1348,-138,1,1,4),(23,1332,-122,1,1,4),(23,1316,-106,1,1,4),(23,1300,-90,1,1,4),(23,1284,-74,1,1,4),(23,1268,-58,1,1,4),(23,1252,-42,1,1,4),(23,1236,-26,1,1,4),(23,1220,-10,1,1,4),(24,1210,-182,1,1,4),(24,1194,-166,1,1,4),(24,1178,-150,1,1,4),(24,1162,-134,1,1,4),(24,1146,-118,1,1,4),(24,1130,-102,1,1,4),(24,1114,-86,1,1,4),(24,1108,-80,1,1,4),(24,1092,-64,1,1,4),(24,1076,-48,1,1,4),(24,1060,-32,1,1,4),(24,1044,-16,1,1,4),(25,1588,-192,1,1,4),(25,1572,-176,1,1,4),(25,1556,-160,1,1,4),(25,1540,-144,1,1,4),(25,1524,-128,1,1,4),(25,1508,-112,1,1,4),(25,1492,-96,1,1,4),(25,1476,-80,1,1,4),(25,1460,-64,1,1,4),(25,1444,-48,1,1,4),(25,1428,-32,1,1,4),(25,1412,-16,1,1,4),(26,1812,-224,1,1,4),(26,1796,-208,1,1,4),(26,1780,-192,1,1,4),(26,1764,-176,1,1,4),(26,1748,-160,1,1,4),(26,1732,-144,1,1,4),(26,1716,-128,1,1,4),(26,1700,-112,1,1,4),(26,1684,-96,1,1,4),(26,1668,-80,1,1,4),(26,1652,-64,1,1,4),(26,1636,-48,1,1,4),(26,1620,-32,1,1,4),(26,1604,-16,1,1,4),(27,1903,-91,1,1,4),(27,1896,-84,1,1,4),(27,1889,-77,1,1,4),(27,1882,-70,1,1,4),(27,1875,-63,1,1,4),(27,1868,-56,1,1,4),(27,1861,-49,1,1,4),(27,1854,-42,1,1,4),(27,1847,-35,1,1,4),(27,1840,-28,1,1,4),(27,1833,-21,1,1,4),(27,1826,-14,1,1,4),(27,1819,-7,1,1,4),(28,2040,-137,1,1,4),(28,2024,-121,1,1,4),(28,2017,-114,1,1,4),(28,2010,-107,1,1,4),(28,2003,-100,1,1,4),(28,1997,-94,1,1,4),(28,1990,-87,1,1,4),(28,1983,-80,1,1,4),(28,1967,-64,1,1,4),(28,1951,-48,1,1,4),(28,1935,-32,1,1,4),(28,1919,-16,1,1,4),(30,1983,-224,1,1,4),(30,1935,-208,1,1,4),(30,1812,-192,1,1,4),(30,1796,-176,1,1,4),(30,1604,-160,1,1,4),(30,1540,-144,1,1,4),(30,1508,-128,1,1,4),(30,1492,-112,1,1,4),(30,1396,-96,1,1,4),(30,1380,-80,1,1,4),(30,1316,-64,1,1,4),(30,1236,-48,1,1,4),(30,1146,-32,1,1,4),(30,1060,-16,1,1,4),(31,1028,-39,1,1,4),(31,976,-26,1,1,4),(31,963,-13,1,1,4),(32,1903,-247,1,1,4),(32,1896,-240,1,1,4),(32,1889,-233,1,1,4),(32,1882,-226,1,1,4),(32,1875,-219,1,1,4),(32,1868,-212,1,1,4),(32,1861,-205,1,1,4),(32,1854,-198,1,1,4),(32,1847,-191,1,1,4),(32,1840,-184,1,1,4),(32,1833,-177,1,1,4),(32,1826,-170,1,1,4),(32,1819,-163,1,1,4),(32,880,-156,1,1,4),(32,867,-143,1,1,4),(32,854,-130,1,1,4),(32,841,-117,1,1,4),(32,828,-104,1,1,4),(32,815,-91,1,1,4),(32,802,-78,1,1,4),(32,789,-65,1,1,4),(32,776,-52,1,1,4),(32,763,-39,1,1,4),(32,750,-26,1,1,4),(32,737,-13,1,1,4),(33,1588,-192,1,1,4),(33,1572,-176,1,1,4),(33,1556,-160,1,1,4),(33,1540,-144,1,1,4),(33,1524,-128,1,1,4),(33,1508,-112,1,1,4),(33,1492,-96,1,1,4),(33,1476,-80,1,1,4),(33,1460,-64,1,1,4),(33,1444,-48,1,1,4),(33,1428,-32,1,1,4),(33,1412,-16,1,1,4),(34,2040,-279,1,1,4),(34,2024,-263,1,1,4),(34,1903,-256,1,1,4),(34,1854,-249,1,1,4),(34,1847,-242,1,1,4),(34,1812,-235,1,1,4),(34,1748,-219,1,1,4),(34,1716,-203,1,1,4),(34,1540,-187,1,1,4),(34,1476,-171,1,1,4),(34,1332,-155,1,1,4),(34,1316,-139,1,1,4),(34,1220,-123,1,1,4),(34,1194,-113,1,1,4),(34,1130,-97,1,1,4),(34,1044,-81,1,1,4),(34,963,-65,1,1,4),(34,893,-52,1,1,4),(34,867,-39,1,1,4),(34,854,-26,1,1,4),(34,841,-13,1,1,4),(35,2003,-310,1,1,4),(35,1951,-304,1,1,4),(35,1896,-288,1,1,4),(35,1861,-281,1,1,4),(35,1826,-274,1,1,4),(35,1819,-267,1,1,4),(35,1796,-260,1,1,4),(35,1780,-244,1,1,4),(35,1732,-228,1,1,4),(35,1636,-212,1,1,4),(35,1556,-196,1,1,4),(35,1524,-180,1,1,4),(35,1428,-164,1,1,4),(35,1396,-148,1,1,4),(35,1380,-132,1,1,4),(35,1348,-116,1,1,4),(35,1268,-100,1,1,4),(35,1210,-84,1,1,4),(35,1146,-68,1,1,4),(35,989,-52,1,1,4),(35,937,-39,1,1,4),(35,911,-26,1,1,4),(35,750,-13,1,1,4),(36,2017,-247,1,1,4),(36,1919,-240,1,1,4),(36,1882,-224,1,1,4),(36,1684,-217,1,1,4),(36,1604,-201,1,1,4),(36,1508,-185,1,1,4),(36,1460,-169,1,1,4),(36,1444,-153,1,1,4),(36,1162,-137,1,1,4),(36,802,-121,1,1,4),(36,718,-108,1,1,4),(36,694,-102,1,1,4),(36,462,-96,1,1,4),(36,398,-80,1,1,4),(36,302,-64,1,1,4),(36,110,-48,1,1,4),(36,94,-32,1,1,4),(36,62,-16,1,1,4);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_store1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index_store1_replica`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index_store1_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index_store1_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_6FBAC0A8825789D69AB86505B4914089` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_8F15547F72AF00C7861A223EC6C69052` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Prmg Catalog Category Product Index Store1 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index_store1_replica`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index_store1_replica` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_store1_replica` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_product_index_store1_replica` VALUES (2,2040,-1181,1,1,4),(2,2024,-1165,1,1,4),(2,2017,-1158,1,1,4),(2,2003,-1151,1,1,4),(2,1997,-1145,1,1,4),(2,1983,-1138,1,1,4),(2,1951,-1122,1,1,4),(2,1935,-1106,1,1,4),(2,1919,-1090,1,1,4),(2,1903,-1074,1,1,4),(2,1896,-1067,1,1,4),(2,1889,-1060,1,1,4),(2,1882,-1053,1,1,4),(2,1875,-1046,1,1,4),(2,1868,-1039,1,1,4),(2,1861,-1032,1,1,4),(2,1854,-1025,1,1,4),(2,1847,-1018,1,1,4),(2,1840,-1011,1,1,4),(2,1833,-1004,1,1,4),(2,1826,-997,1,1,4),(2,1819,-990,1,1,4),(2,1812,-983,1,1,4),(2,1796,-967,1,1,4),(2,1780,-951,1,1,4),(2,1748,-935,1,1,4),(2,1732,-919,1,1,4),(2,1716,-903,1,1,4),(2,1684,-887,1,1,4),(2,1636,-871,1,1,4),(2,1604,-855,1,1,4),(2,1588,-839,1,1,4),(2,1572,-823,1,1,4),(2,1556,-807,1,1,4),(2,1540,-791,1,1,4),(2,1524,-775,1,1,4),(2,1508,-759,1,1,4),(2,1492,-743,1,1,4),(2,1476,-727,1,1,4),(2,1460,-711,1,1,4),(2,1444,-695,1,1,4),(2,1428,-679,1,1,4),(2,1412,-663,1,1,4),(2,1396,-647,1,1,4),(2,1380,-631,1,1,4),(2,1364,-615,1,1,4),(2,1348,-599,1,1,4),(2,1332,-583,1,1,4),(2,1316,-567,1,1,4),(2,1268,-551,1,1,4),(2,1236,-535,1,1,4),(2,1220,-519,1,1,4),(2,1210,-509,1,1,4),(2,1194,-493,1,1,4),(2,1178,-477,1,1,4),(2,1162,-461,1,1,4),(2,1146,-445,1,1,4),(2,1130,-429,1,1,4),(2,1060,-413,1,1,4),(2,1044,-397,1,1,4),(2,1028,-381,1,1,4),(2,1002,-368,1,1,4),(2,989,-355,1,1,4),(2,976,-342,1,1,4),(2,963,-329,1,1,4),(2,950,-316,1,1,4),(2,937,-303,1,1,4),(2,911,-290,1,1,4),(2,893,-277,1,1,4),(2,880,-264,1,1,4),(2,867,-251,1,1,4),(2,854,-238,1,1,4),(2,841,-225,1,1,4),(2,828,-212,1,1,4),(2,254,-208,1,1,4),(2,815,-199,1,1,4),(2,238,-192,1,1,4),(2,622,-192,1,1,4),(2,802,-186,1,1,4),(2,222,-176,1,1,4),(2,430,-176,1,1,4),(2,606,-176,1,1,4),(2,1764,-176,1,1,4),(2,789,-173,1,1,4),(2,206,-160,1,1,4),(2,414,-160,1,1,4),(2,590,-160,1,1,4),(2,776,-160,1,1,4),(2,763,-147,1,1,4),(2,190,-144,1,1,4),(2,398,-144,1,1,4),(2,574,-144,1,1,4),(2,1015,-135,1,1,4),(2,750,-134,1,1,4),(2,174,-128,1,1,4),(2,382,-128,1,1,4),(2,558,-128,1,1,4),(2,737,-121,1,1,4),(2,158,-112,1,1,4),(2,366,-112,1,1,4),(2,542,-112,1,1,4),(2,1700,-112,1,1,4),(2,718,-108,1,1,4),(2,2010,-107,1,1,4),(2,694,-102,1,1,4),(2,724,-102,1,1,4),(2,142,-96,1,1,4),(2,350,-96,1,1,4),(2,462,-96,1,1,4),(2,526,-96,1,1,4),(2,712,-90,1,1,4),(2,1300,-90,1,1,4),(2,1990,-87,1,1,4),(2,1114,-86,1,1,4),(2,706,-84,1,1,4),(2,126,-80,1,1,4),(2,334,-80,1,1,4),(2,510,-80,1,1,4),(2,1108,-80,1,1,4),(2,1668,-80,1,1,4),(2,700,-78,1,1,4),(2,1284,-74,1,1,4),(2,688,-66,1,1,4),(2,110,-64,1,1,4),(2,302,-64,1,1,4),(2,318,-64,1,1,4),(2,494,-64,1,1,4),(2,1092,-64,1,1,4),(2,1652,-64,1,1,4),(2,1967,-64,1,1,4),(2,682,-60,1,1,4),(2,676,-54,1,1,4),(2,94,-48,1,1,4),(2,478,-48,1,1,4),(2,670,-48,1,1,4),(2,1076,-48,1,1,4),(2,924,-44,1,1,4),(2,1252,-42,1,1,4),(2,78,-32,1,1,4),(2,286,-32,1,1,4),(2,654,-32,1,1,4),(2,1620,-32,1,1,4),(2,898,-18,1,1,4),(2,62,-16,1,1,4),(2,270,-16,1,1,4),(2,446,-16,1,1,4),(2,638,-16,1,1,4),(2,1,0,1,1,4),(2,2,0,1,1,4),(2,3,0,1,1,4),(2,4,0,1,1,4),(2,5,0,1,1,4),(2,6,0,1,1,4),(2,7,0,1,1,4),(2,8,0,1,1,4),(2,9,0,1,1,4),(2,10,0,1,1,4),(2,11,0,1,1,4),(2,12,0,1,1,4),(2,13,0,1,1,4),(2,14,0,1,1,4),(2,15,0,1,1,4),(2,16,0,1,1,4),(2,17,0,1,1,4),(2,18,0,1,1,4),(2,19,0,1,1,4),(2,20,0,1,1,4),(2,21,0,1,1,4),(2,22,0,1,1,4),(2,23,0,1,1,4),(2,36,0,1,1,4),(2,37,0,1,1,4),(2,38,0,1,1,4),(2,39,0,1,1,4),(2,40,0,1,1,4),(2,41,0,1,1,4),(2,42,0,1,1,4),(2,43,0,1,1,4),(2,44,0,1,1,4),(2,45,0,1,1,4),(2,46,0,1,1,4),(3,1,0,1,1,4),(3,2,0,1,1,4),(3,3,0,1,1,4),(3,4,0,1,1,4),(3,5,0,1,1,4),(3,6,0,1,1,4),(3,7,0,1,1,4),(3,8,0,1,1,4),(3,9,0,1,1,4),(3,10,0,1,1,4),(3,11,0,1,1,4),(3,12,0,1,1,4),(3,13,0,1,1,4),(3,14,0,1,1,4),(3,15,0,1,1,4),(3,16,0,1,1,4),(3,17,0,1,1,4),(3,18,0,1,1,4),(3,19,0,1,1,4),(3,20,0,1,1,4),(3,21,0,1,1,4),(3,22,0,1,1,4),(3,23,0,1,1,4),(3,36,0,1,1,4),(3,37,0,1,1,4),(3,38,0,1,1,4),(3,39,0,1,1,4),(3,40,0,1,1,4),(3,41,0,1,1,4),(3,42,0,1,1,4),(3,43,0,1,1,4),(3,44,0,1,1,4),(3,45,0,1,1,4),(3,46,0,1,1,4),(4,1,0,1,1,4),(4,2,0,1,1,4),(4,3,0,1,1,4),(4,4,0,1,1,4),(4,5,0,1,1,4),(4,6,0,1,1,4),(4,7,0,1,1,4),(4,8,0,1,1,4),(4,9,0,1,1,4),(4,10,0,1,1,4),(4,11,0,1,1,4),(4,12,0,1,1,4),(4,13,0,1,1,4),(4,14,0,1,1,4),(5,15,0,1,1,4),(5,16,0,1,1,4),(5,17,0,1,1,4),(5,18,0,1,1,4),(5,19,0,1,1,4),(5,20,0,1,1,4),(5,21,0,1,1,4),(5,22,0,1,1,4),(5,23,0,1,1,4),(5,45,0,1,1,4),(5,46,0,1,1,4),(6,36,0,1,1,4),(6,37,0,1,1,4),(6,38,0,1,1,4),(6,39,0,1,1,4),(6,40,0,1,1,4),(6,41,0,1,1,4),(6,42,0,1,1,4),(6,43,0,1,1,4),(6,44,0,1,1,4),(7,2,0,1,1,4),(7,4,0,1,1,4),(7,5,0,1,1,4),(7,10,0,1,1,4),(7,11,0,1,1,4),(7,13,0,1,1,4),(7,14,0,1,1,4),(7,16,0,1,1,4),(7,19,0,1,1,4),(7,38,0,1,1,4),(7,39,0,1,1,4),(7,40,0,1,1,4),(7,44,0,1,1,4),(8,1997,-339,1,1,4),(8,1951,-332,1,1,4),(8,1919,-316,1,1,4),(8,1833,-300,1,1,4),(8,1716,-293,1,1,4),(8,1636,-277,1,1,4),(8,1476,-261,1,1,4),(8,1460,-245,1,1,4),(8,1444,-229,1,1,4),(8,1412,-213,1,1,4),(8,1364,-197,1,1,4),(8,1348,-181,1,1,4),(8,1268,-165,1,1,4),(8,1220,-149,1,1,4),(8,1178,-139,1,1,4),(8,1130,-123,1,1,4),(8,1044,-107,1,1,4),(8,1002,-91,1,1,4),(8,950,-78,1,1,4),(8,841,-65,1,1,4),(8,828,-52,1,1,4),(8,815,-39,1,1,4),(8,789,-26,1,1,4),(8,763,-13,1,1,4),(8,4,0,1,1,4),(8,5,0,1,1,4),(8,13,0,1,1,4),(8,19,0,1,1,4),(8,38,0,1,1,4),(8,39,0,1,1,4),(8,40,0,1,1,4),(8,44,0,1,1,4),(12,254,9792,0,1,4),(12,238,9808,0,1,4),(12,622,9808,0,1,4),(12,222,9824,0,1,4),(12,430,9824,0,1,4),(12,606,9824,0,1,4),(12,206,9840,0,1,4),(12,414,9840,0,1,4),(12,590,9840,0,1,4),(12,190,9856,0,1,4),(12,398,9856,0,1,4),(12,574,9856,0,1,4),(12,174,9872,0,1,4),(12,382,9872,0,1,4),(12,558,9872,0,1,4),(12,158,9888,0,1,4),(12,366,9888,0,1,4),(12,542,9888,0,1,4),(12,724,9898,0,1,4),(12,142,9904,0,1,4),(12,350,9904,0,1,4),(12,526,9904,0,1,4),(12,718,9904,0,1,4),(12,712,9910,0,1,4),(12,706,9916,0,1,4),(12,126,9920,0,1,4),(12,334,9920,0,1,4),(12,510,9920,0,1,4),(12,700,9922,0,1,4),(12,694,9928,0,1,4),(12,688,9934,0,1,4),(12,110,9936,0,1,4),(12,318,9936,0,1,4),(12,494,9936,0,1,4),(12,682,9940,0,1,4),(12,676,9946,0,1,4),(12,94,9952,0,1,4),(12,302,9952,0,1,4),(12,478,9952,0,1,4),(12,670,9952,0,1,4),(12,78,9968,0,1,4),(12,286,9968,0,1,4),(12,462,9968,0,1,4),(12,654,9968,0,1,4),(12,62,9984,0,1,4),(12,270,9984,0,1,4),(12,446,9984,0,1,4),(12,638,9984,0,1,4),(13,880,9844,0,1,4),(13,1028,9852,0,1,4),(13,867,9857,0,1,4),(13,1015,9865,0,1,4),(13,854,9870,0,1,4),(13,1002,9878,0,1,4),(13,841,9883,0,1,4),(13,989,9891,0,1,4),(13,828,9896,0,1,4),(13,976,9904,0,1,4),(13,815,9909,0,1,4),(13,963,9917,0,1,4),(13,802,9922,0,1,4),(13,950,9930,0,1,4),(13,789,9935,0,1,4),(13,937,9943,0,1,4),(13,776,9948,0,1,4),(13,924,9956,0,1,4),(13,763,9961,0,1,4),(13,911,9969,0,1,4),(13,750,9974,0,1,4),(13,898,9982,0,1,4),(13,737,9987,0,1,4),(13,893,9987,0,1,4),(14,430,-176,1,1,4),(14,414,-160,1,1,4),(14,398,-144,1,1,4),(14,382,-128,1,1,4),(14,366,-112,1,1,4),(14,350,-96,1,1,4),(14,334,-80,1,1,4),(14,318,-64,1,1,4),(14,302,-48,1,1,4),(14,286,-32,1,1,4),(14,270,-16,1,1,4),(15,254,-208,1,1,4),(15,238,-192,1,1,4),(15,222,-176,1,1,4),(15,206,-160,1,1,4),(15,190,-144,1,1,4),(15,174,-128,1,1,4),(15,158,-112,1,1,4),(15,142,-96,1,1,4),(15,126,-80,1,1,4),(15,110,-64,1,1,4),(15,94,-48,1,1,4),(15,78,-32,1,1,4),(15,62,-16,1,1,4),(16,622,-192,1,1,4),(16,606,-176,1,1,4),(16,590,-160,1,1,4),(16,574,-144,1,1,4),(16,558,-128,1,1,4),(16,542,-112,1,1,4),(16,526,-96,1,1,4),(16,510,-80,1,1,4),(16,494,-64,1,1,4),(16,478,-48,1,1,4),(16,462,-32,1,1,4),(16,446,-16,1,1,4),(17,724,-102,1,1,4),(17,718,-96,1,1,4),(17,712,-90,1,1,4),(17,706,-84,1,1,4),(17,700,-78,1,1,4),(17,694,-72,1,1,4),(17,688,-66,1,1,4),(17,682,-60,1,1,4),(17,676,-54,1,1,4),(17,670,-48,1,1,4),(17,654,-32,1,1,4),(17,638,-16,1,1,4),(18,880,-156,1,1,4),(18,867,-143,1,1,4),(18,854,-130,1,1,4),(18,841,-117,1,1,4),(18,828,-104,1,1,4),(18,815,-91,1,1,4),(18,802,-78,1,1,4),(18,789,-65,1,1,4),(18,776,-52,1,1,4),(18,763,-39,1,1,4),(18,750,-26,1,1,4),(18,737,-13,1,1,4),(19,1028,-148,1,1,4),(19,1015,-135,1,1,4),(19,1002,-122,1,1,4),(19,989,-109,1,1,4),(19,976,-96,1,1,4),(19,963,-83,1,1,4),(19,950,-70,1,1,4),(19,937,-57,1,1,4),(19,924,-44,1,1,4),(19,911,-31,1,1,4),(19,898,-18,1,1,4),(19,893,-13,1,1,4),(21,1812,9776,0,1,4),(21,1796,9792,0,1,4),(21,1588,9808,0,1,4),(21,1780,9808,0,1,4),(21,1396,9814,0,1,4),(21,1210,9818,0,1,4),(21,1572,9824,0,1,4),(21,1764,9824,0,1,4),(21,1380,9830,0,1,4),(21,1194,9834,0,1,4),(21,1556,9840,0,1,4),(21,1748,9840,0,1,4),(21,1364,9846,0,1,4),(21,1178,9850,0,1,4),(21,1540,9856,0,1,4),(21,1732,9856,0,1,4),(21,1348,9862,0,1,4),(21,1162,9866,0,1,4),(21,1524,9872,0,1,4),(21,1716,9872,0,1,4),(21,1332,9878,0,1,4),(21,1146,9882,0,1,4),(21,1508,9888,0,1,4),(21,1700,9888,0,1,4),(21,1316,9894,0,1,4),(21,1130,9898,0,1,4),(21,1492,9904,0,1,4),(21,1684,9904,0,1,4),(21,1300,9910,0,1,4),(21,1114,9914,0,1,4),(21,1108,9920,0,1,4),(21,1476,9920,0,1,4),(21,1668,9920,0,1,4),(21,1284,9926,0,1,4),(21,1092,9936,0,1,4),(21,1460,9936,0,1,4),(21,1652,9936,0,1,4),(21,1268,9942,0,1,4),(21,1076,9952,0,1,4),(21,1444,9952,0,1,4),(21,1636,9952,0,1,4),(21,1252,9958,0,1,4),(21,1060,9968,0,1,4),(21,1428,9968,0,1,4),(21,1620,9968,0,1,4),(21,1236,9974,0,1,4),(21,1044,9984,0,1,4),(21,1412,9984,0,1,4),(21,1604,9984,0,1,4),(21,1220,9990,0,1,4),(22,2040,9863,0,1,4),(22,2024,9879,0,1,4),(22,2017,9886,0,1,4),(22,2010,9893,0,1,4),(22,2003,9900,0,1,4),(22,1997,9906,0,1,4),(22,1903,9909,0,1,4),(22,1990,9913,0,1,4),(22,1896,9916,0,1,4),(22,1983,9920,0,1,4),(22,1889,9923,0,1,4),(22,1882,9930,0,1,4),(22,1967,9936,0,1,4),(22,1875,9937,0,1,4),(22,1868,9944,0,1,4),(22,1861,9951,0,1,4),(22,1951,9952,0,1,4),(22,1854,9958,0,1,4),(22,1847,9965,0,1,4),(22,1935,9968,0,1,4),(22,1840,9972,0,1,4),(22,1833,9979,0,1,4),(22,1919,9984,0,1,4),(22,1826,9986,0,1,4),(22,1819,9993,0,1,4),(23,1396,-186,1,1,4),(23,1380,-170,1,1,4),(23,1364,-154,1,1,4),(23,1348,-138,1,1,4),(23,1332,-122,1,1,4),(23,1316,-106,1,1,4),(23,1300,-90,1,1,4),(23,1284,-74,1,1,4),(23,1268,-58,1,1,4),(23,1252,-42,1,1,4),(23,1236,-26,1,1,4),(23,1220,-10,1,1,4),(24,1210,-182,1,1,4),(24,1194,-166,1,1,4),(24,1178,-150,1,1,4),(24,1162,-134,1,1,4),(24,1146,-118,1,1,4),(24,1130,-102,1,1,4),(24,1114,-86,1,1,4),(24,1108,-80,1,1,4),(24,1092,-64,1,1,4),(24,1076,-48,1,1,4),(24,1060,-32,1,1,4),(24,1044,-16,1,1,4),(25,1588,-192,1,1,4),(25,1572,-176,1,1,4),(25,1556,-160,1,1,4),(25,1540,-144,1,1,4),(25,1524,-128,1,1,4),(25,1508,-112,1,1,4),(25,1492,-96,1,1,4),(25,1476,-80,1,1,4),(25,1460,-64,1,1,4),(25,1444,-48,1,1,4),(25,1428,-32,1,1,4),(25,1412,-16,1,1,4),(26,1812,-224,1,1,4),(26,1796,-208,1,1,4),(26,1780,-192,1,1,4),(26,1764,-176,1,1,4),(26,1748,-160,1,1,4),(26,1732,-144,1,1,4),(26,1716,-128,1,1,4),(26,1700,-112,1,1,4),(26,1684,-96,1,1,4),(26,1668,-80,1,1,4),(26,1652,-64,1,1,4),(26,1636,-48,1,1,4),(26,1620,-32,1,1,4),(26,1604,-16,1,1,4),(27,1903,-91,1,1,4),(27,1896,-84,1,1,4),(27,1889,-77,1,1,4),(27,1882,-70,1,1,4),(27,1875,-63,1,1,4),(27,1868,-56,1,1,4),(27,1861,-49,1,1,4),(27,1854,-42,1,1,4),(27,1847,-35,1,1,4),(27,1840,-28,1,1,4),(27,1833,-21,1,1,4),(27,1826,-14,1,1,4),(27,1819,-7,1,1,4),(28,2040,-137,1,1,4),(28,2024,-121,1,1,4),(28,2017,-114,1,1,4),(28,2010,-107,1,1,4),(28,2003,-100,1,1,4),(28,1997,-94,1,1,4),(28,1990,-87,1,1,4),(28,1983,-80,1,1,4),(28,1967,-64,1,1,4),(28,1951,-48,1,1,4),(28,1935,-32,1,1,4),(28,1919,-16,1,1,4),(30,1983,-224,1,1,4),(30,1935,-208,1,1,4),(30,1812,-192,1,1,4),(30,1796,-176,1,1,4),(30,1604,-160,1,1,4),(30,1540,-144,1,1,4),(30,1508,-128,1,1,4),(30,1492,-112,1,1,4),(30,1396,-96,1,1,4),(30,1380,-80,1,1,4),(30,1316,-64,1,1,4),(30,1236,-48,1,1,4),(30,1146,-32,1,1,4),(30,1060,-16,1,1,4),(31,1028,-39,1,1,4),(31,976,-26,1,1,4),(31,963,-13,1,1,4),(32,1903,-247,1,1,4),(32,1896,-240,1,1,4),(32,1889,-233,1,1,4),(32,1882,-226,1,1,4),(32,1875,-219,1,1,4),(32,1868,-212,1,1,4),(32,1861,-205,1,1,4),(32,1854,-198,1,1,4),(32,1847,-191,1,1,4),(32,1840,-184,1,1,4),(32,1833,-177,1,1,4),(32,1826,-170,1,1,4),(32,1819,-163,1,1,4),(32,880,-156,1,1,4),(32,867,-143,1,1,4),(32,854,-130,1,1,4),(32,841,-117,1,1,4),(32,828,-104,1,1,4),(32,815,-91,1,1,4),(32,802,-78,1,1,4),(32,789,-65,1,1,4),(32,776,-52,1,1,4),(32,763,-39,1,1,4),(32,750,-26,1,1,4),(32,737,-13,1,1,4),(33,1588,-192,1,1,4),(33,1572,-176,1,1,4),(33,1556,-160,1,1,4),(33,1540,-144,1,1,4),(33,1524,-128,1,1,4),(33,1508,-112,1,1,4),(33,1492,-96,1,1,4),(33,1476,-80,1,1,4),(33,1460,-64,1,1,4),(33,1444,-48,1,1,4),(33,1428,-32,1,1,4),(33,1412,-16,1,1,4),(34,2040,-279,1,1,4),(34,2024,-263,1,1,4),(34,1903,-256,1,1,4),(34,1854,-249,1,1,4),(34,1847,-242,1,1,4),(34,1812,-235,1,1,4),(34,1748,-219,1,1,4),(34,1716,-203,1,1,4),(34,1540,-187,1,1,4),(34,1476,-171,1,1,4),(34,1332,-155,1,1,4),(34,1316,-139,1,1,4),(34,1220,-123,1,1,4),(34,1194,-113,1,1,4),(34,1130,-97,1,1,4),(34,1044,-81,1,1,4),(34,963,-65,1,1,4),(34,893,-52,1,1,4),(34,867,-39,1,1,4),(34,854,-26,1,1,4),(34,841,-13,1,1,4),(35,2003,-310,1,1,4),(35,1951,-304,1,1,4),(35,1896,-288,1,1,4),(35,1861,-281,1,1,4),(35,1826,-274,1,1,4),(35,1819,-267,1,1,4),(35,1796,-260,1,1,4),(35,1780,-244,1,1,4),(35,1732,-228,1,1,4),(35,1636,-212,1,1,4),(35,1556,-196,1,1,4),(35,1524,-180,1,1,4),(35,1428,-164,1,1,4),(35,1396,-148,1,1,4),(35,1380,-132,1,1,4),(35,1348,-116,1,1,4),(35,1268,-100,1,1,4),(35,1210,-84,1,1,4),(35,1146,-68,1,1,4),(35,989,-52,1,1,4),(35,937,-39,1,1,4),(35,911,-26,1,1,4),(35,750,-13,1,1,4),(36,2017,-247,1,1,4),(36,1919,-240,1,1,4),(36,1882,-224,1,1,4),(36,1684,-217,1,1,4),(36,1604,-201,1,1,4),(36,1508,-185,1,1,4),(36,1460,-169,1,1,4),(36,1444,-153,1,1,4),(36,1162,-137,1,1,4),(36,802,-121,1,1,4),(36,718,-108,1,1,4),(36,694,-102,1,1,4),(36,462,-96,1,1,4),(36,398,-80,1,1,4),(36,302,-64,1,1,4),(36,110,-48,1,1,4),(36,94,-32,1,1,4),(36,62,-16,1,1,4);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_store1_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index_tmp`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index_tmp` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `[[DBPREFIX]]CAT_CTGR_PRD_IDX_TMP_PRD_ID_CTGR_ID_STORE_ID` (`product_id`,`category_id`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Indexer temporary table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index_tmp`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index_tmp` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_compare_item`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_compare_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_compare_item` (
  `catalog_compare_item_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare Item ID',
  `visitor_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Visitor ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `list_id` int unsigned DEFAULT NULL COMMENT 'List ID',
  PRIMARY KEY (`catalog_compare_item_id`),
  KEY `[[DBPREFIX]]CAT_CMP_ITEM_LIST_ID_[[DBPREFIX]]CAT_CMP_LIST_LIST_ID` (`list_id`),
  KEY `[[DBPREFIX]]CATALOG_COMPARE_ITEM_PRODUCT_ID` (`product_id`),
  KEY `[[DBPREFIX]]CATALOG_COMPARE_ITEM_VISITOR_ID_PRODUCT_ID` (`visitor_id`,`product_id`),
  KEY `[[DBPREFIX]]CATALOG_COMPARE_ITEM_CUSTOMER_ID_PRODUCT_ID` (`customer_id`,`product_id`),
  KEY `[[DBPREFIX]]CATALOG_COMPARE_ITEM_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CMP_ITEM_CSTR_ID_[[DBPREFIX]]CSTR_ENTT_ENTT_ID` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CMP_ITEM_LIST_ID_[[DBPREFIX]]CAT_CMP_LIST_LIST_ID` FOREIGN KEY (`list_id`) REFERENCES `[[dbprefix]]catalog_compare_list` (`list_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CMP_ITEM_PRD_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CATALOG_COMPARE_ITEM_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Compare Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_compare_item`
--

LOCK TABLES `[[dbprefix]]catalog_compare_item` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_compare_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_compare_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_compare_list`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_compare_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_compare_list` (
  `list_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare List ID',
  `list_id_mask` varchar(32) DEFAULT NULL COMMENT 'Masked ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  PRIMARY KEY (`list_id`),
  UNIQUE KEY `[[DBPREFIX]]CATALOG_COMPARE_LIST_CUSTOMER_ID` (`customer_id`),
  KEY `[[DBPREFIX]]CATALOG_COMPARE_LIST_LIST_ID_MASK` (`list_id_mask`),
  CONSTRAINT `[[DBPREFIX]]CAT_CMP_LIST_CSTR_ID_[[DBPREFIX]]CSTR_ENTT_ENTT_ID` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Compare List with hash Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_compare_list`
--

LOCK TABLES `[[dbprefix]]catalog_compare_list` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_compare_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_compare_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_eav_attribute`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_eav_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_eav_attribute` (
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `frontend_input_renderer` varchar(255) DEFAULT NULL COMMENT 'Frontend Input Renderer',
  `is_global` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Global',
  `is_visible` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Visible',
  `is_searchable` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Searchable',
  `is_filterable` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable',
  `is_comparable` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Comparable',
  `is_visible_on_front` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible On Front',
  `is_html_allowed_on_front` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is HTML Allowed On Front',
  `is_used_for_price_rules` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Price Rules',
  `is_filterable_in_search` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable In Search',
  `used_in_product_listing` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used In Product Listing',
  `used_for_sort_by` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Sorting',
  `apply_to` varchar(255) DEFAULT NULL COMMENT 'Apply To',
  `is_visible_in_advanced_search` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible In Advanced Search',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_wysiwyg_enabled` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is WYSIWYG Enabled',
  `is_used_for_promo_rules` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Promo Rules',
  `is_required_in_admin_store` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Required In Admin Store',
  `is_used_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used in Grid',
  `is_visible_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible in Grid',
  `is_filterable_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable in Grid',
  `search_weight` float NOT NULL DEFAULT '1' COMMENT 'Search Weight',
  `is_pagebuilder_enabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is PageBuilder Enabled',
  `additional_data` text COMMENT 'Additional swatch attributes data',
  PRIMARY KEY (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_EAV_ATTRIBUTE_USED_FOR_SORT_BY` (`used_for_sort_by`),
  KEY `[[DBPREFIX]]CATALOG_EAV_ATTRIBUTE_USED_IN_PRODUCT_LISTING` (`used_in_product_listing`),
  CONSTRAINT `[[DBPREFIX]]CAT_EAV_ATTR_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog EAV Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_eav_attribute`
--

LOCK TABLES `[[dbprefix]]catalog_eav_attribute` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_eav_attribute` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_eav_attribute` VALUES (45,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(46,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(47,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,1,0,0,0,0,0,1,0,NULL),(48,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(49,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(50,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(51,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(52,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(53,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(54,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(55,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(56,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(57,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(58,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(59,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(60,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(61,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(62,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(63,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(64,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(65,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(66,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(67,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\Available',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(68,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\DefaultSortby',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(69,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(70,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(71,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(72,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Pricestep',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(73,NULL,0,1,1,0,0,0,0,0,0,1,1,NULL,1,0,0,0,0,0,0,0,5,0,NULL),(74,NULL,1,1,1,0,1,0,0,0,0,0,0,NULL,1,0,0,1,0,0,0,0,6,0,NULL),(75,NULL,0,1,1,0,1,0,1,0,0,0,0,NULL,1,0,1,0,0,0,0,0,1,1,NULL),(76,NULL,0,1,1,0,1,0,1,0,0,1,0,NULL,1,0,1,0,0,1,0,0,1,0,NULL),(77,NULL,1,1,1,1,0,0,0,0,0,1,1,'simple,virtual,bundle,downloadable,configurable',1,0,0,0,0,0,0,0,1,0,NULL),(78,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,1,1,0,NULL),(79,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,0,1,0,NULL),(80,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,0,1,0,NULL),(81,NULL,1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable',0,0,0,0,0,1,0,1,1,0,NULL),(82,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Weight',1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,1,1,0,NULL),(83,NULL,1,1,1,1,1,0,0,0,0,0,0,'simple,configurable',1,0,0,0,0,1,0,1,1,0,NULL),(84,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(85,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(86,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(87,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(88,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(89,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(90,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(91,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(92,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable',0,0,0,0,0,0,0,0,1,0,NULL),(93,NULL,1,1,0,1,0,0,1,0,0,1,0,'simple,virtual,configurable',0,0,0,1,0,1,0,1,1,0,'{\"swatch_input_type\":\"visual\",\"update_product_preview_image\":1,\"use_product_image_for_swatch\":0}'),(94,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(95,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(96,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(97,'Magento\\Framework\\Data\\Form\\Element\\Hidden',2,1,1,0,0,0,0,0,0,1,0,NULL,0,0,0,0,1,0,0,0,1,0,NULL),(98,NULL,0,0,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,0,0,0,1,0,NULL),(99,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,1,0,0,0,1,0,NULL),(100,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(101,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(102,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(103,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(104,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(105,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Category',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(106,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(107,NULL,1,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(108,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(109,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(110,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(111,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(112,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(113,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(114,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,bundle,configurable,grouped',0,0,0,0,0,1,0,1,1,0,NULL),(115,'Magento\\CatalogInventory\\Block\\Adminhtml\\Form\\Field\\Stock',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(116,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(117,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(118,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(119,NULL,0,1,1,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(120,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(121,NULL,0,1,1,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,1,1,0,NULL),(122,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL),(123,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type',1,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,1,0,1,1,0,NULL),(124,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type\\Price',2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,0,0,0,1,0,NULL),(125,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(126,NULL,1,1,0,0,0,0,0,0,0,0,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(127,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(128,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(129,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,0,NULL),(130,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,0,0,0,0,0,0,0,1,0,NULL),(131,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,0,0,0,0,0,0,0,1,0,NULL),(132,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,0,0,0,0,0,0,0,1,0,NULL),(133,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,0,0,0,0,0,0,0,1,0,NULL),(134,NULL,2,1,1,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,1,1,0,NULL),(135,NULL,1,1,0,1,1,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(136,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(137,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(138,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(139,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(140,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(141,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(142,NULL,1,1,0,1,0,0,1,0,0,1,0,NULL,0,0,0,1,0,0,0,0,1,0,'{\"swatch_input_type\":\"text\",\"update_product_preview_image\":1,\"use_product_image_for_swatch\":0}'),(143,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(144,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(145,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(146,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(147,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(148,'Magento\\GiftMessage\\Block\\Adminhtml\\Product\\Helper\\Form\\Config',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,0,NULL),(149,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(150,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(151,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(152,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(153,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(154,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(155,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,0,NULL),(156,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,0,NULL);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_eav_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_attribute_cl`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_attribute_cl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_attribute_cl` (
  `version_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Version ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  PRIMARY KEY (`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='[[dbprefix]]catalog_product_attribute_cl';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_attribute_cl`
--

LOCK TABLES `[[dbprefix]]catalog_product_attribute_cl` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_attribute_cl` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_attribute_cl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_option`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_option` (
  `option_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option ID',
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `required` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Required',
  `position` int unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `type` varchar(255) DEFAULT NULL COMMENT 'Type',
  PRIMARY KEY (`option_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_OPTION_PARENT_ID` (`parent_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_OPT_PARENT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`parent_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Option';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_option`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_option` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_option` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_bundle_option` VALUES (1,45,1,1,'radio'),(2,45,1,2,'radio'),(3,45,1,3,'radio'),(4,45,1,4,'radio');
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_option_value`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_option_value` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `option_id` int unsigned NOT NULL COMMENT 'Option ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `parent_product_id` int unsigned NOT NULL COMMENT 'Parent Product ID',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_PRD_BNDL_OPT_VAL_OPT_ID_PARENT_PRD_ID_STORE_ID` (`option_id`,`parent_product_id`,`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_OPT_VAL_OPT_ID_[[DBPREFIX]]CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `[[dbprefix]]catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Option Value';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_option_value`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_option_value` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_option_value` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_bundle_option_value` VALUES (1,1,0,'Sprite Stasis Ball',45),(2,2,0,'Sprite Foam Yoga Brick',45),(3,3,0,'Sprite Yoga Strap',45),(4,4,0,'Sprite Foam Roller',45);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_price_index`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_price_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_price_index` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  `min_price` decimal(20,6) NOT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) NOT NULL COMMENT 'Max Price',
  PRIMARY KEY (`entity_id`,`website_id`,`customer_group_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_WEBSITE_ID` (`website_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_CUSTOMER_GROUP_ID` (`customer_group_id`),
  CONSTRAINT `FK_8DB5B8954D6EEC1C9A89C61D561C2D39` FOREIGN KEY (`customer_group_id`) REFERENCES `[[dbprefix]]customer_group` (`customer_group_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_PRICE_IDX_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_PRICE_IDX_WS_ID_[[DBPREFIX]]STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `[[dbprefix]]store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Price Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_price_index`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_price_index` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_price_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_price_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_selection`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_selection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_selection` (
  `selection_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Selection ID',
  `option_id` int unsigned NOT NULL COMMENT 'Option ID',
  `parent_product_id` int unsigned NOT NULL COMMENT 'Parent Product ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `position` int unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_default` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Default',
  `selection_price_type` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Selection Price Value',
  `selection_qty` decimal(12,4) DEFAULT NULL COMMENT 'Selection Qty',
  `selection_can_change_qty` smallint NOT NULL DEFAULT '0' COMMENT 'Selection Can Change Qty',
  PRIMARY KEY (`selection_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_SELECTION_OPTION_ID` (`option_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_SELECTION_PRODUCT_ID` (`product_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_SELECTION_OPT_ID_[[DBPREFIX]]CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `[[dbprefix]]catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_SELECTION_PRD_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Selection';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_selection`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_selection` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_selection` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_bundle_selection` VALUES (1,1,45,26,1,1,0,0.0000,1.0000,1),(2,1,45,29,2,0,0,0.0000,1.0000,1),(3,1,45,32,3,0,0,0.0000,1.0000,1),(4,2,45,21,1,1,0,0.0000,1.0000,1),(5,3,45,33,1,1,0,0.0000,1.0000,1),(6,3,45,34,2,0,0,0.0000,1.0000,1),(7,3,45,35,3,0,0,0.0000,1.0000,1),(8,4,45,22,1,1,0,0.0000,1.0000,1);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_selection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_selection_price`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_selection_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_selection_price` (
  `selection_id` int unsigned NOT NULL COMMENT 'Selection ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `selection_price_type` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Selection Price Value',
  `parent_product_id` int unsigned NOT NULL COMMENT 'Parent Product ID',
  PRIMARY KEY (`selection_id`,`parent_product_id`,`website_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_SELECTION_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `FK_48A0D40A08C88AC5E40947636D598C57` FOREIGN KEY (`selection_id`) REFERENCES `[[dbprefix]]catalog_product_bundle_selection` (`selection_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_SELECTION_PRICE_WS_ID_[[DBPREFIX]]STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `[[dbprefix]]store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Selection Price';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_selection_price`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_selection_price` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_selection_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_selection_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_stock_index`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_stock_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_stock_index` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint unsigned NOT NULL COMMENT 'Stock ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `stock_status` smallint DEFAULT '0' COMMENT 'Stock Status',
  PRIMARY KEY (`entity_id`,`website_id`,`stock_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Stock Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_stock_index`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_stock_index` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_stock_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_stock_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_category_cl`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_category_cl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_category_cl` (
  `version_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Version ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  PRIMARY KEY (`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='[[dbprefix]]catalog_product_category_cl';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_category_cl`
--

LOCK TABLES `[[dbprefix]]catalog_product_category_cl` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_category_cl` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_category_cl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple' COMMENT 'Type ID',
  `sku` varchar(64) NOT NULL COMMENT 'SKU',
  `has_options` smallint NOT NULL DEFAULT '0' COMMENT 'Has Options',
  `required_options` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Required Options',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  PRIMARY KEY (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID` (`attribute_set_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_SKU` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=2041 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity` VALUES (1,15,'simple','24-MB01',0,0,'[[regtime]]','[[regtime]]'),(2,15,'simple','24-MB04',0,0,'[[regtime]]','[[regtime]]'),(3,15,'simple','24-MB03',0,0,'[[regtime]]','[[regtime]]'),(4,15,'simple','24-MB05',0,0,'[[regtime]]','[[regtime]]'),(5,15,'simple','24-MB06',0,0,'[[regtime]]','[[regtime]]'),(6,15,'simple','24-MB02',0,0,'[[regtime]]','[[regtime]]'),(7,15,'simple','24-UB02',0,0,'[[regtime]]','[[regtime]]'),(8,15,'simple','24-WB01',0,0,'[[regtime]]','[[regtime]]'),(9,15,'simple','24-WB02',0,0,'[[regtime]]','[[regtime]]'),(10,15,'simple','24-WB05',0,0,'[[regtime]]','[[regtime]]'),(11,15,'simple','24-WB06',0,0,'[[regtime]]','[[regtime]]'),(12,15,'simple','24-WB03',0,0,'[[regtime]]','[[regtime]]'),(13,15,'simple','24-WB07',0,0,'[[regtime]]','[[regtime]]'),(14,15,'simple','24-WB04',0,0,'[[regtime]]','[[regtime]]'),(15,11,'simple','24-UG06',0,0,'[[regtime]]','[[regtime]]'),(16,11,'simple','24-UG07',0,0,'[[regtime]]','[[regtime]]'),(17,11,'simple','24-UG04',0,0,'[[regtime]]','[[regtime]]'),(18,11,'simple','24-UG02',0,0,'[[regtime]]','[[regtime]]'),(19,11,'simple','24-UG05',0,0,'[[regtime]]','[[regtime]]'),(20,11,'simple','24-UG01',0,0,'[[regtime]]','[[regtime]]'),(21,11,'simple','24-WG084',0,0,'[[regtime]]','[[regtime]]'),(22,11,'simple','24-WG088',0,0,'[[regtime]]','[[regtime]]'),(23,11,'simple','24-UG03',0,0,'[[regtime]]','[[regtime]]'),(24,12,'simple','24-WG081-gray',0,0,'[[regtime]]','[[regtime]]'),(25,12,'simple','24-WG081-pink',0,0,'[[regtime]]','[[regtime]]'),(26,12,'simple','24-WG081-blue',0,0,'[[regtime]]','[[regtime]]'),(27,12,'simple','24-WG082-gray',0,0,'[[regtime]]','[[regtime]]'),(28,12,'simple','24-WG082-pink',0,0,'[[regtime]]','[[regtime]]'),(29,12,'simple','24-WG082-blue',0,0,'[[regtime]]','[[regtime]]'),(30,12,'simple','24-WG083-gray',0,0,'[[regtime]]','[[regtime]]'),(31,12,'simple','24-WG083-pink',0,0,'[[regtime]]','[[regtime]]'),(32,12,'simple','24-WG083-blue',0,0,'[[regtime]]','[[regtime]]'),(33,13,'simple','24-WG085',0,0,'[[regtime]]','[[regtime]]'),(34,13,'simple','24-WG086',0,0,'[[regtime]]','[[regtime]]'),(35,13,'simple','24-WG087',0,0,'[[regtime]]','[[regtime]]'),(36,11,'simple','24-MG04',0,0,'[[regtime]]','[[regtime]]'),(37,11,'simple','24-MG01',0,0,'[[regtime]]','[[regtime]]'),(38,11,'simple','24-MG03',0,0,'[[regtime]]','[[regtime]]'),(39,11,'simple','24-MG05',0,0,'[[regtime]]','[[regtime]]'),(40,11,'simple','24-MG02',0,0,'[[regtime]]','[[regtime]]'),(41,11,'simple','24-WG09',0,0,'[[regtime]]','[[regtime]]'),(42,11,'simple','24-WG01',0,0,'[[regtime]]','[[regtime]]'),(43,11,'simple','24-WG03',0,0,'[[regtime]]','[[regtime]]'),(44,11,'simple','24-WG02',0,0,'[[regtime]]','[[regtime]]'),(45,11,'bundle','24-WG080',1,1,'[[regtime]]','[[regtime]]'),(46,11,'grouped','24-WG085_Group',0,0,'[[regtime]]','[[regtime]]'),(47,9,'simple','MH01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(48,9,'simple','MH01-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(49,9,'simple','MH01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(50,9,'simple','MH01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(51,9,'simple','MH01-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(52,9,'simple','MH01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(53,9,'simple','MH01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(54,9,'simple','MH01-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(55,9,'simple','MH01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(56,9,'simple','MH01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(57,9,'simple','MH01-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(58,9,'simple','MH01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(59,9,'simple','MH01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(60,9,'simple','MH01-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(61,9,'simple','MH01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(62,9,'configurable','MH01',1,0,'[[regtime]]','[[regtime]]'),(63,9,'simple','MH02-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(64,9,'simple','MH02-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(65,9,'simple','MH02-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(66,9,'simple','MH02-S-Black',0,0,'[[regtime]]','[[regtime]]'),(67,9,'simple','MH02-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(68,9,'simple','MH02-S-Red',0,0,'[[regtime]]','[[regtime]]'),(69,9,'simple','MH02-M-Black',0,0,'[[regtime]]','[[regtime]]'),(70,9,'simple','MH02-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(71,9,'simple','MH02-M-Red',0,0,'[[regtime]]','[[regtime]]'),(72,9,'simple','MH02-L-Black',0,0,'[[regtime]]','[[regtime]]'),(73,9,'simple','MH02-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(74,9,'simple','MH02-L-Red',0,0,'[[regtime]]','[[regtime]]'),(75,9,'simple','MH02-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(76,9,'simple','MH02-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(77,9,'simple','MH02-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(78,9,'configurable','MH02',1,0,'[[regtime]]','[[regtime]]'),(79,9,'simple','MH03-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(80,9,'simple','MH03-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(81,9,'simple','MH03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(82,9,'simple','MH03-S-Black',0,0,'[[regtime]]','[[regtime]]'),(83,9,'simple','MH03-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(84,9,'simple','MH03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(85,9,'simple','MH03-M-Black',0,0,'[[regtime]]','[[regtime]]'),(86,9,'simple','MH03-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(87,9,'simple','MH03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(88,9,'simple','MH03-L-Black',0,0,'[[regtime]]','[[regtime]]'),(89,9,'simple','MH03-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(90,9,'simple','MH03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(91,9,'simple','MH03-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(92,9,'simple','MH03-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(93,9,'simple','MH03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(94,9,'configurable','MH03',1,0,'[[regtime]]','[[regtime]]'),(95,9,'simple','MH04-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(96,9,'simple','MH04-XS-White',0,0,'[[regtime]]','[[regtime]]'),(97,9,'simple','MH04-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(98,9,'simple','MH04-S-Green',0,0,'[[regtime]]','[[regtime]]'),(99,9,'simple','MH04-S-White',0,0,'[[regtime]]','[[regtime]]'),(100,9,'simple','MH04-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(101,9,'simple','MH04-M-Green',0,0,'[[regtime]]','[[regtime]]'),(102,9,'simple','MH04-M-White',0,0,'[[regtime]]','[[regtime]]'),(103,9,'simple','MH04-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(104,9,'simple','MH04-L-Green',0,0,'[[regtime]]','[[regtime]]'),(105,9,'simple','MH04-L-White',0,0,'[[regtime]]','[[regtime]]'),(106,9,'simple','MH04-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(107,9,'simple','MH04-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(108,9,'simple','MH04-XL-White',0,0,'[[regtime]]','[[regtime]]'),(109,9,'simple','MH04-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(110,9,'configurable','MH04',1,0,'[[regtime]]','[[regtime]]'),(111,9,'simple','MH05-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(112,9,'simple','MH05-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(113,9,'simple','MH05-XS-White',0,0,'[[regtime]]','[[regtime]]'),(114,9,'simple','MH05-S-Green',0,0,'[[regtime]]','[[regtime]]'),(115,9,'simple','MH05-S-Red',0,0,'[[regtime]]','[[regtime]]'),(116,9,'simple','MH05-S-White',0,0,'[[regtime]]','[[regtime]]'),(117,9,'simple','MH05-M-Green',0,0,'[[regtime]]','[[regtime]]'),(118,9,'simple','MH05-M-Red',0,0,'[[regtime]]','[[regtime]]'),(119,9,'simple','MH05-M-White',0,0,'[[regtime]]','[[regtime]]'),(120,9,'simple','MH05-L-Green',0,0,'[[regtime]]','[[regtime]]'),(121,9,'simple','MH05-L-Red',0,0,'[[regtime]]','[[regtime]]'),(122,9,'simple','MH05-L-White',0,0,'[[regtime]]','[[regtime]]'),(123,9,'simple','MH05-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(124,9,'simple','MH05-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(125,9,'simple','MH05-XL-White',0,0,'[[regtime]]','[[regtime]]'),(126,9,'configurable','MH05',1,0,'[[regtime]]','[[regtime]]'),(127,9,'simple','MH06-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(128,9,'simple','MH06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(129,9,'simple','MH06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(130,9,'simple','MH06-S-Black',0,0,'[[regtime]]','[[regtime]]'),(131,9,'simple','MH06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(132,9,'simple','MH06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(133,9,'simple','MH06-M-Black',0,0,'[[regtime]]','[[regtime]]'),(134,9,'simple','MH06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(135,9,'simple','MH06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(136,9,'simple','MH06-L-Black',0,0,'[[regtime]]','[[regtime]]'),(137,9,'simple','MH06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(138,9,'simple','MH06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(139,9,'simple','MH06-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(140,9,'simple','MH06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(141,9,'simple','MH06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(142,9,'configurable','MH06',1,0,'[[regtime]]','[[regtime]]'),(143,9,'simple','MH07-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(144,9,'simple','MH07-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(145,9,'simple','MH07-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(146,9,'simple','MH07-S-Black',0,0,'[[regtime]]','[[regtime]]'),(147,9,'simple','MH07-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(148,9,'simple','MH07-S-Green',0,0,'[[regtime]]','[[regtime]]'),(149,9,'simple','MH07-M-Black',0,0,'[[regtime]]','[[regtime]]'),(150,9,'simple','MH07-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(151,9,'simple','MH07-M-Green',0,0,'[[regtime]]','[[regtime]]'),(152,9,'simple','MH07-L-Black',0,0,'[[regtime]]','[[regtime]]'),(153,9,'simple','MH07-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(154,9,'simple','MH07-L-Green',0,0,'[[regtime]]','[[regtime]]'),(155,9,'simple','MH07-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(156,9,'simple','MH07-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(157,9,'simple','MH07-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(158,9,'configurable','MH07',1,0,'[[regtime]]','[[regtime]]'),(159,9,'simple','MH08-XS-Brown',0,0,'[[regtime]]','[[regtime]]'),(160,9,'simple','MH08-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(161,9,'simple','MH08-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(162,9,'simple','MH08-S-Brown',0,0,'[[regtime]]','[[regtime]]'),(163,9,'simple','MH08-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(164,9,'simple','MH08-S-Red',0,0,'[[regtime]]','[[regtime]]'),(165,9,'simple','MH08-M-Brown',0,0,'[[regtime]]','[[regtime]]'),(166,9,'simple','MH08-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(167,9,'simple','MH08-M-Red',0,0,'[[regtime]]','[[regtime]]'),(168,9,'simple','MH08-L-Brown',0,0,'[[regtime]]','[[regtime]]'),(169,9,'simple','MH08-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(170,9,'simple','MH08-L-Red',0,0,'[[regtime]]','[[regtime]]'),(171,9,'simple','MH08-XL-Brown',0,0,'[[regtime]]','[[regtime]]'),(172,9,'simple','MH08-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(173,9,'simple','MH08-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(174,9,'configurable','MH08',1,0,'[[regtime]]','[[regtime]]'),(175,9,'simple','MH09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(176,9,'simple','MH09-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(177,9,'simple','MH09-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(178,9,'simple','MH09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(179,9,'simple','MH09-S-Green',0,0,'[[regtime]]','[[regtime]]'),(180,9,'simple','MH09-S-Red',0,0,'[[regtime]]','[[regtime]]'),(181,9,'simple','MH09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(182,9,'simple','MH09-M-Green',0,0,'[[regtime]]','[[regtime]]'),(183,9,'simple','MH09-M-Red',0,0,'[[regtime]]','[[regtime]]'),(184,9,'simple','MH09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(185,9,'simple','MH09-L-Green',0,0,'[[regtime]]','[[regtime]]'),(186,9,'simple','MH09-L-Red',0,0,'[[regtime]]','[[regtime]]'),(187,9,'simple','MH09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(188,9,'simple','MH09-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(189,9,'simple','MH09-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(190,9,'configurable','MH09',1,0,'[[regtime]]','[[regtime]]'),(191,9,'simple','MH10-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(192,9,'simple','MH10-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(193,9,'simple','MH10-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(194,9,'simple','MH10-S-Black',0,0,'[[regtime]]','[[regtime]]'),(195,9,'simple','MH10-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(196,9,'simple','MH10-S-Red',0,0,'[[regtime]]','[[regtime]]'),(197,9,'simple','MH10-M-Black',0,0,'[[regtime]]','[[regtime]]'),(198,9,'simple','MH10-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(199,9,'simple','MH10-M-Red',0,0,'[[regtime]]','[[regtime]]'),(200,9,'simple','MH10-L-Black',0,0,'[[regtime]]','[[regtime]]'),(201,9,'simple','MH10-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(202,9,'simple','MH10-L-Red',0,0,'[[regtime]]','[[regtime]]'),(203,9,'simple','MH10-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(204,9,'simple','MH10-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(205,9,'simple','MH10-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(206,9,'configurable','MH10',1,0,'[[regtime]]','[[regtime]]'),(207,9,'simple','MH11-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(208,9,'simple','MH11-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(209,9,'simple','MH11-XS-White',0,0,'[[regtime]]','[[regtime]]'),(210,9,'simple','MH11-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(211,9,'simple','MH11-S-Red',0,0,'[[regtime]]','[[regtime]]'),(212,9,'simple','MH11-S-White',0,0,'[[regtime]]','[[regtime]]'),(213,9,'simple','MH11-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(214,9,'simple','MH11-M-Red',0,0,'[[regtime]]','[[regtime]]'),(215,9,'simple','MH11-M-White',0,0,'[[regtime]]','[[regtime]]'),(216,9,'simple','MH11-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(217,9,'simple','MH11-L-Red',0,0,'[[regtime]]','[[regtime]]'),(218,9,'simple','MH11-L-White',0,0,'[[regtime]]','[[regtime]]'),(219,9,'simple','MH11-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(220,9,'simple','MH11-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(221,9,'simple','MH11-XL-White',0,0,'[[regtime]]','[[regtime]]'),(222,9,'configurable','MH11',1,0,'[[regtime]]','[[regtime]]'),(223,9,'simple','MH12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(224,9,'simple','MH12-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(225,9,'simple','MH12-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(226,9,'simple','MH12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(227,9,'simple','MH12-S-Green',0,0,'[[regtime]]','[[regtime]]'),(228,9,'simple','MH12-S-Red',0,0,'[[regtime]]','[[regtime]]'),(229,9,'simple','MH12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(230,9,'simple','MH12-M-Green',0,0,'[[regtime]]','[[regtime]]'),(231,9,'simple','MH12-M-Red',0,0,'[[regtime]]','[[regtime]]'),(232,9,'simple','MH12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(233,9,'simple','MH12-L-Green',0,0,'[[regtime]]','[[regtime]]'),(234,9,'simple','MH12-L-Red',0,0,'[[regtime]]','[[regtime]]'),(235,9,'simple','MH12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(236,9,'simple','MH12-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(237,9,'simple','MH12-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(238,9,'configurable','MH12',1,0,'[[regtime]]','[[regtime]]'),(239,9,'simple','MH13-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(240,9,'simple','MH13-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(241,9,'simple','MH13-XS-Lavender',0,0,'[[regtime]]','[[regtime]]'),(242,9,'simple','MH13-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(243,9,'simple','MH13-S-Green',0,0,'[[regtime]]','[[regtime]]'),(244,9,'simple','MH13-S-Lavender',0,0,'[[regtime]]','[[regtime]]'),(245,9,'simple','MH13-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(246,9,'simple','MH13-M-Green',0,0,'[[regtime]]','[[regtime]]'),(247,9,'simple','MH13-M-Lavender',0,0,'[[regtime]]','[[regtime]]'),(248,9,'simple','MH13-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(249,9,'simple','MH13-L-Green',0,0,'[[regtime]]','[[regtime]]'),(250,9,'simple','MH13-L-Lavender',0,0,'[[regtime]]','[[regtime]]'),(251,9,'simple','MH13-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(252,9,'simple','MH13-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(253,9,'simple','MH13-XL-Lavender',0,0,'[[regtime]]','[[regtime]]'),(254,9,'configurable','MH13',1,0,'[[regtime]]','[[regtime]]'),(255,9,'simple','MJ01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(256,9,'simple','MJ01-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(257,9,'simple','MJ01-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(258,9,'simple','MJ01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(259,9,'simple','MJ01-S-Red',0,0,'[[regtime]]','[[regtime]]'),(260,9,'simple','MJ01-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(261,9,'simple','MJ01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(262,9,'simple','MJ01-M-Red',0,0,'[[regtime]]','[[regtime]]'),(263,9,'simple','MJ01-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(264,9,'simple','MJ01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(265,9,'simple','MJ01-L-Red',0,0,'[[regtime]]','[[regtime]]'),(266,9,'simple','MJ01-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(267,9,'simple','MJ01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(268,9,'simple','MJ01-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(269,9,'simple','MJ01-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(270,9,'configurable','MJ01',1,0,'[[regtime]]','[[regtime]]'),(271,9,'simple','MJ02-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(272,9,'simple','MJ02-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(273,9,'simple','MJ02-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(274,9,'simple','MJ02-S-Green',0,0,'[[regtime]]','[[regtime]]'),(275,9,'simple','MJ02-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(276,9,'simple','MJ02-S-Red',0,0,'[[regtime]]','[[regtime]]'),(277,9,'simple','MJ02-M-Green',0,0,'[[regtime]]','[[regtime]]'),(278,9,'simple','MJ02-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(279,9,'simple','MJ02-M-Red',0,0,'[[regtime]]','[[regtime]]'),(280,9,'simple','MJ02-L-Green',0,0,'[[regtime]]','[[regtime]]'),(281,9,'simple','MJ02-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(282,9,'simple','MJ02-L-Red',0,0,'[[regtime]]','[[regtime]]'),(283,9,'simple','MJ02-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(284,9,'simple','MJ02-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(285,9,'simple','MJ02-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(286,9,'configurable','MJ02',1,0,'[[regtime]]','[[regtime]]'),(287,9,'simple','MJ04-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(288,9,'simple','MJ04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(289,9,'simple','MJ04-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(290,9,'simple','MJ04-S-Black',0,0,'[[regtime]]','[[regtime]]'),(291,9,'simple','MJ04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(292,9,'simple','MJ04-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(293,9,'simple','MJ04-M-Black',0,0,'[[regtime]]','[[regtime]]'),(294,9,'simple','MJ04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(295,9,'simple','MJ04-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(296,9,'simple','MJ04-L-Black',0,0,'[[regtime]]','[[regtime]]'),(297,9,'simple','MJ04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(298,9,'simple','MJ04-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(299,9,'simple','MJ04-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(300,9,'simple','MJ04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(301,9,'simple','MJ04-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(302,9,'configurable','MJ04',1,0,'[[regtime]]','[[regtime]]'),(303,9,'simple','MJ07-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(304,9,'simple','MJ07-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(305,9,'simple','MJ07-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(306,9,'simple','MJ07-S-Black',0,0,'[[regtime]]','[[regtime]]'),(307,9,'simple','MJ07-S-Red',0,0,'[[regtime]]','[[regtime]]'),(308,9,'simple','MJ07-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(309,9,'simple','MJ07-M-Black',0,0,'[[regtime]]','[[regtime]]'),(310,9,'simple','MJ07-M-Red',0,0,'[[regtime]]','[[regtime]]'),(311,9,'simple','MJ07-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(312,9,'simple','MJ07-L-Black',0,0,'[[regtime]]','[[regtime]]'),(313,9,'simple','MJ07-L-Red',0,0,'[[regtime]]','[[regtime]]'),(314,9,'simple','MJ07-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(315,9,'simple','MJ07-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(316,9,'simple','MJ07-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(317,9,'simple','MJ07-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(318,9,'configurable','MJ07',1,0,'[[regtime]]','[[regtime]]'),(319,9,'simple','MJ08-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(320,9,'simple','MJ08-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(321,9,'simple','MJ08-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(322,9,'simple','MJ08-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(323,9,'simple','MJ08-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(324,9,'simple','MJ08-S-Green',0,0,'[[regtime]]','[[regtime]]'),(325,9,'simple','MJ08-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(326,9,'simple','MJ08-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(327,9,'simple','MJ08-M-Green',0,0,'[[regtime]]','[[regtime]]'),(328,9,'simple','MJ08-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(329,9,'simple','MJ08-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(330,9,'simple','MJ08-L-Green',0,0,'[[regtime]]','[[regtime]]'),(331,9,'simple','MJ08-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(332,9,'simple','MJ08-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(333,9,'simple','MJ08-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(334,9,'configurable','MJ08',1,0,'[[regtime]]','[[regtime]]'),(335,9,'simple','MJ09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(336,9,'simple','MJ09-XS-White',0,0,'[[regtime]]','[[regtime]]'),(337,9,'simple','MJ09-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(338,9,'simple','MJ09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(339,9,'simple','MJ09-S-White',0,0,'[[regtime]]','[[regtime]]'),(340,9,'simple','MJ09-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(341,9,'simple','MJ09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(342,9,'simple','MJ09-M-White',0,0,'[[regtime]]','[[regtime]]'),(343,9,'simple','MJ09-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(344,9,'simple','MJ09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(345,9,'simple','MJ09-L-White',0,0,'[[regtime]]','[[regtime]]'),(346,9,'simple','MJ09-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(347,9,'simple','MJ09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(348,9,'simple','MJ09-XL-White',0,0,'[[regtime]]','[[regtime]]'),(349,9,'simple','MJ09-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(350,9,'configurable','MJ09',1,0,'[[regtime]]','[[regtime]]'),(351,9,'simple','MJ10-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(352,9,'simple','MJ10-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(353,9,'simple','MJ10-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(354,9,'simple','MJ10-S-Black',0,0,'[[regtime]]','[[regtime]]'),(355,9,'simple','MJ10-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(356,9,'simple','MJ10-S-Red',0,0,'[[regtime]]','[[regtime]]'),(357,9,'simple','MJ10-M-Black',0,0,'[[regtime]]','[[regtime]]'),(358,9,'simple','MJ10-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(359,9,'simple','MJ10-M-Red',0,0,'[[regtime]]','[[regtime]]'),(360,9,'simple','MJ10-L-Black',0,0,'[[regtime]]','[[regtime]]'),(361,9,'simple','MJ10-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(362,9,'simple','MJ10-L-Red',0,0,'[[regtime]]','[[regtime]]'),(363,9,'simple','MJ10-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(364,9,'simple','MJ10-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(365,9,'simple','MJ10-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(366,9,'configurable','MJ10',1,0,'[[regtime]]','[[regtime]]'),(367,9,'simple','MJ11-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(368,9,'simple','MJ11-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(369,9,'simple','MJ11-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(370,9,'simple','MJ11-S-Black',0,0,'[[regtime]]','[[regtime]]'),(371,9,'simple','MJ11-S-Green',0,0,'[[regtime]]','[[regtime]]'),(372,9,'simple','MJ11-S-Red',0,0,'[[regtime]]','[[regtime]]'),(373,9,'simple','MJ11-M-Black',0,0,'[[regtime]]','[[regtime]]'),(374,9,'simple','MJ11-M-Green',0,0,'[[regtime]]','[[regtime]]'),(375,9,'simple','MJ11-M-Red',0,0,'[[regtime]]','[[regtime]]'),(376,9,'simple','MJ11-L-Black',0,0,'[[regtime]]','[[regtime]]'),(377,9,'simple','MJ11-L-Green',0,0,'[[regtime]]','[[regtime]]'),(378,9,'simple','MJ11-L-Red',0,0,'[[regtime]]','[[regtime]]'),(379,9,'simple','MJ11-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(380,9,'simple','MJ11-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(381,9,'simple','MJ11-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(382,9,'configurable','MJ11',1,0,'[[regtime]]','[[regtime]]'),(383,9,'simple','MJ06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(384,9,'simple','MJ06-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(385,9,'simple','MJ06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(386,9,'simple','MJ06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(387,9,'simple','MJ06-S-Green',0,0,'[[regtime]]','[[regtime]]'),(388,9,'simple','MJ06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(389,9,'simple','MJ06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(390,9,'simple','MJ06-M-Green',0,0,'[[regtime]]','[[regtime]]'),(391,9,'simple','MJ06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(392,9,'simple','MJ06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(393,9,'simple','MJ06-L-Green',0,0,'[[regtime]]','[[regtime]]'),(394,9,'simple','MJ06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(395,9,'simple','MJ06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(396,9,'simple','MJ06-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(397,9,'simple','MJ06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(398,9,'configurable','MJ06',1,0,'[[regtime]]','[[regtime]]'),(399,9,'simple','MJ03-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(400,9,'simple','MJ03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(401,9,'simple','MJ03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(402,9,'simple','MJ03-S-Black',0,0,'[[regtime]]','[[regtime]]'),(403,9,'simple','MJ03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(404,9,'simple','MJ03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(405,9,'simple','MJ03-M-Black',0,0,'[[regtime]]','[[regtime]]'),(406,9,'simple','MJ03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(407,9,'simple','MJ03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(408,9,'simple','MJ03-L-Black',0,0,'[[regtime]]','[[regtime]]'),(409,9,'simple','MJ03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(410,9,'simple','MJ03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(411,9,'simple','MJ03-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(412,9,'simple','MJ03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(413,9,'simple','MJ03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(414,9,'configurable','MJ03',1,0,'[[regtime]]','[[regtime]]'),(415,9,'simple','MJ12-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(416,9,'simple','MJ12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(417,9,'simple','MJ12-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(418,9,'simple','MJ12-S-Black',0,0,'[[regtime]]','[[regtime]]'),(419,9,'simple','MJ12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(420,9,'simple','MJ12-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(421,9,'simple','MJ12-M-Black',0,0,'[[regtime]]','[[regtime]]'),(422,9,'simple','MJ12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(423,9,'simple','MJ12-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(424,9,'simple','MJ12-L-Black',0,0,'[[regtime]]','[[regtime]]'),(425,9,'simple','MJ12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(426,9,'simple','MJ12-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(427,9,'simple','MJ12-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(428,9,'simple','MJ12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(429,9,'simple','MJ12-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(430,9,'configurable','MJ12',1,0,'[[regtime]]','[[regtime]]'),(431,9,'simple','MS04-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(432,9,'simple','MS04-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(433,9,'simple','MS04-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(434,9,'simple','MS04-S-Black',0,0,'[[regtime]]','[[regtime]]'),(435,9,'simple','MS04-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(436,9,'simple','MS04-S-Red',0,0,'[[regtime]]','[[regtime]]'),(437,9,'simple','MS04-M-Black',0,0,'[[regtime]]','[[regtime]]'),(438,9,'simple','MS04-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(439,9,'simple','MS04-M-Red',0,0,'[[regtime]]','[[regtime]]'),(440,9,'simple','MS04-L-Black',0,0,'[[regtime]]','[[regtime]]'),(441,9,'simple','MS04-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(442,9,'simple','MS04-L-Red',0,0,'[[regtime]]','[[regtime]]'),(443,9,'simple','MS04-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(444,9,'simple','MS04-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(445,9,'simple','MS04-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(446,9,'configurable','MS04',1,0,'[[regtime]]','[[regtime]]'),(447,9,'simple','MS05-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(448,9,'simple','MS05-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(449,9,'simple','MS05-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(450,9,'simple','MS05-S-Black',0,0,'[[regtime]]','[[regtime]]'),(451,9,'simple','MS05-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(452,9,'simple','MS05-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(453,9,'simple','MS05-M-Black',0,0,'[[regtime]]','[[regtime]]'),(454,9,'simple','MS05-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(455,9,'simple','MS05-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(456,9,'simple','MS05-L-Black',0,0,'[[regtime]]','[[regtime]]'),(457,9,'simple','MS05-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(458,9,'simple','MS05-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(459,9,'simple','MS05-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(460,9,'simple','MS05-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(461,9,'simple','MS05-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(462,9,'configurable','MS05',1,0,'[[regtime]]','[[regtime]]'),(463,9,'simple','MS09-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(464,9,'simple','MS09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(465,9,'simple','MS09-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(466,9,'simple','MS09-S-Black',0,0,'[[regtime]]','[[regtime]]'),(467,9,'simple','MS09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(468,9,'simple','MS09-S-Red',0,0,'[[regtime]]','[[regtime]]'),(469,9,'simple','MS09-M-Black',0,0,'[[regtime]]','[[regtime]]'),(470,9,'simple','MS09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(471,9,'simple','MS09-M-Red',0,0,'[[regtime]]','[[regtime]]'),(472,9,'simple','MS09-L-Black',0,0,'[[regtime]]','[[regtime]]'),(473,9,'simple','MS09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(474,9,'simple','MS09-L-Red',0,0,'[[regtime]]','[[regtime]]'),(475,9,'simple','MS09-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(476,9,'simple','MS09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(477,9,'simple','MS09-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(478,9,'configurable','MS09',1,0,'[[regtime]]','[[regtime]]'),(479,9,'simple','MS11-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(480,9,'simple','MS11-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(481,9,'simple','MS11-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(482,9,'simple','MS11-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(483,9,'simple','MS11-S-Green',0,0,'[[regtime]]','[[regtime]]'),(484,9,'simple','MS11-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(485,9,'simple','MS11-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(486,9,'simple','MS11-M-Green',0,0,'[[regtime]]','[[regtime]]'),(487,9,'simple','MS11-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(488,9,'simple','MS11-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(489,9,'simple','MS11-L-Green',0,0,'[[regtime]]','[[regtime]]'),(490,9,'simple','MS11-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(491,9,'simple','MS11-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(492,9,'simple','MS11-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(493,9,'simple','MS11-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(494,9,'configurable','MS11',1,0,'[[regtime]]','[[regtime]]'),(495,9,'simple','MS12-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(496,9,'simple','MS12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(497,9,'simple','MS12-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(498,9,'simple','MS12-S-Black',0,0,'[[regtime]]','[[regtime]]'),(499,9,'simple','MS12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(500,9,'simple','MS12-S-Red',0,0,'[[regtime]]','[[regtime]]'),(501,9,'simple','MS12-M-Black',0,0,'[[regtime]]','[[regtime]]'),(502,9,'simple','MS12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(503,9,'simple','MS12-M-Red',0,0,'[[regtime]]','[[regtime]]'),(504,9,'simple','MS12-L-Black',0,0,'[[regtime]]','[[regtime]]'),(505,9,'simple','MS12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(506,9,'simple','MS12-L-Red',0,0,'[[regtime]]','[[regtime]]'),(507,9,'simple','MS12-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(508,9,'simple','MS12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(509,9,'simple','MS12-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(510,9,'configurable','MS12',1,0,'[[regtime]]','[[regtime]]'),(511,9,'simple','MS03-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(512,9,'simple','MS03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(513,9,'simple','MS03-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(514,9,'simple','MS03-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(515,9,'simple','MS03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(516,9,'simple','MS03-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(517,9,'simple','MS03-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(518,9,'simple','MS03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(519,9,'simple','MS03-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(520,9,'simple','MS03-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(521,9,'simple','MS03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(522,9,'simple','MS03-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(523,9,'simple','MS03-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(524,9,'simple','MS03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(525,9,'simple','MS03-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(526,9,'configurable','MS03',1,0,'[[regtime]]','[[regtime]]'),(527,9,'simple','MS06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(528,9,'simple','MS06-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(529,9,'simple','MS06-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(530,9,'simple','MS06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(531,9,'simple','MS06-S-Green',0,0,'[[regtime]]','[[regtime]]'),(532,9,'simple','MS06-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(533,9,'simple','MS06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(534,9,'simple','MS06-M-Green',0,0,'[[regtime]]','[[regtime]]'),(535,9,'simple','MS06-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(536,9,'simple','MS06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(537,9,'simple','MS06-L-Green',0,0,'[[regtime]]','[[regtime]]'),(538,9,'simple','MS06-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(539,9,'simple','MS06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(540,9,'simple','MS06-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(541,9,'simple','MS06-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(542,9,'configurable','MS06',1,0,'[[regtime]]','[[regtime]]'),(543,9,'simple','MS01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(544,9,'simple','MS01-XS-Brown',0,0,'[[regtime]]','[[regtime]]'),(545,9,'simple','MS01-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(546,9,'simple','MS01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(547,9,'simple','MS01-S-Brown',0,0,'[[regtime]]','[[regtime]]'),(548,9,'simple','MS01-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(549,9,'simple','MS01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(550,9,'simple','MS01-M-Brown',0,0,'[[regtime]]','[[regtime]]'),(551,9,'simple','MS01-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(552,9,'simple','MS01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(553,9,'simple','MS01-L-Brown',0,0,'[[regtime]]','[[regtime]]'),(554,9,'simple','MS01-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(555,9,'simple','MS01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(556,9,'simple','MS01-XL-Brown',0,0,'[[regtime]]','[[regtime]]'),(557,9,'simple','MS01-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(558,9,'configurable','MS01',1,0,'[[regtime]]','[[regtime]]'),(559,9,'simple','MS02-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(560,9,'simple','MS02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(561,9,'simple','MS02-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(562,9,'simple','MS02-S-Black',0,0,'[[regtime]]','[[regtime]]'),(563,9,'simple','MS02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(564,9,'simple','MS02-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(565,9,'simple','MS02-M-Black',0,0,'[[regtime]]','[[regtime]]'),(566,9,'simple','MS02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(567,9,'simple','MS02-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(568,9,'simple','MS02-L-Black',0,0,'[[regtime]]','[[regtime]]'),(569,9,'simple','MS02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(570,9,'simple','MS02-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(571,9,'simple','MS02-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(572,9,'simple','MS02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(573,9,'simple','MS02-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(574,9,'configurable','MS02',1,0,'[[regtime]]','[[regtime]]'),(575,9,'simple','MS10-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(576,9,'simple','MS10-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(577,9,'simple','MS10-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(578,9,'simple','MS10-S-Black',0,0,'[[regtime]]','[[regtime]]'),(579,9,'simple','MS10-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(580,9,'simple','MS10-S-Red',0,0,'[[regtime]]','[[regtime]]'),(581,9,'simple','MS10-M-Black',0,0,'[[regtime]]','[[regtime]]'),(582,9,'simple','MS10-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(583,9,'simple','MS10-M-Red',0,0,'[[regtime]]','[[regtime]]'),(584,9,'simple','MS10-L-Black',0,0,'[[regtime]]','[[regtime]]'),(585,9,'simple','MS10-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(586,9,'simple','MS10-L-Red',0,0,'[[regtime]]','[[regtime]]'),(587,9,'simple','MS10-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(588,9,'simple','MS10-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(589,9,'simple','MS10-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(590,9,'configurable','MS10',1,0,'[[regtime]]','[[regtime]]'),(591,9,'simple','MS07-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(592,9,'simple','MS07-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(593,9,'simple','MS07-XS-White',0,0,'[[regtime]]','[[regtime]]'),(594,9,'simple','MS07-S-Black',0,0,'[[regtime]]','[[regtime]]'),(595,9,'simple','MS07-S-Green',0,0,'[[regtime]]','[[regtime]]'),(596,9,'simple','MS07-S-White',0,0,'[[regtime]]','[[regtime]]'),(597,9,'simple','MS07-M-Black',0,0,'[[regtime]]','[[regtime]]'),(598,9,'simple','MS07-M-Green',0,0,'[[regtime]]','[[regtime]]'),(599,9,'simple','MS07-M-White',0,0,'[[regtime]]','[[regtime]]'),(600,9,'simple','MS07-L-Black',0,0,'[[regtime]]','[[regtime]]'),(601,9,'simple','MS07-L-Green',0,0,'[[regtime]]','[[regtime]]'),(602,9,'simple','MS07-L-White',0,0,'[[regtime]]','[[regtime]]'),(603,9,'simple','MS07-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(604,9,'simple','MS07-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(605,9,'simple','MS07-XL-White',0,0,'[[regtime]]','[[regtime]]'),(606,9,'configurable','MS07',1,0,'[[regtime]]','[[regtime]]'),(607,9,'simple','MS08-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(608,9,'simple','MS08-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(609,9,'simple','MS08-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(610,9,'simple','MS08-S-Black',0,0,'[[regtime]]','[[regtime]]'),(611,9,'simple','MS08-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(612,9,'simple','MS08-S-Red',0,0,'[[regtime]]','[[regtime]]'),(613,9,'simple','MS08-M-Black',0,0,'[[regtime]]','[[regtime]]'),(614,9,'simple','MS08-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(615,9,'simple','MS08-M-Red',0,0,'[[regtime]]','[[regtime]]'),(616,9,'simple','MS08-L-Black',0,0,'[[regtime]]','[[regtime]]'),(617,9,'simple','MS08-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(618,9,'simple','MS08-L-Red',0,0,'[[regtime]]','[[regtime]]'),(619,9,'simple','MS08-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(620,9,'simple','MS08-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(621,9,'simple','MS08-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(622,9,'configurable','MS08',1,0,'[[regtime]]','[[regtime]]'),(623,9,'simple','MT01-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(624,9,'simple','MT01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(625,9,'simple','MT01-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(626,9,'simple','MT01-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(627,9,'simple','MT01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(628,9,'simple','MT01-S-Red',0,0,'[[regtime]]','[[regtime]]'),(629,9,'simple','MT01-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(630,9,'simple','MT01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(631,9,'simple','MT01-M-Red',0,0,'[[regtime]]','[[regtime]]'),(632,9,'simple','MT01-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(633,9,'simple','MT01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(634,9,'simple','MT01-L-Red',0,0,'[[regtime]]','[[regtime]]'),(635,9,'simple','MT01-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(636,9,'simple','MT01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(637,9,'simple','MT01-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(638,9,'configurable','MT01',1,0,'[[regtime]]','[[regtime]]'),(639,9,'simple','MT02-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(640,9,'simple','MT02-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(641,9,'simple','MT02-XS-White',0,0,'[[regtime]]','[[regtime]]'),(642,9,'simple','MT02-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(643,9,'simple','MT02-S-Red',0,0,'[[regtime]]','[[regtime]]'),(644,9,'simple','MT02-S-White',0,0,'[[regtime]]','[[regtime]]'),(645,9,'simple','MT02-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(646,9,'simple','MT02-M-Red',0,0,'[[regtime]]','[[regtime]]'),(647,9,'simple','MT02-M-White',0,0,'[[regtime]]','[[regtime]]'),(648,9,'simple','MT02-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(649,9,'simple','MT02-L-Red',0,0,'[[regtime]]','[[regtime]]'),(650,9,'simple','MT02-L-White',0,0,'[[regtime]]','[[regtime]]'),(651,9,'simple','MT02-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(652,9,'simple','MT02-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(653,9,'simple','MT02-XL-White',0,0,'[[regtime]]','[[regtime]]'),(654,9,'configurable','MT02',1,0,'[[regtime]]','[[regtime]]'),(655,9,'simple','MT03-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(656,9,'simple','MT03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(657,9,'simple','MT03-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(658,9,'simple','MT03-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(659,9,'simple','MT03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(660,9,'simple','MT03-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(661,9,'simple','MT03-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(662,9,'simple','MT03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(663,9,'simple','MT03-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(664,9,'simple','MT03-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(665,9,'simple','MT03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(666,9,'simple','MT03-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(667,9,'simple','MT03-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(668,9,'simple','MT03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(669,9,'simple','MT03-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(670,9,'configurable','MT03',1,0,'[[regtime]]','[[regtime]]'),(671,9,'simple','MT04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(672,9,'simple','MT04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(673,9,'simple','MT04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(674,9,'simple','MT04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(675,9,'simple','MT04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(676,9,'configurable','MT04',1,0,'[[regtime]]','[[regtime]]'),(677,9,'simple','MT05-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(678,9,'simple','MT05-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(679,9,'simple','MT05-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(680,9,'simple','MT05-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(681,9,'simple','MT05-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(682,9,'configurable','MT05',1,0,'[[regtime]]','[[regtime]]'),(683,9,'simple','MT06-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(684,9,'simple','MT06-S-Black',0,0,'[[regtime]]','[[regtime]]'),(685,9,'simple','MT06-M-Black',0,0,'[[regtime]]','[[regtime]]'),(686,9,'simple','MT06-L-Black',0,0,'[[regtime]]','[[regtime]]'),(687,9,'simple','MT06-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(688,9,'configurable','MT06',1,0,'[[regtime]]','[[regtime]]'),(689,9,'simple','MT07-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(690,9,'simple','MT07-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(691,9,'simple','MT07-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(692,9,'simple','MT07-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(693,9,'simple','MT07-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(694,9,'configurable','MT07',1,0,'[[regtime]]','[[regtime]]'),(695,9,'simple','MT08-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(696,9,'simple','MT08-S-Green',0,0,'[[regtime]]','[[regtime]]'),(697,9,'simple','MT08-M-Green',0,0,'[[regtime]]','[[regtime]]'),(698,9,'simple','MT08-L-Green',0,0,'[[regtime]]','[[regtime]]'),(699,9,'simple','MT08-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(700,9,'configurable','MT08',1,0,'[[regtime]]','[[regtime]]'),(701,9,'simple','MT09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(702,9,'simple','MT09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(703,9,'simple','MT09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(704,9,'simple','MT09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(705,9,'simple','MT09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(706,9,'configurable','MT09',1,0,'[[regtime]]','[[regtime]]'),(707,9,'simple','MT10-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(708,9,'simple','MT10-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(709,9,'simple','MT10-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(710,9,'simple','MT10-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(711,9,'simple','MT10-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(712,9,'configurable','MT10',1,0,'[[regtime]]','[[regtime]]'),(713,9,'simple','MT11-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(714,9,'simple','MT11-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(715,9,'simple','MT11-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(716,9,'simple','MT11-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(717,9,'simple','MT11-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(718,9,'configurable','MT11',1,0,'[[regtime]]','[[regtime]]'),(719,9,'simple','MT12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(720,9,'simple','MT12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(721,9,'simple','MT12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(722,9,'simple','MT12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(723,9,'simple','MT12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(724,9,'configurable','MT12',1,0,'[[regtime]]','[[regtime]]'),(725,10,'simple','MP01-32-Black',0,0,'[[regtime]]','[[regtime]]'),(726,10,'simple','MP01-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(727,10,'simple','MP01-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(728,10,'simple','MP01-33-Black',0,0,'[[regtime]]','[[regtime]]'),(729,10,'simple','MP01-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(730,10,'simple','MP01-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(731,10,'simple','MP01-34-Black',0,0,'[[regtime]]','[[regtime]]'),(732,10,'simple','MP01-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(733,10,'simple','MP01-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(734,10,'simple','MP01-36-Black',0,0,'[[regtime]]','[[regtime]]'),(735,10,'simple','MP01-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(736,10,'simple','MP01-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(737,10,'configurable','MP01',1,0,'[[regtime]]','[[regtime]]'),(738,10,'simple','MP02-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(739,10,'simple','MP02-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(740,10,'simple','MP02-32-Red',0,0,'[[regtime]]','[[regtime]]'),(741,10,'simple','MP02-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(742,10,'simple','MP02-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(743,10,'simple','MP02-33-Red',0,0,'[[regtime]]','[[regtime]]'),(744,10,'simple','MP02-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(745,10,'simple','MP02-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(746,10,'simple','MP02-34-Red',0,0,'[[regtime]]','[[regtime]]'),(747,10,'simple','MP02-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(748,10,'simple','MP02-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(749,10,'simple','MP02-36-Red',0,0,'[[regtime]]','[[regtime]]'),(750,10,'configurable','MP02',1,0,'[[regtime]]','[[regtime]]'),(751,10,'simple','MP03-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(752,10,'simple','MP03-32-Green',0,0,'[[regtime]]','[[regtime]]'),(753,10,'simple','MP03-32-Red',0,0,'[[regtime]]','[[regtime]]'),(754,10,'simple','MP03-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(755,10,'simple','MP03-33-Green',0,0,'[[regtime]]','[[regtime]]'),(756,10,'simple','MP03-33-Red',0,0,'[[regtime]]','[[regtime]]'),(757,10,'simple','MP03-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(758,10,'simple','MP03-34-Green',0,0,'[[regtime]]','[[regtime]]'),(759,10,'simple','MP03-34-Red',0,0,'[[regtime]]','[[regtime]]'),(760,10,'simple','MP03-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(761,10,'simple','MP03-36-Green',0,0,'[[regtime]]','[[regtime]]'),(762,10,'simple','MP03-36-Red',0,0,'[[regtime]]','[[regtime]]'),(763,10,'configurable','MP03',1,0,'[[regtime]]','[[regtime]]'),(764,10,'simple','MP04-32-Black',0,0,'[[regtime]]','[[regtime]]'),(765,10,'simple','MP04-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(766,10,'simple','MP04-32-Green',0,0,'[[regtime]]','[[regtime]]'),(767,10,'simple','MP04-33-Black',0,0,'[[regtime]]','[[regtime]]'),(768,10,'simple','MP04-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(769,10,'simple','MP04-33-Green',0,0,'[[regtime]]','[[regtime]]'),(770,10,'simple','MP04-34-Black',0,0,'[[regtime]]','[[regtime]]'),(771,10,'simple','MP04-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(772,10,'simple','MP04-34-Green',0,0,'[[regtime]]','[[regtime]]'),(773,10,'simple','MP04-36-Black',0,0,'[[regtime]]','[[regtime]]'),(774,10,'simple','MP04-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(775,10,'simple','MP04-36-Green',0,0,'[[regtime]]','[[regtime]]'),(776,10,'configurable','MP04',1,0,'[[regtime]]','[[regtime]]'),(777,10,'simple','MP05-32-Black',0,0,'[[regtime]]','[[regtime]]'),(778,10,'simple','MP05-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(779,10,'simple','MP05-32-Green',0,0,'[[regtime]]','[[regtime]]'),(780,10,'simple','MP05-33-Black',0,0,'[[regtime]]','[[regtime]]'),(781,10,'simple','MP05-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(782,10,'simple','MP05-33-Green',0,0,'[[regtime]]','[[regtime]]'),(783,10,'simple','MP05-34-Black',0,0,'[[regtime]]','[[regtime]]'),(784,10,'simple','MP05-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(785,10,'simple','MP05-34-Green',0,0,'[[regtime]]','[[regtime]]'),(786,10,'simple','MP05-36-Black',0,0,'[[regtime]]','[[regtime]]'),(787,10,'simple','MP05-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(788,10,'simple','MP05-36-Green',0,0,'[[regtime]]','[[regtime]]'),(789,10,'configurable','MP05',1,0,'[[regtime]]','[[regtime]]'),(790,10,'simple','MP06-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(791,10,'simple','MP06-32-Green',0,0,'[[regtime]]','[[regtime]]'),(792,10,'simple','MP06-32-Orange',0,0,'[[regtime]]','[[regtime]]'),(793,10,'simple','MP06-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(794,10,'simple','MP06-33-Green',0,0,'[[regtime]]','[[regtime]]'),(795,10,'simple','MP06-33-Orange',0,0,'[[regtime]]','[[regtime]]'),(796,10,'simple','MP06-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(797,10,'simple','MP06-34-Green',0,0,'[[regtime]]','[[regtime]]'),(798,10,'simple','MP06-34-Orange',0,0,'[[regtime]]','[[regtime]]'),(799,10,'simple','MP06-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(800,10,'simple','MP06-36-Green',0,0,'[[regtime]]','[[regtime]]'),(801,10,'simple','MP06-36-Orange',0,0,'[[regtime]]','[[regtime]]'),(802,10,'configurable','MP06',1,0,'[[regtime]]','[[regtime]]'),(803,10,'simple','MP07-32-Black',0,0,'[[regtime]]','[[regtime]]'),(804,10,'simple','MP07-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(805,10,'simple','MP07-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(806,10,'simple','MP07-33-Black',0,0,'[[regtime]]','[[regtime]]'),(807,10,'simple','MP07-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(808,10,'simple','MP07-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(809,10,'simple','MP07-34-Black',0,0,'[[regtime]]','[[regtime]]'),(810,10,'simple','MP07-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(811,10,'simple','MP07-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(812,10,'simple','MP07-36-Black',0,0,'[[regtime]]','[[regtime]]'),(813,10,'simple','MP07-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(814,10,'simple','MP07-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(815,10,'configurable','MP07',1,0,'[[regtime]]','[[regtime]]'),(816,10,'simple','MP08-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(817,10,'simple','MP08-32-Green',0,0,'[[regtime]]','[[regtime]]'),(818,10,'simple','MP08-32-Red',0,0,'[[regtime]]','[[regtime]]'),(819,10,'simple','MP08-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(820,10,'simple','MP08-33-Green',0,0,'[[regtime]]','[[regtime]]'),(821,10,'simple','MP08-33-Red',0,0,'[[regtime]]','[[regtime]]'),(822,10,'simple','MP08-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(823,10,'simple','MP08-34-Green',0,0,'[[regtime]]','[[regtime]]'),(824,10,'simple','MP08-34-Red',0,0,'[[regtime]]','[[regtime]]'),(825,10,'simple','MP08-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(826,10,'simple','MP08-36-Green',0,0,'[[regtime]]','[[regtime]]'),(827,10,'simple','MP08-36-Red',0,0,'[[regtime]]','[[regtime]]'),(828,10,'configurable','MP08',1,0,'[[regtime]]','[[regtime]]'),(829,10,'simple','MP09-32-Black',0,0,'[[regtime]]','[[regtime]]'),(830,10,'simple','MP09-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(831,10,'simple','MP09-32-Red',0,0,'[[regtime]]','[[regtime]]'),(832,10,'simple','MP09-33-Black',0,0,'[[regtime]]','[[regtime]]'),(833,10,'simple','MP09-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(834,10,'simple','MP09-33-Red',0,0,'[[regtime]]','[[regtime]]'),(835,10,'simple','MP09-34-Black',0,0,'[[regtime]]','[[regtime]]'),(836,10,'simple','MP09-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(837,10,'simple','MP09-34-Red',0,0,'[[regtime]]','[[regtime]]'),(838,10,'simple','MP09-36-Black',0,0,'[[regtime]]','[[regtime]]'),(839,10,'simple','MP09-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(840,10,'simple','MP09-36-Red',0,0,'[[regtime]]','[[regtime]]'),(841,10,'configurable','MP09',1,0,'[[regtime]]','[[regtime]]'),(842,10,'simple','MP10-32-Black',0,0,'[[regtime]]','[[regtime]]'),(843,10,'simple','MP10-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(844,10,'simple','MP10-32-Green',0,0,'[[regtime]]','[[regtime]]'),(845,10,'simple','MP10-33-Black',0,0,'[[regtime]]','[[regtime]]'),(846,10,'simple','MP10-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(847,10,'simple','MP10-33-Green',0,0,'[[regtime]]','[[regtime]]'),(848,10,'simple','MP10-34-Black',0,0,'[[regtime]]','[[regtime]]'),(849,10,'simple','MP10-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(850,10,'simple','MP10-34-Green',0,0,'[[regtime]]','[[regtime]]'),(851,10,'simple','MP10-36-Black',0,0,'[[regtime]]','[[regtime]]'),(852,10,'simple','MP10-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(853,10,'simple','MP10-36-Green',0,0,'[[regtime]]','[[regtime]]'),(854,10,'configurable','MP10',1,0,'[[regtime]]','[[regtime]]'),(855,10,'simple','MP11-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(856,10,'simple','MP11-32-Brown',0,0,'[[regtime]]','[[regtime]]'),(857,10,'simple','MP11-32-Green',0,0,'[[regtime]]','[[regtime]]'),(858,10,'simple','MP11-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(859,10,'simple','MP11-33-Brown',0,0,'[[regtime]]','[[regtime]]'),(860,10,'simple','MP11-33-Green',0,0,'[[regtime]]','[[regtime]]'),(861,10,'simple','MP11-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(862,10,'simple','MP11-34-Brown',0,0,'[[regtime]]','[[regtime]]'),(863,10,'simple','MP11-34-Green',0,0,'[[regtime]]','[[regtime]]'),(864,10,'simple','MP11-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(865,10,'simple','MP11-36-Brown',0,0,'[[regtime]]','[[regtime]]'),(866,10,'simple','MP11-36-Green',0,0,'[[regtime]]','[[regtime]]'),(867,10,'configurable','MP11',1,0,'[[regtime]]','[[regtime]]'),(868,10,'simple','MP12-32-Black',0,0,'[[regtime]]','[[regtime]]'),(869,10,'simple','MP12-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(870,10,'simple','MP12-32-Red',0,0,'[[regtime]]','[[regtime]]'),(871,10,'simple','MP12-33-Black',0,0,'[[regtime]]','[[regtime]]'),(872,10,'simple','MP12-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(873,10,'simple','MP12-33-Red',0,0,'[[regtime]]','[[regtime]]'),(874,10,'simple','MP12-34-Black',0,0,'[[regtime]]','[[regtime]]'),(875,10,'simple','MP12-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(876,10,'simple','MP12-34-Red',0,0,'[[regtime]]','[[regtime]]'),(877,10,'simple','MP12-36-Black',0,0,'[[regtime]]','[[regtime]]'),(878,10,'simple','MP12-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(879,10,'simple','MP12-36-Red',0,0,'[[regtime]]','[[regtime]]'),(880,10,'configurable','MP12',1,0,'[[regtime]]','[[regtime]]'),(881,10,'simple','MSH01-32-Black',0,0,'[[regtime]]','[[regtime]]'),(882,10,'simple','MSH01-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(883,10,'simple','MSH01-32-Red',0,0,'[[regtime]]','[[regtime]]'),(884,10,'simple','MSH01-33-Black',0,0,'[[regtime]]','[[regtime]]'),(885,10,'simple','MSH01-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(886,10,'simple','MSH01-33-Red',0,0,'[[regtime]]','[[regtime]]'),(887,10,'simple','MSH01-34-Black',0,0,'[[regtime]]','[[regtime]]'),(888,10,'simple','MSH01-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(889,10,'simple','MSH01-34-Red',0,0,'[[regtime]]','[[regtime]]'),(890,10,'simple','MSH01-36-Black',0,0,'[[regtime]]','[[regtime]]'),(891,10,'simple','MSH01-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(892,10,'simple','MSH01-36-Red',0,0,'[[regtime]]','[[regtime]]'),(893,10,'configurable','MSH01',1,0,'[[regtime]]','[[regtime]]'),(894,10,'simple','MSH02-32-Black',0,0,'[[regtime]]','[[regtime]]'),(895,10,'simple','MSH02-33-Black',0,0,'[[regtime]]','[[regtime]]'),(896,10,'simple','MSH02-34-Black',0,0,'[[regtime]]','[[regtime]]'),(897,10,'simple','MSH02-36-Black',0,0,'[[regtime]]','[[regtime]]'),(898,10,'configurable','MSH02',1,0,'[[regtime]]','[[regtime]]'),(899,10,'simple','MSH03-32-Black',0,0,'[[regtime]]','[[regtime]]'),(900,10,'simple','MSH03-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(901,10,'simple','MSH03-32-Green',0,0,'[[regtime]]','[[regtime]]'),(902,10,'simple','MSH03-33-Black',0,0,'[[regtime]]','[[regtime]]'),(903,10,'simple','MSH03-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(904,10,'simple','MSH03-33-Green',0,0,'[[regtime]]','[[regtime]]'),(905,10,'simple','MSH03-34-Black',0,0,'[[regtime]]','[[regtime]]'),(906,10,'simple','MSH03-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(907,10,'simple','MSH03-34-Green',0,0,'[[regtime]]','[[regtime]]'),(908,10,'simple','MSH03-36-Black',0,0,'[[regtime]]','[[regtime]]'),(909,10,'simple','MSH03-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(910,10,'simple','MSH03-36-Green',0,0,'[[regtime]]','[[regtime]]'),(911,10,'configurable','MSH03',1,0,'[[regtime]]','[[regtime]]'),(912,10,'simple','MSH04-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(913,10,'simple','MSH04-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(914,10,'simple','MSH04-32-Yellow',0,0,'[[regtime]]','[[regtime]]'),(915,10,'simple','MSH04-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(916,10,'simple','MSH04-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(917,10,'simple','MSH04-33-Yellow',0,0,'[[regtime]]','[[regtime]]'),(918,10,'simple','MSH04-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(919,10,'simple','MSH04-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(920,10,'simple','MSH04-34-Yellow',0,0,'[[regtime]]','[[regtime]]'),(921,10,'simple','MSH04-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(922,10,'simple','MSH04-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(923,10,'simple','MSH04-36-Yellow',0,0,'[[regtime]]','[[regtime]]'),(924,10,'configurable','MSH04',1,0,'[[regtime]]','[[regtime]]'),(925,10,'simple','MSH05-32-Black',0,0,'[[regtime]]','[[regtime]]'),(926,10,'simple','MSH05-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(927,10,'simple','MSH05-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(928,10,'simple','MSH05-33-Black',0,0,'[[regtime]]','[[regtime]]'),(929,10,'simple','MSH05-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(930,10,'simple','MSH05-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(931,10,'simple','MSH05-34-Black',0,0,'[[regtime]]','[[regtime]]'),(932,10,'simple','MSH05-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(933,10,'simple','MSH05-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(934,10,'simple','MSH05-36-Black',0,0,'[[regtime]]','[[regtime]]'),(935,10,'simple','MSH05-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(936,10,'simple','MSH05-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(937,10,'configurable','MSH05',1,0,'[[regtime]]','[[regtime]]'),(938,10,'simple','MSH06-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(939,10,'simple','MSH06-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(940,10,'simple','MSH06-32-Red',0,0,'[[regtime]]','[[regtime]]'),(941,10,'simple','MSH06-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(942,10,'simple','MSH06-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(943,10,'simple','MSH06-33-Red',0,0,'[[regtime]]','[[regtime]]'),(944,10,'simple','MSH06-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(945,10,'simple','MSH06-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(946,10,'simple','MSH06-34-Red',0,0,'[[regtime]]','[[regtime]]'),(947,10,'simple','MSH06-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(948,10,'simple','MSH06-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(949,10,'simple','MSH06-36-Red',0,0,'[[regtime]]','[[regtime]]'),(950,10,'configurable','MSH06',1,0,'[[regtime]]','[[regtime]]'),(951,10,'simple','MSH07-32-Black',0,0,'[[regtime]]','[[regtime]]'),(952,10,'simple','MSH07-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(953,10,'simple','MSH07-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(954,10,'simple','MSH07-33-Black',0,0,'[[regtime]]','[[regtime]]'),(955,10,'simple','MSH07-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(956,10,'simple','MSH07-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(957,10,'simple','MSH07-34-Black',0,0,'[[regtime]]','[[regtime]]'),(958,10,'simple','MSH07-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(959,10,'simple','MSH07-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(960,10,'simple','MSH07-36-Black',0,0,'[[regtime]]','[[regtime]]'),(961,10,'simple','MSH07-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(962,10,'simple','MSH07-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(963,10,'configurable','MSH07',1,0,'[[regtime]]','[[regtime]]'),(964,10,'simple','MSH08-32-Black',0,0,'[[regtime]]','[[regtime]]'),(965,10,'simple','MSH08-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(966,10,'simple','MSH08-32-Green',0,0,'[[regtime]]','[[regtime]]'),(967,10,'simple','MSH08-33-Black',0,0,'[[regtime]]','[[regtime]]'),(968,10,'simple','MSH08-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(969,10,'simple','MSH08-33-Green',0,0,'[[regtime]]','[[regtime]]'),(970,10,'simple','MSH08-34-Black',0,0,'[[regtime]]','[[regtime]]'),(971,10,'simple','MSH08-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(972,10,'simple','MSH08-34-Green',0,0,'[[regtime]]','[[regtime]]'),(973,10,'simple','MSH08-36-Black',0,0,'[[regtime]]','[[regtime]]'),(974,10,'simple','MSH08-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(975,10,'simple','MSH08-36-Green',0,0,'[[regtime]]','[[regtime]]'),(976,10,'configurable','MSH08',1,0,'[[regtime]]','[[regtime]]'),(977,10,'simple','MSH09-32-Black',0,0,'[[regtime]]','[[regtime]]'),(978,10,'simple','MSH09-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(979,10,'simple','MSH09-32-Green',0,0,'[[regtime]]','[[regtime]]'),(980,10,'simple','MSH09-33-Black',0,0,'[[regtime]]','[[regtime]]'),(981,10,'simple','MSH09-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(982,10,'simple','MSH09-33-Green',0,0,'[[regtime]]','[[regtime]]'),(983,10,'simple','MSH09-34-Black',0,0,'[[regtime]]','[[regtime]]'),(984,10,'simple','MSH09-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(985,10,'simple','MSH09-34-Green',0,0,'[[regtime]]','[[regtime]]'),(986,10,'simple','MSH09-36-Black',0,0,'[[regtime]]','[[regtime]]'),(987,10,'simple','MSH09-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(988,10,'simple','MSH09-36-Green',0,0,'[[regtime]]','[[regtime]]'),(989,10,'configurable','MSH09',1,0,'[[regtime]]','[[regtime]]'),(990,10,'simple','MSH10-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(991,10,'simple','MSH10-32-Green',0,0,'[[regtime]]','[[regtime]]'),(992,10,'simple','MSH10-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(993,10,'simple','MSH10-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(994,10,'simple','MSH10-33-Green',0,0,'[[regtime]]','[[regtime]]'),(995,10,'simple','MSH10-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(996,10,'simple','MSH10-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(997,10,'simple','MSH10-34-Green',0,0,'[[regtime]]','[[regtime]]'),(998,10,'simple','MSH10-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(999,10,'simple','MSH10-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(1000,10,'simple','MSH10-36-Green',0,0,'[[regtime]]','[[regtime]]'),(1001,10,'simple','MSH10-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(1002,10,'configurable','MSH10',1,0,'[[regtime]]','[[regtime]]'),(1003,10,'simple','MSH11-32-Black',0,0,'[[regtime]]','[[regtime]]'),(1004,10,'simple','MSH11-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(1005,10,'simple','MSH11-32-Red',0,0,'[[regtime]]','[[regtime]]'),(1006,10,'simple','MSH11-33-Black',0,0,'[[regtime]]','[[regtime]]'),(1007,10,'simple','MSH11-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(1008,10,'simple','MSH11-33-Red',0,0,'[[regtime]]','[[regtime]]'),(1009,10,'simple','MSH11-34-Black',0,0,'[[regtime]]','[[regtime]]'),(1010,10,'simple','MSH11-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(1011,10,'simple','MSH11-34-Red',0,0,'[[regtime]]','[[regtime]]'),(1012,10,'simple','MSH11-36-Black',0,0,'[[regtime]]','[[regtime]]'),(1013,10,'simple','MSH11-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(1014,10,'simple','MSH11-36-Red',0,0,'[[regtime]]','[[regtime]]'),(1015,10,'configurable','MSH11',1,0,'[[regtime]]','[[regtime]]'),(1016,10,'simple','MSH12-32-Black',0,0,'[[regtime]]','[[regtime]]'),(1017,10,'simple','MSH12-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(1018,10,'simple','MSH12-32-Red',0,0,'[[regtime]]','[[regtime]]'),(1019,10,'simple','MSH12-33-Black',0,0,'[[regtime]]','[[regtime]]'),(1020,10,'simple','MSH12-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(1021,10,'simple','MSH12-33-Red',0,0,'[[regtime]]','[[regtime]]'),(1022,10,'simple','MSH12-34-Black',0,0,'[[regtime]]','[[regtime]]'),(1023,10,'simple','MSH12-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(1024,10,'simple','MSH12-34-Red',0,0,'[[regtime]]','[[regtime]]'),(1025,10,'simple','MSH12-36-Black',0,0,'[[regtime]]','[[regtime]]'),(1026,10,'simple','MSH12-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(1027,10,'simple','MSH12-36-Red',0,0,'[[regtime]]','[[regtime]]'),(1028,10,'configurable','MSH12',1,0,'[[regtime]]','[[regtime]]'),(1029,9,'simple','WH01-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1030,9,'simple','WH01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1031,9,'simple','WH01-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1032,9,'simple','WH01-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1033,9,'simple','WH01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1034,9,'simple','WH01-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1035,9,'simple','WH01-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1036,9,'simple','WH01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1037,9,'simple','WH01-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1038,9,'simple','WH01-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1039,9,'simple','WH01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1040,9,'simple','WH01-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1041,9,'simple','WH01-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1042,9,'simple','WH01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1043,9,'simple','WH01-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1044,9,'configurable','WH01',1,0,'[[regtime]]','[[regtime]]'),(1045,9,'simple','WH02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1046,9,'simple','WH02-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1047,9,'simple','WH02-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1048,9,'simple','WH02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1049,9,'simple','WH02-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1050,9,'simple','WH02-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1051,9,'simple','WH02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1052,9,'simple','WH02-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1053,9,'simple','WH02-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1054,9,'simple','WH02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1055,9,'simple','WH02-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1056,9,'simple','WH02-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1057,9,'simple','WH02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1058,9,'simple','WH02-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1059,9,'simple','WH02-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1060,9,'configurable','WH02',1,0,'[[regtime]]','[[regtime]]'),(1061,9,'simple','WH03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1062,9,'simple','WH03-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1063,9,'simple','WH03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1064,9,'simple','WH03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1065,9,'simple','WH03-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1066,9,'simple','WH03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1067,9,'simple','WH03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1068,9,'simple','WH03-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1069,9,'simple','WH03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1070,9,'simple','WH03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1071,9,'simple','WH03-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1072,9,'simple','WH03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1073,9,'simple','WH03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1074,9,'simple','WH03-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1075,9,'simple','WH03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1076,9,'configurable','WH03',1,0,'[[regtime]]','[[regtime]]'),(1077,9,'simple','WH04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1078,9,'simple','WH04-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1079,9,'simple','WH04-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1080,9,'simple','WH04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1081,9,'simple','WH04-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1082,9,'simple','WH04-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1083,9,'simple','WH04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1084,9,'simple','WH04-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1085,9,'simple','WH04-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1086,9,'simple','WH04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1087,9,'simple','WH04-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1088,9,'simple','WH04-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1089,9,'simple','WH04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1090,9,'simple','WH04-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1091,9,'simple','WH04-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1092,9,'configurable','WH04',1,0,'[[regtime]]','[[regtime]]'),(1093,9,'simple','WH05-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1094,9,'simple','WH05-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1095,9,'simple','WH05-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1096,9,'simple','WH05-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1097,9,'simple','WH05-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1098,9,'simple','WH05-S-White',0,0,'[[regtime]]','[[regtime]]'),(1099,9,'simple','WH05-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1100,9,'simple','WH05-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1101,9,'simple','WH05-M-White',0,0,'[[regtime]]','[[regtime]]'),(1102,9,'simple','WH05-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1103,9,'simple','WH05-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1104,9,'simple','WH05-L-White',0,0,'[[regtime]]','[[regtime]]'),(1105,9,'simple','WH05-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1106,9,'simple','WH05-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1107,9,'simple','WH05-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1108,9,'configurable','WH05',1,0,'[[regtime]]','[[regtime]]'),(1109,9,'simple','WH06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1110,9,'simple','WH06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1111,9,'simple','WH06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1112,9,'simple','WH06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1113,9,'simple','WH06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1114,9,'configurable','WH06',1,0,'[[regtime]]','[[regtime]]'),(1115,9,'simple','WH07-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1116,9,'simple','WH07-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1117,9,'simple','WH07-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1118,9,'simple','WH07-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1119,9,'simple','WH07-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1120,9,'simple','WH07-S-White',0,0,'[[regtime]]','[[regtime]]'),(1121,9,'simple','WH07-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1122,9,'simple','WH07-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1123,9,'simple','WH07-M-White',0,0,'[[regtime]]','[[regtime]]'),(1124,9,'simple','WH07-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1125,9,'simple','WH07-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1126,9,'simple','WH07-L-White',0,0,'[[regtime]]','[[regtime]]'),(1127,9,'simple','WH07-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1128,9,'simple','WH07-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1129,9,'simple','WH07-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1130,9,'configurable','WH07',1,0,'[[regtime]]','[[regtime]]'),(1131,9,'simple','WH08-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1132,9,'simple','WH08-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1133,9,'simple','WH08-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1134,9,'simple','WH08-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1135,9,'simple','WH08-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1136,9,'simple','WH08-S-White',0,0,'[[regtime]]','[[regtime]]'),(1137,9,'simple','WH08-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1138,9,'simple','WH08-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1139,9,'simple','WH08-M-White',0,0,'[[regtime]]','[[regtime]]'),(1140,9,'simple','WH08-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1141,9,'simple','WH08-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1142,9,'simple','WH08-L-White',0,0,'[[regtime]]','[[regtime]]'),(1143,9,'simple','WH08-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1144,9,'simple','WH08-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1145,9,'simple','WH08-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1146,9,'configurable','WH08',1,0,'[[regtime]]','[[regtime]]'),(1147,9,'simple','WH09-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1148,9,'simple','WH09-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1149,9,'simple','WH09-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1150,9,'simple','WH09-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1151,9,'simple','WH09-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1152,9,'simple','WH09-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1153,9,'simple','WH09-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1154,9,'simple','WH09-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1155,9,'simple','WH09-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1156,9,'simple','WH09-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1157,9,'simple','WH09-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1158,9,'simple','WH09-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1159,9,'simple','WH09-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1160,9,'simple','WH09-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1161,9,'simple','WH09-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1162,9,'configurable','WH09',1,0,'[[regtime]]','[[regtime]]'),(1163,9,'simple','WH10-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1164,9,'simple','WH10-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1165,9,'simple','WH10-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1166,9,'simple','WH10-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1167,9,'simple','WH10-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1168,9,'simple','WH10-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1169,9,'simple','WH10-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1170,9,'simple','WH10-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1171,9,'simple','WH10-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1172,9,'simple','WH10-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1173,9,'simple','WH10-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1174,9,'simple','WH10-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1175,9,'simple','WH10-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1176,9,'simple','WH10-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1177,9,'simple','WH10-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1178,9,'configurable','WH10',1,0,'[[regtime]]','[[regtime]]'),(1179,9,'simple','WH11-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1180,9,'simple','WH11-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1181,9,'simple','WH11-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1182,9,'simple','WH11-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1183,9,'simple','WH11-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1184,9,'simple','WH11-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1185,9,'simple','WH11-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1186,9,'simple','WH11-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1187,9,'simple','WH11-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1188,9,'simple','WH11-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1189,9,'simple','WH11-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1190,9,'simple','WH11-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1191,9,'simple','WH11-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1192,9,'simple','WH11-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1193,9,'simple','WH11-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1194,9,'configurable','WH11',1,0,'[[regtime]]','[[regtime]]'),(1195,9,'simple','WH12-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1196,9,'simple','WH12-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1197,9,'simple','WH12-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1198,9,'simple','WH12-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1199,9,'simple','WH12-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1200,9,'simple','WH12-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1201,9,'simple','WH12-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1202,9,'simple','WH12-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1203,9,'simple','WH12-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1204,9,'simple','WH12-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1205,9,'simple','WH12-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1206,9,'simple','WH12-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1207,9,'simple','WH12-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1208,9,'simple','WH12-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1209,9,'simple','WH12-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1210,9,'configurable','WH12',1,0,'[[regtime]]','[[regtime]]'),(1211,9,'simple','WJ01-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1212,9,'simple','WJ01-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1213,9,'simple','WJ01-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1214,9,'simple','WJ01-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1215,9,'simple','WJ01-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1216,9,'simple','WJ01-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1217,9,'simple','WJ01-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1218,9,'simple','WJ01-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1219,9,'simple','WJ01-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1220,9,'configurable','WJ01',1,0,'[[regtime]]','[[regtime]]'),(1221,9,'simple','WJ02-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1222,9,'simple','WJ02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1223,9,'simple','WJ02-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1224,9,'simple','WJ02-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1225,9,'simple','WJ02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1226,9,'simple','WJ02-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1227,9,'simple','WJ02-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1228,9,'simple','WJ02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1229,9,'simple','WJ02-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1230,9,'simple','WJ02-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1231,9,'simple','WJ02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1232,9,'simple','WJ02-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1233,9,'simple','WJ02-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1234,9,'simple','WJ02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1235,9,'simple','WJ02-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1236,9,'configurable','WJ02',1,0,'[[regtime]]','[[regtime]]'),(1237,9,'simple','WJ03-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1238,9,'simple','WJ03-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1239,9,'simple','WJ03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1240,9,'simple','WJ03-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1241,9,'simple','WJ03-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1242,9,'simple','WJ03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1243,9,'simple','WJ03-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1244,9,'simple','WJ03-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1245,9,'simple','WJ03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1246,9,'simple','WJ03-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1247,9,'simple','WJ03-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1248,9,'simple','WJ03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1249,9,'simple','WJ03-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1250,9,'simple','WJ03-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1251,9,'simple','WJ03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1252,9,'configurable','WJ03',1,0,'[[regtime]]','[[regtime]]'),(1253,9,'simple','WJ04-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1254,9,'simple','WJ04-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1255,9,'simple','WJ04-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1256,9,'simple','WJ04-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1257,9,'simple','WJ04-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1258,9,'simple','WJ04-S-White',0,0,'[[regtime]]','[[regtime]]'),(1259,9,'simple','WJ04-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1260,9,'simple','WJ04-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1261,9,'simple','WJ04-M-White',0,0,'[[regtime]]','[[regtime]]'),(1262,9,'simple','WJ04-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1263,9,'simple','WJ04-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1264,9,'simple','WJ04-L-White',0,0,'[[regtime]]','[[regtime]]'),(1265,9,'simple','WJ04-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1266,9,'simple','WJ04-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1267,9,'simple','WJ04-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1268,9,'configurable','WJ04',1,0,'[[regtime]]','[[regtime]]'),(1269,9,'simple','WJ05-XS-Brown',0,0,'[[regtime]]','[[regtime]]'),(1270,9,'simple','WJ05-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1271,9,'simple','WJ05-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1272,9,'simple','WJ05-S-Brown',0,0,'[[regtime]]','[[regtime]]'),(1273,9,'simple','WJ05-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1274,9,'simple','WJ05-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1275,9,'simple','WJ05-M-Brown',0,0,'[[regtime]]','[[regtime]]'),(1276,9,'simple','WJ05-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1277,9,'simple','WJ05-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1278,9,'simple','WJ05-L-Brown',0,0,'[[regtime]]','[[regtime]]'),(1279,9,'simple','WJ05-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1280,9,'simple','WJ05-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1281,9,'simple','WJ05-XL-Brown',0,0,'[[regtime]]','[[regtime]]'),(1282,9,'simple','WJ05-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1283,9,'simple','WJ05-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1284,9,'configurable','WJ05',1,0,'[[regtime]]','[[regtime]]'),(1285,9,'simple','WJ07-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1286,9,'simple','WJ07-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1287,9,'simple','WJ07-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1288,9,'simple','WJ07-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1289,9,'simple','WJ07-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1290,9,'simple','WJ07-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1291,9,'simple','WJ07-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1292,9,'simple','WJ07-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1293,9,'simple','WJ07-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1294,9,'simple','WJ07-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1295,9,'simple','WJ07-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1296,9,'simple','WJ07-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1297,9,'simple','WJ07-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1298,9,'simple','WJ07-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1299,9,'simple','WJ07-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1300,9,'configurable','WJ07',1,0,'[[regtime]]','[[regtime]]'),(1301,9,'simple','WJ08-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1302,9,'simple','WJ08-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1303,9,'simple','WJ08-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1304,9,'simple','WJ08-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1305,9,'simple','WJ08-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1306,9,'simple','WJ08-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1307,9,'simple','WJ08-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1308,9,'simple','WJ08-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1309,9,'simple','WJ08-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1310,9,'simple','WJ08-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1311,9,'simple','WJ08-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1312,9,'simple','WJ08-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1313,9,'simple','WJ08-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1314,9,'simple','WJ08-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1315,9,'simple','WJ08-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1316,9,'configurable','WJ08',1,0,'[[regtime]]','[[regtime]]'),(1317,9,'simple','WJ09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1318,9,'simple','WJ09-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1319,9,'simple','WJ09-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1320,9,'simple','WJ09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1321,9,'simple','WJ09-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1322,9,'simple','WJ09-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1323,9,'simple','WJ09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1324,9,'simple','WJ09-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1325,9,'simple','WJ09-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1326,9,'simple','WJ09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1327,9,'simple','WJ09-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1328,9,'simple','WJ09-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1329,9,'simple','WJ09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1330,9,'simple','WJ09-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1331,9,'simple','WJ09-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1332,9,'configurable','WJ09',1,0,'[[regtime]]','[[regtime]]'),(1333,9,'simple','WJ10-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1334,9,'simple','WJ10-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1335,9,'simple','WJ10-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1336,9,'simple','WJ10-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1337,9,'simple','WJ10-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1338,9,'simple','WJ10-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1339,9,'simple','WJ10-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1340,9,'simple','WJ10-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1341,9,'simple','WJ10-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1342,9,'simple','WJ10-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1343,9,'simple','WJ10-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1344,9,'simple','WJ10-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1345,9,'simple','WJ10-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1346,9,'simple','WJ10-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1347,9,'simple','WJ10-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1348,9,'configurable','WJ10',1,0,'[[regtime]]','[[regtime]]'),(1349,9,'simple','WJ11-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1350,9,'simple','WJ11-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1351,9,'simple','WJ11-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1352,9,'simple','WJ11-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1353,9,'simple','WJ11-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1354,9,'simple','WJ11-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1355,9,'simple','WJ11-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1356,9,'simple','WJ11-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1357,9,'simple','WJ11-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1358,9,'simple','WJ11-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1359,9,'simple','WJ11-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1360,9,'simple','WJ11-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1361,9,'simple','WJ11-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1362,9,'simple','WJ11-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1363,9,'simple','WJ11-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1364,9,'configurable','WJ11',1,0,'[[regtime]]','[[regtime]]'),(1365,9,'simple','WJ06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1366,9,'simple','WJ06-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1367,9,'simple','WJ06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1368,9,'simple','WJ06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1369,9,'simple','WJ06-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1370,9,'simple','WJ06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1371,9,'simple','WJ06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1372,9,'simple','WJ06-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1373,9,'simple','WJ06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1374,9,'simple','WJ06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1375,9,'simple','WJ06-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1376,9,'simple','WJ06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1377,9,'simple','WJ06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1378,9,'simple','WJ06-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1379,9,'simple','WJ06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1380,9,'configurable','WJ06',1,0,'[[regtime]]','[[regtime]]'),(1381,9,'simple','WJ12-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1382,9,'simple','WJ12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1383,9,'simple','WJ12-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1384,9,'simple','WJ12-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1385,9,'simple','WJ12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1386,9,'simple','WJ12-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1387,9,'simple','WJ12-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1388,9,'simple','WJ12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1389,9,'simple','WJ12-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1390,9,'simple','WJ12-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1391,9,'simple','WJ12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1392,9,'simple','WJ12-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1393,9,'simple','WJ12-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1394,9,'simple','WJ12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1395,9,'simple','WJ12-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1396,9,'configurable','WJ12',1,0,'[[regtime]]','[[regtime]]'),(1397,9,'simple','WS02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1398,9,'simple','WS02-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1399,9,'simple','WS02-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1400,9,'simple','WS02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1401,9,'simple','WS02-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1402,9,'simple','WS02-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1403,9,'simple','WS02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1404,9,'simple','WS02-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1405,9,'simple','WS02-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1406,9,'simple','WS02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1407,9,'simple','WS02-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1408,9,'simple','WS02-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1409,9,'simple','WS02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1410,9,'simple','WS02-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1411,9,'simple','WS02-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1412,9,'configurable','WS02',1,0,'[[regtime]]','[[regtime]]'),(1413,9,'simple','WS03-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1414,9,'simple','WS03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1415,9,'simple','WS03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1416,9,'simple','WS03-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1417,9,'simple','WS03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1418,9,'simple','WS03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1419,9,'simple','WS03-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1420,9,'simple','WS03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1421,9,'simple','WS03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1422,9,'simple','WS03-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1423,9,'simple','WS03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1424,9,'simple','WS03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1425,9,'simple','WS03-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1426,9,'simple','WS03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1427,9,'simple','WS03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1428,9,'configurable','WS03',1,0,'[[regtime]]','[[regtime]]'),(1429,9,'simple','WS04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1430,9,'simple','WS04-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1431,9,'simple','WS04-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1432,9,'simple','WS04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1433,9,'simple','WS04-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1434,9,'simple','WS04-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1435,9,'simple','WS04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1436,9,'simple','WS04-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1437,9,'simple','WS04-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1438,9,'simple','WS04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1439,9,'simple','WS04-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1440,9,'simple','WS04-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1441,9,'simple','WS04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1442,9,'simple','WS04-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1443,9,'simple','WS04-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1444,9,'configurable','WS04',1,0,'[[regtime]]','[[regtime]]'),(1445,9,'simple','WS06-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1446,9,'simple','WS06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1447,9,'simple','WS06-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1448,9,'simple','WS06-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1449,9,'simple','WS06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1450,9,'simple','WS06-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1451,9,'simple','WS06-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1452,9,'simple','WS06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1453,9,'simple','WS06-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1454,9,'simple','WS06-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1455,9,'simple','WS06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1456,9,'simple','WS06-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1457,9,'simple','WS06-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1458,9,'simple','WS06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1459,9,'simple','WS06-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1460,9,'configurable','WS06',1,0,'[[regtime]]','[[regtime]]'),(1461,9,'simple','WS07-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1462,9,'simple','WS07-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1463,9,'simple','WS07-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1464,9,'simple','WS07-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1465,9,'simple','WS07-S-White',0,0,'[[regtime]]','[[regtime]]'),(1466,9,'simple','WS07-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1467,9,'simple','WS07-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1468,9,'simple','WS07-M-White',0,0,'[[regtime]]','[[regtime]]'),(1469,9,'simple','WS07-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1470,9,'simple','WS07-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1471,9,'simple','WS07-L-White',0,0,'[[regtime]]','[[regtime]]'),(1472,9,'simple','WS07-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1473,9,'simple','WS07-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1474,9,'simple','WS07-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1475,9,'simple','WS07-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1476,9,'configurable','WS07',1,0,'[[regtime]]','[[regtime]]'),(1477,9,'simple','WS08-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1478,9,'simple','WS08-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1479,9,'simple','WS08-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1480,9,'simple','WS08-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1481,9,'simple','WS08-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1482,9,'simple','WS08-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1483,9,'simple','WS08-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1484,9,'simple','WS08-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1485,9,'simple','WS08-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1486,9,'simple','WS08-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1487,9,'simple','WS08-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1488,9,'simple','WS08-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1489,9,'simple','WS08-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1490,9,'simple','WS08-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1491,9,'simple','WS08-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1492,9,'configurable','WS08',1,0,'[[regtime]]','[[regtime]]'),(1493,9,'simple','WS09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1494,9,'simple','WS09-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1495,9,'simple','WS09-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1496,9,'simple','WS09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1497,9,'simple','WS09-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1498,9,'simple','WS09-S-White',0,0,'[[regtime]]','[[regtime]]'),(1499,9,'simple','WS09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1500,9,'simple','WS09-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1501,9,'simple','WS09-M-White',0,0,'[[regtime]]','[[regtime]]'),(1502,9,'simple','WS09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1503,9,'simple','WS09-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1504,9,'simple','WS09-L-White',0,0,'[[regtime]]','[[regtime]]'),(1505,9,'simple','WS09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1506,9,'simple','WS09-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1507,9,'simple','WS09-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1508,9,'configurable','WS09',1,0,'[[regtime]]','[[regtime]]'),(1509,9,'simple','WS10-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1510,9,'simple','WS10-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1511,9,'simple','WS10-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1512,9,'simple','WS10-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1513,9,'simple','WS10-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1514,9,'simple','WS10-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1515,9,'simple','WS10-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1516,9,'simple','WS10-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1517,9,'simple','WS10-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1518,9,'simple','WS10-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1519,9,'simple','WS10-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1520,9,'simple','WS10-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1521,9,'simple','WS10-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1522,9,'simple','WS10-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1523,9,'simple','WS10-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1524,9,'configurable','WS10',1,0,'[[regtime]]','[[regtime]]'),(1525,9,'simple','WS11-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1526,9,'simple','WS11-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1527,9,'simple','WS11-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1528,9,'simple','WS11-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1529,9,'simple','WS11-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1530,9,'simple','WS11-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1531,9,'simple','WS11-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1532,9,'simple','WS11-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1533,9,'simple','WS11-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1534,9,'simple','WS11-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1535,9,'simple','WS11-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1536,9,'simple','WS11-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1537,9,'simple','WS11-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1538,9,'simple','WS11-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1539,9,'simple','WS11-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1540,9,'configurable','WS11',1,0,'[[regtime]]','[[regtime]]'),(1541,9,'simple','WS12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1542,9,'simple','WS12-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1543,9,'simple','WS12-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1544,9,'simple','WS12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1545,9,'simple','WS12-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1546,9,'simple','WS12-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1547,9,'simple','WS12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1548,9,'simple','WS12-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1549,9,'simple','WS12-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1550,9,'simple','WS12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1551,9,'simple','WS12-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1552,9,'simple','WS12-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1553,9,'simple','WS12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1554,9,'simple','WS12-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1555,9,'simple','WS12-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1556,9,'configurable','WS12',1,0,'[[regtime]]','[[regtime]]'),(1557,9,'simple','WS01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1558,9,'simple','WS01-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1559,9,'simple','WS01-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1560,9,'simple','WS01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1561,9,'simple','WS01-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1562,9,'simple','WS01-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1563,9,'simple','WS01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1564,9,'simple','WS01-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1565,9,'simple','WS01-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1566,9,'simple','WS01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1567,9,'simple','WS01-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1568,9,'simple','WS01-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1569,9,'simple','WS01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1570,9,'simple','WS01-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1571,9,'simple','WS01-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1572,9,'configurable','WS01',1,0,'[[regtime]]','[[regtime]]'),(1573,9,'simple','WS05-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1574,9,'simple','WS05-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1575,9,'simple','WS05-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1576,9,'simple','WS05-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1577,9,'simple','WS05-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1578,9,'simple','WS05-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1579,9,'simple','WS05-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1580,9,'simple','WS05-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1581,9,'simple','WS05-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1582,9,'simple','WS05-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1583,9,'simple','WS05-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1584,9,'simple','WS05-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1585,9,'simple','WS05-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1586,9,'simple','WS05-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1587,9,'simple','WS05-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1588,9,'configurable','WS05',1,0,'[[regtime]]','[[regtime]]'),(1589,9,'simple','WB01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1590,9,'simple','WB01-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1591,9,'simple','WB01-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1592,9,'simple','WB01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1593,9,'simple','WB01-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1594,9,'simple','WB01-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1595,9,'simple','WB01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1596,9,'simple','WB01-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1597,9,'simple','WB01-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1598,9,'simple','WB01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1599,9,'simple','WB01-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1600,9,'simple','WB01-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1601,9,'simple','WB01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1602,9,'simple','WB01-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1603,9,'simple','WB01-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1604,9,'configurable','WB01',1,0,'[[regtime]]','[[regtime]]'),(1605,9,'simple','WB02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1606,9,'simple','WB02-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1607,9,'simple','WB02-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1608,9,'simple','WB02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1609,9,'simple','WB02-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1610,9,'simple','WB02-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1611,9,'simple','WB02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1612,9,'simple','WB02-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1613,9,'simple','WB02-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1614,9,'simple','WB02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1615,9,'simple','WB02-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1616,9,'simple','WB02-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1617,9,'simple','WB02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1618,9,'simple','WB02-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1619,9,'simple','WB02-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1620,9,'configurable','WB02',1,0,'[[regtime]]','[[regtime]]'),(1621,9,'simple','WB03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1622,9,'simple','WB03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1623,9,'simple','WB03-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1624,9,'simple','WB03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1625,9,'simple','WB03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1626,9,'simple','WB03-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1627,9,'simple','WB03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1628,9,'simple','WB03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1629,9,'simple','WB03-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1630,9,'simple','WB03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1631,9,'simple','WB03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1632,9,'simple','WB03-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1633,9,'simple','WB03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1634,9,'simple','WB03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1635,9,'simple','WB03-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1636,9,'configurable','WB03',1,0,'[[regtime]]','[[regtime]]'),(1637,9,'simple','WB04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1638,9,'simple','WB04-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1639,9,'simple','WB04-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1640,9,'simple','WB04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1641,9,'simple','WB04-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1642,9,'simple','WB04-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1643,9,'simple','WB04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1644,9,'simple','WB04-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1645,9,'simple','WB04-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1646,9,'simple','WB04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1647,9,'simple','WB04-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1648,9,'simple','WB04-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1649,9,'simple','WB04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1650,9,'simple','WB04-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1651,9,'simple','WB04-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1652,9,'configurable','WB04',1,0,'[[regtime]]','[[regtime]]'),(1653,9,'simple','WB05-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1654,9,'simple','WB05-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1655,9,'simple','WB05-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1656,9,'simple','WB05-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1657,9,'simple','WB05-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1658,9,'simple','WB05-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1659,9,'simple','WB05-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1660,9,'simple','WB05-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1661,9,'simple','WB05-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1662,9,'simple','WB05-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1663,9,'simple','WB05-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1664,9,'simple','WB05-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1665,9,'simple','WB05-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1666,9,'simple','WB05-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1667,9,'simple','WB05-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1668,9,'configurable','WB05',1,0,'[[regtime]]','[[regtime]]'),(1669,9,'simple','WT01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1670,9,'simple','WT01-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1671,9,'simple','WT01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1672,9,'simple','WT01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1673,9,'simple','WT01-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1674,9,'simple','WT01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1675,9,'simple','WT01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1676,9,'simple','WT01-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1677,9,'simple','WT01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1678,9,'simple','WT01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1679,9,'simple','WT01-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1680,9,'simple','WT01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1681,9,'simple','WT01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1682,9,'simple','WT01-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1683,9,'simple','WT01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1684,9,'configurable','WT01',1,0,'[[regtime]]','[[regtime]]'),(1685,9,'simple','WT02-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1686,9,'simple','WT02-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1687,9,'simple','WT02-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1688,9,'simple','WT02-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1689,9,'simple','WT02-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1690,9,'simple','WT02-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1691,9,'simple','WT02-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1692,9,'simple','WT02-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1693,9,'simple','WT02-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1694,9,'simple','WT02-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1695,9,'simple','WT02-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1696,9,'simple','WT02-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1697,9,'simple','WT02-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1698,9,'simple','WT02-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1699,9,'simple','WT02-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1700,9,'configurable','WT02',1,0,'[[regtime]]','[[regtime]]'),(1701,9,'simple','WT03-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1702,9,'simple','WT03-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1703,9,'simple','WT03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1704,9,'simple','WT03-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1705,9,'simple','WT03-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1706,9,'simple','WT03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1707,9,'simple','WT03-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1708,9,'simple','WT03-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1709,9,'simple','WT03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1710,9,'simple','WT03-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1711,9,'simple','WT03-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1712,9,'simple','WT03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1713,9,'simple','WT03-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1714,9,'simple','WT03-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1715,9,'simple','WT03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1716,9,'configurable','WT03',1,0,'[[regtime]]','[[regtime]]'),(1717,9,'simple','WT04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1718,9,'simple','WT04-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1719,9,'simple','WT04-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1720,9,'simple','WT04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1721,9,'simple','WT04-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1722,9,'simple','WT04-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1723,9,'simple','WT04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1724,9,'simple','WT04-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1725,9,'simple','WT04-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1726,9,'simple','WT04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1727,9,'simple','WT04-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1728,9,'simple','WT04-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1729,9,'simple','WT04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1730,9,'simple','WT04-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1731,9,'simple','WT04-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1732,9,'configurable','WT04',1,0,'[[regtime]]','[[regtime]]'),(1733,9,'simple','WT05-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1734,9,'simple','WT05-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1735,9,'simple','WT05-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1736,9,'simple','WT05-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1737,9,'simple','WT05-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1738,9,'simple','WT05-S-White',0,0,'[[regtime]]','[[regtime]]'),(1739,9,'simple','WT05-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1740,9,'simple','WT05-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1741,9,'simple','WT05-M-White',0,0,'[[regtime]]','[[regtime]]'),(1742,9,'simple','WT05-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1743,9,'simple','WT05-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1744,9,'simple','WT05-L-White',0,0,'[[regtime]]','[[regtime]]'),(1745,9,'simple','WT05-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1746,9,'simple','WT05-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1747,9,'simple','WT05-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1748,9,'configurable','WT05',1,0,'[[regtime]]','[[regtime]]'),(1749,9,'simple','WT06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1750,9,'simple','WT06-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1751,9,'simple','WT06-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1752,9,'simple','WT06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1753,9,'simple','WT06-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1754,9,'simple','WT06-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1755,9,'simple','WT06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1756,9,'simple','WT06-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1757,9,'simple','WT06-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1758,9,'simple','WT06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1759,9,'simple','WT06-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1760,9,'simple','WT06-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1761,9,'simple','WT06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1762,9,'simple','WT06-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1763,9,'simple','WT06-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1764,9,'configurable','WT06',1,0,'[[regtime]]','[[regtime]]'),(1765,9,'simple','WT07-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1766,9,'simple','WT07-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1767,9,'simple','WT07-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1768,9,'simple','WT07-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1769,9,'simple','WT07-S-White',0,0,'[[regtime]]','[[regtime]]'),(1770,9,'simple','WT07-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1771,9,'simple','WT07-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1772,9,'simple','WT07-M-White',0,0,'[[regtime]]','[[regtime]]'),(1773,9,'simple','WT07-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1774,9,'simple','WT07-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1775,9,'simple','WT07-L-White',0,0,'[[regtime]]','[[regtime]]'),(1776,9,'simple','WT07-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1777,9,'simple','WT07-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1778,9,'simple','WT07-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1779,9,'simple','WT07-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1780,9,'configurable','WT07',1,0,'[[regtime]]','[[regtime]]'),(1781,9,'simple','WT08-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1782,9,'simple','WT08-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1783,9,'simple','WT08-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1784,9,'simple','WT08-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1785,9,'simple','WT08-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1786,9,'simple','WT08-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1787,9,'simple','WT08-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1788,9,'simple','WT08-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1789,9,'simple','WT08-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1790,9,'simple','WT08-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1791,9,'simple','WT08-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1792,9,'simple','WT08-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1793,9,'simple','WT08-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1794,9,'simple','WT08-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1795,9,'simple','WT08-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1796,9,'configurable','WT08',1,0,'[[regtime]]','[[regtime]]'),(1797,9,'simple','WT09-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1798,9,'simple','WT09-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1799,9,'simple','WT09-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1800,9,'simple','WT09-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1801,9,'simple','WT09-S-White',0,0,'[[regtime]]','[[regtime]]'),(1802,9,'simple','WT09-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1803,9,'simple','WT09-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1804,9,'simple','WT09-M-White',0,0,'[[regtime]]','[[regtime]]'),(1805,9,'simple','WT09-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1806,9,'simple','WT09-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1807,9,'simple','WT09-L-White',0,0,'[[regtime]]','[[regtime]]'),(1808,9,'simple','WT09-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1809,9,'simple','WT09-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1810,9,'simple','WT09-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1811,9,'simple','WT09-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1812,9,'configurable','WT09',1,0,'[[regtime]]','[[regtime]]'),(1813,10,'simple','WP01-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1814,10,'simple','WP01-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1815,10,'simple','WP01-28-White',0,0,'[[regtime]]','[[regtime]]'),(1816,10,'simple','WP01-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1817,10,'simple','WP01-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1818,10,'simple','WP01-29-White',0,0,'[[regtime]]','[[regtime]]'),(1819,10,'configurable','WP01',1,0,'[[regtime]]','[[regtime]]'),(1820,10,'simple','WP02-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1821,10,'simple','WP02-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1822,10,'simple','WP02-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1823,10,'simple','WP02-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1824,10,'simple','WP02-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1825,10,'simple','WP02-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1826,10,'configurable','WP02',1,0,'[[regtime]]','[[regtime]]'),(1827,10,'simple','WP03-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1828,10,'simple','WP03-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1829,10,'simple','WP03-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1830,10,'simple','WP03-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1831,10,'simple','WP03-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1832,10,'simple','WP03-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1833,10,'configurable','WP03',1,0,'[[regtime]]','[[regtime]]'),(1834,10,'simple','WP04-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1835,10,'simple','WP04-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1836,10,'simple','WP04-28-White',0,0,'[[regtime]]','[[regtime]]'),(1837,10,'simple','WP04-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1838,10,'simple','WP04-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1839,10,'simple','WP04-29-White',0,0,'[[regtime]]','[[regtime]]'),(1840,10,'configurable','WP04',1,0,'[[regtime]]','[[regtime]]'),(1841,10,'simple','WP05-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1842,10,'simple','WP05-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1843,10,'simple','WP05-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1844,10,'simple','WP05-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1845,10,'simple','WP05-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1846,10,'simple','WP05-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1847,10,'configurable','WP05',1,0,'[[regtime]]','[[regtime]]'),(1848,10,'simple','WP06-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1849,10,'simple','WP06-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1850,10,'simple','WP06-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1851,10,'simple','WP06-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1852,10,'simple','WP06-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1853,10,'simple','WP06-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1854,10,'configurable','WP06',1,0,'[[regtime]]','[[regtime]]'),(1855,10,'simple','WP07-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1856,10,'simple','WP07-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1857,10,'simple','WP07-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1858,10,'simple','WP07-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1859,10,'simple','WP07-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1860,10,'simple','WP07-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1861,10,'configurable','WP07',1,0,'[[regtime]]','[[regtime]]'),(1862,10,'simple','WP08-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1863,10,'simple','WP08-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1864,10,'simple','WP08-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1865,10,'simple','WP08-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1866,10,'simple','WP08-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1867,10,'simple','WP08-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1868,10,'configurable','WP08',1,0,'[[regtime]]','[[regtime]]'),(1869,10,'simple','WP09-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1870,10,'simple','WP09-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1871,10,'simple','WP09-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1872,10,'simple','WP09-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1873,10,'simple','WP09-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1874,10,'simple','WP09-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1875,10,'configurable','WP09',1,0,'[[regtime]]','[[regtime]]'),(1876,10,'simple','WP10-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1877,10,'simple','WP10-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1878,10,'simple','WP10-28-White',0,0,'[[regtime]]','[[regtime]]'),(1879,10,'simple','WP10-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1880,10,'simple','WP10-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1881,10,'simple','WP10-29-White',0,0,'[[regtime]]','[[regtime]]'),(1882,10,'configurable','WP10',1,0,'[[regtime]]','[[regtime]]'),(1883,10,'simple','WP11-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1884,10,'simple','WP11-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1885,10,'simple','WP11-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1886,10,'simple','WP11-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1887,10,'simple','WP11-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1888,10,'simple','WP11-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1889,10,'configurable','WP11',1,0,'[[regtime]]','[[regtime]]'),(1890,10,'simple','WP12-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1891,10,'simple','WP12-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1892,10,'simple','WP12-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1893,10,'simple','WP12-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1894,10,'simple','WP12-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1895,10,'simple','WP12-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1896,10,'configurable','WP12',1,0,'[[regtime]]','[[regtime]]'),(1897,10,'simple','WP13-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1898,10,'simple','WP13-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1899,10,'simple','WP13-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1900,10,'simple','WP13-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1901,10,'simple','WP13-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1902,10,'simple','WP13-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1903,10,'configurable','WP13',1,0,'[[regtime]]','[[regtime]]'),(1904,10,'simple','WSH01-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1905,10,'simple','WSH01-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1906,10,'simple','WSH01-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1907,10,'simple','WSH01-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1908,10,'simple','WSH01-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1909,10,'simple','WSH01-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1910,10,'simple','WSH01-30-Black',0,0,'[[regtime]]','[[regtime]]'),(1911,10,'simple','WSH01-30-Green',0,0,'[[regtime]]','[[regtime]]'),(1912,10,'simple','WSH01-30-Red',0,0,'[[regtime]]','[[regtime]]'),(1913,10,'simple','WSH01-31-Black',0,0,'[[regtime]]','[[regtime]]'),(1914,10,'simple','WSH01-31-Green',0,0,'[[regtime]]','[[regtime]]'),(1915,10,'simple','WSH01-31-Red',0,0,'[[regtime]]','[[regtime]]'),(1916,10,'simple','WSH01-32-Black',0,0,'[[regtime]]','[[regtime]]'),(1917,10,'simple','WSH01-32-Green',0,0,'[[regtime]]','[[regtime]]'),(1918,10,'simple','WSH01-32-Red',0,0,'[[regtime]]','[[regtime]]'),(1919,10,'configurable','WSH01',1,0,'[[regtime]]','[[regtime]]'),(1920,10,'simple','WSH02-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1921,10,'simple','WSH02-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1922,10,'simple','WSH02-28-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1923,10,'simple','WSH02-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1924,10,'simple','WSH02-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1925,10,'simple','WSH02-29-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1926,10,'simple','WSH02-30-Gray',0,0,'[[regtime]]','[[regtime]]'),(1927,10,'simple','WSH02-30-Orange',0,0,'[[regtime]]','[[regtime]]'),(1928,10,'simple','WSH02-30-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1929,10,'simple','WSH02-31-Gray',0,0,'[[regtime]]','[[regtime]]'),(1930,10,'simple','WSH02-31-Orange',0,0,'[[regtime]]','[[regtime]]'),(1931,10,'simple','WSH02-31-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1932,10,'simple','WSH02-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(1933,10,'simple','WSH02-32-Orange',0,0,'[[regtime]]','[[regtime]]'),(1934,10,'simple','WSH02-32-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1935,10,'configurable','WSH02',1,0,'[[regtime]]','[[regtime]]'),(1936,10,'simple','WSH03-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1937,10,'simple','WSH03-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1938,10,'simple','WSH03-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1939,10,'simple','WSH03-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1940,10,'simple','WSH03-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1941,10,'simple','WSH03-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1942,10,'simple','WSH03-30-Blue',0,0,'[[regtime]]','[[regtime]]'),(1943,10,'simple','WSH03-30-Gray',0,0,'[[regtime]]','[[regtime]]'),(1944,10,'simple','WSH03-30-Orange',0,0,'[[regtime]]','[[regtime]]'),(1945,10,'simple','WSH03-31-Blue',0,0,'[[regtime]]','[[regtime]]'),(1946,10,'simple','WSH03-31-Gray',0,0,'[[regtime]]','[[regtime]]'),(1947,10,'simple','WSH03-31-Orange',0,0,'[[regtime]]','[[regtime]]'),(1948,10,'simple','WSH03-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(1949,10,'simple','WSH03-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(1950,10,'simple','WSH03-32-Orange',0,0,'[[regtime]]','[[regtime]]'),(1951,10,'configurable','WSH03',1,0,'[[regtime]]','[[regtime]]'),(1952,10,'simple','WSH04-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1953,10,'simple','WSH04-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1954,10,'simple','WSH04-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1955,10,'simple','WSH04-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1956,10,'simple','WSH04-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1957,10,'simple','WSH04-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1958,10,'simple','WSH04-30-Black',0,0,'[[regtime]]','[[regtime]]'),(1959,10,'simple','WSH04-30-Green',0,0,'[[regtime]]','[[regtime]]'),(1960,10,'simple','WSH04-30-Orange',0,0,'[[regtime]]','[[regtime]]'),(1961,10,'simple','WSH04-31-Black',0,0,'[[regtime]]','[[regtime]]'),(1962,10,'simple','WSH04-31-Green',0,0,'[[regtime]]','[[regtime]]'),(1963,10,'simple','WSH04-31-Orange',0,0,'[[regtime]]','[[regtime]]'),(1964,10,'simple','WSH04-32-Black',0,0,'[[regtime]]','[[regtime]]'),(1965,10,'simple','WSH04-32-Green',0,0,'[[regtime]]','[[regtime]]'),(1966,10,'simple','WSH04-32-Orange',0,0,'[[regtime]]','[[regtime]]'),(1967,10,'configurable','WSH04',1,0,'[[regtime]]','[[regtime]]'),(1968,10,'simple','WSH05-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1969,10,'simple','WSH05-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1970,10,'simple','WSH05-28-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1971,10,'simple','WSH05-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1972,10,'simple','WSH05-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1973,10,'simple','WSH05-29-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1974,10,'simple','WSH05-30-Blue',0,0,'[[regtime]]','[[regtime]]'),(1975,10,'simple','WSH05-30-Purple',0,0,'[[regtime]]','[[regtime]]'),(1976,10,'simple','WSH05-30-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1977,10,'simple','WSH05-31-Blue',0,0,'[[regtime]]','[[regtime]]'),(1978,10,'simple','WSH05-31-Purple',0,0,'[[regtime]]','[[regtime]]'),(1979,10,'simple','WSH05-31-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1980,10,'simple','WSH05-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(1981,10,'simple','WSH05-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(1982,10,'simple','WSH05-32-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1983,10,'configurable','WSH05',1,0,'[[regtime]]','[[regtime]]'),(1984,10,'simple','WSH06-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1985,10,'simple','WSH06-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1986,10,'simple','WSH06-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1987,10,'simple','WSH06-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1988,10,'simple','WSH06-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1989,10,'simple','WSH06-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1990,10,'configurable','WSH06',1,0,'[[regtime]]','[[regtime]]'),(1991,10,'simple','WSH07-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1992,10,'simple','WSH07-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1993,10,'simple','WSH07-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1994,10,'simple','WSH07-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1995,10,'simple','WSH07-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1996,10,'simple','WSH07-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1997,10,'configurable','WSH07',1,0,'[[regtime]]','[[regtime]]'),(1998,10,'simple','WSH08-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1999,10,'simple','WSH08-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(2000,10,'simple','WSH08-30-Purple',0,0,'[[regtime]]','[[regtime]]'),(2001,10,'simple','WSH08-31-Purple',0,0,'[[regtime]]','[[regtime]]'),(2002,10,'simple','WSH08-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(2003,10,'configurable','WSH08',1,0,'[[regtime]]','[[regtime]]'),(2004,10,'simple','WSH09-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(2005,10,'simple','WSH09-28-Green',0,0,'[[regtime]]','[[regtime]]'),(2006,10,'simple','WSH09-28-White',0,0,'[[regtime]]','[[regtime]]'),(2007,10,'simple','WSH09-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(2008,10,'simple','WSH09-29-Green',0,0,'[[regtime]]','[[regtime]]'),(2009,10,'simple','WSH09-29-White',0,0,'[[regtime]]','[[regtime]]'),(2010,10,'configurable','WSH09',1,0,'[[regtime]]','[[regtime]]'),(2011,10,'simple','WSH10-28-Black',0,0,'[[regtime]]','[[regtime]]'),(2012,10,'simple','WSH10-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(2013,10,'simple','WSH10-28-White',0,0,'[[regtime]]','[[regtime]]'),(2014,10,'simple','WSH10-29-Black',0,0,'[[regtime]]','[[regtime]]'),(2015,10,'simple','WSH10-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(2016,10,'simple','WSH10-29-White',0,0,'[[regtime]]','[[regtime]]'),(2017,10,'configurable','WSH10',1,0,'[[regtime]]','[[regtime]]'),(2018,10,'simple','WSH11-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(2019,10,'simple','WSH11-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(2020,10,'simple','WSH11-28-Red',0,0,'[[regtime]]','[[regtime]]'),(2021,10,'simple','WSH11-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(2022,10,'simple','WSH11-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(2023,10,'simple','WSH11-29-Red',0,0,'[[regtime]]','[[regtime]]'),(2024,10,'configurable','WSH11',1,0,'[[regtime]]','[[regtime]]'),(2025,10,'simple','WSH12-28-Green',0,0,'[[regtime]]','[[regtime]]'),(2026,10,'simple','WSH12-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(2027,10,'simple','WSH12-28-Red',0,0,'[[regtime]]','[[regtime]]'),(2028,10,'simple','WSH12-29-Green',0,0,'[[regtime]]','[[regtime]]'),(2029,10,'simple','WSH12-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(2030,10,'simple','WSH12-29-Red',0,0,'[[regtime]]','[[regtime]]'),(2031,10,'simple','WSH12-30-Green',0,0,'[[regtime]]','[[regtime]]'),(2032,10,'simple','WSH12-30-Purple',0,0,'[[regtime]]','[[regtime]]'),(2033,10,'simple','WSH12-30-Red',0,0,'[[regtime]]','[[regtime]]'),(2034,10,'simple','WSH12-31-Green',0,0,'[[regtime]]','[[regtime]]'),(2035,10,'simple','WSH12-31-Purple',0,0,'[[regtime]]','[[regtime]]'),(2036,10,'simple','WSH12-31-Red',0,0,'[[regtime]]','[[regtime]]'),(2037,10,'simple','WSH12-32-Green',0,0,'[[regtime]]','[[regtime]]'),(2038,10,'simple','WSH12-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(2039,10,'simple','WSH12-32-Red',0,0,'[[regtime]]','[[regtime]]'),(2040,10,'configurable','WSH12',1,0,'[[regtime]]','[[regtime]]');
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_datetime`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_datetime` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_PRD_ENTT_DTIME_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DTIME_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DTIME_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DTIME_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_datetime`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_datetime` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_datetime` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_datetime` VALUES (1,79,0,2,'[[regtime]]'),(2,79,0,10,'[[regtime]]'),(3,79,0,11,'[[regtime]]'),(4,79,0,16,'[[regtime]]'),(5,79,0,41,'[[regtime]]'),(6,79,0,42,'[[regtime]]');
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_decimal`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_decimal` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(20,6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_PRD_ENTT_DEC_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DEC_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DEC_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3904 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_decimal`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_decimal` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_decimal` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_decimal` VALUES (1,77,0,1,34.000000),(2,77,0,2,32.000000),(3,78,0,2,32.000000),(4,77,0,3,38.000000),(5,77,0,4,45.000000),(6,77,0,5,45.000000),(7,77,0,6,59.000000),(8,77,0,7,74.000000),(9,77,0,8,32.000000),(10,77,0,9,32.000000),(11,77,0,10,32.000000),(12,78,0,10,24.000000),(13,77,0,11,33.000000),(14,78,0,11,33.000000),(15,77,0,12,36.000000),(16,77,0,13,45.000000),(17,77,0,14,45.000000),(18,77,0,15,7.000000),(19,77,0,16,12.000000),(20,78,0,16,12.000000),(21,77,0,17,12.000000),(22,77,0,18,16.000000),(23,77,0,19,19.000000),(24,77,0,20,19.000000),(25,77,0,21,5.000000),(26,77,0,22,19.000000),(27,77,0,23,22.000000),(28,77,0,24,23.000000),(29,77,0,25,23.000000),(30,77,0,26,23.000000),(31,77,0,27,27.000000),(32,77,0,28,27.000000),(33,77,0,29,27.000000),(34,77,0,30,32.000000),(35,77,0,31,32.000000),(36,77,0,32,32.000000),(37,77,0,33,14.000000),(38,77,0,34,17.000000),(39,77,0,35,21.000000),(40,77,0,36,45.000000),(41,77,0,37,49.000000),(42,77,0,38,54.000000),(43,77,0,39,55.000000),(44,77,0,40,92.000000),(45,77,0,41,43.000000),(46,78,0,41,43.000000),(47,77,0,42,49.000000),(48,78,0,42,49.000000),(49,77,0,43,54.000000),(50,77,0,44,92.000000),(51,77,0,47,52.000000),(52,82,0,47,1.000000),(53,77,0,48,52.000000),(54,82,0,48,1.000000),(55,77,0,49,52.000000),(56,82,0,49,1.000000),(57,77,0,50,52.000000),(58,82,0,50,1.000000),(59,77,0,51,52.000000),(60,82,0,51,1.000000),(61,77,0,52,52.000000),(62,82,0,52,1.000000),(63,77,0,53,52.000000),(64,82,0,53,1.000000),(65,77,0,54,52.000000),(66,82,0,54,1.000000),(67,77,0,55,52.000000),(68,82,0,55,1.000000),(69,77,0,56,52.000000),(70,82,0,56,1.000000),(71,77,0,57,52.000000),(72,82,0,57,1.000000),(73,77,0,58,52.000000),(74,82,0,58,1.000000),(75,77,0,59,52.000000),(76,82,0,59,1.000000),(77,77,0,60,52.000000),(78,82,0,60,1.000000),(79,77,0,61,52.000000),(80,82,0,61,1.000000),(81,77,0,62,52.000000),(82,77,0,63,70.000000),(83,82,0,63,1.000000),(84,77,0,64,70.000000),(85,82,0,64,1.000000),(86,77,0,65,70.000000),(87,82,0,65,1.000000),(88,77,0,66,70.000000),(89,82,0,66,1.000000),(90,77,0,67,70.000000),(91,82,0,67,1.000000),(92,77,0,68,70.000000),(93,82,0,68,1.000000),(94,77,0,69,70.000000),(95,82,0,69,1.000000),(96,77,0,70,70.000000),(97,82,0,70,1.000000),(98,77,0,71,70.000000),(99,82,0,71,1.000000),(100,77,0,72,70.000000),(101,82,0,72,1.000000),(102,77,0,73,70.000000),(103,82,0,73,1.000000),(104,77,0,74,70.000000),(105,82,0,74,1.000000),(106,77,0,75,70.000000),(107,82,0,75,1.000000),(108,77,0,76,70.000000),(109,82,0,76,1.000000),(110,77,0,77,70.000000),(111,82,0,77,1.000000),(112,77,0,78,70.000000),(113,77,0,79,63.000000),(114,82,0,79,1.000000),(115,77,0,80,63.000000),(116,82,0,80,1.000000),(117,77,0,81,63.000000),(118,82,0,81,1.000000),(119,77,0,82,63.000000),(120,82,0,82,1.000000),(121,77,0,83,63.000000),(122,82,0,83,1.000000),(123,77,0,84,63.000000),(124,82,0,84,1.000000),(125,77,0,85,63.000000),(126,82,0,85,1.000000),(127,77,0,86,63.000000),(128,82,0,86,1.000000),(129,77,0,87,63.000000),(130,82,0,87,1.000000),(131,77,0,88,63.000000),(132,82,0,88,1.000000),(133,77,0,89,63.000000),(134,82,0,89,1.000000),(135,77,0,90,63.000000),(136,82,0,90,1.000000),(137,77,0,91,63.000000),(138,82,0,91,1.000000),(139,77,0,92,63.000000),(140,82,0,92,1.000000),(141,77,0,93,63.000000),(142,82,0,93,1.000000),(143,77,0,94,63.000000),(144,77,0,95,60.000000),(145,82,0,95,1.000000),(146,77,0,96,60.000000),(147,82,0,96,1.000000),(148,77,0,97,60.000000),(149,82,0,97,1.000000),(150,77,0,98,60.000000),(151,82,0,98,1.000000),(152,77,0,99,60.000000),(153,82,0,99,1.000000),(154,77,0,100,60.000000),(155,82,0,100,1.000000),(156,77,0,101,60.000000),(157,82,0,101,1.000000),(158,77,0,102,60.000000),(159,82,0,102,1.000000),(160,77,0,103,60.000000),(161,82,0,103,1.000000),(162,77,0,104,60.000000),(163,82,0,104,1.000000),(164,77,0,105,60.000000),(165,82,0,105,1.000000),(166,77,0,106,60.000000),(167,82,0,106,1.000000),(168,77,0,107,60.000000),(169,82,0,107,1.000000),(170,77,0,108,60.000000),(171,82,0,108,1.000000),(172,77,0,109,60.000000),(173,82,0,109,1.000000),(174,77,0,110,60.000000),(175,77,0,111,52.000000),(176,82,0,111,1.000000),(177,77,0,112,52.000000),(178,82,0,112,1.000000),(179,77,0,113,52.000000),(180,82,0,113,1.000000),(181,77,0,114,52.000000),(182,82,0,114,1.000000),(183,77,0,115,52.000000),(184,82,0,115,1.000000),(185,77,0,116,52.000000),(186,82,0,116,1.000000),(187,77,0,117,52.000000),(188,82,0,117,1.000000),(189,77,0,118,52.000000),(190,82,0,118,1.000000),(191,77,0,119,52.000000),(192,82,0,119,1.000000),(193,77,0,120,52.000000),(194,82,0,120,1.000000),(195,77,0,121,52.000000),(196,82,0,121,1.000000),(197,77,0,122,52.000000),(198,82,0,122,1.000000),(199,77,0,123,52.000000),(200,82,0,123,1.000000),(201,77,0,124,52.000000),(202,82,0,124,1.000000),(203,77,0,125,52.000000),(204,82,0,125,1.000000),(205,77,0,126,52.000000),(206,77,0,127,42.000000),(207,82,0,127,1.000000),(208,77,0,128,42.000000),(209,82,0,128,1.000000),(210,77,0,129,42.000000),(211,82,0,129,1.000000),(212,77,0,130,42.000000),(213,82,0,130,1.000000),(214,77,0,131,42.000000),(215,82,0,131,1.000000),(216,77,0,132,42.000000),(217,82,0,132,1.000000),(218,77,0,133,42.000000),(219,82,0,133,1.000000),(220,77,0,134,42.000000),(221,82,0,134,1.000000),(222,77,0,135,42.000000),(223,82,0,135,1.000000),(224,77,0,136,42.000000),(225,82,0,136,1.000000),(226,77,0,137,42.000000),(227,82,0,137,1.000000),(228,77,0,138,42.000000),(229,82,0,138,1.000000),(230,77,0,139,42.000000),(231,82,0,139,1.000000),(232,77,0,140,42.000000),(233,82,0,140,1.000000),(234,77,0,141,42.000000),(235,82,0,141,1.000000),(236,77,0,142,42.000000),(237,77,0,143,54.000000),(238,82,0,143,1.000000),(239,77,0,144,54.000000),(240,82,0,144,1.000000),(241,77,0,145,54.000000),(242,82,0,145,1.000000),(243,77,0,146,54.000000),(244,82,0,146,1.000000),(245,77,0,147,54.000000),(246,82,0,147,1.000000),(247,77,0,148,54.000000),(248,82,0,148,1.000000),(249,77,0,149,54.000000),(250,82,0,149,1.000000),(251,77,0,150,54.000000),(252,82,0,150,1.000000),(253,77,0,151,54.000000),(254,82,0,151,1.000000),(255,77,0,152,54.000000),(256,82,0,152,1.000000),(257,77,0,153,54.000000),(258,82,0,153,1.000000),(259,77,0,154,54.000000),(260,82,0,154,1.000000),(261,77,0,155,54.000000),(262,82,0,155,1.000000),(263,77,0,156,54.000000),(264,82,0,156,1.000000),(265,77,0,157,54.000000),(266,82,0,157,1.000000),(267,77,0,158,54.000000),(268,77,0,159,42.000000),(269,82,0,159,1.000000),(270,77,0,160,42.000000),(271,82,0,160,1.000000),(272,77,0,161,42.000000),(273,82,0,161,1.000000),(274,77,0,162,42.000000),(275,82,0,162,1.000000),(276,77,0,163,42.000000),(277,82,0,163,1.000000),(278,77,0,164,42.000000),(279,82,0,164,1.000000),(280,77,0,165,42.000000),(281,82,0,165,1.000000),(282,77,0,166,42.000000),(283,82,0,166,1.000000),(284,77,0,167,42.000000),(285,82,0,167,1.000000),(286,77,0,168,42.000000),(287,82,0,168,1.000000),(288,77,0,169,42.000000),(289,82,0,169,1.000000),(290,77,0,170,42.000000),(291,82,0,170,1.000000),(292,77,0,171,42.000000),(293,82,0,171,1.000000),(294,77,0,172,42.000000),(295,82,0,172,1.000000),(296,77,0,173,42.000000),(297,82,0,173,1.000000),(298,77,0,174,42.000000),(299,77,0,175,69.000000),(300,82,0,175,1.000000),(301,77,0,176,69.000000),(302,82,0,176,1.000000),(303,77,0,177,69.000000),(304,82,0,177,1.000000),(305,77,0,178,69.000000),(306,82,0,178,1.000000),(307,77,0,179,69.000000),(308,82,0,179,1.000000),(309,77,0,180,69.000000),(310,82,0,180,1.000000),(311,77,0,181,69.000000),(312,82,0,181,1.000000),(313,77,0,182,69.000000),(314,82,0,182,1.000000),(315,77,0,183,69.000000),(316,82,0,183,1.000000),(317,77,0,184,69.000000),(318,82,0,184,1.000000),(319,77,0,185,69.000000),(320,82,0,185,1.000000),(321,77,0,186,69.000000),(322,82,0,186,1.000000),(323,77,0,187,69.000000),(324,82,0,187,1.000000),(325,77,0,188,69.000000),(326,82,0,188,1.000000),(327,77,0,189,69.000000),(328,82,0,189,1.000000),(329,77,0,190,69.000000),(330,77,0,191,62.000000),(331,82,0,191,1.000000),(332,77,0,192,62.000000),(333,82,0,192,1.000000),(334,77,0,193,62.000000),(335,82,0,193,1.000000),(336,77,0,194,62.000000),(337,82,0,194,1.000000),(338,77,0,195,62.000000),(339,82,0,195,1.000000),(340,77,0,196,62.000000),(341,82,0,196,1.000000),(342,77,0,197,62.000000),(343,82,0,197,1.000000),(344,77,0,198,62.000000),(345,82,0,198,1.000000),(346,77,0,199,62.000000),(347,82,0,199,1.000000),(348,77,0,200,62.000000),(349,82,0,200,1.000000),(350,77,0,201,62.000000),(351,82,0,201,1.000000),(352,77,0,202,62.000000),(353,82,0,202,1.000000),(354,77,0,203,62.000000),(355,82,0,203,1.000000),(356,77,0,204,62.000000),(357,82,0,204,1.000000),(358,77,0,205,62.000000),(359,82,0,205,1.000000),(360,77,0,206,62.000000),(361,77,0,207,64.000000),(362,82,0,207,1.000000),(363,77,0,208,64.000000),(364,82,0,208,1.000000),(365,77,0,209,64.000000),(366,82,0,209,1.000000),(367,77,0,210,64.000000),(368,82,0,210,1.000000),(369,77,0,211,64.000000),(370,82,0,211,1.000000),(371,77,0,212,64.000000),(372,82,0,212,1.000000),(373,77,0,213,64.000000),(374,82,0,213,1.000000),(375,77,0,214,64.000000),(376,82,0,214,1.000000),(377,77,0,215,64.000000),(378,82,0,215,1.000000),(379,77,0,216,64.000000),(380,82,0,216,1.000000),(381,77,0,217,64.000000),(382,82,0,217,1.000000),(383,77,0,218,64.000000),(384,82,0,218,1.000000),(385,77,0,219,64.000000),(386,82,0,219,1.000000),(387,77,0,220,64.000000),(388,82,0,220,1.000000),(389,77,0,221,64.000000),(390,82,0,221,1.000000),(391,77,0,222,64.000000),(392,77,0,223,69.000000),(393,82,0,223,1.000000),(394,77,0,224,69.000000),(395,82,0,224,1.000000),(396,77,0,225,69.000000),(397,82,0,225,1.000000),(398,77,0,226,69.000000),(399,82,0,226,1.000000),(400,77,0,227,69.000000),(401,82,0,227,1.000000),(402,77,0,228,69.000000),(403,82,0,228,1.000000),(404,77,0,229,69.000000),(405,82,0,229,1.000000),(406,77,0,230,69.000000),(407,82,0,230,1.000000),(408,77,0,231,69.000000),(409,82,0,231,1.000000),(410,77,0,232,69.000000),(411,82,0,232,1.000000),(412,77,0,233,69.000000),(413,82,0,233,1.000000),(414,77,0,234,69.000000),(415,82,0,234,1.000000),(416,77,0,235,69.000000),(417,82,0,235,1.000000),(418,77,0,236,69.000000),(419,82,0,236,1.000000),(420,77,0,237,69.000000),(421,82,0,237,1.000000),(422,77,0,238,69.000000),(423,77,0,239,74.000000),(424,82,0,239,1.000000),(425,77,0,240,74.000000),(426,82,0,240,1.000000),(427,77,0,241,74.000000),(428,82,0,241,1.000000),(429,77,0,242,74.000000),(430,82,0,242,1.000000),(431,77,0,243,74.000000),(432,82,0,243,1.000000),(433,77,0,244,74.000000),(434,82,0,244,1.000000),(435,77,0,245,74.000000),(436,82,0,245,1.000000),(437,77,0,246,74.000000),(438,82,0,246,1.000000),(439,77,0,247,74.000000),(440,82,0,247,1.000000),(441,77,0,248,74.000000),(442,82,0,248,1.000000),(443,77,0,249,74.000000),(444,82,0,249,1.000000),(445,77,0,250,74.000000),(446,82,0,250,1.000000),(447,77,0,251,74.000000),(448,82,0,251,1.000000),(449,77,0,252,74.000000),(450,82,0,252,1.000000),(451,77,0,253,74.000000),(452,82,0,253,1.000000),(453,77,0,254,74.000000),(454,77,0,255,42.000000),(455,82,0,255,1.000000),(456,77,0,256,42.000000),(457,82,0,256,1.000000),(458,77,0,257,42.000000),(459,82,0,257,1.000000),(460,77,0,258,42.000000),(461,82,0,258,1.000000),(462,77,0,259,42.000000),(463,82,0,259,1.000000),(464,77,0,260,42.000000),(465,82,0,260,1.000000),(466,77,0,261,42.000000),(467,82,0,261,1.000000),(468,77,0,262,42.000000),(469,82,0,262,1.000000),(470,77,0,263,42.000000),(471,82,0,263,1.000000),(472,77,0,264,42.000000),(473,82,0,264,1.000000),(474,77,0,265,42.000000),(475,82,0,265,1.000000),(476,77,0,266,42.000000),(477,82,0,266,1.000000),(478,77,0,267,42.000000),(479,82,0,267,1.000000),(480,77,0,268,42.000000),(481,82,0,268,1.000000),(482,77,0,269,42.000000),(483,82,0,269,1.000000),(484,77,0,270,42.000000),(485,77,0,271,51.000000),(486,82,0,271,1.000000),(487,77,0,272,51.000000),(488,82,0,272,1.000000),(489,77,0,273,51.000000),(490,82,0,273,1.000000),(491,77,0,274,51.000000),(492,82,0,274,1.000000),(493,77,0,275,51.000000),(494,82,0,275,1.000000),(495,77,0,276,51.000000),(496,82,0,276,1.000000),(497,77,0,277,51.000000),(498,82,0,277,1.000000),(499,77,0,278,51.000000),(500,82,0,278,1.000000),(501,77,0,279,51.000000),(502,82,0,279,1.000000),(503,77,0,280,51.000000),(504,82,0,280,1.000000),(505,77,0,281,51.000000),(506,82,0,281,1.000000),(507,77,0,282,51.000000),(508,82,0,282,1.000000),(509,77,0,283,51.000000),(510,82,0,283,1.000000),(511,77,0,284,51.000000),(512,82,0,284,1.000000),(513,77,0,285,51.000000),(514,82,0,285,1.000000),(515,77,0,286,51.000000),(516,77,0,287,47.000000),(517,82,0,287,1.000000),(518,77,0,288,47.000000),(519,82,0,288,1.000000),(520,77,0,289,47.000000),(521,82,0,289,1.000000),(522,77,0,290,47.000000),(523,82,0,290,1.000000),(524,77,0,291,47.000000),(525,82,0,291,1.000000),(526,77,0,292,47.000000),(527,82,0,292,1.000000),(528,77,0,293,47.000000),(529,82,0,293,1.000000),(530,77,0,294,47.000000),(531,82,0,294,1.000000),(532,77,0,295,47.000000),(533,82,0,295,1.000000),(534,77,0,296,47.000000),(535,82,0,296,1.000000),(536,77,0,297,47.000000),(537,82,0,297,1.000000),(538,77,0,298,47.000000),(539,82,0,298,1.000000),(540,77,0,299,47.000000),(541,82,0,299,1.000000),(542,77,0,300,47.000000),(543,82,0,300,1.000000),(544,77,0,301,47.000000),(545,82,0,301,1.000000),(546,77,0,302,47.000000),(547,77,0,303,72.000000),(548,82,0,303,1.000000),(549,77,0,304,72.000000),(550,82,0,304,1.000000),(551,77,0,305,72.000000),(552,82,0,305,1.000000),(553,77,0,306,72.000000),(554,82,0,306,1.000000),(555,77,0,307,72.000000),(556,82,0,307,1.000000),(557,77,0,308,72.000000),(558,82,0,308,1.000000),(559,77,0,309,72.000000),(560,82,0,309,1.000000),(561,77,0,310,72.000000),(562,82,0,310,1.000000),(563,77,0,311,72.000000),(564,82,0,311,1.000000),(565,77,0,312,72.000000),(566,82,0,312,1.000000),(567,77,0,313,72.000000),(568,82,0,313,1.000000),(569,77,0,314,72.000000),(570,82,0,314,1.000000),(571,77,0,315,72.000000),(572,82,0,315,1.000000),(573,77,0,316,72.000000),(574,82,0,316,1.000000),(575,77,0,317,72.000000),(576,82,0,317,1.000000),(577,77,0,318,72.000000),(578,77,0,319,99.000000),(579,82,0,319,1.000000),(580,77,0,320,99.000000),(581,82,0,320,1.000000),(582,77,0,321,99.000000),(583,82,0,321,1.000000),(584,77,0,322,99.000000),(585,82,0,322,1.000000),(586,77,0,323,99.000000),(587,82,0,323,1.000000),(588,77,0,324,99.000000),(589,82,0,324,1.000000),(590,77,0,325,99.000000),(591,82,0,325,1.000000),(592,77,0,326,99.000000),(593,82,0,326,1.000000),(594,77,0,327,99.000000),(595,82,0,327,1.000000),(596,77,0,328,99.000000),(597,82,0,328,1.000000),(598,77,0,329,99.000000),(599,82,0,329,1.000000),(600,77,0,330,99.000000),(601,82,0,330,1.000000),(602,77,0,331,99.000000),(603,82,0,331,1.000000),(604,77,0,332,99.000000),(605,82,0,332,1.000000),(606,77,0,333,99.000000),(607,82,0,333,1.000000),(608,77,0,334,99.000000),(609,77,0,335,65.000000),(610,82,0,335,1.000000),(611,77,0,336,65.000000),(612,82,0,336,1.000000),(613,77,0,337,65.000000),(614,82,0,337,1.000000),(615,77,0,338,65.000000),(616,82,0,338,1.000000),(617,77,0,339,65.000000),(618,82,0,339,1.000000),(619,77,0,340,65.000000),(620,82,0,340,1.000000),(621,77,0,341,65.000000),(622,82,0,341,1.000000),(623,77,0,342,65.000000),(624,82,0,342,1.000000),(625,77,0,343,65.000000),(626,82,0,343,1.000000),(627,77,0,344,65.000000),(628,82,0,344,1.000000),(629,77,0,345,65.000000),(630,82,0,345,1.000000),(631,77,0,346,65.000000),(632,82,0,346,1.000000),(633,77,0,347,65.000000),(634,82,0,347,1.000000),(635,77,0,348,65.000000),(636,82,0,348,1.000000),(637,77,0,349,65.000000),(638,82,0,349,1.000000),(639,77,0,350,65.000000),(640,77,0,351,66.000000),(641,82,0,351,1.000000),(642,77,0,352,66.000000),(643,82,0,352,1.000000),(644,77,0,353,66.000000),(645,82,0,353,1.000000),(646,77,0,354,66.000000),(647,82,0,354,1.000000),(648,77,0,355,66.000000),(649,82,0,355,1.000000),(650,77,0,356,66.000000),(651,82,0,356,1.000000),(652,77,0,357,66.000000),(653,82,0,357,1.000000),(654,77,0,358,66.000000),(655,82,0,358,1.000000),(656,77,0,359,66.000000),(657,82,0,359,1.000000),(658,77,0,360,66.000000),(659,82,0,360,1.000000),(660,77,0,361,66.000000),(661,82,0,361,1.000000),(662,77,0,362,66.000000),(663,82,0,362,1.000000),(664,77,0,363,66.000000),(665,82,0,363,1.000000),(666,77,0,364,66.000000),(667,82,0,364,1.000000),(668,77,0,365,66.000000),(669,82,0,365,1.000000),(670,77,0,366,66.000000),(671,77,0,367,60.000000),(672,82,0,367,1.000000),(673,77,0,368,60.000000),(674,82,0,368,1.000000),(675,77,0,369,60.000000),(676,82,0,369,1.000000),(677,77,0,370,60.000000),(678,82,0,370,1.000000),(679,77,0,371,60.000000),(680,82,0,371,1.000000),(681,77,0,372,60.000000),(682,82,0,372,1.000000),(683,77,0,373,60.000000),(684,82,0,373,1.000000),(685,77,0,374,60.000000),(686,82,0,374,1.000000),(687,77,0,375,60.000000),(688,82,0,375,1.000000),(689,77,0,376,60.000000),(690,82,0,376,1.000000),(691,77,0,377,60.000000),(692,82,0,377,1.000000),(693,77,0,378,60.000000),(694,82,0,378,1.000000),(695,77,0,379,60.000000),(696,82,0,379,1.000000),(697,77,0,380,60.000000),(698,82,0,380,1.000000),(699,77,0,381,60.000000),(700,82,0,381,1.000000),(701,77,0,382,60.000000),(702,77,0,383,56.990000),(703,82,0,383,1.000000),(704,77,0,384,56.990000),(705,82,0,384,1.000000),(706,77,0,385,56.990000),(707,82,0,385,1.000000),(708,77,0,386,56.990000),(709,82,0,386,1.000000),(710,77,0,387,56.990000),(711,82,0,387,1.000000),(712,77,0,388,56.990000),(713,82,0,388,1.000000),(714,77,0,389,56.990000),(715,82,0,389,1.000000),(716,77,0,390,56.990000),(717,82,0,390,1.000000),(718,77,0,391,56.990000),(719,82,0,391,1.000000),(720,77,0,392,56.990000),(721,82,0,392,1.000000),(722,77,0,393,56.990000),(723,82,0,393,1.000000),(724,77,0,394,56.990000),(725,82,0,394,1.000000),(726,77,0,395,56.990000),(727,82,0,395,1.000000),(728,77,0,396,56.990000),(729,82,0,396,1.000000),(730,77,0,397,56.990000),(731,82,0,397,1.000000),(732,77,0,398,56.990000),(733,77,0,399,49.000000),(734,82,0,399,1.000000),(735,77,0,400,49.000000),(736,82,0,400,1.000000),(737,77,0,401,49.000000),(738,82,0,401,1.000000),(739,77,0,402,49.000000),(740,82,0,402,1.000000),(741,77,0,403,49.000000),(742,82,0,403,1.000000),(743,77,0,404,49.000000),(744,82,0,404,1.000000),(745,77,0,405,49.000000),(746,82,0,405,1.000000),(747,77,0,406,49.000000),(748,82,0,406,1.000000),(749,77,0,407,49.000000),(750,82,0,407,1.000000),(751,77,0,408,49.000000),(752,82,0,408,1.000000),(753,77,0,409,49.000000),(754,82,0,409,1.000000),(755,77,0,410,49.000000),(756,82,0,410,1.000000),(757,77,0,411,49.000000),(758,82,0,411,1.000000),(759,77,0,412,49.000000),(760,82,0,412,1.000000),(761,77,0,413,49.000000),(762,82,0,413,1.000000),(763,77,0,414,49.000000),(764,77,0,415,45.000000),(765,82,0,415,1.000000),(766,77,0,416,45.000000),(767,82,0,416,1.000000),(768,77,0,417,45.000000),(769,82,0,417,1.000000),(770,77,0,418,45.000000),(771,82,0,418,1.000000),(772,77,0,419,45.000000),(773,82,0,419,1.000000),(774,77,0,420,45.000000),(775,82,0,420,1.000000),(776,77,0,421,45.000000),(777,82,0,421,1.000000),(778,77,0,422,45.000000),(779,82,0,422,1.000000),(780,77,0,423,45.000000),(781,82,0,423,1.000000),(782,77,0,424,45.000000),(783,82,0,424,1.000000),(784,77,0,425,45.000000),(785,82,0,425,1.000000),(786,77,0,426,45.000000),(787,82,0,426,1.000000),(788,77,0,427,45.000000),(789,82,0,427,1.000000),(790,77,0,428,45.000000),(791,82,0,428,1.000000),(792,77,0,429,45.000000),(793,82,0,429,1.000000),(794,77,0,430,45.000000),(795,77,0,431,29.000000),(796,82,0,431,1.000000),(797,77,0,432,29.000000),(798,82,0,432,1.000000),(799,77,0,433,29.000000),(800,82,0,433,1.000000),(801,77,0,434,29.000000),(802,82,0,434,1.000000),(803,77,0,435,29.000000),(804,82,0,435,1.000000),(805,77,0,436,29.000000),(806,82,0,436,1.000000),(807,77,0,437,29.000000),(808,82,0,437,1.000000),(809,77,0,438,29.000000),(810,82,0,438,1.000000),(811,77,0,439,29.000000),(812,82,0,439,1.000000),(813,77,0,440,29.000000),(814,82,0,440,1.000000),(815,77,0,441,29.000000),(816,82,0,441,1.000000),(817,77,0,442,29.000000),(818,82,0,442,1.000000),(819,77,0,443,29.000000),(820,82,0,443,1.000000),(821,77,0,444,29.000000),(822,82,0,444,1.000000),(823,77,0,445,29.000000),(824,82,0,445,1.000000),(825,77,0,446,29.000000),(826,77,0,447,24.000000),(827,82,0,447,1.000000),(828,77,0,448,24.000000),(829,82,0,448,1.000000),(830,77,0,449,24.000000),(831,82,0,449,1.000000),(832,77,0,450,24.000000),(833,82,0,450,1.000000),(834,77,0,451,24.000000),(835,82,0,451,1.000000),(836,77,0,452,24.000000),(837,82,0,452,1.000000),(838,77,0,453,24.000000),(839,82,0,453,1.000000),(840,77,0,454,24.000000),(841,82,0,454,1.000000),(842,77,0,455,24.000000),(843,82,0,455,1.000000),(844,77,0,456,24.000000),(845,82,0,456,1.000000),(846,77,0,457,24.000000),(847,82,0,457,1.000000),(848,77,0,458,24.000000),(849,82,0,458,1.000000),(850,77,0,459,24.000000),(851,82,0,459,1.000000),(852,77,0,460,24.000000),(853,82,0,460,1.000000),(854,77,0,461,24.000000),(855,82,0,461,1.000000),(856,77,0,462,24.000000),(857,77,0,463,32.000000),(858,82,0,463,1.000000),(859,77,0,464,32.000000),(860,82,0,464,1.000000),(861,77,0,465,32.000000),(862,82,0,465,1.000000),(863,77,0,466,32.000000),(864,82,0,466,1.000000),(865,77,0,467,32.000000),(866,82,0,467,1.000000),(867,77,0,468,32.000000),(868,82,0,468,1.000000),(869,77,0,469,32.000000),(870,82,0,469,1.000000),(871,77,0,470,32.000000),(872,82,0,470,1.000000),(873,77,0,471,32.000000),(874,82,0,471,1.000000),(875,77,0,472,32.000000),(876,82,0,472,1.000000),(877,77,0,473,32.000000),(878,82,0,473,1.000000),(879,77,0,474,32.000000),(880,82,0,474,1.000000),(881,77,0,475,32.000000),(882,82,0,475,1.000000),(883,77,0,476,32.000000),(884,82,0,476,1.000000),(885,77,0,477,32.000000),(886,82,0,477,1.000000),(887,77,0,478,32.000000),(888,77,0,479,28.000000),(889,82,0,479,1.000000),(890,77,0,480,28.000000),(891,82,0,480,1.000000),(892,77,0,481,28.000000),(893,82,0,481,1.000000),(894,77,0,482,28.000000),(895,82,0,482,1.000000),(896,77,0,483,28.000000),(897,82,0,483,1.000000),(898,77,0,484,28.000000),(899,82,0,484,1.000000),(900,77,0,485,28.000000),(901,82,0,485,1.000000),(902,77,0,486,28.000000),(903,82,0,486,1.000000),(904,77,0,487,28.000000),(905,82,0,487,1.000000),(906,77,0,488,28.000000),(907,82,0,488,1.000000),(908,77,0,489,28.000000),(909,82,0,489,1.000000),(910,77,0,490,28.000000),(911,82,0,490,1.000000),(912,77,0,491,28.000000),(913,82,0,491,1.000000),(914,77,0,492,28.000000),(915,82,0,492,1.000000),(916,77,0,493,28.000000),(917,82,0,493,1.000000),(918,77,0,494,28.000000),(919,77,0,495,29.000000),(920,82,0,495,1.000000),(921,77,0,496,29.000000),(922,82,0,496,1.000000),(923,77,0,497,29.000000),(924,82,0,497,1.000000),(925,77,0,498,29.000000),(926,82,0,498,1.000000),(927,77,0,499,29.000000),(928,82,0,499,1.000000),(929,77,0,500,29.000000),(930,82,0,500,1.000000),(931,77,0,501,29.000000),(932,82,0,501,1.000000),(933,77,0,502,29.000000),(934,82,0,502,1.000000),(935,77,0,503,29.000000),(936,82,0,503,1.000000),(937,77,0,504,29.000000),(938,82,0,504,1.000000),(939,77,0,505,29.000000),(940,82,0,505,1.000000),(941,77,0,506,29.000000),(942,82,0,506,1.000000),(943,77,0,507,29.000000),(944,82,0,507,1.000000),(945,77,0,508,29.000000),(946,82,0,508,1.000000),(947,77,0,509,29.000000),(948,82,0,509,1.000000),(949,77,0,510,29.000000),(950,77,0,511,29.000000),(951,82,0,511,1.000000),(952,77,0,512,29.000000),(953,82,0,512,1.000000),(954,77,0,513,29.000000),(955,82,0,513,1.000000),(956,77,0,514,29.000000),(957,82,0,514,1.000000),(958,77,0,515,29.000000),(959,82,0,515,1.000000),(960,77,0,516,29.000000),(961,82,0,516,1.000000),(962,77,0,517,29.000000),(963,82,0,517,1.000000),(964,77,0,518,29.000000),(965,82,0,518,1.000000),(966,77,0,519,29.000000),(967,82,0,519,1.000000),(968,77,0,520,29.000000),(969,82,0,520,1.000000),(970,77,0,521,29.000000),(971,82,0,521,1.000000),(972,77,0,522,29.000000),(973,82,0,522,1.000000),(974,77,0,523,29.000000),(975,82,0,523,1.000000),(976,77,0,524,29.000000),(977,82,0,524,1.000000),(978,77,0,525,29.000000),(979,82,0,525,1.000000),(980,77,0,526,29.000000),(981,77,0,527,29.000000),(982,82,0,527,1.000000),(983,77,0,528,29.000000),(984,82,0,528,1.000000),(985,77,0,529,29.000000),(986,82,0,529,1.000000),(987,77,0,530,29.000000),(988,82,0,530,1.000000),(989,77,0,531,29.000000),(990,82,0,531,1.000000),(991,77,0,532,29.000000),(992,82,0,532,1.000000),(993,77,0,533,29.000000),(994,82,0,533,1.000000),(995,77,0,534,29.000000),(996,82,0,534,1.000000),(997,77,0,535,29.000000),(998,82,0,535,1.000000),(999,77,0,536,29.000000),(1000,82,0,536,1.000000),(1001,77,0,537,29.000000),(1002,82,0,537,1.000000),(1003,77,0,538,29.000000),(1004,82,0,538,1.000000),(1005,77,0,539,29.000000),(1006,82,0,539,1.000000),(1007,77,0,540,29.000000),(1008,82,0,540,1.000000),(1009,77,0,541,29.000000),(1010,82,0,541,1.000000),(1011,77,0,542,29.000000),(1012,77,0,543,24.000000),(1013,82,0,543,1.000000),(1014,77,0,544,24.000000),(1015,82,0,544,1.000000),(1016,77,0,545,24.000000),(1017,82,0,545,1.000000),(1018,77,0,546,24.000000),(1019,82,0,546,1.000000),(1020,77,0,547,24.000000),(1021,82,0,547,1.000000),(1022,77,0,548,24.000000),(1023,82,0,548,1.000000),(1024,77,0,549,24.000000),(1025,82,0,549,1.000000),(1026,77,0,550,24.000000),(1027,82,0,550,1.000000),(1028,77,0,551,24.000000),(1029,82,0,551,1.000000),(1030,77,0,552,24.000000),(1031,82,0,552,1.000000),(1032,77,0,553,24.000000),(1033,82,0,553,1.000000),(1034,77,0,554,24.000000),(1035,82,0,554,1.000000),(1036,77,0,555,24.000000),(1037,82,0,555,1.000000),(1038,77,0,556,24.000000),(1039,82,0,556,1.000000),(1040,77,0,557,24.000000),(1041,82,0,557,1.000000),(1042,77,0,558,24.000000),(1043,77,0,559,28.000000),(1044,82,0,559,1.000000),(1045,77,0,560,28.000000),(1046,82,0,560,1.000000),(1047,77,0,561,28.000000),(1048,82,0,561,1.000000),(1049,77,0,562,28.000000),(1050,82,0,562,1.000000),(1051,77,0,563,28.000000),(1052,82,0,563,1.000000),(1053,77,0,564,28.000000),(1054,82,0,564,1.000000),(1055,77,0,565,28.000000),(1056,82,0,565,1.000000),(1057,77,0,566,28.000000),(1058,82,0,566,1.000000),(1059,77,0,567,28.000000),(1060,82,0,567,1.000000),(1061,77,0,568,28.000000),(1062,82,0,568,1.000000),(1063,77,0,569,28.000000),(1064,82,0,569,1.000000),(1065,77,0,570,28.000000),(1066,82,0,570,1.000000),(1067,77,0,571,28.000000),(1068,82,0,571,1.000000),(1069,77,0,572,28.000000),(1070,82,0,572,1.000000),(1071,77,0,573,28.000000),(1072,82,0,573,1.000000),(1073,77,0,574,28.000000),(1074,77,0,575,24.000000),(1075,82,0,575,1.000000),(1076,77,0,576,24.000000),(1077,82,0,576,1.000000),(1078,77,0,577,24.000000),(1079,82,0,577,1.000000),(1080,77,0,578,24.000000),(1081,82,0,578,1.000000),(1082,77,0,579,24.000000),(1083,82,0,579,1.000000),(1084,77,0,580,24.000000),(1085,82,0,580,1.000000),(1086,77,0,581,24.000000),(1087,82,0,581,1.000000),(1088,77,0,582,24.000000),(1089,82,0,582,1.000000),(1090,77,0,583,24.000000),(1091,82,0,583,1.000000),(1092,77,0,584,24.000000),(1093,82,0,584,1.000000),(1094,77,0,585,24.000000),(1095,82,0,585,1.000000),(1096,77,0,586,24.000000),(1097,82,0,586,1.000000),(1098,77,0,587,24.000000),(1099,82,0,587,1.000000),(1100,77,0,588,24.000000),(1101,82,0,588,1.000000),(1102,77,0,589,24.000000),(1103,82,0,589,1.000000),(1104,77,0,590,24.000000),(1105,77,0,591,39.000000),(1106,82,0,591,1.000000),(1107,77,0,592,39.000000),(1108,82,0,592,1.000000),(1109,77,0,593,39.000000),(1110,82,0,593,1.000000),(1111,77,0,594,39.000000),(1112,82,0,594,1.000000),(1113,77,0,595,39.000000),(1114,82,0,595,1.000000),(1115,77,0,596,39.000000),(1116,82,0,596,1.000000),(1117,77,0,597,39.000000),(1118,82,0,597,1.000000),(1119,77,0,598,39.000000),(1120,82,0,598,1.000000),(1121,77,0,599,39.000000),(1122,82,0,599,1.000000),(1123,77,0,600,39.000000),(1124,82,0,600,1.000000),(1125,77,0,601,39.000000),(1126,82,0,601,1.000000),(1127,77,0,602,39.000000),(1128,82,0,602,1.000000),(1129,77,0,603,39.000000),(1130,82,0,603,1.000000),(1131,77,0,604,39.000000),(1132,82,0,604,1.000000),(1133,77,0,605,39.000000),(1134,82,0,605,1.000000),(1135,77,0,606,39.000000),(1136,77,0,607,39.000000),(1137,82,0,607,1.000000),(1138,77,0,608,39.000000),(1139,82,0,608,1.000000),(1140,77,0,609,39.000000),(1141,82,0,609,1.000000),(1142,77,0,610,39.000000),(1143,82,0,610,1.000000),(1144,77,0,611,39.000000),(1145,82,0,611,1.000000),(1146,77,0,612,39.000000),(1147,82,0,612,1.000000),(1148,77,0,613,39.000000),(1149,82,0,613,1.000000),(1150,77,0,614,39.000000),(1151,82,0,614,1.000000),(1152,77,0,615,39.000000),(1153,82,0,615,1.000000),(1154,77,0,616,39.000000),(1155,82,0,616,1.000000),(1156,77,0,617,39.000000),(1157,82,0,617,1.000000),(1158,77,0,618,39.000000),(1159,82,0,618,1.000000),(1160,77,0,619,39.000000),(1161,82,0,619,1.000000),(1162,77,0,620,39.000000),(1163,82,0,620,1.000000),(1164,77,0,621,39.000000),(1165,82,0,621,1.000000),(1166,77,0,622,39.000000),(1167,77,0,623,29.000000),(1168,82,0,623,1.000000),(1169,77,0,624,29.000000),(1170,82,0,624,1.000000),(1171,77,0,625,29.000000),(1172,82,0,625,1.000000),(1173,77,0,626,29.000000),(1174,82,0,626,1.000000),(1175,77,0,627,29.000000),(1176,82,0,627,1.000000),(1177,77,0,628,29.000000),(1178,82,0,628,1.000000),(1179,77,0,629,29.000000),(1180,82,0,629,1.000000),(1181,77,0,630,29.000000),(1182,82,0,630,1.000000),(1183,77,0,631,29.000000),(1184,82,0,631,1.000000),(1185,77,0,632,29.000000),(1186,82,0,632,1.000000),(1187,77,0,633,29.000000),(1188,82,0,633,1.000000),(1189,77,0,634,29.000000),(1190,82,0,634,1.000000),(1191,77,0,635,29.000000),(1192,82,0,635,1.000000),(1193,77,0,636,29.000000),(1194,82,0,636,1.000000),(1195,77,0,637,29.000000),(1196,82,0,637,1.000000),(1197,77,0,638,29.000000),(1198,77,0,639,29.000000),(1199,82,0,639,1.000000),(1200,77,0,640,29.000000),(1201,82,0,640,1.000000),(1202,77,0,641,29.000000),(1203,82,0,641,1.000000),(1204,77,0,642,29.000000),(1205,82,0,642,1.000000),(1206,77,0,643,29.000000),(1207,82,0,643,1.000000),(1208,77,0,644,29.000000),(1209,82,0,644,1.000000),(1210,77,0,645,29.000000),(1211,82,0,645,1.000000),(1212,77,0,646,29.000000),(1213,82,0,646,1.000000),(1214,77,0,647,29.000000),(1215,82,0,647,1.000000),(1216,77,0,648,29.000000),(1217,82,0,648,1.000000),(1218,77,0,649,29.000000),(1219,82,0,649,1.000000),(1220,77,0,650,29.000000),(1221,82,0,650,1.000000),(1222,77,0,651,29.000000),(1223,82,0,651,1.000000),(1224,77,0,652,29.000000),(1225,82,0,652,1.000000),(1226,77,0,653,29.000000),(1227,82,0,653,1.000000),(1228,77,0,654,29.000000),(1229,77,0,655,29.000000),(1230,82,0,655,1.000000),(1231,77,0,656,29.000000),(1232,82,0,656,1.000000),(1233,77,0,657,29.000000),(1234,82,0,657,1.000000),(1235,77,0,658,29.000000),(1236,82,0,658,1.000000),(1237,77,0,659,29.000000),(1238,82,0,659,1.000000),(1239,77,0,660,29.000000),(1240,82,0,660,1.000000),(1241,77,0,661,29.000000),(1242,82,0,661,1.000000),(1243,77,0,662,29.000000),(1244,82,0,662,1.000000),(1245,77,0,663,29.000000),(1246,82,0,663,1.000000),(1247,77,0,664,29.000000),(1248,82,0,664,1.000000),(1249,77,0,665,29.000000),(1250,82,0,665,1.000000),(1251,77,0,666,29.000000),(1252,82,0,666,1.000000),(1253,77,0,667,29.000000),(1254,82,0,667,1.000000),(1255,77,0,668,29.000000),(1256,82,0,668,1.000000),(1257,77,0,669,29.000000),(1258,82,0,669,1.000000),(1259,77,0,670,29.000000),(1260,77,0,671,32.000000),(1261,82,0,671,1.000000),(1262,77,0,672,32.000000),(1263,82,0,672,1.000000),(1264,77,0,673,32.000000),(1265,82,0,673,1.000000),(1266,77,0,674,32.000000),(1267,82,0,674,1.000000),(1268,77,0,675,32.000000),(1269,82,0,675,1.000000),(1270,77,0,676,32.000000),(1271,77,0,677,24.000000),(1272,82,0,677,1.000000),(1273,77,0,678,24.000000),(1274,82,0,678,1.000000),(1275,77,0,679,24.000000),(1276,82,0,679,1.000000),(1277,77,0,680,24.000000),(1278,82,0,680,1.000000),(1279,77,0,681,24.000000),(1280,82,0,681,1.000000),(1281,77,0,682,24.000000),(1282,77,0,683,28.000000),(1283,82,0,683,1.000000),(1284,77,0,684,28.000000),(1285,82,0,684,1.000000),(1286,77,0,685,28.000000),(1287,82,0,685,1.000000),(1288,77,0,686,28.000000),(1289,82,0,686,1.000000),(1290,77,0,687,28.000000),(1291,82,0,687,1.000000),(1292,77,0,688,28.000000),(1293,77,0,689,22.000000),(1294,82,0,689,1.000000),(1295,77,0,690,22.000000),(1296,82,0,690,1.000000),(1297,77,0,691,22.000000),(1298,82,0,691,1.000000),(1299,77,0,692,22.000000),(1300,82,0,692,1.000000),(1301,77,0,693,22.000000),(1302,82,0,693,1.000000),(1303,77,0,694,22.000000),(1304,77,0,695,29.000000),(1305,82,0,695,1.000000),(1306,77,0,696,29.000000),(1307,82,0,696,1.000000),(1308,77,0,697,29.000000),(1309,82,0,697,1.000000),(1310,77,0,698,29.000000),(1311,82,0,698,1.000000),(1312,77,0,699,29.000000),(1313,82,0,699,1.000000),(1314,77,0,700,29.000000),(1315,77,0,701,29.000000),(1316,82,0,701,1.000000),(1317,77,0,702,29.000000),(1318,82,0,702,1.000000),(1319,77,0,703,29.000000),(1320,82,0,703,1.000000),(1321,77,0,704,29.000000),(1322,82,0,704,1.000000),(1323,77,0,705,29.000000),(1324,82,0,705,1.000000),(1325,77,0,706,29.000000),(1326,77,0,707,18.000000),(1327,82,0,707,1.000000),(1328,77,0,708,18.000000),(1329,82,0,708,1.000000),(1330,77,0,709,18.000000),(1331,82,0,709,1.000000),(1332,77,0,710,18.000000),(1333,82,0,710,1.000000),(1334,77,0,711,18.000000),(1335,82,0,711,1.000000),(1336,77,0,712,18.000000),(1337,77,0,713,18.000000),(1338,82,0,713,1.000000),(1339,77,0,714,18.000000),(1340,82,0,714,1.000000),(1341,77,0,715,18.000000),(1342,82,0,715,1.000000),(1343,77,0,716,18.000000),(1344,82,0,716,1.000000),(1345,77,0,717,18.000000),(1346,82,0,717,1.000000),(1347,77,0,718,18.000000),(1348,77,0,719,18.000000),(1349,82,0,719,1.000000),(1350,77,0,720,18.000000),(1351,82,0,720,1.000000),(1352,77,0,721,18.000000),(1353,82,0,721,1.000000),(1354,77,0,722,18.000000),(1355,82,0,722,1.000000),(1356,77,0,723,18.000000),(1357,82,0,723,1.000000),(1358,77,0,724,18.000000),(1359,77,0,725,35.000000),(1360,82,0,725,1.000000),(1361,77,0,726,35.000000),(1362,82,0,726,1.000000),(1363,77,0,727,35.000000),(1364,82,0,727,1.000000),(1365,77,0,728,35.000000),(1366,82,0,728,1.000000),(1367,77,0,729,35.000000),(1368,82,0,729,1.000000),(1369,77,0,730,35.000000),(1370,82,0,730,1.000000),(1371,77,0,731,35.000000),(1372,82,0,731,1.000000),(1373,77,0,732,35.000000),(1374,82,0,732,1.000000),(1375,77,0,733,35.000000),(1376,82,0,733,1.000000),(1377,77,0,734,35.000000),(1378,82,0,734,1.000000),(1379,77,0,735,35.000000),(1380,82,0,735,1.000000),(1381,77,0,736,35.000000),(1382,82,0,736,1.000000),(1383,77,0,737,35.000000),(1384,77,0,738,46.000000),(1385,82,0,738,1.000000),(1386,77,0,739,46.000000),(1387,82,0,739,1.000000),(1388,77,0,740,46.000000),(1389,82,0,740,1.000000),(1390,77,0,741,46.000000),(1391,82,0,741,1.000000),(1392,77,0,742,46.000000),(1393,82,0,742,1.000000),(1394,77,0,743,46.000000),(1395,82,0,743,1.000000),(1396,77,0,744,46.000000),(1397,82,0,744,1.000000),(1398,77,0,745,46.000000),(1399,82,0,745,1.000000),(1400,77,0,746,46.000000),(1401,82,0,746,1.000000),(1402,77,0,747,46.000000),(1403,82,0,747,1.000000),(1404,77,0,748,46.000000),(1405,82,0,748,1.000000),(1406,77,0,749,46.000000),(1407,82,0,749,1.000000),(1408,77,0,750,46.000000),(1409,77,0,751,51.000000),(1410,82,0,751,1.000000),(1411,77,0,752,51.000000),(1412,82,0,752,1.000000),(1413,77,0,753,51.000000),(1414,82,0,753,1.000000),(1415,77,0,754,51.000000),(1416,82,0,754,1.000000),(1417,77,0,755,51.000000),(1418,82,0,755,1.000000),(1419,77,0,756,51.000000),(1420,82,0,756,1.000000),(1421,77,0,757,51.000000),(1422,82,0,757,1.000000),(1423,77,0,758,51.000000),(1424,82,0,758,1.000000),(1425,77,0,759,51.000000),(1426,82,0,759,1.000000),(1427,77,0,760,51.000000),(1428,82,0,760,1.000000),(1429,77,0,761,51.000000),(1430,82,0,761,1.000000),(1431,77,0,762,51.000000),(1432,82,0,762,1.000000),(1433,77,0,763,51.000000),(1434,77,0,764,45.000000),(1435,82,0,764,1.000000),(1436,77,0,765,45.000000),(1437,82,0,765,1.000000),(1438,77,0,766,45.000000),(1439,82,0,766,1.000000),(1440,77,0,767,45.000000),(1441,82,0,767,1.000000),(1442,77,0,768,45.000000),(1443,82,0,768,1.000000),(1444,77,0,769,45.000000),(1445,82,0,769,1.000000),(1446,77,0,770,45.000000),(1447,82,0,770,1.000000),(1448,77,0,771,45.000000),(1449,82,0,771,1.000000),(1450,77,0,772,45.000000),(1451,82,0,772,1.000000),(1452,77,0,773,45.000000),(1453,82,0,773,1.000000),(1454,77,0,774,45.000000),(1455,82,0,774,1.000000),(1456,77,0,775,45.000000),(1457,82,0,775,1.000000),(1458,77,0,776,45.000000),(1459,77,0,777,57.000000),(1460,82,0,777,1.000000),(1461,77,0,778,57.000000),(1462,82,0,778,1.000000),(1463,77,0,779,57.000000),(1464,82,0,779,1.000000),(1465,77,0,780,57.000000),(1466,82,0,780,1.000000),(1467,77,0,781,57.000000),(1468,82,0,781,1.000000),(1469,77,0,782,57.000000),(1470,82,0,782,1.000000),(1471,77,0,783,57.000000),(1472,82,0,783,1.000000),(1473,77,0,784,57.000000),(1474,82,0,784,1.000000),(1475,77,0,785,57.000000),(1476,82,0,785,1.000000),(1477,77,0,786,57.000000),(1478,82,0,786,1.000000),(1479,77,0,787,57.000000),(1480,82,0,787,1.000000),(1481,77,0,788,57.000000),(1482,82,0,788,1.000000),(1483,77,0,789,57.000000),(1484,77,0,790,28.000000),(1485,82,0,790,1.000000),(1486,77,0,791,28.000000),(1487,82,0,791,1.000000),(1488,77,0,792,28.000000),(1489,82,0,792,1.000000),(1490,77,0,793,28.000000),(1491,82,0,793,1.000000),(1492,77,0,794,28.000000),(1493,82,0,794,1.000000),(1494,77,0,795,28.000000),(1495,82,0,795,1.000000),(1496,77,0,796,28.000000),(1497,82,0,796,1.000000),(1498,77,0,797,28.000000),(1499,82,0,797,1.000000),(1500,77,0,798,28.000000),(1501,82,0,798,1.000000),(1502,77,0,799,28.000000),(1503,82,0,799,1.000000),(1504,77,0,800,28.000000),(1505,82,0,800,1.000000),(1506,77,0,801,28.000000),(1507,82,0,801,1.000000),(1508,77,0,802,28.000000),(1509,77,0,803,68.000000),(1510,82,0,803,1.000000),(1511,77,0,804,68.000000),(1512,82,0,804,1.000000),(1513,77,0,805,68.000000),(1514,82,0,805,1.000000),(1515,77,0,806,68.000000),(1516,82,0,806,1.000000),(1517,77,0,807,68.000000),(1518,82,0,807,1.000000),(1519,77,0,808,68.000000),(1520,82,0,808,1.000000),(1521,77,0,809,68.000000),(1522,82,0,809,1.000000),(1523,77,0,810,68.000000),(1524,82,0,810,1.000000),(1525,77,0,811,68.000000),(1526,82,0,811,1.000000),(1527,77,0,812,68.000000),(1528,82,0,812,1.000000),(1529,77,0,813,68.000000),(1530,82,0,813,1.000000),(1531,77,0,814,68.000000),(1532,82,0,814,1.000000),(1533,77,0,815,68.000000),(1534,77,0,816,82.000000),(1535,82,0,816,1.000000),(1536,77,0,817,82.000000),(1537,82,0,817,1.000000),(1538,77,0,818,82.000000),(1539,82,0,818,1.000000),(1540,77,0,819,82.000000),(1541,82,0,819,1.000000),(1542,77,0,820,82.000000),(1543,82,0,820,1.000000),(1544,77,0,821,82.000000),(1545,82,0,821,1.000000),(1546,77,0,822,82.000000),(1547,82,0,822,1.000000),(1548,77,0,823,82.000000),(1549,82,0,823,1.000000),(1550,77,0,824,82.000000),(1551,82,0,824,1.000000),(1552,77,0,825,82.000000),(1553,82,0,825,1.000000),(1554,77,0,826,82.000000),(1555,82,0,826,1.000000),(1556,77,0,827,82.000000),(1557,82,0,827,1.000000),(1558,77,0,828,82.000000),(1559,77,0,829,75.000000),(1560,82,0,829,1.000000),(1561,77,0,830,75.000000),(1562,82,0,830,1.000000),(1563,77,0,831,75.000000),(1564,82,0,831,1.000000),(1565,77,0,832,75.000000),(1566,82,0,832,1.000000),(1567,77,0,833,75.000000),(1568,82,0,833,1.000000),(1569,77,0,834,75.000000),(1570,82,0,834,1.000000),(1571,77,0,835,75.000000),(1572,82,0,835,1.000000),(1573,77,0,836,75.000000),(1574,82,0,836,1.000000),(1575,77,0,837,75.000000),(1576,82,0,837,1.000000),(1577,77,0,838,75.000000),(1578,82,0,838,1.000000),(1579,77,0,839,75.000000),(1580,82,0,839,1.000000),(1581,77,0,840,75.000000),(1582,82,0,840,1.000000),(1583,77,0,841,75.000000),(1584,77,0,842,66.000000),(1585,82,0,842,1.000000),(1586,77,0,843,66.000000),(1587,82,0,843,1.000000),(1588,77,0,844,66.000000),(1589,82,0,844,1.000000),(1590,77,0,845,66.000000),(1591,82,0,845,1.000000),(1592,77,0,846,66.000000),(1593,82,0,846,1.000000),(1594,77,0,847,66.000000),(1595,82,0,847,1.000000),(1596,77,0,848,66.000000),(1597,82,0,848,1.000000),(1598,77,0,849,66.000000),(1599,82,0,849,1.000000),(1600,77,0,850,66.000000),(1601,82,0,850,1.000000),(1602,77,0,851,66.000000),(1603,82,0,851,1.000000),(1604,77,0,852,66.000000),(1605,82,0,852,1.000000),(1606,77,0,853,66.000000),(1607,82,0,853,1.000000),(1608,77,0,854,66.000000),(1609,77,0,855,74.000000),(1610,82,0,855,1.000000),(1611,77,0,856,74.000000),(1612,82,0,856,1.000000),(1613,77,0,857,74.000000),(1614,82,0,857,1.000000),(1615,77,0,858,74.000000),(1616,82,0,858,1.000000),(1617,77,0,859,74.000000),(1618,82,0,859,1.000000),(1619,77,0,860,74.000000),(1620,82,0,860,1.000000),(1621,77,0,861,74.000000),(1622,82,0,861,1.000000),(1623,77,0,862,74.000000),(1624,82,0,862,1.000000),(1625,77,0,863,74.000000),(1626,82,0,863,1.000000),(1627,77,0,864,74.000000),(1628,82,0,864,1.000000),(1629,77,0,865,74.000000),(1630,82,0,865,1.000000),(1631,77,0,866,74.000000),(1632,82,0,866,1.000000),(1633,77,0,867,74.000000),(1634,77,0,868,48.000000),(1635,82,0,868,1.000000),(1636,77,0,869,48.000000),(1637,82,0,869,1.000000),(1638,77,0,870,48.000000),(1639,82,0,870,1.000000),(1640,77,0,871,48.000000),(1641,82,0,871,1.000000),(1642,77,0,872,48.000000),(1643,82,0,872,1.000000),(1644,77,0,873,48.000000),(1645,82,0,873,1.000000),(1646,77,0,874,48.000000),(1647,82,0,874,1.000000),(1648,77,0,875,48.000000),(1649,82,0,875,1.000000),(1650,77,0,876,48.000000),(1651,82,0,876,1.000000),(1652,77,0,877,48.000000),(1653,82,0,877,1.000000),(1654,77,0,878,48.000000),(1655,82,0,878,1.000000),(1656,77,0,879,48.000000),(1657,82,0,879,1.000000),(1658,77,0,880,48.000000),(1659,77,0,881,44.000000),(1660,82,0,881,1.000000),(1661,77,0,882,44.000000),(1662,82,0,882,1.000000),(1663,77,0,883,44.000000),(1664,82,0,883,1.000000),(1665,77,0,884,44.000000),(1666,82,0,884,1.000000),(1667,77,0,885,44.000000),(1668,82,0,885,1.000000),(1669,77,0,886,44.000000),(1670,82,0,886,1.000000),(1671,77,0,887,44.000000),(1672,82,0,887,1.000000),(1673,77,0,888,44.000000),(1674,82,0,888,1.000000),(1675,77,0,889,44.000000),(1676,82,0,889,1.000000),(1677,77,0,890,44.000000),(1678,82,0,890,1.000000),(1679,77,0,891,44.000000),(1680,82,0,891,1.000000),(1681,77,0,892,44.000000),(1682,82,0,892,1.000000),(1683,77,0,893,44.000000),(1684,77,0,894,32.500000),(1685,82,0,894,1.000000),(1686,77,0,895,32.500000),(1687,82,0,895,1.000000),(1688,77,0,896,32.500000),(1689,82,0,896,1.000000),(1690,77,0,897,32.500000),(1691,82,0,897,1.000000),(1692,77,0,898,32.500000),(1693,77,0,899,32.500000),(1694,82,0,899,1.000000),(1695,77,0,900,32.500000),(1696,82,0,900,1.000000),(1697,77,0,901,32.500000),(1698,82,0,901,1.000000),(1699,77,0,902,32.500000),(1700,82,0,902,1.000000),(1701,77,0,903,32.500000),(1702,82,0,903,1.000000),(1703,77,0,904,32.500000),(1704,82,0,904,1.000000),(1705,77,0,905,32.500000),(1706,82,0,905,1.000000),(1707,77,0,906,32.500000),(1708,82,0,906,1.000000),(1709,77,0,907,32.500000),(1710,82,0,907,1.000000),(1711,77,0,908,32.500000),(1712,82,0,908,1.000000),(1713,77,0,909,32.500000),(1714,82,0,909,1.000000),(1715,77,0,910,32.500000),(1716,82,0,910,1.000000),(1717,77,0,911,32.500000),(1718,77,0,912,32.500000),(1719,82,0,912,1.000000),(1720,77,0,913,32.500000),(1721,82,0,913,1.000000),(1722,77,0,914,32.500000),(1723,82,0,914,1.000000),(1724,77,0,915,32.500000),(1725,82,0,915,1.000000),(1726,77,0,916,32.500000),(1727,82,0,916,1.000000),(1728,77,0,917,32.500000),(1729,82,0,917,1.000000),(1730,77,0,918,32.500000),(1731,82,0,918,1.000000),(1732,77,0,919,32.500000),(1733,82,0,919,1.000000),(1734,77,0,920,32.500000),(1735,82,0,920,1.000000),(1736,77,0,921,32.500000),(1737,82,0,921,1.000000),(1738,77,0,922,32.500000),(1739,82,0,922,1.000000),(1740,77,0,923,32.500000),(1741,82,0,923,1.000000),(1742,77,0,924,32.500000),(1743,77,0,925,29.000000),(1744,82,0,925,1.000000),(1745,77,0,926,29.000000),(1746,82,0,926,1.000000),(1747,77,0,927,29.000000),(1748,82,0,927,1.000000),(1749,77,0,928,29.000000),(1750,82,0,928,1.000000),(1751,77,0,929,29.000000),(1752,82,0,929,1.000000),(1753,77,0,930,29.000000),(1754,82,0,930,1.000000),(1755,77,0,931,29.000000),(1756,82,0,931,1.000000),(1757,77,0,932,29.000000),(1758,82,0,932,1.000000),(1759,77,0,933,29.000000),(1760,82,0,933,1.000000),(1761,77,0,934,29.000000),(1762,82,0,934,1.000000),(1763,77,0,935,29.000000),(1764,82,0,935,1.000000),(1765,77,0,936,29.000000),(1766,82,0,936,1.000000),(1767,77,0,937,29.000000),(1768,77,0,938,32.000000),(1769,82,0,938,1.000000),(1770,77,0,939,32.000000),(1771,82,0,939,1.000000),(1772,77,0,940,32.000000),(1773,82,0,940,1.000000),(1774,77,0,941,32.000000),(1775,82,0,941,1.000000),(1776,77,0,942,32.000000),(1777,82,0,942,1.000000),(1778,77,0,943,32.000000),(1779,82,0,943,1.000000),(1780,77,0,944,32.000000),(1781,82,0,944,1.000000),(1782,77,0,945,32.000000),(1783,82,0,945,1.000000),(1784,77,0,946,32.000000),(1785,82,0,946,1.000000),(1786,77,0,947,32.000000),(1787,82,0,947,1.000000),(1788,77,0,948,32.000000),(1789,82,0,948,1.000000),(1790,77,0,949,32.000000),(1791,82,0,949,1.000000),(1792,77,0,950,32.000000),(1793,77,0,951,35.000000),(1794,82,0,951,1.000000),(1795,77,0,952,35.000000),(1796,82,0,952,1.000000),(1797,77,0,953,35.000000),(1798,82,0,953,1.000000),(1799,77,0,954,35.000000),(1800,82,0,954,1.000000),(1801,77,0,955,35.000000),(1802,82,0,955,1.000000),(1803,77,0,956,35.000000),(1804,82,0,956,1.000000),(1805,77,0,957,35.000000),(1806,82,0,957,1.000000),(1807,77,0,958,35.000000),(1808,82,0,958,1.000000),(1809,77,0,959,35.000000),(1810,82,0,959,1.000000),(1811,77,0,960,35.000000),(1812,82,0,960,1.000000),(1813,77,0,961,35.000000),(1814,82,0,961,1.000000),(1815,77,0,962,35.000000),(1816,82,0,962,1.000000),(1817,77,0,963,35.000000),(1818,77,0,964,35.000000),(1819,82,0,964,1.000000),(1820,77,0,965,35.000000),(1821,82,0,965,1.000000),(1822,77,0,966,35.000000),(1823,82,0,966,1.000000),(1824,77,0,967,35.000000),(1825,82,0,967,1.000000),(1826,77,0,968,35.000000),(1827,82,0,968,1.000000),(1828,77,0,969,35.000000),(1829,82,0,969,1.000000),(1830,77,0,970,35.000000),(1831,82,0,970,1.000000),(1832,77,0,971,35.000000),(1833,82,0,971,1.000000),(1834,77,0,972,35.000000),(1835,82,0,972,1.000000),(1836,77,0,973,35.000000),(1837,82,0,973,1.000000),(1838,77,0,974,35.000000),(1839,82,0,974,1.000000),(1840,77,0,975,35.000000),(1841,82,0,975,1.000000),(1842,77,0,976,35.000000),(1843,77,0,977,24.000000),(1844,82,0,977,1.000000),(1845,77,0,978,24.000000),(1846,82,0,978,1.000000),(1847,77,0,979,24.000000),(1848,82,0,979,1.000000),(1849,77,0,980,24.000000),(1850,82,0,980,1.000000),(1851,77,0,981,24.000000),(1852,82,0,981,1.000000),(1853,77,0,982,24.000000),(1854,82,0,982,1.000000),(1855,77,0,983,24.000000),(1856,82,0,983,1.000000),(1857,77,0,984,24.000000),(1858,82,0,984,1.000000),(1859,77,0,985,24.000000),(1860,82,0,985,1.000000),(1861,77,0,986,24.000000),(1862,82,0,986,1.000000),(1863,77,0,987,24.000000),(1864,82,0,987,1.000000),(1865,77,0,988,24.000000),(1866,82,0,988,1.000000),(1867,77,0,989,24.000000),(1868,77,0,990,32.000000),(1869,82,0,990,1.000000),(1870,77,0,991,32.000000),(1871,82,0,991,1.000000),(1872,77,0,992,32.000000),(1873,82,0,992,1.000000),(1874,77,0,993,32.000000),(1875,82,0,993,1.000000),(1876,77,0,994,32.000000),(1877,82,0,994,1.000000),(1878,77,0,995,32.000000),(1879,82,0,995,1.000000),(1880,77,0,996,32.000000),(1881,82,0,996,1.000000),(1882,77,0,997,32.000000),(1883,82,0,997,1.000000),(1884,77,0,998,32.000000),(1885,82,0,998,1.000000),(1886,77,0,999,32.000000),(1887,82,0,999,1.000000),(1888,77,0,1000,32.000000),(1889,82,0,1000,1.000000),(1890,77,0,1001,32.000000),(1891,82,0,1001,1.000000),(1892,77,0,1002,32.000000),(1893,77,0,1003,20.000000),(1894,82,0,1003,1.000000),(1895,77,0,1004,20.000000),(1896,82,0,1004,1.000000),(1897,77,0,1005,20.000000),(1898,82,0,1005,1.000000),(1899,77,0,1006,20.000000),(1900,82,0,1006,1.000000),(1901,77,0,1007,20.000000),(1902,82,0,1007,1.000000),(1903,77,0,1008,20.000000),(1904,82,0,1008,1.000000),(1905,77,0,1009,20.000000),(1906,82,0,1009,1.000000),(1907,77,0,1010,20.000000),(1908,82,0,1010,1.000000),(1909,77,0,1011,20.000000),(1910,82,0,1011,1.000000),(1911,77,0,1012,20.000000),(1912,82,0,1012,1.000000),(1913,77,0,1013,20.000000),(1914,82,0,1013,1.000000),(1915,77,0,1014,20.000000),(1916,82,0,1014,1.000000),(1917,77,0,1015,20.000000),(1918,77,0,1016,27.000000),(1919,82,0,1016,1.000000),(1920,77,0,1017,27.000000),(1921,82,0,1017,1.000000),(1922,77,0,1018,27.000000),(1923,82,0,1018,1.000000),(1924,77,0,1019,27.000000),(1925,82,0,1019,1.000000),(1926,77,0,1020,27.000000),(1927,82,0,1020,1.000000),(1928,77,0,1021,27.000000),(1929,82,0,1021,1.000000),(1930,77,0,1022,27.000000),(1931,82,0,1022,1.000000),(1932,77,0,1023,27.000000),(1933,82,0,1023,1.000000),(1934,77,0,1024,27.000000),(1935,82,0,1024,1.000000),(1936,77,0,1025,27.000000),(1937,82,0,1025,1.000000),(1938,77,0,1026,27.000000),(1939,82,0,1026,1.000000),(1940,77,0,1027,27.000000),(1941,82,0,1027,1.000000),(1942,77,0,1028,27.000000),(1943,77,0,1029,57.000000),(1944,82,0,1029,1.000000),(1945,77,0,1030,57.000000),(1946,82,0,1030,1.000000),(1947,77,0,1031,57.000000),(1948,82,0,1031,1.000000),(1949,77,0,1032,57.000000),(1950,82,0,1032,1.000000),(1951,77,0,1033,57.000000),(1952,82,0,1033,1.000000),(1953,77,0,1034,57.000000),(1954,82,0,1034,1.000000),(1955,77,0,1035,57.000000),(1956,82,0,1035,1.000000),(1957,77,0,1036,57.000000),(1958,82,0,1036,1.000000),(1959,77,0,1037,57.000000),(1960,82,0,1037,1.000000),(1961,77,0,1038,57.000000),(1962,82,0,1038,1.000000),(1963,77,0,1039,57.000000),(1964,82,0,1039,1.000000),(1965,77,0,1040,57.000000),(1966,82,0,1040,1.000000),(1967,77,0,1041,57.000000),(1968,82,0,1041,1.000000),(1969,77,0,1042,57.000000),(1970,82,0,1042,1.000000),(1971,77,0,1043,57.000000),(1972,82,0,1043,1.000000),(1973,77,0,1044,57.000000),(1974,77,0,1045,48.000000),(1975,82,0,1045,1.000000),(1976,77,0,1046,48.000000),(1977,82,0,1046,1.000000),(1978,77,0,1047,48.000000),(1979,82,0,1047,1.000000),(1980,77,0,1048,48.000000),(1981,82,0,1048,1.000000),(1982,77,0,1049,48.000000),(1983,82,0,1049,1.000000),(1984,77,0,1050,48.000000),(1985,82,0,1050,1.000000),(1986,77,0,1051,48.000000),(1987,82,0,1051,1.000000),(1988,77,0,1052,48.000000),(1989,82,0,1052,1.000000),(1990,77,0,1053,48.000000),(1991,82,0,1053,1.000000),(1992,77,0,1054,48.000000),(1993,82,0,1054,1.000000),(1994,77,0,1055,48.000000),(1995,82,0,1055,1.000000),(1996,77,0,1056,48.000000),(1997,82,0,1056,1.000000),(1998,77,0,1057,48.000000),(1999,82,0,1057,1.000000),(2000,77,0,1058,48.000000),(2001,82,0,1058,1.000000),(2002,77,0,1059,48.000000),(2003,82,0,1059,1.000000),(2004,77,0,1060,48.000000),(2005,77,0,1061,57.000000),(2006,82,0,1061,1.000000),(2007,77,0,1062,57.000000),(2008,82,0,1062,1.000000),(2009,77,0,1063,57.000000),(2010,82,0,1063,1.000000),(2011,77,0,1064,57.000000),(2012,82,0,1064,1.000000),(2013,77,0,1065,57.000000),(2014,82,0,1065,1.000000),(2015,77,0,1066,57.000000),(2016,82,0,1066,1.000000),(2017,77,0,1067,57.000000),(2018,82,0,1067,1.000000),(2019,77,0,1068,57.000000),(2020,82,0,1068,1.000000),(2021,77,0,1069,57.000000),(2022,82,0,1069,1.000000),(2023,77,0,1070,57.000000),(2024,82,0,1070,1.000000),(2025,77,0,1071,57.000000),(2026,82,0,1071,1.000000),(2027,77,0,1072,57.000000),(2028,82,0,1072,1.000000),(2029,77,0,1073,57.000000),(2030,82,0,1073,1.000000),(2031,77,0,1074,57.000000),(2032,82,0,1074,1.000000),(2033,77,0,1075,57.000000),(2034,82,0,1075,1.000000),(2035,77,0,1076,57.000000),(2036,77,0,1077,69.000000),(2037,82,0,1077,1.000000),(2038,77,0,1078,69.000000),(2039,82,0,1078,1.000000),(2040,77,0,1079,69.000000),(2041,82,0,1079,1.000000),(2042,77,0,1080,69.000000),(2043,82,0,1080,1.000000),(2044,77,0,1081,69.000000),(2045,82,0,1081,1.000000),(2046,77,0,1082,69.000000),(2047,82,0,1082,1.000000),(2048,77,0,1083,69.000000),(2049,82,0,1083,1.000000),(2050,77,0,1084,69.000000),(2051,82,0,1084,1.000000),(2052,77,0,1085,69.000000),(2053,82,0,1085,1.000000),(2054,77,0,1086,69.000000),(2055,82,0,1086,1.000000),(2056,77,0,1087,69.000000),(2057,82,0,1087,1.000000),(2058,77,0,1088,69.000000),(2059,82,0,1088,1.000000),(2060,77,0,1089,69.000000),(2061,82,0,1089,1.000000),(2062,77,0,1090,69.000000),(2063,82,0,1090,1.000000),(2064,77,0,1091,69.000000),(2065,82,0,1091,1.000000),(2066,77,0,1092,69.000000),(2067,77,0,1093,42.000000),(2068,82,0,1093,1.000000),(2069,77,0,1094,42.000000),(2070,82,0,1094,1.000000),(2071,77,0,1095,42.000000),(2072,82,0,1095,1.000000),(2073,77,0,1096,42.000000),(2074,82,0,1096,1.000000),(2075,77,0,1097,42.000000),(2076,82,0,1097,1.000000),(2077,77,0,1098,42.000000),(2078,82,0,1098,1.000000),(2079,77,0,1099,42.000000),(2080,82,0,1099,1.000000),(2081,77,0,1100,42.000000),(2082,82,0,1100,1.000000),(2083,77,0,1101,42.000000),(2084,82,0,1101,1.000000),(2085,77,0,1102,42.000000),(2086,82,0,1102,1.000000),(2087,77,0,1103,42.000000),(2088,82,0,1103,1.000000),(2089,77,0,1104,42.000000),(2090,82,0,1104,1.000000),(2091,77,0,1105,42.000000),(2092,82,0,1105,1.000000),(2093,77,0,1106,42.000000),(2094,82,0,1106,1.000000),(2095,77,0,1107,42.000000),(2096,82,0,1107,1.000000),(2097,77,0,1108,42.000000),(2098,77,0,1109,59.000000),(2099,82,0,1109,1.000000),(2100,77,0,1110,59.000000),(2101,82,0,1110,1.000000),(2102,77,0,1111,59.000000),(2103,82,0,1111,1.000000),(2104,77,0,1112,59.000000),(2105,82,0,1112,1.000000),(2106,77,0,1113,59.000000),(2107,82,0,1113,1.000000),(2108,77,0,1114,59.000000),(2109,77,0,1115,59.000000),(2110,82,0,1115,1.000000),(2111,77,0,1116,59.000000),(2112,82,0,1116,1.000000),(2113,77,0,1117,59.000000),(2114,82,0,1117,1.000000),(2115,77,0,1118,59.000000),(2116,82,0,1118,1.000000),(2117,77,0,1119,59.000000),(2118,82,0,1119,1.000000),(2119,77,0,1120,59.000000),(2120,82,0,1120,1.000000),(2121,77,0,1121,59.000000),(2122,82,0,1121,1.000000),(2123,77,0,1122,59.000000),(2124,82,0,1122,1.000000),(2125,77,0,1123,59.000000),(2126,82,0,1123,1.000000),(2127,77,0,1124,59.000000),(2128,82,0,1124,1.000000),(2129,77,0,1125,59.000000),(2130,82,0,1125,1.000000),(2131,77,0,1126,59.000000),(2132,82,0,1126,1.000000),(2133,77,0,1127,59.000000),(2134,82,0,1127,1.000000),(2135,77,0,1128,59.000000),(2136,82,0,1128,1.000000),(2137,77,0,1129,59.000000),(2138,82,0,1129,1.000000),(2139,77,0,1130,59.000000),(2140,77,0,1131,48.000000),(2141,82,0,1131,1.000000),(2142,77,0,1132,48.000000),(2143,82,0,1132,1.000000),(2144,77,0,1133,48.000000),(2145,82,0,1133,1.000000),(2146,77,0,1134,48.000000),(2147,82,0,1134,1.000000),(2148,77,0,1135,48.000000),(2149,82,0,1135,1.000000),(2150,77,0,1136,48.000000),(2151,82,0,1136,1.000000),(2152,77,0,1137,48.000000),(2153,82,0,1137,1.000000),(2154,77,0,1138,48.000000),(2155,82,0,1138,1.000000),(2156,77,0,1139,48.000000),(2157,82,0,1139,1.000000),(2158,77,0,1140,48.000000),(2159,82,0,1140,1.000000),(2160,77,0,1141,48.000000),(2161,82,0,1141,1.000000),(2162,77,0,1142,48.000000),(2163,82,0,1142,1.000000),(2164,77,0,1143,48.000000),(2165,82,0,1143,1.000000),(2166,77,0,1144,48.000000),(2167,82,0,1144,1.000000),(2168,77,0,1145,48.000000),(2169,82,0,1145,1.000000),(2170,77,0,1146,48.000000),(2171,77,0,1147,39.000000),(2172,82,0,1147,1.000000),(2173,77,0,1148,39.000000),(2174,82,0,1148,1.000000),(2175,77,0,1149,39.000000),(2176,82,0,1149,1.000000),(2177,77,0,1150,39.000000),(2178,82,0,1150,1.000000),(2179,77,0,1151,39.000000),(2180,82,0,1151,1.000000),(2181,77,0,1152,39.000000),(2182,82,0,1152,1.000000),(2183,77,0,1153,39.000000),(2184,82,0,1153,1.000000),(2185,77,0,1154,39.000000),(2186,82,0,1154,1.000000),(2187,77,0,1155,39.000000),(2188,82,0,1155,1.000000),(2189,77,0,1156,39.000000),(2190,82,0,1156,1.000000),(2191,77,0,1157,39.000000),(2192,82,0,1157,1.000000),(2193,77,0,1158,39.000000),(2194,82,0,1158,1.000000),(2195,77,0,1159,39.000000),(2196,82,0,1159,1.000000),(2197,77,0,1160,39.000000),(2198,82,0,1160,1.000000),(2199,77,0,1161,39.000000),(2200,82,0,1161,1.000000),(2201,77,0,1162,39.000000),(2202,77,0,1163,55.000000),(2203,82,0,1163,1.000000),(2204,77,0,1164,55.000000),(2205,82,0,1164,1.000000),(2206,77,0,1165,55.000000),(2207,82,0,1165,1.000000),(2208,77,0,1166,55.000000),(2209,82,0,1166,1.000000),(2210,77,0,1167,55.000000),(2211,82,0,1167,1.000000),(2212,77,0,1168,55.000000),(2213,82,0,1168,1.000000),(2214,77,0,1169,55.000000),(2215,82,0,1169,1.000000),(2216,77,0,1170,55.000000),(2217,82,0,1170,1.000000),(2218,77,0,1171,55.000000),(2219,82,0,1171,1.000000),(2220,77,0,1172,55.000000),(2221,82,0,1172,1.000000),(2222,77,0,1173,55.000000),(2223,82,0,1173,1.000000),(2224,77,0,1174,55.000000),(2225,82,0,1174,1.000000),(2226,77,0,1175,55.000000),(2227,82,0,1175,1.000000),(2228,77,0,1176,55.000000),(2229,82,0,1176,1.000000),(2230,77,0,1177,55.000000),(2231,82,0,1177,1.000000),(2232,77,0,1178,55.000000),(2233,77,0,1179,54.000000),(2234,82,0,1179,1.000000),(2235,77,0,1180,54.000000),(2236,82,0,1180,1.000000),(2237,77,0,1181,54.000000),(2238,82,0,1181,1.000000),(2239,77,0,1182,54.000000),(2240,82,0,1182,1.000000),(2241,77,0,1183,54.000000),(2242,82,0,1183,1.000000),(2243,77,0,1184,54.000000),(2244,82,0,1184,1.000000),(2245,77,0,1185,54.000000),(2246,82,0,1185,1.000000),(2247,77,0,1186,54.000000),(2248,82,0,1186,1.000000),(2249,77,0,1187,54.000000),(2250,82,0,1187,1.000000),(2251,77,0,1188,54.000000),(2252,82,0,1188,1.000000),(2253,77,0,1189,54.000000),(2254,82,0,1189,1.000000),(2255,77,0,1190,54.000000),(2256,82,0,1190,1.000000),(2257,77,0,1191,54.000000),(2258,82,0,1191,1.000000),(2259,77,0,1192,54.000000),(2260,82,0,1192,1.000000),(2261,77,0,1193,54.000000),(2262,82,0,1193,1.000000),(2263,77,0,1194,54.000000),(2264,77,0,1195,68.000000),(2265,82,0,1195,1.000000),(2266,77,0,1196,68.000000),(2267,82,0,1196,1.000000),(2268,77,0,1197,68.000000),(2269,82,0,1197,1.000000),(2270,77,0,1198,68.000000),(2271,82,0,1198,1.000000),(2272,77,0,1199,68.000000),(2273,82,0,1199,1.000000),(2274,77,0,1200,68.000000),(2275,82,0,1200,1.000000),(2276,77,0,1201,68.000000),(2277,82,0,1201,1.000000),(2278,77,0,1202,68.000000),(2279,82,0,1202,1.000000),(2280,77,0,1203,68.000000),(2281,82,0,1203,1.000000),(2282,77,0,1204,68.000000),(2283,82,0,1204,1.000000),(2284,77,0,1205,68.000000),(2285,82,0,1205,1.000000),(2286,77,0,1206,68.000000),(2287,82,0,1206,1.000000),(2288,77,0,1207,68.000000),(2289,82,0,1207,1.000000),(2290,77,0,1208,68.000000),(2291,82,0,1208,1.000000),(2292,77,0,1209,68.000000),(2293,82,0,1209,1.000000),(2294,77,0,1210,68.000000),(2295,77,0,1211,75.000000),(2296,82,0,1211,1.000000),(2297,77,0,1212,75.000000),(2298,82,0,1212,1.000000),(2299,77,0,1213,75.000000),(2300,82,0,1213,1.000000),(2301,77,0,1214,75.000000),(2302,82,0,1214,1.000000),(2303,77,0,1215,75.000000),(2304,82,0,1215,1.000000),(2305,77,0,1216,75.000000),(2306,82,0,1216,1.000000),(2307,77,0,1217,75.000000),(2308,82,0,1217,1.000000),(2309,77,0,1218,75.000000),(2310,82,0,1218,1.000000),(2311,77,0,1219,75.000000),(2312,82,0,1219,1.000000),(2313,77,0,1220,75.000000),(2314,77,0,1221,56.250000),(2315,82,0,1221,1.000000),(2316,77,0,1222,56.250000),(2317,82,0,1222,1.000000),(2318,77,0,1223,56.250000),(2319,82,0,1223,1.000000),(2320,77,0,1224,56.250000),(2321,82,0,1224,1.000000),(2322,77,0,1225,56.250000),(2323,82,0,1225,1.000000),(2324,77,0,1226,56.250000),(2325,82,0,1226,1.000000),(2326,77,0,1227,56.250000),(2327,82,0,1227,1.000000),(2328,77,0,1228,56.250000),(2329,82,0,1228,1.000000),(2330,77,0,1229,56.250000),(2331,82,0,1229,1.000000),(2332,77,0,1230,56.250000),(2333,82,0,1230,1.000000),(2334,77,0,1231,56.250000),(2335,82,0,1231,1.000000),(2336,77,0,1232,56.250000),(2337,82,0,1232,1.000000),(2338,77,0,1233,56.250000),(2339,82,0,1233,1.000000),(2340,77,0,1234,56.250000),(2341,82,0,1234,1.000000),(2342,77,0,1235,56.250000),(2343,82,0,1235,1.000000),(2344,77,0,1236,56.250000),(2345,77,0,1237,57.000000),(2346,82,0,1237,1.000000),(2347,77,0,1238,57.000000),(2348,82,0,1238,1.000000),(2349,77,0,1239,57.000000),(2350,82,0,1239,1.000000),(2351,77,0,1240,57.000000),(2352,82,0,1240,1.000000),(2353,77,0,1241,57.000000),(2354,82,0,1241,1.000000),(2355,77,0,1242,57.000000),(2356,82,0,1242,1.000000),(2357,77,0,1243,57.000000),(2358,82,0,1243,1.000000),(2359,77,0,1244,57.000000),(2360,82,0,1244,1.000000),(2361,77,0,1245,57.000000),(2362,82,0,1245,1.000000),(2363,77,0,1246,57.000000),(2364,82,0,1246,1.000000),(2365,77,0,1247,57.000000),(2366,82,0,1247,1.000000),(2367,77,0,1248,57.000000),(2368,82,0,1248,1.000000),(2369,77,0,1249,57.000000),(2370,82,0,1249,1.000000),(2371,77,0,1250,57.000000),(2372,82,0,1250,1.000000),(2373,77,0,1251,57.000000),(2374,82,0,1251,1.000000),(2375,77,0,1252,57.000000),(2376,77,0,1253,84.000000),(2377,82,0,1253,1.000000),(2378,77,0,1254,84.000000),(2379,82,0,1254,1.000000),(2380,77,0,1255,84.000000),(2381,82,0,1255,1.000000),(2382,77,0,1256,84.000000),(2383,82,0,1256,1.000000),(2384,77,0,1257,84.000000),(2385,82,0,1257,1.000000),(2386,77,0,1258,84.000000),(2387,82,0,1258,1.000000),(2388,77,0,1259,84.000000),(2389,82,0,1259,1.000000),(2390,77,0,1260,84.000000),(2391,82,0,1260,1.000000),(2392,77,0,1261,84.000000),(2393,82,0,1261,1.000000),(2394,77,0,1262,84.000000),(2395,82,0,1262,1.000000),(2396,77,0,1263,84.000000),(2397,82,0,1263,1.000000),(2398,77,0,1264,84.000000),(2399,82,0,1264,1.000000),(2400,77,0,1265,84.000000),(2401,82,0,1265,1.000000),(2402,77,0,1266,84.000000),(2403,82,0,1266,1.000000),(2404,77,0,1267,84.000000),(2405,82,0,1267,1.000000),(2406,77,0,1268,84.000000),(2407,77,0,1269,60.000000),(2408,82,0,1269,1.000000),(2409,77,0,1270,60.000000),(2410,82,0,1270,1.000000),(2411,77,0,1271,60.000000),(2412,82,0,1271,1.000000),(2413,77,0,1272,60.000000),(2414,82,0,1272,1.000000),(2415,77,0,1273,60.000000),(2416,82,0,1273,1.000000),(2417,77,0,1274,60.000000),(2418,82,0,1274,1.000000),(2419,77,0,1275,60.000000),(2420,82,0,1275,1.000000),(2421,77,0,1276,60.000000),(2422,82,0,1276,1.000000),(2423,77,0,1277,60.000000),(2424,82,0,1277,1.000000),(2425,77,0,1278,60.000000),(2426,82,0,1278,1.000000),(2427,77,0,1279,60.000000),(2428,82,0,1279,1.000000),(2429,77,0,1280,60.000000),(2430,82,0,1280,1.000000),(2431,77,0,1281,60.000000),(2432,82,0,1281,1.000000),(2433,77,0,1282,60.000000),(2434,82,0,1282,1.000000),(2435,77,0,1283,60.000000),(2436,82,0,1283,1.000000),(2437,77,0,1284,60.000000),(2438,77,0,1285,59.000000),(2439,82,0,1285,1.000000),(2440,77,0,1286,59.000000),(2441,82,0,1286,1.000000),(2442,77,0,1287,59.000000),(2443,82,0,1287,1.000000),(2444,77,0,1288,59.000000),(2445,82,0,1288,1.000000),(2446,77,0,1289,59.000000),(2447,82,0,1289,1.000000),(2448,77,0,1290,59.000000),(2449,82,0,1290,1.000000),(2450,77,0,1291,59.000000),(2451,82,0,1291,1.000000),(2452,77,0,1292,59.000000),(2453,82,0,1292,1.000000),(2454,77,0,1293,59.000000),(2455,82,0,1293,1.000000),(2456,77,0,1294,59.000000),(2457,82,0,1294,1.000000),(2458,77,0,1295,59.000000),(2459,82,0,1295,1.000000),(2460,77,0,1296,59.000000),(2461,82,0,1296,1.000000),(2462,77,0,1297,59.000000),(2463,82,0,1297,1.000000),(2464,77,0,1298,59.000000),(2465,82,0,1298,1.000000),(2466,77,0,1299,59.000000),(2467,82,0,1299,1.000000),(2468,77,0,1300,59.000000),(2469,77,0,1301,57.000000),(2470,82,0,1301,1.000000),(2471,77,0,1302,57.000000),(2472,82,0,1302,1.000000),(2473,77,0,1303,57.000000),(2474,82,0,1303,1.000000),(2475,77,0,1304,57.000000),(2476,82,0,1304,1.000000),(2477,77,0,1305,57.000000),(2478,82,0,1305,1.000000),(2479,77,0,1306,57.000000),(2480,82,0,1306,1.000000),(2481,77,0,1307,57.000000),(2482,82,0,1307,1.000000),(2483,77,0,1308,57.000000),(2484,82,0,1308,1.000000),(2485,77,0,1309,57.000000),(2486,82,0,1309,1.000000),(2487,77,0,1310,57.000000),(2488,82,0,1310,1.000000),(2489,77,0,1311,57.000000),(2490,82,0,1311,1.000000),(2491,77,0,1312,57.000000),(2492,82,0,1312,1.000000),(2493,77,0,1313,57.000000),(2494,82,0,1313,1.000000),(2495,77,0,1314,57.000000),(2496,82,0,1314,1.000000),(2497,77,0,1315,57.000000),(2498,82,0,1315,1.000000),(2499,77,0,1316,57.000000),(2500,77,0,1317,32.000000),(2501,82,0,1317,1.000000),(2502,77,0,1318,32.000000),(2503,82,0,1318,1.000000),(2504,77,0,1319,32.000000),(2505,82,0,1319,1.000000),(2506,77,0,1320,32.000000),(2507,82,0,1320,1.000000),(2508,77,0,1321,32.000000),(2509,82,0,1321,1.000000),(2510,77,0,1322,32.000000),(2511,82,0,1322,1.000000),(2512,77,0,1323,32.000000),(2513,82,0,1323,1.000000),(2514,77,0,1324,32.000000),(2515,82,0,1324,1.000000),(2516,77,0,1325,32.000000),(2517,82,0,1325,1.000000),(2518,77,0,1326,32.000000),(2519,82,0,1326,1.000000),(2520,77,0,1327,32.000000),(2521,82,0,1327,1.000000),(2522,77,0,1328,32.000000),(2523,82,0,1328,1.000000),(2524,77,0,1329,32.000000),(2525,82,0,1329,1.000000),(2526,77,0,1330,32.000000),(2527,82,0,1330,1.000000),(2528,77,0,1331,32.000000),(2529,82,0,1331,1.000000),(2530,77,0,1332,32.000000),(2531,77,0,1333,69.000000),(2532,82,0,1333,1.000000),(2533,77,0,1334,69.000000),(2534,82,0,1334,1.000000),(2535,77,0,1335,69.000000),(2536,82,0,1335,1.000000),(2537,77,0,1336,69.000000),(2538,82,0,1336,1.000000),(2539,77,0,1337,69.000000),(2540,82,0,1337,1.000000),(2541,77,0,1338,69.000000),(2542,82,0,1338,1.000000),(2543,77,0,1339,69.000000),(2544,82,0,1339,1.000000),(2545,77,0,1340,69.000000),(2546,82,0,1340,1.000000),(2547,77,0,1341,69.000000),(2548,82,0,1341,1.000000),(2549,77,0,1342,69.000000),(2550,82,0,1342,1.000000),(2551,77,0,1343,69.000000),(2552,82,0,1343,1.000000),(2553,77,0,1344,69.000000),(2554,82,0,1344,1.000000),(2555,77,0,1345,69.000000),(2556,82,0,1345,1.000000),(2557,77,0,1346,69.000000),(2558,82,0,1346,1.000000),(2559,77,0,1347,69.000000),(2560,82,0,1347,1.000000),(2561,77,0,1348,69.000000),(2562,77,0,1349,69.000000),(2563,82,0,1349,1.000000),(2564,77,0,1350,69.000000),(2565,82,0,1350,1.000000),(2566,77,0,1351,69.000000),(2567,82,0,1351,1.000000),(2568,77,0,1352,69.000000),(2569,82,0,1352,1.000000),(2570,77,0,1353,69.000000),(2571,82,0,1353,1.000000),(2572,77,0,1354,69.000000),(2573,82,0,1354,1.000000),(2574,77,0,1355,69.000000),(2575,82,0,1355,1.000000),(2576,77,0,1356,69.000000),(2577,82,0,1356,1.000000),(2578,77,0,1357,69.000000),(2579,82,0,1357,1.000000),(2580,77,0,1358,69.000000),(2581,82,0,1358,1.000000),(2582,77,0,1359,69.000000),(2583,82,0,1359,1.000000),(2584,77,0,1360,69.000000),(2585,82,0,1360,1.000000),(2586,77,0,1361,69.000000),(2587,82,0,1361,1.000000),(2588,77,0,1362,69.000000),(2589,82,0,1362,1.000000),(2590,77,0,1363,69.000000),(2591,82,0,1363,1.000000),(2592,77,0,1364,69.000000),(2593,77,0,1365,77.000000),(2594,82,0,1365,1.000000),(2595,77,0,1366,77.000000),(2596,82,0,1366,1.000000),(2597,77,0,1367,77.000000),(2598,82,0,1367,1.000000),(2599,77,0,1368,77.000000),(2600,82,0,1368,1.000000),(2601,77,0,1369,77.000000),(2602,82,0,1369,1.000000),(2603,77,0,1370,77.000000),(2604,82,0,1370,1.000000),(2605,77,0,1371,77.000000),(2606,82,0,1371,1.000000),(2607,77,0,1372,77.000000),(2608,82,0,1372,1.000000),(2609,77,0,1373,77.000000),(2610,82,0,1373,1.000000),(2611,77,0,1374,77.000000),(2612,82,0,1374,1.000000),(2613,77,0,1375,77.000000),(2614,82,0,1375,1.000000),(2615,77,0,1376,77.000000),(2616,82,0,1376,1.000000),(2617,77,0,1377,77.000000),(2618,82,0,1377,1.000000),(2619,77,0,1378,77.000000),(2620,82,0,1378,1.000000),(2621,77,0,1379,77.000000),(2622,82,0,1379,1.000000),(2623,77,0,1380,77.000000),(2624,77,0,1381,77.000000),(2625,82,0,1381,1.000000),(2626,77,0,1382,77.000000),(2627,82,0,1382,1.000000),(2628,77,0,1383,77.000000),(2629,82,0,1383,1.000000),(2630,77,0,1384,77.000000),(2631,82,0,1384,1.000000),(2632,77,0,1385,77.000000),(2633,82,0,1385,1.000000),(2634,77,0,1386,77.000000),(2635,82,0,1386,1.000000),(2636,77,0,1387,77.000000),(2637,82,0,1387,1.000000),(2638,77,0,1388,77.000000),(2639,82,0,1388,1.000000),(2640,77,0,1389,77.000000),(2641,82,0,1389,1.000000),(2642,77,0,1390,77.000000),(2643,82,0,1390,1.000000),(2644,77,0,1391,77.000000),(2645,82,0,1391,1.000000),(2646,77,0,1392,77.000000),(2647,82,0,1392,1.000000),(2648,77,0,1393,77.000000),(2649,82,0,1393,1.000000),(2650,77,0,1394,77.000000),(2651,82,0,1394,1.000000),(2652,77,0,1395,77.000000),(2653,82,0,1395,1.000000),(2654,77,0,1396,77.000000),(2655,77,0,1397,28.000000),(2656,82,0,1397,1.000000),(2657,77,0,1398,28.000000),(2658,82,0,1398,1.000000),(2659,77,0,1399,28.000000),(2660,82,0,1399,1.000000),(2661,77,0,1400,28.000000),(2662,82,0,1400,1.000000),(2663,77,0,1401,28.000000),(2664,82,0,1401,1.000000),(2665,77,0,1402,28.000000),(2666,82,0,1402,1.000000),(2667,77,0,1403,28.000000),(2668,82,0,1403,1.000000),(2669,77,0,1404,28.000000),(2670,82,0,1404,1.000000),(2671,77,0,1405,28.000000),(2672,82,0,1405,1.000000),(2673,77,0,1406,28.000000),(2674,82,0,1406,1.000000),(2675,77,0,1407,28.000000),(2676,82,0,1407,1.000000),(2677,77,0,1408,28.000000),(2678,82,0,1408,1.000000),(2679,77,0,1409,28.000000),(2680,82,0,1409,1.000000),(2681,77,0,1410,28.000000),(2682,82,0,1410,1.000000),(2683,77,0,1411,28.000000),(2684,82,0,1411,1.000000),(2685,77,0,1412,28.000000),(2686,77,0,1413,29.000000),(2687,82,0,1413,1.000000),(2688,77,0,1414,29.000000),(2689,82,0,1414,1.000000),(2690,77,0,1415,29.000000),(2691,82,0,1415,1.000000),(2692,77,0,1416,29.000000),(2693,82,0,1416,1.000000),(2694,77,0,1417,29.000000),(2695,82,0,1417,1.000000),(2696,77,0,1418,29.000000),(2697,82,0,1418,1.000000),(2698,77,0,1419,29.000000),(2699,82,0,1419,1.000000),(2700,77,0,1420,29.000000),(2701,82,0,1420,1.000000),(2702,77,0,1421,29.000000),(2703,82,0,1421,1.000000),(2704,77,0,1422,29.000000),(2705,82,0,1422,1.000000),(2706,77,0,1423,29.000000),(2707,82,0,1423,1.000000),(2708,77,0,1424,29.000000),(2709,82,0,1424,1.000000),(2710,77,0,1425,29.000000),(2711,82,0,1425,1.000000),(2712,77,0,1426,29.000000),(2713,82,0,1426,1.000000),(2714,77,0,1427,29.000000),(2715,82,0,1427,1.000000),(2716,77,0,1428,29.000000),(2717,77,0,1429,29.000000),(2718,82,0,1429,1.000000),(2719,77,0,1430,29.000000),(2720,82,0,1430,1.000000),(2721,77,0,1431,29.000000),(2722,82,0,1431,1.000000),(2723,77,0,1432,29.000000),(2724,82,0,1432,1.000000),(2725,77,0,1433,29.000000),(2726,82,0,1433,1.000000),(2727,77,0,1434,29.000000),(2728,82,0,1434,1.000000),(2729,77,0,1435,29.000000),(2730,82,0,1435,1.000000),(2731,77,0,1436,29.000000),(2732,82,0,1436,1.000000),(2733,77,0,1437,29.000000),(2734,82,0,1437,1.000000),(2735,77,0,1438,29.000000),(2736,82,0,1438,1.000000),(2737,77,0,1439,29.000000),(2738,82,0,1439,1.000000),(2739,77,0,1440,29.000000),(2740,82,0,1440,1.000000),(2741,77,0,1441,29.000000),(2742,82,0,1441,1.000000),(2743,77,0,1442,29.000000),(2744,82,0,1442,1.000000),(2745,77,0,1443,29.000000),(2746,82,0,1443,1.000000),(2747,77,0,1444,29.000000),(2748,77,0,1445,29.000000),(2749,82,0,1445,1.000000),(2750,77,0,1446,29.000000),(2751,82,0,1446,1.000000),(2752,77,0,1447,29.000000),(2753,82,0,1447,1.000000),(2754,77,0,1448,29.000000),(2755,82,0,1448,1.000000),(2756,77,0,1449,29.000000),(2757,82,0,1449,1.000000),(2758,77,0,1450,29.000000),(2759,82,0,1450,1.000000),(2760,77,0,1451,29.000000),(2761,82,0,1451,1.000000),(2762,77,0,1452,29.000000),(2763,82,0,1452,1.000000),(2764,77,0,1453,29.000000),(2765,82,0,1453,1.000000),(2766,77,0,1454,29.000000),(2767,82,0,1454,1.000000),(2768,77,0,1455,29.000000),(2769,82,0,1455,1.000000),(2770,77,0,1456,29.000000),(2771,82,0,1456,1.000000),(2772,77,0,1457,29.000000),(2773,82,0,1457,1.000000),(2774,77,0,1458,29.000000),(2775,82,0,1458,1.000000),(2776,77,0,1459,29.000000),(2777,82,0,1459,1.000000),(2778,77,0,1460,29.000000),(2779,77,0,1461,42.000000),(2780,82,0,1461,1.000000),(2781,77,0,1462,42.000000),(2782,82,0,1462,1.000000),(2783,77,0,1463,42.000000),(2784,82,0,1463,1.000000),(2785,77,0,1464,42.000000),(2786,82,0,1464,1.000000),(2787,77,0,1465,42.000000),(2788,82,0,1465,1.000000),(2789,77,0,1466,42.000000),(2790,82,0,1466,1.000000),(2791,77,0,1467,42.000000),(2792,82,0,1467,1.000000),(2793,77,0,1468,42.000000),(2794,82,0,1468,1.000000),(2795,77,0,1469,42.000000),(2796,82,0,1469,1.000000),(2797,77,0,1470,42.000000),(2798,82,0,1470,1.000000),(2799,77,0,1471,42.000000),(2800,82,0,1471,1.000000),(2801,77,0,1472,42.000000),(2802,82,0,1472,1.000000),(2803,77,0,1473,42.000000),(2804,82,0,1473,1.000000),(2805,77,0,1474,42.000000),(2806,82,0,1474,1.000000),(2807,77,0,1475,42.000000),(2808,82,0,1475,1.000000),(2809,77,0,1476,42.000000),(2810,77,0,1477,32.000000),(2811,82,0,1477,1.000000),(2812,77,0,1478,32.000000),(2813,82,0,1478,1.000000),(2814,77,0,1479,32.000000),(2815,82,0,1479,1.000000),(2816,77,0,1480,32.000000),(2817,82,0,1480,1.000000),(2818,77,0,1481,32.000000),(2819,82,0,1481,1.000000),(2820,77,0,1482,32.000000),(2821,82,0,1482,1.000000),(2822,77,0,1483,32.000000),(2823,82,0,1483,1.000000),(2824,77,0,1484,32.000000),(2825,82,0,1484,1.000000),(2826,77,0,1485,32.000000),(2827,82,0,1485,1.000000),(2828,77,0,1486,32.000000),(2829,82,0,1486,1.000000),(2830,77,0,1487,32.000000),(2831,82,0,1487,1.000000),(2832,77,0,1488,32.000000),(2833,82,0,1488,1.000000),(2834,77,0,1489,32.000000),(2835,82,0,1489,1.000000),(2836,77,0,1490,32.000000),(2837,82,0,1490,1.000000),(2838,77,0,1491,32.000000),(2839,82,0,1491,1.000000),(2840,77,0,1492,32.000000),(2841,77,0,1493,28.000000),(2842,82,0,1493,1.000000),(2843,77,0,1494,28.000000),(2844,82,0,1494,1.000000),(2845,77,0,1495,28.000000),(2846,82,0,1495,1.000000),(2847,77,0,1496,28.000000),(2848,82,0,1496,1.000000),(2849,77,0,1497,28.000000),(2850,82,0,1497,1.000000),(2851,77,0,1498,28.000000),(2852,82,0,1498,1.000000),(2853,77,0,1499,28.000000),(2854,82,0,1499,1.000000),(2855,77,0,1500,28.000000),(2856,82,0,1500,1.000000),(2857,77,0,1501,28.000000),(2858,82,0,1501,1.000000),(2859,77,0,1502,28.000000),(2860,82,0,1502,1.000000),(2861,77,0,1503,28.000000),(2862,82,0,1503,1.000000),(2863,77,0,1504,28.000000),(2864,82,0,1504,1.000000),(2865,77,0,1505,28.000000),(2866,82,0,1505,1.000000),(2867,77,0,1506,28.000000),(2868,82,0,1506,1.000000),(2869,77,0,1507,28.000000),(2870,82,0,1507,1.000000),(2871,77,0,1508,28.000000),(2872,77,0,1509,32.000000),(2873,82,0,1509,1.000000),(2874,77,0,1510,32.000000),(2875,82,0,1510,1.000000),(2876,77,0,1511,32.000000),(2877,82,0,1511,1.000000),(2878,77,0,1512,32.000000),(2879,82,0,1512,1.000000),(2880,77,0,1513,32.000000),(2881,82,0,1513,1.000000),(2882,77,0,1514,32.000000),(2883,82,0,1514,1.000000),(2884,77,0,1515,32.000000),(2885,82,0,1515,1.000000),(2886,77,0,1516,32.000000),(2887,82,0,1516,1.000000),(2888,77,0,1517,32.000000),(2889,82,0,1517,1.000000),(2890,77,0,1518,32.000000),(2891,82,0,1518,1.000000),(2892,77,0,1519,32.000000),(2893,82,0,1519,1.000000),(2894,77,0,1520,32.000000),(2895,82,0,1520,1.000000),(2896,77,0,1521,32.000000),(2897,82,0,1521,1.000000),(2898,77,0,1522,32.000000),(2899,82,0,1522,1.000000),(2900,77,0,1523,32.000000),(2901,82,0,1523,1.000000),(2902,77,0,1524,32.000000),(2903,77,0,1525,32.000000),(2904,82,0,1525,1.000000),(2905,77,0,1526,32.000000),(2906,82,0,1526,1.000000),(2907,77,0,1527,32.000000),(2908,82,0,1527,1.000000),(2909,77,0,1528,32.000000),(2910,82,0,1528,1.000000),(2911,77,0,1529,32.000000),(2912,82,0,1529,1.000000),(2913,77,0,1530,32.000000),(2914,82,0,1530,1.000000),(2915,77,0,1531,32.000000),(2916,82,0,1531,1.000000),(2917,77,0,1532,32.000000),(2918,82,0,1532,1.000000),(2919,77,0,1533,32.000000),(2920,82,0,1533,1.000000),(2921,77,0,1534,32.000000),(2922,82,0,1534,1.000000),(2923,77,0,1535,32.000000),(2924,82,0,1535,1.000000),(2925,77,0,1536,32.000000),(2926,82,0,1536,1.000000),(2927,77,0,1537,32.000000),(2928,82,0,1537,1.000000),(2929,77,0,1538,32.000000),(2930,82,0,1538,1.000000),(2931,77,0,1539,32.000000),(2932,82,0,1539,1.000000),(2933,77,0,1540,32.000000),(2934,77,0,1541,22.000000),(2935,82,0,1541,1.000000),(2936,77,0,1542,22.000000),(2937,82,0,1542,1.000000),(2938,77,0,1543,22.000000),(2939,82,0,1543,1.000000),(2940,77,0,1544,22.000000),(2941,82,0,1544,1.000000),(2942,77,0,1545,22.000000),(2943,82,0,1545,1.000000),(2944,77,0,1546,22.000000),(2945,82,0,1546,1.000000),(2946,77,0,1547,22.000000),(2947,82,0,1547,1.000000),(2948,77,0,1548,22.000000),(2949,82,0,1548,1.000000),(2950,77,0,1549,22.000000),(2951,82,0,1549,1.000000),(2952,77,0,1550,22.000000),(2953,82,0,1550,1.000000),(2954,77,0,1551,22.000000),(2955,82,0,1551,1.000000),(2956,77,0,1552,22.000000),(2957,82,0,1552,1.000000),(2958,77,0,1553,22.000000),(2959,82,0,1553,1.000000),(2960,77,0,1554,22.000000),(2961,82,0,1554,1.000000),(2962,77,0,1555,22.000000),(2963,82,0,1555,1.000000),(2964,77,0,1556,22.000000),(2965,77,0,1557,24.000000),(2966,82,0,1557,1.000000),(2967,77,0,1558,24.000000),(2968,82,0,1558,1.000000),(2969,77,0,1559,24.000000),(2970,82,0,1559,1.000000),(2971,77,0,1560,24.000000),(2972,82,0,1560,1.000000),(2973,77,0,1561,24.000000),(2974,82,0,1561,1.000000),(2975,77,0,1562,24.000000),(2976,82,0,1562,1.000000),(2977,77,0,1563,24.000000),(2978,82,0,1563,1.000000),(2979,77,0,1564,24.000000),(2980,82,0,1564,1.000000),(2981,77,0,1565,24.000000),(2982,82,0,1565,1.000000),(2983,77,0,1566,24.000000),(2984,82,0,1566,1.000000),(2985,77,0,1567,24.000000),(2986,82,0,1567,1.000000),(2987,77,0,1568,24.000000),(2988,82,0,1568,1.000000),(2989,77,0,1569,24.000000),(2990,82,0,1569,1.000000),(2991,77,0,1570,24.000000),(2992,82,0,1570,1.000000),(2993,77,0,1571,24.000000),(2994,82,0,1571,1.000000),(2995,77,0,1572,24.000000),(2996,77,0,1573,24.000000),(2997,82,0,1573,1.000000),(2998,77,0,1574,24.000000),(2999,82,0,1574,1.000000),(3000,77,0,1575,24.000000),(3001,82,0,1575,1.000000),(3002,77,0,1576,24.000000),(3003,82,0,1576,1.000000),(3004,77,0,1577,24.000000),(3005,82,0,1577,1.000000),(3006,77,0,1578,24.000000),(3007,82,0,1578,1.000000),(3008,77,0,1579,24.000000),(3009,82,0,1579,1.000000),(3010,77,0,1580,24.000000),(3011,82,0,1580,1.000000),(3012,77,0,1581,24.000000),(3013,82,0,1581,1.000000),(3014,77,0,1582,24.000000),(3015,82,0,1582,1.000000),(3016,77,0,1583,24.000000),(3017,82,0,1583,1.000000),(3018,77,0,1584,24.000000),(3019,82,0,1584,1.000000),(3020,77,0,1585,24.000000),(3021,82,0,1585,1.000000),(3022,77,0,1586,24.000000),(3023,82,0,1586,1.000000),(3024,77,0,1587,24.000000),(3025,82,0,1587,1.000000),(3026,77,0,1588,24.000000),(3027,77,0,1589,39.000000),(3028,82,0,1589,1.000000),(3029,77,0,1590,39.000000),(3030,82,0,1590,1.000000),(3031,77,0,1591,39.000000),(3032,82,0,1591,1.000000),(3033,77,0,1592,39.000000),(3034,82,0,1592,1.000000),(3035,77,0,1593,39.000000),(3036,82,0,1593,1.000000),(3037,77,0,1594,39.000000),(3038,82,0,1594,1.000000),(3039,77,0,1595,39.000000),(3040,82,0,1595,1.000000),(3041,77,0,1596,39.000000),(3042,82,0,1596,1.000000),(3043,77,0,1597,39.000000),(3044,82,0,1597,1.000000),(3045,77,0,1598,39.000000),(3046,82,0,1598,1.000000),(3047,77,0,1599,39.000000),(3048,82,0,1599,1.000000),(3049,77,0,1600,39.000000),(3050,82,0,1600,1.000000),(3051,77,0,1601,39.000000),(3052,82,0,1601,1.000000),(3053,77,0,1602,39.000000),(3054,82,0,1602,1.000000),(3055,77,0,1603,39.000000),(3056,82,0,1603,1.000000),(3057,77,0,1604,39.000000),(3058,77,0,1605,39.000000),(3059,82,0,1605,1.000000),(3060,77,0,1606,39.000000),(3061,82,0,1606,1.000000),(3062,77,0,1607,39.000000),(3063,82,0,1607,1.000000),(3064,77,0,1608,39.000000),(3065,82,0,1608,1.000000),(3066,77,0,1609,39.000000),(3067,82,0,1609,1.000000),(3068,77,0,1610,39.000000),(3069,82,0,1610,1.000000),(3070,77,0,1611,39.000000),(3071,82,0,1611,1.000000),(3072,77,0,1612,39.000000),(3073,82,0,1612,1.000000),(3074,77,0,1613,39.000000),(3075,82,0,1613,1.000000),(3076,77,0,1614,39.000000),(3077,82,0,1614,1.000000),(3078,77,0,1615,39.000000),(3079,82,0,1615,1.000000),(3080,77,0,1616,39.000000),(3081,82,0,1616,1.000000),(3082,77,0,1617,39.000000),(3083,82,0,1617,1.000000),(3084,77,0,1618,39.000000),(3085,82,0,1618,1.000000),(3086,77,0,1619,39.000000),(3087,82,0,1619,1.000000),(3088,77,0,1620,39.000000),(3089,77,0,1621,39.000000),(3090,82,0,1621,1.000000),(3091,77,0,1622,39.000000),(3092,82,0,1622,1.000000),(3093,77,0,1623,39.000000),(3094,82,0,1623,1.000000),(3095,77,0,1624,39.000000),(3096,82,0,1624,1.000000),(3097,77,0,1625,39.000000),(3098,82,0,1625,1.000000),(3099,77,0,1626,39.000000),(3100,82,0,1626,1.000000),(3101,77,0,1627,39.000000),(3102,82,0,1627,1.000000),(3103,77,0,1628,39.000000),(3104,82,0,1628,1.000000),(3105,77,0,1629,39.000000),(3106,82,0,1629,1.000000),(3107,77,0,1630,39.000000),(3108,82,0,1630,1.000000),(3109,77,0,1631,39.000000),(3110,82,0,1631,1.000000),(3111,77,0,1632,39.000000),(3112,82,0,1632,1.000000),(3113,77,0,1633,39.000000),(3114,82,0,1633,1.000000),(3115,77,0,1634,39.000000),(3116,82,0,1634,1.000000),(3117,77,0,1635,39.000000),(3118,82,0,1635,1.000000),(3119,77,0,1636,39.000000),(3120,77,0,1637,24.000000),(3121,82,0,1637,1.000000),(3122,77,0,1638,24.000000),(3123,82,0,1638,1.000000),(3124,77,0,1639,24.000000),(3125,82,0,1639,1.000000),(3126,77,0,1640,24.000000),(3127,82,0,1640,1.000000),(3128,77,0,1641,24.000000),(3129,82,0,1641,1.000000),(3130,77,0,1642,24.000000),(3131,82,0,1642,1.000000),(3132,77,0,1643,24.000000),(3133,82,0,1643,1.000000),(3134,77,0,1644,24.000000),(3135,82,0,1644,1.000000),(3136,77,0,1645,24.000000),(3137,82,0,1645,1.000000),(3138,77,0,1646,24.000000),(3139,82,0,1646,1.000000),(3140,77,0,1647,24.000000),(3141,82,0,1647,1.000000),(3142,77,0,1648,24.000000),(3143,82,0,1648,1.000000),(3144,77,0,1649,24.000000),(3145,82,0,1649,1.000000),(3146,77,0,1650,24.000000),(3147,82,0,1650,1.000000),(3148,77,0,1651,24.000000),(3149,82,0,1651,1.000000),(3150,77,0,1652,24.000000),(3151,77,0,1653,39.000000),(3152,82,0,1653,1.000000),(3153,77,0,1654,39.000000),(3154,82,0,1654,1.000000),(3155,77,0,1655,39.000000),(3156,82,0,1655,1.000000),(3157,77,0,1656,39.000000),(3158,82,0,1656,1.000000),(3159,77,0,1657,39.000000),(3160,82,0,1657,1.000000),(3161,77,0,1658,39.000000),(3162,82,0,1658,1.000000),(3163,77,0,1659,39.000000),(3164,82,0,1659,1.000000),(3165,77,0,1660,39.000000),(3166,82,0,1660,1.000000),(3167,77,0,1661,39.000000),(3168,82,0,1661,1.000000),(3169,77,0,1662,39.000000),(3170,82,0,1662,1.000000),(3171,77,0,1663,39.000000),(3172,82,0,1663,1.000000),(3173,77,0,1664,39.000000),(3174,82,0,1664,1.000000),(3175,77,0,1665,39.000000),(3176,82,0,1665,1.000000),(3177,77,0,1666,39.000000),(3178,82,0,1666,1.000000),(3179,77,0,1667,39.000000),(3180,82,0,1667,1.000000),(3181,77,0,1668,39.000000),(3182,77,0,1669,29.000000),(3183,82,0,1669,1.000000),(3184,77,0,1670,29.000000),(3185,82,0,1670,1.000000),(3186,77,0,1671,29.000000),(3187,82,0,1671,1.000000),(3188,77,0,1672,29.000000),(3189,82,0,1672,1.000000),(3190,77,0,1673,29.000000),(3191,82,0,1673,1.000000),(3192,77,0,1674,29.000000),(3193,82,0,1674,1.000000),(3194,77,0,1675,29.000000),(3195,82,0,1675,1.000000),(3196,77,0,1676,29.000000),(3197,82,0,1676,1.000000),(3198,77,0,1677,29.000000),(3199,82,0,1677,1.000000),(3200,77,0,1678,29.000000),(3201,82,0,1678,1.000000),(3202,77,0,1679,29.000000),(3203,82,0,1679,1.000000),(3204,77,0,1680,29.000000),(3205,82,0,1680,1.000000),(3206,77,0,1681,29.000000),(3207,82,0,1681,1.000000),(3208,77,0,1682,29.000000),(3209,82,0,1682,1.000000),(3210,77,0,1683,29.000000),(3211,82,0,1683,1.000000),(3212,77,0,1684,29.000000),(3213,77,0,1685,29.000000),(3214,82,0,1685,1.000000),(3215,77,0,1686,29.000000),(3216,82,0,1686,1.000000),(3217,77,0,1687,29.000000),(3218,82,0,1687,1.000000),(3219,77,0,1688,29.000000),(3220,82,0,1688,1.000000),(3221,77,0,1689,29.000000),(3222,82,0,1689,1.000000),(3223,77,0,1690,29.000000),(3224,82,0,1690,1.000000),(3225,77,0,1691,29.000000),(3226,82,0,1691,1.000000),(3227,77,0,1692,29.000000),(3228,82,0,1692,1.000000),(3229,77,0,1693,29.000000),(3230,82,0,1693,1.000000),(3231,77,0,1694,29.000000),(3232,82,0,1694,1.000000),(3233,77,0,1695,29.000000),(3234,82,0,1695,1.000000),(3235,77,0,1696,29.000000),(3236,82,0,1696,1.000000),(3237,77,0,1697,29.000000),(3238,82,0,1697,1.000000),(3239,77,0,1698,29.000000),(3240,82,0,1698,1.000000),(3241,77,0,1699,29.000000),(3242,82,0,1699,1.000000),(3243,77,0,1700,29.000000),(3244,77,0,1701,39.000000),(3245,82,0,1701,1.000000),(3246,77,0,1702,39.000000),(3247,82,0,1702,1.000000),(3248,77,0,1703,39.000000),(3249,82,0,1703,1.000000),(3250,77,0,1704,39.000000),(3251,82,0,1704,1.000000),(3252,77,0,1705,39.000000),(3253,82,0,1705,1.000000),(3254,77,0,1706,39.000000),(3255,82,0,1706,1.000000),(3256,77,0,1707,39.000000),(3257,82,0,1707,1.000000),(3258,77,0,1708,39.000000),(3259,82,0,1708,1.000000),(3260,77,0,1709,39.000000),(3261,82,0,1709,1.000000),(3262,77,0,1710,39.000000),(3263,82,0,1710,1.000000),(3264,77,0,1711,39.000000),(3265,82,0,1711,1.000000),(3266,77,0,1712,39.000000),(3267,82,0,1712,1.000000),(3268,77,0,1713,39.000000),(3269,82,0,1713,1.000000),(3270,77,0,1714,39.000000),(3271,82,0,1714,1.000000),(3272,77,0,1715,39.000000),(3273,82,0,1715,1.000000),(3274,77,0,1716,39.000000),(3275,77,0,1717,39.000000),(3276,82,0,1717,1.000000),(3277,77,0,1718,39.000000),(3278,82,0,1718,1.000000),(3279,77,0,1719,39.000000),(3280,82,0,1719,1.000000),(3281,77,0,1720,39.000000),(3282,82,0,1720,1.000000),(3283,77,0,1721,39.000000),(3284,82,0,1721,1.000000),(3285,77,0,1722,39.000000),(3286,82,0,1722,1.000000),(3287,77,0,1723,39.000000),(3288,82,0,1723,1.000000),(3289,77,0,1724,39.000000),(3290,82,0,1724,1.000000),(3291,77,0,1725,39.000000),(3292,82,0,1725,1.000000),(3293,77,0,1726,39.000000),(3294,82,0,1726,1.000000),(3295,77,0,1727,39.000000),(3296,82,0,1727,1.000000),(3297,77,0,1728,39.000000),(3298,82,0,1728,1.000000),(3299,77,0,1729,39.000000),(3300,82,0,1729,1.000000),(3301,77,0,1730,39.000000),(3302,82,0,1730,1.000000),(3303,77,0,1731,39.000000),(3304,82,0,1731,1.000000),(3305,77,0,1732,39.000000),(3306,77,0,1733,39.000000),(3307,82,0,1733,1.000000),(3308,77,0,1734,39.000000),(3309,82,0,1734,1.000000),(3310,77,0,1735,39.000000),(3311,82,0,1735,1.000000),(3312,77,0,1736,39.000000),(3313,82,0,1736,1.000000),(3314,77,0,1737,39.000000),(3315,82,0,1737,1.000000),(3316,77,0,1738,39.000000),(3317,82,0,1738,1.000000),(3318,77,0,1739,39.000000),(3319,82,0,1739,1.000000),(3320,77,0,1740,39.000000),(3321,82,0,1740,1.000000),(3322,77,0,1741,39.000000),(3323,82,0,1741,1.000000),(3324,77,0,1742,39.000000),(3325,82,0,1742,1.000000),(3326,77,0,1743,39.000000),(3327,82,0,1743,1.000000),(3328,77,0,1744,39.000000),(3329,82,0,1744,1.000000),(3330,77,0,1745,39.000000),(3331,82,0,1745,1.000000),(3332,77,0,1746,39.000000),(3333,82,0,1746,1.000000),(3334,77,0,1747,39.000000),(3335,82,0,1747,1.000000),(3336,77,0,1748,39.000000),(3337,77,0,1749,39.000000),(3338,82,0,1749,1.000000),(3339,77,0,1750,39.000000),(3340,82,0,1750,1.000000),(3341,77,0,1751,39.000000),(3342,82,0,1751,1.000000),(3343,77,0,1752,39.000000),(3344,82,0,1752,1.000000),(3345,77,0,1753,39.000000),(3346,82,0,1753,1.000000),(3347,77,0,1754,39.000000),(3348,82,0,1754,1.000000),(3349,77,0,1755,39.000000),(3350,82,0,1755,1.000000),(3351,77,0,1756,39.000000),(3352,82,0,1756,1.000000),(3353,77,0,1757,39.000000),(3354,82,0,1757,1.000000),(3355,77,0,1758,39.000000),(3356,82,0,1758,1.000000),(3357,77,0,1759,39.000000),(3358,82,0,1759,1.000000),(3359,77,0,1760,39.000000),(3360,82,0,1760,1.000000),(3361,77,0,1761,39.000000),(3362,82,0,1761,1.000000),(3363,77,0,1762,39.000000),(3364,82,0,1762,1.000000),(3365,77,0,1763,39.000000),(3366,82,0,1763,1.000000),(3367,77,0,1764,39.000000),(3368,77,0,1765,29.000000),(3369,82,0,1765,1.000000),(3370,77,0,1766,29.000000),(3371,82,0,1766,1.000000),(3372,77,0,1767,29.000000),(3373,82,0,1767,1.000000),(3374,77,0,1768,29.000000),(3375,82,0,1768,1.000000),(3376,77,0,1769,29.000000),(3377,82,0,1769,1.000000),(3378,77,0,1770,29.000000),(3379,82,0,1770,1.000000),(3380,77,0,1771,29.000000),(3381,82,0,1771,1.000000),(3382,77,0,1772,29.000000),(3383,82,0,1772,1.000000),(3384,77,0,1773,29.000000),(3385,82,0,1773,1.000000),(3386,77,0,1774,29.000000),(3387,82,0,1774,1.000000),(3388,77,0,1775,29.000000),(3389,82,0,1775,1.000000),(3390,77,0,1776,29.000000),(3391,82,0,1776,1.000000),(3392,77,0,1777,29.000000),(3393,82,0,1777,1.000000),(3394,77,0,1778,29.000000),(3395,82,0,1778,1.000000),(3396,77,0,1779,29.000000),(3397,82,0,1779,1.000000),(3398,77,0,1780,29.000000),(3399,77,0,1781,34.000000),(3400,82,0,1781,1.000000),(3401,77,0,1782,34.000000),(3402,82,0,1782,1.000000),(3403,77,0,1783,34.000000),(3404,82,0,1783,1.000000),(3405,77,0,1784,34.000000),(3406,82,0,1784,1.000000),(3407,77,0,1785,34.000000),(3408,82,0,1785,1.000000),(3409,77,0,1786,34.000000),(3410,82,0,1786,1.000000),(3411,77,0,1787,34.000000),(3412,82,0,1787,1.000000),(3413,77,0,1788,34.000000),(3414,82,0,1788,1.000000),(3415,77,0,1789,34.000000),(3416,82,0,1789,1.000000),(3417,77,0,1790,34.000000),(3418,82,0,1790,1.000000),(3419,77,0,1791,34.000000),(3420,82,0,1791,1.000000),(3421,77,0,1792,34.000000),(3422,82,0,1792,1.000000),(3423,77,0,1793,34.000000),(3424,82,0,1793,1.000000),(3425,77,0,1794,34.000000),(3426,82,0,1794,1.000000),(3427,77,0,1795,34.000000),(3428,82,0,1795,1.000000),(3429,77,0,1796,34.000000),(3430,77,0,1797,34.000000),(3431,82,0,1797,1.000000),(3432,77,0,1798,34.000000),(3433,82,0,1798,1.000000),(3434,77,0,1799,34.000000),(3435,82,0,1799,1.000000),(3436,77,0,1800,34.000000),(3437,82,0,1800,1.000000),(3438,77,0,1801,34.000000),(3439,82,0,1801,1.000000),(3440,77,0,1802,34.000000),(3441,82,0,1802,1.000000),(3442,77,0,1803,34.000000),(3443,82,0,1803,1.000000),(3444,77,0,1804,34.000000),(3445,82,0,1804,1.000000),(3446,77,0,1805,34.000000),(3447,82,0,1805,1.000000),(3448,77,0,1806,34.000000),(3449,82,0,1806,1.000000),(3450,77,0,1807,34.000000),(3451,82,0,1807,1.000000),(3452,77,0,1808,34.000000),(3453,82,0,1808,1.000000),(3454,77,0,1809,34.000000),(3455,82,0,1809,1.000000),(3456,77,0,1810,34.000000),(3457,82,0,1810,1.000000),(3458,77,0,1811,34.000000),(3459,82,0,1811,1.000000),(3460,77,0,1812,34.000000),(3461,77,0,1813,39.000000),(3462,82,0,1813,1.000000),(3463,77,0,1814,39.000000),(3464,82,0,1814,1.000000),(3465,77,0,1815,39.000000),(3466,82,0,1815,1.000000),(3467,77,0,1816,39.000000),(3468,82,0,1816,1.000000),(3469,77,0,1817,39.000000),(3470,82,0,1817,1.000000),(3471,77,0,1818,39.000000),(3472,82,0,1818,1.000000),(3473,77,0,1819,39.000000),(3474,77,0,1820,42.000000),(3475,82,0,1820,1.000000),(3476,77,0,1821,42.000000),(3477,82,0,1821,1.000000),(3478,77,0,1822,42.000000),(3479,82,0,1822,1.000000),(3480,77,0,1823,42.000000),(3481,82,0,1823,1.000000),(3482,77,0,1824,42.000000),(3483,82,0,1824,1.000000),(3484,77,0,1825,42.000000),(3485,82,0,1825,1.000000),(3486,77,0,1826,42.000000),(3487,77,0,1827,48.000000),(3488,82,0,1827,1.000000),(3489,77,0,1828,48.000000),(3490,82,0,1828,1.000000),(3491,77,0,1829,48.000000),(3492,82,0,1829,1.000000),(3493,77,0,1830,48.000000),(3494,82,0,1830,1.000000),(3495,77,0,1831,48.000000),(3496,82,0,1831,1.000000),(3497,77,0,1832,48.000000),(3498,82,0,1832,1.000000),(3499,77,0,1833,48.000000),(3500,77,0,1834,75.000000),(3501,82,0,1834,1.000000),(3502,77,0,1835,75.000000),(3503,82,0,1835,1.000000),(3504,77,0,1836,75.000000),(3505,82,0,1836,1.000000),(3506,77,0,1837,75.000000),(3507,82,0,1837,1.000000),(3508,77,0,1838,75.000000),(3509,82,0,1838,1.000000),(3510,77,0,1839,75.000000),(3511,82,0,1839,1.000000),(3512,77,0,1840,75.000000),(3513,77,0,1841,75.000000),(3514,82,0,1841,1.000000),(3515,77,0,1842,75.000000),(3516,82,0,1842,1.000000),(3517,77,0,1843,75.000000),(3518,82,0,1843,1.000000),(3519,77,0,1844,75.000000),(3520,82,0,1844,1.000000),(3521,77,0,1845,75.000000),(3522,82,0,1845,1.000000),(3523,77,0,1846,75.000000),(3524,82,0,1846,1.000000),(3525,77,0,1847,75.000000),(3526,77,0,1848,59.000000),(3527,82,0,1848,1.000000),(3528,77,0,1849,59.000000),(3529,82,0,1849,1.000000),(3530,77,0,1850,59.000000),(3531,82,0,1850,1.000000),(3532,77,0,1851,59.000000),(3533,82,0,1851,1.000000),(3534,77,0,1852,59.000000),(3535,82,0,1852,1.000000),(3536,77,0,1853,59.000000),(3537,82,0,1853,1.000000),(3538,77,0,1854,59.000000),(3539,77,0,1855,48.000000),(3540,82,0,1855,1.000000),(3541,77,0,1856,48.000000),(3542,82,0,1856,1.000000),(3543,77,0,1857,48.000000),(3544,82,0,1857,1.000000),(3545,77,0,1858,48.000000),(3546,82,0,1858,1.000000),(3547,77,0,1859,48.000000),(3548,82,0,1859,1.000000),(3549,77,0,1860,48.000000),(3550,82,0,1860,1.000000),(3551,77,0,1861,48.000000),(3552,77,0,1862,48.000000),(3553,82,0,1862,1.000000),(3554,77,0,1863,48.000000),(3555,82,0,1863,1.000000),(3556,77,0,1864,48.000000),(3557,82,0,1864,1.000000),(3558,77,0,1865,48.000000),(3559,82,0,1865,1.000000),(3560,77,0,1866,48.000000),(3561,82,0,1866,1.000000),(3562,77,0,1867,48.000000),(3563,82,0,1867,1.000000),(3564,77,0,1868,48.000000),(3565,77,0,1869,51.000000),(3566,82,0,1869,1.000000),(3567,77,0,1870,51.000000),(3568,82,0,1870,1.000000),(3569,77,0,1871,51.000000),(3570,82,0,1871,1.000000),(3571,77,0,1872,51.000000),(3572,82,0,1872,1.000000),(3573,77,0,1873,51.000000),(3574,82,0,1873,1.000000),(3575,77,0,1874,51.000000),(3576,82,0,1874,1.000000),(3577,77,0,1875,51.000000),(3578,77,0,1876,51.000000),(3579,82,0,1876,1.000000),(3580,77,0,1877,51.000000),(3581,82,0,1877,1.000000),(3582,77,0,1878,51.000000),(3583,82,0,1878,1.000000),(3584,77,0,1879,51.000000),(3585,82,0,1879,1.000000),(3586,77,0,1880,51.000000),(3587,82,0,1880,1.000000),(3588,77,0,1881,51.000000),(3589,82,0,1881,1.000000),(3590,77,0,1882,51.000000),(3591,77,0,1883,42.000000),(3592,82,0,1883,1.000000),(3593,77,0,1884,42.000000),(3594,82,0,1884,1.000000),(3595,77,0,1885,42.000000),(3596,82,0,1885,1.000000),(3597,77,0,1886,42.000000),(3598,82,0,1886,1.000000),(3599,77,0,1887,42.000000),(3600,82,0,1887,1.000000),(3601,77,0,1888,42.000000),(3602,82,0,1888,1.000000),(3603,77,0,1889,42.000000),(3604,77,0,1890,63.000000),(3605,82,0,1890,1.000000),(3606,77,0,1891,63.000000),(3607,82,0,1891,1.000000),(3608,77,0,1892,63.000000),(3609,82,0,1892,1.000000),(3610,77,0,1893,63.000000),(3611,82,0,1893,1.000000),(3612,77,0,1894,63.000000),(3613,82,0,1894,1.000000),(3614,77,0,1895,63.000000),(3615,82,0,1895,1.000000),(3616,77,0,1896,63.000000),(3617,77,0,1897,49.000000),(3618,82,0,1897,1.000000),(3619,77,0,1898,49.000000),(3620,82,0,1898,1.000000),(3621,77,0,1899,49.000000),(3622,82,0,1899,1.000000),(3623,77,0,1900,49.000000),(3624,82,0,1900,1.000000),(3625,77,0,1901,49.000000),(3626,82,0,1901,1.000000),(3627,77,0,1902,49.000000),(3628,82,0,1902,1.000000),(3629,77,0,1903,49.000000),(3630,77,0,1904,29.000000),(3631,82,0,1904,1.000000),(3632,77,0,1905,29.000000),(3633,82,0,1905,1.000000),(3634,77,0,1906,29.000000),(3635,82,0,1906,1.000000),(3636,77,0,1907,29.000000),(3637,82,0,1907,1.000000),(3638,77,0,1908,29.000000),(3639,82,0,1908,1.000000),(3640,77,0,1909,29.000000),(3641,82,0,1909,1.000000),(3642,77,0,1910,29.000000),(3643,82,0,1910,1.000000),(3644,77,0,1911,29.000000),(3645,82,0,1911,1.000000),(3646,77,0,1912,29.000000),(3647,82,0,1912,1.000000),(3648,77,0,1913,29.000000),(3649,82,0,1913,1.000000),(3650,77,0,1914,29.000000),(3651,82,0,1914,1.000000),(3652,77,0,1915,29.000000),(3653,82,0,1915,1.000000),(3654,77,0,1916,29.000000),(3655,82,0,1916,1.000000),(3656,77,0,1917,29.000000),(3657,82,0,1917,1.000000),(3658,77,0,1918,29.000000),(3659,82,0,1918,1.000000),(3660,77,0,1919,29.000000),(3661,77,0,1920,28.000000),(3662,82,0,1920,1.000000),(3663,77,0,1921,28.000000),(3664,82,0,1921,1.000000),(3665,77,0,1922,28.000000),(3666,82,0,1922,1.000000),(3667,77,0,1923,28.000000),(3668,82,0,1923,1.000000),(3669,77,0,1924,28.000000),(3670,82,0,1924,1.000000),(3671,77,0,1925,28.000000),(3672,82,0,1925,1.000000),(3673,77,0,1926,28.000000),(3674,82,0,1926,1.000000),(3675,77,0,1927,28.000000),(3676,82,0,1927,1.000000),(3677,77,0,1928,28.000000),(3678,82,0,1928,1.000000),(3679,77,0,1929,28.000000),(3680,82,0,1929,1.000000),(3681,77,0,1930,28.000000),(3682,82,0,1930,1.000000),(3683,77,0,1931,28.000000),(3684,82,0,1931,1.000000),(3685,77,0,1932,28.000000),(3686,82,0,1932,1.000000),(3687,77,0,1933,28.000000),(3688,82,0,1933,1.000000),(3689,77,0,1934,28.000000),(3690,82,0,1934,1.000000),(3691,77,0,1935,28.000000),(3692,77,0,1936,50.000000),(3693,82,0,1936,1.000000),(3694,77,0,1937,50.000000),(3695,82,0,1937,1.000000),(3696,77,0,1938,50.000000),(3697,82,0,1938,1.000000),(3698,77,0,1939,50.000000),(3699,82,0,1939,1.000000),(3700,77,0,1940,50.000000),(3701,82,0,1940,1.000000),(3702,77,0,1941,50.000000),(3703,82,0,1941,1.000000),(3704,77,0,1942,50.000000),(3705,82,0,1942,1.000000),(3706,77,0,1943,50.000000),(3707,82,0,1943,1.000000),(3708,77,0,1944,50.000000),(3709,82,0,1944,1.000000),(3710,77,0,1945,50.000000),(3711,82,0,1945,1.000000),(3712,77,0,1946,50.000000),(3713,82,0,1946,1.000000),(3714,77,0,1947,50.000000),(3715,82,0,1947,1.000000),(3716,77,0,1948,50.000000),(3717,82,0,1948,1.000000),(3718,77,0,1949,50.000000),(3719,82,0,1949,1.000000),(3720,77,0,1950,50.000000),(3721,82,0,1950,1.000000),(3722,77,0,1951,50.000000),(3723,77,0,1952,45.000000),(3724,82,0,1952,1.000000),(3725,77,0,1953,45.000000),(3726,82,0,1953,1.000000),(3727,77,0,1954,45.000000),(3728,82,0,1954,1.000000),(3729,77,0,1955,45.000000),(3730,82,0,1955,1.000000),(3731,77,0,1956,45.000000),(3732,82,0,1956,1.000000),(3733,77,0,1957,45.000000),(3734,82,0,1957,1.000000),(3735,77,0,1958,45.000000),(3736,82,0,1958,1.000000),(3737,77,0,1959,45.000000),(3738,82,0,1959,1.000000),(3739,77,0,1960,45.000000),(3740,82,0,1960,1.000000),(3741,77,0,1961,45.000000),(3742,82,0,1961,1.000000),(3743,77,0,1962,45.000000),(3744,82,0,1962,1.000000),(3745,77,0,1963,45.000000),(3746,82,0,1963,1.000000),(3747,77,0,1964,45.000000),(3748,82,0,1964,1.000000),(3749,77,0,1965,45.000000),(3750,82,0,1965,1.000000),(3751,77,0,1966,45.000000),(3752,82,0,1966,1.000000),(3753,77,0,1967,45.000000),(3754,77,0,1968,28.000000),(3755,82,0,1968,1.000000),(3756,77,0,1969,28.000000),(3757,82,0,1969,1.000000),(3758,77,0,1970,28.000000),(3759,82,0,1970,1.000000),(3760,77,0,1971,28.000000),(3761,82,0,1971,1.000000),(3762,77,0,1972,28.000000),(3763,82,0,1972,1.000000),(3764,77,0,1973,28.000000),(3765,82,0,1973,1.000000),(3766,77,0,1974,28.000000),(3767,82,0,1974,1.000000),(3768,77,0,1975,28.000000),(3769,82,0,1975,1.000000),(3770,77,0,1976,28.000000),(3771,82,0,1976,1.000000),(3772,77,0,1977,28.000000),(3773,82,0,1977,1.000000),(3774,77,0,1978,28.000000),(3775,82,0,1978,1.000000),(3776,77,0,1979,28.000000),(3777,82,0,1979,1.000000),(3778,77,0,1980,28.000000),(3779,82,0,1980,1.000000),(3780,77,0,1981,28.000000),(3781,82,0,1981,1.000000),(3782,77,0,1982,28.000000),(3783,82,0,1982,1.000000),(3784,77,0,1983,28.000000),(3785,77,0,1984,42.000000),(3786,82,0,1984,1.000000),(3787,77,0,1985,42.000000),(3788,82,0,1985,1.000000),(3789,77,0,1986,42.000000),(3790,82,0,1986,1.000000),(3791,77,0,1987,42.000000),(3792,82,0,1987,1.000000),(3793,77,0,1988,42.000000),(3794,82,0,1988,1.000000),(3795,77,0,1989,42.000000),(3796,82,0,1989,1.000000),(3797,77,0,1990,42.000000),(3798,77,0,1991,24.000000),(3799,82,0,1991,1.000000),(3800,77,0,1992,24.000000),(3801,82,0,1992,1.000000),(3802,77,0,1993,24.000000),(3803,82,0,1993,1.000000),(3804,77,0,1994,24.000000),(3805,82,0,1994,1.000000),(3806,77,0,1995,24.000000),(3807,82,0,1995,1.000000),(3808,77,0,1996,24.000000),(3809,82,0,1996,1.000000),(3810,77,0,1997,24.000000),(3811,77,0,1998,44.000000),(3812,82,0,1998,1.000000),(3813,77,0,1999,44.000000),(3814,82,0,1999,1.000000),(3815,77,0,2000,44.000000),(3816,82,0,2000,1.000000),(3817,77,0,2001,44.000000),(3818,82,0,2001,1.000000),(3819,77,0,2002,44.000000),(3820,82,0,2002,1.000000),(3821,77,0,2003,44.000000),(3822,77,0,2004,44.000000),(3823,82,0,2004,1.000000),(3824,77,0,2005,44.000000),(3825,82,0,2005,1.000000),(3826,77,0,2006,44.000000),(3827,82,0,2006,1.000000),(3828,77,0,2007,44.000000),(3829,82,0,2007,1.000000),(3830,77,0,2008,44.000000),(3831,82,0,2008,1.000000),(3832,77,0,2009,44.000000),(3833,82,0,2009,1.000000),(3834,77,0,2010,44.000000),(3835,77,0,2011,40.000000),(3836,82,0,2011,1.000000),(3837,77,0,2012,40.000000),(3838,82,0,2012,1.000000),(3839,77,0,2013,40.000000),(3840,82,0,2013,1.000000),(3841,77,0,2014,40.000000),(3842,82,0,2014,1.000000),(3843,77,0,2015,40.000000),(3844,82,0,2015,1.000000),(3845,77,0,2016,40.000000),(3846,82,0,2016,1.000000),(3847,77,0,2017,40.000000),(3848,77,0,2018,49.000000),(3849,82,0,2018,1.000000),(3850,77,0,2019,49.000000),(3851,82,0,2019,1.000000),(3852,77,0,2020,49.000000),(3853,82,0,2020,1.000000),(3854,77,0,2021,49.000000),(3855,82,0,2021,1.000000),(3856,77,0,2022,49.000000),(3857,82,0,2022,1.000000),(3858,77,0,2023,49.000000),(3859,82,0,2023,1.000000),(3860,77,0,2024,49.000000),(3861,77,0,2025,45.000000),(3862,82,0,2025,1.000000),(3863,77,0,2026,45.000000),(3864,82,0,2026,1.000000),(3865,77,0,2027,45.000000),(3866,82,0,2027,1.000000),(3867,77,0,2028,45.000000),(3868,82,0,2028,1.000000),(3869,77,0,2029,45.000000),(3870,82,0,2029,1.000000),(3871,77,0,2030,45.000000),(3872,82,0,2030,1.000000),(3873,77,0,2031,45.000000),(3874,82,0,2031,1.000000),(3875,77,0,2032,45.000000),(3876,82,0,2032,1.000000),(3877,77,0,2033,45.000000),(3878,82,0,2033,1.000000),(3879,77,0,2034,45.000000),(3880,82,0,2034,1.000000),(3881,77,0,2035,45.000000),(3882,82,0,2035,1.000000),(3883,77,0,2036,45.000000),(3884,82,0,2036,1.000000),(3885,77,0,2037,45.000000),(3886,82,0,2037,1.000000),(3887,77,0,2038,45.000000),(3888,82,0,2038,1.000000),(3889,77,0,2039,45.000000),(3890,82,0,2039,1.000000),(3891,77,0,2040,45.000000),(3892,123,0,1220,79.990000),(3893,123,0,1236,59.990000),(3894,123,0,1252,59.990000),(3895,123,0,1268,89.990000),(3896,123,0,1284,62.990000),(3897,123,0,1380,79.990000),(3898,123,0,1300,62.990000),(3899,123,0,1316,59.990000),(3900,123,0,1332,34.990000),(3901,123,0,1348,72.990000),(3902,123,0,1364,72.990000),(3903,123,0,1396,79.990000);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_gallery`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_gallery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_gallery` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_PRD_ENTT_GLR_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_GALLERY_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_GLR_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_GLR_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Gallery Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_gallery`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_gallery` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_gallery` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_gallery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_int`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_int` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_INT_STORE_ID` (`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE_ID_STORE_ID_VALUE` (`attribute_id`,`store_id`,`value`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_INT_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_INT_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_INT_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12621 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_int`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_int` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_int` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_int` VALUES (1,97,0,1,1),(2,99,0,1,4),(3,145,0,2,1),(4,147,0,2,1),(5,97,0,2,1),(6,134,0,2,2),(7,99,0,2,4),(8,97,0,3,1),(9,134,0,3,2),(10,99,0,3,4),(11,146,0,4,1),(12,97,0,4,1),(13,134,0,4,2),(14,99,0,4,4),(15,146,0,5,1),(16,97,0,5,1),(17,134,0,5,2),(18,99,0,5,4),(19,97,0,6,1),(20,134,0,6,2),(21,99,0,6,4),(22,97,0,7,1),(23,134,0,7,2),(24,99,0,7,4),(25,97,0,8,1),(26,134,0,8,2),(27,99,0,8,4),(28,97,0,9,1),(29,134,0,9,2),(30,99,0,9,4),(31,145,0,10,1),(32,147,0,10,1),(33,97,0,10,1),(34,134,0,10,2),(35,99,0,10,4),(36,145,0,11,1),(37,147,0,11,1),(38,97,0,11,1),(39,134,0,11,2),(40,99,0,11,4),(41,97,0,12,1),(42,134,0,12,2),(43,99,0,12,4),(44,146,0,13,1),(45,97,0,13,1),(46,134,0,13,2),(47,99,0,13,4),(48,144,0,14,1),(49,97,0,14,1),(50,134,0,14,2),(51,99,0,14,4),(52,97,0,15,1),(53,99,0,15,4),(54,145,0,16,1),(55,147,0,16,1),(56,97,0,16,1),(57,134,0,16,2),(58,99,0,16,4),(59,97,0,17,1),(60,134,0,17,2),(61,99,0,17,4),(62,97,0,18,1),(63,134,0,18,2),(64,99,0,18,4),(65,145,0,19,1),(66,146,0,19,1),(67,97,0,19,1),(68,134,0,19,2),(69,99,0,19,4),(70,97,0,20,1),(71,134,0,20,2),(72,99,0,20,4),(73,97,0,21,1),(74,134,0,21,2),(75,99,0,21,4),(76,97,0,22,1),(77,134,0,22,2),(78,99,0,22,4),(79,97,0,23,1),(80,134,0,23,2),(81,99,0,23,4),(82,93,0,24,52),(83,142,0,24,91),(84,97,0,24,1),(85,99,0,24,1),(86,93,0,25,58),(87,142,0,25,91),(88,97,0,25,1),(89,134,0,25,2),(90,99,0,25,1),(91,93,0,26,50),(92,142,0,26,91),(93,97,0,26,1),(94,134,0,26,2),(95,99,0,26,1),(96,93,0,27,52),(97,142,0,27,92),(98,97,0,27,1),(99,134,0,27,2),(100,99,0,27,1),(101,93,0,28,58),(102,142,0,28,92),(103,97,0,28,1),(104,134,0,28,2),(105,99,0,28,1),(106,93,0,29,50),(107,142,0,29,92),(108,97,0,29,1),(109,134,0,29,2),(110,99,0,29,1),(111,93,0,30,52),(112,142,0,30,93),(113,97,0,30,1),(114,134,0,30,2),(115,99,0,30,1),(116,93,0,31,58),(117,142,0,31,93),(118,97,0,31,1),(119,134,0,31,2),(120,99,0,31,1),(121,93,0,32,50),(122,142,0,32,93),(123,97,0,32,1),(124,134,0,32,2),(125,99,0,32,1),(126,142,0,33,94),(127,97,0,33,1),(128,99,0,33,1),(129,142,0,34,95),(130,97,0,34,1),(131,134,0,34,2),(132,99,0,34,1),(133,142,0,35,96),(134,97,0,35,1),(135,134,0,35,2),(136,99,0,35,1),(137,97,0,36,1),(138,134,0,36,2),(139,99,0,36,4),(140,97,0,37,1),(141,134,0,37,2),(142,99,0,37,4),(143,146,0,38,1),(144,97,0,38,1),(145,134,0,38,2),(146,99,0,38,4),(147,146,0,39,1),(148,97,0,39,1),(149,134,0,39,2),(150,99,0,39,4),(151,146,0,40,1),(152,97,0,40,1),(153,134,0,40,2),(154,99,0,40,4),(155,147,0,41,1),(156,97,0,41,1),(157,134,0,41,2),(158,99,0,41,4),(159,147,0,42,1),(160,97,0,42,1),(161,134,0,42,2),(162,99,0,42,4),(163,97,0,43,1),(164,134,0,43,2),(165,99,0,43,4),(166,146,0,44,1),(167,97,0,44,1),(168,134,0,44,2),(169,99,0,44,4),(170,125,0,45,0),(171,128,0,45,0),(172,129,0,45,0),(173,126,0,45,0),(174,97,0,45,1),(175,134,0,45,2),(176,99,0,45,4),(177,127,0,45,0),(178,97,0,46,1),(179,99,0,46,4),(180,97,0,47,1),(181,134,0,47,2),(182,115,0,47,1),(183,99,0,47,1),(184,93,0,47,49),(185,142,0,47,166),(186,97,0,48,1),(187,134,0,48,2),(188,115,0,48,1),(189,99,0,48,1),(190,93,0,48,52),(191,142,0,48,166),(192,97,0,49,1),(193,134,0,49,2),(194,115,0,49,1),(195,99,0,49,1),(196,93,0,49,56),(197,142,0,49,166),(198,97,0,50,1),(199,134,0,50,2),(200,115,0,50,1),(201,99,0,50,1),(202,93,0,50,49),(203,142,0,50,167),(204,97,0,51,1),(205,134,0,51,2),(206,115,0,51,1),(207,99,0,51,1),(208,93,0,51,52),(209,142,0,51,167),(210,97,0,52,1),(211,134,0,52,2),(212,115,0,52,1),(213,99,0,52,1),(214,93,0,52,56),(215,142,0,52,167),(216,97,0,53,1),(217,134,0,53,2),(218,115,0,53,1),(219,99,0,53,1),(220,93,0,53,49),(221,142,0,53,168),(222,97,0,54,1),(223,134,0,54,2),(224,115,0,54,1),(225,99,0,54,1),(226,93,0,54,52),(227,142,0,54,168),(228,97,0,55,1),(229,134,0,55,2),(230,115,0,55,1),(231,99,0,55,1),(232,93,0,55,56),(233,142,0,55,168),(234,97,0,56,1),(235,134,0,56,2),(236,115,0,56,1),(237,99,0,56,1),(238,93,0,56,49),(239,142,0,56,169),(240,97,0,57,1),(241,134,0,57,2),(242,115,0,57,1),(243,99,0,57,1),(244,93,0,57,52),(245,142,0,57,169),(246,97,0,58,1),(247,134,0,58,2),(248,115,0,58,1),(249,99,0,58,1),(250,93,0,58,56),(251,142,0,58,169),(252,97,0,59,1),(253,134,0,59,2),(254,115,0,59,1),(255,99,0,59,1),(256,93,0,59,49),(257,142,0,59,170),(258,97,0,60,1),(259,134,0,60,2),(260,115,0,60,1),(261,99,0,60,1),(262,93,0,60,52),(263,142,0,60,170),(264,97,0,61,1),(265,134,0,61,2),(266,115,0,61,1),(267,99,0,61,1),(268,93,0,61,56),(269,142,0,61,170),(270,97,0,62,1),(271,134,0,62,2),(272,115,0,62,1),(273,99,0,62,4),(274,143,0,62,1),(275,144,0,62,0),(276,145,0,62,0),(277,146,0,62,0),(278,147,0,62,1),(279,97,0,63,1),(280,134,0,63,2),(281,115,0,63,1),(282,99,0,63,1),(283,93,0,63,49),(284,142,0,63,166),(285,97,0,64,1),(286,134,0,64,2),(287,115,0,64,1),(288,99,0,64,1),(289,93,0,64,57),(290,142,0,64,166),(291,97,0,65,1),(292,134,0,65,2),(293,115,0,65,1),(294,99,0,65,1),(295,93,0,65,58),(296,142,0,65,166),(297,97,0,66,1),(298,134,0,66,2),(299,115,0,66,1),(300,99,0,66,1),(301,93,0,66,49),(302,142,0,66,167),(303,97,0,67,1),(304,134,0,67,2),(305,115,0,67,1),(306,99,0,67,1),(307,93,0,67,57),(308,142,0,67,167),(309,97,0,68,1),(310,134,0,68,2),(311,115,0,68,1),(312,99,0,68,1),(313,93,0,68,58),(314,142,0,68,167),(315,97,0,69,1),(316,134,0,69,2),(317,115,0,69,1),(318,99,0,69,1),(319,93,0,69,49),(320,142,0,69,168),(321,97,0,70,1),(322,134,0,70,2),(323,115,0,70,1),(324,99,0,70,1),(325,93,0,70,57),(326,142,0,70,168),(327,97,0,71,1),(328,134,0,71,2),(329,115,0,71,1),(330,99,0,71,1),(331,93,0,71,58),(332,142,0,71,168),(333,97,0,72,1),(334,134,0,72,2),(335,115,0,72,1),(336,99,0,72,1),(337,93,0,72,49),(338,142,0,72,169),(339,97,0,73,1),(340,134,0,73,2),(341,115,0,73,1),(342,99,0,73,1),(343,93,0,73,57),(344,142,0,73,169),(345,97,0,74,1),(346,134,0,74,2),(347,115,0,74,1),(348,99,0,74,1),(349,93,0,74,58),(350,142,0,74,169),(351,97,0,75,1),(352,134,0,75,2),(353,115,0,75,1),(354,99,0,75,1),(355,93,0,75,49),(356,142,0,75,170),(357,97,0,76,1),(358,134,0,76,2),(359,115,0,76,1),(360,99,0,76,1),(361,93,0,76,57),(362,142,0,76,170),(363,97,0,77,1),(364,134,0,77,2),(365,115,0,77,1),(366,99,0,77,1),(367,93,0,77,58),(368,142,0,77,170),(369,97,0,78,1),(370,134,0,78,2),(371,115,0,78,1),(372,99,0,78,4),(373,143,0,78,0),(374,144,0,78,0),(375,145,0,78,0),(376,146,0,78,1),(377,147,0,78,0),(378,97,0,79,1),(379,134,0,79,2),(380,115,0,79,1),(381,99,0,79,1),(382,93,0,79,49),(383,142,0,79,166),(384,97,0,80,1),(385,134,0,80,2),(386,115,0,80,1),(387,99,0,80,1),(388,93,0,80,50),(389,142,0,80,166),(390,97,0,81,1),(391,134,0,81,2),(392,115,0,81,1),(393,99,0,81,1),(394,93,0,81,53),(395,142,0,81,166),(396,97,0,82,1),(397,134,0,82,2),(398,115,0,82,1),(399,99,0,82,1),(400,93,0,82,49),(401,142,0,82,167),(402,97,0,83,1),(403,134,0,83,2),(404,115,0,83,1),(405,99,0,83,1),(406,93,0,83,50),(407,142,0,83,167),(408,97,0,84,1),(409,134,0,84,2),(410,115,0,84,1),(411,99,0,84,1),(412,93,0,84,53),(413,142,0,84,167),(414,97,0,85,1),(415,134,0,85,2),(416,115,0,85,1),(417,99,0,85,1),(418,93,0,85,49),(419,142,0,85,168),(420,97,0,86,1),(421,134,0,86,2),(422,115,0,86,1),(423,99,0,86,1),(424,93,0,86,50),(425,142,0,86,168),(426,97,0,87,1),(427,134,0,87,2),(428,115,0,87,1),(429,99,0,87,1),(430,93,0,87,53),(431,142,0,87,168),(432,97,0,88,1),(433,134,0,88,2),(434,115,0,88,1),(435,99,0,88,1),(436,93,0,88,49),(437,142,0,88,169),(438,97,0,89,1),(439,134,0,89,2),(440,115,0,89,1),(441,99,0,89,1),(442,93,0,89,50),(443,142,0,89,169),(444,97,0,90,1),(445,134,0,90,2),(446,115,0,90,1),(447,99,0,90,1),(448,93,0,90,53),(449,142,0,90,169),(450,97,0,91,1),(451,134,0,91,2),(452,115,0,91,1),(453,99,0,91,1),(454,93,0,91,49),(455,142,0,91,170),(456,97,0,92,1),(457,134,0,92,2),(458,115,0,92,1),(459,99,0,92,1),(460,93,0,92,50),(461,142,0,92,170),(462,97,0,93,1),(463,134,0,93,2),(464,115,0,93,1),(465,99,0,93,1),(466,93,0,93,53),(467,142,0,93,170),(468,97,0,94,1),(469,134,0,94,2),(470,115,0,94,1),(471,99,0,94,4),(472,143,0,94,1),(473,144,0,94,0),(474,145,0,94,1),(475,146,0,94,1),(476,147,0,94,0),(477,97,0,95,1),(478,134,0,95,2),(479,115,0,95,1),(480,99,0,95,1),(481,93,0,95,53),(482,142,0,95,166),(483,97,0,96,1),(484,134,0,96,2),(485,115,0,96,1),(486,99,0,96,1),(487,93,0,96,59),(488,142,0,96,166),(489,97,0,97,1),(490,134,0,97,2),(491,115,0,97,1),(492,99,0,97,1),(493,93,0,97,60),(494,142,0,97,166),(495,97,0,98,1),(496,134,0,98,2),(497,115,0,98,1),(498,99,0,98,1),(499,93,0,98,53),(500,142,0,98,167),(501,97,0,99,1),(502,134,0,99,2),(503,115,0,99,1),(504,99,0,99,1),(505,93,0,99,59),(506,142,0,99,167),(507,97,0,100,1),(508,134,0,100,2),(509,115,0,100,1),(510,99,0,100,1),(511,93,0,100,60),(512,142,0,100,167),(513,97,0,101,1),(514,134,0,101,2),(515,115,0,101,1),(516,99,0,101,1),(517,93,0,101,53),(518,142,0,101,168),(519,97,0,102,1),(520,134,0,102,2),(521,115,0,102,1),(522,99,0,102,1),(523,93,0,102,59),(524,142,0,102,168),(525,97,0,103,1),(526,134,0,103,2),(527,115,0,103,1),(528,99,0,103,1),(529,93,0,103,60),(530,142,0,103,168),(531,97,0,104,1),(532,134,0,104,2),(533,115,0,104,1),(534,99,0,104,1),(535,93,0,104,53),(536,142,0,104,169),(537,97,0,105,1),(538,134,0,105,2),(539,115,0,105,1),(540,99,0,105,1),(541,93,0,105,59),(542,142,0,105,169),(543,97,0,106,1),(544,134,0,106,2),(545,115,0,106,1),(546,99,0,106,1),(547,93,0,106,60),(548,142,0,106,169),(549,97,0,107,1),(550,134,0,107,2),(551,115,0,107,1),(552,99,0,107,1),(553,93,0,107,53),(554,142,0,107,170),(555,97,0,108,1),(556,134,0,108,2),(557,115,0,108,1),(558,99,0,108,1),(559,93,0,108,59),(560,142,0,108,170),(561,97,0,109,1),(562,134,0,109,2),(563,115,0,109,1),(564,99,0,109,1),(565,93,0,109,60),(566,142,0,109,170),(567,97,0,110,1),(568,134,0,110,2),(569,115,0,110,1),(570,99,0,110,4),(571,143,0,110,1),(572,144,0,110,1),(573,145,0,110,0),(574,146,0,110,0),(575,147,0,110,1),(576,97,0,111,1),(577,134,0,111,2),(578,115,0,111,1),(579,99,0,111,1),(580,93,0,111,53),(581,142,0,111,166),(582,97,0,112,1),(583,134,0,112,2),(584,115,0,112,1),(585,99,0,112,1),(586,93,0,112,58),(587,142,0,112,166),(588,97,0,113,1),(589,134,0,113,2),(590,115,0,113,1),(591,99,0,113,1),(592,93,0,113,59),(593,142,0,113,166),(594,97,0,114,1),(595,134,0,114,2),(596,115,0,114,1),(597,99,0,114,1),(598,93,0,114,53),(599,142,0,114,167),(600,97,0,115,1),(601,134,0,115,2),(602,115,0,115,1),(603,99,0,115,1),(604,93,0,115,58),(605,142,0,115,167),(606,97,0,116,1),(607,134,0,116,2),(608,115,0,116,1),(609,99,0,116,1),(610,93,0,116,59),(611,142,0,116,167),(612,97,0,117,1),(613,134,0,117,2),(614,115,0,117,1),(615,99,0,117,1),(616,93,0,117,53),(617,142,0,117,168),(618,97,0,118,1),(619,134,0,118,2),(620,115,0,118,1),(621,99,0,118,1),(622,93,0,118,58),(623,142,0,118,168),(624,97,0,119,1),(625,134,0,119,2),(626,115,0,119,1),(627,99,0,119,1),(628,93,0,119,59),(629,142,0,119,168),(630,97,0,120,1),(631,134,0,120,2),(632,115,0,120,1),(633,99,0,120,1),(634,93,0,120,53),(635,142,0,120,169),(636,97,0,121,1),(637,134,0,121,2),(638,115,0,121,1),(639,99,0,121,1),(640,93,0,121,58),(641,142,0,121,169),(642,97,0,122,1),(643,134,0,122,2),(644,115,0,122,1),(645,99,0,122,1),(646,93,0,122,59),(647,142,0,122,169),(648,97,0,123,1),(649,134,0,123,2),(650,115,0,123,1),(651,99,0,123,1),(652,93,0,123,53),(653,142,0,123,170),(654,97,0,124,1),(655,134,0,124,2),(656,115,0,124,1),(657,99,0,124,1),(658,93,0,124,58),(659,142,0,124,170),(660,97,0,125,1),(661,134,0,125,2),(662,115,0,125,1),(663,99,0,125,1),(664,93,0,125,59),(665,142,0,125,170),(666,97,0,126,1),(667,134,0,126,2),(668,115,0,126,1),(669,99,0,126,4),(670,143,0,126,0),(671,144,0,126,0),(672,145,0,126,0),(673,146,0,126,0),(674,147,0,126,0),(675,97,0,127,1),(676,134,0,127,2),(677,115,0,127,1),(678,99,0,127,1),(679,93,0,127,49),(680,142,0,127,166),(681,97,0,128,1),(682,134,0,128,2),(683,115,0,128,1),(684,99,0,128,1),(685,93,0,128,50),(686,142,0,128,166),(687,97,0,129,1),(688,134,0,129,2),(689,115,0,129,1),(690,99,0,129,1),(691,93,0,129,57),(692,142,0,129,166),(693,97,0,130,1),(694,134,0,130,2),(695,115,0,130,1),(696,99,0,130,1),(697,93,0,130,49),(698,142,0,130,167),(699,97,0,131,1),(700,134,0,131,2),(701,115,0,131,1),(702,99,0,131,1),(703,93,0,131,50),(704,142,0,131,167),(705,97,0,132,1),(706,134,0,132,2),(707,115,0,132,1),(708,99,0,132,1),(709,93,0,132,57),(710,142,0,132,167),(711,97,0,133,1),(712,134,0,133,2),(713,115,0,133,1),(714,99,0,133,1),(715,93,0,133,49),(716,142,0,133,168),(717,97,0,134,1),(718,134,0,134,2),(719,115,0,134,1),(720,99,0,134,1),(721,93,0,134,50),(722,142,0,134,168),(723,97,0,135,1),(724,134,0,135,2),(725,115,0,135,1),(726,99,0,135,1),(727,93,0,135,57),(728,142,0,135,168),(729,97,0,136,1),(730,134,0,136,2),(731,115,0,136,1),(732,99,0,136,1),(733,93,0,136,49),(734,142,0,136,169),(735,97,0,137,1),(736,134,0,137,2),(737,115,0,137,1),(738,99,0,137,1),(739,93,0,137,50),(740,142,0,137,169),(741,97,0,138,1),(742,134,0,138,2),(743,115,0,138,1),(744,99,0,138,1),(745,93,0,138,57),(746,142,0,138,169),(747,97,0,139,1),(748,134,0,139,2),(749,115,0,139,1),(750,99,0,139,1),(751,93,0,139,49),(752,142,0,139,170),(753,97,0,140,1),(754,134,0,140,2),(755,115,0,140,1),(756,99,0,140,1),(757,93,0,140,50),(758,142,0,140,170),(759,97,0,141,1),(760,134,0,141,2),(761,115,0,141,1),(762,99,0,141,1),(763,93,0,141,57),(764,142,0,141,170),(765,97,0,142,1),(766,134,0,142,2),(767,115,0,142,1),(768,99,0,142,4),(769,143,0,142,0),(770,144,0,142,0),(771,145,0,142,0),(772,146,0,142,0),(773,147,0,142,0),(774,97,0,143,1),(775,134,0,143,2),(776,115,0,143,1),(777,99,0,143,1),(778,93,0,143,49),(779,142,0,143,166),(780,97,0,144,1),(781,134,0,144,2),(782,115,0,144,1),(783,99,0,144,1),(784,93,0,144,52),(785,142,0,144,166),(786,97,0,145,1),(787,134,0,145,2),(788,115,0,145,1),(789,99,0,145,1),(790,93,0,145,53),(791,142,0,145,166),(792,97,0,146,1),(793,134,0,146,2),(794,115,0,146,1),(795,99,0,146,1),(796,93,0,146,49),(797,142,0,146,167),(798,97,0,147,1),(799,134,0,147,2),(800,115,0,147,1),(801,99,0,147,1),(802,93,0,147,52),(803,142,0,147,167),(804,97,0,148,1),(805,134,0,148,2),(806,115,0,148,1),(807,99,0,148,1),(808,93,0,148,53),(809,142,0,148,167),(810,97,0,149,1),(811,134,0,149,2),(812,115,0,149,1),(813,99,0,149,1),(814,93,0,149,49),(815,142,0,149,168),(816,97,0,150,1),(817,134,0,150,2),(818,115,0,150,1),(819,99,0,150,1),(820,93,0,150,52),(821,142,0,150,168),(822,97,0,151,1),(823,134,0,151,2),(824,115,0,151,1),(825,99,0,151,1),(826,93,0,151,53),(827,142,0,151,168),(828,97,0,152,1),(829,134,0,152,2),(830,115,0,152,1),(831,99,0,152,1),(832,93,0,152,49),(833,142,0,152,169),(834,97,0,153,1),(835,134,0,153,2),(836,115,0,153,1),(837,99,0,153,1),(838,93,0,153,52),(839,142,0,153,169),(840,97,0,154,1),(841,134,0,154,2),(842,115,0,154,1),(843,99,0,154,1),(844,93,0,154,53),(845,142,0,154,169),(846,97,0,155,1),(847,134,0,155,2),(848,115,0,155,1),(849,99,0,155,1),(850,93,0,155,49),(851,142,0,155,170),(852,97,0,156,1),(853,134,0,156,2),(854,115,0,156,1),(855,99,0,156,1),(856,93,0,156,52),(857,142,0,156,170),(858,97,0,157,1),(859,134,0,157,2),(860,115,0,157,1),(861,99,0,157,1),(862,93,0,157,53),(863,142,0,157,170),(864,97,0,158,1),(865,134,0,158,2),(866,115,0,158,1),(867,99,0,158,4),(868,143,0,158,0),(869,144,0,158,0),(870,145,0,158,0),(871,146,0,158,1),(872,147,0,158,0),(873,97,0,159,1),(874,134,0,159,2),(875,115,0,159,1),(876,99,0,159,1),(877,93,0,159,51),(878,142,0,159,166),(879,97,0,160,1),(880,134,0,160,2),(881,115,0,160,1),(882,99,0,160,1),(883,93,0,160,57),(884,142,0,160,166),(885,97,0,161,1),(886,134,0,161,2),(887,115,0,161,1),(888,99,0,161,1),(889,93,0,161,58),(890,142,0,161,166),(891,97,0,162,1),(892,134,0,162,2),(893,115,0,162,1),(894,99,0,162,1),(895,93,0,162,51),(896,142,0,162,167),(897,97,0,163,1),(898,134,0,163,2),(899,115,0,163,1),(900,99,0,163,1),(901,93,0,163,57),(902,142,0,163,167),(903,97,0,164,1),(904,134,0,164,2),(905,115,0,164,1),(906,99,0,164,1),(907,93,0,164,58),(908,142,0,164,167),(909,97,0,165,1),(910,134,0,165,2),(911,115,0,165,1),(912,99,0,165,1),(913,93,0,165,51),(914,142,0,165,168),(915,97,0,166,1),(916,134,0,166,2),(917,115,0,166,1),(918,99,0,166,1),(919,93,0,166,57),(920,142,0,166,168),(921,97,0,167,1),(922,134,0,167,2),(923,115,0,167,1),(924,99,0,167,1),(925,93,0,167,58),(926,142,0,167,168),(927,97,0,168,1),(928,134,0,168,2),(929,115,0,168,1),(930,99,0,168,1),(931,93,0,168,51),(932,142,0,168,169),(933,97,0,169,1),(934,134,0,169,2),(935,115,0,169,1),(936,99,0,169,1),(937,93,0,169,57),(938,142,0,169,169),(939,97,0,170,1),(940,134,0,170,2),(941,115,0,170,1),(942,99,0,170,1),(943,93,0,170,58),(944,142,0,170,169),(945,97,0,171,1),(946,134,0,171,2),(947,115,0,171,1),(948,99,0,171,1),(949,93,0,171,51),(950,142,0,171,170),(951,97,0,172,1),(952,134,0,172,2),(953,115,0,172,1),(954,99,0,172,1),(955,93,0,172,57),(956,142,0,172,170),(957,97,0,173,1),(958,134,0,173,2),(959,115,0,173,1),(960,99,0,173,1),(961,93,0,173,58),(962,142,0,173,170),(963,97,0,174,1),(964,134,0,174,2),(965,115,0,174,1),(966,99,0,174,4),(967,143,0,174,0),(968,144,0,174,0),(969,145,0,174,0),(970,146,0,174,0),(971,147,0,174,0),(972,97,0,175,1),(973,134,0,175,2),(974,115,0,175,1),(975,99,0,175,1),(976,93,0,175,50),(977,142,0,175,166),(978,97,0,176,1),(979,134,0,176,2),(980,115,0,176,1),(981,99,0,176,1),(982,93,0,176,53),(983,142,0,176,166),(984,97,0,177,1),(985,134,0,177,2),(986,115,0,177,1),(987,99,0,177,1),(988,93,0,177,58),(989,142,0,177,166),(990,97,0,178,1),(991,134,0,178,2),(992,115,0,178,1),(993,99,0,178,1),(994,93,0,178,50),(995,142,0,178,167),(996,97,0,179,1),(997,134,0,179,2),(998,115,0,179,1),(999,99,0,179,1),(1000,93,0,179,53),(1001,142,0,179,167),(1002,97,0,180,1),(1003,134,0,180,2),(1004,115,0,180,1),(1005,99,0,180,1),(1006,93,0,180,58),(1007,142,0,180,167),(1008,97,0,181,1),(1009,134,0,181,2),(1010,115,0,181,1),(1011,99,0,181,1),(1012,93,0,181,50),(1013,142,0,181,168),(1014,97,0,182,1),(1015,134,0,182,2),(1016,115,0,182,1),(1017,99,0,182,1),(1018,93,0,182,53),(1019,142,0,182,168),(1020,97,0,183,1),(1021,134,0,183,2),(1022,115,0,183,1),(1023,99,0,183,1),(1024,93,0,183,58),(1025,142,0,183,168),(1026,97,0,184,1),(1027,134,0,184,2),(1028,115,0,184,1),(1029,99,0,184,1),(1030,93,0,184,50),(1031,142,0,184,169),(1032,97,0,185,1),(1033,134,0,185,2),(1034,115,0,185,1),(1035,99,0,185,1),(1036,93,0,185,53),(1037,142,0,185,169),(1038,97,0,186,1),(1039,134,0,186,2),(1040,115,0,186,1),(1041,99,0,186,1),(1042,93,0,186,58),(1043,142,0,186,169),(1044,97,0,187,1),(1045,134,0,187,2),(1046,115,0,187,1),(1047,99,0,187,1),(1048,93,0,187,50),(1049,142,0,187,170),(1050,97,0,188,1),(1051,134,0,188,2),(1052,115,0,188,1),(1053,99,0,188,1),(1054,93,0,188,53),(1055,142,0,188,170),(1056,97,0,189,1),(1057,134,0,189,2),(1058,115,0,189,1),(1059,99,0,189,1),(1060,93,0,189,58),(1061,142,0,189,170),(1062,97,0,190,1),(1063,134,0,190,2),(1064,115,0,190,1),(1065,99,0,190,4),(1066,143,0,190,0),(1067,144,0,190,0),(1068,145,0,190,1),(1069,146,0,190,0),(1070,147,0,190,0),(1071,97,0,191,1),(1072,134,0,191,2),(1073,115,0,191,1),(1074,99,0,191,1),(1075,93,0,191,49),(1076,142,0,191,166),(1077,97,0,192,1),(1078,134,0,192,2),(1079,115,0,192,1),(1080,99,0,192,1),(1081,93,0,192,50),(1082,142,0,192,166),(1083,97,0,193,1),(1084,134,0,193,2),(1085,115,0,193,1),(1086,99,0,193,1),(1087,93,0,193,58),(1088,142,0,193,166),(1089,97,0,194,1),(1090,134,0,194,2),(1091,115,0,194,1),(1092,99,0,194,1),(1093,93,0,194,49),(1094,142,0,194,167),(1095,97,0,195,1),(1096,134,0,195,2),(1097,115,0,195,1),(1098,99,0,195,1),(1099,93,0,195,50),(1100,142,0,195,167),(1101,97,0,196,1),(1102,134,0,196,2),(1103,115,0,196,1),(1104,99,0,196,1),(1105,93,0,196,58),(1106,142,0,196,167),(1107,97,0,197,1),(1108,134,0,197,2),(1109,115,0,197,1),(1110,99,0,197,1),(1111,93,0,197,49),(1112,142,0,197,168),(1113,97,0,198,1),(1114,134,0,198,2),(1115,115,0,198,1),(1116,99,0,198,1),(1117,93,0,198,50),(1118,142,0,198,168),(1119,97,0,199,1),(1120,134,0,199,2),(1121,115,0,199,1),(1122,99,0,199,1),(1123,93,0,199,58),(1124,142,0,199,168),(1125,97,0,200,1),(1126,134,0,200,2),(1127,115,0,200,1),(1128,99,0,200,1),(1129,93,0,200,49),(1130,142,0,200,169),(1131,97,0,201,1),(1132,134,0,201,2),(1133,115,0,201,1),(1134,99,0,201,1),(1135,93,0,201,50),(1136,142,0,201,169),(1137,97,0,202,1),(1138,134,0,202,2),(1139,115,0,202,1),(1140,99,0,202,1),(1141,93,0,202,58),(1142,142,0,202,169),(1143,97,0,203,1),(1144,134,0,203,2),(1145,115,0,203,1),(1146,99,0,203,1),(1147,93,0,203,49),(1148,142,0,203,170),(1149,97,0,204,1),(1150,134,0,204,2),(1151,115,0,204,1),(1152,99,0,204,1),(1153,93,0,204,50),(1154,142,0,204,170),(1155,97,0,205,1),(1156,134,0,205,2),(1157,115,0,205,1),(1158,99,0,205,1),(1159,93,0,205,58),(1160,142,0,205,170),(1161,97,0,206,1),(1162,134,0,206,2),(1163,115,0,206,1),(1164,99,0,206,4),(1165,143,0,206,0),(1166,144,0,206,1),(1167,145,0,206,0),(1168,146,0,206,0),(1169,147,0,206,1),(1170,97,0,207,1),(1171,134,0,207,2),(1172,115,0,207,1),(1173,99,0,207,1),(1174,93,0,207,56),(1175,142,0,207,166),(1176,97,0,208,1),(1177,134,0,208,2),(1178,115,0,208,1),(1179,99,0,208,1),(1180,93,0,208,58),(1181,142,0,208,166),(1182,97,0,209,1),(1183,134,0,209,2),(1184,115,0,209,1),(1185,99,0,209,1),(1186,93,0,209,59),(1187,142,0,209,166),(1188,97,0,210,1),(1189,134,0,210,2),(1190,115,0,210,1),(1191,99,0,210,1),(1192,93,0,210,56),(1193,142,0,210,167),(1194,97,0,211,1),(1195,134,0,211,2),(1196,115,0,211,1),(1197,99,0,211,1),(1198,93,0,211,58),(1199,142,0,211,167),(1200,97,0,212,1),(1201,134,0,212,2),(1202,115,0,212,1),(1203,99,0,212,1),(1204,93,0,212,59),(1205,142,0,212,167),(1206,97,0,213,1),(1207,134,0,213,2),(1208,115,0,213,1),(1209,99,0,213,1),(1210,93,0,213,56),(1211,142,0,213,168),(1212,97,0,214,1),(1213,134,0,214,2),(1214,115,0,214,1),(1215,99,0,214,1),(1216,93,0,214,58),(1217,142,0,214,168),(1218,97,0,215,1),(1219,134,0,215,2),(1220,115,0,215,1),(1221,99,0,215,1),(1222,93,0,215,59),(1223,142,0,215,168),(1224,97,0,216,1),(1225,134,0,216,2),(1226,115,0,216,1),(1227,99,0,216,1),(1228,93,0,216,56),(1229,142,0,216,169),(1230,97,0,217,1),(1231,134,0,217,2),(1232,115,0,217,1),(1233,99,0,217,1),(1234,93,0,217,58),(1235,142,0,217,169),(1236,97,0,218,1),(1237,134,0,218,2),(1238,115,0,218,1),(1239,99,0,218,1),(1240,93,0,218,59),(1241,142,0,218,169),(1242,97,0,219,1),(1243,134,0,219,2),(1244,115,0,219,1),(1245,99,0,219,1),(1246,93,0,219,56),(1247,142,0,219,170),(1248,97,0,220,1),(1249,134,0,220,2),(1250,115,0,220,1),(1251,99,0,220,1),(1252,93,0,220,58),(1253,142,0,220,170),(1254,97,0,221,1),(1255,134,0,221,2),(1256,115,0,221,1),(1257,99,0,221,1),(1258,93,0,221,59),(1259,142,0,221,170),(1260,97,0,222,1),(1261,134,0,222,2),(1262,115,0,222,1),(1263,99,0,222,4),(1264,143,0,222,0),(1265,144,0,222,0),(1266,145,0,222,0),(1267,146,0,222,0),(1268,147,0,222,0),(1269,97,0,223,1),(1270,134,0,223,2),(1271,115,0,223,1),(1272,99,0,223,1),(1273,93,0,223,50),(1274,142,0,223,166),(1275,97,0,224,1),(1276,134,0,224,2),(1277,115,0,224,1),(1278,99,0,224,1),(1279,93,0,224,53),(1280,142,0,224,166),(1281,97,0,225,1),(1282,134,0,225,2),(1283,115,0,225,1),(1284,99,0,225,1),(1285,93,0,225,58),(1286,142,0,225,166),(1287,97,0,226,1),(1288,134,0,226,2),(1289,115,0,226,1),(1290,99,0,226,1),(1291,93,0,226,50),(1292,142,0,226,167),(1293,97,0,227,1),(1294,134,0,227,2),(1295,115,0,227,1),(1296,99,0,227,1),(1297,93,0,227,53),(1298,142,0,227,167),(1299,97,0,228,1),(1300,134,0,228,2),(1301,115,0,228,1),(1302,99,0,228,1),(1303,93,0,228,58),(1304,142,0,228,167),(1305,97,0,229,1),(1306,134,0,229,2),(1307,115,0,229,1),(1308,99,0,229,1),(1309,93,0,229,50),(1310,142,0,229,168),(1311,97,0,230,1),(1312,134,0,230,2),(1313,115,0,230,1),(1314,99,0,230,1),(1315,93,0,230,53),(1316,142,0,230,168),(1317,97,0,231,1),(1318,134,0,231,2),(1319,115,0,231,1),(1320,99,0,231,1),(1321,93,0,231,58),(1322,142,0,231,168),(1323,97,0,232,1),(1324,134,0,232,2),(1325,115,0,232,1),(1326,99,0,232,1),(1327,93,0,232,50),(1328,142,0,232,169),(1329,97,0,233,1),(1330,134,0,233,2),(1331,115,0,233,1),(1332,99,0,233,1),(1333,93,0,233,53),(1334,142,0,233,169),(1335,97,0,234,1),(1336,134,0,234,2),(1337,115,0,234,1),(1338,99,0,234,1),(1339,93,0,234,58),(1340,142,0,234,169),(1341,97,0,235,1),(1342,134,0,235,2),(1343,115,0,235,1),(1344,99,0,235,1),(1345,93,0,235,50),(1346,142,0,235,170),(1347,97,0,236,1),(1348,134,0,236,2),(1349,115,0,236,1),(1350,99,0,236,1),(1351,93,0,236,53),(1352,142,0,236,170),(1353,97,0,237,1),(1354,134,0,237,2),(1355,115,0,237,1),(1356,99,0,237,1),(1357,93,0,237,58),(1358,142,0,237,170),(1359,97,0,238,1),(1360,134,0,238,2),(1361,115,0,238,1),(1362,99,0,238,4),(1363,143,0,238,0),(1364,144,0,238,0),(1365,145,0,238,0),(1366,146,0,238,0),(1367,147,0,238,0),(1368,97,0,239,1),(1369,134,0,239,2),(1370,115,0,239,1),(1371,99,0,239,1),(1372,93,0,239,50),(1373,142,0,239,166),(1374,97,0,240,1),(1375,134,0,240,2),(1376,115,0,240,1),(1377,99,0,240,1),(1378,93,0,240,53),(1379,142,0,240,166),(1380,97,0,241,1),(1381,134,0,241,2),(1382,115,0,241,1),(1383,99,0,241,1),(1384,93,0,241,54),(1385,142,0,241,166),(1386,97,0,242,1),(1387,134,0,242,2),(1388,115,0,242,1),(1389,99,0,242,1),(1390,93,0,242,50),(1391,142,0,242,167),(1392,97,0,243,1),(1393,134,0,243,2),(1394,115,0,243,1),(1395,99,0,243,1),(1396,93,0,243,53),(1397,142,0,243,167),(1398,97,0,244,1),(1399,134,0,244,2),(1400,115,0,244,1),(1401,99,0,244,1),(1402,93,0,244,54),(1403,142,0,244,167),(1404,97,0,245,1),(1405,134,0,245,2),(1406,115,0,245,1),(1407,99,0,245,1),(1408,93,0,245,50),(1409,142,0,245,168),(1410,97,0,246,1),(1411,134,0,246,2),(1412,115,0,246,1),(1413,99,0,246,1),(1414,93,0,246,53),(1415,142,0,246,168),(1416,97,0,247,1),(1417,134,0,247,2),(1418,115,0,247,1),(1419,99,0,247,1),(1420,93,0,247,54),(1421,142,0,247,168),(1422,97,0,248,1),(1423,134,0,248,2),(1424,115,0,248,1),(1425,99,0,248,1),(1426,93,0,248,50),(1427,142,0,248,169),(1428,97,0,249,1),(1429,134,0,249,2),(1430,115,0,249,1),(1431,99,0,249,1),(1432,93,0,249,53),(1433,142,0,249,169),(1434,97,0,250,1),(1435,134,0,250,2),(1436,115,0,250,1),(1437,99,0,250,1),(1438,93,0,250,54),(1439,142,0,250,169),(1440,97,0,251,1),(1441,134,0,251,2),(1442,115,0,251,1),(1443,99,0,251,1),(1444,93,0,251,50),(1445,142,0,251,170),(1446,97,0,252,1),(1447,134,0,252,2),(1448,115,0,252,1),(1449,99,0,252,1),(1450,93,0,252,53),(1451,142,0,252,170),(1452,97,0,253,1),(1453,134,0,253,2),(1454,115,0,253,1),(1455,99,0,253,1),(1456,93,0,253,54),(1457,142,0,253,170),(1458,97,0,254,1),(1459,134,0,254,2),(1460,115,0,254,1),(1461,99,0,254,4),(1462,143,0,254,0),(1463,144,0,254,1),(1464,145,0,254,1),(1465,146,0,254,0),(1466,147,0,254,0),(1467,97,0,255,1),(1468,134,0,255,2),(1469,115,0,255,1),(1470,99,0,255,1),(1471,93,0,255,56),(1472,142,0,255,166),(1473,97,0,256,1),(1474,134,0,256,2),(1475,115,0,256,1),(1476,99,0,256,1),(1477,93,0,256,58),(1478,142,0,256,166),(1479,97,0,257,1),(1480,134,0,257,2),(1481,115,0,257,1),(1482,99,0,257,1),(1483,93,0,257,60),(1484,142,0,257,166),(1485,97,0,258,1),(1486,134,0,258,2),(1487,115,0,258,1),(1488,99,0,258,1),(1489,93,0,258,56),(1490,142,0,258,167),(1491,97,0,259,1),(1492,134,0,259,2),(1493,115,0,259,1),(1494,99,0,259,1),(1495,93,0,259,58),(1496,142,0,259,167),(1497,97,0,260,1),(1498,134,0,260,2),(1499,115,0,260,1),(1500,99,0,260,1),(1501,93,0,260,60),(1502,142,0,260,167),(1503,97,0,261,1),(1504,134,0,261,2),(1505,115,0,261,1),(1506,99,0,261,1),(1507,93,0,261,56),(1508,142,0,261,168),(1509,97,0,262,1),(1510,134,0,262,2),(1511,115,0,262,1),(1512,99,0,262,1),(1513,93,0,262,58),(1514,142,0,262,168),(1515,97,0,263,1),(1516,134,0,263,2),(1517,115,0,263,1),(1518,99,0,263,1),(1519,93,0,263,60),(1520,142,0,263,168),(1521,97,0,264,1),(1522,134,0,264,2),(1523,115,0,264,1),(1524,99,0,264,1),(1525,93,0,264,56),(1526,142,0,264,169),(1527,97,0,265,1),(1528,134,0,265,2),(1529,115,0,265,1),(1530,99,0,265,1),(1531,93,0,265,58),(1532,142,0,265,169),(1533,97,0,266,1),(1534,134,0,266,2),(1535,115,0,266,1),(1536,99,0,266,1),(1537,93,0,266,60),(1538,142,0,266,169),(1539,97,0,267,1),(1540,134,0,267,2),(1541,115,0,267,1),(1542,99,0,267,1),(1543,93,0,267,56),(1544,142,0,267,170),(1545,97,0,268,1),(1546,134,0,268,2),(1547,115,0,268,1),(1548,99,0,268,1),(1549,93,0,268,58),(1550,142,0,268,170),(1551,97,0,269,1),(1552,134,0,269,2),(1553,115,0,269,1),(1554,99,0,269,1),(1555,93,0,269,60),(1556,142,0,269,170),(1557,97,0,270,1),(1558,134,0,270,2),(1559,115,0,270,1),(1560,99,0,270,4),(1561,143,0,270,0),(1562,144,0,270,1),(1563,145,0,270,0),(1564,146,0,270,0),(1565,147,0,270,1),(1566,97,0,271,1),(1567,134,0,271,2),(1568,115,0,271,1),(1569,99,0,271,1),(1570,93,0,271,53),(1571,142,0,271,166),(1572,97,0,272,1),(1573,134,0,272,2),(1574,115,0,272,1),(1575,99,0,272,1),(1576,93,0,272,56),(1577,142,0,272,166),(1578,97,0,273,1),(1579,134,0,273,2),(1580,115,0,273,1),(1581,99,0,273,1),(1582,93,0,273,58),(1583,142,0,273,166),(1584,97,0,274,1),(1585,134,0,274,2),(1586,115,0,274,1),(1587,99,0,274,1),(1588,93,0,274,53),(1589,142,0,274,167),(1590,97,0,275,1),(1591,134,0,275,2),(1592,115,0,275,1),(1593,99,0,275,1),(1594,93,0,275,56),(1595,142,0,275,167),(1596,97,0,276,1),(1597,134,0,276,2),(1598,115,0,276,1),(1599,99,0,276,1),(1600,93,0,276,58),(1601,142,0,276,167),(1602,97,0,277,1),(1603,134,0,277,2),(1604,115,0,277,1),(1605,99,0,277,1),(1606,93,0,277,53),(1607,142,0,277,168),(1608,97,0,278,1),(1609,134,0,278,2),(1610,115,0,278,1),(1611,99,0,278,1),(1612,93,0,278,56),(1613,142,0,278,168),(1614,97,0,279,1),(1615,134,0,279,2),(1616,115,0,279,1),(1617,99,0,279,1),(1618,93,0,279,58),(1619,142,0,279,168),(1620,97,0,280,1),(1621,134,0,280,2),(1622,115,0,280,1),(1623,99,0,280,1),(1624,93,0,280,53),(1625,142,0,280,169),(1626,97,0,281,1),(1627,134,0,281,2),(1628,115,0,281,1),(1629,99,0,281,1),(1630,93,0,281,56),(1631,142,0,281,169),(1632,97,0,282,1),(1633,134,0,282,2),(1634,115,0,282,1),(1635,99,0,282,1),(1636,93,0,282,58),(1637,142,0,282,169),(1638,97,0,283,1),(1639,134,0,283,2),(1640,115,0,283,1),(1641,99,0,283,1),(1642,93,0,283,53),(1643,142,0,283,170),(1644,97,0,284,1),(1645,134,0,284,2),(1646,115,0,284,1),(1647,99,0,284,1),(1648,93,0,284,56),(1649,142,0,284,170),(1650,97,0,285,1),(1651,134,0,285,2),(1652,115,0,285,1),(1653,99,0,285,1),(1654,93,0,285,58),(1655,142,0,285,170),(1656,97,0,286,1),(1657,134,0,286,2),(1658,115,0,286,1),(1659,99,0,286,4),(1660,143,0,286,0),(1661,144,0,286,1),(1662,145,0,286,0),(1663,146,0,286,1),(1664,147,0,286,0),(1665,97,0,287,1),(1666,134,0,287,2),(1667,115,0,287,1),(1668,99,0,287,1),(1669,93,0,287,49),(1670,142,0,287,166),(1671,97,0,288,1),(1672,134,0,288,2),(1673,115,0,288,1),(1674,99,0,288,1),(1675,93,0,288,50),(1676,142,0,288,166),(1677,97,0,289,1),(1678,134,0,289,2),(1679,115,0,289,1),(1680,99,0,289,1),(1681,93,0,289,57),(1682,142,0,289,166),(1683,97,0,290,1),(1684,134,0,290,2),(1685,115,0,290,1),(1686,99,0,290,1),(1687,93,0,290,49),(1688,142,0,290,167),(1689,97,0,291,1),(1690,134,0,291,2),(1691,115,0,291,1),(1692,99,0,291,1),(1693,93,0,291,50),(1694,142,0,291,167),(1695,97,0,292,1),(1696,134,0,292,2),(1697,115,0,292,1),(1698,99,0,292,1),(1699,93,0,292,57),(1700,142,0,292,167),(1701,97,0,293,1),(1702,134,0,293,2),(1703,115,0,293,1),(1704,99,0,293,1),(1705,93,0,293,49),(1706,142,0,293,168),(1707,97,0,294,1),(1708,134,0,294,2),(1709,115,0,294,1),(1710,99,0,294,1),(1711,93,0,294,50),(1712,142,0,294,168),(1713,97,0,295,1),(1714,134,0,295,2),(1715,115,0,295,1),(1716,99,0,295,1),(1717,93,0,295,57),(1718,142,0,295,168),(1719,97,0,296,1),(1720,134,0,296,2),(1721,115,0,296,1),(1722,99,0,296,1),(1723,93,0,296,49),(1724,142,0,296,169),(1725,97,0,297,1),(1726,134,0,297,2),(1727,115,0,297,1),(1728,99,0,297,1),(1729,93,0,297,50),(1730,142,0,297,169),(1731,97,0,298,1),(1732,134,0,298,2),(1733,115,0,298,1),(1734,99,0,298,1),(1735,93,0,298,57),(1736,142,0,298,169),(1737,97,0,299,1),(1738,134,0,299,2),(1739,115,0,299,1),(1740,99,0,299,1),(1741,93,0,299,49),(1742,142,0,299,170),(1743,97,0,300,1),(1744,134,0,300,2),(1745,115,0,300,1),(1746,99,0,300,1),(1747,93,0,300,50),(1748,142,0,300,170),(1749,97,0,301,1),(1750,134,0,301,2),(1751,115,0,301,1),(1752,99,0,301,1),(1753,93,0,301,57),(1754,142,0,301,170),(1755,97,0,302,1),(1756,134,0,302,2),(1757,115,0,302,1),(1758,99,0,302,4),(1759,143,0,302,1),(1760,144,0,302,0),(1761,145,0,302,0),(1762,146,0,302,0),(1763,147,0,302,0),(1764,97,0,303,1),(1765,134,0,303,2),(1766,115,0,303,1),(1767,99,0,303,1),(1768,93,0,303,49),(1769,142,0,303,166),(1770,97,0,304,1),(1771,134,0,304,2),(1772,115,0,304,1),(1773,99,0,304,1),(1774,93,0,304,58),(1775,142,0,304,166),(1776,97,0,305,1),(1777,134,0,305,2),(1778,115,0,305,1),(1779,99,0,305,1),(1780,93,0,305,60),(1781,142,0,305,166),(1782,97,0,306,1),(1783,134,0,306,2),(1784,115,0,306,1),(1785,99,0,306,1),(1786,93,0,306,49),(1787,142,0,306,167),(1788,97,0,307,1),(1789,134,0,307,2),(1790,115,0,307,1),(1791,99,0,307,1),(1792,93,0,307,58),(1793,142,0,307,167),(1794,97,0,308,1),(1795,134,0,308,2),(1796,115,0,308,1),(1797,99,0,308,1),(1798,93,0,308,60),(1799,142,0,308,167),(1800,97,0,309,1),(1801,134,0,309,2),(1802,115,0,309,1),(1803,99,0,309,1),(1804,93,0,309,49),(1805,142,0,309,168),(1806,97,0,310,1),(1807,134,0,310,2),(1808,115,0,310,1),(1809,99,0,310,1),(1810,93,0,310,58),(1811,142,0,310,168),(1812,97,0,311,1),(1813,134,0,311,2),(1814,115,0,311,1),(1815,99,0,311,1),(1816,93,0,311,60),(1817,142,0,311,168),(1818,97,0,312,1),(1819,134,0,312,2),(1820,115,0,312,1),(1821,99,0,312,1),(1822,93,0,312,49),(1823,142,0,312,169),(1824,97,0,313,1),(1825,134,0,313,2),(1826,115,0,313,1),(1827,99,0,313,1),(1828,93,0,313,58),(1829,142,0,313,169),(1830,97,0,314,1),(1831,134,0,314,2),(1832,115,0,314,1),(1833,99,0,314,1),(1834,93,0,314,60),(1835,142,0,314,169),(1836,97,0,315,1),(1837,134,0,315,2),(1838,115,0,315,1),(1839,99,0,315,1),(1840,93,0,315,49),(1841,142,0,315,170),(1842,97,0,316,1),(1843,134,0,316,2),(1844,115,0,316,1),(1845,99,0,316,1),(1846,93,0,316,58),(1847,142,0,316,170),(1848,97,0,317,1),(1849,134,0,317,2),(1850,115,0,317,1),(1851,99,0,317,1),(1852,93,0,317,60),(1853,142,0,317,170),(1854,97,0,318,1),(1855,134,0,318,2),(1856,115,0,318,1),(1857,99,0,318,4),(1858,143,0,318,0),(1859,144,0,318,0),(1860,145,0,318,0),(1861,146,0,318,0),(1862,147,0,318,0),(1863,97,0,319,1),(1864,134,0,319,2),(1865,115,0,319,1),(1866,99,0,319,1),(1867,93,0,319,50),(1868,142,0,319,166),(1869,97,0,320,1),(1870,134,0,320,2),(1871,115,0,320,1),(1872,99,0,320,1),(1873,93,0,320,52),(1874,142,0,320,166),(1875,97,0,321,1),(1876,134,0,321,2),(1877,115,0,321,1),(1878,99,0,321,1),(1879,93,0,321,53),(1880,142,0,321,166),(1881,97,0,322,1),(1882,134,0,322,2),(1883,115,0,322,1),(1884,99,0,322,1),(1885,93,0,322,50),(1886,142,0,322,167),(1887,97,0,323,1),(1888,134,0,323,2),(1889,115,0,323,1),(1890,99,0,323,1),(1891,93,0,323,52),(1892,142,0,323,167),(1893,97,0,324,1),(1894,134,0,324,2),(1895,115,0,324,1),(1896,99,0,324,1),(1897,93,0,324,53),(1898,142,0,324,167),(1899,97,0,325,1),(1900,134,0,325,2),(1901,115,0,325,1),(1902,99,0,325,1),(1903,93,0,325,50),(1904,142,0,325,168),(1905,97,0,326,1),(1906,134,0,326,2),(1907,115,0,326,1),(1908,99,0,326,1),(1909,93,0,326,52),(1910,142,0,326,168),(1911,97,0,327,1),(1912,134,0,327,2),(1913,115,0,327,1),(1914,99,0,327,1),(1915,93,0,327,53),(1916,142,0,327,168),(1917,97,0,328,1),(1918,134,0,328,2),(1919,115,0,328,1),(1920,99,0,328,1),(1921,93,0,328,50),(1922,142,0,328,169),(1923,97,0,329,1),(1924,134,0,329,2),(1925,115,0,329,1),(1926,99,0,329,1),(1927,93,0,329,52),(1928,142,0,329,169),(1929,97,0,330,1),(1930,134,0,330,2),(1931,115,0,330,1),(1932,99,0,330,1),(1933,93,0,330,53),(1934,142,0,330,169),(1935,97,0,331,1),(1936,134,0,331,2),(1937,115,0,331,1),(1938,99,0,331,1),(1939,93,0,331,50),(1940,142,0,331,170),(1941,97,0,332,1),(1942,134,0,332,2),(1943,115,0,332,1),(1944,99,0,332,1),(1945,93,0,332,52),(1946,142,0,332,170),(1947,97,0,333,1),(1948,134,0,333,2),(1949,115,0,333,1),(1950,99,0,333,1),(1951,93,0,333,53),(1952,142,0,333,170),(1953,97,0,334,1),(1954,134,0,334,2),(1955,115,0,334,1),(1956,99,0,334,4),(1957,143,0,334,0),(1958,144,0,334,0),(1959,145,0,334,1),(1960,146,0,334,0),(1961,147,0,334,0),(1962,97,0,335,1),(1963,134,0,335,2),(1964,115,0,335,1),(1965,99,0,335,1),(1966,93,0,335,50),(1967,142,0,335,166),(1968,97,0,336,1),(1969,134,0,336,2),(1970,115,0,336,1),(1971,99,0,336,1),(1972,93,0,336,59),(1973,142,0,336,166),(1974,97,0,337,1),(1975,134,0,337,2),(1976,115,0,337,1),(1977,99,0,337,1),(1978,93,0,337,60),(1979,142,0,337,166),(1980,97,0,338,1),(1981,134,0,338,2),(1982,115,0,338,1),(1983,99,0,338,1),(1984,93,0,338,50),(1985,142,0,338,167),(1986,97,0,339,1),(1987,134,0,339,2),(1988,115,0,339,1),(1989,99,0,339,1),(1990,93,0,339,59),(1991,142,0,339,167),(1992,97,0,340,1),(1993,134,0,340,2),(1994,115,0,340,1),(1995,99,0,340,1),(1996,93,0,340,60),(1997,142,0,340,167),(1998,97,0,341,1),(1999,134,0,341,2),(2000,115,0,341,1),(2001,99,0,341,1),(2002,93,0,341,50),(2003,142,0,341,168),(2004,97,0,342,1),(2005,134,0,342,2),(2006,115,0,342,1),(2007,99,0,342,1),(2008,93,0,342,59),(2009,142,0,342,168),(2010,97,0,343,1),(2011,134,0,343,2),(2012,115,0,343,1),(2013,99,0,343,1),(2014,93,0,343,60),(2015,142,0,343,168),(2016,97,0,344,1),(2017,134,0,344,2),(2018,115,0,344,1),(2019,99,0,344,1),(2020,93,0,344,50),(2021,142,0,344,169),(2022,97,0,345,1),(2023,134,0,345,2),(2024,115,0,345,1),(2025,99,0,345,1),(2026,93,0,345,59),(2027,142,0,345,169),(2028,97,0,346,1),(2029,134,0,346,2),(2030,115,0,346,1),(2031,99,0,346,1),(2032,93,0,346,60),(2033,142,0,346,169),(2034,97,0,347,1),(2035,134,0,347,2),(2036,115,0,347,1),(2037,99,0,347,1),(2038,93,0,347,50),(2039,142,0,347,170),(2040,97,0,348,1),(2041,134,0,348,2),(2042,115,0,348,1),(2043,99,0,348,1),(2044,93,0,348,59),(2045,142,0,348,170),(2046,97,0,349,1),(2047,134,0,349,2),(2048,115,0,349,1),(2049,99,0,349,1),(2050,93,0,349,60),(2051,142,0,349,170),(2052,97,0,350,1),(2053,134,0,350,2),(2054,115,0,350,1),(2055,99,0,350,4),(2056,143,0,350,0),(2057,144,0,350,0),(2058,145,0,350,0),(2059,146,0,350,0),(2060,147,0,350,0),(2061,97,0,351,1),(2062,134,0,351,2),(2063,115,0,351,1),(2064,99,0,351,1),(2065,93,0,351,49),(2066,142,0,351,166),(2067,97,0,352,1),(2068,134,0,352,2),(2069,115,0,352,1),(2070,99,0,352,1),(2071,93,0,352,56),(2072,142,0,352,166),(2073,97,0,353,1),(2074,134,0,353,2),(2075,115,0,353,1),(2076,99,0,353,1),(2077,93,0,353,58),(2078,142,0,353,166),(2079,97,0,354,1),(2080,134,0,354,2),(2081,115,0,354,1),(2082,99,0,354,1),(2083,93,0,354,49),(2084,142,0,354,167),(2085,97,0,355,1),(2086,134,0,355,2),(2087,115,0,355,1),(2088,99,0,355,1),(2089,93,0,355,56),(2090,142,0,355,167),(2091,97,0,356,1),(2092,134,0,356,2),(2093,115,0,356,1),(2094,99,0,356,1),(2095,93,0,356,58),(2096,142,0,356,167),(2097,97,0,357,1),(2098,134,0,357,2),(2099,115,0,357,1),(2100,99,0,357,1),(2101,93,0,357,49),(2102,142,0,357,168),(2103,97,0,358,1),(2104,134,0,358,2),(2105,115,0,358,1),(2106,99,0,358,1),(2107,93,0,358,56),(2108,142,0,358,168),(2109,97,0,359,1),(2110,134,0,359,2),(2111,115,0,359,1),(2112,99,0,359,1),(2113,93,0,359,58),(2114,142,0,359,168),(2115,97,0,360,1),(2116,134,0,360,2),(2117,115,0,360,1),(2118,99,0,360,1),(2119,93,0,360,49),(2120,142,0,360,169),(2121,97,0,361,1),(2122,134,0,361,2),(2123,115,0,361,1),(2124,99,0,361,1),(2125,93,0,361,56),(2126,142,0,361,169),(2127,97,0,362,1),(2128,134,0,362,2),(2129,115,0,362,1),(2130,99,0,362,1),(2131,93,0,362,58),(2132,142,0,362,169),(2133,97,0,363,1),(2134,134,0,363,2),(2135,115,0,363,1),(2136,99,0,363,1),(2137,93,0,363,49),(2138,142,0,363,170),(2139,97,0,364,1),(2140,134,0,364,2),(2141,115,0,364,1),(2142,99,0,364,1),(2143,93,0,364,56),(2144,142,0,364,170),(2145,97,0,365,1),(2146,134,0,365,2),(2147,115,0,365,1),(2148,99,0,365,1),(2149,93,0,365,58),(2150,142,0,365,170),(2151,97,0,366,1),(2152,134,0,366,2),(2153,115,0,366,1),(2154,99,0,366,4),(2155,143,0,366,0),(2156,144,0,366,0),(2157,145,0,366,0),(2158,146,0,366,0),(2159,147,0,366,0),(2160,97,0,367,1),(2161,134,0,367,2),(2162,115,0,367,1),(2163,99,0,367,1),(2164,93,0,367,49),(2165,142,0,367,166),(2166,97,0,368,1),(2167,134,0,368,2),(2168,115,0,368,1),(2169,99,0,368,1),(2170,93,0,368,53),(2171,142,0,368,166),(2172,97,0,369,1),(2173,134,0,369,2),(2174,115,0,369,1),(2175,99,0,369,1),(2176,93,0,369,58),(2177,142,0,369,166),(2178,97,0,370,1),(2179,134,0,370,2),(2180,115,0,370,1),(2181,99,0,370,1),(2182,93,0,370,49),(2183,142,0,370,167),(2184,97,0,371,1),(2185,134,0,371,2),(2186,115,0,371,1),(2187,99,0,371,1),(2188,93,0,371,53),(2189,142,0,371,167),(2190,97,0,372,1),(2191,134,0,372,2),(2192,115,0,372,1),(2193,99,0,372,1),(2194,93,0,372,58),(2195,142,0,372,167),(2196,97,0,373,1),(2197,134,0,373,2),(2198,115,0,373,1),(2199,99,0,373,1),(2200,93,0,373,49),(2201,142,0,373,168),(2202,97,0,374,1),(2203,134,0,374,2),(2204,115,0,374,1),(2205,99,0,374,1),(2206,93,0,374,53),(2207,142,0,374,168),(2208,97,0,375,1),(2209,134,0,375,2),(2210,115,0,375,1),(2211,99,0,375,1),(2212,93,0,375,58),(2213,142,0,375,168),(2214,97,0,376,1),(2215,134,0,376,2),(2216,115,0,376,1),(2217,99,0,376,1),(2218,93,0,376,49),(2219,142,0,376,169),(2220,97,0,377,1),(2221,134,0,377,2),(2222,115,0,377,1),(2223,99,0,377,1),(2224,93,0,377,53),(2225,142,0,377,169),(2226,97,0,378,1),(2227,134,0,378,2),(2228,115,0,378,1),(2229,99,0,378,1),(2230,93,0,378,58),(2231,142,0,378,169),(2232,97,0,379,1),(2233,134,0,379,2),(2234,115,0,379,1),(2235,99,0,379,1),(2236,93,0,379,49),(2237,142,0,379,170),(2238,97,0,380,1),(2239,134,0,380,2),(2240,115,0,380,1),(2241,99,0,380,1),(2242,93,0,380,53),(2243,142,0,380,170),(2244,97,0,381,1),(2245,134,0,381,2),(2246,115,0,381,1),(2247,99,0,381,1),(2248,93,0,381,58),(2249,142,0,381,170),(2250,97,0,382,1),(2251,134,0,382,2),(2252,115,0,382,1),(2253,99,0,382,4),(2254,143,0,382,0),(2255,144,0,382,1),(2256,145,0,382,0),(2257,146,0,382,0),(2258,147,0,382,1),(2259,97,0,383,1),(2260,134,0,383,2),(2261,115,0,383,1),(2262,99,0,383,1),(2263,93,0,383,50),(2264,142,0,383,166),(2265,97,0,384,1),(2266,134,0,384,2),(2267,115,0,384,1),(2268,99,0,384,1),(2269,93,0,384,53),(2270,142,0,384,166),(2271,97,0,385,1),(2272,134,0,385,2),(2273,115,0,385,1),(2274,99,0,385,1),(2275,93,0,385,57),(2276,142,0,385,166),(2277,97,0,386,1),(2278,134,0,386,2),(2279,115,0,386,1),(2280,99,0,386,1),(2281,93,0,386,50),(2282,142,0,386,167),(2283,97,0,387,1),(2284,134,0,387,2),(2285,115,0,387,1),(2286,99,0,387,1),(2287,93,0,387,53),(2288,142,0,387,167),(2289,97,0,388,1),(2290,134,0,388,2),(2291,115,0,388,1),(2292,99,0,388,1),(2293,93,0,388,57),(2294,142,0,388,167),(2295,97,0,389,1),(2296,134,0,389,2),(2297,115,0,389,1),(2298,99,0,389,1),(2299,93,0,389,50),(2300,142,0,389,168),(2301,97,0,390,1),(2302,134,0,390,2),(2303,115,0,390,1),(2304,99,0,390,1),(2305,93,0,390,53),(2306,142,0,390,168),(2307,97,0,391,1),(2308,134,0,391,2),(2309,115,0,391,1),(2310,99,0,391,1),(2311,93,0,391,57),(2312,142,0,391,168),(2313,97,0,392,1),(2314,134,0,392,2),(2315,115,0,392,1),(2316,99,0,392,1),(2317,93,0,392,50),(2318,142,0,392,169),(2319,97,0,393,1),(2320,134,0,393,2),(2321,115,0,393,1),(2322,99,0,393,1),(2323,93,0,393,53),(2324,142,0,393,169),(2325,97,0,394,1),(2326,134,0,394,2),(2327,115,0,394,1),(2328,99,0,394,1),(2329,93,0,394,57),(2330,142,0,394,169),(2331,97,0,395,1),(2332,134,0,395,2),(2333,115,0,395,1),(2334,99,0,395,1),(2335,93,0,395,50),(2336,142,0,395,170),(2337,97,0,396,1),(2338,134,0,396,2),(2339,115,0,396,1),(2340,99,0,396,1),(2341,93,0,396,53),(2342,142,0,396,170),(2343,97,0,397,1),(2344,134,0,397,2),(2345,115,0,397,1),(2346,99,0,397,1),(2347,93,0,397,57),(2348,142,0,397,170),(2349,97,0,398,1),(2350,134,0,398,2),(2351,115,0,398,1),(2352,99,0,398,4),(2353,143,0,398,1),(2354,144,0,398,0),(2355,145,0,398,1),(2356,146,0,398,0),(2357,147,0,398,0),(2358,97,0,399,1),(2359,134,0,399,2),(2360,115,0,399,1),(2361,99,0,399,1),(2362,93,0,399,49),(2363,142,0,399,166),(2364,97,0,400,1),(2365,134,0,400,2),(2366,115,0,400,1),(2367,99,0,400,1),(2368,93,0,400,53),(2369,142,0,400,166),(2370,97,0,401,1),(2371,134,0,401,2),(2372,115,0,401,1),(2373,99,0,401,1),(2374,93,0,401,58),(2375,142,0,401,166),(2376,97,0,402,1),(2377,134,0,402,2),(2378,115,0,402,1),(2379,99,0,402,1),(2380,93,0,402,49),(2381,142,0,402,167),(2382,97,0,403,1),(2383,134,0,403,2),(2384,115,0,403,1),(2385,99,0,403,1),(2386,93,0,403,53),(2387,142,0,403,167),(2388,97,0,404,1),(2389,134,0,404,2),(2390,115,0,404,1),(2391,99,0,404,1),(2392,93,0,404,58),(2393,142,0,404,167),(2394,97,0,405,1),(2395,134,0,405,2),(2396,115,0,405,1),(2397,99,0,405,1),(2398,93,0,405,49),(2399,142,0,405,168),(2400,97,0,406,1),(2401,134,0,406,2),(2402,115,0,406,1),(2403,99,0,406,1),(2404,93,0,406,53),(2405,142,0,406,168),(2406,97,0,407,1),(2407,134,0,407,2),(2408,115,0,407,1),(2409,99,0,407,1),(2410,93,0,407,58),(2411,142,0,407,168),(2412,97,0,408,1),(2413,134,0,408,2),(2414,115,0,408,1),(2415,99,0,408,1),(2416,93,0,408,49),(2417,142,0,408,169),(2418,97,0,409,1),(2419,134,0,409,2),(2420,115,0,409,1),(2421,99,0,409,1),(2422,93,0,409,53),(2423,142,0,409,169),(2424,97,0,410,1),(2425,134,0,410,2),(2426,115,0,410,1),(2427,99,0,410,1),(2428,93,0,410,58),(2429,142,0,410,169),(2430,97,0,411,1),(2431,134,0,411,2),(2432,115,0,411,1),(2433,99,0,411,1),(2434,93,0,411,49),(2435,142,0,411,170),(2436,97,0,412,1),(2437,134,0,412,2),(2438,115,0,412,1),(2439,99,0,412,1),(2440,93,0,412,53),(2441,142,0,412,170),(2442,97,0,413,1),(2443,134,0,413,2),(2444,115,0,413,1),(2445,99,0,413,1),(2446,93,0,413,58),(2447,142,0,413,170),(2448,97,0,414,1),(2449,134,0,414,2),(2450,115,0,414,1),(2451,99,0,414,4),(2452,143,0,414,0),(2453,144,0,414,0),(2454,145,0,414,0),(2455,146,0,414,1),(2456,147,0,414,0),(2457,97,0,415,1),(2458,134,0,415,2),(2459,115,0,415,1),(2460,99,0,415,1),(2461,93,0,415,49),(2462,142,0,415,166),(2463,97,0,416,1),(2464,134,0,416,2),(2465,115,0,416,1),(2466,99,0,416,1),(2467,93,0,416,50),(2468,142,0,416,166),(2469,97,0,417,1),(2470,134,0,417,2),(2471,115,0,417,1),(2472,99,0,417,1),(2473,93,0,417,56),(2474,142,0,417,166),(2475,97,0,418,1),(2476,134,0,418,2),(2477,115,0,418,1),(2478,99,0,418,1),(2479,93,0,418,49),(2480,142,0,418,167),(2481,97,0,419,1),(2482,134,0,419,2),(2483,115,0,419,1),(2484,99,0,419,1),(2485,93,0,419,50),(2486,142,0,419,167),(2487,97,0,420,1),(2488,134,0,420,2),(2489,115,0,420,1),(2490,99,0,420,1),(2491,93,0,420,56),(2492,142,0,420,167),(2493,97,0,421,1),(2494,134,0,421,2),(2495,115,0,421,1),(2496,99,0,421,1),(2497,93,0,421,49),(2498,142,0,421,168),(2499,97,0,422,1),(2500,134,0,422,2),(2501,115,0,422,1),(2502,99,0,422,1),(2503,93,0,422,50),(2504,142,0,422,168),(2505,97,0,423,1),(2506,134,0,423,2),(2507,115,0,423,1),(2508,99,0,423,1),(2509,93,0,423,56),(2510,142,0,423,168),(2511,97,0,424,1),(2512,134,0,424,2),(2513,115,0,424,1),(2514,99,0,424,1),(2515,93,0,424,49),(2516,142,0,424,169),(2517,97,0,425,1),(2518,134,0,425,2),(2519,115,0,425,1),(2520,99,0,425,1),(2521,93,0,425,50),(2522,142,0,425,169),(2523,97,0,426,1),(2524,134,0,426,2),(2525,115,0,426,1),(2526,99,0,426,1),(2527,93,0,426,56),(2528,142,0,426,169),(2529,97,0,427,1),(2530,134,0,427,2),(2531,115,0,427,1),(2532,99,0,427,1),(2533,93,0,427,49),(2534,142,0,427,170),(2535,97,0,428,1),(2536,134,0,428,2),(2537,115,0,428,1),(2538,99,0,428,1),(2539,93,0,428,50),(2540,142,0,428,170),(2541,97,0,429,1),(2542,134,0,429,2),(2543,115,0,429,1),(2544,99,0,429,1),(2545,93,0,429,56),(2546,142,0,429,170),(2547,97,0,430,1),(2548,134,0,430,2),(2549,115,0,430,1),(2550,99,0,430,4),(2551,143,0,430,0),(2552,144,0,430,0),(2553,145,0,430,0),(2554,146,0,430,0),(2555,147,0,430,0),(2556,97,0,431,1),(2557,134,0,431,2),(2558,115,0,431,1),(2559,99,0,431,1),(2560,93,0,431,49),(2561,142,0,431,166),(2562,97,0,432,1),(2563,134,0,432,2),(2564,115,0,432,1),(2565,99,0,432,1),(2566,93,0,432,56),(2567,142,0,432,166),(2568,97,0,433,1),(2569,134,0,433,2),(2570,115,0,433,1),(2571,99,0,433,1),(2572,93,0,433,58),(2573,142,0,433,166),(2574,97,0,434,1),(2575,134,0,434,2),(2576,115,0,434,1),(2577,99,0,434,1),(2578,93,0,434,49),(2579,142,0,434,167),(2580,97,0,435,1),(2581,134,0,435,2),(2582,115,0,435,1),(2583,99,0,435,1),(2584,93,0,435,56),(2585,142,0,435,167),(2586,97,0,436,1),(2587,134,0,436,2),(2588,115,0,436,1),(2589,99,0,436,1),(2590,93,0,436,58),(2591,142,0,436,167),(2592,97,0,437,1),(2593,134,0,437,2),(2594,115,0,437,1),(2595,99,0,437,1),(2596,93,0,437,49),(2597,142,0,437,168),(2598,97,0,438,1),(2599,134,0,438,2),(2600,115,0,438,1),(2601,99,0,438,1),(2602,93,0,438,56),(2603,142,0,438,168),(2604,97,0,439,1),(2605,134,0,439,2),(2606,115,0,439,1),(2607,99,0,439,1),(2608,93,0,439,58),(2609,142,0,439,168),(2610,97,0,440,1),(2611,134,0,440,2),(2612,115,0,440,1),(2613,99,0,440,1),(2614,93,0,440,49),(2615,142,0,440,169),(2616,97,0,441,1),(2617,134,0,441,2),(2618,115,0,441,1),(2619,99,0,441,1),(2620,93,0,441,56),(2621,142,0,441,169),(2622,97,0,442,1),(2623,134,0,442,2),(2624,115,0,442,1),(2625,99,0,442,1),(2626,93,0,442,58),(2627,142,0,442,169),(2628,97,0,443,1),(2629,134,0,443,2),(2630,115,0,443,1),(2631,99,0,443,1),(2632,93,0,443,49),(2633,142,0,443,170),(2634,97,0,444,1),(2635,134,0,444,2),(2636,115,0,444,1),(2637,99,0,444,1),(2638,93,0,444,56),(2639,142,0,444,170),(2640,97,0,445,1),(2641,134,0,445,2),(2642,115,0,445,1),(2643,99,0,445,1),(2644,93,0,445,58),(2645,142,0,445,170),(2646,97,0,446,1),(2647,134,0,446,2),(2648,115,0,446,1),(2649,99,0,446,4),(2650,143,0,446,0),(2651,144,0,446,1),(2652,145,0,446,0),(2653,146,0,446,1),(2654,147,0,446,0),(2655,97,0,447,1),(2656,134,0,447,2),(2657,115,0,447,1),(2658,99,0,447,1),(2659,93,0,447,49),(2660,142,0,447,166),(2661,97,0,448,1),(2662,134,0,448,2),(2663,115,0,448,1),(2664,99,0,448,1),(2665,93,0,448,50),(2666,142,0,448,166),(2667,97,0,449,1),(2668,134,0,449,2),(2669,115,0,449,1),(2670,99,0,449,1),(2671,93,0,449,57),(2672,142,0,449,166),(2673,97,0,450,1),(2674,134,0,450,2),(2675,115,0,450,1),(2676,99,0,450,1),(2677,93,0,450,49),(2678,142,0,450,167),(2679,97,0,451,1),(2680,134,0,451,2),(2681,115,0,451,1),(2682,99,0,451,1),(2683,93,0,451,50),(2684,142,0,451,167),(2685,97,0,452,1),(2686,134,0,452,2),(2687,115,0,452,1),(2688,99,0,452,1),(2689,93,0,452,57),(2690,142,0,452,167),(2691,97,0,453,1),(2692,134,0,453,2),(2693,115,0,453,1),(2694,99,0,453,1),(2695,93,0,453,49),(2696,142,0,453,168),(2697,97,0,454,1),(2698,134,0,454,2),(2699,115,0,454,1),(2700,99,0,454,1),(2701,93,0,454,50),(2702,142,0,454,168),(2703,97,0,455,1),(2704,134,0,455,2),(2705,115,0,455,1),(2706,99,0,455,1),(2707,93,0,455,57),(2708,142,0,455,168),(2709,97,0,456,1),(2710,134,0,456,2),(2711,115,0,456,1),(2712,99,0,456,1),(2713,93,0,456,49),(2714,142,0,456,169),(2715,97,0,457,1),(2716,134,0,457,2),(2717,115,0,457,1),(2718,99,0,457,1),(2719,93,0,457,50),(2720,142,0,457,169),(2721,97,0,458,1),(2722,134,0,458,2),(2723,115,0,458,1),(2724,99,0,458,1),(2725,93,0,458,57),(2726,142,0,458,169),(2727,97,0,459,1),(2728,134,0,459,2),(2729,115,0,459,1),(2730,99,0,459,1),(2731,93,0,459,49),(2732,142,0,459,170),(2733,97,0,460,1),(2734,134,0,460,2),(2735,115,0,460,1),(2736,99,0,460,1),(2737,93,0,460,50),(2738,142,0,460,170),(2739,97,0,461,1),(2740,134,0,461,2),(2741,115,0,461,1),(2742,99,0,461,1),(2743,93,0,461,57),(2744,142,0,461,170),(2745,97,0,462,1),(2746,134,0,462,2),(2747,115,0,462,1),(2748,99,0,462,4),(2749,143,0,462,1),(2750,144,0,462,1),(2751,145,0,462,0),(2752,146,0,462,0),(2753,147,0,462,0),(2754,97,0,463,1),(2755,134,0,463,2),(2756,115,0,463,1),(2757,99,0,463,1),(2758,93,0,463,49),(2759,142,0,463,166),(2760,97,0,464,1),(2761,134,0,464,2),(2762,115,0,464,1),(2763,99,0,464,1),(2764,93,0,464,50),(2765,142,0,464,166),(2766,97,0,465,1),(2767,134,0,465,2),(2768,115,0,465,1),(2769,99,0,465,1),(2770,93,0,465,58),(2771,142,0,465,166),(2772,97,0,466,1),(2773,134,0,466,2),(2774,115,0,466,1),(2775,99,0,466,1),(2776,93,0,466,49),(2777,142,0,466,167),(2778,97,0,467,1),(2779,134,0,467,2),(2780,115,0,467,1),(2781,99,0,467,1),(2782,93,0,467,50),(2783,142,0,467,167),(2784,97,0,468,1),(2785,134,0,468,2),(2786,115,0,468,1),(2787,99,0,468,1),(2788,93,0,468,58),(2789,142,0,468,167),(2790,97,0,469,1),(2791,134,0,469,2),(2792,115,0,469,1),(2793,99,0,469,1),(2794,93,0,469,49),(2795,142,0,469,168),(2796,97,0,470,1),(2797,134,0,470,2),(2798,115,0,470,1),(2799,99,0,470,1),(2800,93,0,470,50),(2801,142,0,470,168),(2802,97,0,471,1),(2803,134,0,471,2),(2804,115,0,471,1),(2805,99,0,471,1),(2806,93,0,471,58),(2807,142,0,471,168),(2808,97,0,472,1),(2809,134,0,472,2),(2810,115,0,472,1),(2811,99,0,472,1),(2812,93,0,472,49),(2813,142,0,472,169),(2814,97,0,473,1),(2815,134,0,473,2),(2816,115,0,473,1),(2817,99,0,473,1),(2818,93,0,473,50),(2819,142,0,473,169),(2820,97,0,474,1),(2821,134,0,474,2),(2822,115,0,474,1),(2823,99,0,474,1),(2824,93,0,474,58),(2825,142,0,474,169),(2826,97,0,475,1),(2827,134,0,475,2),(2828,115,0,475,1),(2829,99,0,475,1),(2830,93,0,475,49),(2831,142,0,475,170),(2832,97,0,476,1),(2833,134,0,476,2),(2834,115,0,476,1),(2835,99,0,476,1),(2836,93,0,476,50),(2837,142,0,476,170),(2838,97,0,477,1),(2839,134,0,477,2),(2840,115,0,477,1),(2841,99,0,477,1),(2842,93,0,477,58),(2843,142,0,477,170),(2844,97,0,478,1),(2845,134,0,478,2),(2846,115,0,478,1),(2847,99,0,478,4),(2848,143,0,478,0),(2849,144,0,478,0),(2850,145,0,478,1),(2851,146,0,478,0),(2852,147,0,478,0),(2853,97,0,479,1),(2854,134,0,479,2),(2855,115,0,479,1),(2856,99,0,479,1),(2857,93,0,479,50),(2858,142,0,479,166),(2859,97,0,480,1),(2860,134,0,480,2),(2861,115,0,480,1),(2862,99,0,480,1),(2863,93,0,480,53),(2864,142,0,480,166),(2865,97,0,481,1),(2866,134,0,481,2),(2867,115,0,481,1),(2868,99,0,481,1),(2869,93,0,481,60),(2870,142,0,481,166),(2871,97,0,482,1),(2872,134,0,482,2),(2873,115,0,482,1),(2874,99,0,482,1),(2875,93,0,482,50),(2876,142,0,482,167),(2877,97,0,483,1),(2878,134,0,483,2),(2879,115,0,483,1),(2880,99,0,483,1),(2881,93,0,483,53),(2882,142,0,483,167),(2883,97,0,484,1),(2884,134,0,484,2),(2885,115,0,484,1),(2886,99,0,484,1),(2887,93,0,484,60),(2888,142,0,484,167),(2889,97,0,485,1),(2890,134,0,485,2),(2891,115,0,485,1),(2892,99,0,485,1),(2893,93,0,485,50),(2894,142,0,485,168),(2895,97,0,486,1),(2896,134,0,486,2),(2897,115,0,486,1),(2898,99,0,486,1),(2899,93,0,486,53),(2900,142,0,486,168),(2901,97,0,487,1),(2902,134,0,487,2),(2903,115,0,487,1),(2904,99,0,487,1),(2905,93,0,487,60),(2906,142,0,487,168),(2907,97,0,488,1),(2908,134,0,488,2),(2909,115,0,488,1),(2910,99,0,488,1),(2911,93,0,488,50),(2912,142,0,488,169),(2913,97,0,489,1),(2914,134,0,489,2),(2915,115,0,489,1),(2916,99,0,489,1),(2917,93,0,489,53),(2918,142,0,489,169),(2919,97,0,490,1),(2920,134,0,490,2),(2921,115,0,490,1),(2922,99,0,490,1),(2923,93,0,490,60),(2924,142,0,490,169),(2925,97,0,491,1),(2926,134,0,491,2),(2927,115,0,491,1),(2928,99,0,491,1),(2929,93,0,491,50),(2930,142,0,491,170),(2931,97,0,492,1),(2932,134,0,492,2),(2933,115,0,492,1),(2934,99,0,492,1),(2935,93,0,492,53),(2936,142,0,492,170),(2937,97,0,493,1),(2938,134,0,493,2),(2939,115,0,493,1),(2940,99,0,493,1),(2941,93,0,493,60),(2942,142,0,493,170),(2943,97,0,494,1),(2944,134,0,494,2),(2945,115,0,494,1),(2946,99,0,494,4),(2947,143,0,494,0),(2948,144,0,494,1),(2949,145,0,494,0),(2950,146,0,494,0),(2951,147,0,494,1),(2952,97,0,495,1),(2953,134,0,495,2),(2954,115,0,495,1),(2955,99,0,495,1),(2956,93,0,495,49),(2957,142,0,495,166),(2958,97,0,496,1),(2959,134,0,496,2),(2960,115,0,496,1),(2961,99,0,496,1),(2962,93,0,496,50),(2963,142,0,496,166),(2964,97,0,497,1),(2965,134,0,497,2),(2966,115,0,497,1),(2967,99,0,497,1),(2968,93,0,497,58),(2969,142,0,497,166),(2970,97,0,498,1),(2971,134,0,498,2),(2972,115,0,498,1),(2973,99,0,498,1),(2974,93,0,498,49),(2975,142,0,498,167),(2976,97,0,499,1),(2977,134,0,499,2),(2978,115,0,499,1),(2979,99,0,499,1),(2980,93,0,499,50),(2981,142,0,499,167),(2982,97,0,500,1),(2983,134,0,500,2),(2984,115,0,500,1),(2985,99,0,500,1),(2986,93,0,500,58),(2987,142,0,500,167),(2988,97,0,501,1),(2989,134,0,501,2),(2990,115,0,501,1),(2991,99,0,501,1),(2992,93,0,501,49),(2993,142,0,501,168),(2994,97,0,502,1),(2995,134,0,502,2),(2996,115,0,502,1),(2997,99,0,502,1),(2998,93,0,502,50),(2999,142,0,502,168),(3000,97,0,503,1),(3001,134,0,503,2),(3002,115,0,503,1),(3003,99,0,503,1),(3004,93,0,503,58),(3005,142,0,503,168),(3006,97,0,504,1),(3007,134,0,504,2),(3008,115,0,504,1),(3009,99,0,504,1),(3010,93,0,504,49),(3011,142,0,504,169),(3012,97,0,505,1),(3013,134,0,505,2),(3014,115,0,505,1),(3015,99,0,505,1),(3016,93,0,505,50),(3017,142,0,505,169),(3018,97,0,506,1),(3019,134,0,506,2),(3020,115,0,506,1),(3021,99,0,506,1),(3022,93,0,506,58),(3023,142,0,506,169),(3024,97,0,507,1),(3025,134,0,507,2),(3026,115,0,507,1),(3027,99,0,507,1),(3028,93,0,507,49),(3029,142,0,507,170),(3030,97,0,508,1),(3031,134,0,508,2),(3032,115,0,508,1),(3033,99,0,508,1),(3034,93,0,508,50),(3035,142,0,508,170),(3036,97,0,509,1),(3037,134,0,509,2),(3038,115,0,509,1),(3039,99,0,509,1),(3040,93,0,509,58),(3041,142,0,509,170),(3042,97,0,510,1),(3043,134,0,510,2),(3044,115,0,510,1),(3045,99,0,510,4),(3046,143,0,510,0),(3047,144,0,510,0),(3048,145,0,510,0),(3049,146,0,510,1),(3050,147,0,510,0),(3051,97,0,511,1),(3052,134,0,511,2),(3053,115,0,511,1),(3054,99,0,511,1),(3055,93,0,511,52),(3056,142,0,511,166),(3057,97,0,512,1),(3058,134,0,512,2),(3059,115,0,512,1),(3060,99,0,512,1),(3061,93,0,512,53),(3062,142,0,512,166),(3063,97,0,513,1),(3064,134,0,513,2),(3065,115,0,513,1),(3066,99,0,513,1),(3067,93,0,513,56),(3068,142,0,513,166),(3069,97,0,514,1),(3070,134,0,514,2),(3071,115,0,514,1),(3072,99,0,514,1),(3073,93,0,514,52),(3074,142,0,514,167),(3075,97,0,515,1),(3076,134,0,515,2),(3077,115,0,515,1),(3078,99,0,515,1),(3079,93,0,515,53),(3080,142,0,515,167),(3081,97,0,516,1),(3082,134,0,516,2),(3083,115,0,516,1),(3084,99,0,516,1),(3085,93,0,516,56),(3086,142,0,516,167),(3087,97,0,517,1),(3088,134,0,517,2),(3089,115,0,517,1),(3090,99,0,517,1),(3091,93,0,517,52),(3092,142,0,517,168),(3093,97,0,518,1),(3094,134,0,518,2),(3095,115,0,518,1),(3096,99,0,518,1),(3097,93,0,518,53),(3098,142,0,518,168),(3099,97,0,519,1),(3100,134,0,519,2),(3101,115,0,519,1),(3102,99,0,519,1),(3103,93,0,519,56),(3104,142,0,519,168),(3105,97,0,520,1),(3106,134,0,520,2),(3107,115,0,520,1),(3108,99,0,520,1),(3109,93,0,520,52),(3110,142,0,520,169),(3111,97,0,521,1),(3112,134,0,521,2),(3113,115,0,521,1),(3114,99,0,521,1),(3115,93,0,521,53),(3116,142,0,521,169),(3117,97,0,522,1),(3118,134,0,522,2),(3119,115,0,522,1),(3120,99,0,522,1),(3121,93,0,522,56),(3122,142,0,522,169),(3123,97,0,523,1),(3124,134,0,523,2),(3125,115,0,523,1),(3126,99,0,523,1),(3127,93,0,523,52),(3128,142,0,523,170),(3129,97,0,524,1),(3130,134,0,524,2),(3131,115,0,524,1),(3132,99,0,524,1),(3133,93,0,524,53),(3134,142,0,524,170),(3135,97,0,525,1),(3136,134,0,525,2),(3137,115,0,525,1),(3138,99,0,525,1),(3139,93,0,525,56),(3140,142,0,525,170),(3141,97,0,526,1),(3142,134,0,526,2),(3143,115,0,526,1),(3144,99,0,526,4),(3145,143,0,526,0),(3146,144,0,526,1),(3147,145,0,526,1),(3148,146,0,526,0),(3149,147,0,526,0),(3150,97,0,527,1),(3151,134,0,527,2),(3152,115,0,527,1),(3153,99,0,527,1),(3154,93,0,527,50),(3155,142,0,527,166),(3156,97,0,528,1),(3157,134,0,528,2),(3158,115,0,528,1),(3159,99,0,528,1),(3160,93,0,528,53),(3161,142,0,528,166),(3162,97,0,529,1),(3163,134,0,529,2),(3164,115,0,529,1),(3165,99,0,529,1),(3166,93,0,529,60),(3167,142,0,529,166),(3168,97,0,530,1),(3169,134,0,530,2),(3170,115,0,530,1),(3171,99,0,530,1),(3172,93,0,530,50),(3173,142,0,530,167),(3174,97,0,531,1),(3175,134,0,531,2),(3176,115,0,531,1),(3177,99,0,531,1),(3178,93,0,531,53),(3179,142,0,531,167),(3180,97,0,532,1),(3181,134,0,532,2),(3182,115,0,532,1),(3183,99,0,532,1),(3184,93,0,532,60),(3185,142,0,532,167),(3186,97,0,533,1),(3187,134,0,533,2),(3188,115,0,533,1),(3189,99,0,533,1),(3190,93,0,533,50),(3191,142,0,533,168),(3192,97,0,534,1),(3193,134,0,534,2),(3194,115,0,534,1),(3195,99,0,534,1),(3196,93,0,534,53),(3197,142,0,534,168),(3198,97,0,535,1),(3199,134,0,535,2),(3200,115,0,535,1),(3201,99,0,535,1),(3202,93,0,535,60),(3203,142,0,535,168),(3204,97,0,536,1),(3205,134,0,536,2),(3206,115,0,536,1),(3207,99,0,536,1),(3208,93,0,536,50),(3209,142,0,536,169),(3210,97,0,537,1),(3211,134,0,537,2),(3212,115,0,537,1),(3213,99,0,537,1),(3214,93,0,537,53),(3215,142,0,537,169),(3216,97,0,538,1),(3217,134,0,538,2),(3218,115,0,538,1),(3219,99,0,538,1),(3220,93,0,538,60),(3221,142,0,538,169),(3222,97,0,539,1),(3223,134,0,539,2),(3224,115,0,539,1),(3225,99,0,539,1),(3226,93,0,539,50),(3227,142,0,539,170),(3228,97,0,540,1),(3229,134,0,540,2),(3230,115,0,540,1),(3231,99,0,540,1),(3232,93,0,540,53),(3233,142,0,540,170),(3234,97,0,541,1),(3235,134,0,541,2),(3236,115,0,541,1),(3237,99,0,541,1),(3238,93,0,541,60),(3239,142,0,541,170),(3240,97,0,542,1),(3241,134,0,542,2),(3242,115,0,542,1),(3243,99,0,542,4),(3244,143,0,542,0),(3245,144,0,542,0),(3246,145,0,542,0),(3247,146,0,542,1),(3248,147,0,542,0),(3249,97,0,543,1),(3250,134,0,543,2),(3251,115,0,543,1),(3252,99,0,543,1),(3253,93,0,543,49),(3254,142,0,543,166),(3255,97,0,544,1),(3256,134,0,544,2),(3257,115,0,544,1),(3258,99,0,544,1),(3259,93,0,544,51),(3260,142,0,544,166),(3261,97,0,545,1),(3262,134,0,545,2),(3263,115,0,545,1),(3264,99,0,545,1),(3265,93,0,545,60),(3266,142,0,545,166),(3267,97,0,546,1),(3268,134,0,546,2),(3269,115,0,546,1),(3270,99,0,546,1),(3271,93,0,546,49),(3272,142,0,546,167),(3273,97,0,547,1),(3274,134,0,547,2),(3275,115,0,547,1),(3276,99,0,547,1),(3277,93,0,547,51),(3278,142,0,547,167),(3279,97,0,548,1),(3280,134,0,548,2),(3281,115,0,548,1),(3282,99,0,548,1),(3283,93,0,548,60),(3284,142,0,548,167),(3285,97,0,549,1),(3286,134,0,549,2),(3287,115,0,549,1),(3288,99,0,549,1),(3289,93,0,549,49),(3290,142,0,549,168),(3291,97,0,550,1),(3292,134,0,550,2),(3293,115,0,550,1),(3294,99,0,550,1),(3295,93,0,550,51),(3296,142,0,550,168),(3297,97,0,551,1),(3298,134,0,551,2),(3299,115,0,551,1),(3300,99,0,551,1),(3301,93,0,551,60),(3302,142,0,551,168),(3303,97,0,552,1),(3304,134,0,552,2),(3305,115,0,552,1),(3306,99,0,552,1),(3307,93,0,552,49),(3308,142,0,552,169),(3309,97,0,553,1),(3310,134,0,553,2),(3311,115,0,553,1),(3312,99,0,553,1),(3313,93,0,553,51),(3314,142,0,553,169),(3315,97,0,554,1),(3316,134,0,554,2),(3317,115,0,554,1),(3318,99,0,554,1),(3319,93,0,554,60),(3320,142,0,554,169),(3321,97,0,555,1),(3322,134,0,555,2),(3323,115,0,555,1),(3324,99,0,555,1),(3325,93,0,555,49),(3326,142,0,555,170),(3327,97,0,556,1),(3328,134,0,556,2),(3329,115,0,556,1),(3330,99,0,556,1),(3331,93,0,556,51),(3332,142,0,556,170),(3333,97,0,557,1),(3334,134,0,557,2),(3335,115,0,557,1),(3336,99,0,557,1),(3337,93,0,557,60),(3338,142,0,557,170),(3339,97,0,558,1),(3340,134,0,558,2),(3341,115,0,558,1),(3342,99,0,558,4),(3343,143,0,558,0),(3344,144,0,558,0),(3345,145,0,558,0),(3346,146,0,558,0),(3347,147,0,558,0),(3348,97,0,559,1),(3349,134,0,559,2),(3350,115,0,559,1),(3351,99,0,559,1),(3352,93,0,559,49),(3353,142,0,559,166),(3354,97,0,560,1),(3355,134,0,560,2),(3356,115,0,560,1),(3357,99,0,560,1),(3358,93,0,560,50),(3359,142,0,560,166),(3360,97,0,561,1),(3361,134,0,561,2),(3362,115,0,561,1),(3363,99,0,561,1),(3364,93,0,561,52),(3365,142,0,561,166),(3366,97,0,562,1),(3367,134,0,562,2),(3368,115,0,562,1),(3369,99,0,562,1),(3370,93,0,562,49),(3371,142,0,562,167),(3372,97,0,563,1),(3373,134,0,563,2),(3374,115,0,563,1),(3375,99,0,563,1),(3376,93,0,563,50),(3377,142,0,563,167),(3378,97,0,564,1),(3379,134,0,564,2),(3380,115,0,564,1),(3381,99,0,564,1),(3382,93,0,564,52),(3383,142,0,564,167),(3384,97,0,565,1),(3385,134,0,565,2),(3386,115,0,565,1),(3387,99,0,565,1),(3388,93,0,565,49),(3389,142,0,565,168),(3390,97,0,566,1),(3391,134,0,566,2),(3392,115,0,566,1),(3393,99,0,566,1),(3394,93,0,566,50),(3395,142,0,566,168),(3396,97,0,567,1),(3397,134,0,567,2),(3398,115,0,567,1),(3399,99,0,567,1),(3400,93,0,567,52),(3401,142,0,567,168),(3402,97,0,568,1),(3403,134,0,568,2),(3404,115,0,568,1),(3405,99,0,568,1),(3406,93,0,568,49),(3407,142,0,568,169),(3408,97,0,569,1),(3409,134,0,569,2),(3410,115,0,569,1),(3411,99,0,569,1),(3412,93,0,569,50),(3413,142,0,569,169),(3414,97,0,570,1),(3415,134,0,570,2),(3416,115,0,570,1),(3417,99,0,570,1),(3418,93,0,570,52),(3419,142,0,570,169),(3420,97,0,571,1),(3421,134,0,571,2),(3422,115,0,571,1),(3423,99,0,571,1),(3424,93,0,571,49),(3425,142,0,571,170),(3426,97,0,572,1),(3427,134,0,572,2),(3428,115,0,572,1),(3429,99,0,572,1),(3430,93,0,572,50),(3431,142,0,572,170),(3432,97,0,573,1),(3433,134,0,573,2),(3434,115,0,573,1),(3435,99,0,573,1),(3436,93,0,573,52),(3437,142,0,573,170),(3438,97,0,574,1),(3439,134,0,574,2),(3440,115,0,574,1),(3441,99,0,574,4),(3442,143,0,574,0),(3443,144,0,574,0),(3444,145,0,574,0),(3445,146,0,574,0),(3446,147,0,574,1),(3447,97,0,575,1),(3448,134,0,575,2),(3449,115,0,575,1),(3450,99,0,575,1),(3451,93,0,575,49),(3452,142,0,575,166),(3453,97,0,576,1),(3454,134,0,576,2),(3455,115,0,576,1),(3456,99,0,576,1),(3457,93,0,576,50),(3458,142,0,576,166),(3459,97,0,577,1),(3460,134,0,577,2),(3461,115,0,577,1),(3462,99,0,577,1),(3463,93,0,577,58),(3464,142,0,577,166),(3465,97,0,578,1),(3466,134,0,578,2),(3467,115,0,578,1),(3468,99,0,578,1),(3469,93,0,578,49),(3470,142,0,578,167),(3471,97,0,579,1),(3472,134,0,579,2),(3473,115,0,579,1),(3474,99,0,579,1),(3475,93,0,579,50),(3476,142,0,579,167),(3477,97,0,580,1),(3478,134,0,580,2),(3479,115,0,580,1),(3480,99,0,580,1),(3481,93,0,580,58),(3482,142,0,580,167),(3483,97,0,581,1),(3484,134,0,581,2),(3485,115,0,581,1),(3486,99,0,581,1),(3487,93,0,581,49),(3488,142,0,581,168),(3489,97,0,582,1),(3490,134,0,582,2),(3491,115,0,582,1),(3492,99,0,582,1),(3493,93,0,582,50),(3494,142,0,582,168),(3495,97,0,583,1),(3496,134,0,583,2),(3497,115,0,583,1),(3498,99,0,583,1),(3499,93,0,583,58),(3500,142,0,583,168),(3501,97,0,584,1),(3502,134,0,584,2),(3503,115,0,584,1),(3504,99,0,584,1),(3505,93,0,584,49),(3506,142,0,584,169),(3507,97,0,585,1),(3508,134,0,585,2),(3509,115,0,585,1),(3510,99,0,585,1),(3511,93,0,585,50),(3512,142,0,585,169),(3513,97,0,586,1),(3514,134,0,586,2),(3515,115,0,586,1),(3516,99,0,586,1),(3517,93,0,586,58),(3518,142,0,586,169),(3519,97,0,587,1),(3520,134,0,587,2),(3521,115,0,587,1),(3522,99,0,587,1),(3523,93,0,587,49),(3524,142,0,587,170),(3525,97,0,588,1),(3526,134,0,588,2),(3527,115,0,588,1),(3528,99,0,588,1),(3529,93,0,588,50),(3530,142,0,588,170),(3531,97,0,589,1),(3532,134,0,589,2),(3533,115,0,589,1),(3534,99,0,589,1),(3535,93,0,589,58),(3536,142,0,589,170),(3537,97,0,590,1),(3538,134,0,590,2),(3539,115,0,590,1),(3540,99,0,590,4),(3541,143,0,590,0),(3542,144,0,590,0),(3543,145,0,590,0),(3544,146,0,590,0),(3545,147,0,590,0),(3546,97,0,591,1),(3547,134,0,591,2),(3548,115,0,591,1),(3549,99,0,591,1),(3550,93,0,591,49),(3551,142,0,591,166),(3552,97,0,592,1),(3553,134,0,592,2),(3554,115,0,592,1),(3555,99,0,592,1),(3556,93,0,592,53),(3557,142,0,592,166),(3558,97,0,593,1),(3559,134,0,593,2),(3560,115,0,593,1),(3561,99,0,593,1),(3562,93,0,593,59),(3563,142,0,593,166),(3564,97,0,594,1),(3565,134,0,594,2),(3566,115,0,594,1),(3567,99,0,594,1),(3568,93,0,594,49),(3569,142,0,594,167),(3570,97,0,595,1),(3571,134,0,595,2),(3572,115,0,595,1),(3573,99,0,595,1),(3574,93,0,595,53),(3575,142,0,595,167),(3576,97,0,596,1),(3577,134,0,596,2),(3578,115,0,596,1),(3579,99,0,596,1),(3580,93,0,596,59),(3581,142,0,596,167),(3582,97,0,597,1),(3583,134,0,597,2),(3584,115,0,597,1),(3585,99,0,597,1),(3586,93,0,597,49),(3587,142,0,597,168),(3588,97,0,598,1),(3589,134,0,598,2),(3590,115,0,598,1),(3591,99,0,598,1),(3592,93,0,598,53),(3593,142,0,598,168),(3594,97,0,599,1),(3595,134,0,599,2),(3596,115,0,599,1),(3597,99,0,599,1),(3598,93,0,599,59),(3599,142,0,599,168),(3600,97,0,600,1),(3601,134,0,600,2),(3602,115,0,600,1),(3603,99,0,600,1),(3604,93,0,600,49),(3605,142,0,600,169),(3606,97,0,601,1),(3607,134,0,601,2),(3608,115,0,601,1),(3609,99,0,601,1),(3610,93,0,601,53),(3611,142,0,601,169),(3612,97,0,602,1),(3613,134,0,602,2),(3614,115,0,602,1),(3615,99,0,602,1),(3616,93,0,602,59),(3617,142,0,602,169),(3618,97,0,603,1),(3619,134,0,603,2),(3620,115,0,603,1),(3621,99,0,603,1),(3622,93,0,603,49),(3623,142,0,603,170),(3624,97,0,604,1),(3625,134,0,604,2),(3626,115,0,604,1),(3627,99,0,604,1),(3628,93,0,604,53),(3629,142,0,604,170),(3630,97,0,605,1),(3631,134,0,605,2),(3632,115,0,605,1),(3633,99,0,605,1),(3634,93,0,605,59),(3635,142,0,605,170),(3636,97,0,606,1),(3637,134,0,606,2),(3638,115,0,606,1),(3639,99,0,606,4),(3640,143,0,606,0),(3641,144,0,606,0),(3642,145,0,606,0),(3643,146,0,606,0),(3644,147,0,606,0),(3645,97,0,607,1),(3646,134,0,607,2),(3647,115,0,607,1),(3648,99,0,607,1),(3649,93,0,607,49),(3650,142,0,607,166),(3651,97,0,608,1),(3652,134,0,608,2),(3653,115,0,608,1),(3654,99,0,608,1),(3655,93,0,608,50),(3656,142,0,608,166),(3657,97,0,609,1),(3658,134,0,609,2),(3659,115,0,609,1),(3660,99,0,609,1),(3661,93,0,609,58),(3662,142,0,609,166),(3663,97,0,610,1),(3664,134,0,610,2),(3665,115,0,610,1),(3666,99,0,610,1),(3667,93,0,610,49),(3668,142,0,610,167),(3669,97,0,611,1),(3670,134,0,611,2),(3671,115,0,611,1),(3672,99,0,611,1),(3673,93,0,611,50),(3674,142,0,611,167),(3675,97,0,612,1),(3676,134,0,612,2),(3677,115,0,612,1),(3678,99,0,612,1),(3679,93,0,612,58),(3680,142,0,612,167),(3681,97,0,613,1),(3682,134,0,613,2),(3683,115,0,613,1),(3684,99,0,613,1),(3685,93,0,613,49),(3686,142,0,613,168),(3687,97,0,614,1),(3688,134,0,614,2),(3689,115,0,614,1),(3690,99,0,614,1),(3691,93,0,614,50),(3692,142,0,614,168),(3693,97,0,615,1),(3694,134,0,615,2),(3695,115,0,615,1),(3696,99,0,615,1),(3697,93,0,615,58),(3698,142,0,615,168),(3699,97,0,616,1),(3700,134,0,616,2),(3701,115,0,616,1),(3702,99,0,616,1),(3703,93,0,616,49),(3704,142,0,616,169),(3705,97,0,617,1),(3706,134,0,617,2),(3707,115,0,617,1),(3708,99,0,617,1),(3709,93,0,617,50),(3710,142,0,617,169),(3711,97,0,618,1),(3712,134,0,618,2),(3713,115,0,618,1),(3714,99,0,618,1),(3715,93,0,618,58),(3716,142,0,618,169),(3717,97,0,619,1),(3718,134,0,619,2),(3719,115,0,619,1),(3720,99,0,619,1),(3721,93,0,619,49),(3722,142,0,619,170),(3723,97,0,620,1),(3724,134,0,620,2),(3725,115,0,620,1),(3726,99,0,620,1),(3727,93,0,620,50),(3728,142,0,620,170),(3729,97,0,621,1),(3730,134,0,621,2),(3731,115,0,621,1),(3732,99,0,621,1),(3733,93,0,621,58),(3734,142,0,621,170),(3735,97,0,622,1),(3736,134,0,622,2),(3737,115,0,622,1),(3738,99,0,622,4),(3739,143,0,622,0),(3740,144,0,622,0),(3741,145,0,622,1),(3742,146,0,622,1),(3743,147,0,622,0),(3744,97,0,623,1),(3745,134,0,623,2),(3746,115,0,623,1),(3747,99,0,623,1),(3748,93,0,623,52),(3749,142,0,623,166),(3750,97,0,624,1),(3751,134,0,624,2),(3752,115,0,624,1),(3753,99,0,624,1),(3754,93,0,624,56),(3755,142,0,624,166),(3756,97,0,625,1),(3757,134,0,625,2),(3758,115,0,625,1),(3759,99,0,625,1),(3760,93,0,625,58),(3761,142,0,625,166),(3762,97,0,626,1),(3763,134,0,626,2),(3764,115,0,626,1),(3765,99,0,626,1),(3766,93,0,626,52),(3767,142,0,626,167),(3768,97,0,627,1),(3769,134,0,627,2),(3770,115,0,627,1),(3771,99,0,627,1),(3772,93,0,627,56),(3773,142,0,627,167),(3774,97,0,628,1),(3775,134,0,628,2),(3776,115,0,628,1),(3777,99,0,628,1),(3778,93,0,628,58),(3779,142,0,628,167),(3780,97,0,629,1),(3781,134,0,629,2),(3782,115,0,629,1),(3783,99,0,629,1),(3784,93,0,629,52),(3785,142,0,629,168),(3786,97,0,630,1),(3787,134,0,630,2),(3788,115,0,630,1),(3789,99,0,630,1),(3790,93,0,630,56),(3791,142,0,630,168),(3792,97,0,631,1),(3793,134,0,631,2),(3794,115,0,631,1),(3795,99,0,631,1),(3796,93,0,631,58),(3797,142,0,631,168),(3798,97,0,632,1),(3799,134,0,632,2),(3800,115,0,632,1),(3801,99,0,632,1),(3802,93,0,632,52),(3803,142,0,632,169),(3804,97,0,633,1),(3805,134,0,633,2),(3806,115,0,633,1),(3807,99,0,633,1),(3808,93,0,633,56),(3809,142,0,633,169),(3810,97,0,634,1),(3811,134,0,634,2),(3812,115,0,634,1),(3813,99,0,634,1),(3814,93,0,634,58),(3815,142,0,634,169),(3816,97,0,635,1),(3817,134,0,635,2),(3818,115,0,635,1),(3819,99,0,635,1),(3820,93,0,635,52),(3821,142,0,635,170),(3822,97,0,636,1),(3823,134,0,636,2),(3824,115,0,636,1),(3825,99,0,636,1),(3826,93,0,636,56),(3827,142,0,636,170),(3828,97,0,637,1),(3829,134,0,637,2),(3830,115,0,637,1),(3831,99,0,637,1),(3832,93,0,637,58),(3833,142,0,637,170),(3834,97,0,638,1),(3835,134,0,638,2),(3836,115,0,638,1),(3837,99,0,638,4),(3838,143,0,638,0),(3839,144,0,638,0),(3840,145,0,638,0),(3841,146,0,638,0),(3842,147,0,638,0),(3843,97,0,639,1),(3844,134,0,639,2),(3845,115,0,639,1),(3846,99,0,639,1),(3847,93,0,639,52),(3848,142,0,639,166),(3849,97,0,640,1),(3850,134,0,640,2),(3851,115,0,640,1),(3852,99,0,640,1),(3853,93,0,640,58),(3854,142,0,640,166),(3855,97,0,641,1),(3856,134,0,641,2),(3857,115,0,641,1),(3858,99,0,641,1),(3859,93,0,641,59),(3860,142,0,641,166),(3861,97,0,642,1),(3862,134,0,642,2),(3863,115,0,642,1),(3864,99,0,642,1),(3865,93,0,642,52),(3866,142,0,642,167),(3867,97,0,643,1),(3868,134,0,643,2),(3869,115,0,643,1),(3870,99,0,643,1),(3871,93,0,643,58),(3872,142,0,643,167),(3873,97,0,644,1),(3874,134,0,644,2),(3875,115,0,644,1),(3876,99,0,644,1),(3877,93,0,644,59),(3878,142,0,644,167),(3879,97,0,645,1),(3880,134,0,645,2),(3881,115,0,645,1),(3882,99,0,645,1),(3883,93,0,645,52),(3884,142,0,645,168),(3885,97,0,646,1),(3886,134,0,646,2),(3887,115,0,646,1),(3888,99,0,646,1),(3889,93,0,646,58),(3890,142,0,646,168),(3891,97,0,647,1),(3892,134,0,647,2),(3893,115,0,647,1),(3894,99,0,647,1),(3895,93,0,647,59),(3896,142,0,647,168),(3897,97,0,648,1),(3898,134,0,648,2),(3899,115,0,648,1),(3900,99,0,648,1),(3901,93,0,648,52),(3902,142,0,648,169),(3903,97,0,649,1),(3904,134,0,649,2),(3905,115,0,649,1),(3906,99,0,649,1),(3907,93,0,649,58),(3908,142,0,649,169),(3909,97,0,650,1),(3910,134,0,650,2),(3911,115,0,650,1),(3912,99,0,650,1),(3913,93,0,650,59),(3914,142,0,650,169),(3915,97,0,651,1),(3916,134,0,651,2),(3917,115,0,651,1),(3918,99,0,651,1),(3919,93,0,651,52),(3920,142,0,651,170),(3921,97,0,652,1),(3922,134,0,652,2),(3923,115,0,652,1),(3924,99,0,652,1),(3925,93,0,652,58),(3926,142,0,652,170),(3927,97,0,653,1),(3928,134,0,653,2),(3929,115,0,653,1),(3930,99,0,653,1),(3931,93,0,653,59),(3932,142,0,653,170),(3933,97,0,654,1),(3934,134,0,654,2),(3935,115,0,654,1),(3936,99,0,654,4),(3937,143,0,654,0),(3938,144,0,654,0),(3939,145,0,654,0),(3940,146,0,654,0),(3941,147,0,654,0),(3942,97,0,655,1),(3943,134,0,655,2),(3944,115,0,655,1),(3945,99,0,655,1),(3946,93,0,655,50),(3947,142,0,655,166),(3948,97,0,656,1),(3949,134,0,656,2),(3950,115,0,656,1),(3951,99,0,656,1),(3952,93,0,656,58),(3953,142,0,656,166),(3954,97,0,657,1),(3955,134,0,657,2),(3956,115,0,657,1),(3957,99,0,657,1),(3958,93,0,657,60),(3959,142,0,657,166),(3960,97,0,658,1),(3961,134,0,658,2),(3962,115,0,658,1),(3963,99,0,658,1),(3964,93,0,658,50),(3965,142,0,658,167),(3966,97,0,659,1),(3967,134,0,659,2),(3968,115,0,659,1),(3969,99,0,659,1),(3970,93,0,659,58),(3971,142,0,659,167),(3972,97,0,660,1),(3973,134,0,660,2),(3974,115,0,660,1),(3975,99,0,660,1),(3976,93,0,660,60),(3977,142,0,660,167),(3978,97,0,661,1),(3979,134,0,661,2),(3980,115,0,661,1),(3981,99,0,661,1),(3982,93,0,661,50),(3983,142,0,661,168),(3984,97,0,662,1),(3985,134,0,662,2),(3986,115,0,662,1),(3987,99,0,662,1),(3988,93,0,662,58),(3989,142,0,662,168),(3990,97,0,663,1),(3991,134,0,663,2),(3992,115,0,663,1),(3993,99,0,663,1),(3994,93,0,663,60),(3995,142,0,663,168),(3996,97,0,664,1),(3997,134,0,664,2),(3998,115,0,664,1),(3999,99,0,664,1),(4000,93,0,664,50),(4001,142,0,664,169),(4002,97,0,665,1),(4003,134,0,665,2),(4004,115,0,665,1),(4005,99,0,665,1),(4006,93,0,665,58),(4007,142,0,665,169),(4008,97,0,666,1),(4009,134,0,666,2),(4010,115,0,666,1),(4011,99,0,666,1),(4012,93,0,666,60),(4013,142,0,666,169),(4014,97,0,667,1),(4015,134,0,667,2),(4016,115,0,667,1),(4017,99,0,667,1),(4018,93,0,667,50),(4019,142,0,667,170),(4020,97,0,668,1),(4021,134,0,668,2),(4022,115,0,668,1),(4023,99,0,668,1),(4024,93,0,668,58),(4025,142,0,668,170),(4026,97,0,669,1),(4027,134,0,669,2),(4028,115,0,669,1),(4029,99,0,669,1),(4030,93,0,669,60),(4031,142,0,669,170),(4032,97,0,670,1),(4033,134,0,670,2),(4034,115,0,670,1),(4035,99,0,670,4),(4036,143,0,670,0),(4037,144,0,670,0),(4038,145,0,670,0),(4039,146,0,670,0),(4040,147,0,670,0),(4041,97,0,671,1),(4042,134,0,671,2),(4043,115,0,671,1),(4044,99,0,671,1),(4045,93,0,671,50),(4046,142,0,671,166),(4047,97,0,672,1),(4048,134,0,672,2),(4049,115,0,672,1),(4050,99,0,672,1),(4051,93,0,672,50),(4052,142,0,672,167),(4053,97,0,673,1),(4054,134,0,673,2),(4055,115,0,673,1),(4056,99,0,673,1),(4057,93,0,673,50),(4058,142,0,673,168),(4059,97,0,674,1),(4060,134,0,674,2),(4061,115,0,674,1),(4062,99,0,674,1),(4063,93,0,674,50),(4064,142,0,674,169),(4065,97,0,675,1),(4066,134,0,675,2),(4067,115,0,675,1),(4068,99,0,675,1),(4069,93,0,675,50),(4070,142,0,675,170),(4071,97,0,676,1),(4072,134,0,676,2),(4073,115,0,676,1),(4074,99,0,676,4),(4075,143,0,676,0),(4076,144,0,676,1),(4077,145,0,676,1),(4078,146,0,676,1),(4079,147,0,676,0),(4080,97,0,677,1),(4081,134,0,677,2),(4082,115,0,677,1),(4083,99,0,677,1),(4084,93,0,677,50),(4085,142,0,677,166),(4086,97,0,678,1),(4087,134,0,678,2),(4088,115,0,678,1),(4089,99,0,678,1),(4090,93,0,678,50),(4091,142,0,678,167),(4092,97,0,679,1),(4093,134,0,679,2),(4094,115,0,679,1),(4095,99,0,679,1),(4096,93,0,679,50),(4097,142,0,679,168),(4098,97,0,680,1),(4099,134,0,680,2),(4100,115,0,680,1),(4101,99,0,680,1),(4102,93,0,680,50),(4103,142,0,680,169),(4104,97,0,681,1),(4105,134,0,681,2),(4106,115,0,681,1),(4107,99,0,681,1),(4108,93,0,681,50),(4109,142,0,681,170),(4110,97,0,682,1),(4111,134,0,682,2),(4112,115,0,682,1),(4113,99,0,682,4),(4114,143,0,682,0),(4115,144,0,682,1),(4116,145,0,682,0),(4117,146,0,682,0),(4118,147,0,682,0),(4119,97,0,683,1),(4120,134,0,683,2),(4121,115,0,683,1),(4122,99,0,683,1),(4123,93,0,683,49),(4124,142,0,683,166),(4125,97,0,684,1),(4126,134,0,684,2),(4127,115,0,684,1),(4128,99,0,684,1),(4129,93,0,684,49),(4130,142,0,684,167),(4131,97,0,685,1),(4132,134,0,685,2),(4133,115,0,685,1),(4134,99,0,685,1),(4135,93,0,685,49),(4136,142,0,685,168),(4137,97,0,686,1),(4138,134,0,686,2),(4139,115,0,686,1),(4140,99,0,686,1),(4141,93,0,686,49),(4142,142,0,686,169),(4143,97,0,687,1),(4144,134,0,687,2),(4145,115,0,687,1),(4146,99,0,687,1),(4147,93,0,687,49),(4148,142,0,687,170),(4149,97,0,688,1),(4150,134,0,688,2),(4151,115,0,688,1),(4152,99,0,688,4),(4153,143,0,688,0),(4154,144,0,688,1),(4155,145,0,688,0),(4156,146,0,688,0),(4157,147,0,688,0),(4158,97,0,689,1),(4159,134,0,689,2),(4160,115,0,689,1),(4161,99,0,689,1),(4162,93,0,689,52),(4163,142,0,689,166),(4164,97,0,690,1),(4165,134,0,690,2),(4166,115,0,690,1),(4167,99,0,690,1),(4168,93,0,690,52),(4169,142,0,690,167),(4170,97,0,691,1),(4171,134,0,691,2),(4172,115,0,691,1),(4173,99,0,691,1),(4174,93,0,691,52),(4175,142,0,691,168),(4176,97,0,692,1),(4177,134,0,692,2),(4178,115,0,692,1),(4179,99,0,692,1),(4180,93,0,692,52),(4181,142,0,692,169),(4182,97,0,693,1),(4183,134,0,693,2),(4184,115,0,693,1),(4185,99,0,693,1),(4186,93,0,693,52),(4187,142,0,693,170),(4188,97,0,694,1),(4189,134,0,694,2),(4190,115,0,694,1),(4191,99,0,694,4),(4192,143,0,694,1),(4193,144,0,694,0),(4194,145,0,694,0),(4195,146,0,694,0),(4196,147,0,694,0),(4197,97,0,695,1),(4198,134,0,695,2),(4199,115,0,695,1),(4200,99,0,695,1),(4201,93,0,695,53),(4202,142,0,695,166),(4203,97,0,696,1),(4204,134,0,696,2),(4205,115,0,696,1),(4206,99,0,696,1),(4207,93,0,696,53),(4208,142,0,696,167),(4209,97,0,697,1),(4210,134,0,697,2),(4211,115,0,697,1),(4212,99,0,697,1),(4213,93,0,697,53),(4214,142,0,697,168),(4215,97,0,698,1),(4216,134,0,698,2),(4217,115,0,698,1),(4218,99,0,698,1),(4219,93,0,698,53),(4220,142,0,698,169),(4221,97,0,699,1),(4222,134,0,699,2),(4223,115,0,699,1),(4224,99,0,699,1),(4225,93,0,699,53),(4226,142,0,699,170),(4227,97,0,700,1),(4228,134,0,700,2),(4229,115,0,700,1),(4230,99,0,700,4),(4231,143,0,700,0),(4232,144,0,700,0),(4233,145,0,700,1),(4234,146,0,700,1),(4235,147,0,700,0),(4236,97,0,701,1),(4237,134,0,701,2),(4238,115,0,701,1),(4239,99,0,701,1),(4240,93,0,701,50),(4241,142,0,701,166),(4242,97,0,702,1),(4243,134,0,702,2),(4244,115,0,702,1),(4245,99,0,702,1),(4246,93,0,702,50),(4247,142,0,702,167),(4248,97,0,703,1),(4249,134,0,703,2),(4250,115,0,703,1),(4251,99,0,703,1),(4252,93,0,703,50),(4253,142,0,703,168),(4254,97,0,704,1),(4255,134,0,704,2),(4256,115,0,704,1),(4257,99,0,704,1),(4258,93,0,704,50),(4259,142,0,704,169),(4260,97,0,705,1),(4261,134,0,705,2),(4262,115,0,705,1),(4263,99,0,705,1),(4264,93,0,705,50),(4265,142,0,705,170),(4266,97,0,706,1),(4267,134,0,706,2),(4268,115,0,706,1),(4269,99,0,706,4),(4270,143,0,706,0),(4271,144,0,706,0),(4272,145,0,706,0),(4273,146,0,706,1),(4274,147,0,706,0),(4275,97,0,707,1),(4276,134,0,707,2),(4277,115,0,707,1),(4278,99,0,707,1),(4279,93,0,707,60),(4280,142,0,707,166),(4281,97,0,708,1),(4282,134,0,708,2),(4283,115,0,708,1),(4284,99,0,708,1),(4285,93,0,708,60),(4286,142,0,708,167),(4287,97,0,709,1),(4288,134,0,709,2),(4289,115,0,709,1),(4290,99,0,709,1),(4291,93,0,709,60),(4292,142,0,709,168),(4293,97,0,710,1),(4294,134,0,710,2),(4295,115,0,710,1),(4296,99,0,710,1),(4297,93,0,710,60),(4298,142,0,710,169),(4299,97,0,711,1),(4300,134,0,711,2),(4301,115,0,711,1),(4302,99,0,711,1),(4303,93,0,711,60),(4304,142,0,711,170),(4305,97,0,712,1),(4306,134,0,712,2),(4307,115,0,712,1),(4308,99,0,712,4),(4309,143,0,712,0),(4310,144,0,712,0),(4311,145,0,712,0),(4312,146,0,712,0),(4313,147,0,712,1),(4314,97,0,713,1),(4315,134,0,713,2),(4316,115,0,713,1),(4317,99,0,713,1),(4318,93,0,713,50),(4319,142,0,713,166),(4320,97,0,714,1),(4321,134,0,714,2),(4322,115,0,714,1),(4323,99,0,714,1),(4324,93,0,714,50),(4325,142,0,714,167),(4326,97,0,715,1),(4327,134,0,715,2),(4328,115,0,715,1),(4329,99,0,715,1),(4330,93,0,715,50),(4331,142,0,715,168),(4332,97,0,716,1),(4333,134,0,716,2),(4334,115,0,716,1),(4335,99,0,716,1),(4336,93,0,716,50),(4337,142,0,716,169),(4338,97,0,717,1),(4339,134,0,717,2),(4340,115,0,717,1),(4341,99,0,717,1),(4342,93,0,717,50),(4343,142,0,717,170),(4344,97,0,718,1),(4345,134,0,718,2),(4346,115,0,718,1),(4347,99,0,718,4),(4348,143,0,718,1),(4349,144,0,718,0),(4350,145,0,718,0),(4351,146,0,718,0),(4352,147,0,718,1),(4353,97,0,719,1),(4354,134,0,719,2),(4355,115,0,719,1),(4356,99,0,719,1),(4357,93,0,719,50),(4358,142,0,719,166),(4359,97,0,720,1),(4360,134,0,720,2),(4361,115,0,720,1),(4362,99,0,720,1),(4363,93,0,720,50),(4364,142,0,720,167),(4365,97,0,721,1),(4366,134,0,721,2),(4367,115,0,721,1),(4368,99,0,721,1),(4369,93,0,721,50),(4370,142,0,721,168),(4371,97,0,722,1),(4372,134,0,722,2),(4373,115,0,722,1),(4374,99,0,722,1),(4375,93,0,722,50),(4376,142,0,722,169),(4377,97,0,723,1),(4378,134,0,723,2),(4379,115,0,723,1),(4380,99,0,723,1),(4381,93,0,723,50),(4382,142,0,723,170),(4383,97,0,724,1),(4384,134,0,724,2),(4385,115,0,724,1),(4386,99,0,724,4),(4387,143,0,724,0),(4388,144,0,724,0),(4389,145,0,724,0),(4390,146,0,724,0),(4391,147,0,724,1),(4392,97,0,725,1),(4393,134,0,725,2),(4394,115,0,725,1),(4395,99,0,725,1),(4396,93,0,725,49),(4397,142,0,725,175),(4398,97,0,726,1),(4399,134,0,726,2),(4400,115,0,726,1),(4401,99,0,726,1),(4402,93,0,726,52),(4403,142,0,726,175),(4404,97,0,727,1),(4405,134,0,727,2),(4406,115,0,727,1),(4407,99,0,727,1),(4408,93,0,727,57),(4409,142,0,727,175),(4410,97,0,728,1),(4411,134,0,728,2),(4412,115,0,728,1),(4413,99,0,728,1),(4414,93,0,728,49),(4415,142,0,728,176),(4416,97,0,729,1),(4417,134,0,729,2),(4418,115,0,729,1),(4419,99,0,729,1),(4420,93,0,729,52),(4421,142,0,729,176),(4422,97,0,730,1),(4423,134,0,730,2),(4424,115,0,730,1),(4425,99,0,730,1),(4426,93,0,730,57),(4427,142,0,730,176),(4428,97,0,731,1),(4429,134,0,731,2),(4430,115,0,731,1),(4431,99,0,731,1),(4432,93,0,731,49),(4433,142,0,731,177),(4434,97,0,732,1),(4435,134,0,732,2),(4436,115,0,732,1),(4437,99,0,732,1),(4438,93,0,732,52),(4439,142,0,732,177),(4440,97,0,733,1),(4441,134,0,733,2),(4442,115,0,733,1),(4443,99,0,733,1),(4444,93,0,733,57),(4445,142,0,733,177),(4446,97,0,734,1),(4447,134,0,734,2),(4448,115,0,734,1),(4449,99,0,734,1),(4450,93,0,734,49),(4451,142,0,734,178),(4452,97,0,735,1),(4453,134,0,735,2),(4454,115,0,735,1),(4455,99,0,735,1),(4456,93,0,735,52),(4457,142,0,735,178),(4458,97,0,736,1),(4459,134,0,736,2),(4460,115,0,736,1),(4461,99,0,736,1),(4462,93,0,736,57),(4463,142,0,736,178),(4464,97,0,737,1),(4465,134,0,737,2),(4466,115,0,737,1),(4467,99,0,737,4),(4468,143,0,737,0),(4469,144,0,737,0),(4470,145,0,737,0),(4471,146,0,737,0),(4472,147,0,737,0),(4473,97,0,738,1),(4474,134,0,738,2),(4475,115,0,738,1),(4476,99,0,738,1),(4477,93,0,738,50),(4478,142,0,738,175),(4479,97,0,739,1),(4480,134,0,739,2),(4481,115,0,739,1),(4482,99,0,739,1),(4483,93,0,739,52),(4484,142,0,739,175),(4485,97,0,740,1),(4486,134,0,740,2),(4487,115,0,740,1),(4488,99,0,740,1),(4489,93,0,740,58),(4490,142,0,740,175),(4491,97,0,741,1),(4492,134,0,741,2),(4493,115,0,741,1),(4494,99,0,741,1),(4495,93,0,741,50),(4496,142,0,741,176),(4497,97,0,742,1),(4498,134,0,742,2),(4499,115,0,742,1),(4500,99,0,742,1),(4501,93,0,742,52),(4502,142,0,742,176),(4503,97,0,743,1),(4504,134,0,743,2),(4505,115,0,743,1),(4506,99,0,743,1),(4507,93,0,743,58),(4508,142,0,743,176),(4509,97,0,744,1),(4510,134,0,744,2),(4511,115,0,744,1),(4512,99,0,744,1),(4513,93,0,744,50),(4514,142,0,744,177),(4515,97,0,745,1),(4516,134,0,745,2),(4517,115,0,745,1),(4518,99,0,745,1),(4519,93,0,745,52),(4520,142,0,745,177),(4521,97,0,746,1),(4522,134,0,746,2),(4523,115,0,746,1),(4524,99,0,746,1),(4525,93,0,746,58),(4526,142,0,746,177),(4527,97,0,747,1),(4528,134,0,747,2),(4529,115,0,747,1),(4530,99,0,747,1),(4531,93,0,747,50),(4532,142,0,747,178),(4533,97,0,748,1),(4534,134,0,748,2),(4535,115,0,748,1),(4536,99,0,748,1),(4537,93,0,748,52),(4538,142,0,748,178),(4539,97,0,749,1),(4540,134,0,749,2),(4541,115,0,749,1),(4542,99,0,749,1),(4543,93,0,749,58),(4544,142,0,749,178),(4545,97,0,750,1),(4546,134,0,750,2),(4547,115,0,750,1),(4548,99,0,750,4),(4549,143,0,750,0),(4550,144,0,750,1),(4551,145,0,750,0),(4552,146,0,750,0),(4553,147,0,750,0),(4554,97,0,751,1),(4555,134,0,751,2),(4556,115,0,751,1),(4557,99,0,751,1),(4558,93,0,751,50),(4559,142,0,751,175),(4560,97,0,752,1),(4561,134,0,752,2),(4562,115,0,752,1),(4563,99,0,752,1),(4564,93,0,752,53),(4565,142,0,752,175),(4566,97,0,753,1),(4567,134,0,753,2),(4568,115,0,753,1),(4569,99,0,753,1),(4570,93,0,753,58),(4571,142,0,753,175),(4572,97,0,754,1),(4573,134,0,754,2),(4574,115,0,754,1),(4575,99,0,754,1),(4576,93,0,754,50),(4577,142,0,754,176),(4578,97,0,755,1),(4579,134,0,755,2),(4580,115,0,755,1),(4581,99,0,755,1),(4582,93,0,755,53),(4583,142,0,755,176),(4584,97,0,756,1),(4585,134,0,756,2),(4586,115,0,756,1),(4587,99,0,756,1),(4588,93,0,756,58),(4589,142,0,756,176),(4590,97,0,757,1),(4591,134,0,757,2),(4592,115,0,757,1),(4593,99,0,757,1),(4594,93,0,757,50),(4595,142,0,757,177),(4596,97,0,758,1),(4597,134,0,758,2),(4598,115,0,758,1),(4599,99,0,758,1),(4600,93,0,758,53),(4601,142,0,758,177),(4602,97,0,759,1),(4603,134,0,759,2),(4604,115,0,759,1),(4605,99,0,759,1),(4606,93,0,759,58),(4607,142,0,759,177),(4608,97,0,760,1),(4609,134,0,760,2),(4610,115,0,760,1),(4611,99,0,760,1),(4612,93,0,760,50),(4613,142,0,760,178),(4614,97,0,761,1),(4615,134,0,761,2),(4616,115,0,761,1),(4617,99,0,761,1),(4618,93,0,761,53),(4619,142,0,761,178),(4620,97,0,762,1),(4621,134,0,762,2),(4622,115,0,762,1),(4623,99,0,762,1),(4624,93,0,762,58),(4625,142,0,762,178),(4626,97,0,763,1),(4627,134,0,763,2),(4628,115,0,763,1),(4629,99,0,763,4),(4630,143,0,763,0),(4631,144,0,763,0),(4632,145,0,763,0),(4633,146,0,763,1),(4634,147,0,763,0),(4635,97,0,764,1),(4636,134,0,764,2),(4637,115,0,764,1),(4638,99,0,764,1),(4639,93,0,764,49),(4640,142,0,764,175),(4641,97,0,765,1),(4642,134,0,765,2),(4643,115,0,765,1),(4644,99,0,765,1),(4645,93,0,765,52),(4646,142,0,765,175),(4647,97,0,766,1),(4648,134,0,766,2),(4649,115,0,766,1),(4650,99,0,766,1),(4651,93,0,766,53),(4652,142,0,766,175),(4653,97,0,767,1),(4654,134,0,767,2),(4655,115,0,767,1),(4656,99,0,767,1),(4657,93,0,767,49),(4658,142,0,767,176),(4659,97,0,768,1),(4660,134,0,768,2),(4661,115,0,768,1),(4662,99,0,768,1),(4663,93,0,768,52),(4664,142,0,768,176),(4665,97,0,769,1),(4666,134,0,769,2),(4667,115,0,769,1),(4668,99,0,769,1),(4669,93,0,769,53),(4670,142,0,769,176),(4671,97,0,770,1),(4672,134,0,770,2),(4673,115,0,770,1),(4674,99,0,770,1),(4675,93,0,770,49),(4676,142,0,770,177),(4677,97,0,771,1),(4678,134,0,771,2),(4679,115,0,771,1),(4680,99,0,771,1),(4681,93,0,771,52),(4682,142,0,771,177),(4683,97,0,772,1),(4684,134,0,772,2),(4685,115,0,772,1),(4686,99,0,772,1),(4687,93,0,772,53),(4688,142,0,772,177),(4689,97,0,773,1),(4690,134,0,773,2),(4691,115,0,773,1),(4692,99,0,773,1),(4693,93,0,773,49),(4694,142,0,773,178),(4695,97,0,774,1),(4696,134,0,774,2),(4697,115,0,774,1),(4698,99,0,774,1),(4699,93,0,774,52),(4700,142,0,774,178),(4701,97,0,775,1),(4702,134,0,775,2),(4703,115,0,775,1),(4704,99,0,775,1),(4705,93,0,775,53),(4706,142,0,775,178),(4707,97,0,776,1),(4708,134,0,776,2),(4709,115,0,776,1),(4710,99,0,776,4),(4711,143,0,776,0),(4712,144,0,776,0),(4713,145,0,776,0),(4714,146,0,776,0),(4715,147,0,776,0),(4716,97,0,777,1),(4717,134,0,777,2),(4718,115,0,777,1),(4719,99,0,777,1),(4720,93,0,777,49),(4721,142,0,777,175),(4722,97,0,778,1),(4723,134,0,778,2),(4724,115,0,778,1),(4725,99,0,778,1),(4726,93,0,778,50),(4727,142,0,778,175),(4728,97,0,779,1),(4729,134,0,779,2),(4730,115,0,779,1),(4731,99,0,779,1),(4732,93,0,779,53),(4733,142,0,779,175),(4734,97,0,780,1),(4735,134,0,780,2),(4736,115,0,780,1),(4737,99,0,780,1),(4738,93,0,780,49),(4739,142,0,780,176),(4740,97,0,781,1),(4741,134,0,781,2),(4742,115,0,781,1),(4743,99,0,781,1),(4744,93,0,781,50),(4745,142,0,781,176),(4746,97,0,782,1),(4747,134,0,782,2),(4748,115,0,782,1),(4749,99,0,782,1),(4750,93,0,782,53),(4751,142,0,782,176),(4752,97,0,783,1),(4753,134,0,783,2),(4754,115,0,783,1),(4755,99,0,783,1),(4756,93,0,783,49),(4757,142,0,783,177),(4758,97,0,784,1),(4759,134,0,784,2),(4760,115,0,784,1),(4761,99,0,784,1),(4762,93,0,784,50),(4763,142,0,784,177),(4764,97,0,785,1),(4765,134,0,785,2),(4766,115,0,785,1),(4767,99,0,785,1),(4768,93,0,785,53),(4769,142,0,785,177),(4770,97,0,786,1),(4771,134,0,786,2),(4772,115,0,786,1),(4773,99,0,786,1),(4774,93,0,786,49),(4775,142,0,786,178),(4776,97,0,787,1),(4777,134,0,787,2),(4778,115,0,787,1),(4779,99,0,787,1),(4780,93,0,787,50),(4781,142,0,787,178),(4782,97,0,788,1),(4783,134,0,788,2),(4784,115,0,788,1),(4785,99,0,788,1),(4786,93,0,788,53),(4787,142,0,788,178),(4788,97,0,789,1),(4789,134,0,789,2),(4790,115,0,789,1),(4791,99,0,789,4),(4792,143,0,789,0),(4793,144,0,789,0),(4794,145,0,789,0),(4795,146,0,789,1),(4796,147,0,789,0),(4797,97,0,790,1),(4798,134,0,790,2),(4799,115,0,790,1),(4800,99,0,790,1),(4801,93,0,790,52),(4802,142,0,790,175),(4803,97,0,791,1),(4804,134,0,791,2),(4805,115,0,791,1),(4806,99,0,791,1),(4807,93,0,791,53),(4808,142,0,791,175),(4809,97,0,792,1),(4810,134,0,792,2),(4811,115,0,792,1),(4812,99,0,792,1),(4813,93,0,792,56),(4814,142,0,792,175),(4815,97,0,793,1),(4816,134,0,793,2),(4817,115,0,793,1),(4818,99,0,793,1),(4819,93,0,793,52),(4820,142,0,793,176),(4821,97,0,794,1),(4822,134,0,794,2),(4823,115,0,794,1),(4824,99,0,794,1),(4825,93,0,794,53),(4826,142,0,794,176),(4827,97,0,795,1),(4828,134,0,795,2),(4829,115,0,795,1),(4830,99,0,795,1),(4831,93,0,795,56),(4832,142,0,795,176),(4833,97,0,796,1),(4834,134,0,796,2),(4835,115,0,796,1),(4836,99,0,796,1),(4837,93,0,796,52),(4838,142,0,796,177),(4839,97,0,797,1),(4840,134,0,797,2),(4841,115,0,797,1),(4842,99,0,797,1),(4843,93,0,797,53),(4844,142,0,797,177),(4845,97,0,798,1),(4846,134,0,798,2),(4847,115,0,798,1),(4848,99,0,798,1),(4849,93,0,798,56),(4850,142,0,798,177),(4851,97,0,799,1),(4852,134,0,799,2),(4853,115,0,799,1),(4854,99,0,799,1),(4855,93,0,799,52),(4856,142,0,799,178),(4857,97,0,800,1),(4858,134,0,800,2),(4859,115,0,800,1),(4860,99,0,800,1),(4861,93,0,800,53),(4862,142,0,800,178),(4863,97,0,801,1),(4864,134,0,801,2),(4865,115,0,801,1),(4866,99,0,801,1),(4867,93,0,801,56),(4868,142,0,801,178),(4869,97,0,802,1),(4870,134,0,802,2),(4871,115,0,802,1),(4872,99,0,802,4),(4873,143,0,802,1),(4874,144,0,802,0),(4875,145,0,802,0),(4876,146,0,802,0),(4877,147,0,802,0),(4878,97,0,803,1),(4879,134,0,803,2),(4880,115,0,803,1),(4881,99,0,803,1),(4882,93,0,803,49),(4883,142,0,803,175),(4884,97,0,804,1),(4885,134,0,804,2),(4886,115,0,804,1),(4887,99,0,804,1),(4888,93,0,804,50),(4889,142,0,804,175),(4890,97,0,805,1),(4891,134,0,805,2),(4892,115,0,805,1),(4893,99,0,805,1),(4894,93,0,805,57),(4895,142,0,805,175),(4896,97,0,806,1),(4897,134,0,806,2),(4898,115,0,806,1),(4899,99,0,806,1),(4900,93,0,806,49),(4901,142,0,806,176),(4902,97,0,807,1),(4903,134,0,807,2),(4904,115,0,807,1),(4905,99,0,807,1),(4906,93,0,807,50),(4907,142,0,807,176),(4908,97,0,808,1),(4909,134,0,808,2),(4910,115,0,808,1),(4911,99,0,808,1),(4912,93,0,808,57),(4913,142,0,808,176),(4914,97,0,809,1),(4915,134,0,809,2),(4916,115,0,809,1),(4917,99,0,809,1),(4918,93,0,809,49),(4919,142,0,809,177),(4920,97,0,810,1),(4921,134,0,810,2),(4922,115,0,810,1),(4923,99,0,810,1),(4924,93,0,810,50),(4925,142,0,810,177),(4926,97,0,811,1),(4927,134,0,811,2),(4928,115,0,811,1),(4929,99,0,811,1),(4930,93,0,811,57),(4931,142,0,811,177),(4932,97,0,812,1),(4933,134,0,812,2),(4934,115,0,812,1),(4935,99,0,812,1),(4936,93,0,812,49),(4937,142,0,812,178),(4938,97,0,813,1),(4939,134,0,813,2),(4940,115,0,813,1),(4941,99,0,813,1),(4942,93,0,813,50),(4943,142,0,813,178),(4944,97,0,814,1),(4945,134,0,814,2),(4946,115,0,814,1),(4947,99,0,814,1),(4948,93,0,814,57),(4949,142,0,814,178),(4950,97,0,815,1),(4951,134,0,815,2),(4952,115,0,815,1),(4953,99,0,815,4),(4954,143,0,815,0),(4955,144,0,815,0),(4956,145,0,815,0),(4957,146,0,815,1),(4958,147,0,815,0),(4959,97,0,816,1),(4960,134,0,816,2),(4961,115,0,816,1),(4962,99,0,816,1),(4963,93,0,816,50),(4964,142,0,816,175),(4965,97,0,817,1),(4966,134,0,817,2),(4967,115,0,817,1),(4968,99,0,817,1),(4969,93,0,817,53),(4970,142,0,817,175),(4971,97,0,818,1),(4972,134,0,818,2),(4973,115,0,818,1),(4974,99,0,818,1),(4975,93,0,818,58),(4976,142,0,818,175),(4977,97,0,819,1),(4978,134,0,819,2),(4979,115,0,819,1),(4980,99,0,819,1),(4981,93,0,819,50),(4982,142,0,819,176),(4983,97,0,820,1),(4984,134,0,820,2),(4985,115,0,820,1),(4986,99,0,820,1),(4987,93,0,820,53),(4988,142,0,820,176),(4989,97,0,821,1),(4990,134,0,821,2),(4991,115,0,821,1),(4992,99,0,821,1),(4993,93,0,821,58),(4994,142,0,821,176),(4995,97,0,822,1),(4996,134,0,822,2),(4997,115,0,822,1),(4998,99,0,822,1),(4999,93,0,822,50),(5000,142,0,822,177),(5001,97,0,823,1),(5002,134,0,823,2),(5003,115,0,823,1),(5004,99,0,823,1),(5005,93,0,823,53),(5006,142,0,823,177),(5007,97,0,824,1),(5008,134,0,824,2),(5009,115,0,824,1),(5010,99,0,824,1),(5011,93,0,824,58),(5012,142,0,824,177),(5013,97,0,825,1),(5014,134,0,825,2),(5015,115,0,825,1),(5016,99,0,825,1),(5017,93,0,825,50),(5018,142,0,825,178),(5019,97,0,826,1),(5020,134,0,826,2),(5021,115,0,826,1),(5022,99,0,826,1),(5023,93,0,826,53),(5024,142,0,826,178),(5025,97,0,827,1),(5026,134,0,827,2),(5027,115,0,827,1),(5028,99,0,827,1),(5029,93,0,827,58),(5030,142,0,827,178),(5031,97,0,828,1),(5032,134,0,828,2),(5033,115,0,828,1),(5034,99,0,828,4),(5035,143,0,828,0),(5036,144,0,828,0),(5037,145,0,828,0),(5038,146,0,828,1),(5039,147,0,828,0),(5040,97,0,829,1),(5041,134,0,829,2),(5042,115,0,829,1),(5043,99,0,829,1),(5044,93,0,829,49),(5045,142,0,829,175),(5046,97,0,830,1),(5047,134,0,830,2),(5048,115,0,830,1),(5049,99,0,830,1),(5050,93,0,830,50),(5051,142,0,830,175),(5052,97,0,831,1),(5053,134,0,831,2),(5054,115,0,831,1),(5055,99,0,831,1),(5056,93,0,831,58),(5057,142,0,831,175),(5058,97,0,832,1),(5059,134,0,832,2),(5060,115,0,832,1),(5061,99,0,832,1),(5062,93,0,832,49),(5063,142,0,832,176),(5064,97,0,833,1),(5065,134,0,833,2),(5066,115,0,833,1),(5067,99,0,833,1),(5068,93,0,833,50),(5069,142,0,833,176),(5070,97,0,834,1),(5071,134,0,834,2),(5072,115,0,834,1),(5073,99,0,834,1),(5074,93,0,834,58),(5075,142,0,834,176),(5076,97,0,835,1),(5077,134,0,835,2),(5078,115,0,835,1),(5079,99,0,835,1),(5080,93,0,835,49),(5081,142,0,835,177),(5082,97,0,836,1),(5083,134,0,836,2),(5084,115,0,836,1),(5085,99,0,836,1),(5086,93,0,836,50),(5087,142,0,836,177),(5088,97,0,837,1),(5089,134,0,837,2),(5090,115,0,837,1),(5091,99,0,837,1),(5092,93,0,837,58),(5093,142,0,837,177),(5094,97,0,838,1),(5095,134,0,838,2),(5096,115,0,838,1),(5097,99,0,838,1),(5098,93,0,838,49),(5099,142,0,838,178),(5100,97,0,839,1),(5101,134,0,839,2),(5102,115,0,839,1),(5103,99,0,839,1),(5104,93,0,839,50),(5105,142,0,839,178),(5106,97,0,840,1),(5107,134,0,840,2),(5108,115,0,840,1),(5109,99,0,840,1),(5110,93,0,840,58),(5111,142,0,840,178),(5112,97,0,841,1),(5113,134,0,841,2),(5114,115,0,841,1),(5115,99,0,841,4),(5116,143,0,841,0),(5117,144,0,841,1),(5118,145,0,841,1),(5119,146,0,841,1),(5120,147,0,841,0),(5121,97,0,842,1),(5122,134,0,842,2),(5123,115,0,842,1),(5124,99,0,842,1),(5125,93,0,842,49),(5126,142,0,842,175),(5127,97,0,843,1),(5128,134,0,843,2),(5129,115,0,843,1),(5130,99,0,843,1),(5131,93,0,843,50),(5132,142,0,843,175),(5133,97,0,844,1),(5134,134,0,844,2),(5135,115,0,844,1),(5136,99,0,844,1),(5137,93,0,844,53),(5138,142,0,844,175),(5139,97,0,845,1),(5140,134,0,845,2),(5141,115,0,845,1),(5142,99,0,845,1),(5143,93,0,845,49),(5144,142,0,845,176),(5145,97,0,846,1),(5146,134,0,846,2),(5147,115,0,846,1),(5148,99,0,846,1),(5149,93,0,846,50),(5150,142,0,846,176),(5151,97,0,847,1),(5152,134,0,847,2),(5153,115,0,847,1),(5154,99,0,847,1),(5155,93,0,847,53),(5156,142,0,847,176),(5157,97,0,848,1),(5158,134,0,848,2),(5159,115,0,848,1),(5160,99,0,848,1),(5161,93,0,848,49),(5162,142,0,848,177),(5163,97,0,849,1),(5164,134,0,849,2),(5165,115,0,849,1),(5166,99,0,849,1),(5167,93,0,849,50),(5168,142,0,849,177),(5169,97,0,850,1),(5170,134,0,850,2),(5171,115,0,850,1),(5172,99,0,850,1),(5173,93,0,850,53),(5174,142,0,850,177),(5175,97,0,851,1),(5176,134,0,851,2),(5177,115,0,851,1),(5178,99,0,851,1),(5179,93,0,851,49),(5180,142,0,851,178),(5181,97,0,852,1),(5182,134,0,852,2),(5183,115,0,852,1),(5184,99,0,852,1),(5185,93,0,852,50),(5186,142,0,852,178),(5187,97,0,853,1),(5188,134,0,853,2),(5189,115,0,853,1),(5190,99,0,853,1),(5191,93,0,853,53),(5192,142,0,853,178),(5193,97,0,854,1),(5194,134,0,854,2),(5195,115,0,854,1),(5196,99,0,854,4),(5197,143,0,854,0),(5198,144,0,854,0),(5199,145,0,854,1),(5200,146,0,854,0),(5201,147,0,854,0),(5202,97,0,855,1),(5203,134,0,855,2),(5204,115,0,855,1),(5205,99,0,855,1),(5206,93,0,855,50),(5207,142,0,855,175),(5208,97,0,856,1),(5209,134,0,856,2),(5210,115,0,856,1),(5211,99,0,856,1),(5212,93,0,856,51),(5213,142,0,856,175),(5214,97,0,857,1),(5215,134,0,857,2),(5216,115,0,857,1),(5217,99,0,857,1),(5218,93,0,857,53),(5219,142,0,857,175),(5220,97,0,858,1),(5221,134,0,858,2),(5222,115,0,858,1),(5223,99,0,858,1),(5224,93,0,858,50),(5225,142,0,858,176),(5226,97,0,859,1),(5227,134,0,859,2),(5228,115,0,859,1),(5229,99,0,859,1),(5230,93,0,859,51),(5231,142,0,859,176),(5232,97,0,860,1),(5233,134,0,860,2),(5234,115,0,860,1),(5235,99,0,860,1),(5236,93,0,860,53),(5237,142,0,860,176),(5238,97,0,861,1),(5239,134,0,861,2),(5240,115,0,861,1),(5241,99,0,861,1),(5242,93,0,861,50),(5243,142,0,861,177),(5244,97,0,862,1),(5245,134,0,862,2),(5246,115,0,862,1),(5247,99,0,862,1),(5248,93,0,862,51),(5249,142,0,862,177),(5250,97,0,863,1),(5251,134,0,863,2),(5252,115,0,863,1),(5253,99,0,863,1),(5254,93,0,863,53),(5255,142,0,863,177),(5256,97,0,864,1),(5257,134,0,864,2),(5258,115,0,864,1),(5259,99,0,864,1),(5260,93,0,864,50),(5261,142,0,864,178),(5262,97,0,865,1),(5263,134,0,865,2),(5264,115,0,865,1),(5265,99,0,865,1),(5266,93,0,865,51),(5267,142,0,865,178),(5268,97,0,866,1),(5269,134,0,866,2),(5270,115,0,866,1),(5271,99,0,866,1),(5272,93,0,866,53),(5273,142,0,866,178),(5274,97,0,867,1),(5275,134,0,867,2),(5276,115,0,867,1),(5277,99,0,867,4),(5278,143,0,867,0),(5279,144,0,867,1),(5280,145,0,867,1),(5281,146,0,867,0),(5282,147,0,867,0),(5283,97,0,868,1),(5284,134,0,868,2),(5285,115,0,868,1),(5286,99,0,868,1),(5287,93,0,868,49),(5288,142,0,868,175),(5289,97,0,869,1),(5290,134,0,869,2),(5291,115,0,869,1),(5292,99,0,869,1),(5293,93,0,869,50),(5294,142,0,869,175),(5295,97,0,870,1),(5296,134,0,870,2),(5297,115,0,870,1),(5298,99,0,870,1),(5299,93,0,870,58),(5300,142,0,870,175),(5301,97,0,871,1),(5302,134,0,871,2),(5303,115,0,871,1),(5304,99,0,871,1),(5305,93,0,871,49),(5306,142,0,871,176),(5307,97,0,872,1),(5308,134,0,872,2),(5309,115,0,872,1),(5310,99,0,872,1),(5311,93,0,872,50),(5312,142,0,872,176),(5313,97,0,873,1),(5314,134,0,873,2),(5315,115,0,873,1),(5316,99,0,873,1),(5317,93,0,873,58),(5318,142,0,873,176),(5319,97,0,874,1),(5320,134,0,874,2),(5321,115,0,874,1),(5322,99,0,874,1),(5323,93,0,874,49),(5324,142,0,874,177),(5325,97,0,875,1),(5326,134,0,875,2),(5327,115,0,875,1),(5328,99,0,875,1),(5329,93,0,875,50),(5330,142,0,875,177),(5331,97,0,876,1),(5332,134,0,876,2),(5333,115,0,876,1),(5334,99,0,876,1),(5335,93,0,876,58),(5336,142,0,876,177),(5337,97,0,877,1),(5338,134,0,877,2),(5339,115,0,877,1),(5340,99,0,877,1),(5341,93,0,877,49),(5342,142,0,877,178),(5343,97,0,878,1),(5344,134,0,878,2),(5345,115,0,878,1),(5346,99,0,878,1),(5347,93,0,878,50),(5348,142,0,878,178),(5349,97,0,879,1),(5350,134,0,879,2),(5351,115,0,879,1),(5352,99,0,879,1),(5353,93,0,879,58),(5354,142,0,879,178),(5355,97,0,880,1),(5356,134,0,880,2),(5357,115,0,880,1),(5358,99,0,880,4),(5359,143,0,880,0),(5360,144,0,880,0),(5361,145,0,880,0),(5362,146,0,880,0),(5363,147,0,880,0),(5364,97,0,881,1),(5365,134,0,881,2),(5366,115,0,881,1),(5367,99,0,881,1),(5368,93,0,881,49),(5369,142,0,881,175),(5370,97,0,882,1),(5371,134,0,882,2),(5372,115,0,882,1),(5373,99,0,882,1),(5374,93,0,882,50),(5375,142,0,882,175),(5376,97,0,883,1),(5377,134,0,883,2),(5378,115,0,883,1),(5379,99,0,883,1),(5380,93,0,883,58),(5381,142,0,883,175),(5382,97,0,884,1),(5383,134,0,884,2),(5384,115,0,884,1),(5385,99,0,884,1),(5386,93,0,884,49),(5387,142,0,884,176),(5388,97,0,885,1),(5389,134,0,885,2),(5390,115,0,885,1),(5391,99,0,885,1),(5392,93,0,885,50),(5393,142,0,885,176),(5394,97,0,886,1),(5395,134,0,886,2),(5396,115,0,886,1),(5397,99,0,886,1),(5398,93,0,886,58),(5399,142,0,886,176),(5400,97,0,887,1),(5401,134,0,887,2),(5402,115,0,887,1),(5403,99,0,887,1),(5404,93,0,887,49),(5405,142,0,887,177),(5406,97,0,888,1),(5407,134,0,888,2),(5408,115,0,888,1),(5409,99,0,888,1),(5410,93,0,888,50),(5411,142,0,888,177),(5412,97,0,889,1),(5413,134,0,889,2),(5414,115,0,889,1),(5415,99,0,889,1),(5416,93,0,889,58),(5417,142,0,889,177),(5418,97,0,890,1),(5419,134,0,890,2),(5420,115,0,890,1),(5421,99,0,890,1),(5422,93,0,890,49),(5423,142,0,890,178),(5424,97,0,891,1),(5425,134,0,891,2),(5426,115,0,891,1),(5427,99,0,891,1),(5428,93,0,891,50),(5429,142,0,891,178),(5430,97,0,892,1),(5431,134,0,892,2),(5432,115,0,892,1),(5433,99,0,892,1),(5434,93,0,892,58),(5435,142,0,892,178),(5436,97,0,893,1),(5437,134,0,893,2),(5438,115,0,893,1),(5439,99,0,893,4),(5440,143,0,893,0),(5441,144,0,893,0),(5442,145,0,893,1),(5443,146,0,893,0),(5444,147,0,893,0),(5445,97,0,894,1),(5446,134,0,894,2),(5447,115,0,894,1),(5448,99,0,894,1),(5449,93,0,894,49),(5450,142,0,894,175),(5451,97,0,895,1),(5452,134,0,895,2),(5453,115,0,895,1),(5454,99,0,895,1),(5455,93,0,895,49),(5456,142,0,895,176),(5457,97,0,896,1),(5458,134,0,896,2),(5459,115,0,896,1),(5460,99,0,896,1),(5461,93,0,896,49),(5462,142,0,896,177),(5463,97,0,897,1),(5464,134,0,897,2),(5465,115,0,897,1),(5466,99,0,897,1),(5467,93,0,897,49),(5468,142,0,897,178),(5469,97,0,898,1),(5470,134,0,898,2),(5471,115,0,898,1),(5472,99,0,898,4),(5473,143,0,898,0),(5474,144,0,898,0),(5475,145,0,898,0),(5476,146,0,898,0),(5477,147,0,898,0),(5478,97,0,899,1),(5479,134,0,899,2),(5480,115,0,899,1),(5481,99,0,899,1),(5482,93,0,899,49),(5483,142,0,899,175),(5484,97,0,900,1),(5485,134,0,900,2),(5486,115,0,900,1),(5487,99,0,900,1),(5488,93,0,900,50),(5489,142,0,900,175),(5490,97,0,901,1),(5491,134,0,901,2),(5492,115,0,901,1),(5493,99,0,901,1),(5494,93,0,901,53),(5495,142,0,901,175),(5496,97,0,902,1),(5497,134,0,902,2),(5498,115,0,902,1),(5499,99,0,902,1),(5500,93,0,902,49),(5501,142,0,902,176),(5502,97,0,903,1),(5503,134,0,903,2),(5504,115,0,903,1),(5505,99,0,903,1),(5506,93,0,903,50),(5507,142,0,903,176),(5508,97,0,904,1),(5509,134,0,904,2),(5510,115,0,904,1),(5511,99,0,904,1),(5512,93,0,904,53),(5513,142,0,904,176),(5514,97,0,905,1),(5515,134,0,905,2),(5516,115,0,905,1),(5517,99,0,905,1),(5518,93,0,905,49),(5519,142,0,905,177),(5520,97,0,906,1),(5521,134,0,906,2),(5522,115,0,906,1),(5523,99,0,906,1),(5524,93,0,906,50),(5525,142,0,906,177),(5526,97,0,907,1),(5527,134,0,907,2),(5528,115,0,907,1),(5529,99,0,907,1),(5530,93,0,907,53),(5531,142,0,907,177),(5532,97,0,908,1),(5533,134,0,908,2),(5534,115,0,908,1),(5535,99,0,908,1),(5536,93,0,908,49),(5537,142,0,908,178),(5538,97,0,909,1),(5539,134,0,909,2),(5540,115,0,909,1),(5541,99,0,909,1),(5542,93,0,909,50),(5543,142,0,909,178),(5544,97,0,910,1),(5545,134,0,910,2),(5546,115,0,910,1),(5547,99,0,910,1),(5548,93,0,910,53),(5549,142,0,910,178),(5550,97,0,911,1),(5551,134,0,911,2),(5552,115,0,911,1),(5553,99,0,911,4),(5554,143,0,911,0),(5555,144,0,911,1),(5556,145,0,911,0),(5557,146,0,911,0),(5558,147,0,911,0),(5559,97,0,912,1),(5560,134,0,912,2),(5561,115,0,912,1),(5562,99,0,912,1),(5563,93,0,912,52),(5564,142,0,912,175),(5565,97,0,913,1),(5566,134,0,913,2),(5567,115,0,913,1),(5568,99,0,913,1),(5569,93,0,913,57),(5570,142,0,913,175),(5571,97,0,914,1),(5572,134,0,914,2),(5573,115,0,914,1),(5574,99,0,914,1),(5575,93,0,914,60),(5576,142,0,914,175),(5577,97,0,915,1),(5578,134,0,915,2),(5579,115,0,915,1),(5580,99,0,915,1),(5581,93,0,915,52),(5582,142,0,915,176),(5583,97,0,916,1),(5584,134,0,916,2),(5585,115,0,916,1),(5586,99,0,916,1),(5587,93,0,916,57),(5588,142,0,916,176),(5589,97,0,917,1),(5590,134,0,917,2),(5591,115,0,917,1),(5592,99,0,917,1),(5593,93,0,917,60),(5594,142,0,917,176),(5595,97,0,918,1),(5596,134,0,918,2),(5597,115,0,918,1),(5598,99,0,918,1),(5599,93,0,918,52),(5600,142,0,918,177),(5601,97,0,919,1),(5602,134,0,919,2),(5603,115,0,919,1),(5604,99,0,919,1),(5605,93,0,919,57),(5606,142,0,919,177),(5607,97,0,920,1),(5608,134,0,920,2),(5609,115,0,920,1),(5610,99,0,920,1),(5611,93,0,920,60),(5612,142,0,920,177),(5613,97,0,921,1),(5614,134,0,921,2),(5615,115,0,921,1),(5616,99,0,921,1),(5617,93,0,921,52),(5618,142,0,921,178),(5619,97,0,922,1),(5620,134,0,922,2),(5621,115,0,922,1),(5622,99,0,922,1),(5623,93,0,922,57),(5624,142,0,922,178),(5625,97,0,923,1),(5626,134,0,923,2),(5627,115,0,923,1),(5628,99,0,923,1),(5629,93,0,923,60),(5630,142,0,923,178),(5631,97,0,924,1),(5632,134,0,924,2),(5633,115,0,924,1),(5634,99,0,924,4),(5635,143,0,924,0),(5636,144,0,924,0),(5637,145,0,924,0),(5638,146,0,924,0),(5639,147,0,924,0),(5640,97,0,925,1),(5641,134,0,925,2),(5642,115,0,925,1),(5643,99,0,925,1),(5644,93,0,925,49),(5645,142,0,925,175),(5646,97,0,926,1),(5647,134,0,926,2),(5648,115,0,926,1),(5649,99,0,926,1),(5650,93,0,926,50),(5651,142,0,926,175),(5652,97,0,927,1),(5653,134,0,927,2),(5654,115,0,927,1),(5655,99,0,927,1),(5656,93,0,927,52),(5657,142,0,927,175),(5658,97,0,928,1),(5659,134,0,928,2),(5660,115,0,928,1),(5661,99,0,928,1),(5662,93,0,928,49),(5663,142,0,928,176),(5664,97,0,929,1),(5665,134,0,929,2),(5666,115,0,929,1),(5667,99,0,929,1),(5668,93,0,929,50),(5669,142,0,929,176),(5670,97,0,930,1),(5671,134,0,930,2),(5672,115,0,930,1),(5673,99,0,930,1),(5674,93,0,930,52),(5675,142,0,930,176),(5676,97,0,931,1),(5677,134,0,931,2),(5678,115,0,931,1),(5679,99,0,931,1),(5680,93,0,931,49),(5681,142,0,931,177),(5682,97,0,932,1),(5683,134,0,932,2),(5684,115,0,932,1),(5685,99,0,932,1),(5686,93,0,932,50),(5687,142,0,932,177),(5688,97,0,933,1),(5689,134,0,933,2),(5690,115,0,933,1),(5691,99,0,933,1),(5692,93,0,933,52),(5693,142,0,933,177),(5694,97,0,934,1),(5695,134,0,934,2),(5696,115,0,934,1),(5697,99,0,934,1),(5698,93,0,934,49),(5699,142,0,934,178),(5700,97,0,935,1),(5701,134,0,935,2),(5702,115,0,935,1),(5703,99,0,935,1),(5704,93,0,935,50),(5705,142,0,935,178),(5706,97,0,936,1),(5707,134,0,936,2),(5708,115,0,936,1),(5709,99,0,936,1),(5710,93,0,936,52),(5711,142,0,936,178),(5712,97,0,937,1),(5713,134,0,937,2),(5714,115,0,937,1),(5715,99,0,937,4),(5716,143,0,937,0),(5717,144,0,937,1),(5718,145,0,937,0),(5719,146,0,937,0),(5720,147,0,937,0),(5721,97,0,938,1),(5722,134,0,938,2),(5723,115,0,938,1),(5724,99,0,938,1),(5725,93,0,938,50),(5726,142,0,938,175),(5727,97,0,939,1),(5728,134,0,939,2),(5729,115,0,939,1),(5730,99,0,939,1),(5731,93,0,939,52),(5732,142,0,939,175),(5733,97,0,940,1),(5734,134,0,940,2),(5735,115,0,940,1),(5736,99,0,940,1),(5737,93,0,940,58),(5738,142,0,940,175),(5739,97,0,941,1),(5740,134,0,941,2),(5741,115,0,941,1),(5742,99,0,941,1),(5743,93,0,941,50),(5744,142,0,941,176),(5745,97,0,942,1),(5746,134,0,942,2),(5747,115,0,942,1),(5748,99,0,942,1),(5749,93,0,942,52),(5750,142,0,942,176),(5751,97,0,943,1),(5752,134,0,943,2),(5753,115,0,943,1),(5754,99,0,943,1),(5755,93,0,943,58),(5756,142,0,943,176),(5757,97,0,944,1),(5758,134,0,944,2),(5759,115,0,944,1),(5760,99,0,944,1),(5761,93,0,944,50),(5762,142,0,944,177),(5763,97,0,945,1),(5764,134,0,945,2),(5765,115,0,945,1),(5766,99,0,945,1),(5767,93,0,945,52),(5768,142,0,945,177),(5769,97,0,946,1),(5770,134,0,946,2),(5771,115,0,946,1),(5772,99,0,946,1),(5773,93,0,946,58),(5774,142,0,946,177),(5775,97,0,947,1),(5776,134,0,947,2),(5777,115,0,947,1),(5778,99,0,947,1),(5779,93,0,947,50),(5780,142,0,947,178),(5781,97,0,948,1),(5782,134,0,948,2),(5783,115,0,948,1),(5784,99,0,948,1),(5785,93,0,948,52),(5786,142,0,948,178),(5787,97,0,949,1),(5788,134,0,949,2),(5789,115,0,949,1),(5790,99,0,949,1),(5791,93,0,949,58),(5792,142,0,949,178),(5793,97,0,950,1),(5794,134,0,950,2),(5795,115,0,950,1),(5796,99,0,950,4),(5797,143,0,950,0),(5798,144,0,950,0),(5799,145,0,950,0),(5800,146,0,950,1),(5801,147,0,950,0),(5802,97,0,951,1),(5803,134,0,951,2),(5804,115,0,951,1),(5805,99,0,951,1),(5806,93,0,951,49),(5807,142,0,951,175),(5808,97,0,952,1),(5809,134,0,952,2),(5810,115,0,952,1),(5811,99,0,952,1),(5812,93,0,952,50),(5813,142,0,952,175),(5814,97,0,953,1),(5815,134,0,953,2),(5816,115,0,953,1),(5817,99,0,953,1),(5818,93,0,953,57),(5819,142,0,953,175),(5820,97,0,954,1),(5821,134,0,954,2),(5822,115,0,954,1),(5823,99,0,954,1),(5824,93,0,954,49),(5825,142,0,954,176),(5826,97,0,955,1),(5827,134,0,955,2),(5828,115,0,955,1),(5829,99,0,955,1),(5830,93,0,955,50),(5831,142,0,955,176),(5832,97,0,956,1),(5833,134,0,956,2),(5834,115,0,956,1),(5835,99,0,956,1),(5836,93,0,956,57),(5837,142,0,956,176),(5838,97,0,957,1),(5839,134,0,957,2),(5840,115,0,957,1),(5841,99,0,957,1),(5842,93,0,957,49),(5843,142,0,957,177),(5844,97,0,958,1),(5845,134,0,958,2),(5846,115,0,958,1),(5847,99,0,958,1),(5848,93,0,958,50),(5849,142,0,958,177),(5850,97,0,959,1),(5851,134,0,959,2),(5852,115,0,959,1),(5853,99,0,959,1),(5854,93,0,959,57),(5855,142,0,959,177),(5856,97,0,960,1),(5857,134,0,960,2),(5858,115,0,960,1),(5859,99,0,960,1),(5860,93,0,960,49),(5861,142,0,960,178),(5862,97,0,961,1),(5863,134,0,961,2),(5864,115,0,961,1),(5865,99,0,961,1),(5866,93,0,961,50),(5867,142,0,961,178),(5868,97,0,962,1),(5869,134,0,962,2),(5870,115,0,962,1),(5871,99,0,962,1),(5872,93,0,962,57),(5873,142,0,962,178),(5874,97,0,963,1),(5875,134,0,963,2),(5876,115,0,963,1),(5877,99,0,963,4),(5878,143,0,963,0),(5879,144,0,963,1),(5880,145,0,963,1),(5881,146,0,963,0),(5882,147,0,963,1),(5883,97,0,964,1),(5884,134,0,964,2),(5885,115,0,964,1),(5886,99,0,964,1),(5887,93,0,964,49),(5888,142,0,964,175),(5889,97,0,965,1),(5890,134,0,965,2),(5891,115,0,965,1),(5892,99,0,965,1),(5893,93,0,965,50),(5894,142,0,965,175),(5895,97,0,966,1),(5896,134,0,966,2),(5897,115,0,966,1),(5898,99,0,966,1),(5899,93,0,966,53),(5900,142,0,966,175),(5901,97,0,967,1),(5902,134,0,967,2),(5903,115,0,967,1),(5904,99,0,967,1),(5905,93,0,967,49),(5906,142,0,967,176),(5907,97,0,968,1),(5908,134,0,968,2),(5909,115,0,968,1),(5910,99,0,968,1),(5911,93,0,968,50),(5912,142,0,968,176),(5913,97,0,969,1),(5914,134,0,969,2),(5915,115,0,969,1),(5916,99,0,969,1),(5917,93,0,969,53),(5918,142,0,969,176),(5919,97,0,970,1),(5920,134,0,970,2),(5921,115,0,970,1),(5922,99,0,970,1),(5923,93,0,970,49),(5924,142,0,970,177),(5925,97,0,971,1),(5926,134,0,971,2),(5927,115,0,971,1),(5928,99,0,971,1),(5929,93,0,971,50),(5930,142,0,971,177),(5931,97,0,972,1),(5932,134,0,972,2),(5933,115,0,972,1),(5934,99,0,972,1),(5935,93,0,972,53),(5936,142,0,972,177),(5937,97,0,973,1),(5938,134,0,973,2),(5939,115,0,973,1),(5940,99,0,973,1),(5941,93,0,973,49),(5942,142,0,973,178),(5943,97,0,974,1),(5944,134,0,974,2),(5945,115,0,974,1),(5946,99,0,974,1),(5947,93,0,974,50),(5948,142,0,974,178),(5949,97,0,975,1),(5950,134,0,975,2),(5951,115,0,975,1),(5952,99,0,975,1),(5953,93,0,975,53),(5954,142,0,975,178),(5955,97,0,976,1),(5956,134,0,976,2),(5957,115,0,976,1),(5958,99,0,976,4),(5959,143,0,976,0),(5960,144,0,976,0),(5961,145,0,976,0),(5962,146,0,976,0),(5963,147,0,976,1),(5964,97,0,977,1),(5965,134,0,977,2),(5966,115,0,977,1),(5967,99,0,977,1),(5968,93,0,977,49),(5969,142,0,977,175),(5970,97,0,978,1),(5971,134,0,978,2),(5972,115,0,978,1),(5973,99,0,978,1),(5974,93,0,978,50),(5975,142,0,978,175),(5976,97,0,979,1),(5977,134,0,979,2),(5978,115,0,979,1),(5979,99,0,979,1),(5980,93,0,979,53),(5981,142,0,979,175),(5982,97,0,980,1),(5983,134,0,980,2),(5984,115,0,980,1),(5985,99,0,980,1),(5986,93,0,980,49),(5987,142,0,980,176),(5988,97,0,981,1),(5989,134,0,981,2),(5990,115,0,981,1),(5991,99,0,981,1),(5992,93,0,981,50),(5993,142,0,981,176),(5994,97,0,982,1),(5995,134,0,982,2),(5996,115,0,982,1),(5997,99,0,982,1),(5998,93,0,982,53),(5999,142,0,982,176),(6000,97,0,983,1),(6001,134,0,983,2),(6002,115,0,983,1),(6003,99,0,983,1),(6004,93,0,983,49),(6005,142,0,983,177),(6006,97,0,984,1),(6007,134,0,984,2),(6008,115,0,984,1),(6009,99,0,984,1),(6010,93,0,984,50),(6011,142,0,984,177),(6012,97,0,985,1),(6013,134,0,985,2),(6014,115,0,985,1),(6015,99,0,985,1),(6016,93,0,985,53),(6017,142,0,985,177),(6018,97,0,986,1),(6019,134,0,986,2),(6020,115,0,986,1),(6021,99,0,986,1),(6022,93,0,986,49),(6023,142,0,986,178),(6024,97,0,987,1),(6025,134,0,987,2),(6026,115,0,987,1),(6027,99,0,987,1),(6028,93,0,987,50),(6029,142,0,987,178),(6030,97,0,988,1),(6031,134,0,988,2),(6032,115,0,988,1),(6033,99,0,988,1),(6034,93,0,988,53),(6035,142,0,988,178),(6036,97,0,989,1),(6037,134,0,989,2),(6038,115,0,989,1),(6039,99,0,989,4),(6040,143,0,989,0),(6041,144,0,989,1),(6042,145,0,989,0),(6043,146,0,989,0),(6044,147,0,989,0),(6045,97,0,990,1),(6046,134,0,990,2),(6047,115,0,990,1),(6048,99,0,990,1),(6049,93,0,990,50),(6050,142,0,990,175),(6051,97,0,991,1),(6052,134,0,991,2),(6053,115,0,991,1),(6054,99,0,991,1),(6055,93,0,991,53),(6056,142,0,991,175),(6057,97,0,992,1),(6058,134,0,992,2),(6059,115,0,992,1),(6060,99,0,992,1),(6061,93,0,992,57),(6062,142,0,992,175),(6063,97,0,993,1),(6064,134,0,993,2),(6065,115,0,993,1),(6066,99,0,993,1),(6067,93,0,993,50),(6068,142,0,993,176),(6069,97,0,994,1),(6070,134,0,994,2),(6071,115,0,994,1),(6072,99,0,994,1),(6073,93,0,994,53),(6074,142,0,994,176),(6075,97,0,995,1),(6076,134,0,995,2),(6077,115,0,995,1),(6078,99,0,995,1),(6079,93,0,995,57),(6080,142,0,995,176),(6081,97,0,996,1),(6082,134,0,996,2),(6083,115,0,996,1),(6084,99,0,996,1),(6085,93,0,996,50),(6086,142,0,996,177),(6087,97,0,997,1),(6088,134,0,997,2),(6089,115,0,997,1),(6090,99,0,997,1),(6091,93,0,997,53),(6092,142,0,997,177),(6093,97,0,998,1),(6094,134,0,998,2),(6095,115,0,998,1),(6096,99,0,998,1),(6097,93,0,998,57),(6098,142,0,998,177),(6099,97,0,999,1),(6100,134,0,999,2),(6101,115,0,999,1),(6102,99,0,999,1),(6103,93,0,999,50),(6104,142,0,999,178),(6105,97,0,1000,1),(6106,134,0,1000,2),(6107,115,0,1000,1),(6108,99,0,1000,1),(6109,93,0,1000,53),(6110,142,0,1000,178),(6111,97,0,1001,1),(6112,134,0,1001,2),(6113,115,0,1001,1),(6114,99,0,1001,1),(6115,93,0,1001,57),(6116,142,0,1001,178),(6117,97,0,1002,1),(6118,134,0,1002,2),(6119,115,0,1002,1),(6120,99,0,1002,4),(6121,143,0,1002,0),(6122,144,0,1002,0),(6123,145,0,1002,0),(6124,146,0,1002,1),(6125,147,0,1002,0),(6126,97,0,1003,1),(6127,134,0,1003,2),(6128,115,0,1003,1),(6129,99,0,1003,1),(6130,93,0,1003,49),(6131,142,0,1003,175),(6132,97,0,1004,1),(6133,134,0,1004,2),(6134,115,0,1004,1),(6135,99,0,1004,1),(6136,93,0,1004,50),(6137,142,0,1004,175),(6138,97,0,1005,1),(6139,134,0,1005,2),(6140,115,0,1005,1),(6141,99,0,1005,1),(6142,93,0,1005,58),(6143,142,0,1005,175),(6144,97,0,1006,1),(6145,134,0,1006,2),(6146,115,0,1006,1),(6147,99,0,1006,1),(6148,93,0,1006,49),(6149,142,0,1006,176),(6150,97,0,1007,1),(6151,134,0,1007,2),(6152,115,0,1007,1),(6153,99,0,1007,1),(6154,93,0,1007,50),(6155,142,0,1007,176),(6156,97,0,1008,1),(6157,134,0,1008,2),(6158,115,0,1008,1),(6159,99,0,1008,1),(6160,93,0,1008,58),(6161,142,0,1008,176),(6162,97,0,1009,1),(6163,134,0,1009,2),(6164,115,0,1009,1),(6165,99,0,1009,1),(6166,93,0,1009,49),(6167,142,0,1009,177),(6168,97,0,1010,1),(6169,134,0,1010,2),(6170,115,0,1010,1),(6171,99,0,1010,1),(6172,93,0,1010,50),(6173,142,0,1010,177),(6174,97,0,1011,1),(6175,134,0,1011,2),(6176,115,0,1011,1),(6177,99,0,1011,1),(6178,93,0,1011,58),(6179,142,0,1011,177),(6180,97,0,1012,1),(6181,134,0,1012,2),(6182,115,0,1012,1),(6183,99,0,1012,1),(6184,93,0,1012,49),(6185,142,0,1012,178),(6186,97,0,1013,1),(6187,134,0,1013,2),(6188,115,0,1013,1),(6189,99,0,1013,1),(6190,93,0,1013,50),(6191,142,0,1013,178),(6192,97,0,1014,1),(6193,134,0,1014,2),(6194,115,0,1014,1),(6195,99,0,1014,1),(6196,93,0,1014,58),(6197,142,0,1014,178),(6198,97,0,1015,1),(6199,134,0,1015,2),(6200,115,0,1015,1),(6201,99,0,1015,4),(6202,143,0,1015,0),(6203,144,0,1015,0),(6204,145,0,1015,0),(6205,146,0,1015,0),(6206,147,0,1015,0),(6207,97,0,1016,1),(6208,134,0,1016,2),(6209,115,0,1016,1),(6210,99,0,1016,1),(6211,93,0,1016,49),(6212,142,0,1016,175),(6213,97,0,1017,1),(6214,134,0,1017,2),(6215,115,0,1017,1),(6216,99,0,1017,1),(6217,93,0,1017,52),(6218,142,0,1017,175),(6219,97,0,1018,1),(6220,134,0,1018,2),(6221,115,0,1018,1),(6222,99,0,1018,1),(6223,93,0,1018,58),(6224,142,0,1018,175),(6225,97,0,1019,1),(6226,134,0,1019,2),(6227,115,0,1019,1),(6228,99,0,1019,1),(6229,93,0,1019,49),(6230,142,0,1019,176),(6231,97,0,1020,1),(6232,134,0,1020,2),(6233,115,0,1020,1),(6234,99,0,1020,1),(6235,93,0,1020,52),(6236,142,0,1020,176),(6237,97,0,1021,1),(6238,134,0,1021,2),(6239,115,0,1021,1),(6240,99,0,1021,1),(6241,93,0,1021,58),(6242,142,0,1021,176),(6243,97,0,1022,1),(6244,134,0,1022,2),(6245,115,0,1022,1),(6246,99,0,1022,1),(6247,93,0,1022,49),(6248,142,0,1022,177),(6249,97,0,1023,1),(6250,134,0,1023,2),(6251,115,0,1023,1),(6252,99,0,1023,1),(6253,93,0,1023,52),(6254,142,0,1023,177),(6255,97,0,1024,1),(6256,134,0,1024,2),(6257,115,0,1024,1),(6258,99,0,1024,1),(6259,93,0,1024,58),(6260,142,0,1024,177),(6261,97,0,1025,1),(6262,134,0,1025,2),(6263,115,0,1025,1),(6264,99,0,1025,1),(6265,93,0,1025,49),(6266,142,0,1025,178),(6267,97,0,1026,1),(6268,134,0,1026,2),(6269,115,0,1026,1),(6270,99,0,1026,1),(6271,93,0,1026,52),(6272,142,0,1026,178),(6273,97,0,1027,1),(6274,134,0,1027,2),(6275,115,0,1027,1),(6276,99,0,1027,1),(6277,93,0,1027,58),(6278,142,0,1027,178),(6279,97,0,1028,1),(6280,134,0,1028,2),(6281,115,0,1028,1),(6282,99,0,1028,4),(6283,143,0,1028,0),(6284,144,0,1028,0),(6285,145,0,1028,0),(6286,146,0,1028,0),(6287,147,0,1028,1),(6288,97,0,1029,1),(6289,134,0,1029,2),(6290,115,0,1029,1),(6291,99,0,1029,1),(6292,93,0,1029,53),(6293,142,0,1029,166),(6294,97,0,1030,1),(6295,134,0,1030,2),(6296,115,0,1030,1),(6297,99,0,1030,1),(6298,93,0,1030,56),(6299,142,0,1030,166),(6300,97,0,1031,1),(6301,134,0,1031,2),(6302,115,0,1031,1),(6303,99,0,1031,1),(6304,93,0,1031,57),(6305,142,0,1031,166),(6306,97,0,1032,1),(6307,134,0,1032,2),(6308,115,0,1032,1),(6309,99,0,1032,1),(6310,93,0,1032,53),(6311,142,0,1032,167),(6312,97,0,1033,1),(6313,134,0,1033,2),(6314,115,0,1033,1),(6315,99,0,1033,1),(6316,93,0,1033,56),(6317,142,0,1033,167),(6318,97,0,1034,1),(6319,134,0,1034,2),(6320,115,0,1034,1),(6321,99,0,1034,1),(6322,93,0,1034,57),(6323,142,0,1034,167),(6324,97,0,1035,1),(6325,134,0,1035,2),(6326,115,0,1035,1),(6327,99,0,1035,1),(6328,93,0,1035,53),(6329,142,0,1035,168),(6330,97,0,1036,1),(6331,134,0,1036,2),(6332,115,0,1036,1),(6333,99,0,1036,1),(6334,93,0,1036,56),(6335,142,0,1036,168),(6336,97,0,1037,1),(6337,134,0,1037,2),(6338,115,0,1037,1),(6339,99,0,1037,1),(6340,93,0,1037,57),(6341,142,0,1037,168),(6342,97,0,1038,1),(6343,134,0,1038,2),(6344,115,0,1038,1),(6345,99,0,1038,1),(6346,93,0,1038,53),(6347,142,0,1038,169),(6348,97,0,1039,1),(6349,134,0,1039,2),(6350,115,0,1039,1),(6351,99,0,1039,1),(6352,93,0,1039,56),(6353,142,0,1039,169),(6354,97,0,1040,1),(6355,134,0,1040,2),(6356,115,0,1040,1),(6357,99,0,1040,1),(6358,93,0,1040,57),(6359,142,0,1040,169),(6360,97,0,1041,1),(6361,134,0,1041,2),(6362,115,0,1041,1),(6363,99,0,1041,1),(6364,93,0,1041,53),(6365,142,0,1041,170),(6366,97,0,1042,1),(6367,134,0,1042,2),(6368,115,0,1042,1),(6369,99,0,1042,1),(6370,93,0,1042,56),(6371,142,0,1042,170),(6372,97,0,1043,1),(6373,134,0,1043,2),(6374,115,0,1043,1),(6375,99,0,1043,1),(6376,93,0,1043,57),(6377,142,0,1043,170),(6378,97,0,1044,1),(6379,134,0,1044,2),(6380,115,0,1044,1),(6381,99,0,1044,4),(6382,143,0,1044,0),(6383,144,0,1044,0),(6384,145,0,1044,1),(6385,146,0,1044,1),(6386,147,0,1044,0),(6387,97,0,1045,1),(6388,134,0,1045,2),(6389,115,0,1045,1),(6390,99,0,1045,1),(6391,93,0,1045,50),(6392,142,0,1045,166),(6393,97,0,1046,1),(6394,134,0,1046,2),(6395,115,0,1046,1),(6396,99,0,1046,1),(6397,93,0,1046,53),(6398,142,0,1046,166),(6399,97,0,1047,1),(6400,134,0,1047,2),(6401,115,0,1047,1),(6402,99,0,1047,1),(6403,93,0,1047,56),(6404,142,0,1047,166),(6405,97,0,1048,1),(6406,134,0,1048,2),(6407,115,0,1048,1),(6408,99,0,1048,1),(6409,93,0,1048,50),(6410,142,0,1048,167),(6411,97,0,1049,1),(6412,134,0,1049,2),(6413,115,0,1049,1),(6414,99,0,1049,1),(6415,93,0,1049,53),(6416,142,0,1049,167),(6417,97,0,1050,1),(6418,134,0,1050,2),(6419,115,0,1050,1),(6420,99,0,1050,1),(6421,93,0,1050,56),(6422,142,0,1050,167),(6423,97,0,1051,1),(6424,134,0,1051,2),(6425,115,0,1051,1),(6426,99,0,1051,1),(6427,93,0,1051,50),(6428,142,0,1051,168),(6429,97,0,1052,1),(6430,134,0,1052,2),(6431,115,0,1052,1),(6432,99,0,1052,1),(6433,93,0,1052,53),(6434,142,0,1052,168),(6435,97,0,1053,1),(6436,134,0,1053,2),(6437,115,0,1053,1),(6438,99,0,1053,1),(6439,93,0,1053,56),(6440,142,0,1053,168),(6441,97,0,1054,1),(6442,134,0,1054,2),(6443,115,0,1054,1),(6444,99,0,1054,1),(6445,93,0,1054,50),(6446,142,0,1054,169),(6447,97,0,1055,1),(6448,134,0,1055,2),(6449,115,0,1055,1),(6450,99,0,1055,1),(6451,93,0,1055,53),(6452,142,0,1055,169),(6453,97,0,1056,1),(6454,134,0,1056,2),(6455,115,0,1056,1),(6456,99,0,1056,1),(6457,93,0,1056,56),(6458,142,0,1056,169),(6459,97,0,1057,1),(6460,134,0,1057,2),(6461,115,0,1057,1),(6462,99,0,1057,1),(6463,93,0,1057,50),(6464,142,0,1057,170),(6465,97,0,1058,1),(6466,134,0,1058,2),(6467,115,0,1058,1),(6468,99,0,1058,1),(6469,93,0,1058,53),(6470,142,0,1058,170),(6471,97,0,1059,1),(6472,134,0,1059,2),(6473,115,0,1059,1),(6474,99,0,1059,1),(6475,93,0,1059,56),(6476,142,0,1059,170),(6477,97,0,1060,1),(6478,134,0,1060,2),(6479,115,0,1060,1),(6480,99,0,1060,4),(6481,143,0,1060,0),(6482,144,0,1060,0),(6483,145,0,1060,0),(6484,146,0,1060,0),(6485,147,0,1060,1),(6486,97,0,1061,1),(6487,134,0,1061,2),(6488,115,0,1061,1),(6489,99,0,1061,1),(6490,93,0,1061,53),(6491,142,0,1061,166),(6492,97,0,1062,1),(6493,134,0,1062,2),(6494,115,0,1062,1),(6495,99,0,1062,1),(6496,93,0,1062,57),(6497,142,0,1062,166),(6498,97,0,1063,1),(6499,134,0,1063,2),(6500,115,0,1063,1),(6501,99,0,1063,1),(6502,93,0,1063,58),(6503,142,0,1063,166),(6504,97,0,1064,1),(6505,134,0,1064,2),(6506,115,0,1064,1),(6507,99,0,1064,1),(6508,93,0,1064,53),(6509,142,0,1064,167),(6510,97,0,1065,1),(6511,134,0,1065,2),(6512,115,0,1065,1),(6513,99,0,1065,1),(6514,93,0,1065,57),(6515,142,0,1065,167),(6516,97,0,1066,1),(6517,134,0,1066,2),(6518,115,0,1066,1),(6519,99,0,1066,1),(6520,93,0,1066,58),(6521,142,0,1066,167),(6522,97,0,1067,1),(6523,134,0,1067,2),(6524,115,0,1067,1),(6525,99,0,1067,1),(6526,93,0,1067,53),(6527,142,0,1067,168),(6528,97,0,1068,1),(6529,134,0,1068,2),(6530,115,0,1068,1),(6531,99,0,1068,1),(6532,93,0,1068,57),(6533,142,0,1068,168),(6534,97,0,1069,1),(6535,134,0,1069,2),(6536,115,0,1069,1),(6537,99,0,1069,1),(6538,93,0,1069,58),(6539,142,0,1069,168),(6540,97,0,1070,1),(6541,134,0,1070,2),(6542,115,0,1070,1),(6543,99,0,1070,1),(6544,93,0,1070,53),(6545,142,0,1070,169),(6546,97,0,1071,1),(6547,134,0,1071,2),(6548,115,0,1071,1),(6549,99,0,1071,1),(6550,93,0,1071,57),(6551,142,0,1071,169),(6552,97,0,1072,1),(6553,134,0,1072,2),(6554,115,0,1072,1),(6555,99,0,1072,1),(6556,93,0,1072,58),(6557,142,0,1072,169),(6558,97,0,1073,1),(6559,134,0,1073,2),(6560,115,0,1073,1),(6561,99,0,1073,1),(6562,93,0,1073,53),(6563,142,0,1073,170),(6564,97,0,1074,1),(6565,134,0,1074,2),(6566,115,0,1074,1),(6567,99,0,1074,1),(6568,93,0,1074,57),(6569,142,0,1074,170),(6570,97,0,1075,1),(6571,134,0,1075,2),(6572,115,0,1075,1),(6573,99,0,1075,1),(6574,93,0,1075,58),(6575,142,0,1075,170),(6576,97,0,1076,1),(6577,134,0,1076,2),(6578,115,0,1076,1),(6579,99,0,1076,4),(6580,143,0,1076,0),(6581,144,0,1076,0),(6582,145,0,1076,0),(6583,146,0,1076,0),(6584,147,0,1076,0),(6585,97,0,1077,1),(6586,134,0,1077,2),(6587,115,0,1077,1),(6588,99,0,1077,1),(6589,93,0,1077,50),(6590,142,0,1077,166),(6591,97,0,1078,1),(6592,134,0,1078,2),(6593,115,0,1078,1),(6594,99,0,1078,1),(6595,93,0,1078,56),(6596,142,0,1078,166),(6597,97,0,1079,1),(6598,134,0,1079,2),(6599,115,0,1079,1),(6600,99,0,1079,1),(6601,93,0,1079,57),(6602,142,0,1079,166),(6603,97,0,1080,1),(6604,134,0,1080,2),(6605,115,0,1080,1),(6606,99,0,1080,1),(6607,93,0,1080,50),(6608,142,0,1080,167),(6609,97,0,1081,1),(6610,134,0,1081,2),(6611,115,0,1081,1),(6612,99,0,1081,1),(6613,93,0,1081,56),(6614,142,0,1081,167),(6615,97,0,1082,1),(6616,134,0,1082,2),(6617,115,0,1082,1),(6618,99,0,1082,1),(6619,93,0,1082,57),(6620,142,0,1082,167),(6621,97,0,1083,1),(6622,134,0,1083,2),(6623,115,0,1083,1),(6624,99,0,1083,1),(6625,93,0,1083,50),(6626,142,0,1083,168),(6627,97,0,1084,1),(6628,134,0,1084,2),(6629,115,0,1084,1),(6630,99,0,1084,1),(6631,93,0,1084,56),(6632,142,0,1084,168),(6633,97,0,1085,1),(6634,134,0,1085,2),(6635,115,0,1085,1),(6636,99,0,1085,1),(6637,93,0,1085,57),(6638,142,0,1085,168),(6639,97,0,1086,1),(6640,134,0,1086,2),(6641,115,0,1086,1),(6642,99,0,1086,1),(6643,93,0,1086,50),(6644,142,0,1086,169),(6645,97,0,1087,1),(6646,134,0,1087,2),(6647,115,0,1087,1),(6648,99,0,1087,1),(6649,93,0,1087,56),(6650,142,0,1087,169),(6651,97,0,1088,1),(6652,134,0,1088,2),(6653,115,0,1088,1),(6654,99,0,1088,1),(6655,93,0,1088,57),(6656,142,0,1088,169),(6657,97,0,1089,1),(6658,134,0,1089,2),(6659,115,0,1089,1),(6660,99,0,1089,1),(6661,93,0,1089,50),(6662,142,0,1089,170),(6663,97,0,1090,1),(6664,134,0,1090,2),(6665,115,0,1090,1),(6666,99,0,1090,1),(6667,93,0,1090,56),(6668,142,0,1090,170),(6669,97,0,1091,1),(6670,134,0,1091,2),(6671,115,0,1091,1),(6672,99,0,1091,1),(6673,93,0,1091,57),(6674,142,0,1091,170),(6675,97,0,1092,1),(6676,134,0,1092,2),(6677,115,0,1092,1),(6678,99,0,1092,4),(6679,143,0,1092,0),(6680,144,0,1092,0),(6681,145,0,1092,0),(6682,146,0,1092,0),(6683,147,0,1092,0),(6684,97,0,1093,1),(6685,134,0,1093,2),(6686,115,0,1093,1),(6687,99,0,1093,1),(6688,93,0,1093,56),(6689,142,0,1093,166),(6690,97,0,1094,1),(6691,134,0,1094,2),(6692,115,0,1094,1),(6693,99,0,1094,1),(6694,93,0,1094,57),(6695,142,0,1094,166),(6696,97,0,1095,1),(6697,134,0,1095,2),(6698,115,0,1095,1),(6699,99,0,1095,1),(6700,93,0,1095,59),(6701,142,0,1095,166),(6702,97,0,1096,1),(6703,134,0,1096,2),(6704,115,0,1096,1),(6705,99,0,1096,1),(6706,93,0,1096,56),(6707,142,0,1096,167),(6708,97,0,1097,1),(6709,134,0,1097,2),(6710,115,0,1097,1),(6711,99,0,1097,1),(6712,93,0,1097,57),(6713,142,0,1097,167),(6714,97,0,1098,1),(6715,134,0,1098,2),(6716,115,0,1098,1),(6717,99,0,1098,1),(6718,93,0,1098,59),(6719,142,0,1098,167),(6720,97,0,1099,1),(6721,134,0,1099,2),(6722,115,0,1099,1),(6723,99,0,1099,1),(6724,93,0,1099,56),(6725,142,0,1099,168),(6726,97,0,1100,1),(6727,134,0,1100,2),(6728,115,0,1100,1),(6729,99,0,1100,1),(6730,93,0,1100,57),(6731,142,0,1100,168),(6732,97,0,1101,1),(6733,134,0,1101,2),(6734,115,0,1101,1),(6735,99,0,1101,1),(6736,93,0,1101,59),(6737,142,0,1101,168),(6738,97,0,1102,1),(6739,134,0,1102,2),(6740,115,0,1102,1),(6741,99,0,1102,1),(6742,93,0,1102,56),(6743,142,0,1102,169),(6744,97,0,1103,1),(6745,134,0,1103,2),(6746,115,0,1103,1),(6747,99,0,1103,1),(6748,93,0,1103,57),(6749,142,0,1103,169),(6750,97,0,1104,1),(6751,134,0,1104,2),(6752,115,0,1104,1),(6753,99,0,1104,1),(6754,93,0,1104,59),(6755,142,0,1104,169),(6756,97,0,1105,1),(6757,134,0,1105,2),(6758,115,0,1105,1),(6759,99,0,1105,1),(6760,93,0,1105,56),(6761,142,0,1105,170),(6762,97,0,1106,1),(6763,134,0,1106,2),(6764,115,0,1106,1),(6765,99,0,1106,1),(6766,93,0,1106,57),(6767,142,0,1106,170),(6768,97,0,1107,1),(6769,134,0,1107,2),(6770,115,0,1107,1),(6771,99,0,1107,1),(6772,93,0,1107,59),(6773,142,0,1107,170),(6774,97,0,1108,1),(6775,134,0,1108,2),(6776,115,0,1108,1),(6777,99,0,1108,4),(6778,143,0,1108,0),(6779,144,0,1108,0),(6780,145,0,1108,0),(6781,146,0,1108,0),(6782,147,0,1108,0),(6783,97,0,1109,1),(6784,134,0,1109,2),(6785,115,0,1109,1),(6786,99,0,1109,1),(6787,93,0,1109,57),(6788,142,0,1109,166),(6789,97,0,1110,1),(6790,134,0,1110,2),(6791,115,0,1110,1),(6792,99,0,1110,1),(6793,93,0,1110,57),(6794,142,0,1110,167),(6795,97,0,1111,1),(6796,134,0,1111,2),(6797,115,0,1111,1),(6798,99,0,1111,1),(6799,93,0,1111,57),(6800,142,0,1111,168),(6801,97,0,1112,1),(6802,134,0,1112,2),(6803,115,0,1112,1),(6804,99,0,1112,1),(6805,93,0,1112,57),(6806,142,0,1112,169),(6807,97,0,1113,1),(6808,134,0,1113,2),(6809,115,0,1113,1),(6810,99,0,1113,1),(6811,93,0,1113,57),(6812,142,0,1113,170),(6813,97,0,1114,1),(6814,134,0,1114,2),(6815,115,0,1114,1),(6816,99,0,1114,4),(6817,143,0,1114,0),(6818,144,0,1114,0),(6819,145,0,1114,0),(6820,146,0,1114,0),(6821,147,0,1114,0),(6822,97,0,1115,1),(6823,134,0,1115,2),(6824,115,0,1115,1),(6825,99,0,1115,1),(6826,93,0,1115,52),(6827,142,0,1115,166),(6828,97,0,1116,1),(6829,134,0,1116,2),(6830,115,0,1116,1),(6831,99,0,1116,1),(6832,93,0,1116,57),(6833,142,0,1116,166),(6834,97,0,1117,1),(6835,134,0,1117,2),(6836,115,0,1117,1),(6837,99,0,1117,1),(6838,93,0,1117,59),(6839,142,0,1117,166),(6840,97,0,1118,1),(6841,134,0,1118,2),(6842,115,0,1118,1),(6843,99,0,1118,1),(6844,93,0,1118,52),(6845,142,0,1118,167),(6846,97,0,1119,1),(6847,134,0,1119,2),(6848,115,0,1119,1),(6849,99,0,1119,1),(6850,93,0,1119,57),(6851,142,0,1119,167),(6852,97,0,1120,1),(6853,134,0,1120,2),(6854,115,0,1120,1),(6855,99,0,1120,1),(6856,93,0,1120,59),(6857,142,0,1120,167),(6858,97,0,1121,1),(6859,134,0,1121,2),(6860,115,0,1121,1),(6861,99,0,1121,1),(6862,93,0,1121,52),(6863,142,0,1121,168),(6864,97,0,1122,1),(6865,134,0,1122,2),(6866,115,0,1122,1),(6867,99,0,1122,1),(6868,93,0,1122,57),(6869,142,0,1122,168),(6870,97,0,1123,1),(6871,134,0,1123,2),(6872,115,0,1123,1),(6873,99,0,1123,1),(6874,93,0,1123,59),(6875,142,0,1123,168),(6876,97,0,1124,1),(6877,134,0,1124,2),(6878,115,0,1124,1),(6879,99,0,1124,1),(6880,93,0,1124,52),(6881,142,0,1124,169),(6882,97,0,1125,1),(6883,134,0,1125,2),(6884,115,0,1125,1),(6885,99,0,1125,1),(6886,93,0,1125,57),(6887,142,0,1125,169),(6888,97,0,1126,1),(6889,134,0,1126,2),(6890,115,0,1126,1),(6891,99,0,1126,1),(6892,93,0,1126,59),(6893,142,0,1126,169),(6894,97,0,1127,1),(6895,134,0,1127,2),(6896,115,0,1127,1),(6897,99,0,1127,1),(6898,93,0,1127,52),(6899,142,0,1127,170),(6900,97,0,1128,1),(6901,134,0,1128,2),(6902,115,0,1128,1),(6903,99,0,1128,1),(6904,93,0,1128,57),(6905,142,0,1128,170),(6906,97,0,1129,1),(6907,134,0,1129,2),(6908,115,0,1129,1),(6909,99,0,1129,1),(6910,93,0,1129,59),(6911,142,0,1129,170),(6912,97,0,1130,1),(6913,134,0,1130,2),(6914,115,0,1130,1),(6915,99,0,1130,4),(6916,143,0,1130,0),(6917,144,0,1130,0),(6918,145,0,1130,1),(6919,146,0,1130,1),(6920,147,0,1130,0),(6921,97,0,1131,1),(6922,134,0,1131,2),(6923,115,0,1131,1),(6924,99,0,1131,1),(6925,93,0,1131,56),(6926,142,0,1131,166),(6927,97,0,1132,1),(6928,134,0,1132,2),(6929,115,0,1132,1),(6930,99,0,1132,1),(6931,93,0,1132,57),(6932,142,0,1132,166),(6933,97,0,1133,1),(6934,134,0,1133,2),(6935,115,0,1133,1),(6936,99,0,1133,1),(6937,93,0,1133,59),(6938,142,0,1133,166),(6939,97,0,1134,1),(6940,134,0,1134,2),(6941,115,0,1134,1),(6942,99,0,1134,1),(6943,93,0,1134,56),(6944,142,0,1134,167),(6945,97,0,1135,1),(6946,134,0,1135,2),(6947,115,0,1135,1),(6948,99,0,1135,1),(6949,93,0,1135,57),(6950,142,0,1135,167),(6951,97,0,1136,1),(6952,134,0,1136,2),(6953,115,0,1136,1),(6954,99,0,1136,1),(6955,93,0,1136,59),(6956,142,0,1136,167),(6957,97,0,1137,1),(6958,134,0,1137,2),(6959,115,0,1137,1),(6960,99,0,1137,1),(6961,93,0,1137,56),(6962,142,0,1137,168),(6963,97,0,1138,1),(6964,134,0,1138,2),(6965,115,0,1138,1),(6966,99,0,1138,1),(6967,93,0,1138,57),(6968,142,0,1138,168),(6969,97,0,1139,1),(6970,134,0,1139,2),(6971,115,0,1139,1),(6972,99,0,1139,1),(6973,93,0,1139,59),(6974,142,0,1139,168),(6975,97,0,1140,1),(6976,134,0,1140,2),(6977,115,0,1140,1),(6978,99,0,1140,1),(6979,93,0,1140,56),(6980,142,0,1140,169),(6981,97,0,1141,1),(6982,134,0,1141,2),(6983,115,0,1141,1),(6984,99,0,1141,1),(6985,93,0,1141,57),(6986,142,0,1141,169),(6987,97,0,1142,1),(6988,134,0,1142,2),(6989,115,0,1142,1),(6990,99,0,1142,1),(6991,93,0,1142,59),(6992,142,0,1142,169),(6993,97,0,1143,1),(6994,134,0,1143,2),(6995,115,0,1143,1),(6996,99,0,1143,1),(6997,93,0,1143,56),(6998,142,0,1143,170),(6999,97,0,1144,1),(7000,134,0,1144,2),(7001,115,0,1144,1),(7002,99,0,1144,1),(7003,93,0,1144,57),(7004,142,0,1144,170),(7005,97,0,1145,1),(7006,134,0,1145,2),(7007,115,0,1145,1),(7008,99,0,1145,1),(7009,93,0,1145,59),(7010,142,0,1145,170),(7011,97,0,1146,1),(7012,134,0,1146,2),(7013,115,0,1146,1),(7014,99,0,1146,4),(7015,143,0,1146,0),(7016,144,0,1146,1),(7017,145,0,1146,0),(7018,146,0,1146,0),(7019,147,0,1146,1),(7020,97,0,1147,1),(7021,134,0,1147,2),(7022,115,0,1147,1),(7023,99,0,1147,1),(7024,93,0,1147,53),(7025,142,0,1147,166),(7026,97,0,1148,1),(7027,134,0,1148,2),(7028,115,0,1148,1),(7029,99,0,1148,1),(7030,93,0,1148,57),(7031,142,0,1148,166),(7032,97,0,1149,1),(7033,134,0,1149,2),(7034,115,0,1149,1),(7035,99,0,1149,1),(7036,93,0,1149,58),(7037,142,0,1149,166),(7038,97,0,1150,1),(7039,134,0,1150,2),(7040,115,0,1150,1),(7041,99,0,1150,1),(7042,93,0,1150,53),(7043,142,0,1150,167),(7044,97,0,1151,1),(7045,134,0,1151,2),(7046,115,0,1151,1),(7047,99,0,1151,1),(7048,93,0,1151,57),(7049,142,0,1151,167),(7050,97,0,1152,1),(7051,134,0,1152,2),(7052,115,0,1152,1),(7053,99,0,1152,1),(7054,93,0,1152,58),(7055,142,0,1152,167),(7056,97,0,1153,1),(7057,134,0,1153,2),(7058,115,0,1153,1),(7059,99,0,1153,1),(7060,93,0,1153,53),(7061,142,0,1153,168),(7062,97,0,1154,1),(7063,134,0,1154,2),(7064,115,0,1154,1),(7065,99,0,1154,1),(7066,93,0,1154,57),(7067,142,0,1154,168),(7068,97,0,1155,1),(7069,134,0,1155,2),(7070,115,0,1155,1),(7071,99,0,1155,1),(7072,93,0,1155,58),(7073,142,0,1155,168),(7074,97,0,1156,1),(7075,134,0,1156,2),(7076,115,0,1156,1),(7077,99,0,1156,1),(7078,93,0,1156,53),(7079,142,0,1156,169),(7080,97,0,1157,1),(7081,134,0,1157,2),(7082,115,0,1157,1),(7083,99,0,1157,1),(7084,93,0,1157,57),(7085,142,0,1157,169),(7086,97,0,1158,1),(7087,134,0,1158,2),(7088,115,0,1158,1),(7089,99,0,1158,1),(7090,93,0,1158,58),(7091,142,0,1158,169),(7092,97,0,1159,1),(7093,134,0,1159,2),(7094,115,0,1159,1),(7095,99,0,1159,1),(7096,93,0,1159,53),(7097,142,0,1159,170),(7098,97,0,1160,1),(7099,134,0,1160,2),(7100,115,0,1160,1),(7101,99,0,1160,1),(7102,93,0,1160,57),(7103,142,0,1160,170),(7104,97,0,1161,1),(7105,134,0,1161,2),(7106,115,0,1161,1),(7107,99,0,1161,1),(7108,93,0,1161,58),(7109,142,0,1161,170),(7110,97,0,1162,1),(7111,134,0,1162,2),(7112,115,0,1162,1),(7113,99,0,1162,4),(7114,143,0,1162,1),(7115,144,0,1162,0),(7116,145,0,1162,0),(7117,146,0,1162,0),(7118,147,0,1162,0),(7119,97,0,1163,1),(7120,134,0,1163,2),(7121,115,0,1163,1),(7122,99,0,1163,1),(7123,93,0,1163,50),(7124,142,0,1163,166),(7125,97,0,1164,1),(7126,134,0,1164,2),(7127,115,0,1164,1),(7128,99,0,1164,1),(7129,93,0,1164,52),(7130,142,0,1164,166),(7131,97,0,1165,1),(7132,134,0,1165,2),(7133,115,0,1165,1),(7134,99,0,1165,1),(7135,93,0,1165,60),(7136,142,0,1165,166),(7137,97,0,1166,1),(7138,134,0,1166,2),(7139,115,0,1166,1),(7140,99,0,1166,1),(7141,93,0,1166,50),(7142,142,0,1166,167),(7143,97,0,1167,1),(7144,134,0,1167,2),(7145,115,0,1167,1),(7146,99,0,1167,1),(7147,93,0,1167,52),(7148,142,0,1167,167),(7149,97,0,1168,1),(7150,134,0,1168,2),(7151,115,0,1168,1),(7152,99,0,1168,1),(7153,93,0,1168,60),(7154,142,0,1168,167),(7155,97,0,1169,1),(7156,134,0,1169,2),(7157,115,0,1169,1),(7158,99,0,1169,1),(7159,93,0,1169,50),(7160,142,0,1169,168),(7161,97,0,1170,1),(7162,134,0,1170,2),(7163,115,0,1170,1),(7164,99,0,1170,1),(7165,93,0,1170,52),(7166,142,0,1170,168),(7167,97,0,1171,1),(7168,134,0,1171,2),(7169,115,0,1171,1),(7170,99,0,1171,1),(7171,93,0,1171,60),(7172,142,0,1171,168),(7173,97,0,1172,1),(7174,134,0,1172,2),(7175,115,0,1172,1),(7176,99,0,1172,1),(7177,93,0,1172,50),(7178,142,0,1172,169),(7179,97,0,1173,1),(7180,134,0,1173,2),(7181,115,0,1173,1),(7182,99,0,1173,1),(7183,93,0,1173,52),(7184,142,0,1173,169),(7185,97,0,1174,1),(7186,134,0,1174,2),(7187,115,0,1174,1),(7188,99,0,1174,1),(7189,93,0,1174,60),(7190,142,0,1174,169),(7191,97,0,1175,1),(7192,134,0,1175,2),(7193,115,0,1175,1),(7194,99,0,1175,1),(7195,93,0,1175,50),(7196,142,0,1175,170),(7197,97,0,1176,1),(7198,134,0,1176,2),(7199,115,0,1176,1),(7200,99,0,1176,1),(7201,93,0,1176,52),(7202,142,0,1176,170),(7203,97,0,1177,1),(7204,134,0,1177,2),(7205,115,0,1177,1),(7206,99,0,1177,1),(7207,93,0,1177,60),(7208,142,0,1177,170),(7209,97,0,1178,1),(7210,134,0,1178,2),(7211,115,0,1178,1),(7212,99,0,1178,4),(7213,143,0,1178,0),(7214,144,0,1178,0),(7215,145,0,1178,0),(7216,146,0,1178,1),(7217,147,0,1178,0),(7218,97,0,1179,1),(7219,134,0,1179,2),(7220,115,0,1179,1),(7221,99,0,1179,1),(7222,93,0,1179,50),(7223,142,0,1179,166),(7224,97,0,1180,1),(7225,134,0,1180,2),(7226,115,0,1180,1),(7227,99,0,1180,1),(7228,93,0,1180,53),(7229,142,0,1180,166),(7230,97,0,1181,1),(7231,134,0,1181,2),(7232,115,0,1181,1),(7233,99,0,1181,1),(7234,93,0,1181,56),(7235,142,0,1181,166),(7236,97,0,1182,1),(7237,134,0,1182,2),(7238,115,0,1182,1),(7239,99,0,1182,1),(7240,93,0,1182,50),(7241,142,0,1182,167),(7242,97,0,1183,1),(7243,134,0,1183,2),(7244,115,0,1183,1),(7245,99,0,1183,1),(7246,93,0,1183,53),(7247,142,0,1183,167),(7248,97,0,1184,1),(7249,134,0,1184,2),(7250,115,0,1184,1),(7251,99,0,1184,1),(7252,93,0,1184,56),(7253,142,0,1184,167),(7254,97,0,1185,1),(7255,134,0,1185,2),(7256,115,0,1185,1),(7257,99,0,1185,1),(7258,93,0,1185,50),(7259,142,0,1185,168),(7260,97,0,1186,1),(7261,134,0,1186,2),(7262,115,0,1186,1),(7263,99,0,1186,1),(7264,93,0,1186,53),(7265,142,0,1186,168),(7266,97,0,1187,1),(7267,134,0,1187,2),(7268,115,0,1187,1),(7269,99,0,1187,1),(7270,93,0,1187,56),(7271,142,0,1187,168),(7272,97,0,1188,1),(7273,134,0,1188,2),(7274,115,0,1188,1),(7275,99,0,1188,1),(7276,93,0,1188,50),(7277,142,0,1188,169),(7278,97,0,1189,1),(7279,134,0,1189,2),(7280,115,0,1189,1),(7281,99,0,1189,1),(7282,93,0,1189,53),(7283,142,0,1189,169),(7284,97,0,1190,1),(7285,134,0,1190,2),(7286,115,0,1190,1),(7287,99,0,1190,1),(7288,93,0,1190,56),(7289,142,0,1190,169),(7290,97,0,1191,1),(7291,134,0,1191,2),(7292,115,0,1191,1),(7293,99,0,1191,1),(7294,93,0,1191,50),(7295,142,0,1191,170),(7296,97,0,1192,1),(7297,134,0,1192,2),(7298,115,0,1192,1),(7299,99,0,1192,1),(7300,93,0,1192,53),(7301,142,0,1192,170),(7302,97,0,1193,1),(7303,134,0,1193,2),(7304,115,0,1193,1),(7305,99,0,1193,1),(7306,93,0,1193,56),(7307,142,0,1193,170),(7308,97,0,1194,1),(7309,134,0,1194,2),(7310,115,0,1194,1),(7311,99,0,1194,4),(7312,143,0,1194,0),(7313,144,0,1194,0),(7314,145,0,1194,1),(7315,146,0,1194,0),(7316,147,0,1194,0),(7317,97,0,1195,1),(7318,134,0,1195,2),(7319,115,0,1195,1),(7320,99,0,1195,1),(7321,93,0,1195,52),(7322,142,0,1195,166),(7323,97,0,1196,1),(7324,134,0,1196,2),(7325,115,0,1196,1),(7326,99,0,1196,1),(7327,93,0,1196,53),(7328,142,0,1196,166),(7329,97,0,1197,1),(7330,134,0,1197,2),(7331,115,0,1197,1),(7332,99,0,1197,1),(7333,93,0,1197,57),(7334,142,0,1197,166),(7335,97,0,1198,1),(7336,134,0,1198,2),(7337,115,0,1198,1),(7338,99,0,1198,1),(7339,93,0,1198,52),(7340,142,0,1198,167),(7341,97,0,1199,1),(7342,134,0,1199,2),(7343,115,0,1199,1),(7344,99,0,1199,1),(7345,93,0,1199,53),(7346,142,0,1199,167),(7347,97,0,1200,1),(7348,134,0,1200,2),(7349,115,0,1200,1),(7350,99,0,1200,1),(7351,93,0,1200,57),(7352,142,0,1200,167),(7353,97,0,1201,1),(7354,134,0,1201,2),(7355,115,0,1201,1),(7356,99,0,1201,1),(7357,93,0,1201,52),(7358,142,0,1201,168),(7359,97,0,1202,1),(7360,134,0,1202,2),(7361,115,0,1202,1),(7362,99,0,1202,1),(7363,93,0,1202,53),(7364,142,0,1202,168),(7365,97,0,1203,1),(7366,134,0,1203,2),(7367,115,0,1203,1),(7368,99,0,1203,1),(7369,93,0,1203,57),(7370,142,0,1203,168),(7371,97,0,1204,1),(7372,134,0,1204,2),(7373,115,0,1204,1),(7374,99,0,1204,1),(7375,93,0,1204,52),(7376,142,0,1204,169),(7377,97,0,1205,1),(7378,134,0,1205,2),(7379,115,0,1205,1),(7380,99,0,1205,1),(7381,93,0,1205,53),(7382,142,0,1205,169),(7383,97,0,1206,1),(7384,134,0,1206,2),(7385,115,0,1206,1),(7386,99,0,1206,1),(7387,93,0,1206,57),(7388,142,0,1206,169),(7389,97,0,1207,1),(7390,134,0,1207,2),(7391,115,0,1207,1),(7392,99,0,1207,1),(7393,93,0,1207,52),(7394,142,0,1207,170),(7395,97,0,1208,1),(7396,134,0,1208,2),(7397,115,0,1208,1),(7398,99,0,1208,1),(7399,93,0,1208,53),(7400,142,0,1208,170),(7401,97,0,1209,1),(7402,134,0,1209,2),(7403,115,0,1209,1),(7404,99,0,1209,1),(7405,93,0,1209,57),(7406,142,0,1209,170),(7407,97,0,1210,1),(7408,134,0,1210,2),(7409,115,0,1210,1),(7410,99,0,1210,4),(7411,143,0,1210,1),(7412,144,0,1210,1),(7413,145,0,1210,0),(7414,146,0,1210,0),(7415,147,0,1210,0),(7416,97,0,1211,1),(7417,134,0,1211,2),(7418,115,0,1211,1),(7419,99,0,1211,1),(7420,93,0,1211,50),(7421,142,0,1211,167),(7422,97,0,1212,1),(7423,134,0,1212,2),(7424,115,0,1212,1),(7425,99,0,1212,1),(7426,93,0,1212,58),(7427,142,0,1212,167),(7428,97,0,1213,1),(7429,134,0,1213,2),(7430,115,0,1213,1),(7431,99,0,1213,1),(7432,93,0,1213,60),(7433,142,0,1213,167),(7434,97,0,1214,1),(7435,134,0,1214,2),(7436,115,0,1214,1),(7437,99,0,1214,1),(7438,93,0,1214,50),(7439,142,0,1214,168),(7440,97,0,1215,1),(7441,134,0,1215,2),(7442,115,0,1215,1),(7443,99,0,1215,1),(7444,93,0,1215,58),(7445,142,0,1215,168),(7446,97,0,1216,1),(7447,134,0,1216,2),(7448,115,0,1216,1),(7449,99,0,1216,1),(7450,93,0,1216,60),(7451,142,0,1216,168),(7452,97,0,1217,1),(7453,134,0,1217,2),(7454,115,0,1217,1),(7455,99,0,1217,1),(7456,93,0,1217,50),(7457,142,0,1217,169),(7458,97,0,1218,1),(7459,134,0,1218,2),(7460,115,0,1218,1),(7461,99,0,1218,1),(7462,93,0,1218,58),(7463,142,0,1218,169),(7464,97,0,1219,1),(7465,134,0,1219,2),(7466,115,0,1219,1),(7467,99,0,1219,1),(7468,93,0,1219,60),(7469,142,0,1219,169),(7470,97,0,1220,1),(7471,134,0,1220,2),(7472,115,0,1220,1),(7473,99,0,1220,4),(7474,143,0,1220,1),(7475,144,0,1220,0),(7476,145,0,1220,1),(7477,146,0,1220,1),(7478,147,0,1220,0),(7479,97,0,1221,1),(7480,134,0,1221,2),(7481,115,0,1221,1),(7482,99,0,1221,1),(7483,93,0,1221,49),(7484,142,0,1221,166),(7485,97,0,1222,1),(7486,134,0,1222,2),(7487,115,0,1222,1),(7488,99,0,1222,1),(7489,93,0,1222,50),(7490,142,0,1222,166),(7491,97,0,1223,1),(7492,134,0,1223,2),(7493,115,0,1223,1),(7494,99,0,1223,1),(7495,93,0,1223,52),(7496,142,0,1223,166),(7497,97,0,1224,1),(7498,134,0,1224,2),(7499,115,0,1224,1),(7500,99,0,1224,1),(7501,93,0,1224,49),(7502,142,0,1224,167),(7503,97,0,1225,1),(7504,134,0,1225,2),(7505,115,0,1225,1),(7506,99,0,1225,1),(7507,93,0,1225,50),(7508,142,0,1225,167),(7509,97,0,1226,1),(7510,134,0,1226,2),(7511,115,0,1226,1),(7512,99,0,1226,1),(7513,93,0,1226,52),(7514,142,0,1226,167),(7515,97,0,1227,1),(7516,134,0,1227,2),(7517,115,0,1227,1),(7518,99,0,1227,1),(7519,93,0,1227,49),(7520,142,0,1227,168),(7521,97,0,1228,1),(7522,134,0,1228,2),(7523,115,0,1228,1),(7524,99,0,1228,1),(7525,93,0,1228,50),(7526,142,0,1228,168),(7527,97,0,1229,1),(7528,134,0,1229,2),(7529,115,0,1229,1),(7530,99,0,1229,1),(7531,93,0,1229,52),(7532,142,0,1229,168),(7533,97,0,1230,1),(7534,134,0,1230,2),(7535,115,0,1230,1),(7536,99,0,1230,1),(7537,93,0,1230,49),(7538,142,0,1230,169),(7539,97,0,1231,1),(7540,134,0,1231,2),(7541,115,0,1231,1),(7542,99,0,1231,1),(7543,93,0,1231,50),(7544,142,0,1231,169),(7545,97,0,1232,1),(7546,134,0,1232,2),(7547,115,0,1232,1),(7548,99,0,1232,1),(7549,93,0,1232,52),(7550,142,0,1232,169),(7551,97,0,1233,1),(7552,134,0,1233,2),(7553,115,0,1233,1),(7554,99,0,1233,1),(7555,93,0,1233,49),(7556,142,0,1233,170),(7557,97,0,1234,1),(7558,134,0,1234,2),(7559,115,0,1234,1),(7560,99,0,1234,1),(7561,93,0,1234,50),(7562,142,0,1234,170),(7563,97,0,1235,1),(7564,134,0,1235,2),(7565,115,0,1235,1),(7566,99,0,1235,1),(7567,93,0,1235,52),(7568,142,0,1235,170),(7569,97,0,1236,1),(7570,134,0,1236,2),(7571,115,0,1236,1),(7572,99,0,1236,4),(7573,143,0,1236,0),(7574,144,0,1236,0),(7575,145,0,1236,0),(7576,146,0,1236,0),(7577,147,0,1236,1),(7578,97,0,1237,1),(7579,134,0,1237,2),(7580,115,0,1237,1),(7581,99,0,1237,1),(7582,93,0,1237,50),(7583,142,0,1237,166),(7584,97,0,1238,1),(7585,134,0,1238,2),(7586,115,0,1238,1),(7587,99,0,1238,1),(7588,93,0,1238,56),(7589,142,0,1238,166),(7590,97,0,1239,1),(7591,134,0,1239,2),(7592,115,0,1239,1),(7593,99,0,1239,1),(7594,93,0,1239,58),(7595,142,0,1239,166),(7596,97,0,1240,1),(7597,134,0,1240,2),(7598,115,0,1240,1),(7599,99,0,1240,1),(7600,93,0,1240,50),(7601,142,0,1240,167),(7602,97,0,1241,1),(7603,134,0,1241,2),(7604,115,0,1241,1),(7605,99,0,1241,1),(7606,93,0,1241,56),(7607,142,0,1241,167),(7608,97,0,1242,1),(7609,134,0,1242,2),(7610,115,0,1242,1),(7611,99,0,1242,1),(7612,93,0,1242,58),(7613,142,0,1242,167),(7614,97,0,1243,1),(7615,134,0,1243,2),(7616,115,0,1243,1),(7617,99,0,1243,1),(7618,93,0,1243,50),(7619,142,0,1243,168),(7620,97,0,1244,1),(7621,134,0,1244,2),(7622,115,0,1244,1),(7623,99,0,1244,1),(7624,93,0,1244,56),(7625,142,0,1244,168),(7626,97,0,1245,1),(7627,134,0,1245,2),(7628,115,0,1245,1),(7629,99,0,1245,1),(7630,93,0,1245,58),(7631,142,0,1245,168),(7632,97,0,1246,1),(7633,134,0,1246,2),(7634,115,0,1246,1),(7635,99,0,1246,1),(7636,93,0,1246,50),(7637,142,0,1246,169),(7638,97,0,1247,1),(7639,134,0,1247,2),(7640,115,0,1247,1),(7641,99,0,1247,1),(7642,93,0,1247,56),(7643,142,0,1247,169),(7644,97,0,1248,1),(7645,134,0,1248,2),(7646,115,0,1248,1),(7647,99,0,1248,1),(7648,93,0,1248,58),(7649,142,0,1248,169),(7650,97,0,1249,1),(7651,134,0,1249,2),(7652,115,0,1249,1),(7653,99,0,1249,1),(7654,93,0,1249,50),(7655,142,0,1249,170),(7656,97,0,1250,1),(7657,134,0,1250,2),(7658,115,0,1250,1),(7659,99,0,1250,1),(7660,93,0,1250,56),(7661,142,0,1250,170),(7662,97,0,1251,1),(7663,134,0,1251,2),(7664,115,0,1251,1),(7665,99,0,1251,1),(7666,93,0,1251,58),(7667,142,0,1251,170),(7668,97,0,1252,1),(7669,134,0,1252,2),(7670,115,0,1252,1),(7671,99,0,1252,4),(7672,143,0,1252,0),(7673,144,0,1252,0),(7674,145,0,1252,0),(7675,146,0,1252,0),(7676,147,0,1252,0),(7677,97,0,1253,1),(7678,134,0,1253,2),(7679,115,0,1253,1),(7680,99,0,1253,1),(7681,93,0,1253,56),(7682,142,0,1253,166),(7683,97,0,1254,1),(7684,134,0,1254,2),(7685,115,0,1254,1),(7686,99,0,1254,1),(7687,93,0,1254,58),(7688,142,0,1254,166),(7689,97,0,1255,1),(7690,134,0,1255,2),(7691,115,0,1255,1),(7692,99,0,1255,1),(7693,93,0,1255,59),(7694,142,0,1255,166),(7695,97,0,1256,1),(7696,134,0,1256,2),(7697,115,0,1256,1),(7698,99,0,1256,1),(7699,93,0,1256,56),(7700,142,0,1256,167),(7701,97,0,1257,1),(7702,134,0,1257,2),(7703,115,0,1257,1),(7704,99,0,1257,1),(7705,93,0,1257,58),(7706,142,0,1257,167),(7707,97,0,1258,1),(7708,134,0,1258,2),(7709,115,0,1258,1),(7710,99,0,1258,1),(7711,93,0,1258,59),(7712,142,0,1258,167),(7713,97,0,1259,1),(7714,134,0,1259,2),(7715,115,0,1259,1),(7716,99,0,1259,1),(7717,93,0,1259,56),(7718,142,0,1259,168),(7719,97,0,1260,1),(7720,134,0,1260,2),(7721,115,0,1260,1),(7722,99,0,1260,1),(7723,93,0,1260,58),(7724,142,0,1260,168),(7725,97,0,1261,1),(7726,134,0,1261,2),(7727,115,0,1261,1),(7728,99,0,1261,1),(7729,93,0,1261,59),(7730,142,0,1261,168),(7731,97,0,1262,1),(7732,134,0,1262,2),(7733,115,0,1262,1),(7734,99,0,1262,1),(7735,93,0,1262,56),(7736,142,0,1262,169),(7737,97,0,1263,1),(7738,134,0,1263,2),(7739,115,0,1263,1),(7740,99,0,1263,1),(7741,93,0,1263,58),(7742,142,0,1263,169),(7743,97,0,1264,1),(7744,134,0,1264,2),(7745,115,0,1264,1),(7746,99,0,1264,1),(7747,93,0,1264,59),(7748,142,0,1264,169),(7749,97,0,1265,1),(7750,134,0,1265,2),(7751,115,0,1265,1),(7752,99,0,1265,1),(7753,93,0,1265,56),(7754,142,0,1265,170),(7755,97,0,1266,1),(7756,134,0,1266,2),(7757,115,0,1266,1),(7758,99,0,1266,1),(7759,93,0,1266,58),(7760,142,0,1266,170),(7761,97,0,1267,1),(7762,134,0,1267,2),(7763,115,0,1267,1),(7764,99,0,1267,1),(7765,93,0,1267,59),(7766,142,0,1267,170),(7767,97,0,1268,1),(7768,134,0,1268,2),(7769,115,0,1268,1),(7770,99,0,1268,4),(7771,143,0,1268,0),(7772,144,0,1268,1),(7773,145,0,1268,0),(7774,146,0,1268,1),(7775,147,0,1268,0),(7776,97,0,1269,1),(7777,134,0,1269,2),(7778,115,0,1269,1),(7779,99,0,1269,1),(7780,93,0,1269,51),(7781,142,0,1269,166),(7782,97,0,1270,1),(7783,134,0,1270,2),(7784,115,0,1270,1),(7785,99,0,1270,1),(7786,93,0,1270,53),(7787,142,0,1270,166),(7788,97,0,1271,1),(7789,134,0,1271,2),(7790,115,0,1271,1),(7791,99,0,1271,1),(7792,93,0,1271,58),(7793,142,0,1271,166),(7794,97,0,1272,1),(7795,134,0,1272,2),(7796,115,0,1272,1),(7797,99,0,1272,1),(7798,93,0,1272,51),(7799,142,0,1272,167),(7800,97,0,1273,1),(7801,134,0,1273,2),(7802,115,0,1273,1),(7803,99,0,1273,1),(7804,93,0,1273,53),(7805,142,0,1273,167),(7806,97,0,1274,1),(7807,134,0,1274,2),(7808,115,0,1274,1),(7809,99,0,1274,1),(7810,93,0,1274,58),(7811,142,0,1274,167),(7812,97,0,1275,1),(7813,134,0,1275,2),(7814,115,0,1275,1),(7815,99,0,1275,1),(7816,93,0,1275,51),(7817,142,0,1275,168),(7818,97,0,1276,1),(7819,134,0,1276,2),(7820,115,0,1276,1),(7821,99,0,1276,1),(7822,93,0,1276,53),(7823,142,0,1276,168),(7824,97,0,1277,1),(7825,134,0,1277,2),(7826,115,0,1277,1),(7827,99,0,1277,1),(7828,93,0,1277,58),(7829,142,0,1277,168),(7830,97,0,1278,1),(7831,134,0,1278,2),(7832,115,0,1278,1),(7833,99,0,1278,1),(7834,93,0,1278,51),(7835,142,0,1278,169),(7836,97,0,1279,1),(7837,134,0,1279,2),(7838,115,0,1279,1),(7839,99,0,1279,1),(7840,93,0,1279,53),(7841,142,0,1279,169),(7842,97,0,1280,1),(7843,134,0,1280,2),(7844,115,0,1280,1),(7845,99,0,1280,1),(7846,93,0,1280,58),(7847,142,0,1280,169),(7848,97,0,1281,1),(7849,134,0,1281,2),(7850,115,0,1281,1),(7851,99,0,1281,1),(7852,93,0,1281,51),(7853,142,0,1281,170),(7854,97,0,1282,1),(7855,134,0,1282,2),(7856,115,0,1282,1),(7857,99,0,1282,1),(7858,93,0,1282,53),(7859,142,0,1282,170),(7860,97,0,1283,1),(7861,134,0,1283,2),(7862,115,0,1283,1),(7863,99,0,1283,1),(7864,93,0,1283,58),(7865,142,0,1283,170),(7866,97,0,1284,1),(7867,134,0,1284,2),(7868,115,0,1284,1),(7869,99,0,1284,4),(7870,143,0,1284,0),(7871,144,0,1284,0),(7872,145,0,1284,0),(7873,146,0,1284,0),(7874,147,0,1284,0),(7875,97,0,1285,1),(7876,134,0,1285,2),(7877,115,0,1285,1),(7878,99,0,1285,1),(7879,93,0,1285,56),(7880,142,0,1285,166),(7881,97,0,1286,1),(7882,134,0,1286,2),(7883,115,0,1286,1),(7884,99,0,1286,1),(7885,93,0,1286,57),(7886,142,0,1286,166),(7887,97,0,1287,1),(7888,134,0,1287,2),(7889,115,0,1287,1),(7890,99,0,1287,1),(7891,93,0,1287,58),(7892,142,0,1287,166),(7893,97,0,1288,1),(7894,134,0,1288,2),(7895,115,0,1288,1),(7896,99,0,1288,1),(7897,93,0,1288,56),(7898,142,0,1288,167),(7899,97,0,1289,1),(7900,134,0,1289,2),(7901,115,0,1289,1),(7902,99,0,1289,1),(7903,93,0,1289,57),(7904,142,0,1289,167),(7905,97,0,1290,1),(7906,134,0,1290,2),(7907,115,0,1290,1),(7908,99,0,1290,1),(7909,93,0,1290,58),(7910,142,0,1290,167),(7911,97,0,1291,1),(7912,134,0,1291,2),(7913,115,0,1291,1),(7914,99,0,1291,1),(7915,93,0,1291,56),(7916,142,0,1291,168),(7917,97,0,1292,1),(7918,134,0,1292,2),(7919,115,0,1292,1),(7920,99,0,1292,1),(7921,93,0,1292,57),(7922,142,0,1292,168),(7923,97,0,1293,1),(7924,134,0,1293,2),(7925,115,0,1293,1),(7926,99,0,1293,1),(7927,93,0,1293,58),(7928,142,0,1293,168),(7929,97,0,1294,1),(7930,134,0,1294,2),(7931,115,0,1294,1),(7932,99,0,1294,1),(7933,93,0,1294,56),(7934,142,0,1294,169),(7935,97,0,1295,1),(7936,134,0,1295,2),(7937,115,0,1295,1),(7938,99,0,1295,1),(7939,93,0,1295,57),(7940,142,0,1295,169),(7941,97,0,1296,1),(7942,134,0,1296,2),(7943,115,0,1296,1),(7944,99,0,1296,1),(7945,93,0,1296,58),(7946,142,0,1296,169),(7947,97,0,1297,1),(7948,134,0,1297,2),(7949,115,0,1297,1),(7950,99,0,1297,1),(7951,93,0,1297,56),(7952,142,0,1297,170),(7953,97,0,1298,1),(7954,134,0,1298,2),(7955,115,0,1298,1),(7956,99,0,1298,1),(7957,93,0,1298,57),(7958,142,0,1298,170),(7959,97,0,1299,1),(7960,134,0,1299,2),(7961,115,0,1299,1),(7962,99,0,1299,1),(7963,93,0,1299,58),(7964,142,0,1299,170),(7965,97,0,1300,1),(7966,134,0,1300,2),(7967,115,0,1300,1),(7968,99,0,1300,4),(7969,143,0,1300,0),(7970,144,0,1300,0),(7971,145,0,1300,0),(7972,146,0,1300,0),(7973,147,0,1300,0),(7974,97,0,1301,1),(7975,134,0,1301,2),(7976,115,0,1301,1),(7977,99,0,1301,1),(7978,93,0,1301,52),(7979,142,0,1301,166),(7980,97,0,1302,1),(7981,134,0,1302,2),(7982,115,0,1302,1),(7983,99,0,1302,1),(7984,93,0,1302,56),(7985,142,0,1302,166),(7986,97,0,1303,1),(7987,134,0,1303,2),(7988,115,0,1303,1),(7989,99,0,1303,1),(7990,93,0,1303,57),(7991,142,0,1303,166),(7992,97,0,1304,1),(7993,134,0,1304,2),(7994,115,0,1304,1),(7995,99,0,1304,1),(7996,93,0,1304,52),(7997,142,0,1304,167),(7998,97,0,1305,1),(7999,134,0,1305,2),(8000,115,0,1305,1),(8001,99,0,1305,1),(8002,93,0,1305,56),(8003,142,0,1305,167),(8004,97,0,1306,1),(8005,134,0,1306,2),(8006,115,0,1306,1),(8007,99,0,1306,1),(8008,93,0,1306,57),(8009,142,0,1306,167),(8010,97,0,1307,1),(8011,134,0,1307,2),(8012,115,0,1307,1),(8013,99,0,1307,1),(8014,93,0,1307,52),(8015,142,0,1307,168),(8016,97,0,1308,1),(8017,134,0,1308,2),(8018,115,0,1308,1),(8019,99,0,1308,1),(8020,93,0,1308,56),(8021,142,0,1308,168),(8022,97,0,1309,1),(8023,134,0,1309,2),(8024,115,0,1309,1),(8025,99,0,1309,1),(8026,93,0,1309,57),(8027,142,0,1309,168),(8028,97,0,1310,1),(8029,134,0,1310,2),(8030,115,0,1310,1),(8031,99,0,1310,1),(8032,93,0,1310,52),(8033,142,0,1310,169),(8034,97,0,1311,1),(8035,134,0,1311,2),(8036,115,0,1311,1),(8037,99,0,1311,1),(8038,93,0,1311,56),(8039,142,0,1311,169),(8040,97,0,1312,1),(8041,134,0,1312,2),(8042,115,0,1312,1),(8043,99,0,1312,1),(8044,93,0,1312,57),(8045,142,0,1312,169),(8046,97,0,1313,1),(8047,134,0,1313,2),(8048,115,0,1313,1),(8049,99,0,1313,1),(8050,93,0,1313,52),(8051,142,0,1313,170),(8052,97,0,1314,1),(8053,134,0,1314,2),(8054,115,0,1314,1),(8055,99,0,1314,1),(8056,93,0,1314,56),(8057,142,0,1314,170),(8058,97,0,1315,1),(8059,134,0,1315,2),(8060,115,0,1315,1),(8061,99,0,1315,1),(8062,93,0,1315,57),(8063,142,0,1315,170),(8064,97,0,1316,1),(8065,134,0,1316,2),(8066,115,0,1316,1),(8067,99,0,1316,4),(8068,143,0,1316,1),(8069,144,0,1316,0),(8070,145,0,1316,1),(8071,146,0,1316,0),(8072,147,0,1316,1),(8073,97,0,1317,1),(8074,134,0,1317,2),(8075,115,0,1317,1),(8076,99,0,1317,1),(8077,93,0,1317,50),(8078,142,0,1317,166),(8079,97,0,1318,1),(8080,134,0,1318,2),(8081,115,0,1318,1),(8082,99,0,1318,1),(8083,93,0,1318,52),(8084,142,0,1318,166),(8085,97,0,1319,1),(8086,134,0,1319,2),(8087,115,0,1319,1),(8088,99,0,1319,1),(8089,93,0,1319,53),(8090,142,0,1319,166),(8091,97,0,1320,1),(8092,134,0,1320,2),(8093,115,0,1320,1),(8094,99,0,1320,1),(8095,93,0,1320,50),(8096,142,0,1320,167),(8097,97,0,1321,1),(8098,134,0,1321,2),(8099,115,0,1321,1),(8100,99,0,1321,1),(8101,93,0,1321,52),(8102,142,0,1321,167),(8103,97,0,1322,1),(8104,134,0,1322,2),(8105,115,0,1322,1),(8106,99,0,1322,1),(8107,93,0,1322,53),(8108,142,0,1322,167),(8109,97,0,1323,1),(8110,134,0,1323,2),(8111,115,0,1323,1),(8112,99,0,1323,1),(8113,93,0,1323,50),(8114,142,0,1323,168),(8115,97,0,1324,1),(8116,134,0,1324,2),(8117,115,0,1324,1),(8118,99,0,1324,1),(8119,93,0,1324,52),(8120,142,0,1324,168),(8121,97,0,1325,1),(8122,134,0,1325,2),(8123,115,0,1325,1),(8124,99,0,1325,1),(8125,93,0,1325,53),(8126,142,0,1325,168),(8127,97,0,1326,1),(8128,134,0,1326,2),(8129,115,0,1326,1),(8130,99,0,1326,1),(8131,93,0,1326,50),(8132,142,0,1326,169),(8133,97,0,1327,1),(8134,134,0,1327,2),(8135,115,0,1327,1),(8136,99,0,1327,1),(8137,93,0,1327,52),(8138,142,0,1327,169),(8139,97,0,1328,1),(8140,134,0,1328,2),(8141,115,0,1328,1),(8142,99,0,1328,1),(8143,93,0,1328,53),(8144,142,0,1328,169),(8145,97,0,1329,1),(8146,134,0,1329,2),(8147,115,0,1329,1),(8148,99,0,1329,1),(8149,93,0,1329,50),(8150,142,0,1329,170),(8151,97,0,1330,1),(8152,134,0,1330,2),(8153,115,0,1330,1),(8154,99,0,1330,1),(8155,93,0,1330,52),(8156,142,0,1330,170),(8157,97,0,1331,1),(8158,134,0,1331,2),(8159,115,0,1331,1),(8160,99,0,1331,1),(8161,93,0,1331,53),(8162,142,0,1331,170),(8163,97,0,1332,1),(8164,134,0,1332,2),(8165,115,0,1332,1),(8166,99,0,1332,4),(8167,143,0,1332,1),(8168,144,0,1332,0),(8169,145,0,1332,1),(8170,146,0,1332,0),(8171,147,0,1332,0),(8172,97,0,1333,1),(8173,134,0,1333,2),(8174,115,0,1333,1),(8175,99,0,1333,1),(8176,93,0,1333,49),(8177,142,0,1333,166),(8178,97,0,1334,1),(8179,134,0,1334,2),(8180,115,0,1334,1),(8181,99,0,1334,1),(8182,93,0,1334,56),(8183,142,0,1334,166),(8184,97,0,1335,1),(8185,134,0,1335,2),(8186,115,0,1335,1),(8187,99,0,1335,1),(8188,93,0,1335,60),(8189,142,0,1335,166),(8190,97,0,1336,1),(8191,134,0,1336,2),(8192,115,0,1336,1),(8193,99,0,1336,1),(8194,93,0,1336,49),(8195,142,0,1336,167),(8196,97,0,1337,1),(8197,134,0,1337,2),(8198,115,0,1337,1),(8199,99,0,1337,1),(8200,93,0,1337,56),(8201,142,0,1337,167),(8202,97,0,1338,1),(8203,134,0,1338,2),(8204,115,0,1338,1),(8205,99,0,1338,1),(8206,93,0,1338,60),(8207,142,0,1338,167),(8208,97,0,1339,1),(8209,134,0,1339,2),(8210,115,0,1339,1),(8211,99,0,1339,1),(8212,93,0,1339,49),(8213,142,0,1339,168),(8214,97,0,1340,1),(8215,134,0,1340,2),(8216,115,0,1340,1),(8217,99,0,1340,1),(8218,93,0,1340,56),(8219,142,0,1340,168),(8220,97,0,1341,1),(8221,134,0,1341,2),(8222,115,0,1341,1),(8223,99,0,1341,1),(8224,93,0,1341,60),(8225,142,0,1341,168),(8226,97,0,1342,1),(8227,134,0,1342,2),(8228,115,0,1342,1),(8229,99,0,1342,1),(8230,93,0,1342,49),(8231,142,0,1342,169),(8232,97,0,1343,1),(8233,134,0,1343,2),(8234,115,0,1343,1),(8235,99,0,1343,1),(8236,93,0,1343,56),(8237,142,0,1343,169),(8238,97,0,1344,1),(8239,134,0,1344,2),(8240,115,0,1344,1),(8241,99,0,1344,1),(8242,93,0,1344,60),(8243,142,0,1344,169),(8244,97,0,1345,1),(8245,134,0,1345,2),(8246,115,0,1345,1),(8247,99,0,1345,1),(8248,93,0,1345,49),(8249,142,0,1345,170),(8250,97,0,1346,1),(8251,134,0,1346,2),(8252,115,0,1346,1),(8253,99,0,1346,1),(8254,93,0,1346,56),(8255,142,0,1346,170),(8256,97,0,1347,1),(8257,134,0,1347,2),(8258,115,0,1347,1),(8259,99,0,1347,1),(8260,93,0,1347,60),(8261,142,0,1347,170),(8262,97,0,1348,1),(8263,134,0,1348,2),(8264,115,0,1348,1),(8265,99,0,1348,4),(8266,143,0,1348,0),(8267,144,0,1348,1),(8268,145,0,1348,0),(8269,146,0,1348,1),(8270,147,0,1348,0),(8271,97,0,1349,1),(8272,134,0,1349,2),(8273,115,0,1349,1),(8274,99,0,1349,1),(8275,93,0,1349,49),(8276,142,0,1349,166),(8277,97,0,1350,1),(8278,134,0,1350,2),(8279,115,0,1350,1),(8280,99,0,1350,1),(8281,93,0,1350,50),(8282,142,0,1350,166),(8283,97,0,1351,1),(8284,134,0,1351,2),(8285,115,0,1351,1),(8286,99,0,1351,1),(8287,93,0,1351,56),(8288,142,0,1351,166),(8289,97,0,1352,1),(8290,134,0,1352,2),(8291,115,0,1352,1),(8292,99,0,1352,1),(8293,93,0,1352,49),(8294,142,0,1352,167),(8295,97,0,1353,1),(8296,134,0,1353,2),(8297,115,0,1353,1),(8298,99,0,1353,1),(8299,93,0,1353,50),(8300,142,0,1353,167),(8301,97,0,1354,1),(8302,134,0,1354,2),(8303,115,0,1354,1),(8304,99,0,1354,1),(8305,93,0,1354,56),(8306,142,0,1354,167),(8307,97,0,1355,1),(8308,134,0,1355,2),(8309,115,0,1355,1),(8310,99,0,1355,1),(8311,93,0,1355,49),(8312,142,0,1355,168),(8313,97,0,1356,1),(8314,134,0,1356,2),(8315,115,0,1356,1),(8316,99,0,1356,1),(8317,93,0,1356,50),(8318,142,0,1356,168),(8319,97,0,1357,1),(8320,134,0,1357,2),(8321,115,0,1357,1),(8322,99,0,1357,1),(8323,93,0,1357,56),(8324,142,0,1357,168),(8325,97,0,1358,1),(8326,134,0,1358,2),(8327,115,0,1358,1),(8328,99,0,1358,1),(8329,93,0,1358,49),(8330,142,0,1358,169),(8331,97,0,1359,1),(8332,134,0,1359,2),(8333,115,0,1359,1),(8334,99,0,1359,1),(8335,93,0,1359,50),(8336,142,0,1359,169),(8337,97,0,1360,1),(8338,134,0,1360,2),(8339,115,0,1360,1),(8340,99,0,1360,1),(8341,93,0,1360,56),(8342,142,0,1360,169),(8343,97,0,1361,1),(8344,134,0,1361,2),(8345,115,0,1361,1),(8346,99,0,1361,1),(8347,93,0,1361,49),(8348,142,0,1361,170),(8349,97,0,1362,1),(8350,134,0,1362,2),(8351,115,0,1362,1),(8352,99,0,1362,1),(8353,93,0,1362,50),(8354,142,0,1362,170),(8355,97,0,1363,1),(8356,134,0,1363,2),(8357,115,0,1363,1),(8358,99,0,1363,1),(8359,93,0,1363,56),(8360,142,0,1363,170),(8361,97,0,1364,1),(8362,134,0,1364,2),(8363,115,0,1364,1),(8364,99,0,1364,4),(8365,143,0,1364,0),(8366,144,0,1364,0),(8367,145,0,1364,0),(8368,146,0,1364,1),(8369,147,0,1364,0),(8370,97,0,1365,1),(8371,134,0,1365,2),(8372,115,0,1365,1),(8373,99,0,1365,1),(8374,93,0,1365,50),(8375,142,0,1365,166),(8376,97,0,1366,1),(8377,134,0,1366,2),(8378,115,0,1366,1),(8379,99,0,1366,1),(8380,93,0,1366,53),(8381,142,0,1366,166),(8382,97,0,1367,1),(8383,134,0,1367,2),(8384,115,0,1367,1),(8385,99,0,1367,1),(8386,93,0,1367,57),(8387,142,0,1367,166),(8388,97,0,1368,1),(8389,134,0,1368,2),(8390,115,0,1368,1),(8391,99,0,1368,1),(8392,93,0,1368,50),(8393,142,0,1368,167),(8394,97,0,1369,1),(8395,134,0,1369,2),(8396,115,0,1369,1),(8397,99,0,1369,1),(8398,93,0,1369,53),(8399,142,0,1369,167),(8400,97,0,1370,1),(8401,134,0,1370,2),(8402,115,0,1370,1),(8403,99,0,1370,1),(8404,93,0,1370,57),(8405,142,0,1370,167),(8406,97,0,1371,1),(8407,134,0,1371,2),(8408,115,0,1371,1),(8409,99,0,1371,1),(8410,93,0,1371,50),(8411,142,0,1371,168),(8412,97,0,1372,1),(8413,134,0,1372,2),(8414,115,0,1372,1),(8415,99,0,1372,1),(8416,93,0,1372,53),(8417,142,0,1372,168),(8418,97,0,1373,1),(8419,134,0,1373,2),(8420,115,0,1373,1),(8421,99,0,1373,1),(8422,93,0,1373,57),(8423,142,0,1373,168),(8424,97,0,1374,1),(8425,134,0,1374,2),(8426,115,0,1374,1),(8427,99,0,1374,1),(8428,93,0,1374,50),(8429,142,0,1374,169),(8430,97,0,1375,1),(8431,134,0,1375,2),(8432,115,0,1375,1),(8433,99,0,1375,1),(8434,93,0,1375,53),(8435,142,0,1375,169),(8436,97,0,1376,1),(8437,134,0,1376,2),(8438,115,0,1376,1),(8439,99,0,1376,1),(8440,93,0,1376,57),(8441,142,0,1376,169),(8442,97,0,1377,1),(8443,134,0,1377,2),(8444,115,0,1377,1),(8445,99,0,1377,1),(8446,93,0,1377,50),(8447,142,0,1377,170),(8448,97,0,1378,1),(8449,134,0,1378,2),(8450,115,0,1378,1),(8451,99,0,1378,1),(8452,93,0,1378,53),(8453,142,0,1378,170),(8454,97,0,1379,1),(8455,134,0,1379,2),(8456,115,0,1379,1),(8457,99,0,1379,1),(8458,93,0,1379,57),(8459,142,0,1379,170),(8460,97,0,1380,1),(8461,134,0,1380,2),(8462,115,0,1380,1),(8463,99,0,1380,4),(8464,143,0,1380,0),(8465,144,0,1380,1),(8466,145,0,1380,0),(8467,146,0,1380,0),(8468,147,0,1380,1),(8469,97,0,1381,1),(8470,134,0,1381,2),(8471,115,0,1381,1),(8472,99,0,1381,1),(8473,93,0,1381,49),(8474,142,0,1381,166),(8475,97,0,1382,1),(8476,134,0,1382,2),(8477,115,0,1382,1),(8478,99,0,1382,1),(8479,93,0,1382,50),(8480,142,0,1382,166),(8481,97,0,1383,1),(8482,134,0,1383,2),(8483,115,0,1383,1),(8484,99,0,1383,1),(8485,93,0,1383,57),(8486,142,0,1383,166),(8487,97,0,1384,1),(8488,134,0,1384,2),(8489,115,0,1384,1),(8490,99,0,1384,1),(8491,93,0,1384,49),(8492,142,0,1384,167),(8493,97,0,1385,1),(8494,134,0,1385,2),(8495,115,0,1385,1),(8496,99,0,1385,1),(8497,93,0,1385,50),(8498,142,0,1385,167),(8499,97,0,1386,1),(8500,134,0,1386,2),(8501,115,0,1386,1),(8502,99,0,1386,1),(8503,93,0,1386,57),(8504,142,0,1386,167),(8505,97,0,1387,1),(8506,134,0,1387,2),(8507,115,0,1387,1),(8508,99,0,1387,1),(8509,93,0,1387,49),(8510,142,0,1387,168),(8511,97,0,1388,1),(8512,134,0,1388,2),(8513,115,0,1388,1),(8514,99,0,1388,1),(8515,93,0,1388,50),(8516,142,0,1388,168),(8517,97,0,1389,1),(8518,134,0,1389,2),(8519,115,0,1389,1),(8520,99,0,1389,1),(8521,93,0,1389,57),(8522,142,0,1389,168),(8523,97,0,1390,1),(8524,134,0,1390,2),(8525,115,0,1390,1),(8526,99,0,1390,1),(8527,93,0,1390,49),(8528,142,0,1390,169),(8529,97,0,1391,1),(8530,134,0,1391,2),(8531,115,0,1391,1),(8532,99,0,1391,1),(8533,93,0,1391,50),(8534,142,0,1391,169),(8535,97,0,1392,1),(8536,134,0,1392,2),(8537,115,0,1392,1),(8538,99,0,1392,1),(8539,93,0,1392,57),(8540,142,0,1392,169),(8541,97,0,1393,1),(8542,134,0,1393,2),(8543,115,0,1393,1),(8544,99,0,1393,1),(8545,93,0,1393,49),(8546,142,0,1393,170),(8547,97,0,1394,1),(8548,134,0,1394,2),(8549,115,0,1394,1),(8550,99,0,1394,1),(8551,93,0,1394,50),(8552,142,0,1394,170),(8553,97,0,1395,1),(8554,134,0,1395,2),(8555,115,0,1395,1),(8556,99,0,1395,1),(8557,93,0,1395,57),(8558,142,0,1395,170),(8559,97,0,1396,1),(8560,134,0,1396,2),(8561,115,0,1396,1),(8562,99,0,1396,4),(8563,143,0,1396,0),(8564,144,0,1396,1),(8565,145,0,1396,0),(8566,146,0,1396,0),(8567,147,0,1396,1),(8568,97,0,1397,1),(8569,134,0,1397,2),(8570,115,0,1397,1),(8571,99,0,1397,1),(8572,93,0,1397,50),(8573,142,0,1397,166),(8574,97,0,1398,1),(8575,134,0,1398,2),(8576,115,0,1398,1),(8577,99,0,1398,1),(8578,93,0,1398,53),(8579,142,0,1398,166),(8580,97,0,1399,1),(8581,134,0,1399,2),(8582,115,0,1399,1),(8583,99,0,1399,1),(8584,93,0,1399,58),(8585,142,0,1399,166),(8586,97,0,1400,1),(8587,134,0,1400,2),(8588,115,0,1400,1),(8589,99,0,1400,1),(8590,93,0,1400,50),(8591,142,0,1400,167),(8592,97,0,1401,1),(8593,134,0,1401,2),(8594,115,0,1401,1),(8595,99,0,1401,1),(8596,93,0,1401,53),(8597,142,0,1401,167),(8598,97,0,1402,1),(8599,134,0,1402,2),(8600,115,0,1402,1),(8601,99,0,1402,1),(8602,93,0,1402,58),(8603,142,0,1402,167),(8604,97,0,1403,1),(8605,134,0,1403,2),(8606,115,0,1403,1),(8607,99,0,1403,1),(8608,93,0,1403,50),(8609,142,0,1403,168),(8610,97,0,1404,1),(8611,134,0,1404,2),(8612,115,0,1404,1),(8613,99,0,1404,1),(8614,93,0,1404,53),(8615,142,0,1404,168),(8616,97,0,1405,1),(8617,134,0,1405,2),(8618,115,0,1405,1),(8619,99,0,1405,1),(8620,93,0,1405,58),(8621,142,0,1405,168),(8622,97,0,1406,1),(8623,134,0,1406,2),(8624,115,0,1406,1),(8625,99,0,1406,1),(8626,93,0,1406,50),(8627,142,0,1406,169),(8628,97,0,1407,1),(8629,134,0,1407,2),(8630,115,0,1407,1),(8631,99,0,1407,1),(8632,93,0,1407,53),(8633,142,0,1407,169),(8634,97,0,1408,1),(8635,134,0,1408,2),(8636,115,0,1408,1),(8637,99,0,1408,1),(8638,93,0,1408,58),(8639,142,0,1408,169),(8640,97,0,1409,1),(8641,134,0,1409,2),(8642,115,0,1409,1),(8643,99,0,1409,1),(8644,93,0,1409,50),(8645,142,0,1409,170),(8646,97,0,1410,1),(8647,134,0,1410,2),(8648,115,0,1410,1),(8649,99,0,1410,1),(8650,93,0,1410,53),(8651,142,0,1410,170),(8652,97,0,1411,1),(8653,134,0,1411,2),(8654,115,0,1411,1),(8655,99,0,1411,1),(8656,93,0,1411,58),(8657,142,0,1411,170),(8658,97,0,1412,1),(8659,134,0,1412,2),(8660,115,0,1412,1),(8661,99,0,1412,4),(8662,143,0,1412,0),(8663,144,0,1412,0),(8664,145,0,1412,0),(8665,146,0,1412,1),(8666,147,0,1412,0),(8667,97,0,1413,1),(8668,134,0,1413,2),(8669,115,0,1413,1),(8670,99,0,1413,1),(8671,93,0,1413,50),(8672,142,0,1413,166),(8673,97,0,1414,1),(8674,134,0,1414,2),(8675,115,0,1414,1),(8676,99,0,1414,1),(8677,93,0,1414,53),(8678,142,0,1414,166),(8679,97,0,1415,1),(8680,134,0,1415,2),(8681,115,0,1415,1),(8682,99,0,1415,1),(8683,93,0,1415,58),(8684,142,0,1415,166),(8685,97,0,1416,1),(8686,134,0,1416,2),(8687,115,0,1416,1),(8688,99,0,1416,1),(8689,93,0,1416,50),(8690,142,0,1416,167),(8691,97,0,1417,1),(8692,134,0,1417,2),(8693,115,0,1417,1),(8694,99,0,1417,1),(8695,93,0,1417,53),(8696,142,0,1417,167),(8697,97,0,1418,1),(8698,134,0,1418,2),(8699,115,0,1418,1),(8700,99,0,1418,1),(8701,93,0,1418,58),(8702,142,0,1418,167),(8703,97,0,1419,1),(8704,134,0,1419,2),(8705,115,0,1419,1),(8706,99,0,1419,1),(8707,93,0,1419,50),(8708,142,0,1419,168),(8709,97,0,1420,1),(8710,134,0,1420,2),(8711,115,0,1420,1),(8712,99,0,1420,1),(8713,93,0,1420,53),(8714,142,0,1420,168),(8715,97,0,1421,1),(8716,134,0,1421,2),(8717,115,0,1421,1),(8718,99,0,1421,1),(8719,93,0,1421,58),(8720,142,0,1421,168),(8721,97,0,1422,1),(8722,134,0,1422,2),(8723,115,0,1422,1),(8724,99,0,1422,1),(8725,93,0,1422,50),(8726,142,0,1422,169),(8727,97,0,1423,1),(8728,134,0,1423,2),(8729,115,0,1423,1),(8730,99,0,1423,1),(8731,93,0,1423,53),(8732,142,0,1423,169),(8733,97,0,1424,1),(8734,134,0,1424,2),(8735,115,0,1424,1),(8736,99,0,1424,1),(8737,93,0,1424,58),(8738,142,0,1424,169),(8739,97,0,1425,1),(8740,134,0,1425,2),(8741,115,0,1425,1),(8742,99,0,1425,1),(8743,93,0,1425,50),(8744,142,0,1425,170),(8745,97,0,1426,1),(8746,134,0,1426,2),(8747,115,0,1426,1),(8748,99,0,1426,1),(8749,93,0,1426,53),(8750,142,0,1426,170),(8751,97,0,1427,1),(8752,134,0,1427,2),(8753,115,0,1427,1),(8754,99,0,1427,1),(8755,93,0,1427,58),(8756,142,0,1427,170),(8757,97,0,1428,1),(8758,134,0,1428,2),(8759,115,0,1428,1),(8760,99,0,1428,4),(8761,143,0,1428,0),(8762,144,0,1428,1),(8763,145,0,1428,0),(8764,146,0,1428,0),(8765,147,0,1428,0),(8766,97,0,1429,1),(8767,134,0,1429,2),(8768,115,0,1429,1),(8769,99,0,1429,1),(8770,93,0,1429,50),(8771,142,0,1429,166),(8772,97,0,1430,1),(8773,134,0,1430,2),(8774,115,0,1430,1),(8775,99,0,1430,1),(8776,93,0,1430,53),(8777,142,0,1430,166),(8778,97,0,1431,1),(8779,134,0,1431,2),(8780,115,0,1431,1),(8781,99,0,1431,1),(8782,93,0,1431,58),(8783,142,0,1431,166),(8784,97,0,1432,1),(8785,134,0,1432,2),(8786,115,0,1432,1),(8787,99,0,1432,1),(8788,93,0,1432,50),(8789,142,0,1432,167),(8790,97,0,1433,1),(8791,134,0,1433,2),(8792,115,0,1433,1),(8793,99,0,1433,1),(8794,93,0,1433,53),(8795,142,0,1433,167),(8796,97,0,1434,1),(8797,134,0,1434,2),(8798,115,0,1434,1),(8799,99,0,1434,1),(8800,93,0,1434,58),(8801,142,0,1434,167),(8802,97,0,1435,1),(8803,134,0,1435,2),(8804,115,0,1435,1),(8805,99,0,1435,1),(8806,93,0,1435,50),(8807,142,0,1435,168),(8808,97,0,1436,1),(8809,134,0,1436,2),(8810,115,0,1436,1),(8811,99,0,1436,1),(8812,93,0,1436,53),(8813,142,0,1436,168),(8814,97,0,1437,1),(8815,134,0,1437,2),(8816,115,0,1437,1),(8817,99,0,1437,1),(8818,93,0,1437,58),(8819,142,0,1437,168),(8820,97,0,1438,1),(8821,134,0,1438,2),(8822,115,0,1438,1),(8823,99,0,1438,1),(8824,93,0,1438,50),(8825,142,0,1438,169),(8826,97,0,1439,1),(8827,134,0,1439,2),(8828,115,0,1439,1),(8829,99,0,1439,1),(8830,93,0,1439,53),(8831,142,0,1439,169),(8832,97,0,1440,1),(8833,134,0,1440,2),(8834,115,0,1440,1),(8835,99,0,1440,1),(8836,93,0,1440,58),(8837,142,0,1440,169),(8838,97,0,1441,1),(8839,134,0,1441,2),(8840,115,0,1441,1),(8841,99,0,1441,1),(8842,93,0,1441,50),(8843,142,0,1441,170),(8844,97,0,1442,1),(8845,134,0,1442,2),(8846,115,0,1442,1),(8847,99,0,1442,1),(8848,93,0,1442,53),(8849,142,0,1442,170),(8850,97,0,1443,1),(8851,134,0,1443,2),(8852,115,0,1443,1),(8853,99,0,1443,1),(8854,93,0,1443,58),(8855,142,0,1443,170),(8856,97,0,1444,1),(8857,134,0,1444,2),(8858,115,0,1444,1),(8859,99,0,1444,4),(8860,143,0,1444,1),(8861,144,0,1444,0),(8862,145,0,1444,0),(8863,146,0,1444,1),(8864,147,0,1444,0),(8865,97,0,1445,1),(8866,134,0,1445,2),(8867,115,0,1445,1),(8868,99,0,1445,1),(8869,93,0,1445,52),(8870,142,0,1445,166),(8871,97,0,1446,1),(8872,134,0,1446,2),(8873,115,0,1446,1),(8874,99,0,1446,1),(8875,93,0,1446,57),(8876,142,0,1446,166),(8877,97,0,1447,1),(8878,134,0,1447,2),(8879,115,0,1447,1),(8880,99,0,1447,1),(8881,93,0,1447,58),(8882,142,0,1447,166),(8883,97,0,1448,1),(8884,134,0,1448,2),(8885,115,0,1448,1),(8886,99,0,1448,1),(8887,93,0,1448,52),(8888,142,0,1448,167),(8889,97,0,1449,1),(8890,134,0,1449,2),(8891,115,0,1449,1),(8892,99,0,1449,1),(8893,93,0,1449,57),(8894,142,0,1449,167),(8895,97,0,1450,1),(8896,134,0,1450,2),(8897,115,0,1450,1),(8898,99,0,1450,1),(8899,93,0,1450,58),(8900,142,0,1450,167),(8901,97,0,1451,1),(8902,134,0,1451,2),(8903,115,0,1451,1),(8904,99,0,1451,1),(8905,93,0,1451,52),(8906,142,0,1451,168),(8907,97,0,1452,1),(8908,134,0,1452,2),(8909,115,0,1452,1),(8910,99,0,1452,1),(8911,93,0,1452,57),(8912,142,0,1452,168),(8913,97,0,1453,1),(8914,134,0,1453,2),(8915,115,0,1453,1),(8916,99,0,1453,1),(8917,93,0,1453,58),(8918,142,0,1453,168),(8919,97,0,1454,1),(8920,134,0,1454,2),(8921,115,0,1454,1),(8922,99,0,1454,1),(8923,93,0,1454,52),(8924,142,0,1454,169),(8925,97,0,1455,1),(8926,134,0,1455,2),(8927,115,0,1455,1),(8928,99,0,1455,1),(8929,93,0,1455,57),(8930,142,0,1455,169),(8931,97,0,1456,1),(8932,134,0,1456,2),(8933,115,0,1456,1),(8934,99,0,1456,1),(8935,93,0,1456,58),(8936,142,0,1456,169),(8937,97,0,1457,1),(8938,134,0,1457,2),(8939,115,0,1457,1),(8940,99,0,1457,1),(8941,93,0,1457,52),(8942,142,0,1457,170),(8943,97,0,1458,1),(8944,134,0,1458,2),(8945,115,0,1458,1),(8946,99,0,1458,1),(8947,93,0,1458,57),(8948,142,0,1458,170),(8949,97,0,1459,1),(8950,134,0,1459,2),(8951,115,0,1459,1),(8952,99,0,1459,1),(8953,93,0,1459,58),(8954,142,0,1459,170),(8955,97,0,1460,1),(8956,134,0,1460,2),(8957,115,0,1460,1),(8958,99,0,1460,4),(8959,143,0,1460,1),(8960,144,0,1460,0),(8961,145,0,1460,0),(8962,146,0,1460,1),(8963,147,0,1460,0),(8964,97,0,1461,1),(8965,134,0,1461,2),(8966,115,0,1461,1),(8967,99,0,1461,1),(8968,93,0,1461,49),(8969,142,0,1461,166),(8970,97,0,1462,1),(8971,134,0,1462,2),(8972,115,0,1462,1),(8973,99,0,1462,1),(8974,93,0,1462,59),(8975,142,0,1462,166),(8976,97,0,1463,1),(8977,134,0,1463,2),(8978,115,0,1463,1),(8979,99,0,1463,1),(8980,93,0,1463,60),(8981,142,0,1463,166),(8982,97,0,1464,1),(8983,134,0,1464,2),(8984,115,0,1464,1),(8985,99,0,1464,1),(8986,93,0,1464,49),(8987,142,0,1464,167),(8988,97,0,1465,1),(8989,134,0,1465,2),(8990,115,0,1465,1),(8991,99,0,1465,1),(8992,93,0,1465,59),(8993,142,0,1465,167),(8994,97,0,1466,1),(8995,134,0,1466,2),(8996,115,0,1466,1),(8997,99,0,1466,1),(8998,93,0,1466,60),(8999,142,0,1466,167),(9000,97,0,1467,1),(9001,134,0,1467,2),(9002,115,0,1467,1),(9003,99,0,1467,1),(9004,93,0,1467,49),(9005,142,0,1467,168),(9006,97,0,1468,1),(9007,134,0,1468,2),(9008,115,0,1468,1),(9009,99,0,1468,1),(9010,93,0,1468,59),(9011,142,0,1468,168),(9012,97,0,1469,1),(9013,134,0,1469,2),(9014,115,0,1469,1),(9015,99,0,1469,1),(9016,93,0,1469,60),(9017,142,0,1469,168),(9018,97,0,1470,1),(9019,134,0,1470,2),(9020,115,0,1470,1),(9021,99,0,1470,1),(9022,93,0,1470,49),(9023,142,0,1470,169),(9024,97,0,1471,1),(9025,134,0,1471,2),(9026,115,0,1471,1),(9027,99,0,1471,1),(9028,93,0,1471,59),(9029,142,0,1471,169),(9030,97,0,1472,1),(9031,134,0,1472,2),(9032,115,0,1472,1),(9033,99,0,1472,1),(9034,93,0,1472,60),(9035,142,0,1472,169),(9036,97,0,1473,1),(9037,134,0,1473,2),(9038,115,0,1473,1),(9039,99,0,1473,1),(9040,93,0,1473,49),(9041,142,0,1473,170),(9042,97,0,1474,1),(9043,134,0,1474,2),(9044,115,0,1474,1),(9045,99,0,1474,1),(9046,93,0,1474,59),(9047,142,0,1474,170),(9048,97,0,1475,1),(9049,134,0,1475,2),(9050,115,0,1475,1),(9051,99,0,1475,1),(9052,93,0,1475,60),(9053,142,0,1475,170),(9054,97,0,1476,1),(9055,134,0,1476,2),(9056,115,0,1476,1),(9057,99,0,1476,4),(9058,143,0,1476,0),(9059,144,0,1476,1),(9060,145,0,1476,1),(9061,146,0,1476,1),(9062,147,0,1476,0),(9063,97,0,1477,1),(9064,134,0,1477,2),(9065,115,0,1477,1),(9066,99,0,1477,1),(9067,93,0,1477,49),(9068,142,0,1477,166),(9069,97,0,1478,1),(9070,134,0,1478,2),(9071,115,0,1478,1),(9072,99,0,1478,1),(9073,93,0,1478,50),(9074,142,0,1478,166),(9075,97,0,1479,1),(9076,134,0,1479,2),(9077,115,0,1479,1),(9078,99,0,1479,1),(9079,93,0,1479,58),(9080,142,0,1479,166),(9081,97,0,1480,1),(9082,134,0,1480,2),(9083,115,0,1480,1),(9084,99,0,1480,1),(9085,93,0,1480,49),(9086,142,0,1480,167),(9087,97,0,1481,1),(9088,134,0,1481,2),(9089,115,0,1481,1),(9090,99,0,1481,1),(9091,93,0,1481,50),(9092,142,0,1481,167),(9093,97,0,1482,1),(9094,134,0,1482,2),(9095,115,0,1482,1),(9096,99,0,1482,1),(9097,93,0,1482,58),(9098,142,0,1482,167),(9099,97,0,1483,1),(9100,134,0,1483,2),(9101,115,0,1483,1),(9102,99,0,1483,1),(9103,93,0,1483,49),(9104,142,0,1483,168),(9105,97,0,1484,1),(9106,134,0,1484,2),(9107,115,0,1484,1),(9108,99,0,1484,1),(9109,93,0,1484,50),(9110,142,0,1484,168),(9111,97,0,1485,1),(9112,134,0,1485,2),(9113,115,0,1485,1),(9114,99,0,1485,1),(9115,93,0,1485,58),(9116,142,0,1485,168),(9117,97,0,1486,1),(9118,134,0,1486,2),(9119,115,0,1486,1),(9120,99,0,1486,1),(9121,93,0,1486,49),(9122,142,0,1486,169),(9123,97,0,1487,1),(9124,134,0,1487,2),(9125,115,0,1487,1),(9126,99,0,1487,1),(9127,93,0,1487,50),(9128,142,0,1487,169),(9129,97,0,1488,1),(9130,134,0,1488,2),(9131,115,0,1488,1),(9132,99,0,1488,1),(9133,93,0,1488,58),(9134,142,0,1488,169),(9135,97,0,1489,1),(9136,134,0,1489,2),(9137,115,0,1489,1),(9138,99,0,1489,1),(9139,93,0,1489,49),(9140,142,0,1489,170),(9141,97,0,1490,1),(9142,134,0,1490,2),(9143,115,0,1490,1),(9144,99,0,1490,1),(9145,93,0,1490,50),(9146,142,0,1490,170),(9147,97,0,1491,1),(9148,134,0,1491,2),(9149,115,0,1491,1),(9150,99,0,1491,1),(9151,93,0,1491,58),(9152,142,0,1491,170),(9153,97,0,1492,1),(9154,134,0,1492,2),(9155,115,0,1492,1),(9156,99,0,1492,4),(9157,143,0,1492,0),(9158,144,0,1492,0),(9159,145,0,1492,0),(9160,146,0,1492,0),(9161,147,0,1492,1),(9162,97,0,1493,1),(9163,134,0,1493,2),(9164,115,0,1493,1),(9165,99,0,1493,1),(9166,93,0,1493,50),(9167,142,0,1493,166),(9168,97,0,1494,1),(9169,134,0,1494,2),(9170,115,0,1494,1),(9171,99,0,1494,1),(9172,93,0,1494,58),(9173,142,0,1494,166),(9174,97,0,1495,1),(9175,134,0,1495,2),(9176,115,0,1495,1),(9177,99,0,1495,1),(9178,93,0,1495,59),(9179,142,0,1495,166),(9180,97,0,1496,1),(9181,134,0,1496,2),(9182,115,0,1496,1),(9183,99,0,1496,1),(9184,93,0,1496,50),(9185,142,0,1496,167),(9186,97,0,1497,1),(9187,134,0,1497,2),(9188,115,0,1497,1),(9189,99,0,1497,1),(9190,93,0,1497,58),(9191,142,0,1497,167),(9192,97,0,1498,1),(9193,134,0,1498,2),(9194,115,0,1498,1),(9195,99,0,1498,1),(9196,93,0,1498,59),(9197,142,0,1498,167),(9198,97,0,1499,1),(9199,134,0,1499,2),(9200,115,0,1499,1),(9201,99,0,1499,1),(9202,93,0,1499,50),(9203,142,0,1499,168),(9204,97,0,1500,1),(9205,134,0,1500,2),(9206,115,0,1500,1),(9207,99,0,1500,1),(9208,93,0,1500,58),(9209,142,0,1500,168),(9210,97,0,1501,1),(9211,134,0,1501,2),(9212,115,0,1501,1),(9213,99,0,1501,1),(9214,93,0,1501,59),(9215,142,0,1501,168),(9216,97,0,1502,1),(9217,134,0,1502,2),(9218,115,0,1502,1),(9219,99,0,1502,1),(9220,93,0,1502,50),(9221,142,0,1502,169),(9222,97,0,1503,1),(9223,134,0,1503,2),(9224,115,0,1503,1),(9225,99,0,1503,1),(9226,93,0,1503,58),(9227,142,0,1503,169),(9228,97,0,1504,1),(9229,134,0,1504,2),(9230,115,0,1504,1),(9231,99,0,1504,1),(9232,93,0,1504,59),(9233,142,0,1504,169),(9234,97,0,1505,1),(9235,134,0,1505,2),(9236,115,0,1505,1),(9237,99,0,1505,1),(9238,93,0,1505,50),(9239,142,0,1505,170),(9240,97,0,1506,1),(9241,134,0,1506,2),(9242,115,0,1506,1),(9243,99,0,1506,1),(9244,93,0,1506,58),(9245,142,0,1506,170),(9246,97,0,1507,1),(9247,134,0,1507,2),(9248,115,0,1507,1),(9249,99,0,1507,1),(9250,93,0,1507,59),(9251,142,0,1507,170),(9252,97,0,1508,1),(9253,134,0,1508,2),(9254,115,0,1508,1),(9255,99,0,1508,4),(9256,143,0,1508,1),(9257,144,0,1508,0),(9258,145,0,1508,0),(9259,146,0,1508,0),(9260,147,0,1508,1),(9261,97,0,1509,1),(9262,134,0,1509,2),(9263,115,0,1509,1),(9264,99,0,1509,1),(9265,93,0,1509,53),(9266,142,0,1509,166),(9267,97,0,1510,1),(9268,134,0,1510,2),(9269,115,0,1510,1),(9270,99,0,1510,1),(9271,93,0,1510,58),(9272,142,0,1510,166),(9273,97,0,1511,1),(9274,134,0,1511,2),(9275,115,0,1511,1),(9276,99,0,1511,1),(9277,93,0,1511,60),(9278,142,0,1511,166),(9279,97,0,1512,1),(9280,134,0,1512,2),(9281,115,0,1512,1),(9282,99,0,1512,1),(9283,93,0,1512,53),(9284,142,0,1512,167),(9285,97,0,1513,1),(9286,134,0,1513,2),(9287,115,0,1513,1),(9288,99,0,1513,1),(9289,93,0,1513,58),(9290,142,0,1513,167),(9291,97,0,1514,1),(9292,134,0,1514,2),(9293,115,0,1514,1),(9294,99,0,1514,1),(9295,93,0,1514,60),(9296,142,0,1514,167),(9297,97,0,1515,1),(9298,134,0,1515,2),(9299,115,0,1515,1),(9300,99,0,1515,1),(9301,93,0,1515,53),(9302,142,0,1515,168),(9303,97,0,1516,1),(9304,134,0,1516,2),(9305,115,0,1516,1),(9306,99,0,1516,1),(9307,93,0,1516,58),(9308,142,0,1516,168),(9309,97,0,1517,1),(9310,134,0,1517,2),(9311,115,0,1517,1),(9312,99,0,1517,1),(9313,93,0,1517,60),(9314,142,0,1517,168),(9315,97,0,1518,1),(9316,134,0,1518,2),(9317,115,0,1518,1),(9318,99,0,1518,1),(9319,93,0,1518,53),(9320,142,0,1518,169),(9321,97,0,1519,1),(9322,134,0,1519,2),(9323,115,0,1519,1),(9324,99,0,1519,1),(9325,93,0,1519,58),(9326,142,0,1519,169),(9327,97,0,1520,1),(9328,134,0,1520,2),(9329,115,0,1520,1),(9330,99,0,1520,1),(9331,93,0,1520,60),(9332,142,0,1520,169),(9333,97,0,1521,1),(9334,134,0,1521,2),(9335,115,0,1521,1),(9336,99,0,1521,1),(9337,93,0,1521,53),(9338,142,0,1521,170),(9339,97,0,1522,1),(9340,134,0,1522,2),(9341,115,0,1522,1),(9342,99,0,1522,1),(9343,93,0,1522,58),(9344,142,0,1522,170),(9345,97,0,1523,1),(9346,134,0,1523,2),(9347,115,0,1523,1),(9348,99,0,1523,1),(9349,93,0,1523,60),(9350,142,0,1523,170),(9351,97,0,1524,1),(9352,134,0,1524,2),(9353,115,0,1524,1),(9354,99,0,1524,4),(9355,143,0,1524,0),(9356,144,0,1524,1),(9357,145,0,1524,0),(9358,146,0,1524,0),(9359,147,0,1524,0),(9360,97,0,1525,1),(9361,134,0,1525,2),(9362,115,0,1525,1),(9363,99,0,1525,1),(9364,93,0,1525,53),(9365,142,0,1525,166),(9366,97,0,1526,1),(9367,134,0,1526,2),(9368,115,0,1526,1),(9369,99,0,1526,1),(9370,93,0,1526,56),(9371,142,0,1526,166),(9372,97,0,1527,1),(9373,134,0,1527,2),(9374,115,0,1527,1),(9375,99,0,1527,1),(9376,93,0,1527,60),(9377,142,0,1527,166),(9378,97,0,1528,1),(9379,134,0,1528,2),(9380,115,0,1528,1),(9381,99,0,1528,1),(9382,93,0,1528,53),(9383,142,0,1528,167),(9384,97,0,1529,1),(9385,134,0,1529,2),(9386,115,0,1529,1),(9387,99,0,1529,1),(9388,93,0,1529,56),(9389,142,0,1529,167),(9390,97,0,1530,1),(9391,134,0,1530,2),(9392,115,0,1530,1),(9393,99,0,1530,1),(9394,93,0,1530,60),(9395,142,0,1530,167),(9396,97,0,1531,1),(9397,134,0,1531,2),(9398,115,0,1531,1),(9399,99,0,1531,1),(9400,93,0,1531,53),(9401,142,0,1531,168),(9402,97,0,1532,1),(9403,134,0,1532,2),(9404,115,0,1532,1),(9405,99,0,1532,1),(9406,93,0,1532,56),(9407,142,0,1532,168),(9408,97,0,1533,1),(9409,134,0,1533,2),(9410,115,0,1533,1),(9411,99,0,1533,1),(9412,93,0,1533,60),(9413,142,0,1533,168),(9414,97,0,1534,1),(9415,134,0,1534,2),(9416,115,0,1534,1),(9417,99,0,1534,1),(9418,93,0,1534,53),(9419,142,0,1534,169),(9420,97,0,1535,1),(9421,134,0,1535,2),(9422,115,0,1535,1),(9423,99,0,1535,1),(9424,93,0,1535,56),(9425,142,0,1535,169),(9426,97,0,1536,1),(9427,134,0,1536,2),(9428,115,0,1536,1),(9429,99,0,1536,1),(9430,93,0,1536,60),(9431,142,0,1536,169),(9432,97,0,1537,1),(9433,134,0,1537,2),(9434,115,0,1537,1),(9435,99,0,1537,1),(9436,93,0,1537,53),(9437,142,0,1537,170),(9438,97,0,1538,1),(9439,134,0,1538,2),(9440,115,0,1538,1),(9441,99,0,1538,1),(9442,93,0,1538,56),(9443,142,0,1538,170),(9444,97,0,1539,1),(9445,134,0,1539,2),(9446,115,0,1539,1),(9447,99,0,1539,1),(9448,93,0,1539,60),(9449,142,0,1539,170),(9450,97,0,1540,1),(9451,134,0,1540,2),(9452,115,0,1540,1),(9453,99,0,1540,4),(9454,143,0,1540,0),(9455,144,0,1540,0),(9456,145,0,1540,1),(9457,146,0,1540,0),(9458,147,0,1540,1),(9459,97,0,1541,1),(9460,134,0,1541,2),(9461,115,0,1541,1),(9462,99,0,1541,1),(9463,93,0,1541,50),(9464,142,0,1541,166),(9465,97,0,1542,1),(9466,134,0,1542,2),(9467,115,0,1542,1),(9468,99,0,1542,1),(9469,93,0,1542,56),(9470,142,0,1542,166),(9471,97,0,1543,1),(9472,134,0,1543,2),(9473,115,0,1543,1),(9474,99,0,1543,1),(9475,93,0,1543,57),(9476,142,0,1543,166),(9477,97,0,1544,1),(9478,134,0,1544,2),(9479,115,0,1544,1),(9480,99,0,1544,1),(9481,93,0,1544,50),(9482,142,0,1544,167),(9483,97,0,1545,1),(9484,134,0,1545,2),(9485,115,0,1545,1),(9486,99,0,1545,1),(9487,93,0,1545,56),(9488,142,0,1545,167),(9489,97,0,1546,1),(9490,134,0,1546,2),(9491,115,0,1546,1),(9492,99,0,1546,1),(9493,93,0,1546,57),(9494,142,0,1546,167),(9495,97,0,1547,1),(9496,134,0,1547,2),(9497,115,0,1547,1),(9498,99,0,1547,1),(9499,93,0,1547,50),(9500,142,0,1547,168),(9501,97,0,1548,1),(9502,134,0,1548,2),(9503,115,0,1548,1),(9504,99,0,1548,1),(9505,93,0,1548,56),(9506,142,0,1548,168),(9507,97,0,1549,1),(9508,134,0,1549,2),(9509,115,0,1549,1),(9510,99,0,1549,1),(9511,93,0,1549,57),(9512,142,0,1549,168),(9513,97,0,1550,1),(9514,134,0,1550,2),(9515,115,0,1550,1),(9516,99,0,1550,1),(9517,93,0,1550,50),(9518,142,0,1550,169),(9519,97,0,1551,1),(9520,134,0,1551,2),(9521,115,0,1551,1),(9522,99,0,1551,1),(9523,93,0,1551,56),(9524,142,0,1551,169),(9525,97,0,1552,1),(9526,134,0,1552,2),(9527,115,0,1552,1),(9528,99,0,1552,1),(9529,93,0,1552,57),(9530,142,0,1552,169),(9531,97,0,1553,1),(9532,134,0,1553,2),(9533,115,0,1553,1),(9534,99,0,1553,1),(9535,93,0,1553,50),(9536,142,0,1553,170),(9537,97,0,1554,1),(9538,134,0,1554,2),(9539,115,0,1554,1),(9540,99,0,1554,1),(9541,93,0,1554,56),(9542,142,0,1554,170),(9543,97,0,1555,1),(9544,134,0,1555,2),(9545,115,0,1555,1),(9546,99,0,1555,1),(9547,93,0,1555,57),(9548,142,0,1555,170),(9549,97,0,1556,1),(9550,134,0,1556,2),(9551,115,0,1556,1),(9552,99,0,1556,4),(9553,143,0,1556,1),(9554,144,0,1556,1),(9555,145,0,1556,0),(9556,146,0,1556,0),(9557,147,0,1556,0),(9558,97,0,1557,1),(9559,134,0,1557,2),(9560,115,0,1557,1),(9561,99,0,1557,1),(9562,93,0,1557,49),(9563,142,0,1557,166),(9564,97,0,1558,1),(9565,134,0,1558,2),(9566,115,0,1558,1),(9567,99,0,1558,1),(9568,93,0,1558,53),(9569,142,0,1558,166),(9570,97,0,1559,1),(9571,134,0,1559,2),(9572,115,0,1559,1),(9573,99,0,1559,1),(9574,93,0,1559,60),(9575,142,0,1559,166),(9576,97,0,1560,1),(9577,134,0,1560,2),(9578,115,0,1560,1),(9579,99,0,1560,1),(9580,93,0,1560,49),(9581,142,0,1560,167),(9582,97,0,1561,1),(9583,134,0,1561,2),(9584,115,0,1561,1),(9585,99,0,1561,1),(9586,93,0,1561,53),(9587,142,0,1561,167),(9588,97,0,1562,1),(9589,134,0,1562,2),(9590,115,0,1562,1),(9591,99,0,1562,1),(9592,93,0,1562,60),(9593,142,0,1562,167),(9594,97,0,1563,1),(9595,134,0,1563,2),(9596,115,0,1563,1),(9597,99,0,1563,1),(9598,93,0,1563,49),(9599,142,0,1563,168),(9600,97,0,1564,1),(9601,134,0,1564,2),(9602,115,0,1564,1),(9603,99,0,1564,1),(9604,93,0,1564,53),(9605,142,0,1564,168),(9606,97,0,1565,1),(9607,134,0,1565,2),(9608,115,0,1565,1),(9609,99,0,1565,1),(9610,93,0,1565,60),(9611,142,0,1565,168),(9612,97,0,1566,1),(9613,134,0,1566,2),(9614,115,0,1566,1),(9615,99,0,1566,1),(9616,93,0,1566,49),(9617,142,0,1566,169),(9618,97,0,1567,1),(9619,134,0,1567,2),(9620,115,0,1567,1),(9621,99,0,1567,1),(9622,93,0,1567,53),(9623,142,0,1567,169),(9624,97,0,1568,1),(9625,134,0,1568,2),(9626,115,0,1568,1),(9627,99,0,1568,1),(9628,93,0,1568,60),(9629,142,0,1568,169),(9630,97,0,1569,1),(9631,134,0,1569,2),(9632,115,0,1569,1),(9633,99,0,1569,1),(9634,93,0,1569,49),(9635,142,0,1569,170),(9636,97,0,1570,1),(9637,134,0,1570,2),(9638,115,0,1570,1),(9639,99,0,1570,1),(9640,93,0,1570,53),(9641,142,0,1570,170),(9642,97,0,1571,1),(9643,134,0,1571,2),(9644,115,0,1571,1),(9645,99,0,1571,1),(9646,93,0,1571,60),(9647,142,0,1571,170),(9648,97,0,1572,1),(9649,134,0,1572,2),(9650,115,0,1572,1),(9651,99,0,1572,4),(9652,143,0,1572,0),(9653,144,0,1572,0),(9654,145,0,1572,0),(9655,146,0,1572,0),(9656,147,0,1572,0),(9657,97,0,1573,1),(9658,134,0,1573,2),(9659,115,0,1573,1),(9660,99,0,1573,1),(9661,93,0,1573,49),(9662,142,0,1573,166),(9663,97,0,1574,1),(9664,134,0,1574,2),(9665,115,0,1574,1),(9666,99,0,1574,1),(9667,93,0,1574,56),(9668,142,0,1574,166),(9669,97,0,1575,1),(9670,134,0,1575,2),(9671,115,0,1575,1),(9672,99,0,1575,1),(9673,93,0,1575,60),(9674,142,0,1575,166),(9675,97,0,1576,1),(9676,134,0,1576,2),(9677,115,0,1576,1),(9678,99,0,1576,1),(9679,93,0,1576,49),(9680,142,0,1576,167),(9681,97,0,1577,1),(9682,134,0,1577,2),(9683,115,0,1577,1),(9684,99,0,1577,1),(9685,93,0,1577,56),(9686,142,0,1577,167),(9687,97,0,1578,1),(9688,134,0,1578,2),(9689,115,0,1578,1),(9690,99,0,1578,1),(9691,93,0,1578,60),(9692,142,0,1578,167),(9693,97,0,1579,1),(9694,134,0,1579,2),(9695,115,0,1579,1),(9696,99,0,1579,1),(9697,93,0,1579,49),(9698,142,0,1579,168),(9699,97,0,1580,1),(9700,134,0,1580,2),(9701,115,0,1580,1),(9702,99,0,1580,1),(9703,93,0,1580,56),(9704,142,0,1580,168),(9705,97,0,1581,1),(9706,134,0,1581,2),(9707,115,0,1581,1),(9708,99,0,1581,1),(9709,93,0,1581,60),(9710,142,0,1581,168),(9711,97,0,1582,1),(9712,134,0,1582,2),(9713,115,0,1582,1),(9714,99,0,1582,1),(9715,93,0,1582,49),(9716,142,0,1582,169),(9717,97,0,1583,1),(9718,134,0,1583,2),(9719,115,0,1583,1),(9720,99,0,1583,1),(9721,93,0,1583,56),(9722,142,0,1583,169),(9723,97,0,1584,1),(9724,134,0,1584,2),(9725,115,0,1584,1),(9726,99,0,1584,1),(9727,93,0,1584,60),(9728,142,0,1584,169),(9729,97,0,1585,1),(9730,134,0,1585,2),(9731,115,0,1585,1),(9732,99,0,1585,1),(9733,93,0,1585,49),(9734,142,0,1585,170),(9735,97,0,1586,1),(9736,134,0,1586,2),(9737,115,0,1586,1),(9738,99,0,1586,1),(9739,93,0,1586,56),(9740,142,0,1586,170),(9741,97,0,1587,1),(9742,134,0,1587,2),(9743,115,0,1587,1),(9744,99,0,1587,1),(9745,93,0,1587,60),(9746,142,0,1587,170),(9747,97,0,1588,1),(9748,134,0,1588,2),(9749,115,0,1588,1),(9750,99,0,1588,4),(9751,143,0,1588,0),(9752,144,0,1588,0),(9753,145,0,1588,0),(9754,146,0,1588,0),(9755,147,0,1588,0),(9756,97,0,1589,1),(9757,134,0,1589,2),(9758,115,0,1589,1),(9759,99,0,1589,1),(9760,93,0,1589,49),(9761,142,0,1589,166),(9762,97,0,1590,1),(9763,134,0,1590,2),(9764,115,0,1590,1),(9765,99,0,1590,1),(9766,93,0,1590,52),(9767,142,0,1590,166),(9768,97,0,1591,1),(9769,134,0,1591,2),(9770,115,0,1591,1),(9771,99,0,1591,1),(9772,93,0,1591,57),(9773,142,0,1591,166),(9774,97,0,1592,1),(9775,134,0,1592,2),(9776,115,0,1592,1),(9777,99,0,1592,1),(9778,93,0,1592,49),(9779,142,0,1592,167),(9780,97,0,1593,1),(9781,134,0,1593,2),(9782,115,0,1593,1),(9783,99,0,1593,1),(9784,93,0,1593,52),(9785,142,0,1593,167),(9786,97,0,1594,1),(9787,134,0,1594,2),(9788,115,0,1594,1),(9789,99,0,1594,1),(9790,93,0,1594,57),(9791,142,0,1594,167),(9792,97,0,1595,1),(9793,134,0,1595,2),(9794,115,0,1595,1),(9795,99,0,1595,1),(9796,93,0,1595,49),(9797,142,0,1595,168),(9798,97,0,1596,1),(9799,134,0,1596,2),(9800,115,0,1596,1),(9801,99,0,1596,1),(9802,93,0,1596,52),(9803,142,0,1596,168),(9804,97,0,1597,1),(9805,134,0,1597,2),(9806,115,0,1597,1),(9807,99,0,1597,1),(9808,93,0,1597,57),(9809,142,0,1597,168),(9810,97,0,1598,1),(9811,134,0,1598,2),(9812,115,0,1598,1),(9813,99,0,1598,1),(9814,93,0,1598,49),(9815,142,0,1598,169),(9816,97,0,1599,1),(9817,134,0,1599,2),(9818,115,0,1599,1),(9819,99,0,1599,1),(9820,93,0,1599,52),(9821,142,0,1599,169),(9822,97,0,1600,1),(9823,134,0,1600,2),(9824,115,0,1600,1),(9825,99,0,1600,1),(9826,93,0,1600,57),(9827,142,0,1600,169),(9828,97,0,1601,1),(9829,134,0,1601,2),(9830,115,0,1601,1),(9831,99,0,1601,1),(9832,93,0,1601,49),(9833,142,0,1601,170),(9834,97,0,1602,1),(9835,134,0,1602,2),(9836,115,0,1602,1),(9837,99,0,1602,1),(9838,93,0,1602,52),(9839,142,0,1602,170),(9840,97,0,1603,1),(9841,134,0,1603,2),(9842,115,0,1603,1),(9843,99,0,1603,1),(9844,93,0,1603,57),(9845,142,0,1603,170),(9846,97,0,1604,1),(9847,134,0,1604,2),(9848,115,0,1604,1),(9849,99,0,1604,4),(9850,143,0,1604,1),(9851,144,0,1604,0),(9852,145,0,1604,0),(9853,146,0,1604,0),(9854,147,0,1604,1),(9855,97,0,1605,1),(9856,134,0,1605,2),(9857,115,0,1605,1),(9858,99,0,1605,1),(9859,93,0,1605,50),(9860,142,0,1605,166),(9861,97,0,1606,1),(9862,134,0,1606,2),(9863,115,0,1606,1),(9864,99,0,1606,1),(9865,93,0,1606,56),(9866,142,0,1606,166),(9867,97,0,1607,1),(9868,134,0,1607,2),(9869,115,0,1607,1),(9870,99,0,1607,1),(9871,93,0,1607,60),(9872,142,0,1607,166),(9873,97,0,1608,1),(9874,134,0,1608,2),(9875,115,0,1608,1),(9876,99,0,1608,1),(9877,93,0,1608,50),(9878,142,0,1608,167),(9879,97,0,1609,1),(9880,134,0,1609,2),(9881,115,0,1609,1),(9882,99,0,1609,1),(9883,93,0,1609,56),(9884,142,0,1609,167),(9885,97,0,1610,1),(9886,134,0,1610,2),(9887,115,0,1610,1),(9888,99,0,1610,1),(9889,93,0,1610,60),(9890,142,0,1610,167),(9891,97,0,1611,1),(9892,134,0,1611,2),(9893,115,0,1611,1),(9894,99,0,1611,1),(9895,93,0,1611,50),(9896,142,0,1611,168),(9897,97,0,1612,1),(9898,134,0,1612,2),(9899,115,0,1612,1),(9900,99,0,1612,1),(9901,93,0,1612,56),(9902,142,0,1612,168),(9903,97,0,1613,1),(9904,134,0,1613,2),(9905,115,0,1613,1),(9906,99,0,1613,1),(9907,93,0,1613,60),(9908,142,0,1613,168),(9909,97,0,1614,1),(9910,134,0,1614,2),(9911,115,0,1614,1),(9912,99,0,1614,1),(9913,93,0,1614,50),(9914,142,0,1614,169),(9915,97,0,1615,1),(9916,134,0,1615,2),(9917,115,0,1615,1),(9918,99,0,1615,1),(9919,93,0,1615,56),(9920,142,0,1615,169),(9921,97,0,1616,1),(9922,134,0,1616,2),(9923,115,0,1616,1),(9924,99,0,1616,1),(9925,93,0,1616,60),(9926,142,0,1616,169),(9927,97,0,1617,1),(9928,134,0,1617,2),(9929,115,0,1617,1),(9930,99,0,1617,1),(9931,93,0,1617,50),(9932,142,0,1617,170),(9933,97,0,1618,1),(9934,134,0,1618,2),(9935,115,0,1618,1),(9936,99,0,1618,1),(9937,93,0,1618,56),(9938,142,0,1618,170),(9939,97,0,1619,1),(9940,134,0,1619,2),(9941,115,0,1619,1),(9942,99,0,1619,1),(9943,93,0,1619,60),(9944,142,0,1619,170),(9945,97,0,1620,1),(9946,134,0,1620,2),(9947,115,0,1620,1),(9948,99,0,1620,4),(9949,143,0,1620,0),(9950,144,0,1620,0),(9951,145,0,1620,0),(9952,146,0,1620,0),(9953,147,0,1620,0),(9954,97,0,1621,1),(9955,134,0,1621,2),(9956,115,0,1621,1),(9957,99,0,1621,1),(9958,93,0,1621,53),(9959,142,0,1621,166),(9960,97,0,1622,1),(9961,134,0,1622,2),(9962,115,0,1622,1),(9963,99,0,1622,1),(9964,93,0,1622,58),(9965,142,0,1622,166),(9966,97,0,1623,1),(9967,134,0,1623,2),(9968,115,0,1623,1),(9969,99,0,1623,1),(9970,93,0,1623,60),(9971,142,0,1623,166),(9972,97,0,1624,1),(9973,134,0,1624,2),(9974,115,0,1624,1),(9975,99,0,1624,1),(9976,93,0,1624,53),(9977,142,0,1624,167),(9978,97,0,1625,1),(9979,134,0,1625,2),(9980,115,0,1625,1),(9981,99,0,1625,1),(9982,93,0,1625,58),(9983,142,0,1625,167),(9984,97,0,1626,1),(9985,134,0,1626,2),(9986,115,0,1626,1),(9987,99,0,1626,1),(9988,93,0,1626,60),(9989,142,0,1626,167),(9990,97,0,1627,1),(9991,134,0,1627,2),(9992,115,0,1627,1),(9993,99,0,1627,1),(9994,93,0,1627,53),(9995,142,0,1627,168),(9996,97,0,1628,1),(9997,134,0,1628,2),(9998,115,0,1628,1),(9999,99,0,1628,1),(10000,93,0,1628,58),(10001,142,0,1628,168),(10002,97,0,1629,1),(10003,134,0,1629,2),(10004,115,0,1629,1),(10005,99,0,1629,1),(10006,93,0,1629,60),(10007,142,0,1629,168),(10008,97,0,1630,1),(10009,134,0,1630,2),(10010,115,0,1630,1),(10011,99,0,1630,1),(10012,93,0,1630,53),(10013,142,0,1630,169),(10014,97,0,1631,1),(10015,134,0,1631,2),(10016,115,0,1631,1),(10017,99,0,1631,1),(10018,93,0,1631,58),(10019,142,0,1631,169),(10020,97,0,1632,1),(10021,134,0,1632,2),(10022,115,0,1632,1),(10023,99,0,1632,1),(10024,93,0,1632,60),(10025,142,0,1632,169),(10026,97,0,1633,1),(10027,134,0,1633,2),(10028,115,0,1633,1),(10029,99,0,1633,1),(10030,93,0,1633,53),(10031,142,0,1633,170),(10032,97,0,1634,1),(10033,134,0,1634,2),(10034,115,0,1634,1),(10035,99,0,1634,1),(10036,93,0,1634,58),(10037,142,0,1634,170),(10038,97,0,1635,1),(10039,134,0,1635,2),(10040,115,0,1635,1),(10041,99,0,1635,1),(10042,93,0,1635,60),(10043,142,0,1635,170),(10044,97,0,1636,1),(10045,134,0,1636,2),(10046,115,0,1636,1),(10047,99,0,1636,4),(10048,143,0,1636,0),(10049,144,0,1636,1),(10050,145,0,1636,0),(10051,146,0,1636,1),(10052,147,0,1636,0),(10053,97,0,1637,1),(10054,134,0,1637,2),(10055,115,0,1637,1),(10056,99,0,1637,1),(10057,93,0,1637,50),(10058,142,0,1637,166),(10059,97,0,1638,1),(10060,134,0,1638,2),(10061,115,0,1638,1),(10062,99,0,1638,1),(10063,93,0,1638,57),(10064,142,0,1638,166),(10065,97,0,1639,1),(10066,134,0,1639,2),(10067,115,0,1639,1),(10068,99,0,1639,1),(10069,93,0,1639,60),(10070,142,0,1639,166),(10071,97,0,1640,1),(10072,134,0,1640,2),(10073,115,0,1640,1),(10074,99,0,1640,1),(10075,93,0,1640,50),(10076,142,0,1640,167),(10077,97,0,1641,1),(10078,134,0,1641,2),(10079,115,0,1641,1),(10080,99,0,1641,1),(10081,93,0,1641,57),(10082,142,0,1641,167),(10083,97,0,1642,1),(10084,134,0,1642,2),(10085,115,0,1642,1),(10086,99,0,1642,1),(10087,93,0,1642,60),(10088,142,0,1642,167),(10089,97,0,1643,1),(10090,134,0,1643,2),(10091,115,0,1643,1),(10092,99,0,1643,1),(10093,93,0,1643,50),(10094,142,0,1643,168),(10095,97,0,1644,1),(10096,134,0,1644,2),(10097,115,0,1644,1),(10098,99,0,1644,1),(10099,93,0,1644,57),(10100,142,0,1644,168),(10101,97,0,1645,1),(10102,134,0,1645,2),(10103,115,0,1645,1),(10104,99,0,1645,1),(10105,93,0,1645,60),(10106,142,0,1645,168),(10107,97,0,1646,1),(10108,134,0,1646,2),(10109,115,0,1646,1),(10110,99,0,1646,1),(10111,93,0,1646,50),(10112,142,0,1646,169),(10113,97,0,1647,1),(10114,134,0,1647,2),(10115,115,0,1647,1),(10116,99,0,1647,1),(10117,93,0,1647,57),(10118,142,0,1647,169),(10119,97,0,1648,1),(10120,134,0,1648,2),(10121,115,0,1648,1),(10122,99,0,1648,1),(10123,93,0,1648,60),(10124,142,0,1648,169),(10125,97,0,1649,1),(10126,134,0,1649,2),(10127,115,0,1649,1),(10128,99,0,1649,1),(10129,93,0,1649,50),(10130,142,0,1649,170),(10131,97,0,1650,1),(10132,134,0,1650,2),(10133,115,0,1650,1),(10134,99,0,1650,1),(10135,93,0,1650,57),(10136,142,0,1650,170),(10137,97,0,1651,1),(10138,134,0,1651,2),(10139,115,0,1651,1),(10140,99,0,1651,1),(10141,93,0,1651,60),(10142,142,0,1651,170),(10143,97,0,1652,1),(10144,134,0,1652,2),(10145,115,0,1652,1),(10146,99,0,1652,4),(10147,143,0,1652,0),(10148,144,0,1652,0),(10149,145,0,1652,0),(10150,146,0,1652,0),(10151,147,0,1652,0),(10152,97,0,1653,1),(10153,134,0,1653,2),(10154,115,0,1653,1),(10155,99,0,1653,1),(10156,93,0,1653,49),(10157,142,0,1653,166),(10158,97,0,1654,1),(10159,134,0,1654,2),(10160,115,0,1654,1),(10161,99,0,1654,1),(10162,93,0,1654,56),(10163,142,0,1654,166),(10164,97,0,1655,1),(10165,134,0,1655,2),(10166,115,0,1655,1),(10167,99,0,1655,1),(10168,93,0,1655,57),(10169,142,0,1655,166),(10170,97,0,1656,1),(10171,134,0,1656,2),(10172,115,0,1656,1),(10173,99,0,1656,1),(10174,93,0,1656,49),(10175,142,0,1656,167),(10176,97,0,1657,1),(10177,134,0,1657,2),(10178,115,0,1657,1),(10179,99,0,1657,1),(10180,93,0,1657,56),(10181,142,0,1657,167),(10182,97,0,1658,1),(10183,134,0,1658,2),(10184,115,0,1658,1),(10185,99,0,1658,1),(10186,93,0,1658,57),(10187,142,0,1658,167),(10188,97,0,1659,1),(10189,134,0,1659,2),(10190,115,0,1659,1),(10191,99,0,1659,1),(10192,93,0,1659,49),(10193,142,0,1659,168),(10194,97,0,1660,1),(10195,134,0,1660,2),(10196,115,0,1660,1),(10197,99,0,1660,1),(10198,93,0,1660,56),(10199,142,0,1660,168),(10200,97,0,1661,1),(10201,134,0,1661,2),(10202,115,0,1661,1),(10203,99,0,1661,1),(10204,93,0,1661,57),(10205,142,0,1661,168),(10206,97,0,1662,1),(10207,134,0,1662,2),(10208,115,0,1662,1),(10209,99,0,1662,1),(10210,93,0,1662,49),(10211,142,0,1662,169),(10212,97,0,1663,1),(10213,134,0,1663,2),(10214,115,0,1663,1),(10215,99,0,1663,1),(10216,93,0,1663,56),(10217,142,0,1663,169),(10218,97,0,1664,1),(10219,134,0,1664,2),(10220,115,0,1664,1),(10221,99,0,1664,1),(10222,93,0,1664,57),(10223,142,0,1664,169),(10224,97,0,1665,1),(10225,134,0,1665,2),(10226,115,0,1665,1),(10227,99,0,1665,1),(10228,93,0,1665,49),(10229,142,0,1665,170),(10230,97,0,1666,1),(10231,134,0,1666,2),(10232,115,0,1666,1),(10233,99,0,1666,1),(10234,93,0,1666,56),(10235,142,0,1666,170),(10236,97,0,1667,1),(10237,134,0,1667,2),(10238,115,0,1667,1),(10239,99,0,1667,1),(10240,93,0,1667,57),(10241,142,0,1667,170),(10242,97,0,1668,1),(10243,134,0,1668,2),(10244,115,0,1668,1),(10245,99,0,1668,4),(10246,143,0,1668,0),(10247,144,0,1668,0),(10248,145,0,1668,0),(10249,146,0,1668,0),(10250,147,0,1668,0),(10251,97,0,1669,1),(10252,134,0,1669,2),(10253,115,0,1669,1),(10254,99,0,1669,1),(10255,93,0,1669,49),(10256,142,0,1669,166),(10257,97,0,1670,1),(10258,134,0,1670,2),(10259,115,0,1670,1),(10260,99,0,1670,1),(10261,93,0,1670,50),(10262,142,0,1670,166),(10263,97,0,1671,1),(10264,134,0,1671,2),(10265,115,0,1671,1),(10266,99,0,1671,1),(10267,93,0,1671,56),(10268,142,0,1671,166),(10269,97,0,1672,1),(10270,134,0,1672,2),(10271,115,0,1672,1),(10272,99,0,1672,1),(10273,93,0,1672,49),(10274,142,0,1672,167),(10275,97,0,1673,1),(10276,134,0,1673,2),(10277,115,0,1673,1),(10278,99,0,1673,1),(10279,93,0,1673,50),(10280,142,0,1673,167),(10281,97,0,1674,1),(10282,134,0,1674,2),(10283,115,0,1674,1),(10284,99,0,1674,1),(10285,93,0,1674,56),(10286,142,0,1674,167),(10287,97,0,1675,1),(10288,134,0,1675,2),(10289,115,0,1675,1),(10290,99,0,1675,1),(10291,93,0,1675,49),(10292,142,0,1675,168),(10293,97,0,1676,1),(10294,134,0,1676,2),(10295,115,0,1676,1),(10296,99,0,1676,1),(10297,93,0,1676,50),(10298,142,0,1676,168),(10299,97,0,1677,1),(10300,134,0,1677,2),(10301,115,0,1677,1),(10302,99,0,1677,1),(10303,93,0,1677,56),(10304,142,0,1677,168),(10305,97,0,1678,1),(10306,134,0,1678,2),(10307,115,0,1678,1),(10308,99,0,1678,1),(10309,93,0,1678,49),(10310,142,0,1678,169),(10311,97,0,1679,1),(10312,134,0,1679,2),(10313,115,0,1679,1),(10314,99,0,1679,1),(10315,93,0,1679,50),(10316,142,0,1679,169),(10317,97,0,1680,1),(10318,134,0,1680,2),(10319,115,0,1680,1),(10320,99,0,1680,1),(10321,93,0,1680,56),(10322,142,0,1680,169),(10323,97,0,1681,1),(10324,134,0,1681,2),(10325,115,0,1681,1),(10326,99,0,1681,1),(10327,93,0,1681,49),(10328,142,0,1681,170),(10329,97,0,1682,1),(10330,134,0,1682,2),(10331,115,0,1682,1),(10332,99,0,1682,1),(10333,93,0,1682,50),(10334,142,0,1682,170),(10335,97,0,1683,1),(10336,134,0,1683,2),(10337,115,0,1683,1),(10338,99,0,1683,1),(10339,93,0,1683,56),(10340,142,0,1683,170),(10341,97,0,1684,1),(10342,134,0,1684,2),(10343,115,0,1684,1),(10344,99,0,1684,4),(10345,143,0,1684,1),(10346,144,0,1684,0),(10347,145,0,1684,0),(10348,146,0,1684,0),(10349,147,0,1684,0),(10350,97,0,1685,1),(10351,134,0,1685,2),(10352,115,0,1685,1),(10353,99,0,1685,1),(10354,93,0,1685,53),(10355,142,0,1685,166),(10356,97,0,1686,1),(10357,134,0,1686,2),(10358,115,0,1686,1),(10359,99,0,1686,1),(10360,93,0,1686,56),(10361,142,0,1686,166),(10362,97,0,1687,1),(10363,134,0,1687,2),(10364,115,0,1687,1),(10365,99,0,1687,1),(10366,93,0,1687,60),(10367,142,0,1687,166),(10368,97,0,1688,1),(10369,134,0,1688,2),(10370,115,0,1688,1),(10371,99,0,1688,1),(10372,93,0,1688,53),(10373,142,0,1688,167),(10374,97,0,1689,1),(10375,134,0,1689,2),(10376,115,0,1689,1),(10377,99,0,1689,1),(10378,93,0,1689,56),(10379,142,0,1689,167),(10380,97,0,1690,1),(10381,134,0,1690,2),(10382,115,0,1690,1),(10383,99,0,1690,1),(10384,93,0,1690,60),(10385,142,0,1690,167),(10386,97,0,1691,1),(10387,134,0,1691,2),(10388,115,0,1691,1),(10389,99,0,1691,1),(10390,93,0,1691,53),(10391,142,0,1691,168),(10392,97,0,1692,1),(10393,134,0,1692,2),(10394,115,0,1692,1),(10395,99,0,1692,1),(10396,93,0,1692,56),(10397,142,0,1692,168),(10398,97,0,1693,1),(10399,134,0,1693,2),(10400,115,0,1693,1),(10401,99,0,1693,1),(10402,93,0,1693,60),(10403,142,0,1693,168),(10404,97,0,1694,1),(10405,134,0,1694,2),(10406,115,0,1694,1),(10407,99,0,1694,1),(10408,93,0,1694,53),(10409,142,0,1694,169),(10410,97,0,1695,1),(10411,134,0,1695,2),(10412,115,0,1695,1),(10413,99,0,1695,1),(10414,93,0,1695,56),(10415,142,0,1695,169),(10416,97,0,1696,1),(10417,134,0,1696,2),(10418,115,0,1696,1),(10419,99,0,1696,1),(10420,93,0,1696,60),(10421,142,0,1696,169),(10422,97,0,1697,1),(10423,134,0,1697,2),(10424,115,0,1697,1),(10425,99,0,1697,1),(10426,93,0,1697,53),(10427,142,0,1697,170),(10428,97,0,1698,1),(10429,134,0,1698,2),(10430,115,0,1698,1),(10431,99,0,1698,1),(10432,93,0,1698,56),(10433,142,0,1698,170),(10434,97,0,1699,1),(10435,134,0,1699,2),(10436,115,0,1699,1),(10437,99,0,1699,1),(10438,93,0,1699,60),(10439,142,0,1699,170),(10440,97,0,1700,1),(10441,134,0,1700,2),(10442,115,0,1700,1),(10443,99,0,1700,4),(10444,143,0,1700,0),(10445,144,0,1700,0),(10446,145,0,1700,0),(10447,146,0,1700,0),(10448,147,0,1700,0),(10449,97,0,1701,1),(10450,134,0,1701,2),(10451,115,0,1701,1),(10452,99,0,1701,1),(10453,93,0,1701,56),(10454,142,0,1701,166),(10455,97,0,1702,1),(10456,134,0,1702,2),(10457,115,0,1702,1),(10458,99,0,1702,1),(10459,93,0,1702,57),(10460,142,0,1702,166),(10461,97,0,1703,1),(10462,134,0,1703,2),(10463,115,0,1703,1),(10464,99,0,1703,1),(10465,93,0,1703,58),(10466,142,0,1703,166),(10467,97,0,1704,1),(10468,134,0,1704,2),(10469,115,0,1704,1),(10470,99,0,1704,1),(10471,93,0,1704,56),(10472,142,0,1704,167),(10473,97,0,1705,1),(10474,134,0,1705,2),(10475,115,0,1705,1),(10476,99,0,1705,1),(10477,93,0,1705,57),(10478,142,0,1705,167),(10479,97,0,1706,1),(10480,134,0,1706,2),(10481,115,0,1706,1),(10482,99,0,1706,1),(10483,93,0,1706,58),(10484,142,0,1706,167),(10485,97,0,1707,1),(10486,134,0,1707,2),(10487,115,0,1707,1),(10488,99,0,1707,1),(10489,93,0,1707,56),(10490,142,0,1707,168),(10491,97,0,1708,1),(10492,134,0,1708,2),(10493,115,0,1708,1),(10494,99,0,1708,1),(10495,93,0,1708,57),(10496,142,0,1708,168),(10497,97,0,1709,1),(10498,134,0,1709,2),(10499,115,0,1709,1),(10500,99,0,1709,1),(10501,93,0,1709,58),(10502,142,0,1709,168),(10503,97,0,1710,1),(10504,134,0,1710,2),(10505,115,0,1710,1),(10506,99,0,1710,1),(10507,93,0,1710,56),(10508,142,0,1710,169),(10509,97,0,1711,1),(10510,134,0,1711,2),(10511,115,0,1711,1),(10512,99,0,1711,1),(10513,93,0,1711,57),(10514,142,0,1711,169),(10515,97,0,1712,1),(10516,134,0,1712,2),(10517,115,0,1712,1),(10518,99,0,1712,1),(10519,93,0,1712,58),(10520,142,0,1712,169),(10521,97,0,1713,1),(10522,134,0,1713,2),(10523,115,0,1713,1),(10524,99,0,1713,1),(10525,93,0,1713,56),(10526,142,0,1713,170),(10527,97,0,1714,1),(10528,134,0,1714,2),(10529,115,0,1714,1),(10530,99,0,1714,1),(10531,93,0,1714,57),(10532,142,0,1714,170),(10533,97,0,1715,1),(10534,134,0,1715,2),(10535,115,0,1715,1),(10536,99,0,1715,1),(10537,93,0,1715,58),(10538,142,0,1715,170),(10539,97,0,1716,1),(10540,134,0,1716,2),(10541,115,0,1716,1),(10542,99,0,1716,4),(10543,143,0,1716,0),(10544,144,0,1716,0),(10545,145,0,1716,1),(10546,146,0,1716,1),(10547,147,0,1716,0),(10548,97,0,1717,1),(10549,134,0,1717,2),(10550,115,0,1717,1),(10551,99,0,1717,1),(10552,93,0,1717,50),(10553,142,0,1717,166),(10554,97,0,1718,1),(10555,134,0,1718,2),(10556,115,0,1718,1),(10557,99,0,1718,1),(10558,93,0,1718,57),(10559,142,0,1718,166),(10560,97,0,1719,1),(10561,134,0,1719,2),(10562,115,0,1719,1),(10563,99,0,1719,1),(10564,93,0,1719,58),(10565,142,0,1719,166),(10566,97,0,1720,1),(10567,134,0,1720,2),(10568,115,0,1720,1),(10569,99,0,1720,1),(10570,93,0,1720,50),(10571,142,0,1720,167),(10572,97,0,1721,1),(10573,134,0,1721,2),(10574,115,0,1721,1),(10575,99,0,1721,1),(10576,93,0,1721,57),(10577,142,0,1721,167),(10578,97,0,1722,1),(10579,134,0,1722,2),(10580,115,0,1722,1),(10581,99,0,1722,1),(10582,93,0,1722,58),(10583,142,0,1722,167),(10584,97,0,1723,1),(10585,134,0,1723,2),(10586,115,0,1723,1),(10587,99,0,1723,1),(10588,93,0,1723,50),(10589,142,0,1723,168),(10590,97,0,1724,1),(10591,134,0,1724,2),(10592,115,0,1724,1),(10593,99,0,1724,1),(10594,93,0,1724,57),(10595,142,0,1724,168),(10596,97,0,1725,1),(10597,134,0,1725,2),(10598,115,0,1725,1),(10599,99,0,1725,1),(10600,93,0,1725,58),(10601,142,0,1725,168),(10602,97,0,1726,1),(10603,134,0,1726,2),(10604,115,0,1726,1),(10605,99,0,1726,1),(10606,93,0,1726,50),(10607,142,0,1726,169),(10608,97,0,1727,1),(10609,134,0,1727,2),(10610,115,0,1727,1),(10611,99,0,1727,1),(10612,93,0,1727,57),(10613,142,0,1727,169),(10614,97,0,1728,1),(10615,134,0,1728,2),(10616,115,0,1728,1),(10617,99,0,1728,1),(10618,93,0,1728,58),(10619,142,0,1728,169),(10620,97,0,1729,1),(10621,134,0,1729,2),(10622,115,0,1729,1),(10623,99,0,1729,1),(10624,93,0,1729,50),(10625,142,0,1729,170),(10626,97,0,1730,1),(10627,134,0,1730,2),(10628,115,0,1730,1),(10629,99,0,1730,1),(10630,93,0,1730,57),(10631,142,0,1730,170),(10632,97,0,1731,1),(10633,134,0,1731,2),(10634,115,0,1731,1),(10635,99,0,1731,1),(10636,93,0,1731,58),(10637,142,0,1731,170),(10638,97,0,1732,1),(10639,134,0,1732,2),(10640,115,0,1732,1),(10641,99,0,1732,4),(10642,143,0,1732,1),(10643,144,0,1732,1),(10644,145,0,1732,0),(10645,146,0,1732,0),(10646,147,0,1732,0),(10647,97,0,1733,1),(10648,134,0,1733,2),(10649,115,0,1733,1),(10650,99,0,1733,1),(10651,93,0,1733,56),(10652,142,0,1733,166),(10653,97,0,1734,1),(10654,134,0,1734,2),(10655,115,0,1734,1),(10656,99,0,1734,1),(10657,93,0,1734,57),(10658,142,0,1734,166),(10659,97,0,1735,1),(10660,134,0,1735,2),(10661,115,0,1735,1),(10662,99,0,1735,1),(10663,93,0,1735,59),(10664,142,0,1735,166),(10665,97,0,1736,1),(10666,134,0,1736,2),(10667,115,0,1736,1),(10668,99,0,1736,1),(10669,93,0,1736,56),(10670,142,0,1736,167),(10671,97,0,1737,1),(10672,134,0,1737,2),(10673,115,0,1737,1),(10674,99,0,1737,1),(10675,93,0,1737,57),(10676,142,0,1737,167),(10677,97,0,1738,1),(10678,134,0,1738,2),(10679,115,0,1738,1),(10680,99,0,1738,1),(10681,93,0,1738,59),(10682,142,0,1738,167),(10683,97,0,1739,1),(10684,134,0,1739,2),(10685,115,0,1739,1),(10686,99,0,1739,1),(10687,93,0,1739,56),(10688,142,0,1739,168),(10689,97,0,1740,1),(10690,134,0,1740,2),(10691,115,0,1740,1),(10692,99,0,1740,1),(10693,93,0,1740,57),(10694,142,0,1740,168),(10695,97,0,1741,1),(10696,134,0,1741,2),(10697,115,0,1741,1),(10698,99,0,1741,1),(10699,93,0,1741,59),(10700,142,0,1741,168),(10701,97,0,1742,1),(10702,134,0,1742,2),(10703,115,0,1742,1),(10704,99,0,1742,1),(10705,93,0,1742,56),(10706,142,0,1742,169),(10707,97,0,1743,1),(10708,134,0,1743,2),(10709,115,0,1743,1),(10710,99,0,1743,1),(10711,93,0,1743,57),(10712,142,0,1743,169),(10713,97,0,1744,1),(10714,134,0,1744,2),(10715,115,0,1744,1),(10716,99,0,1744,1),(10717,93,0,1744,59),(10718,142,0,1744,169),(10719,97,0,1745,1),(10720,134,0,1745,2),(10721,115,0,1745,1),(10722,99,0,1745,1),(10723,93,0,1745,56),(10724,142,0,1745,170),(10725,97,0,1746,1),(10726,134,0,1746,2),(10727,115,0,1746,1),(10728,99,0,1746,1),(10729,93,0,1746,57),(10730,142,0,1746,170),(10731,97,0,1747,1),(10732,134,0,1747,2),(10733,115,0,1747,1),(10734,99,0,1747,1),(10735,93,0,1747,59),(10736,142,0,1747,170),(10737,97,0,1748,1),(10738,134,0,1748,2),(10739,115,0,1748,1),(10740,99,0,1748,4),(10741,143,0,1748,0),(10742,144,0,1748,0),(10743,145,0,1748,1),(10744,146,0,1748,0),(10745,147,0,1748,0),(10746,97,0,1749,1),(10747,134,0,1749,2),(10748,115,0,1749,1),(10749,99,0,1749,1),(10750,93,0,1749,50),(10751,142,0,1749,166),(10752,97,0,1750,1),(10753,134,0,1750,2),(10754,115,0,1750,1),(10755,99,0,1750,1),(10756,93,0,1750,58),(10757,142,0,1750,166),(10758,97,0,1751,1),(10759,134,0,1751,2),(10760,115,0,1751,1),(10761,99,0,1751,1),(10762,93,0,1751,60),(10763,142,0,1751,166),(10764,97,0,1752,1),(10765,134,0,1752,2),(10766,115,0,1752,1),(10767,99,0,1752,1),(10768,93,0,1752,50),(10769,142,0,1752,167),(10770,97,0,1753,1),(10771,134,0,1753,2),(10772,115,0,1753,1),(10773,99,0,1753,1),(10774,93,0,1753,58),(10775,142,0,1753,167),(10776,97,0,1754,1),(10777,134,0,1754,2),(10778,115,0,1754,1),(10779,99,0,1754,1),(10780,93,0,1754,60),(10781,142,0,1754,167),(10782,97,0,1755,1),(10783,134,0,1755,2),(10784,115,0,1755,1),(10785,99,0,1755,1),(10786,93,0,1755,50),(10787,142,0,1755,168),(10788,97,0,1756,1),(10789,134,0,1756,2),(10790,115,0,1756,1),(10791,99,0,1756,1),(10792,93,0,1756,58),(10793,142,0,1756,168),(10794,97,0,1757,1),(10795,134,0,1757,2),(10796,115,0,1757,1),(10797,99,0,1757,1),(10798,93,0,1757,60),(10799,142,0,1757,168),(10800,97,0,1758,1),(10801,134,0,1758,2),(10802,115,0,1758,1),(10803,99,0,1758,1),(10804,93,0,1758,50),(10805,142,0,1758,169),(10806,97,0,1759,1),(10807,134,0,1759,2),(10808,115,0,1759,1),(10809,99,0,1759,1),(10810,93,0,1759,58),(10811,142,0,1759,169),(10812,97,0,1760,1),(10813,134,0,1760,2),(10814,115,0,1760,1),(10815,99,0,1760,1),(10816,93,0,1760,60),(10817,142,0,1760,169),(10818,97,0,1761,1),(10819,134,0,1761,2),(10820,115,0,1761,1),(10821,99,0,1761,1),(10822,93,0,1761,50),(10823,142,0,1761,170),(10824,97,0,1762,1),(10825,134,0,1762,2),(10826,115,0,1762,1),(10827,99,0,1762,1),(10828,93,0,1762,58),(10829,142,0,1762,170),(10830,97,0,1763,1),(10831,134,0,1763,2),(10832,115,0,1763,1),(10833,99,0,1763,1),(10834,93,0,1763,60),(10835,142,0,1763,170),(10836,97,0,1764,1),(10837,134,0,1764,2),(10838,115,0,1764,1),(10839,99,0,1764,4),(10840,143,0,1764,0),(10841,144,0,1764,0),(10842,145,0,1764,0),(10843,146,0,1764,0),(10844,147,0,1764,0),(10845,97,0,1765,1),(10846,134,0,1765,2),(10847,115,0,1765,1),(10848,99,0,1765,1),(10849,93,0,1765,53),(10850,142,0,1765,166),(10851,97,0,1766,1),(10852,134,0,1766,2),(10853,115,0,1766,1),(10854,99,0,1766,1),(10855,93,0,1766,59),(10856,142,0,1766,166),(10857,97,0,1767,1),(10858,134,0,1767,2),(10859,115,0,1767,1),(10860,99,0,1767,1),(10861,93,0,1767,60),(10862,142,0,1767,166),(10863,97,0,1768,1),(10864,134,0,1768,2),(10865,115,0,1768,1),(10866,99,0,1768,1),(10867,93,0,1768,53),(10868,142,0,1768,167),(10869,97,0,1769,1),(10870,134,0,1769,2),(10871,115,0,1769,1),(10872,99,0,1769,1),(10873,93,0,1769,59),(10874,142,0,1769,167),(10875,97,0,1770,1),(10876,134,0,1770,2),(10877,115,0,1770,1),(10878,99,0,1770,1),(10879,93,0,1770,60),(10880,142,0,1770,167),(10881,97,0,1771,1),(10882,134,0,1771,2),(10883,115,0,1771,1),(10884,99,0,1771,1),(10885,93,0,1771,53),(10886,142,0,1771,168),(10887,97,0,1772,1),(10888,134,0,1772,2),(10889,115,0,1772,1),(10890,99,0,1772,1),(10891,93,0,1772,59),(10892,142,0,1772,168),(10893,97,0,1773,1),(10894,134,0,1773,2),(10895,115,0,1773,1),(10896,99,0,1773,1),(10897,93,0,1773,60),(10898,142,0,1773,168),(10899,97,0,1774,1),(10900,134,0,1774,2),(10901,115,0,1774,1),(10902,99,0,1774,1),(10903,93,0,1774,53),(10904,142,0,1774,169),(10905,97,0,1775,1),(10906,134,0,1775,2),(10907,115,0,1775,1),(10908,99,0,1775,1),(10909,93,0,1775,59),(10910,142,0,1775,169),(10911,97,0,1776,1),(10912,134,0,1776,2),(10913,115,0,1776,1),(10914,99,0,1776,1),(10915,93,0,1776,60),(10916,142,0,1776,169),(10917,97,0,1777,1),(10918,134,0,1777,2),(10919,115,0,1777,1),(10920,99,0,1777,1),(10921,93,0,1777,53),(10922,142,0,1777,170),(10923,97,0,1778,1),(10924,134,0,1778,2),(10925,115,0,1778,1),(10926,99,0,1778,1),(10927,93,0,1778,59),(10928,142,0,1778,170),(10929,97,0,1779,1),(10930,134,0,1779,2),(10931,115,0,1779,1),(10932,99,0,1779,1),(10933,93,0,1779,60),(10934,142,0,1779,170),(10935,97,0,1780,1),(10936,134,0,1780,2),(10937,115,0,1780,1),(10938,99,0,1780,4),(10939,143,0,1780,0),(10940,144,0,1780,1),(10941,145,0,1780,0),(10942,146,0,1780,0),(10943,147,0,1780,0),(10944,97,0,1781,1),(10945,134,0,1781,2),(10946,115,0,1781,1),(10947,99,0,1781,1),(10948,93,0,1781,49),(10949,142,0,1781,166),(10950,97,0,1782,1),(10951,134,0,1782,2),(10952,115,0,1782,1),(10953,99,0,1782,1),(10954,93,0,1782,57),(10955,142,0,1782,166),(10956,97,0,1783,1),(10957,134,0,1783,2),(10958,115,0,1783,1),(10959,99,0,1783,1),(10960,93,0,1783,60),(10961,142,0,1783,166),(10962,97,0,1784,1),(10963,134,0,1784,2),(10964,115,0,1784,1),(10965,99,0,1784,1),(10966,93,0,1784,49),(10967,142,0,1784,167),(10968,97,0,1785,1),(10969,134,0,1785,2),(10970,115,0,1785,1),(10971,99,0,1785,1),(10972,93,0,1785,57),(10973,142,0,1785,167),(10974,97,0,1786,1),(10975,134,0,1786,2),(10976,115,0,1786,1),(10977,99,0,1786,1),(10978,93,0,1786,60),(10979,142,0,1786,167),(10980,97,0,1787,1),(10981,134,0,1787,2),(10982,115,0,1787,1),(10983,99,0,1787,1),(10984,93,0,1787,49),(10985,142,0,1787,168),(10986,97,0,1788,1),(10987,134,0,1788,2),(10988,115,0,1788,1),(10989,99,0,1788,1),(10990,93,0,1788,57),(10991,142,0,1788,168),(10992,97,0,1789,1),(10993,134,0,1789,2),(10994,115,0,1789,1),(10995,99,0,1789,1),(10996,93,0,1789,60),(10997,142,0,1789,168),(10998,97,0,1790,1),(10999,134,0,1790,2),(11000,115,0,1790,1),(11001,99,0,1790,1),(11002,93,0,1790,49),(11003,142,0,1790,169),(11004,97,0,1791,1),(11005,134,0,1791,2),(11006,115,0,1791,1),(11007,99,0,1791,1),(11008,93,0,1791,57),(11009,142,0,1791,169),(11010,97,0,1792,1),(11011,134,0,1792,2),(11012,115,0,1792,1),(11013,99,0,1792,1),(11014,93,0,1792,60),(11015,142,0,1792,169),(11016,97,0,1793,1),(11017,134,0,1793,2),(11018,115,0,1793,1),(11019,99,0,1793,1),(11020,93,0,1793,49),(11021,142,0,1793,170),(11022,97,0,1794,1),(11023,134,0,1794,2),(11024,115,0,1794,1),(11025,99,0,1794,1),(11026,93,0,1794,57),(11027,142,0,1794,170),(11028,97,0,1795,1),(11029,134,0,1795,2),(11030,115,0,1795,1),(11031,99,0,1795,1),(11032,93,0,1795,60),(11033,142,0,1795,170),(11034,97,0,1796,1),(11035,134,0,1796,2),(11036,115,0,1796,1),(11037,99,0,1796,4),(11038,143,0,1796,0),(11039,144,0,1796,1),(11040,145,0,1796,0),(11041,146,0,1796,0),(11042,147,0,1796,1),(11043,97,0,1797,1),(11044,134,0,1797,2),(11045,115,0,1797,1),(11046,99,0,1797,1),(11047,93,0,1797,57),(11048,142,0,1797,166),(11049,97,0,1798,1),(11050,134,0,1798,2),(11051,115,0,1798,1),(11052,99,0,1798,1),(11053,93,0,1798,59),(11054,142,0,1798,166),(11055,97,0,1799,1),(11056,134,0,1799,2),(11057,115,0,1799,1),(11058,99,0,1799,1),(11059,93,0,1799,60),(11060,142,0,1799,166),(11061,97,0,1800,1),(11062,134,0,1800,2),(11063,115,0,1800,1),(11064,99,0,1800,1),(11065,93,0,1800,57),(11066,142,0,1800,167),(11067,97,0,1801,1),(11068,134,0,1801,2),(11069,115,0,1801,1),(11070,99,0,1801,1),(11071,93,0,1801,59),(11072,142,0,1801,167),(11073,97,0,1802,1),(11074,134,0,1802,2),(11075,115,0,1802,1),(11076,99,0,1802,1),(11077,93,0,1802,60),(11078,142,0,1802,167),(11079,97,0,1803,1),(11080,134,0,1803,2),(11081,115,0,1803,1),(11082,99,0,1803,1),(11083,93,0,1803,57),(11084,142,0,1803,168),(11085,97,0,1804,1),(11086,134,0,1804,2),(11087,115,0,1804,1),(11088,99,0,1804,1),(11089,93,0,1804,59),(11090,142,0,1804,168),(11091,97,0,1805,1),(11092,134,0,1805,2),(11093,115,0,1805,1),(11094,99,0,1805,1),(11095,93,0,1805,60),(11096,142,0,1805,168),(11097,97,0,1806,1),(11098,134,0,1806,2),(11099,115,0,1806,1),(11100,99,0,1806,1),(11101,93,0,1806,57),(11102,142,0,1806,169),(11103,97,0,1807,1),(11104,134,0,1807,2),(11105,115,0,1807,1),(11106,99,0,1807,1),(11107,93,0,1807,59),(11108,142,0,1807,169),(11109,97,0,1808,1),(11110,134,0,1808,2),(11111,115,0,1808,1),(11112,99,0,1808,1),(11113,93,0,1808,60),(11114,142,0,1808,169),(11115,97,0,1809,1),(11116,134,0,1809,2),(11117,115,0,1809,1),(11118,99,0,1809,1),(11119,93,0,1809,57),(11120,142,0,1809,170),(11121,97,0,1810,1),(11122,134,0,1810,2),(11123,115,0,1810,1),(11124,99,0,1810,1),(11125,93,0,1810,59),(11126,142,0,1810,170),(11127,97,0,1811,1),(11128,134,0,1811,2),(11129,115,0,1811,1),(11130,99,0,1811,1),(11131,93,0,1811,60),(11132,142,0,1811,170),(11133,97,0,1812,1),(11134,134,0,1812,2),(11135,115,0,1812,1),(11136,99,0,1812,4),(11137,143,0,1812,0),(11138,144,0,1812,1),(11139,145,0,1812,1),(11140,146,0,1812,0),(11141,147,0,1812,1),(11142,97,0,1813,1),(11143,134,0,1813,2),(11144,115,0,1813,1),(11145,99,0,1813,1),(11146,93,0,1813,49),(11147,142,0,1813,171),(11148,97,0,1814,1),(11149,134,0,1814,2),(11150,115,0,1814,1),(11151,99,0,1814,1),(11152,93,0,1814,52),(11153,142,0,1814,171),(11154,97,0,1815,1),(11155,134,0,1815,2),(11156,115,0,1815,1),(11157,99,0,1815,1),(11158,93,0,1815,59),(11159,142,0,1815,171),(11160,97,0,1816,1),(11161,134,0,1816,2),(11162,115,0,1816,1),(11163,99,0,1816,1),(11164,93,0,1816,49),(11165,142,0,1816,172),(11166,97,0,1817,1),(11167,134,0,1817,2),(11168,115,0,1817,1),(11169,99,0,1817,1),(11170,93,0,1817,52),(11171,142,0,1817,172),(11172,97,0,1818,1),(11173,134,0,1818,2),(11174,115,0,1818,1),(11175,99,0,1818,1),(11176,93,0,1818,59),(11177,142,0,1818,172),(11178,97,0,1819,1),(11179,134,0,1819,2),(11180,115,0,1819,1),(11181,99,0,1819,4),(11182,143,0,1819,1),(11183,144,0,1819,1),(11184,145,0,1819,0),(11185,146,0,1819,0),(11186,147,0,1819,0),(11187,97,0,1820,1),(11188,134,0,1820,2),(11189,115,0,1820,1),(11190,99,0,1820,1),(11191,93,0,1820,50),(11192,142,0,1820,171),(11193,97,0,1821,1),(11194,134,0,1821,2),(11195,115,0,1821,1),(11196,99,0,1821,1),(11197,93,0,1821,57),(11198,142,0,1821,171),(11199,97,0,1822,1),(11200,134,0,1822,2),(11201,115,0,1822,1),(11202,99,0,1822,1),(11203,93,0,1822,58),(11204,142,0,1822,171),(11205,97,0,1823,1),(11206,134,0,1823,2),(11207,115,0,1823,1),(11208,99,0,1823,1),(11209,93,0,1823,50),(11210,142,0,1823,172),(11211,97,0,1824,1),(11212,134,0,1824,2),(11213,115,0,1824,1),(11214,99,0,1824,1),(11215,93,0,1824,57),(11216,142,0,1824,172),(11217,97,0,1825,1),(11218,134,0,1825,2),(11219,115,0,1825,1),(11220,99,0,1825,1),(11221,93,0,1825,58),(11222,142,0,1825,172),(11223,97,0,1826,1),(11224,134,0,1826,2),(11225,115,0,1826,1),(11226,99,0,1826,4),(11227,143,0,1826,0),(11228,144,0,1826,1),(11229,145,0,1826,0),(11230,146,0,1826,0),(11231,147,0,1826,0),(11232,97,0,1827,1),(11233,134,0,1827,2),(11234,115,0,1827,1),(11235,99,0,1827,1),(11236,93,0,1827,49),(11237,142,0,1827,171),(11238,97,0,1828,1),(11239,134,0,1828,2),(11240,115,0,1828,1),(11241,99,0,1828,1),(11242,93,0,1828,50),(11243,142,0,1828,171),(11244,97,0,1829,1),(11245,134,0,1829,2),(11246,115,0,1829,1),(11247,99,0,1829,1),(11248,93,0,1829,57),(11249,142,0,1829,171),(11250,97,0,1830,1),(11251,134,0,1830,2),(11252,115,0,1830,1),(11253,99,0,1830,1),(11254,93,0,1830,49),(11255,142,0,1830,172),(11256,97,0,1831,1),(11257,134,0,1831,2),(11258,115,0,1831,1),(11259,99,0,1831,1),(11260,93,0,1831,50),(11261,142,0,1831,172),(11262,97,0,1832,1),(11263,134,0,1832,2),(11264,115,0,1832,1),(11265,99,0,1832,1),(11266,93,0,1832,57),(11267,142,0,1832,172),(11268,97,0,1833,1),(11269,134,0,1833,2),(11270,115,0,1833,1),(11271,99,0,1833,4),(11272,143,0,1833,0),(11273,144,0,1833,0),(11274,145,0,1833,0),(11275,146,0,1833,1),(11276,147,0,1833,0),(11277,97,0,1834,1),(11278,134,0,1834,2),(11279,115,0,1834,1),(11280,99,0,1834,1),(11281,93,0,1834,49),(11282,142,0,1834,171),(11283,97,0,1835,1),(11284,134,0,1835,2),(11285,115,0,1835,1),(11286,99,0,1835,1),(11287,93,0,1835,50),(11288,142,0,1835,171),(11289,97,0,1836,1),(11290,134,0,1836,2),(11291,115,0,1836,1),(11292,99,0,1836,1),(11293,93,0,1836,59),(11294,142,0,1836,171),(11295,97,0,1837,1),(11296,134,0,1837,2),(11297,115,0,1837,1),(11298,99,0,1837,1),(11299,93,0,1837,49),(11300,142,0,1837,172),(11301,97,0,1838,1),(11302,134,0,1838,2),(11303,115,0,1838,1),(11304,99,0,1838,1),(11305,93,0,1838,50),(11306,142,0,1838,172),(11307,97,0,1839,1),(11308,134,0,1839,2),(11309,115,0,1839,1),(11310,99,0,1839,1),(11311,93,0,1839,59),(11312,142,0,1839,172),(11313,97,0,1840,1),(11314,134,0,1840,2),(11315,115,0,1840,1),(11316,99,0,1840,4),(11317,143,0,1840,0),(11318,144,0,1840,0),(11319,145,0,1840,0),(11320,146,0,1840,0),(11321,147,0,1840,0),(11322,97,0,1841,1),(11323,134,0,1841,2),(11324,115,0,1841,1),(11325,99,0,1841,1),(11326,93,0,1841,50),(11327,142,0,1841,171),(11328,97,0,1842,1),(11329,134,0,1842,2),(11330,115,0,1842,1),(11331,99,0,1842,1),(11332,93,0,1842,52),(11333,142,0,1842,171),(11334,97,0,1843,1),(11335,134,0,1843,2),(11336,115,0,1843,1),(11337,99,0,1843,1),(11338,93,0,1843,58),(11339,142,0,1843,171),(11340,97,0,1844,1),(11341,134,0,1844,2),(11342,115,0,1844,1),(11343,99,0,1844,1),(11344,93,0,1844,50),(11345,142,0,1844,172),(11346,97,0,1845,1),(11347,134,0,1845,2),(11348,115,0,1845,1),(11349,99,0,1845,1),(11350,93,0,1845,52),(11351,142,0,1845,172),(11352,97,0,1846,1),(11353,134,0,1846,2),(11354,115,0,1846,1),(11355,99,0,1846,1),(11356,93,0,1846,58),(11357,142,0,1846,172),(11358,97,0,1847,1),(11359,134,0,1847,2),(11360,115,0,1847,1),(11361,99,0,1847,4),(11362,143,0,1847,0),(11363,144,0,1847,0),(11364,145,0,1847,1),(11365,146,0,1847,0),(11366,147,0,1847,0),(11367,97,0,1848,1),(11368,134,0,1848,2),(11369,115,0,1848,1),(11370,99,0,1848,1),(11371,93,0,1848,49),(11372,142,0,1848,171),(11373,97,0,1849,1),(11374,134,0,1849,2),(11375,115,0,1849,1),(11376,99,0,1849,1),(11377,93,0,1849,50),(11378,142,0,1849,171),(11379,97,0,1850,1),(11380,134,0,1850,2),(11381,115,0,1850,1),(11382,99,0,1850,1),(11383,93,0,1850,56),(11384,142,0,1850,171),(11385,97,0,1851,1),(11386,134,0,1851,2),(11387,115,0,1851,1),(11388,99,0,1851,1),(11389,93,0,1851,49),(11390,142,0,1851,172),(11391,97,0,1852,1),(11392,134,0,1852,2),(11393,115,0,1852,1),(11394,99,0,1852,1),(11395,93,0,1852,50),(11396,142,0,1852,172),(11397,97,0,1853,1),(11398,134,0,1853,2),(11399,115,0,1853,1),(11400,99,0,1853,1),(11401,93,0,1853,56),(11402,142,0,1853,172),(11403,97,0,1854,1),(11404,134,0,1854,2),(11405,115,0,1854,1),(11406,99,0,1854,4),(11407,143,0,1854,0),(11408,144,0,1854,0),(11409,145,0,1854,1),(11410,146,0,1854,0),(11411,147,0,1854,0),(11412,97,0,1855,1),(11413,134,0,1855,2),(11414,115,0,1855,1),(11415,99,0,1855,1),(11416,93,0,1855,49),(11417,142,0,1855,171),(11418,97,0,1856,1),(11419,134,0,1856,2),(11420,115,0,1856,1),(11421,99,0,1856,1),(11422,93,0,1856,50),(11423,142,0,1856,171),(11424,97,0,1857,1),(11425,134,0,1857,2),(11426,115,0,1857,1),(11427,99,0,1857,1),(11428,93,0,1857,56),(11429,142,0,1857,171),(11430,97,0,1858,1),(11431,134,0,1858,2),(11432,115,0,1858,1),(11433,99,0,1858,1),(11434,93,0,1858,49),(11435,142,0,1858,172),(11436,97,0,1859,1),(11437,134,0,1859,2),(11438,115,0,1859,1),(11439,99,0,1859,1),(11440,93,0,1859,50),(11441,142,0,1859,172),(11442,97,0,1860,1),(11443,134,0,1860,2),(11444,115,0,1860,1),(11445,99,0,1860,1),(11446,93,0,1860,56),(11447,142,0,1860,172),(11448,97,0,1861,1),(11449,134,0,1861,2),(11450,115,0,1861,1),(11451,99,0,1861,4),(11452,143,0,1861,0),(11453,144,0,1861,1),(11454,145,0,1861,0),(11455,146,0,1861,0),(11456,147,0,1861,0),(11457,97,0,1862,1),(11458,134,0,1862,2),(11459,115,0,1862,1),(11460,99,0,1862,1),(11461,93,0,1862,49),(11462,142,0,1862,171),(11463,97,0,1863,1),(11464,134,0,1863,2),(11465,115,0,1863,1),(11466,99,0,1863,1),(11467,93,0,1863,53),(11468,142,0,1863,171),(11469,97,0,1864,1),(11470,134,0,1864,2),(11471,115,0,1864,1),(11472,99,0,1864,1),(11473,93,0,1864,58),(11474,142,0,1864,171),(11475,97,0,1865,1),(11476,134,0,1865,2),(11477,115,0,1865,1),(11478,99,0,1865,1),(11479,93,0,1865,49),(11480,142,0,1865,172),(11481,97,0,1866,1),(11482,134,0,1866,2),(11483,115,0,1866,1),(11484,99,0,1866,1),(11485,93,0,1866,53),(11486,142,0,1866,172),(11487,97,0,1867,1),(11488,134,0,1867,2),(11489,115,0,1867,1),(11490,99,0,1867,1),(11491,93,0,1867,58),(11492,142,0,1867,172),(11493,97,0,1868,1),(11494,134,0,1868,2),(11495,115,0,1868,1),(11496,99,0,1868,4),(11497,143,0,1868,0),(11498,144,0,1868,0),(11499,145,0,1868,0),(11500,146,0,1868,0),(11501,147,0,1868,0),(11502,97,0,1869,1),(11503,134,0,1869,2),(11504,115,0,1869,1),(11505,99,0,1869,1),(11506,93,0,1869,49),(11507,142,0,1869,171),(11508,97,0,1870,1),(11509,134,0,1870,2),(11510,115,0,1870,1),(11511,99,0,1870,1),(11512,93,0,1870,50),(11513,142,0,1870,171),(11514,97,0,1871,1),(11515,134,0,1871,2),(11516,115,0,1871,1),(11517,99,0,1871,1),(11518,93,0,1871,57),(11519,142,0,1871,171),(11520,97,0,1872,1),(11521,134,0,1872,2),(11522,115,0,1872,1),(11523,99,0,1872,1),(11524,93,0,1872,49),(11525,142,0,1872,172),(11526,97,0,1873,1),(11527,134,0,1873,2),(11528,115,0,1873,1),(11529,99,0,1873,1),(11530,93,0,1873,50),(11531,142,0,1873,172),(11532,97,0,1874,1),(11533,134,0,1874,2),(11534,115,0,1874,1),(11535,99,0,1874,1),(11536,93,0,1874,57),(11537,142,0,1874,172),(11538,97,0,1875,1),(11539,134,0,1875,2),(11540,115,0,1875,1),(11541,99,0,1875,4),(11542,143,0,1875,0),(11543,144,0,1875,0),(11544,145,0,1875,0),(11545,146,0,1875,0),(11546,147,0,1875,0),(11547,97,0,1876,1),(11548,134,0,1876,2),(11549,115,0,1876,1),(11550,99,0,1876,1),(11551,93,0,1876,49),(11552,142,0,1876,171),(11553,97,0,1877,1),(11554,134,0,1877,2),(11555,115,0,1877,1),(11556,99,0,1877,1),(11557,93,0,1877,52),(11558,142,0,1877,171),(11559,97,0,1878,1),(11560,134,0,1878,2),(11561,115,0,1878,1),(11562,99,0,1878,1),(11563,93,0,1878,59),(11564,142,0,1878,171),(11565,97,0,1879,1),(11566,134,0,1879,2),(11567,115,0,1879,1),(11568,99,0,1879,1),(11569,93,0,1879,49),(11570,142,0,1879,172),(11571,97,0,1880,1),(11572,134,0,1880,2),(11573,115,0,1880,1),(11574,99,0,1880,1),(11575,93,0,1880,52),(11576,142,0,1880,172),(11577,97,0,1881,1),(11578,134,0,1881,2),(11579,115,0,1881,1),(11580,99,0,1881,1),(11581,93,0,1881,59),(11582,142,0,1881,172),(11583,97,0,1882,1),(11584,134,0,1882,2),(11585,115,0,1882,1),(11586,99,0,1882,4),(11587,143,0,1882,1),(11588,144,0,1882,0),(11589,145,0,1882,0),(11590,146,0,1882,0),(11591,147,0,1882,0),(11592,97,0,1883,1),(11593,134,0,1883,2),(11594,115,0,1883,1),(11595,99,0,1883,1),(11596,93,0,1883,50),(11597,142,0,1883,171),(11598,97,0,1884,1),(11599,134,0,1884,2),(11600,115,0,1884,1),(11601,99,0,1884,1),(11602,93,0,1884,53),(11603,142,0,1884,171),(11604,97,0,1885,1),(11605,134,0,1885,2),(11606,115,0,1885,1),(11607,99,0,1885,1),(11608,93,0,1885,58),(11609,142,0,1885,171),(11610,97,0,1886,1),(11611,134,0,1886,2),(11612,115,0,1886,1),(11613,99,0,1886,1),(11614,93,0,1886,50),(11615,142,0,1886,172),(11616,97,0,1887,1),(11617,134,0,1887,2),(11618,115,0,1887,1),(11619,99,0,1887,1),(11620,93,0,1887,53),(11621,142,0,1887,172),(11622,97,0,1888,1),(11623,134,0,1888,2),(11624,115,0,1888,1),(11625,99,0,1888,1),(11626,93,0,1888,58),(11627,142,0,1888,172),(11628,97,0,1889,1),(11629,134,0,1889,2),(11630,115,0,1889,1),(11631,99,0,1889,4),(11632,143,0,1889,0),(11633,144,0,1889,0),(11634,145,0,1889,0),(11635,146,0,1889,0),(11636,147,0,1889,0),(11637,97,0,1890,1),(11638,134,0,1890,2),(11639,115,0,1890,1),(11640,99,0,1890,1),(11641,93,0,1890,50),(11642,142,0,1890,171),(11643,97,0,1891,1),(11644,134,0,1891,2),(11645,115,0,1891,1),(11646,99,0,1891,1),(11647,93,0,1891,52),(11648,142,0,1891,171),(11649,97,0,1892,1),(11650,134,0,1892,2),(11651,115,0,1892,1),(11652,99,0,1892,1),(11653,93,0,1892,53),(11654,142,0,1892,171),(11655,97,0,1893,1),(11656,134,0,1893,2),(11657,115,0,1893,1),(11658,99,0,1893,1),(11659,93,0,1893,50),(11660,142,0,1893,172),(11661,97,0,1894,1),(11662,134,0,1894,2),(11663,115,0,1894,1),(11664,99,0,1894,1),(11665,93,0,1894,52),(11666,142,0,1894,172),(11667,97,0,1895,1),(11668,134,0,1895,2),(11669,115,0,1895,1),(11670,99,0,1895,1),(11671,93,0,1895,53),(11672,142,0,1895,172),(11673,97,0,1896,1),(11674,134,0,1896,2),(11675,115,0,1896,1),(11676,99,0,1896,4),(11677,143,0,1896,1),(11678,144,0,1896,1),(11679,145,0,1896,0),(11680,146,0,1896,0),(11681,147,0,1896,0),(11682,97,0,1897,1),(11683,134,0,1897,2),(11684,115,0,1897,1),(11685,99,0,1897,1),(11686,93,0,1897,50),(11687,142,0,1897,171),(11688,97,0,1898,1),(11689,134,0,1898,2),(11690,115,0,1898,1),(11691,99,0,1898,1),(11692,93,0,1898,53),(11693,142,0,1898,171),(11694,97,0,1899,1),(11695,134,0,1899,2),(11696,115,0,1899,1),(11697,99,0,1899,1),(11698,93,0,1899,56),(11699,142,0,1899,171),(11700,97,0,1900,1),(11701,134,0,1900,2),(11702,115,0,1900,1),(11703,99,0,1900,1),(11704,93,0,1900,50),(11705,142,0,1900,172),(11706,97,0,1901,1),(11707,134,0,1901,2),(11708,115,0,1901,1),(11709,99,0,1901,1),(11710,93,0,1901,53),(11711,142,0,1901,172),(11712,97,0,1902,1),(11713,134,0,1902,2),(11714,115,0,1902,1),(11715,99,0,1902,1),(11716,93,0,1902,56),(11717,142,0,1902,172),(11718,97,0,1903,1),(11719,134,0,1903,2),(11720,115,0,1903,1),(11721,99,0,1903,4),(11722,143,0,1903,1),(11723,144,0,1903,0),(11724,145,0,1903,1),(11725,146,0,1903,0),(11726,147,0,1903,0),(11727,97,0,1904,1),(11728,134,0,1904,2),(11729,115,0,1904,1),(11730,99,0,1904,1),(11731,93,0,1904,49),(11732,142,0,1904,171),(11733,97,0,1905,1),(11734,134,0,1905,2),(11735,115,0,1905,1),(11736,99,0,1905,1),(11737,93,0,1905,53),(11738,142,0,1905,171),(11739,97,0,1906,1),(11740,134,0,1906,2),(11741,115,0,1906,1),(11742,99,0,1906,1),(11743,93,0,1906,58),(11744,142,0,1906,171),(11745,97,0,1907,1),(11746,134,0,1907,2),(11747,115,0,1907,1),(11748,99,0,1907,1),(11749,93,0,1907,49),(11750,142,0,1907,172),(11751,97,0,1908,1),(11752,134,0,1908,2),(11753,115,0,1908,1),(11754,99,0,1908,1),(11755,93,0,1908,53),(11756,142,0,1908,172),(11757,97,0,1909,1),(11758,134,0,1909,2),(11759,115,0,1909,1),(11760,99,0,1909,1),(11761,93,0,1909,58),(11762,142,0,1909,172),(11763,97,0,1910,1),(11764,134,0,1910,2),(11765,115,0,1910,1),(11766,99,0,1910,1),(11767,93,0,1910,49),(11768,142,0,1910,173),(11769,97,0,1911,1),(11770,134,0,1911,2),(11771,115,0,1911,1),(11772,99,0,1911,1),(11773,93,0,1911,53),(11774,142,0,1911,173),(11775,97,0,1912,1),(11776,134,0,1912,2),(11777,115,0,1912,1),(11778,99,0,1912,1),(11779,93,0,1912,58),(11780,142,0,1912,173),(11781,97,0,1913,1),(11782,134,0,1913,2),(11783,115,0,1913,1),(11784,99,0,1913,1),(11785,93,0,1913,49),(11786,142,0,1913,174),(11787,97,0,1914,1),(11788,134,0,1914,2),(11789,115,0,1914,1),(11790,99,0,1914,1),(11791,93,0,1914,53),(11792,142,0,1914,174),(11793,97,0,1915,1),(11794,134,0,1915,2),(11795,115,0,1915,1),(11796,99,0,1915,1),(11797,93,0,1915,58),(11798,142,0,1915,174),(11799,97,0,1916,1),(11800,134,0,1916,2),(11801,115,0,1916,1),(11802,99,0,1916,1),(11803,93,0,1916,49),(11804,142,0,1916,175),(11805,97,0,1917,1),(11806,134,0,1917,2),(11807,115,0,1917,1),(11808,99,0,1917,1),(11809,93,0,1917,53),(11810,142,0,1917,175),(11811,97,0,1918,1),(11812,134,0,1918,2),(11813,115,0,1918,1),(11814,99,0,1918,1),(11815,93,0,1918,58),(11816,142,0,1918,175),(11817,97,0,1919,1),(11818,134,0,1919,2),(11819,115,0,1919,1),(11820,99,0,1919,4),(11821,143,0,1919,1),(11822,144,0,1919,0),(11823,145,0,1919,0),(11824,146,0,1919,1),(11825,147,0,1919,0),(11826,97,0,1920,1),(11827,134,0,1920,2),(11828,115,0,1920,1),(11829,99,0,1920,1),(11830,93,0,1920,52),(11831,142,0,1920,171),(11832,97,0,1921,1),(11833,134,0,1921,2),(11834,115,0,1921,1),(11835,99,0,1921,1),(11836,93,0,1921,56),(11837,142,0,1921,171),(11838,97,0,1922,1),(11839,134,0,1922,2),(11840,115,0,1922,1),(11841,99,0,1922,1),(11842,93,0,1922,60),(11843,142,0,1922,171),(11844,97,0,1923,1),(11845,134,0,1923,2),(11846,115,0,1923,1),(11847,99,0,1923,1),(11848,93,0,1923,52),(11849,142,0,1923,172),(11850,97,0,1924,1),(11851,134,0,1924,2),(11852,115,0,1924,1),(11853,99,0,1924,1),(11854,93,0,1924,56),(11855,142,0,1924,172),(11856,97,0,1925,1),(11857,134,0,1925,2),(11858,115,0,1925,1),(11859,99,0,1925,1),(11860,93,0,1925,60),(11861,142,0,1925,172),(11862,97,0,1926,1),(11863,134,0,1926,2),(11864,115,0,1926,1),(11865,99,0,1926,1),(11866,93,0,1926,52),(11867,142,0,1926,173),(11868,97,0,1927,1),(11869,134,0,1927,2),(11870,115,0,1927,1),(11871,99,0,1927,1),(11872,93,0,1927,56),(11873,142,0,1927,173),(11874,97,0,1928,1),(11875,134,0,1928,2),(11876,115,0,1928,1),(11877,99,0,1928,1),(11878,93,0,1928,60),(11879,142,0,1928,173),(11880,97,0,1929,1),(11881,134,0,1929,2),(11882,115,0,1929,1),(11883,99,0,1929,1),(11884,93,0,1929,52),(11885,142,0,1929,174),(11886,97,0,1930,1),(11887,134,0,1930,2),(11888,115,0,1930,1),(11889,99,0,1930,1),(11890,93,0,1930,56),(11891,142,0,1930,174),(11892,97,0,1931,1),(11893,134,0,1931,2),(11894,115,0,1931,1),(11895,99,0,1931,1),(11896,93,0,1931,60),(11897,142,0,1931,174),(11898,97,0,1932,1),(11899,134,0,1932,2),(11900,115,0,1932,1),(11901,99,0,1932,1),(11902,93,0,1932,52),(11903,142,0,1932,175),(11904,97,0,1933,1),(11905,134,0,1933,2),(11906,115,0,1933,1),(11907,99,0,1933,1),(11908,93,0,1933,56),(11909,142,0,1933,175),(11910,97,0,1934,1),(11911,134,0,1934,2),(11912,115,0,1934,1),(11913,99,0,1934,1),(11914,93,0,1934,60),(11915,142,0,1934,175),(11916,97,0,1935,1),(11917,134,0,1935,2),(11918,115,0,1935,1),(11919,99,0,1935,4),(11920,143,0,1935,0),(11921,144,0,1935,0),(11922,145,0,1935,0),(11923,146,0,1935,0),(11924,147,0,1935,1),(11925,97,0,1936,1),(11926,134,0,1936,2),(11927,115,0,1936,1),(11928,99,0,1936,1),(11929,93,0,1936,50),(11930,142,0,1936,171),(11931,97,0,1937,1),(11932,134,0,1937,2),(11933,115,0,1937,1),(11934,99,0,1937,1),(11935,93,0,1937,52),(11936,142,0,1937,171),(11937,97,0,1938,1),(11938,134,0,1938,2),(11939,115,0,1938,1),(11940,99,0,1938,1),(11941,93,0,1938,56),(11942,142,0,1938,171),(11943,97,0,1939,1),(11944,134,0,1939,2),(11945,115,0,1939,1),(11946,99,0,1939,1),(11947,93,0,1939,50),(11948,142,0,1939,172),(11949,97,0,1940,1),(11950,134,0,1940,2),(11951,115,0,1940,1),(11952,99,0,1940,1),(11953,93,0,1940,52),(11954,142,0,1940,172),(11955,97,0,1941,1),(11956,134,0,1941,2),(11957,115,0,1941,1),(11958,99,0,1941,1),(11959,93,0,1941,56),(11960,142,0,1941,172),(11961,97,0,1942,1),(11962,134,0,1942,2),(11963,115,0,1942,1),(11964,99,0,1942,1),(11965,93,0,1942,50),(11966,142,0,1942,173),(11967,97,0,1943,1),(11968,134,0,1943,2),(11969,115,0,1943,1),(11970,99,0,1943,1),(11971,93,0,1943,52),(11972,142,0,1943,173),(11973,97,0,1944,1),(11974,134,0,1944,2),(11975,115,0,1944,1),(11976,99,0,1944,1),(11977,93,0,1944,56),(11978,142,0,1944,173),(11979,97,0,1945,1),(11980,134,0,1945,2),(11981,115,0,1945,1),(11982,99,0,1945,1),(11983,93,0,1945,50),(11984,142,0,1945,174),(11985,97,0,1946,1),(11986,134,0,1946,2),(11987,115,0,1946,1),(11988,99,0,1946,1),(11989,93,0,1946,52),(11990,142,0,1946,174),(11991,97,0,1947,1),(11992,134,0,1947,2),(11993,115,0,1947,1),(11994,99,0,1947,1),(11995,93,0,1947,56),(11996,142,0,1947,174),(11997,97,0,1948,1),(11998,134,0,1948,2),(11999,115,0,1948,1),(12000,99,0,1948,1),(12001,93,0,1948,50),(12002,142,0,1948,175),(12003,97,0,1949,1),(12004,134,0,1949,2),(12005,115,0,1949,1),(12006,99,0,1949,1),(12007,93,0,1949,52),(12008,142,0,1949,175),(12009,97,0,1950,1),(12010,134,0,1950,2),(12011,115,0,1950,1),(12012,99,0,1950,1),(12013,93,0,1950,56),(12014,142,0,1950,175),(12015,97,0,1951,1),(12016,134,0,1951,2),(12017,115,0,1951,1),(12018,99,0,1951,4),(12019,143,0,1951,1),(12020,144,0,1951,1),(12021,145,0,1951,0),(12022,146,0,1951,1),(12023,147,0,1951,0),(12024,97,0,1952,1),(12025,134,0,1952,2),(12026,115,0,1952,1),(12027,99,0,1952,1),(12028,93,0,1952,49),(12029,142,0,1952,171),(12030,97,0,1953,1),(12031,134,0,1953,2),(12032,115,0,1953,1),(12033,99,0,1953,1),(12034,93,0,1953,53),(12035,142,0,1953,171),(12036,97,0,1954,1),(12037,134,0,1954,2),(12038,115,0,1954,1),(12039,99,0,1954,1),(12040,93,0,1954,56),(12041,142,0,1954,171),(12042,97,0,1955,1),(12043,134,0,1955,2),(12044,115,0,1955,1),(12045,99,0,1955,1),(12046,93,0,1955,49),(12047,142,0,1955,172),(12048,97,0,1956,1),(12049,134,0,1956,2),(12050,115,0,1956,1),(12051,99,0,1956,1),(12052,93,0,1956,53),(12053,142,0,1956,172),(12054,97,0,1957,1),(12055,134,0,1957,2),(12056,115,0,1957,1),(12057,99,0,1957,1),(12058,93,0,1957,56),(12059,142,0,1957,172),(12060,97,0,1958,1),(12061,134,0,1958,2),(12062,115,0,1958,1),(12063,99,0,1958,1),(12064,93,0,1958,49),(12065,142,0,1958,173),(12066,97,0,1959,1),(12067,134,0,1959,2),(12068,115,0,1959,1),(12069,99,0,1959,1),(12070,93,0,1959,53),(12071,142,0,1959,173),(12072,97,0,1960,1),(12073,134,0,1960,2),(12074,115,0,1960,1),(12075,99,0,1960,1),(12076,93,0,1960,56),(12077,142,0,1960,173),(12078,97,0,1961,1),(12079,134,0,1961,2),(12080,115,0,1961,1),(12081,99,0,1961,1),(12082,93,0,1961,49),(12083,142,0,1961,174),(12084,97,0,1962,1),(12085,134,0,1962,2),(12086,115,0,1962,1),(12087,99,0,1962,1),(12088,93,0,1962,53),(12089,142,0,1962,174),(12090,97,0,1963,1),(12091,134,0,1963,2),(12092,115,0,1963,1),(12093,99,0,1963,1),(12094,93,0,1963,56),(12095,142,0,1963,174),(12096,97,0,1964,1),(12097,134,0,1964,2),(12098,115,0,1964,1),(12099,99,0,1964,1),(12100,93,0,1964,49),(12101,142,0,1964,175),(12102,97,0,1965,1),(12103,134,0,1965,2),(12104,115,0,1965,1),(12105,99,0,1965,1),(12106,93,0,1965,53),(12107,142,0,1965,175),(12108,97,0,1966,1),(12109,134,0,1966,2),(12110,115,0,1966,1),(12111,99,0,1966,1),(12112,93,0,1966,56),(12113,142,0,1966,175),(12114,97,0,1967,1),(12115,134,0,1967,2),(12116,115,0,1967,1),(12117,99,0,1967,4),(12118,143,0,1967,0),(12119,144,0,1967,0),(12120,145,0,1967,0),(12121,146,0,1967,0),(12122,147,0,1967,0),(12123,97,0,1968,1),(12124,134,0,1968,2),(12125,115,0,1968,1),(12126,99,0,1968,1),(12127,93,0,1968,50),(12128,142,0,1968,171),(12129,97,0,1969,1),(12130,134,0,1969,2),(12131,115,0,1969,1),(12132,99,0,1969,1),(12133,93,0,1969,57),(12134,142,0,1969,171),(12135,97,0,1970,1),(12136,134,0,1970,2),(12137,115,0,1970,1),(12138,99,0,1970,1),(12139,93,0,1970,60),(12140,142,0,1970,171),(12141,97,0,1971,1),(12142,134,0,1971,2),(12143,115,0,1971,1),(12144,99,0,1971,1),(12145,93,0,1971,50),(12146,142,0,1971,172),(12147,97,0,1972,1),(12148,134,0,1972,2),(12149,115,0,1972,1),(12150,99,0,1972,1),(12151,93,0,1972,57),(12152,142,0,1972,172),(12153,97,0,1973,1),(12154,134,0,1973,2),(12155,115,0,1973,1),(12156,99,0,1973,1),(12157,93,0,1973,60),(12158,142,0,1973,172),(12159,97,0,1974,1),(12160,134,0,1974,2),(12161,115,0,1974,1),(12162,99,0,1974,1),(12163,93,0,1974,50),(12164,142,0,1974,173),(12165,97,0,1975,1),(12166,134,0,1975,2),(12167,115,0,1975,1),(12168,99,0,1975,1),(12169,93,0,1975,57),(12170,142,0,1975,173),(12171,97,0,1976,1),(12172,134,0,1976,2),(12173,115,0,1976,1),(12174,99,0,1976,1),(12175,93,0,1976,60),(12176,142,0,1976,173),(12177,97,0,1977,1),(12178,134,0,1977,2),(12179,115,0,1977,1),(12180,99,0,1977,1),(12181,93,0,1977,50),(12182,142,0,1977,174),(12183,97,0,1978,1),(12184,134,0,1978,2),(12185,115,0,1978,1),(12186,99,0,1978,1),(12187,93,0,1978,57),(12188,142,0,1978,174),(12189,97,0,1979,1),(12190,134,0,1979,2),(12191,115,0,1979,1),(12192,99,0,1979,1),(12193,93,0,1979,60),(12194,142,0,1979,174),(12195,97,0,1980,1),(12196,134,0,1980,2),(12197,115,0,1980,1),(12198,99,0,1980,1),(12199,93,0,1980,50),(12200,142,0,1980,175),(12201,97,0,1981,1),(12202,134,0,1981,2),(12203,115,0,1981,1),(12204,99,0,1981,1),(12205,93,0,1981,57),(12206,142,0,1981,175),(12207,97,0,1982,1),(12208,134,0,1982,2),(12209,115,0,1982,1),(12210,99,0,1982,1),(12211,93,0,1982,60),(12212,142,0,1982,175),(12213,97,0,1983,1),(12214,134,0,1983,2),(12215,115,0,1983,1),(12216,99,0,1983,4),(12217,143,0,1983,0),(12218,144,0,1983,0),(12219,145,0,1983,0),(12220,146,0,1983,0),(12221,147,0,1983,1),(12222,97,0,1984,1),(12223,134,0,1984,2),(12224,115,0,1984,1),(12225,99,0,1984,1),(12226,93,0,1984,52),(12227,142,0,1984,171),(12228,97,0,1985,1),(12229,134,0,1985,2),(12230,115,0,1985,1),(12231,99,0,1985,1),(12232,93,0,1985,56),(12233,142,0,1985,171),(12234,97,0,1986,1),(12235,134,0,1986,2),(12236,115,0,1986,1),(12237,99,0,1986,1),(12238,93,0,1986,57),(12239,142,0,1986,171),(12240,97,0,1987,1),(12241,134,0,1987,2),(12242,115,0,1987,1),(12243,99,0,1987,1),(12244,93,0,1987,52),(12245,142,0,1987,172),(12246,97,0,1988,1),(12247,134,0,1988,2),(12248,115,0,1988,1),(12249,99,0,1988,1),(12250,93,0,1988,56),(12251,142,0,1988,172),(12252,97,0,1989,1),(12253,134,0,1989,2),(12254,115,0,1989,1),(12255,99,0,1989,1),(12256,93,0,1989,57),(12257,142,0,1989,172),(12258,97,0,1990,1),(12259,134,0,1990,2),(12260,115,0,1990,1),(12261,99,0,1990,4),(12262,143,0,1990,0),(12263,144,0,1990,0),(12264,145,0,1990,0),(12265,146,0,1990,0),(12266,147,0,1990,0),(12267,97,0,1991,1),(12268,134,0,1991,2),(12269,115,0,1991,1),(12270,99,0,1991,1),(12271,93,0,1991,49),(12272,142,0,1991,171),(12273,97,0,1992,1),(12274,134,0,1992,2),(12275,115,0,1992,1),(12276,99,0,1992,1),(12277,93,0,1992,50),(12278,142,0,1992,171),(12279,97,0,1993,1),(12280,134,0,1993,2),(12281,115,0,1993,1),(12282,99,0,1993,1),(12283,93,0,1993,57),(12284,142,0,1993,171),(12285,97,0,1994,1),(12286,134,0,1994,2),(12287,115,0,1994,1),(12288,99,0,1994,1),(12289,93,0,1994,49),(12290,142,0,1994,172),(12291,97,0,1995,1),(12292,134,0,1995,2),(12293,115,0,1995,1),(12294,99,0,1995,1),(12295,93,0,1995,50),(12296,142,0,1995,172),(12297,97,0,1996,1),(12298,134,0,1996,2),(12299,115,0,1996,1),(12300,99,0,1996,1),(12301,93,0,1996,57),(12302,142,0,1996,172),(12303,97,0,1997,1),(12304,134,0,1997,2),(12305,115,0,1997,1),(12306,99,0,1997,4),(12307,143,0,1997,0),(12308,144,0,1997,0),(12309,145,0,1997,0),(12310,146,0,1997,1),(12311,147,0,1997,0),(12312,97,0,1998,1),(12313,134,0,1998,2),(12314,115,0,1998,1),(12315,99,0,1998,1),(12316,93,0,1998,57),(12317,142,0,1998,171),(12318,97,0,1999,1),(12319,134,0,1999,2),(12320,115,0,1999,1),(12321,99,0,1999,1),(12322,93,0,1999,57),(12323,142,0,1999,172),(12324,97,0,2000,1),(12325,134,0,2000,2),(12326,115,0,2000,1),(12327,99,0,2000,1),(12328,93,0,2000,57),(12329,142,0,2000,173),(12330,97,0,2001,1),(12331,134,0,2001,2),(12332,115,0,2001,1),(12333,99,0,2001,1),(12334,93,0,2001,57),(12335,142,0,2001,174),(12336,97,0,2002,1),(12337,134,0,2002,2),(12338,115,0,2002,1),(12339,99,0,2002,1),(12340,93,0,2002,57),(12341,142,0,2002,175),(12342,97,0,2003,1),(12343,134,0,2003,2),(12344,115,0,2003,1),(12345,99,0,2003,4),(12346,143,0,2003,0),(12347,144,0,2003,1),(12348,145,0,2003,0),(12349,146,0,2003,0),(12350,147,0,2003,0),(12351,97,0,2004,1),(12352,134,0,2004,2),(12353,115,0,2004,1),(12354,99,0,2004,1),(12355,93,0,2004,52),(12356,142,0,2004,171),(12357,97,0,2005,1),(12358,134,0,2005,2),(12359,115,0,2005,1),(12360,99,0,2005,1),(12361,93,0,2005,53),(12362,142,0,2005,171),(12363,97,0,2006,1),(12364,134,0,2006,2),(12365,115,0,2006,1),(12366,99,0,2006,1),(12367,93,0,2006,59),(12368,142,0,2006,171),(12369,97,0,2007,1),(12370,134,0,2007,2),(12371,115,0,2007,1),(12372,99,0,2007,1),(12373,93,0,2007,52),(12374,142,0,2007,172),(12375,97,0,2008,1),(12376,134,0,2008,2),(12377,115,0,2008,1),(12378,99,0,2008,1),(12379,93,0,2008,53),(12380,142,0,2008,172),(12381,97,0,2009,1),(12382,134,0,2009,2),(12383,115,0,2009,1),(12384,99,0,2009,1),(12385,93,0,2009,59),(12386,142,0,2009,172),(12387,97,0,2010,1),(12388,134,0,2010,2),(12389,115,0,2010,1),(12390,99,0,2010,4),(12391,143,0,2010,0),(12392,144,0,2010,0),(12393,145,0,2010,0),(12394,146,0,2010,0),(12395,147,0,2010,0),(12396,97,0,2011,1),(12397,134,0,2011,2),(12398,115,0,2011,1),(12399,99,0,2011,1),(12400,93,0,2011,49),(12401,142,0,2011,171),(12402,97,0,2012,1),(12403,134,0,2012,2),(12404,115,0,2012,1),(12405,99,0,2012,1),(12406,93,0,2012,56),(12407,142,0,2012,171),(12408,97,0,2013,1),(12409,134,0,2013,2),(12410,115,0,2013,1),(12411,99,0,2013,1),(12412,93,0,2013,59),(12413,142,0,2013,171),(12414,97,0,2014,1),(12415,134,0,2014,2),(12416,115,0,2014,1),(12417,99,0,2014,1),(12418,93,0,2014,49),(12419,142,0,2014,172),(12420,97,0,2015,1),(12421,134,0,2015,2),(12422,115,0,2015,1),(12423,99,0,2015,1),(12424,93,0,2015,56),(12425,142,0,2015,172),(12426,97,0,2016,1),(12427,134,0,2016,2),(12428,115,0,2016,1),(12429,99,0,2016,1),(12430,93,0,2016,59),(12431,142,0,2016,172),(12432,97,0,2017,1),(12433,134,0,2017,2),(12434,115,0,2017,1),(12435,99,0,2017,4),(12436,143,0,2017,1),(12437,144,0,2017,0),(12438,145,0,2017,0),(12439,146,0,2017,0),(12440,147,0,2017,0),(12441,97,0,2018,1),(12442,134,0,2018,2),(12443,115,0,2018,1),(12444,99,0,2018,1),(12445,93,0,2018,50),(12446,142,0,2018,171),(12447,97,0,2019,1),(12448,134,0,2019,2),(12449,115,0,2019,1),(12450,99,0,2019,1),(12451,93,0,2019,56),(12452,142,0,2019,171),(12453,97,0,2020,1),(12454,134,0,2020,2),(12455,115,0,2020,1),(12456,99,0,2020,1),(12457,93,0,2020,58),(12458,142,0,2020,171),(12459,97,0,2021,1),(12460,134,0,2021,2),(12461,115,0,2021,1),(12462,99,0,2021,1),(12463,93,0,2021,50),(12464,142,0,2021,172),(12465,97,0,2022,1),(12466,134,0,2022,2),(12467,115,0,2022,1),(12468,99,0,2022,1),(12469,93,0,2022,56),(12470,142,0,2022,172),(12471,97,0,2023,1),(12472,134,0,2023,2),(12473,115,0,2023,1),(12474,99,0,2023,1),(12475,93,0,2023,58),(12476,142,0,2023,172),(12477,97,0,2024,1),(12478,134,0,2024,2),(12479,115,0,2024,1),(12480,99,0,2024,4),(12481,143,0,2024,0),(12482,144,0,2024,1),(12483,145,0,2024,1),(12484,146,0,2024,0),(12485,147,0,2024,0),(12486,97,0,2025,1),(12487,134,0,2025,2),(12488,115,0,2025,1),(12489,99,0,2025,1),(12490,93,0,2025,53),(12491,142,0,2025,171),(12492,97,0,2026,1),(12493,134,0,2026,2),(12494,115,0,2026,1),(12495,99,0,2026,1),(12496,93,0,2026,57),(12497,142,0,2026,171),(12498,97,0,2027,1),(12499,134,0,2027,2),(12500,115,0,2027,1),(12501,99,0,2027,1),(12502,93,0,2027,58),(12503,142,0,2027,171),(12504,97,0,2028,1),(12505,134,0,2028,2),(12506,115,0,2028,1),(12507,99,0,2028,1),(12508,93,0,2028,53),(12509,142,0,2028,172),(12510,97,0,2029,1),(12511,134,0,2029,2),(12512,115,0,2029,1),(12513,99,0,2029,1),(12514,93,0,2029,57),(12515,142,0,2029,172),(12516,97,0,2030,1),(12517,134,0,2030,2),(12518,115,0,2030,1),(12519,99,0,2030,1),(12520,93,0,2030,58),(12521,142,0,2030,172),(12522,97,0,2031,1),(12523,134,0,2031,2),(12524,115,0,2031,1),(12525,99,0,2031,1),(12526,93,0,2031,53),(12527,142,0,2031,173),(12528,97,0,2032,1),(12529,134,0,2032,2),(12530,115,0,2032,1),(12531,99,0,2032,1),(12532,93,0,2032,57),(12533,142,0,2032,173),(12534,97,0,2033,1),(12535,134,0,2033,2),(12536,115,0,2033,1),(12537,99,0,2033,1),(12538,93,0,2033,58),(12539,142,0,2033,173),(12540,97,0,2034,1),(12541,134,0,2034,2),(12542,115,0,2034,1),(12543,99,0,2034,1),(12544,93,0,2034,53),(12545,142,0,2034,174),(12546,97,0,2035,1),(12547,134,0,2035,2),(12548,115,0,2035,1),(12549,99,0,2035,1),(12550,93,0,2035,57),(12551,142,0,2035,174),(12552,97,0,2036,1),(12553,134,0,2036,2),(12554,115,0,2036,1),(12555,99,0,2036,1),(12556,93,0,2036,58),(12557,142,0,2036,174),(12558,97,0,2037,1),(12559,134,0,2037,2),(12560,115,0,2037,1),(12561,99,0,2037,1),(12562,93,0,2037,53),(12563,142,0,2037,175),(12564,97,0,2038,1),(12565,134,0,2038,2),(12566,115,0,2038,1),(12567,99,0,2038,1),(12568,93,0,2038,57),(12569,142,0,2038,175),(12570,97,0,2039,1),(12571,134,0,2039,2),(12572,115,0,2039,1),(12573,99,0,2039,1),(12574,93,0,2039,58),(12575,142,0,2039,175),(12576,97,0,2040,1),(12577,134,0,2040,2),(12578,115,0,2040,1),(12579,99,0,2040,4),(12580,143,0,2040,0),(12581,144,0,2040,0),(12582,145,0,2040,1),(12583,146,0,2040,0),(12584,147,0,2040,0),(12585,97,1,1220,1),(12586,134,1,1220,2),(12587,99,1,1220,4),(12588,97,1,1236,1),(12589,134,1,1236,2),(12590,99,1,1236,4),(12591,97,1,1252,1),(12592,134,1,1252,2),(12593,99,1,1252,4),(12594,97,1,1268,1),(12595,134,1,1268,2),(12596,99,1,1268,4),(12597,97,1,1284,1),(12598,134,1,1284,2),(12599,99,1,1284,4),(12600,97,1,1380,1),(12601,134,1,1380,2),(12602,99,1,1380,4),(12603,97,1,1300,1),(12604,134,1,1300,2),(12605,99,1,1300,4),(12606,97,1,1316,1),(12607,134,1,1316,2),(12608,99,1,1316,4),(12609,97,1,1332,1),(12610,134,1,1332,2),(12611,99,1,1332,4),(12612,97,1,1348,1),(12613,134,1,1348,2),(12614,99,1,1348,4),(12615,97,1,1364,1),(12616,134,1,1364,2),(12617,99,1,1364,4),(12618,97,1,1396,1),(12619,134,1,1396,2),(12620,99,1,1396,4);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_media_gallery`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_media_gallery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_media_gallery` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  `media_type` varchar(32) NOT NULL DEFAULT 'image' COMMENT 'Media entry type',
  `disabled` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Visibility status',
  PRIMARY KEY (`value_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_MDA_GLR_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3417 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Media Gallery Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_media_gallery`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_media_gallery` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_media_gallery` VALUES (1,90,'/m/b/mb01-blue-0.jpg','image',0),(2,90,'/m/b/mb04-black-0.jpg','image',0),(3,90,'/m/b/mb04-black-0_alt1.jpg','image',0),(4,90,'/m/b/mb03-black-0.jpg','image',0),(5,90,'/m/b/mb03-black-0_alt1.jpg','image',0),(6,90,'/m/b/mb05-black-0.jpg','image',0),(7,90,'/m/b/mb06-gray-0.jpg','image',0),(8,90,'/m/b/mb02-gray-0.jpg','image',0),(9,90,'/m/b/mb02-blue-0.jpg','image',0),(10,90,'/u/b/ub02-black-0.jpg','image',0),(11,90,'/w/b/wb01-black-0.jpg','image',0),(12,90,'/w/b/wb02-green-0.jpg','image',0),(13,90,'/w/b/wb05-red-0.jpg','image',0),(14,90,'/w/b/wb06-red-0.jpg','image',0),(15,90,'/w/b/wb06-red-0_alt1.jpg','image',0),(16,90,'/w/b/wb03-purple-0.jpg','image',0),(17,90,'/w/b/wb07-brown-0.jpg','image',0),(18,90,'/w/b/wb04-blue-0.jpg','image',0),(19,90,'/u/g/ug06-lb-0.jpg','image',0),(20,90,'/u/g/ug07-bk-0.jpg','image',0),(21,90,'/u/g/ug07-bk-0_alt1.jpg','image',0),(22,90,'/u/g/ug04-bk-0.jpg','image',0),(23,90,'/u/g/ug02-bk-0.jpg','image',0),(24,90,'/u/g/ug05-gr-0.jpg','image',0),(25,90,'/u/g/ug01-bk-0.jpg','image',0),(26,90,'/l/u/luma-yoga-brick.jpg','image',0),(27,90,'/l/u/luma-foam-roller.jpg','image',0),(28,90,'/u/g/ug03-bk-0.jpg','image',0),(29,90,'/l/u/luma-stability-ball-gray.jpg','image',0),(30,90,'/l/u/luma-stability-ball-pink.jpg','image',0),(31,90,'/l/u/luma-stability-ball.jpg','image',0),(32,90,'/l/u/luma-stability-ball-gray.jpg','image',0),(33,90,'/l/u/luma-stability-ball-pink.jpg','image',0),(34,90,'/l/u/luma-stability-ball.jpg','image',0),(35,90,'/l/u/luma-stability-ball-gray.jpg','image',0),(36,90,'/l/u/luma-stability-ball-pink.jpg','image',0),(37,90,'/l/u/luma-stability-ball.jpg','image',0),(38,90,'/l/u/luma-yoga-strap.jpg','image',0),(39,90,'/l/u/luma-yoga-strap.jpg','image',0),(40,90,'/l/u/luma-yoga-strap.jpg','image',0),(41,90,'/m/g/mg04-bk-0.jpg','image',0),(42,90,'/m/g/mg01-bk-0.jpg','image',0),(43,90,'/m/g/mg03-br-0.jpg','image',0),(44,90,'/m/g/mg05-br-0.jpg','image',0),(45,90,'/m/g/mg02-bk-0.jpg','image',0),(46,90,'/w/g/wg09-gr-0.jpg','image',0),(47,90,'/w/g/wg01-bk-0.jpg','image',0),(48,90,'/w/g/wg03-gr-0.jpg','image',0),(49,90,'/w/g/wg03-sa-0.jpg','image',0),(50,90,'/w/g/wg02-bk-0.jpg','image',0),(51,90,'/l/u/luma-yoga-kit-2.jpg','image',0),(52,90,'/l/u/luma-yoga-strap-set.jpg','image',0),(53,90,'/m/h/mh01-black_main_1.jpg','image',0),(54,90,'/m/h/mh01-gray_main_1.jpg','image',0),(55,90,'/m/h/mh01-gray_alt1_1.jpg','image',0),(56,90,'/m/h/mh01-gray_back_1.jpg','image',0),(57,90,'/m/h/mh01-orange_main_1.jpg','image',0),(58,90,'/m/h/mh01-black_main_1.jpg','image',0),(59,90,'/m/h/mh01-gray_main_1.jpg','image',0),(60,90,'/m/h/mh01-gray_alt1_1.jpg','image',0),(61,90,'/m/h/mh01-gray_back_1.jpg','image',0),(62,90,'/m/h/mh01-orange_main_1.jpg','image',0),(63,90,'/m/h/mh01-black_main_1.jpg','image',0),(64,90,'/m/h/mh01-gray_main_1.jpg','image',0),(65,90,'/m/h/mh01-gray_alt1_1.jpg','image',0),(66,90,'/m/h/mh01-gray_back_1.jpg','image',0),(67,90,'/m/h/mh01-orange_main_1.jpg','image',0),(68,90,'/m/h/mh01-black_main_1.jpg','image',0),(69,90,'/m/h/mh01-gray_main_1.jpg','image',0),(70,90,'/m/h/mh01-gray_alt1_1.jpg','image',0),(71,90,'/m/h/mh01-gray_back_1.jpg','image',0),(72,90,'/m/h/mh01-orange_main_1.jpg','image',0),(73,90,'/m/h/mh01-black_main_1.jpg','image',0),(74,90,'/m/h/mh01-gray_main_1.jpg','image',0),(75,90,'/m/h/mh01-gray_alt1_1.jpg','image',0),(76,90,'/m/h/mh01-gray_back_1.jpg','image',0),(77,90,'/m/h/mh01-orange_main_1.jpg','image',0),(78,90,'/m/h/mh01-gray_main_1.jpg','image',0),(79,90,'/m/h/mh01-gray_alt1_1.jpg','image',0),(80,90,'/m/h/mh01-gray_back_1.jpg','image',0),(81,90,'/m/h/mh02-black_main_1.jpg','image',0),(82,90,'/m/h/mh02-black_alt1_1.jpg','image',0),(83,90,'/m/h/mh02-black_back_1.jpg','image',0),(84,90,'/m/h/mh02-purple_main_1.jpg','image',0),(85,90,'/m/h/mh02-red_main_1.jpg','image',0),(86,90,'/m/h/mh02-black_main_1.jpg','image',0),(87,90,'/m/h/mh02-black_alt1_1.jpg','image',0),(88,90,'/m/h/mh02-black_back_1.jpg','image',0),(89,90,'/m/h/mh02-purple_main_1.jpg','image',0),(90,90,'/m/h/mh02-red_main_1.jpg','image',0),(91,90,'/m/h/mh02-black_main_1.jpg','image',0),(92,90,'/m/h/mh02-black_alt1_1.jpg','image',0),(93,90,'/m/h/mh02-black_back_1.jpg','image',0),(94,90,'/m/h/mh02-purple_main_1.jpg','image',0),(95,90,'/m/h/mh02-red_main_1.jpg','image',0),(96,90,'/m/h/mh02-black_main_1.jpg','image',0),(97,90,'/m/h/mh02-black_alt1_1.jpg','image',0),(98,90,'/m/h/mh02-black_back_1.jpg','image',0),(99,90,'/m/h/mh02-purple_main_1.jpg','image',0),(100,90,'/m/h/mh02-red_main_1.jpg','image',0),(101,90,'/m/h/mh02-black_main_1.jpg','image',0),(102,90,'/m/h/mh02-black_alt1_1.jpg','image',0),(103,90,'/m/h/mh02-black_back_1.jpg','image',0),(104,90,'/m/h/mh02-purple_main_1.jpg','image',0),(105,90,'/m/h/mh02-red_main_1.jpg','image',0),(106,90,'/m/h/mh02-black_main_1.jpg','image',0),(107,90,'/m/h/mh02-black_alt1_1.jpg','image',0),(108,90,'/m/h/mh02-black_back_1.jpg','image',0),(109,90,'/m/h/mh03-black_main_1.jpg','image',0),(110,90,'/m/h/mh03-black_alt1_1.jpg','image',0),(111,90,'/m/h/mh03-black_back_1.jpg','image',0),(112,90,'/m/h/mh03-blue_main_1.jpg','image',0),(113,90,'/m/h/mh03-green_main_1.jpg','image',0),(114,90,'/m/h/mh03-black_main_1.jpg','image',0),(115,90,'/m/h/mh03-black_alt1_1.jpg','image',0),(116,90,'/m/h/mh03-black_back_1.jpg','image',0),(117,90,'/m/h/mh03-blue_main_1.jpg','image',0),(118,90,'/m/h/mh03-green_main_1.jpg','image',0),(119,90,'/m/h/mh03-black_main_1.jpg','image',0),(120,90,'/m/h/mh03-black_alt1_1.jpg','image',0),(121,90,'/m/h/mh03-black_back_1.jpg','image',0),(122,90,'/m/h/mh03-blue_main_1.jpg','image',0),(123,90,'/m/h/mh03-green_main_1.jpg','image',0),(124,90,'/m/h/mh03-black_main_1.jpg','image',0),(125,90,'/m/h/mh03-black_alt1_1.jpg','image',0),(126,90,'/m/h/mh03-black_back_1.jpg','image',0),(127,90,'/m/h/mh03-blue_main_1.jpg','image',0),(128,90,'/m/h/mh03-green_main_1.jpg','image',0),(129,90,'/m/h/mh03-black_main_1.jpg','image',0),(130,90,'/m/h/mh03-black_alt1_1.jpg','image',0),(131,90,'/m/h/mh03-black_back_1.jpg','image',0),(132,90,'/m/h/mh03-blue_main_1.jpg','image',0),(133,90,'/m/h/mh03-green_main_1.jpg','image',0),(134,90,'/m/h/mh03-black_main_1.jpg','image',0),(135,90,'/m/h/mh03-black_alt1_1.jpg','image',0),(136,90,'/m/h/mh03-black_back_1.jpg','image',0),(137,90,'/m/h/mh04-green_main_1.jpg','image',0),(138,90,'/m/h/mh04-green_alt1_1.jpg','image',0),(139,90,'/m/h/mh04-green_back_1.jpg','image',0),(140,90,'/m/h/mh04-white_main_1.jpg','image',0),(141,90,'/m/h/mh04-yellow_main_1.jpg','image',0),(142,90,'/m/h/mh04-green_main_1.jpg','image',0),(143,90,'/m/h/mh04-green_alt1_1.jpg','image',0),(144,90,'/m/h/mh04-green_back_1.jpg','image',0),(145,90,'/m/h/mh04-white_main_1.jpg','image',0),(146,90,'/m/h/mh04-yellow_main_1.jpg','image',0),(147,90,'/m/h/mh04-green_main_1.jpg','image',0),(148,90,'/m/h/mh04-green_alt1_1.jpg','image',0),(149,90,'/m/h/mh04-green_back_1.jpg','image',0),(150,90,'/m/h/mh04-white_main_1.jpg','image',0),(151,90,'/m/h/mh04-yellow_main_1.jpg','image',0),(152,90,'/m/h/mh04-green_main_1.jpg','image',0),(153,90,'/m/h/mh04-green_alt1_1.jpg','image',0),(154,90,'/m/h/mh04-green_back_1.jpg','image',0),(155,90,'/m/h/mh04-white_main_1.jpg','image',0),(156,90,'/m/h/mh04-yellow_main_1.jpg','image',0),(157,90,'/m/h/mh04-green_main_1.jpg','image',0),(158,90,'/m/h/mh04-green_alt1_1.jpg','image',0),(159,90,'/m/h/mh04-green_back_1.jpg','image',0),(160,90,'/m/h/mh04-white_main_1.jpg','image',0),(161,90,'/m/h/mh04-yellow_main_1.jpg','image',0),(162,90,'/m/h/mh04-green_main_1.jpg','image',0),(163,90,'/m/h/mh04-green_alt1_1.jpg','image',0),(164,90,'/m/h/mh04-green_back_1.jpg','image',0),(165,90,'/m/h/mh05-green_main_1.jpg','image',0),(166,90,'/m/h/mh05-red_main_1.jpg','image',0),(167,90,'/m/h/mh05-white_main_1.jpg','image',0),(168,90,'/m/h/mh05-white_alt1_1.jpg','image',0),(169,90,'/m/h/mh05-white_back_1.jpg','image',0),(170,90,'/m/h/mh05-green_main_1.jpg','image',0),(171,90,'/m/h/mh05-red_main_1.jpg','image',0),(172,90,'/m/h/mh05-white_main_1.jpg','image',0),(173,90,'/m/h/mh05-white_alt1_1.jpg','image',0),(174,90,'/m/h/mh05-white_back_1.jpg','image',0),(175,90,'/m/h/mh05-green_main_1.jpg','image',0),(176,90,'/m/h/mh05-red_main_1.jpg','image',0),(177,90,'/m/h/mh05-white_main_1.jpg','image',0),(178,90,'/m/h/mh05-white_alt1_1.jpg','image',0),(179,90,'/m/h/mh05-white_back_1.jpg','image',0),(180,90,'/m/h/mh05-green_main_1.jpg','image',0),(181,90,'/m/h/mh05-red_main_1.jpg','image',0),(182,90,'/m/h/mh05-white_main_1.jpg','image',0),(183,90,'/m/h/mh05-white_alt1_1.jpg','image',0),(184,90,'/m/h/mh05-white_back_1.jpg','image',0),(185,90,'/m/h/mh05-green_main_1.jpg','image',0),(186,90,'/m/h/mh05-red_main_1.jpg','image',0),(187,90,'/m/h/mh05-white_main_1.jpg','image',0),(188,90,'/m/h/mh05-white_alt1_1.jpg','image',0),(189,90,'/m/h/mh05-white_back_1.jpg','image',0),(190,90,'/m/h/mh05-white_main_1.jpg','image',0),(191,90,'/m/h/mh05-white_alt1_1.jpg','image',0),(192,90,'/m/h/mh05-white_back_1.jpg','image',0),(193,90,'/m/h/mh06-black_main_1.jpg','image',0),(194,90,'/m/h/mh06-blue_main_1.jpg','image',0),(195,90,'/m/h/mh06-blue_alt1_1.jpg','image',0),(196,90,'/m/h/mh06-blue_back_1.jpg','image',0),(197,90,'/m/h/mh06-purple_main_1.jpg','image',0),(198,90,'/m/h/mh06-black_main_1.jpg','image',0),(199,90,'/m/h/mh06-blue_main_1.jpg','image',0),(200,90,'/m/h/mh06-blue_alt1_1.jpg','image',0),(201,90,'/m/h/mh06-blue_back_1.jpg','image',0),(202,90,'/m/h/mh06-purple_main_1.jpg','image',0),(203,90,'/m/h/mh06-black_main_1.jpg','image',0),(204,90,'/m/h/mh06-blue_main_1.jpg','image',0),(205,90,'/m/h/mh06-blue_alt1_1.jpg','image',0),(206,90,'/m/h/mh06-blue_back_1.jpg','image',0),(207,90,'/m/h/mh06-purple_main_1.jpg','image',0),(208,90,'/m/h/mh06-black_main_1.jpg','image',0),(209,90,'/m/h/mh06-blue_main_1.jpg','image',0),(210,90,'/m/h/mh06-blue_alt1_1.jpg','image',0),(211,90,'/m/h/mh06-blue_back_1.jpg','image',0),(212,90,'/m/h/mh06-purple_main_1.jpg','image',0),(213,90,'/m/h/mh06-black_main_1.jpg','image',0),(214,90,'/m/h/mh06-blue_main_1.jpg','image',0),(215,90,'/m/h/mh06-blue_alt1_1.jpg','image',0),(216,90,'/m/h/mh06-blue_back_1.jpg','image',0),(217,90,'/m/h/mh06-purple_main_1.jpg','image',0),(218,90,'/m/h/mh06-blue_main_1.jpg','image',0),(219,90,'/m/h/mh06-blue_alt1_1.jpg','image',0),(220,90,'/m/h/mh06-blue_back_1.jpg','image',0),(221,90,'/m/h/mh07-black_main_1.jpg','image',0),(222,90,'/m/h/mh07-gray_main_1.jpg','image',0),(223,90,'/m/h/mh07-gray_alt1_1.jpg','image',0),(224,90,'/m/h/mh07-gray_back_1.jpg','image',0),(225,90,'/m/h/mh07-green_main_1.jpg','image',0),(226,90,'/m/h/mh07-black_main_1.jpg','image',0),(227,90,'/m/h/mh07-gray_main_2.jpg','image',0),(228,90,'/m/h/mh07-gray_alt1_2.jpg','image',0),(229,90,'/m/h/mh07-gray_back_2.jpg','image',0),(230,90,'/m/h/mh07-green_main_2.jpg','image',0),(231,90,'/m/h/mh07-black_main_2.jpg','image',0),(232,90,'/m/h/mh07-gray_main_2.jpg','image',0),(233,90,'/m/h/mh07-gray_alt1_2.jpg','image',0),(234,90,'/m/h/mh07-gray_back_2.jpg','image',0),(235,90,'/m/h/mh07-green_main_2.jpg','image',0),(236,90,'/m/h/mh07-black_main_2.jpg','image',0),(237,90,'/m/h/mh07-gray_main_2.jpg','image',0),(238,90,'/m/h/mh07-gray_alt1_2.jpg','image',0),(239,90,'/m/h/mh07-gray_back_2.jpg','image',0),(240,90,'/m/h/mh07-green_main_2.jpg','image',0),(241,90,'/m/h/mh07-black_main_2.jpg','image',0),(242,90,'/m/h/mh07-gray_main_2.jpg','image',0),(243,90,'/m/h/mh07-gray_alt1_2.jpg','image',0),(244,90,'/m/h/mh07-gray_back_2.jpg','image',0),(245,90,'/m/h/mh07-green_main_2.jpg','image',0),(246,90,'/m/h/mh07-gray_main_2.jpg','image',0),(247,90,'/m/h/mh07-gray_alt1_2.jpg','image',0),(248,90,'/m/h/mh07-gray_back_2.jpg','image',0),(249,90,'/m/h/mh08-brown_main_1.jpg','image',0),(250,90,'/m/h/mh08-brown_alt1_1.jpg','image',0),(251,90,'/m/h/mh08-brown_back_1.jpg','image',0),(252,90,'/m/h/mh08-purple_main_1.jpg','image',0),(253,90,'/m/h/mh08-red_main_1.jpg','image',0),(254,90,'/m/h/mh08-brown_main_1.jpg','image',0),(255,90,'/m/h/mh08-brown_alt1_1.jpg','image',0),(256,90,'/m/h/mh08-brown_back_1.jpg','image',0),(257,90,'/m/h/mh08-purple_main_1.jpg','image',0),(258,90,'/m/h/mh08-red_main_1.jpg','image',0),(259,90,'/m/h/mh08-brown_main_1.jpg','image',0),(260,90,'/m/h/mh08-brown_alt1_1.jpg','image',0),(261,90,'/m/h/mh08-brown_back_1.jpg','image',0),(262,90,'/m/h/mh08-purple_main_1.jpg','image',0),(263,90,'/m/h/mh08-red_main_1.jpg','image',0),(264,90,'/m/h/mh08-brown_main_1.jpg','image',0),(265,90,'/m/h/mh08-brown_alt1_1.jpg','image',0),(266,90,'/m/h/mh08-brown_back_1.jpg','image',0),(267,90,'/m/h/mh08-purple_main_1.jpg','image',0),(268,90,'/m/h/mh08-red_main_1.jpg','image',0),(269,90,'/m/h/mh08-brown_main_1.jpg','image',0),(270,90,'/m/h/mh08-brown_alt1_1.jpg','image',0),(271,90,'/m/h/mh08-brown_back_1.jpg','image',0),(272,90,'/m/h/mh08-purple_main_1.jpg','image',0),(273,90,'/m/h/mh08-red_main_1.jpg','image',0),(274,90,'/m/h/mh08-brown_main_1.jpg','image',0),(275,90,'/m/h/mh08-brown_alt1_1.jpg','image',0),(276,90,'/m/h/mh08-brown_back_1.jpg','image',0),(277,90,'/m/h/mh09-blue_main_1.jpg','image',0),(278,90,'/m/h/mh09-blue_alt1_1.jpg','image',0),(279,90,'/m/h/mh09-blue_back_1.jpg','image',0),(280,90,'/m/h/mh09-green_main_1.jpg','image',0),(281,90,'/m/h/mh09-red_main_1.jpg','image',0),(282,90,'/m/h/mh09-blue_main_1.jpg','image',0),(283,90,'/m/h/mh09-blue_alt1_1.jpg','image',0),(284,90,'/m/h/mh09-blue_back_1.jpg','image',0),(285,90,'/m/h/mh09-green_main_1.jpg','image',0),(286,90,'/m/h/mh09-red_main_1.jpg','image',0),(287,90,'/m/h/mh09-blue_main_1.jpg','image',0),(288,90,'/m/h/mh09-blue_alt1_1.jpg','image',0),(289,90,'/m/h/mh09-blue_back_1.jpg','image',0),(290,90,'/m/h/mh09-green_main_1.jpg','image',0),(291,90,'/m/h/mh09-red_main_1.jpg','image',0),(292,90,'/m/h/mh09-blue_main_1.jpg','image',0),(293,90,'/m/h/mh09-blue_alt1_1.jpg','image',0),(294,90,'/m/h/mh09-blue_back_1.jpg','image',0),(295,90,'/m/h/mh09-green_main_1.jpg','image',0),(296,90,'/m/h/mh09-red_main_1.jpg','image',0),(297,90,'/m/h/mh09-blue_main_1.jpg','image',0),(298,90,'/m/h/mh09-blue_alt1_1.jpg','image',0),(299,90,'/m/h/mh09-blue_back_1.jpg','image',0),(300,90,'/m/h/mh09-green_main_1.jpg','image',0),(301,90,'/m/h/mh09-red_main_1.jpg','image',0),(302,90,'/m/h/mh09-blue_main_1.jpg','image',0),(303,90,'/m/h/mh09-blue_alt1_1.jpg','image',0),(304,90,'/m/h/mh09-blue_back_1.jpg','image',0),(305,90,'/m/h/mh10-black_main_1.jpg','image',0),(306,90,'/m/h/mh10-blue_main_1.jpg','image',0),(307,90,'/m/h/mh10-blue_alt1_1.jpg','image',0),(308,90,'/m/h/mh10-blue_back_1.jpg','image',0),(309,90,'/m/h/mh10-red_main_1.jpg','image',0),(310,90,'/m/h/mh10-black_main_1.jpg','image',0),(311,90,'/m/h/mh10-blue_main_1.jpg','image',0),(312,90,'/m/h/mh10-blue_alt1_1.jpg','image',0),(313,90,'/m/h/mh10-blue_back_1.jpg','image',0),(314,90,'/m/h/mh10-red_main_1.jpg','image',0),(315,90,'/m/h/mh10-black_main_1.jpg','image',0),(316,90,'/m/h/mh10-blue_main_1.jpg','image',0),(317,90,'/m/h/mh10-blue_alt1_1.jpg','image',0),(318,90,'/m/h/mh10-blue_back_1.jpg','image',0),(319,90,'/m/h/mh10-red_main_1.jpg','image',0),(320,90,'/m/h/mh10-black_main_1.jpg','image',0),(321,90,'/m/h/mh10-blue_main_1.jpg','image',0),(322,90,'/m/h/mh10-blue_alt1_1.jpg','image',0),(323,90,'/m/h/mh10-blue_back_1.jpg','image',0),(324,90,'/m/h/mh10-red_main_1.jpg','image',0),(325,90,'/m/h/mh10-black_main_1.jpg','image',0),(326,90,'/m/h/mh10-blue_main_1.jpg','image',0),(327,90,'/m/h/mh10-blue_alt1_1.jpg','image',0),(328,90,'/m/h/mh10-blue_back_1.jpg','image',0),(329,90,'/m/h/mh10-red_main_1.jpg','image',0),(330,90,'/m/h/mh10-blue_main_1.jpg','image',0),(331,90,'/m/h/mh10-blue_alt1_1.jpg','image',0),(332,90,'/m/h/mh10-blue_back_1.jpg','image',0),(333,90,'/m/h/mh11-orange_main_1.jpg','image',0),(334,90,'/m/h/mh11-red_main_1.jpg','image',0),(335,90,'/m/h/mh11-white_main_1.jpg','image',0),(336,90,'/m/h/mh11-white_alt1_1.jpg','image',0),(337,90,'/m/h/mh11-white_back_1.jpg','image',0),(338,90,'/m/h/mh11-orange_main_1.jpg','image',0),(339,90,'/m/h/mh11-red_main_1.jpg','image',0),(340,90,'/m/h/mh11-white_main_1.jpg','image',0),(341,90,'/m/h/mh11-white_alt1_1.jpg','image',0),(342,90,'/m/h/mh11-white_back_1.jpg','image',0),(343,90,'/m/h/mh11-orange_main_1.jpg','image',0),(344,90,'/m/h/mh11-red_main_1.jpg','image',0),(345,90,'/m/h/mh11-white_main_1.jpg','image',0),(346,90,'/m/h/mh11-white_alt1_1.jpg','image',0),(347,90,'/m/h/mh11-white_back_1.jpg','image',0),(348,90,'/m/h/mh11-orange_main_1.jpg','image',0),(349,90,'/m/h/mh11-red_main_1.jpg','image',0),(350,90,'/m/h/mh11-white_main_1.jpg','image',0),(351,90,'/m/h/mh11-white_alt1_1.jpg','image',0),(352,90,'/m/h/mh11-white_back_1.jpg','image',0),(353,90,'/m/h/mh11-orange_main_1.jpg','image',0),(354,90,'/m/h/mh11-red_main_1.jpg','image',0),(355,90,'/m/h/mh11-white_main_1.jpg','image',0),(356,90,'/m/h/mh11-white_alt1_1.jpg','image',0),(357,90,'/m/h/mh11-white_back_1.jpg','image',0),(358,90,'/m/h/mh11-white_main_1.jpg','image',0),(359,90,'/m/h/mh11-white_alt1_1.jpg','image',0),(360,90,'/m/h/mh11-white_back_1.jpg','image',0),(361,90,'/m/h/mh12-blue_main_1.jpg','image',0),(362,90,'/m/h/mh12-green_main_1.jpg','image',0),(363,90,'/m/h/mh12-green_alt1_1.jpg','image',0),(364,90,'/m/h/mh12-green_back_1.jpg','image',0),(365,90,'/m/h/mh12-red_main_1.jpg','image',0),(366,90,'/m/h/mh12-blue_main_1.jpg','image',0),(367,90,'/m/h/mh12-green_main_1.jpg','image',0),(368,90,'/m/h/mh12-green_alt1_1.jpg','image',0),(369,90,'/m/h/mh12-green_back_1.jpg','image',0),(370,90,'/m/h/mh12-red_main_1.jpg','image',0),(371,90,'/m/h/mh12-blue_main_1.jpg','image',0),(372,90,'/m/h/mh12-green_main_1.jpg','image',0),(373,90,'/m/h/mh12-green_alt1_1.jpg','image',0),(374,90,'/m/h/mh12-green_back_1.jpg','image',0),(375,90,'/m/h/mh12-red_main_1.jpg','image',0),(376,90,'/m/h/mh12-blue_main_1.jpg','image',0),(377,90,'/m/h/mh12-green_main_1.jpg','image',0),(378,90,'/m/h/mh12-green_alt1_1.jpg','image',0),(379,90,'/m/h/mh12-green_back_1.jpg','image',0),(380,90,'/m/h/mh12-red_main_1.jpg','image',0),(381,90,'/m/h/mh12-blue_main_1.jpg','image',0),(382,90,'/m/h/mh12-green_main_1.jpg','image',0),(383,90,'/m/h/mh12-green_alt1_1.jpg','image',0),(384,90,'/m/h/mh12-green_back_1.jpg','image',0),(385,90,'/m/h/mh12-red_main_1.jpg','image',0),(386,90,'/m/h/mh12-green_main_1.jpg','image',0),(387,90,'/m/h/mh12-green_alt1_1.jpg','image',0),(388,90,'/m/h/mh12-green_back_1.jpg','image',0),(389,90,'/m/h/mh13-blue_main_1.jpg','image',0),(390,90,'/m/h/mh13-blue_alt1_1.jpg','image',0),(391,90,'/m/h/mh13-blue_back_1.jpg','image',0),(392,90,'/m/h/mh13-green_main_1.jpg','image',0),(393,90,'/m/h/mh13-lavender_main_1.jpg','image',0),(394,90,'/m/h/mh13-blue_main_1.jpg','image',0),(395,90,'/m/h/mh13-blue_alt1_1.jpg','image',0),(396,90,'/m/h/mh13-blue_back_1.jpg','image',0),(397,90,'/m/h/mh13-green_main_1.jpg','image',0),(398,90,'/m/h/mh13-lavender_main_1.jpg','image',0),(399,90,'/m/h/mh13-blue_main_1.jpg','image',0),(400,90,'/m/h/mh13-blue_alt1_1.jpg','image',0),(401,90,'/m/h/mh13-blue_back_1.jpg','image',0),(402,90,'/m/h/mh13-green_main_1.jpg','image',0),(403,90,'/m/h/mh13-lavender_main_2.jpg','image',0),(404,90,'/m/h/mh13-blue_main_2.jpg','image',0),(405,90,'/m/h/mh13-blue_alt1_2.jpg','image',0),(406,90,'/m/h/mh13-blue_back_2.jpg','image',0),(407,90,'/m/h/mh13-green_main_2.jpg','image',0),(408,90,'/m/h/mh13-lavender_main_2.jpg','image',0),(409,90,'/m/h/mh13-blue_main_2.jpg','image',0),(410,90,'/m/h/mh13-blue_alt1_2.jpg','image',0),(411,90,'/m/h/mh13-blue_back_2.jpg','image',0),(412,90,'/m/h/mh13-green_main_2.jpg','image',0),(413,90,'/m/h/mh13-lavender_main_2.jpg','image',0),(414,90,'/m/h/mh13-blue_main_2.jpg','image',0),(415,90,'/m/h/mh13-blue_alt1_2.jpg','image',0),(416,90,'/m/h/mh13-blue_back_2.jpg','image',0),(417,90,'/m/j/mj01-orange_main_1.jpg','image',0),(418,90,'/m/j/mj01-red_main_1.jpg','image',0),(419,90,'/m/j/mj01-yellow_main_1.jpg','image',0),(420,90,'/m/j/mj01-yellow_alt1_1.jpg','image',0),(421,90,'/m/j/mj01-yellow_back_1.jpg','image',0),(422,90,'/m/j/mj01-orange_main_1.jpg','image',0),(423,90,'/m/j/mj01-red_main_1.jpg','image',0),(424,90,'/m/j/mj01-yellow_main_1.jpg','image',0),(425,90,'/m/j/mj01-yellow_alt1_1.jpg','image',0),(426,90,'/m/j/mj01-yellow_back_1.jpg','image',0),(427,90,'/m/j/mj01-orange_main_1.jpg','image',0),(428,90,'/m/j/mj01-red_main_1.jpg','image',0),(429,90,'/m/j/mj01-yellow_main_1.jpg','image',0),(430,90,'/m/j/mj01-yellow_alt1_1.jpg','image',0),(431,90,'/m/j/mj01-yellow_back_1.jpg','image',0),(432,90,'/m/j/mj01-orange_main_1.jpg','image',0),(433,90,'/m/j/mj01-red_main_1.jpg','image',0),(434,90,'/m/j/mj01-yellow_main_1.jpg','image',0),(435,90,'/m/j/mj01-yellow_alt1_1.jpg','image',0),(436,90,'/m/j/mj01-yellow_back_1.jpg','image',0),(437,90,'/m/j/mj01-orange_main_1.jpg','image',0),(438,90,'/m/j/mj01-red_main_1.jpg','image',0),(439,90,'/m/j/mj01-yellow_main_1.jpg','image',0),(440,90,'/m/j/mj01-yellow_alt1_1.jpg','image',0),(441,90,'/m/j/mj01-yellow_back_1.jpg','image',0),(442,90,'/m/j/mj01-yellow_main_1.jpg','image',0),(443,90,'/m/j/mj01-yellow_alt1_1.jpg','image',0),(444,90,'/m/j/mj01-yellow_back_1.jpg','image',0),(445,90,'/m/j/mj02-green_main_1.jpg','image',0),(446,90,'/m/j/mj02-green_alt1_1.jpg','image',0),(447,90,'/m/j/mj02-green_back_1.jpg','image',0),(448,90,'/m/j/mj02-orange_main_1.jpg','image',0),(449,90,'/m/j/mj02-red_main_1.jpg','image',0),(450,90,'/m/j/mj02-green_main_1.jpg','image',0),(451,90,'/m/j/mj02-green_alt1_1.jpg','image',0),(452,90,'/m/j/mj02-green_back_1.jpg','image',0),(453,90,'/m/j/mj02-orange_main_1.jpg','image',0),(454,90,'/m/j/mj02-red_main_1.jpg','image',0),(455,90,'/m/j/mj02-green_main_1.jpg','image',0),(456,90,'/m/j/mj02-green_alt1_1.jpg','image',0),(457,90,'/m/j/mj02-green_back_1.jpg','image',0),(458,90,'/m/j/mj02-orange_main_1.jpg','image',0),(459,90,'/m/j/mj02-red_main_1.jpg','image',0),(460,90,'/m/j/mj02-green_main_1.jpg','image',0),(461,90,'/m/j/mj02-green_alt1_1.jpg','image',0),(462,90,'/m/j/mj02-green_back_1.jpg','image',0),(463,90,'/m/j/mj02-orange_main_1.jpg','image',0),(464,90,'/m/j/mj02-red_main_1.jpg','image',0),(465,90,'/m/j/mj02-green_main_1.jpg','image',0),(466,90,'/m/j/mj02-green_alt1_1.jpg','image',0),(467,90,'/m/j/mj02-green_back_1.jpg','image',0),(468,90,'/m/j/mj02-orange_main_1.jpg','image',0),(469,90,'/m/j/mj02-red_main_1.jpg','image',0),(470,90,'/m/j/mj02-green_main_1.jpg','image',0),(471,90,'/m/j/mj02-green_alt1_1.jpg','image',0),(472,90,'/m/j/mj02-green_back_1.jpg','image',0),(473,90,'/m/j/mj04-black_main_1.jpg','image',0),(474,90,'/m/j/mj04-black_alt1_1.jpg','image',0),(475,90,'/m/j/mj04-black_back_1.jpg','image',0),(476,90,'/m/j/mj04-blue_main_1.jpg','image',0),(477,90,'/m/j/mj04-purple_main_1.jpg','image',0),(478,90,'/m/j/mj04-black_main_1.jpg','image',0),(479,90,'/m/j/mj04-black_alt1_1.jpg','image',0),(480,90,'/m/j/mj04-black_back_1.jpg','image',0),(481,90,'/m/j/mj04-blue_main_1.jpg','image',0),(482,90,'/m/j/mj04-purple_main_1.jpg','image',0),(483,90,'/m/j/mj04-black_main_1.jpg','image',0),(484,90,'/m/j/mj04-black_alt1_1.jpg','image',0),(485,90,'/m/j/mj04-black_back_1.jpg','image',0),(486,90,'/m/j/mj04-blue_main_1.jpg','image',0),(487,90,'/m/j/mj04-purple_main_1.jpg','image',0),(488,90,'/m/j/mj04-black_main_1.jpg','image',0),(489,90,'/m/j/mj04-black_alt1_1.jpg','image',0),(490,90,'/m/j/mj04-black_back_1.jpg','image',0),(491,90,'/m/j/mj04-blue_main_1.jpg','image',0),(492,90,'/m/j/mj04-purple_main_1.jpg','image',0),(493,90,'/m/j/mj04-black_main_1.jpg','image',0),(494,90,'/m/j/mj04-black_alt1_1.jpg','image',0),(495,90,'/m/j/mj04-black_back_1.jpg','image',0),(496,90,'/m/j/mj04-blue_main_1.jpg','image',0),(497,90,'/m/j/mj04-purple_main_1.jpg','image',0),(498,90,'/m/j/mj04-black_main_1.jpg','image',0),(499,90,'/m/j/mj04-black_alt1_1.jpg','image',0),(500,90,'/m/j/mj04-black_back_1.jpg','image',0),(501,90,'/m/j/mj07-black_main_1.jpg','image',0),(502,90,'/m/j/mj07-red_main_1.jpg','image',0),(503,90,'/m/j/mj07-red_alt1_1.jpg','image',0),(504,90,'/m/j/mj07-red_back_1.jpg','image',0),(505,90,'/m/j/mj07-yellow_main_1.jpg','image',0),(506,90,'/m/j/mj07-black_main_1.jpg','image',0),(507,90,'/m/j/mj07-red_main_1.jpg','image',0),(508,90,'/m/j/mj07-red_alt1_1.jpg','image',0),(509,90,'/m/j/mj07-red_back_1.jpg','image',0),(510,90,'/m/j/mj07-yellow_main_1.jpg','image',0),(511,90,'/m/j/mj07-black_main_1.jpg','image',0),(512,90,'/m/j/mj07-red_main_1.jpg','image',0),(513,90,'/m/j/mj07-red_alt1_1.jpg','image',0),(514,90,'/m/j/mj07-red_back_1.jpg','image',0),(515,90,'/m/j/mj07-yellow_main_1.jpg','image',0),(516,90,'/m/j/mj07-black_main_1.jpg','image',0),(517,90,'/m/j/mj07-red_main_1.jpg','image',0),(518,90,'/m/j/mj07-red_alt1_1.jpg','image',0),(519,90,'/m/j/mj07-red_back_1.jpg','image',0),(520,90,'/m/j/mj07-yellow_main_1.jpg','image',0),(521,90,'/m/j/mj07-black_main_1.jpg','image',0),(522,90,'/m/j/mj07-red_main_1.jpg','image',0),(523,90,'/m/j/mj07-red_alt1_1.jpg','image',0),(524,90,'/m/j/mj07-red_back_1.jpg','image',0),(525,90,'/m/j/mj07-yellow_main_1.jpg','image',0),(526,90,'/m/j/mj07-red_main_1.jpg','image',0),(527,90,'/m/j/mj07-red_alt1_1.jpg','image',0),(528,90,'/m/j/mj07-red_back_1.jpg','image',0),(529,90,'/m/j/mj08-blue_main_1.jpg','image',0),(530,90,'/m/j/mj08-gray_main_1.jpg','image',0),(531,90,'/m/j/mj08-gray_alt1_1.jpg','image',0),(532,90,'/m/j/mj08-gray_back_1.jpg','image',0),(533,90,'/m/j/mj08-green_main_1.jpg','image',0),(534,90,'/m/j/mj08-blue_main_1.jpg','image',0),(535,90,'/m/j/mj08-gray_main_1.jpg','image',0),(536,90,'/m/j/mj08-gray_alt1_1.jpg','image',0),(537,90,'/m/j/mj08-gray_back_1.jpg','image',0),(538,90,'/m/j/mj08-green_main_1.jpg','image',0),(539,90,'/m/j/mj08-blue_main_1.jpg','image',0),(540,90,'/m/j/mj08-gray_main_1.jpg','image',0),(541,90,'/m/j/mj08-gray_alt1_1.jpg','image',0),(542,90,'/m/j/mj08-gray_back_1.jpg','image',0),(543,90,'/m/j/mj08-green_main_1.jpg','image',0),(544,90,'/m/j/mj08-blue_main_1.jpg','image',0),(545,90,'/m/j/mj08-gray_main_1.jpg','image',0),(546,90,'/m/j/mj08-gray_alt1_1.jpg','image',0),(547,90,'/m/j/mj08-gray_back_1.jpg','image',0),(548,90,'/m/j/mj08-green_main_1.jpg','image',0),(549,90,'/m/j/mj08-blue_main_1.jpg','image',0),(550,90,'/m/j/mj08-gray_main_1.jpg','image',0),(551,90,'/m/j/mj08-gray_alt1_1.jpg','image',0),(552,90,'/m/j/mj08-gray_back_1.jpg','image',0),(553,90,'/m/j/mj08-green_main_1.jpg','image',0),(554,90,'/m/j/mj08-gray_main_1.jpg','image',0),(555,90,'/m/j/mj08-gray_alt1_1.jpg','image',0),(556,90,'/m/j/mj08-gray_back_1.jpg','image',0),(557,90,'/m/j/mj09-blue_main_1.jpg','image',0),(558,90,'/m/j/mj09-white_main_1.jpg','image',0),(559,90,'/m/j/mj09-yellow_main_1.jpg','image',0),(560,90,'/m/j/mj09-yellow_alt1_1.jpg','image',0),(561,90,'/m/j/mj09-yellow_back_1.jpg','image',0),(562,90,'/m/j/mj09-blue_main_1.jpg','image',0),(563,90,'/m/j/mj09-white_main_1.jpg','image',0),(564,90,'/m/j/mj09-yellow_main_1.jpg','image',0),(565,90,'/m/j/mj09-yellow_alt1_1.jpg','image',0),(566,90,'/m/j/mj09-yellow_back_1.jpg','image',0),(567,90,'/m/j/mj09-blue_main_1.jpg','image',0),(568,90,'/m/j/mj09-white_main_1.jpg','image',0),(569,90,'/m/j/mj09-yellow_main_1.jpg','image',0),(570,90,'/m/j/mj09-yellow_alt1_1.jpg','image',0),(571,90,'/m/j/mj09-yellow_back_1.jpg','image',0),(572,90,'/m/j/mj09-blue_main_1.jpg','image',0),(573,90,'/m/j/mj09-white_main_1.jpg','image',0),(574,90,'/m/j/mj09-yellow_main_1.jpg','image',0),(575,90,'/m/j/mj09-yellow_alt1_1.jpg','image',0),(576,90,'/m/j/mj09-yellow_back_1.jpg','image',0),(577,90,'/m/j/mj09-blue_main_2.jpg','image',0),(578,90,'/m/j/mj09-white_main_2.jpg','image',0),(579,90,'/m/j/mj09-yellow_main_2.jpg','image',0),(580,90,'/m/j/mj09-yellow_alt1_2.jpg','image',0),(581,90,'/m/j/mj09-yellow_back_2.jpg','image',0),(582,90,'/m/j/mj09-yellow_main_2.jpg','image',0),(583,90,'/m/j/mj09-yellow_alt1_2.jpg','image',0),(584,90,'/m/j/mj09-yellow_back_2.jpg','image',0),(585,90,'/m/j/mj10-black_main_1.jpg','image',0),(586,90,'/m/j/mj10-orange_main_1.jpg','image',0),(587,90,'/m/j/mj10-red_main_1.jpg','image',0),(588,90,'/m/j/mj10-red_alt1_1.jpg','image',0),(589,90,'/m/j/mj10-red_back_1.jpg','image',0),(590,90,'/m/j/mj10-black_main_1.jpg','image',0),(591,90,'/m/j/mj10-orange_main_1.jpg','image',0),(592,90,'/m/j/mj10-red_main_1.jpg','image',0),(593,90,'/m/j/mj10-red_alt1_1.jpg','image',0),(594,90,'/m/j/mj10-red_back_1.jpg','image',0),(595,90,'/m/j/mj10-black_main_1.jpg','image',0),(596,90,'/m/j/mj10-orange_main_1.jpg','image',0),(597,90,'/m/j/mj10-red_main_1.jpg','image',0),(598,90,'/m/j/mj10-red_alt1_1.jpg','image',0),(599,90,'/m/j/mj10-red_back_1.jpg','image',0),(600,90,'/m/j/mj10-black_main_1.jpg','image',0),(601,90,'/m/j/mj10-orange_main_1.jpg','image',0),(602,90,'/m/j/mj10-red_main_1.jpg','image',0),(603,90,'/m/j/mj10-red_alt1_1.jpg','image',0),(604,90,'/m/j/mj10-red_back_1.jpg','image',0),(605,90,'/m/j/mj10-black_main_1.jpg','image',0),(606,90,'/m/j/mj10-orange_main_1.jpg','image',0),(607,90,'/m/j/mj10-red_main_1.jpg','image',0),(608,90,'/m/j/mj10-red_alt1_1.jpg','image',0),(609,90,'/m/j/mj10-red_back_1.jpg','image',0),(610,90,'/m/j/mj10-red_main_1.jpg','image',0),(611,90,'/m/j/mj10-red_alt1_1.jpg','image',0),(612,90,'/m/j/mj10-red_back_1.jpg','image',0),(613,90,'/m/j/mj11-black_main_1.jpg','image',0),(614,90,'/m/j/mj11-black_alt1_1.jpg','image',0),(615,90,'/m/j/mj11-black_back_1.jpg','image',0),(616,90,'/m/j/mj11-green_main_1.jpg','image',0),(617,90,'/m/j/mj11-red_main_1.jpg','image',0),(618,90,'/m/j/mj11-black_main_1.jpg','image',0),(619,90,'/m/j/mj11-black_alt1_1.jpg','image',0),(620,90,'/m/j/mj11-black_back_1.jpg','image',0),(621,90,'/m/j/mj11-green_main_1.jpg','image',0),(622,90,'/m/j/mj11-red_main_1.jpg','image',0),(623,90,'/m/j/mj11-black_main_1.jpg','image',0),(624,90,'/m/j/mj11-black_alt1_1.jpg','image',0),(625,90,'/m/j/mj11-black_back_1.jpg','image',0),(626,90,'/m/j/mj11-green_main_1.jpg','image',0),(627,90,'/m/j/mj11-red_main_1.jpg','image',0),(628,90,'/m/j/mj11-black_main_1.jpg','image',0),(629,90,'/m/j/mj11-black_alt1_1.jpg','image',0),(630,90,'/m/j/mj11-black_back_1.jpg','image',0),(631,90,'/m/j/mj11-green_main_1.jpg','image',0),(632,90,'/m/j/mj11-red_main_1.jpg','image',0),(633,90,'/m/j/mj11-black_main_1.jpg','image',0),(634,90,'/m/j/mj11-black_alt1_1.jpg','image',0),(635,90,'/m/j/mj11-black_back_1.jpg','image',0),(636,90,'/m/j/mj11-green_main_1.jpg','image',0),(637,90,'/m/j/mj11-red_main_1.jpg','image',0),(638,90,'/m/j/mj11-black_main_1.jpg','image',0),(639,90,'/m/j/mj11-black_alt1_1.jpg','image',0),(640,90,'/m/j/mj11-black_back_1.jpg','image',0),(641,90,'/m/j/mj06-blue_main_1.jpg','image',0),(642,90,'/m/j/mj06-blue_alt1_1.jpg','image',0),(643,90,'/m/j/mj06-blue_back_1.jpg','image',0),(644,90,'/m/j/mj06-green_main_1.jpg','image',0),(645,90,'/m/j/mj06-purple_main_1.jpg','image',0),(646,90,'/m/j/mj06-blue_main_1.jpg','image',0),(647,90,'/m/j/mj06-blue_alt1_1.jpg','image',0),(648,90,'/m/j/mj06-blue_back_1.jpg','image',0),(649,90,'/m/j/mj06-green_main_1.jpg','image',0),(650,90,'/m/j/mj06-purple_main_1.jpg','image',0),(651,90,'/m/j/mj06-blue_main_1.jpg','image',0),(652,90,'/m/j/mj06-blue_alt1_1.jpg','image',0),(653,90,'/m/j/mj06-blue_back_1.jpg','image',0),(654,90,'/m/j/mj06-green_main_1.jpg','image',0),(655,90,'/m/j/mj06-purple_main_1.jpg','image',0),(656,90,'/m/j/mj06-blue_main_1.jpg','image',0),(657,90,'/m/j/mj06-blue_alt1_1.jpg','image',0),(658,90,'/m/j/mj06-blue_back_1.jpg','image',0),(659,90,'/m/j/mj06-green_main_1.jpg','image',0),(660,90,'/m/j/mj06-purple_main_1.jpg','image',0),(661,90,'/m/j/mj06-blue_main_1.jpg','image',0),(662,90,'/m/j/mj06-blue_alt1_1.jpg','image',0),(663,90,'/m/j/mj06-blue_back_1.jpg','image',0),(664,90,'/m/j/mj06-green_main_1.jpg','image',0),(665,90,'/m/j/mj06-purple_main_1.jpg','image',0),(666,90,'/m/j/mj06-blue_main_1.jpg','image',0),(667,90,'/m/j/mj06-blue_alt1_1.jpg','image',0),(668,90,'/m/j/mj06-blue_back_1.jpg','image',0),(669,90,'/m/j/mj03-black_main_1.jpg','image',0),(670,90,'/m/j/mj03-black_alt1_1.jpg','image',0),(671,90,'/m/j/mj03-black_back_1.jpg','image',0),(672,90,'/m/j/mj03-green_main_1.jpg','image',0),(673,90,'/m/j/mj03-red_main_1.jpg','image',0),(674,90,'/m/j/mj03-black_main_1.jpg','image',0),(675,90,'/m/j/mj03-black_alt1_1.jpg','image',0),(676,90,'/m/j/mj03-black_back_1.jpg','image',0),(677,90,'/m/j/mj03-green_main_1.jpg','image',0),(678,90,'/m/j/mj03-red_main_1.jpg','image',0),(679,90,'/m/j/mj03-black_main_1.jpg','image',0),(680,90,'/m/j/mj03-black_alt1_1.jpg','image',0),(681,90,'/m/j/mj03-black_back_1.jpg','image',0),(682,90,'/m/j/mj03-green_main_1.jpg','image',0),(683,90,'/m/j/mj03-red_main_1.jpg','image',0),(684,90,'/m/j/mj03-black_main_1.jpg','image',0),(685,90,'/m/j/mj03-black_alt1_1.jpg','image',0),(686,90,'/m/j/mj03-black_back_1.jpg','image',0),(687,90,'/m/j/mj03-green_main_1.jpg','image',0),(688,90,'/m/j/mj03-red_main_1.jpg','image',0),(689,90,'/m/j/mj03-black_main_1.jpg','image',0),(690,90,'/m/j/mj03-black_alt1_1.jpg','image',0),(691,90,'/m/j/mj03-black_back_1.jpg','image',0),(692,90,'/m/j/mj03-green_main_1.jpg','image',0),(693,90,'/m/j/mj03-red_main_1.jpg','image',0),(694,90,'/m/j/mj03-black_main_1.jpg','image',0),(695,90,'/m/j/mj03-black_alt1_1.jpg','image',0),(696,90,'/m/j/mj03-black_back_1.jpg','image',0),(697,90,'/m/j/mj12-black_main_1.jpg','image',0),(698,90,'/m/j/mj12-blue_main_1.jpg','image',0),(699,90,'/m/j/mj12-orange_main_1.jpg','image',0),(700,90,'/m/j/mj12-orange_alt1_1.jpg','image',0),(701,90,'/m/j/mj12-orange_back_1.jpg','image',0),(702,90,'/m/j/mj12-black_main_1.jpg','image',0),(703,90,'/m/j/mj12-blue_main_1.jpg','image',0),(704,90,'/m/j/mj12-orange_main_1.jpg','image',0),(705,90,'/m/j/mj12-orange_alt1_1.jpg','image',0),(706,90,'/m/j/mj12-orange_back_1.jpg','image',0),(707,90,'/m/j/mj12-black_main_1.jpg','image',0),(708,90,'/m/j/mj12-blue_main_1.jpg','image',0),(709,90,'/m/j/mj12-orange_main_1.jpg','image',0),(710,90,'/m/j/mj12-orange_alt1_1.jpg','image',0),(711,90,'/m/j/mj12-orange_back_1.jpg','image',0),(712,90,'/m/j/mj12-black_main_1.jpg','image',0),(713,90,'/m/j/mj12-blue_main_1.jpg','image',0),(714,90,'/m/j/mj12-orange_main_1.jpg','image',0),(715,90,'/m/j/mj12-orange_alt1_1.jpg','image',0),(716,90,'/m/j/mj12-orange_back_1.jpg','image',0),(717,90,'/m/j/mj12-black_main_1.jpg','image',0),(718,90,'/m/j/mj12-blue_main_1.jpg','image',0),(719,90,'/m/j/mj12-orange_main_1.jpg','image',0),(720,90,'/m/j/mj12-orange_alt1_1.jpg','image',0),(721,90,'/m/j/mj12-orange_back_1.jpg','image',0),(722,90,'/m/j/mj12-orange_main_1.jpg','image',0),(723,90,'/m/j/mj12-orange_alt1_1.jpg','image',0),(724,90,'/m/j/mj12-orange_back_1.jpg','image',0),(725,90,'/m/s/ms04-black_main_1.jpg','image',0),(726,90,'/m/s/ms04-orange_main_1.jpg','image',0),(727,90,'/m/s/ms04-orange_back_1.jpg','image',0),(728,90,'/m/s/ms04-red_main_1.jpg','image',0),(729,90,'/m/s/ms04-black_main_1.jpg','image',0),(730,90,'/m/s/ms04-orange_main_1.jpg','image',0),(731,90,'/m/s/ms04-orange_back_1.jpg','image',0),(732,90,'/m/s/ms04-red_main_1.jpg','image',0),(733,90,'/m/s/ms04-black_main_1.jpg','image',0),(734,90,'/m/s/ms04-orange_main_1.jpg','image',0),(735,90,'/m/s/ms04-orange_back_1.jpg','image',0),(736,90,'/m/s/ms04-red_main_1.jpg','image',0),(737,90,'/m/s/ms04-black_main_1.jpg','image',0),(738,90,'/m/s/ms04-orange_main_1.jpg','image',0),(739,90,'/m/s/ms04-orange_back_1.jpg','image',0),(740,90,'/m/s/ms04-red_main_1.jpg','image',0),(741,90,'/m/s/ms04-black_main_1.jpg','image',0),(742,90,'/m/s/ms04-orange_main_1.jpg','image',0),(743,90,'/m/s/ms04-orange_back_1.jpg','image',0),(744,90,'/m/s/ms04-red_main_1.jpg','image',0),(745,90,'/m/s/ms04-orange_main_1.jpg','image',0),(746,90,'/m/s/ms04-orange_back_1.jpg','image',0),(747,90,'/m/s/ms05-black_main_1.jpg','image',0),(748,90,'/m/s/ms05-blue_main_1.jpg','image',0),(749,90,'/m/s/ms05-blue_back_1.jpg','image',0),(750,90,'/m/s/ms05-purple_main_1.jpg','image',0),(751,90,'/m/s/ms05-black_main_1.jpg','image',0),(752,90,'/m/s/ms05-blue_main_1.jpg','image',0),(753,90,'/m/s/ms05-blue_back_1.jpg','image',0),(754,90,'/m/s/ms05-purple_main_1.jpg','image',0),(755,90,'/m/s/ms05-black_main_1.jpg','image',0),(756,90,'/m/s/ms05-blue_main_1.jpg','image',0),(757,90,'/m/s/ms05-blue_back_1.jpg','image',0),(758,90,'/m/s/ms05-purple_main_1.jpg','image',0),(759,90,'/m/s/ms05-black_main_1.jpg','image',0),(760,90,'/m/s/ms05-blue_main_1.jpg','image',0),(761,90,'/m/s/ms05-blue_back_1.jpg','image',0),(762,90,'/m/s/ms05-purple_main_1.jpg','image',0),(763,90,'/m/s/ms05-black_main_1.jpg','image',0),(764,90,'/m/s/ms05-blue_main_1.jpg','image',0),(765,90,'/m/s/ms05-blue_back_1.jpg','image',0),(766,90,'/m/s/ms05-purple_main_1.jpg','image',0),(767,90,'/m/s/ms05-blue_main_1.jpg','image',0),(768,90,'/m/s/ms05-blue_back_1.jpg','image',0),(769,90,'/m/s/ms09-black_main_1.jpg','image',0),(770,90,'/m/s/ms09-blue_main_1.jpg','image',0),(771,90,'/m/s/ms09-blue_alt1_1.jpg','image',0),(772,90,'/m/s/ms09-blue_back_1.jpg','image',0),(773,90,'/m/s/ms09-red_main_1.jpg','image',0),(774,90,'/m/s/ms09-black_main_1.jpg','image',0),(775,90,'/m/s/ms09-blue_main_1.jpg','image',0),(776,90,'/m/s/ms09-blue_alt1_1.jpg','image',0),(777,90,'/m/s/ms09-blue_back_1.jpg','image',0),(778,90,'/m/s/ms09-red_main_1.jpg','image',0),(779,90,'/m/s/ms09-black_main_1.jpg','image',0),(780,90,'/m/s/ms09-blue_main_1.jpg','image',0),(781,90,'/m/s/ms09-blue_alt1_1.jpg','image',0),(782,90,'/m/s/ms09-blue_back_1.jpg','image',0),(783,90,'/m/s/ms09-red_main_1.jpg','image',0),(784,90,'/m/s/ms09-black_main_1.jpg','image',0),(785,90,'/m/s/ms09-blue_main_1.jpg','image',0),(786,90,'/m/s/ms09-blue_alt1_1.jpg','image',0),(787,90,'/m/s/ms09-blue_back_1.jpg','image',0),(788,90,'/m/s/ms09-red_main_1.jpg','image',0),(789,90,'/m/s/ms09-black_main_1.jpg','image',0),(790,90,'/m/s/ms09-blue_main_1.jpg','image',0),(791,90,'/m/s/ms09-blue_alt1_1.jpg','image',0),(792,90,'/m/s/ms09-blue_back_1.jpg','image',0),(793,90,'/m/s/ms09-red_main_1.jpg','image',0),(794,90,'/m/s/ms09-blue_main_1.jpg','image',0),(795,90,'/m/s/ms09-blue_alt1_1.jpg','image',0),(796,90,'/m/s/ms09-blue_back_1.jpg','image',0),(797,90,'/m/s/ms11-blue_main_1.jpg','image',0),(798,90,'/m/s/ms11-green_main_1.jpg','image',0),(799,90,'/m/s/ms11-green_back_1.jpg','image',0),(800,90,'/m/s/ms11-yellow_main_1.jpg','image',0),(801,90,'/m/s/ms11-blue_main_1.jpg','image',0),(802,90,'/m/s/ms11-green_main_1.jpg','image',0),(803,90,'/m/s/ms11-green_back_1.jpg','image',0),(804,90,'/m/s/ms11-yellow_main_1.jpg','image',0),(805,90,'/m/s/ms11-blue_main_1.jpg','image',0),(806,90,'/m/s/ms11-green_main_1.jpg','image',0),(807,90,'/m/s/ms11-green_back_1.jpg','image',0),(808,90,'/m/s/ms11-yellow_main_1.jpg','image',0),(809,90,'/m/s/ms11-blue_main_1.jpg','image',0),(810,90,'/m/s/ms11-green_main_1.jpg','image',0),(811,90,'/m/s/ms11-green_back_1.jpg','image',0),(812,90,'/m/s/ms11-yellow_main_1.jpg','image',0),(813,90,'/m/s/ms11-blue_main_1.jpg','image',0),(814,90,'/m/s/ms11-green_main_1.jpg','image',0),(815,90,'/m/s/ms11-green_back_1.jpg','image',0),(816,90,'/m/s/ms11-yellow_main_1.jpg','image',0),(817,90,'/m/s/ms11-green_main_1.jpg','image',0),(818,90,'/m/s/ms11-green_back_1.jpg','image',0),(819,90,'/m/s/ms12-black_main_1.jpg','image',0),(820,90,'/m/s/ms12-blue_main_1.jpg','image',0),(821,90,'/m/s/ms12-red_main_1.jpg','image',0),(822,90,'/m/s/ms12-red_alt1_1.jpg','image',0),(823,90,'/m/s/ms12-red_back_1.jpg','image',0),(824,90,'/m/s/ms12-black_main_1.jpg','image',0),(825,90,'/m/s/ms12-blue_main_1.jpg','image',0),(826,90,'/m/s/ms12-red_main_1.jpg','image',0),(827,90,'/m/s/ms12-red_alt1_1.jpg','image',0),(828,90,'/m/s/ms12-red_back_1.jpg','image',0),(829,90,'/m/s/ms12-black_main_1.jpg','image',0),(830,90,'/m/s/ms12-blue_main_1.jpg','image',0),(831,90,'/m/s/ms12-red_main_1.jpg','image',0),(832,90,'/m/s/ms12-red_alt1_1.jpg','image',0),(833,90,'/m/s/ms12-red_back_1.jpg','image',0),(834,90,'/m/s/ms12-black_main_1.jpg','image',0),(835,90,'/m/s/ms12-blue_main_1.jpg','image',0),(836,90,'/m/s/ms12-red_main_1.jpg','image',0),(837,90,'/m/s/ms12-red_alt1_1.jpg','image',0),(838,90,'/m/s/ms12-red_back_1.jpg','image',0),(839,90,'/m/s/ms12-black_main_1.jpg','image',0),(840,90,'/m/s/ms12-blue_main_1.jpg','image',0),(841,90,'/m/s/ms12-red_main_1.jpg','image',0),(842,90,'/m/s/ms12-red_alt1_1.jpg','image',0),(843,90,'/m/s/ms12-red_back_1.jpg','image',0),(844,90,'/m/s/ms12-red_main_1.jpg','image',0),(845,90,'/m/s/ms12-red_alt1_1.jpg','image',0),(846,90,'/m/s/ms12-red_back_1.jpg','image',0),(847,90,'/m/s/ms03-gray_main_1.jpg','image',0),(848,90,'/m/s/ms03-gray_alt1_1.jpg','image',0),(849,90,'/m/s/ms03-gray_back_1.jpg','image',0),(850,90,'/m/s/ms03-green_main_1.jpg','image',0),(851,90,'/m/s/ms03-orange_main_1.jpg','image',0),(852,90,'/m/s/ms03-gray_main_1.jpg','image',0),(853,90,'/m/s/ms03-gray_alt1_1.jpg','image',0),(854,90,'/m/s/ms03-gray_back_1.jpg','image',0),(855,90,'/m/s/ms03-green_main_1.jpg','image',0),(856,90,'/m/s/ms03-orange_main_1.jpg','image',0),(857,90,'/m/s/ms03-gray_main_1.jpg','image',0),(858,90,'/m/s/ms03-gray_alt1_1.jpg','image',0),(859,90,'/m/s/ms03-gray_back_1.jpg','image',0),(860,90,'/m/s/ms03-green_main_1.jpg','image',0),(861,90,'/m/s/ms03-orange_main_1.jpg','image',0),(862,90,'/m/s/ms03-gray_main_1.jpg','image',0),(863,90,'/m/s/ms03-gray_alt1_1.jpg','image',0),(864,90,'/m/s/ms03-gray_back_1.jpg','image',0),(865,90,'/m/s/ms03-green_main_1.jpg','image',0),(866,90,'/m/s/ms03-orange_main_1.jpg','image',0),(867,90,'/m/s/ms03-gray_main_1.jpg','image',0),(868,90,'/m/s/ms03-gray_alt1_1.jpg','image',0),(869,90,'/m/s/ms03-gray_back_1.jpg','image',0),(870,90,'/m/s/ms03-green_main_1.jpg','image',0),(871,90,'/m/s/ms03-orange_main_1.jpg','image',0),(872,90,'/m/s/ms03-black_main_1.jpg','image',0),(873,90,'/m/s/ms03-black_back_1.jpg','image',0),(874,90,'/m/s/ms06-blue_main_1.jpg','image',0),(875,90,'/m/s/ms06-blue_alt1_1.jpg','image',0),(876,90,'/m/s/ms06-blue_back_1.jpg','image',0),(877,90,'/m/s/ms06-green_main_1.jpg','image',0),(878,90,'/m/s/ms06-yellow_main_1.jpg','image',0),(879,90,'/m/s/ms06-blue_main_1.jpg','image',0),(880,90,'/m/s/ms06-blue_alt1_1.jpg','image',0),(881,90,'/m/s/ms06-blue_back_1.jpg','image',0),(882,90,'/m/s/ms06-green_main_1.jpg','image',0),(883,90,'/m/s/ms06-yellow_main_1.jpg','image',0),(884,90,'/m/s/ms06-blue_main_1.jpg','image',0),(885,90,'/m/s/ms06-blue_alt1_1.jpg','image',0),(886,90,'/m/s/ms06-blue_back_1.jpg','image',0),(887,90,'/m/s/ms06-green_main_1.jpg','image',0),(888,90,'/m/s/ms06-yellow_main_1.jpg','image',0),(889,90,'/m/s/ms06-blue_main_1.jpg','image',0),(890,90,'/m/s/ms06-blue_alt1_1.jpg','image',0),(891,90,'/m/s/ms06-blue_back_1.jpg','image',0),(892,90,'/m/s/ms06-green_main_1.jpg','image',0),(893,90,'/m/s/ms06-yellow_main_1.jpg','image',0),(894,90,'/m/s/ms06-blue_main_1.jpg','image',0),(895,90,'/m/s/ms06-blue_alt1_1.jpg','image',0),(896,90,'/m/s/ms06-blue_back_1.jpg','image',0),(897,90,'/m/s/ms06-green_main_1.jpg','image',0),(898,90,'/m/s/ms06-yellow_main_1.jpg','image',0),(899,90,'/m/s/ms06-blue_main_1.jpg','image',0),(900,90,'/m/s/ms06-blue_alt1_1.jpg','image',0),(901,90,'/m/s/ms06-blue_back_1.jpg','image',0),(902,90,'/m/s/ms01-black_main_1.jpg','image',0),(903,90,'/m/s/ms01-brown_main_1.jpg','image',0),(904,90,'/m/s/ms01-brown_back_1.jpg','image',0),(905,90,'/m/s/ms01-yellow_main_1.jpg','image',0),(906,90,'/m/s/ms01-black_main_1.jpg','image',0),(907,90,'/m/s/ms01-brown_main_2.jpg','image',0),(908,90,'/m/s/ms01-brown_back_2.jpg','image',0),(909,90,'/m/s/ms01-yellow_main_2.jpg','image',0),(910,90,'/m/s/ms01-black_main_2.jpg','image',0),(911,90,'/m/s/ms01-brown_main_2.jpg','image',0),(912,90,'/m/s/ms01-brown_back_2.jpg','image',0),(913,90,'/m/s/ms01-yellow_main_2.jpg','image',0),(914,90,'/m/s/ms01-black_main_2.jpg','image',0),(915,90,'/m/s/ms01-brown_main_2.jpg','image',0),(916,90,'/m/s/ms01-brown_back_2.jpg','image',0),(917,90,'/m/s/ms01-yellow_main_2.jpg','image',0),(918,90,'/m/s/ms01-black_main_2.jpg','image',0),(919,90,'/m/s/ms01-brown_main_2.jpg','image',0),(920,90,'/m/s/ms01-brown_back_2.jpg','image',0),(921,90,'/m/s/ms01-yellow_main_2.jpg','image',0),(922,90,'/m/s/ms01-blue_main_1.jpg','image',0),(923,90,'/m/s/ms01-blue_back_1.jpg','image',0),(924,90,'/m/s/ms02-black_main_1.jpg','image',0),(925,90,'/m/s/ms02-blue_main_1.jpg','image',0),(926,90,'/m/s/ms02-gray_main_1.jpg','image',0),(927,90,'/m/s/ms02-gray_alt1_1.jpg','image',0),(928,90,'/m/s/ms02-gray_back_1.jpg','image',0),(929,90,'/m/s/ms02-black_main_1.jpg','image',0),(930,90,'/m/s/ms02-blue_main_1.jpg','image',0),(931,90,'/m/s/ms02-gray_main_1.jpg','image',0),(932,90,'/m/s/ms02-gray_alt1_1.jpg','image',0),(933,90,'/m/s/ms02-gray_back_1.jpg','image',0),(934,90,'/m/s/ms02-black_main_1.jpg','image',0),(935,90,'/m/s/ms02-blue_main_1.jpg','image',0),(936,90,'/m/s/ms02-gray_main_1.jpg','image',0),(937,90,'/m/s/ms02-gray_alt1_1.jpg','image',0),(938,90,'/m/s/ms02-gray_back_1.jpg','image',0),(939,90,'/m/s/ms02-black_main_1.jpg','image',0),(940,90,'/m/s/ms02-blue_main_1.jpg','image',0),(941,90,'/m/s/ms02-gray_main_1.jpg','image',0),(942,90,'/m/s/ms02-gray_alt1_1.jpg','image',0),(943,90,'/m/s/ms02-gray_back_1.jpg','image',0),(944,90,'/m/s/ms02-black_main_1.jpg','image',0),(945,90,'/m/s/ms02-blue_main_1.jpg','image',0),(946,90,'/m/s/ms02-gray_main_1.jpg','image',0),(947,90,'/m/s/ms02-gray_alt1_1.jpg','image',0),(948,90,'/m/s/ms02-gray_back_1.jpg','image',0),(949,90,'/m/s/ms02-gray_main_1.jpg','image',0),(950,90,'/m/s/ms02-gray_alt1_1.jpg','image',0),(951,90,'/m/s/ms02-gray_back_1.jpg','image',0),(952,90,'/m/s/ms10-black_main_1.jpg','image',0),(953,90,'/m/s/ms10-blue_main_1.jpg','image',0),(954,90,'/m/s/ms10-blue_alt1_1.jpg','image',0),(955,90,'/m/s/ms10-blue_back_1.jpg','image',0),(956,90,'/m/s/ms10-red_main_1.jpg','image',0),(957,90,'/m/s/ms10-black_main_1.jpg','image',0),(958,90,'/m/s/ms10-blue_main_1.jpg','image',0),(959,90,'/m/s/ms10-blue_alt1_1.jpg','image',0),(960,90,'/m/s/ms10-blue_back_1.jpg','image',0),(961,90,'/m/s/ms10-red_main_1.jpg','image',0),(962,90,'/m/s/ms10-black_main_1.jpg','image',0),(963,90,'/m/s/ms10-blue_main_1.jpg','image',0),(964,90,'/m/s/ms10-blue_alt1_1.jpg','image',0),(965,90,'/m/s/ms10-blue_back_1.jpg','image',0),(966,90,'/m/s/ms10-red_main_1.jpg','image',0),(967,90,'/m/s/ms10-black_main_1.jpg','image',0),(968,90,'/m/s/ms10-blue_main_1.jpg','image',0),(969,90,'/m/s/ms10-blue_alt1_1.jpg','image',0),(970,90,'/m/s/ms10-blue_back_1.jpg','image',0),(971,90,'/m/s/ms10-red_main_1.jpg','image',0),(972,90,'/m/s/ms10-black_main_1.jpg','image',0),(973,90,'/m/s/ms10-blue_main_1.jpg','image',0),(974,90,'/m/s/ms10-blue_alt1_1.jpg','image',0),(975,90,'/m/s/ms10-blue_back_1.jpg','image',0),(976,90,'/m/s/ms10-red_main_1.jpg','image',0),(977,90,'/m/s/ms10-blue_main_1.jpg','image',0),(978,90,'/m/s/ms10-blue_alt1_1.jpg','image',0),(979,90,'/m/s/ms10-blue_back_1.jpg','image',0),(980,90,'/m/s/ms07-black_main_1.jpg','image',0),(981,90,'/m/s/ms07-green_main_1.jpg','image',0),(982,90,'/m/s/ms07-green_alt1_1.jpg','image',0),(983,90,'/m/s/ms07-green_back_1.jpg','image',0),(984,90,'/m/s/ms07-white_main_1.jpg','image',0),(985,90,'/m/s/ms07-black_main_1.jpg','image',0),(986,90,'/m/s/ms07-green_main_1.jpg','image',0),(987,90,'/m/s/ms07-green_alt1_1.jpg','image',0),(988,90,'/m/s/ms07-green_back_1.jpg','image',0),(989,90,'/m/s/ms07-white_main_1.jpg','image',0),(990,90,'/m/s/ms07-black_main_1.jpg','image',0),(991,90,'/m/s/ms07-green_main_1.jpg','image',0),(992,90,'/m/s/ms07-green_alt1_1.jpg','image',0),(993,90,'/m/s/ms07-green_back_1.jpg','image',0),(994,90,'/m/s/ms07-white_main_1.jpg','image',0),(995,90,'/m/s/ms07-black_main_1.jpg','image',0),(996,90,'/m/s/ms07-green_main_1.jpg','image',0),(997,90,'/m/s/ms07-green_alt1_1.jpg','image',0),(998,90,'/m/s/ms07-green_back_1.jpg','image',0),(999,90,'/m/s/ms07-white_main_1.jpg','image',0),(1000,90,'/m/s/ms07-black_main_1.jpg','image',0),(1001,90,'/m/s/ms07-green_main_1.jpg','image',0),(1002,90,'/m/s/ms07-green_alt1_1.jpg','image',0),(1003,90,'/m/s/ms07-green_back_1.jpg','image',0),(1004,90,'/m/s/ms07-white_main_1.jpg','image',0),(1005,90,'/m/s/ms07-green_main_1.jpg','image',0),(1006,90,'/m/s/ms07-green_alt1_1.jpg','image',0),(1007,90,'/m/s/ms07-green_back_1.jpg','image',0),(1008,90,'/m/s/ms08-black_main_1.jpg','image',0),(1009,90,'/m/s/ms08-black_back_1.jpg','image',0),(1010,90,'/m/s/ms08-blue_main_1.jpg','image',0),(1011,90,'/m/s/ms08-red_main_1.jpg','image',0),(1012,90,'/m/s/ms08-black_main_1.jpg','image',0),(1013,90,'/m/s/ms08-black_back_1.jpg','image',0),(1014,90,'/m/s/ms08-blue_main_1.jpg','image',0),(1015,90,'/m/s/ms08-red_main_1.jpg','image',0),(1016,90,'/m/s/ms08-black_main_1.jpg','image',0),(1017,90,'/m/s/ms08-black_back_1.jpg','image',0),(1018,90,'/m/s/ms08-blue_main_1.jpg','image',0),(1019,90,'/m/s/ms08-red_main_1.jpg','image',0),(1020,90,'/m/s/ms08-black_main_1.jpg','image',0),(1021,90,'/m/s/ms08-black_back_1.jpg','image',0),(1022,90,'/m/s/ms08-blue_main_1.jpg','image',0),(1023,90,'/m/s/ms08-red_main_1.jpg','image',0),(1024,90,'/m/s/ms08-black_main_1.jpg','image',0),(1025,90,'/m/s/ms08-black_back_1.jpg','image',0),(1026,90,'/m/s/ms08-blue_main_1.jpg','image',0),(1027,90,'/m/s/ms08-red_main_1.jpg','image',0),(1028,90,'/m/s/ms08-black_main_1.jpg','image',0),(1029,90,'/m/s/ms08-black_back_1.jpg','image',0),(1030,90,'/m/t/mt01-gray_main_1.jpg','image',0),(1031,90,'/m/t/mt01-orange_main_1.jpg','image',0),(1032,90,'/m/t/mt01-red_main_1.jpg','image',0),(1033,90,'/m/t/mt01-red_alt1_1.jpg','image',0),(1034,90,'/m/t/mt01-red_back_1.jpg','image',0),(1035,90,'/m/t/mt01-gray_main_1.jpg','image',0),(1036,90,'/m/t/mt01-orange_main_1.jpg','image',0),(1037,90,'/m/t/mt01-red_main_1.jpg','image',0),(1038,90,'/m/t/mt01-red_alt1_1.jpg','image',0),(1039,90,'/m/t/mt01-red_back_1.jpg','image',0),(1040,90,'/m/t/mt01-gray_main_1.jpg','image',0),(1041,90,'/m/t/mt01-orange_main_1.jpg','image',0),(1042,90,'/m/t/mt01-red_main_1.jpg','image',0),(1043,90,'/m/t/mt01-red_alt1_1.jpg','image',0),(1044,90,'/m/t/mt01-red_back_1.jpg','image',0),(1045,90,'/m/t/mt01-gray_main_1.jpg','image',0),(1046,90,'/m/t/mt01-orange_main_1.jpg','image',0),(1047,90,'/m/t/mt01-red_main_1.jpg','image',0),(1048,90,'/m/t/mt01-red_alt1_1.jpg','image',0),(1049,90,'/m/t/mt01-red_back_1.jpg','image',0),(1050,90,'/m/t/mt01-gray_main_1.jpg','image',0),(1051,90,'/m/t/mt01-orange_main_1.jpg','image',0),(1052,90,'/m/t/mt01-red_main_1.jpg','image',0),(1053,90,'/m/t/mt01-red_alt1_1.jpg','image',0),(1054,90,'/m/t/mt01-red_back_1.jpg','image',0),(1055,90,'/m/t/mt01-red_main_1.jpg','image',0),(1056,90,'/m/t/mt01-red_alt1_1.jpg','image',0),(1057,90,'/m/t/mt01-red_back_1.jpg','image',0),(1058,90,'/m/t/mt02-gray_main_1.jpg','image',0),(1059,90,'/m/t/mt02-red_main_1.jpg','image',0),(1060,90,'/m/t/mt02-white_main_1.jpg','image',0),(1061,90,'/m/t/mt02-white_alt1_1.jpg','image',0),(1062,90,'/m/t/mt02-white_back_1.jpg','image',0),(1063,90,'/m/t/mt02-white_sideb_1.jpg','image',0),(1064,90,'/m/t/mt02-gray_main_1.jpg','image',0),(1065,90,'/m/t/mt02-red_main_1.jpg','image',0),(1066,90,'/m/t/mt02-white_main_1.jpg','image',0),(1067,90,'/m/t/mt02-white_alt1_1.jpg','image',0),(1068,90,'/m/t/mt02-white_back_1.jpg','image',0),(1069,90,'/m/t/mt02-white_sideb_1.jpg','image',0),(1070,90,'/m/t/mt02-gray_main_1.jpg','image',0),(1071,90,'/m/t/mt02-red_main_1.jpg','image',0),(1072,90,'/m/t/mt02-white_main_2.jpg','image',0),(1073,90,'/m/t/mt02-white_alt1_2.jpg','image',0),(1074,90,'/m/t/mt02-white_back_2.jpg','image',0),(1075,90,'/m/t/mt02-white_sideb_2.jpg','image',0),(1076,90,'/m/t/mt02-gray_main_2.jpg','image',0),(1077,90,'/m/t/mt02-red_main_2.jpg','image',0),(1078,90,'/m/t/mt02-white_main_2.jpg','image',0),(1079,90,'/m/t/mt02-white_alt1_2.jpg','image',0),(1080,90,'/m/t/mt02-white_back_2.jpg','image',0),(1081,90,'/m/t/mt02-white_sideb_2.jpg','image',0),(1082,90,'/m/t/mt02-gray_main_2.jpg','image',0),(1083,90,'/m/t/mt02-red_main_2.jpg','image',0),(1084,90,'/m/t/mt02-white_main_2.jpg','image',0),(1085,90,'/m/t/mt02-white_alt1_2.jpg','image',0),(1086,90,'/m/t/mt02-white_back_2.jpg','image',0),(1087,90,'/m/t/mt02-white_sideb_2.jpg','image',0),(1088,90,'/m/t/mt02-white_main_2.jpg','image',0),(1089,90,'/m/t/mt02-white_alt1_2.jpg','image',0),(1090,90,'/m/t/mt02-white_back_2.jpg','image',0),(1091,90,'/m/t/mt02-white_sideb_2.jpg','image',0),(1092,90,'/m/t/mt03-blue_main_1.jpg','image',0),(1093,90,'/m/t/mt03-red_main_1.jpg','image',0),(1094,90,'/m/t/mt03-yellow_main_1.jpg','image',0),(1095,90,'/m/t/mt03-blue_main_1.jpg','image',0),(1096,90,'/m/t/mt03-red_main_1.jpg','image',0),(1097,90,'/m/t/mt03-yellow_main_1.jpg','image',0),(1098,90,'/m/t/mt03-blue_main_1.jpg','image',0),(1099,90,'/m/t/mt03-red_main_1.jpg','image',0),(1100,90,'/m/t/mt03-yellow_main_1.jpg','image',0),(1101,90,'/m/t/mt03-blue_main_1.jpg','image',0),(1102,90,'/m/t/mt03-red_main_1.jpg','image',0),(1103,90,'/m/t/mt03-yellow_main_1.jpg','image',0),(1104,90,'/m/t/mt03-blue_main_1.jpg','image',0),(1105,90,'/m/t/mt03-red_main_1.jpg','image',0),(1106,90,'/m/t/mt03-yellow_main_1.jpg','image',0),(1107,90,'/m/t/mt03-red_main_1.jpg','image',0),(1108,90,'/m/t/mt04-blue_main_1.jpg','image',0),(1109,90,'/m/t/mt04-blue_alt1_1.jpg','image',0),(1110,90,'/m/t/mt04-blue_back_1.jpg','image',0),(1111,90,'/m/t/mt04-blue_main_1.jpg','image',0),(1112,90,'/m/t/mt04-blue_alt1_1.jpg','image',0),(1113,90,'/m/t/mt04-blue_back_1.jpg','image',0),(1114,90,'/m/t/mt04-blue_main_1.jpg','image',0),(1115,90,'/m/t/mt04-blue_alt1_1.jpg','image',0),(1116,90,'/m/t/mt04-blue_back_1.jpg','image',0),(1117,90,'/m/t/mt04-blue_main_1.jpg','image',0),(1118,90,'/m/t/mt04-blue_alt1_1.jpg','image',0),(1119,90,'/m/t/mt04-blue_back_1.jpg','image',0),(1120,90,'/m/t/mt04-blue_main_1.jpg','image',0),(1121,90,'/m/t/mt04-blue_alt1_1.jpg','image',0),(1122,90,'/m/t/mt04-blue_back_1.jpg','image',0),(1123,90,'/m/t/mt04-blue_main_1.jpg','image',0),(1124,90,'/m/t/mt04-blue_alt1_1.jpg','image',0),(1125,90,'/m/t/mt04-blue_back_1.jpg','image',0),(1126,90,'/m/t/mt05-blue_main_1.jpg','image',0),(1127,90,'/m/t/mt05-blue_back_1.jpg','image',0),(1128,90,'/m/t/mt05-blue_main_1.jpg','image',0),(1129,90,'/m/t/mt05-blue_back_1.jpg','image',0),(1130,90,'/m/t/mt05-blue_main_1.jpg','image',0),(1131,90,'/m/t/mt05-blue_back_1.jpg','image',0),(1132,90,'/m/t/mt05-blue_main_1.jpg','image',0),(1133,90,'/m/t/mt05-blue_back_1.jpg','image',0),(1134,90,'/m/t/mt05-blue_main_1.jpg','image',0),(1135,90,'/m/t/mt05-blue_back_1.jpg','image',0),(1136,90,'/m/t/mt05-blue_main_1.jpg','image',0),(1137,90,'/m/t/mt05-blue_back_1.jpg','image',0),(1138,90,'/m/t/mt06-black_main_1.jpg','image',0),(1139,90,'/m/t/mt06-black_back_1.jpg','image',0),(1140,90,'/m/t/mt06-black_main_1.jpg','image',0),(1141,90,'/m/t/mt06-black_back_1.jpg','image',0),(1142,90,'/m/t/mt06-black_main_1.jpg','image',0),(1143,90,'/m/t/mt06-black_back_1.jpg','image',0),(1144,90,'/m/t/mt06-black_main_1.jpg','image',0),(1145,90,'/m/t/mt06-black_back_1.jpg','image',0),(1146,90,'/m/t/mt06-black_main_1.jpg','image',0),(1147,90,'/m/t/mt06-black_back_1.jpg','image',0),(1148,90,'/m/t/mt06-black_main_1.jpg','image',0),(1149,90,'/m/t/mt06-black_back_1.jpg','image',0),(1150,90,'/m/t/mt07-gray_main_1.jpg','image',0),(1151,90,'/m/t/mt07-gray_back_1.jpg','image',0),(1152,90,'/m/t/mt07-gray_main_1.jpg','image',0),(1153,90,'/m/t/mt07-gray_back_1.jpg','image',0),(1154,90,'/m/t/mt07-gray_main_1.jpg','image',0),(1155,90,'/m/t/mt07-gray_back_1.jpg','image',0),(1156,90,'/m/t/mt07-gray_main_1.jpg','image',0),(1157,90,'/m/t/mt07-gray_back_1.jpg','image',0),(1158,90,'/m/t/mt07-gray_main_1.jpg','image',0),(1159,90,'/m/t/mt07-gray_back_1.jpg','image',0),(1160,90,'/m/t/mt07-gray_main_1.jpg','image',0),(1161,90,'/m/t/mt07-gray_back_1.jpg','image',0),(1162,90,'/m/t/mt08-green_main_1.jpg','image',0),(1163,90,'/m/t/mt08-green_alt1_1.jpg','image',0),(1164,90,'/m/t/mt08-green_back_1.jpg','image',0),(1165,90,'/m/t/mt08-green_main_1.jpg','image',0),(1166,90,'/m/t/mt08-green_alt1_1.jpg','image',0),(1167,90,'/m/t/mt08-green_back_1.jpg','image',0),(1168,90,'/m/t/mt08-green_main_1.jpg','image',0),(1169,90,'/m/t/mt08-green_alt1_1.jpg','image',0),(1170,90,'/m/t/mt08-green_back_1.jpg','image',0),(1171,90,'/m/t/mt08-green_main_1.jpg','image',0),(1172,90,'/m/t/mt08-green_alt1_1.jpg','image',0),(1173,90,'/m/t/mt08-green_back_1.jpg','image',0),(1174,90,'/m/t/mt08-green_main_1.jpg','image',0),(1175,90,'/m/t/mt08-green_alt1_1.jpg','image',0),(1176,90,'/m/t/mt08-green_back_1.jpg','image',0),(1177,90,'/m/t/mt08-green_main_1.jpg','image',0),(1178,90,'/m/t/mt08-green_alt1_1.jpg','image',0),(1179,90,'/m/t/mt08-green_back_1.jpg','image',0),(1180,90,'/m/t/mt09-blue_main_1.jpg','image',0),(1181,90,'/m/t/mt09-blue_alt1_1.jpg','image',0),(1182,90,'/m/t/mt09-blue_back_1.jpg','image',0),(1183,90,'/m/t/mt09-blue_main_1.jpg','image',0),(1184,90,'/m/t/mt09-blue_alt1_1.jpg','image',0),(1185,90,'/m/t/mt09-blue_back_1.jpg','image',0),(1186,90,'/m/t/mt09-blue_main_1.jpg','image',0),(1187,90,'/m/t/mt09-blue_alt1_1.jpg','image',0),(1188,90,'/m/t/mt09-blue_back_1.jpg','image',0),(1189,90,'/m/t/mt09-blue_main_1.jpg','image',0),(1190,90,'/m/t/mt09-blue_alt1_1.jpg','image',0),(1191,90,'/m/t/mt09-blue_back_1.jpg','image',0),(1192,90,'/m/t/mt09-blue_main_1.jpg','image',0),(1193,90,'/m/t/mt09-blue_alt1_1.jpg','image',0),(1194,90,'/m/t/mt09-blue_back_1.jpg','image',0),(1195,90,'/m/t/mt09-blue_main_1.jpg','image',0),(1196,90,'/m/t/mt09-blue_alt1_1.jpg','image',0),(1197,90,'/m/t/mt09-blue_back_1.jpg','image',0),(1198,90,'/m/t/mt10-yellow_main_1.jpg','image',0),(1199,90,'/m/t/mt10-yellow_back_1.jpg','image',0),(1200,90,'/m/t/mt10-yellow_main_1.jpg','image',0),(1201,90,'/m/t/mt10-yellow_back_1.jpg','image',0),(1202,90,'/m/t/mt10-yellow_main_1.jpg','image',0),(1203,90,'/m/t/mt10-yellow_back_1.jpg','image',0),(1204,90,'/m/t/mt10-yellow_main_1.jpg','image',0),(1205,90,'/m/t/mt10-yellow_back_1.jpg','image',0),(1206,90,'/m/t/mt10-yellow_main_1.jpg','image',0),(1207,90,'/m/t/mt10-yellow_back_1.jpg','image',0),(1208,90,'/m/t/mt10-yellow_main_1.jpg','image',0),(1209,90,'/m/t/mt10-yellow_back_1.jpg','image',0),(1210,90,'/m/t/mt11-blue_main_1.jpg','image',0),(1211,90,'/m/t/mt11-blue_back_1.jpg','image',0),(1212,90,'/m/t/mt11-blue_main_1.jpg','image',0),(1213,90,'/m/t/mt11-blue_back_1.jpg','image',0),(1214,90,'/m/t/mt11-blue_main_1.jpg','image',0),(1215,90,'/m/t/mt11-blue_back_1.jpg','image',0),(1216,90,'/m/t/mt11-blue_main_1.jpg','image',0),(1217,90,'/m/t/mt11-blue_back_1.jpg','image',0),(1218,90,'/m/t/mt11-blue_main_1.jpg','image',0),(1219,90,'/m/t/mt11-blue_back_1.jpg','image',0),(1220,90,'/m/t/mt11-blue_main_1.jpg','image',0),(1221,90,'/m/t/mt11-blue_back_1.jpg','image',0),(1222,90,'/m/t/mt12-blue_main_1.jpg','image',0),(1223,90,'/m/t/mt12-blue_back_1.jpg','image',0),(1224,90,'/m/t/mt12-blue_main_1.jpg','image',0),(1225,90,'/m/t/mt12-blue_back_1.jpg','image',0),(1226,90,'/m/t/mt12-blue_main_1.jpg','image',0),(1227,90,'/m/t/mt12-blue_back_1.jpg','image',0),(1228,90,'/m/t/mt12-blue_main_1.jpg','image',0),(1229,90,'/m/t/mt12-blue_back_1.jpg','image',0),(1230,90,'/m/t/mt12-blue_main_1.jpg','image',0),(1231,90,'/m/t/mt12-blue_back_1.jpg','image',0),(1232,90,'/m/t/mt12-blue_main_1.jpg','image',0),(1233,90,'/m/t/mt12-blue_back_1.jpg','image',0),(1234,90,'/m/p/mp01-black_main_1.jpg','image',0),(1235,90,'/m/p/mp01-gray_main_1.jpg','image',0),(1236,90,'/m/p/mp01-gray_back_1.jpg','image',0),(1237,90,'/m/p/mp01-purple_main_1.jpg','image',0),(1238,90,'/m/p/mp01-black_main_1.jpg','image',0),(1239,90,'/m/p/mp01-gray_main_1.jpg','image',0),(1240,90,'/m/p/mp01-gray_back_1.jpg','image',0),(1241,90,'/m/p/mp01-purple_main_1.jpg','image',0),(1242,90,'/m/p/mp01-black_main_1.jpg','image',0),(1243,90,'/m/p/mp01-gray_main_1.jpg','image',0),(1244,90,'/m/p/mp01-gray_back_1.jpg','image',0),(1245,90,'/m/p/mp01-purple_main_1.jpg','image',0),(1246,90,'/m/p/mp01-black_main_1.jpg','image',0),(1247,90,'/m/p/mp01-gray_main_1.jpg','image',0),(1248,90,'/m/p/mp01-gray_back_1.jpg','image',0),(1249,90,'/m/p/mp01-purple_main_1.jpg','image',0),(1250,90,'/m/p/mp01-gray_main_1.jpg','image',0),(1251,90,'/m/p/mp01-gray_back_1.jpg','image',0),(1252,90,'/m/p/mp02-blue_main_1.jpg','image',0),(1253,90,'/m/p/mp02-gray_main_1.jpg','image',0),(1254,90,'/m/p/mp02-gray_back_1.jpg','image',0),(1255,90,'/m/p/mp02-red_main_1.jpg','image',0),(1256,90,'/m/p/mp02-blue_main_1.jpg','image',0),(1257,90,'/m/p/mp02-gray_main_1.jpg','image',0),(1258,90,'/m/p/mp02-gray_back_1.jpg','image',0),(1259,90,'/m/p/mp02-red_main_1.jpg','image',0),(1260,90,'/m/p/mp02-blue_main_1.jpg','image',0),(1261,90,'/m/p/mp02-gray_main_1.jpg','image',0),(1262,90,'/m/p/mp02-gray_back_1.jpg','image',0),(1263,90,'/m/p/mp02-red_main_1.jpg','image',0),(1264,90,'/m/p/mp02-blue_main_2.jpg','image',0),(1265,90,'/m/p/mp02-gray_main_2.jpg','image',0),(1266,90,'/m/p/mp02-gray_back_2.jpg','image',0),(1267,90,'/m/p/mp02-red_main_2.jpg','image',0),(1268,90,'/m/p/mp02-gray_main_2.jpg','image',0),(1269,90,'/m/p/mp02-gray_back_2.jpg','image',0),(1270,90,'/m/p/mp03-blue_main_1.jpg','image',0),(1271,90,'/m/p/mp03-green_main_1.jpg','image',0),(1272,90,'/m/p/mp03-red_main_1.jpg','image',0),(1273,90,'/m/p/mp03-blue_main_1.jpg','image',0),(1274,90,'/m/p/mp03-green_main_1.jpg','image',0),(1275,90,'/m/p/mp03-red_main_1.jpg','image',0),(1276,90,'/m/p/mp03-blue_main_1.jpg','image',0),(1277,90,'/m/p/mp03-green_main_1.jpg','image',0),(1278,90,'/m/p/mp03-red_main_1.jpg','image',0),(1279,90,'/m/p/mp03-blue_main_1.jpg','image',0),(1280,90,'/m/p/mp03-green_main_1.jpg','image',0),(1281,90,'/m/p/mp03-red_main_1.jpg','image',0),(1282,90,'/m/p/mp03-black_main_1.jpg','image',0),(1283,90,'/m/p/mp03-black_alt1_1.jpg','image',0),(1284,90,'/m/p/mp03-black_back_1.jpg','image',0),(1285,90,'/m/p/mp04-black_main_1.jpg','image',0),(1286,90,'/m/p/mp04-gray_main_1.jpg','image',0),(1287,90,'/m/p/mp04-gray_back_1.jpg','image',0),(1288,90,'/m/p/mp04-green_main_1.jpg','image',0),(1289,90,'/m/p/mp04-black_main_1.jpg','image',0),(1290,90,'/m/p/mp04-gray_main_1.jpg','image',0),(1291,90,'/m/p/mp04-gray_back_1.jpg','image',0),(1292,90,'/m/p/mp04-green_main_1.jpg','image',0),(1293,90,'/m/p/mp04-black_main_1.jpg','image',0),(1294,90,'/m/p/mp04-gray_main_1.jpg','image',0),(1295,90,'/m/p/mp04-gray_back_1.jpg','image',0),(1296,90,'/m/p/mp04-green_main_1.jpg','image',0),(1297,90,'/m/p/mp04-black_main_1.jpg','image',0),(1298,90,'/m/p/mp04-gray_main_1.jpg','image',0),(1299,90,'/m/p/mp04-gray_back_1.jpg','image',0),(1300,90,'/m/p/mp04-green_main_1.jpg','image',0),(1301,90,'/m/p/mp04-gray_main_1.jpg','image',0),(1302,90,'/m/p/mp04-gray_back_1.jpg','image',0),(1303,90,'/m/p/mp05-black_main_1.jpg','image',0),(1304,90,'/m/p/mp05-blue_main_1.jpg','image',0),(1305,90,'/m/p/mp05-blue_back_1.jpg','image',0),(1306,90,'/m/p/mp05-blue_outfit_1.jpg','image',0),(1307,90,'/m/p/mp05-green_main_1.jpg','image',0),(1308,90,'/m/p/mp05-black_main_1.jpg','image',0),(1309,90,'/m/p/mp05-blue_main_1.jpg','image',0),(1310,90,'/m/p/mp05-blue_back_1.jpg','image',0),(1311,90,'/m/p/mp05-blue_outfit_1.jpg','image',0),(1312,90,'/m/p/mp05-green_main_1.jpg','image',0),(1313,90,'/m/p/mp05-black_main_1.jpg','image',0),(1314,90,'/m/p/mp05-blue_main_1.jpg','image',0),(1315,90,'/m/p/mp05-blue_back_1.jpg','image',0),(1316,90,'/m/p/mp05-blue_outfit_1.jpg','image',0),(1317,90,'/m/p/mp05-green_main_1.jpg','image',0),(1318,90,'/m/p/mp05-black_main_1.jpg','image',0),(1319,90,'/m/p/mp05-blue_main_1.jpg','image',0),(1320,90,'/m/p/mp05-blue_back_1.jpg','image',0),(1321,90,'/m/p/mp05-blue_outfit_1.jpg','image',0),(1322,90,'/m/p/mp05-green_main_1.jpg','image',0),(1323,90,'/m/p/mp05-blue_main_1.jpg','image',0),(1324,90,'/m/p/mp05-blue_back_1.jpg','image',0),(1325,90,'/m/p/mp05-blue_outfit_1.jpg','image',0),(1326,90,'/m/p/mp06-gray_main_1.jpg','image',0),(1327,90,'/m/p/mp06-gray_back_1.jpg','image',0),(1328,90,'/m/p/mp06-gray_outfit_1.jpg','image',0),(1329,90,'/m/p/mp06-green_main_1.jpg','image',0),(1330,90,'/m/p/mp06-orange_main_1.jpg','image',0),(1331,90,'/m/p/mp06-gray_main_1.jpg','image',0),(1332,90,'/m/p/mp06-gray_back_1.jpg','image',0),(1333,90,'/m/p/mp06-gray_outfit_1.jpg','image',0),(1334,90,'/m/p/mp06-green_main_1.jpg','image',0),(1335,90,'/m/p/mp06-orange_main_1.jpg','image',0),(1336,90,'/m/p/mp06-gray_main_1.jpg','image',0),(1337,90,'/m/p/mp06-gray_back_1.jpg','image',0),(1338,90,'/m/p/mp06-gray_outfit_1.jpg','image',0),(1339,90,'/m/p/mp06-green_main_1.jpg','image',0),(1340,90,'/m/p/mp06-orange_main_1.jpg','image',0),(1341,90,'/m/p/mp06-gray_main_1.jpg','image',0),(1342,90,'/m/p/mp06-gray_back_1.jpg','image',0),(1343,90,'/m/p/mp06-gray_outfit_1.jpg','image',0),(1344,90,'/m/p/mp06-green_main_1.jpg','image',0),(1345,90,'/m/p/mp06-orange_main_1.jpg','image',0),(1346,90,'/m/p/mp06-gray_main_1.jpg','image',0),(1347,90,'/m/p/mp06-gray_back_1.jpg','image',0),(1348,90,'/m/p/mp06-gray_outfit_1.jpg','image',0),(1349,90,'/m/p/mp07-black_main_1.jpg','image',0),(1350,90,'/m/p/mp07-blue_main_1.jpg','image',0),(1351,90,'/m/p/mp07-blue_alt1_1.jpg','image',0),(1352,90,'/m/p/mp07-blue_back_1.jpg','image',0),(1353,90,'/m/p/mp07-blue_side_a_1.jpg','image',0),(1354,90,'/m/p/mp07-blue_side_b_1.jpg','image',0),(1355,90,'/m/p/mp07-purple_main_1.jpg','image',0),(1356,90,'/m/p/mp07-black_main_1.jpg','image',0),(1357,90,'/m/p/mp07-blue_main_1.jpg','image',0),(1358,90,'/m/p/mp07-blue_alt1_1.jpg','image',0),(1359,90,'/m/p/mp07-blue_back_1.jpg','image',0),(1360,90,'/m/p/mp07-blue_side_a_1.jpg','image',0),(1361,90,'/m/p/mp07-blue_side_b_1.jpg','image',0),(1362,90,'/m/p/mp07-purple_main_1.jpg','image',0),(1363,90,'/m/p/mp07-black_main_1.jpg','image',0),(1364,90,'/m/p/mp07-blue_main_1.jpg','image',0),(1365,90,'/m/p/mp07-blue_alt1_1.jpg','image',0),(1366,90,'/m/p/mp07-blue_back_1.jpg','image',0),(1367,90,'/m/p/mp07-blue_side_a_1.jpg','image',0),(1368,90,'/m/p/mp07-blue_side_b_1.jpg','image',0),(1369,90,'/m/p/mp07-purple_main_1.jpg','image',0),(1370,90,'/m/p/mp07-black_main_1.jpg','image',0),(1371,90,'/m/p/mp07-blue_main_1.jpg','image',0),(1372,90,'/m/p/mp07-blue_alt1_1.jpg','image',0),(1373,90,'/m/p/mp07-blue_back_1.jpg','image',0),(1374,90,'/m/p/mp07-blue_side_a_1.jpg','image',0),(1375,90,'/m/p/mp07-blue_side_b_1.jpg','image',0),(1376,90,'/m/p/mp07-purple_main_1.jpg','image',0),(1377,90,'/m/p/mp07-blue_main_1.jpg','image',0),(1378,90,'/m/p/mp07-blue_alt1_1.jpg','image',0),(1379,90,'/m/p/mp07-blue_back_1.jpg','image',0),(1380,90,'/m/p/mp07-blue_side_a_1.jpg','image',0),(1381,90,'/m/p/mp07-blue_side_b_1.jpg','image',0),(1382,90,'/m/p/mp08-blue_main_1.jpg','image',0),(1383,90,'/m/p/mp08-green_main_1.jpg','image',0),(1384,90,'/m/p/mp08-green_alt1_1.jpg','image',0),(1385,90,'/m/p/mp08-green_back_1.jpg','image',0),(1386,90,'/m/p/mp08-red_main_1.jpg','image',0),(1387,90,'/m/p/mp08-blue_main_1.jpg','image',0),(1388,90,'/m/p/mp08-green_main_1.jpg','image',0),(1389,90,'/m/p/mp08-green_alt1_1.jpg','image',0),(1390,90,'/m/p/mp08-green_back_1.jpg','image',0),(1391,90,'/m/p/mp08-red_main_1.jpg','image',0),(1392,90,'/m/p/mp08-blue_main_1.jpg','image',0),(1393,90,'/m/p/mp08-green_main_1.jpg','image',0),(1394,90,'/m/p/mp08-green_alt1_1.jpg','image',0),(1395,90,'/m/p/mp08-green_back_1.jpg','image',0),(1396,90,'/m/p/mp08-red_main_1.jpg','image',0),(1397,90,'/m/p/mp08-blue_main_1.jpg','image',0),(1398,90,'/m/p/mp08-green_main_1.jpg','image',0),(1399,90,'/m/p/mp08-green_alt1_1.jpg','image',0),(1400,90,'/m/p/mp08-green_back_1.jpg','image',0),(1401,90,'/m/p/mp08-red_main_1.jpg','image',0),(1402,90,'/m/p/mp08-green_main_1.jpg','image',0),(1403,90,'/m/p/mp08-green_alt1_1.jpg','image',0),(1404,90,'/m/p/mp08-green_back_1.jpg','image',0),(1405,90,'/m/p/mp09-black_main_1.jpg','image',0),(1406,90,'/m/p/mp09-blue_main_1.jpg','image',0),(1407,90,'/m/p/mp09-blue_alt1_1.jpg','image',0),(1408,90,'/m/p/mp09-blue_back_1.jpg','image',0),(1409,90,'/m/p/mp09-red_main_1.jpg','image',0),(1410,90,'/m/p/mp09-black_main_1.jpg','image',0),(1411,90,'/m/p/mp09-blue_main_1.jpg','image',0),(1412,90,'/m/p/mp09-blue_alt1_1.jpg','image',0),(1413,90,'/m/p/mp09-blue_back_1.jpg','image',0),(1414,90,'/m/p/mp09-red_main_1.jpg','image',0),(1415,90,'/m/p/mp09-black_main_1.jpg','image',0),(1416,90,'/m/p/mp09-blue_main_1.jpg','image',0),(1417,90,'/m/p/mp09-blue_alt1_1.jpg','image',0),(1418,90,'/m/p/mp09-blue_back_1.jpg','image',0),(1419,90,'/m/p/mp09-red_main_1.jpg','image',0),(1420,90,'/m/p/mp09-black_main_1.jpg','image',0),(1421,90,'/m/p/mp09-blue_main_1.jpg','image',0),(1422,90,'/m/p/mp09-blue_alt1_1.jpg','image',0),(1423,90,'/m/p/mp09-blue_back_1.jpg','image',0),(1424,90,'/m/p/mp09-red_main_1.jpg','image',0),(1425,90,'/m/p/mp09-blue_main_1.jpg','image',0),(1426,90,'/m/p/mp09-blue_alt1_1.jpg','image',0),(1427,90,'/m/p/mp09-blue_back_1.jpg','image',0),(1428,90,'/m/p/mp10-black_main_1.jpg','image',0),(1429,90,'/m/p/mp10-black_alt1_1.jpg','image',0),(1430,90,'/m/p/mp10-black_back_1.jpg','image',0),(1431,90,'/m/p/mp10-blue_main_1.jpg','image',0),(1432,90,'/m/p/mp10-green_main_1.jpg','image',0),(1433,90,'/m/p/mp10-black_main_1.jpg','image',0),(1434,90,'/m/p/mp10-black_alt1_1.jpg','image',0),(1435,90,'/m/p/mp10-black_back_1.jpg','image',0),(1436,90,'/m/p/mp10-blue_main_1.jpg','image',0),(1437,90,'/m/p/mp10-green_main_2.jpg','image',0),(1438,90,'/m/p/mp10-black_main_2.jpg','image',0),(1439,90,'/m/p/mp10-black_alt1_2.jpg','image',0),(1440,90,'/m/p/mp10-black_back_2.jpg','image',0),(1441,90,'/m/p/mp10-blue_main_2.jpg','image',0),(1442,90,'/m/p/mp10-green_main_2.jpg','image',0),(1443,90,'/m/p/mp10-black_main_2.jpg','image',0),(1444,90,'/m/p/mp10-black_alt1_2.jpg','image',0),(1445,90,'/m/p/mp10-black_back_2.jpg','image',0),(1446,90,'/m/p/mp10-blue_main_2.jpg','image',0),(1447,90,'/m/p/mp10-green_main_2.jpg','image',0),(1448,90,'/m/p/mp10-black_main_2.jpg','image',0),(1449,90,'/m/p/mp10-black_alt1_2.jpg','image',0),(1450,90,'/m/p/mp10-black_back_2.jpg','image',0),(1451,90,'/m/p/mp11-blue_main_1.jpg','image',0),(1452,90,'/m/p/mp11-brown_main_1.jpg','image',0),(1453,90,'/m/p/mp11-brown_alt1_1.jpg','image',0),(1454,90,'/m/p/mp11-brown_back_1.jpg','image',0),(1455,90,'/m/p/mp11-green_main_1.jpg','image',0),(1456,90,'/m/p/mp11-blue_main_1.jpg','image',0),(1457,90,'/m/p/mp11-brown_main_1.jpg','image',0),(1458,90,'/m/p/mp11-brown_alt1_1.jpg','image',0),(1459,90,'/m/p/mp11-brown_back_1.jpg','image',0),(1460,90,'/m/p/mp11-green_main_1.jpg','image',0),(1461,90,'/m/p/mp11-blue_main_1.jpg','image',0),(1462,90,'/m/p/mp11-brown_main_1.jpg','image',0),(1463,90,'/m/p/mp11-brown_alt1_1.jpg','image',0),(1464,90,'/m/p/mp11-brown_back_1.jpg','image',0),(1465,90,'/m/p/mp11-green_main_1.jpg','image',0),(1466,90,'/m/p/mp11-blue_main_1.jpg','image',0),(1467,90,'/m/p/mp11-brown_main_1.jpg','image',0),(1468,90,'/m/p/mp11-brown_alt1_1.jpg','image',0),(1469,90,'/m/p/mp11-brown_back_1.jpg','image',0),(1470,90,'/m/p/mp11-green_main_1.jpg','image',0),(1471,90,'/m/p/mp11-brown_main_1.jpg','image',0),(1472,90,'/m/p/mp11-brown_alt1_1.jpg','image',0),(1473,90,'/m/p/mp11-brown_back_1.jpg','image',0),(1474,90,'/m/p/mp12-black_main_1.jpg','image',0),(1475,90,'/m/p/mp12-black_back_1.jpg','image',0),(1476,90,'/m/p/mp12-blue_main_1.jpg','image',0),(1477,90,'/m/p/mp12-red_main_1.jpg','image',0),(1478,90,'/m/p/mp12-black_main_1.jpg','image',0),(1479,90,'/m/p/mp12-black_back_1.jpg','image',0),(1480,90,'/m/p/mp12-blue_main_1.jpg','image',0),(1481,90,'/m/p/mp12-red_main_1.jpg','image',0),(1482,90,'/m/p/mp12-black_main_1.jpg','image',0),(1483,90,'/m/p/mp12-black_back_1.jpg','image',0),(1484,90,'/m/p/mp12-blue_main_1.jpg','image',0),(1485,90,'/m/p/mp12-red_main_1.jpg','image',0),(1486,90,'/m/p/mp12-black_main_1.jpg','image',0),(1487,90,'/m/p/mp12-black_back_1.jpg','image',0),(1488,90,'/m/p/mp12-blue_main_1.jpg','image',0),(1489,90,'/m/p/mp12-red_main_1.jpg','image',0),(1490,90,'/m/p/mp12-black_main_1.jpg','image',0),(1491,90,'/m/p/mp12-black_back_1.jpg','image',0),(1492,90,'/m/s/msh01-black_main_1.jpg','image',0),(1493,90,'/m/s/msh01-blue_main_1.jpg','image',0),(1494,90,'/m/s/msh01-blue_back_1.jpg','image',0),(1495,90,'/m/s/msh01-red_main_1.jpg','image',0),(1496,90,'/m/s/msh01-black_main_1.jpg','image',0),(1497,90,'/m/s/msh01-blue_main_1.jpg','image',0),(1498,90,'/m/s/msh01-blue_back_1.jpg','image',0),(1499,90,'/m/s/msh01-red_main_1.jpg','image',0),(1500,90,'/m/s/msh01-black_main_1.jpg','image',0),(1501,90,'/m/s/msh01-blue_main_1.jpg','image',0),(1502,90,'/m/s/msh01-blue_back_1.jpg','image',0),(1503,90,'/m/s/msh01-red_main_1.jpg','image',0),(1504,90,'/m/s/msh01-black_main_1.jpg','image',0),(1505,90,'/m/s/msh01-blue_main_1.jpg','image',0),(1506,90,'/m/s/msh01-blue_back_1.jpg','image',0),(1507,90,'/m/s/msh01-red_main_1.jpg','image',0),(1508,90,'/m/s/msh01-blue_main_1.jpg','image',0),(1509,90,'/m/s/msh01-blue_back_1.jpg','image',0),(1510,90,'/m/s/msh02-black_main_1.jpg','image',0),(1511,90,'/m/s/msh02-black_alt1_1.jpg','image',0),(1512,90,'/m/s/msh02-black_back_1.jpg','image',0),(1513,90,'/m/s/msh02-black_main_1.jpg','image',0),(1514,90,'/m/s/msh02-black_alt1_1.jpg','image',0),(1515,90,'/m/s/msh02-black_back_1.jpg','image',0),(1516,90,'/m/s/msh02-black_main_1.jpg','image',0),(1517,90,'/m/s/msh02-black_alt1_1.jpg','image',0),(1518,90,'/m/s/msh02-black_back_1.jpg','image',0),(1519,90,'/m/s/msh02-black_main_1.jpg','image',0),(1520,90,'/m/s/msh02-black_alt1_1.jpg','image',0),(1521,90,'/m/s/msh02-black_back_1.jpg','image',0),(1522,90,'/m/s/msh02-black_main_1.jpg','image',0),(1523,90,'/m/s/msh02-black_alt1_1.jpg','image',0),(1524,90,'/m/s/msh02-black_back_1.jpg','image',0),(1525,90,'/m/s/msh03-black_main_1.jpg','image',0),(1526,90,'/m/s/msh03-blue_main_1.jpg','image',0),(1527,90,'/m/s/msh03-blue_alt1_1.jpg','image',0),(1528,90,'/m/s/msh03-blue_back_1.jpg','image',0),(1529,90,'/m/s/msh03-green_main_1.jpg','image',0),(1530,90,'/m/s/msh03-black_main_1.jpg','image',0),(1531,90,'/m/s/msh03-blue_main_1.jpg','image',0),(1532,90,'/m/s/msh03-blue_alt1_1.jpg','image',0),(1533,90,'/m/s/msh03-blue_back_1.jpg','image',0),(1534,90,'/m/s/msh03-green_main_1.jpg','image',0),(1535,90,'/m/s/msh03-black_main_1.jpg','image',0),(1536,90,'/m/s/msh03-blue_main_1.jpg','image',0),(1537,90,'/m/s/msh03-blue_alt1_1.jpg','image',0),(1538,90,'/m/s/msh03-blue_back_1.jpg','image',0),(1539,90,'/m/s/msh03-green_main_1.jpg','image',0),(1540,90,'/m/s/msh03-black_main_1.jpg','image',0),(1541,90,'/m/s/msh03-blue_main_1.jpg','image',0),(1542,90,'/m/s/msh03-blue_alt1_1.jpg','image',0),(1543,90,'/m/s/msh03-blue_back_1.jpg','image',0),(1544,90,'/m/s/msh03-green_main_1.jpg','image',0),(1545,90,'/m/s/msh03-blue_main_1.jpg','image',0),(1546,90,'/m/s/msh03-blue_alt1_1.jpg','image',0),(1547,90,'/m/s/msh03-blue_back_1.jpg','image',0),(1548,90,'/m/s/msh04-gray_main_1.jpg','image',0),(1549,90,'/m/s/msh04-gray_back_1.jpg','image',0),(1550,90,'/m/s/msh04-purple_main_1.jpg','image',0),(1551,90,'/m/s/msh04-yellow_main_1.jpg','image',0),(1552,90,'/m/s/msh04-gray_main_1.jpg','image',0),(1553,90,'/m/s/msh04-gray_back_1.jpg','image',0),(1554,90,'/m/s/msh04-purple_main_1.jpg','image',0),(1555,90,'/m/s/msh04-yellow_main_1.jpg','image',0),(1556,90,'/m/s/msh04-gray_main_1.jpg','image',0),(1557,90,'/m/s/msh04-gray_back_1.jpg','image',0),(1558,90,'/m/s/msh04-purple_main_1.jpg','image',0),(1559,90,'/m/s/msh04-yellow_main_1.jpg','image',0),(1560,90,'/m/s/msh04-gray_main_1.jpg','image',0),(1561,90,'/m/s/msh04-gray_back_1.jpg','image',0),(1562,90,'/m/s/msh04-purple_main_1.jpg','image',0),(1563,90,'/m/s/msh04-yellow_main_1.jpg','image',0),(1564,90,'/m/s/msh04-gray_main_1.jpg','image',0),(1565,90,'/m/s/msh04-gray_back_1.jpg','image',0),(1566,90,'/m/s/msh05-black_main_1.jpg','image',0),(1567,90,'/m/s/msh05-blue_main_1.jpg','image',0),(1568,90,'/m/s/msh05-gray_main_1.jpg','image',0),(1569,90,'/m/s/msh05-gray_alt1_1.jpg','image',0),(1570,90,'/m/s/msh05-gray_back_1.jpg','image',0),(1571,90,'/m/s/msh05-black_main_1.jpg','image',0),(1572,90,'/m/s/msh05-blue_main_1.jpg','image',0),(1573,90,'/m/s/msh05-gray_main_1.jpg','image',0),(1574,90,'/m/s/msh05-gray_alt1_1.jpg','image',0),(1575,90,'/m/s/msh05-gray_back_1.jpg','image',0),(1576,90,'/m/s/msh05-black_main_1.jpg','image',0),(1577,90,'/m/s/msh05-blue_main_1.jpg','image',0),(1578,90,'/m/s/msh05-gray_main_1.jpg','image',0),(1579,90,'/m/s/msh05-gray_alt1_1.jpg','image',0),(1580,90,'/m/s/msh05-gray_back_1.jpg','image',0),(1581,90,'/m/s/msh05-black_main_1.jpg','image',0),(1582,90,'/m/s/msh05-blue_main_1.jpg','image',0),(1583,90,'/m/s/msh05-gray_main_1.jpg','image',0),(1584,90,'/m/s/msh05-gray_alt1_1.jpg','image',0),(1585,90,'/m/s/msh05-gray_back_1.jpg','image',0),(1586,90,'/m/s/msh05-gray_main_1.jpg','image',0),(1587,90,'/m/s/msh05-gray_alt1_1.jpg','image',0),(1588,90,'/m/s/msh05-gray_back_1.jpg','image',0),(1589,90,'/m/s/msh06-blue_main_1.jpg','image',0),(1590,90,'/m/s/msh06-gray_main_1.jpg','image',0),(1591,90,'/m/s/msh06-gray_alt1_1.jpg','image',0),(1592,90,'/m/s/msh06-gray_back_1.jpg','image',0),(1593,90,'/m/s/msh06-red_main_1.jpg','image',0),(1594,90,'/m/s/msh06-blue_main_1.jpg','image',0),(1595,90,'/m/s/msh06-gray_main_1.jpg','image',0),(1596,90,'/m/s/msh06-gray_alt1_1.jpg','image',0),(1597,90,'/m/s/msh06-gray_back_1.jpg','image',0),(1598,90,'/m/s/msh06-red_main_1.jpg','image',0),(1599,90,'/m/s/msh06-blue_main_1.jpg','image',0),(1600,90,'/m/s/msh06-gray_main_1.jpg','image',0),(1601,90,'/m/s/msh06-gray_alt1_1.jpg','image',0),(1602,90,'/m/s/msh06-gray_back_1.jpg','image',0),(1603,90,'/m/s/msh06-red_main_1.jpg','image',0),(1604,90,'/m/s/msh06-blue_main_2.jpg','image',0),(1605,90,'/m/s/msh06-gray_main_2.jpg','image',0),(1606,90,'/m/s/msh06-gray_alt1_2.jpg','image',0),(1607,90,'/m/s/msh06-gray_back_2.jpg','image',0),(1608,90,'/m/s/msh06-red_main_2.jpg','image',0),(1609,90,'/m/s/msh06-gray_main_2.jpg','image',0),(1610,90,'/m/s/msh06-gray_alt1_2.jpg','image',0),(1611,90,'/m/s/msh06-gray_back_2.jpg','image',0),(1612,90,'/m/s/msh07-black_main_1.jpg','image',0),(1613,90,'/m/s/msh07-black_alt1_1.jpg','image',0),(1614,90,'/m/s/msh07-black_back_1.jpg','image',0),(1615,90,'/m/s/msh07-blue_main_1.jpg','image',0),(1616,90,'/m/s/msh07-purple_main_1.jpg','image',0),(1617,90,'/m/s/msh07-black_main_1.jpg','image',0),(1618,90,'/m/s/msh07-black_alt1_1.jpg','image',0),(1619,90,'/m/s/msh07-black_back_1.jpg','image',0),(1620,90,'/m/s/msh07-blue_main_1.jpg','image',0),(1621,90,'/m/s/msh07-purple_main_1.jpg','image',0),(1622,90,'/m/s/msh07-black_main_1.jpg','image',0),(1623,90,'/m/s/msh07-black_alt1_1.jpg','image',0),(1624,90,'/m/s/msh07-black_back_1.jpg','image',0),(1625,90,'/m/s/msh07-blue_main_1.jpg','image',0),(1626,90,'/m/s/msh07-purple_main_1.jpg','image',0),(1627,90,'/m/s/msh07-black_main_1.jpg','image',0),(1628,90,'/m/s/msh07-black_alt1_1.jpg','image',0),(1629,90,'/m/s/msh07-black_back_1.jpg','image',0),(1630,90,'/m/s/msh07-blue_main_1.jpg','image',0),(1631,90,'/m/s/msh07-purple_main_1.jpg','image',0),(1632,90,'/m/s/msh07-black_main_1.jpg','image',0),(1633,90,'/m/s/msh07-black_alt1_1.jpg','image',0),(1634,90,'/m/s/msh07-black_back_1.jpg','image',0),(1635,90,'/m/s/msh08-black_main_1.jpg','image',0),(1636,90,'/m/s/msh08-black_back_1.jpg','image',0),(1637,90,'/m/s/msh08-blue_main_1.jpg','image',0),(1638,90,'/m/s/msh08-green_main_1.jpg','image',0),(1639,90,'/m/s/msh08-black_main_1.jpg','image',0),(1640,90,'/m/s/msh08-black_back_1.jpg','image',0),(1641,90,'/m/s/msh08-blue_main_1.jpg','image',0),(1642,90,'/m/s/msh08-green_main_1.jpg','image',0),(1643,90,'/m/s/msh08-black_main_1.jpg','image',0),(1644,90,'/m/s/msh08-black_back_1.jpg','image',0),(1645,90,'/m/s/msh08-blue_main_1.jpg','image',0),(1646,90,'/m/s/msh08-green_main_1.jpg','image',0),(1647,90,'/m/s/msh08-black_main_1.jpg','image',0),(1648,90,'/m/s/msh08-black_back_1.jpg','image',0),(1649,90,'/m/s/msh08-blue_main_1.jpg','image',0),(1650,90,'/m/s/msh08-green_main_1.jpg','image',0),(1651,90,'/m/s/msh08-black_main_1.jpg','image',0),(1652,90,'/m/s/msh08-black_back_1.jpg','image',0),(1653,90,'/m/s/msh09-black_main_1.jpg','image',0),(1654,90,'/m/s/msh09-blue_main_1.jpg','image',0),(1655,90,'/m/s/msh09-blue_alt1_1.jpg','image',0),(1656,90,'/m/s/msh09-blue_back_1.jpg','image',0),(1657,90,'/m/s/msh09-green_main_1.jpg','image',0),(1658,90,'/m/s/msh09-black_main_1.jpg','image',0),(1659,90,'/m/s/msh09-blue_main_1.jpg','image',0),(1660,90,'/m/s/msh09-blue_alt1_1.jpg','image',0),(1661,90,'/m/s/msh09-blue_back_1.jpg','image',0),(1662,90,'/m/s/msh09-green_main_1.jpg','image',0),(1663,90,'/m/s/msh09-black_main_1.jpg','image',0),(1664,90,'/m/s/msh09-blue_main_1.jpg','image',0),(1665,90,'/m/s/msh09-blue_alt1_1.jpg','image',0),(1666,90,'/m/s/msh09-blue_back_1.jpg','image',0),(1667,90,'/m/s/msh09-green_main_1.jpg','image',0),(1668,90,'/m/s/msh09-black_main_1.jpg','image',0),(1669,90,'/m/s/msh09-blue_main_1.jpg','image',0),(1670,90,'/m/s/msh09-blue_alt1_1.jpg','image',0),(1671,90,'/m/s/msh09-blue_back_1.jpg','image',0),(1672,90,'/m/s/msh09-green_main_1.jpg','image',0),(1673,90,'/m/s/msh09-blue_main_1.jpg','image',0),(1674,90,'/m/s/msh09-blue_alt1_1.jpg','image',0),(1675,90,'/m/s/msh09-blue_back_1.jpg','image',0),(1676,90,'/m/s/msh10-blue_main_1.jpg','image',0),(1677,90,'/m/s/msh10-blue_alt1_1.jpg','image',0),(1678,90,'/m/s/msh10-blue_back_1.jpg','image',0),(1679,90,'/m/s/msh10-green_main_1.jpg','image',0),(1680,90,'/m/s/msh10-purple_main_1.jpg','image',0),(1681,90,'/m/s/msh10-blue_main_1.jpg','image',0),(1682,90,'/m/s/msh10-blue_alt1_1.jpg','image',0),(1683,90,'/m/s/msh10-blue_back_1.jpg','image',0),(1684,90,'/m/s/msh10-green_main_1.jpg','image',0),(1685,90,'/m/s/msh10-purple_main_1.jpg','image',0),(1686,90,'/m/s/msh10-blue_main_1.jpg','image',0),(1687,90,'/m/s/msh10-blue_alt1_1.jpg','image',0),(1688,90,'/m/s/msh10-blue_back_1.jpg','image',0),(1689,90,'/m/s/msh10-green_main_1.jpg','image',0),(1690,90,'/m/s/msh10-purple_main_1.jpg','image',0),(1691,90,'/m/s/msh10-blue_main_1.jpg','image',0),(1692,90,'/m/s/msh10-blue_alt1_1.jpg','image',0),(1693,90,'/m/s/msh10-blue_back_1.jpg','image',0),(1694,90,'/m/s/msh10-green_main_1.jpg','image',0),(1695,90,'/m/s/msh10-purple_main_1.jpg','image',0),(1696,90,'/m/s/msh10-blue_main_1.jpg','image',0),(1697,90,'/m/s/msh10-blue_alt1_1.jpg','image',0),(1698,90,'/m/s/msh10-blue_back_1.jpg','image',0),(1699,90,'/m/s/msh11-black_main_1.jpg','image',0),(1700,90,'/m/s/msh11-blue_main_1.jpg','image',0),(1701,90,'/m/s/msh11-blue_back_1.jpg','image',0),(1702,90,'/m/s/msh11-red_main_1.jpg','image',0),(1703,90,'/m/s/msh11-black_main_1.jpg','image',0),(1704,90,'/m/s/msh11-blue_main_1.jpg','image',0),(1705,90,'/m/s/msh11-blue_back_1.jpg','image',0),(1706,90,'/m/s/msh11-red_main_1.jpg','image',0),(1707,90,'/m/s/msh11-black_main_1.jpg','image',0),(1708,90,'/m/s/msh11-blue_main_1.jpg','image',0),(1709,90,'/m/s/msh11-blue_back_1.jpg','image',0),(1710,90,'/m/s/msh11-red_main_1.jpg','image',0),(1711,90,'/m/s/msh11-black_main_1.jpg','image',0),(1712,90,'/m/s/msh11-blue_main_1.jpg','image',0),(1713,90,'/m/s/msh11-blue_back_1.jpg','image',0),(1714,90,'/m/s/msh11-red_main_1.jpg','image',0),(1715,90,'/m/s/msh11-blue_main_1.jpg','image',0),(1716,90,'/m/s/msh11-blue_back_1.jpg','image',0),(1717,90,'/m/s/msh12-black_main_1.jpg','image',0),(1718,90,'/m/s/msh12-gray_main_1.jpg','image',0),(1719,90,'/m/s/msh12-red_main_1.jpg','image',0),(1720,90,'/m/s/msh12-red_back_1.jpg','image',0),(1721,90,'/m/s/msh12-black_main_1.jpg','image',0),(1722,90,'/m/s/msh12-gray_main_1.jpg','image',0),(1723,90,'/m/s/msh12-red_main_1.jpg','image',0),(1724,90,'/m/s/msh12-red_back_1.jpg','image',0),(1725,90,'/m/s/msh12-black_main_1.jpg','image',0),(1726,90,'/m/s/msh12-gray_main_1.jpg','image',0),(1727,90,'/m/s/msh12-red_main_1.jpg','image',0),(1728,90,'/m/s/msh12-red_back_1.jpg','image',0),(1729,90,'/m/s/msh12-black_main_1.jpg','image',0),(1730,90,'/m/s/msh12-gray_main_1.jpg','image',0),(1731,90,'/m/s/msh12-red_main_1.jpg','image',0),(1732,90,'/m/s/msh12-red_back_1.jpg','image',0),(1733,90,'/m/s/msh12-red_main_1.jpg','image',0),(1734,90,'/m/s/msh12-red_back_1.jpg','image',0),(1735,90,'/w/h/wh01-green_main_1.jpg','image',0),(1736,90,'/w/h/wh01-green_alt1_1.jpg','image',0),(1737,90,'/w/h/wh01-green_back_1.jpg','image',0),(1738,90,'/w/h/wh01-orange_main_1.jpg','image',0),(1739,90,'/w/h/wh01-purple_main_1.jpg','image',0),(1740,90,'/w/h/wh01-green_main_1.jpg','image',0),(1741,90,'/w/h/wh01-green_alt1_1.jpg','image',0),(1742,90,'/w/h/wh01-green_back_1.jpg','image',0),(1743,90,'/w/h/wh01-orange_main_1.jpg','image',0),(1744,90,'/w/h/wh01-purple_main_1.jpg','image',0),(1745,90,'/w/h/wh01-green_main_1.jpg','image',0),(1746,90,'/w/h/wh01-green_alt1_1.jpg','image',0),(1747,90,'/w/h/wh01-green_back_1.jpg','image',0),(1748,90,'/w/h/wh01-orange_main_1.jpg','image',0),(1749,90,'/w/h/wh01-purple_main_1.jpg','image',0),(1750,90,'/w/h/wh01-green_main_1.jpg','image',0),(1751,90,'/w/h/wh01-green_alt1_1.jpg','image',0),(1752,90,'/w/h/wh01-green_back_1.jpg','image',0),(1753,90,'/w/h/wh01-orange_main_1.jpg','image',0),(1754,90,'/w/h/wh01-purple_main_1.jpg','image',0),(1755,90,'/w/h/wh01-green_main_1.jpg','image',0),(1756,90,'/w/h/wh01-green_alt1_1.jpg','image',0),(1757,90,'/w/h/wh01-green_back_1.jpg','image',0),(1758,90,'/w/h/wh01-orange_main_1.jpg','image',0),(1759,90,'/w/h/wh01-purple_main_1.jpg','image',0),(1760,90,'/w/h/wh01-green_main_1.jpg','image',0),(1761,90,'/w/h/wh01-green_alt1_1.jpg','image',0),(1762,90,'/w/h/wh01-green_back_1.jpg','image',0),(1763,90,'/w/h/wh02-blue_main_1.jpg','image',0),(1764,90,'/w/h/wh02-blue_alt1_1.jpg','image',0),(1765,90,'/w/h/wh02-blue_back_1.jpg','image',0),(1766,90,'/w/h/wh02-green_main_1.jpg','image',0),(1767,90,'/w/h/wh02-orange_main_1.jpg','image',0),(1768,90,'/w/h/wh02-blue_main_2.jpg','image',0),(1769,90,'/w/h/wh02-blue_alt1_2.jpg','image',0),(1770,90,'/w/h/wh02-blue_back_2.jpg','image',0),(1771,90,'/w/h/wh02-green_main_2.jpg','image',0),(1772,90,'/w/h/wh02-orange_main_1.jpg','image',0),(1773,90,'/w/h/wh02-blue_main_2.jpg','image',0),(1774,90,'/w/h/wh02-blue_alt1_2.jpg','image',0),(1775,90,'/w/h/wh02-blue_back_2.jpg','image',0),(1776,90,'/w/h/wh02-green_main_2.jpg','image',0),(1777,90,'/w/h/wh02-orange_main_1.jpg','image',0),(1778,90,'/w/h/wh02-blue_main_2.jpg','image',0),(1779,90,'/w/h/wh02-blue_alt1_2.jpg','image',0),(1780,90,'/w/h/wh02-blue_back_2.jpg','image',0),(1781,90,'/w/h/wh02-green_main_2.jpg','image',0),(1782,90,'/w/h/wh02-orange_main_1.jpg','image',0),(1783,90,'/w/h/wh02-blue_main_2.jpg','image',0),(1784,90,'/w/h/wh02-blue_alt1_2.jpg','image',0),(1785,90,'/w/h/wh02-blue_back_2.jpg','image',0),(1786,90,'/w/h/wh02-green_main_2.jpg','image',0),(1787,90,'/w/h/wh02-orange_main_1.jpg','image',0),(1788,90,'/w/h/wh02-blue_main_2.jpg','image',0),(1789,90,'/w/h/wh02-blue_alt1_2.jpg','image',0),(1790,90,'/w/h/wh02-blue_back_2.jpg','image',0),(1791,90,'/w/h/wh03-green_main_1.jpg','image',0),(1792,90,'/w/h/wh03-purple_main_1.jpg','image',0),(1793,90,'/w/h/wh03-red_main_1.jpg','image',0),(1794,90,'/w/h/wh03-red_alt1_1.jpg','image',0),(1795,90,'/w/h/wh03-red_back_1.jpg','image',0),(1796,90,'/w/h/wh03-green_main_1.jpg','image',0),(1797,90,'/w/h/wh03-purple_main_1.jpg','image',0),(1798,90,'/w/h/wh03-red_main_1.jpg','image',0),(1799,90,'/w/h/wh03-red_alt1_1.jpg','image',0),(1800,90,'/w/h/wh03-red_back_1.jpg','image',0),(1801,90,'/w/h/wh03-green_main_1.jpg','image',0),(1802,90,'/w/h/wh03-purple_main_1.jpg','image',0),(1803,90,'/w/h/wh03-red_main_1.jpg','image',0),(1804,90,'/w/h/wh03-red_alt1_1.jpg','image',0),(1805,90,'/w/h/wh03-red_back_1.jpg','image',0),(1806,90,'/w/h/wh03-green_main_1.jpg','image',0),(1807,90,'/w/h/wh03-purple_main_1.jpg','image',0),(1808,90,'/w/h/wh03-red_main_1.jpg','image',0),(1809,90,'/w/h/wh03-red_alt1_1.jpg','image',0),(1810,90,'/w/h/wh03-red_back_1.jpg','image',0),(1811,90,'/w/h/wh03-green_main_1.jpg','image',0),(1812,90,'/w/h/wh03-purple_main_1.jpg','image',0),(1813,90,'/w/h/wh03-red_main_1.jpg','image',0),(1814,90,'/w/h/wh03-red_alt1_1.jpg','image',0),(1815,90,'/w/h/wh03-red_back_1.jpg','image',0),(1816,90,'/w/h/wh03-red_main_1.jpg','image',0),(1817,90,'/w/h/wh03-red_alt1_1.jpg','image',0),(1818,90,'/w/h/wh03-red_back_1.jpg','image',0),(1819,90,'/w/h/wh04-blue_main_1.jpg','image',0),(1820,90,'/w/h/wh04-blue_alt1_1.jpg','image',0),(1821,90,'/w/h/wh04-blue_back_1.jpg','image',0),(1822,90,'/w/h/wh04-orange_main_1.jpg','image',0),(1823,90,'/w/h/wh04-purple_main_1.jpg','image',0),(1824,90,'/w/h/wh04-blue_main_1.jpg','image',0),(1825,90,'/w/h/wh04-blue_alt1_1.jpg','image',0),(1826,90,'/w/h/wh04-blue_back_1.jpg','image',0),(1827,90,'/w/h/wh04-orange_main_1.jpg','image',0),(1828,90,'/w/h/wh04-purple_main_1.jpg','image',0),(1829,90,'/w/h/wh04-blue_main_1.jpg','image',0),(1830,90,'/w/h/wh04-blue_alt1_1.jpg','image',0),(1831,90,'/w/h/wh04-blue_back_1.jpg','image',0),(1832,90,'/w/h/wh04-orange_main_1.jpg','image',0),(1833,90,'/w/h/wh04-purple_main_1.jpg','image',0),(1834,90,'/w/h/wh04-blue_main_1.jpg','image',0),(1835,90,'/w/h/wh04-blue_alt1_1.jpg','image',0),(1836,90,'/w/h/wh04-blue_back_1.jpg','image',0),(1837,90,'/w/h/wh04-orange_main_1.jpg','image',0),(1838,90,'/w/h/wh04-purple_main_1.jpg','image',0),(1839,90,'/w/h/wh04-blue_main_1.jpg','image',0),(1840,90,'/w/h/wh04-blue_alt1_1.jpg','image',0),(1841,90,'/w/h/wh04-blue_back_1.jpg','image',0),(1842,90,'/w/h/wh04-orange_main_1.jpg','image',0),(1843,90,'/w/h/wh04-purple_main_1.jpg','image',0),(1844,90,'/w/h/wh04-blue_main_1.jpg','image',0),(1845,90,'/w/h/wh04-blue_alt1_1.jpg','image',0),(1846,90,'/w/h/wh04-blue_back_1.jpg','image',0),(1847,90,'/w/h/wh05-orange_main_1.jpg','image',0),(1848,90,'/w/h/wh05-purple_main_1.jpg','image',0),(1849,90,'/w/h/wh05-white_main_1.jpg','image',0),(1850,90,'/w/h/wh05-white_back_1.jpg','image',0),(1851,90,'/w/h/wh05-orange_main_1.jpg','image',0),(1852,90,'/w/h/wh05-purple_main_1.jpg','image',0),(1853,90,'/w/h/wh05-white_main_1.jpg','image',0),(1854,90,'/w/h/wh05-white_back_1.jpg','image',0),(1855,90,'/w/h/wh05-orange_main_1.jpg','image',0),(1856,90,'/w/h/wh05-purple_main_1.jpg','image',0),(1857,90,'/w/h/wh05-white_main_1.jpg','image',0),(1858,90,'/w/h/wh05-white_back_1.jpg','image',0),(1859,90,'/w/h/wh05-orange_main_1.jpg','image',0),(1860,90,'/w/h/wh05-purple_main_1.jpg','image',0),(1861,90,'/w/h/wh05-white_main_1.jpg','image',0),(1862,90,'/w/h/wh05-white_back_1.jpg','image',0),(1863,90,'/w/h/wh05-orange_main_1.jpg','image',0),(1864,90,'/w/h/wh05-purple_main_1.jpg','image',0),(1865,90,'/w/h/wh05-white_main_1.jpg','image',0),(1866,90,'/w/h/wh05-white_back_1.jpg','image',0),(1867,90,'/w/h/wh05-white_main_1.jpg','image',0),(1868,90,'/w/h/wh05-white_back_1.jpg','image',0),(1869,90,'/w/h/wh06-purple_main_1.jpg','image',0),(1870,90,'/w/h/wh06-purple_alt1_1.jpg','image',0),(1871,90,'/w/h/wh06-purple_back_1.jpg','image',0),(1872,90,'/w/h/wh06-purple_main_1.jpg','image',0),(1873,90,'/w/h/wh06-purple_alt1_1.jpg','image',0),(1874,90,'/w/h/wh06-purple_back_1.jpg','image',0),(1875,90,'/w/h/wh06-purple_main_1.jpg','image',0),(1876,90,'/w/h/wh06-purple_alt1_1.jpg','image',0),(1877,90,'/w/h/wh06-purple_back_1.jpg','image',0),(1878,90,'/w/h/wh06-purple_main_1.jpg','image',0),(1879,90,'/w/h/wh06-purple_alt1_1.jpg','image',0),(1880,90,'/w/h/wh06-purple_back_1.jpg','image',0),(1881,90,'/w/h/wh06-purple_main_1.jpg','image',0),(1882,90,'/w/h/wh06-purple_alt1_1.jpg','image',0),(1883,90,'/w/h/wh06-purple_back_1.jpg','image',0),(1884,90,'/w/h/wh06-purple_main_1.jpg','image',0),(1885,90,'/w/h/wh06-purple_alt1_1.jpg','image',0),(1886,90,'/w/h/wh06-purple_back_1.jpg','image',0),(1887,90,'/w/h/wh07-gray_main_1.jpg','image',0),(1888,90,'/w/h/wh07-gray_alt1_1.jpg','image',0),(1889,90,'/w/h/wh07-gray_back_1.jpg','image',0),(1890,90,'/w/h/wh07-purple_main_1.jpg','image',0),(1891,90,'/w/h/wh07-white_main_1.jpg','image',0),(1892,90,'/w/h/wh07-gray_main_1.jpg','image',0),(1893,90,'/w/h/wh07-gray_alt1_1.jpg','image',0),(1894,90,'/w/h/wh07-gray_back_1.jpg','image',0),(1895,90,'/w/h/wh07-purple_main_1.jpg','image',0),(1896,90,'/w/h/wh07-white_main_1.jpg','image',0),(1897,90,'/w/h/wh07-gray_main_1.jpg','image',0),(1898,90,'/w/h/wh07-gray_alt1_1.jpg','image',0),(1899,90,'/w/h/wh07-gray_back_1.jpg','image',0),(1900,90,'/w/h/wh07-purple_main_1.jpg','image',0),(1901,90,'/w/h/wh07-white_main_1.jpg','image',0),(1902,90,'/w/h/wh07-gray_main_1.jpg','image',0),(1903,90,'/w/h/wh07-gray_alt1_1.jpg','image',0),(1904,90,'/w/h/wh07-gray_back_1.jpg','image',0),(1905,90,'/w/h/wh07-purple_main_1.jpg','image',0),(1906,90,'/w/h/wh07-white_main_1.jpg','image',0),(1907,90,'/w/h/wh07-gray_main_1.jpg','image',0),(1908,90,'/w/h/wh07-gray_alt1_1.jpg','image',0),(1909,90,'/w/h/wh07-gray_back_1.jpg','image',0),(1910,90,'/w/h/wh07-purple_main_1.jpg','image',0),(1911,90,'/w/h/wh07-white_main_1.jpg','image',0),(1912,90,'/w/h/wh07-gray_main_1.jpg','image',0),(1913,90,'/w/h/wh07-gray_alt1_1.jpg','image',0),(1914,90,'/w/h/wh07-gray_back_1.jpg','image',0),(1915,90,'/w/h/wh08-orange_main_1.jpg','image',0),(1916,90,'/w/h/wh08-purple_main_1.jpg','image',0),(1917,90,'/w/h/wh08-white_main_1.jpg','image',0),(1918,90,'/w/h/wh08-white_alt1_1.jpg','image',0),(1919,90,'/w/h/wh08-white_alternate_1.jpg','image',0),(1920,90,'/w/h/wh08-white_back_1.jpg','image',0),(1921,90,'/w/h/wh08-orange_main_1.jpg','image',0),(1922,90,'/w/h/wh08-purple_main_1.jpg','image',0),(1923,90,'/w/h/wh08-white_main_1.jpg','image',0),(1924,90,'/w/h/wh08-white_alt1_1.jpg','image',0),(1925,90,'/w/h/wh08-white_alternate_1.jpg','image',0),(1926,90,'/w/h/wh08-white_back_1.jpg','image',0),(1927,90,'/w/h/wh08-orange_main_1.jpg','image',0),(1928,90,'/w/h/wh08-purple_main_1.jpg','image',0),(1929,90,'/w/h/wh08-white_main_1.jpg','image',0),(1930,90,'/w/h/wh08-white_alt1_1.jpg','image',0),(1931,90,'/w/h/wh08-white_alternate_1.jpg','image',0),(1932,90,'/w/h/wh08-white_back_1.jpg','image',0),(1933,90,'/w/h/wh08-orange_main_1.jpg','image',0),(1934,90,'/w/h/wh08-purple_main_1.jpg','image',0),(1935,90,'/w/h/wh08-white_main_1.jpg','image',0),(1936,90,'/w/h/wh08-white_alt1_1.jpg','image',0),(1937,90,'/w/h/wh08-white_alternate_1.jpg','image',0),(1938,90,'/w/h/wh08-white_back_1.jpg','image',0),(1939,90,'/w/h/wh08-orange_main_1.jpg','image',0),(1940,90,'/w/h/wh08-purple_main_1.jpg','image',0),(1941,90,'/w/h/wh08-white_main_1.jpg','image',0),(1942,90,'/w/h/wh08-white_alt1_1.jpg','image',0),(1943,90,'/w/h/wh08-white_alternate_1.jpg','image',0),(1944,90,'/w/h/wh08-white_back_1.jpg','image',0),(1945,90,'/w/h/wh08-white_main_1.jpg','image',0),(1946,90,'/w/h/wh08-white_alt1_1.jpg','image',0),(1947,90,'/w/h/wh08-white_alternate_1.jpg','image',0),(1948,90,'/w/h/wh08-white_back_1.jpg','image',0),(1949,90,'/w/h/wh09-green_main_1.jpg','image',0),(1950,90,'/w/h/wh09-purple_main_1.jpg','image',0),(1951,90,'/w/h/wh09-purple_alt1_1.jpg','image',0),(1952,90,'/w/h/wh09-purple_back_1.jpg','image',0),(1953,90,'/w/h/wh09-red_main_1.jpg','image',0),(1954,90,'/w/h/wh09-green_main_1.jpg','image',0),(1955,90,'/w/h/wh09-purple_main_1.jpg','image',0),(1956,90,'/w/h/wh09-purple_alt1_1.jpg','image',0),(1957,90,'/w/h/wh09-purple_back_1.jpg','image',0),(1958,90,'/w/h/wh09-red_main_1.jpg','image',0),(1959,90,'/w/h/wh09-green_main_1.jpg','image',0),(1960,90,'/w/h/wh09-purple_main_1.jpg','image',0),(1961,90,'/w/h/wh09-purple_alt1_1.jpg','image',0),(1962,90,'/w/h/wh09-purple_back_1.jpg','image',0),(1963,90,'/w/h/wh09-red_main_1.jpg','image',0),(1964,90,'/w/h/wh09-green_main_1.jpg','image',0),(1965,90,'/w/h/wh09-purple_main_1.jpg','image',0),(1966,90,'/w/h/wh09-purple_alt1_1.jpg','image',0),(1967,90,'/w/h/wh09-purple_back_1.jpg','image',0),(1968,90,'/w/h/wh09-red_main_1.jpg','image',0),(1969,90,'/w/h/wh09-green_main_1.jpg','image',0),(1970,90,'/w/h/wh09-purple_main_1.jpg','image',0),(1971,90,'/w/h/wh09-purple_alt1_1.jpg','image',0),(1972,90,'/w/h/wh09-purple_back_1.jpg','image',0),(1973,90,'/w/h/wh09-red_main_1.jpg','image',0),(1974,90,'/w/h/wh09-purple_main_1.jpg','image',0),(1975,90,'/w/h/wh09-purple_alt1_1.jpg','image',0),(1976,90,'/w/h/wh09-purple_back_1.jpg','image',0),(1977,90,'/w/h/wh10-blue_main_1.jpg','image',0),(1978,90,'/w/h/wh10-gray_main_1.jpg','image',0),(1979,90,'/w/h/wh10-gray_alt1_1.jpg','image',0),(1980,90,'/w/h/wh10-gray_back_1.jpg','image',0),(1981,90,'/w/h/wh10-yellow_main_1.jpg','image',0),(1982,90,'/w/h/wh10-blue_main_1.jpg','image',0),(1983,90,'/w/h/wh10-gray_main_1.jpg','image',0),(1984,90,'/w/h/wh10-gray_alt1_1.jpg','image',0),(1985,90,'/w/h/wh10-gray_back_1.jpg','image',0),(1986,90,'/w/h/wh10-yellow_main_1.jpg','image',0),(1987,90,'/w/h/wh10-blue_main_1.jpg','image',0),(1988,90,'/w/h/wh10-gray_main_1.jpg','image',0),(1989,90,'/w/h/wh10-gray_alt1_1.jpg','image',0),(1990,90,'/w/h/wh10-gray_back_1.jpg','image',0),(1991,90,'/w/h/wh10-yellow_main_1.jpg','image',0),(1992,90,'/w/h/wh10-blue_main_1.jpg','image',0),(1993,90,'/w/h/wh10-gray_main_1.jpg','image',0),(1994,90,'/w/h/wh10-gray_alt1_1.jpg','image',0),(1995,90,'/w/h/wh10-gray_back_1.jpg','image',0),(1996,90,'/w/h/wh10-yellow_main_1.jpg','image',0),(1997,90,'/w/h/wh10-blue_main_1.jpg','image',0),(1998,90,'/w/h/wh10-gray_main_1.jpg','image',0),(1999,90,'/w/h/wh10-gray_alt1_1.jpg','image',0),(2000,90,'/w/h/wh10-gray_back_1.jpg','image',0),(2001,90,'/w/h/wh10-yellow_main_1.jpg','image',0),(2002,90,'/w/h/wh10-gray_main_1.jpg','image',0),(2003,90,'/w/h/wh10-gray_alt1_1.jpg','image',0),(2004,90,'/w/h/wh10-gray_back_1.jpg','image',0),(2005,90,'/w/h/wh11-blue_main_1.jpg','image',0),(2006,90,'/w/h/wh11-blue_back_1.jpg','image',0),(2007,90,'/w/h/wh11-green_main_1.jpg','image',0),(2008,90,'/w/h/wh11-orange_main_1.jpg','image',0),(2009,90,'/w/h/wh11-blue_main_1.jpg','image',0),(2010,90,'/w/h/wh11-blue_back_1.jpg','image',0),(2011,90,'/w/h/wh11-green_main_1.jpg','image',0),(2012,90,'/w/h/wh11-orange_main_1.jpg','image',0),(2013,90,'/w/h/wh11-blue_main_1.jpg','image',0),(2014,90,'/w/h/wh11-blue_back_1.jpg','image',0),(2015,90,'/w/h/wh11-green_main_1.jpg','image',0),(2016,90,'/w/h/wh11-orange_main_1.jpg','image',0),(2017,90,'/w/h/wh11-blue_main_1.jpg','image',0),(2018,90,'/w/h/wh11-blue_back_1.jpg','image',0),(2019,90,'/w/h/wh11-green_main_1.jpg','image',0),(2020,90,'/w/h/wh11-orange_main_1.jpg','image',0),(2021,90,'/w/h/wh11-blue_main_1.jpg','image',0),(2022,90,'/w/h/wh11-blue_back_1.jpg','image',0),(2023,90,'/w/h/wh11-green_main_1.jpg','image',0),(2024,90,'/w/h/wh11-orange_main_1.jpg','image',0),(2025,90,'/w/h/wh11-blue_main_1.jpg','image',0),(2026,90,'/w/h/wh11-blue_back_1.jpg','image',0),(2027,90,'/w/h/wh12-gray_main_1.jpg','image',0),(2028,90,'/w/h/wh12-gray_back_1.jpg','image',0),(2029,90,'/w/h/wh12-green_main_1.jpg','image',0),(2030,90,'/w/h/wh12-purple_main_1.jpg','image',0),(2031,90,'/w/h/wh12-gray_main_1.jpg','image',0),(2032,90,'/w/h/wh12-gray_back_1.jpg','image',0),(2033,90,'/w/h/wh12-green_main_1.jpg','image',0),(2034,90,'/w/h/wh12-purple_main_1.jpg','image',0),(2035,90,'/w/h/wh12-gray_main_1.jpg','image',0),(2036,90,'/w/h/wh12-gray_back_1.jpg','image',0),(2037,90,'/w/h/wh12-green_main_1.jpg','image',0),(2038,90,'/w/h/wh12-purple_main_1.jpg','image',0),(2039,90,'/w/h/wh12-gray_main_1.jpg','image',0),(2040,90,'/w/h/wh12-gray_back_1.jpg','image',0),(2041,90,'/w/h/wh12-green_main_1.jpg','image',0),(2042,90,'/w/h/wh12-purple_main_1.jpg','image',0),(2043,90,'/w/h/wh12-gray_main_1.jpg','image',0),(2044,90,'/w/h/wh12-gray_back_1.jpg','image',0),(2045,90,'/w/h/wh12-green_main_1.jpg','image',0),(2046,90,'/w/h/wh12-purple_main_1.jpg','image',0),(2047,90,'/w/h/wh12-gray_main_1.jpg','image',0),(2048,90,'/w/h/wh12-gray_back_1.jpg','image',0),(2049,90,'/w/j/wj01-blue_main_1.jpg','image',0),(2050,90,'/w/j/wj01-red_main_1.jpg','image',0),(2051,90,'/w/j/wj01-red_alt1_1.jpg','image',0),(2052,90,'/w/j/wj01-red_back_1.jpg','image',0),(2053,90,'/w/j/wj01-yellow_main_1.jpg','image',0),(2054,90,'/w/j/wj01-blue_main_1.jpg','image',0),(2055,90,'/w/j/wj01-red_main_1.jpg','image',0),(2056,90,'/w/j/wj01-red_alt1_1.jpg','image',0),(2057,90,'/w/j/wj01-red_back_1.jpg','image',0),(2058,90,'/w/j/wj01-yellow_main_1.jpg','image',0),(2059,90,'/w/j/wj01-blue_main_1.jpg','image',0),(2060,90,'/w/j/wj01-red_main_1.jpg','image',0),(2061,90,'/w/j/wj01-red_alt1_1.jpg','image',0),(2062,90,'/w/j/wj01-red_back_1.jpg','image',0),(2063,90,'/w/j/wj01-yellow_main_1.jpg','image',0),(2064,90,'/w/j/wj01-red_main_1.jpg','image',0),(2065,90,'/w/j/wj01-red_alt1_1.jpg','image',0),(2066,90,'/w/j/wj01-red_back_1.jpg','image',0),(2067,90,'/w/j/wj02-black_main_1.jpg','image',0),(2068,90,'/w/j/wj02-blue_main_1.jpg','image',0),(2069,90,'/w/j/wj02-gray_main_1.jpg','image',0),(2070,90,'/w/j/wj02-gray_alt1_1.jpg','image',0),(2071,90,'/w/j/wj02-gray_back_1.jpg','image',0),(2072,90,'/w/j/wj02-black_main_1.jpg','image',0),(2073,90,'/w/j/wj02-blue_main_1.jpg','image',0),(2074,90,'/w/j/wj02-gray_main_1.jpg','image',0),(2075,90,'/w/j/wj02-gray_alt1_1.jpg','image',0),(2076,90,'/w/j/wj02-gray_back_1.jpg','image',0),(2077,90,'/w/j/wj02-black_main_1.jpg','image',0),(2078,90,'/w/j/wj02-blue_main_1.jpg','image',0),(2079,90,'/w/j/wj02-gray_main_1.jpg','image',0),(2080,90,'/w/j/wj02-gray_alt1_1.jpg','image',0),(2081,90,'/w/j/wj02-gray_back_1.jpg','image',0),(2082,90,'/w/j/wj02-black_main_1.jpg','image',0),(2083,90,'/w/j/wj02-blue_main_1.jpg','image',0),(2084,90,'/w/j/wj02-gray_main_1.jpg','image',0),(2085,90,'/w/j/wj02-gray_alt1_1.jpg','image',0),(2086,90,'/w/j/wj02-gray_back_1.jpg','image',0),(2087,90,'/w/j/wj02-black_main_1.jpg','image',0),(2088,90,'/w/j/wj02-blue_main_1.jpg','image',0),(2089,90,'/w/j/wj02-gray_main_1.jpg','image',0),(2090,90,'/w/j/wj02-gray_alt1_1.jpg','image',0),(2091,90,'/w/j/wj02-gray_back_1.jpg','image',0),(2092,90,'/w/j/wj02-gray_main_1.jpg','image',0),(2093,90,'/w/j/wj02-gray_alt1_1.jpg','image',0),(2094,90,'/w/j/wj02-gray_back_1.jpg','image',0),(2095,90,'/w/j/wj03-blue_main_1.jpg','image',0),(2096,90,'/w/j/wj03-orange_main_1.jpg','image',0),(2097,90,'/w/j/wj03-red_main_1.jpg','image',0),(2098,90,'/w/j/wj03-red_alt1_1.jpg','image',0),(2099,90,'/w/j/wj03-red_back_1.jpg','image',0),(2100,90,'/w/j/wj03-blue_main_1.jpg','image',0),(2101,90,'/w/j/wj03-orange_main_1.jpg','image',0),(2102,90,'/w/j/wj03-red_main_1.jpg','image',0),(2103,90,'/w/j/wj03-red_alt1_1.jpg','image',0),(2104,90,'/w/j/wj03-red_back_1.jpg','image',0),(2105,90,'/w/j/wj03-blue_main_1.jpg','image',0),(2106,90,'/w/j/wj03-orange_main_1.jpg','image',0),(2107,90,'/w/j/wj03-red_main_1.jpg','image',0),(2108,90,'/w/j/wj03-red_alt1_1.jpg','image',0),(2109,90,'/w/j/wj03-red_back_1.jpg','image',0),(2110,90,'/w/j/wj03-blue_main_1.jpg','image',0),(2111,90,'/w/j/wj03-orange_main_2.jpg','image',0),(2112,90,'/w/j/wj03-red_main_2.jpg','image',0),(2113,90,'/w/j/wj03-red_alt1_2.jpg','image',0),(2114,90,'/w/j/wj03-red_back_2.jpg','image',0),(2115,90,'/w/j/wj03-blue_main_2.jpg','image',0),(2116,90,'/w/j/wj03-orange_main_2.jpg','image',0),(2117,90,'/w/j/wj03-red_main_2.jpg','image',0),(2118,90,'/w/j/wj03-red_alt1_2.jpg','image',0),(2119,90,'/w/j/wj03-red_back_2.jpg','image',0),(2120,90,'/w/j/wj03-red_main_2.jpg','image',0),(2121,90,'/w/j/wj03-red_alt1_2.jpg','image',0),(2122,90,'/w/j/wj03-red_back_2.jpg','image',0),(2123,90,'/w/j/wj04-orange_main_1.jpg','image',0),(2124,90,'/w/j/wj04-red_main_1.jpg','image',0),(2125,90,'/w/j/wj04-white_main_1.jpg','image',0),(2126,90,'/w/j/wj04-white_alt1_1.jpg','image',0),(2127,90,'/w/j/wj04-white_alternate_1.jpg','image',0),(2128,90,'/w/j/wj04-white_back_1.jpg','image',0),(2129,90,'/w/j/wj04-orange_main_1.jpg','image',0),(2130,90,'/w/j/wj04-red_main_1.jpg','image',0),(2131,90,'/w/j/wj04-white_main_1.jpg','image',0),(2132,90,'/w/j/wj04-white_alt1_1.jpg','image',0),(2133,90,'/w/j/wj04-white_alternate_1.jpg','image',0),(2134,90,'/w/j/wj04-white_back_1.jpg','image',0),(2135,90,'/w/j/wj04-orange_main_1.jpg','image',0),(2136,90,'/w/j/wj04-red_main_1.jpg','image',0),(2137,90,'/w/j/wj04-white_main_1.jpg','image',0),(2138,90,'/w/j/wj04-white_alt1_1.jpg','image',0),(2139,90,'/w/j/wj04-white_alternate_1.jpg','image',0),(2140,90,'/w/j/wj04-white_back_1.jpg','image',0),(2141,90,'/w/j/wj04-orange_main_1.jpg','image',0),(2142,90,'/w/j/wj04-red_main_1.jpg','image',0),(2143,90,'/w/j/wj04-white_main_1.jpg','image',0),(2144,90,'/w/j/wj04-white_alt1_1.jpg','image',0),(2145,90,'/w/j/wj04-white_alternate_1.jpg','image',0),(2146,90,'/w/j/wj04-white_back_1.jpg','image',0),(2147,90,'/w/j/wj04-orange_main_1.jpg','image',0),(2148,90,'/w/j/wj04-red_main_1.jpg','image',0),(2149,90,'/w/j/wj04-white_main_1.jpg','image',0),(2150,90,'/w/j/wj04-white_alt1_1.jpg','image',0),(2151,90,'/w/j/wj04-white_alternate_1.jpg','image',0),(2152,90,'/w/j/wj04-white_back_1.jpg','image',0),(2153,90,'/w/j/wj04-white_main_1.jpg','image',0),(2154,90,'/w/j/wj04-white_alt1_1.jpg','image',0),(2155,90,'/w/j/wj04-white_alternate_1.jpg','image',0),(2156,90,'/w/j/wj04-white_back_1.jpg','image',0),(2157,90,'/w/j/wj05-brown_main_1.jpg','image',0),(2158,90,'/w/j/wj05-brown_alt1_1.jpg','image',0),(2159,90,'/w/j/wj05-brown_back_1.jpg','image',0),(2160,90,'/w/j/wj05-green_main_1.jpg','image',0),(2161,90,'/w/j/wj05-red_main_1.jpg','image',0),(2162,90,'/w/j/wj05-brown_main_1.jpg','image',0),(2163,90,'/w/j/wj05-brown_alt1_1.jpg','image',0),(2164,90,'/w/j/wj05-brown_back_1.jpg','image',0),(2165,90,'/w/j/wj05-green_main_1.jpg','image',0),(2166,90,'/w/j/wj05-red_main_1.jpg','image',0),(2167,90,'/w/j/wj05-brown_main_1.jpg','image',0),(2168,90,'/w/j/wj05-brown_alt1_1.jpg','image',0),(2169,90,'/w/j/wj05-brown_back_1.jpg','image',0),(2170,90,'/w/j/wj05-green_main_1.jpg','image',0),(2171,90,'/w/j/wj05-red_main_1.jpg','image',0),(2172,90,'/w/j/wj05-brown_main_1.jpg','image',0),(2173,90,'/w/j/wj05-brown_alt1_1.jpg','image',0),(2174,90,'/w/j/wj05-brown_back_1.jpg','image',0),(2175,90,'/w/j/wj05-green_main_1.jpg','image',0),(2176,90,'/w/j/wj05-red_main_1.jpg','image',0),(2177,90,'/w/j/wj05-brown_main_1.jpg','image',0),(2178,90,'/w/j/wj05-brown_alt1_1.jpg','image',0),(2179,90,'/w/j/wj05-brown_back_1.jpg','image',0),(2180,90,'/w/j/wj05-green_main_1.jpg','image',0),(2181,90,'/w/j/wj05-red_main_1.jpg','image',0),(2182,90,'/w/j/wj05-brown_main_1.jpg','image',0),(2183,90,'/w/j/wj05-brown_alt1_1.jpg','image',0),(2184,90,'/w/j/wj05-brown_back_1.jpg','image',0),(2185,90,'/w/j/wj07-orange_main_1.jpg','image',0),(2186,90,'/w/j/wj07-purple_main_1.jpg','image',0),(2187,90,'/w/j/wj07-purple_alt1_1.jpg','image',0),(2188,90,'/w/j/wj07-purple_back_1.jpg','image',0),(2189,90,'/w/j/wj07-red_main_1.jpg','image',0),(2190,90,'/w/j/wj07-orange_main_1.jpg','image',0),(2191,90,'/w/j/wj07-purple_main_1.jpg','image',0),(2192,90,'/w/j/wj07-purple_alt1_1.jpg','image',0),(2193,90,'/w/j/wj07-purple_back_1.jpg','image',0),(2194,90,'/w/j/wj07-red_main_1.jpg','image',0),(2195,90,'/w/j/wj07-orange_main_1.jpg','image',0),(2196,90,'/w/j/wj07-purple_main_1.jpg','image',0),(2197,90,'/w/j/wj07-purple_alt1_1.jpg','image',0),(2198,90,'/w/j/wj07-purple_back_1.jpg','image',0),(2199,90,'/w/j/wj07-red_main_1.jpg','image',0),(2200,90,'/w/j/wj07-orange_main_1.jpg','image',0),(2201,90,'/w/j/wj07-purple_main_1.jpg','image',0),(2202,90,'/w/j/wj07-purple_alt1_1.jpg','image',0),(2203,90,'/w/j/wj07-purple_back_1.jpg','image',0),(2204,90,'/w/j/wj07-red_main_1.jpg','image',0),(2205,90,'/w/j/wj07-orange_main_1.jpg','image',0),(2206,90,'/w/j/wj07-purple_main_1.jpg','image',0),(2207,90,'/w/j/wj07-purple_alt1_1.jpg','image',0),(2208,90,'/w/j/wj07-purple_back_1.jpg','image',0),(2209,90,'/w/j/wj07-red_main_1.jpg','image',0),(2210,90,'/w/j/wj07-purple_main_1.jpg','image',0),(2211,90,'/w/j/wj07-purple_alt1_1.jpg','image',0),(2212,90,'/w/j/wj07-purple_back_1.jpg','image',0),(2213,90,'/w/j/wj08-gray_main_1.jpg','image',0),(2214,90,'/w/j/wj08-gray_alt1_1.jpg','image',0),(2215,90,'/w/j/wj08-gray_alternate_1.jpg','image',0),(2216,90,'/w/j/wj08-gray_back_1.jpg','image',0),(2217,90,'/w/j/wj08-orange_main_1.jpg','image',0),(2218,90,'/w/j/wj08-purple_main_1.jpg','image',0),(2219,90,'/w/j/wj08-gray_main_1.jpg','image',0),(2220,90,'/w/j/wj08-gray_alt1_1.jpg','image',0),(2221,90,'/w/j/wj08-gray_alternate_1.jpg','image',0),(2222,90,'/w/j/wj08-gray_back_1.jpg','image',0),(2223,90,'/w/j/wj08-orange_main_1.jpg','image',0),(2224,90,'/w/j/wj08-purple_main_1.jpg','image',0),(2225,90,'/w/j/wj08-gray_main_1.jpg','image',0),(2226,90,'/w/j/wj08-gray_alt1_1.jpg','image',0),(2227,90,'/w/j/wj08-gray_alternate_1.jpg','image',0),(2228,90,'/w/j/wj08-gray_back_1.jpg','image',0),(2229,90,'/w/j/wj08-orange_main_1.jpg','image',0),(2230,90,'/w/j/wj08-purple_main_1.jpg','image',0),(2231,90,'/w/j/wj08-gray_main_1.jpg','image',0),(2232,90,'/w/j/wj08-gray_alt1_1.jpg','image',0),(2233,90,'/w/j/wj08-gray_alternate_1.jpg','image',0),(2234,90,'/w/j/wj08-gray_back_1.jpg','image',0),(2235,90,'/w/j/wj08-orange_main_1.jpg','image',0),(2236,90,'/w/j/wj08-purple_main_1.jpg','image',0),(2237,90,'/w/j/wj08-gray_main_1.jpg','image',0),(2238,90,'/w/j/wj08-gray_alt1_1.jpg','image',0),(2239,90,'/w/j/wj08-gray_alternate_1.jpg','image',0),(2240,90,'/w/j/wj08-gray_back_1.jpg','image',0),(2241,90,'/w/j/wj08-orange_main_1.jpg','image',0),(2242,90,'/w/j/wj08-purple_main_1.jpg','image',0),(2243,90,'/w/j/wj08-gray_main_1.jpg','image',0),(2244,90,'/w/j/wj08-gray_alt1_1.jpg','image',0),(2245,90,'/w/j/wj08-gray_alternate_1.jpg','image',0),(2246,90,'/w/j/wj08-gray_back_1.jpg','image',0),(2247,90,'/w/j/wj09-blue_main_1.jpg','image',0),(2248,90,'/w/j/wj09-gray_main_1.jpg','image',0),(2249,90,'/w/j/wj09-green_main_1.jpg','image',0),(2250,90,'/w/j/wj09-green_alt1_1.jpg','image',0),(2251,90,'/w/j/wj09-green_back_1.jpg','image',0),(2252,90,'/w/j/wj09-blue_main_1.jpg','image',0),(2253,90,'/w/j/wj09-gray_main_1.jpg','image',0),(2254,90,'/w/j/wj09-green_main_1.jpg','image',0),(2255,90,'/w/j/wj09-green_alt1_1.jpg','image',0),(2256,90,'/w/j/wj09-green_back_1.jpg','image',0),(2257,90,'/w/j/wj09-blue_main_1.jpg','image',0),(2258,90,'/w/j/wj09-gray_main_1.jpg','image',0),(2259,90,'/w/j/wj09-green_main_1.jpg','image',0),(2260,90,'/w/j/wj09-green_alt1_1.jpg','image',0),(2261,90,'/w/j/wj09-green_back_1.jpg','image',0),(2262,90,'/w/j/wj09-blue_main_1.jpg','image',0),(2263,90,'/w/j/wj09-gray_main_1.jpg','image',0),(2264,90,'/w/j/wj09-green_main_1.jpg','image',0),(2265,90,'/w/j/wj09-green_alt1_1.jpg','image',0),(2266,90,'/w/j/wj09-green_back_1.jpg','image',0),(2267,90,'/w/j/wj09-blue_main_1.jpg','image',0),(2268,90,'/w/j/wj09-gray_main_1.jpg','image',0),(2269,90,'/w/j/wj09-green_main_1.jpg','image',0),(2270,90,'/w/j/wj09-green_alt1_1.jpg','image',0),(2271,90,'/w/j/wj09-green_back_1.jpg','image',0),(2272,90,'/w/j/wj09-green_main_1.jpg','image',0),(2273,90,'/w/j/wj09-green_alt1_1.jpg','image',0),(2274,90,'/w/j/wj09-green_back_1.jpg','image',0),(2275,90,'/w/j/wj10-black_main_1.jpg','image',0),(2276,90,'/w/j/wj10-orange_main_1.jpg','image',0),(2277,90,'/w/j/wj10-yellow_main_1.jpg','image',0),(2278,90,'/w/j/wj10-yellow_alt1_1.jpg','image',0),(2279,90,'/w/j/wj10-yellow_back_1.jpg','image',0),(2280,90,'/w/j/wj10-black_main_1.jpg','image',0),(2281,90,'/w/j/wj10-orange_main_1.jpg','image',0),(2282,90,'/w/j/wj10-yellow_main_1.jpg','image',0),(2283,90,'/w/j/wj10-yellow_alt1_1.jpg','image',0),(2284,90,'/w/j/wj10-yellow_back_1.jpg','image',0),(2285,90,'/w/j/wj10-black_main_1.jpg','image',0),(2286,90,'/w/j/wj10-orange_main_1.jpg','image',0),(2287,90,'/w/j/wj10-yellow_main_1.jpg','image',0),(2288,90,'/w/j/wj10-yellow_alt1_1.jpg','image',0),(2289,90,'/w/j/wj10-yellow_back_1.jpg','image',0),(2290,90,'/w/j/wj10-black_main_1.jpg','image',0),(2291,90,'/w/j/wj10-orange_main_1.jpg','image',0),(2292,90,'/w/j/wj10-yellow_main_1.jpg','image',0),(2293,90,'/w/j/wj10-yellow_alt1_1.jpg','image',0),(2294,90,'/w/j/wj10-yellow_back_1.jpg','image',0),(2295,90,'/w/j/wj10-black_main_1.jpg','image',0),(2296,90,'/w/j/wj10-orange_main_1.jpg','image',0),(2297,90,'/w/j/wj10-yellow_main_2.jpg','image',0),(2298,90,'/w/j/wj10-yellow_alt1_2.jpg','image',0),(2299,90,'/w/j/wj10-yellow_back_2.jpg','image',0),(2300,90,'/w/j/wj10-yellow_main_2.jpg','image',0),(2301,90,'/w/j/wj10-yellow_alt1_2.jpg','image',0),(2302,90,'/w/j/wj10-yellow_back_2.jpg','image',0),(2303,90,'/w/j/wj11-black_main_1.jpg','image',0),(2304,90,'/w/j/wj11-blue_main_1.jpg','image',0),(2305,90,'/w/j/wj11-blue_alt1_1.jpg','image',0),(2306,90,'/w/j/wj11-blue_back_1.jpg','image',0),(2307,90,'/w/j/wj11-orange_main_1.jpg','image',0),(2308,90,'/w/j/wj11-black_main_1.jpg','image',0),(2309,90,'/w/j/wj11-blue_main_1.jpg','image',0),(2310,90,'/w/j/wj11-blue_alt1_1.jpg','image',0),(2311,90,'/w/j/wj11-blue_back_1.jpg','image',0),(2312,90,'/w/j/wj11-orange_main_1.jpg','image',0),(2313,90,'/w/j/wj11-black_main_1.jpg','image',0),(2314,90,'/w/j/wj11-blue_main_1.jpg','image',0),(2315,90,'/w/j/wj11-blue_alt1_1.jpg','image',0),(2316,90,'/w/j/wj11-blue_back_1.jpg','image',0),(2317,90,'/w/j/wj11-orange_main_1.jpg','image',0),(2318,90,'/w/j/wj11-black_main_1.jpg','image',0),(2319,90,'/w/j/wj11-blue_main_1.jpg','image',0),(2320,90,'/w/j/wj11-blue_alt1_1.jpg','image',0),(2321,90,'/w/j/wj11-blue_back_1.jpg','image',0),(2322,90,'/w/j/wj11-orange_main_1.jpg','image',0),(2323,90,'/w/j/wj11-black_main_1.jpg','image',0),(2324,90,'/w/j/wj11-blue_main_1.jpg','image',0),(2325,90,'/w/j/wj11-blue_alt1_1.jpg','image',0),(2326,90,'/w/j/wj11-blue_back_1.jpg','image',0),(2327,90,'/w/j/wj11-orange_main_1.jpg','image',0),(2328,90,'/w/j/wj11-blue_main_1.jpg','image',0),(2329,90,'/w/j/wj11-blue_alt1_1.jpg','image',0),(2330,90,'/w/j/wj11-blue_back_1.jpg','image',0),(2331,90,'/w/j/wj06-blue_main_1.jpg','image',0),(2332,90,'/w/j/wj06-green_main_1.jpg','image',0),(2333,90,'/w/j/wj06-purple_main_1.jpg','image',0),(2334,90,'/w/j/wj06-purple_alt1_1.jpg','image',0),(2335,90,'/w/j/wj06-purple_back_1.jpg','image',0),(2336,90,'/w/j/wj06-blue_main_1.jpg','image',0),(2337,90,'/w/j/wj06-green_main_1.jpg','image',0),(2338,90,'/w/j/wj06-purple_main_1.jpg','image',0),(2339,90,'/w/j/wj06-purple_alt1_1.jpg','image',0),(2340,90,'/w/j/wj06-purple_back_1.jpg','image',0),(2341,90,'/w/j/wj06-blue_main_1.jpg','image',0),(2342,90,'/w/j/wj06-green_main_1.jpg','image',0),(2343,90,'/w/j/wj06-purple_main_1.jpg','image',0),(2344,90,'/w/j/wj06-purple_alt1_1.jpg','image',0),(2345,90,'/w/j/wj06-purple_back_1.jpg','image',0),(2346,90,'/w/j/wj06-blue_main_1.jpg','image',0),(2347,90,'/w/j/wj06-green_main_1.jpg','image',0),(2348,90,'/w/j/wj06-purple_main_1.jpg','image',0),(2349,90,'/w/j/wj06-purple_alt1_1.jpg','image',0),(2350,90,'/w/j/wj06-purple_back_1.jpg','image',0),(2351,90,'/w/j/wj06-blue_main_1.jpg','image',0),(2352,90,'/w/j/wj06-green_main_1.jpg','image',0),(2353,90,'/w/j/wj06-purple_main_1.jpg','image',0),(2354,90,'/w/j/wj06-purple_alt1_1.jpg','image',0),(2355,90,'/w/j/wj06-purple_back_1.jpg','image',0),(2356,90,'/w/j/wj06-purple_main_1.jpg','image',0),(2357,90,'/w/j/wj06-purple_alt1_1.jpg','image',0),(2358,90,'/w/j/wj06-purple_back_1.jpg','image',0),(2359,90,'/w/j/wj12-black_main_1.jpg','image',0),(2360,90,'/w/j/wj12-blue_main_1.jpg','image',0),(2361,90,'/w/j/wj12-blue_alt1_1.jpg','image',0),(2362,90,'/w/j/wj12-blue_back_1.jpg','image',0),(2363,90,'/w/j/wj12-purple_main_1.jpg','image',0),(2364,90,'/w/j/wj12-black_main_1.jpg','image',0),(2365,90,'/w/j/wj12-blue_main_1.jpg','image',0),(2366,90,'/w/j/wj12-blue_alt1_1.jpg','image',0),(2367,90,'/w/j/wj12-blue_back_1.jpg','image',0),(2368,90,'/w/j/wj12-purple_main_1.jpg','image',0),(2369,90,'/w/j/wj12-black_main_1.jpg','image',0),(2370,90,'/w/j/wj12-blue_main_1.jpg','image',0),(2371,90,'/w/j/wj12-blue_alt1_1.jpg','image',0),(2372,90,'/w/j/wj12-blue_back_1.jpg','image',0),(2373,90,'/w/j/wj12-purple_main_1.jpg','image',0),(2374,90,'/w/j/wj12-black_main_1.jpg','image',0),(2375,90,'/w/j/wj12-blue_main_1.jpg','image',0),(2376,90,'/w/j/wj12-blue_alt1_1.jpg','image',0),(2377,90,'/w/j/wj12-blue_back_1.jpg','image',0),(2378,90,'/w/j/wj12-purple_main_1.jpg','image',0),(2379,90,'/w/j/wj12-black_main_1.jpg','image',0),(2380,90,'/w/j/wj12-blue_main_1.jpg','image',0),(2381,90,'/w/j/wj12-blue_alt1_1.jpg','image',0),(2382,90,'/w/j/wj12-blue_back_1.jpg','image',0),(2383,90,'/w/j/wj12-purple_main_1.jpg','image',0),(2384,90,'/w/j/wj12-blue_main_1.jpg','image',0),(2385,90,'/w/j/wj12-blue_alt1_1.jpg','image',0),(2386,90,'/w/j/wj12-blue_back_1.jpg','image',0),(2387,90,'/w/s/ws02-blue_main_1.jpg','image',0),(2388,90,'/w/s/ws02-green_main_1.jpg','image',0),(2389,90,'/w/s/ws02-green_back_1.jpg','image',0),(2390,90,'/w/s/ws02-red_main_1.jpg','image',0),(2391,90,'/w/s/ws02-blue_main_1.jpg','image',0),(2392,90,'/w/s/ws02-green_main_1.jpg','image',0),(2393,90,'/w/s/ws02-green_back_1.jpg','image',0),(2394,90,'/w/s/ws02-red_main_1.jpg','image',0),(2395,90,'/w/s/ws02-blue_main_1.jpg','image',0),(2396,90,'/w/s/ws02-green_main_1.jpg','image',0),(2397,90,'/w/s/ws02-green_back_1.jpg','image',0),(2398,90,'/w/s/ws02-red_main_1.jpg','image',0),(2399,90,'/w/s/ws02-blue_main_1.jpg','image',0),(2400,90,'/w/s/ws02-green_main_1.jpg','image',0),(2401,90,'/w/s/ws02-green_back_1.jpg','image',0),(2402,90,'/w/s/ws02-red_main_1.jpg','image',0),(2403,90,'/w/s/ws02-blue_main_1.jpg','image',0),(2404,90,'/w/s/ws02-green_main_1.jpg','image',0),(2405,90,'/w/s/ws02-green_back_1.jpg','image',0),(2406,90,'/w/s/ws02-red_main_1.jpg','image',0),(2407,90,'/w/s/ws02-green_main_1.jpg','image',0),(2408,90,'/w/s/ws02-green_back_1.jpg','image',0),(2409,90,'/w/s/ws03-blue_main_1.jpg','image',0),(2410,90,'/w/s/ws03-green_main_1.jpg','image',0),(2411,90,'/w/s/ws03-red_main_1.jpg','image',0),(2412,90,'/w/s/ws03-red_alt1_1.jpg','image',0),(2413,90,'/w/s/ws03-red_back_1.jpg','image',0),(2414,90,'/w/s/ws03-blue_main_1.jpg','image',0),(2415,90,'/w/s/ws03-green_main_1.jpg','image',0),(2416,90,'/w/s/ws03-red_main_1.jpg','image',0),(2417,90,'/w/s/ws03-red_alt1_1.jpg','image',0),(2418,90,'/w/s/ws03-red_back_1.jpg','image',0),(2419,90,'/w/s/ws03-blue_main_1.jpg','image',0),(2420,90,'/w/s/ws03-green_main_1.jpg','image',0),(2421,90,'/w/s/ws03-red_main_1.jpg','image',0),(2422,90,'/w/s/ws03-red_alt1_1.jpg','image',0),(2423,90,'/w/s/ws03-red_back_1.jpg','image',0),(2424,90,'/w/s/ws03-blue_main_1.jpg','image',0),(2425,90,'/w/s/ws03-green_main_1.jpg','image',0),(2426,90,'/w/s/ws03-red_main_1.jpg','image',0),(2427,90,'/w/s/ws03-red_alt1_1.jpg','image',0),(2428,90,'/w/s/ws03-red_back_1.jpg','image',0),(2429,90,'/w/s/ws03-blue_main_1.jpg','image',0),(2430,90,'/w/s/ws03-green_main_1.jpg','image',0),(2431,90,'/w/s/ws03-red_main_1.jpg','image',0),(2432,90,'/w/s/ws03-red_alt1_1.jpg','image',0),(2433,90,'/w/s/ws03-red_back_1.jpg','image',0),(2434,90,'/w/s/ws03-red_main_1.jpg','image',0),(2435,90,'/w/s/ws03-red_alt1_1.jpg','image',0),(2436,90,'/w/s/ws03-red_back_1.jpg','image',0),(2437,90,'/w/s/ws04-blue_main_1.jpg','image',0),(2438,90,'/w/s/ws04-green_main_1.jpg','image',0),(2439,90,'/w/s/ws04-green_back_1.jpg','image',0),(2440,90,'/w/s/ws04-red_main_1.jpg','image',0),(2441,90,'/w/s/ws04-blue_main_1.jpg','image',0),(2442,90,'/w/s/ws04-green_main_1.jpg','image',0),(2443,90,'/w/s/ws04-green_back_1.jpg','image',0),(2444,90,'/w/s/ws04-red_main_1.jpg','image',0),(2445,90,'/w/s/ws04-blue_main_1.jpg','image',0),(2446,90,'/w/s/ws04-green_main_1.jpg','image',0),(2447,90,'/w/s/ws04-green_back_1.jpg','image',0),(2448,90,'/w/s/ws04-red_main_1.jpg','image',0),(2449,90,'/w/s/ws04-blue_main_1.jpg','image',0),(2450,90,'/w/s/ws04-green_main_1.jpg','image',0),(2451,90,'/w/s/ws04-green_back_1.jpg','image',0),(2452,90,'/w/s/ws04-red_main_1.jpg','image',0),(2453,90,'/w/s/ws04-blue_main_1.jpg','image',0),(2454,90,'/w/s/ws04-green_main_1.jpg','image',0),(2455,90,'/w/s/ws04-green_back_1.jpg','image',0),(2456,90,'/w/s/ws04-red_main_1.jpg','image',0),(2457,90,'/w/s/ws04-green_main_1.jpg','image',0),(2458,90,'/w/s/ws04-green_back_1.jpg','image',0),(2459,90,'/w/s/ws06-gray_main_1.jpg','image',0),(2460,90,'/w/s/ws06-purple_main_1.jpg','image',0),(2461,90,'/w/s/ws06-purple_back_1.jpg','image',0),(2462,90,'/w/s/ws06-red_main_1.jpg','image',0),(2463,90,'/w/s/ws06-gray_main_2.jpg','image',0),(2464,90,'/w/s/ws06-purple_main_2.jpg','image',0),(2465,90,'/w/s/ws06-purple_back_2.jpg','image',0),(2466,90,'/w/s/ws06-red_main_1.jpg','image',0),(2467,90,'/w/s/ws06-gray_main_2.jpg','image',0),(2468,90,'/w/s/ws06-purple_main_2.jpg','image',0),(2469,90,'/w/s/ws06-purple_back_2.jpg','image',0),(2470,90,'/w/s/ws06-red_main_1.jpg','image',0),(2471,90,'/w/s/ws06-gray_main_2.jpg','image',0),(2472,90,'/w/s/ws06-purple_main_2.jpg','image',0),(2473,90,'/w/s/ws06-purple_back_2.jpg','image',0),(2474,90,'/w/s/ws06-red_main_1.jpg','image',0),(2475,90,'/w/s/ws06-gray_main_2.jpg','image',0),(2476,90,'/w/s/ws06-purple_main_2.jpg','image',0),(2477,90,'/w/s/ws06-purple_back_2.jpg','image',0),(2478,90,'/w/s/ws06-red_main_1.jpg','image',0),(2479,90,'/w/s/ws06-purple_main_2.jpg','image',0),(2480,90,'/w/s/ws06-purple_back_2.jpg','image',0),(2481,90,'/w/s/ws07-black_main_1.jpg','image',0),(2482,90,'/w/s/ws07-black_alt1_1.jpg','image',0),(2483,90,'/w/s/ws07-black_back_1.jpg','image',0),(2484,90,'/w/s/ws07-white_main_1.jpg','image',0),(2485,90,'/w/s/ws07-yellow_main_1.jpg','image',0),(2486,90,'/w/s/ws07-black_main_1.jpg','image',0),(2487,90,'/w/s/ws07-black_alt1_1.jpg','image',0),(2488,90,'/w/s/ws07-black_back_1.jpg','image',0),(2489,90,'/w/s/ws07-white_main_1.jpg','image',0),(2490,90,'/w/s/ws07-yellow_main_1.jpg','image',0),(2491,90,'/w/s/ws07-black_main_1.jpg','image',0),(2492,90,'/w/s/ws07-black_alt1_1.jpg','image',0),(2493,90,'/w/s/ws07-black_back_1.jpg','image',0),(2494,90,'/w/s/ws07-white_main_1.jpg','image',0),(2495,90,'/w/s/ws07-yellow_main_1.jpg','image',0),(2496,90,'/w/s/ws07-black_main_1.jpg','image',0),(2497,90,'/w/s/ws07-black_alt1_1.jpg','image',0),(2498,90,'/w/s/ws07-black_back_1.jpg','image',0),(2499,90,'/w/s/ws07-white_main_1.jpg','image',0),(2500,90,'/w/s/ws07-yellow_main_1.jpg','image',0),(2501,90,'/w/s/ws07-black_main_1.jpg','image',0),(2502,90,'/w/s/ws07-black_alt1_1.jpg','image',0),(2503,90,'/w/s/ws07-black_back_1.jpg','image',0),(2504,90,'/w/s/ws07-white_main_1.jpg','image',0),(2505,90,'/w/s/ws07-yellow_main_1.jpg','image',0),(2506,90,'/w/s/ws07-black_main_1.jpg','image',0),(2507,90,'/w/s/ws07-black_alt1_1.jpg','image',0),(2508,90,'/w/s/ws07-black_back_1.jpg','image',0),(2509,90,'/w/s/ws08-black_main_1.jpg','image',0),(2510,90,'/w/s/ws08-blue_main_1.jpg','image',0),(2511,90,'/w/s/ws08-blue_back_1.jpg','image',0),(2512,90,'/w/s/ws08-red_main_1.jpg','image',0),(2513,90,'/w/s/ws08-black_main_1.jpg','image',0),(2514,90,'/w/s/ws08-blue_main_1.jpg','image',0),(2515,90,'/w/s/ws08-blue_back_1.jpg','image',0),(2516,90,'/w/s/ws08-red_main_1.jpg','image',0),(2517,90,'/w/s/ws08-black_main_1.jpg','image',0),(2518,90,'/w/s/ws08-blue_main_1.jpg','image',0),(2519,90,'/w/s/ws08-blue_back_1.jpg','image',0),(2520,90,'/w/s/ws08-red_main_1.jpg','image',0),(2521,90,'/w/s/ws08-black_main_1.jpg','image',0),(2522,90,'/w/s/ws08-blue_main_1.jpg','image',0),(2523,90,'/w/s/ws08-blue_back_1.jpg','image',0),(2524,90,'/w/s/ws08-red_main_1.jpg','image',0),(2525,90,'/w/s/ws08-black_main_1.jpg','image',0),(2526,90,'/w/s/ws08-blue_main_1.jpg','image',0),(2527,90,'/w/s/ws08-blue_back_1.jpg','image',0),(2528,90,'/w/s/ws08-red_main_1.jpg','image',0),(2529,90,'/w/s/ws08-blue_main_1.jpg','image',0),(2530,90,'/w/s/ws08-blue_back_1.jpg','image',0),(2531,90,'/w/s/ws09-blue_main_1.jpg','image',0),(2532,90,'/w/s/ws09-blue_back_1.jpg','image',0),(2533,90,'/w/s/ws09-red_main_1.jpg','image',0),(2534,90,'/w/s/ws09-white_main_1.jpg','image',0),(2535,90,'/w/s/ws09-blue_main_1.jpg','image',0),(2536,90,'/w/s/ws09-blue_back_1.jpg','image',0),(2537,90,'/w/s/ws09-red_main_1.jpg','image',0),(2538,90,'/w/s/ws09-white_main_1.jpg','image',0),(2539,90,'/w/s/ws09-blue_main_1.jpg','image',0),(2540,90,'/w/s/ws09-blue_back_1.jpg','image',0),(2541,90,'/w/s/ws09-red_main_1.jpg','image',0),(2542,90,'/w/s/ws09-white_main_1.jpg','image',0),(2543,90,'/w/s/ws09-blue_main_1.jpg','image',0),(2544,90,'/w/s/ws09-blue_back_1.jpg','image',0),(2545,90,'/w/s/ws09-red_main_1.jpg','image',0),(2546,90,'/w/s/ws09-white_main_1.jpg','image',0),(2547,90,'/w/s/ws09-blue_main_1.jpg','image',0),(2548,90,'/w/s/ws09-blue_back_1.jpg','image',0),(2549,90,'/w/s/ws09-red_main_1.jpg','image',0),(2550,90,'/w/s/ws09-white_main_1.jpg','image',0),(2551,90,'/w/s/ws09-blue_main_1.jpg','image',0),(2552,90,'/w/s/ws09-blue_back_1.jpg','image',0),(2553,90,'/w/s/ws10-green_main_1.jpg','image',0),(2554,90,'/w/s/ws10-red_main_1.jpg','image',0),(2555,90,'/w/s/ws10-red_back_1.jpg','image',0),(2556,90,'/w/s/ws10-yellow_main_1.jpg','image',0),(2557,90,'/w/s/ws10-green_main_1.jpg','image',0),(2558,90,'/w/s/ws10-red_main_1.jpg','image',0),(2559,90,'/w/s/ws10-red_back_1.jpg','image',0),(2560,90,'/w/s/ws10-yellow_main_1.jpg','image',0),(2561,90,'/w/s/ws10-green_main_1.jpg','image',0),(2562,90,'/w/s/ws10-red_main_1.jpg','image',0),(2563,90,'/w/s/ws10-red_back_1.jpg','image',0),(2564,90,'/w/s/ws10-yellow_main_1.jpg','image',0),(2565,90,'/w/s/ws10-green_main_1.jpg','image',0),(2566,90,'/w/s/ws10-red_main_1.jpg','image',0),(2567,90,'/w/s/ws10-red_back_1.jpg','image',0),(2568,90,'/w/s/ws10-yellow_main_1.jpg','image',0),(2569,90,'/w/s/ws10-green_main_1.jpg','image',0),(2570,90,'/w/s/ws10-red_main_1.jpg','image',0),(2571,90,'/w/s/ws10-red_back_1.jpg','image',0),(2572,90,'/w/s/ws10-yellow_main_1.jpg','image',0),(2573,90,'/w/s/ws10-red_main_1.jpg','image',0),(2574,90,'/w/s/ws10-red_back_1.jpg','image',0),(2575,90,'/w/s/ws11-green_main_1.jpg','image',0),(2576,90,'/w/s/ws11-orange_main_1.jpg','image',0),(2577,90,'/w/s/ws11-yellow_main_1.jpg','image',0),(2578,90,'/w/s/ws11-yellow_back_1.jpg','image',0),(2579,90,'/w/s/ws11-green_main_1.jpg','image',0),(2580,90,'/w/s/ws11-orange_main_1.jpg','image',0),(2581,90,'/w/s/ws11-yellow_main_1.jpg','image',0),(2582,90,'/w/s/ws11-yellow_back_1.jpg','image',0),(2583,90,'/w/s/ws11-green_main_1.jpg','image',0),(2584,90,'/w/s/ws11-orange_main_1.jpg','image',0),(2585,90,'/w/s/ws11-yellow_main_1.jpg','image',0),(2586,90,'/w/s/ws11-yellow_back_1.jpg','image',0),(2587,90,'/w/s/ws11-green_main_1.jpg','image',0),(2588,90,'/w/s/ws11-orange_main_1.jpg','image',0),(2589,90,'/w/s/ws11-yellow_main_1.jpg','image',0),(2590,90,'/w/s/ws11-yellow_back_1.jpg','image',0),(2591,90,'/w/s/ws11-green_main_1.jpg','image',0),(2592,90,'/w/s/ws11-orange_main_1.jpg','image',0),(2593,90,'/w/s/ws11-yellow_main_1.jpg','image',0),(2594,90,'/w/s/ws11-yellow_back_1.jpg','image',0),(2595,90,'/w/s/ws11-yellow_main_1.jpg','image',0),(2596,90,'/w/s/ws11-yellow_back_1.jpg','image',0),(2597,90,'/w/s/ws12-blue_main_1.jpg','image',0),(2598,90,'/w/s/ws12-orange_main_1.jpg','image',0),(2599,90,'/w/s/ws12-orange_back_1.jpg','image',0),(2600,90,'/w/s/ws12-purple_main_1.jpg','image',0),(2601,90,'/w/s/ws12-blue_main_1.jpg','image',0),(2602,90,'/w/s/ws12-orange_main_1.jpg','image',0),(2603,90,'/w/s/ws12-orange_back_1.jpg','image',0),(2604,90,'/w/s/ws12-purple_main_1.jpg','image',0),(2605,90,'/w/s/ws12-blue_main_2.jpg','image',0),(2606,90,'/w/s/ws12-orange_main_2.jpg','image',0),(2607,90,'/w/s/ws12-orange_back_2.jpg','image',0),(2608,90,'/w/s/ws12-purple_main_2.jpg','image',0),(2609,90,'/w/s/ws12-blue_main_2.jpg','image',0),(2610,90,'/w/s/ws12-orange_main_2.jpg','image',0),(2611,90,'/w/s/ws12-orange_back_2.jpg','image',0),(2612,90,'/w/s/ws12-purple_main_2.jpg','image',0),(2613,90,'/w/s/ws12-blue_main_2.jpg','image',0),(2614,90,'/w/s/ws12-orange_main_2.jpg','image',0),(2615,90,'/w/s/ws12-orange_back_2.jpg','image',0),(2616,90,'/w/s/ws12-purple_main_2.jpg','image',0),(2617,90,'/w/s/ws12-orange_main_2.jpg','image',0),(2618,90,'/w/s/ws12-orange_back_2.jpg','image',0),(2619,90,'/w/s/ws01-black_main_1.jpg','image',0),(2620,90,'/w/s/ws01-black_back_1.jpg','image',0),(2621,90,'/w/s/ws01-green_main_1.jpg','image',0),(2622,90,'/w/s/ws01-yellow_main_1.jpg','image',0),(2623,90,'/w/s/ws01-black_main_1.jpg','image',0),(2624,90,'/w/s/ws01-black_back_1.jpg','image',0),(2625,90,'/w/s/ws01-green_main_1.jpg','image',0),(2626,90,'/w/s/ws01-yellow_main_1.jpg','image',0),(2627,90,'/w/s/ws01-black_main_1.jpg','image',0),(2628,90,'/w/s/ws01-black_back_1.jpg','image',0),(2629,90,'/w/s/ws01-green_main_1.jpg','image',0),(2630,90,'/w/s/ws01-yellow_main_1.jpg','image',0),(2631,90,'/w/s/ws01-black_main_1.jpg','image',0),(2632,90,'/w/s/ws01-black_back_1.jpg','image',0),(2633,90,'/w/s/ws01-green_main_1.jpg','image',0),(2634,90,'/w/s/ws01-yellow_main_1.jpg','image',0),(2635,90,'/w/s/ws01-black_main_1.jpg','image',0),(2636,90,'/w/s/ws01-black_back_1.jpg','image',0),(2637,90,'/w/s/ws01-green_main_1.jpg','image',0),(2638,90,'/w/s/ws01-yellow_main_1.jpg','image',0),(2639,90,'/w/s/ws01-black_main_1.jpg','image',0),(2640,90,'/w/s/ws01-black_back_1.jpg','image',0),(2641,90,'/w/s/ws05-black_main_1.jpg','image',0),(2642,90,'/w/s/ws05-black_alt1_1.jpg','image',0),(2643,90,'/w/s/ws05-black_back_1.jpg','image',0),(2644,90,'/w/s/ws05-orange_main_1.jpg','image',0),(2645,90,'/w/s/ws05-yellow_main_1.jpg','image',0),(2646,90,'/w/s/ws05-black_main_1.jpg','image',0),(2647,90,'/w/s/ws05-black_alt1_1.jpg','image',0),(2648,90,'/w/s/ws05-black_back_1.jpg','image',0),(2649,90,'/w/s/ws05-orange_main_1.jpg','image',0),(2650,90,'/w/s/ws05-yellow_main_1.jpg','image',0),(2651,90,'/w/s/ws05-black_main_1.jpg','image',0),(2652,90,'/w/s/ws05-black_alt1_1.jpg','image',0),(2653,90,'/w/s/ws05-black_back_1.jpg','image',0),(2654,90,'/w/s/ws05-orange_main_1.jpg','image',0),(2655,90,'/w/s/ws05-yellow_main_1.jpg','image',0),(2656,90,'/w/s/ws05-black_main_1.jpg','image',0),(2657,90,'/w/s/ws05-black_alt1_1.jpg','image',0),(2658,90,'/w/s/ws05-black_back_1.jpg','image',0),(2659,90,'/w/s/ws05-orange_main_1.jpg','image',0),(2660,90,'/w/s/ws05-yellow_main_1.jpg','image',0),(2661,90,'/w/s/ws05-black_main_1.jpg','image',0),(2662,90,'/w/s/ws05-black_alt1_1.jpg','image',0),(2663,90,'/w/s/ws05-black_back_1.jpg','image',0),(2664,90,'/w/s/ws05-orange_main_1.jpg','image',0),(2665,90,'/w/s/ws05-yellow_main_1.jpg','image',0),(2666,90,'/w/s/ws05-black_main_1.jpg','image',0),(2667,90,'/w/s/ws05-black_alt1_1.jpg','image',0),(2668,90,'/w/s/ws05-black_back_1.jpg','image',0),(2669,90,'/w/b/wb01-black_main_1.jpg','image',0),(2670,90,'/w/b/wb01-black-0_1.jpg','image',0),(2671,90,'/w/b/wb01-gray_main_1.jpg','image',0),(2672,90,'/w/b/wb01-gray_alt1_1.jpg','image',0),(2673,90,'/w/b/wb01-gray_back_1.jpg','image',0),(2674,90,'/w/b/wb01-purple_main_1.jpg','image',0),(2675,90,'/w/b/wb01-black_main_1.jpg','image',0),(2676,90,'/w/b/wb01-black-0_1.jpg','image',0),(2677,90,'/w/b/wb01-gray_main_1.jpg','image',0),(2678,90,'/w/b/wb01-gray_alt1_1.jpg','image',0),(2679,90,'/w/b/wb01-gray_back_1.jpg','image',0),(2680,90,'/w/b/wb01-purple_main_1.jpg','image',0),(2681,90,'/w/b/wb01-black_main_1.jpg','image',0),(2682,90,'/w/b/wb01-black-0_1.jpg','image',0),(2683,90,'/w/b/wb01-gray_main_1.jpg','image',0),(2684,90,'/w/b/wb01-gray_alt1_1.jpg','image',0),(2685,90,'/w/b/wb01-gray_back_1.jpg','image',0),(2686,90,'/w/b/wb01-purple_main_1.jpg','image',0),(2687,90,'/w/b/wb01-black_main_1.jpg','image',0),(2688,90,'/w/b/wb01-black-0_1.jpg','image',0),(2689,90,'/w/b/wb01-gray_main_1.jpg','image',0),(2690,90,'/w/b/wb01-gray_alt1_1.jpg','image',0),(2691,90,'/w/b/wb01-gray_back_1.jpg','image',0),(2692,90,'/w/b/wb01-purple_main_1.jpg','image',0),(2693,90,'/w/b/wb01-black_main_1.jpg','image',0),(2694,90,'/w/b/wb01-black-0_1.jpg','image',0),(2695,90,'/w/b/wb01-gray_main_1.jpg','image',0),(2696,90,'/w/b/wb01-gray_alt1_1.jpg','image',0),(2697,90,'/w/b/wb01-gray_back_1.jpg','image',0),(2698,90,'/w/b/wb01-purple_main_1.jpg','image',0),(2699,90,'/w/b/wb01-gray_main_1.jpg','image',0),(2700,90,'/w/b/wb01-gray_alt1_1.jpg','image',0),(2701,90,'/w/b/wb01-gray_back_1.jpg','image',0),(2702,90,'/w/b/wb02-blue_main_1.jpg','image',0),(2703,90,'/w/b/wb02-blue_alt1_1.jpg','image',0),(2704,90,'/w/b/wb02-blue_back_1.jpg','image',0),(2705,90,'/w/b/wb02-orange_main_1.jpg','image',0),(2706,90,'/w/b/wb02-yellow_main_1.jpg','image',0),(2707,90,'/w/b/wb02-blue_main_1.jpg','image',0),(2708,90,'/w/b/wb02-blue_alt1_1.jpg','image',0),(2709,90,'/w/b/wb02-blue_back_1.jpg','image',0),(2710,90,'/w/b/wb02-orange_main_1.jpg','image',0),(2711,90,'/w/b/wb02-yellow_main_1.jpg','image',0),(2712,90,'/w/b/wb02-blue_main_1.jpg','image',0),(2713,90,'/w/b/wb02-blue_alt1_1.jpg','image',0),(2714,90,'/w/b/wb02-blue_back_1.jpg','image',0),(2715,90,'/w/b/wb02-orange_main_1.jpg','image',0),(2716,90,'/w/b/wb02-yellow_main_1.jpg','image',0),(2717,90,'/w/b/wb02-blue_main_1.jpg','image',0),(2718,90,'/w/b/wb02-blue_alt1_1.jpg','image',0),(2719,90,'/w/b/wb02-blue_back_1.jpg','image',0),(2720,90,'/w/b/wb02-orange_main_1.jpg','image',0),(2721,90,'/w/b/wb02-yellow_main_1.jpg','image',0),(2722,90,'/w/b/wb02-blue_main_1.jpg','image',0),(2723,90,'/w/b/wb02-blue_alt1_1.jpg','image',0),(2724,90,'/w/b/wb02-blue_back_1.jpg','image',0),(2725,90,'/w/b/wb02-orange_main_1.jpg','image',0),(2726,90,'/w/b/wb02-yellow_main_1.jpg','image',0),(2727,90,'/w/b/wb02-blue_main_1.jpg','image',0),(2728,90,'/w/b/wb02-blue_alt1_1.jpg','image',0),(2729,90,'/w/b/wb02-blue_back_1.jpg','image',0),(2730,90,'/w/b/wb03-green_main_1.jpg','image',0),(2731,90,'/w/b/wb03-green_alt1_1.jpg','image',0),(2732,90,'/w/b/wb03-green_back_1.jpg','image',0),(2733,90,'/w/b/wb03-red_main_1.jpg','image',0),(2734,90,'/w/b/wb03-yellow_main_1.jpg','image',0),(2735,90,'/w/b/wb03-green_main_1.jpg','image',0),(2736,90,'/w/b/wb03-green_alt1_1.jpg','image',0),(2737,90,'/w/b/wb03-green_back_1.jpg','image',0),(2738,90,'/w/b/wb03-red_main_1.jpg','image',0),(2739,90,'/w/b/wb03-yellow_main_1.jpg','image',0),(2740,90,'/w/b/wb03-green_main_1.jpg','image',0),(2741,90,'/w/b/wb03-green_alt1_1.jpg','image',0),(2742,90,'/w/b/wb03-green_back_1.jpg','image',0),(2743,90,'/w/b/wb03-red_main_1.jpg','image',0),(2744,90,'/w/b/wb03-yellow_main_1.jpg','image',0),(2745,90,'/w/b/wb03-green_main_1.jpg','image',0),(2746,90,'/w/b/wb03-green_alt1_1.jpg','image',0),(2747,90,'/w/b/wb03-green_back_1.jpg','image',0),(2748,90,'/w/b/wb03-red_main_1.jpg','image',0),(2749,90,'/w/b/wb03-yellow_main_1.jpg','image',0),(2750,90,'/w/b/wb03-green_main_1.jpg','image',0),(2751,90,'/w/b/wb03-green_alt1_1.jpg','image',0),(2752,90,'/w/b/wb03-green_back_1.jpg','image',0),(2753,90,'/w/b/wb03-red_main_1.jpg','image',0),(2754,90,'/w/b/wb03-yellow_main_1.jpg','image',0),(2755,90,'/w/b/wb03-green_main_1.jpg','image',0),(2756,90,'/w/b/wb03-green_alt1_1.jpg','image',0),(2757,90,'/w/b/wb03-green_back_1.jpg','image',0),(2758,90,'/w/b/wb04-blue_main_1.jpg','image',0),(2759,90,'/w/b/wb04-blue-0_1.jpg','image',0),(2760,90,'/w/b/wb04-blue_alt1_1.jpg','image',0),(2761,90,'/w/b/wb04-blue_back_1.jpg','image',0),(2762,90,'/w/b/wb04-purple_main_1.jpg','image',0),(2763,90,'/w/b/wb04-yellow_main_1.jpg','image',0),(2764,90,'/w/b/wb04-blue_main_1.jpg','image',0),(2765,90,'/w/b/wb04-blue-0_1.jpg','image',0),(2766,90,'/w/b/wb04-blue_alt1_1.jpg','image',0),(2767,90,'/w/b/wb04-blue_back_1.jpg','image',0),(2768,90,'/w/b/wb04-purple_main_1.jpg','image',0),(2769,90,'/w/b/wb04-yellow_main_1.jpg','image',0),(2770,90,'/w/b/wb04-blue_main_1.jpg','image',0),(2771,90,'/w/b/wb04-blue-0_1.jpg','image',0),(2772,90,'/w/b/wb04-blue_alt1_1.jpg','image',0),(2773,90,'/w/b/wb04-blue_back_1.jpg','image',0),(2774,90,'/w/b/wb04-purple_main_1.jpg','image',0),(2775,90,'/w/b/wb04-yellow_main_1.jpg','image',0),(2776,90,'/w/b/wb04-blue_main_1.jpg','image',0),(2777,90,'/w/b/wb04-blue-0_1.jpg','image',0),(2778,90,'/w/b/wb04-blue_alt1_1.jpg','image',0),(2779,90,'/w/b/wb04-blue_back_1.jpg','image',0),(2780,90,'/w/b/wb04-purple_main_2.jpg','image',0),(2781,90,'/w/b/wb04-yellow_main_2.jpg','image',0),(2782,90,'/w/b/wb04-blue_main_2.jpg','image',0),(2783,90,'/w/b/wb04-blue-0_2.jpg','image',0),(2784,90,'/w/b/wb04-blue_alt1_2.jpg','image',0),(2785,90,'/w/b/wb04-blue_back_2.jpg','image',0),(2786,90,'/w/b/wb04-purple_main_2.jpg','image',0),(2787,90,'/w/b/wb04-yellow_main_2.jpg','image',0),(2788,90,'/w/b/wb04-blue_main_2.jpg','image',0),(2789,90,'/w/b/wb04-blue-0_2.jpg','image',0),(2790,90,'/w/b/wb04-blue_alt1_2.jpg','image',0),(2791,90,'/w/b/wb04-blue_back_2.jpg','image',0),(2792,90,'/w/b/wb05-black_main_1.jpg','image',0),(2793,90,'/w/b/wb05-black_back_1.jpg','image',0),(2794,90,'/w/b/wb05-orange_main_1.jpg','image',0),(2795,90,'/w/b/wb05-purple_main_1.jpg','image',0),(2796,90,'/w/b/wb05-black_main_1.jpg','image',0),(2797,90,'/w/b/wb05-black_back_1.jpg','image',0),(2798,90,'/w/b/wb05-orange_main_1.jpg','image',0),(2799,90,'/w/b/wb05-purple_main_1.jpg','image',0),(2800,90,'/w/b/wb05-black_main_1.jpg','image',0),(2801,90,'/w/b/wb05-black_back_1.jpg','image',0),(2802,90,'/w/b/wb05-orange_main_1.jpg','image',0),(2803,90,'/w/b/wb05-purple_main_1.jpg','image',0),(2804,90,'/w/b/wb05-black_main_1.jpg','image',0),(2805,90,'/w/b/wb05-black_back_1.jpg','image',0),(2806,90,'/w/b/wb05-orange_main_1.jpg','image',0),(2807,90,'/w/b/wb05-purple_main_1.jpg','image',0),(2808,90,'/w/b/wb05-black_main_1.jpg','image',0),(2809,90,'/w/b/wb05-black_back_1.jpg','image',0),(2810,90,'/w/b/wb05-orange_main_1.jpg','image',0),(2811,90,'/w/b/wb05-purple_main_1.jpg','image',0),(2812,90,'/w/b/wb05-black_main_1.jpg','image',0),(2813,90,'/w/b/wb05-black_back_1.jpg','image',0),(2814,90,'/w/t/wt01-black_main_1.jpg','image',0),(2815,90,'/w/t/wt01-blue_main_1.jpg','image',0),(2816,90,'/w/t/wt01-blue_back_1.jpg','image',0),(2817,90,'/w/t/wt01-orange_main_1.jpg','image',0),(2818,90,'/w/t/wt01-black_main_1.jpg','image',0),(2819,90,'/w/t/wt01-blue_main_1.jpg','image',0),(2820,90,'/w/t/wt01-blue_back_1.jpg','image',0),(2821,90,'/w/t/wt01-orange_main_1.jpg','image',0),(2822,90,'/w/t/wt01-black_main_1.jpg','image',0),(2823,90,'/w/t/wt01-blue_main_1.jpg','image',0),(2824,90,'/w/t/wt01-blue_back_1.jpg','image',0),(2825,90,'/w/t/wt01-orange_main_1.jpg','image',0),(2826,90,'/w/t/wt01-black_main_1.jpg','image',0),(2827,90,'/w/t/wt01-blue_main_1.jpg','image',0),(2828,90,'/w/t/wt01-blue_back_1.jpg','image',0),(2829,90,'/w/t/wt01-orange_main_1.jpg','image',0),(2830,90,'/w/t/wt01-black_main_1.jpg','image',0),(2831,90,'/w/t/wt01-blue_main_1.jpg','image',0),(2832,90,'/w/t/wt01-blue_back_1.jpg','image',0),(2833,90,'/w/t/wt01-orange_main_1.jpg','image',0),(2834,90,'/w/t/wt01-blue_main_1.jpg','image',0),(2835,90,'/w/t/wt01-blue_back_1.jpg','image',0),(2836,90,'/w/t/wt02-green_main_1.jpg','image',0),(2837,90,'/w/t/wt02-orange_main_1.jpg','image',0),(2838,90,'/w/t/wt02-orange_back_1.jpg','image',0),(2839,90,'/w/t/wt02-yellow_main_1.jpg','image',0),(2840,90,'/w/t/wt02-green_main_1.jpg','image',0),(2841,90,'/w/t/wt02-orange_main_1.jpg','image',0),(2842,90,'/w/t/wt02-orange_back_1.jpg','image',0),(2843,90,'/w/t/wt02-yellow_main_1.jpg','image',0),(2844,90,'/w/t/wt02-green_main_1.jpg','image',0),(2845,90,'/w/t/wt02-orange_main_1.jpg','image',0),(2846,90,'/w/t/wt02-orange_back_1.jpg','image',0),(2847,90,'/w/t/wt02-yellow_main_1.jpg','image',0),(2848,90,'/w/t/wt02-green_main_1.jpg','image',0),(2849,90,'/w/t/wt02-orange_main_1.jpg','image',0),(2850,90,'/w/t/wt02-orange_back_1.jpg','image',0),(2851,90,'/w/t/wt02-yellow_main_1.jpg','image',0),(2852,90,'/w/t/wt02-green_main_1.jpg','image',0),(2853,90,'/w/t/wt02-orange_main_1.jpg','image',0),(2854,90,'/w/t/wt02-orange_back_1.jpg','image',0),(2855,90,'/w/t/wt02-yellow_main_1.jpg','image',0),(2856,90,'/w/t/wt02-orange_main_1.jpg','image',0),(2857,90,'/w/t/wt02-orange_back_1.jpg','image',0),(2858,90,'/w/t/wt03-orange_main_1.jpg','image',0),(2859,90,'/w/t/wt03-purple_main_1.jpg','image',0),(2860,90,'/w/t/wt03-red_main_1.jpg','image',0),(2861,90,'/w/t/wt03-red_alt1_1.jpg','image',0),(2862,90,'/w/t/wt03-red_back_1.jpg','image',0),(2863,90,'/w/t/wt03-orange_main_1.jpg','image',0),(2864,90,'/w/t/wt03-purple_main_1.jpg','image',0),(2865,90,'/w/t/wt03-red_main_1.jpg','image',0),(2866,90,'/w/t/wt03-red_alt1_1.jpg','image',0),(2867,90,'/w/t/wt03-red_back_1.jpg','image',0),(2868,90,'/w/t/wt03-orange_main_1.jpg','image',0),(2869,90,'/w/t/wt03-purple_main_1.jpg','image',0),(2870,90,'/w/t/wt03-red_main_1.jpg','image',0),(2871,90,'/w/t/wt03-red_alt1_1.jpg','image',0),(2872,90,'/w/t/wt03-red_back_1.jpg','image',0),(2873,90,'/w/t/wt03-orange_main_1.jpg','image',0),(2874,90,'/w/t/wt03-purple_main_1.jpg','image',0),(2875,90,'/w/t/wt03-red_main_1.jpg','image',0),(2876,90,'/w/t/wt03-red_alt1_1.jpg','image',0),(2877,90,'/w/t/wt03-red_back_1.jpg','image',0),(2878,90,'/w/t/wt03-orange_main_1.jpg','image',0),(2879,90,'/w/t/wt03-purple_main_1.jpg','image',0),(2880,90,'/w/t/wt03-red_main_1.jpg','image',0),(2881,90,'/w/t/wt03-red_alt1_1.jpg','image',0),(2882,90,'/w/t/wt03-red_back_1.jpg','image',0),(2883,90,'/w/t/wt03-red_main_1.jpg','image',0),(2884,90,'/w/t/wt03-red_alt1_1.jpg','image',0),(2885,90,'/w/t/wt03-red_back_1.jpg','image',0),(2886,90,'/w/t/wt04-blue_main_1.jpg','image',0),(2887,90,'/w/t/wt04-blue_back_1.jpg','image',0),(2888,90,'/w/t/wt04-purple_main_1.jpg','image',0),(2889,90,'/w/t/wt04-red_main_1.jpg','image',0),(2890,90,'/w/t/wt04-blue_main_1.jpg','image',0),(2891,90,'/w/t/wt04-blue_back_1.jpg','image',0),(2892,90,'/w/t/wt04-purple_main_1.jpg','image',0),(2893,90,'/w/t/wt04-red_main_1.jpg','image',0),(2894,90,'/w/t/wt04-blue_main_1.jpg','image',0),(2895,90,'/w/t/wt04-blue_back_1.jpg','image',0),(2896,90,'/w/t/wt04-purple_main_1.jpg','image',0),(2897,90,'/w/t/wt04-red_main_1.jpg','image',0),(2898,90,'/w/t/wt04-blue_main_1.jpg','image',0),(2899,90,'/w/t/wt04-blue_back_1.jpg','image',0),(2900,90,'/w/t/wt04-purple_main_1.jpg','image',0),(2901,90,'/w/t/wt04-red_main_1.jpg','image',0),(2902,90,'/w/t/wt04-blue_main_1.jpg','image',0),(2903,90,'/w/t/wt04-blue_back_1.jpg','image',0),(2904,90,'/w/t/wt04-purple_main_1.jpg','image',0),(2905,90,'/w/t/wt04-red_main_1.jpg','image',0),(2906,90,'/w/t/wt04-blue_main_1.jpg','image',0),(2907,90,'/w/t/wt04-blue_back_1.jpg','image',0),(2908,90,'/w/t/wt05-orange_main_1.jpg','image',0),(2909,90,'/w/t/wt05-purple_main_1.jpg','image',0),(2910,90,'/w/t/wt05-purple_alt1_1.jpg','image',0),(2911,90,'/w/t/wt05-purple_back_1.jpg','image',0),(2912,90,'/w/t/wt05-white_main_1.jpg','image',0),(2913,90,'/w/t/wt05-orange_main_1.jpg','image',0),(2914,90,'/w/t/wt05-purple_main_1.jpg','image',0),(2915,90,'/w/t/wt05-purple_alt1_1.jpg','image',0),(2916,90,'/w/t/wt05-purple_back_1.jpg','image',0),(2917,90,'/w/t/wt05-white_main_1.jpg','image',0),(2918,90,'/w/t/wt05-orange_main_1.jpg','image',0),(2919,90,'/w/t/wt05-purple_main_1.jpg','image',0),(2920,90,'/w/t/wt05-purple_alt1_1.jpg','image',0),(2921,90,'/w/t/wt05-purple_back_1.jpg','image',0),(2922,90,'/w/t/wt05-white_main_1.jpg','image',0),(2923,90,'/w/t/wt05-orange_main_1.jpg','image',0),(2924,90,'/w/t/wt05-purple_main_1.jpg','image',0),(2925,90,'/w/t/wt05-purple_alt1_1.jpg','image',0),(2926,90,'/w/t/wt05-purple_back_1.jpg','image',0),(2927,90,'/w/t/wt05-white_main_1.jpg','image',0),(2928,90,'/w/t/wt05-orange_main_1.jpg','image',0),(2929,90,'/w/t/wt05-purple_main_1.jpg','image',0),(2930,90,'/w/t/wt05-purple_alt1_1.jpg','image',0),(2931,90,'/w/t/wt05-purple_back_1.jpg','image',0),(2932,90,'/w/t/wt05-white_main_2.jpg','image',0),(2933,90,'/w/t/wt05-purple_main_2.jpg','image',0),(2934,90,'/w/t/wt05-purple_alt1_2.jpg','image',0),(2935,90,'/w/t/wt05-purple_back_2.jpg','image',0),(2936,90,'/w/t/wt06-blue_main_1.jpg','image',0),(2937,90,'/w/t/wt06-blue_back_1.jpg','image',0),(2938,90,'/w/t/wt06-red_main_1.jpg','image',0),(2939,90,'/w/t/wt06-yellow_main_1.jpg','image',0),(2940,90,'/w/t/wt06-blue_main_1.jpg','image',0),(2941,90,'/w/t/wt06-blue_back_1.jpg','image',0),(2942,90,'/w/t/wt06-red_main_1.jpg','image',0),(2943,90,'/w/t/wt06-yellow_main_1.jpg','image',0),(2944,90,'/w/t/wt06-blue_main_1.jpg','image',0),(2945,90,'/w/t/wt06-blue_back_1.jpg','image',0),(2946,90,'/w/t/wt06-red_main_1.jpg','image',0),(2947,90,'/w/t/wt06-yellow_main_1.jpg','image',0),(2948,90,'/w/t/wt06-blue_main_1.jpg','image',0),(2949,90,'/w/t/wt06-blue_back_1.jpg','image',0),(2950,90,'/w/t/wt06-red_main_1.jpg','image',0),(2951,90,'/w/t/wt06-yellow_main_1.jpg','image',0),(2952,90,'/w/t/wt06-blue_main_1.jpg','image',0),(2953,90,'/w/t/wt06-blue_back_1.jpg','image',0),(2954,90,'/w/t/wt06-red_main_1.jpg','image',0),(2955,90,'/w/t/wt06-yellow_main_1.jpg','image',0),(2956,90,'/w/t/wt06-blue_main_1.jpg','image',0),(2957,90,'/w/t/wt06-blue_back_1.jpg','image',0),(2958,90,'/w/t/wt07-green_main_1.jpg','image',0),(2959,90,'/w/t/wt07-green_alt1_1.jpg','image',0),(2960,90,'/w/t/wt07-green_back_1.jpg','image',0),(2961,90,'/w/t/wt07-white_main_1.jpg','image',0),(2962,90,'/w/t/wt07-yellow_main_1.jpg','image',0),(2963,90,'/w/t/wt07-green_main_1.jpg','image',0),(2964,90,'/w/t/wt07-green_alt1_1.jpg','image',0),(2965,90,'/w/t/wt07-green_back_1.jpg','image',0),(2966,90,'/w/t/wt07-white_main_1.jpg','image',0),(2967,90,'/w/t/wt07-yellow_main_1.jpg','image',0),(2968,90,'/w/t/wt07-green_main_1.jpg','image',0),(2969,90,'/w/t/wt07-green_alt1_1.jpg','image',0),(2970,90,'/w/t/wt07-green_back_1.jpg','image',0),(2971,90,'/w/t/wt07-white_main_1.jpg','image',0),(2972,90,'/w/t/wt07-yellow_main_1.jpg','image',0),(2973,90,'/w/t/wt07-green_main_1.jpg','image',0),(2974,90,'/w/t/wt07-green_alt1_1.jpg','image',0),(2975,90,'/w/t/wt07-green_back_1.jpg','image',0),(2976,90,'/w/t/wt07-white_main_1.jpg','image',0),(2977,90,'/w/t/wt07-yellow_main_1.jpg','image',0),(2978,90,'/w/t/wt07-green_main_1.jpg','image',0),(2979,90,'/w/t/wt07-green_alt1_1.jpg','image',0),(2980,90,'/w/t/wt07-green_back_1.jpg','image',0),(2981,90,'/w/t/wt07-white_main_1.jpg','image',0),(2982,90,'/w/t/wt07-yellow_main_1.jpg','image',0),(2983,90,'/w/t/wt07-green_main_1.jpg','image',0),(2984,90,'/w/t/wt07-green_alt1_1.jpg','image',0),(2985,90,'/w/t/wt07-green_back_1.jpg','image',0),(2986,90,'/w/t/wt08-black_main_1.jpg','image',0),(2987,90,'/w/t/wt08-black_alt1_1.jpg','image',0),(2988,90,'/w/t/wt08-black_back_1.jpg','image',0),(2989,90,'/w/t/wt08-purple_main_1.jpg','image',0),(2990,90,'/w/t/wt08-yellow_main_1.jpg','image',0),(2991,90,'/w/t/wt08-black_main_1.jpg','image',0),(2992,90,'/w/t/wt08-black_alt1_1.jpg','image',0),(2993,90,'/w/t/wt08-black_back_1.jpg','image',0),(2994,90,'/w/t/wt08-purple_main_1.jpg','image',0),(2995,90,'/w/t/wt08-yellow_main_1.jpg','image',0),(2996,90,'/w/t/wt08-black_main_1.jpg','image',0),(2997,90,'/w/t/wt08-black_alt1_1.jpg','image',0),(2998,90,'/w/t/wt08-black_back_1.jpg','image',0),(2999,90,'/w/t/wt08-purple_main_1.jpg','image',0),(3000,90,'/w/t/wt08-yellow_main_1.jpg','image',0),(3001,90,'/w/t/wt08-black_main_1.jpg','image',0),(3002,90,'/w/t/wt08-black_alt1_1.jpg','image',0),(3003,90,'/w/t/wt08-black_back_1.jpg','image',0),(3004,90,'/w/t/wt08-purple_main_1.jpg','image',0),(3005,90,'/w/t/wt08-yellow_main_1.jpg','image',0),(3006,90,'/w/t/wt08-black_main_1.jpg','image',0),(3007,90,'/w/t/wt08-black_alt1_1.jpg','image',0),(3008,90,'/w/t/wt08-black_back_1.jpg','image',0),(3009,90,'/w/t/wt08-purple_main_1.jpg','image',0),(3010,90,'/w/t/wt08-yellow_main_1.jpg','image',0),(3011,90,'/w/t/wt08-black_main_1.jpg','image',0),(3012,90,'/w/t/wt08-black_alt1_1.jpg','image',0),(3013,90,'/w/t/wt08-black_back_1.jpg','image',0),(3014,90,'/w/t/wt09-purple_main_1.jpg','image',0),(3015,90,'/w/t/wt09-white_main_1.jpg','image',0),(3016,90,'/w/t/wt09-white_back_1.jpg','image',0),(3017,90,'/w/t/wt09-yellow_main_1.jpg','image',0),(3018,90,'/w/t/wt09-purple_main_1.jpg','image',0),(3019,90,'/w/t/wt09-white_main_1.jpg','image',0),(3020,90,'/w/t/wt09-white_back_1.jpg','image',0),(3021,90,'/w/t/wt09-yellow_main_1.jpg','image',0),(3022,90,'/w/t/wt09-purple_main_1.jpg','image',0),(3023,90,'/w/t/wt09-white_main_1.jpg','image',0),(3024,90,'/w/t/wt09-white_back_1.jpg','image',0),(3025,90,'/w/t/wt09-yellow_main_1.jpg','image',0),(3026,90,'/w/t/wt09-purple_main_1.jpg','image',0),(3027,90,'/w/t/wt09-white_main_1.jpg','image',0),(3028,90,'/w/t/wt09-white_back_1.jpg','image',0),(3029,90,'/w/t/wt09-yellow_main_1.jpg','image',0),(3030,90,'/w/t/wt09-purple_main_1.jpg','image',0),(3031,90,'/w/t/wt09-white_main_1.jpg','image',0),(3032,90,'/w/t/wt09-white_back_1.jpg','image',0),(3033,90,'/w/t/wt09-yellow_main_1.jpg','image',0),(3034,90,'/w/t/wt09-white_main_1.jpg','image',0),(3035,90,'/w/t/wt09-white_back_1.jpg','image',0),(3036,90,'/w/p/wp01-black_main_1.jpg','image',0),(3037,90,'/w/p/wp01-gray_main_1.jpg','image',0),(3038,90,'/w/p/wp01-gray_back_1.jpg','image',0),(3039,90,'/w/p/wp01-white_main_1.jpg','image',0),(3040,90,'/w/p/wp01-black_main_1.jpg','image',0),(3041,90,'/w/p/wp01-gray_main_1.jpg','image',0),(3042,90,'/w/p/wp01-gray_back_1.jpg','image',0),(3043,90,'/w/p/wp01-white_main_1.jpg','image',0),(3044,90,'/w/p/wp01-gray_main_1.jpg','image',0),(3045,90,'/w/p/wp01-gray_back_1.jpg','image',0),(3046,90,'/w/p/wp02-blue_main_1.jpg','image',0),(3047,90,'/w/p/wp02-blue_back_1.jpg','image',0),(3048,90,'/w/p/wp02-purple_main_1.jpg','image',0),(3049,90,'/w/p/wp02-red_main_1.jpg','image',0),(3050,90,'/w/p/wp02-blue_main_1.jpg','image',0),(3051,90,'/w/p/wp02-blue_back_1.jpg','image',0),(3052,90,'/w/p/wp02-purple_main_1.jpg','image',0),(3053,90,'/w/p/wp02-red_main_1.jpg','image',0),(3054,90,'/w/p/wp02-blue_main_1.jpg','image',0),(3055,90,'/w/p/wp02-blue_back_1.jpg','image',0),(3056,90,'/w/p/wp03-black_main_1.jpg','image',0),(3057,90,'/w/p/wp03-blue_main_1.jpg','image',0),(3058,90,'/w/p/wp03-blue_alt1_1.jpg','image',0),(3059,90,'/w/p/wp03-blue_back_1.jpg','image',0),(3060,90,'/w/p/wp03-purple_main_1.jpg','image',0),(3061,90,'/w/p/wp03-black_main_1.jpg','image',0),(3062,90,'/w/p/wp03-blue_main_1.jpg','image',0),(3063,90,'/w/p/wp03-blue_alt1_1.jpg','image',0),(3064,90,'/w/p/wp03-blue_back_1.jpg','image',0),(3065,90,'/w/p/wp03-purple_main_1.jpg','image',0),(3066,90,'/w/p/wp03-blue_main_1.jpg','image',0),(3067,90,'/w/p/wp03-blue_alt1_1.jpg','image',0),(3068,90,'/w/p/wp03-blue_back_1.jpg','image',0),(3069,90,'/w/p/wp04-black_main_1.jpg','image',0),(3070,90,'/w/p/wp04-blue_main_1.jpg','image',0),(3071,90,'/w/p/wp04-blue_alt1_1.jpg','image',0),(3072,90,'/w/p/wp04-blue_alternate_1.jpg','image',0),(3073,90,'/w/p/wp04-blue_back_1.jpg','image',0),(3074,90,'/w/p/wp04-white_main_1.jpg','image',0),(3075,90,'/w/p/wp04-black_main_1.jpg','image',0),(3076,90,'/w/p/wp04-blue_main_1.jpg','image',0),(3077,90,'/w/p/wp04-blue_alt1_1.jpg','image',0),(3078,90,'/w/p/wp04-blue_alternate_1.jpg','image',0),(3079,90,'/w/p/wp04-blue_back_1.jpg','image',0),(3080,90,'/w/p/wp04-white_main_1.jpg','image',0),(3081,90,'/w/p/wp04-blue_main_1.jpg','image',0),(3082,90,'/w/p/wp04-blue_alt1_1.jpg','image',0),(3083,90,'/w/p/wp04-blue_alternate_1.jpg','image',0),(3084,90,'/w/p/wp04-blue_back_1.jpg','image',0),(3085,90,'/w/p/wp05-blue_main_1.jpg','image',0),(3086,90,'/w/p/wp05-gray_main_1.jpg','image',0),(3087,90,'/w/p/wp05-gray_alt1_1.jpg','image',0),(3088,90,'/w/p/wp05-gray_back_1.jpg','image',0),(3089,90,'/w/p/wp05-red_main_1.jpg','image',0),(3090,90,'/w/p/wp05-blue_main_1.jpg','image',0),(3091,90,'/w/p/wp05-gray_main_1.jpg','image',0),(3092,90,'/w/p/wp05-gray_alt1_1.jpg','image',0),(3093,90,'/w/p/wp05-gray_back_1.jpg','image',0),(3094,90,'/w/p/wp05-red_main_1.jpg','image',0),(3095,90,'/w/p/wp05-gray_main_2.jpg','image',0),(3096,90,'/w/p/wp05-gray_alt1_2.jpg','image',0),(3097,90,'/w/p/wp05-gray_back_2.jpg','image',0),(3098,90,'/w/p/wp06-black_main_1.jpg','image',0),(3099,90,'/w/p/wp06-black_alt1_1.jpg','image',0),(3100,90,'/w/p/wp06-black_back_1.jpg','image',0),(3101,90,'/w/p/wp06-black_outfit_1.jpg','image',0),(3102,90,'/w/p/wp06-blue_main_1.jpg','image',0),(3103,90,'/w/p/wp06-orange_main_1.jpg','image',0),(3104,90,'/w/p/wp06-black_main_1.jpg','image',0),(3105,90,'/w/p/wp06-black_alt1_1.jpg','image',0),(3106,90,'/w/p/wp06-black_back_1.jpg','image',0),(3107,90,'/w/p/wp06-black_outfit_1.jpg','image',0),(3108,90,'/w/p/wp06-blue_main_1.jpg','image',0),(3109,90,'/w/p/wp06-orange_main_1.jpg','image',0),(3110,90,'/w/p/wp06-black_main_1.jpg','image',0),(3111,90,'/w/p/wp06-black_alt1_1.jpg','image',0),(3112,90,'/w/p/wp06-black_back_1.jpg','image',0),(3113,90,'/w/p/wp06-black_outfit_1.jpg','image',0),(3114,90,'/w/p/wp07-black_main_1.jpg','image',0),(3115,90,'/w/p/wp07-black_alt1_1.jpg','image',0),(3116,90,'/w/p/wp07-black_back_1.jpg','image',0),(3117,90,'/w/p/wp07-blue_main_1.jpg','image',0),(3118,90,'/w/p/wp07-orange_main_1.jpg','image',0),(3119,90,'/w/p/wp07-black_main_1.jpg','image',0),(3120,90,'/w/p/wp07-black_alt1_1.jpg','image',0),(3121,90,'/w/p/wp07-black_back_1.jpg','image',0),(3122,90,'/w/p/wp07-blue_main_1.jpg','image',0),(3123,90,'/w/p/wp07-orange_main_1.jpg','image',0),(3124,90,'/w/p/wp07-black_main_1.jpg','image',0),(3125,90,'/w/p/wp07-black_alt1_1.jpg','image',0),(3126,90,'/w/p/wp07-black_back_1.jpg','image',0),(3127,90,'/w/p/wp08-black_main_1.jpg','image',0),(3128,90,'/w/p/wp08-black_back_1.jpg','image',0),(3129,90,'/w/p/wp08-green_main_1.jpg','image',0),(3130,90,'/w/p/wp08-red_main_1.jpg','image',0),(3131,90,'/w/p/wp08-black_main_1.jpg','image',0),(3132,90,'/w/p/wp08-black_back_1.jpg','image',0),(3133,90,'/w/p/wp08-green_main_1.jpg','image',0),(3134,90,'/w/p/wp08-red_main_1.jpg','image',0),(3135,90,'/w/p/wp08-black_main_1.jpg','image',0),(3136,90,'/w/p/wp08-black_back_1.jpg','image',0),(3137,90,'/w/p/wp09-black_main_1.jpg','image',0),(3138,90,'/w/p/wp09-black_alt1_1.jpg','image',0),(3139,90,'/w/p/wp09-black_back_1.jpg','image',0),(3140,90,'/w/p/wp09-black_outfit_1.jpg','image',0),(3141,90,'/w/p/wp09-blue_main_1.jpg','image',0),(3142,90,'/w/p/wp09-purple_main_1.jpg','image',0),(3143,90,'/w/p/wp09-black_main_1.jpg','image',0),(3144,90,'/w/p/wp09-black_alt1_1.jpg','image',0),(3145,90,'/w/p/wp09-black_back_1.jpg','image',0),(3146,90,'/w/p/wp09-black_outfit_1.jpg','image',0),(3147,90,'/w/p/wp09-blue_main_1.jpg','image',0),(3148,90,'/w/p/wp09-purple_main_1.jpg','image',0),(3149,90,'/w/p/wp09-black_main_1.jpg','image',0),(3150,90,'/w/p/wp09-black_alt1_1.jpg','image',0),(3151,90,'/w/p/wp09-black_back_1.jpg','image',0),(3152,90,'/w/p/wp09-black_outfit_1.jpg','image',0),(3153,90,'/w/p/wp10-black_main_1.jpg','image',0),(3154,90,'/w/p/wp10-gray_main_1.jpg','image',0),(3155,90,'/w/p/wp10-gray_alt1_1.jpg','image',0),(3156,90,'/w/p/wp10-gray_back_1.jpg','image',0),(3157,90,'/w/p/wp10-white_main_1.jpg','image',0),(3158,90,'/w/p/wp10-black_main_1.jpg','image',0),(3159,90,'/w/p/wp10-gray_main_1.jpg','image',0),(3160,90,'/w/p/wp10-gray_alt1_1.jpg','image',0),(3161,90,'/w/p/wp10-gray_back_1.jpg','image',0),(3162,90,'/w/p/wp10-white_main_1.jpg','image',0),(3163,90,'/w/p/wp10-gray_main_1.jpg','image',0),(3164,90,'/w/p/wp10-gray_alt1_1.jpg','image',0),(3165,90,'/w/p/wp10-gray_back_1.jpg','image',0),(3166,90,'/w/p/wp11-blue_main_1.jpg','image',0),(3167,90,'/w/p/wp11-green_main_1.jpg','image',0),(3168,90,'/w/p/wp11-green_back_1.jpg','image',0),(3169,90,'/w/p/wp11-red_main_1.jpg','image',0),(3170,90,'/w/p/wp11-blue_main_1.jpg','image',0),(3171,90,'/w/p/wp11-green_main_1.jpg','image',0),(3172,90,'/w/p/wp11-green_back_1.jpg','image',0),(3173,90,'/w/p/wp11-red_main_1.jpg','image',0),(3174,90,'/w/p/wp11-green_main_1.jpg','image',0),(3175,90,'/w/p/wp11-green_back_1.jpg','image',0),(3176,90,'/w/p/wp12-blue_main_1.jpg','image',0),(3177,90,'/w/p/wp12-gray_main_1.jpg','image',0),(3178,90,'/w/p/wp12-gray_back_1.jpg','image',0),(3179,90,'/w/p/wp12-green_main_1.jpg','image',0),(3180,90,'/w/p/wp12-blue_main_1.jpg','image',0),(3181,90,'/w/p/wp12-gray_main_1.jpg','image',0),(3182,90,'/w/p/wp12-gray_back_1.jpg','image',0),(3183,90,'/w/p/wp12-green_main_1.jpg','image',0),(3184,90,'/w/p/wp12-gray_main_1.jpg','image',0),(3185,90,'/w/p/wp12-gray_back_1.jpg','image',0),(3186,90,'/w/p/wp13-blue_main_1.jpg','image',0),(3187,90,'/w/p/wp13-green_main_1.jpg','image',0),(3188,90,'/w/p/wp13-orange_main_1.jpg','image',0),(3189,90,'/w/p/wp13-orange_back_1.jpg','image',0),(3190,90,'/w/p/wp13-blue_main_1.jpg','image',0),(3191,90,'/w/p/wp13-green_main_1.jpg','image',0),(3192,90,'/w/p/wp13-orange_main_1.jpg','image',0),(3193,90,'/w/p/wp13-orange_back_1.jpg','image',0),(3194,90,'/w/p/wp13-orange_main_1.jpg','image',0),(3195,90,'/w/p/wp13-orange_back_1.jpg','image',0),(3196,90,'/w/s/wsh01-black_main_1.jpg','image',0),(3197,90,'/w/s/wsh01-black_back_1.jpg','image',0),(3198,90,'/w/s/wsh01-green_main_1.jpg','image',0),(3199,90,'/w/s/wsh01-red_main_1.jpg','image',0),(3200,90,'/w/s/wsh01-black_main_1.jpg','image',0),(3201,90,'/w/s/wsh01-black_back_1.jpg','image',0),(3202,90,'/w/s/wsh01-green_main_1.jpg','image',0),(3203,90,'/w/s/wsh01-red_main_1.jpg','image',0),(3204,90,'/w/s/wsh01-black_main_1.jpg','image',0),(3205,90,'/w/s/wsh01-black_back_1.jpg','image',0),(3206,90,'/w/s/wsh01-green_main_1.jpg','image',0),(3207,90,'/w/s/wsh01-red_main_1.jpg','image',0),(3208,90,'/w/s/wsh01-black_main_1.jpg','image',0),(3209,90,'/w/s/wsh01-black_back_1.jpg','image',0),(3210,90,'/w/s/wsh01-green_main_1.jpg','image',0),(3211,90,'/w/s/wsh01-red_main_1.jpg','image',0),(3212,90,'/w/s/wsh01-black_main_1.jpg','image',0),(3213,90,'/w/s/wsh01-black_back_1.jpg','image',0),(3214,90,'/w/s/wsh01-green_main_1.jpg','image',0),(3215,90,'/w/s/wsh01-red_main_1.jpg','image',0),(3216,90,'/w/s/wsh01-black_main_1.jpg','image',0),(3217,90,'/w/s/wsh01-black_back_1.jpg','image',0),(3218,90,'/w/s/wsh02-gray_main_1.jpg','image',0),(3219,90,'/w/s/wsh02-gray_back_1.jpg','image',0),(3220,90,'/w/s/wsh02-orange_main_1.jpg','image',0),(3221,90,'/w/s/wsh02-yellow_main_1.jpg','image',0),(3222,90,'/w/s/wsh02-gray_main_1.jpg','image',0),(3223,90,'/w/s/wsh02-gray_back_1.jpg','image',0),(3224,90,'/w/s/wsh02-orange_main_1.jpg','image',0),(3225,90,'/w/s/wsh02-yellow_main_1.jpg','image',0),(3226,90,'/w/s/wsh02-gray_main_1.jpg','image',0),(3227,90,'/w/s/wsh02-gray_back_1.jpg','image',0),(3228,90,'/w/s/wsh02-orange_main_1.jpg','image',0),(3229,90,'/w/s/wsh02-yellow_main_1.jpg','image',0),(3230,90,'/w/s/wsh02-gray_main_1.jpg','image',0),(3231,90,'/w/s/wsh02-gray_back_1.jpg','image',0),(3232,90,'/w/s/wsh02-orange_main_1.jpg','image',0),(3233,90,'/w/s/wsh02-yellow_main_1.jpg','image',0),(3234,90,'/w/s/wsh02-gray_main_1.jpg','image',0),(3235,90,'/w/s/wsh02-gray_back_1.jpg','image',0),(3236,90,'/w/s/wsh02-orange_main_1.jpg','image',0),(3237,90,'/w/s/wsh02-yellow_main_1.jpg','image',0),(3238,90,'/w/s/wsh02-gray_main_1.jpg','image',0),(3239,90,'/w/s/wsh02-gray_back_1.jpg','image',0),(3240,90,'/w/s/wsh03-blue_main_1.jpg','image',0),(3241,90,'/w/s/wsh03-gray_main_1.jpg','image',0),(3242,90,'/w/s/wsh03-gray_alt1_1.jpg','image',0),(3243,90,'/w/s/wsh03-gray_back_1.jpg','image',0),(3244,90,'/w/s/wsh03-orange_main_1.jpg','image',0),(3245,90,'/w/s/wsh03-blue_main_1.jpg','image',0),(3246,90,'/w/s/wsh03-gray_main_1.jpg','image',0),(3247,90,'/w/s/wsh03-gray_alt1_1.jpg','image',0),(3248,90,'/w/s/wsh03-gray_back_1.jpg','image',0),(3249,90,'/w/s/wsh03-orange_main_1.jpg','image',0),(3250,90,'/w/s/wsh03-blue_main_1.jpg','image',0),(3251,90,'/w/s/wsh03-gray_main_1.jpg','image',0),(3252,90,'/w/s/wsh03-gray_alt1_1.jpg','image',0),(3253,90,'/w/s/wsh03-gray_back_1.jpg','image',0),(3254,90,'/w/s/wsh03-orange_main_1.jpg','image',0),(3255,90,'/w/s/wsh03-blue_main_1.jpg','image',0),(3256,90,'/w/s/wsh03-gray_main_1.jpg','image',0),(3257,90,'/w/s/wsh03-gray_alt1_1.jpg','image',0),(3258,90,'/w/s/wsh03-gray_back_1.jpg','image',0),(3259,90,'/w/s/wsh03-orange_main_2.jpg','image',0),(3260,90,'/w/s/wsh03-blue_main_2.jpg','image',0),(3261,90,'/w/s/wsh03-gray_main_2.jpg','image',0),(3262,90,'/w/s/wsh03-gray_alt1_2.jpg','image',0),(3263,90,'/w/s/wsh03-gray_back_2.jpg','image',0),(3264,90,'/w/s/wsh03-orange_main_2.jpg','image',0),(3265,90,'/w/s/wsh03-gray_main_2.jpg','image',0),(3266,90,'/w/s/wsh03-gray_alt1_2.jpg','image',0),(3267,90,'/w/s/wsh03-gray_back_2.jpg','image',0),(3268,90,'/w/s/wsh04-black_main_1.jpg','image',0),(3269,90,'/w/s/wsh04-black_alt1_1.jpg','image',0),(3270,90,'/w/s/wsh04-black_back_1.jpg','image',0),(3271,90,'/w/s/wsh04-green_main_1.jpg','image',0),(3272,90,'/w/s/wsh04-orange_main_1.jpg','image',0),(3273,90,'/w/s/wsh04-black_main_1.jpg','image',0),(3274,90,'/w/s/wsh04-black_alt1_1.jpg','image',0),(3275,90,'/w/s/wsh04-black_back_1.jpg','image',0),(3276,90,'/w/s/wsh04-green_main_1.jpg','image',0),(3277,90,'/w/s/wsh04-orange_main_1.jpg','image',0),(3278,90,'/w/s/wsh04-black_main_1.jpg','image',0),(3279,90,'/w/s/wsh04-black_alt1_1.jpg','image',0),(3280,90,'/w/s/wsh04-black_back_1.jpg','image',0),(3281,90,'/w/s/wsh04-green_main_1.jpg','image',0),(3282,90,'/w/s/wsh04-orange_main_1.jpg','image',0),(3283,90,'/w/s/wsh04-black_main_1.jpg','image',0),(3284,90,'/w/s/wsh04-black_alt1_1.jpg','image',0),(3285,90,'/w/s/wsh04-black_back_1.jpg','image',0),(3286,90,'/w/s/wsh04-green_main_1.jpg','image',0),(3287,90,'/w/s/wsh04-orange_main_1.jpg','image',0),(3288,90,'/w/s/wsh04-black_main_1.jpg','image',0),(3289,90,'/w/s/wsh04-black_alt1_1.jpg','image',0),(3290,90,'/w/s/wsh04-black_back_1.jpg','image',0),(3291,90,'/w/s/wsh04-green_main_1.jpg','image',0),(3292,90,'/w/s/wsh04-orange_main_1.jpg','image',0),(3293,90,'/w/s/wsh04-black_main_1.jpg','image',0),(3294,90,'/w/s/wsh04-black_alt1_1.jpg','image',0),(3295,90,'/w/s/wsh04-black_back_1.jpg','image',0),(3296,90,'/w/s/wsh05-blue_main_1.jpg','image',0),(3297,90,'/w/s/wsh05-blue_back_1.jpg','image',0),(3298,90,'/w/s/wsh05-purple_main_1.jpg','image',0),(3299,90,'/w/s/wsh05-yellow_main_1.jpg','image',0),(3300,90,'/w/s/wsh05-blue_main_1.jpg','image',0),(3301,90,'/w/s/wsh05-blue_back_1.jpg','image',0),(3302,90,'/w/s/wsh05-purple_main_1.jpg','image',0),(3303,90,'/w/s/wsh05-yellow_main_1.jpg','image',0),(3304,90,'/w/s/wsh05-blue_main_1.jpg','image',0),(3305,90,'/w/s/wsh05-blue_back_1.jpg','image',0),(3306,90,'/w/s/wsh05-purple_main_1.jpg','image',0),(3307,90,'/w/s/wsh05-yellow_main_1.jpg','image',0),(3308,90,'/w/s/wsh05-blue_main_1.jpg','image',0),(3309,90,'/w/s/wsh05-blue_back_1.jpg','image',0),(3310,90,'/w/s/wsh05-purple_main_1.jpg','image',0),(3311,90,'/w/s/wsh05-yellow_main_1.jpg','image',0),(3312,90,'/w/s/wsh05-blue_main_1.jpg','image',0),(3313,90,'/w/s/wsh05-blue_back_1.jpg','image',0),(3314,90,'/w/s/wsh05-purple_main_1.jpg','image',0),(3315,90,'/w/s/wsh05-yellow_main_1.jpg','image',0),(3316,90,'/w/s/wsh05-blue_main_1.jpg','image',0),(3317,90,'/w/s/wsh05-blue_back_1.jpg','image',0),(3318,90,'/w/s/wsh06-gray_main_1.jpg','image',0),(3319,90,'/w/s/wsh06-gray_alt1_1.jpg','image',0),(3320,90,'/w/s/wsh06-gray_back_1.jpg','image',0),(3321,90,'/w/s/wsh06-orange_main_1.jpg','image',0),(3322,90,'/w/s/wsh06-purple_main_1.jpg','image',0),(3323,90,'/w/s/wsh06-gray_main_1.jpg','image',0),(3324,90,'/w/s/wsh06-gray_alt1_1.jpg','image',0),(3325,90,'/w/s/wsh06-gray_back_1.jpg','image',0),(3326,90,'/w/s/wsh06-orange_main_1.jpg','image',0),(3327,90,'/w/s/wsh06-purple_main_1.jpg','image',0),(3328,90,'/w/s/wsh06-gray_main_1.jpg','image',0),(3329,90,'/w/s/wsh06-gray_alt1_1.jpg','image',0),(3330,90,'/w/s/wsh06-gray_back_1.jpg','image',0),(3331,90,'/w/s/wsh07-black_main_1.jpg','image',0),(3332,90,'/w/s/wsh07-black_back_1.jpg','image',0),(3333,90,'/w/s/wsh07-blue_main_1.jpg','image',0),(3334,90,'/w/s/wsh07-purple_main_1.jpg','image',0),(3335,90,'/w/s/wsh07-black_main_1.jpg','image',0),(3336,90,'/w/s/wsh07-black_back_1.jpg','image',0),(3337,90,'/w/s/wsh07-blue_main_1.jpg','image',0),(3338,90,'/w/s/wsh07-purple_main_1.jpg','image',0),(3339,90,'/w/s/wsh07-black_main_1.jpg','image',0),(3340,90,'/w/s/wsh07-black_back_1.jpg','image',0),(3341,90,'/w/s/wsh08-purple_main_1.jpg','image',0),(3342,90,'/w/s/wsh08-purple_back_1.jpg','image',0),(3343,90,'/w/s/wsh08-purple_main_1.jpg','image',0),(3344,90,'/w/s/wsh08-purple_back_1.jpg','image',0),(3345,90,'/w/s/wsh08-purple_main_1.jpg','image',0),(3346,90,'/w/s/wsh08-purple_back_1.jpg','image',0),(3347,90,'/w/s/wsh08-purple_main_1.jpg','image',0),(3348,90,'/w/s/wsh08-purple_back_1.jpg','image',0),(3349,90,'/w/s/wsh08-purple_main_1.jpg','image',0),(3350,90,'/w/s/wsh08-purple_back_1.jpg','image',0),(3351,90,'/w/s/wsh08-purple_main_1.jpg','image',0),(3352,90,'/w/s/wsh08-purple_back_1.jpg','image',0),(3353,90,'/w/s/wsh09-gray_main_1.jpg','image',0),(3354,90,'/w/s/wsh09-gray_alt1_1.jpg','image',0),(3355,90,'/w/s/wsh09-gray_back_1.jpg','image',0),(3356,90,'/w/s/wsh09-green_main_1.jpg','image',0),(3357,90,'/w/s/wsh09-white_main_1.jpg','image',0),(3358,90,'/w/s/wsh09-gray_main_1.jpg','image',0),(3359,90,'/w/s/wsh09-gray_alt1_1.jpg','image',0),(3360,90,'/w/s/wsh09-gray_back_1.jpg','image',0),(3361,90,'/w/s/wsh09-green_main_1.jpg','image',0),(3362,90,'/w/s/wsh09-white_main_1.jpg','image',0),(3363,90,'/w/s/wsh09-gray_main_1.jpg','image',0),(3364,90,'/w/s/wsh09-gray_alt1_1.jpg','image',0),(3365,90,'/w/s/wsh09-gray_back_1.jpg','image',0),(3366,90,'/w/s/wsh10-black_main_1.jpg','image',0),(3367,90,'/w/s/wsh10-black_alt1_1.jpg','image',0),(3368,90,'/w/s/wsh10-black_back_1.jpg','image',0),(3369,90,'/w/s/wsh10-orange_main_1.jpg','image',0),(3370,90,'/w/s/wsh10-white_main_1.jpg','image',0),(3371,90,'/w/s/wsh10-black_main_1.jpg','image',0),(3372,90,'/w/s/wsh10-black_alt1_1.jpg','image',0),(3373,90,'/w/s/wsh10-black_back_1.jpg','image',0),(3374,90,'/w/s/wsh10-orange_main_1.jpg','image',0),(3375,90,'/w/s/wsh10-white_main_1.jpg','image',0),(3376,90,'/w/s/wsh10-black_main_1.jpg','image',0),(3377,90,'/w/s/wsh10-black_alt1_1.jpg','image',0),(3378,90,'/w/s/wsh10-black_back_1.jpg','image',0),(3379,90,'/w/s/wsh11-blue_main_1.jpg','image',0),(3380,90,'/w/s/wsh11-blue_back_1.jpg','image',0),(3381,90,'/w/s/wsh11-orange_main_1.jpg','image',0),(3382,90,'/w/s/wsh11-red_main_1.jpg','image',0),(3383,90,'/w/s/wsh11-blue_main_1.jpg','image',0),(3384,90,'/w/s/wsh11-blue_back_1.jpg','image',0),(3385,90,'/w/s/wsh11-orange_main_1.jpg','image',0),(3386,90,'/w/s/wsh11-red_main_1.jpg','image',0),(3387,90,'/w/s/wsh11-blue_main_1.jpg','image',0),(3388,90,'/w/s/wsh11-blue_back_1.jpg','image',0),(3389,90,'/w/s/wsh12-green_main_1.jpg','image',0),(3390,90,'/w/s/wsh12-green_alt1_1.jpg','image',0),(3391,90,'/w/s/wsh12-green_back_1.jpg','image',0),(3392,90,'/w/s/wsh12-purple_main_1.jpg','image',0),(3393,90,'/w/s/wsh12-red_main_1.jpg','image',0),(3394,90,'/w/s/wsh12-green_main_1.jpg','image',0),(3395,90,'/w/s/wsh12-green_alt1_1.jpg','image',0),(3396,90,'/w/s/wsh12-green_back_1.jpg','image',0),(3397,90,'/w/s/wsh12-purple_main_1.jpg','image',0),(3398,90,'/w/s/wsh12-red_main_1.jpg','image',0),(3399,90,'/w/s/wsh12-green_main_1.jpg','image',0),(3400,90,'/w/s/wsh12-green_alt1_1.jpg','image',0),(3401,90,'/w/s/wsh12-green_back_1.jpg','image',0),(3402,90,'/w/s/wsh12-purple_main_1.jpg','image',0),(3403,90,'/w/s/wsh12-red_main_1.jpg','image',0),(3404,90,'/w/s/wsh12-green_main_1.jpg','image',0),(3405,90,'/w/s/wsh12-green_alt1_1.jpg','image',0),(3406,90,'/w/s/wsh12-green_back_1.jpg','image',0),(3407,90,'/w/s/wsh12-purple_main_1.jpg','image',0),(3408,90,'/w/s/wsh12-red_main_1.jpg','image',0),(3409,90,'/w/s/wsh12-green_main_1.jpg','image',0),(3410,90,'/w/s/wsh12-green_alt1_1.jpg','image',0),(3411,90,'/w/s/wsh12-green_back_1.jpg','image',0),(3412,90,'/w/s/wsh12-purple_main_1.jpg','image',0),(3413,90,'/w/s/wsh12-red_main_1.jpg','image',0),(3414,90,'/w/s/wsh12-green_main_1.jpg','image',0),(3415,90,'/w/s/wsh12-green_alt1_1.jpg','image',0),(3416,90,'/w/s/wsh12-green_back_1.jpg','image',0);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_media_gallery_value`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_media_gallery_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value` (
  `value_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Value ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `label` varchar(255) DEFAULT NULL COMMENT 'Label',
  `position` int unsigned DEFAULT NULL COMMENT 'Position',
  `disabled` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Disabled',
  `record_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Record ID',
  PRIMARY KEY (`record_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_STORE_ID` (`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_VALUE_ID` (`value_id`),
  KEY `[[DBPREFIX]]CAT_PRD_ENTT_MDA_GLR_VAL_ENTT_ID_VAL_ID_STORE_ID` (`entity_id`,`value_id`,`store_id`),
  CONSTRAINT `FK_CCAEA26D5065C2D6A7A1517EBBA6ED81` FOREIGN KEY (`value_id`) REFERENCES `[[dbprefix]]catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_MDA_GLR_VAL_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_MDA_GLR_VAL_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3417 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Media Gallery Attribute Value Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_media_gallery_value`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_media_gallery_value` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_media_gallery_value` VALUES (1,0,1,'Image',1,0,1),(2,0,2,'Image',1,0,2),(3,0,2,'Image',2,0,3),(4,0,3,'Image',1,0,4),(5,0,3,'Image',2,0,5),(6,0,4,'Image',1,0,6),(7,0,5,'Image',1,0,7),(8,0,6,'Image',1,0,8),(9,0,6,'Image',2,0,9),(10,0,7,'Image',1,0,10),(11,0,8,'Image',1,0,11),(12,0,9,'Image',1,0,12),(13,0,10,'Image',1,0,13),(14,0,11,'Image',1,0,14),(15,0,11,'Image',2,0,15),(16,0,12,'Image',1,0,16),(17,0,13,'Image',1,0,17),(18,0,14,'Image',1,0,18),(19,0,15,'Image',1,0,19),(20,0,16,'Image',1,0,20),(21,0,16,'Image',2,0,21),(22,0,17,'Image',1,0,22),(23,0,18,'Image',1,0,23),(24,0,19,'Image',1,0,24),(25,0,20,'Image',1,0,25),(26,0,21,'Image',1,0,26),(27,0,22,'Image',1,0,27),(28,0,23,'Image',1,0,28),(29,0,24,'Image',1,0,29),(30,0,25,'Image',1,0,30),(31,0,26,'Image',1,0,31),(32,0,27,'Image',1,0,32),(33,0,28,'Image',1,0,33),(34,0,29,'Image',1,0,34),(35,0,30,'Image',1,0,35),(36,0,31,'Image',1,0,36),(37,0,32,'Image',1,0,37),(38,0,33,'Image',1,0,38),(39,0,34,'Image',1,0,39),(40,0,35,'Image',1,0,40),(41,0,36,'Image',1,0,41),(42,0,37,'Image',1,0,42),(43,0,38,'Image',1,0,43),(44,0,39,'Image',1,0,44),(45,0,40,'Image',1,0,45),(46,0,41,'Image',1,0,46),(47,0,42,'Image',1,0,47),(48,0,43,'Image',1,0,48),(49,0,43,'Image',2,0,49),(50,0,44,'Image',1,0,50),(51,0,45,'Image',1,0,51),(52,0,46,'Image',1,0,52),(53,0,47,'',1,0,53),(54,0,48,'',1,0,54),(55,0,48,'',2,0,55),(56,0,48,'',3,0,56),(57,0,49,'',1,0,57),(58,0,50,'',1,0,58),(59,0,51,'',1,0,59),(60,0,51,'',2,0,60),(61,0,51,'',3,0,61),(62,0,52,'',1,0,62),(63,0,53,'',1,0,63),(64,0,54,'',1,0,64),(65,0,54,'',2,0,65),(66,0,54,'',3,0,66),(67,0,55,'',1,0,67),(68,0,56,'',1,0,68),(69,0,57,'',1,0,69),(70,0,57,'',2,0,70),(71,0,57,'',3,0,71),(72,0,58,'',1,0,72),(73,0,59,'',1,0,73),(74,0,60,'',1,0,74),(75,0,60,'',2,0,75),(76,0,60,'',3,0,76),(77,0,61,'',1,0,77),(78,0,62,'',1,0,78),(79,0,62,'',2,0,79),(80,0,62,'',3,0,80),(81,0,63,'',1,0,81),(82,0,63,'',2,0,82),(83,0,63,'',3,0,83),(84,0,64,'',1,0,84),(85,0,65,'',1,0,85),(86,0,66,'',1,0,86),(87,0,66,'',2,0,87),(88,0,66,'',3,0,88),(89,0,67,'',1,0,89),(90,0,68,'',1,0,90),(91,0,69,'',1,0,91),(92,0,69,'',2,0,92),(93,0,69,'',3,0,93),(94,0,70,'',1,0,94),(95,0,71,'',1,0,95),(96,0,72,'',1,0,96),(97,0,72,'',2,0,97),(98,0,72,'',3,0,98),(99,0,73,'',1,0,99),(100,0,74,'',1,0,100),(101,0,75,'',1,0,101),(102,0,75,'',2,0,102),(103,0,75,'',3,0,103),(104,0,76,'',1,0,104),(105,0,77,'',1,0,105),(106,0,78,'',1,0,106),(107,0,78,'',2,0,107),(108,0,78,'',3,0,108),(109,0,79,'',1,0,109),(110,0,79,'',2,0,110),(111,0,79,'',3,0,111),(112,0,80,'',1,0,112),(113,0,81,'',1,0,113),(114,0,82,'',1,0,114),(115,0,82,'',2,0,115),(116,0,82,'',3,0,116),(117,0,83,'',1,0,117),(118,0,84,'',1,0,118),(119,0,85,'',1,0,119),(120,0,85,'',2,0,120),(121,0,85,'',3,0,121),(122,0,86,'',1,0,122),(123,0,87,'',1,0,123),(124,0,88,'',1,0,124),(125,0,88,'',2,0,125),(126,0,88,'',3,0,126),(127,0,89,'',1,0,127),(128,0,90,'',1,0,128),(129,0,91,'',1,0,129),(130,0,91,'',2,0,130),(131,0,91,'',3,0,131),(132,0,92,'',1,0,132),(133,0,93,'',1,0,133),(134,0,94,'',1,0,134),(135,0,94,'',2,0,135),(136,0,94,'',3,0,136),(137,0,95,'',1,0,137),(138,0,95,'',2,0,138),(139,0,95,'',3,0,139),(140,0,96,'',1,0,140),(141,0,97,'',1,0,141),(142,0,98,'',1,0,142),(143,0,98,'',2,0,143),(144,0,98,'',3,0,144),(145,0,99,'',1,0,145),(146,0,100,'',1,0,146),(147,0,101,'',1,0,147),(148,0,101,'',2,0,148),(149,0,101,'',3,0,149),(150,0,102,'',1,0,150),(151,0,103,'',1,0,151),(152,0,104,'',1,0,152),(153,0,104,'',2,0,153),(154,0,104,'',3,0,154),(155,0,105,'',1,0,155),(156,0,106,'',1,0,156),(157,0,107,'',1,0,157),(158,0,107,'',2,0,158),(159,0,107,'',3,0,159),(160,0,108,'',1,0,160),(161,0,109,'',1,0,161),(162,0,110,'',1,0,162),(163,0,110,'',2,0,163),(164,0,110,'',3,0,164),(165,0,111,'',1,0,165),(166,0,112,'',1,0,166),(167,0,113,'',1,0,167),(168,0,113,'',2,0,168),(169,0,113,'',3,0,169),(170,0,114,'',1,0,170),(171,0,115,'',1,0,171),(172,0,116,'',1,0,172),(173,0,116,'',2,0,173),(174,0,116,'',3,0,174),(175,0,117,'',1,0,175),(176,0,118,'',1,0,176),(177,0,119,'',1,0,177),(178,0,119,'',2,0,178),(179,0,119,'',3,0,179),(180,0,120,'',1,0,180),(181,0,121,'',1,0,181),(182,0,122,'',1,0,182),(183,0,122,'',2,0,183),(184,0,122,'',3,0,184),(185,0,123,'',1,0,185),(186,0,124,'',1,0,186),(187,0,125,'',1,0,187),(188,0,125,'',2,0,188),(189,0,125,'',3,0,189),(190,0,126,'',1,0,190),(191,0,126,'',2,0,191),(192,0,126,'',3,0,192),(193,0,127,'',1,0,193),(194,0,128,'',1,0,194),(195,0,128,'',2,0,195),(196,0,128,'',3,0,196),(197,0,129,'',1,0,197),(198,0,130,'',1,0,198),(199,0,131,'',1,0,199),(200,0,131,'',2,0,200),(201,0,131,'',3,0,201),(202,0,132,'',1,0,202),(203,0,133,'',1,0,203),(204,0,134,'',1,0,204),(205,0,134,'',2,0,205),(206,0,134,'',3,0,206),(207,0,135,'',1,0,207),(208,0,136,'',1,0,208),(209,0,137,'',1,0,209),(210,0,137,'',2,0,210),(211,0,137,'',3,0,211),(212,0,138,'',1,0,212),(213,0,139,'',1,0,213),(214,0,140,'',1,0,214),(215,0,140,'',2,0,215),(216,0,140,'',3,0,216),(217,0,141,'',1,0,217),(218,0,142,'',1,0,218),(219,0,142,'',2,0,219),(220,0,142,'',3,0,220),(221,0,143,'',1,0,221),(222,0,144,'',1,0,222),(223,0,144,'',2,0,223),(224,0,144,'',3,0,224),(225,0,145,'',1,0,225),(226,0,146,'',1,0,226),(227,0,147,'',1,0,227),(228,0,147,'',2,0,228),(229,0,147,'',3,0,229),(230,0,148,'',1,0,230),(231,0,149,'',1,0,231),(232,0,150,'',1,0,232),(233,0,150,'',2,0,233),(234,0,150,'',3,0,234),(235,0,151,'',1,0,235),(236,0,152,'',1,0,236),(237,0,153,'',1,0,237),(238,0,153,'',2,0,238),(239,0,153,'',3,0,239),(240,0,154,'',1,0,240),(241,0,155,'',1,0,241),(242,0,156,'',1,0,242),(243,0,156,'',2,0,243),(244,0,156,'',3,0,244),(245,0,157,'',1,0,245),(246,0,158,'',1,0,246),(247,0,158,'',2,0,247),(248,0,158,'',3,0,248),(249,0,159,'',1,0,249),(250,0,159,'',2,0,250),(251,0,159,'',3,0,251),(252,0,160,'',1,0,252),(253,0,161,'',1,0,253),(254,0,162,'',1,0,254),(255,0,162,'',2,0,255),(256,0,162,'',3,0,256),(257,0,163,'',1,0,257),(258,0,164,'',1,0,258),(259,0,165,'',1,0,259),(260,0,165,'',2,0,260),(261,0,165,'',3,0,261),(262,0,166,'',1,0,262),(263,0,167,'',1,0,263),(264,0,168,'',1,0,264),(265,0,168,'',2,0,265),(266,0,168,'',3,0,266),(267,0,169,'',1,0,267),(268,0,170,'',1,0,268),(269,0,171,'',1,0,269),(270,0,171,'',2,0,270),(271,0,171,'',3,0,271),(272,0,172,'',1,0,272),(273,0,173,'',1,0,273),(274,0,174,'',1,0,274),(275,0,174,'',2,0,275),(276,0,174,'',3,0,276),(277,0,175,'',1,0,277),(278,0,175,'',2,0,278),(279,0,175,'',3,0,279),(280,0,176,'',1,0,280),(281,0,177,'',1,0,281),(282,0,178,'',1,0,282),(283,0,178,'',2,0,283),(284,0,178,'',3,0,284),(285,0,179,'',1,0,285),(286,0,180,'',1,0,286),(287,0,181,'',1,0,287),(288,0,181,'',2,0,288),(289,0,181,'',3,0,289),(290,0,182,'',1,0,290),(291,0,183,'',1,0,291),(292,0,184,'',1,0,292),(293,0,184,'',2,0,293),(294,0,184,'',3,0,294),(295,0,185,'',1,0,295),(296,0,186,'',1,0,296),(297,0,187,'',1,0,297),(298,0,187,'',2,0,298),(299,0,187,'',3,0,299),(300,0,188,'',1,0,300),(301,0,189,'',1,0,301),(302,0,190,'',1,0,302),(303,0,190,'',2,0,303),(304,0,190,'',3,0,304),(305,0,191,'',1,0,305),(306,0,192,'',1,0,306),(307,0,192,'',2,0,307),(308,0,192,'',3,0,308),(309,0,193,'',1,0,309),(310,0,194,'',1,0,310),(311,0,195,'',1,0,311),(312,0,195,'',2,0,312),(313,0,195,'',3,0,313),(314,0,196,'',1,0,314),(315,0,197,'',1,0,315),(316,0,198,'',1,0,316),(317,0,198,'',2,0,317),(318,0,198,'',3,0,318),(319,0,199,'',1,0,319),(320,0,200,'',1,0,320),(321,0,201,'',1,0,321),(322,0,201,'',2,0,322),(323,0,201,'',3,0,323),(324,0,202,'',1,0,324),(325,0,203,'',1,0,325),(326,0,204,'',1,0,326),(327,0,204,'',2,0,327),(328,0,204,'',3,0,328),(329,0,205,'',1,0,329),(330,0,206,'',1,0,330),(331,0,206,'',2,0,331),(332,0,206,'',3,0,332),(333,0,207,'',1,0,333),(334,0,208,'',1,0,334),(335,0,209,'',1,0,335),(336,0,209,'',2,0,336),(337,0,209,'',3,0,337),(338,0,210,'',1,0,338),(339,0,211,'',1,0,339),(340,0,212,'',1,0,340),(341,0,212,'',2,0,341),(342,0,212,'',3,0,342),(343,0,213,'',1,0,343),(344,0,214,'',1,0,344),(345,0,215,'',1,0,345),(346,0,215,'',2,0,346),(347,0,215,'',3,0,347),(348,0,216,'',1,0,348),(349,0,217,'',1,0,349),(350,0,218,'',1,0,350),(351,0,218,'',2,0,351),(352,0,218,'',3,0,352),(353,0,219,'',1,0,353),(354,0,220,'',1,0,354),(355,0,221,'',1,0,355),(356,0,221,'',2,0,356),(357,0,221,'',3,0,357),(358,0,222,'',1,0,358),(359,0,222,'',2,0,359),(360,0,222,'',3,0,360),(361,0,223,'',1,0,361),(362,0,224,'',1,0,362),(363,0,224,'',2,0,363),(364,0,224,'',3,0,364),(365,0,225,'',1,0,365),(366,0,226,'',1,0,366),(367,0,227,'',1,0,367),(368,0,227,'',2,0,368),(369,0,227,'',3,0,369),(370,0,228,'',1,0,370),(371,0,229,'',1,0,371),(372,0,230,'',1,0,372),(373,0,230,'',2,0,373),(374,0,230,'',3,0,374),(375,0,231,'',1,0,375),(376,0,232,'',1,0,376),(377,0,233,'',1,0,377),(378,0,233,'',2,0,378),(379,0,233,'',3,0,379),(380,0,234,'',1,0,380),(381,0,235,'',1,0,381),(382,0,236,'',1,0,382),(383,0,236,'',2,0,383),(384,0,236,'',3,0,384),(385,0,237,'',1,0,385),(386,0,238,'',1,0,386),(387,0,238,'',2,0,387),(388,0,238,'',3,0,388),(389,0,239,'',1,0,389),(390,0,239,'',2,0,390),(391,0,239,'',3,0,391),(392,0,240,'',1,0,392),(393,0,241,'',1,0,393),(394,0,242,'',1,0,394),(395,0,242,'',2,0,395),(396,0,242,'',3,0,396),(397,0,243,'',1,0,397),(398,0,244,'',1,0,398),(399,0,245,'',1,0,399),(400,0,245,'',2,0,400),(401,0,245,'',3,0,401),(402,0,246,'',1,0,402),(403,0,247,'',1,0,403),(404,0,248,'',1,0,404),(405,0,248,'',2,0,405),(406,0,248,'',3,0,406),(407,0,249,'',1,0,407),(408,0,250,'',1,0,408),(409,0,251,'',1,0,409),(410,0,251,'',2,0,410),(411,0,251,'',3,0,411),(412,0,252,'',1,0,412),(413,0,253,'',1,0,413),(414,0,254,'',1,0,414),(415,0,254,'',2,0,415),(416,0,254,'',3,0,416),(417,0,255,'',1,0,417),(418,0,256,'',1,0,418),(419,0,257,'',1,0,419),(420,0,257,'',2,0,420),(421,0,257,'',3,0,421),(422,0,258,'',1,0,422),(423,0,259,'',1,0,423),(424,0,260,'',1,0,424),(425,0,260,'',2,0,425),(426,0,260,'',3,0,426),(427,0,261,'',1,0,427),(428,0,262,'',1,0,428),(429,0,263,'',1,0,429),(430,0,263,'',2,0,430),(431,0,263,'',3,0,431),(432,0,264,'',1,0,432),(433,0,265,'',1,0,433),(434,0,266,'',1,0,434),(435,0,266,'',2,0,435),(436,0,266,'',3,0,436),(437,0,267,'',1,0,437),(438,0,268,'',1,0,438),(439,0,269,'',1,0,439),(440,0,269,'',2,0,440),(441,0,269,'',3,0,441),(442,0,270,'',1,0,442),(443,0,270,'',2,0,443),(444,0,270,'',3,0,444),(445,0,271,'',1,0,445),(446,0,271,'',2,0,446),(447,0,271,'',3,0,447),(448,0,272,'',1,0,448),(449,0,273,'',1,0,449),(450,0,274,'',1,0,450),(451,0,274,'',2,0,451),(452,0,274,'',3,0,452),(453,0,275,'',1,0,453),(454,0,276,'',1,0,454),(455,0,277,'',1,0,455),(456,0,277,'',2,0,456),(457,0,277,'',3,0,457),(458,0,278,'',1,0,458),(459,0,279,'',1,0,459),(460,0,280,'',1,0,460),(461,0,280,'',2,0,461),(462,0,280,'',3,0,462),(463,0,281,'',1,0,463),(464,0,282,'',1,0,464),(465,0,283,'',1,0,465),(466,0,283,'',2,0,466),(467,0,283,'',3,0,467),(468,0,284,'',1,0,468),(469,0,285,'',1,0,469),(470,0,286,'',1,0,470),(471,0,286,'',2,0,471),(472,0,286,'',3,0,472),(473,0,287,'',1,0,473),(474,0,287,'',2,0,474),(475,0,287,'',3,0,475),(476,0,288,'',1,0,476),(477,0,289,'',1,0,477),(478,0,290,'',1,0,478),(479,0,290,'',2,0,479),(480,0,290,'',3,0,480),(481,0,291,'',1,0,481),(482,0,292,'',1,0,482),(483,0,293,'',1,0,483),(484,0,293,'',2,0,484),(485,0,293,'',3,0,485),(486,0,294,'',1,0,486),(487,0,295,'',1,0,487),(488,0,296,'',1,0,488),(489,0,296,'',2,0,489),(490,0,296,'',3,0,490),(491,0,297,'',1,0,491),(492,0,298,'',1,0,492),(493,0,299,'',1,0,493),(494,0,299,'',2,0,494),(495,0,299,'',3,0,495),(496,0,300,'',1,0,496),(497,0,301,'',1,0,497),(498,0,302,'',1,0,498),(499,0,302,'',2,0,499),(500,0,302,'',3,0,500),(501,0,303,'',1,0,501),(502,0,304,'',1,0,502),(503,0,304,'',2,0,503),(504,0,304,'',3,0,504),(505,0,305,'',1,0,505),(506,0,306,'',1,0,506),(507,0,307,'',1,0,507),(508,0,307,'',2,0,508),(509,0,307,'',3,0,509),(510,0,308,'',1,0,510),(511,0,309,'',1,0,511),(512,0,310,'',1,0,512),(513,0,310,'',2,0,513),(514,0,310,'',3,0,514),(515,0,311,'',1,0,515),(516,0,312,'',1,0,516),(517,0,313,'',1,0,517),(518,0,313,'',2,0,518),(519,0,313,'',3,0,519),(520,0,314,'',1,0,520),(521,0,315,'',1,0,521),(522,0,316,'',1,0,522),(523,0,316,'',2,0,523),(524,0,316,'',3,0,524),(525,0,317,'',1,0,525),(526,0,318,'',1,0,526),(527,0,318,'',2,0,527),(528,0,318,'',3,0,528),(529,0,319,'',1,0,529),(530,0,320,'',1,0,530),(531,0,320,'',2,0,531),(532,0,320,'',3,0,532),(533,0,321,'',1,0,533),(534,0,322,'',1,0,534),(535,0,323,'',1,0,535),(536,0,323,'',2,0,536),(537,0,323,'',3,0,537),(538,0,324,'',1,0,538),(539,0,325,'',1,0,539),(540,0,326,'',1,0,540),(541,0,326,'',2,0,541),(542,0,326,'',3,0,542),(543,0,327,'',1,0,543),(544,0,328,'',1,0,544),(545,0,329,'',1,0,545),(546,0,329,'',2,0,546),(547,0,329,'',3,0,547),(548,0,330,'',1,0,548),(549,0,331,'',1,0,549),(550,0,332,'',1,0,550),(551,0,332,'',2,0,551),(552,0,332,'',3,0,552),(553,0,333,'',1,0,553),(554,0,334,'',1,0,554),(555,0,334,'',2,0,555),(556,0,334,'',3,0,556),(557,0,335,'',1,0,557),(558,0,336,'',1,0,558),(559,0,337,'',1,0,559),(560,0,337,'',2,0,560),(561,0,337,'',3,0,561),(562,0,338,'',1,0,562),(563,0,339,'',1,0,563),(564,0,340,'',1,0,564),(565,0,340,'',2,0,565),(566,0,340,'',3,0,566),(567,0,341,'',1,0,567),(568,0,342,'',1,0,568),(569,0,343,'',1,0,569),(570,0,343,'',2,0,570),(571,0,343,'',3,0,571),(572,0,344,'',1,0,572),(573,0,345,'',1,0,573),(574,0,346,'',1,0,574),(575,0,346,'',2,0,575),(576,0,346,'',3,0,576),(577,0,347,'',1,0,577),(578,0,348,'',1,0,578),(579,0,349,'',1,0,579),(580,0,349,'',2,0,580),(581,0,349,'',3,0,581),(582,0,350,'',1,0,582),(583,0,350,'',2,0,583),(584,0,350,'',3,0,584),(585,0,351,'',1,0,585),(586,0,352,'',1,0,586),(587,0,353,'',1,0,587),(588,0,353,'',2,0,588),(589,0,353,'',3,0,589),(590,0,354,'',1,0,590),(591,0,355,'',1,0,591),(592,0,356,'',1,0,592),(593,0,356,'',2,0,593),(594,0,356,'',3,0,594),(595,0,357,'',1,0,595),(596,0,358,'',1,0,596),(597,0,359,'',1,0,597),(598,0,359,'',2,0,598),(599,0,359,'',3,0,599),(600,0,360,'',1,0,600),(601,0,361,'',1,0,601),(602,0,362,'',1,0,602),(603,0,362,'',2,0,603),(604,0,362,'',3,0,604),(605,0,363,'',1,0,605),(606,0,364,'',1,0,606),(607,0,365,'',1,0,607),(608,0,365,'',2,0,608),(609,0,365,'',3,0,609),(610,0,366,'',1,0,610),(611,0,366,'',2,0,611),(612,0,366,'',3,0,612),(613,0,367,'',1,0,613),(614,0,367,'',2,0,614),(615,0,367,'',3,0,615),(616,0,368,'',1,0,616),(617,0,369,'',1,0,617),(618,0,370,'',1,0,618),(619,0,370,'',2,0,619),(620,0,370,'',3,0,620),(621,0,371,'',1,0,621),(622,0,372,'',1,0,622),(623,0,373,'',1,0,623),(624,0,373,'',2,0,624),(625,0,373,'',3,0,625),(626,0,374,'',1,0,626),(627,0,375,'',1,0,627),(628,0,376,'',1,0,628),(629,0,376,'',2,0,629),(630,0,376,'',3,0,630),(631,0,377,'',1,0,631),(632,0,378,'',1,0,632),(633,0,379,'',1,0,633),(634,0,379,'',2,0,634),(635,0,379,'',3,0,635),(636,0,380,'',1,0,636),(637,0,381,'',1,0,637),(638,0,382,'',1,0,638),(639,0,382,'',2,0,639),(640,0,382,'',3,0,640),(641,0,383,'',1,0,641),(642,0,383,'',2,0,642),(643,0,383,'',3,0,643),(644,0,384,'',1,0,644),(645,0,385,'',1,0,645),(646,0,386,'',1,0,646),(647,0,386,'',2,0,647),(648,0,386,'',3,0,648),(649,0,387,'',1,0,649),(650,0,388,'',1,0,650),(651,0,389,'',1,0,651),(652,0,389,'',2,0,652),(653,0,389,'',3,0,653),(654,0,390,'',1,0,654),(655,0,391,'',1,0,655),(656,0,392,'',1,0,656),(657,0,392,'',2,0,657),(658,0,392,'',3,0,658),(659,0,393,'',1,0,659),(660,0,394,'',1,0,660),(661,0,395,'',1,0,661),(662,0,395,'',2,0,662),(663,0,395,'',3,0,663),(664,0,396,'',1,0,664),(665,0,397,'',1,0,665),(666,0,398,'',1,0,666),(667,0,398,'',2,0,667),(668,0,398,'',3,0,668),(669,0,399,'',1,0,669),(670,0,399,'',2,0,670),(671,0,399,'',3,0,671),(672,0,400,'',1,0,672),(673,0,401,'',1,0,673),(674,0,402,'',1,0,674),(675,0,402,'',2,0,675),(676,0,402,'',3,0,676),(677,0,403,'',1,0,677),(678,0,404,'',1,0,678),(679,0,405,'',1,0,679),(680,0,405,'',2,0,680),(681,0,405,'',3,0,681),(682,0,406,'',1,0,682),(683,0,407,'',1,0,683),(684,0,408,'',1,0,684),(685,0,408,'',2,0,685),(686,0,408,'',3,0,686),(687,0,409,'',1,0,687),(688,0,410,'',1,0,688),(689,0,411,'',1,0,689),(690,0,411,'',2,0,690),(691,0,411,'',3,0,691),(692,0,412,'',1,0,692),(693,0,413,'',1,0,693),(694,0,414,'',1,0,694),(695,0,414,'',2,0,695),(696,0,414,'',3,0,696),(697,0,415,'',1,0,697),(698,0,416,'',1,0,698),(699,0,417,'',1,0,699),(700,0,417,'',2,0,700),(701,0,417,'',3,0,701),(702,0,418,'',1,0,702),(703,0,419,'',1,0,703),(704,0,420,'',1,0,704),(705,0,420,'',2,0,705),(706,0,420,'',3,0,706),(707,0,421,'',1,0,707),(708,0,422,'',1,0,708),(709,0,423,'',1,0,709),(710,0,423,'',2,0,710),(711,0,423,'',3,0,711),(712,0,424,'',1,0,712),(713,0,425,'',1,0,713),(714,0,426,'',1,0,714),(715,0,426,'',2,0,715),(716,0,426,'',3,0,716),(717,0,427,'',1,0,717),(718,0,428,'',1,0,718),(719,0,429,'',1,0,719),(720,0,429,'',2,0,720),(721,0,429,'',3,0,721),(722,0,430,'',1,0,722),(723,0,430,'',2,0,723),(724,0,430,'',3,0,724),(725,0,431,'',1,0,725),(726,0,432,'',1,0,726),(727,0,432,'',2,0,727),(728,0,433,'',1,0,728),(729,0,434,'',1,0,729),(730,0,435,'',1,0,730),(731,0,435,'',2,0,731),(732,0,436,'',1,0,732),(733,0,437,'',1,0,733),(734,0,438,'',1,0,734),(735,0,438,'',2,0,735),(736,0,439,'',1,0,736),(737,0,440,'',1,0,737),(738,0,441,'',1,0,738),(739,0,441,'',2,0,739),(740,0,442,'',1,0,740),(741,0,443,'',1,0,741),(742,0,444,'',1,0,742),(743,0,444,'',2,0,743),(744,0,445,'',1,0,744),(745,0,446,'',1,0,745),(746,0,446,'',2,0,746),(747,0,447,'',1,0,747),(748,0,448,'',1,0,748),(749,0,448,'',2,0,749),(750,0,449,'',1,0,750),(751,0,450,'',1,0,751),(752,0,451,'',1,0,752),(753,0,451,'',2,0,753),(754,0,452,'',1,0,754),(755,0,453,'',1,0,755),(756,0,454,'',1,0,756),(757,0,454,'',2,0,757),(758,0,455,'',1,0,758),(759,0,456,'',1,0,759),(760,0,457,'',1,0,760),(761,0,457,'',2,0,761),(762,0,458,'',1,0,762),(763,0,459,'',1,0,763),(764,0,460,'',1,0,764),(765,0,460,'',2,0,765),(766,0,461,'',1,0,766),(767,0,462,'',1,0,767),(768,0,462,'',2,0,768),(769,0,463,'',1,0,769),(770,0,464,'',1,0,770),(771,0,464,'',2,0,771),(772,0,464,'',3,0,772),(773,0,465,'',1,0,773),(774,0,466,'',1,0,774),(775,0,467,'',1,0,775),(776,0,467,'',2,0,776),(777,0,467,'',3,0,777),(778,0,468,'',1,0,778),(779,0,469,'',1,0,779),(780,0,470,'',1,0,780),(781,0,470,'',2,0,781),(782,0,470,'',3,0,782),(783,0,471,'',1,0,783),(784,0,472,'',1,0,784),(785,0,473,'',1,0,785),(786,0,473,'',2,0,786),(787,0,473,'',3,0,787),(788,0,474,'',1,0,788),(789,0,475,'',1,0,789),(790,0,476,'',1,0,790),(791,0,476,'',2,0,791),(792,0,476,'',3,0,792),(793,0,477,'',1,0,793),(794,0,478,'',1,0,794),(795,0,478,'',2,0,795),(796,0,478,'',3,0,796),(797,0,479,'',1,0,797),(798,0,480,'',1,0,798),(799,0,480,'',2,0,799),(800,0,481,'',1,0,800),(801,0,482,'',1,0,801),(802,0,483,'',1,0,802),(803,0,483,'',2,0,803),(804,0,484,'',1,0,804),(805,0,485,'',1,0,805),(806,0,486,'',1,0,806),(807,0,486,'',2,0,807),(808,0,487,'',1,0,808),(809,0,488,'',1,0,809),(810,0,489,'',1,0,810),(811,0,489,'',2,0,811),(812,0,490,'',1,0,812),(813,0,491,'',1,0,813),(814,0,492,'',1,0,814),(815,0,492,'',2,0,815),(816,0,493,'',1,0,816),(817,0,494,'',1,0,817),(818,0,494,'',2,0,818),(819,0,495,'',1,0,819),(820,0,496,'',1,0,820),(821,0,497,'',1,0,821),(822,0,497,'',2,0,822),(823,0,497,'',3,0,823),(824,0,498,'',1,0,824),(825,0,499,'',1,0,825),(826,0,500,'',1,0,826),(827,0,500,'',2,0,827),(828,0,500,'',3,0,828),(829,0,501,'',1,0,829),(830,0,502,'',1,0,830),(831,0,503,'',1,0,831),(832,0,503,'',2,0,832),(833,0,503,'',3,0,833),(834,0,504,'',1,0,834),(835,0,505,'',1,0,835),(836,0,506,'',1,0,836),(837,0,506,'',2,0,837),(838,0,506,'',3,0,838),(839,0,507,'',1,0,839),(840,0,508,'',1,0,840),(841,0,509,'',1,0,841),(842,0,509,'',2,0,842),(843,0,509,'',3,0,843),(844,0,510,'',1,0,844),(845,0,510,'',2,0,845),(846,0,510,'',3,0,846),(847,0,511,'',1,0,847),(848,0,511,'',2,0,848),(849,0,511,'',3,0,849),(850,0,512,'',1,0,850),(851,0,513,'',1,0,851),(852,0,514,'',1,0,852),(853,0,514,'',2,0,853),(854,0,514,'',3,0,854),(855,0,515,'',1,0,855),(856,0,516,'',1,0,856),(857,0,517,'',1,0,857),(858,0,517,'',2,0,858),(859,0,517,'',3,0,859),(860,0,518,'',1,0,860),(861,0,519,'',1,0,861),(862,0,520,'',1,0,862),(863,0,520,'',2,0,863),(864,0,520,'',3,0,864),(865,0,521,'',1,0,865),(866,0,522,'',1,0,866),(867,0,523,'',1,0,867),(868,0,523,'',2,0,868),(869,0,523,'',3,0,869),(870,0,524,'',1,0,870),(871,0,525,'',1,0,871),(872,0,526,'',1,0,872),(873,0,526,'',2,0,873),(874,0,527,'',1,0,874),(875,0,527,'',2,0,875),(876,0,527,'',3,0,876),(877,0,528,'',1,0,877),(878,0,529,'',1,0,878),(879,0,530,'',1,0,879),(880,0,530,'',2,0,880),(881,0,530,'',3,0,881),(882,0,531,'',1,0,882),(883,0,532,'',1,0,883),(884,0,533,'',1,0,884),(885,0,533,'',2,0,885),(886,0,533,'',3,0,886),(887,0,534,'',1,0,887),(888,0,535,'',1,0,888),(889,0,536,'',1,0,889),(890,0,536,'',2,0,890),(891,0,536,'',3,0,891),(892,0,537,'',1,0,892),(893,0,538,'',1,0,893),(894,0,539,'',1,0,894),(895,0,539,'',2,0,895),(896,0,539,'',3,0,896),(897,0,540,'',1,0,897),(898,0,541,'',1,0,898),(899,0,542,'',1,0,899),(900,0,542,'',2,0,900),(901,0,542,'',3,0,901),(902,0,543,'',1,0,902),(903,0,544,'',1,0,903),(904,0,544,'',2,0,904),(905,0,545,'',1,0,905),(906,0,546,'',1,0,906),(907,0,547,'',1,0,907),(908,0,547,'',2,0,908),(909,0,548,'',1,0,909),(910,0,549,'',1,0,910),(911,0,550,'',1,0,911),(912,0,550,'',2,0,912),(913,0,551,'',1,0,913),(914,0,552,'',1,0,914),(915,0,553,'',1,0,915),(916,0,553,'',2,0,916),(917,0,554,'',1,0,917),(918,0,555,'',1,0,918),(919,0,556,'',1,0,919),(920,0,556,'',2,0,920),(921,0,557,'',1,0,921),(922,0,558,'',1,0,922),(923,0,558,'',2,0,923),(924,0,559,'',1,0,924),(925,0,560,'',1,0,925),(926,0,561,'',1,0,926),(927,0,561,'',2,0,927),(928,0,561,'',3,0,928),(929,0,562,'',1,0,929),(930,0,563,'',1,0,930),(931,0,564,'',1,0,931),(932,0,564,'',2,0,932),(933,0,564,'',3,0,933),(934,0,565,'',1,0,934),(935,0,566,'',1,0,935),(936,0,567,'',1,0,936),(937,0,567,'',2,0,937),(938,0,567,'',3,0,938),(939,0,568,'',1,0,939),(940,0,569,'',1,0,940),(941,0,570,'',1,0,941),(942,0,570,'',2,0,942),(943,0,570,'',3,0,943),(944,0,571,'',1,0,944),(945,0,572,'',1,0,945),(946,0,573,'',1,0,946),(947,0,573,'',2,0,947),(948,0,573,'',3,0,948),(949,0,574,'',1,0,949),(950,0,574,'',2,0,950),(951,0,574,'',3,0,951),(952,0,575,'',1,0,952),(953,0,576,'',1,0,953),(954,0,576,'',2,0,954),(955,0,576,'',3,0,955),(956,0,577,'',1,0,956),(957,0,578,'',1,0,957),(958,0,579,'',1,0,958),(959,0,579,'',2,0,959),(960,0,579,'',3,0,960),(961,0,580,'',1,0,961),(962,0,581,'',1,0,962),(963,0,582,'',1,0,963),(964,0,582,'',2,0,964),(965,0,582,'',3,0,965),(966,0,583,'',1,0,966),(967,0,584,'',1,0,967),(968,0,585,'',1,0,968),(969,0,585,'',2,0,969),(970,0,585,'',3,0,970),(971,0,586,'',1,0,971),(972,0,587,'',1,0,972),(973,0,588,'',1,0,973),(974,0,588,'',2,0,974),(975,0,588,'',3,0,975),(976,0,589,'',1,0,976),(977,0,590,'',1,0,977),(978,0,590,'',2,0,978),(979,0,590,'',3,0,979),(980,0,591,'',1,0,980),(981,0,592,'',1,0,981),(982,0,592,'',2,0,982),(983,0,592,'',3,0,983),(984,0,593,'',1,0,984),(985,0,594,'',1,0,985),(986,0,595,'',1,0,986),(987,0,595,'',2,0,987),(988,0,595,'',3,0,988),(989,0,596,'',1,0,989),(990,0,597,'',1,0,990),(991,0,598,'',1,0,991),(992,0,598,'',2,0,992),(993,0,598,'',3,0,993),(994,0,599,'',1,0,994),(995,0,600,'',1,0,995),(996,0,601,'',1,0,996),(997,0,601,'',2,0,997),(998,0,601,'',3,0,998),(999,0,602,'',1,0,999),(1000,0,603,'',1,0,1000),(1001,0,604,'',1,0,1001),(1002,0,604,'',2,0,1002),(1003,0,604,'',3,0,1003),(1004,0,605,'',1,0,1004),(1005,0,606,'',1,0,1005),(1006,0,606,'',2,0,1006),(1007,0,606,'',3,0,1007),(1008,0,607,'',1,0,1008),(1009,0,607,'',2,0,1009),(1010,0,608,'',1,0,1010),(1011,0,609,'',1,0,1011),(1012,0,610,'',1,0,1012),(1013,0,610,'',2,0,1013),(1014,0,611,'',1,0,1014),(1015,0,612,'',1,0,1015),(1016,0,613,'',1,0,1016),(1017,0,613,'',2,0,1017),(1018,0,614,'',1,0,1018),(1019,0,615,'',1,0,1019),(1020,0,616,'',1,0,1020),(1021,0,616,'',2,0,1021),(1022,0,617,'',1,0,1022),(1023,0,618,'',1,0,1023),(1024,0,619,'',1,0,1024),(1025,0,619,'',2,0,1025),(1026,0,620,'',1,0,1026),(1027,0,621,'',1,0,1027),(1028,0,622,'',1,0,1028),(1029,0,622,'',2,0,1029),(1030,0,623,'',1,0,1030),(1031,0,624,'',1,0,1031),(1032,0,625,'',1,0,1032),(1033,0,625,'',2,0,1033),(1034,0,625,'',3,0,1034),(1035,0,626,'',1,0,1035),(1036,0,627,'',1,0,1036),(1037,0,628,'',1,0,1037),(1038,0,628,'',2,0,1038),(1039,0,628,'',3,0,1039),(1040,0,629,'',1,0,1040),(1041,0,630,'',1,0,1041),(1042,0,631,'',1,0,1042),(1043,0,631,'',2,0,1043),(1044,0,631,'',3,0,1044),(1045,0,632,'',1,0,1045),(1046,0,633,'',1,0,1046),(1047,0,634,'',1,0,1047),(1048,0,634,'',2,0,1048),(1049,0,634,'',3,0,1049),(1050,0,635,'',1,0,1050),(1051,0,636,'',1,0,1051),(1052,0,637,'',1,0,1052),(1053,0,637,'',2,0,1053),(1054,0,637,'',3,0,1054),(1055,0,638,'',1,0,1055),(1056,0,638,'',2,0,1056),(1057,0,638,'',3,0,1057),(1058,0,639,'',1,0,1058),(1059,0,640,'',1,0,1059),(1060,0,641,'',1,0,1060),(1061,0,641,'',2,0,1061),(1062,0,641,'',3,0,1062),(1063,0,641,'',4,0,1063),(1064,0,642,'',1,0,1064),(1065,0,643,'',1,0,1065),(1066,0,644,'',1,0,1066),(1067,0,644,'',2,0,1067),(1068,0,644,'',3,0,1068),(1069,0,644,'',4,0,1069),(1070,0,645,'',1,0,1070),(1071,0,646,'',1,0,1071),(1072,0,647,'',1,0,1072),(1073,0,647,'',2,0,1073),(1074,0,647,'',3,0,1074),(1075,0,647,'',4,0,1075),(1076,0,648,'',1,0,1076),(1077,0,649,'',1,0,1077),(1078,0,650,'',1,0,1078),(1079,0,650,'',2,0,1079),(1080,0,650,'',3,0,1080),(1081,0,650,'',4,0,1081),(1082,0,651,'',1,0,1082),(1083,0,652,'',1,0,1083),(1084,0,653,'',1,0,1084),(1085,0,653,'',2,0,1085),(1086,0,653,'',3,0,1086),(1087,0,653,'',4,0,1087),(1088,0,654,'',1,0,1088),(1089,0,654,'',2,0,1089),(1090,0,654,'',3,0,1090),(1091,0,654,'',4,0,1091),(1092,0,655,'',1,0,1092),(1093,0,656,'',1,0,1093),(1094,0,657,'',1,0,1094),(1095,0,658,'',1,0,1095),(1096,0,659,'',1,0,1096),(1097,0,660,'',1,0,1097),(1098,0,661,'',1,0,1098),(1099,0,662,'',1,0,1099),(1100,0,663,'',1,0,1100),(1101,0,664,'',1,0,1101),(1102,0,665,'',1,0,1102),(1103,0,666,'',1,0,1103),(1104,0,667,'',1,0,1104),(1105,0,668,'',1,0,1105),(1106,0,669,'',1,0,1106),(1107,0,670,'',1,0,1107),(1108,0,671,'',1,0,1108),(1109,0,671,'',2,0,1109),(1110,0,671,'',3,0,1110),(1111,0,672,'',1,0,1111),(1112,0,672,'',2,0,1112),(1113,0,672,'',3,0,1113),(1114,0,673,'',1,0,1114),(1115,0,673,'',2,0,1115),(1116,0,673,'',3,0,1116),(1117,0,674,'',1,0,1117),(1118,0,674,'',2,0,1118),(1119,0,674,'',3,0,1119),(1120,0,675,'',1,0,1120),(1121,0,675,'',2,0,1121),(1122,0,675,'',3,0,1122),(1123,0,676,'',1,0,1123),(1124,0,676,'',2,0,1124),(1125,0,676,'',3,0,1125),(1126,0,677,'',1,0,1126),(1127,0,677,'',2,0,1127),(1128,0,678,'',1,0,1128),(1129,0,678,'',2,0,1129),(1130,0,679,'',1,0,1130),(1131,0,679,'',2,0,1131),(1132,0,680,'',1,0,1132),(1133,0,680,'',2,0,1133),(1134,0,681,'',1,0,1134),(1135,0,681,'',2,0,1135),(1136,0,682,'',1,0,1136),(1137,0,682,'',2,0,1137),(1138,0,683,'',1,0,1138),(1139,0,683,'',2,0,1139),(1140,0,684,'',1,0,1140),(1141,0,684,'',2,0,1141),(1142,0,685,'',1,0,1142),(1143,0,685,'',2,0,1143),(1144,0,686,'',1,0,1144),(1145,0,686,'',2,0,1145),(1146,0,687,'',1,0,1146),(1147,0,687,'',2,0,1147),(1148,0,688,'',1,0,1148),(1149,0,688,'',2,0,1149),(1150,0,689,'',1,0,1150),(1151,0,689,'',2,0,1151),(1152,0,690,'',1,0,1152),(1153,0,690,'',2,0,1153),(1154,0,691,'',1,0,1154),(1155,0,691,'',2,0,1155),(1156,0,692,'',1,0,1156),(1157,0,692,'',2,0,1157),(1158,0,693,'',1,0,1158),(1159,0,693,'',2,0,1159),(1160,0,694,'',1,0,1160),(1161,0,694,'',2,0,1161),(1162,0,695,'',1,0,1162),(1163,0,695,'',2,0,1163),(1164,0,695,'',3,0,1164),(1165,0,696,'',1,0,1165),(1166,0,696,'',2,0,1166),(1167,0,696,'',3,0,1167),(1168,0,697,'',1,0,1168),(1169,0,697,'',2,0,1169),(1170,0,697,'',3,0,1170),(1171,0,698,'',1,0,1171),(1172,0,698,'',2,0,1172),(1173,0,698,'',3,0,1173),(1174,0,699,'',1,0,1174),(1175,0,699,'',2,0,1175),(1176,0,699,'',3,0,1176),(1177,0,700,'',1,0,1177),(1178,0,700,'',2,0,1178),(1179,0,700,'',3,0,1179),(1180,0,701,'',1,0,1180),(1181,0,701,'',2,0,1181),(1182,0,701,'',3,0,1182),(1183,0,702,'',1,0,1183),(1184,0,702,'',2,0,1184),(1185,0,702,'',3,0,1185),(1186,0,703,'',1,0,1186),(1187,0,703,'',2,0,1187),(1188,0,703,'',3,0,1188),(1189,0,704,'',1,0,1189),(1190,0,704,'',2,0,1190),(1191,0,704,'',3,0,1191),(1192,0,705,'',1,0,1192),(1193,0,705,'',2,0,1193),(1194,0,705,'',3,0,1194),(1195,0,706,'',1,0,1195),(1196,0,706,'',2,0,1196),(1197,0,706,'',3,0,1197),(1198,0,707,'',1,0,1198),(1199,0,707,'',2,0,1199),(1200,0,708,'',1,0,1200),(1201,0,708,'',2,0,1201),(1202,0,709,'',1,0,1202),(1203,0,709,'',2,0,1203),(1204,0,710,'',1,0,1204),(1205,0,710,'',2,0,1205),(1206,0,711,'',1,0,1206),(1207,0,711,'',2,0,1207),(1208,0,712,'',1,0,1208),(1209,0,712,'',2,0,1209),(1210,0,713,'',1,0,1210),(1211,0,713,'',2,0,1211),(1212,0,714,'',1,0,1212),(1213,0,714,'',2,0,1213),(1214,0,715,'',1,0,1214),(1215,0,715,'',2,0,1215),(1216,0,716,'',1,0,1216),(1217,0,716,'',2,0,1217),(1218,0,717,'',1,0,1218),(1219,0,717,'',2,0,1219),(1220,0,718,'',1,0,1220),(1221,0,718,'',2,0,1221),(1222,0,719,'',1,0,1222),(1223,0,719,'',2,0,1223),(1224,0,720,'',1,0,1224),(1225,0,720,'',2,0,1225),(1226,0,721,'',1,0,1226),(1227,0,721,'',2,0,1227),(1228,0,722,'',1,0,1228),(1229,0,722,'',2,0,1229),(1230,0,723,'',1,0,1230),(1231,0,723,'',2,0,1231),(1232,0,724,'',1,0,1232),(1233,0,724,'',2,0,1233),(1234,0,725,'',1,0,1234),(1235,0,726,'',1,0,1235),(1236,0,726,'',2,0,1236),(1237,0,727,'',1,0,1237),(1238,0,728,'',1,0,1238),(1239,0,729,'',1,0,1239),(1240,0,729,'',2,0,1240),(1241,0,730,'',1,0,1241),(1242,0,731,'',1,0,1242),(1243,0,732,'',1,0,1243),(1244,0,732,'',2,0,1244),(1245,0,733,'',1,0,1245),(1246,0,734,'',1,0,1246),(1247,0,735,'',1,0,1247),(1248,0,735,'',2,0,1248),(1249,0,736,'',1,0,1249),(1250,0,737,'',1,0,1250),(1251,0,737,'',2,0,1251),(1252,0,738,'',1,0,1252),(1253,0,739,'',1,0,1253),(1254,0,739,'',2,0,1254),(1255,0,740,'',1,0,1255),(1256,0,741,'',1,0,1256),(1257,0,742,'',1,0,1257),(1258,0,742,'',2,0,1258),(1259,0,743,'',1,0,1259),(1260,0,744,'',1,0,1260),(1261,0,745,'',1,0,1261),(1262,0,745,'',2,0,1262),(1263,0,746,'',1,0,1263),(1264,0,747,'',1,0,1264),(1265,0,748,'',1,0,1265),(1266,0,748,'',2,0,1266),(1267,0,749,'',1,0,1267),(1268,0,750,'',1,0,1268),(1269,0,750,'',2,0,1269),(1270,0,751,'',1,0,1270),(1271,0,752,'',1,0,1271),(1272,0,753,'',1,0,1272),(1273,0,754,'',1,0,1273),(1274,0,755,'',1,0,1274),(1275,0,756,'',1,0,1275),(1276,0,757,'',1,0,1276),(1277,0,758,'',1,0,1277),(1278,0,759,'',1,0,1278),(1279,0,760,'',1,0,1279),(1280,0,761,'',1,0,1280),(1281,0,762,'',1,0,1281),(1282,0,763,'',1,0,1282),(1283,0,763,'',2,0,1283),(1284,0,763,'',3,0,1284),(1285,0,764,'',1,0,1285),(1286,0,765,'',1,0,1286),(1287,0,765,'',2,0,1287),(1288,0,766,'',1,0,1288),(1289,0,767,'',1,0,1289),(1290,0,768,'',1,0,1290),(1291,0,768,'',2,0,1291),(1292,0,769,'',1,0,1292),(1293,0,770,'',1,0,1293),(1294,0,771,'',1,0,1294),(1295,0,771,'',2,0,1295),(1296,0,772,'',1,0,1296),(1297,0,773,'',1,0,1297),(1298,0,774,'',1,0,1298),(1299,0,774,'',2,0,1299),(1300,0,775,'',1,0,1300),(1301,0,776,'',1,0,1301),(1302,0,776,'',2,0,1302),(1303,0,777,'',1,0,1303),(1304,0,778,'',1,0,1304),(1305,0,778,'',2,0,1305),(1306,0,778,'',3,0,1306),(1307,0,779,'',1,0,1307),(1308,0,780,'',1,0,1308),(1309,0,781,'',1,0,1309),(1310,0,781,'',2,0,1310),(1311,0,781,'',3,0,1311),(1312,0,782,'',1,0,1312),(1313,0,783,'',1,0,1313),(1314,0,784,'',1,0,1314),(1315,0,784,'',2,0,1315),(1316,0,784,'',3,0,1316),(1317,0,785,'',1,0,1317),(1318,0,786,'',1,0,1318),(1319,0,787,'',1,0,1319),(1320,0,787,'',2,0,1320),(1321,0,787,'',3,0,1321),(1322,0,788,'',1,0,1322),(1323,0,789,'',1,0,1323),(1324,0,789,'',2,0,1324),(1325,0,789,'',3,0,1325),(1326,0,790,'',1,0,1326),(1327,0,790,'',2,0,1327),(1328,0,790,'',3,0,1328),(1329,0,791,'',1,0,1329),(1330,0,792,'',1,0,1330),(1331,0,793,'',1,0,1331),(1332,0,793,'',2,0,1332),(1333,0,793,'',3,0,1333),(1334,0,794,'',1,0,1334),(1335,0,795,'',1,0,1335),(1336,0,796,'',1,0,1336),(1337,0,796,'',2,0,1337),(1338,0,796,'',3,0,1338),(1339,0,797,'',1,0,1339),(1340,0,798,'',1,0,1340),(1341,0,799,'',1,0,1341),(1342,0,799,'',2,0,1342),(1343,0,799,'',3,0,1343),(1344,0,800,'',1,0,1344),(1345,0,801,'',1,0,1345),(1346,0,802,'',1,0,1346),(1347,0,802,'',2,0,1347),(1348,0,802,'',3,0,1348),(1349,0,803,'',1,0,1349),(1350,0,804,'',1,0,1350),(1351,0,804,'',2,0,1351),(1352,0,804,'',3,0,1352),(1353,0,804,'',4,0,1353),(1354,0,804,'',5,0,1354),(1355,0,805,'',1,0,1355),(1356,0,806,'',1,0,1356),(1357,0,807,'',1,0,1357),(1358,0,807,'',2,0,1358),(1359,0,807,'',3,0,1359),(1360,0,807,'',4,0,1360),(1361,0,807,'',5,0,1361),(1362,0,808,'',1,0,1362),(1363,0,809,'',1,0,1363),(1364,0,810,'',1,0,1364),(1365,0,810,'',2,0,1365),(1366,0,810,'',3,0,1366),(1367,0,810,'',4,0,1367),(1368,0,810,'',5,0,1368),(1369,0,811,'',1,0,1369),(1370,0,812,'',1,0,1370),(1371,0,813,'',1,0,1371),(1372,0,813,'',2,0,1372),(1373,0,813,'',3,0,1373),(1374,0,813,'',4,0,1374),(1375,0,813,'',5,0,1375),(1376,0,814,'',1,0,1376),(1377,0,815,'',1,0,1377),(1378,0,815,'',2,0,1378),(1379,0,815,'',3,0,1379),(1380,0,815,'',4,0,1380),(1381,0,815,'',5,0,1381),(1382,0,816,'',1,0,1382),(1383,0,817,'',1,0,1383),(1384,0,817,'',2,0,1384),(1385,0,817,'',3,0,1385),(1386,0,818,'',1,0,1386),(1387,0,819,'',1,0,1387),(1388,0,820,'',1,0,1388),(1389,0,820,'',2,0,1389),(1390,0,820,'',3,0,1390),(1391,0,821,'',1,0,1391),(1392,0,822,'',1,0,1392),(1393,0,823,'',1,0,1393),(1394,0,823,'',2,0,1394),(1395,0,823,'',3,0,1395),(1396,0,824,'',1,0,1396),(1397,0,825,'',1,0,1397),(1398,0,826,'',1,0,1398),(1399,0,826,'',2,0,1399),(1400,0,826,'',3,0,1400),(1401,0,827,'',1,0,1401),(1402,0,828,'',1,0,1402),(1403,0,828,'',2,0,1403),(1404,0,828,'',3,0,1404),(1405,0,829,'',1,0,1405),(1406,0,830,'',1,0,1406),(1407,0,830,'',2,0,1407),(1408,0,830,'',3,0,1408),(1409,0,831,'',1,0,1409),(1410,0,832,'',1,0,1410),(1411,0,833,'',1,0,1411),(1412,0,833,'',2,0,1412),(1413,0,833,'',3,0,1413),(1414,0,834,'',1,0,1414),(1415,0,835,'',1,0,1415),(1416,0,836,'',1,0,1416),(1417,0,836,'',2,0,1417),(1418,0,836,'',3,0,1418),(1419,0,837,'',1,0,1419),(1420,0,838,'',1,0,1420),(1421,0,839,'',1,0,1421),(1422,0,839,'',2,0,1422),(1423,0,839,'',3,0,1423),(1424,0,840,'',1,0,1424),(1425,0,841,'',1,0,1425),(1426,0,841,'',2,0,1426),(1427,0,841,'',3,0,1427),(1428,0,842,'',1,0,1428),(1429,0,842,'',2,0,1429),(1430,0,842,'',3,0,1430),(1431,0,843,'',1,0,1431),(1432,0,844,'',1,0,1432),(1433,0,845,'',1,0,1433),(1434,0,845,'',2,0,1434),(1435,0,845,'',3,0,1435),(1436,0,846,'',1,0,1436),(1437,0,847,'',1,0,1437),(1438,0,848,'',1,0,1438),(1439,0,848,'',2,0,1439),(1440,0,848,'',3,0,1440),(1441,0,849,'',1,0,1441),(1442,0,850,'',1,0,1442),(1443,0,851,'',1,0,1443),(1444,0,851,'',2,0,1444),(1445,0,851,'',3,0,1445),(1446,0,852,'',1,0,1446),(1447,0,853,'',1,0,1447),(1448,0,854,'',1,0,1448),(1449,0,854,'',2,0,1449),(1450,0,854,'',3,0,1450),(1451,0,855,'',1,0,1451),(1452,0,856,'',1,0,1452),(1453,0,856,'',2,0,1453),(1454,0,856,'',3,0,1454),(1455,0,857,'',1,0,1455),(1456,0,858,'',1,0,1456),(1457,0,859,'',1,0,1457),(1458,0,859,'',2,0,1458),(1459,0,859,'',3,0,1459),(1460,0,860,'',1,0,1460),(1461,0,861,'',1,0,1461),(1462,0,862,'',1,0,1462),(1463,0,862,'',2,0,1463),(1464,0,862,'',3,0,1464),(1465,0,863,'',1,0,1465),(1466,0,864,'',1,0,1466),(1467,0,865,'',1,0,1467),(1468,0,865,'',2,0,1468),(1469,0,865,'',3,0,1469),(1470,0,866,'',1,0,1470),(1471,0,867,'',1,0,1471),(1472,0,867,'',2,0,1472),(1473,0,867,'',3,0,1473),(1474,0,868,'',1,0,1474),(1475,0,868,'',2,0,1475),(1476,0,869,'',1,0,1476),(1477,0,870,'',1,0,1477),(1478,0,871,'',1,0,1478),(1479,0,871,'',2,0,1479),(1480,0,872,'',1,0,1480),(1481,0,873,'',1,0,1481),(1482,0,874,'',1,0,1482),(1483,0,874,'',2,0,1483),(1484,0,875,'',1,0,1484),(1485,0,876,'',1,0,1485),(1486,0,877,'',1,0,1486),(1487,0,877,'',2,0,1487),(1488,0,878,'',1,0,1488),(1489,0,879,'',1,0,1489),(1490,0,880,'',1,0,1490),(1491,0,880,'',2,0,1491),(1492,0,881,'',1,0,1492),(1493,0,882,'',1,0,1493),(1494,0,882,'',2,0,1494),(1495,0,883,'',1,0,1495),(1496,0,884,'',1,0,1496),(1497,0,885,'',1,0,1497),(1498,0,885,'',2,0,1498),(1499,0,886,'',1,0,1499),(1500,0,887,'',1,0,1500),(1501,0,888,'',1,0,1501),(1502,0,888,'',2,0,1502),(1503,0,889,'',1,0,1503),(1504,0,890,'',1,0,1504),(1505,0,891,'',1,0,1505),(1506,0,891,'',2,0,1506),(1507,0,892,'',1,0,1507),(1508,0,893,'',1,0,1508),(1509,0,893,'',2,0,1509),(1510,0,894,'',1,0,1510),(1511,0,894,'',2,0,1511),(1512,0,894,'',3,0,1512),(1513,0,895,'',1,0,1513),(1514,0,895,'',2,0,1514),(1515,0,895,'',3,0,1515),(1516,0,896,'',1,0,1516),(1517,0,896,'',2,0,1517),(1518,0,896,'',3,0,1518),(1519,0,897,'',1,0,1519),(1520,0,897,'',2,0,1520),(1521,0,897,'',3,0,1521),(1522,0,898,'',1,0,1522),(1523,0,898,'',2,0,1523),(1524,0,898,'',3,0,1524),(1525,0,899,'',1,0,1525),(1526,0,900,'',1,0,1526),(1527,0,900,'',2,0,1527),(1528,0,900,'',3,0,1528),(1529,0,901,'',1,0,1529),(1530,0,902,'',1,0,1530),(1531,0,903,'',1,0,1531),(1532,0,903,'',2,0,1532),(1533,0,903,'',3,0,1533),(1534,0,904,'',1,0,1534),(1535,0,905,'',1,0,1535),(1536,0,906,'',1,0,1536),(1537,0,906,'',2,0,1537),(1538,0,906,'',3,0,1538),(1539,0,907,'',1,0,1539),(1540,0,908,'',1,0,1540),(1541,0,909,'',1,0,1541),(1542,0,909,'',2,0,1542),(1543,0,909,'',3,0,1543),(1544,0,910,'',1,0,1544),(1545,0,911,'',1,0,1545),(1546,0,911,'',2,0,1546),(1547,0,911,'',3,0,1547),(1548,0,912,'',1,0,1548),(1549,0,912,'',2,0,1549),(1550,0,913,'',1,0,1550),(1551,0,914,'',1,0,1551),(1552,0,915,'',1,0,1552),(1553,0,915,'',2,0,1553),(1554,0,916,'',1,0,1554),(1555,0,917,'',1,0,1555),(1556,0,918,'',1,0,1556),(1557,0,918,'',2,0,1557),(1558,0,919,'',1,0,1558),(1559,0,920,'',1,0,1559),(1560,0,921,'',1,0,1560),(1561,0,921,'',2,0,1561),(1562,0,922,'',1,0,1562),(1563,0,923,'',1,0,1563),(1564,0,924,'',1,0,1564),(1565,0,924,'',2,0,1565),(1566,0,925,'',1,0,1566),(1567,0,926,'',1,0,1567),(1568,0,927,'',1,0,1568),(1569,0,927,'',2,0,1569),(1570,0,927,'',3,0,1570),(1571,0,928,'',1,0,1571),(1572,0,929,'',1,0,1572),(1573,0,930,'',1,0,1573),(1574,0,930,'',2,0,1574),(1575,0,930,'',3,0,1575),(1576,0,931,'',1,0,1576),(1577,0,932,'',1,0,1577),(1578,0,933,'',1,0,1578),(1579,0,933,'',2,0,1579),(1580,0,933,'',3,0,1580),(1581,0,934,'',1,0,1581),(1582,0,935,'',1,0,1582),(1583,0,936,'',1,0,1583),(1584,0,936,'',2,0,1584),(1585,0,936,'',3,0,1585),(1586,0,937,'',1,0,1586),(1587,0,937,'',2,0,1587),(1588,0,937,'',3,0,1588),(1589,0,938,'',1,0,1589),(1590,0,939,'',1,0,1590),(1591,0,939,'',2,0,1591),(1592,0,939,'',3,0,1592),(1593,0,940,'',1,0,1593),(1594,0,941,'',1,0,1594),(1595,0,942,'',1,0,1595),(1596,0,942,'',2,0,1596),(1597,0,942,'',3,0,1597),(1598,0,943,'',1,0,1598),(1599,0,944,'',1,0,1599),(1600,0,945,'',1,0,1600),(1601,0,945,'',2,0,1601),(1602,0,945,'',3,0,1602),(1603,0,946,'',1,0,1603),(1604,0,947,'',1,0,1604),(1605,0,948,'',1,0,1605),(1606,0,948,'',2,0,1606),(1607,0,948,'',3,0,1607),(1608,0,949,'',1,0,1608),(1609,0,950,'',1,0,1609),(1610,0,950,'',2,0,1610),(1611,0,950,'',3,0,1611),(1612,0,951,'',1,0,1612),(1613,0,951,'',2,0,1613),(1614,0,951,'',3,0,1614),(1615,0,952,'',1,0,1615),(1616,0,953,'',1,0,1616),(1617,0,954,'',1,0,1617),(1618,0,954,'',2,0,1618),(1619,0,954,'',3,0,1619),(1620,0,955,'',1,0,1620),(1621,0,956,'',1,0,1621),(1622,0,957,'',1,0,1622),(1623,0,957,'',2,0,1623),(1624,0,957,'',3,0,1624),(1625,0,958,'',1,0,1625),(1626,0,959,'',1,0,1626),(1627,0,960,'',1,0,1627),(1628,0,960,'',2,0,1628),(1629,0,960,'',3,0,1629),(1630,0,961,'',1,0,1630),(1631,0,962,'',1,0,1631),(1632,0,963,'',1,0,1632),(1633,0,963,'',2,0,1633),(1634,0,963,'',3,0,1634),(1635,0,964,'',1,0,1635),(1636,0,964,'',2,0,1636),(1637,0,965,'',1,0,1637),(1638,0,966,'',1,0,1638),(1639,0,967,'',1,0,1639),(1640,0,967,'',2,0,1640),(1641,0,968,'',1,0,1641),(1642,0,969,'',1,0,1642),(1643,0,970,'',1,0,1643),(1644,0,970,'',2,0,1644),(1645,0,971,'',1,0,1645),(1646,0,972,'',1,0,1646),(1647,0,973,'',1,0,1647),(1648,0,973,'',2,0,1648),(1649,0,974,'',1,0,1649),(1650,0,975,'',1,0,1650),(1651,0,976,'',1,0,1651),(1652,0,976,'',2,0,1652),(1653,0,977,'',1,0,1653),(1654,0,978,'',1,0,1654),(1655,0,978,'',2,0,1655),(1656,0,978,'',3,0,1656),(1657,0,979,'',1,0,1657),(1658,0,980,'',1,0,1658),(1659,0,981,'',1,0,1659),(1660,0,981,'',2,0,1660),(1661,0,981,'',3,0,1661),(1662,0,982,'',1,0,1662),(1663,0,983,'',1,0,1663),(1664,0,984,'',1,0,1664),(1665,0,984,'',2,0,1665),(1666,0,984,'',3,0,1666),(1667,0,985,'',1,0,1667),(1668,0,986,'',1,0,1668),(1669,0,987,'',1,0,1669),(1670,0,987,'',2,0,1670),(1671,0,987,'',3,0,1671),(1672,0,988,'',1,0,1672),(1673,0,989,'',1,0,1673),(1674,0,989,'',2,0,1674),(1675,0,989,'',3,0,1675),(1676,0,990,'',1,0,1676),(1677,0,990,'',2,0,1677),(1678,0,990,'',3,0,1678),(1679,0,991,'',1,0,1679),(1680,0,992,'',1,0,1680),(1681,0,993,'',1,0,1681),(1682,0,993,'',2,0,1682),(1683,0,993,'',3,0,1683),(1684,0,994,'',1,0,1684),(1685,0,995,'',1,0,1685),(1686,0,996,'',1,0,1686),(1687,0,996,'',2,0,1687),(1688,0,996,'',3,0,1688),(1689,0,997,'',1,0,1689),(1690,0,998,'',1,0,1690),(1691,0,999,'',1,0,1691),(1692,0,999,'',2,0,1692),(1693,0,999,'',3,0,1693),(1694,0,1000,'',1,0,1694),(1695,0,1001,'',1,0,1695),(1696,0,1002,'',1,0,1696),(1697,0,1002,'',2,0,1697),(1698,0,1002,'',3,0,1698),(1699,0,1003,'',1,0,1699),(1700,0,1004,'',1,0,1700),(1701,0,1004,'',2,0,1701),(1702,0,1005,'',1,0,1702),(1703,0,1006,'',1,0,1703),(1704,0,1007,'',1,0,1704),(1705,0,1007,'',2,0,1705),(1706,0,1008,'',1,0,1706),(1707,0,1009,'',1,0,1707),(1708,0,1010,'',1,0,1708),(1709,0,1010,'',2,0,1709),(1710,0,1011,'',1,0,1710),(1711,0,1012,'',1,0,1711),(1712,0,1013,'',1,0,1712),(1713,0,1013,'',2,0,1713),(1714,0,1014,'',1,0,1714),(1715,0,1015,'',1,0,1715),(1716,0,1015,'',2,0,1716),(1717,0,1016,'',1,0,1717),(1718,0,1017,'',1,0,1718),(1719,0,1018,'',1,0,1719),(1720,0,1018,'',2,0,1720),(1721,0,1019,'',1,0,1721),(1722,0,1020,'',1,0,1722),(1723,0,1021,'',1,0,1723),(1724,0,1021,'',2,0,1724),(1725,0,1022,'',1,0,1725),(1726,0,1023,'',1,0,1726),(1727,0,1024,'',1,0,1727),(1728,0,1024,'',2,0,1728),(1729,0,1025,'',1,0,1729),(1730,0,1026,'',1,0,1730),(1731,0,1027,'',1,0,1731),(1732,0,1027,'',2,0,1732),(1733,0,1028,'',1,0,1733),(1734,0,1028,'',2,0,1734),(1735,0,1029,'',1,0,1735),(1736,0,1029,'',2,0,1736),(1737,0,1029,'',3,0,1737),(1738,0,1030,'',1,0,1738),(1739,0,1031,'',1,0,1739),(1740,0,1032,'',1,0,1740),(1741,0,1032,'',2,0,1741),(1742,0,1032,'',3,0,1742),(1743,0,1033,'',1,0,1743),(1744,0,1034,'',1,0,1744),(1745,0,1035,'',1,0,1745),(1746,0,1035,'',2,0,1746),(1747,0,1035,'',3,0,1747),(1748,0,1036,'',1,0,1748),(1749,0,1037,'',1,0,1749),(1750,0,1038,'',1,0,1750),(1751,0,1038,'',2,0,1751),(1752,0,1038,'',3,0,1752),(1753,0,1039,'',1,0,1753),(1754,0,1040,'',1,0,1754),(1755,0,1041,'',1,0,1755),(1756,0,1041,'',2,0,1756),(1757,0,1041,'',3,0,1757),(1758,0,1042,'',1,0,1758),(1759,0,1043,'',1,0,1759),(1760,0,1044,'',1,0,1760),(1761,0,1044,'',2,0,1761),(1762,0,1044,'',3,0,1762),(1763,0,1045,'',1,0,1763),(1764,0,1045,'',2,0,1764),(1765,0,1045,'',3,0,1765),(1766,0,1046,'',1,0,1766),(1767,0,1047,'',1,0,1767),(1768,0,1048,'',1,0,1768),(1769,0,1048,'',2,0,1769),(1770,0,1048,'',3,0,1770),(1771,0,1049,'',1,0,1771),(1772,0,1050,'',1,0,1772),(1773,0,1051,'',1,0,1773),(1774,0,1051,'',2,0,1774),(1775,0,1051,'',3,0,1775),(1776,0,1052,'',1,0,1776),(1777,0,1053,'',1,0,1777),(1778,0,1054,'',1,0,1778),(1779,0,1054,'',2,0,1779),(1780,0,1054,'',3,0,1780),(1781,0,1055,'',1,0,1781),(1782,0,1056,'',1,0,1782),(1783,0,1057,'',1,0,1783),(1784,0,1057,'',2,0,1784),(1785,0,1057,'',3,0,1785),(1786,0,1058,'',1,0,1786),(1787,0,1059,'',1,0,1787),(1788,0,1060,'',1,0,1788),(1789,0,1060,'',2,0,1789),(1790,0,1060,'',3,0,1790),(1791,0,1061,'',1,0,1791),(1792,0,1062,'',1,0,1792),(1793,0,1063,'',1,0,1793),(1794,0,1063,'',2,0,1794),(1795,0,1063,'',3,0,1795),(1796,0,1064,'',1,0,1796),(1797,0,1065,'',1,0,1797),(1798,0,1066,'',1,0,1798),(1799,0,1066,'',2,0,1799),(1800,0,1066,'',3,0,1800),(1801,0,1067,'',1,0,1801),(1802,0,1068,'',1,0,1802),(1803,0,1069,'',1,0,1803),(1804,0,1069,'',2,0,1804),(1805,0,1069,'',3,0,1805),(1806,0,1070,'',1,0,1806),(1807,0,1071,'',1,0,1807),(1808,0,1072,'',1,0,1808),(1809,0,1072,'',2,0,1809),(1810,0,1072,'',3,0,1810),(1811,0,1073,'',1,0,1811),(1812,0,1074,'',1,0,1812),(1813,0,1075,'',1,0,1813),(1814,0,1075,'',2,0,1814),(1815,0,1075,'',3,0,1815),(1816,0,1076,'',1,0,1816),(1817,0,1076,'',2,0,1817),(1818,0,1076,'',3,0,1818),(1819,0,1077,'',1,0,1819),(1820,0,1077,'',2,0,1820),(1821,0,1077,'',3,0,1821),(1822,0,1078,'',1,0,1822),(1823,0,1079,'',1,0,1823),(1824,0,1080,'',1,0,1824),(1825,0,1080,'',2,0,1825),(1826,0,1080,'',3,0,1826),(1827,0,1081,'',1,0,1827),(1828,0,1082,'',1,0,1828),(1829,0,1083,'',1,0,1829),(1830,0,1083,'',2,0,1830),(1831,0,1083,'',3,0,1831),(1832,0,1084,'',1,0,1832),(1833,0,1085,'',1,0,1833),(1834,0,1086,'',1,0,1834),(1835,0,1086,'',2,0,1835),(1836,0,1086,'',3,0,1836),(1837,0,1087,'',1,0,1837),(1838,0,1088,'',1,0,1838),(1839,0,1089,'',1,0,1839),(1840,0,1089,'',2,0,1840),(1841,0,1089,'',3,0,1841),(1842,0,1090,'',1,0,1842),(1843,0,1091,'',1,0,1843),(1844,0,1092,'',1,0,1844),(1845,0,1092,'',2,0,1845),(1846,0,1092,'',3,0,1846),(1847,0,1093,'',1,0,1847),(1848,0,1094,'',1,0,1848),(1849,0,1095,'',1,0,1849),(1850,0,1095,'',2,0,1850),(1851,0,1096,'',1,0,1851),(1852,0,1097,'',1,0,1852),(1853,0,1098,'',1,0,1853),(1854,0,1098,'',2,0,1854),(1855,0,1099,'',1,0,1855),(1856,0,1100,'',1,0,1856),(1857,0,1101,'',1,0,1857),(1858,0,1101,'',2,0,1858),(1859,0,1102,'',1,0,1859),(1860,0,1103,'',1,0,1860),(1861,0,1104,'',1,0,1861),(1862,0,1104,'',2,0,1862),(1863,0,1105,'',1,0,1863),(1864,0,1106,'',1,0,1864),(1865,0,1107,'',1,0,1865),(1866,0,1107,'',2,0,1866),(1867,0,1108,'',1,0,1867),(1868,0,1108,'',2,0,1868),(1869,0,1109,'',1,0,1869),(1870,0,1109,'',2,0,1870),(1871,0,1109,'',3,0,1871),(1872,0,1110,'',1,0,1872),(1873,0,1110,'',2,0,1873),(1874,0,1110,'',3,0,1874),(1875,0,1111,'',1,0,1875),(1876,0,1111,'',2,0,1876),(1877,0,1111,'',3,0,1877),(1878,0,1112,'',1,0,1878),(1879,0,1112,'',2,0,1879),(1880,0,1112,'',3,0,1880),(1881,0,1113,'',1,0,1881),(1882,0,1113,'',2,0,1882),(1883,0,1113,'',3,0,1883),(1884,0,1114,'',1,0,1884),(1885,0,1114,'',2,0,1885),(1886,0,1114,'',3,0,1886),(1887,0,1115,'',1,0,1887),(1888,0,1115,'',2,0,1888),(1889,0,1115,'',3,0,1889),(1890,0,1116,'',1,0,1890),(1891,0,1117,'',1,0,1891),(1892,0,1118,'',1,0,1892),(1893,0,1118,'',2,0,1893),(1894,0,1118,'',3,0,1894),(1895,0,1119,'',1,0,1895),(1896,0,1120,'',1,0,1896),(1897,0,1121,'',1,0,1897),(1898,0,1121,'',2,0,1898),(1899,0,1121,'',3,0,1899),(1900,0,1122,'',1,0,1900),(1901,0,1123,'',1,0,1901),(1902,0,1124,'',1,0,1902),(1903,0,1124,'',2,0,1903),(1904,0,1124,'',3,0,1904),(1905,0,1125,'',1,0,1905),(1906,0,1126,'',1,0,1906),(1907,0,1127,'',1,0,1907),(1908,0,1127,'',2,0,1908),(1909,0,1127,'',3,0,1909),(1910,0,1128,'',1,0,1910),(1911,0,1129,'',1,0,1911),(1912,0,1130,'',1,0,1912),(1913,0,1130,'',2,0,1913),(1914,0,1130,'',3,0,1914),(1915,0,1131,'',1,0,1915),(1916,0,1132,'',1,0,1916),(1917,0,1133,'',1,0,1917),(1918,0,1133,'',2,0,1918),(1919,0,1133,'',3,0,1919),(1920,0,1133,'',4,0,1920),(1921,0,1134,'',1,0,1921),(1922,0,1135,'',1,0,1922),(1923,0,1136,'',1,0,1923),(1924,0,1136,'',2,0,1924),(1925,0,1136,'',3,0,1925),(1926,0,1136,'',4,0,1926),(1927,0,1137,'',1,0,1927),(1928,0,1138,'',1,0,1928),(1929,0,1139,'',1,0,1929),(1930,0,1139,'',2,0,1930),(1931,0,1139,'',3,0,1931),(1932,0,1139,'',4,0,1932),(1933,0,1140,'',1,0,1933),(1934,0,1141,'',1,0,1934),(1935,0,1142,'',1,0,1935),(1936,0,1142,'',2,0,1936),(1937,0,1142,'',3,0,1937),(1938,0,1142,'',4,0,1938),(1939,0,1143,'',1,0,1939),(1940,0,1144,'',1,0,1940),(1941,0,1145,'',1,0,1941),(1942,0,1145,'',2,0,1942),(1943,0,1145,'',3,0,1943),(1944,0,1145,'',4,0,1944),(1945,0,1146,'',1,0,1945),(1946,0,1146,'',2,0,1946),(1947,0,1146,'',3,0,1947),(1948,0,1146,'',4,0,1948),(1949,0,1147,'',1,0,1949),(1950,0,1148,'',1,0,1950),(1951,0,1148,'',2,0,1951),(1952,0,1148,'',3,0,1952),(1953,0,1149,'',1,0,1953),(1954,0,1150,'',1,0,1954),(1955,0,1151,'',1,0,1955),(1956,0,1151,'',2,0,1956),(1957,0,1151,'',3,0,1957),(1958,0,1152,'',1,0,1958),(1959,0,1153,'',1,0,1959),(1960,0,1154,'',1,0,1960),(1961,0,1154,'',2,0,1961),(1962,0,1154,'',3,0,1962),(1963,0,1155,'',1,0,1963),(1964,0,1156,'',1,0,1964),(1965,0,1157,'',1,0,1965),(1966,0,1157,'',2,0,1966),(1967,0,1157,'',3,0,1967),(1968,0,1158,'',1,0,1968),(1969,0,1159,'',1,0,1969),(1970,0,1160,'',1,0,1970),(1971,0,1160,'',2,0,1971),(1972,0,1160,'',3,0,1972),(1973,0,1161,'',1,0,1973),(1974,0,1162,'',1,0,1974),(1975,0,1162,'',2,0,1975),(1976,0,1162,'',3,0,1976),(1977,0,1163,'',1,0,1977),(1978,0,1164,'',1,0,1978),(1979,0,1164,'',2,0,1979),(1980,0,1164,'',3,0,1980),(1981,0,1165,'',1,0,1981),(1982,0,1166,'',1,0,1982),(1983,0,1167,'',1,0,1983),(1984,0,1167,'',2,0,1984),(1985,0,1167,'',3,0,1985),(1986,0,1168,'',1,0,1986),(1987,0,1169,'',1,0,1987),(1988,0,1170,'',1,0,1988),(1989,0,1170,'',2,0,1989),(1990,0,1170,'',3,0,1990),(1991,0,1171,'',1,0,1991),(1992,0,1172,'',1,0,1992),(1993,0,1173,'',1,0,1993),(1994,0,1173,'',2,0,1994),(1995,0,1173,'',3,0,1995),(1996,0,1174,'',1,0,1996),(1997,0,1175,'',1,0,1997),(1998,0,1176,'',1,0,1998),(1999,0,1176,'',2,0,1999),(2000,0,1176,'',3,0,2000),(2001,0,1177,'',1,0,2001),(2002,0,1178,'',1,0,2002),(2003,0,1178,'',2,0,2003),(2004,0,1178,'',3,0,2004),(2005,0,1179,'',1,0,2005),(2006,0,1179,'',2,0,2006),(2007,0,1180,'',1,0,2007),(2008,0,1181,'',1,0,2008),(2009,0,1182,'',1,0,2009),(2010,0,1182,'',2,0,2010),(2011,0,1183,'',1,0,2011),(2012,0,1184,'',1,0,2012),(2013,0,1185,'',1,0,2013),(2014,0,1185,'',2,0,2014),(2015,0,1186,'',1,0,2015),(2016,0,1187,'',1,0,2016),(2017,0,1188,'',1,0,2017),(2018,0,1188,'',2,0,2018),(2019,0,1189,'',1,0,2019),(2020,0,1190,'',1,0,2020),(2021,0,1191,'',1,0,2021),(2022,0,1191,'',2,0,2022),(2023,0,1192,'',1,0,2023),(2024,0,1193,'',1,0,2024),(2025,0,1194,'',1,0,2025),(2026,0,1194,'',2,0,2026),(2027,0,1195,'',1,0,2027),(2028,0,1195,'',2,0,2028),(2029,0,1196,'',1,0,2029),(2030,0,1197,'',1,0,2030),(2031,0,1198,'',1,0,2031),(2032,0,1198,'',2,0,2032),(2033,0,1199,'',1,0,2033),(2034,0,1200,'',1,0,2034),(2035,0,1201,'',1,0,2035),(2036,0,1201,'',2,0,2036),(2037,0,1202,'',1,0,2037),(2038,0,1203,'',1,0,2038),(2039,0,1204,'',1,0,2039),(2040,0,1204,'',2,0,2040),(2041,0,1205,'',1,0,2041),(2042,0,1206,'',1,0,2042),(2043,0,1207,'',1,0,2043),(2044,0,1207,'',2,0,2044),(2045,0,1208,'',1,0,2045),(2046,0,1209,'',1,0,2046),(2047,0,1210,'',1,0,2047),(2048,0,1210,'',2,0,2048),(2049,0,1211,'',1,0,2049),(2050,0,1212,'',1,0,2050),(2051,0,1212,'',2,0,2051),(2052,0,1212,'',3,0,2052),(2053,0,1213,'',1,0,2053),(2054,0,1214,'',1,0,2054),(2055,0,1215,'',1,0,2055),(2056,0,1215,'',2,0,2056),(2057,0,1215,'',3,0,2057),(2058,0,1216,'',1,0,2058),(2059,0,1217,'',1,0,2059),(2060,0,1218,'',1,0,2060),(2061,0,1218,'',2,0,2061),(2062,0,1218,'',3,0,2062),(2063,0,1219,'',1,0,2063),(2064,0,1220,'',1,0,2064),(2065,0,1220,'',2,0,2065),(2066,0,1220,'',3,0,2066),(2067,0,1221,'',1,0,2067),(2068,0,1222,'',1,0,2068),(2069,0,1223,'',1,0,2069),(2070,0,1223,'',2,0,2070),(2071,0,1223,'',3,0,2071),(2072,0,1224,'',1,0,2072),(2073,0,1225,'',1,0,2073),(2074,0,1226,'',1,0,2074),(2075,0,1226,'',2,0,2075),(2076,0,1226,'',3,0,2076),(2077,0,1227,'',1,0,2077),(2078,0,1228,'',1,0,2078),(2079,0,1229,'',1,0,2079),(2080,0,1229,'',2,0,2080),(2081,0,1229,'',3,0,2081),(2082,0,1230,'',1,0,2082),(2083,0,1231,'',1,0,2083),(2084,0,1232,'',1,0,2084),(2085,0,1232,'',2,0,2085),(2086,0,1232,'',3,0,2086),(2087,0,1233,'',1,0,2087),(2088,0,1234,'',1,0,2088),(2089,0,1235,'',1,0,2089),(2090,0,1235,'',2,0,2090),(2091,0,1235,'',3,0,2091),(2092,0,1236,'',1,0,2092),(2093,0,1236,'',2,0,2093),(2094,0,1236,'',3,0,2094),(2095,0,1237,'',1,0,2095),(2096,0,1238,'',1,0,2096),(2097,0,1239,'',1,0,2097),(2098,0,1239,'',2,0,2098),(2099,0,1239,'',3,0,2099),(2100,0,1240,'',1,0,2100),(2101,0,1241,'',1,0,2101),(2102,0,1242,'',1,0,2102),(2103,0,1242,'',2,0,2103),(2104,0,1242,'',3,0,2104),(2105,0,1243,'',1,0,2105),(2106,0,1244,'',1,0,2106),(2107,0,1245,'',1,0,2107),(2108,0,1245,'',2,0,2108),(2109,0,1245,'',3,0,2109),(2110,0,1246,'',1,0,2110),(2111,0,1247,'',1,0,2111),(2112,0,1248,'',1,0,2112),(2113,0,1248,'',2,0,2113),(2114,0,1248,'',3,0,2114),(2115,0,1249,'',1,0,2115),(2116,0,1250,'',1,0,2116),(2117,0,1251,'',1,0,2117),(2118,0,1251,'',2,0,2118),(2119,0,1251,'',3,0,2119),(2120,0,1252,'',1,0,2120),(2121,0,1252,'',2,0,2121),(2122,0,1252,'',3,0,2122),(2123,0,1253,'',1,0,2123),(2124,0,1254,'',1,0,2124),(2125,0,1255,'',1,0,2125),(2126,0,1255,'',2,0,2126),(2127,0,1255,'',3,0,2127),(2128,0,1255,'',4,0,2128),(2129,0,1256,'',1,0,2129),(2130,0,1257,'',1,0,2130),(2131,0,1258,'',1,0,2131),(2132,0,1258,'',2,0,2132),(2133,0,1258,'',3,0,2133),(2134,0,1258,'',4,0,2134),(2135,0,1259,'',1,0,2135),(2136,0,1260,'',1,0,2136),(2137,0,1261,'',1,0,2137),(2138,0,1261,'',2,0,2138),(2139,0,1261,'',3,0,2139),(2140,0,1261,'',4,0,2140),(2141,0,1262,'',1,0,2141),(2142,0,1263,'',1,0,2142),(2143,0,1264,'',1,0,2143),(2144,0,1264,'',2,0,2144),(2145,0,1264,'',3,0,2145),(2146,0,1264,'',4,0,2146),(2147,0,1265,'',1,0,2147),(2148,0,1266,'',1,0,2148),(2149,0,1267,'',1,0,2149),(2150,0,1267,'',2,0,2150),(2151,0,1267,'',3,0,2151),(2152,0,1267,'',4,0,2152),(2153,0,1268,'',1,0,2153),(2154,0,1268,'',2,0,2154),(2155,0,1268,'',3,0,2155),(2156,0,1268,'',4,0,2156),(2157,0,1269,'',1,0,2157),(2158,0,1269,'',2,0,2158),(2159,0,1269,'',3,0,2159),(2160,0,1270,'',1,0,2160),(2161,0,1271,'',1,0,2161),(2162,0,1272,'',1,0,2162),(2163,0,1272,'',2,0,2163),(2164,0,1272,'',3,0,2164),(2165,0,1273,'',1,0,2165),(2166,0,1274,'',1,0,2166),(2167,0,1275,'',1,0,2167),(2168,0,1275,'',2,0,2168),(2169,0,1275,'',3,0,2169),(2170,0,1276,'',1,0,2170),(2171,0,1277,'',1,0,2171),(2172,0,1278,'',1,0,2172),(2173,0,1278,'',2,0,2173),(2174,0,1278,'',3,0,2174),(2175,0,1279,'',1,0,2175),(2176,0,1280,'',1,0,2176),(2177,0,1281,'',1,0,2177),(2178,0,1281,'',2,0,2178),(2179,0,1281,'',3,0,2179),(2180,0,1282,'',1,0,2180),(2181,0,1283,'',1,0,2181),(2182,0,1284,'',1,0,2182),(2183,0,1284,'',2,0,2183),(2184,0,1284,'',3,0,2184),(2185,0,1285,'',1,0,2185),(2186,0,1286,'',1,0,2186),(2187,0,1286,'',2,0,2187),(2188,0,1286,'',3,0,2188),(2189,0,1287,'',1,0,2189),(2190,0,1288,'',1,0,2190),(2191,0,1289,'',1,0,2191),(2192,0,1289,'',2,0,2192),(2193,0,1289,'',3,0,2193),(2194,0,1290,'',1,0,2194),(2195,0,1291,'',1,0,2195),(2196,0,1292,'',1,0,2196),(2197,0,1292,'',2,0,2197),(2198,0,1292,'',3,0,2198),(2199,0,1293,'',1,0,2199),(2200,0,1294,'',1,0,2200),(2201,0,1295,'',1,0,2201),(2202,0,1295,'',2,0,2202),(2203,0,1295,'',3,0,2203),(2204,0,1296,'',1,0,2204),(2205,0,1297,'',1,0,2205),(2206,0,1298,'',1,0,2206),(2207,0,1298,'',2,0,2207),(2208,0,1298,'',3,0,2208),(2209,0,1299,'',1,0,2209),(2210,0,1300,'',1,0,2210),(2211,0,1300,'',2,0,2211),(2212,0,1300,'',3,0,2212),(2213,0,1301,'',1,0,2213),(2214,0,1301,'',2,0,2214),(2215,0,1301,'',3,0,2215),(2216,0,1301,'',4,0,2216),(2217,0,1302,'',1,0,2217),(2218,0,1303,'',1,0,2218),(2219,0,1304,'',1,0,2219),(2220,0,1304,'',2,0,2220),(2221,0,1304,'',3,0,2221),(2222,0,1304,'',4,0,2222),(2223,0,1305,'',1,0,2223),(2224,0,1306,'',1,0,2224),(2225,0,1307,'',1,0,2225),(2226,0,1307,'',2,0,2226),(2227,0,1307,'',3,0,2227),(2228,0,1307,'',4,0,2228),(2229,0,1308,'',1,0,2229),(2230,0,1309,'',1,0,2230),(2231,0,1310,'',1,0,2231),(2232,0,1310,'',2,0,2232),(2233,0,1310,'',3,0,2233),(2234,0,1310,'',4,0,2234),(2235,0,1311,'',1,0,2235),(2236,0,1312,'',1,0,2236),(2237,0,1313,'',1,0,2237),(2238,0,1313,'',2,0,2238),(2239,0,1313,'',3,0,2239),(2240,0,1313,'',4,0,2240),(2241,0,1314,'',1,0,2241),(2242,0,1315,'',1,0,2242),(2243,0,1316,'',1,0,2243),(2244,0,1316,'',2,0,2244),(2245,0,1316,'',3,0,2245),(2246,0,1316,'',4,0,2246),(2247,0,1317,'',1,0,2247),(2248,0,1318,'',1,0,2248),(2249,0,1319,'',1,0,2249),(2250,0,1319,'',2,0,2250),(2251,0,1319,'',3,0,2251),(2252,0,1320,'',1,0,2252),(2253,0,1321,'',1,0,2253),(2254,0,1322,'',1,0,2254),(2255,0,1322,'',2,0,2255),(2256,0,1322,'',3,0,2256),(2257,0,1323,'',1,0,2257),(2258,0,1324,'',1,0,2258),(2259,0,1325,'',1,0,2259),(2260,0,1325,'',2,0,2260),(2261,0,1325,'',3,0,2261),(2262,0,1326,'',1,0,2262),(2263,0,1327,'',1,0,2263),(2264,0,1328,'',1,0,2264),(2265,0,1328,'',2,0,2265),(2266,0,1328,'',3,0,2266),(2267,0,1329,'',1,0,2267),(2268,0,1330,'',1,0,2268),(2269,0,1331,'',1,0,2269),(2270,0,1331,'',2,0,2270),(2271,0,1331,'',3,0,2271),(2272,0,1332,'',1,0,2272),(2273,0,1332,'',2,0,2273),(2274,0,1332,'',3,0,2274),(2275,0,1333,'',1,0,2275),(2276,0,1334,'',1,0,2276),(2277,0,1335,'',1,0,2277),(2278,0,1335,'',2,0,2278),(2279,0,1335,'',3,0,2279),(2280,0,1336,'',1,0,2280),(2281,0,1337,'',1,0,2281),(2282,0,1338,'',1,0,2282),(2283,0,1338,'',2,0,2283),(2284,0,1338,'',3,0,2284),(2285,0,1339,'',1,0,2285),(2286,0,1340,'',1,0,2286),(2287,0,1341,'',1,0,2287),(2288,0,1341,'',2,0,2288),(2289,0,1341,'',3,0,2289),(2290,0,1342,'',1,0,2290),(2291,0,1343,'',1,0,2291),(2292,0,1344,'',1,0,2292),(2293,0,1344,'',2,0,2293),(2294,0,1344,'',3,0,2294),(2295,0,1345,'',1,0,2295),(2296,0,1346,'',1,0,2296),(2297,0,1347,'',1,0,2297),(2298,0,1347,'',2,0,2298),(2299,0,1347,'',3,0,2299),(2300,0,1348,'',1,0,2300),(2301,0,1348,'',2,0,2301),(2302,0,1348,'',3,0,2302),(2303,0,1349,'',1,0,2303),(2304,0,1350,'',1,0,2304),(2305,0,1350,'',2,0,2305),(2306,0,1350,'',3,0,2306),(2307,0,1351,'',1,0,2307),(2308,0,1352,'',1,0,2308),(2309,0,1353,'',1,0,2309),(2310,0,1353,'',2,0,2310),(2311,0,1353,'',3,0,2311),(2312,0,1354,'',1,0,2312),(2313,0,1355,'',1,0,2313),(2314,0,1356,'',1,0,2314),(2315,0,1356,'',2,0,2315),(2316,0,1356,'',3,0,2316),(2317,0,1357,'',1,0,2317),(2318,0,1358,'',1,0,2318),(2319,0,1359,'',1,0,2319),(2320,0,1359,'',2,0,2320),(2321,0,1359,'',3,0,2321),(2322,0,1360,'',1,0,2322),(2323,0,1361,'',1,0,2323),(2324,0,1362,'',1,0,2324),(2325,0,1362,'',2,0,2325),(2326,0,1362,'',3,0,2326),(2327,0,1363,'',1,0,2327),(2328,0,1364,'',1,0,2328),(2329,0,1364,'',2,0,2329),(2330,0,1364,'',3,0,2330),(2331,0,1365,'',1,0,2331),(2332,0,1366,'',1,0,2332),(2333,0,1367,'',1,0,2333),(2334,0,1367,'',2,0,2334),(2335,0,1367,'',3,0,2335),(2336,0,1368,'',1,0,2336),(2337,0,1369,'',1,0,2337),(2338,0,1370,'',1,0,2338),(2339,0,1370,'',2,0,2339),(2340,0,1370,'',3,0,2340),(2341,0,1371,'',1,0,2341),(2342,0,1372,'',1,0,2342),(2343,0,1373,'',1,0,2343),(2344,0,1373,'',2,0,2344),(2345,0,1373,'',3,0,2345),(2346,0,1374,'',1,0,2346),(2347,0,1375,'',1,0,2347),(2348,0,1376,'',1,0,2348),(2349,0,1376,'',2,0,2349),(2350,0,1376,'',3,0,2350),(2351,0,1377,'',1,0,2351),(2352,0,1378,'',1,0,2352),(2353,0,1379,'',1,0,2353),(2354,0,1379,'',2,0,2354),(2355,0,1379,'',3,0,2355),(2356,0,1380,'',1,0,2356),(2357,0,1380,'',2,0,2357),(2358,0,1380,'',3,0,2358),(2359,0,1381,'',1,0,2359),(2360,0,1382,'',1,0,2360),(2361,0,1382,'',2,0,2361),(2362,0,1382,'',3,0,2362),(2363,0,1383,'',1,0,2363),(2364,0,1384,'',1,0,2364),(2365,0,1385,'',1,0,2365),(2366,0,1385,'',2,0,2366),(2367,0,1385,'',3,0,2367),(2368,0,1386,'',1,0,2368),(2369,0,1387,'',1,0,2369),(2370,0,1388,'',1,0,2370),(2371,0,1388,'',2,0,2371),(2372,0,1388,'',3,0,2372),(2373,0,1389,'',1,0,2373),(2374,0,1390,'',1,0,2374),(2375,0,1391,'',1,0,2375),(2376,0,1391,'',2,0,2376),(2377,0,1391,'',3,0,2377),(2378,0,1392,'',1,0,2378),(2379,0,1393,'',1,0,2379),(2380,0,1394,'',1,0,2380),(2381,0,1394,'',2,0,2381),(2382,0,1394,'',3,0,2382),(2383,0,1395,'',1,0,2383),(2384,0,1396,'',1,0,2384),(2385,0,1396,'',2,0,2385),(2386,0,1396,'',3,0,2386),(2387,0,1397,'',1,0,2387),(2388,0,1398,'',1,0,2388),(2389,0,1398,'',2,0,2389),(2390,0,1399,'',1,0,2390),(2391,0,1400,'',1,0,2391),(2392,0,1401,'',1,0,2392),(2393,0,1401,'',2,0,2393),(2394,0,1402,'',1,0,2394),(2395,0,1403,'',1,0,2395),(2396,0,1404,'',1,0,2396),(2397,0,1404,'',2,0,2397),(2398,0,1405,'',1,0,2398),(2399,0,1406,'',1,0,2399),(2400,0,1407,'',1,0,2400),(2401,0,1407,'',2,0,2401),(2402,0,1408,'',1,0,2402),(2403,0,1409,'',1,0,2403),(2404,0,1410,'',1,0,2404),(2405,0,1410,'',2,0,2405),(2406,0,1411,'',1,0,2406),(2407,0,1412,'',1,0,2407),(2408,0,1412,'',2,0,2408),(2409,0,1413,'',1,0,2409),(2410,0,1414,'',1,0,2410),(2411,0,1415,'',1,0,2411),(2412,0,1415,'',2,0,2412),(2413,0,1415,'',3,0,2413),(2414,0,1416,'',1,0,2414),(2415,0,1417,'',1,0,2415),(2416,0,1418,'',1,0,2416),(2417,0,1418,'',2,0,2417),(2418,0,1418,'',3,0,2418),(2419,0,1419,'',1,0,2419),(2420,0,1420,'',1,0,2420),(2421,0,1421,'',1,0,2421),(2422,0,1421,'',2,0,2422),(2423,0,1421,'',3,0,2423),(2424,0,1422,'',1,0,2424),(2425,0,1423,'',1,0,2425),(2426,0,1424,'',1,0,2426),(2427,0,1424,'',2,0,2427),(2428,0,1424,'',3,0,2428),(2429,0,1425,'',1,0,2429),(2430,0,1426,'',1,0,2430),(2431,0,1427,'',1,0,2431),(2432,0,1427,'',2,0,2432),(2433,0,1427,'',3,0,2433),(2434,0,1428,'',1,0,2434),(2435,0,1428,'',2,0,2435),(2436,0,1428,'',3,0,2436),(2437,0,1429,'',1,0,2437),(2438,0,1430,'',1,0,2438),(2439,0,1430,'',2,0,2439),(2440,0,1431,'',1,0,2440),(2441,0,1432,'',1,0,2441),(2442,0,1433,'',1,0,2442),(2443,0,1433,'',2,0,2443),(2444,0,1434,'',1,0,2444),(2445,0,1435,'',1,0,2445),(2446,0,1436,'',1,0,2446),(2447,0,1436,'',2,0,2447),(2448,0,1437,'',1,0,2448),(2449,0,1438,'',1,0,2449),(2450,0,1439,'',1,0,2450),(2451,0,1439,'',2,0,2451),(2452,0,1440,'',1,0,2452),(2453,0,1441,'',1,0,2453),(2454,0,1442,'',1,0,2454),(2455,0,1442,'',2,0,2455),(2456,0,1443,'',1,0,2456),(2457,0,1444,'',1,0,2457),(2458,0,1444,'',2,0,2458),(2459,0,1445,'',1,0,2459),(2460,0,1446,'',1,0,2460),(2461,0,1446,'',2,0,2461),(2462,0,1447,'',1,0,2462),(2463,0,1448,'',1,0,2463),(2464,0,1449,'',1,0,2464),(2465,0,1449,'',2,0,2465),(2466,0,1450,'',1,0,2466),(2467,0,1451,'',1,0,2467),(2468,0,1452,'',1,0,2468),(2469,0,1452,'',2,0,2469),(2470,0,1453,'',1,0,2470),(2471,0,1454,'',1,0,2471),(2472,0,1455,'',1,0,2472),(2473,0,1455,'',2,0,2473),(2474,0,1456,'',1,0,2474),(2475,0,1457,'',1,0,2475),(2476,0,1458,'',1,0,2476),(2477,0,1458,'',2,0,2477),(2478,0,1459,'',1,0,2478),(2479,0,1460,'',1,0,2479),(2480,0,1460,'',2,0,2480),(2481,0,1461,'',1,0,2481),(2482,0,1461,'',2,0,2482),(2483,0,1461,'',3,0,2483),(2484,0,1462,'',1,0,2484),(2485,0,1463,'',1,0,2485),(2486,0,1464,'',1,0,2486),(2487,0,1464,'',2,0,2487),(2488,0,1464,'',3,0,2488),(2489,0,1465,'',1,0,2489),(2490,0,1466,'',1,0,2490),(2491,0,1467,'',1,0,2491),(2492,0,1467,'',2,0,2492),(2493,0,1467,'',3,0,2493),(2494,0,1468,'',1,0,2494),(2495,0,1469,'',1,0,2495),(2496,0,1470,'',1,0,2496),(2497,0,1470,'',2,0,2497),(2498,0,1470,'',3,0,2498),(2499,0,1471,'',1,0,2499),(2500,0,1472,'',1,0,2500),(2501,0,1473,'',1,0,2501),(2502,0,1473,'',2,0,2502),(2503,0,1473,'',3,0,2503),(2504,0,1474,'',1,0,2504),(2505,0,1475,'',1,0,2505),(2506,0,1476,'',1,0,2506),(2507,0,1476,'',2,0,2507),(2508,0,1476,'',3,0,2508),(2509,0,1477,'',1,0,2509),(2510,0,1478,'',1,0,2510),(2511,0,1478,'',2,0,2511),(2512,0,1479,'',1,0,2512),(2513,0,1480,'',1,0,2513),(2514,0,1481,'',1,0,2514),(2515,0,1481,'',2,0,2515),(2516,0,1482,'',1,0,2516),(2517,0,1483,'',1,0,2517),(2518,0,1484,'',1,0,2518),(2519,0,1484,'',2,0,2519),(2520,0,1485,'',1,0,2520),(2521,0,1486,'',1,0,2521),(2522,0,1487,'',1,0,2522),(2523,0,1487,'',2,0,2523),(2524,0,1488,'',1,0,2524),(2525,0,1489,'',1,0,2525),(2526,0,1490,'',1,0,2526),(2527,0,1490,'',2,0,2527),(2528,0,1491,'',1,0,2528),(2529,0,1492,'',1,0,2529),(2530,0,1492,'',2,0,2530),(2531,0,1493,'',1,0,2531),(2532,0,1493,'',2,0,2532),(2533,0,1494,'',1,0,2533),(2534,0,1495,'',1,0,2534),(2535,0,1496,'',1,0,2535),(2536,0,1496,'',2,0,2536),(2537,0,1497,'',1,0,2537),(2538,0,1498,'',1,0,2538),(2539,0,1499,'',1,0,2539),(2540,0,1499,'',2,0,2540),(2541,0,1500,'',1,0,2541),(2542,0,1501,'',1,0,2542),(2543,0,1502,'',1,0,2543),(2544,0,1502,'',2,0,2544),(2545,0,1503,'',1,0,2545),(2546,0,1504,'',1,0,2546),(2547,0,1505,'',1,0,2547),(2548,0,1505,'',2,0,2548),(2549,0,1506,'',1,0,2549),(2550,0,1507,'',1,0,2550),(2551,0,1508,'',1,0,2551),(2552,0,1508,'',2,0,2552),(2553,0,1509,'',1,0,2553),(2554,0,1510,'',1,0,2554),(2555,0,1510,'',2,0,2555),(2556,0,1511,'',1,0,2556),(2557,0,1512,'',1,0,2557),(2558,0,1513,'',1,0,2558),(2559,0,1513,'',2,0,2559),(2560,0,1514,'',1,0,2560),(2561,0,1515,'',1,0,2561),(2562,0,1516,'',1,0,2562),(2563,0,1516,'',2,0,2563),(2564,0,1517,'',1,0,2564),(2565,0,1518,'',1,0,2565),(2566,0,1519,'',1,0,2566),(2567,0,1519,'',2,0,2567),(2568,0,1520,'',1,0,2568),(2569,0,1521,'',1,0,2569),(2570,0,1522,'',1,0,2570),(2571,0,1522,'',2,0,2571),(2572,0,1523,'',1,0,2572),(2573,0,1524,'',1,0,2573),(2574,0,1524,'',2,0,2574),(2575,0,1525,'',1,0,2575),(2576,0,1526,'',1,0,2576),(2577,0,1527,'',1,0,2577),(2578,0,1527,'',2,0,2578),(2579,0,1528,'',1,0,2579),(2580,0,1529,'',1,0,2580),(2581,0,1530,'',1,0,2581),(2582,0,1530,'',2,0,2582),(2583,0,1531,'',1,0,2583),(2584,0,1532,'',1,0,2584),(2585,0,1533,'',1,0,2585),(2586,0,1533,'',2,0,2586),(2587,0,1534,'',1,0,2587),(2588,0,1535,'',1,0,2588),(2589,0,1536,'',1,0,2589),(2590,0,1536,'',2,0,2590),(2591,0,1537,'',1,0,2591),(2592,0,1538,'',1,0,2592),(2593,0,1539,'',1,0,2593),(2594,0,1539,'',2,0,2594),(2595,0,1540,'',1,0,2595),(2596,0,1540,'',2,0,2596),(2597,0,1541,'',1,0,2597),(2598,0,1542,'',1,0,2598),(2599,0,1542,'',2,0,2599),(2600,0,1543,'',1,0,2600),(2601,0,1544,'',1,0,2601),(2602,0,1545,'',1,0,2602),(2603,0,1545,'',2,0,2603),(2604,0,1546,'',1,0,2604),(2605,0,1547,'',1,0,2605),(2606,0,1548,'',1,0,2606),(2607,0,1548,'',2,0,2607),(2608,0,1549,'',1,0,2608),(2609,0,1550,'',1,0,2609),(2610,0,1551,'',1,0,2610),(2611,0,1551,'',2,0,2611),(2612,0,1552,'',1,0,2612),(2613,0,1553,'',1,0,2613),(2614,0,1554,'',1,0,2614),(2615,0,1554,'',2,0,2615),(2616,0,1555,'',1,0,2616),(2617,0,1556,'',1,0,2617),(2618,0,1556,'',2,0,2618),(2619,0,1557,'',1,0,2619),(2620,0,1557,'',2,0,2620),(2621,0,1558,'',1,0,2621),(2622,0,1559,'',1,0,2622),(2623,0,1560,'',1,0,2623),(2624,0,1560,'',2,0,2624),(2625,0,1561,'',1,0,2625),(2626,0,1562,'',1,0,2626),(2627,0,1563,'',1,0,2627),(2628,0,1563,'',2,0,2628),(2629,0,1564,'',1,0,2629),(2630,0,1565,'',1,0,2630),(2631,0,1566,'',1,0,2631),(2632,0,1566,'',2,0,2632),(2633,0,1567,'',1,0,2633),(2634,0,1568,'',1,0,2634),(2635,0,1569,'',1,0,2635),(2636,0,1569,'',2,0,2636),(2637,0,1570,'',1,0,2637),(2638,0,1571,'',1,0,2638),(2639,0,1572,'',1,0,2639),(2640,0,1572,'',2,0,2640),(2641,0,1573,'',1,0,2641),(2642,0,1573,'',2,0,2642),(2643,0,1573,'',3,0,2643),(2644,0,1574,'',1,0,2644),(2645,0,1575,'',1,0,2645),(2646,0,1576,'',1,0,2646),(2647,0,1576,'',2,0,2647),(2648,0,1576,'',3,0,2648),(2649,0,1577,'',1,0,2649),(2650,0,1578,'',1,0,2650),(2651,0,1579,'',1,0,2651),(2652,0,1579,'',2,0,2652),(2653,0,1579,'',3,0,2653),(2654,0,1580,'',1,0,2654),(2655,0,1581,'',1,0,2655),(2656,0,1582,'',1,0,2656),(2657,0,1582,'',2,0,2657),(2658,0,1582,'',3,0,2658),(2659,0,1583,'',1,0,2659),(2660,0,1584,'',1,0,2660),(2661,0,1585,'',1,0,2661),(2662,0,1585,'',2,0,2662),(2663,0,1585,'',3,0,2663),(2664,0,1586,'',1,0,2664),(2665,0,1587,'',1,0,2665),(2666,0,1588,'',1,0,2666),(2667,0,1588,'',2,0,2667),(2668,0,1588,'',3,0,2668),(2669,0,1589,'',1,0,2669),(2670,0,1589,'',2,0,2670),(2671,0,1590,'',1,0,2671),(2672,0,1590,'',2,0,2672),(2673,0,1590,'',3,0,2673),(2674,0,1591,'',1,0,2674),(2675,0,1592,'',1,0,2675),(2676,0,1592,'',2,0,2676),(2677,0,1593,'',1,0,2677),(2678,0,1593,'',2,0,2678),(2679,0,1593,'',3,0,2679),(2680,0,1594,'',1,0,2680),(2681,0,1595,'',1,0,2681),(2682,0,1595,'',2,0,2682),(2683,0,1596,'',1,0,2683),(2684,0,1596,'',2,0,2684),(2685,0,1596,'',3,0,2685),(2686,0,1597,'',1,0,2686),(2687,0,1598,'',1,0,2687),(2688,0,1598,'',2,0,2688),(2689,0,1599,'',1,0,2689),(2690,0,1599,'',2,0,2690),(2691,0,1599,'',3,0,2691),(2692,0,1600,'',1,0,2692),(2693,0,1601,'',1,0,2693),(2694,0,1601,'',2,0,2694),(2695,0,1602,'',1,0,2695),(2696,0,1602,'',2,0,2696),(2697,0,1602,'',3,0,2697),(2698,0,1603,'',1,0,2698),(2699,0,1604,'',1,0,2699),(2700,0,1604,'',2,0,2700),(2701,0,1604,'',3,0,2701),(2702,0,1605,'',1,0,2702),(2703,0,1605,'',2,0,2703),(2704,0,1605,'',3,0,2704),(2705,0,1606,'',1,0,2705),(2706,0,1607,'',1,0,2706),(2707,0,1608,'',1,0,2707),(2708,0,1608,'',2,0,2708),(2709,0,1608,'',3,0,2709),(2710,0,1609,'',1,0,2710),(2711,0,1610,'',1,0,2711),(2712,0,1611,'',1,0,2712),(2713,0,1611,'',2,0,2713),(2714,0,1611,'',3,0,2714),(2715,0,1612,'',1,0,2715),(2716,0,1613,'',1,0,2716),(2717,0,1614,'',1,0,2717),(2718,0,1614,'',2,0,2718),(2719,0,1614,'',3,0,2719),(2720,0,1615,'',1,0,2720),(2721,0,1616,'',1,0,2721),(2722,0,1617,'',1,0,2722),(2723,0,1617,'',2,0,2723),(2724,0,1617,'',3,0,2724),(2725,0,1618,'',1,0,2725),(2726,0,1619,'',1,0,2726),(2727,0,1620,'',1,0,2727),(2728,0,1620,'',2,0,2728),(2729,0,1620,'',3,0,2729),(2730,0,1621,'',1,0,2730),(2731,0,1621,'',2,0,2731),(2732,0,1621,'',3,0,2732),(2733,0,1622,'',1,0,2733),(2734,0,1623,'',1,0,2734),(2735,0,1624,'',1,0,2735),(2736,0,1624,'',2,0,2736),(2737,0,1624,'',3,0,2737),(2738,0,1625,'',1,0,2738),(2739,0,1626,'',1,0,2739),(2740,0,1627,'',1,0,2740),(2741,0,1627,'',2,0,2741),(2742,0,1627,'',3,0,2742),(2743,0,1628,'',1,0,2743),(2744,0,1629,'',1,0,2744),(2745,0,1630,'',1,0,2745),(2746,0,1630,'',2,0,2746),(2747,0,1630,'',3,0,2747),(2748,0,1631,'',1,0,2748),(2749,0,1632,'',1,0,2749),(2750,0,1633,'',1,0,2750),(2751,0,1633,'',2,0,2751),(2752,0,1633,'',3,0,2752),(2753,0,1634,'',1,0,2753),(2754,0,1635,'',1,0,2754),(2755,0,1636,'',1,0,2755),(2756,0,1636,'',2,0,2756),(2757,0,1636,'',3,0,2757),(2758,0,1637,'',1,0,2758),(2759,0,1637,'',2,0,2759),(2760,0,1637,'',3,0,2760),(2761,0,1637,'',4,0,2761),(2762,0,1638,'',1,0,2762),(2763,0,1639,'',1,0,2763),(2764,0,1640,'',1,0,2764),(2765,0,1640,'',2,0,2765),(2766,0,1640,'',3,0,2766),(2767,0,1640,'',4,0,2767),(2768,0,1641,'',1,0,2768),(2769,0,1642,'',1,0,2769),(2770,0,1643,'',1,0,2770),(2771,0,1643,'',2,0,2771),(2772,0,1643,'',3,0,2772),(2773,0,1643,'',4,0,2773),(2774,0,1644,'',1,0,2774),(2775,0,1645,'',1,0,2775),(2776,0,1646,'',1,0,2776),(2777,0,1646,'',2,0,2777),(2778,0,1646,'',3,0,2778),(2779,0,1646,'',4,0,2779),(2780,0,1647,'',1,0,2780),(2781,0,1648,'',1,0,2781),(2782,0,1649,'',1,0,2782),(2783,0,1649,'',2,0,2783),(2784,0,1649,'',3,0,2784),(2785,0,1649,'',4,0,2785),(2786,0,1650,'',1,0,2786),(2787,0,1651,'',1,0,2787),(2788,0,1652,'',1,0,2788),(2789,0,1652,'',2,0,2789),(2790,0,1652,'',3,0,2790),(2791,0,1652,'',4,0,2791),(2792,0,1653,'',1,0,2792),(2793,0,1653,'',2,0,2793),(2794,0,1654,'',1,0,2794),(2795,0,1655,'',1,0,2795),(2796,0,1656,'',1,0,2796),(2797,0,1656,'',2,0,2797),(2798,0,1657,'',1,0,2798),(2799,0,1658,'',1,0,2799),(2800,0,1659,'',1,0,2800),(2801,0,1659,'',2,0,2801),(2802,0,1660,'',1,0,2802),(2803,0,1661,'',1,0,2803),(2804,0,1662,'',1,0,2804),(2805,0,1662,'',2,0,2805),(2806,0,1663,'',1,0,2806),(2807,0,1664,'',1,0,2807),(2808,0,1665,'',1,0,2808),(2809,0,1665,'',2,0,2809),(2810,0,1666,'',1,0,2810),(2811,0,1667,'',1,0,2811),(2812,0,1668,'',1,0,2812),(2813,0,1668,'',2,0,2813),(2814,0,1669,'',1,0,2814),(2815,0,1670,'',1,0,2815),(2816,0,1670,'',2,0,2816),(2817,0,1671,'',1,0,2817),(2818,0,1672,'',1,0,2818),(2819,0,1673,'',1,0,2819),(2820,0,1673,'',2,0,2820),(2821,0,1674,'',1,0,2821),(2822,0,1675,'',1,0,2822),(2823,0,1676,'',1,0,2823),(2824,0,1676,'',2,0,2824),(2825,0,1677,'',1,0,2825),(2826,0,1678,'',1,0,2826),(2827,0,1679,'',1,0,2827),(2828,0,1679,'',2,0,2828),(2829,0,1680,'',1,0,2829),(2830,0,1681,'',1,0,2830),(2831,0,1682,'',1,0,2831),(2832,0,1682,'',2,0,2832),(2833,0,1683,'',1,0,2833),(2834,0,1684,'',1,0,2834),(2835,0,1684,'',2,0,2835),(2836,0,1685,'',1,0,2836),(2837,0,1686,'',1,0,2837),(2838,0,1686,'',2,0,2838),(2839,0,1687,'',1,0,2839),(2840,0,1688,'',1,0,2840),(2841,0,1689,'',1,0,2841),(2842,0,1689,'',2,0,2842),(2843,0,1690,'',1,0,2843),(2844,0,1691,'',1,0,2844),(2845,0,1692,'',1,0,2845),(2846,0,1692,'',2,0,2846),(2847,0,1693,'',1,0,2847),(2848,0,1694,'',1,0,2848),(2849,0,1695,'',1,0,2849),(2850,0,1695,'',2,0,2850),(2851,0,1696,'',1,0,2851),(2852,0,1697,'',1,0,2852),(2853,0,1698,'',1,0,2853),(2854,0,1698,'',2,0,2854),(2855,0,1699,'',1,0,2855),(2856,0,1700,'',1,0,2856),(2857,0,1700,'',2,0,2857),(2858,0,1701,'',1,0,2858),(2859,0,1702,'',1,0,2859),(2860,0,1703,'',1,0,2860),(2861,0,1703,'',2,0,2861),(2862,0,1703,'',3,0,2862),(2863,0,1704,'',1,0,2863),(2864,0,1705,'',1,0,2864),(2865,0,1706,'',1,0,2865),(2866,0,1706,'',2,0,2866),(2867,0,1706,'',3,0,2867),(2868,0,1707,'',1,0,2868),(2869,0,1708,'',1,0,2869),(2870,0,1709,'',1,0,2870),(2871,0,1709,'',2,0,2871),(2872,0,1709,'',3,0,2872),(2873,0,1710,'',1,0,2873),(2874,0,1711,'',1,0,2874),(2875,0,1712,'',1,0,2875),(2876,0,1712,'',2,0,2876),(2877,0,1712,'',3,0,2877),(2878,0,1713,'',1,0,2878),(2879,0,1714,'',1,0,2879),(2880,0,1715,'',1,0,2880),(2881,0,1715,'',2,0,2881),(2882,0,1715,'',3,0,2882),(2883,0,1716,'',1,0,2883),(2884,0,1716,'',2,0,2884),(2885,0,1716,'',3,0,2885),(2886,0,1717,'',1,0,2886),(2887,0,1717,'',2,0,2887),(2888,0,1718,'',1,0,2888),(2889,0,1719,'',1,0,2889),(2890,0,1720,'',1,0,2890),(2891,0,1720,'',2,0,2891),(2892,0,1721,'',1,0,2892),(2893,0,1722,'',1,0,2893),(2894,0,1723,'',1,0,2894),(2895,0,1723,'',2,0,2895),(2896,0,1724,'',1,0,2896),(2897,0,1725,'',1,0,2897),(2898,0,1726,'',1,0,2898),(2899,0,1726,'',2,0,2899),(2900,0,1727,'',1,0,2900),(2901,0,1728,'',1,0,2901),(2902,0,1729,'',1,0,2902),(2903,0,1729,'',2,0,2903),(2904,0,1730,'',1,0,2904),(2905,0,1731,'',1,0,2905),(2906,0,1732,'',1,0,2906),(2907,0,1732,'',2,0,2907),(2908,0,1733,'',1,0,2908),(2909,0,1734,'',1,0,2909),(2910,0,1734,'',2,0,2910),(2911,0,1734,'',3,0,2911),(2912,0,1735,'',1,0,2912),(2913,0,1736,'',1,0,2913),(2914,0,1737,'',1,0,2914),(2915,0,1737,'',2,0,2915),(2916,0,1737,'',3,0,2916),(2917,0,1738,'',1,0,2917),(2918,0,1739,'',1,0,2918),(2919,0,1740,'',1,0,2919),(2920,0,1740,'',2,0,2920),(2921,0,1740,'',3,0,2921),(2922,0,1741,'',1,0,2922),(2923,0,1742,'',1,0,2923),(2924,0,1743,'',1,0,2924),(2925,0,1743,'',2,0,2925),(2926,0,1743,'',3,0,2926),(2927,0,1744,'',1,0,2927),(2928,0,1745,'',1,0,2928),(2929,0,1746,'',1,0,2929),(2930,0,1746,'',2,0,2930),(2931,0,1746,'',3,0,2931),(2932,0,1747,'',1,0,2932),(2933,0,1748,'',1,0,2933),(2934,0,1748,'',2,0,2934),(2935,0,1748,'',3,0,2935),(2936,0,1749,'',1,0,2936),(2937,0,1749,'',2,0,2937),(2938,0,1750,'',1,0,2938),(2939,0,1751,'',1,0,2939),(2940,0,1752,'',1,0,2940),(2941,0,1752,'',2,0,2941),(2942,0,1753,'',1,0,2942),(2943,0,1754,'',1,0,2943),(2944,0,1755,'',1,0,2944),(2945,0,1755,'',2,0,2945),(2946,0,1756,'',1,0,2946),(2947,0,1757,'',1,0,2947),(2948,0,1758,'',1,0,2948),(2949,0,1758,'',2,0,2949),(2950,0,1759,'',1,0,2950),(2951,0,1760,'',1,0,2951),(2952,0,1761,'',1,0,2952),(2953,0,1761,'',2,0,2953),(2954,0,1762,'',1,0,2954),(2955,0,1763,'',1,0,2955),(2956,0,1764,'',1,0,2956),(2957,0,1764,'',2,0,2957),(2958,0,1765,'',1,0,2958),(2959,0,1765,'',2,0,2959),(2960,0,1765,'',3,0,2960),(2961,0,1766,'',1,0,2961),(2962,0,1767,'',1,0,2962),(2963,0,1768,'',1,0,2963),(2964,0,1768,'',2,0,2964),(2965,0,1768,'',3,0,2965),(2966,0,1769,'',1,0,2966),(2967,0,1770,'',1,0,2967),(2968,0,1771,'',1,0,2968),(2969,0,1771,'',2,0,2969),(2970,0,1771,'',3,0,2970),(2971,0,1772,'',1,0,2971),(2972,0,1773,'',1,0,2972),(2973,0,1774,'',1,0,2973),(2974,0,1774,'',2,0,2974),(2975,0,1774,'',3,0,2975),(2976,0,1775,'',1,0,2976),(2977,0,1776,'',1,0,2977),(2978,0,1777,'',1,0,2978),(2979,0,1777,'',2,0,2979),(2980,0,1777,'',3,0,2980),(2981,0,1778,'',1,0,2981),(2982,0,1779,'',1,0,2982),(2983,0,1780,'',1,0,2983),(2984,0,1780,'',2,0,2984),(2985,0,1780,'',3,0,2985),(2986,0,1781,'',1,0,2986),(2987,0,1781,'',2,0,2987),(2988,0,1781,'',3,0,2988),(2989,0,1782,'',1,0,2989),(2990,0,1783,'',1,0,2990),(2991,0,1784,'',1,0,2991),(2992,0,1784,'',2,0,2992),(2993,0,1784,'',3,0,2993),(2994,0,1785,'',1,0,2994),(2995,0,1786,'',1,0,2995),(2996,0,1787,'',1,0,2996),(2997,0,1787,'',2,0,2997),(2998,0,1787,'',3,0,2998),(2999,0,1788,'',1,0,2999),(3000,0,1789,'',1,0,3000),(3001,0,1790,'',1,0,3001),(3002,0,1790,'',2,0,3002),(3003,0,1790,'',3,0,3003),(3004,0,1791,'',1,0,3004),(3005,0,1792,'',1,0,3005),(3006,0,1793,'',1,0,3006),(3007,0,1793,'',2,0,3007),(3008,0,1793,'',3,0,3008),(3009,0,1794,'',1,0,3009),(3010,0,1795,'',1,0,3010),(3011,0,1796,'',1,0,3011),(3012,0,1796,'',2,0,3012),(3013,0,1796,'',3,0,3013),(3014,0,1797,'',1,0,3014),(3015,0,1798,'',1,0,3015),(3016,0,1798,'',2,0,3016),(3017,0,1799,'',1,0,3017),(3018,0,1800,'',1,0,3018),(3019,0,1801,'',1,0,3019),(3020,0,1801,'',2,0,3020),(3021,0,1802,'',1,0,3021),(3022,0,1803,'',1,0,3022),(3023,0,1804,'',1,0,3023),(3024,0,1804,'',2,0,3024),(3025,0,1805,'',1,0,3025),(3026,0,1806,'',1,0,3026),(3027,0,1807,'',1,0,3027),(3028,0,1807,'',2,0,3028),(3029,0,1808,'',1,0,3029),(3030,0,1809,'',1,0,3030),(3031,0,1810,'',1,0,3031),(3032,0,1810,'',2,0,3032),(3033,0,1811,'',1,0,3033),(3034,0,1812,'',1,0,3034),(3035,0,1812,'',2,0,3035),(3036,0,1813,'',1,0,3036),(3037,0,1814,'',1,0,3037),(3038,0,1814,'',2,0,3038),(3039,0,1815,'',1,0,3039),(3040,0,1816,'',1,0,3040),(3041,0,1817,'',1,0,3041),(3042,0,1817,'',2,0,3042),(3043,0,1818,'',1,0,3043),(3044,0,1819,'',1,0,3044),(3045,0,1819,'',2,0,3045),(3046,0,1820,'',1,0,3046),(3047,0,1820,'',2,0,3047),(3048,0,1821,'',1,0,3048),(3049,0,1822,'',1,0,3049),(3050,0,1823,'',1,0,3050),(3051,0,1823,'',2,0,3051),(3052,0,1824,'',1,0,3052),(3053,0,1825,'',1,0,3053),(3054,0,1826,'',1,0,3054),(3055,0,1826,'',2,0,3055),(3056,0,1827,'',1,0,3056),(3057,0,1828,'',1,0,3057),(3058,0,1828,'',2,0,3058),(3059,0,1828,'',3,0,3059),(3060,0,1829,'',1,0,3060),(3061,0,1830,'',1,0,3061),(3062,0,1831,'',1,0,3062),(3063,0,1831,'',2,0,3063),(3064,0,1831,'',3,0,3064),(3065,0,1832,'',1,0,3065),(3066,0,1833,'',1,0,3066),(3067,0,1833,'',2,0,3067),(3068,0,1833,'',3,0,3068),(3069,0,1834,'',1,0,3069),(3070,0,1835,'',1,0,3070),(3071,0,1835,'',2,0,3071),(3072,0,1835,'',3,0,3072),(3073,0,1835,'',4,0,3073),(3074,0,1836,'',1,0,3074),(3075,0,1837,'',1,0,3075),(3076,0,1838,'',1,0,3076),(3077,0,1838,'',2,0,3077),(3078,0,1838,'',3,0,3078),(3079,0,1838,'',4,0,3079),(3080,0,1839,'',1,0,3080),(3081,0,1840,'',1,0,3081),(3082,0,1840,'',2,0,3082),(3083,0,1840,'',3,0,3083),(3084,0,1840,'',4,0,3084),(3085,0,1841,'',1,0,3085),(3086,0,1842,'',1,0,3086),(3087,0,1842,'',2,0,3087),(3088,0,1842,'',3,0,3088),(3089,0,1843,'',1,0,3089),(3090,0,1844,'',1,0,3090),(3091,0,1845,'',1,0,3091),(3092,0,1845,'',2,0,3092),(3093,0,1845,'',3,0,3093),(3094,0,1846,'',1,0,3094),(3095,0,1847,'',1,0,3095),(3096,0,1847,'',2,0,3096),(3097,0,1847,'',3,0,3097),(3098,0,1848,'',1,0,3098),(3099,0,1848,'',2,0,3099),(3100,0,1848,'',3,0,3100),(3101,0,1848,'',4,0,3101),(3102,0,1849,'',1,0,3102),(3103,0,1850,'',1,0,3103),(3104,0,1851,'',1,0,3104),(3105,0,1851,'',2,0,3105),(3106,0,1851,'',3,0,3106),(3107,0,1851,'',4,0,3107),(3108,0,1852,'',1,0,3108),(3109,0,1853,'',1,0,3109),(3110,0,1854,'',1,0,3110),(3111,0,1854,'',2,0,3111),(3112,0,1854,'',3,0,3112),(3113,0,1854,'',4,0,3113),(3114,0,1855,'',1,0,3114),(3115,0,1855,'',2,0,3115),(3116,0,1855,'',3,0,3116),(3117,0,1856,'',1,0,3117),(3118,0,1857,'',1,0,3118),(3119,0,1858,'',1,0,3119),(3120,0,1858,'',2,0,3120),(3121,0,1858,'',3,0,3121),(3122,0,1859,'',1,0,3122),(3123,0,1860,'',1,0,3123),(3124,0,1861,'',1,0,3124),(3125,0,1861,'',2,0,3125),(3126,0,1861,'',3,0,3126),(3127,0,1862,'',1,0,3127),(3128,0,1862,'',2,0,3128),(3129,0,1863,'',1,0,3129),(3130,0,1864,'',1,0,3130),(3131,0,1865,'',1,0,3131),(3132,0,1865,'',2,0,3132),(3133,0,1866,'',1,0,3133),(3134,0,1867,'',1,0,3134),(3135,0,1868,'',1,0,3135),(3136,0,1868,'',2,0,3136),(3137,0,1869,'',1,0,3137),(3138,0,1869,'',2,0,3138),(3139,0,1869,'',3,0,3139),(3140,0,1869,'',4,0,3140),(3141,0,1870,'',1,0,3141),(3142,0,1871,'',1,0,3142),(3143,0,1872,'',1,0,3143),(3144,0,1872,'',2,0,3144),(3145,0,1872,'',3,0,3145),(3146,0,1872,'',4,0,3146),(3147,0,1873,'',1,0,3147),(3148,0,1874,'',1,0,3148),(3149,0,1875,'',1,0,3149),(3150,0,1875,'',2,0,3150),(3151,0,1875,'',3,0,3151),(3152,0,1875,'',4,0,3152),(3153,0,1876,'',1,0,3153),(3154,0,1877,'',1,0,3154),(3155,0,1877,'',2,0,3155),(3156,0,1877,'',3,0,3156),(3157,0,1878,'',1,0,3157),(3158,0,1879,'',1,0,3158),(3159,0,1880,'',1,0,3159),(3160,0,1880,'',2,0,3160),(3161,0,1880,'',3,0,3161),(3162,0,1881,'',1,0,3162),(3163,0,1882,'',1,0,3163),(3164,0,1882,'',2,0,3164),(3165,0,1882,'',3,0,3165),(3166,0,1883,'',1,0,3166),(3167,0,1884,'',1,0,3167),(3168,0,1884,'',2,0,3168),(3169,0,1885,'',1,0,3169),(3170,0,1886,'',1,0,3170),(3171,0,1887,'',1,0,3171),(3172,0,1887,'',2,0,3172),(3173,0,1888,'',1,0,3173),(3174,0,1889,'',1,0,3174),(3175,0,1889,'',2,0,3175),(3176,0,1890,'',1,0,3176),(3177,0,1891,'',1,0,3177),(3178,0,1891,'',2,0,3178),(3179,0,1892,'',1,0,3179),(3180,0,1893,'',1,0,3180),(3181,0,1894,'',1,0,3181),(3182,0,1894,'',2,0,3182),(3183,0,1895,'',1,0,3183),(3184,0,1896,'',1,0,3184),(3185,0,1896,'',2,0,3185),(3186,0,1897,'',1,0,3186),(3187,0,1898,'',1,0,3187),(3188,0,1899,'',1,0,3188),(3189,0,1899,'',2,0,3189),(3190,0,1900,'',1,0,3190),(3191,0,1901,'',1,0,3191),(3192,0,1902,'',1,0,3192),(3193,0,1902,'',2,0,3193),(3194,0,1903,'',1,0,3194),(3195,0,1903,'',2,0,3195),(3196,0,1904,'',1,0,3196),(3197,0,1904,'',2,0,3197),(3198,0,1905,'',1,0,3198),(3199,0,1906,'',1,0,3199),(3200,0,1907,'',1,0,3200),(3201,0,1907,'',2,0,3201),(3202,0,1908,'',1,0,3202),(3203,0,1909,'',1,0,3203),(3204,0,1910,'',1,0,3204),(3205,0,1910,'',2,0,3205),(3206,0,1911,'',1,0,3206),(3207,0,1912,'',1,0,3207),(3208,0,1913,'',1,0,3208),(3209,0,1913,'',2,0,3209),(3210,0,1914,'',1,0,3210),(3211,0,1915,'',1,0,3211),(3212,0,1916,'',1,0,3212),(3213,0,1916,'',2,0,3213),(3214,0,1917,'',1,0,3214),(3215,0,1918,'',1,0,3215),(3216,0,1919,'',1,0,3216),(3217,0,1919,'',2,0,3217),(3218,0,1920,'',1,0,3218),(3219,0,1920,'',2,0,3219),(3220,0,1921,'',1,0,3220),(3221,0,1922,'',1,0,3221),(3222,0,1923,'',1,0,3222),(3223,0,1923,'',2,0,3223),(3224,0,1924,'',1,0,3224),(3225,0,1925,'',1,0,3225),(3226,0,1926,'',1,0,3226),(3227,0,1926,'',2,0,3227),(3228,0,1927,'',1,0,3228),(3229,0,1928,'',1,0,3229),(3230,0,1929,'',1,0,3230),(3231,0,1929,'',2,0,3231),(3232,0,1930,'',1,0,3232),(3233,0,1931,'',1,0,3233),(3234,0,1932,'',1,0,3234),(3235,0,1932,'',2,0,3235),(3236,0,1933,'',1,0,3236),(3237,0,1934,'',1,0,3237),(3238,0,1935,'',1,0,3238),(3239,0,1935,'',2,0,3239),(3240,0,1936,'',1,0,3240),(3241,0,1937,'',1,0,3241),(3242,0,1937,'',2,0,3242),(3243,0,1937,'',3,0,3243),(3244,0,1938,'',1,0,3244),(3245,0,1939,'',1,0,3245),(3246,0,1940,'',1,0,3246),(3247,0,1940,'',2,0,3247),(3248,0,1940,'',3,0,3248),(3249,0,1941,'',1,0,3249),(3250,0,1942,'',1,0,3250),(3251,0,1943,'',1,0,3251),(3252,0,1943,'',2,0,3252),(3253,0,1943,'',3,0,3253),(3254,0,1944,'',1,0,3254),(3255,0,1945,'',1,0,3255),(3256,0,1946,'',1,0,3256),(3257,0,1946,'',2,0,3257),(3258,0,1946,'',3,0,3258),(3259,0,1947,'',1,0,3259),(3260,0,1948,'',1,0,3260),(3261,0,1949,'',1,0,3261),(3262,0,1949,'',2,0,3262),(3263,0,1949,'',3,0,3263),(3264,0,1950,'',1,0,3264),(3265,0,1951,'',1,0,3265),(3266,0,1951,'',2,0,3266),(3267,0,1951,'',3,0,3267),(3268,0,1952,'',1,0,3268),(3269,0,1952,'',2,0,3269),(3270,0,1952,'',3,0,3270),(3271,0,1953,'',1,0,3271),(3272,0,1954,'',1,0,3272),(3273,0,1955,'',1,0,3273),(3274,0,1955,'',2,0,3274),(3275,0,1955,'',3,0,3275),(3276,0,1956,'',1,0,3276),(3277,0,1957,'',1,0,3277),(3278,0,1958,'',1,0,3278),(3279,0,1958,'',2,0,3279),(3280,0,1958,'',3,0,3280),(3281,0,1959,'',1,0,3281),(3282,0,1960,'',1,0,3282),(3283,0,1961,'',1,0,3283),(3284,0,1961,'',2,0,3284),(3285,0,1961,'',3,0,3285),(3286,0,1962,'',1,0,3286),(3287,0,1963,'',1,0,3287),(3288,0,1964,'',1,0,3288),(3289,0,1964,'',2,0,3289),(3290,0,1964,'',3,0,3290),(3291,0,1965,'',1,0,3291),(3292,0,1966,'',1,0,3292),(3293,0,1967,'',1,0,3293),(3294,0,1967,'',2,0,3294),(3295,0,1967,'',3,0,3295),(3296,0,1968,'',1,0,3296),(3297,0,1968,'',2,0,3297),(3298,0,1969,'',1,0,3298),(3299,0,1970,'',1,0,3299),(3300,0,1971,'',1,0,3300),(3301,0,1971,'',2,0,3301),(3302,0,1972,'',1,0,3302),(3303,0,1973,'',1,0,3303),(3304,0,1974,'',1,0,3304),(3305,0,1974,'',2,0,3305),(3306,0,1975,'',1,0,3306),(3307,0,1976,'',1,0,3307),(3308,0,1977,'',1,0,3308),(3309,0,1977,'',2,0,3309),(3310,0,1978,'',1,0,3310),(3311,0,1979,'',1,0,3311),(3312,0,1980,'',1,0,3312),(3313,0,1980,'',2,0,3313),(3314,0,1981,'',1,0,3314),(3315,0,1982,'',1,0,3315),(3316,0,1983,'',1,0,3316),(3317,0,1983,'',2,0,3317),(3318,0,1984,'',1,0,3318),(3319,0,1984,'',2,0,3319),(3320,0,1984,'',3,0,3320),(3321,0,1985,'',1,0,3321),(3322,0,1986,'',1,0,3322),(3323,0,1987,'',1,0,3323),(3324,0,1987,'',2,0,3324),(3325,0,1987,'',3,0,3325),(3326,0,1988,'',1,0,3326),(3327,0,1989,'',1,0,3327),(3328,0,1990,'',1,0,3328),(3329,0,1990,'',2,0,3329),(3330,0,1990,'',3,0,3330),(3331,0,1991,'',1,0,3331),(3332,0,1991,'',2,0,3332),(3333,0,1992,'',1,0,3333),(3334,0,1993,'',1,0,3334),(3335,0,1994,'',1,0,3335),(3336,0,1994,'',2,0,3336),(3337,0,1995,'',1,0,3337),(3338,0,1996,'',1,0,3338),(3339,0,1997,'',1,0,3339),(3340,0,1997,'',2,0,3340),(3341,0,1998,'',1,0,3341),(3342,0,1998,'',2,0,3342),(3343,0,1999,'',1,0,3343),(3344,0,1999,'',2,0,3344),(3345,0,2000,'',1,0,3345),(3346,0,2000,'',2,0,3346),(3347,0,2001,'',1,0,3347),(3348,0,2001,'',2,0,3348),(3349,0,2002,'',1,0,3349),(3350,0,2002,'',2,0,3350),(3351,0,2003,'',1,0,3351),(3352,0,2003,'',2,0,3352),(3353,0,2004,'',1,0,3353),(3354,0,2004,'',2,0,3354),(3355,0,2004,'',3,0,3355),(3356,0,2005,'',1,0,3356),(3357,0,2006,'',1,0,3357),(3358,0,2007,'',1,0,3358),(3359,0,2007,'',2,0,3359),(3360,0,2007,'',3,0,3360),(3361,0,2008,'',1,0,3361),(3362,0,2009,'',1,0,3362),(3363,0,2010,'',1,0,3363),(3364,0,2010,'',2,0,3364),(3365,0,2010,'',3,0,3365),(3366,0,2011,'',1,0,3366),(3367,0,2011,'',2,0,3367),(3368,0,2011,'',3,0,3368),(3369,0,2012,'',1,0,3369),(3370,0,2013,'',1,0,3370),(3371,0,2014,'',1,0,3371),(3372,0,2014,'',2,0,3372),(3373,0,2014,'',3,0,3373),(3374,0,2015,'',1,0,3374),(3375,0,2016,'',1,0,3375),(3376,0,2017,'',1,0,3376),(3377,0,2017,'',2,0,3377),(3378,0,2017,'',3,0,3378),(3379,0,2018,'',1,0,3379),(3380,0,2018,'',2,0,3380),(3381,0,2019,'',1,0,3381),(3382,0,2020,'',1,0,3382),(3383,0,2021,'',1,0,3383),(3384,0,2021,'',2,0,3384),(3385,0,2022,'',1,0,3385),(3386,0,2023,'',1,0,3386),(3387,0,2024,'',1,0,3387),(3388,0,2024,'',2,0,3388),(3389,0,2025,'',1,0,3389),(3390,0,2025,'',2,0,3390),(3391,0,2025,'',3,0,3391),(3392,0,2026,'',1,0,3392),(3393,0,2027,'',1,0,3393),(3394,0,2028,'',1,0,3394),(3395,0,2028,'',2,0,3395),(3396,0,2028,'',3,0,3396),(3397,0,2029,'',1,0,3397),(3398,0,2030,'',1,0,3398),(3399,0,2031,'',1,0,3399),(3400,0,2031,'',2,0,3400),(3401,0,2031,'',3,0,3401),(3402,0,2032,'',1,0,3402),(3403,0,2033,'',1,0,3403),(3404,0,2034,'',1,0,3404),(3405,0,2034,'',2,0,3405),(3406,0,2034,'',3,0,3406),(3407,0,2035,'',1,0,3407),(3408,0,2036,'',1,0,3408),(3409,0,2037,'',1,0,3409),(3410,0,2037,'',2,0,3410),(3411,0,2037,'',3,0,3411),(3412,0,2038,'',1,0,3412),(3413,0,2039,'',1,0,3413),(3414,0,2040,'',1,0,3414),(3415,0,2040,'',2,0,3415),(3416,0,2040,'',3,0,3416);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity` (
  `value_id` int unsigned NOT NULL COMMENT 'Value media Entry ID',
  `entity_id` int unsigned NOT NULL COMMENT 'Product Entity ID',
  PRIMARY KEY (`value_id`,`entity_id`),
  KEY `FK_11B443E566D0F1A4C7684AD8FAC9CFAE` (`entity_id`),
  CONSTRAINT `FK_11B443E566D0F1A4C7684AD8FAC9CFAE` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_80EC8D98740F21EDD3873AF489663BE3` FOREIGN KEY (`value_id`) REFERENCES `[[dbprefix]]catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Link Media value to Product entity table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity` VALUES (1,1),(2,2),(3,2),(4,3),(5,3),(6,4),(7,5),(8,6),(9,6),(10,7),(11,8),(12,9),(13,10),(14,11),(15,11),(16,12),(17,13),(18,14),(19,15),(20,16),(21,16),(22,17),(23,18),(24,19),(25,20),(26,21),(27,22),(28,23),(29,24),(30,25),(31,26),(32,27),(33,28),(34,29),(35,30),(36,31),(37,32),(38,33),(39,34),(40,35),(41,36),(42,37),(43,38),(44,39),(45,40),(46,41),(47,42),(48,43),(49,43),(50,44),(51,45),(52,46),(53,47),(54,48),(55,48),(56,48),(57,49),(58,50),(59,51),(60,51),(61,51),(62,52),(63,53),(64,54),(65,54),(66,54),(67,55),(68,56),(69,57),(70,57),(71,57),(72,58),(73,59),(74,60),(75,60),(76,60),(77,61),(78,62),(79,62),(80,62),(81,63),(82,63),(83,63),(84,64),(85,65),(86,66),(87,66),(88,66),(89,67),(90,68),(91,69),(92,69),(93,69),(94,70),(95,71),(96,72),(97,72),(98,72),(99,73),(100,74),(101,75),(102,75),(103,75),(104,76),(105,77),(106,78),(107,78),(108,78),(109,79),(110,79),(111,79),(112,80),(113,81),(114,82),(115,82),(116,82),(117,83),(118,84),(119,85),(120,85),(121,85),(122,86),(123,87),(124,88),(125,88),(126,88),(127,89),(128,90),(129,91),(130,91),(131,91),(132,92),(133,93),(134,94),(135,94),(136,94),(137,95),(138,95),(139,95),(140,96),(141,97),(142,98),(143,98),(144,98),(145,99),(146,100),(147,101),(148,101),(149,101),(150,102),(151,103),(152,104),(153,104),(154,104),(155,105),(156,106),(157,107),(158,107),(159,107),(160,108),(161,109),(162,110),(163,110),(164,110),(165,111),(166,112),(167,113),(168,113),(169,113),(170,114),(171,115),(172,116),(173,116),(174,116),(175,117),(176,118),(177,119),(178,119),(179,119),(180,120),(181,121),(182,122),(183,122),(184,122),(185,123),(186,124),(187,125),(188,125),(189,125),(190,126),(191,126),(192,126),(193,127),(194,128),(195,128),(196,128),(197,129),(198,130),(199,131),(200,131),(201,131),(202,132),(203,133),(204,134),(205,134),(206,134),(207,135),(208,136),(209,137),(210,137),(211,137),(212,138),(213,139),(214,140),(215,140),(216,140),(217,141),(218,142),(219,142),(220,142),(221,143),(222,144),(223,144),(224,144),(225,145),(226,146),(227,147),(228,147),(229,147),(230,148),(231,149),(232,150),(233,150),(234,150),(235,151),(236,152),(237,153),(238,153),(239,153),(240,154),(241,155),(242,156),(243,156),(244,156),(245,157),(246,158),(247,158),(248,158),(249,159),(250,159),(251,159),(252,160),(253,161),(254,162),(255,162),(256,162),(257,163),(258,164),(259,165),(260,165),(261,165),(262,166),(263,167),(264,168),(265,168),(266,168),(267,169),(268,170),(269,171),(270,171),(271,171),(272,172),(273,173),(274,174),(275,174),(276,174),(277,175),(278,175),(279,175),(280,176),(281,177),(282,178),(283,178),(284,178),(285,179),(286,180),(287,181),(288,181),(289,181),(290,182),(291,183),(292,184),(293,184),(294,184),(295,185),(296,186),(297,187),(298,187),(299,187),(300,188),(301,189),(302,190),(303,190),(304,190),(305,191),(306,192),(307,192),(308,192),(309,193),(310,194),(311,195),(312,195),(313,195),(314,196),(315,197),(316,198),(317,198),(318,198),(319,199),(320,200),(321,201),(322,201),(323,201),(324,202),(325,203),(326,204),(327,204),(328,204),(329,205),(330,206),(331,206),(332,206),(333,207),(334,208),(335,209),(336,209),(337,209),(338,210),(339,211),(340,212),(341,212),(342,212),(343,213),(344,214),(345,215),(346,215),(347,215),(348,216),(349,217),(350,218),(351,218),(352,218),(353,219),(354,220),(355,221),(356,221),(357,221),(358,222),(359,222),(360,222),(361,223),(362,224),(363,224),(364,224),(365,225),(366,226),(367,227),(368,227),(369,227),(370,228),(371,229),(372,230),(373,230),(374,230),(375,231),(376,232),(377,233),(378,233),(379,233),(380,234),(381,235),(382,236),(383,236),(384,236),(385,237),(386,238),(387,238),(388,238),(389,239),(390,239),(391,239),(392,240),(393,241),(394,242),(395,242),(396,242),(397,243),(398,244),(399,245),(400,245),(401,245),(402,246),(403,247),(404,248),(405,248),(406,248),(407,249),(408,250),(409,251),(410,251),(411,251),(412,252),(413,253),(414,254),(415,254),(416,254),(417,255),(418,256),(419,257),(420,257),(421,257),(422,258),(423,259),(424,260),(425,260),(426,260),(427,261),(428,262),(429,263),(430,263),(431,263),(432,264),(433,265),(434,266),(435,266),(436,266),(437,267),(438,268),(439,269),(440,269),(441,269),(442,270),(443,270),(444,270),(445,271),(446,271),(447,271),(448,272),(449,273),(450,274),(451,274),(452,274),(453,275),(454,276),(455,277),(456,277),(457,277),(458,278),(459,279),(460,280),(461,280),(462,280),(463,281),(464,282),(465,283),(466,283),(467,283),(468,284),(469,285),(470,286),(471,286),(472,286),(473,287),(474,287),(475,287),(476,288),(477,289),(478,290),(479,290),(480,290),(481,291),(482,292),(483,293),(484,293),(485,293),(486,294),(487,295),(488,296),(489,296),(490,296),(491,297),(492,298),(493,299),(494,299),(495,299),(496,300),(497,301),(498,302),(499,302),(500,302),(501,303),(502,304),(503,304),(504,304),(505,305),(506,306),(507,307),(508,307),(509,307),(510,308),(511,309),(512,310),(513,310),(514,310),(515,311),(516,312),(517,313),(518,313),(519,313),(520,314),(521,315),(522,316),(523,316),(524,316),(525,317),(526,318),(527,318),(528,318),(529,319),(530,320),(531,320),(532,320),(533,321),(534,322),(535,323),(536,323),(537,323),(538,324),(539,325),(540,326),(541,326),(542,326),(543,327),(544,328),(545,329),(546,329),(547,329),(548,330),(549,331),(550,332),(551,332),(552,332),(553,333),(554,334),(555,334),(556,334),(557,335),(558,336),(559,337),(560,337),(561,337),(562,338),(563,339),(564,340),(565,340),(566,340),(567,341),(568,342),(569,343),(570,343),(571,343),(572,344),(573,345),(574,346),(575,346),(576,346),(577,347),(578,348),(579,349),(580,349),(581,349),(582,350),(583,350),(584,350),(585,351),(586,352),(587,353),(588,353),(589,353),(590,354),(591,355),(592,356),(593,356),(594,356),(595,357),(596,358),(597,359),(598,359),(599,359),(600,360),(601,361),(602,362),(603,362),(604,362),(605,363),(606,364),(607,365),(608,365),(609,365),(610,366),(611,366),(612,366),(613,367),(614,367),(615,367),(616,368),(617,369),(618,370),(619,370),(620,370),(621,371),(622,372),(623,373),(624,373),(625,373),(626,374),(627,375),(628,376),(629,376),(630,376),(631,377),(632,378),(633,379),(634,379),(635,379),(636,380),(637,381),(638,382),(639,382),(640,382),(641,383),(642,383),(643,383),(644,384),(645,385),(646,386),(647,386),(648,386),(649,387),(650,388),(651,389),(652,389),(653,389),(654,390),(655,391),(656,392),(657,392),(658,392),(659,393),(660,394),(661,395),(662,395),(663,395),(664,396),(665,397),(666,398),(667,398),(668,398),(669,399),(670,399),(671,399),(672,400),(673,401),(674,402),(675,402),(676,402),(677,403),(678,404),(679,405),(680,405),(681,405),(682,406),(683,407),(684,408),(685,408),(686,408),(687,409),(688,410),(689,411),(690,411),(691,411),(692,412),(693,413),(694,414),(695,414),(696,414),(697,415),(698,416),(699,417),(700,417),(701,417),(702,418),(703,419),(704,420),(705,420),(706,420),(707,421),(708,422),(709,423),(710,423),(711,423),(712,424),(713,425),(714,426),(715,426),(716,426),(717,427),(718,428),(719,429),(720,429),(721,429),(722,430),(723,430),(724,430),(725,431),(726,432),(727,432),(728,433),(729,434),(730,435),(731,435),(732,436),(733,437),(734,438),(735,438),(736,439),(737,440),(738,441),(739,441),(740,442),(741,443),(742,444),(743,444),(744,445),(745,446),(746,446),(747,447),(748,448),(749,448),(750,449),(751,450),(752,451),(753,451),(754,452),(755,453),(756,454),(757,454),(758,455),(759,456),(760,457),(761,457),(762,458),(763,459),(764,460),(765,460),(766,461),(767,462),(768,462),(769,463),(770,464),(771,464),(772,464),(773,465),(774,466),(775,467),(776,467),(777,467),(778,468),(779,469),(780,470),(781,470),(782,470),(783,471),(784,472),(785,473),(786,473),(787,473),(788,474),(789,475),(790,476),(791,476),(792,476),(793,477),(794,478),(795,478),(796,478),(797,479),(798,480),(799,480),(800,481),(801,482),(802,483),(803,483),(804,484),(805,485),(806,486),(807,486),(808,487),(809,488),(810,489),(811,489),(812,490),(813,491),(814,492),(815,492),(816,493),(817,494),(818,494),(819,495),(820,496),(821,497),(822,497),(823,497),(824,498),(825,499),(826,500),(827,500),(828,500),(829,501),(830,502),(831,503),(832,503),(833,503),(834,504),(835,505),(836,506),(837,506),(838,506),(839,507),(840,508),(841,509),(842,509),(843,509),(844,510),(845,510),(846,510),(847,511),(848,511),(849,511),(850,512),(851,513),(852,514),(853,514),(854,514),(855,515),(856,516),(857,517),(858,517),(859,517),(860,518),(861,519),(862,520),(863,520),(864,520),(865,521),(866,522),(867,523),(868,523),(869,523),(870,524),(871,525),(872,526),(873,526),(874,527),(875,527),(876,527),(877,528),(878,529),(879,530),(880,530),(881,530),(882,531),(883,532),(884,533),(885,533),(886,533),(887,534),(888,535),(889,536),(890,536),(891,536),(892,537),(893,538),(894,539),(895,539),(896,539),(897,540),(898,541),(899,542),(900,542),(901,542),(902,543),(903,544),(904,544),(905,545),(906,546),(907,547),(908,547),(909,548),(910,549),(911,550),(912,550),(913,551),(914,552),(915,553),(916,553),(917,554),(918,555),(919,556),(920,556),(921,557),(922,558),(923,558),(924,559),(925,560),(926,561),(927,561),(928,561),(929,562),(930,563),(931,564),(932,564),(933,564),(934,565),(935,566),(936,567),(937,567),(938,567),(939,568),(940,569),(941,570),(942,570),(943,570),(944,571),(945,572),(946,573),(947,573),(948,573),(949,574),(950,574),(951,574),(952,575),(953,576),(954,576),(955,576),(956,577),(957,578),(958,579),(959,579),(960,579),(961,580),(962,581),(963,582),(964,582),(965,582),(966,583),(967,584),(968,585),(969,585),(970,585),(971,586),(972,587),(973,588),(974,588),(975,588),(976,589),(977,590),(978,590),(979,590),(980,591),(981,592),(982,592),(983,592),(984,593),(985,594),(986,595),(987,595),(988,595),(989,596),(990,597),(991,598),(992,598),(993,598),(994,599),(995,600),(996,601),(997,601),(998,601),(999,602),(1000,603),(1001,604),(1002,604),(1003,604),(1004,605),(1005,606),(1006,606),(1007,606),(1008,607),(1009,607),(1010,608),(1011,609),(1012,610),(1013,610),(1014,611),(1015,612),(1016,613),(1017,613),(1018,614),(1019,615),(1020,616),(1021,616),(1022,617),(1023,618),(1024,619),(1025,619),(1026,620),(1027,621),(1028,622),(1029,622),(1030,623),(1031,624),(1032,625),(1033,625),(1034,625),(1035,626),(1036,627),(1037,628),(1038,628),(1039,628),(1040,629),(1041,630),(1042,631),(1043,631),(1044,631),(1045,632),(1046,633),(1047,634),(1048,634),(1049,634),(1050,635),(1051,636),(1052,637),(1053,637),(1054,637),(1055,638),(1056,638),(1057,638),(1058,639),(1059,640),(1060,641),(1061,641),(1062,641),(1063,641),(1064,642),(1065,643),(1066,644),(1067,644),(1068,644),(1069,644),(1070,645),(1071,646),(1072,647),(1073,647),(1074,647),(1075,647),(1076,648),(1077,649),(1078,650),(1079,650),(1080,650),(1081,650),(1082,651),(1083,652),(1084,653),(1085,653),(1086,653),(1087,653),(1088,654),(1089,654),(1090,654),(1091,654),(1092,655),(1093,656),(1094,657),(1095,658),(1096,659),(1097,660),(1098,661),(1099,662),(1100,663),(1101,664),(1102,665),(1103,666),(1104,667),(1105,668),(1106,669),(1107,670),(1108,671),(1109,671),(1110,671),(1111,672),(1112,672),(1113,672),(1114,673),(1115,673),(1116,673),(1117,674),(1118,674),(1119,674),(1120,675),(1121,675),(1122,675),(1123,676),(1124,676),(1125,676),(1126,677),(1127,677),(1128,678),(1129,678),(1130,679),(1131,679),(1132,680),(1133,680),(1134,681),(1135,681),(1136,682),(1137,682),(1138,683),(1139,683),(1140,684),(1141,684),(1142,685),(1143,685),(1144,686),(1145,686),(1146,687),(1147,687),(1148,688),(1149,688),(1150,689),(1151,689),(1152,690),(1153,690),(1154,691),(1155,691),(1156,692),(1157,692),(1158,693),(1159,693),(1160,694),(1161,694),(1162,695),(1163,695),(1164,695),(1165,696),(1166,696),(1167,696),(1168,697),(1169,697),(1170,697),(1171,698),(1172,698),(1173,698),(1174,699),(1175,699),(1176,699),(1177,700),(1178,700),(1179,700),(1180,701),(1181,701),(1182,701),(1183,702),(1184,702),(1185,702),(1186,703),(1187,703),(1188,703),(1189,704),(1190,704),(1191,704),(1192,705),(1193,705),(1194,705),(1195,706),(1196,706),(1197,706),(1198,707),(1199,707),(1200,708),(1201,708),(1202,709),(1203,709),(1204,710),(1205,710),(1206,711),(1207,711),(1208,712),(1209,712),(1210,713),(1211,713),(1212,714),(1213,714),(1214,715),(1215,715),(1216,716),(1217,716),(1218,717),(1219,717),(1220,718),(1221,718),(1222,719),(1223,719),(1224,720),(1225,720),(1226,721),(1227,721),(1228,722),(1229,722),(1230,723),(1231,723),(1232,724),(1233,724),(1234,725),(1235,726),(1236,726),(1237,727),(1238,728),(1239,729),(1240,729),(1241,730),(1242,731),(1243,732),(1244,732),(1245,733),(1246,734),(1247,735),(1248,735),(1249,736),(1250,737),(1251,737),(1252,738),(1253,739),(1254,739),(1255,740),(1256,741),(1257,742),(1258,742),(1259,743),(1260,744),(1261,745),(1262,745),(1263,746),(1264,747),(1265,748),(1266,748),(1267,749),(1268,750),(1269,750),(1270,751),(1271,752),(1272,753),(1273,754),(1274,755),(1275,756),(1276,757),(1277,758),(1278,759),(1279,760),(1280,761),(1281,762),(1282,763),(1283,763),(1284,763),(1285,764),(1286,765),(1287,765),(1288,766),(1289,767),(1290,768),(1291,768),(1292,769),(1293,770),(1294,771),(1295,771),(1296,772),(1297,773),(1298,774),(1299,774),(1300,775),(1301,776),(1302,776),(1303,777),(1304,778),(1305,778),(1306,778),(1307,779),(1308,780),(1309,781),(1310,781),(1311,781),(1312,782),(1313,783),(1314,784),(1315,784),(1316,784),(1317,785),(1318,786),(1319,787),(1320,787),(1321,787),(1322,788),(1323,789),(1324,789),(1325,789),(1326,790),(1327,790),(1328,790),(1329,791),(1330,792),(1331,793),(1332,793),(1333,793),(1334,794),(1335,795),(1336,796),(1337,796),(1338,796),(1339,797),(1340,798),(1341,799),(1342,799),(1343,799),(1344,800),(1345,801),(1346,802),(1347,802),(1348,802),(1349,803),(1350,804),(1351,804),(1352,804),(1353,804),(1354,804),(1355,805),(1356,806),(1357,807),(1358,807),(1359,807),(1360,807),(1361,807),(1362,808),(1363,809),(1364,810),(1365,810),(1366,810),(1367,810),(1368,810),(1369,811),(1370,812),(1371,813),(1372,813),(1373,813),(1374,813),(1375,813),(1376,814),(1377,815),(1378,815),(1379,815),(1380,815),(1381,815),(1382,816),(1383,817),(1384,817),(1385,817),(1386,818),(1387,819),(1388,820),(1389,820),(1390,820),(1391,821),(1392,822),(1393,823),(1394,823),(1395,823),(1396,824),(1397,825),(1398,826),(1399,826),(1400,826),(1401,827),(1402,828),(1403,828),(1404,828),(1405,829),(1406,830),(1407,830),(1408,830),(1409,831),(1410,832),(1411,833),(1412,833),(1413,833),(1414,834),(1415,835),(1416,836),(1417,836),(1418,836),(1419,837),(1420,838),(1421,839),(1422,839),(1423,839),(1424,840),(1425,841),(1426,841),(1427,841),(1428,842),(1429,842),(1430,842),(1431,843),(1432,844),(1433,845),(1434,845),(1435,845),(1436,846),(1437,847),(1438,848),(1439,848),(1440,848),(1441,849),(1442,850),(1443,851),(1444,851),(1445,851),(1446,852),(1447,853),(1448,854),(1449,854),(1450,854),(1451,855),(1452,856),(1453,856),(1454,856),(1455,857),(1456,858),(1457,859),(1458,859),(1459,859),(1460,860),(1461,861),(1462,862),(1463,862),(1464,862),(1465,863),(1466,864),(1467,865),(1468,865),(1469,865),(1470,866),(1471,867),(1472,867),(1473,867),(1474,868),(1475,868),(1476,869),(1477,870),(1478,871),(1479,871),(1480,872),(1481,873),(1482,874),(1483,874),(1484,875),(1485,876),(1486,877),(1487,877),(1488,878),(1489,879),(1490,880),(1491,880),(1492,881),(1493,882),(1494,882),(1495,883),(1496,884),(1497,885),(1498,885),(1499,886),(1500,887),(1501,888),(1502,888),(1503,889),(1504,890),(1505,891),(1506,891),(1507,892),(1508,893),(1509,893),(1510,894),(1511,894),(1512,894),(1513,895),(1514,895),(1515,895),(1516,896),(1517,896),(1518,896),(1519,897),(1520,897),(1521,897),(1522,898),(1523,898),(1524,898),(1525,899),(1526,900),(1527,900),(1528,900),(1529,901),(1530,902),(1531,903),(1532,903),(1533,903),(1534,904),(1535,905),(1536,906),(1537,906),(1538,906),(1539,907),(1540,908),(1541,909),(1542,909),(1543,909),(1544,910),(1545,911),(1546,911),(1547,911),(1548,912),(1549,912),(1550,913),(1551,914),(1552,915),(1553,915),(1554,916),(1555,917),(1556,918),(1557,918),(1558,919),(1559,920),(1560,921),(1561,921),(1562,922),(1563,923),(1564,924),(1565,924),(1566,925),(1567,926),(1568,927),(1569,927),(1570,927),(1571,928),(1572,929),(1573,930),(1574,930),(1575,930),(1576,931),(1577,932),(1578,933),(1579,933),(1580,933),(1581,934),(1582,935),(1583,936),(1584,936),(1585,936),(1586,937),(1587,937),(1588,937),(1589,938),(1590,939),(1591,939),(1592,939),(1593,940),(1594,941),(1595,942),(1596,942),(1597,942),(1598,943),(1599,944),(1600,945),(1601,945),(1602,945),(1603,946),(1604,947),(1605,948),(1606,948),(1607,948),(1608,949),(1609,950),(1610,950),(1611,950),(1612,951),(1613,951),(1614,951),(1615,952),(1616,953),(1617,954),(1618,954),(1619,954),(1620,955),(1621,956),(1622,957),(1623,957),(1624,957),(1625,958),(1626,959),(1627,960),(1628,960),(1629,960),(1630,961),(1631,962),(1632,963),(1633,963),(1634,963),(1635,964),(1636,964),(1637,965),(1638,966),(1639,967),(1640,967),(1641,968),(1642,969),(1643,970),(1644,970),(1645,971),(1646,972),(1647,973),(1648,973),(1649,974),(1650,975),(1651,976),(1652,976),(1653,977),(1654,978),(1655,978),(1656,978),(1657,979),(1658,980),(1659,981),(1660,981),(1661,981),(1662,982),(1663,983),(1664,984),(1665,984),(1666,984),(1667,985),(1668,986),(1669,987),(1670,987),(1671,987),(1672,988),(1673,989),(1674,989),(1675,989),(1676,990),(1677,990),(1678,990),(1679,991),(1680,992),(1681,993),(1682,993),(1683,993),(1684,994),(1685,995),(1686,996),(1687,996),(1688,996),(1689,997),(1690,998),(1691,999),(1692,999),(1693,999),(1694,1000),(1695,1001),(1696,1002),(1697,1002),(1698,1002),(1699,1003),(1700,1004),(1701,1004),(1702,1005),(1703,1006),(1704,1007),(1705,1007),(1706,1008),(1707,1009),(1708,1010),(1709,1010),(1710,1011),(1711,1012),(1712,1013),(1713,1013),(1714,1014),(1715,1015),(1716,1015),(1717,1016),(1718,1017),(1719,1018),(1720,1018),(1721,1019),(1722,1020),(1723,1021),(1724,1021),(1725,1022),(1726,1023),(1727,1024),(1728,1024),(1729,1025),(1730,1026),(1731,1027),(1732,1027),(1733,1028),(1734,1028),(1735,1029),(1736,1029),(1737,1029),(1738,1030),(1739,1031),(1740,1032),(1741,1032),(1742,1032),(1743,1033),(1744,1034),(1745,1035),(1746,1035),(1747,1035),(1748,1036),(1749,1037),(1750,1038),(1751,1038),(1752,1038),(1753,1039),(1754,1040),(1755,1041),(1756,1041),(1757,1041),(1758,1042),(1759,1043),(1760,1044),(1761,1044),(1762,1044),(1763,1045),(1764,1045),(1765,1045),(1766,1046),(1767,1047),(1768,1048),(1769,1048),(1770,1048),(1771,1049),(1772,1050),(1773,1051),(1774,1051),(1775,1051),(1776,1052),(1777,1053),(1778,1054),(1779,1054),(1780,1054),(1781,1055),(1782,1056),(1783,1057),(1784,1057),(1785,1057),(1786,1058),(1787,1059),(1788,1060),(1789,1060),(1790,1060),(1791,1061),(1792,1062),(1793,1063),(1794,1063),(1795,1063),(1796,1064),(1797,1065),(1798,1066),(1799,1066),(1800,1066),(1801,1067),(1802,1068),(1803,1069),(1804,1069),(1805,1069),(1806,1070),(1807,1071),(1808,1072),(1809,1072),(1810,1072),(1811,1073),(1812,1074),(1813,1075),(1814,1075),(1815,1075),(1816,1076),(1817,1076),(1818,1076),(1819,1077),(1820,1077),(1821,1077),(1822,1078),(1823,1079),(1824,1080),(1825,1080),(1826,1080),(1827,1081),(1828,1082),(1829,1083),(1830,1083),(1831,1083),(1832,1084),(1833,1085),(1834,1086),(1835,1086),(1836,1086),(1837,1087),(1838,1088),(1839,1089),(1840,1089),(1841,1089),(1842,1090),(1843,1091),(1844,1092),(1845,1092),(1846,1092),(1847,1093),(1848,1094),(1849,1095),(1850,1095),(1851,1096),(1852,1097),(1853,1098),(1854,1098),(1855,1099),(1856,1100),(1857,1101),(1858,1101),(1859,1102),(1860,1103),(1861,1104),(1862,1104),(1863,1105),(1864,1106),(1865,1107),(1866,1107),(1867,1108),(1868,1108),(1869,1109),(1870,1109),(1871,1109),(1872,1110),(1873,1110),(1874,1110),(1875,1111),(1876,1111),(1877,1111),(1878,1112),(1879,1112),(1880,1112),(1881,1113),(1882,1113),(1883,1113),(1884,1114),(1885,1114),(1886,1114),(1887,1115),(1888,1115),(1889,1115),(1890,1116),(1891,1117),(1892,1118),(1893,1118),(1894,1118),(1895,1119),(1896,1120),(1897,1121),(1898,1121),(1899,1121),(1900,1122),(1901,1123),(1902,1124),(1903,1124),(1904,1124),(1905,1125),(1906,1126),(1907,1127),(1908,1127),(1909,1127),(1910,1128),(1911,1129),(1912,1130),(1913,1130),(1914,1130),(1915,1131),(1916,1132),(1917,1133),(1918,1133),(1919,1133),(1920,1133),(1921,1134),(1922,1135),(1923,1136),(1924,1136),(1925,1136),(1926,1136),(1927,1137),(1928,1138),(1929,1139),(1930,1139),(1931,1139),(1932,1139),(1933,1140),(1934,1141),(1935,1142),(1936,1142),(1937,1142),(1938,1142),(1939,1143),(1940,1144),(1941,1145),(1942,1145),(1943,1145),(1944,1145),(1945,1146),(1946,1146),(1947,1146),(1948,1146),(1949,1147),(1950,1148),(1951,1148),(1952,1148),(1953,1149),(1954,1150),(1955,1151),(1956,1151),(1957,1151),(1958,1152),(1959,1153),(1960,1154),(1961,1154),(1962,1154),(1963,1155),(1964,1156),(1965,1157),(1966,1157),(1967,1157),(1968,1158),(1969,1159),(1970,1160),(1971,1160),(1972,1160),(1973,1161),(1974,1162),(1975,1162),(1976,1162),(1977,1163),(1978,1164),(1979,1164),(1980,1164),(1981,1165),(1982,1166),(1983,1167),(1984,1167),(1985,1167),(1986,1168),(1987,1169),(1988,1170),(1989,1170),(1990,1170),(1991,1171),(1992,1172),(1993,1173),(1994,1173),(1995,1173),(1996,1174),(1997,1175),(1998,1176),(1999,1176),(2000,1176),(2001,1177),(2002,1178),(2003,1178),(2004,1178),(2005,1179),(2006,1179),(2007,1180),(2008,1181),(2009,1182),(2010,1182),(2011,1183),(2012,1184),(2013,1185),(2014,1185),(2015,1186),(2016,1187),(2017,1188),(2018,1188),(2019,1189),(2020,1190),(2021,1191),(2022,1191),(2023,1192),(2024,1193),(2025,1194),(2026,1194),(2027,1195),(2028,1195),(2029,1196),(2030,1197),(2031,1198),(2032,1198),(2033,1199),(2034,1200),(2035,1201),(2036,1201),(2037,1202),(2038,1203),(2039,1204),(2040,1204),(2041,1205),(2042,1206),(2043,1207),(2044,1207),(2045,1208),(2046,1209),(2047,1210),(2048,1210),(2049,1211),(2050,1212),(2051,1212),(2052,1212),(2053,1213),(2054,1214),(2055,1215),(2056,1215),(2057,1215),(2058,1216),(2059,1217),(2060,1218),(2061,1218),(2062,1218),(2063,1219),(2064,1220),(2065,1220),(2066,1220),(2067,1221),(2068,1222),(2069,1223),(2070,1223),(2071,1223),(2072,1224),(2073,1225),(2074,1226),(2075,1226),(2076,1226),(2077,1227),(2078,1228),(2079,1229),(2080,1229),(2081,1229),(2082,1230),(2083,1231),(2084,1232),(2085,1232),(2086,1232),(2087,1233),(2088,1234),(2089,1235),(2090,1235),(2091,1235),(2092,1236),(2093,1236),(2094,1236),(2095,1237),(2096,1238),(2097,1239),(2098,1239),(2099,1239),(2100,1240),(2101,1241),(2102,1242),(2103,1242),(2104,1242),(2105,1243),(2106,1244),(2107,1245),(2108,1245),(2109,1245),(2110,1246),(2111,1247),(2112,1248),(2113,1248),(2114,1248),(2115,1249),(2116,1250),(2117,1251),(2118,1251),(2119,1251),(2120,1252),(2121,1252),(2122,1252),(2123,1253),(2124,1254),(2125,1255),(2126,1255),(2127,1255),(2128,1255),(2129,1256),(2130,1257),(2131,1258),(2132,1258),(2133,1258),(2134,1258),(2135,1259),(2136,1260),(2137,1261),(2138,1261),(2139,1261),(2140,1261),(2141,1262),(2142,1263),(2143,1264),(2144,1264),(2145,1264),(2146,1264),(2147,1265),(2148,1266),(2149,1267),(2150,1267),(2151,1267),(2152,1267),(2153,1268),(2154,1268),(2155,1268),(2156,1268),(2157,1269),(2158,1269),(2159,1269),(2160,1270),(2161,1271),(2162,1272),(2163,1272),(2164,1272),(2165,1273),(2166,1274),(2167,1275),(2168,1275),(2169,1275),(2170,1276),(2171,1277),(2172,1278),(2173,1278),(2174,1278),(2175,1279),(2176,1280),(2177,1281),(2178,1281),(2179,1281),(2180,1282),(2181,1283),(2182,1284),(2183,1284),(2184,1284),(2185,1285),(2186,1286),(2187,1286),(2188,1286),(2189,1287),(2190,1288),(2191,1289),(2192,1289),(2193,1289),(2194,1290),(2195,1291),(2196,1292),(2197,1292),(2198,1292),(2199,1293),(2200,1294),(2201,1295),(2202,1295),(2203,1295),(2204,1296),(2205,1297),(2206,1298),(2207,1298),(2208,1298),(2209,1299),(2210,1300),(2211,1300),(2212,1300),(2213,1301),(2214,1301),(2215,1301),(2216,1301),(2217,1302),(2218,1303),(2219,1304),(2220,1304),(2221,1304),(2222,1304),(2223,1305),(2224,1306),(2225,1307),(2226,1307),(2227,1307),(2228,1307),(2229,1308),(2230,1309),(2231,1310),(2232,1310),(2233,1310),(2234,1310),(2235,1311),(2236,1312),(2237,1313),(2238,1313),(2239,1313),(2240,1313),(2241,1314),(2242,1315),(2243,1316),(2244,1316),(2245,1316),(2246,1316),(2247,1317),(2248,1318),(2249,1319),(2250,1319),(2251,1319),(2252,1320),(2253,1321),(2254,1322),(2255,1322),(2256,1322),(2257,1323),(2258,1324),(2259,1325),(2260,1325),(2261,1325),(2262,1326),(2263,1327),(2264,1328),(2265,1328),(2266,1328),(2267,1329),(2268,1330),(2269,1331),(2270,1331),(2271,1331),(2272,1332),(2273,1332),(2274,1332),(2275,1333),(2276,1334),(2277,1335),(2278,1335),(2279,1335),(2280,1336),(2281,1337),(2282,1338),(2283,1338),(2284,1338),(2285,1339),(2286,1340),(2287,1341),(2288,1341),(2289,1341),(2290,1342),(2291,1343),(2292,1344),(2293,1344),(2294,1344),(2295,1345),(2296,1346),(2297,1347),(2298,1347),(2299,1347),(2300,1348),(2301,1348),(2302,1348),(2303,1349),(2304,1350),(2305,1350),(2306,1350),(2307,1351),(2308,1352),(2309,1353),(2310,1353),(2311,1353),(2312,1354),(2313,1355),(2314,1356),(2315,1356),(2316,1356),(2317,1357),(2318,1358),(2319,1359),(2320,1359),(2321,1359),(2322,1360),(2323,1361),(2324,1362),(2325,1362),(2326,1362),(2327,1363),(2328,1364),(2329,1364),(2330,1364),(2331,1365),(2332,1366),(2333,1367),(2334,1367),(2335,1367),(2336,1368),(2337,1369),(2338,1370),(2339,1370),(2340,1370),(2341,1371),(2342,1372),(2343,1373),(2344,1373),(2345,1373),(2346,1374),(2347,1375),(2348,1376),(2349,1376),(2350,1376),(2351,1377),(2352,1378),(2353,1379),(2354,1379),(2355,1379),(2356,1380),(2357,1380),(2358,1380),(2359,1381),(2360,1382),(2361,1382),(2362,1382),(2363,1383),(2364,1384),(2365,1385),(2366,1385),(2367,1385),(2368,1386),(2369,1387),(2370,1388),(2371,1388),(2372,1388),(2373,1389),(2374,1390),(2375,1391),(2376,1391),(2377,1391),(2378,1392),(2379,1393),(2380,1394),(2381,1394),(2382,1394),(2383,1395),(2384,1396),(2385,1396),(2386,1396),(2387,1397),(2388,1398),(2389,1398),(2390,1399),(2391,1400),(2392,1401),(2393,1401),(2394,1402),(2395,1403),(2396,1404),(2397,1404),(2398,1405),(2399,1406),(2400,1407),(2401,1407),(2402,1408),(2403,1409),(2404,1410),(2405,1410),(2406,1411),(2407,1412),(2408,1412),(2409,1413),(2410,1414),(2411,1415),(2412,1415),(2413,1415),(2414,1416),(2415,1417),(2416,1418),(2417,1418),(2418,1418),(2419,1419),(2420,1420),(2421,1421),(2422,1421),(2423,1421),(2424,1422),(2425,1423),(2426,1424),(2427,1424),(2428,1424),(2429,1425),(2430,1426),(2431,1427),(2432,1427),(2433,1427),(2434,1428),(2435,1428),(2436,1428),(2437,1429),(2438,1430),(2439,1430),(2440,1431),(2441,1432),(2442,1433),(2443,1433),(2444,1434),(2445,1435),(2446,1436),(2447,1436),(2448,1437),(2449,1438),(2450,1439),(2451,1439),(2452,1440),(2453,1441),(2454,1442),(2455,1442),(2456,1443),(2457,1444),(2458,1444),(2459,1445),(2460,1446),(2461,1446),(2462,1447),(2463,1448),(2464,1449),(2465,1449),(2466,1450),(2467,1451),(2468,1452),(2469,1452),(2470,1453),(2471,1454),(2472,1455),(2473,1455),(2474,1456),(2475,1457),(2476,1458),(2477,1458),(2478,1459),(2479,1460),(2480,1460),(2481,1461),(2482,1461),(2483,1461),(2484,1462),(2485,1463),(2486,1464),(2487,1464),(2488,1464),(2489,1465),(2490,1466),(2491,1467),(2492,1467),(2493,1467),(2494,1468),(2495,1469),(2496,1470),(2497,1470),(2498,1470),(2499,1471),(2500,1472),(2501,1473),(2502,1473),(2503,1473),(2504,1474),(2505,1475),(2506,1476),(2507,1476),(2508,1476),(2509,1477),(2510,1478),(2511,1478),(2512,1479),(2513,1480),(2514,1481),(2515,1481),(2516,1482),(2517,1483),(2518,1484),(2519,1484),(2520,1485),(2521,1486),(2522,1487),(2523,1487),(2524,1488),(2525,1489),(2526,1490),(2527,1490),(2528,1491),(2529,1492),(2530,1492),(2531,1493),(2532,1493),(2533,1494),(2534,1495),(2535,1496),(2536,1496),(2537,1497),(2538,1498),(2539,1499),(2540,1499),(2541,1500),(2542,1501),(2543,1502),(2544,1502),(2545,1503),(2546,1504),(2547,1505),(2548,1505),(2549,1506),(2550,1507),(2551,1508),(2552,1508),(2553,1509),(2554,1510),(2555,1510),(2556,1511),(2557,1512),(2558,1513),(2559,1513),(2560,1514),(2561,1515),(2562,1516),(2563,1516),(2564,1517),(2565,1518),(2566,1519),(2567,1519),(2568,1520),(2569,1521),(2570,1522),(2571,1522),(2572,1523),(2573,1524),(2574,1524),(2575,1525),(2576,1526),(2577,1527),(2578,1527),(2579,1528),(2580,1529),(2581,1530),(2582,1530),(2583,1531),(2584,1532),(2585,1533),(2586,1533),(2587,1534),(2588,1535),(2589,1536),(2590,1536),(2591,1537),(2592,1538),(2593,1539),(2594,1539),(2595,1540),(2596,1540),(2597,1541),(2598,1542),(2599,1542),(2600,1543),(2601,1544),(2602,1545),(2603,1545),(2604,1546),(2605,1547),(2606,1548),(2607,1548),(2608,1549),(2609,1550),(2610,1551),(2611,1551),(2612,1552),(2613,1553),(2614,1554),(2615,1554),(2616,1555),(2617,1556),(2618,1556),(2619,1557),(2620,1557),(2621,1558),(2622,1559),(2623,1560),(2624,1560),(2625,1561),(2626,1562),(2627,1563),(2628,1563),(2629,1564),(2630,1565),(2631,1566),(2632,1566),(2633,1567),(2634,1568),(2635,1569),(2636,1569),(2637,1570),(2638,1571),(2639,1572),(2640,1572),(2641,1573),(2642,1573),(2643,1573),(2644,1574),(2645,1575),(2646,1576),(2647,1576),(2648,1576),(2649,1577),(2650,1578),(2651,1579),(2652,1579),(2653,1579),(2654,1580),(2655,1581),(2656,1582),(2657,1582),(2658,1582),(2659,1583),(2660,1584),(2661,1585),(2662,1585),(2663,1585),(2664,1586),(2665,1587),(2666,1588),(2667,1588),(2668,1588),(2669,1589),(2670,1589),(2671,1590),(2672,1590),(2673,1590),(2674,1591),(2675,1592),(2676,1592),(2677,1593),(2678,1593),(2679,1593),(2680,1594),(2681,1595),(2682,1595),(2683,1596),(2684,1596),(2685,1596),(2686,1597),(2687,1598),(2688,1598),(2689,1599),(2690,1599),(2691,1599),(2692,1600),(2693,1601),(2694,1601),(2695,1602),(2696,1602),(2697,1602),(2698,1603),(2699,1604),(2700,1604),(2701,1604),(2702,1605),(2703,1605),(2704,1605),(2705,1606),(2706,1607),(2707,1608),(2708,1608),(2709,1608),(2710,1609),(2711,1610),(2712,1611),(2713,1611),(2714,1611),(2715,1612),(2716,1613),(2717,1614),(2718,1614),(2719,1614),(2720,1615),(2721,1616),(2722,1617),(2723,1617),(2724,1617),(2725,1618),(2726,1619),(2727,1620),(2728,1620),(2729,1620),(2730,1621),(2731,1621),(2732,1621),(2733,1622),(2734,1623),(2735,1624),(2736,1624),(2737,1624),(2738,1625),(2739,1626),(2740,1627),(2741,1627),(2742,1627),(2743,1628),(2744,1629),(2745,1630),(2746,1630),(2747,1630),(2748,1631),(2749,1632),(2750,1633),(2751,1633),(2752,1633),(2753,1634),(2754,1635),(2755,1636),(2756,1636),(2757,1636),(2758,1637),(2759,1637),(2760,1637),(2761,1637),(2762,1638),(2763,1639),(2764,1640),(2765,1640),(2766,1640),(2767,1640),(2768,1641),(2769,1642),(2770,1643),(2771,1643),(2772,1643),(2773,1643),(2774,1644),(2775,1645),(2776,1646),(2777,1646),(2778,1646),(2779,1646),(2780,1647),(2781,1648),(2782,1649),(2783,1649),(2784,1649),(2785,1649),(2786,1650),(2787,1651),(2788,1652),(2789,1652),(2790,1652),(2791,1652),(2792,1653),(2793,1653),(2794,1654),(2795,1655),(2796,1656),(2797,1656),(2798,1657),(2799,1658),(2800,1659),(2801,1659),(2802,1660),(2803,1661),(2804,1662),(2805,1662),(2806,1663),(2807,1664),(2808,1665),(2809,1665),(2810,1666),(2811,1667),(2812,1668),(2813,1668),(2814,1669),(2815,1670),(2816,1670),(2817,1671),(2818,1672),(2819,1673),(2820,1673),(2821,1674),(2822,1675),(2823,1676),(2824,1676),(2825,1677),(2826,1678),(2827,1679),(2828,1679),(2829,1680),(2830,1681),(2831,1682),(2832,1682),(2833,1683),(2834,1684),(2835,1684),(2836,1685),(2837,1686),(2838,1686),(2839,1687),(2840,1688),(2841,1689),(2842,1689),(2843,1690),(2844,1691),(2845,1692),(2846,1692),(2847,1693),(2848,1694),(2849,1695),(2850,1695),(2851,1696),(2852,1697),(2853,1698),(2854,1698),(2855,1699),(2856,1700),(2857,1700),(2858,1701),(2859,1702),(2860,1703),(2861,1703),(2862,1703),(2863,1704),(2864,1705),(2865,1706),(2866,1706),(2867,1706),(2868,1707),(2869,1708),(2870,1709),(2871,1709),(2872,1709),(2873,1710),(2874,1711),(2875,1712),(2876,1712),(2877,1712),(2878,1713),(2879,1714),(2880,1715),(2881,1715),(2882,1715),(2883,1716),(2884,1716),(2885,1716),(2886,1717),(2887,1717),(2888,1718),(2889,1719),(2890,1720),(2891,1720),(2892,1721),(2893,1722),(2894,1723),(2895,1723),(2896,1724),(2897,1725),(2898,1726),(2899,1726),(2900,1727),(2901,1728),(2902,1729),(2903,1729),(2904,1730),(2905,1731),(2906,1732),(2907,1732),(2908,1733),(2909,1734),(2910,1734),(2911,1734),(2912,1735),(2913,1736),(2914,1737),(2915,1737),(2916,1737),(2917,1738),(2918,1739),(2919,1740),(2920,1740),(2921,1740),(2922,1741),(2923,1742),(2924,1743),(2925,1743),(2926,1743),(2927,1744),(2928,1745),(2929,1746),(2930,1746),(2931,1746),(2932,1747),(2933,1748),(2934,1748),(2935,1748),(2936,1749),(2937,1749),(2938,1750),(2939,1751),(2940,1752),(2941,1752),(2942,1753),(2943,1754),(2944,1755),(2945,1755),(2946,1756),(2947,1757),(2948,1758),(2949,1758),(2950,1759),(2951,1760),(2952,1761),(2953,1761),(2954,1762),(2955,1763),(2956,1764),(2957,1764),(2958,1765),(2959,1765),(2960,1765),(2961,1766),(2962,1767),(2963,1768),(2964,1768),(2965,1768),(2966,1769),(2967,1770),(2968,1771),(2969,1771),(2970,1771),(2971,1772),(2972,1773),(2973,1774),(2974,1774),(2975,1774),(2976,1775),(2977,1776),(2978,1777),(2979,1777),(2980,1777),(2981,1778),(2982,1779),(2983,1780),(2984,1780),(2985,1780),(2986,1781),(2987,1781),(2988,1781),(2989,1782),(2990,1783),(2991,1784),(2992,1784),(2993,1784),(2994,1785),(2995,1786),(2996,1787),(2997,1787),(2998,1787),(2999,1788),(3000,1789),(3001,1790),(3002,1790),(3003,1790),(3004,1791),(3005,1792),(3006,1793),(3007,1793),(3008,1793),(3009,1794),(3010,1795),(3011,1796),(3012,1796),(3013,1796),(3014,1797),(3015,1798),(3016,1798),(3017,1799),(3018,1800),(3019,1801),(3020,1801),(3021,1802),(3022,1803),(3023,1804),(3024,1804),(3025,1805),(3026,1806),(3027,1807),(3028,1807),(3029,1808),(3030,1809),(3031,1810),(3032,1810),(3033,1811),(3034,1812),(3035,1812),(3036,1813),(3037,1814),(3038,1814),(3039,1815),(3040,1816),(3041,1817),(3042,1817),(3043,1818),(3044,1819),(3045,1819),(3046,1820),(3047,1820),(3048,1821),(3049,1822),(3050,1823),(3051,1823),(3052,1824),(3053,1825),(3054,1826),(3055,1826),(3056,1827),(3057,1828),(3058,1828),(3059,1828),(3060,1829),(3061,1830),(3062,1831),(3063,1831),(3064,1831),(3065,1832),(3066,1833),(3067,1833),(3068,1833),(3069,1834),(3070,1835),(3071,1835),(3072,1835),(3073,1835),(3074,1836),(3075,1837),(3076,1838),(3077,1838),(3078,1838),(3079,1838),(3080,1839),(3081,1840),(3082,1840),(3083,1840),(3084,1840),(3085,1841),(3086,1842),(3087,1842),(3088,1842),(3089,1843),(3090,1844),(3091,1845),(3092,1845),(3093,1845),(3094,1846),(3095,1847),(3096,1847),(3097,1847),(3098,1848),(3099,1848),(3100,1848),(3101,1848),(3102,1849),(3103,1850),(3104,1851),(3105,1851),(3106,1851),(3107,1851),(3108,1852),(3109,1853),(3110,1854),(3111,1854),(3112,1854),(3113,1854),(3114,1855),(3115,1855),(3116,1855),(3117,1856),(3118,1857),(3119,1858),(3120,1858),(3121,1858),(3122,1859),(3123,1860),(3124,1861),(3125,1861),(3126,1861),(3127,1862),(3128,1862),(3129,1863),(3130,1864),(3131,1865),(3132,1865),(3133,1866),(3134,1867),(3135,1868),(3136,1868),(3137,1869),(3138,1869),(3139,1869),(3140,1869),(3141,1870),(3142,1871),(3143,1872),(3144,1872),(3145,1872),(3146,1872),(3147,1873),(3148,1874),(3149,1875),(3150,1875),(3151,1875),(3152,1875),(3153,1876),(3154,1877),(3155,1877),(3156,1877),(3157,1878),(3158,1879),(3159,1880),(3160,1880),(3161,1880),(3162,1881),(3163,1882),(3164,1882),(3165,1882),(3166,1883),(3167,1884),(3168,1884),(3169,1885),(3170,1886),(3171,1887),(3172,1887),(3173,1888),(3174,1889),(3175,1889),(3176,1890),(3177,1891),(3178,1891),(3179,1892),(3180,1893),(3181,1894),(3182,1894),(3183,1895),(3184,1896),(3185,1896),(3186,1897),(3187,1898),(3188,1899),(3189,1899),(3190,1900),(3191,1901),(3192,1902),(3193,1902),(3194,1903),(3195,1903),(3196,1904),(3197,1904),(3198,1905),(3199,1906),(3200,1907),(3201,1907),(3202,1908),(3203,1909),(3204,1910),(3205,1910),(3206,1911),(3207,1912),(3208,1913),(3209,1913),(3210,1914),(3211,1915),(3212,1916),(3213,1916),(3214,1917),(3215,1918),(3216,1919),(3217,1919),(3218,1920),(3219,1920),(3220,1921),(3221,1922),(3222,1923),(3223,1923),(3224,1924),(3225,1925),(3226,1926),(3227,1926),(3228,1927),(3229,1928),(3230,1929),(3231,1929),(3232,1930),(3233,1931),(3234,1932),(3235,1932),(3236,1933),(3237,1934),(3238,1935),(3239,1935),(3240,1936),(3241,1937),(3242,1937),(3243,1937),(3244,1938),(3245,1939),(3246,1940),(3247,1940),(3248,1940),(3249,1941),(3250,1942),(3251,1943),(3252,1943),(3253,1943),(3254,1944),(3255,1945),(3256,1946),(3257,1946),(3258,1946),(3259,1947),(3260,1948),(3261,1949),(3262,1949),(3263,1949),(3264,1950),(3265,1951),(3266,1951),(3267,1951),(3268,1952),(3269,1952),(3270,1952),(3271,1953),(3272,1954),(3273,1955),(3274,1955),(3275,1955),(3276,1956),(3277,1957),(3278,1958),(3279,1958),(3280,1958),(3281,1959),(3282,1960),(3283,1961),(3284,1961),(3285,1961),(3286,1962),(3287,1963),(3288,1964),(3289,1964),(3290,1964),(3291,1965),(3292,1966),(3293,1967),(3294,1967),(3295,1967),(3296,1968),(3297,1968),(3298,1969),(3299,1970),(3300,1971),(3301,1971),(3302,1972),(3303,1973),(3304,1974),(3305,1974),(3306,1975),(3307,1976),(3308,1977),(3309,1977),(3310,1978),(3311,1979),(3312,1980),(3313,1980),(3314,1981),(3315,1982),(3316,1983),(3317,1983),(3318,1984),(3319,1984),(3320,1984),(3321,1985),(3322,1986),(3323,1987),(3324,1987),(3325,1987),(3326,1988),(3327,1989),(3328,1990),(3329,1990),(3330,1990),(3331,1991),(3332,1991),(3333,1992),(3334,1993),(3335,1994),(3336,1994),(3337,1995),(3338,1996),(3339,1997),(3340,1997),(3341,1998),(3342,1998),(3343,1999),(3344,1999),(3345,2000),(3346,2000),(3347,2001),(3348,2001),(3349,2002),(3350,2002),(3351,2003),(3352,2003),(3353,2004),(3354,2004),(3355,2004),(3356,2005),(3357,2006),(3358,2007),(3359,2007),(3360,2007),(3361,2008),(3362,2009),(3363,2010),(3364,2010),(3365,2010),(3366,2011),(3367,2011),(3368,2011),(3369,2012),(3370,2013),(3371,2014),(3372,2014),(3373,2014),(3374,2015),(3375,2016),(3376,2017),(3377,2017),(3378,2017),(3379,2018),(3380,2018),(3381,2019),(3382,2020),(3383,2021),(3384,2021),(3385,2022),(3386,2023),(3387,2024),(3388,2024),(3389,2025),(3390,2025),(3391,2025),(3392,2026),(3393,2027),(3394,2028),(3395,2028),(3396,2028),(3397,2029),(3398,2030),(3399,2031),(3400,2031),(3401,2031),(3402,2032),(3403,2033),(3404,2034),(3405,2034),(3406,2034),(3407,2035),(3408,2036),(3409,2037),(3410,2037),(3411,2037),(3412,2038),(3413,2039),(3414,2040),(3415,2040),(3416,2040);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_media_gallery_value_video`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_media_gallery_value_video`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value_video` (
  `value_id` int unsigned NOT NULL COMMENT 'Media Entity ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `provider` varchar(32) DEFAULT NULL COMMENT 'Video provider ID',
  `url` text COMMENT 'Video URL',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `description` text COMMENT 'Page Meta Description',
  `metadata` text COMMENT 'Video meta data',
  PRIMARY KEY (`value_id`,`store_id`),
  KEY `[[DBPREFIX]]CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` (`store_id`),
  CONSTRAINT `FK_A0FC129B4BF5F257FAA2BEFCD8CD532C` FOREIGN KEY (`value_id`) REFERENCES `[[dbprefix]]catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Video Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_media_gallery_value_video`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_media_gallery_value_video` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value_video` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value_video` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_text`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_text` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` mediumtext COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_TEXT_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_TEXT_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2800 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_text`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_text` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_text` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_text` VALUES (1,75,0,1,'<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.<p>\n<ul>\n<li>Dual top handles.</li>\n<li>Adjustable shoulder strap.</li>\n<li>Full-length zipper.</li>\n<li>L 29\" x W 13\" x H 11\".</li>\n</ul>'),(2,135,0,2,'11,21,23,18'),(3,75,0,2,'<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>\n<ul>\n<li>Zippered main compartment.</li>\n<li>Front zippered pocket.</li>\n<li>Side mesh pocket.</li>\n<li>Cell phone pocket on strap.</li>\n<li>Adjustable shoulder strap and top carry handle.</li>\n</ul>'),(4,139,0,2,'72,74,75,78'),(5,137,0,2,'32,33,36,38'),(6,138,0,2,'61,62,65,66,67'),(7,136,0,2,'27,29,30'),(8,135,0,3,'11,18,19,20,21,22,23'),(9,75,0,3,'<p>The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.</p>\n<ul>\n<li>Top handle.</li>\n<li>Grommet holes.</li>\n<li>Two-way zippers.</li>\n<li>H 20\" x W 14\" x D 12\".</li>\n<li>Weight: 2 lbs, 8 oz. Volume: 29 L.</li>\n<ul>'),(10,139,0,3,'72,74,75,77,78'),(11,137,0,3,'37,38'),(12,138,0,3,'61,64,65'),(13,136,0,3,'24'),(14,135,0,4,'11,19,22'),(15,75,0,4,'<p>Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.</p>\n<ul>\n<li>Multiple internal zip pockets.</li>\n<li>Made of durable nylon.</li>\n</ul>'),(16,139,0,4,'74,75,77,78,79'),(17,137,0,4,'37,38'),(18,138,0,4,'61,63,64,65,66'),(19,136,0,4,'27,28'),(20,135,0,5,'22,23'),(21,75,0,5,'<p>The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.</p>\n<ul>\n<li>Leather construction.</li>\n<li>Adjustable fabric carry strap.</li>\n<li>Dimensions: 18\" x 10\" x 4\".</li>\n</ul>'),(22,139,0,5,'73,75,78'),(23,137,0,5,'35,37,41'),(24,138,0,5,'61,62,66,67'),(25,136,0,5,'27,28,29'),(26,135,0,6,'18,20,8'),(27,75,0,6,'<p>With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.</p>\n<ul>\n<li>Durable nylon construction.</li>\n<li>2 main zippered compartments.</li>\n<li>1 exterior zippered pocket.</li>\n<li>Mesh side pouches.</li>\n<li>Padded, adjustable straps.</li>\n<li>Top carry handle.</li>\n<li>Dimensions: 18\" x 10\" x 6\".</li>\n</ul>'),(28,139,0,6,'71,72,74,75'),(29,137,0,6,'31,37,38'),(30,138,0,6,'61,64,65'),(31,136,0,6,'24,28'),(32,135,0,7,'11,19,22'),(33,75,0,7,'<p>Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.</p>\n<ul>\n<li>Wheeled.</li>\n<li>Dual carry handles.</li>\n<li>Retractable top handle.</li>\n<li>W 14\" x H 26\" x D 11\".</li>\n</ul>'),(34,139,0,7,'70,76,79'),(35,137,0,7,'37,38'),(36,138,0,7,'61,64,68'),(37,136,0,7,'25,26'),(38,135,0,8,'11,8'),(39,75,0,8,'<p>Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.</p>\n<ul>\n<li>Slip pocket on front.</li>\n<li>Contrast piping.</li>\n<li>Durable nylon construction.</li>\n</ul>'),(40,139,0,8,'74,77,79'),(41,137,0,8,'37,38'),(42,138,0,8,'64,66'),(43,136,0,8,'29,30'),(44,135,0,9,'11,20,8'),(45,75,0,9,'<p>The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.<p>\n<ul>\n<li>Two-way zippers.</li>\n<li>Contrast detailing.</li>\n<li>W 22.0\" x H 17\" x D 1