<?php

declare(strict_types=1);

/**
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 *
 * OpenSearch PHP client
 *
 * @link      https://github.com/opensearch-project/opensearch-php/
 * @copyright Copyright (c) Elasticsearch B.V (https://www.elastic.co)
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @license   https://www.gnu.org/licenses/lgpl-2.1.html GNU Lesser General Public License, Version 2.1
 *
 * Licensed to Elasticsearch B.V under one or more agreements.
 * Elasticsearch B.V licenses this file to you under the Apache 2.0 License or
 * the GNU Lesser General Public License, Version 2.1, at your option.
 * See the LICENSE file in the project root for more information.
 */

namespace OpenSearch\Endpoints;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class Search extends AbstractEndpoint
{
    public function getURI(): string
    {
        $index = $this->index ?? null;
        if (isset($index)) {
            return '/' . rawurlencode($index) . '/_search';
        }
        return '/_search';
    }

    public function getParamWhitelist(): array
    {
        return [
            '_source',
            '_source_excludes',
            '_source_includes',
            'allow_no_indices',
            'allow_partial_search_results',
            'analyze_wildcard',
            'analyzer',
            'batched_reduce_size',
            'cancel_after_time_interval',
            'ccs_minimize_roundtrips',
            'default_operator',
            'df',
            'docvalue_fields',
            'expand_wildcards',
            'explain',
            'from',
            'ignore_throttled',
            'ignore_unavailable',
            'include_named_queries_score',
            'lenient',
            'max_concurrent_shard_requests',
            'phase_took',
            'pre_filter_shard_size',
            'preference',
            'q',
            'request_cache',
            'rest_total_hits_as_int',
            'routing',
            'scroll',
            'search_pipeline',
            'search_type',
            'seq_no_primary_term',
            'size',
            'sort',
            'stats',
            'stored_fields',
            'suggest_field',
            'suggest_mode',
            'suggest_size',
            'suggest_text',
            'terminate_after',
            'timeout',
            'track_scores',
            'track_total_hits',
            'typed_keys',
            'verbose_pipeline',
            'version',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return isset($this->body) ? 'POST' : 'GET';
    }

    public function setBody($body): static
    {
        if (is_null($body)) {
            return $this;
        }
        $this->body = $body;

        return $this;
    }
}
