<?php

declare(strict_types=1);

/**
 *  Copyright OpenSearch Contributors
 *   SPDX-License-Identifier: Apache-2.0
 *
 *   The OpenSearch Contributors require contributions made to
 *   this file be licensed under the Apache-2.0 license or a
 *   compatible open source license.
 */

namespace OpenSearch\Endpoints\Ml;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class UpdateModelGroup extends AbstractEndpoint
{
    protected $model_group_id;

    public function getURI(): string
    {
        $model_group_id = $this->model_group_id ?? null;
        if (isset($model_group_id)) {
            return '/_plugins/_ml/model_groups/' . rawurlencode($model_group_id);
        }
        throw new RuntimeException('Missing parameter for the endpoint ml.update_model_group');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'PUT';
    }

    public function setBody($body): static
    {
        if (is_null($body)) {
            return $this;
        }
        $this->body = $body;

        return $this;
    }

    public function setModelGroupId($model_group_id): static
    {
        if (is_null($model_group_id)) {
            return $this;
        }
        $this->model_group_id = $model_group_id;

        return $this;
    }
}
