<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Cluster;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class GetDecommissionAwareness extends AbstractEndpoint
{
    protected $awareness_attribute_name;

    public function getURI(): string
    {
        $awareness_attribute_name = $this->awareness_attribute_name ?? null;
        if (isset($awareness_attribute_name)) {
            return '/_cluster/decommission/awareness/' . rawurlencode($awareness_attribute_name) . '/_status';
        }
        throw new RuntimeException('Missing parameter for the endpoint cluster.get_decommission_awareness');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function setAwarenessAttributeName($awareness_attribute_name): static
    {
        if (is_null($awareness_attribute_name)) {
            return $this;
        }
        $this->awareness_attribute_name = $awareness_attribute_name;

        return $this;
    }
}
