# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from sqlalchemy import Column, String, BigInteger

from lvestats.orm.base import Base
from lvestats.orm.const import LVE_STATS_2_TABLENAME_PREFIX, SERVER_ID_LENGTH


class user(Base):
    __tablename__ = LVE_STATS_2_TABLENAME_PREFIX + 'user'

    uid = Column('uid', BigInteger, index=True, primary_key=True, autoincrement=False)
    server_id = Column('server_id', String(SERVER_ID_LENGTH), index=True, primary_key=True, autoincrement=False)
    # according to `man useradd` Usernames may only be up to 32 characters long.
    user_name = Column('user_name', String(32), primary_key=True, autoincrement=False)
