# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from lvestats.lib import config as lvestats_config, dbengine

__author__ = 'shaman'


class PluginContext(object):
    def __init__(self, config):
        self.config = config
        self.db_engine = dbengine.make_db_engine(config, debug=False)
        self._cache = {}

    def get_instance(self, plugin_class):
        if plugin_class in self._cache:
            return self._cache[plugin_class]

        plugin = plugin_class()
        if hasattr(plugin, 'set_config'):
            plugin_config = lvestats_config.read_plugin_config(self.config, plugin=plugin_class.__name__)
            plugin.set_config(plugin_config)

        if hasattr(plugin, 'set_db_engine') and self.db_engine:
            plugin.set_db_engine(self.db_engine)

        self._cache[plugin_class] = plugin
        return plugin

    def recover_db(self):
        dbengine.recreate_db(self.db_engine)
