# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

__author__ = 'shaman'


class LveStatsPluginTerminated(Exception):
    def __init__(self, *args, **kwargs):
        Exception.__init__(self, *args, **kwargs)


class LveStatsPlugin(object):
    """
    Skeleton of the plugin. User plugins are not required to depend on the code of the project
    and have this class as a parent, but they should have methods set_config(config) and execute(lve_data)

    Additional attributes you may define in the plugin:

        * order : int : order of plugin execution.

        * period : int : time between executions of execute() method. Default period is
        set in config.

       * timeout : float or int : time to wait (in seconds) for plugin execution, until it is marked as
        halted and killed. Default missing or None for system plugins.

    Additional object (instance level) attributes set by system:

        * now: current moment of time (see time.time()) Updated by the system each time execute() is
        invoked.

    Additional class level attributes set by system

        * __is_user_plugin__ : True or False, determines is the current plugin loaded from user folder
    """
    # this value will be replaces with plugins runner
    # before runnin execute(), but new pylint complaints
    # that we might get None where not expect
    # so I just changed it to 0
    now = 0
    engine = None

    def set_config(self, config):
        """
        :type config: dict
        """

    def set_db_engine(self, engine):
        """
        :type engine: sqlalchemy.engine.base.Engine
        """
        self.engine = engine

    def execute(self, lve_data):
        """
        Should be overriden in the implementation.
        :param lve_data: lve_data is shared between instances of plugins, so that modify it
        carefully.
        :type lve_data: dict
        """
