# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

import argparse

ALLOWED_DB_TYPES = ("postgresql", "mysql", "sqlite")


class VAction(argparse.Action):
    def __call__(self, parser, args, values, option_string=None):
        # print 'values: {v!r}'.format(v=values)
        if values is None:
            values = '1'
        try:
            values = int(values)
        except ValueError:
            values = values.count('v') + 1
        setattr(args, self.dest, values)


def run_tests_parser():
    parser = argparse.ArgumentParser(prog="lvestats-run-tests",
                                     add_help=True,
                                     description="LveStats2 tests")

    parser.add_argument("-dt", "--db-type",
                        help=f"type of db, should be one of {ALLOWED_DB_TYPES}",
                        dest="dbtype",
                        default="sqlite",
                        required=True)

    parser.add_argument("-dl", "--db-login",
                        help="database login",
                        dest="login",
                        required=False)

    parser.add_argument("-dp", "--db-password",
                        help="database password",
                        dest="password",
                        required=False)

    parser.add_argument("-dh", "--db-host",
                        help="dtabase host",
                        dest="host",
                        default="localhost")
    parser.add_argument("--db-tests-only",
                        action="store_true",
                        dest="db_only",
                        default=False)
    parser.add_argument("--with-tap",
                        action="store_true",
                        dest="with_tap",
                        default=None)
    parser.add_argument("-dn", "--db-name",
                        help="database name; default in memory for sqlite and temporary for mysql/postgresqll",
                        dest="dbname")
    parser.add_argument("-p", "--pattern",
                        help="running test pattern",
                        dest="pattern",
                        default="test_")

    parser.add_argument("-w", "--with-path",
                        help="add PYTHONPATH",
                        dest="path")
    parser.add_argument("--without-coverage", action='store_false', default=True, dest="coverage")

    verbose_parser = parser.add_mutually_exclusive_group()
    verbose_parser.add_argument('-q', '--quiet', action="store_true",
                                default=False,
                                help='quiet operation')
    verbose_parser.add_argument('-v', nargs='?', action=VAction, default=0,
                                dest='verbose',
                                help='verbose operation; for example -v or -vv')
    return parser
