# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

import argparse


def lve_create_db_parser():
    parser = argparse.ArgumentParser(
        prog='lve_create_db',
        add_help=True,
        description='Creates a database for lve-stats',
        formatter_class=argparse.ArgumentDefaultsHelpFormatter)

    parser.add_argument(
        '--recreate',
        help='Drops and recreates database even if tables exists',
        action='store_true',
        default=False)
    parser.add_argument(
        '--create-missing-tables',
        help='Create missing tables',
        action='store_true',
        default=False)
    parser.add_argument(
        '--print-sql',
        help='Prints sql and exits, without creating db',
        action='store_true',
        default=False)
    parser.add_argument(
        '--update-serverid-prompt',
        help='Update exist server ID or create new one',
        action='store_true',
        default=False)
    parser.add_argument(
        '--update-serverid-auto',
        help='Update exist server ID with uuid',
        action='store_true',
        default=False)
    parser.add_argument(
        '--validate',
        help='Check the correctness of the database structure',
        action='store_true',
        default=False
    )
    parser.add_argument(
        '--fix',
        help='Try fix errors in database',
        action='store_true',
        default=False
    )

    return parser
