# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT


class LVEList(list):
    def __init__(self, stat, resellers=False):
        """
        :type stat: CloudLinuxStatistics
        :type resellers: bool
        """
        list.__init__([])
        self.stat = stat
        self.resellers = resellers

    def __eq__(self, other):
        """:type other: LVEList | list"""
        return (
            (
                isinstance(other, LVEList)
                and self.stat == other.stat)
            or (
                isinstance(other, list)
                and list(self) == other))

    def __ne__(self, other):
        """:type other: LVEList | list"""
        return not self.__eq__(other)

    def __len__(self):
        if self.resellers:
            return len(self.stat._resellers_results)
        else:
            return max(len(self.stat._lve_results), len(self.stat._gov_results))

    def __reversed__(self):
        """ L.__reversed__() -- return a reverse iterator over the list """
        raise TypeError

    def append(self, p_object):
        """ L.append(object) -- append object to end """
        raise TypeError

    def count(self, value):
        """ L.count(value) -> integer -- return number of occurrences of value """
        raise TypeError

    def extend(self, iterable):
        """ L.extend(iterable) -- extend list by appending elements from the iterable """
        raise TypeError

    def index(self, value, start=None, stop=None):
        """
        L.index(value, [start, [stop]]) -> integer -- return first index of value.
        Raises ValueError if the value is not present.
        """
        raise TypeError

    def insert(self, index, p_object):
        """ L.insert(index, object) -- insert object before index """
        raise TypeError

    def pop(self, index=None):
        """
        L.pop([index]) -> item -- remove and return item at index (default last).
        Raises IndexError if list is empty or index is out of range.
        """
        raise TypeError

    def remove(self, value):
        """
        L.remove(value) -- remove first occurrence of value.
        Raises ValueError if the value is not present.
        """
        raise TypeError

    def reverse(self):
        """ L.reverse() -- reverse *IN PLACE* """
        raise TypeError

    def sort(self, cmp=None, key=None, reverse=False):
        """
        L.sort(cmp=None, key=None, reverse=False) -- stable sort *IN PLACE*;
        cmp(x, y) -> -1, 0, 1
        """
        raise TypeError

    def __add__(self, y):
        """ x.__add__(y) <==> x+y """
        raise TypeError

    def __contains__(self, y):
        """ x.__contains__(y) <==> y in x """
        raise TypeError

    def __delitem__(self, y):
        """ x.__delitem__(y) <==> del x[y] """
        raise TypeError

    def __iter__(self):
        current_index = 0
        while True:
            try:
                yield self.stat.get_value(current_index, self.resellers)
            except IndexError:
                return
            current_index += 1

    def __getitem__(self, index):
        if isinstance(index, slice):
            raise TypeError
        return self.stat.get_value(index, self.resellers)

    def __repr__(self):
        return str(list(self))
