# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

__author__ = 'shaman'


def default_plugins():
    # NOTE(vlebedev): Do not trigger import of plugins on import as it becomes harder to run unittests
    #                 due to vastly different plugins requirements, which are quite hard to fullfill locally.
    # pylint: disable=import-outside-toplevel
    from lvestats.plugins.generic.analyzers import LVEUsageAnalyzer
    from lvestats.plugins.generic.collectors import LVECollector, CPUInfoCollector, LVEUsernamesCollector
    from lvestats.plugins.generic.burster import LveLimitsBurster
    from lvestats.plugins.generic.dbgov_saver import DBGovSaver
    from lvestats.plugins.generic.dbsaver import DBSaver, DbUsernamesSaver
    from lvestats.plugins.generic.persistors import FileSaver, CloudLinuxTopFileSaver, MySQLTopFileSaver
    from lvestats.plugins.generic.snapshot_saver import SnapshotSaver
    from lvestats.plugins.generic.statsnotifier import StatsNotifier
    from lvestats.plugins.generic.aggregators import LveUsageAggregator, LveUsageAggregator5S
    from lvestats.plugins.generic.cleaners import HistoryCleaner
    from lvestats.plugins.generic.dbsaver_x60 import DBSaverX60
    from lvestats.plugins.generic.lvestats_memory_usage import LVEStatsMemoryUsage
    from lvestats.plugins.generic.cm_collector import CMCollector
    # pylint: enable=import-outside-toplevel

    return [
        # plugin_class, plugin_order
        (LVECollector, 1000),
        (CPUInfoCollector, 2000),
        (LVEUsageAnalyzer, 3000),
        (LveUsageAggregator5S, 4000),
        (LveUsageAggregator, 5000),
        (SnapshotSaver, 6000),
        (FileSaver, 7000),
        (DBGovSaver, 8000),
        (CloudLinuxTopFileSaver, 9000),
        (MySQLTopFileSaver, 9500),
        (DBSaver, 10000),
        (LVEUsernamesCollector, 11000),
        (LveLimitsBurster, 11400),
        (CMCollector, 11500),
        (DbUsernamesSaver, 12000),
        (StatsNotifier, 13000),
        (HistoryCleaner, 14000),
        (DBSaverX60, 15000),
        (LVEStatsMemoryUsage, 16000),
    ]
