# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from sqlalchemy import Column, Integer, String, BigInteger

from lvestats.orm.base import Base
from lvestats.orm.const import LVE_STATS_2_TABLENAME_PREFIX, SERVER_ID_LENGTH


class incident(Base):
    __tablename__ = LVE_STATS_2_TABLENAME_PREFIX + 'incident'
    uid = Column('uid', BigInteger, index=True, primary_key=True, autoincrement=False)
    server_id = Column('server_id', String(SERVER_ID_LENGTH), index=True, primary_key=True)
    # unix time used as id, rounded to seconds
    incident_start_time = Column('incident_start_time', Integer, index=True, primary_key=True,
                                 autoincrement=False)
    incident_end_time = Column('incident_end_time', Integer, index=True)
    dump_time = Column('dump_time', Integer)
    snapshot_count = Column('snapshot_count', Integer)
