# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from sqlalchemy import (
    Column,
    Integer,
    Float,
    String,
    PrimaryKeyConstraint,
    BigInteger,
)
from lvestats.orm.base import Base
from lvestats.orm.const import LVE_STATS_2_TABLENAME_PREFIX, SERVER_ID_LENGTH


class _history(object):
    """
    Common base class for history table and history_serives view.
    """
    id = Column('id', BigInteger, autoincrement=False)
    cpu = Column('cpu', Integer)
    cpu_limit = Column('cpu_limit', Integer)
    cpu_fault = Column('cpu_fault', Integer)
    mep = Column('mep', Integer)
    mep_limit = Column('mep_limit', Integer)
    io = Column('io', Integer)
    io_limit = Column('io_limit', Integer)
    io_fault = Column('io_fault', Integer)
    mem = Column('mem', Integer)
    mem_limit = Column('mem_limit', Integer)
    mem_fault = Column('mem_fault', Integer)
    mep_fault = Column('mep_fault', Integer)
    created = Column('created', Integer, index=True, autoincrement=False)
    server_id = Column('server_id', String(SERVER_ID_LENGTH), autoincrement=False)
    lmemphy = Column('lmemphy', Integer)
    memphy = Column('memphy', Integer)
    memphy_fault = Column('memphy_fault', Integer)
    lnproc = Column('lnproc', Integer)
    nproc = Column('nproc', Integer)
    nproc_fault = Column('nproc_fault', Integer)
    liops = Column('liops', Integer)
    iops = Column('iops', Integer)
    iops_fault = Column('iops_fault', Integer)


class history(Base, _history):
    __tablename__ = LVE_STATS_2_TABLENAME_PREFIX + 'history'
    __table_args__ = (PrimaryKeyConstraint("server_id", "created", "id"),)


class _history_aggregated(object):
    """
    Common base class for aggregated history table and history_serives view.
    """
    id = Column('id', BigInteger, autoincrement=False)
    time = Column('time', Integer)
    cpu = Column('cpu', Float)
    cpu_limit = Column('cpu_limit', Integer)
    cpu_fault = Column('cpu_fault', Integer)
    mep = Column('mep', Integer)
    mep_limit = Column('mep_limit', Integer)
    io = Column('io', Float)
    io_limit = Column('io_limit', Integer)
    io_fault = Column('io_fault', Integer)
    mem = Column('mem', Float)
    mem_limit = Column('mem_limit', Integer)
    mem_fault = Column('mem_fault', Integer)
    mep_fault = Column('mep_fault', Integer)
    created = Column('created', Integer, index=True, autoincrement=False)
    server_id = Column('server_id', String(SERVER_ID_LENGTH), autoincrement=False)
    lmemphy = Column('lmemphy', Integer)
    memphy = Column('memphy', Float)
    memphy_fault = Column('memphy_fault', Integer)
    lnproc = Column('lnproc', Integer)
    nproc = Column('nproc', Integer)
    nproc_fault = Column('nproc_fault', Integer)
    liops = Column('liops', Integer)
    iops = Column('iops', Integer)
    iops_fault = Column('iops_fault', Integer)


class history_x60(Base, _history_aggregated):
    __tablename__ = LVE_STATS_2_TABLENAME_PREFIX + 'history_x60'
    __table_args__ = (PrimaryKeyConstraint("server_id", "created", "id"),)
