# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from sqlalchemy.ext.compiler import compiles
from sqlalchemy.sql import expression
from sqlalchemy.types import Numeric


class greatest(expression.FunctionElement):
    type = Numeric()
    name = "greatest"


class least(expression.FunctionElement):
    type = Numeric()
    name = "least"


@compiles(greatest)
def default_greatest(element, compiler, **kw):
    return compiler.visit_function(element)


@compiles(least)
def default_least(element, compiler, **kw):
    return compiler.visit_function(element)


@compiles(greatest, "sqlite")
def case_greatest(element, compiler, **kw):
    arg1, arg2 = list(element.clauses)
    return f"max({compiler.process(arg1)}, {compiler.process(arg2)})"


@compiles(least, "sqlite")
def case_least(element, compiler, **kw):
    arg1, arg2 = list(element.clauses)
    return f"min({compiler.process(arg1)}, {compiler.process(arg2)})"


class div(expression.FunctionElement):
    type = Numeric
    name = "div"


@compiles(div)
def default_div(element, compiler, **kw):
    arg1, arg2 = list(element.clauses)
    return f"{compiler.process(arg1)} / {compiler.process(arg2)}"


@compiles(div, "mysql")
def case_div(element, compiler, **kw):
    arg1, arg2 = list(element.clauses)
    return f"{compiler.process(arg1)} div {compiler.process(arg2)}"
