# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

import sys
import time


class ProgressCallback(object):
    """
    Class to display the progress in the console
    """

    def __init__(self, time_change_step=0.5):
        self.time_change_step = time_change_step
        self.ts_start = time.time()
        self.ts_change_screen = 0

    def start(self):
        self.ts_start = time.time()

    @staticmethod
    def stop():
        print('')

    def change_screen(self, percentage):
        sys.stdout.write(
            f'\rProgress: {percentage:.2f}%; work time: {int(time.time() - self.ts_start)}s'
        )
        sys.stdout.flush()
        self.ts_change_screen = time.time()

    def __call__(self, percentage, force=False):
        if force or (time.time() - self.ts_change_screen >= self.time_change_step):
            self.change_screen(percentage)
