# coding:utf-8

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2020 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from __future__ import absolute_import
import json
import sys
import subprocess


def exit_with_error(error_string='', context=None,
                    code=None, error_id=None, icon=None, ignore_errors=False):
    result = {"result": error_string}
    if context:
        result['context'] = context
    if code:
        result['code'] = code
    if error_id:
        result['error_id'] = error_id
    if icon:
        result['icon'] = icon
    if ignore_errors:
        result['ignore'] = ignore_errors
    print(json.dumps(result))
    sys.exit(1)


def run_command(cmd, env_data=None, return_full_output=False):
    cmd_line = ' '.join(cmd)
    try:
        if return_full_output:
            std_err_obj = subprocess.PIPE
        else:
            std_err_obj = subprocess.STDOUT
        output = subprocess.Popen(
            cmd,
            stdin=subprocess.PIPE,
            stdout=subprocess.PIPE,
            stderr=std_err_obj,
            close_fds=True,
            text=True,
            env=env_data)
    except OSError as oserr:
        exit_with_error('%s. Can not run command: %s' % (cmd_line, str(oserr)))
    std_out, std_err = output.communicate()
    if return_full_output:
        return output.returncode, std_out, std_err
    if output.returncode != 0:
        exit_with_error(std_err or 'output of the command: %s\n%s' % (cmd_line, std_out))
    return std_out
