#!/usr/bin/python
# coding=utf-8
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from clcommon.cpapi import panel_hooks_lib
from clcommon.public_hooks.lib import ModifyUserHook
from clcommon.lib.cledition import lve_supported_or_exit


class SyncMapHook(ModifyUserHook):
    """
    Synchronize kernel lve<=>lvp mapping
    with control panel.
    """

    @lve_supported_or_exit
    def post_create_user(self, username, owner, **kwargs):
        panel_hooks_lib.call_sync_map()

    @lve_supported_or_exit
    def post_delete_user(self, username, **kwargs):
        panel_hooks_lib.call_sync_map()

    @lve_supported_or_exit
    def post_modify_user(self, username, new_name=None, new_owner=None, **kwargs):
        if new_owner is not None:
            self._post_transit_user(username or new_name, new_owner)

    def _post_transit_user(self, username, new_owner, **kwargs):
        panel_hooks_lib.call_sync_map()
