#!/opt/cloudlinux/venv/bin/python3 -bb
# coding=utf-8
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

import subprocess
import os.path

from clcommon.public_hooks.lib import ModifyUserHook
from clcommon.lib.cledition import lve_supported_or_exit


class SyncPackageLimitsHook(ModifyUserHook):
    """
    Sync user package limits on creation
    """
    PKGCTL = '/usr/share/lve/dbgovernor/governor_package_limitting.py'

    @lve_supported_or_exit
    def post_create_user(self, username, owner, **kwargs):
        if os.path.exists(self.PKGCTL):
            subprocess.run([self.PKGCTL, 'sync', '--user=' + username], shell=False, check=False)
