# coding=utf-8

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from clsentry import init_sentry_client

from lve_utils import PKG_VERSION

# test sentry with this project https://sentry.cloudlinux.com/sentry/userland_tests
# LVE_UTILS_DSN = 'https://47c4ef4aa3e04274be8f49fd7fc71260:63928a329958442ca5ef9b51fb1a88c8@sentry.cloudlinux.com/28'
# prod https://cl.sentry.cloudlinux.com/settings/cloudlinux_os/projects/userland/
LVE_UTILS_DSN = 'https://9713d1296f804031b058b8f2d789d7ac:8ddacae32d8246cf8b25cf826bf3fc0a@cl.sentry.cloudlinux.com/12'
__all__ = ('init_lve_utils_sentry_client', )


def init_lve_utils_sentry_client(project, dsn=LVE_UTILS_DSN):
    """Create sentry client and install logging hooks"""
    return init_sentry_client(project, release=PKG_VERSION, dsn=dsn)
