<?php

$stats = new STATS;
$stats->parse_all();

function getSelectOptions($selType, $selValue)
{
	if ($selType == 'REFRESH')
	{
		$options = ['0'=>'Stop',
			'10'=>'10 Seconds','15'=>'15 Seconds',
			'30'=>'30 Seconds','60'=>'60 Seconds',
			'120' => '2 Minutes', '300' => '5 Minutes'];
	}
	else if ($selType == 'SHOW_TOP')
	{
		$options = ['5'=>'Top 5',
			'10'=>'Top 10', '20'=>'Top 20',
			'50'=>'Top 50', '0'=>'All'];
	}
	else if ($selType == 'VH_SHOW_SORTBY')
	{
		$options = [
			'vhname'=>'Virtual Host Name',
			'req_processing'=>'Requests in Processing',
			'req_per_sec'=>'Request/Second',
			'eap_process'=>'ExtApp Processes',
			'eap_inuse'=>'EAProc In Use',
			'eap_idle'=>'EAProc Idle',
			'eap_waitQ'=>'EAProc WaitQ',
			'eap_req_per_sec'=>'EAProc Req/Sec'];
	}
	else if ($selType == 'EAP_SHOW_SORTBY')
	{
		$options = [
			'vhost'=>'Scope',
			'type'=>'Type',
			'extapp'=>'Name',
			'config_max_conn'=>'Max CONN',
			'effect_max_conn'=>'Eff Max',
			'pool_size'=>'Pool',
			'inuse_conn'=>'In Use',
			'idle_conn'=>'Idle',
			'waitqueue_depth'=>'WaitQ',
			'req_per_sec'=>'Req/Sec'];
	}

	return DUtil::genOptions($options, $selValue);
}

function td_number($label, $number, $suffix = '', $decimals = 0, $col = 1)
{
	$colspan = ($col == 1) ? '' : "colspan=\"$col\" ";
	return sprintf('<td class="xtbl_value">%s</td><td %sclass="xtbl_value">%s%s</td>',
			$label, $colspan, number_format($number, $decimals), $suffix);
}

function td_num2($number, $decimals = 0)
{
	return '<td align="center">' . number_format($number, $decimals) . '</td>';
}

function td_num3($hits, $hits_per_sec)
{
	return '<td align="center">' . number_format($hits) . ' | ' . number_format($hits_per_sec, 1) . '</td>';
}

function td_val($value)
{
	return '<td class="xtbl_value">'. $value . '</td>';
}

function td_label($label, $width = 0, $help_key = '') 
{
    if ($help_key) {
        $dhelp_item = DATTR_HELP::GetInstance()->GetItem($help_key);
        $help = '&nbsp;&nbsp;&nbsp;&nbsp' . $dhelp_item->render($help_key);
    } else {
        $help = '';
    }

    return '<td ' . ($width ? "width=\"$width\" " : '') . 'class="xtbl_label_vert">' . $label . $help . '</td>';
}

function input_val($name)
{
	return DUtil::getGoodVal(DUtil::grab_input('REQUEST', $name));
}

function graph_icon($gtype, $vhost='', $extapp='')
{
	$param = ['gtype' => $gtype];
	if ($vhost) {
		$param['vhost'] = $vhost;
	}
	if ($extapp) {
		$param['extapp'] = $extapp;
	}
	$url = 'graph_html.php?' . http_build_query($param);
	$window_name = md5($url);
	return '<img src="/static/images/icons/graph.gif" border=0 onclick="window.open(\'' . $url . "','$window_name');\">";
}

$etr = "</tr>\n";
$refresh = input_val('refresh');
$vh_show_ind = input_val('vh_show_ind');
$vh_show_top = input_val('vh_show_top');
$vh_show_filter = input_val('vh_show_filter');
$vh_show_sort = input_val('vh_show_sort');
$eap_show_ind = input_val('eap_show_ind');
$eap_show_top = input_val('eap_show_top');
$eap_show_filter = input_val('eap_show_filter');
$eap_show_sort = input_val('eap_show_sort');
$cur_time = gmdate("D M j H:i:s T");
$server_info = "server {$service->serv['name']} snapshot at $cur_time";

// setting defaults
if ($vh_show_ind == '') {
	$vh_show_ind = 'Show';
}

if ($vh_show_top === '') {
	$vh_show_top = '5';
}

if ($vh_show_sort == '') {
	$vh_show_sort = 'req_per_sec';
}

if ($eap_show_ind == '') {
	$eap_show_ind = 'Show';
}

if ($eap_show_top === '') {
	$eap_show_top = '5';
}

if ($eap_show_sort == '') {
	$eap_show_sort = 'req_per_sec';
}

if ($refresh > 0 && $refresh < 10) {
	$refresh = 10;
}

if($refresh >= 10) {
	echo '<META http-equiv="Refresh" content=' . $refresh . '>';
}


?>
<form name="rpt" method="get"><input type="hidden" name="vl" value="2">
<input type="hidden" name="vh_show_ind" value="<?php echo $vh_show_ind;?>">
<input type="hidden" name="eap_show_ind" value="<?php echo $eap_show_ind;?>">

<div class="bottom_bar">
<span  class="h2_font">Real-Time Statistics</span>&nbsp;&nbsp;&nbsp; <?php echo $server_info;?>
<span style="float:right">Refresh Interval:
	<select onChange='document.rpt.submit();' name="refresh"  class="th-clr">
	<?php
		echo( getSelectOptions('REFRESH', $refresh) );
	?>
	</select></span>
</div>
<div style="margin-top:20px;">
	<div style="width:350px;display:inline-block;vertical-align:top;margin-right:20px;">
	<table class="xtbl" width="100%" border="0" cellpadding="3"	cellspacing="1">
			<tr>
				<td class="xtbl_title" colspan="2">Server Health</td>
			</tr>
			<?php
			$buf = '<tr>' . td_label('Uptime', 120) . td_val(ucwords($stats->uptime)) . $etr;
			$buf .= '<tr>' . td_label('Load', 120) . td_val($stats->load_avg) . $etr;
			$blocked_count = count($stats->blocked_ip);
			$blocked_sample = 'NONE';
			if ($blocked_count > 14) {
				$blocked_sample = join(', ', array_slice($stats->blocked_ip, 0, 14) );
				$blocked_sample .= '<br> ... <br>Total ' . $blocked_count . ' blocked &nbsp;&nbsp;&nbsp;<a target=_new href="blockip_html.php">Show All</a>';
			}
			else if ($blocked_count > 0) {
				$blocked_sample = join(', ', $stats->blocked_ip);
			}

			$buf .= '<tr>'. td_label('Anti-DDoS Blocked IP', 120, 'antiddos_blocked_ip') . td_val($blocked_sample) . $etr;
			echo $buf;
			?>
		</table></div>
		<div style="width:560px;display:inline-block;">
		<table class="xtbl" width="100%" border="0" cellpadding="3"	cellspacing="1">
			<?php
			$buf = '<tr><td class="xtbl_title" colspan="5">Server ' . graph_icon('Server') . "</td>$etr";
			$buf .= '<tr>' . td_label('Network Throughput')
					. td_number('Http In', $stats->bps_in, 'KB')
					. td_number('Http Out', $stats->bps_out, 'KB')
					. $etr;
			$buf .= '<tr>' . td_val('')
					. td_number('Https In', $stats->ssl_bps_in, 'KB')
					. td_number('Https Out', $stats->ssl_bps_out, 'KB')
					. $etr;
			$buf .= '<tr>' . td_label('Connections')
					. td_number('Max', $stats->max_conn)
					. td_number('Idle', $stats->idle_conn)
					. $etr;
			$buf .= '<tr>' . td_val('')
					. td_number('Http Used', $stats->plain_conn)
					. td_number('Http Free', $stats->avail_conn)
					. $etr;
			$buf .= '<tr>' . td_val('')
					. td_number('Https Used', $stats->ssl_conn)
					. td_number('Https Free', $stats->avail_ssl_conn)
					. $etr;
			$buf .= '<tr>' . td_label('Requests &nbsp;&nbsp;<a target=_newreq href="serviceMgr.php?vl=4">(Details)</a>')
					. td_number('In Processing', $stats->serv->req_processing)
					. td_number('Req/Sec', $stats->serv->req_per_sec, '', 1)
					. $etr;
			$buf .= '<tr>' . td_val('')
					. td_number('Total Req', $stats->serv->req_total, '', 0, 3)
					. $etr;
			$buf .= '<tr>' . td_val('')
					. td_number('Total Static Hits', $stats->serv->total_static_hits)
					. td_number('Static Hits/Sec', $stats->serv->static_hits_per_sec, '', 1)
					. $etr;
			$buf .= '<tr>' . td_val('')
					. td_number('Total Public Cache Hits', $stats->serv->total_cache_hits)
					. td_number('Public Cache Hits/Sec', $stats->serv->cache_hits_per_sec, '', 1)
					. $etr;
			$buf .= '<tr>' . td_val('')
					. td_number('Total Private Cache Hits', $stats->serv->total_private_cache_hits)
					. td_number('Private Cache Hits/Sec', $stats->serv->private_cache_hits_per_sec, '', 1)
					. $etr;

			echo $buf;

			?>
		</table></div>
</div>
<div>
<table class="xtbl" width="100%" border="0" cellpadding="3"
	cellspacing="1">
	<tr class="xtbl_title">
		<td colspan="12">
		<table width="100%" border="0" cellpadding="3">
			<tr>
				<td>Virtual Host</td>
				<td>
<?php
				if ($vh_show_ind == 'Show') {
					$buf = '<button name="vh_show" type="button" onclick="document.rpt.vh_show_ind.value=\'Hide\';document.rpt.submit();">Hide</button>';
				} else {
					$buf = '<button name="vh_show" type="button" onclick="document.rpt.vh_show_ind.value=\'Show\';document.rpt.submit();">Show</button>';
				}

				$buf .= '</td><td>Display: <select class="th-clr" name="vh_show_top">'
						. getSelectOptions('SHOW_TOP', $vh_show_top)
						. '</select></td>' . "\n";
				$buf .= '<td>Filter by Name (take regExp): <input type="text" name="vh_show_filter" value="'
						. $vh_show_filter . '"></td>' . "\n";
				$buf .= '<td>Sort by: <select class="th-clr" name="vh_show_sort">'
						. getSelectOptions('VH_SHOW_SORTBY', $vh_show_sort)
						. '</select></td>' . "\n";
				$buf .= '<td><input name="vh_show_apply" value="Apply" type="submit">';
				echo $buf;
?>
				</td>
			</tr>
		</table>
		</td>
	</tr>

<?php
	if ($vh_show_ind == 'Show') {

		$buf = '<tr class="xtbl_label_vert">'
				. '<td>VH Name</td><td>&nbsp;</td>'
				. '<td>Req in Processing</td><td>Req/Sec</td><td>Total Static Hits | Hits/Sec</td>'
				. '<td>Public Cache Hits | Hits/Sec</td><td>Private Cache Hits | Hits/Sec</td>'
				. '<td>ExtApp Processes</td><td>EAProc In Use</td><td>EAProc Idle</td>'
				. '<td>EAProc WaitQ</td><td>EAProc Req/Sec</td></tr>'
				. "\n";

		$vhlist = $stats->apply_vh_filter($vh_show_top, $vh_show_filter, $vh_show_sort);

		foreach ($vhlist as $vhname) {
			if ($vhname == '_Server')
				continue;
			$vh = $stats->vhosts[$vhname];
			$buf .= '<tr class="xtbl_value"><td>' . $vhname . '</td>';
			$buf .= '<td>' . graph_icon('VH', $vhname) . '</td>';

			$buf .= td_num2($vh->req_processing)
					. td_num2($vh->req_per_sec, 1)
					. td_num3($vh->total_static_hits, $vh->static_hits_per_sec)
					. td_num3($vh->total_cache_hits, $vh->cache_hits_per_sec)
					. td_num3($vh->total_private_cache_hits, $vh->private_cache_hits_per_sec)
					. td_num2($vh->eap_process)
					. td_num2($vh->eap_inuse)
					. td_num2($vh->eap_idle)
					. td_num2($vh->eap_waitQ)
					. td_num2($vh->eap_req_per_sec, 1)
					. $etr;
		}
		echo $buf;
	}
?>
</table>
</div>
<div>
<table class="xtbl" width="100%" border="0" cellpadding="3"	cellspacing="1">
<?php
$buf = '<tr class="xtbl_title"><td colspan="10">'
		. '<table width="100%" border="0" cellpadding="3">'
		. '<tr><td>External Application</td><td>';
if ($eap_show_ind == 'Show') {
	$buf .= '<button name="eap_show" type="button" onclick="document.rpt.eap_show_ind.value=\'Hide\';document.rpt.submit();">Hide</button>';
} else {
	$buf .= '<button name="eap_show" type="button" onclick="document.rpt.eap_show_ind.value=\'Show\';document.rpt.submit();">Show</button>';
}

$buf .= '</td><td>Display: <select class="th-clr" name="eap_show_top">' . getSelectOptions('SHOW_TOP', $eap_show_top) . '</select></td>' . "\n";
$buf .= '<td>Filter by Name (take regExp): <input type="text" name="eap_show_filter" value="' . $eap_show_filter . '"></td>' . "\n";
$buf .= '<td>Sort by: <select class="th-clr" name="eap_show_sort">' . getSelectOptions('EAP_SHOW_SORTBY', $eap_show_sort) . '</select></td>' . "\n";
$buf .= '<td><input name="eap_show_apply" value="Apply" type="submit"></td>'
		. '</tr></table></td></tr>' . "\n";

if ($eap_show_ind == 'Show') {

	$buf .= '<tr class="xtbl_label_vert">'
			. '<td>Scope</td><td>Type</td><td>Name</td><td>&nbsp;</td>'
			. '<td>Max Conn</td><td>Eff Max</td><td>Pool</td>'
			. '<td>In Use</td><td>Idle</td><td>WaitQ</td><td>Req/Sec</td>'
			. $etr;
	$exapps = $stats->apply_eap_filter($eap_show_top, $eap_show_filter, $eap_show_sort);

	foreach ($exapps as $eap) {
		$buf .= '<tr class="xtbl_value"><td>' . $eap->vhost . '</td>';
		$buf .= '<td align="center">' . $eap->type . '</td>';
		$buf .= '<td align="center">' . $eap->extapp . '</td>';
		$buf .= '<td width=1>' . graph_icon('EXTAPP', $eap->vhost, $eap->extapp) . '</td>';
		$buf .= td_num2($eap->config_max_conn)
				. td_num2($eap->effect_max_conn)
				. td_num2($eap->pool_size)
				. td_num2($eap->inuse_conn)
				. td_num2($eap->idle_conn)
				. td_num2($eap->waitqueue_depth)
				. td_num2($eap->req_per_sec, 1)
				. $etr;
	}
}
echo $buf;
?>
</table>
</div>

</form>

