<?php 
$this->db['AIOBlockSize'] = new DATTR_HELP_ITEM("AIO Block Size", 'Specifies the sent block size for AIO. This block size multiplied by the total files being processed should be less than the physical memory of the server, otherwise, AIO will not help. If your server has enough memory, you can choose a bigger size. Default value is &quot;1M&quot;.', '', 'Select from drop down list', '');
$this->db['CACertFile'] = new DATTR_HELP_ITEM("CA Certificate File", 'Specifies the file that contains all certificates of certification authorities (CAs) for chained certificates. This file is simply the concatenation of PEM-encoded certificate files, in order of preference. This can be used as an alternative or in addition to &quot;CA Certificate Path&quot;. Those certificates are used for client certificate authentication and constructing the server certificate chain, which will be sent to browsers in addition to the server certificate.', '', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');
$this->db['CACertPath'] = new DATTR_HELP_ITEM("CA Certificate Path", 'Specifies the directory where the certificates of certification authorities (CAs) are kept. Those certificates are used for client certificate authentication and constructing the server certificate chain, which will be sent to browsers in addition to the server certificate.', '', 'path', '');
$this->db['CGIPriority'] = new DATTR_HELP_ITEM("CGI Priority", 'Specifies priority of the external application process. Value ranges from -20 to 20. A lower number means a higher priority.<br/><br/>A CGI process cannot have a higher priority than the web server. If this priority is set to a lower number than the server&#039;s, the server&#039;s priority will be used for this value.', '', 'int', '');
$this->db['CPUHardLimit'] = new DATTR_HELP_ITEM("CPU Hard Limit", 'Specifies maximum CPU consumption time limit in seconds for a CGI process. If the process continues to consume CPU time and reach the hard limit, the process will be force killed. The operating system&#039;s default setting will be used if the value is absent or set to 0.', '', 'Integer number', '');
$this->db['CPUSoftLimit'] = new DATTR_HELP_ITEM("CPU Soft Limit (sec)", 'Specifies CPU consumption time limit in seconds for a CGI process. When the process reaches the soft limit, it will be notified by a signal. The operating system&#039;s default setting will be used if the value is absent or set to 0.', '', 'Integer number', '');
$this->db['DHParam'] = new DATTR_HELP_ITEM("DH Parameter", 'Specifies the location of the Diffie-Hellman parameter file necessary for DH key exchange.', '', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');
$this->db['GroupDBLocation'] = new DATTR_HELP_ITEM("Group DB Location", 'Specifies the location of the group database.<br/><br/>Group information can be set either in the user database or in this standalone group DB. For user authentication, the user DB will be checked first. If the user DB also contains group information, then the group DB will not be checked.<br/><br/>For the DB type Password File, the group DB location should be the path to the flat file containing group definitions. You can edit this file through the WebAdmin console by clicking on the filename.<br/><br/>Each line of a group file should contain a groupname followed by a colon, followed by space delimited group of usernames. Example:<br/><blockquote><code>testgroup: user1 user2 user3</code></blockquote><br/><br/>For the DB type LDAP, the group DB location should be the LDAP URL to query for group information. For each valid group, one and only one record should be returned in the LDAP search request based on this URL and the group name specified in &quot;Require (Authorized Users/Groups)&quot;. &quot;$k&quot; must be specified in the filter part of the URL and it will be replaced with the group name. The name of the attribute that specifies members in this group is specified by the &quot;Group Member Attribute&quot;.<br/><br/>Example: If objectClass posixGroup is being used to store group information. The following URL could be used:<br/><blockquote><code>ldap://localhost/ou=GroupDB,dc=example,dc=com???(&(objectClass=*)(cn=$k))</code></blockquote>', ' It is recommended to store a group file outside the document tree. If it has to be placed inside document tree, simply name it with a leading &quot;.ht&quot; like .htgroup, to prevent the file being served as a static file. LiteSpeed Web Server does not serve files prefixed with &quot;.ht&quot;.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT, $VH_ROOT.', '');
$this->db['LDAPBindDN'] = new DATTR_HELP_ITEM("LDAP Bind DN", 'Specifies a DN used to bind to the server. If the LDAP server requires authentication, a bind DN and password must be specified. If not specified, anonymous bind will be used.', '', 'string', '');
$this->db['LDAPBindPasswd'] = new DATTR_HELP_ITEM("LDAP Bind Password", 'Specifies a password used to bind to the server. If the LDAP Server requires authentication, a bind DN and password must be specified.', '', 'string', '');
$this->db['UDBgroup'] = new DATTR_HELP_ITEM("Groups", 'A comma seperated list of groups that this user belongs to. The user will only be able to access resources belonging to these groups.<br/><br/>If group information is added here, this information will be used for resource authorization and any group database settings involving this user will be ignored.', '', '', '');
$this->db['UDBpass'] = new DATTR_HELP_ITEM("New Password", 'Password can be any length and contain any characters.', '', '', '');
$this->db['UDBpass1'] = new DATTR_HELP_ITEM("Retype Password", 'Password can be any length and contain any characters.', '', '', '');
$this->db['UDBusername'] = new DATTR_HELP_ITEM("User Name", 'A user name containing only letters and numbers. (no special characters)', '', '', '');
$this->db['VHlsrecaptcha'] = new DATTR_HELP_ITEM("reCAPTCHA Protection", 'reCAPTCHA Protection is a service provided as a way to mitigate heavy server load. reCAPTCHA Protection will activate after one of the below situations is hit. Once active, all requests by NON TRUSTED(as configured) clients will be redirected to a reCAPTCHA validation page. After validation, the client will be redirected to their desired page.<br/><br/>The following situations will activate reCAPTCHA Protection:<br/>1. The server or vhost concurrent requests count passes the configured connection limit.<br/>2. Anti-DDoS is enabled and a client is hitting a url in a suspicious manner. The client will redirect to reCAPTCHA first instead of getting denied when triggered.<br/>3. WordPress Brute Force Attack Protection is enabled and action is set to &#039;CAPTCHA or Drop’. When a brute force attack is detected, the client will redirect to reCAPTCHA first. After max tries is reached, the connection will be dropped, as per the ‘drop’ option.<br/>4. WordPress Brute Force Attack Protection is enabled and action is set to &#039;WP Login CAPTCHA Full Protection&#039;. The client will always redirect to reCAPTCHA first.<br/>5. A new rewrite rule environment is provided to activate reCAPTCHA via RewriteRules. &#039;verifycaptcha&#039; can be set to redirect clients to reCAPTCHA. A special value &#039;: deny&#039; can be set to deny the client if it failed too many times. For example, [E=verifycaptcha] will always redirect to reCAPTCHA until verified. [E=verifycaptcha: deny] will redirect to reCAPTCHA until Max Tries is hit, after which the client will be denied.', '', '', '');
$this->db['accessAllowed'] = new DATTR_HELP_ITEM("Access Allowed", 'Specifies which IPs or sub-networks are allowed to access resources under this context. Together with &quot;Access Denied&quot; and server/virtual host level access control, accessibility is determined by the smallest scope that a client&#039;s IP address falls into.', '', 'Comma-delimited list of IPs/sub-networks.', 'Sub-networks can be written as 192.168.1.0/255.255.255.0, 192.168.1, or 192.168.1.*.');
$this->db['accessControl'] = new DATTR_HELP_ITEM("Access Control", 'Specifies what sub networks and/or IP addresses can access the server. At the server level, this setting will affect all virtual hosts. You can also set up access control unique to each virtual host at the virtual host level. Virtual host level settings will NOT override server level settings.<br/><br/>Blocking/Allowing an IP is determined by the combination of the allowed list and the denied list. If you want to block only certain IPs or sub-networks, put * or ALL in the &quot;Allowed List&quot; and list the blocked IPs or sub-networks in the &quot;Denied List&quot;. If you want to allow only certain IPs or sub-networks, put * or ALL in the &quot;Denied List&quot; and list the allowed IPs or sub-networks in the &quot;Allowed List&quot;. The setting of the smallest scope that fits for an IP will be used to determine access.<br/><br/><b>Server Level:</b> Trusted IPs or sub-networks must be specified in the &quot;Allowed List&quot; by adding a trailing &quot;T&quot;. Trusted IPs or sub-networks are not affected by connection/throttling limits. Only server level access control can set up trusted IPs/sub-networks.', ' Use this at the server level for general restrictions that apply to all virtual hosts.', '', '');
$this->db['accessControl_allow'] = new DATTR_HELP_ITEM("Allowed List", 'Specifies the list of IPs or sub-networks allowed. * or ALL are accepted.', ' Trusted IPs or sub-networks set at the server level access control will be excluded from connection/throttling limits.', 'Comma delimited list of IP addresses or sub-networks. A trailing &quot;T&quot; can be used to indicate a trusted IP or sub-network, such as 192.168.1.*T.', '<b>Sub-networks:</b> 192.168.1.0/255.255.255.0, 192.168.1.0/24, 192.168.1, or 192.168.1.*<br/><b>IPv6 addresses:</b> ::1 or [::1]<br/><b>IPv6 subnets:</b> 3ffe:302:11:2:20f:1fff:fe29:717c/64 or [3ffe:302:11:2:20f:1fff:fe29:717c]/64');
$this->db['accessControl_deny'] = new DATTR_HELP_ITEM("Denied List", 'Specifies the list of IPs or sub-networks disallowed.', '', 'Comma delimited list of IP addresses or sub-networks. * or ALL are accepted.', '<b>Sub-networks:</b> 192.168.1.0/255.255.255.0, 192.168.1.0/24, 192.168.1, or 192.168.1.*<br/><b>IPv6 addresses:</b> ::1 or [::1]<br/><b>IPv6 subnets:</b> 3ffe:302:11:2:20f:1fff:fe29:717c/64 or [3ffe:302:11:2:20f:1fff:fe29:717c]/64');
$this->db['accessDenied'] = new DATTR_HELP_ITEM("Access Denied", 'Specifies which IPs or sub-networks are NOT allowed to access resources under this context. Together with &quot;Access Allowed&quot; and server/virtual host-level access control, accessibility is determined by the smallest scope that a client&#039;s IP address falls into.', '', 'Comma-delimited list of IPs/sub-networks.', 'Sub-networks can be written as 192.168.1.0/255.255.255.0, 192.168.1, or 192.168.1.*.');
$this->db['accessDenyDir'] = new DATTR_HELP_ITEM("Access Denied Directories", 'Specifies directories that should be blocked from access. Add directories that contain sensitive data to this list to prevent accidentally exposing sensitive files to clients. Append a &quot;*&quot; to the path to include all sub-directories. If both &quot;Follow Symbolic Link&quot; and &quot;Check Symbolic Link&quot; are enabled, symbolic links will be checked against the denied directories.', ' Of critical importance: This setting only prevents serving static files from these directories. This does not prevent exposure by external scripts such as PHP/Ruby/CGI.', 'Comma-delimited list of directories', '');
$this->db['accessFileName'] = new DATTR_HELP_ITEM("Access File Name", 'Specifies the name of access control files. These files will be used only if &quot;Allow Override&quot; is enabled. Default name is .htaccess. You can configure this at server level and virtual host level. Server level is the default setting, and you  can override it at virtual host level.', '', 'Filename starting with &quot;.&quot;', '');
$this->db['accessLog_bytesLog'] = new DATTR_HELP_ITEM("Bytes Log", 'Specifies the path to the bandwidth bytes log file. When specified, a cPanel compatible bandwidth log will be created. This will log  the total bytes transferred for a request including both the request and reply bodies.', ' Put the log file on a separate disk.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');
$this->db['accessLog_fileName'] = new DATTR_HELP_ITEM("File Name", 'The access log filename.', ' Put access log file on a separate disk.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');
$this->db['accessLog_logFormat'] = new DATTR_HELP_ITEM("Log Format", 'Enterprise Edition Only Specifies the log format for the access log. When log format is set, it will override the &quot;Log Headers&quot; setting.', '', 'String. The syntax of log format is compatible with Apache 2.0&#039;s custom  <a href="http://httpd.apache.org/docs/current/mod/mod_log_config.html#formats" target="_blank" rel="noopener noreferrer">log format</a>.', '<b>Common Log Format (CLF)</b><br/>    &quot;%h %l %u %t \&quot;%r\&quot; %>s %b&quot;<br/><br/><b>Common Log Format with Virtual Host</b><br/>    &quot;%v %h %l %u %t \&quot;%r\&quot; %>s %b&quot;<br/><br/><b>NCSA extended/combined log format</b><br/>    &quot;%h %l %u %t \&quot;%r\&quot; %>s %b \&quot;%{Referer}i\&quot; \&quot;%{User-agent}i\&quot; <br/><br/><b>Log cookie value of Foobar</b><br/>    &quot;%{Foobar}C&quot;');
$this->db['accessLog_logHeader'] = new DATTR_HELP_ITEM("Log Headers", 'Specifies whether to log HTTP request headers: Referer, UserAgent, and Host.', ' Turn this off if you do not need these headers in the access log.', 'Select from checkbox', '');
$this->db['accessLog_pipedLogger'] = new DATTR_HELP_ITEM("Piped Logger", 'Specifies the external application that will receive the access log data sent by LiteSpeed through a pipe on its STDIN stream (file handle is 0).  When this field is specified, the access log will be sent only to the logger  application and not the access log file specified in previous entry.<br/><br/>The logger application must be defined in &quot;External Apps&quot; section first.  Server-level access logging can only use an external logger application  defined at the server level. Virtual host-level access logging can only use a logger application defined at the virtual host level.<br/><br/>The logger process is spawned in the same way as other external  (CGI/FastCGI/LSAPI) processes. This means it will execute as the  user ID specified in the virtual host&#039;s &quot;External App Set UID Mode&quot;  settings and will never run on behalf of a privileged user. <br/><br/>LiteSpeed web server performs simple load balancing among multiple logger  applications if more than one instance of a logger application is configured.  LiteSpeed server always attempts to keep the number of logger applications  as low as possible. Only when one logger application fails to process access  log entries in time will the server attempt to spawn another instance of  the logger application. <br/><br/>If a logger crashes, the web server will start another instance but the  log data in the stream buffer will be lost. It is possible to lose log  data if external loggers cannot keep up with the speed and volume of the log stream.', '', 'Select from drop down list', '');
$this->db['aclogUseServer'] = new DATTR_HELP_ITEM("Log Control", 'Where the access log should be written. There are three options:  <ol> <li>Write to the server&#039;s access log</li> <li>Create an access log for this virtual host</li> <li>Disable access logging</li> </ol>', '', 'Select from drop down list', '');
$this->db['addDefaultCharset'] = new DATTR_HELP_ITEM("Add Default Charset", 'Specifies whether to add a character set tag to the 	   &quot;Content-Type&quot; response header, when content type is either 	   &quot;text/html&quot; or &quot;text/plain&quot; without any parameters. 	   When set to Off,  this function is disabled. When set to 	   On, either the character set specified by 	   &quot;Customized Default Charset&quot; or the default &quot;iso-8859-1&quot; will be added.', '', 'Select from radio box', '');
$this->db['addMIMEType'] = new DATTR_HELP_ITEM("MIME Type", 'Specifies additional MIME types and mappings for this 	   context. New mappings will override existing mappings under this 	   context and its children contexts.<br/>	   If you want to show PHP scripts as text files instead of being 	   executed as scripts, just override the .php mapping to MIME type 	   &quot;text/plain&quot;.', '', 'MIME-type1 extension extension ..., MIME-type2 extension ... 		Use comma to separate between MIME types, use space to 		separate multiple extensions.', 'image/jpg jpeg jpg, image/gif gif');
$this->db['adminEmails'] = new DATTR_HELP_ITEM("Administrator Email", 'Specifies the server administrator&#039;s email address(es). If specified, administrators will be notified by email of important events (for example, when the LiteSpeed service is restarted automatically due to crash detection or when license is expiring).', 'Email alert feature will only work if the server has an active MX server such as postfix, exim, or sendmail.', 'Comma delimited list of email address.', '');
$this->db['adminUser'] = new DATTR_HELP_ITEM("WebAdmin User", 'Change the username and password for the WebAdmin Console.  The old password must be entered and verified in order to save changes.', '', '', '');
$this->db['allowBrowse'] = new DATTR_HELP_ITEM("Accessible", 'Specifies whether this context can be accessed. Set to No to deny access. You can use this feature to protect the specified directory from being visited. You may use it when you are updating contents for this context or you have special data in this directory.', '', 'Select from radio box', '');
$this->db['allowDirectAccess'] = new DATTR_HELP_ITEM("Allow Direct Access", 'Specifies whether to allow direct access without a referrer. A referrer header identifies the web page that linked to the current page. There is no &quot;referrer&quot; header in HTTP requests when a user types in an address directly in the address box or uses a feature like &quot;save target link as&quot;.', '', 'Select from radio box', '');
$this->db['allowOverride'] = new DATTR_HELP_ITEM("Allow Override", 'Specifies what directives in an access control file are allowed. An access control file can be placed in a directory to control the accessibility of files under that directory.<br/><ul>   <li>When nothing is checked, inherited default settings will be used.</li>   <li>When None is checked, access control files will be ignored.</li>   <li>     When Limit is checked, directives &quot;Allow&quot;, &quot;Deny&quot;, and &quot;Order&quot; are allowed. &lt;Limit&gt; and &lt;LimitExcept&gt;     directives are also allowed with limited support for GET, HEAD, and POST requests.   </li>   <li>     When Auth is checked, directives &quot;AuthGroupFile&quot;,  &quot;AuthName&quot;, &quot;AuthType&quot;, &quot;AuthUserFile&quot;, &quot;Require&quot;, and     &quot;Satisfy&quot; are allowed. &lt;Limit&gt; and &lt;LimitExcept&gt; directives are also allowed with limited support for GET,     HEAD, and POST requests.   </li>   <li>     When FileInfo is checked, directives &quot;AddDefaultCharset&quot;, &quot;AddType&quot;, &quot;DefaultType&quot;, &quot;ForceType&quot;, &quot;Redirect&quot;,     &quot;RedirectPermanent&quot;, &quot;RedirectTemp&quot;, &quot;RewriteBase&quot;, &quot;RewriteCond&quot;, &quot;RewriteEngine&quot;, &quot;RewriteOptions&quot;, and     &quot;RewriteRule&quot; are allowed.   </li>   <li>     When Indexes is checked, directives &quot;DirectoryIndex&quot;, &quot;ExpiresActive&quot;, &quot;ExpiresByType&quot;, and &quot;ExpiresDefault&quot; are     allowed.   </li>   <li>When Options is checked, directive &quot;Options&quot; is allowed.</li> </ul><br/>Allow Override configuration is available at the Server, Virtual Host, and Context levels. If a configuration is unchecked at the Server level, those controlled directives will be disabled for the entire server regardless of settings at lower levels. Lower levels can disable a setting that is enabled at a higher level, but cannot enable a setting that is disabled at an upper level.<br/><br/>Default values:<br/><b>Server level:</b> &quot;None&quot; (ignore access control file)<br/><b>VH level:</b> Inherit Server level setting<br/><b>Context level</b> Inherit VH level setting', ' If there is no need for directory level configuration customization, check None.', 'Select from checkbox', '');
$this->db['allowQuic'] = new DATTR_HELP_ITEM("Open HTTP3/QUIC (UDP) port", 'Allows the use of the HTTP3/QUIC network protocol for virtual hosts mapped to this listener. For this setting to take effect, &quot;Enable HTTP3/QUIC&quot; must also be set to Yes at the server level. Default value is Yes.', 'When this setting is set to Yes, HTTP3/QUIC can still be disabled at the virtual host level through the &quot;Enable HTTP3/QUIC&quot; setting.', '', '');
$this->db['allowSetUID'] = new DATTR_HELP_ITEM("Allow Set UID", 'Specifies whether the set UID bit is allowed for CGI scripts. If the set UID bit is allowed and the set UID bit is enabled for a CGI script, no matter which user the CGI script was started on behalf of, the user ID of the CGI process will switch to the user ID of the owner of the CGI script.<br/>The default is &quot;Off&quot;.', ' Do not allow Set UID CGI scripts whenever possible, as it is inherently a security risk.', 'Select from radio box', '');
$this->db['allowSymbolLink'] = new DATTR_HELP_ITEM("Follow Symbolic Link", 'Specifies whether to follow symbolic links in this virtual host. IF OWNER MATCH option will follow a symbolic link only if it has the same ownership. This setting overrides the default server-level setting.', ' For better security, disable this feature. For better performance, enable it.', 'Select from drop down list', '');
$this->db['allowedHosts'] = new DATTR_HELP_ITEM("Allowed Domains", 'Specifies which web sites can link to protected content.', '', 'Comma delimited list of domain names.', '');
$this->db['antiddos_blocked_ip'] = new DATTR_HELP_ITEM("Anti-DDoS Blocked IP", 'A comma-separated list of IP addresses blocked by Anti-DDoS protection, each ending with a semi-colon and reason code indicating why the IP address was blocked.<br/><br/>Potential Reason Codes: <ul>   <li>A: BOT_UNKNOWN</li>   <li>B: BOT_OVER_SOFT</li>   <li>C: BOT_OVER_HARD</li>   <li>D: BOT_TOO_MANY_BAD_REQ</li>   <li>E: BOT_TOO_MANY_DOS_URL</li>   <li>F: BOT_CAPTCHA</li>   <li>G: BOT_FLOOD</li>   <li>H: BOT_REWRITE_RULE</li>   <li>I: BOT_TOO_MANY_BAD_STATUS</li>   <li>J: BOT_WAF_DETECTED</li>   <li>K: BOT_BRUTE_FORCE</li> </ul><br/><br/>The full list of blocked IPs is also available in the Real-Time Stats report file /tmp/lshttpd/.rtreport.', '', '&lt;blocked_ip_address&gt;;&lt;reason_code&gt;', '1.0.100.50;E, 1.0.100.60;D, 1.0.100.70;F');
$this->db['apacheBinPath'] = new DATTR_HELP_ITEM("Apache Binary Path", 'Specifies the location of the Apache binary. Usually, it is located at /usr/local/apache/bin/httpd or /usr/local/apache2/bin/httpd, etc. This option must be set when &quot;Use Apache binary wrapper&quot; is used for &quot;Auto Reload On Changes&quot;.', '', '', '');
$this->db['apacheConf'] = new DATTR_HELP_ITEM("Apache Style Configurations", 'Specifies Apache configuration directives (supported by LiteSpeed) that you want to use in LiteSpeed native configuration file. For example, to override the default PHP configurations (php.ini entries) the server will need four directives: &quot;php_value&quot;, &quot;php_flag&quot;, &quot;php_admin_value&quot; and &quot;php_admin_flag&quot;.', '', 'Same as Apache configuration file.', '');
$this->db['apacheConfFile'] = new DATTR_HELP_ITEM("Apache Configuration File", 'Specifies the location of Apache configuration file. Usually, it is located at /usr/local/apache/conf/httpd.conf or /etc/httpd/conf/httpd.conf.', '', '', '');
$this->db['apacheEnableFP'] = new DATTR_HELP_ITEM("Enable FrontPage Extension", 'Specifies whether to explicitly enable Microsoft Front Page Server Extension or not. Usually, LSWS will enable it when module &quot;frontpage&quot; has been loaded in Apache httpd.conf. However, when mod_frontpage is statically linked into the Apache binary, configuration for the FrontPage module is not in httpd.conf, and you need to enable it explicitly here. Default is &quot;disabled&quot;.', '', 'Select from radio box', '');
$this->db['apacheEnvVars'] = new DATTR_HELP_ITEM("Apache Environment Variables", 'For shell environment variables used inside the Apache configuration file, LSWS will replace &quot;${ENVVAR}&quot; with the values set here. If the ENVVAR variable is not set here, &quot;${ENVVAR}&quot; occurrences are left unchanged.', '', 'Name and value pairs, one pair per line in the form of ENV=VALUE', '');
$this->db['apacheHandledContent'] = new DATTR_HELP_ITEM("Apache Handled Content", 'Specifies resources to be passed to and processed by Apache on the backend. This feature requires running Apache parallel to LiteSpeed on either another IP or a different port, so either &quot;Apache Port Offset&quot; or &quot;Apache IP Offset&quot; should be set to a non-zero value.', '', 'Resources are specified by a comma delimited list of URI, file suffixes, or regular expressions. A URI starts with &quot;/&quot;; a suffix starts with &quot;.&quot;, a regular expression starts with &quot;exp:&quot;. For example: &quot;/svn/, .shtml&quot; lets Apache handle requests with a URI starting with &quot;/svn/&quot; or ending with &quot;.shtml&quot;. The same effect can be achieved with the regular expression &quot;exp:^/svn/, exp:\.shtml$&quot;.', '');
$this->db['apacheIgnoredModules'] = new DATTR_HELP_ITEM("Ignore Apache Modules", 'Specifies a list of names of Apache modules that should be ignored by LiteSpeed while parsing the Apache configuration file. LiteSpeed will treat the listed modules as unsupported. This will cause configuration directives related to these modules enclosed in matching &lt;IfModule&gt; or &lt;IfDefined&gt; tags to be ignored.', '', 'comma delimited list of module names', '');
$this->db['apacheIpOffset'] = new DATTR_HELP_ITEM("Apache IP Offset", 'Specifies an offset to be added to listening IP address specified in the Apache configuration file. This allows LiteSpeed to run alongside Apache in the testing phase instead of switching back and forth between LiteSpeed and Apache on a production server. The calculated IP address has to be available on this server.', '', 'The offset should be set as an integer (allow negative number), not an IP address. Adding &quot;256&quot; will add 1 to the value of the C class subnet. This option only works with IPv4 address.', '');
$this->db['apachePortOffset'] = new DATTR_HELP_ITEM("Apache Port Offset", 'Specifies an offset to be added to listening TCP ports specified in the Apache configuration file. In the testing phase, this allows LiteSpeed to run alongside Apache on a different port instead of switching back and forth between LiteSpeed and Apache on a production server.<br/>If set to 0 or not set, LiteSpeed will use the ports specified in the Apache configuration file. When testing, make this setting a non-zero value. LiteSpeed will then add this offset value to the port specified in the Apache configuration and use this port. After confirming that everything works properly, you can stop Apache, set this option back to 0, and restart LiteSpeed.', '', '', '');
$this->db['appServerContext'] = new DATTR_HELP_ITEM("App Server Context", 'An App Server Context provides an easy way to configure a Ruby Rack/Rails, WSGI, or Node.js application. To add a an application through an App Server Context, only mounting the URL and the application&#039;s root directory is required. There is no need to go through all the trouble to define an external application, add a 404 handler, and rewrite rules, etc.', '', '', '');
$this->db['appType'] = new DATTR_HELP_ITEM("Application Type", 'The type of application used for this context. Rack/Rails, WSGI, or Node.js are supported.', '', '', '');
$this->db['appserverEnv'] = new DATTR_HELP_ITEM("Run-Time Mode", 'Specifies which mode the application will be running as: &quot;Development&quot;, &quot;Production&quot;, or &quot;Staging&quot;. The default is &quot;Production&quot;.', '', 'Select from drop down list', '');
$this->db['as_location'] = new DATTR_HELP_ITEM("Location", 'Specifies the corresponding location of this context in the file system.<br/><br/>Default value: $DOC_ROOT + &quot;URI&quot;', '', 'It can be an absolute path or path relative to $SERVER_ROOT, $VH_ROOT, or $DOC_ROOT. $DOC_ROOT is the default relative path, and can be omitted.<br/><br/>If the &quot;URI&quot; is a regular expression, then the matched sub-string can be used to form the &quot;Root&quot; string. The matched sub-string can be referenced with the values &quot;$1&quot; - &quot;$9&quot;. &quot;$0&quot; and &quot;&&quot; can be used to reference the whole matched string. Additionally, a query string can be set by appending a &quot;?&quot; followed by the query string. Be careful. &quot;&&quot; should be escaped as &quot;\&&quot; in the query string.', 'A plain URI like /examples/ with &quot;Location&quot; set to /home/john/web_examples will map the request &quot;/examples/foo/bar.html&quot; to file &quot;/home/john/web_examples/foo/bar.html&quot;.<br/>To simulate Apache&#039;s mod_userdir, set URI to exp: ^/~([A-Za-z0-9]+)(.*), set &quot;Location&quot; to /home/$1/public_html$2. With these settings, a request of URI /~john/foo/bar.html will map to file /home/john/public_html/foo/bar.html.');
$this->db['as_startupfile'] = new DATTR_HELP_ITEM("Startup File", 'The location of file used to start the application, relative to the application root directory.<br/><br/>Default startup file names include &#039;config.ru&#039; for Rack/Rails, &#039;wsgi.py&#039; and &#039;passenger_wsgi.py&#039; for WSGI, and &#039;app.js&#039; for NodeJS.', '', 'Path relative to application root directory', '');
$this->db['authName'] = new DATTR_HELP_ITEM("Authentication Name", 'Specifies an alternative name for the authorization realm for the current context. If not specified, the original realm name will be used. The authentication name is displayed on the browser&#039;s login pop-up.', '', '', '');
$this->db['autoFix503'] = new DATTR_HELP_ITEM("Auto Fix 503 Error", 'Specifies whether to try to fix the &quot;503 Service Unavailable&quot; error by restarting the server gracefully. A &quot;503&quot; error is usually caused by malfunctioning external applications and a web server restart can often fix the error temporarily. If enabled, the server will restart automatically whenever there are more than 30 &quot;503&quot; errors within a 30 seconds span.<br/><br/>Default value: No', '', 'Select from radio box', '');
$this->db['autoIndex'] = new DATTR_HELP_ITEM("Auto Index", 'Specifies whether to generate a directory index on the fly when index files listed in &quot;Index Files&quot; are not available in a directory. This option is customizable at the virtual host and context level, and is inherited along the directory tree until it is explicitly overridden. You can customize the generated index page. Please check online wiki How-tos.', ' It is recommended to turn off Auto Index wherever possible to prevent revealing confidential data.', 'Select from radio box', '');
$this->db['autoIndexURI'] = new DATTR_HELP_ITEM("Auto Index URI", 'Specifies the URI that will be used to generate the index page when index files listed in &quot;Index Files&quot; are not available in a directory. LiteSpeed web server uses an external script to generate the index page providing the maximum customization flexibility. The default script produces an index page with same look as Apache&#039;s. To customize the generated index page, please read online wiki How-tos. The directory to be indexed is passed to the script via an environment variable &quot;LS_AI_PATH&quot;.', '', 'URI', '');
$this->db['autoReloadApacheConf'] = new DATTR_HELP_ITEM("Auto Reload On Changes", 'Specifies how to apply Apache configuration changes. When set to &quot;Yes&quot;, LSWS will perform a graceful restart whenever the Apache configuration file has been modified. This may cause LSWS to restart multiple times when updating Apache configurations. A better solution (introduced in version 3.3.8)  is &quot;Use Apache binary wrapper&quot;. This will replace Apache httpd binary with a wrapper script. Whenever Apache is requested to start/stop/restart, the script will tell LSWS to take corresponding action. &quot;Apache Binary Path&quot; must be set to use this setting. Default is &quot;No&quot; for standard installations. For cPanel servers, the default is &quot;Use Apache binary wrapper&quot;. (&quot;Override cPanel restart HTTPD script&quot; is an optional workaround that should only be used if the option &quot;Use Apache binary wrapper&quot; is having problems.) For other control panels default is &quot;Yes&quot;.', '', 'Select from radio box', '');
$this->db['autoStart'] = new DATTR_HELP_ITEM("Start By Server", 'Specifies whether you want the web server to start the application automatically. Only FastCGI and LSAPI applications running on the same machine can be started automatically. The IP in the &quot;Address&quot; must be a local IP. Starting through the LiteSpeed CGI Daemon instead of a main server process will help reduce system overhead. CGI Daemon Async mode (non-blocking event-driven method) is recommended for servers with high I/O wait.<br/><br/>Default value: Yes (Through CGI Daemon Async)', '', 'Select from drop down list', '');
$this->db['autoUpdateDownloadPkg'] = new DATTR_HELP_ITEM("Download Updates", 'Specifies whether to auto-download a new product release package file when available. If a new package has been successfully downloaded, an online one-click upgrade can be performed via the WebAdmin console under Service Manager - &quot;Version Management&quot;.', '', 'Select from drop down list', '');
$this->db['autoUpdateInterval'] = new DATTR_HELP_ITEM("Check For Update", 'Specifies how often the update agent will check for a new product release. Options are &quot;Daily&quot;, &quot;Weekly&quot;, &quot;Monthly&quot; and &quot;Disable&quot;.', '', 'Select from drop down list', '');
$this->db['awstats'] = new DATTR_HELP_ITEM("AWStats Integration", 'AWStats is a popular log analyzer that generates advanced web server  statistics. LiteSpeed web server seamlessly integrates AWStats into  its WebAdmin console.', '', '', '');
$this->db['awstatsRealm'] = new DATTR_HELP_ITEM("Authentication Realm", 'Specifies an authorization realm for the statistical results. When specified, only authorized users can view the results.', '', 'Select from drop down list', '');
$this->db['awstatsURI'] = new DATTR_HELP_ITEM("AWStats URI", 'Specifies the URI where the AWStats results can be accessed in this virtual host.', 'The URI should be unique on this virtual host. Otherwise, overlapped content will be inaccessible.', 'uri', 'If this URI is set to /awstats/ for the virtual host www.example.com,  then the full URL to the AWStats page would be http://www.example.com/awstats/.');
$this->db['backlog'] = new DATTR_HELP_ITEM("Back Log", 'Specifies the backlog of the listening socket.  Required if &quot;Start By Server&quot; is enabled.', '', 'Integer number', '');
$this->db['banPeriod'] = new DATTR_HELP_ITEM("Banned Period (sec)", 'Specifies how long new connections will be rejected from an IP if, after the &quot;Grace Period (sec)&quot; has elapsed, the number of connections is still more than the &quot;Connection Soft Limit&quot;. If IPs are getting banned repeatedly, we suggest that you increase your banned period to stiffen the penalty for abuse.', '', 'Integer number', '');
$this->db['binPath'] = new DATTR_HELP_ITEM("Binary Path", 'The location of the App Server application binary.', '', '', '');
$this->db['bindIPv6Only'] = new DATTR_HELP_ITEM("Bind IPv6 Only", 'Only bind IPv6 for IPv6 wildcard IP addresses. When set to &quot;Yes&quot;, IPv4 IP addresses will not be bound and will need their own listeners.<br/><br/>Default value: Yes', '', 'Select from radio box', '');
$this->db['blockBadReq'] = new DATTR_HELP_ITEM("Block Bad Request", 'Block IPs that keep sending badly-formated HTTP requests for the &quot;Banned Period (sec)&quot;. Default is Yes. This helps to block botnet attacks that repeatedly sending junk requests.', '', 'Select from radio box', '');
$this->db['brStaticCompressLevel'] = new DATTR_HELP_ITEM("Brotli Compression Level (Static File)", 'Specifies the level of Brotli compression applied to static files. Ranges from 1 (lowest) to 11 (highest).<br/><br/>This setting will only take effect when &quot;Enable Compression&quot; and &quot;Auto Update Static File&quot; are enabled.<br/><br/>Default value: 5', ' Save network bandwidth. Text-based responses such as html, css, and javascript files benefit the most and on average can be compressed to half of their original size.', 'Number between 1 and 11.', '');
$this->db['bubbleWrap'] = new DATTR_HELP_ITEM("Bubblewrap Container", 'Set to On if you wish to start CGI processes (including PHP programs) in a bubblewrap sandbox. See <a href="   https://wiki.archlinux.org/title/Bubblewrap " target="_blank" rel="noopener noreferrer">   https://wiki.archlinux.org/title/Bubblewrap </a> for details on using bubblewrap. Bubblewrap must be installed on your system prior to using this setting.<br/><br/>This setting cannot be turned on at the Virtual Host level if set to &quot;Disabled&quot; at the Server level.<br/><br/>Default values:<br/><b>Server level:</b> Disabled<br/><b>VH level:</b> Inherit Server level setting', '', 'Select from drop down list', '');
$this->db['bubbleWrapCmd'] = new DATTR_HELP_ITEM("Bubblewrap Command", 'The full bubblewrap use command, including the bubblewrap program itself. More on configuring this command can be found here: <a href="   https://docs.litespeedtech.com/products/lsws/bubblewrap " target="_blank" rel="noopener noreferrer">   https://docs.litespeedtech.com/products/lsws/bubblewrap </a>. If not specified, the default command listed below will be used.<br/><br/>Default value: /bin/bwrap --ro-bind /usr /usr --ro-bind /lib /lib --ro-bind-try /lib64 /lib64 --ro-bind /bin /bin --ro-bind /sbin /sbin --dir /var --dir /tmp --proc /proc --symlink ../tmp var/tmp --dev /dev --ro-bind-try /etc/localtime /etc/localtime --ro-bind-try /etc/ld.so.cache /etc/ld.so.cache --ro-bind-try /etc/resolv.conf /etc/resolv.conf --ro-bind-try /etc/ssl /etc/ssl --ro-bind-try /etc/pki /etc/pki --ro-bind-try /etc/man_db.conf /etc/man_db.conf --ro-bind-try /home/$USER /home/$USER --bind-try /var/lib/mysql/mysql.sock /var/lib/mysql/mysql.sock --bind-try /home/mysql/mysql.sock /home/mysql/mysql.sock --bind-try /tmp/mysql.sock /tmp/mysql.sock  --unshare-all --share-net --die-with-parent --dir /run/user/$UID ‘$PASSWD 65534’ ‘$GROUP 65534’', '', '', '');
$this->db['cacheEngine'] = new DATTR_HELP_ITEM("Cache Features", 'Specifies which cache features to enable. On enables the cache engine while Crawler and ESI enables those respective features. Features enabled globally at the Server level can be overriden at the Virtual Host level.<br/><br/>Setting Enable LiteMage to On at the Virtual Host level will override this setting, enabling all features.<br/><br/>Default value: Everything enabled', '', 'Select from checkbox', '');
$this->db['cacheMgrStorePath'] = new DATTR_HELP_ITEM("Cache Manager Path", 'Specifies the directory used to store cache manager files. These files are stored in <b>Storage Path</b> by default.', ' A separate location on a fast disk is recommended to prevent the accidental removal of cache manager files. Only set to a location on a RAM disk if cache storage is also saved on a RAM disk.', 'path', '');
$this->db['cachePolicy:cacheKeyMod'] = new DATTR_HELP_ITEM("Cache Key Modifications", 'Makes some requests more cache-friendly by allowing junk query string parameters to be dropped from URLs.', '', 'clear discards all previous configurations, -qs:[string] drop all query strings where the name matches [string] exactly, or -qs:utm* drop all query strings where the name part starts with [string]. Input one rule per line.', '-qs:utm* drops all query strings where the name part starts with &quot;utm&quot;.<br/>-qs:gclid drops all query strings where the name matches &quot;gclid&quot; exactly.');
$this->db['cachePolicy:enableCache'] = new DATTR_HELP_ITEM("Publicly Cache All", 'Publicly cache all URLs served under the current context (virtual host, or context level).<br/><br/>Virtual hosts configured through Apache&#039;s httpd.conf can use the &quot;CacheEnable&quot; and &quot;CacheDisable&quot; directives at the server, virtual host, context, file, and location level or in .htaccess. &quot;CacheEnable&quot; and &quot;CacheDisable&quot; directives are compatible with Apache mod_cache directives. However, when used at the context, file, or location level, or in .htaccess, &quot;CacheEnable&quot; and &quot;CacheDisable&quot; will only be applied to directories below the current level. URL parameters will be ignored.', 'Disabled by default. Do not enabled this setting if you are using any LSCache plugins.', 'Select from radio box', '');
$this->db['cachePolicy:enablePostCache'] = new DATTR_HELP_ITEM("Enable POST cache", 'Specifies if POST requests can be cached using the &quot;x-litespeed-cache-control&quot; header.<br/><br/>Default value: No', '', 'Select from radio box', '');
$this->db['cachePolicy:enablePrivateCache'] = new DATTR_HELP_ITEM("Privately Cache All", 'Privately cache all URLs served under the current context (virtual host, or context level).<br/><br/>A separate cached copy will be made per user based on their IP and set cookies.<br/><br/>Virtual hosts configured through Apache&#039;s httpd.conf can use the &quot;CacheEnable private /url&quot; and &quot;CacheDisable private /url&quot; directives at server, virtual host, directory, file, and location levels or in a .htaccess file. &quot;CacheEnable private&quot; and &quot;CacheDisable private&quot; are compatible with Apache&#039;s mod_cache directives and will be applied to all directories below the current level. However, when used at the directory, file, or location level, or in a .htaccess file, &quot;CacheEnable private&quot; and &quot;CacheDisable private&quot; will only be applied to directories below the current level. URL parameters will be ignored.', 'Disabled by default. Do not enabled this setting if you are using any LSCache plugins.', 'Select from radio box', '');
$this->db['cachePolicy:expireInSeconds'] = new DATTR_HELP_ITEM("Cache Expire Time (seconds)", 'Specifies how long an object will be cached. The default is &quot;86400&quot; seconds (one day).', '', 'Integer number', '');
$this->db['cachePolicy:maxCacheObjSize'] = new DATTR_HELP_ITEM("Max Object Size", 'Specifies the maximum size of an object, up to 100M, that can be stored in the cache directory.<br/><br/>Default value: 10M', '', 'Integer number', '');
$this->db['cachePolicy:maxStaleAge'] = new DATTR_HELP_ITEM("Cache Stale Age (seconds)", 'Specifies how long an object will continue to be served from cache after it has expired but before a new cached copy is available. The default is &quot;10&quot; seconds.', '', 'Integer number', '');
$this->db['cachePolicy:microCache5xx'] = new DATTR_HELP_ITEM("Micro Cache 5XX Response", 'Cache pages responding with HTTP status code 5xx (500, 503, etc) for 10 seconds when the cache response header indicates that the page is cacheable.<br/><br/>Default values:<br/><b>Server level:</b> Yes<br/><b>VH level:</b> Inherit Server level setting<br/><b>Context-level</b> Inherit VH level setting', ' Enabling this setting is useful for avoiding bad requests but can also act as some added DDoS protection.', 'Select from radio box', '');
$this->db['cachePolicy:privateExpireInSeconds'] = new DATTR_HELP_ITEM("Private Cache Expire Time (seconds)", 'Specifies how long an object will be cached in private cache. The default is &quot;60&quot; seconds.', '', 'Integer number', '');
$this->db['cacheStorePath'] = new DATTR_HELP_ITEM("Storage Path", 'Specifies the directory for holding cached objects. Currently, LiteSpeed Cache stores each object in its own file. The filename is a hash of the object key. Multiple levels of directories will be created in order to avoid holding too many files in one directory. This value must be set at the Server level in order to enable cache. Virtual Host level settings will override Server level settings.', ' Assign a dedicated disk or disk array as the cache storage. RAID0 is recommended.<br/><br/>It is recommended to set a different cache storage path for each Virtual Host to prevent purge all requests from affecting other Virtual Hosts.', 'path', '');
$this->db['censorLogLevel'] = new DATTR_HELP_ITEM("Log Level", 'Specifies the level of detail of the Web Application Firewall engine&#039;s debug output. This value ranges from 0 - 9. 0 disables logging. 9 produces the most detailed log. The the server and virtual host&#039;s error log &quot;Log Level&quot; must be set to at least INFO for this option to take effect. This is useful when testing request filtering rules.', '', 'Integer number', '');
$this->db['censorRuleSet'] = new DATTR_HELP_ITEM("Rules Definition", 'Specifies a list of censorship rules.<br/><br/>If you are using an Apache config file, you have to set up rules in httpd.conf.  Rules defined here will have no effect.', 'Rules configured here only work for vhosts configured in native LSWS configuration, not for vhosts from Apache httpd.conf.', 'String. Syntax of censoring rules follows that of Apache&#039;s mod_security directives. &quot;SecFilter&quot;, &quot;SecFilterSelective&quot;, and &quot;SecRule&quot; can be  used here.  You can copy and paste security rules from an Apache configuration file.<br/><br/>For more details about rule syntax, please refer to the  <a href="http://www.modsecurity.org/documentation/index.html" target="_blank" rel="noopener noreferrer">Mod Security documentation</a>.', '');
$this->db['censorRuleSetEnabled'] = new DATTR_HELP_ITEM("Enabled", 'Specifies whether to enable this rule set. With this option, a rule set can be quickly turned on and off without adding or removing the rule set. Default is &quot;Yes&quot;.', '', 'Select from radio box', '');
$this->db['censorRuleSetName'] = new DATTR_HELP_ITEM("Name", 'Give a group of censorship rules a name. For display only.', '', 'String', '');
$this->db['certChain'] = new DATTR_HELP_ITEM("Chained Certificate", 'Specifies whether the certificate is a chained certificate or not. The file that stores a certificate chain must be in PEM format, and the certificates must be in the chained order, from the lowest level (the actual client or server certificate) to the highest level (root) CA.', '', 'Select from radio box', '');
$this->db['certFile'] = new DATTR_HELP_ITEM("Certificate File", 'The filename of the SSL certificate file.', ' The certificate file should be placed in a secured directory, which allows read-only access to the user that the server runs as.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');
$this->db['cgiContext'] = new DATTR_HELP_ITEM("CGI Context", 'A CGI context defines scripts in a particular directory as CGI scripts. This directory can be inside or outside of the document root. When a file under this directory is requested, the server will always try to execute it as a CGI script, no matter if it&#039;s executable or not. In this way, file content under a CGI Context is always protected and cannot be read as static content. It is recommended that you put all your CGI scripts in a directory and set up a CGI Context to access them.', '', '', '');
$this->db['cgiResource'] = new DATTR_HELP_ITEM("CGI Settings", 'The following settings control CGI processes. Memory and process limits also serve as the default for other external applications if limits have not been set explicitly for those applications.', '', '', '');
$this->db['cgi_path'] = new DATTR_HELP_ITEM("Path", 'Specifies the location of CGI scripts.', '', 'The path can be a directory that contains a group of CGI scripts, like $VH_ROOT/myapp/cgi-bin/. In this case, the context &quot;URI&quot; must end with &quot;/&quot;, like /app1/cgi/. The Path can also specify only one CGI script, like $VH_ROOT/myapp/myscript.pl. This script should have the corresponding &quot;URI&quot; /myapp/myscript.pl.', '');
$this->db['cgidSock'] = new DATTR_HELP_ITEM("CGI Daemon Socket", 'A unique socket address used to communicate with the CGI daemon. LiteSpeed server uses a standalone CGI daemon to spawn CGI scripts for best performance and security. If you need to change this location, specify a Unix domain socket here.<br/><br/>Default value: uds://$SERVER_ROOT/admin/lscgid/.cgid.sock', '', 'UDS://path', 'UDS://tmp/lshttpd/cgid.sock');
$this->db['cgroups'] = new DATTR_HELP_ITEM("cgroups", 'Apply cgroup settings to this CGI process if supported by the current OS. At this time, RedHat/Centos Linux v7.5+ and Ubuntu 18.04+ are supported. The currently executing user will be used to determine which cgroup configuration to apply.<br/><br/>Setting this to Disabled at the Server level will disable this setting server-wide. In all other cases, the Server level setting can be overridden at the Virtual Host level.<br/><br/>Default values:<br/><b>Server level:</b> Off<br/><b>VH level:</b> Inherit Server level setting', '', 'Select from drop down list', '');
$this->db['checkPrivateCache'] = new DATTR_HELP_ITEM("Check Private Cache", 'Specifies whether to check against the private cache for URLs requested in the current context. Can be set at the server, virtual host, or context level.', '', 'Select from radio box', '');
$this->db['checkPublicCache'] = new DATTR_HELP_ITEM("Check Public Cache", 'Specifies whether to check against the public cache for URLs requested in the current context. Can be set at the server level, virtual host level, or context level.', '', 'Select from radio box', '');
$this->db['checkSymbolLink'] = new DATTR_HELP_ITEM("Check Symbolic Link", 'Specifies whether to check symbolic links against &quot;Access Denied Directories&quot; when &quot;Follow Symbolic Link&quot; is turned on. If enabled, the canonical real path of the resource referred by a URL will be checked against the configurable access denied directories. Access will be denied if it falls inside an access denied directory.', ' For best security, enable this option. For best performance, disable it.', 'Select from radio box', '');
$this->db['chrootMode'] = new DATTR_HELP_ITEM("External App Chroot Mode", 'Enterprise Edition Only Specifies how the root directory is set for an external application process. In order to protect confidential system data files from being accessed by a vulnerable external application script, an alternative root path can be set for the external application process so that files beyond the new root directory become inaccessible. This is referred to as a &quot;chroot jail&quot;.<br/><br/>Three choices are available: <ul><li>Same as Server: External application processes will be run in the same jail as the server.</li>     <li>Virtual Host Root: Set chroot jail to the root directory of the virtual host. The external application script will only be able to access files inside the virtual host root. </li> 	<li>Customized Chroot Path: Specify the chroot path &quot;External App Chroot Path&quot; below. </li> </ul>', 'If used properly, chroot will greatly enhance the security of external application scripts, but you must make sure the external application script is functional in the limited chroot jail environment.', 'Select from drop down list', '');
$this->db['chrootPath'] = new DATTR_HELP_ITEM("External App Chroot Path", 'Enterprise Edition Only Specifies a new root directory for the current host&#039;s external application scripts when &quot;External App Chroot Mode&quot; is set to Customized Chroot Path.', '', 'Absolute path', '');
$this->db['ciphers'] = new DATTR_HELP_ITEM("Ciphers", 'Specifies the cipher suite to be used when negotiating the SSL handshake. LSWS supports cipher suites implemented in SSL v3.0, TLS v1.0, TLS v1.2, and TLS v1.3.', ' We recommend leaving this field blank to use our default cipher which follows SSL cipher best practices.', 'Colon-separated string of cipher specifications.', 'ECDHE-RSA-AES128-SHA256:RC4:HIGH:!MD5:!aNULL:!EDH');
$this->db['clAltPhp'] = new DATTR_HELP_ITEM("CloudLinux Alt PHP", 'Detect cloudlinux alt PHP handlers.<br/><br/>Default value is &quot;Yes&quot;.', '', 'Select from radio box', '');
$this->db['clientVerify'] = new DATTR_HELP_ITEM("Client Verification", 'Enterprise Edition Only Specifies the type of client certifcate authentication. Available types are: <ul> <li><b>None:</b> No client certificate is required.</li> <li><b>Optional:</b> Client certificate is optional.</li> <li><b>Require:</b> The client must has valid certificate.</li> <li><b>Optional_no_ca:</b> Same as optional.</li> </ul> The default is &quot;None&quot;.', '&quot;None&quot; or &quot;Require&quot; are recommended.', 'Select from drop down list', '');
$this->db['compressibleTypes'] = new DATTR_HELP_ITEM("Compressible Types", 'Specifies what MIME types are allowed to be compressed. Leave this setting unset or enter default to use the server built-in default list which should already cover most mime-types.<br/><br/>Default value: text/*,application/x-javascript,application/javascript,application/xml,image/svg+xml,application/rss+xml, application/json,application/vnd.ms-fontobject,application/x-font,application/x-font-opentype, application/x-font-truetype,application/x-font-ttf,font/eot,font/opentype,font/otf,font/ttf,image/x-icon, image/vnd.microsoft.icon,application/xhtml+xml', ' Only allow types that will benefit from GZIP/Brotli compression. Binary files such as gif/png/jpeg images and flash files do not benefit from compression.', 'MIME type list separated by commas. Wild card &quot;*&quot; and negate sign &quot;!&quot; are allowed, such as text/*, !text/js.', 'If you want to compress text/* but not text/css, you can have a rule like text/*, !text/css. &quot;!&quot; will exclude that MIME type.');
$this->db['configFile'] = new DATTR_HELP_ITEM("Config File", 'The configuration filename and directory for this virtual host.', '$SERVER_ROOT/conf/vhosts/$VH_NAME.xml is recommended for easy management.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT, $VH_ROOT.', '');
$this->db['connTimeout'] = new DATTR_HELP_ITEM("Connection Timeout (secs)", 'Specifies the maximum connection idle time allowed during processing one request. The connection will be closed if it has been idle, i.e. no I/O activity, for this period of time.', ' Set this as low as you can to help recover dead connections during a potential DoS attack.', 'Integer number', '');
$this->db['consoleSessionTimeout'] = new DATTR_HELP_ITEM("Session Timeout (secs)", 'Customize the session timeout length of the WebAdmin Console.  The default is 60 seconds.', ' Set a proper value for production use, usually less than 300 seconds.', 'Integer number', '');
$this->db['controlPanel'] = new DATTR_HELP_ITEM("Control Panel", 'Auto detect PHP handlers based on the control panel used.<br/><br/>Default value is &quot;auto detect&quot;.', '', 'Select from drop down list', '');
$this->db['cpuAffinity'] = new DATTR_HELP_ITEM("CPU Affinity", 'CPU affinity binds a process to one or more CPUs (cores). It is beneficial for a process to always use the same CPU because then the process can make use of data left in CPU cache. If the process moves to a different CPU, there is no use of CPU cache and unnecessary overhead is required.<br/><br/>The CPU Affinity setting controls how many CPUs (cores) one server process will be associated with. The minimum value is 0, which will disable this feature. The maximum value is the number of cores the server has. Generally, 1 is the best setting because it creates the strictest use of CPU affinity and thus makes the most use of CPU cache.<br/><br/>Default value: 0', '', 'Integer value from 0 to 64. (0 will disable this feature)', '');
$this->db['crlFile'] = new DATTR_HELP_ITEM("Client Revocation File", 'Enterprise Edition Only Specifies the file containing PEM-encoded CA CRL files enumerating revoked client certificates. This can be used as an alternative or in addition to &quot;Client Revocation Path&quot;.', '', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');
$this->db['crlPath'] = new DATTR_HELP_ITEM("Client Revocation Path", 'Enterprise Edition Only Specifies the directory containing PEM-encoded CA CRL files for revoked client certificates. The files in this directory have to be PEM-encoded. These files are accessed through hash filenames, hash-value.rN. Please refer to openSSL or Apache mod_ssl documentation regarding creating the hash filename.', '', 'path', '');
$this->db['ctxType'] = new DATTR_HELP_ITEM("Context Type", 'The type of context created determines it&#039;s usage.:<br><br><b>Static</b> context can be used to map a URI to a directory either outside document root or within it.<br> <b>Java Web App</b> context is used to automatically import a predefined Java Application in an AJPv13 compilant Java servlet engine.<br> <b>Servlet</b> context is used to import a specific servlet under a web application.<br> <b>Fast CGI</b> context is a mount point of Fast CGI application.<br> <b>LiteSpeed SAPI</b> context can be used to associate a URI with an LSAPI application.<br> <b>Proxy</b> context enables this virtual host to serve as a transparant reverse proxy server to an external web server or application server.<br> <b>CGI</b> context can be used to specify a directory only contains CGI scripts.<br> <b>Load Balancer</b> context can be used to assign a different cluster for that context.<br> <b>Redirect</b> context can set up an internal or external redirect URI.<br> <b>App Server</b> context is used for Rack/Rails, WSGI, or Node.js applications.<br> <b>Rack/Rails</b> context is specifically used for Rack/Rails applications. It is recommended to configure Rack/Rails applications as an <b>App Server</b> context instead.<br>', '', '', '');
$this->db['defaultAction'] = new DATTR_HELP_ITEM("Default Action", 'Specifies the default actions that should be taken when a censoring rule is met. Default value is deny,log,status:403, which means to deny access with status code 403 and log the incident in the error log.', '', '', '');
$this->db['defaultCharsetCustomized'] = new DATTR_HELP_ITEM("Customized Default Charset", 'Specifies a character set to be used when &quot;Add Default Charset&quot; 	   is On. This is optional. The default value is iso-8859-1. 	   This entry has no effect when &quot;Add Default Charset&quot; is 	   Off.', '', 'Name of a character set.', 'utf-8');
$this->db['defaultPhpVer'] = new DATTR_HELP_ITEM("Default PHP Versions", 'A list of PHP versions to use as the default &quot;.php&quot; handler when a &quot;.php&quot; handler has not been explicitly set through a script handler or the &quot;Handled suffixes&quot; configuration.<br/><br/>The first available PHP handler, based on this list, will be used.', ' All versions from php52 to php56 and php70 to php74 are available.', 'Comma separated list of phpXX versions where XX is the combined major and minor PHP version number.', 'php74, php73, php72, php71, php70, php56');
$this->db['defaultType'] = new DATTR_HELP_ITEM("Default MIME Type", 'When specified, this type will be used when MIME type mapping 	   cannot be determined by the suffix of a document or if there is no suffix. 	   If not specified, the default value 	   application/octet-stream will be used.', '', 'MIME-type', '');
$this->db['destinationuri'] = new DATTR_HELP_ITEM("Destination URI", 'Specifies the target location of the redirect. If this redirected URI maps to a URI in another redirect context, it will be redirected again.', '', 'This URI can either be a relative URI on the same web site starting with &quot;/&quot;, or an absolute URI pointing to different web site starting with &quot;http(s)://&quot;. If the &quot;URI&quot; contains regular expressions, the destination can reference the matched variables, such as $1 or $2.', '');
$this->db['detachedMode'] = new DATTR_HELP_ITEM("Detached Mode", 'Run PHP handler processes detached from the main LiteSpeed worker process.', ' This has the advantage of allowing LiteSpeed to continue using detached PHP handler processes after restarting as opposed to having to start new PHP handler processes.', 'Select from radio box', '');
$this->db['disableAdmin'] = new DATTR_HELP_ITEM("Disable Admin", 'Specifies whether to disable the web administration console for  Microsoft FrontPage Server Extensions. The web administration console is available at URL<br/>http://your.domain/_vti_bin/_vti_adm/fpadmcgi.exe.<br/>Additional FrontPage Server Extensions packages must be installed in order to make it work properly.', ' Disable the administration console when you no longer need to manage users or change configurations.', 'Select from radio box', '');
$this->db['disableInitLogRotation'] = new DATTR_HELP_ITEM("Disable Initial Log Rotation", 'Specifies whether to disable rotation of server error log file at startup. Initial log rotation is enabled by default for standard installations. Servers using cPanel, however, always write to the Apache error log and thus ignore this setting.', '', 'Select from radio box', '');
$this->db['disableSecHtaccess'] = new DATTR_HELP_ITEM("Disable .htaccess Override", 'Disable turning off mod_security engine in .htaccess. This is a global setting only available at the server level.  Default is &quot;No&quot;.', '', 'Select from radio box', '');
$this->db['docRoot'] = new DATTR_HELP_ITEM("Document Root", 'Specifies the document root for this virtual host. $VH_ROOT/html is recommended. This directory is referred to as $DOC_ROOT in contexts.', '', 'A path which can be absolute, relative to $SERVER_ROOT, or relative to $VH_ROOT.', '');
$this->db['domainName'] = new DATTR_HELP_ITEM("Domains", 'Specifies the mapping domain names. Domain names are case insensitive and the leading &quot;www.&quot; will be removed. The wildcard characters &quot;*&quot; and &quot;?&quot; are allowed. &quot;?&quot; only represents one character. &quot;*&quot; represents any numbers of characters. Duplicated domain names are not allowed.', ' If a listener is dedicated to one virtual host, always use * for the domain name to avoid unnecessary checking. Domain names with wildcard characters  (other than the catchall domain) should be avoided whenever possible.', 'Comma-separated list.', 'www?.example.com<br/>&quot;*.mydomain.com&quot; will match all subdomains of mydomain.com.<br/>&quot;*&quot; by itself is the catchall domain and will match any unmatched domain names.');
$this->db['domainNames'] = new DATTR_HELP_ITEM("Domain Names", 'Specifies the virtual servers that provide Front Page Server Extensions service. When a web site is assigned to multiple domain names or service ports, FrontPage access is only available to the domain name and port combinations specified in this list. <br/><br/>Additional FrontPage Server Extensions packages must be installed in order to make it work properly.', '', 'Domain_name:port[, ...] The virtual server name is comprised of domain name and port number.', 'For a web site with domain name &quot;www.mydomain.com&quot; accessible via both HTTP and HTTPS connections, the name list should be something like: <blockquote> www.mydomain.com:80, www.mydomain.com:443 </blockquote>');
$this->db['dynReqPerSec'] = new DATTR_HELP_ITEM("Dynamic Requests/Second", 'Specifies the maximum number of requests to dynamically generated content coming from a single IP address that can be processed in each second regardless of the number of connections established. When this limit is reached, all future requests to dynamic content are tar-pitted until the next second.<br/><br/>The request limit for static content is independent of this limit. This per client request limit can be set at server or virtual host level. Virtual host-level settings override server-level settings.', ' Trusted IPs or sub-networks are not restrained by this limit.', 'Integer number', '');
$this->db['enableBrCompress'] = new DATTR_HELP_ITEM("Brotli Compression Level (Dynamic Content)", 'Controls the level of Brotli compression applied to dynamic responses. Ranges from 0 (OFF) to 6 (highest).<br/><br/>This setting will only take effect when &quot;Enable Compression&quot; is enabled.<br/><br/>Default value: 2', '', 'Number between 0 and 6.', '');
$this->db['enableCensorship'] = new DATTR_HELP_ITEM("Enable WAF", 'Specifies whether to enable request content deep inspection. This feature is equivalent to Apache&#039;s mod_security, which can be used to detect and block requests with ill intention by matching them to known signatures.', '', 'Select from radio box', '');
$this->db['enableChroot'] = new DATTR_HELP_ITEM("Enable chroot", 'Enterprise Edition Only Specifies whether to start the server in chroot mode. The new root directory is set by &quot;Chroot Path&quot; during installation.', '', 'Select from radio box', '');
$this->db['enableCoreDump'] = new DATTR_HELP_ITEM("Enable Core Dump", 'Specifies whether to enable core dump when the server is started by &quot;root&quot; user.  For most modern Unix systems, processes that change user ID or group ID are not allowed to  dump a core file for security reasons. However, it is much easier to identify root  cause of a problem with a core dump. This option only works on Linux kernel 2.4 and up.   Solaris users should use the coreadm command to control this feature.', ' Only enable this when you see no core file created in   the server log file. Disable it immediately after producing the core file.   Please submit a bug report when a core dump has been created.', 'Select from radio box', '');
$this->db['enableDHE'] = new DATTR_HELP_ITEM("Enable DH Key Exchange", 'Allows use of Diffie-Hellman key exchange for further SSL encryption.', ' DH key exchange is more secure than using just an RSA key. ECDH and DH key exchange are equally secure.<br/><br/> Enabling DH key exchange will increase CPU load and is slower than ECDH key exchange and RSA. ECDH key exchange is preferred when available.', 'Select from radio box', '');
$this->db['enableDynGzipCompress'] = new DATTR_HELP_ITEM("Enable GZIP Dynamic Compression", 'Controls GZIP compression for dynamically generated responses.<br/><br/>For this setting to have an effect, &quot;Enable Compression&quot; must be set to Yes.<br/><br/>Default value: Yes', ' Compressing dynamic responses increases CPU and memory utilization but saves network bandwidth.', 'Select from radio box', '');
$this->db['enableECDHE'] = new DATTR_HELP_ITEM("Enable ECDH Key Exchange", 'Allows use of Elliptic Curve Diffie-Hellman key exchange for further SSL encryption.', ' ECDH key exchange is more secure than using just an RSA key. ECDH and DH key exchange are equally secure.<br/><br/> Enabling ECDH key exchange will increase CPU load and is slower than using just an RSA key.', 'Select from radio box', '');
$this->db['enableExpires'] = new DATTR_HELP_ITEM("Enable Expires", 'Specifies whether to generate an Expires header for static files. If enabled, an Expires header will be generated based on &quot;Expires Default&quot; and &quot;Expires By Type&quot;.<br/><br/>This can be set at server, virtual host and context level. Lower level settings will override higher level ones, i.e. context settings will override virtual host settings and virtual host settings will override server settings.', '', 'Select from radio box', '');
$this->db['enableFrontPage'] = new DATTR_HELP_ITEM("Enable", 'Specifies whether to enable Microsoft FrontPage Server Extensions. When enabled, Microsoft FrontPage can be used to  publish web content. A web administration console is available at URL http://your.domain/_vti_bin/_vti_adm/fpadmcgi.exe.<br/><br/>Additional FrontPage Server Extensions packages must be installed in order to make this work properly.', '', 'Select from radio box', '');
$this->db['enableGzipCompress'] = new DATTR_HELP_ITEM("Enable Compression", 'Enables GZIP/Brotli compression for both static and dynamic responses.<br/><br/>Default value: Yes', ' Enable it to save network bandwidth. Text-based responses such as html, css, and javascript files benefit the most and on average can be compressed to half of their original size.', 'Select from radio box', '');
$this->db['enableHotlinkCtrl'] = new DATTR_HELP_ITEM("Enable Hotlink Protection", 'Specifies whether to activate hotlink protection.', '', 'Select from radio box', '');
$this->db['enableIpGeo'] = new DATTR_HELP_ITEM("Enable GeoLocation Lookup", 'Enterprise Edition Only Specifies whether to enable/disable IP Geolocation lookup. Can be set at server, virtual host, or context level. IP Geolocation is disabled by default when using value &quot;Not Set&quot;.', '', 'Select from radio box', '');
$this->db['enableLVE'] = new DATTR_HELP_ITEM("Cloud-Linux", 'Specifies whether to enable CloudLinux&#039;s Lightweight Virtual Environment (LVE) when it exists. You can use LiteSpeed with LVE to achieve better resource management. For more information, please check <a href="http://www.cloudlinux.com" target="_blank" rel="noopener noreferrer">http://www.cloudlinux.com</a>.', '', 'Select from drop down list', '');
$this->db['enableRailsHosting'] = new DATTR_HELP_ITEM("Enable Shared Hosting", 'Specifies whether to enable Rack/Rails shared hosting. The default is &quot;Disabled&quot;.', '', 'Select from radio box', '');
$this->db['enableRecaptcha'] = new DATTR_HELP_ITEM("Enable reCAPTCHA", 'Enable the reCAPTCHA Protection feature at the current level. This setting must be set to Yes at the Server level before the reCAPTCHA Protection feature can be used.<br/><br/>Default values:<br/><b>Server-level:</b> No<br/><b>VH-Level:</b> Inherit Server level setting', '', 'Select from radio box', '');
$this->db['enableRewrite'] = new DATTR_HELP_ITEM("Enable Rewrite", 'Specifies whether to enable LiteSpeed&#039;s URL rewrite engine. This option can be customized at the virtual host or context level, and is inherited along the directory tree until it is explicitly overridden.', '', 'Select from radio box', '');
$this->db['enableScript'] = new DATTR_HELP_ITEM("Enable Script", 'Specifies whether scripting (non-static pages) is allowed in this virtual host. If disabled, CGI, FastCGI, LSAPI, Servlet engines and other scripting languages will not be allowed in this virtual host. Therefore, if you want to use a script handler, you need to enable it here as well.', '', 'Select from radio box', '');
$this->db['enableSpdy'] = new DATTR_HELP_ITEM("ALPN", 'Selectively enable HTTP/3, HTTP/2, and SPDY HTTP network protocols.<br/><br/>If you wish to disable SPDY, HTTP/2, and HTTP3, check &quot;None&quot; and leave all other boxes unchecked.<br/><br/>Default value: All enabled', 'This setting can be set at the listener and virtual host levels.', 'Select from checkbox', '');
$this->db['enableStapling'] = new DATTR_HELP_ITEM("Enable OCSP Stapling", 'Determines whether to enable OCSP stapling, a more efficient way of verifying public key certificates.', '', 'Select from radio box', '');
$this->db['enableh2c'] = new DATTR_HELP_ITEM("Enable HTTP/2 Over Cleartext TCP", 'Specifies whether to enable HTTP/2 over non-encrypted TCP connections. Default is disabled.', '', 'Select from radio box', '');
$this->db['env'] = new DATTR_HELP_ITEM("Environment", 'Specifies extra environment variables for the external application.', '', 'Key=value. Multiple variables can be separated by &quot;ENTER&quot;', '');
$this->db['errCode'] = new DATTR_HELP_ITEM("Error Code", 'Specifies the HTTP status code for the error page. Only the selected HTTP status code will have this customized error page.', '', 'Select from drop down list', '');
$this->db['errPage'] = new DATTR_HELP_ITEM("Customized Error Pages", 'Whenever the server has a problem processing a request, the server will return an error code and an html page as an error message to the web client. Error codes are defined in the HTTP protocol (see RFC 2616). LiteSpeed web server has a built-in default error page for each error code, but a customized page can be configured for each error code as well. These error pages can be even further customized to be unique for each virtual host.', '', '', '');
$this->db['errURL'] = new DATTR_HELP_ITEM("URL", 'Specifies the URL of the customized error page. The server will forward the request to this URL when the corresponding HTTP status code has returned. If this URL refers to a non-existing resource, the built-in error page will be used. The URL can be a static file, a dynamically generated page, or a page on another web site (a URL starting with &quot;http(s)://&quot;). When referring to a page on another web site, the client will receive a redirect status code instead of the original status code.', '', 'URL', '');
$this->db['expWSAddress'] = new DATTR_HELP_ITEM("Address", 'HTTP,HTTPS, or Unix Domain Sockets (UDS) address used by the external web server.', ' If you proxy to another web server running on the same machine using an IPv4/IPv6 address, set the IP address to localhost or 127.0.0.1, so the external application is inaccessible from other machines.<br/> Unix Domain Sockets generally provide higher performance than IPv4 or IPv6 sockets.', 'IPv4/IPv6 address(:port), UDS://path, or unix:path. Add &quot;https://&quot; in front of an IPv4/IPv6 address if the external web server uses HTTPS. Port is optional for IPv4/IPv6 addresses if the external web server uses the standard ports 80 or 443.', '192.168.0.10<br/>127.0.0.1:5434<br/>https://10.0.8.9<br/>https://127.0.0.1:5438<br/>UDS://tmp/lshttpd/php.sock<br/>unix:/tmp/lshttpd/php.sock');
$this->db['expiresByType'] = new DATTR_HELP_ITEM("Expires By Type", 'Specifies Expires header settings for individual MIME types.', '', 'Comma delimited list of &quot;MIME-type=A|Mseconds&quot;. The file will expire after base time (A|M) plus specified seconds.<br/><br/>Base time &quot;A&quot; sets the value to the client&#039;s access time and &quot;M&quot; to the file&#039;s last modified time. MIME-type accepts wildcard &quot;*&quot;, like image/*.', '');
$this->db['expiresDefault'] = new DATTR_HELP_ITEM("Expires Default", 'Specifies default settings for Expires header generation. This setting takes effect when &quot;Enable Expires&quot; is set to &quot;Yes&quot;. It can be overridden by &quot;Expires By Type&quot;. Do not set this default at the server or virtual host level unless you have to, since it will generate Expires headers for all pages. Most of time this should be set at the context level for certain directories that do not change often. If there is no default setting, no Expires header will be generated for types not specified in &quot;Expires By Type&quot;.', '', 'A|Mseconds<br/>The file will expire after base time(A|M) plus specified seconds. Base time &quot;A&quot; sets the value to the client&#039;s access time and &quot;M&quot; to the file&#039;s last modified time.', '');
$this->db['expuri'] = new DATTR_HELP_ITEM("URI", 'Specifies the URI for this context.', '', 'The URI can be a plain URI (starting with &quot;/&quot;) or a Perl compatible regular expression URI (starting with &quot;exp:&quot;). If a plain URI ends with a &quot;/&quot;, then this context will include all sub-URIs under this URI. If the context maps to a directory on the file system, a trailing &quot;/&quot; must be added.', '');
$this->db['extAppAbort'] = new DATTR_HELP_ITEM("External Application Abort", 'When a client breaks a connection with the server, LiteSpeed Web Server can automatically abort external application processes generating responses for that client. Some users, however, may have (long-running) processes that they wish to continue running whether or not the client is still connected.<br/><br/>There are three options for this:<br/><ul>   <li>No Abort: Never abort external applications because of a broken connection.</li>   <li>     Enable Abort for Requests from External IPs: Only processes started by requests from external IPs will be automatically     aborted because of a broken connection. This is the default setting. It is a good setting if you have some internal     long-running processes, like some cron jobs.   </li>   <li>     Enable Abort for All Requests: External application processes will be automatically aborted if the connection is broken,     regardless of the source of the request.   </li> </ul>', '', 'Select from drop down list', '');
$this->db['extAppAddress'] = new DATTR_HELP_ITEM("Address", 'A unique socket address used by the external application. IPv4/IPv6 sockets and Unix Domain Sockets (UDS) are supported. IPv4/IPv6 sockets can be used for communication over the network. UDS can only be used when the external application resides on the same machine as the server.', ' If the external application runs on the same machine, UDS is preferred. If you have to use an IPv4|IPV6 socket, set the IP address to localhost or 127.0.0.1, so the external application is inaccessible from other machines.<br/> Unix Domain Sockets generally provide higher performance than IPv4 sockets.', 'IPv4 or IPV6 address:port or UDS://path', '127.0.0.1:5434<br/>UDS://tmp/lshttpd/php.sock.');
$this->db['extAppName'] = new DATTR_HELP_ITEM("Name", 'A unique name for this external application. You will refer to it by this name when you use it in other parts of the configuration.', '', '', '');
$this->db['extAppPath'] = new DATTR_HELP_ITEM("Command", 'Specifies the full command line including parameters to execute the external application. Required value if &quot;Start By Server&quot; is enabled. A parameter should be quoted with a double or single quote if the parameter contains space or tab characters.', '', 'Full path to the executable with optional parameters.', '');
$this->db['extAppPriority'] = new DATTR_HELP_ITEM("Priority", 'Specifies priority of the external application process. Value ranges from -20 to 20. A lower number means a higher priority. An external application process cannot have a higher priority than the web server. If this priority is set to a lower number than the server&#039;s, the server&#039;s priority will be used for this value.', '', 'int', '');
$this->db['extAppType'] = new DATTR_HELP_ITEM("Type", 'Specifies the type of external application. Application types are differentiated by the service they provide or the protocol they use to communicate with the server. Choose from <ul>   <li>FastCGI: a FastCGI application with a Responder role.</li>   <li>FastCGI Authorizer: a FastCGI application with an Authorizer role</li>   <li>Servlet Engine: a servlet engine with an AJPv13 connector, such as Tomcat.</li>   <li>Web Server: a web server or application server that supports HTTP protocol.</li>   <li>LiteSpeed SAPI App: an application that communicates with the web server using LSAPI protocol.</li>   <li>Load Balancer: a virtual application that can balance load among worker applications.</li>   <li>Piped Logger: an application that can process access log entries received on its STDIN stream.</li> </ul>', 'Most applications will use either LSAPI or FastCGI protocol. LSAPI supports PHP, Ruby, and Python. Perl can be used with FastCGI. (PHP, Ruby, and Python can also be set up to run using FastCGI, but they run faster using LSAPI.) Java uses servlet engines.', 'Select from drop down list', '');
$this->db['extAuthorizer'] = new DATTR_HELP_ITEM("Authorizer", 'Specifies an external application that can be used to generate authorized/unauthorized decisions. Currently, only the FastCGI Authorizer is available. For more details about the FastCGI Authorizer role, please visit <a href="   https://fastcgi-archives.github.io/ " target="_blank" rel="noopener noreferrer">   https://fastcgi-archives.github.io/ </a>.', '', 'Select from drop down list', '');
$this->db['extGroup'] = new DATTR_HELP_ITEM("Run As Group", 'The external application will run as this specified group name. If not set, Virtual Host level settings will be inherited.<br/><br/>Default value: Not Set', '', 'Valid group name.', '');
$this->db['extMaxIdleTime'] = new DATTR_HELP_ITEM("Max Idle Time", 'Specifies the maximum idle time before an external application is stopped by the server, freeing idle resources. When set to &quot;-1&quot;, the external application will not be stopped by the server unless running in ProcessGroup mode where idle external applications will be stopped after 30 seconds.<br/><br/>Default value: -1{/val}', ' This feature is especially useful in the mass hosting environment where, in order to prevent files owned by one virtual host from being accessed by the external application scripts of another virtual host, many different applications are run at the same time in SetUID mode. Set this value low to prevent these external applications from idling unnecessarily.', 'Integer number', '');
$this->db['extUmask'] = new DATTR_HELP_ITEM("umask", 'Sets default umask for this external application&#039;s processes. See  man 2 umask  for details. The default value taken from the server-level &quot;umask&quot; setting.', '', 'value valid range [000]-[777].', '');
$this->db['extUser'] = new DATTR_HELP_ITEM("Run As User", 'The external application will run as this specified user name. If not set, Virtual Host level settings will be inherited.<br/><br/>Default value: Not Set', '', 'Valid username.', '');
$this->db['extWorkers'] = new DATTR_HELP_ITEM("Workers", 'List of worker groups previously defined in the external load balancer.', '', 'A comma-separated list in the form ExternalAppType::ExternalAppName', 'fcgi::localPHP, proxy::backend1');
$this->db['externalredirect'] = new DATTR_HELP_ITEM("External Redirect", 'Specifies whether this redirect is external. For external redirection, &quot;Status Code&quot; may be specified and &quot;Destination URI&quot; can start either with &quot;/&quot; or &quot;http(s)://&quot;. For internal redirection, &quot;Destination URI&quot; must start with &quot;/&quot;.', '', '', '');
$this->db['extraHeaders'] = new DATTR_HELP_ITEM("Header Operations", 'Specifies additional response/request headers to be added. Multiple header directives can be added with one directive per line. &quot;NONE&quot; can be used to disable parent header inheritance. If no directive is provided &#039;Header&#039; is assumed.', ' Syntax and usage are similar to <a href="https://httpd.apache.org/docs/2.2/mod/mod_headers.html#header" target="_blank" rel="noopener noreferrer">Apache&#039;s mod_headers directives</a> for supported operations.<br/><br/> The &#039;Header&#039; directive is is optional and can be excluded or left in when copying rules from elsewhere without issue.', '[Header]|RequestHeader [condition] set|append|merge|add|unset header [value] [early|env=[!]variable]', 'set Cache-control no-cache<br/>append Cache-control no-store<br/>Header set My-header cust_header_val<br/>RequestHeader set My-req-header cust_req_header_val');
$this->db['fcgiContext'] = new DATTR_HELP_ITEM("FastCGI Context", 'FastCGI applications cannot be used directly. A FastCGI application must be either configured as a script handler or mapped to a URL through FastCGI context. A FastCGI context will associate a URI with a FastCGI application.', '', '', '');
$this->db['fcgiapp'] = new DATTR_HELP_ITEM("FastCGI App", 'Specifies the name of the FastCGI application. This application must be defined in the &quot;External Apps&quot; section at the server or virtual host level.', '', 'Select from drop down list', '');
$this->db['fileETag'] = new DATTR_HELP_ITEM("File ETag", 'Specifies whether to use a file&#039;s inode, last-modified time, and size attributes to generate the ETag HTTP response header for static files. All three attributes are enabled by default. If you plan to serve the same file out of mirrored servers, you should not include inode; otherwise, the ETag generated for one file will be different on different servers.', '', 'Select from checkbox', '');
$this->db['followSymbolLink'] = new DATTR_HELP_ITEM("Follow Symbolic Link", 'Specifies the server-level default setting of following symbolic links when serving static files.<br/><br/>Choices are Yes, If Owner Match and No.<br/><br/>Yes sets the server to always follow symbolic links. If Owner Match sets the server to follow a symbolic link only if the owner of the link and of the target are same. No means the server will never follow a symbolic link. This setting can be overridden in the virtual host configurations but cannot be overridden from an .htaccess file.', ' For best security select No or If Owner Match. For best performance, select Yes.', 'Select from drop down list', '');
$this->db['forceGID'] = new DATTR_HELP_ITEM("Force GID", 'Specifies a group ID to be used for all external applications started in suEXEC mode. When set to non-zero value, all suEXEC external applications (CGI/FastCGI/LSAPI) will use this group ID. This can be used to prevent an external application from accessing files owned by other users.<br/><br/>For example, in a shared hosting environment, LiteSpeed runs as user &quot;www-data&quot;, group &quot;www-data&quot;. Each docroot is owned by a user account, with a group of &quot;www-data&quot; and permission mode 0750. If Force GID is set to &quot;nogroup&quot; (or any group other than &#039;www-data&#039;), all suEXEC external applications will run as a particular user but in the group &quot;nogroup&quot;. These external application processes will still be able to access files owned by that particular user (because of their user ID), but will not have group permission to access anyone else&#039;s files. The server, on the other hand, still can serve files under any user&#039;s docroot directory (because of its group ID).', ' Set it high enough to exclude all groups used by system users.', 'Integer number', '');
$this->db['forceSecureCookie'] = new DATTR_HELP_ITEM("Secure Cookie Control", 'Control whether to send cookies with the flag &quot;secure&quot;, attribute &quot;SameSite=Strict&quot;, and attribute &quot;SameSite=Lax&quot;.<br/><br/>If both &quot;SameSite=Strict&quot; and &quot;SameSite=Lax&quot; are selected, &quot;SameSite=Strict&quot; will be used.<br/><br/>Default value: &quot;secure&quot;', '', 'Select from checkbox', '');
$this->db['forceStrictOwnership'] = new DATTR_HELP_ITEM("Force Strict Ownership Checking", 'Specifies whether to enforce strict file ownership checking. If it is enabled, the web server will check if the owner of the file being served is the same as the owner of the virtual host. If it is different, a 403 Access Denied Error will be returned. This is turned off by default.', ' For shared hosting, enable this check for better security.', 'Select from radio box', '');
$this->db['forceType'] = new DATTR_HELP_ITEM("Force MIME Type", 'When specified, all files under this context will be served as 	   static files with the MIME type specified regardless of file suffix. 	   When set to NONE, inherited force type setting will be 	   disabled.', '', 'MIME type or NONE.', '');
$this->db['gdb_groupname'] = new DATTR_HELP_ITEM("Group Name", 'A group name containing only letters and numbers (no special characters).', '', 'string', '');
$this->db['gdb_users'] = new DATTR_HELP_ITEM("Users", 'Space separated list of users belonging to this group.', '', '', '');
$this->db['generalContext'] = new DATTR_HELP_ITEM("Static Context", 'Context settings are used to specify special settings for files in a certain location. These settings can be used to bring in files outside of the document root (like Apache&#039;s Alias or AliasMatch directives), to protect a particular directory using authorization realms, or to block or restrict access to a particular directory within the document root.', '', '', '');
$this->db['geoipDBFile'] = new DATTR_HELP_ITEM("DB File Path", 'Specifies the path to MaxMind GeoIP database.', '', 'Absolute path', '/usr/local/share/GeoIP/GeoLite2-Country.mmdb');
$this->db['geoipDBName'] = new DATTR_HELP_ITEM("DB Name", 'MaxMind GeoIP database name. As of GeoIP2, this setting is required.<br/><br/>When upgrading from a GeoIP to a GeoIP2, using values &quot;COUNTRY_DB&quot;, &quot;CITY_DB&quot;, or &quot;ASN_DB&quot; for this setting will automatically populate PHP&#039;s $_SERVER variable with some GeoIP compatible entries (listed by DB Name value below) to help ease this transition.<br/><br/><b>CITY_DB:</b> &#039;GEOIP_COUNTRY_CODE&#039;, &#039;GEOIP_COUNTRY_NAME&#039;, &#039;GEOIP_CONTINENT_CODE&#039;, &#039;GEOIP_COUNTRY_CONTINENT&#039;, &#039;GEOIP_DMA_CODE&#039;, &#039;GEOIP_METRO_CODE&#039;, &#039;GEOIP_LATITUDE&#039;, &#039;GEOIP_LONGITUDE&#039;, &#039;GEOIP_POSTAL_CODE&#039;, and &#039;GEOIP_CITY&#039;.<br/><b>COUNTRY_DB:</b> &#039;GEOIP_COUNTRY_CODE&#039;, &#039;GEOIP_COUNTRY_NAME&#039;, &#039;GEOIP_CONTINENT_CODE&#039;, and &#039;GEOIP_COUNTRY_CONTINENT&#039;.<br/><b>ASN_DB:</b> &#039;GEOIP_ORGANIZATION&#039; and &#039;GEOIP_ISP&#039;.', '', '', 'COUNTRY_DB');
$this->db['geolocationDB'] = new DATTR_HELP_ITEM("MaxMind GeoIP DB", 'Multiple MaxMind geolocation databases can be specified here. MaxMind has the following type of DBs: Country, Region, City, Organization, ISP and Netspeed. If multiple databases of types &quot;Country&quot;, &quot;Region&quot;, and &quot;City&quot; are configured, the last configuration will be effective.', '', '', '');
$this->db['gracePeriod'] = new DATTR_HELP_ITEM("Grace Period (sec)", 'Specifies how long new connections can be accepted after the number of connections established from one IP is over the &quot;Connection Soft Limit&quot;. Within this period, new connections will be accepted if the total connections is still below the &quot;Connection Hard Limit&quot;. After this period has elapsed, if the number of connections still higher than the &quot;Connection Soft Limit&quot;, then the offending IP will be blocked for the &quot;Banned Period (sec)&quot;.', ' Set to a proper number big enough for downloading a complete page but low enough to prevent deliberate attacks.', 'Integer number', '');
$this->db['gracefulRestartTimeout'] = new DATTR_HELP_ITEM("Graceful Restart Timeout (secs)", 'During a graceful restart, even after the new server instance is up, the old instance will continue to handle existing requests. This timeout defines how long the previous instance shall wait before exit. Default value is 300 seconds. -1 means wait forever. 0 means no wait and abort immediately.', '', 'int', '');
$this->db['groupDBCacheTimeout'] = new DATTR_HELP_ITEM("Group DB Cache Timeout (secs)", 'Specifies how often the backend group database will be checked for changes. For more detail please refer to &quot;User DB Cache Timeout (secs)&quot;.', '', 'Integer number', '');
$this->db['groupDBMaxCacheSize'] = new DATTR_HELP_ITEM("Group DB Max Cache Size", 'Specifies the maximum cache size of the group database.', ' As a larger cache will consume more memory, a higher value may or may not provide better performance. Set it to an appropriate size according to your user database size and site usage.', 'Integer number', '');
$this->db['groupDB_attrGroupMember'] = new DATTR_HELP_ITEM("Group Member Attribute", 'Specifies the name of the &quot;Member&quot; attribute for a group record stored in an LDAP server. The default value is memberUid.', '', 'string', '');
$this->db['gzipAutoUpdateStatic'] = new DATTR_HELP_ITEM("Auto Update Static File", 'Specifies whether to let the server automatically create/update GZIP/Brotli-compressed versions of compressible static files or not. If set to Yes, when a file with a MIME type listed in &quot;Compressible Types&quot; is requested, the server may create or update the corresponding compressed version of the file depending on the compressed file&#039;s timestamp. This compressed file is created under the &quot;Static Cache Directory&quot;. The filename is based on a MD5 hash of the path of the original file.<br/><br/>Default value: Yes', '', 'Select from radio box', '');
$this->db['gzipCacheDir'] = new DATTR_HELP_ITEM("Static Cache Directory", 'Specifies the path of the directory used to store compressed files for static content.<br/><br/>Default value: &quot;Swapping Directory&quot;.', '', 'Directory Path', '');
$this->db['gzipCompressLevel'] = new DATTR_HELP_ITEM("GZIP Compression Level (Dynamic Content)", 'Specifies the level of GZIP compression applied to dynamic content. Ranges from 1 (lowest) to 9 (highest).<br/><br/>This setting will only take effect when &quot;Enable Compression&quot; and &quot;Enable GZIP Dynamic Compression&quot; are enabled.<br/><br/>Default value: 6', ' Higher compression level will use more memory and CPU cycles. You can set it to a higher level if your machine has additional power. There is not much difference between 6 and 9, except that 9 uses many more CPU cycles.', 'Number between 1 and 9.', '');
$this->db['gzipMaxFileSize'] = new DATTR_HELP_ITEM("Max Static File Size (bytes)", 'Specifies the maximum size of a static file for which the server will create a compressed file automatically.<br/><br/>Default value: 10M', ' It is not recommended to have the server create/update compressed files for large files. Compressing blocks an entire server process and no further requests can be processed until the compression is completed.', 'Number in bytes not less than 1K.', '');
$this->db['gzipMinFileSize'] = new DATTR_HELP_ITEM("Min Static File Size (bytes)", 'Specifies the minimum size of a static file for which the server will create a corresponding compressed file.<br/><br/>Default value: 200', 'It is not necessary to compress very small files as the bandwidth saving is negligible.', 'Number in bytes not less than 200.', '');
$this->db['gzipStaticCompressLevel'] = new DATTR_HELP_ITEM("GZIP Compression Level (Static File)", 'Specifies the level of GZIP compression applied to static files. Ranges from 1 (lowest) to 9 (highest).<br/><br/>This setting will only take effect when &quot;Enable Compression&quot; and &quot;Auto Update Static File&quot; are enabled.<br/><br/>Default value: 6', '', 'Number between 1 and 9.', '');
$this->db['hardLimit'] = new DATTR_HELP_ITEM("Connection Hard Limit", 'Specifies the maximum number of allowed concurrent connections from a single IP address. This limit is always enforced and a client will never be able to exceed this limit. HTTP/1.0 clients usually try to set up as many connections as they need to download embedded content at the same time. This limit should be set high enough so that HTTP/1.0 clients can still access the site. Use &quot;Connection Soft Limit&quot; to set the desired connection limit.<br/><br/>The recommended limit is between 20 and 50 depending on the content of your web page and your traffic load.', ' A lower number will enable serving more distinct clients.<br/> Trusted IPs or sub-networks are not affected.<br/> Set to a high value when you are performing benchmark tests with a large number of concurrent client machines.', 'Integer number', '');
$this->db['hideSigInErrorPage'] = new DATTR_HELP_ITEM("Hide Error Page Signature", 'Specifies whether or not to show the lines <blockquote>Powered By LiteSpeed.<br/>LiteSpeed Technologies is not responsible for administration and contents of this web site!&quot;</blockquote> on your default error pages.', '', 'Select from radio box', '');
$this->db['htaccess'] = new DATTR_HELP_ITEM("HT Access", 'The following directives are supported in a directory level access control file (.htaccess file).<br/><ul>   <li>     Authentication     <ul>       <li>AuthGroupFile</li>       <li>AuthName</li>       <li>AuthType</li>       <li>AuthUserFile</li>       <li>Require</li>       <li>Satisfy</li>       <li>&lt;Limit&gt; (GET, HEAD, POST only)</li>       <li>&lt;LimitExcept&gt; (GET, HEAD, POST only)</li>     </ul>   </li>   <li>     Access Control     <ul>       <li>Allow</li>       <li>Deny</li>       <li>Order</li>       <li>&lt;Limit&gt; (GET, HEAD, POST only)</li>       <li>&lt;LimitExcept&gt; (GET, HEAD, POST only)</li>     </ul>   </li>   <li>     File Info     <ul>       <li>AddDefaultCharset</li>       <li>AddType</li>       <li>DefaultType</li>       <li>ForceType</li>       <li>Redirect</li>       <li>RedirectPermanent</li>       <li>RedirectTemp</li>       <li>RewriteBase</li>       <li>RewriteCond</li>       <li>RewriteEngine</li>       <li>RewriteOptions</li>       <li>RewriteRule</li>     </ul>   </li>   <li>     Other     <ul>       <li>DirectoryIndex</li>       <li>ExpiresActive</li>       <li>ExpiresByType</li>       <li>ExpiresDefault</li>       <li>Options</li>     </ul>   </li> </ul>', '', '', '');
$this->db['id'] = new DATTR_HELP_ITEM("Handler ID", 'A unique ID used to associate this PHP handler&#039;s command to it&#039;s handled suffixes. The ID itself will also be treated as a handled suffix.<br/><br/>Well known IDs include &quot;phpXX&quot;, &quot;alt-phpXX&quot;, and &quot;ea-phpXX&quot;.', ' When adding a handler with ID &quot;php72&quot;, files with suffix &quot;.php72&quot; as well as MIME type &quot;application/x-httpd-php72&quot; will be automatically handled by this handler.', '', 'php72');
$this->db['inBandwidth'] = new DATTR_HELP_ITEM("Inbound Bandwidth (bytes/sec)", 'The maximum allowed incoming throughput from a single IP address, regardless of the number of connections established. The real bandwidth may end up being slightly higher than this setting for efficiency reasons. Bandwidth is allocated in 1KB units. Set to 0 to disable throttling. Per-client bandwidth limits (bytes/sec) can be set at the server or virtual host level where virtual host level settings override server level settings.', ' Trusted IPs or sub-networks are not affected.', 'Integer number', '');
$this->db['inMemBufSize'] = new DATTR_HELP_ITEM("Max I/O Buffer Size", 'Specifies the maximum buffer size that is used to store a request body and its dynamically generated response. When this limit is reached, the server will start to create temporary swapping files under &quot;Swapping Directory&quot;.', ' Set the buffer size large enough to accommodate all concurrent requests/replies to avoid memory to disk swapping. If there is frequent I/O activity to the swap directoy, by default /tmp/lshttpd/swap/, this buffer size is too low and LiteSpeed is swapping to disk.', 'Integer number', '');
$this->db['indexFiles'] = new DATTR_HELP_ITEM("Index Files", 'Specifies names of index files that will be searched sequentially when a URL is mapped to a directory. You can customize it at the server, virtual host, and context level.', ' Only set index files that you need.', 'Comma-delimited list of index filenames.', '');
$this->db['indexUseServer'] = new DATTR_HELP_ITEM("Use Server Index Files", 'Specifies whether to use the server&#039;s index file settings. If set to Yes, only the server&#039;s settings will be used. If set to No, the server&#039;s settings will not be used. If set to Addition, additional index files can be added to server&#039;s index file list for this virtual host. If you want to disable index files for this virtual host, you can set the value to No and leave the index files field empty.', '', 'Select from drop down list', '');
$this->db['initTimeout'] = new DATTR_HELP_ITEM("Initial Request Timeout (secs)", 'Specifies the maximum time in seconds the server will wait for the external application to respond to the first request over a new established connection. If the server does not receive any data from the external application within this timeout limit, it will mark this connection as bad. This helps to identify communication problems with external applications as quickly as possible. If some requests take longer to process, increase this limit to avoid 503 error messages.', '', 'Integer number', '');
$this->db['instances'] = new DATTR_HELP_ITEM("Instances", 'Specifies the maximum instances of the external application the server will create. It is required if &quot;Start By Server&quot; is enabled. Most FastCGI/LSAPI applications can only process one request per process instance and for those types of applications, instances should be set to match the value of &quot;Max Connections&quot;. Some FastCGI/LSAPI applications can spawn multiple child processes to handle multiple requests concurrently. For these types of applications, instances should be set to &quot;1&quot; and environment variables used to control how many child processes the application can spawn.', '', 'Integer number', '');
$this->db['ip2locDBCache'] = new DATTR_HELP_ITEM("DB Cache Type", 'The caching method used. The default value is Memory.', '', 'Select from drop down list', '');
$this->db['ip2locDBFile'] = new DATTR_HELP_ITEM("IP2Location DB File Path", 'The location of a valid database file.', '', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');
$this->db['javaServletEngine'] = new DATTR_HELP_ITEM("Servlet Engine", 'Specifies the name of the servlet engine that serves this web application. Servlet engines must be defined in the &quot;External Apps&quot; section at the server or virtual host level.', '', 'Select from drop down list', '');
$this->db['javaWebAppContext'] = new DATTR_HELP_ITEM("Java Web App Context", 'Many people running Java applications use the servlet engine to serve static content as well. But no servlet engine is nearly as efficient as LiteSpeed Web Server for these processes. In order to improve the overall performance, LiteSpeed Web Server can be configured as a gateway server, which serves static content and forwards dynamic Java page requests to the servlet engine.<br/><br/>LiteSpeed Web Server requires certain contexts to be defined in order to run a Java application. A Java Web App Context automatically creates all required contexts based on the Java web application&#039;s configuration file (WEB-INF/web.xml).<br/><br/>There are a few points you need to keep in mind when setting up a Java Web App Context:<br/><ul> <li>A Servlet Engine external application must be set up in &quot;External Apps&quot; before Java Web App Context can be set up.<li> <li>A &quot;Script Handler&quot; for .jsp files should be defined as well.</li> <li>If the web application is packed into a .war file, the .war file must be expanded. The server cannot access compressed archive files.</li> <li>For the same resources, the same URL should be used no matter whether it is accessed through LiteSpeed Web Server or through the servlet engine&#039;s built-in HTTP server.<br/><br/>For example,   Tomcat 4.1 is installed under /opt/tomcat. Files for the &quot;examples&quot; web application are   located at /opt/tomcat/webapps/examples/. Through Tomcat&#039;s built-in HTTP server,   the &quot;examples&quot; web application is thus accessed with a URI like &quot;/examples/***&quot;.   The corresponding Java Web App Context should thus be configured:   &quot;URI&quot; = /examples/, &quot;Location&quot; = /opt/tomcat/webapps/examples/.</li>   </ul>', '', '', '');
$this->db['javaWebApp_location'] = new DATTR_HELP_ITEM("Location", 'Specifies the directory that contains the files for this web application. This is the directory containing &quot;WEB-INF/web.xml&quot;.<br/><br/>Default value: $DOC_ROOT + &quot;URI&quot;', '', 'path', '');
$this->db['jitConfig'] = new DATTR_HELP_ITEM("Just In Time Configuration", 'With just in time configuration, the web server only finalizes vhost configurations when that virtual host is accessed for the first time, instead of loading all configurations at start up. This allows the web server to save memory and speed up server start up.', '', 'Select from radio box', '');
$this->db['keepAliveTimeout'] = new DATTR_HELP_ITEM("Keep-Alive Timeout (secs)", 'Specifies the maximum idle time between requests from a keep-alive connection. If no new request is received during this period of time, the connection will be closed. This setting only applies to HTTP/1.1 connections. HTTP/2 connections have long keep-alive timeouts by design and are not affected by this setting.', ' We recommend that you set this value just long enough to wait for subsequent requests from  a client when there are more assets referenced by a single page that need to be loaded. Do not set this too long hoping that  the next page will be served over the keep-alive connection. Keeping many idle keep-alive connections is a waste of server resources and could be taken advantage of by (D)DoS attacks. 2-5 seconds is a  reasonable range for most applications. LiteSpeed is highly efficient in a non-keep-alive environment.', 'Integer number', '');
$this->db['keyFile'] = new DATTR_HELP_ITEM("Private Key File", 'The filename of the SSL private key file. The key file should not be encrypted.', ' The private key file should be placed in a secured directory that allows read-only access to the user the server runs as.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');
$this->db['lbContext'] = new DATTR_HELP_ITEM("Load Balancer Context", 'Like other external applications, load balancer worker applications cannot be used directly. They must be mapped to a URL through a context. A Load Balancer Context will associate a URI to be load balanced by the load balancer workers.', '', '', '');
$this->db['lbapp'] = new DATTR_HELP_ITEM("Load Balancer", 'Specifies the name of the load balancer to be associated to this context. This load balancer is a virtual application, and must be defined in the &quot;External Apps&quot; section at the server or virtual host level.', '', 'Select from drop down list', '');
$this->db['listenerBinding'] = new DATTR_HELP_ITEM("Binding", 'Enterprise Edition Only Specifies which lshttpd child process the listener is assigned to. Enterprise Edition spawns multiple child processes to take advantage of the multiple CPUs in a SMP system. Different child processes can be used to handle requests to different listeners by manually associating a listener with a process. By default, a listener is assigned to all child processes.', '', 'Select from checkbox', '');
$this->db['listenerIP'] = new DATTR_HELP_ITEM("IP Address", 'Specifies the IP of this listener. All available IP addresses are listed. IPv6 addresses are enclosed in &quot;[ ]&quot;.<br/><br/>To listen on all IPv4 IP addresses, select ANY. To listen on all IPv6 IP addresses, select [ANY] IPv6. If No is selected for setting &quot;Bind IPv6 Only&quot;, selecting [ANY] IPv6 will listen on IPv4 addresses as well.<br/><br/>By default, LiteSpeed uses separate listeners for IPv4 and IPv6 addresses. Should the need to serve both IPv4 and IPv6 arise, separate listeners should be created for each.', ' If your machine has multiple IPs on different sub-networks, you can select a specific IP to only allow traffic from the corresponding sub-network.', 'Select from drop down list', '');
$this->db['listenerName'] = new DATTR_HELP_ITEM("Listener Name", 'A unique name for this listener.', '', '', '');
$this->db['listenerPort'] = new DATTR_HELP_ITEM("Port", 'Specifies the TCP port of the listener. Only the super user (&quot;root&quot;) can use ports lower than 1024. Port 80 is the default HTTP port. Port 443 is the default HTTPS port.', '', 'Integer number', '');
$this->db['listenerSecure'] = new DATTR_HELP_ITEM("Secure", 'Specifies whether this is a secure (SSL) listener. For secure listeners, additional SSL settings need to be set properly.', '', 'Select from radio box', '');
$this->db['litemage'] = new DATTR_HELP_ITEM("Enable LiteMage", 'Enables LiteMage Cache for Magento Stores.<br/><br/>When set to &#039;On&#039; the server will also try to use shared private cache information to speed up page load time for first time visitors. Select &#039;Safe&#039; to disable this feature.', 'This setting will not work if your LiteSpeed license does not have the LiteMage module enabled.', 'Select from drop down list', '');
$this->db['lmap'] = new DATTR_HELP_ITEM("Virtual Hosts Mappings", 'Shows currently established mappings to virtual hosts from a particular listener.  The virtual host name appears in brackets and is followed by the matching domain name(s) for this listener.', 'If a virtual host has not been loaded successfully (fatal errors in the  virtual host configuration), the mapping to that virtual host will not be displayed.', '', '');
$this->db['lname'] = new DATTR_HELP_ITEM("Name - Listener", 'The unique name that identifies this listener. This is the  &quot;Listener Name&quot; you specified when setting up the listener.', '', '', '');
$this->db['loadApacheConf'] = new DATTR_HELP_ITEM("Load Apache Configuration", 'Specifies whether LiteSpeed will read and use a Apache configuration file to configure the web server. Native configurations will have higher priority when there is conflict between LiteSpeed internal and Apache-based configurations.', '', 'Select from radio box', '');
$this->db['location'] = new DATTR_HELP_ITEM("Location", 'Specifies the corresponding location of this context in the file system.<br/><br/>Default value: $DOC_ROOT + &quot;URI&quot;', '', 'It can be an absolute path or path relative to $SERVER_ROOT, $VH_ROOT, or $DOC_ROOT. $DOC_ROOT is the default relative path, and can be omitted.<br/><br/>If the &quot;URI&quot; is a regular expression, then the matched sub-string can be used to form the &quot;Root&quot; string. The matched sub-string can be referenced with the values &quot;$1&quot; - &quot;$9&quot;. &quot;$0&quot; and &quot;&&quot; can be used to reference the whole matched string. Additionally, a query string can be set by appending a &quot;?&quot; followed by the query string. Be careful. &quot;&&quot; should be escaped as &quot;\&&quot; in the query string.', 'A plain URI like /examples/ with &quot;Location&quot; set to /home/john/web_examples will map the request &quot;/examples/foo/bar.html&quot; to file &quot;/home/john/web_examples/foo/bar.html&quot;.<br/>To simulate Apache&#039;s mod_userdir, set URI to exp: ^/~([A-Za-z0-9]+)(.*), set &quot;Location&quot; to /home/$1/public_html$2. With these settings, a request of URI /~john/foo/bar.html will map to file /home/john/public_html/foo/bar.html.');
$this->db['logUseServer'] = new DATTR_HELP_ITEM("Use Server's Log", 'Specifies whether to put log messages from this virtual host into the server  log file instead of creating its own log file.', '', 'Select from radio box', '');
$this->db['log_compressArchive'] = new DATTR_HELP_ITEM("Compress Archive", 'Specifies whether to compress rotated log files in order to save disk space.', 'Log files are highly compressible and this is recommended to reduce disk usage for old logs.', 'Select from radio box', '');
$this->db['log_debugLevel'] = new DATTR_HELP_ITEM("Debug Level", 'Specifies the level of debug logging.  &quot;Log Level&quot; must be set to DEBUG to use this feature.  Debug logging is disabled when &quot;Debug Level&quot; is set to NONE even if &quot;Log Level&quot; is set to DEBUG.  &quot;Toggle Debug Logging&quot; can be used to control debug level on a live server without restarting.', ' Important! Always set this to NONE if you do not need detailed debug logging. Active debug logging will severely degrade service performance and potentially saturate disk space in a very short time. Debug logging includes detailed information for each request and response.<br/><br/>It&#039;s recommended to set Log Level to DEBUG and Debug Level to NONE.  These settings mean that you will not fill up your hard disk with debug logging,  but you will be able to use the &quot;Toggle Debug Logging&quot; action to control debug output.  This action can turn debug logging on and off on the fly, and is useful for debugging busy production servers.', 'Select from drop down list', '');
$this->db['log_enableAioLog'] = new DATTR_HELP_ITEM("Enable AIO Logging", 'Specifies whether to enable AIO logging for server log and access log. If enabled, asynchronous I/O will be used for writing log messages.', 'Enabling AIO logging can help overall server performance when server I/O wait is high.', 'Select from radio box', '');
$this->db['log_enableStderrLog'] = new DATTR_HELP_ITEM("Enable stderr Log", 'Specifies whether to write to log when receiving stderr output from processes started by the server.<br/><br/>If enabled, stderr messages will be logged in the same directory as the server log with the fixed name &quot;stderr.log&quot;. If disabled, all stderr output will be discarded.<br/><br/>Functions like PHP&#039;s error_log() which do not write directly to stderr (file handle 2) are not affected by this setting and will write to the file set in PHP ini directive &#039;error_log&#039; or the server&#039;s &quot;error.log&quot; file with tag &#039;[STDERR]&#039; if that directive is not set.', 'Turn it on if you need to debug configured external applications: i.e. PHP, Ruby, Java, Python, Perl.', 'Select from radio box', '');
$this->db['log_fileName'] = new DATTR_HELP_ITEM("File Name", 'Specifies the path for the log file.', ' Place the log file on a separate disk.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');
$this->db['log_keepDays'] = new DATTR_HELP_ITEM("Keep Days", 'Specifies how many days the access log file will be kept on disk.  Only rotated log files older than the specified number of days will be deleted. The current  log file will not be touched regardless how many days worth of data it contains.  If you do not want to auto-delete stale and very old log files, set this to 0.', '', 'Integer number', '');
$this->db['log_logLevel'] = new DATTR_HELP_ITEM("Log Level", 'Specifies the level of logging to include in your log file.  Available levels (from high to low) are: ERROR,  WARNING, NOTICE, INFO and DEBUG.  Only messages with level higher or equal to the current setting will be logged.', ' Using DEBUG log level does not have any performance impact, unless &quot;Debug Level&quot; is set to a level other than NONE. It&#039;s recommended to set Log Level to DEBUG and Debug Level to NONE. These settings mean that you will not fill up your  hard disk with debug logging, but you will be able to use the &quot;Toggle Debug Logging&quot;  action to control debug output. This action can turn debug logging on and off on the fly,   and is useful for debugging busy production servers.', 'Select from drop down list', '');
$this->db['log_rollingSize'] = new DATTR_HELP_ITEM("Rolling Size (bytes)", 'Specifies when the current log file needs to be rolled over, also known as log rotation.  When the file size is over the rollover limit, the active log file will be renamed  to log_name.mm_dd_yyyy(.sequence) in the same directory and a new active log file will be created. The actual size of the rotated log file once it is created will sometimes be a little bigger than  this size limit. Set to 0 to disable log rotation.', 'Append &quot;K&quot;, &quot;M&quot;, &quot;G&quot; to the number for kilo-, mega- and giga- bytes.', 'Integer number', '');
$this->db['lsapiContext'] = new DATTR_HELP_ITEM("LiteSpeed SAPI Context", 'External applications cannot be used directly. They must be either configured as a script handler or mapped to a URL through a context. An LiteSpeed SAPI Context will associate a URI with an LSAPI (LiteSpeed Server Application Programming Interface) application. Currently PHP, Ruby and Python have LSAPI modules. LSAPI, as it is developed specifically for LiteSpeed web server, is the most efficient way to communicate with LiteSpeed web server.', '', '', '');
$this->db['lsapiapp'] = new DATTR_HELP_ITEM("LiteSpeed SAPI App", 'Specifies the name of the LiteSpeed SAPI application to be connected to this context. This application must be defined in the &quot;External Apps&quot; section at the server or virtual host level.', '', 'Select from drop down list', '');
$this->db['lsrecaptcha'] = new DATTR_HELP_ITEM("reCAPTCHA Protection", 'reCAPTCHA Protection is a service provided as a way to mitigate heavy server load. reCAPTCHA Protection will activate after one of the below situations is hit. Once active, all requests by NON TRUSTED(as configured) clients will be redirected to a reCAPTCHA validation page. After validation, the client will be redirected to their desired page.<br/><br/>The following situations will activate reCAPTCHA Protection:<br/>1. The server or vhost concurrent requests count passes the configured connection limit.<br/>2. Anti-DDoS is enabled and a client is hitting a url in a suspicious manner. The client will redirect to reCAPTCHA first instead of getting denied when triggered.<br/>3. WordPress Brute Force Attack Protection is enabled and action is set to &#039;CAPTCHA or Drop’. When a brute force attack is detected, the client will redirect to reCAPTCHA first. After max tries is reached, the connection will be dropped, as per the ‘drop’ option.<br/>4. WordPress Brute Force Attack Protection is enabled and action is set to &#039;WP Login CAPTCHA Full Protection&#039;. The client will always redirect to reCAPTCHA first.<br/>5. A new rewrite rule environment is provided to activate reCAPTCHA via RewriteRules. &#039;verifycaptcha&#039; can be set to redirect clients to reCAPTCHA. A special value &#039;: deny&#039; can be set to deny the client if it failed too many times. For example, [E=verifycaptcha] will always redirect to reCAPTCHA until verified. [E=verifycaptcha: deny] will redirect to reCAPTCHA until Max Tries is hit, after which the client will be denied.', '', '', '');
$this->db['lstatus'] = new DATTR_HELP_ITEM("Status - Listener", 'The current status of this listener. The status is either Running or Error.', 'If the listener is in the Error state, you can view the server log to find out why.', '', '');
$this->db['lswsProcesses'] = new DATTR_HELP_ITEM("Number of Processes", '<b>[Only Available For Web Host Elite Licenses]</b> <br /> Specifies the number of lshttpd workers. Enter 0 to have this number be decided automatically.', ' Set an appropriate number to suit your needs. Adding more processes may not necessarily mean better performance.', 'Integer value between 0 and 128.', '');
$this->db['mappedListeners'] = new DATTR_HELP_ITEM("Mapped Listeners", 'Specifies the names of all listeners that this template maps to. A listener-to-virtual host mapping for this template&#039;s member virtual hosts will be added to the listeners specified in this field. This mapping will map listeners to virtual hosts based on the domain names and aliases set in the member virtual hosts&#039; individual configurations.', '', 'comma-separated list', '');
$this->db['matchedHosts'] = new DATTR_HELP_ITEM("REGEX Matched Domains", 'Specifies web sites that can link to protected content in regular expressions. The regular expression will match the domain name only and not the full URL.', '', 'Regular expressions', '^.*\.mydomain\.com$');
$this->db['maxCGIInstances'] = new DATTR_HELP_ITEM("Max CGI Instances", 'Specifies the maximum number of concurrent CGI processes the server can start. For each request to a CGI script, the server needs to start a standalone CGI process. On a Unix system, the number of concurrent processes is limited. Excessive concurrent processes will degrade the performance of the whole system and are one way to perform a DoS attack. LiteSpeed server pipelines requests to CGI scripts and limits concurrent CGI processes to ensure the optimal performance and reliability. The hard limit is 2000.', ' A higher limit does not necessarily translate to faster performance. In most cases, a lower limit gives better performance and security. A higher limit will only help when I/O latency is excessive during CGI processing.', 'Integer number', '');
$this->db['maxCachedFileSize'] = new DATTR_HELP_ITEM("Max Cached Small File Size (bytes)", 'Specifies the largest static file that will be cached in a pre-allocated memory buffer. Static files can be served in four different ways: memory buffer cache, memory-mapped cache, plain read/write, and sendfile(). Files whose size is smaller than this setting are served from memory buffer cache. Files whose size is larger than this setting, but smaller than the &quot;Max MMAP File Size (bytes)&quot; will be served from memory-mapped cache. Files whose size is larger than the &quot;Max MMAP File Size (bytes)&quot; will be served via plain read/write or sendfile(). It is optimal to serve static files smaller than 4K from the memory buffer cache.', '', 'Integer number', '');
$this->db['maxConnections'] = new DATTR_HELP_ITEM("Max Connections", 'Specifies the maximum number of concurrent connections that the server can accept. This includes both plain TCP connections and SSL connections. This setting should not be set to exceed the hard limit set by the server software edition or license: 500 for VPS license, 800 for Ultra VPS license. Once the maximum concurrent connections limit is reached, the server will close Keep-Alive connections when they complete active requests.', 'When the server is started by &quot;root&quot; user, the server will try to adjust the per-process file descriptor limits automatically, however, if this fails, you may need to increase this limit manually.', 'Integer number', '');
$this->db['maxConns'] = new DATTR_HELP_ITEM("Max Connections", 'Specifies the maximum number of concurrent connections that can be established between the server and an external application. This setting controls how many requests can be processed concurrently by an external application, however, the real limit also depends on the external application itself. Setting this value higher will not help if the external application is not fast enough or cannot scale to a large number of concurrent requests.', ' Setting a high value does not directly translate to higher performance. Setting the limit to a value that will not overload the external application will provide the best performance/throughput.', 'Integer number', '');
$this->db['maxDynRespHeaderSize'] = new DATTR_HELP_ITEM("Max Dynamic Response Header Size (bytes)", 'Specifies the maximum header size of a dynamically generated response. Hard limit is 65530 bytes. Values larger than this, such as 64K (6 bytes larger), will be treated as if 65530 was used.<br/><br/>Default value: 32768 or 32K', ' Set it reasonably low to help recognize bad responses dynamically generated by external applications.', 'Integer number', '');
$this->db['maxDynRespSize'] = new DATTR_HELP_ITEM("Max Dynamic Response Body Size (bytes)", 'Specifies the maximum body size of a dynamically generated response.', ' Set the limit reasonably low to help identify bad responses. It is not uncommon to malformed scripts to contain an infinite loop which leads to infinity-sized responses.', 'Integer number', '');
$this->db['maxKeepAliveReq'] = new DATTR_HELP_ITEM("Max Keep-Alive Requests", 'Specifies the maximum number of requests that can be served through a keep-alive (persistent) session. The connection will be closed once this limit is reached. You can set this limit for each virtual host as well.', ' Set this to a reasonably high value. A value of &quot;1&quot; or &quot;0&quot; will disable keep-alive.', 'Integer number', '');
$this->db['maxMMapFileSize'] = new DATTR_HELP_ITEM("Max MMAP File Size (bytes)", 'Specifies the largest static file that will be memory mapped (MMAP).  Static files can be served in four different ways: memory buffer cache, memory-mapped cache, plain read/write, and sendfile(). Files whose size is smaller than the &quot;Max Cached Small File Size (bytes)&quot; are served from memory buffer cache. Files whose size is larger than the  &quot;Max Cached Small File Size (bytes)&quot;, but smaller than the Max MMAP File Size  will be served from memory-mapped cache. Files whose size is larger than the Max MMAP File Size will be served via plain read/write or sendfile(). Since the server has a 32bit address space (2GB), it is not recommended to memory map very large files.', '', 'Integer number', '');
$this->db['maxMindDBEnv'] = new DATTR_HELP_ITEM("Environment Variables", 'Assign the results of database lookups to environment variables.', '', 'Variable_Name mapped_DB_data<br/><br/>One entry per line. Path to data can use map keys or 0-based array indexes, both being separated by /.', 'COUNTRY_CODE COUNTRY_DB/country/iso_code<br/>REGION_CODE  CITY_DB/subdivisions/0/iso_code');
$this->db['maxReqBodySize'] = new DATTR_HELP_ITEM("Max Request Body Size (bytes)", 'Specifies the maximum size of an HTTP request body. For a 32Bit OS, 2GB is the hard limit.  For a 64Bit OS, it is virtually unlimited.', ' To help prevent DoS attacks, try to constrain this limit to only what is really needed. Your swapping space must have enough free space to accommodate this limit.', 'Integer number', '');
$this->db['maxReqHeaderSize'] = new DATTR_HELP_ITEM("Max Request Header Size (bytes)", 'Specifies the maximum size of an HTTP request header including request URL. Hard limit is 65530 bytes. Values larger than this, such as 64K (6 bytes larger), will be treated as if 65530 was used.<br/><br/>Default value: 32768 or 32K', ' Set it reasonably low to reduce memory usage and help identify bogus requests and DoS attacks.<br/>4-8K is big enough for most web sites under normal circumstances.', 'Integer number', '');
$this->db['maxReqURLLen'] = new DATTR_HELP_ITEM("Max Request URL Length (bytes)", 'Specifies the maximum size of a request URL. URL is the full text address used to access a server resource including the query string. Hard limit is 65530 bytes. Values larger than this, such as 64K (6 bytes larger), will be treated as if 65530 was used.<br/><br/>Default value: 8192 or 8K.', ' Set it reasonably low to reduce memory usage and help identify bogus requests and DoS attacks.<br/>2-3K is big enough for most web sites unless the HTTP GET method is used with large query strings instead of POST.', 'Integer number', '');
$this->db['maxSSLConnections'] = new DATTR_HELP_ITEM("Max SSL Connections", 'Specifies the maximum number of concurrent SSL connections the server will accept. Since total concurrent SSL and non-SSL connections cannot exceed the limit specified by &quot;Max Connections&quot;, the actual number of concurrent SSL connections allowed must be lower than this limit.', '', 'Integer number', '');
$this->db['memHardLimit'] = new DATTR_HELP_ITEM("Memory Hard Limit (bytes)", 'Much the same as &quot;Memory Soft Limit (bytes)&quot;, except the soft limit can be raised up to the hard limit from within a user process. The hard limit can be set at server level or at an individual external application level. The server-level limit will be used if it is not set at an individual application level.<br/><br/>The operating system&#039;s default will be used if the value is absent at both levels or set to 0.', ' Do not over adjust this limit. This may result in 503 errors if your application need more memory.', 'Integer number', '');
$this->db['memSoftLimit'] = new DATTR_HELP_ITEM("Memory Soft Limit (bytes)", 'Specifies the memory consumption limit in bytes for an external application process or an external application started by the server.<br/><br/>The main purpose of this limit is to prevent excessive memory usage because of software bugs or intentional attacks, not to impose a limit on normal usage. Make sure to leave enough head room, otherwise your application may fail and 503 error may be returned. It can be set at the server- level or at an individual external application level. The server-level limit will be used if it is not set at the individual application level.<br/><br/>The operating system&#039;s default setting will be used if the value is absent at both levels or set to 0.', ' Do not over adjust this limit. This may result in 503 errors if your application needs more memory.', 'Integer number', '');
$this->db['memberVHRoot'] = new DATTR_HELP_ITEM("Member Virtual Host Root", 'Specifies the root directory of this virtual host. If left blank, the default virtual host root for this template will be used.<br/><br/>Note: This is <b>NOT</b> the document root. It is recommended to place all files related to the virtual host (like virtual host configuration, log files, html files, CGI scripts, etc.) under this directory. Virtual host root can be referred to as $VH_ROOT.', '', 'path', '');
$this->db['mime'] = new DATTR_HELP_ITEM("MIME Settings", 'Specifies the file that contains the MIME settings for this server. It is always relative to the real root when an absolute path is given in chroot mode. Click on the filename to view/edit the detailed MIME entries.', 'Click the filename to edit the MIME settings.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');
$this->db['mimesuffix'] = new DATTR_HELP_ITEM("Suffixes", 'You can list multiple suffixes for the same MIME type, using comma to separate.', '', '', '');
$this->db['mimetype'] = new DATTR_HELP_ITEM("MIME Type", 'A MIME type consists of a type and subtype in the format of &quot;type/subtype&quot;.', '', '', '');
$this->db['minGID'] = new DATTR_HELP_ITEM("Minimum GID", 'Specifies the minimum group ID allowed to run external applications when running as a specified group. Execution of an external script with a group ID lower than the value specified here will be denied.', ' Set it high enough to exclude all groups used by system users.', 'Integer number', '');
$this->db['minUID'] = new DATTR_HELP_ITEM("Minimum UID", 'Specifies the minimum user ID allowed to run external applications when running as a specified user. Execution of an external script with a user ID lower than the value specified here will be denied.', ' Set it high enough to exclude all system/privileged users.', 'Integer number', '');
$this->db['noCacheDomain'] = new DATTR_HELP_ITEM("No Cache Domain", 'A comma-separated list of domains that will not be cached.', '', 'Comma-separated list. Domain names are case insensitive and the leading &quot;www.&quot; should be removed. The wildcard characters &quot;*&quot; and &quot;?&quot; are allowed. &quot;?&quot; only replaces one character. &quot;*&quot; replaces any number of characters. For example, &quot;*.mydomain.com&quot; will match all subdomains of mydomain.com. Duplicate domain names are not allowed.', '');
$this->db['noCacheUrl'] = new DATTR_HELP_ITEM("Do-Not-Cache URL", 'A list of URL segments where any URL containing these listed segments will not be cached. String matching is used. Regular expressions are not supported. Can be set at the server or virtual host level. URL segments listed at the server level are inherited by all virtual hosts and added to their <b>Do-Not-Cache URL</b> lists.', 'You can add comments by starting a line with &quot;#&quot;.', '', '');
$this->db['nodeBin'] = new DATTR_HELP_ITEM("Node Path", 'Path to Node.js executable.', '', 'Absolute path', '');
$this->db['nodeDefaults'] = new DATTR_HELP_ITEM("Node.js App Default Settings", 'Default configurations for Node.js applications. These settings can be overriden at the context level.', '', '', '');
$this->db['note'] = new DATTR_HELP_ITEM("Notes", 'Add notes for yourself.', '', '', '');
$this->db['ocspCACerts'] = new DATTR_HELP_ITEM("OCSP CA Certificates", 'Specifies the location of the file where OCSP certificate authority (CA) certificates are stored. These certificates are used to check responses from the OCSP responder (and make sure those responses are not spoofed or otherwise compromised). This file should contain the whole certificate chain. If this file does not contain the root certificate, LSWS should be able to find the root certificate in your system directory without you adding it to the file, but, if this validation fails, you should try adding your root certificate to this file.<br/><br/>This setting is optional. If this setting is not set, the server will automatically check &quot;CA Certificate File&quot;.', '', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');
$this->db['ocspRespMaxAge'] = new DATTR_HELP_ITEM("OCSP Response Max Age (secs)", 'This option sets the maximum allowable age for an OCSP response. If an OCSP response is older than this maximum age, the server will contact the OCSP responder for a new response. The default value is 86400. Maximum age can be turned off by setting this value to -1.', '', 'Integer of seconds', '');
$this->db['ocspResponder'] = new DATTR_HELP_ITEM("OCSP Responder", 'Specifies the URL of the OCSP responder to be used. If not set, the server will attempt to contact the OCSP responder detailed in the certificate authority&#039;s issuer certificate. Some issuer certificates may not have an OCSP responder URL specified.', '', 'URL starting with http://', 'http://rapidssl-ocsp.geotrust.com ');
$this->db['onlySelf'] = new DATTR_HELP_ITEM("Only Self Reference", 'Specifies whether to only allow references from the current web site itself. When set to Yes, &quot;Allowed Domains&quot; has no effect and no other web site can link to protected files. This can be convenient if you wish to park multiple domain names on the current web site.', '', 'Select from radio box', '');
$this->db['outBandwidth'] = new DATTR_HELP_ITEM("Outbound Bandwidth (bytes/sec)", 'The maximum allowed outgoing throughput to a single IP address, regardless of the number of connections established. The real bandwidth may end up being slightly higher than this setting for efficiency reasons. Bandwidth is allocated in 4KB units. Set to 0 to disable throttling. Per-client bandwidth limits (bytes/sec) can be set at the server or virtual host level where virtual host level settings override server level settings.', ' Set the bandwidth in 8KB units for better performance.<br/><br/> Trusted IPs or sub-networks are not affected.', 'Integer number', '');
$this->db['pagespeedActivate'] = new DATTR_HELP_ITEM("Activate PageSpeed", 'Choose whether or not to activate PageSpeed capabilites.', '', 'Select from radio box', '');
$this->db['pagespeedEnabled'] = new DATTR_HELP_ITEM("Enable PageSpeed Optimization", 'Choose whether or not to enable PageSpeed optimization.', 'This can be set at the Server Level and overridden at the Virtual Host and Context Levels. Context Level settings will  override Virtual Host Level settings.', 'Select from radio box', '');
$this->db['pagespeedParams'] = new DATTR_HELP_ITEM("PageSpeed Settings", 'Set parameters using Google default filter sets.', '', '', '<br /> pagespeed FileCachePath /tmp/lshttpd/pagespeed;<br/>pagespeed RewriteLevel CoreFilters;');
$this->db['pcKeepAliveTimeout'] = new DATTR_HELP_ITEM("Connection Keepalive Timeout", 'Specifies the maximum time in seconds to keep an idle persistent connection open.<br/><br/>When set to &quot;-1&quot;, the connection will never timeout. When set to 0 or greater, the connection will be closed after this time in seconds has passed.', '', 'int', '');
$this->db['perClientConnLimit'] = new DATTR_HELP_ITEM("Per Client Throttling", 'These are connection control settings are based on client IP. These settings help to mitigate DoS (Denial of Service) and DDoS (Distributed Denial of Service) attacks.', '', '', '');
$this->db['persistConn'] = new DATTR_HELP_ITEM("Persistent Connection", 'Specifies whether to keep the connection open after a request has been processed. Persistent connections can increase performance, but some FastCGI external applications do not support persistent connections fully. The default is &quot;On&quot;.', '', 'Select from radio box', '');
$this->db['phpCommand'] = new DATTR_HELP_ITEM("Command", 'Command used to start the PHP handler.', ' This is usually the path to an &quot;lsphp&quot; binary.', '', '');
$this->db['phpDefault'] = new DATTR_HELP_ITEM("PHP Handler Defaults", 'Set the default configuration for handlers defined via &quot;PHP Handler Definition&quot; .', '', '', '');
$this->db['phpHandlerDef'] = new DATTR_HELP_ITEM("PHP Handler Definition", 'Add a custom PHP handler by only specifying &quot;Handler ID&quot;, &quot;Command&quot;, and optional &quot;Handled Suffixes&quot;. This method will add an external application and associated script handler automatically.<br/><br/>External applications explicitly defined at the server level with the same &quot;Handler ID&quot; or &quot;Command&quot; will have a higher priority.', ' These settings may not be needed as automatically detected PHP handlers should work properly.', '', '');
$this->db['phpHandlers'] = new DATTR_HELP_ITEM("PHP Handlers", 'List of custom PHP handlers.', ' External applications explicitly defined at the server level with the same &quot;Handler ID&quot; or &quot;Command&quot; will have a  higher priority.', '', '');
$this->db['phpSuExec'] = new DATTR_HELP_ITEM("PHP suEXEC", 'Specifies whether to run PHP script in suEXEC mode when &quot;user&quot; and &quot;group&quot; are specified for a virtual host. When set to Yes, PHP scripts will be executed under the user (and group unless &quot;Force GID&quot; is set) specified. When set to User&#039;s Home Directory Only, scripts outside a user&#039;s home directory will run as the global user/group that the web server run as. When using DirectAdmin, User&#039;s Home Directory Only is recommended. Default is No.', '', 'Select from radio box', '');
$this->db['phpSuExecMaxConn'] = new DATTR_HELP_ITEM("PHP suEXEC Max Conn", 'Specifies the maximum number of concurrent PHP processes that can be created by LSWS for each user when running PHP scripts in suEXEC mode. Default value is 5.', 'This limit is per user per lshttpd process. Thus, if you have a 2-CPU license, this limit will be doubled. The limit will be 4x for a 4-CPU license, and so on.', 'Integer number', '');
$this->db['phpSuexecSuffixes'] = new DATTR_HELP_ITEM("SuEXEC handlers", 'List of file suffixes associated with handlers in suEXEC mode. All automatically discovered PHP handlers are in suEXEC mode.', ' This setting can be left as &quot;Not Set&quot; in most situations.', 'Comma separated list of file suffixes', 'php, php5, php7');
$this->db['phpSuffixes'] = new DATTR_HELP_ITEM("Handled suffixes", 'Extra file &quot;suffixes&quot; to be handled by this handler.', ' If a script handler has been configured explicitly for a provided file suffix, this configuration will be ignored.', '', '');
$this->db['pid'] = new DATTR_HELP_ITEM("PID", 'PID (Process ID) of the current server process.', 'The PID will change each time the server is restarted.', '', '');
$this->db['procHardLimit'] = new DATTR_HELP_ITEM("Process Hard Limit", 'Much the same as &quot;Process Soft Limit&quot;, except the soft limit can be raised up to the hard limit from within a user process. The hard limit can be set at the server level or at an individual external application level. The server-level limit will be used if it is not set at an individual application level. The operating system&#039;s default value will be used if the value is absent at both levels or set to 0.', '', 'Integer number', '');
$this->db['procSoftLimit'] = new DATTR_HELP_ITEM("Process Soft Limit", 'Limits the total number of processes that can be created on behalf of a user. All existing processes will be counted against this limit, not just new processes to be started.<br/><br/>The limit can be set at the server level or at an individual external application level. The server-level limit will be used if it is not set at an individual application level. The operating system&#039;s default setting will be used if this value is 0 or absent at both levels.', 'To control how many processes LSWS will make for users in mod_suEXEC mode, use the suEXEC Max Conn setting. PHP scripts can call for forking processes and the number of processes needed for normal functioning can be above the suEXEC Max Conn setting. The main purpose of this limit is as a last line of defense to prevent fork bombs and other attacks caused by PHP processes creating other processes.<br/><br/>Setting this setting too low can severely hurt functionality. The setting will thus be ignored below certain levels.<br/><br/>When <b>Run On Start Up</b> is set to &quot;Yes (Daemon mode)&quot;, the actual process limit will be higher than this setting to make sure parent processes are not limited.', 'Integer number', '');
$this->db['proxyContext'] = new DATTR_HELP_ITEM("Proxy Context", 'A Proxy Context enables this virtual host as a transparent reverse proxy server. This proxy server can run in front of any web servers or application servers that support HTTP protocol. The External web server that this virtual host proxies for  has to be defined in &quot;External Apps&quot; before you can set up a Proxy Context.', '', '', '');
$this->db['proxyProtocol'] = new DATTR_HELP_ITEM("PROXY protocol", 'List of IPs/subnets for front-end proxies that communicate with this server using PROXY protocol. Once set, the server will use PROXY protocol for incoming connections from listed IPs/subnets or fall back to a regular connection if PROXY protocol is unavailable.<br/><br/>Applies to HTTP, HTTPS, HTTP2, and websocket connections.', '', 'Comma delimited list of IP addresses or sub-networks.', '');
$this->db['proxyWebServer'] = new DATTR_HELP_ITEM("Web Server", 'Specifies the name of the external web server. This external web server must be defined in the &quot;External Apps&quot; section at the server or virtual host level.', '', 'Select from drop down list', '');
$this->db['pubStoreExpireMinutes'] = new DATTR_HELP_ITEM("Public Storage Expire (minutes)", 'The maximum age of a cached file before the server will attempt to physically remove it. This removal operation will occur once per day to prevent cache storage from growing too large. Minimum setting is 60 minutes.', 'Set this value to a time greater than your longest TTL to help prevent the removal of still valid cache files.', 'Integer number', '');
$this->db['purgeNoHitTimeout'] = new DATTR_HELP_ITEM("No Hit Expire (minutes)", 'The maximum number of minutes a cached file will remain in cache storage without a cache hit before being physically removed by the server. Set to 0 to disable this feature.<br/><br/>Default value: 0', '', 'Integer number', '');
$this->db['quicBasePLPMTU'] = new DATTR_HELP_ITEM("PLPMTU Base Value", 'The maximum value of PLPMTU (maximum packet size without headers) in bytes that QUIC will use by default. Setting this to 0 will allow QUIC to pick the size.<br/><br/>This setting should be set lower than &quot;PLPMTU Max Value&quot;.<br/><br/>Default value: 0', '', '0 or integer number between 1200 and 65527', '');
$this->db['quicCfcw'] = new DATTR_HELP_ITEM("Connection Flow Control Window", 'The initial size of the buffer allocated for a QUIC connection. Default value is 1.5M.', 'A larger window size will use more memory.', 'Number between 64K and 512M', '');
$this->db['quicCongestionCtrl'] = new DATTR_HELP_ITEM("Congestion Control", 'The congestion control algorithm used. This can be set manually or left up to the QUIC library in use by selecting the &quot;Default&quot; option.<br/><br/>Default value: Default', '', 'Select from drop down list', '');
$this->db['quicEnable'] = new DATTR_HELP_ITEM("Enable HTTP3/QUIC", 'Enables the HTTP3/QUIC network protocol server wide. Default value is Yes.', 'When this setting is set to Yes, HTTP3/QUIC can still be disabled at the listener level through the &quot;Open HTTP3/QUIC (UDP) port&quot; setting, or at the virtual host level through the &quot;Enable HTTP3/QUIC&quot; setting.', 'Select from radio box', '');
$this->db['quicEnableDPLPMTUD'] = new DATTR_HELP_ITEM("Enable DPLPMTUD", 'Enable Datagram Packetization Layer Path Maximum Transmission Unit Discovery (DPLPMTUD).<br/><br/><b>   <a href="     https://tools.ietf.org/html/rfc8899   " target="_blank" rel="noopener noreferrer">     Background on DPLPMTUD (RFC 8899)   </a> </b><br/><br/>Default value: Yes', '', 'Select from radio box', '');
$this->db['quicHandshakeTimeout'] = new DATTR_HELP_ITEM("Handshake Timeout", 'The time in seconds a new QUIC connection is given to complete its handshake, after which the connection is aborted. Default value is 10.', '', 'Integer number between 1 and 15', '');
$this->db['quicIdleTimeout'] = new DATTR_HELP_ITEM("Idle Timeout", 'The time in seconds after which an idle QUIC connection will be closed. Default value is 30.', '', 'Integer number between 10 and 30', '');
$this->db['quicMaxCfcw'] = new DATTR_HELP_ITEM("Max Connection Flow Control Window", 'Specifies the maximum size that a connection flow control window buffer is allowed to reach due to window auto-tuning.<br/><br/>Default value is 0, which means that the value of &quot;Connection Flow Control Window&quot; is used and no auto-tuning is performed.', 'A larger window size will use more memory.', '0 or a number between 64K and 512M', '');
$this->db['quicMaxPLPMTU'] = new DATTR_HELP_ITEM("PLPMTU Max Value", 'The PLPMTU (maximum packet size without headers) probe upper limit in bytes. This setting is used to limit the &quot;maximum packet size&quot; in the DPLPMTUD search space.  Setting this to 0 will allow QUIC to pick the size (By default LSQUIC assumes that MTU is 1,500 bytes (Ethernet)).<br/><br/>This setting should be set higher than &quot;PLPMTU Base Value&quot;.<br/>Default value: 0', '', '0 or integer number between 1200 and 65527', '');
$this->db['quicMaxSfcw'] = new DATTR_HELP_ITEM("Max Stream Flow Control Window", 'Specifies the maximum size that a stream flow control window is allowed to reach due to window auto-tuning.<br/><br/>Default value is 0, which means that the value of &quot;Stream Flow Control Window&quot; is used and no auto-tuning is performed.', 'A larger window size will use more memory.', '0 or a number between 64K and 128M', '');
$this->db['quicMaxStreams'] = new DATTR_HELP_ITEM("Max Concurrent Streams Per Connection", 'The maximum number of concurrent streams allowed per QUIC connection. Default value is 100.', '', 'Integer number between 10 and 1000', '');
$this->db['quicSfcw'] = new DATTR_HELP_ITEM("Stream Flow Control Window", 'The initial amount of data a QUIC connection is willing to receive per stream. Default value is 1M.', 'A larger window size will use more memory.', 'Number between 64K and 128M', '');
$this->db['quicShmDir'] = new DATTR_HELP_ITEM("QUIC SHM Directory", 'Specifies the directory used to save QUIC data to shared memory.<br/><br/>By default, the server&#039;s default SHM directory, /dev/shm, will be used.', 'A RAM based partition, such as /dev/shm, is recommended.', 'Path', '');
$this->db['quicVersions'] = new DATTR_HELP_ITEM("HTTP3/QUIC Versions", 'A list of enabled HTTP3/QUIC versions. This setting should only be used to limit HTTP3/QUIC support to the versions listed and is best left blank.', 'It is recommended to leave this setting blank to have the the best configuration applied automatically.', 'Comma-separated list', 'h3-29, h3-Q050');
$this->db['railsAppLimit'] = new DATTR_HELP_ITEM("Max Apps Per Account", 'Specifies the maximum number of Rack/Rails applications that can be created per account. The default is &quot;1&quot;.', ' Rack/Rails applications can take a  large amount of system resources. Thus it is not recommended to set this limit too high,  otherwise it may affect the performance of whole server if one user abuses it.', 'Integer number', '');
$this->db['railsContext'] = new DATTR_HELP_ITEM("Rack/Rails Context", 'A Rack/Rails Context provides an easy way to configure a Ruby Rack/Rails application. To add a Rack/Rails application through a Rack/Rails Context, only mounting the URL and the application&#039;s root directory is required. There is no need to go through all the troubles to define an external application, add a 404 handler, and rewrite rules, etc.', '', '', '');
$this->db['railsDefaults'] = new DATTR_HELP_ITEM("Rack/Rails Default Settings", 'Default configurations for Rack/Rails applications. These settings can be overriden at the context level.', '', '', '');
$this->db['railsEnv'] = new DATTR_HELP_ITEM("Run-Time Mode", 'Specifies which mode Rack/Rails will be running as: &quot;Development&quot;,  &quot;Production&quot;, or &quot;Staging&quot;. The default is &quot;Production&quot;.', '', 'Select from drop down list', '');
$this->db['railsHosting'] = new DATTR_HELP_ITEM("Rack/Rails Shared Hosting", 'LiteSpeed&#039;s Rack/Rails Shared Hosting settings allow users  using our high performance, highly scalable Ruby LSAPI module to  easily control their customers&#039; Ruby usage.<br/><br/>LiteSpeed Rack/Rails hosting solution can deliver the best performance with minimum server resource requirement. In addition, it is compatible with all existing web hosting control panels. <br/><br/>The user-manageable Rack/Rails configuration file (&quot;.ls_rails_config&quot;)  is located in the user&#039;s home directory or virtual host root directory.   Syntax is as follows: <br/><blockquote> #RailsApp <name> <App Path> <Rails Evn> <Children Processes> <RunOnStart><br/>RailsApp testApp &quot;/lsws/testrails&quot; &quot;development&quot; 4 1 <br/><br/>#RailsAppMap <name> <domain> <URI> <br/>RailsAppMap testApp &quot;testrails.com&quot; &quot;/&quot; <br/>RailsAppMap testApp &quot;test.testrails.com&quot; &quot;/&quot;  </blockquote><br/>The &quot;App Path&quot; is relative to the user&#039;s home directory or the virtual host root directory.<br/><br/>Whenever this file is touched, Rack/Rails applications will be restarted.', '', '', '');
$this->db['rails_location'] = new DATTR_HELP_ITEM("Location", 'Specifies the corresponding location of this context in the file system.<br/><br/>Default value: $DOC_ROOT + &quot;URI&quot;', '', 'It can be an absolute path or path relative to $SERVER_ROOT, $VH_ROOT, or $DOC_ROOT. $DOC_ROOT is the default relative path, and can be omitted.<br/><br/>If the &quot;URI&quot; is a regular expression, then the matched sub-string can be used to form the &quot;Root&quot; string. The matched sub-string can be referenced with the values &quot;$1&quot; - &quot;$9&quot;. &quot;$0&quot; and &quot;&&quot; can be used to reference the whole matched string. Additionally, a query string can be set by appending a &quot;?&quot; followed by the query string. Be careful. &quot;&&quot; should be escaped as &quot;\&&quot; in the query string.', 'A plain URI like /examples/ with &quot;Location&quot; set to /home/john/web_examples will map the request &quot;/examples/foo/bar.html&quot; to file &quot;/home/john/web_examples/foo/bar.html&quot;.<br/>To simulate Apache&#039;s mod_userdir, set URI to exp: ^/~([A-Za-z0-9]+)(.*), set &quot;Location&quot; to /home/$1/public_html$2. With these settings, a request of URI /~john/foo/bar.html will map to file /home/john/public_html/foo/bar.html.');
$this->db['ramDiskPath'] = new DATTR_HELP_ITEM("RAM Disk Path", 'Setting the RAM Disk Path allows you to designate the location of a RAM disk. A RAM disk is a world-writable directory stored in memory. A server with excess RAM can reduce disk I/O by serving content from this RAM disk. Accessing content from RAM is much faster than reading data from the disk. LSWS will use this RAM disk to optimize performance when there is enough memory available.<br/><br/>(The RAM disk must be designated in your OS setup before it can be used by the web server. Many Linux distributions assign /dev/shm as a RAM disk by default, but these settings depend on your OS.)', '', 'path', '');
$this->db['rcvBufSize'] = new DATTR_HELP_ITEM("Receive Buffer Size (bytes)", 'The receiving buffer size of each TCP socket. 512K is the maximum allowed buffer size.', ' It is recommended to leave this value as &quot;Not Set&quot; or set to 0 to use the operating system&#039;s default buffer size.<br/> A large receive buffer will increase performance when processing  incoming requests with large payloads, i.e. file uploads.<br/> Setting this to a lower value will reduce throughput and memory usage per socket allowing the server to have more concurrent sockets when memory is a bottleneck.', 'Integer number', '');
$this->db['realm'] = new DATTR_HELP_ITEM("Realm", 'Specifies the authorization realm for this context. When specified, a valid username and password must be provided in order to access this context. &quot;Authorization Realms&quot; are set up in the &quot;Virtual Host Security&quot; section. This setting uses each realm&#039;s &quot;Realm Name&quot;.', '', 'Select from drop down list', '');
$this->db['realmName'] = new DATTR_HELP_ITEM("Realm Name", 'Specifies a unique name for the authorization realm.', '', '', '');
$this->db['realmType'] = new DATTR_HELP_ITEM("DB Type", 'Specifies how user/group data is stored for an authorization realm. Currently, user/group data can be stored in flat files or on a LDAP server.', '', 'Select from drop down list', '');
$this->db['realms'] = new DATTR_HELP_ITEM("Authorization Realms", 'Lists all authorization realms for this virtual host. Authorization realms are used to block unauthorized users from accessing protected web pages. A realm is a user directory containing usernames and passwords with optional group classifications. Authorization is performed at the context level. Because different contexts can share the same realm (user database), realms are defined separately from the contexts that use them. You can refer to a realm by these names in a contexts configuration.', '', '', '');
$this->db['realtimerpt'] = new DATTR_HELP_ITEM("Real-Time Statistics", 'The Real-Time Statistics link leads to a page with a real-time server status report. This is a convenient tool to monitor the system.    The report shows a snapshot of your server statistics. The refresh rate for this snapshot  is controlled by the Refresh Interval drop-down list in the upper righthand corner.   The report contains the following sections: <ul><li>Server Health shows the basic server statistics, uptime, load, and anti-DDoS blocked IPs.</li>   <li>Server lists current traffic throughput, connections, and requests statistics.</li>  <li>Virtual Host shows request processing statuses and external application statuses for each virtual host.</li>  <li>External Application lists the external applications currently running and their usage statistics.   The CGI daemon process lscgid is always running as an external application.</li> </ul>   Many of the rows in the Real-Time Statistics feature a graph icon.  Clicking on this icon will open a graph of that row&#039;s statistics updated in real-time.   In the Server section, next to Requests, there is a link labeled (Details).  This link takes you to the Requests Snapshot, where you can view detailed information  on which clients are making certain kinds of requests or which aspects of your site  are bottlenecking. The fields in the blue area allow you to filter the snapshot to isolate  certain parts of your server or look for clients that are performing certain actions.', '', '', '');
$this->db['recaptchaAllowedRobotHits'] = new DATTR_HELP_ITEM("Allowed Robot Hits", 'Number of hits per 10 seconds to allow ‘good bots’ to pass. Bots will still be throttled when the server is under load.<br/><br/>Default value is 3.', '', 'Integer number', '');
$this->db['recaptchaBotWhiteList'] = new DATTR_HELP_ITEM("Bot White List", 'List of custom user agents to allow access. Will be subject to the ‘good bots’ limitations, including allowedRobotHits.', '', 'List of user agents, one per line. Regex is supported.', '');
$this->db['recaptchaMaxTries'] = new DATTR_HELP_ITEM("Max Tries", 'Max Tries specifies the maximum number of reCAPTCHA attempts permitted before denying the visitor.<br/><br/>Default value is 3.', '', 'Integer number', '');
$this->db['recaptchaSecretKey'] = new DATTR_HELP_ITEM("Secret Key", 'The secret key is the private key provided by Google via its reCAPTCHA service. A default Secret Key will be used if not set.', '', '', '');
$this->db['recaptchaSensitivity'] = new DATTR_HELP_ITEM("Trigger Sensitivity", 'Automatic reCAPTCHA sensitivity. The higher the value, the more likely reCAPTCHA Protection will be used. A value of 0 is equivalent to &quot;Off&quot; while a value of 100 is equivalent to &quot;Always On&quot;.<br/><br/>Default values:<br/><b>Server level:</b> 0<br/><b>Virtual Host level:</b> Inherit Server level setting', '', 'Integer value between 0 and 100.', '');
$this->db['recaptchaSiteKey'] = new DATTR_HELP_ITEM("Site Key", 'The site key is the public key provided by Google via its reCAPTCHA service. A default Site Key will be used if not set.', '', '', '');
$this->db['recaptchaType'] = new DATTR_HELP_ITEM("reCAPTCHA Type", 'Specify the reCAPTCHA type to use with the key pairs.<br/>If a key pair has not been provided and this setting is set to Not Set, a default key pair of type Invisible will be used.<br/><br/>Checkbox will display a checkbox reCAPTCHA for the visitor to validate.<br/><br/>Invisible will attempt to validate the reCAPTCHA automatically and if successful, will redirect to the desired page.<br/><br/>hCaptcha can be used to support reCAPTCHA provider <a href="https://www.hcaptcha.com" target="_blank" rel="noopener noreferrer">hCaptcha</a>.<br/><br/>Default value is Invisible.', '', 'Select from drop down list', '');
$this->db['redirectContext'] = new DATTR_HELP_ITEM("Redirect Context", 'A Redirect Context can be used to forward one URI or a group of URIs to another location. The destination URI can be either on the same web site (an internal redirect) or an absolute URI pointing to another web site (an external redirect).', '', '', '');
$this->db['redirectUri'] = new DATTR_HELP_ITEM("Redirect URL", 'Specifies a URL that a user will be redirected to when a hotlinking action is detected. You can redirect users to an image or page saying hotlinking is not allowed. If it is not specified, 403 Forbidden will be returned.', '', 'Absolute URL', '');
$this->db['renegProtection'] = new DATTR_HELP_ITEM("SSL Renegotiation Protection", 'Specifies whether to enable SSL Renegotiation Protection to defend against SSL handshake-based attacks. The default value is &quot;Yes&quot;.', 'This setting can be enabled at the listener and virtual host levels.', 'Select from radio box', '');
$this->db['reqCensorshipRule'] = new DATTR_HELP_ITEM("Web Application Firewall (WAF) Rule Set", 'Rules configured here only work for virtual hosts configured with a native LSWS configuration, not for virtual hosts using Apache httpd.conf.', '', '', '');
$this->db['required'] = new DATTR_HELP_ITEM("Require (Authorized Users/Groups)", 'Specifies which user/group can access this context. This allows you to use one user/group database (specified in &quot;Realm&quot;) across a number of contexts, but only allow certain users/groups from that database to access this context.', '', 'Syntax is compatible with Apache&#039;s Require directive. For example: <ul> <li>user username [username ...]<br/>Only listed users can access this context.</li> <li> group groupid [groupid ...]<br/>Only users belonging to the listed groups can access this context.</li> </ul> If this setting is not specified, all valid users will be allowed to access this resource.', '');
$this->db['requiredPermissionMask'] = new DATTR_HELP_ITEM("Required Permission Mask", 'Specifies the required permission mask for static files that the server will serve. For example, if only files that are readable by everyone can be served, set the value to 0004. See man 2 stat for all values.', '', 'octal numbers', '');
$this->db['respBuffer'] = new DATTR_HELP_ITEM("Response Buffering", 'Specifies whether to buffer responses received from external applications. If a &quot;nph-&quot; (Non-Parsed-Header) script is detected, buffering is turned off for responses with full HTTP headers.', '', 'Select from drop down list', '');
$this->db['respectCacheable'] = new DATTR_HELP_ITEM("Respect Cacheable", 'Respect the value of regular &quot;Cache-Control&quot; response headers when LiteSpeed-specific cache control has not been provided.<br/><br/>LiteSpeed-specific cache control includes the X-litespeed-cache-control response header and the cache-control environment variable set via rewrite rule.', 'This setting is enabled by default.', 'Select from radio box', '');
$this->db['restart'] = new DATTR_HELP_ITEM("Apply Changes/Graceful Restart", 'By clicking Graceful Restart, a new server process will be started.  For Graceful Restart, the old server process will only exit after all requests  to it have been finished (or the &quot;Graceful Restart Timeout (secs)&quot; limit has been reached).   Configuration changes are applied at the next restart.  Graceful Restart will apply these changes without any server downtime.', 'Graceful restart takes less than 2 seconds to generate a new server process.', '', '');
$this->db['restrained'] = new DATTR_HELP_ITEM("Restrained", 'Specifies whether files beyond this virtual host root($VH_ROOT) can be accessed though this web site. If set to Yes, only files under $VH_ROOT can be accessed and access to symbolic links or context pointing to files or directories beyond $VH_ROOT will be denied. This, however, does not limit the accessibility of CGI scripts. This is useful in the shared hosting environment. &quot;Follow Symbolic Link&quot; can be set to Yes to allow users to use symbolic links under $VH_ROOT, but not anything beyond $VH_ROOT.', ' Turn it on in the shared hosting environment.', 'Select from radio box', '');
$this->db['restrictedDirPermissionMask'] = new DATTR_HELP_ITEM("Script Directory Restricted Permission Mask", 'Specifies the restricted permission mask of parent directories of script files that the server will not serve. For example, to prohibit serving PHP scripts in a directory that is group and world writable, set the mask to 022. Default value is 000. This option can be used to prevent serving scripts under a directory of  uploaded files.<br/><br/>See man 2 stat for all values.', '', 'octal numbers', '');
$this->db['restrictedPermissionMask'] = new DATTR_HELP_ITEM("Restricted Permission Mask", 'Specifies the restricted permission mask for static files that the server will not serve. For example, to prohibit serving files that are executable, set the mask to 0111.<br/><br/>See man 2 stat for all values.', '', 'octal numbers', '');
$this->db['restrictedScriptPermissionMask'] = new DATTR_HELP_ITEM("Script Restricted Permission Mask", 'Specifies the restricted permission mask for script files that the server will not serve. For example, to prohibit serving PHP scripts that are group and world writable, set the mask to 022. Default value is 000.<br/><br/>See man 2 stat for all values.', '', 'octal numbers', '');
$this->db['retryTimeout'] = new DATTR_HELP_ITEM("Retry Timeout (secs)", 'Specifies the period of time that the server waits before retrying an external application that had a prior communication problem.', '', 'Integer number', '');
$this->db['reusePort'] = new DATTR_HELP_ITEM("Enable REUSEPORT", 'Use SO_REUSEPORT socket option to distribute incoming traffic to multiple workers. This setting is only effective for multi-worker licenses. When enabled, all workers are automatically bound to this listener and &quot;Binding&quot; configuration is ignored.<br/><br/>Default value: On', '', 'Select from radio box', '');
$this->db['reverseDnsLookup'] = new DATTR_HELP_ITEM("Reverse DNS Lookup", 'Perform an IP -> Domain Name lookup for each client. This can be used in access logging.<br/><br/>Default value: No', '', 'Select from radio box', '');
$this->db['rewriteBase'] = new DATTR_HELP_ITEM("Rewrite Base", 'Specifies the base URL for rewrite rules.', '', 'URL', '');
$this->db['rewriteInherit'] = new DATTR_HELP_ITEM("Rewrite Inherit", 'Specifies whether to inherit rewrite rules from parent contexts. If rewrite is enabled and not inherited, rewrite base and rewrite rules defined in this context will be used.', '', 'Select from radio box', '');
$this->db['rewriteLogLevel'] = new DATTR_HELP_ITEM("Log Level", 'Specifies the level of detail of the rewrite engine&#039;s debug output. This value ranges from 0 - 9. 0 disables logging. 9 produces the most detailed log. The server and virtual host&#039;s error log &quot;Log Level&quot;  must be set to at least INFO for this option to take effect. This is useful when testing rewrite rules.', '', 'Integer number', '');
$this->db['rewriteMapLocation'] = new DATTR_HELP_ITEM("Location", 'Specifies the location of the rewrite map using the syntax MapType:MapSource.<br/>LiteSpeed&#039;s rewrite engine supports three types of rewrite maps: <ul> 	<li><b>Standard Plain Text</b> <blockquote> 		<b>MapType:</b> txt; <br/>		<b>MapSource:</b> file path to a valid plain ASCII file.  </blockquote> 		Each line of this file should contain two elements separated  		by blank spaces. The first element is the key and the second 		element is the value. Comments can be added with a leading &quot;#&quot; 		sign.  	</li> 	<li><b>Randomized Plain Text</b> <blockquote> 		<b>MapType:</b> rnd;<br/>		<b>MapSource:</b> file path of a valid plain ASCII file. </blockquote> 		File format is similar to the Standard Plain Text file, except that the 		second element can contain multiple choices separated by a &quot;|&quot; 		sign and chosen randomly by the rewrite engine. 	</li> 	<li><b>Internal Function</b> <blockquote> 	    <b>MapType:</b> int;<br/>		<b>MapSource:</b> Internal string function  </blockquote> 		4 functions are available: 		<ul> 			<li><b>toupper:</b> converts lookup key to upper cases.</li> 			<li><b>tolower:</b> converts lookup key to lower cases.</li> 			<li><b>escape:</b> perform URL encoding on lookup key.</li> 			<li><b>unescape:</b> perform URL decoding on lookup key.</li> 		</ul> 	</li> 	The following map types available in Apache 	have not been implemented in LiteSpeed:<br/>Hash File and External Rewriting Program. </ul> The implementation of LiteSpeed&#039;s rewrite engine follows the specifications of Apache&#039;s rewrite engine. For more details about rewrite map, please refer to <a href="http://httpd.apache.org/docs/current/mod/mod_rewrite.html" target="_blank" rel="noopener noreferrer">Apache&#039;s mod_rewrite document</a>.', '', 'String', '');
$this->db['rewriteMapName'] = new DATTR_HELP_ITEM("Name", 'Specifies a unique name for the rewrite map at the virtual host  level. This name will be used by a mapping-reference in rewrite rules. When referencing this name, one of the following syntaxes should be used: <blockquote><code> $\{MapName:LookupKey\}<br/>$\{MapName:LookupKey|DefaultValue\} </code></blockquote><br/>The implementation of LiteSpeed&#039;s rewrite engine follows the specifications of Apache&#039;s rewrite engine. For more details about rewrite maps, please refer to <a href="http://httpd.apache.org/docs/current/mod/mod_rewrite.html" target="_blank" rel="noopener noreferrer">Apache&#039;s mod_rewrite document</a>.', '', 'string', '');
$this->db['rewriteRules'] = new DATTR_HELP_ITEM("Rewrite Rules", 'Specifies a list of rewrite rules at the virtual host level.<br/><br/>Do NOT add any document root level rewrite rules here. If you have any document root level rewrite rules from .htaccess, you should instead create a static context with uri &quot;/&quot; and add the rewrite rules there.<br/><br/>A rewrite rule is comprised of one RewriteRule directive and optionally preceded by multiple RewriteCond directives. <ul>   <li>Each directive should take only one line.</li>   <li>     RewriteCond and RewriteRule follow Apache&#039;s rewrite     directive syntax. Just copy and paste rewrite directives from your Apache     configuration files.   </li>   <li>     There are minor differences between LiteSpeed and Apache mod_rewrite     implementation:     <ul>       <li>         %\{LA-U:variable\} and %\{LA-F:variable\} are ignored         by the LiteSpeed rewrite engine       </li>       <li>         Two new server variables are added in the LiteSpeed rewrite engine:         %\{CURRENT_URI\} represents the current URI being processed by         the rewrite engine and %\{SCRIPT_NAME\} has the same  meaning         as the corresponding CGI environment variable.       </li>       <li>         The LiteSpeed rewrite engine will stop processing rewrite rules after         encountering an [L] flag to avoid looping while Apache         mod_rewrite will stop processing rewrite rules for the current         iteration only. This behavior is similar to that of the [END]         flag in Apache mod_rewrite.       </li>     </ul>   </li> </ul><br/>The implementation of LiteSpeed&#039;s rewrite engine follows Apache&#039;s rewrite engine specifications. For more details about rewrite rules, please refer to <a href="https://httpd.apache.org/docs/current/mod/mod_rewrite.html" target="_blank" rel="noopener noreferrer">   Apache&#039;s mod_rewrite document </a> and <a href="https://httpd.apache.org/docs/current/rewrite/" target="_blank" rel="noopener noreferrer">   Apache&#039;s URL rewriting guide </a>.', '', 'string', '');
$this->db['rubyBin'] = new DATTR_HELP_ITEM("Ruby Path", 'Path to Ruby executable. Generally, it is /usr/bin/ruby or /usr/local/bin/ruby depending on where Ruby has been installed to.', '', 'Absolute path', '');
$this->db['rubyProcLimit'] = new DATTR_HELP_ITEM("Max Ruby Processes Per Account", 'Specifies the maximum number of Ruby processes that can be created per account. The default is &quot;10&quot;. If one account runs multiple Rack/Rails applications, the total number of Ruby processes of all applications cannot exceed this limit. Each ruby process will take large amount of system resource, it is not recommended to set a high limit, otherwise, it will affect the performance of whole server if one user abuse it.', ' Ruby processes can take a large amount of system resources. Thus it is not recommended to set this limit too high, otherwise it may affect the performance of the whole server if one user abuses it.', 'Integer number', '');
$this->db['ruleSetAction'] = new DATTR_HELP_ITEM("Rule Set Action", 'Specifies the actions that should be taken when a censoring rule in current ruleset is met. If not set, &quot;Default Action&quot; will be used.', '', 'String. This action string uses the same syntax as Apache&#039;s <a href="   https://github.com/SpiderLabs/ModSecurity/wiki/Reference-Manual#SecDefaultAction " target="_blank" rel="noopener noreferrer">   mod_security SecDefaultAction directive </a> .', '');
$this->db['runOnStartUp'] = new DATTR_HELP_ITEM("Run On Start Up", 'Specifies whether to start the external application at server start up. Only applicable to external applications that can manage their own child processes and where &quot;Instances&quot; value is set to &quot;1&quot;.<br/><br/>If enabled, external processes will be created at server startup instead of run-time.<br/><br/>When selecting &quot;Yes (Detached mode)&quot;, all detached process can be restarted at the Server level or Virtual Host level by touching the &#039;.lsphp_restart.txt&#039; file under the $SERVER_ROOT/admin/tmp/ or $VH_ROOT/ directory respectively.<br/><br/>Default value: Yes (Detached mode)', ' If the configured external process has significant startup overhead, like a Rails app, then this option should be enabled to decrease first page response time.', 'Select from radio box', '');
$this->db['runningAs'] = new DATTR_HELP_ITEM("Running As", 'Specifies the user/group that the server process runs as. This value is set during installation. In order to change it, you must download the installation package and perform an upgrade via the command line.', ' Server should not be run as a privileged user, such as &quot;root&quot;. It is critical that the server is configured to run as an un-privileged user/group combination that does not have login/shell access. A user and group of nobody is generally a good choice.', '', '');
$this->db['scanPOST'] = new DATTR_HELP_ITEM("Scan Request Body", 'Specifies whether to check the body of an HTTP POST request.  Default is &quot;No&quot;.', '', 'Select from radio box', '');
$this->db['secAuditLog'] = new DATTR_HELP_ITEM("Security Audit Log", 'Specifies the path of the security audit log, which gives more detailed information.   This extra information can be useful if, for example, you wish to track the actions of   a particular user. Use &quot;Enable Security Audit Log&quot; to turn on the logging.', '', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT.', '');
$this->db['secAuditLogEngine'] = new DATTR_HELP_ITEM("Enable Security Audit Log", 'Specifies whether to enable audit logging and in what format (Native, JSON, or Pretty JSON). This feature is equivalent to Apache&#039;s mod_security audit engine.<br/><br/>If this setting is enabled and the &quot;Security Audit Log&quot; setting is set, detailed request information will be saved.', '', 'Select from drop down list', '');
$this->db['securedConn'] = new DATTR_HELP_ITEM("Secured Connection", 'Specifies whether HTTPS is used to access AWstats statistics.', '', 'Select from radio box', '');
$this->db['servAction'] = new DATTR_HELP_ITEM("Actions", 'Six actions are available from this menu: Graceful Restart, Toggle Debug Logging, Server Log Viewer, Real-Time Statistics,  Version Manager, and Compile PHP.  <ul><li>&quot;Apply Changes/Graceful Restart&quot; restarts server process gracefully without interrupting requests in process.</li> 	<li>&quot;Toggle Debug Logging&quot; turns debug logging on or off.</li> 	<li>&quot;Server Log Viewer&quot; allows you to view the server log through the log viewer.</li> 	<li>&quot;Real-Time Statistics&quot; allows you to view real-time server status.</li> 	<li>&quot;Version Management&quot; allows you to download new versions of LSWS and switch between different versions. 	<li>Compile PHP allows you to compile PHP for LiteSpeed Web Server. </ul>', 'The shell utility $SERVER_ROOT/bin/lswsctrl can be used to control the server processes as well,  but requires a login shell.', '', '');
$this->db['servChrootPath'] = new DATTR_HELP_ITEM("Chroot Path", 'Enterprise Edition Only Specifies the directory where the chroot environment is rooted. Only &quot;root&quot; user can run the server in chroot mode. Whether to run in chroot mode is controlled by &quot;Enable chroot&quot; option. The installer program will set up the initial chroot environment automatically. This entry is read-only, and if you want to change it, please run the installer again from the command line.<br/><br/>In the chroot environment, the server and its child processes cannot access file systems outside of the chroot jail. Chroot is an advanced security feature and additional administration may be required to make it work properly. All required executables, libraries, configuration files, and device files should be recreated within the chroot jail.<br/><br/>As the root directory is changed, you need to pay special attention to path configuration when an absolute path is used. A Unix domain socket or swapping directory is always relative to the new root directory. All other path configurations are always relative to the real root.', ' Use chroot for better security.', '', '');
$this->db['serverName'] = new DATTR_HELP_ITEM("Server Name", 'A unique name for this server. You can use $HOSTNAME as value.', '', '', '');
$this->db['serverPriority'] = new DATTR_HELP_ITEM("Priority", 'Specifies priority of the server processes. Value ranges from -20 to 20. A lower number means higher priority.', ' Usually a higher priority leads to slightly higher web performance on a busy server. Do not set priority higher than that of database processes.', 'Integer number', '');
$this->db['servletContext'] = new DATTR_HELP_ITEM("Servlet Context", 'Servlets can be imported individually through Servlet Contexts. A Servlet Context just specifies the URI for the servlet and the name of the servlet engine. You only need to use this when you do not want to import the whole web application or you want to protect different servlets with different authorization realms. This URI has the same requirements as for a &quot;Java Web App Context&quot;.', '', '', '');
$this->db['servletEngine'] = new DATTR_HELP_ITEM("Servlet Engine", 'Specifies the name of the servlet engine that serves this web application. Servlet engines must be defined in the &quot;External Apps&quot; section at the server or virtual host level.', '', 'Select from drop down list', '');
$this->db['setUidMode'] = new DATTR_HELP_ITEM("External App Set UID Mode", 'Specifies how user ID is set for an external application process. Three choices are available: <ul><li>Server UID: Set the user/group ID of external application processes  to the same as the server&#039;s user/group ID.</li>     <li>CGI File UID: Set the user/group ID of external CGI processes based 	on the user/group ID of the executable. This option only applies to CGI, not FastCGI or LSPHP.</li>     <li>Doc Root UID: Set the user/group ID of external application processes based 	on the user/group ID of the document root of the current virtual host.</li> </ul><br/><br/>Default value: Server UID', ' In the shared hosting environment, it is recommended to use the CGI File UID or Doc Root UID modes to prevent files owned by one virtual host from being accessed by the external application scripts of another virtual host.', 'Select from drop down list', '');
$this->db['shHandlerName'] = new DATTR_HELP_ITEM("Handler Name", 'Specifies the name of the external application that processes the script files  when the handler type is FastCGI, Web Server, LSAPI, Load Balancer, or Servlet Engine.', '', 'Select from drop down list', '');
$this->db['shType'] = new DATTR_HELP_ITEM("Handler Type", 'Specifies the type of external application that processes these script files.   Available types are: CGI, FastCGI, Web Server, LSAPI app, Load balancer, or Servlet Engine.  For FastCGI, Web Server and Servlet Engine, a &quot;Handler Name&quot; needs to be specified.  This is an external application name as predefined in the &quot;External Apps&quot; section.', '', 'Select from drop down list', '');
$this->db['shmDefaultDir'] = new DATTR_HELP_ITEM("Default SHM Directory", 'Changes shared memory&#039;s default directory to the specified path. If the directory does not exist, it will be created. All SHM data will be stored in this directory unless otherwise specified.', '', 'path', '');
$this->db['showVersionNumber'] = new DATTR_HELP_ITEM("Server Signature", 'Specifies whether to show the server signature and version number in the response header&#039;s &quot;Server&quot; value. There are three options: when set to Hide Version, only LiteSpeed is shown. When set to Show Version, LiteSpeed and the version number are shown. Enterprise Edition Only When set to Hide Full Header, the entire Server header will not be shown in the response header.', ' Set to Hide Version if you do not wish to expose the server version number.', 'Select from drop down list', '');
$this->db['siteAliases'] = new DATTR_HELP_ITEM("Site Aliases", 'Specifies all other possible domain names, IP addresses, and host aliases that this virtual host can be accessed with. This value is used to populate the &quot;SiteAliases&quot; parameter in AWStats configuration.  It is used to analyze the referrer field in log files and to help  AWStats to decide if a referrer URL is a local or external URL.  For best performance, use the the minimum number of possible name/address combinations.', '', 'A list of domain names and IP addresses.', 'www.myserver.com localhost 127.0.0.1 REGEX[mydomain\.(net|org)$]');
$this->db['siteDomain'] = new DATTR_HELP_ITEM("Site Domain", 'Specifies the main domain name of this web site. It controls the &quot;SiteDomain&quot; parameter in AWStats&#039;s configuration file.  It is used by Awstats to generate full URL paths. If not set,  the name of this virtual host will be used.', '', 'domain name', '');
$this->db['sname'] = new DATTR_HELP_ITEM("Name - Server", 'The unique name that identifies this server. This is the  &quot;Server Name&quot; specified in the general configuration.', '', '', '');
$this->db['sndBufSize'] = new DATTR_HELP_ITEM("Send Buffer Size (bytes)", 'The sending buffer size of each TCP socket. 512K is the maximum allowed buffer size.', ' It is recommended to leave this value as &quot;Not Set&quot; or set to 0 to use the operating system&#039;s default buffer size.<br/> If your web site serves large static files, increase the send buffer  size to improve performance.<br/> Setting this to a lower value will reduce throughput and memory usage per socket allowing the server to have more concurrent sockets when memory is a bottleneck.', 'Integer number', '');
$this->db['softLimit'] = new DATTR_HELP_ITEM("Connection Soft Limit", 'Specifies the soft limit of concurrent connections allowed from one IP. This soft limit can be exceeded temporarily during &quot;Grace Period (sec)&quot; as long as the number is below the &quot;Connection Hard Limit&quot;, but Keep-Alive connections will be closed as soon as possible until the number of connections is lower than the limit. If number of connections is still over the limit after the &quot;Grace Period (sec)&quot;, that IP will be blocked for the &quot;Banned Period (sec)&quot;.<br/><br/>For example, if a page contains many small graphs, the browser may try to set up many connections at same time, especially for HTTP/1.0 clients. You would want to allow those connections for a short period.<br/><br/>HTTP/1.1 clients may also set up multiple connections to speed up downloading and SSL  requires separate connections from non-SSL connections. Make sure the limit is set properly,  as not to adversely affect normal service. The recommended limit is between 5 and 10.', ' A lower number will enable serving more distinct clients.<br/> Trusted IPs or sub-networks are not affected.<br/> Set to a high value when you are performing benchmark tests with a large number of concurrent client machines.', 'Integer number', '');
$this->db['sslCert'] = new DATTR_HELP_ITEM("SSL Private Key & Certificate", 'Every SSL listener requires a paired SSL private key and SSL certificate. Multiple SSL listeners can share the same key and certificate.<br/><br/>You can generate SSL private keys yourself using an SSL software package, such as OpenSSL. SSL certificates can also be purchased from an authorized certificate issuer like VeriSign or Thawte. You can also sign the certificate yourself. Self-signed certificates will not be trusted by web browsers and should not be used on public websites containing critical data. However, a self-signed certificate is good enough for internal use, e.g. for encrypting traffic to LiteSpeed Web Server&#039;s WebAdmin Console.', '', '', '');
$this->db['sslCertCompress'] = new DATTR_HELP_ITEM("Enable Certificate Compression", 'Use SSL certificate compression.<br/><br/>Default value: On', '', 'Select from radio box', '');
$this->db['sslDefaultCiphers'] = new DATTR_HELP_ITEM("Default Cipher Suite", 'Default cipher suite for SSL certificates.<br/><br/>Default value: Server Internal Default (Based on current best practices)', '', 'Colon-separated string of cipher specifications.', '');
$this->db['sslEnableMultiCerts'] = new DATTR_HELP_ITEM("Enable Multiple SSL Certificates", 'Allows listeners/vhosts to set multiple SSL certificates.  If multiple certificates are enabled, the certificates/keys are expected to follow a naming scheme.  If the cert is named server.crt, other possible cert names are server.crt.rsa, server.crt.dsa, server.crt.ecc. If &quot;Not Set&quot;, defaults to &quot;No&quot;.', '', 'Select from radio box', '');
$this->db['sslHsOffload'] = new DATTR_HELP_ITEM("Enable Handshake Offload", 'Offload SSL handshake to a separate thread.<br/><br/>Default value: On', '', 'Select from radio box', '');
$this->db['sslOCSP'] = new DATTR_HELP_ITEM("OCSP Stapling", 'Online Certificate Status Protocol (OCSP) is a more efficient method of checking whether a digital certificate is valid. It works by communicating with another server — the OCSP responder — to get verification that the certificate is valid instead of checking through certificate revocation lists (CRL).<br/><br/>OCSP stapling is a further improvement on this protocol, allowing the server to check with the OCSP responder at regular intervals instead of every time a certificate is requested. See the <a href="http://en.wikipedia.org/wiki/OCSP_Stapling" target="_blank" rel="noopener noreferrer">OCSP Wikipedia page</a> for more details.', '', '', '');
$this->db['sslOcspProxy'] = new DATTR_HELP_ITEM("OCSP Proxy", 'Socket address used as the proxy server address for OCSP verification. Leave this setting unset If not using a proxy.<br/><br/>Default value: not set', '', 'Socket Address', '');
$this->db['sslProtocolSetting'] = new DATTR_HELP_ITEM("SSL Protocol", 'Customizes SSL protocols accepted by the listener.', '', '', '');
$this->db['sslSessionCache'] = new DATTR_HELP_ITEM("Enable Session Cache", 'Enables session id caching using OpenSSL&#039;s default setting. Default value is &quot;No&quot;.', '', 'Select from radio box', '');
$this->db['sslSessionCacheSize'] = new DATTR_HELP_ITEM("Session Cache Size (bytes)", 'Sets the maximum number of SSL session IDs to store in the cache. Default is 1,000,000.', '', 'Integer number', '');
$this->db['sslSessionCacheTimeout'] = new DATTR_HELP_ITEM("Session Cache Timeout (secs)", 'This value determines how long a session ID will be valid within the cache before renegotiation is required. Default is 3,600.', '', 'Integer number', '');
$this->db['sslSessionTicketKeyFile'] = new DATTR_HELP_ITEM("SSL Session Ticket Key File", 'Allows the SSL Ticket Key to be created/maintained by an administrator. The file must be 48 bytes long. If this option is left empty, the load balancer will generate and rotate its own set of keys.<br/><br/>IMPORTANT: To maintain forward secrecy, it is strongly recommended to change the key every <b>SSL Session Ticket Lifetime</b> seconds. If this cannot be done, it is recommended to leave this field empty.', '', 'Path', '');
$this->db['sslSessionTicketLifetime'] = new DATTR_HELP_ITEM("SSL Session Ticket Lifetime (secs)", 'This value determines how long a session ticket will be valid before a renegotiation is required. Default is 3,600.', '', 'Integer number', '');
$this->db['sslSessionTickets'] = new DATTR_HELP_ITEM("Enable Session Tickets", 'Enables session tickets using OpenSSL&#039;s default session ticket setting. Server-level setting must be set to &quot;Yes&quot; for Virtual Host setting to take effect.<br/><br/>Default values:<br/><b>Server-level:</b> Yes<br/><b>VH-Level:</b> Yes', '', 'Select from radio box', '');
$this->db['sslStrictSni'] = new DATTR_HELP_ITEM("Strict SNI Certificate", 'Specifies whether to strictly require a dedicated virtual host certificate configuration. When enabled, SSL connections to virtual hosts without a dedicated certificate configuration will fail instead of using a default catch-all certificate.<br/><br/>Default value: No', '', 'Select from radio box', '');
$this->db['sslStrongDhKey'] = new DATTR_HELP_ITEM("SSL Strong DH Key", 'Specifies whether to use 2048 or 1024 bit DH keys for SSL handshakes. If set to &quot;Yes&quot;, 2048 bit DH keys will be used for 2048 bit SSL keys and certificates. 1024 bit DH keys will still be used in other situations. Default is &quot;Yes&quot;.<br/><br/>Earlier versions of Java do not support DH key size higher than 1024 bits. If Java client compatibility is required, this should be set to &quot;No&quot;.', '', 'radio', '');
$this->db['staticReqPerSec'] = new DATTR_HELP_ITEM("Static Requests/Second", 'Specifies the maximum number of requests to static content coming from a single IP address that can be processed in a single second regardless of the number of connections established.<br/><br/>When this limit is reached, all future requests are tar-pitted until the next second. Request limits for dynamically generated content are independent of this limit. Per-client request limits can be set at server- or virtual host-level. Virtual host-level settings override server-level settings.', ' Trusted IPs or sub-networks are not affected.', 'Integer number', '');
$this->db['statuscode'] = new DATTR_HELP_ITEM("Status Code", 'Specifies the response status code of the external redirection. If the status code is between 300 and 399, &quot;Destination URI&quot; can be specified.', '', 'Select from drop down list', '');
$this->db['suexecGroup'] = new DATTR_HELP_ITEM("suEXEC Group", 'At the current context level, run as this group. Either <b>suEXEC User</b> at the Virtual Host level, or <b>Run As User</b> at the External Application level, must be set for <b>suEXEC Group</b> to take effect.<br/><br/>This configuration can be overridden at the External Application level using the <b>Run As Group</b> setting.<br/><br/>Default value: <b>suExec User</b> setting value', '', 'Valid group name or uid', '');
$this->db['suexecUser'] = new DATTR_HELP_ITEM("suEXEC User", 'At the current context level, run as this user. If set, this value will override the Virtual Host level <b>ExtApp Set UID Mode</b> setting.<br/><br/>This configuration may be overridden at the External Application level using the <b>Run As User</b> setting.<br/><br/>Default value: Not Set', '', 'Valid user name or uid.', '');
$this->db['suffix'] = new DATTR_HELP_ITEM("Suffix", 'Specifies the script file suffixes that will be handled by this  script handler. Suffixes must be unique.', 'The server will automatically add a special MIME type (&quot;application/x-httpd-[suffix]&quot;) for the first  suffix in the list. For example, MIME type &quot;application/x-httpd-php53&quot; will be added  for suffix &quot;php53&quot;. Suffixes after the first need to set up in the &quot;MIME Settings&quot; settings.<br/>Though we list suffixes in this field, the script handlers use MIME types, not suffixes,  to decide which scripts to handle. You can thus use the Apache configuration directives  &quot;AddType&quot; and &quot;ForceType&quot; (which control file MIME types) in .htaccess files to change  which script handler certain files will use. For example, with the directive   AddType application/x-httpd-php53 .php in a properly placed .htaccess file,  you can stipulate that php files in this directory have the MIME type &quot;application/x-httpd-php53&quot; and  thus will be handled by the script handler that uses MIME type &quot;application/x-httpd-php53&quot;  (suffix &quot;php53&quot;). This then allows you to assign different script handlers, not only for  different file suffixes, but also based on the locations of files.<br/> Only specify the suffixes you really need.', 'Comma delimited list with period &quot;.&quot; character prohibited.', '');
$this->db['suffixes'] = new DATTR_HELP_ITEM("Suffix", 'Specifies what kinds of files will be protected from hotlinking by listing file suffixes.', '', 'Comma delimited list. &quot;.&quot; is prohibited', '');
$this->db['swappingDir'] = new DATTR_HELP_ITEM("Swapping Directory", 'Specifies the directory where the swapping files should be placed. When the server is started in chroot mode, this directory is relative to the new root directory, otherwise it is relative to the real root directory.<br/><br/>The server uses its own virtual memory to reduce system memory usage. Virtual memory and disk swapping are used to store large request bodies and dynamically generated responses. The swapping directory should be placed on a disk with enough space.<br/><br/>Default value: /tmp/lshttpd/swap', ' Place the swapping directory on a separate disk or increase Max I/O Buffer Size to eliminate swapping.', 'Absolute path', '');
$this->db['templateFile'] = new DATTR_HELP_ITEM("Template File", 'Specifies the path to the configuration file of this template. The file must be located within $SERVER_ROOT/conf/templates/ with a &quot;.xml&quot; filename. If the file you designate does not exist, after trying to save the template an error will appear with the link &quot;CLICK TO CREATE&quot;. This link will generate a new empty template file. When you delete the template, the entry will be removed from your configurations, but the actual template config file will not be deleted.', '', 'path', '');
$this->db['templateFileRef'] = new DATTR_HELP_ITEM("Config File", 'Specifies the unique path for each member virtual host&#039;s configuration file. Variable $VH_NAME or $VH_ROOT must appear in the path so each member virtual host will have its own configuration file.', '', 'path with $VH_NAME or $VH_ROOT variable', '');
$this->db['templateName'] = new DATTR_HELP_ITEM("Template Name", 'A unique name for the template.', '', '', '');
$this->db['templateVHAliases'] = new DATTR_HELP_ITEM("Aliases", 'Specifies alternate names for the virtual host. All possible hostnames and IP addresses should be added to this list. The wildcard characters * and ? are allowed in the name. Append :<port> for web sites not on port 80.<br/><br/>Aliases will be used in the following situations: <ol>   <li>To match the hostname in the Host header when processing a   request.</li>   <li>To populate domain name/alias configurations for add-ons   like FrontPage or AWstats.</li>   <li>To configure listener-to-virtual host mappings based on the virtual host template.</li> </ol>', '', 'Comma-separated list of domain names.', '');
$this->db['templateVHConfigFile'] = new DATTR_HELP_ITEM("Instantiated VHost Config File", 'Specifies the location of the config file generated when you instantiate a member virtual host.  Variable $VH_NAME must appear in the path so each virtual host will have its own file. Suggested location is $SERVER_ROOT/conf/vhosts/$VH_NAME.xml. This config file will  be created only after you move a member vhost out of the template through instantiation.', '', 'String with $VH_NAME variable and .xml suffix', '');
$this->db['templateVHDocRoot'] = new DATTR_HELP_ITEM("Document Root", 'Specifies the unique path for each member virtual host&#039;s document root.   Variable $VH_NAME or $VH_ROOT must appear in the path so  each member virtual host will have its own document root.', '', 'path with $VH_NAME or $VH_ROOT variable', '$VH_ROOT/public_html/ or $SERVER_ROOT/$VH_NAME/public_html.');
$this->db['templateVHDomain'] = new DATTR_HELP_ITEM("Domain", 'Specifies the main domain name for this member virtual host. If left blank, the virtual host name will be used. This should be a fully qualified domain name, but you can use an IP address as well. It is recommended to append :<port> for web sites not on port 80. For configurations containing domain names, this domain can be referenced with variable $VH_DOMAIN.<br/><br/>This domain name will be used in the following situations: <ol>   <li>To match the hostname in the Host header when processing a   request.</li>   <li>To populate domain name configurations for add-ons   like FrontPage or AWstats.</li>  <li>To configure listener-to-virtual host mappings based on the virtual host template.</li> </ol>', '', 'domain name', '');
$this->db['templateVHName'] = new DATTR_HELP_ITEM("Virtual Host Name", 'A unique name for this virtual host. This name must be unique among all template member virtual hosts and standalone virtual hosts. Inside a directory path configuration, this name can be referenced by the variable $VH_NAME.<br/><br/>If a standalone virtual host with the same name is also configured, then the member virtual host configuration will be ignored.', '', '', '');
$this->db['templateVHRoot'] = new DATTR_HELP_ITEM("Default Virtual Host Root", 'Specifies the default root directory for member virtual hosts using this template.  Variable $VH_NAME must appear in the path. This will allow each member template  to be automatically assigned a separate root directory based on its name.', '', 'path', '');
$this->db['toggleDebugLog'] = new DATTR_HELP_ITEM("Toggle Debug Logging", 'Toggle Debug Logging toggles the value of &quot;Debug Level&quot; between NONE and HIGH.  As debug logging has an impact on performance and can fill up the hard drive quickly, so &quot;Debug Level&quot; should usually be set to NONE on a production server.  This feature can be used instead to turn debug logging on and off quickly  in order to debug a problem on a production server. Debug logging turned on or  off in this way will not change anything shown in your server configurations.', '&quot;Toggle Debug Logging&quot; will only work if &quot;Log Level&quot;  is set to DEBUG.   Important! Debug logging includes detailed information for each  request and response. Active debug logging will severely degrade service performance and potentially saturate disk space in a very short time. This feature should only be  used for a short period of time when trying to diagnose server issues.', '', '');
$this->db['totalBandwidth'] = new DATTR_HELP_ITEM("Total Output Bandwidth (KB/sec)", 'Sets a limit for the total output bandwidth in KB/s for this virtual host. Once this limit is reached throttling will occur.', '', '', '');
$this->db['totalInMemCacheSize'] = new DATTR_HELP_ITEM("Total Small File Cache Size (bytes)", 'Specifies the total memory that can be allocated to the buffer cache in order to cache/serve small static files.', '', 'Integer number', '');
$this->db['totalMMapCacheSize'] = new DATTR_HELP_ITEM("Total MMAP Cache Size (bytes)", 'Specifies the total memory that can be allocated for memory- mapped cache in order to cache/serve medium sized static files.', '', 'Integer number', '');
$this->db['umask'] = new DATTR_HELP_ITEM("umask", 'Sets default umask for CGI processes. See  man 2 umask  for details. This also serves as the default value for external applications &quot;umask&quot;.', '', 'value valid range [000]-[777].', '');
$this->db['updateInterval'] = new DATTR_HELP_ITEM("Update Interval", 'Specifies how often AWstats statistics are updated. Options are daily or hourly.', '', 'Select from drop down list', '');
$this->db['updateMode'] = new DATTR_HELP_ITEM("Update Mode", 'Specifies how AWStats statistics are being updated:   <ul>    <li> Disabled: AWStats is disabled. Statistics will not be updated. </li>    <li> Static: Static HTML pages will be created after the statistics have been updated. </li>    <li> Dynamic: The statistics will be updated, but static pages will not be created.     HTML pages will be generated dynamically by the CGI script awstats.pl.</li> </ul>', '', 'Select from drop down list', '');
$this->db['updateOffset'] = new DATTR_HELP_ITEM("Update Offset", 'Specifies when the update should be performed during the &quot;Update Interval&quot;.', 'If many virtual hosts are hosted on one server, it is recommended to spread out  the &quot;Update Offset&quot; to avoid multiple AWstats processes running at the same time and server overload. Log processing is a CPU and I/O intensive task.', 'Number of seconds.', 'Set this to 3600 to start statistic processing at 1AM for &quot;Daily&quot; update.');
$this->db['uploadTmpDir'] = new DATTR_HELP_ITEM("Temporary File Path", 'Temporary directory where files being uploaded to server will be stored  while request body parser is working. Default value is /tmp.', '', 'Absolute path or path starting with $SERVER_ROOT (for Server and VHost levels).', '');
$this->db['uploadTmpFilePermission'] = new DATTR_HELP_ITEM("Temporary File Permissions", 'Global setting determining file permissions used for files stored in the <b>Temporary File Path</b> directory.', '', '3 digits octet number. Default value is 666.', '');
$this->db['uri'] = new DATTR_HELP_ITEM("URI", 'Specifies the URI for this context. The URI should start with a &quot;/&quot;. If a URI ends with a &quot;/&quot;, then this context will include all sub-URIs under this URI.', '', 'URI', '');
$this->db['useAIO'] = new DATTR_HELP_ITEM("Use AIO", 'Specifies whether to use AIO to serve static files. AIO will help if your server has a high I/O wait. For 64bit operation system, there is an option to keep files mapped in process address space to improve AIO performance.', '', 'Select from drop down list', '');
$this->db['useIpInProxyHeader'] = new DATTR_HELP_ITEM("Use Client IP in Header", 'Specifies whether to use the first most valid IP IP address listed in the &quot;X-Forwarded-For&quot; HTTP request header for all IP address-related features, including connection/bandwidth throttling, access control, and IP geolocation.<br/><br/>This feature is useful if your web server is behind a load balancer or a proxy server. If you select Trusted IP Only, then X-Forwarded-For IP will be used only when the request is coming from trusted IPs defined in the server-level &quot;Allowed List&quot;.<br/><br/>Keep Header from Trusted IP is the same as Trusted IP Only, but the X-Forwarded-For header used for the backend will not be modified to include the connecting peer address.<br/><br/>Use Last IP (for AWS ELB) will use the last IP address in the &quot;X-Forwarded-For&quot; list. Select this option if you are using AWS Elastic Load Balancer or expect the real IP to appended to the end of the &quot;X-Forwarded-For&quot; list.', '', 'Select from drop down list', '');
$this->db['useRe2'] = new DATTR_HELP_ITEM("Use RE2 regex engine", 'Use RE2 when evaluating regular expressions instead of PCRE.<br/><br/>Default value: No', ' While PCRE provides more features than RE2, RE2 allows for a defined maximum memory usage and has a more predictable runtime than PCRE making it more suited for use in server applications.<br/> Unlike PCRE, RE2 uses a fixed stack and guarantees that run-time increases linearly (not exponentially) with the size of the input.', 'Select from radio box', '');
$this->db['useSendfile'] = new DATTR_HELP_ITEM("Use sendfile()", 'Specifies whether to use the sendfile() system call to serve static files. Static files can be served in four different ways: memory buffer cache, memory-mapped cache, plain read/write, and sendfile(). Files smaller than the &quot;Max Cached Small File Size (bytes)&quot; are served from memory buffer cache. Files larger than the &quot;Max Cached Small File Size (bytes)&quot; but smaller than the &quot;Max MMAP File Size (bytes)&quot; will be served from memory-mapped cache. Files larger than the &quot;Max MMAP File Size (bytes)&quot; will be served via plain read/write or sendfile(). Sendfile() is a &quot;zero copy&quot; system call that can greatly reduce CPU utilization when serving very large static files. Sendfile() requires an optimized network card kernel driver and thus may not be suitable for some small-vendor network adapters.', '', 'Select from radio box', '');
$this->db['userDBCacheTimeout'] = new DATTR_HELP_ITEM("User DB Cache Timeout (secs)", 'Specifies how often the backend user database will be checked for changes. Every entry in the cache has a timestamp. When cached data is older than the specified timeout, the backend database will be checked for changes. If there is no change, the timestamp will be reset to the current time, otherwise the new data will be loaded. Sevrer reload and graceful restart will clear the cache immediately.', ' If the backend database does not change very often, set a longer timeout for better performance.', 'Integer number', '');
$this->db['userDBLocation'] = new DATTR_HELP_ITEM("User DB Location", 'Specifies the location of the user database. For DB type Password File, it is the path to the flat file containing user/password definitions. You can edit this file through the WebAdmin console by clicking on the filename.<br/><br/>Each line of the user file contains a username followed by a colon, followed by a crypt() encrypted password, optionally followed by a colon and group names that user belongs to. Group names are delimitated by commas. If group information is specified in the user database, then the group database will not be checked.<br/><br/>Example:<blockquote><code>john:HZ.U8kgjnMOHo:admin,user</code></blockquote><br/><br/>For DB type LDAP, it is the LDAP URL to query for the user information. For each valid user, the authentication data stored in the LDAP server should contain at least the user id and user password. One and only one record should be returned in the LDAP search request based on the URL and username received in the HTTP Authentication header. &quot;$k&quot; must be specified in the filter part of the URL and it will be replaced with the username. The user password attribute must be returned in the query result. The attribute name of the user password is specified by &quot;Password Attribute&quot;. Group information can be optionally specified by the &quot;Member-of Attribute&quot;.<br/><br/>Example: At minimum, a user can be defined in LDAP with object classes: uidObject, simpleSecurityObject and organizationalRole. The following URL could be used:<br/><br/><blockquote><code>ldap://localhost/ou=UserDB,dc=example,dc=com???(&(objectClass=*)(uid=$k))</code></blockquote>', ' It is recommended to store user password files outside of the document tree. If a user password file has to be placed inside document tree, simply name it with a leading &quot;.ht&quot; like .htuser to prevent it being served as a static file.  LiteSpeed Web Server does not serve files prefixed with &quot;.ht&quot;.', 'Path to user DB file or LDAP URL (RFC 2255).', '');
$this->db['userDBMaxCacheSize'] = new DATTR_HELP_ITEM("User DB Max Cache Size", 'Specifies the maximum cache size of the user database. Recently accessed user authentication data will be cached in memory to provide maximum performance.', ' As a larger cache will consume more memory, a higher value may or may not provide better performance. Set it to an appropriate size according to your user database size and site usage.', 'Integer number', '');
$this->db['userDB_attrMemberOf'] = new DATTR_HELP_ITEM("Member-of Attribute", 'Specifies the name of the &quot;Member-of&quot; attribute for a user record stored in an LDAP server. The default value is memberOf. The &quot;Member-of&quot; attribute can be used to specify the group name that the user belongs to.', '', 'string', '');
$this->db['userDB_attrPasswd'] = new DATTR_HELP_ITEM("Password Attribute", 'Specifies the name of the password attribute for a user record stored in an LDAP server. The default value is userPassword.', '', 'string', '');
$this->db['vaction'] = new DATTR_HELP_ITEM("Actions - Virtual Host", 'This field shows buttons to disable, enable, or restart the virtual host.   Actions taken on one virtual host do not affect the rest of the web server.', 'It is good idea to disable a virtual host temporarily when updating its content.', '', '');
$this->db['vdisable'] = new DATTR_HELP_ITEM("Disable", 'The Disable action stops a running virtual host. New requests will not be accepted, but requests being processed will finish as usual.', '', '', '');
$this->db['venable'] = new DATTR_HELP_ITEM("Enable", 'The Enable action starts up a stopped virtual host.   This allows new requests to be accepted.', '', '', '');
$this->db['verifyDepth'] = new DATTR_HELP_ITEM("Verify Depth", 'Enterprise Edition Only Specifies how deeply a certificate should be verified before determining that the client does not have a valid certificate. The default is &quot;1&quot;.', '', 'Select from drop down list', '');
$this->db['verifyExpires'] = new DATTR_HELP_ITEM("Verification Expires (secs)", 'Sets the expire time of a successful reCAPTCHA submission, after which reCAPTCHA protection will re-trigger for that visitor.<br/><br/>Default value: 86,400 (1 day).', '', 'Integer value between 30 and 31,536,000 (1 year).', '');
$this->db['verifyGoogleBot'] = new DATTR_HELP_ITEM("Verify Google Bot", 'Perform a PTR lookup to ensure that the reverse DNS of an IP matches Google&#039;s crawler information and bypass reCAPTCHA verification if so.  Bad Google bot IPs are logged.<br/><br/>Default value: No', '', 'Select from radio box', '');
$this->db['vermgr'] = new DATTR_HELP_ITEM("Version Management", 'Version Management (found by clicking on the the version number at  the top of the page) is a convenient tool to manage LSWS versions. It shows license info and information on all installed versions and available new releases.   <ul><li>If a new version has been released on the LiteSpeed website, and &quot;Check For Update&quot; is  enabled, the new version will be listed with a Download link. If &quot;Download Updates&quot; is enabled, new versions will be automatically downloaded and the new version  will be listed with an Upgrade link. Upgrade  installs the new package and restarts the web server. </li> <li>You return to a previous version by clicking the Switch To link. This will restart the web server with that version.</li> <li>If you are sure that you no longer need an old installation, you can remove it by clicking the Delete link. This will permanently remove that copy.</li></ul>  Please note, service will not be interrupted during an upgrade or restart.', '', '', '');
$this->db['vhEnableGzip'] = new DATTR_HELP_ITEM("Enable Compression", 'Specifies whether to enable GZIP/Brotli compression for this virtual host. This setting is only effective when compression is enabled at the server level. Compression settings are configured at the server level (Tuning > GZIP/Brotli Compression).', '', 'Select from radio box', '');
$this->db['vhEnableQuic'] = new DATTR_HELP_ITEM("Enable HTTP3/QUIC", 'Enables the HTTP3/QUIC network protocol for this virtual host. For this setting to take effect, both &quot;Enable HTTP3/QUIC&quot; and &quot;Open HTTP3/QUIC (UDP) port&quot; must also be set to Yes at the server and listener levels respectively. Default value is Yes.', 'When this setting is set to No, the HTTP3/QUIC advertisement will no longer be sent. If a browser still contains cached HTTP3/QUIC information and HTTP3/QUIC is still enabled at the server and listener levels, an HTTP3/QUIC connection will continue to be used until this information is no longer cached or an HTTP3/QUIC protocol error is encountered.', 'Select from radio box', '');
$this->db['vhHotlink'] = new DATTR_HELP_ITEM("Hotlink Protection", 'Hotlinks are requests made from an external website to files on your own website often referred to as &quot;leeching&quot;. This practice introduces additional bandwidth usage that you should not be responsible for.<br/><br/>LiteSpeed web server can prevent others from hotlinking to content on your web site by checking the Referer header within an HTTP request. If the Referer header does not match your website, the request will be denied.', '', '', '');
$this->db['vhMaxKeepAliveReq'] = new DATTR_HELP_ITEM("Max Keep-Alive Requests", 'Specifies the maximum requests that can be served through a keep-alive (persistent) connection. Connections will be closed once this limit is reached. You can specify a different limit for each virtual hosts. This number cannot exceed the server-level &quot;Max Keep-Alive Requests&quot; limit.', ' Set to a reasonably high value. A value of &quot;1&quot; or less will disable keep-alive connections.', 'Integer number', '');
$this->db['vhName'] = new DATTR_HELP_ITEM("Virtual Host Name", 'A unique name for a virtual host. It is recommended to use the virtual host&#039;s domain name as the Virtual Host Name. Virtual Host Name can be referred to using the variable $VH_NAME.', '', '', '');
$this->db['vhRoot'] = new DATTR_HELP_ITEM("Virtual Host Root", 'Specifies the root directory of the virtual host. Note: This is <b>NOT</b> the document root. It is recommended to place all files related to the virtual host (like log files, html files, CGI scripts, etc.) under this directory. Virtual Host Root can be referred to using the variable $VH_ROOT.', ' Place different virtual hosts on different hard drives.', 'An absolute path or a relative path to $SERVER_ROOT.', '');
$this->db['vhaccessLog_fileName'] = new DATTR_HELP_ITEM("File Name", 'The access log filename.', ' Put access log file on a separate disk.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT, $VH_ROOT.', '');
$this->db['vhadminEmails'] = new DATTR_HELP_ITEM("Administrator Email", 'Specifies email address(es) of the administrator(s) of this virtual host.', '', 'Comma separated list of email addresses', '');
$this->db['vhlog_fileName'] = new DATTR_HELP_ITEM("File Name", 'Specifies the path for the log file.', ' Place the log file on a separate disk.', 'Filename which can be an absolute path or a relative path to $SERVER_ROOT, $VH_ROOT.', '');
$this->db['vhlog_logLevel'] = new DATTR_HELP_ITEM("Log Level", 'Specifies the level of logging. Available levels (from high to low) are ERROR,  WARNING, NOTICE, INFO, and DEBUG.  Only messages with a level higher than or equal to the current setting will be logged.  If you want to set it to DEBUG, you must set the server log level to DEBUG as well.  The level of debugging is controlled solely at the server level by &quot;Debug Level&quot;.', ' Unless &quot;Debug Level&quot; is set to a level other than NONE, DEBUG log level does not have any performance impact and is recommended.', 'Select from drop down list', '');
$this->db['viewlog'] = new DATTR_HELP_ITEM("Server Log Viewer", 'The Server Log Viewer is a convenient tool for browsing the  current server log to check for errors or problems.  The log viewer  searches the server log file in blocks for the specified log level.    The default block size is 20KB. You can use the Begin, End, Next, and Prev buttons to navigate a large log file.', 'The size of a dynamically generated page is limited by &quot;Max Dynamic Response Body Size (bytes)&quot;.   So if the block is too big, the page might be truncated.', '', '');
$this->db['virtualHostMapping'] = new DATTR_HELP_ITEM("Virtual Host Mappings", 'Specifies the relationship between the listener and virtual hosts. Listeners and virtual hosts are associated by domain names. An HTTP request will be routed to a virtual host with a matching domain name. One listener can map to multiple virtual hosts for different domain names. One virtual host can also be mapped from different listeners. One listener can allow one catchall virtual host with the domain name value &quot;*&quot;. When there is no explicitly matched domain name in the listener&#039;s mapping, the listener will forward the request to that catchall virtual host.', ' Only add necessary mappings. If the listener is mapped to only one virtual host, then only set up a catchall mapping &quot;*&quot;.', '', '');
$this->db['virtualHostName'] = new DATTR_HELP_ITEM("Virtual Host", 'Specifies the name of a virtual host.', '', 'Select from drop down list', '');
$this->db['vname'] = new DATTR_HELP_ITEM("Name - Virtual Host", 'The unique name that identifies this virtual host. This is the &quot;Virtual Host Name&quot;  you specified when setting up this virtual host.', '', '', '');
$this->db['vreload'] = new DATTR_HELP_ITEM("Restart - Virtual Host", 'The Restart action causes the web server to load the newest configuration  for this virtual host. Requests being processed will finish with the old configuration.  The new configuration will only apply for new requests. All changes to a virtual host  can be applied on the fly this way.', '', '', '');
$this->db['vstatus'] = new DATTR_HELP_ITEM("Status - Virtual Host", 'The current status of a virtual host.   The status can be: Running, Stopped, Restart Required,   or Running - Removed from Configuration.  <ul>     <li>Running means the virtual host is loaded and in service.</li>     <li>Stopped means the virtual host is loaded but not in service (disabled). </li>     <li> Restart Required means this is a newly added virtual host and          the server has not yet loaded its configuration. </li>     <li>Running - Removed from Configuration means the virtual host has been deleted      from the server&#039;s configuration but it is still in service. </li> </ul>', '', '', '');
$this->db['workingDir'] = new DATTR_HELP_ITEM("Working Directory", 'Specifies the &quot;DataDir&quot; parameter in the AWStats configuration file.  All results files and AWStats databases will be stored there.  This directory should be writable by the owner of the document root of this virtual host. Usually the working directory should be set to under  the virtual host root like $VH_ROOT/awstats/.', '', 'A path which can be absolute, relative to $SERVER_ROOT, or relative to $VH_ROOT.', '');
$this->db['wpProtectAction'] = new DATTR_HELP_ITEM("Protection Mode", 'Specifies the action to be taken when the specified Allowed Login Attempts limit is reached within 5 minutes.<br/><br/>Throttle gradually slows down the speed of the server response, Drop severs the connection without any reply, Deny returns a 403 response, and CAPTCHA or Drop redirects to a CAPTCHA if reCAPTCHA Protection is enabled and drops otherwise.<br/><br/>WP Login CAPTCHA Full Protection can also be selected. This setting will redirect to a CAPTCHA if ReCAPTCHA Protection is enabled regardless of Allowed Login Attempts limit and falls back to use Throttle otherwise.<br/><br/>Default values:<br/><b>Server level:</b> Throttle<br/><b>VH level:</b> Inherit Server level setting. If Server level is set to Disable, Throttle will be used.', ' Trusted IPs or sub-networks are not affected.<br/> This feature is enabled by default (Throttle) and does not need any further configuration in the WebAdmin GUI or in Apache configurations.<br/> This setting will override Apache conf WordPressProtect setting for LSWS only. Apache will be unaffected.<br/><br/> This can be set at the Server level and overwritten at the Virtual Host level. If not overridden at the Virtual Host level, this setting can also be overridden in a user&#039;s docroot .htaccess file using Apache configuration directive WordPressProtect with value 0 (disabled), 1 (use server level setting), throttle, deny, or drop.', 'Select from drop down list', '');
$this->db['wpProtectLimit'] = new DATTR_HELP_ITEM("Allowed Login Attempts", 'Specifies the maximum number of wp-login.php and xmlrpc.php POST attempts allowed by an IP within 5 minutes before the action specified in &quot;Protection Mode&quot; is taken.<br/><br/>This limit is handled using a quota system where remaining attempts = limit. Each POST attempt will decrease the number of remaining attempts by 1, with the number of remaining attempts increasing back to the set limit over time. An IP will be throttled once the number of remaining attempts for that IP falls to 1/2 the set limit, throttling more as the remaining attempts drops further below the 1/2 mark. When remaining attempts reaches 0, the specified action is taken toward the IP.<br/><br/>In addition to this, if &quot;Enable reCAPTCHA&quot; is also enabled, an additional per worker protection will be added. If wp-login.php and xmlrpc.php are visited by the same worker at a rate of 4x the set limit in a 30 second time frame, those URLs will be put into reCAPTCHA mode until the number of visits to these files decreases.<br/><br/>Resetting the server will clear blocked IPs.<br/><br/>Default values:<br/><b>Server-level:</b> 10<br/><b>VH-Level:</b> Inherit Server level setting', ' Trusted IPs or sub-networks are not affected.<br/><br/> This setting will override Apache conf WordPressProtect setting for LSWS only. Apache will be unaffected.<br/><br/> This can be set at the Server level and overwritten at the Virtual Host level. If not overridden at the Virtual Host level, this setting can also be overridden in a user&#039;s docroot .htaccess file using Apache configuration directive WordPressProtect with integer value between 3 and 1000.', 'Valid Range: 3 - 1000.', 'With an Attempt limit of 10, and a Mode of drop:<br/><br/>After the first POST attempt, the quota is decreased to 9.<br/><br/>Quota decreases by 1 for each POST attempt.<br/><br/>After Quota reaches half of the limit (5), the IP will be throttled.<br/><br/>Throttling will get worse with each POST attempt.<br/><br/>Once the quota reaches 0, the connection will be dropped.');
$this->db['wsaddr'] = new DATTR_HELP_ITEM("Address", 'A unique socket address used by the WebSocket backend.  IPv4 sockets, IPv6 sockets, and Unix Domain Sockets (UDS) are supported.  IPv4 and IPv6 sockets can be used for communication over the network.  UDS can only be used when the WebSocket backend resides on the same machine as the server.', ' If the WebSocket backend runs on the same machine,  UDS is preferred. If you have to use an IPv4 or IPv6 socket,  set the IP address to localhost or 127.0.0.1, so the WebSocket backend  is inaccessible from other machines.<br/> Unix Domain Sockets generally provide higher performance than IPv4 or IPv6 sockets.', 'IPv4/IPv6 address:port, UDS://path, or unix:path', '127.0.0.1:5434 <br/>UDS://tmp/lshttpd/php.sock<br/>unix:/tmp/lshttpd/php.sock');
$this->db['wsgiBin'] = new DATTR_HELP_ITEM("WSGI Path", 'Path to LiteSpeed Python Web Server Gateway Interface executable (lswsgi).<br/><br/>This executable is created by compiling Python with LiteSpeed&#039;s WSGI LSAPI module.', '', 'Absolute path', '');
$this->db['wsgiDefaults'] = new DATTR_HELP_ITEM("Python WSGI Default Settings", 'Default configurations for Python WSGI applications. These settings can be overriden at the context level.', '', '', '');
$this->db['wsuri'] = new DATTR_HELP_ITEM("URI", 'Specifies the URI(s) that will use this WebSocket backend. Traffic to  this URI will only be forwarded to the WebSocket backend when it contains  a WebSocket upgrade request. <br/><br/>Traffic without this upgrade request will automatically be forwarded to the  Context that this URI belongs to. If no Context exists for this URI,  LSWS will treat this traffic as though it is accessing a static context with  the location $DOC_ROOT/URI.', '', 'A plain URI (starting with &quot;/&quot;). If the URI ends with a &quot;/&quot;,  then this WebSocket backend will include all sub-URIs under this URI.', 'Using the WebSocket proxy in conjunction with a Context  allows you to serve different kinds of traffic in different ways  on the same page, thus optimizing performance. You can send WebSocket  traffic to the WebSocket backend, while setting up a static context so  that LSWS can serve the page&#039;s static content, or an LSAPI context so LSWS  will serve PHP content (both of which LSWS does more efficiently  than the WebSocket backend).');
$this->edb['UDBgroup'] = array('If group information is added here, this information will be used for resource authorization and any group database settings involving this user will be ignored.','You can enter multiple groups, using a comma to separate them. Space characters will be treated as part of a group name.');
$this->edb['accessControl_allow'] = array('You can set up access control at server, virtual host and context levels. If there is access control at server level, the virtual host rules will be applied after the server rules are satisfied.','Input format can be an IP like 192.168.0.2, a sub-network like 192.168.*, or a subnet/netmask like 192.168.128.5/255.255.128.0.','If you have trusted IP or sub-network, then you must specify them in allowed list by adding a trailing &quot;T&quot; such as 192.168.1.*T. Trusted IP or sub-network is not limited by connection/throttling limit.');
$this->edb['accessControl_deny'] = array('To deny access from certain address, put &quot;ALL&quot; in allowed list, and put subnet or IP in denied list. To allow only certain IP or subnet to access the site, put &quot;ALL&quot; in denied list and specify the address in the allowed list.');
$this->edb['accessDenyDir'] = array('Enter a full path if you want to deny access for specific directory; entering a path followed by * will disable all the sub directories.','Path can be either absolute or relative to $SERVER_ROOT, use comma to separate.','If both <b>Follow Symbolic Link</b> and <b>Check Symbolic Link</b> are enabled, symbolic links will be checked against the denied directories.');
$this->edb['accessFileName'] = array('It is recommended to use a hidden access file. To do this simply start the filename with &quot;.&quot;, similar to &quot;.htaccess&quot;. LiteSpeed Web Server does not serve hidden files.');
$this->edb['accessLog_fileName'] = array('Log file path can be an absolute path or relative to $SERVER_ROOT.');
$this->edb['aclogUseServer'] = array('When required, you can disable access logging for this virtual host to save on disk i/o.');
$this->edb['adminEmails'] = array('You can enter multiple admin emails: use comma to separate.');
$this->edb['adminOldPass'] = array('For security reasons, if you forget the admin password, you will be unable to change it from the WebAdmin Console.  Please use the following shell command instead:  <br><br> /usr/local/lsws/admin/misc/admpass.sh.  <br><br> This script will remove all entered admin user IDs and overwrite them with a single admin user.');
$this->edb['allowBrowse'] = array('Static context can be used to map a URI to a directory either outside document root or within it. The directory can be absolute path or relative to document root(default), $VH_ROOT or $SERVER_ROOT.','Check &quot;Accessible&quot; will allow browsing static files in this context. You may want to disable it to prevent viewing static files, for e.g. when you update the content.');
$this->edb['allowDirectAccess'] = array('Set &quot;Allow Direct Access&quot; to &quot;Yes&quot; if it is preferred to allow direct access without a referrer. For e.g., there is no referrer when a user key in a url in a browser and some proxy will suppress &quot;Referrer&quot; header.');
$this->edb['allowOverride'] = array('Allow Override configuration is available at the Server, Virtual Host, and Context levels. Lower levels can disable a setting that is enabled at a higher level, but cannot enable a setting that is disabled at a higher level.','When all checkboxes are unchecked, default settings will be used.');
$this->edb['appType'] = array('','');
$this->edb['as_location'] = array('The App Server context is for easy configuration of running Rack/Rails, WSGI, or Node.js applications. You only need to specify the root location of your application in the &quot;Location&quot; field.');
$this->edb['as_startupfile'] = array('','');
$this->edb['autoFix503'] = array('When you enable <b>Auto Fix 503 Error</b>, the monitor process will automatically launch a new server process and service will resume instantly if a crash is detected.');
$this->edb['backlog'] = array('Local applications can be started by the web server. In this case, you need to specify the path, backlog and number of instances.');
$this->edb['binPath'] = array('','');
$this->edb['bubbleWrap'] = array('');
$this->edb['bubbleWrapCmd'] = array('');
$this->edb['censorRuleSet'] = array('If you are using apache config file, you have to set up rules in httpd.conf and rules defined here have no effect.');
$this->edb['cgi_path'] = array('A CGI context can be used to specify a directory only contains CGI scripts. Path can be absolute path or relative to $SERVER_ROOT, $VH_ROOT or $DOC_ROOT(default). Path and URI must be ended with &quot;/&quot; for a cgi-bin directory.','If only a specific script is needed in that directory, it is recommended to create a CGI context for that script only. In this case, path and URI need not be a directory. For e.g., path can be ~/myapp/myscript.pl, URI can be /myapp/myscript.pl. All other files will not be served as CGI.');
$this->edb['checkSymbolLink'] = array('Check-Symbolic-Link control will take effect only if Follow-Symbolic-Link is turned on. This controls whether symbolic links are checked against Access Denied Directories.');
$this->edb['compressibleTypes'] = array('Compressible Types is a list of MIME types that are compressible, separated by commas. You can use wildcard &quot;*&quot; for MIME types, like */*, text/*. You can put &quot;!&quot; in front to exclude certain types. The order of the list is important if you use &quot;!&quot;. For e.g., a list like &quot;text/*, !text/css, !text/js&quot; will compress all text file except for css and js.');
$this->edb['ctxType'] = array('<b>Static</b> context can be used to map a URI to a directory either outside document root or within it.','<b>Java Web App</b> context is used to automatically import a predefined Java Application in an AJPv13 compilant Java servlet engine.','<b>Servlet</b> context is used to import a specific servlet under a web application.','<b>Fast CGI</b> context is a mount point of Fast CGI application.','<b>LiteSpeed SAPI</b> context can be used to associate a URI with an LSAPI application.','<b>Proxy</b> context enables this virtual host to serve as a transparant reverse proxy server to an external web server or application server.','<b>CGI</b> context can be used to specify a directory only contains CGI scripts.','<b>Load Balancer</b> context can be used to assign a different cluster for that context.','<b>Redirect</b> context can set up an internal or external redirect URI.','<b>App Server</b> context is used for Rack/Rails, WSGI, or Node.js applications.','<b>Rack/Rails</b> context is specifically used for Rack/Rails applications. It is recommended to configure Rack/Rails applications as an <b>App Server</b> context instead.');
$this->edb['docRoot'] = array('Document root will not be created by the server automatically if it does not already exist. Please ensure that both the directory exists and it is owned by the correct user.','Set up your document root here, which can be absolute path or relative to $SERV_ROOT or $VH_ROOT','Document root is referred as $DOC_ROOT in this virtual host, which can be used in other path configuration.');
$this->edb['domainName'] = array('Enter all the domains that you want this listener to respond to. Use comma &quot;,&quot; to separate individual domain.','You can choose only one virtual host to handle all unspecified domains, put &quot;*&quot; in domains.');
$this->edb['domainNames'] = array('Domain names are comma-dilimited list of domain:port. For e.g. www.domain1.com:80, www.domain2.com:443');
$this->edb['enableDynGzipCompress'] = array('Dynamic GZIP compression control will be effective only if GZIP Compression is enabled.');
$this->edb['enableExpires'] = array('Expires can be set at the Server/Virtual Host/Context level. Lower level settings will override higher level settings. In terms of overwrite priority: <br><br> Context Level > Virtual Host Level > Server Level <br><br>');
$this->edb['enableRecaptcha'] = array('When this setting is set to <b>Yes</b> at the Server level, reCAPTCHA Protection can still be disabled at the Virtual Host level using the Trigger Sensitivity setting.');
$this->edb['errURL'] = array('You can set up customized error pages for different error codes.');
$this->edb['expiresByType'] = array('Expires By Type will override default settings. Each entry is in the format of &quot;MIME-type=A|Mseconds&quot; with no space in between. You can input multiple entries separated by comma.');
$this->edb['expiresDefault'] = array('Expires syntax, &quot;A|Mseconds&quot; means after base time (A or M) plus the specified time in seconds, the file will expire. &quot;A&quot; means client access time, &quot;M&quot; means file modified time. You can override this default setting by different MIME types: A86400 means the file will expire after 1 day based on client access time.','Here are some common numbers: 1 hour = 3600 sec, 1 day = 86400 sec, 1 week = 604800 sec, 1 month = 2592000 sec, 1 year = 31536000 sec.');
$this->edb['extAppAddress'] = array('Address can be IPv4 socket address &quot;IP:PORT&quot;, like 192.168.1.3:7777 and localhost:7777 or Unix domain socket address &quot;UDS://path&quot; like UDS://tmp/lshttpd/myfcgi.sock.','UDS is chrooted in chroot environment.','For local applications, Unix domain socket is preferred due to security and better performance. If you have to use IPv4 socket, set the IP part to localhost or 127.0.0.1, thus the application is inaccessible from other machines.');
$this->edb['extAppName'] = array('Give a name that easy to remember, other places will refer to this app by its name.');
$this->edb['extAppType'] = array('You can set up external Fast CGI application and AJPv13 (Apache JServ Protocol v1.3) compatible servlet engine.');
$this->edb['extWorkers'] = array('Load balancing workers must be previously defined.','Available ExtApp Types are fcgi(Fast CGI App), lsapi(LSAPI App), servlet(Servlet/JSP Engine), proxy(Web Server).','Different types of external applications can be mixed in one load balancing cluster.');
$this->edb['externalredirect'] = array('Set up redirect URI here. If it is an external redirect, you can specify the status code. Internal redirect has to start with &quot;/&quot;, external redirect can either start with &quot;/&quot; or with &quot;http(s)://&quot;.');
$this->edb['extraHeaders'] = array('The Header Operations setting is backwards compatible with the old &#039;header_name: value1,value2,...&#039; syntax, which is equivalent to setting the header + values using the &#039;Header&#039; directive.');
$this->edb['fcgiapp'] = array('Fast CGI context is a mount point of Fast CGI application. The Fast CGI Application must be pre-defined at server level or virtual host level.');
$this->edb['followSymbolLink'] = array('If Follow-Symbolic-Link is enabled, you can still disable it at virtual host level.');
$this->edb['gdb_groupname'] = array('Group Name should comprise of letter and numbers only.');
$this->edb['gzipCompressLevel'] = array('GZIP Compression level ranges from 1 (Minimum) to 9 (Maximum).');
$this->edb['hardLimit'] = array('Set concurrent connection Limits coming from one client (per IP address). This helps against DoS attack.');
$this->edb['indexUseServer'] = array('You can use default server level settings for index files or use your own.','You can use your settings in addition to the server level settings.','You can disable index files by choosing not to use server level settings and leaving vhost level settings blank.','You can enable/disable &quot;auto index&quot; at the context level.');
$this->edb['javaServletEngine'] = array('If the servlet engine runs on a different machine, it is recommended to make a copy of webapps directory locally. Otherwise you must put the files in a common accessible network drive, which may affect performance.');
$this->edb['javaWebApp_location'] = array('Java web app context is used to automatically import a predefined Java Application in an AJPv13 compilant Java servlet engine, the servlet engine should be set up in external app section (either server or virtual host level).','Location is the directory that contains web application files, which includes WEB-INF/ sub directory.','The web server will automatically import configuration file of web application, which usually is WEB-INF/web.xml under the driectory specified by &quot;location&quot;.');
$this->edb['listenerIP'] = array('Select an IP address from the list, if you don&#039;t specify a particular address, the system will bind to all the available IP address on this machine.');
$this->edb['listenerName'] = array('Give listener a name that is easy to understand and remember.');
$this->edb['listenerPort'] = array('Input a unique port number on this IP for this listener. Only super user (root) can use ports lower than 1024. Port 80 is the default HTTP port; port 443 is the default HTTPS port.');
$this->edb['listenerSecure'] = array('Selecting &quot;Yes&quot; for <b>Secure</b> will make this listener use https. You must then configure this further in SSL settings.');
$this->edb['logUseServer'] = array('If you select &quot;Yes&quot; for <b>Use Server&#039;s Log</b>, the log will be written to the server file set up at the server level.');
$this->edb['log_enableStderrLog'] = array('Stderr Log is located in the same directory as the Server Log. If enabled, all External Application output to stderr will be logged in this file.');
$this->edb['log_fileName'] = array('Log file path can be an absolute path or relative to $SERVER_ROOT.');
$this->edb['log_rollingSize'] = array('A new log file will be created if current log file exceeds the rolling size. File size is in bytes and can be in multiple input formats: 10240, 10K or 1M.');
$this->edb['maxCGIInstances'] = array('Limits resources that a CGI program can use. This helps against DoS attacks.','Max CGI Instances controls how many CGI processes the web server can launch.');
$this->edb['maxReqHeaderSize'] = array('Numbers can be represented as 10240 or 10K.');
$this->edb['mime'] = array('MIME settings can be edited from the previous page. You can specify the mime configuration file location which can be either be an absolute path or relative to $SERVER_ROOT.');
$this->edb['nodeBin'] = array('');
$this->edb['onlySelf'] = array('Set &quot;Only Self Reference&quot; to &quot;Yes&quot; will only allow links from same web site and there is no need to specify &quot;Allowed Domains&quot;. It is more convenient when multiple domains are parked.','If &quot;Only Self Reference&quot; set to &quot;No&quot;, &quot;Allowed Domains&quot; must be specified.');
$this->edb['pagespeedActivate'] = array('');
$this->edb['pagespeedEnabled'] = array('');
$this->edb['pagespeedParams'] = array('');
$this->edb['procSoftLimit'] = array('Process soft/hard limit controls how many processes are allowed for one user. This includes all the processes spawned by CGI application. OS level limit is used if not set.','Set to 0 or empty will use operation system default value for all soft/hard limits.','The soft limit is the value that the kernel enforces for the corresponding resource. The hard limit acts as a ceiling for the soft limit');
$this->edb['proxyWebServer'] = array('Proxy context enables this virtual host serving as a transparent reverse proxy server to an external web server or application server.','External web server must be pre-defined under External App at server or virtual host level.');
$this->edb['rails_location'] = array('Rack/Rails context is for easy configuration of running Rack/Rails application. You only need to specify the root location of your rack/rails application in the &quot;Location&quot; field.');
$this->edb['realm'] = array('A Context can be protected with a predefined realm, which is set up in the virtual host security section. Optionally, an alternative name and additional requirements can be specified.');
$this->edb['realmName'] = array('Define your HT Access realm here, this can be used for contexts.');
$this->edb['realmType'] = array('Currently password file and LDAP are supported for user DB and group DB.');
$this->edb['recaptchaAllowedRobotHits'] = array('');
$this->edb['recaptchaBotWhiteList'] = array('');
$this->edb['recaptchaMaxTries'] = array('');
$this->edb['recaptchaSecretKey'] = array('');
$this->edb['recaptchaSensitivity'] = array('Server level setting can be overridden at the Virtual Host level.');
$this->edb['recaptchaSiteKey'] = array('The server level site/secret key pair must be configured to skip domain checking if the server manages multiple domains. Otherwise, the reCAPTCHA verification will not work properly.');
$this->edb['recaptchaType'] = array('');
$this->edb['redirectUri'] = array('If &quot;Redirect URL&quot; is set, a hotlink attempt will be redirected to the url specified; otherwise, access denied status code will be returned.');
$this->edb['restrained'] = array('Turn on Restrained in a shared hosting enviroment.');
$this->edb['reusePort'] = array('');
$this->edb['rewriteMapLocation'] = array('Enter URI for location. URI must start with &quot;/&quot;.');
$this->edb['rewriteRules'] = array('Only virtual host level rewrite rules should be used here, such as those found in an Apache virtual host config file. Do NOT add any document root level rewrite rules here. If you have any document root level rewrite rules from .htaccess, you should instead create a static context with uri &quot;/&quot; and add the rewrite rules there.');
$this->edb['rubyBin'] = array('<b>Ruby Path</b> is the absolute path of a ruby executable. For e.g., /usr/local/bin/ruby.');
$this->edb['serverName'] = array('The user and group setting of the server process cannot be modified. This was set up during installation. You have to reinstall to change this option.');
$this->edb['servletEngine'] = array('If the servlet engine runs on a different machine, it is recommended to make a copy of webapps directory locally. Otherwise you must put the files in a common accessible network drive, which may affect performance.');
$this->edb['shHandlerName'] = array('Except CGI, other handlers need to be predefined in the &quot;External App&quot; section.');
$this->edb['shType'] = array('Script handler can be a CGI, an FCGI app, a module handler, a Servlet engine, or a proxy to Web server.');
$this->edb['sndBufSize'] = array('Numbers can be represented as 10240, 10K or 1M.','If send/receive buffer size is 0, OS default TCP buffer size will be used.');
$this->edb['softLimit'] = array('Set IP level throttle limit here. The number will be rounded up to 4K units. Set to &quot;0&quot; to disable throttling.','Number of connections can temporarily exceed Soft Limit during Grace Period as long as under Hard Limit. After Grace Period, if it is still above Soft Limit, then no more connections will be allowed from that IP for time of Banned Period.');
$this->edb['sslSessionCache'] = array('Session caching allows a client to resume a session within a set amount of time without having to re-perform an SSL handshake. You can do this by assigning clients a session ID using  <b>Enable Session Cache</b>, or by creating and using session tickets.');
$this->edb['sslSessionTicketKeyFile'] = array('Session tickets will be rotated automatically if the tickets are being generated by the server. If using the <b>SSL Session Ticket Key File</b> option to create and manage your own session tickets, you must be rotate the tickets yourself using a cron job.');
$this->edb['suffix'] = array('If the web site supports php or jsp, please set up here.');
$this->edb['swappingDir'] = array('Swapping directory is recommended to be placed on a local disk such as /tmp. Network drive should be avoided at all cost. Swap will be when configured memory i/o buffer is exhausted.');
$this->edb['verifyExpires'] = array('');
$this->edb['vhRoot'] = array('All directories must pre-exist. This web interface will not create the directory for you. If you are creating a new virtual host, you can create an empty root directory and set it up from the beginning; or you can copy the DEFAULT virtual root that shipped with the package to this virtual host root and modify it to be user owned.','Virtual host root ($VH_ROOT) can be absolute path or relative to $SERVER_ROOT. Config File can be relative to $VH_ROOT.');
$this->edb['vhaccessLog_fileName'] = array('Log file path can be an absolute path or a relative path to $SERVER_ROOT, $VH_ROOT.');
$this->edb['vhadminEmails'] = array('You can enter multiple admin emails, separated by commas.');
$this->edb['vhlog_fileName'] = array('Log file path can be an absolute path or relative to $SERVER_ROOT, $VH_ROOT.','If you want to set Log Level to DEBUG, you must set the server log level to DEBUG as well. The level of  debugging is controlled by Server DEBUG Level. Use DEBUG only if you have to as it has a large impact on server performance and can fill up disk space quickly.');
$this->edb['virtualHostName'] = array('Select the virtual hosts that you want to map to this listener.','If you have not set up the virtual host you want to map, you can skip this step and come back later.');
$this->edb['wsgiBin'] = array('');
