<?php
$modalHeaderClass = 'pt-1 pb-1 ps-2 pe-2';
$modalHeaderTitle = erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Statistic') . ' - ' . (isset($department) ? htmlspecialchars($department) : htmlspecialchars($department_group));
$modalBodyClass = 'p-1'
?>
<?php include(erLhcoreClassDesign::designtpl('lhkernel/modal_header.tpl.php'));?>
<div class="modal-body" ng-non-bindable>
    <div class="p-2">
        <ul class="nav nav-pills mb-3" role="tablist" data-remember="true">
            <li role="presentation" class="nav-item"><a href="#dep-status" class="nav-link<?php if ($tab == 'chats') : ?> active<?php endif;?>" aria-controls="dep-status" role="tab" data-bs-toggle="tab"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Chats');?></a></li>
            <li role="presentation" class="nav-item"><a href="#user-status" class="nav-link<?php if ($tab == 'op') : ?> active<?php endif;?>" aria-controls="user-status" role="tab" data-bs-toggle="tab"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Operators');?></a></li>
            <li role="presentation" class="nav-item"><a href="#dep-chats-users" class="nav-link" aria-controls="dep-chats-users" role="tab" data-bs-toggle="tab"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Chats operators');?></a></li>
            <?php if (isset($department)) : ?>
            <li role="presentation" class="nav-item"><a href="#online-status" class="nav-link" aria-controls="online-status" role="tab" data-bs-toggle="tab"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online status');?></a></li>
            <li role="presentation" class="nav-item"><a href="#depgroups-stat" class="nav-link" aria-controls="depgroups-stat" role="tab" data-bs-toggle="tab"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Department groups');?></a></li>
            <?php endif; ?>
        </ul>
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane<?php if ($tab == 'chats') : ?> active<?php endif;?>" id="dep-status">
                <?php if (isset($department)) : $department_live = clone $department; erLhcoreClassChatStatsResque::updateDepartmentStats($department_live, false); ?>
                <h6><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Operators online');?></h6>
                    <div class="row">
                        <div class="col-6">
                            <ul class="list-unstyled">
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department->max_load_op?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_live->max_load_op?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online operators soft');?><br/><span class="badge bg-secondary">max_load_op</span>
                                </li>
                            </ul>
                        </div>
                        <div class="col-6">
                            <ul class="list-unstyled">
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department->max_load_op_h?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_live->max_load_op_h?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online operators hard');?><br/><span class="badge bg-secondary">max_load_op_h</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                <h6><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Chats statistic');?></h6>
                    <div class="row">
                        <div class="col-6">
                            <ul class="list-unstyled">
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department->active_chats_counter?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_live->active_chats_counter?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','active chats');?><br/><span class="badge bg-secondary">active_chats_counter</span>
                                </li>
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department->bot_chats_counter?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_live->bot_chats_counter?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','bot chats');?><br/><span class="badge bg-secondary">bot_chats_counter</span>
                                </li>
                            </ul>
                        </div>
                        <div class="col-6">
                            <ul class="list-unstyled">
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department->pending_chats_counter?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_live->pending_chats_counter?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','pending chats');?><br/><span class="badge bg-secondary">pending_chats_counter</span>
                                </li>
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department->inactive_chats_cnt?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_live->inactive_chats_cnt?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','in-active chats');?><br/><span class="badge bg-secondary">inactive_chats_cnt</span>
                                    <small><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Chat is active/pending and user has closed widget or has been redirected to survey');?></small>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <h6><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Load statistic');?></h6>
                    <div class="row">
                        <div class="col-6">
                            <ul class="list-unstyled">
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department->max_load?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_live->max_load?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','soft limit');?><br/><span class="badge bg-secondary">max_load</span>
                                    <small><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Operator is logged to back office during last 10 minutes and is online/offline');?></small>
                                </li>
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department->max_load_h?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_live->max_load_h?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','hard limit');?><br/><span class="badge bg-secondary">max_load_h</span>
                                    <small><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Operator is logged to back office during last 10 minutes and is in online status');?></small>
                                </li>
                            </ul>
                        </div>
                        <div class="col-6">
                            <ul class="list-unstyled">
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department->acop_chats_cnt?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_live->acop_chats_cnt?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','active operators chats');?><br/><span class="badge bg-secondary">acop_chats_cnt</span>
                                </li>
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department->inop_chats_cnt?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_live->inop_chats_cnt?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','inactive operators chats');?><br/><span class="badge bg-secondary">inop_chats_cnt</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <h6><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Summary statistic [Hard limit]');?></h6>
                            <ul class="list-unstyled">
                                <li>
                                    <span class="badge bg-secondary">max_load_h</span> - ( <span class="badge bg-secondary">acop_chats_cnt</span> - <span class="badge bg-secondary">inop_chats_cnt</span> )
                                </li>
                                <li class="<?php echo $department->max_load_h && $department->max_load_h - ($department->acop_chats_cnt - ($department->inop_chats_cnt ? $department->inop_chats_cnt : 0)) <= 3 ? 'text-danger fw-bold' : ''?>">
                                    <?php echo (int)$department->max_load_h. ' - ('. (int)$department->acop_chats_cnt . ' - ' . (int)$department->inop_chats_cnt . ')'; ?> = <?php echo (int)$department->max_load_h  - ( (int)$department->acop_chats_cnt  -  (int)$department->inop_chats_cnt ); ?>
                                    <br/><?php echo (int)$department_live->max_load_h. ' - ('. (int)$department_live->acop_chats_cnt . ' - ' . (int)$department_live->inop_chats_cnt . ')'; ?> = <?php echo (int)$department_live->max_load_h  - ( (int)$department_live->acop_chats_cnt  -  (int)$department_live->inop_chats_cnt ); ?> <span class="material-icons">autorenew</span>
                                </li>
                            </ul>
                        </div>
                        <div class="col-6">
                            <h6><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Summary statistic [Soft limit]');?></h6>
                            <ul class="list-unstyled">
                                <li>
                                    <span class="badge bg-secondary">max_load</span> - ( <span class="badge bg-secondary">active_chats_counter</span> - <span class="badge bg-secondary">inactive_chats_cnt</span> )
                                </li>
                                <li class="<?php echo $department->max_load_h && $department->max_load_h - ($department->acop_chats_cnt - ($department->inop_chats_cnt ? $department->inop_chats_cnt : 0)) <= 3 ? 'text-danger fw-bold' : ''?>">
                                    <?php echo (int)$department->max_load. ' - ('. (int)$department->active_chats_counter . ' - ' . (int)$department->inactive_chats_cnt . ')'; ?> = <?php echo (int)$department->max_load  - ( (int)$department->active_chats_counter  -  (int)$department->inactive_chats_cnt ); ?>
                                    <br/><?php echo (int)$department_live->max_load. ' - ('. (int)$department_live->active_chats_counter . ' - ' . (int)$department_live->inactive_chats_cnt . ')'; ?> = <?php echo (int)$department_live->max_load  - ( (int)$department_live->active_chats_counter  -  (int)$department_live->inactive_chats_cnt ); ?> <span class="material-icons">autorenew</span>
                                </li>
                            </ul>
                        </div>
                    </div>

                <?php else : ?>


                    <?php $department_group_live = clone $department_group; erLhcoreClassChatStatsResque::updateDepartmentGroupStats($department_group_live, false); ?>

                    <h6><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Operators online');?></h6>
                    <div class="row">
                        <div class="col-6">
                            <ul class="list-unstyled">
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department_group->max_load_op?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_group_live->max_load_op?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online operators soft');?><br/><span class="badge bg-secondary">max_load_op</span>
                                </li>
                            </ul>
                        </div>
                        <div class="col-6">
                            <ul class="list-unstyled">
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department_group->max_load_op_h?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_group_live->max_load_op_h?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online operators hard');?><br/><span class="badge bg-secondary">max_load_op_h</span>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <h6><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Chats statistic');?></h6>
                    <div class="row">
                        <div class="col-6">
                            <ul class="list-unstyled">
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department_group->achats_cnt?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_group_live->achats_cnt?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','active chats');?><br/><span class="badge bg-secondary">achats_cnt</span>
                                </li>
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department_group->bchats_cnt?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_group_live->bchats_cnt?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','bot chats');?><br/><span class="badge bg-secondary">bchats_cnt</span>
                                </li>
                            </ul>
                        </div>
                        <div class="col-6">
                            <ul class="list-unstyled">
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department_group->pchats_cnt?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_group_live->pchats_cnt?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','pending chats');?><br/><span class="badge bg-secondary">pchats_cnt</span>
                                </li>
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department_group->inachats_cnt?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_group_live->inachats_cnt?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','in-active chats');?><br/><span class="badge bg-secondary">inachats_cnt</span>
                                    <small><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Chat is active/pending and user has closed widget or has been redirected to survey');?></small>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <h6><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Load statistic');?></h6>
                    <div class="row">
                        <div class="col-6">
                            <ul class="list-unstyled">
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department_group->max_load?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_group_live->max_load?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','soft limit');?><br/><span class="badge bg-secondary">max_load</span>
                                    <small><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Operator is logged to back office during last 10 minutes and is online/offline');?></small>
                                </li>
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department_group->max_load_h?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_group_live->max_load_h?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','hard limit');?><br/><span class="badge bg-secondary">max_load_h</span>
                                    <small><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Operator is logged to back office during last 10 minutes and is in online status');?></small>
                                </li>
                            </ul>
                        </div>
                        <div class="col-6">
                            <ul class="list-unstyled">
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department_group->acopchats_cnt?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_group_live->acopchats_cnt?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','active operators chats');?><br/><span class="badge bg-secondary">acopchats_cnt</span>
                                </li>
                                <li>
                                    <span class="material-icons">history</span><strong><?php echo $department_group->inopchats_cnt?></strong><small title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Live data');?>" class="ps-1">[<?php echo $department_group_live->inopchats_cnt?>]</small> - <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','inactive operators chats');?><br/><span class="badge bg-secondary">inopchats_cnt</span>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-6">
                            <h6><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Summary statistic [Hard limit]');?></h6>
                            <ul class="list-unstyled">
                                <li>
                                    <span class="badge bg-secondary">max_load_h</span> - ( <span class="badge bg-secondary">acopchats_cnt</span> - <span class="badge bg-secondary">inopchats_cnt</span> )
                                </li>
                                <li>
                                    <?php echo (int)$department_group->max_load_h. ' - ('. (int)$department_group->acopchats_cnt . ' - ' . (int)$department_group->inopchats_cnt . ')'; ?> = <?php echo (int)$department_group->max_load_h  - ( (int)$department_group->acopchats_cnt  -  (int)$department_group->inopchats_cnt ); ?>
                                    <br/><?php echo (int)$department_group_live->max_load_h. ' - ('. (int)$department_group_live->acopchats_cnt . ' - ' . (int)$department_group_live->inopchats_cnt . ')'; ?> = <?php echo (int)$department_group_live->max_load_h  - ( (int)$department_group_live->acopchats_cnt  -  (int)$department_group_live->inopchats_cnt ); ?> <span class="material-icons">autorenew</span>
                                </li>
                            </ul>
                        </div>
                        <div class="col-6">
                            <h6><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Summary statistic [Soft limit]');?></h6>
                            <ul class="list-unstyled">
                                <li>
                                    <span class="badge bg-secondary">max_load</span> - ( <span class="badge bg-secondary">achats_cnt</span> - <span class="badge bg-secondary">inachats_cnt</span> )
                                </li>
                                <li>
                                    <?php echo (int)$department_group->max_load. ' - ('. (int)$department_group->achats_cnt . ' - ' . (int)$department_group->inachats_cnt . ')'; ?> = <?php echo (int)$department_group->max_load  - ( (int)$department_group->achats_cnt  -  (int)$department_group->inachats_cnt ); ?>
                                    <br/><?php echo (int)$department_group_live->max_load. ' - ('. (int)$department_group_live->achats_cnt . ' - ' . (int)$department_group_live->inachats_cnt . ')'; ?> = <?php echo (int)$department_group_live->max_load  - ( (int)$department_group_live->achats_cnt  -  (int)$department_group_live->inachats_cnt ); ?> <span class="material-icons">autorenew</span>
                                </li>
                            </ul>
                        </div>
                    </div>

                <?php endif; ?>
            </div>
            <div role="tabpanel" class="tab-pane mx550<?php if ($tab == 'op') : ?> active<?php endif;?>" id="user-status">

                    <?php
                    if (isset($department)) {
                        $operatorsStatus = erLhcoreClassChatStatsResque::getDepartmentOperatorsStatistic($department);
                        $operatorsStatusHard = erLhcoreClassChatStatsResque::getDepartmentOperatorsStatistic($department, false);
                    } else {
                        $operatorsStatus = erLhcoreClassChatStatsResque::getDepartmentGroupOperatorsStatistic($department_group);
                        $operatorsStatusHard = erLhcoreClassChatStatsResque::getDepartmentGroupOperatorsStatistic($department_group, false);
                    }
                    ?>

                    <h6><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Soft limit. Operator is logged to back office during last 10 minutes and is online/offline.');?></h6>
                    <?php if (!empty($operatorsStatus)) : ?>
                    <table class="table table-sm table-striped w-100">
                        <thead>
                            <tr>
                                <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','User ID');?></th>
                                <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Max chats');?></th>
                                <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Active chats');?></th>
                                <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Inactive chats');?></th>
                                <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online');?></th>
                            </tr>
                        </thead>
                        <?php $totalStats = array('max_chats' => 0, 'active_chats' => 0, 'inactive_chats' => 0); foreach ($operatorsStatus as $operator) : ?>
                        <tr class="<?php if ($operator['ro'] == 1) : ?>text-muted<?php endif;?>">
                            <td>
                                <span class=" text-truncate d-inline-block" style="max-width: 200px;">
                                    <span title="<?php if ($operator['ro'] == 1) : ?><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Read only');?><?php endif;?>" class="material-icons<?php if ($operator['ro'] == 1) : ?> text-muted<?php else : ?> text-success<?php endif;?>"><?php if ($operator['ro'] == 1) : ?>edit_off<?php else :?>edit<?php endif;?></span>
                                    <a <?php if ($operator['ro'] == 1) : ?>class="text-muted"<?php endif;?> href="<?php echo erLhcoreClassDesign::baseurl('chat/list')?>/(user_ids)/<?php echo $operator['user_id']?>/(chat_status_ids)/0/1"><span title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Operator active/pending chats');?>" class="material-icons">chat</span></a>
                                    <a <?php if ($operator['ro'] == 1) : ?>class="text-muted"<?php endif;?> title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Edit operator');?>" href="<?php echo erLhcoreClassDesign::baseurl('user/edit')?>/<?php echo $operator['user_id']?>"><span class="material-icons">account_box</span>
                                        <?php echo htmlspecialchars(($userStat = erLhcoreClassModelUser::fetch($operator['user_id'])) !== false ? $userStat->name_official : $operator['user_id']);?>
                                    </a>
                                </span>
                            </td>
                            <td><?php echo $operator['max_chats'];
                                if ($operator['ro'] == 0) {$totalStats['max_chats'] += $operator['max_chats'];}?>
                            </td>
                            <td><?php echo $operator['active_chats'];
                                if ($operator['ro'] == 0) {$totalStats['active_chats'] += $operator['active_chats']; }?>
                            </td>
                            <td><?php echo $operator['inactive_chats'];
                                    if ($operator['ro'] == 0) { $totalStats['inactive_chats'] += $operator['inactive_chats']; }
                                ?></td>
                            <td>
                                <span class="material-icons"><?php echo $operator['hide_online'] == 0 ? 'flash_on' : 'flash_off';?></span>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <tr>
                            <td><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Total');?></td>
                            <td>
                                <?php echo $totalStats['max_chats']?> <span class="badge bg-secondary">max_load</span>
                            </td>
                            <td>
                                <?php echo $totalStats['active_chats']?> <span class="badge bg-secondary"><?php if (isset($department)) : ?>acop_chats_cnt<?php else : ?>acopchats_cnt<?php endif; ?></span>
                            </td>
                            <td colspan="2">
                                <?php echo $totalStats['inactive_chats']?> <span class="badge bg-secondary"><?php if (isset($department)) : ?>inop_chats_cnt<?php else : ?>inopchats_cnt<?php endif; ?></span>
                            </td>
                        </tr>
                    </table>
                    <?php else : ?>
                        <p><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','No data.');?></p>
                    <?php endif; ?>

                    <h6><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Hard limit. Operator is logged to back office during last 10 minutes and is in online status');?></h6>
                    <?php if (!empty($operatorsStatusHard)) : ?>
                    <table class="table table-sm table-striped w-100">
                        <thead>
                            <tr>
                                <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','User ID');?></th>
                                <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Max chats');?></th>
                                <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Active chats');?></th>
                                <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Inactive chats');?></th>
                                <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online');?></th>
                            </tr>
                        </thead>
                        <?php $totalStats = array('max_chats' => 0, 'active_chats' => 0, 'inactive_chats' => 0); foreach ($operatorsStatusHard as $operator) : ?>
                        <tr class="<?php if ($operator['ro'] == 1) : ?>text-muted<?php endif;?>">
                            <td>
                                <span class=" text-truncate d-inline-block" style="max-width: 200px;">
                                    <span title="<?php if ($operator['ro'] == 1) : ?><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Read only');?><?php endif;?>" class="material-icons<?php if ($operator['ro'] == 1) : ?> text-muted<?php else : ?> text-success<?php endif;?>"><?php if ($operator['ro'] == 1) : ?>edit_off<?php else :?>edit<?php endif;?></span>
                                    <a <?php if ($operator['ro'] == 1) : ?>class="text-muted"<?php endif;?> href="<?php echo erLhcoreClassDesign::baseurl('chat/list')?>/(user_ids)/<?php echo $operator['user_id']?>/(chat_status_ids)/0/1"><span title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Operator active/pending chats');?>" class="material-icons">chat</span></a>
                                    <a <?php if ($operator['ro'] == 1) : ?>class="text-muted"<?php endif;?> title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Edit operator');?>" href="<?php echo erLhcoreClassDesign::baseurl('user/edit')?>/<?php echo $operator['user_id']?>"><span class="material-icons">account_box</span><?php echo htmlspecialchars(($userStat = erLhcoreClassModelUser::fetch($operator['user_id'])) !== false ? $userStat->name_official : $operator['user_id']);?></a>
                                </span>
                            </td>
                            <td><?php echo $operator['max_chats'];if ($operator['ro'] == 0) {$totalStats['max_chats'] += $operator['max_chats'];}?></td>
                            <td><?php echo $operator['active_chats'];if ($operator['ro'] == 0) {$totalStats['active_chats'] += $operator['active_chats'];}?></td>
                            <td><?php echo $operator['inactive_chats'];if ($operator['ro'] == 0) {$totalStats['inactive_chats'] += $operator['inactive_chats'];}?></td>
                            <td><span class="material-icons"><?php echo $operator['hide_online'] == 0 ? 'flash_on' : 'flash_off';?></span></td>
                        </tr>
                        <?php endforeach; ?>
                        <tr>
                            <td><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Total');?></td>
                            <td>
                                <?php echo $totalStats['max_chats']?> <span class="badge bg-secondary">max_load_h</span>
                            </td>
                            <td>
                                <?php echo $totalStats['active_chats']?> <span class="badge bg-secondary"><?php if (isset($department)) : ?>acop_chats_cnt<?php else : ?>acopchats_cnt<?php endif; ?></span>
                            </td>
                            <td colspan="2">
                                <?php echo $totalStats['inactive_chats']?> <span class="badge bg-secondary"><?php if (isset($department)) : ?>inop_chats_cnt<?php else : ?>inopchats_cnt<?php endif; ?></span>
                            </td>
                        </tr>
                    </table>
                <?php else : ?>
                    <p><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','No data.');?></p>
                <?php endif; ?>

            </div>
            <div role="tabpanel" class="tab-pane mx550" id="dep-chats-users">
                <?php
                if (isset($department)) {
                    $operatorsStatus = erLhcoreClassChatStatsResque::getDepartmentChatsOperatorsStatistic($department);
                } else {
                    $operatorsStatus = erLhcoreClassChatStatsResque::getDepartmentChatsGroupOperatorsStatistic($department_group);
                }

                ?>
                <h6><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Active chats statistic by operators');?></h6>

                <?php if (!empty($operatorsStatus)) : ?>
                <table class="table table-sm table-striped w-100">
                    <thead>
                    <tr>
                        <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','User ID');?></th>
                        <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Max chats');?></th>
                        <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Active chats');?></th>
                        <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Inactive chats');?></th>
                        <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online');?></th>
                        <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Last activity');?></th>
                    </tr>
                    </thead>
                    <?php $totalStats = array('max_chats' => 0, 'active_chats' => 0, 'inactive_chats' => 0); foreach ($operatorsStatus as $operator) : ?>
                        <tr>
                            <td>
                                <a href="<?php echo erLhcoreClassDesign::baseurl('chat/list')?>/(user_ids)/<?php echo $operator['user_id']?>/(chat_status_ids)/0/1"><span title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Operator active/pending chats');?>" class="material-icons">chat</span></a>
                                <a title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Edit operator');?>" href="<?php echo erLhcoreClassDesign::baseurl('user/edit')?>/<?php echo $operator['user_id']?>"><span class="material-icons">account_box</span><?php echo $operator['user_id']?></a>
                            </td>
                            <td><?php echo $operator['max_chats'];$totalStats['max_chats'] += $operator['max_chats']?></td>
                            <td><?php echo $operator['active_chats'];$totalStats['active_chats'] += $operator['active_chats']?></td>
                            <td><?php echo $operator['inactive_chats'];$totalStats['inactive_chats'] += $operator['inactive_chats']?></td>
                            <td>
                                <span class="material-icons<?php if ($operator['hide_online'] == 1 && (time() - (int)$operator['hide_online_ts']) > 600) : ?> text-danger<?php endif;?>"><?php echo $operator['hide_online'] == 0 ? 'flash_on' : 'flash_off';?></span>
                                <?php if ($operator['hide_online'] == 1 &&  $operator['hide_online_ts'] > 0) : ?>
                                    <span <?php if ((time() - (int)$operator['hide_online_ts']) > 600) : ?>class="text-danger"<?php endif;?> title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Offline for');?>"><?php echo erLhcoreClassChat::formatSeconds(time() - (int)$operator['hide_online_ts']); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ((int)$operator['last_activity'] != 0) : $diff = time() - (int)$operator['last_activity'];?>
                                    <?php if ($diff == 0) : ?><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Just now');?><?php else : ?><?php echo erLhcoreClassChat::formatSeconds($diff)?><?php endif; ?>
                                <?php else : ?>
                                    -
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <tr>
                        <td><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Total');?></td>
                        <td>
                            <?php echo $totalStats['max_chats']?> <span class="badge bg-secondary">max_load</span>
                        </td>
                        <td>
                            <?php echo $totalStats['active_chats']?> <span class="badge bg-secondary"><?php if (isset($department)) : ?>acop_chats_cnt<?php else : ?>acopchats_cnt<?php endif; ?></span>
                        </td>
                        <td colspan="3">
                            <?php echo $totalStats['inactive_chats']?> <span class="badge bg-secondary"><?php if (isset($department)) : ?>inop_chats_cnt<?php else : ?>inopchats_cnt<?php endif; ?></span>
                        </td>
                    </tr>
                </table>
                <?php else : ?>
                <p><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','No data.');?></p>
                <?php endif; ?>


            </div>
            <?php if (isset($department)) : ?>
                
            <div role="tabpanel" class="tab-pane" id="depgroups-stat">
                <?php
                // Get department group memberships for this department
                $departmentGroupMemberships = erLhcoreClassModelDepartamentGroupMember::getList(array(
                    'limit' => false,
                    'filter' => array('dep_id' => $department->id),
                    'sort' => false
                ));

                ?>
                     
                <?php if (empty($departmentGroupMemberships)) : ?>
                    <div class="alert alert-info">
                        <i class="material-icons">info</i>
                        <strong><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('department/edit','Information');?></strong>
                        <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('department/edit','This department is not assigned to any department groups.')?>
                    </div>
                <?php else : ?>
                    <div class="table-responsive">
                        <table class="table table-sm table-striped w-100">
                            <thead>
                                <tr>
                                    <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('department/edit','Department Group')?></th>
                                    <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('department/edit','Active chats')?></th>
                                    <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('department/edit','Pending chats')?></th>
                                    <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('department/edit','Bot chats')?></th>
                                    <th><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('department/edit','Inactive chats')?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($departmentGroupMemberships as $depGroupmember) : $depGroup = erLhcoreClassModelDepartamentGroup::fetch($depGroupmember->dep_group_id);?>
                                <tr>
                                    <td>
                                        <?php echo htmlspecialchars($depGroup?->name); ?><?php if (erLhcoreClassUser::instance()->hasAccessTo('lhdepartment', 'managegroups')) : ?><a class="ms-1" href="<?php echo erLhcoreClassDesign::baseurl('department/editgroup')?>/<?php echo $depGroup?->id?>" title="<?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('department/edit','Edit group')?>"><i class="material-icons">edit</i></a><?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge bg-success"><?php echo (int)$depGroup?->achats_cnt?></span>
                                    </td>
                                    <td>
                                        <span class="badge bg-warning"><?php echo (int)$depGroup?->pchats_cnt?></span>
                                    </td>
                                    <td>
                                        <span class="badge bg-info"><?php echo (int)$depGroup?->bchats_cnt?></span>
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary"><?php echo (int)$depGroup?->inachats_cnt?></span>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>

            <div role="tabpanel" class="tab-pane" id="online-status">
                <h5><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online settings');?></h5>
                <ul>
                    <li><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Manual offline mode');?> - <?php if ($department->dep_offline == 1) : ?><span class="badge fs16 bg-light text-danger"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Yes');?></span><?php else : ?><span class="badge fs16 bg-light text-success"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','No');?></span><?php endif;?></li>
                    <li><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online timeout');?> - <?php echo (int)erLhcoreClassModelChatConfig::fetch('sync_sound_settings')->data['online_timeout']?> s.</li>
                    <li><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Status cache');?> - <?php if ((int)erLhcoreClassModelChatConfig::fetch('enable_status_cache')->current_value === 0) : ?><span class="badge fs16 bg-light text-success"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','No');?></span><?php else : ?><span class="badge fs16 bg-light text-danger"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Yes');?></span><?php endif;?></li>
                    <li><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Ignore operator (global level)');?> - <?php if ((int)erLhcoreClassModelChatConfig::fetch('ignore_user_status')->current_value === 0) : ?><span class="badge fs16 bg-light text-success"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','No');?></span><?php else : ?><span class="badge fs16 bg-light text-danger"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Yes');?></span><?php endif;?></li>
                    <li><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Ignore operator (department level)');?> - <?php if ((int)$department->ignore_op_status == 0) : ?><span class="badge fs16 bg-light text-success"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','No');?></span><?php else : ?><span class="badge fs16 bg-light text-danger"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Yes');?></span><?php endif;?></li>
                </ul>
                <h5><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Status');?></h5>
                <ul>
                    <li><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Status if this was the only department passed (default widget status check)');?>
                        <?php
                        if (erLhcoreClassChat::isOnline($department->id, false, array(
                            'online_timeout' => (int) erLhcoreClassModelChatConfig::fetch('sync_sound_settings')->data['online_timeout'],
                            'disable_cache' => ((int)erLhcoreClassModelChatConfig::fetch('enable_status_cache')->current_value === 0),
                            'ignore_user_status' => (int)erLhcoreClassModelChatConfig::fetch('ignore_user_status')->current_value
                        ))) : ?><span class="ms-1 badge fs16 bg-light text-success"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online');?></span><?php else : ?><span class="ms-1 badge fs16 bg-light text-danger"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Offline');?></span><?php endif; ?>
                    </li>
                    <li>
                        <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Status if online hours were ignored (operators and bot configuration respected)');?>
                        <?php
                        if (erLhcoreClassChat::isOnline($department->id, false, array(
                            'online_timeout' => (int) erLhcoreClassModelChatConfig::fetch('sync_sound_settings')->data['online_timeout'],
                            'disable_cache' => true,
                            'ignore_user_status' => (int)erLhcoreClassModelChatConfig::fetch('ignore_user_status')->current_value,
                            'exclude_online_hours' => true
                        ))) : ?><span class="ms-1 badge fs16 bg-light text-success"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online');?></span><?php else : ?><span class="ms-1 badge fs16 bg-light text-danger"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Offline');?></span><?php endif; ?>
                    </li>
                    <li>
                        <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Status if online operators were ignored and only online hours and bot check would be done');?>
                        <?php if (erLhcoreClassChat::isOnline($department->id, false, array(
                            'online_timeout' => (int) erLhcoreClassModelChatConfig::fetch('sync_sound_settings')->data['online_timeout'],
                            'disable_cache' => true,
                            'ignore_user_status' => true
                        ))) : ?><span class="ms-1 badge fs16 bg-light text-success"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online');?></span><?php else : ?><span class="ms-1 badge fs16 bg-light text-danger"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Offline');?></span><?php endif; ?>
                    </li>
                    <li>
                        <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Status if bot was ignored (default check for `Stop chat and transfer to human` trigger action)');?>
                        <?php
                        if (erLhcoreClassChat::isOnline($department->id, false, array(
                            'online_timeout' => (int) erLhcoreClassModelChatConfig::fetch('sync_sound_settings')->data['online_timeout'],
                            'disable_cache' => true,
                            'exclude_bot' => true,
                            'include_users' => true,
                        ))) : ?><span class="ms-1 badge fs16 bg-light text-success"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online');?></span><?php else : ?><span class="ms-1 badge fs16 bg-light text-danger"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Offline');?></span><?php endif; ?><span class="badge bg-secondary ms-1">online_department</span>
                    </li>
                    <li>
                        <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Status if bot and online hours were ignored (default check for `Stop chat and transfer to human` trigger action with `Ignore department online hours` option checked)');?>
                        <?php
                        if (erLhcoreClassChat::isOnline($department->id, false, array(
                            'online_timeout' => (int) erLhcoreClassModelChatConfig::fetch('sync_sound_settings')->data['online_timeout'],
                            'disable_cache' => true,
                            'exclude_bot' => true,
                            'include_users' => true,
                            'exclude_online_hours' => true
                        ))) : ?><span class="ms-1 badge fs16 bg-light text-success"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online');?></span><?php else : ?><span class="ms-1 badge fs16 bg-light text-danger"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Offline');?></span><?php endif; ?><span class="badge bg-secondary ms-1">online_op_department</span>
                    </li>
                    <li>
                        <?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Status if bot and operators status would be excluded. Only online hours would be checked');?>
                        <?php
                        if (erLhcoreClassChat::isOnline($department->id, false, array(
                            'online_timeout' => (int) erLhcoreClassModelChatConfig::fetch('sync_sound_settings')->data['online_timeout'],
                            'disable_cache' => true,
                            'exclude_bot' => true,
                            'ignore_user_status' => true
                        ))) : ?><span class="ms-1 badge fs16 bg-light text-success"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Online');?></span><?php else : ?><span class="ms-1 badge fs16 bg-light text-danger"><?php echo erTranslationClassLhTranslation::getInstance()->getTranslation('statistic/departmentstats','Offline');?></span><?php endif; ?><span class="badge bg-secondary ms-1">online_department_hours</span>
                    </li>
                </ul>
            </div>
            <?php endif;?>
        </div>
    </div>
</div>
<?php include(erLhcoreClassDesign::designtpl('lhkernel/modal_footer.tpl.php'));?>