tinymce.PluginManager.add('lhfiles', function(editor, url) {

    var id = editor.id.replace("reply-to-mce-","");

    // Add a button that opens a window
    editor.ui.registry.addButton('lhfiles', {
        text: '<span class="material-icons" style="font-size: 18px;font-family:\'Material Symbols Rounded\'!important;font-weight: normal!important;font-style: normal!important;">attach_file</span>',
        onAction: function () {
            // Open window
            tinymce.activeEditor.windowManager.openUrl({
                title: 'Attatch existing file',
                url: WWW_DIR_JAVASCRIPT + 'mailconv/attatchfile/'+  id
            });
        }
    });

    editor.ui.registry.addButton('lhtemplates', {
        icon: 'template',
        onAction: function () {
            // Open window
            var elm = document.getElementById('new-mailbox-id');

            var idTemplate = id;

            if (id == 'response-template' && elm) {
                idTemplate = elm.value != '' ? elm.value : idTemplate;
            }

            tinymce.activeEditor.windowManager.openUrl({
                title: 'Insert template',
                url: WWW_DIR_JAVASCRIPT + 'mailconv/attachtemplate/' + idTemplate
            });
        }
    });

    // Adds a menu item, which can then be included in any menu via the menu/menubar configuration
    editor.ui.registry.addMenuItem('lhfiles', {
        text: 'Insert file from live helper chat',
        onAction: function() {
            // Open window
            openDialog();
        }
    });

    editor.ui.registry.addMenuItem('lhtemplates', {
        text: 'Insert file from live helper chat',
        onAction: function() {
            // Open window
            openDialog();
        }
    });

    return {
        getMetadata: function () {
            return  {
                name: "Example plugin",
                url: "http://exampleplugindocsurl.com"
            };
        }
    };
});