<?php

declare(strict_types=1);

/**
 * @module          Reset PIN
 * @author          cms-lab
 * @copyright       2010-2025 cms-lab
 * @link            https://cms-lab.com
 * @license         custom license: https://cms-lab.com/_documentation/reset-pin/license.php
 * @license_terms   please see license
 *
 */

class reset_pin extends LEPTON_abstract
{
	public array $allUsers = [];
	public string $addon_color = 'blue';
	public string $sActionUrl = ADMIN_URL . '/admintools/tool.php?tool=reset_pin';
	public string $sBackUrl = ADMIN_URL . '/admintools/index.php';	

	public object|null $oTwig = null;		
	public LEPTON_database $database;
	public static $instance;

	public function initialize()
	{
		$this->database = LEPTON_database::getInstance();
		$this->oTwig = lib_twig_box::getInstance();
		$this->oTwig->registerModule('reset_pin');
		$this->init_tool();	
	}

	public function init_tool( $sToolname = '' )
	{
		//get all users
		$this->database->execute_query(
			"SELECT * FROM ".TABLE_PREFIX."users " ,
			true,
			$this->allUsers,
			true
		);
	}

	public function display_reset()
	{
		global $MENU;
		// data for twig template engine	
		$data = [
			'oRP'	=> $this,
			'help_link'	=> '<a class="ui blue basic button" href="https://cms-lab.com/_documentation/reset-pin/readme.php" target="_blank" title="'.$MENU['HELP'].'"><i class="help icon"></i>'.$MENU['HELP'].'</a>'
			];

		//	get the template-engine		
		echo $this->oTwig->render( 
			"@reset_pin/tool.lte",	//	template-filename
			$data				//	template-data
		);
	}
	

	public function save_value( int $id = 0) 
	{
		if($id > 0)
		{
			$user_id = intval($id);
			$this->database->simple_query("UPDATE ".TABLE_PREFIX."users SET pin = '-1' WHERE user_id = ".$user_id." ");
			$this->database->simple_query("UPDATE ".TABLE_PREFIX."users SET pin_set = 0 WHERE user_id = ".$user_id." ");

			LEPTON_admin::displayMessage(
				"success",
				[$this->language['SAVE_OK']],
				$this->sActionUrl,
				2000,
				"message.lte",
				true
			);			
		}
	}
	
	
	public function show_info() 
	{
		// data for twig template engine	
		$data = [
			'oRP'			=> $this,
			'image_url'		=> "https://cms-lab.com/_documentation/media/reset_pin/reset_pin.jpg",
			'readme_link'	=> "<a class='ui basic blue button' href='https://cms-lab.com/_documentation/reset_pin/readme.php' target='_blank'><i class='book icon'></i>Readme</a>",
			'live_support'	=> "<a  class='ui basic red button' href='#'><i class='bookmark icon'></i>NO Live-Support</a>",			
			'forum_support'	=> "<a class='ui basic blue button' href='https://forum.lepton-cms.org/viewforum.php?f=14' target='_blank'><i class='bookmark icon'></i>Forum-Support</a>"
			];

		//	get the template-engine		
		echo $this->oTwig->render( 
			"@reset_pin/info.lte",	//	template-filename
			$data				//	template-data
		);		
	}
}