<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2010-2025 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         https://gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */

// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {	
	include LEPTON_PATH.SEC_FILE;
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.SEC_FILE))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.SEC_FILE)) { 
		include $root.SEC_FILE;  
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include secure file


	/**
	 * get additions for page header (css, js)
	 *
	 * + gets all active sections for a page;
	 * + scans module directories for file headers.inc.php;
	 * + includes that file if it is available
	 * + includes automatically if exists:
	 *   + module dirs:
	 *     + frontend.css / backend.css              (media: all)
	 *     + ./css/frontend.css / backend.css        (media: all)
	 *     + frontend_print.css / backend_print.css  (media: print)
	 *     + ./css/frontend_print.css / backend_print.css  (media: print)
	 *     + frontend.js / backend.js
	 *     + ./js/frontend.js / backend.js
	 *   + template dir:
	 *     + <PAGE_ID>.css 							 (media: all)
	 *     + ./css/<PAGE_ID>.css					 (media: all)
	 *   + pages_directory:
	 *     + <PAGE_ID>.css                           (media: all)
	 *     + ./css/<PAGE_ID>.css                     (media: all)
	 *
	 * @access public
	 * @param  string  $for - 'frontend' (default) / 'backend'
	 * @param  boolean $print_output
	 * @param  boolean $current_section
	 * @return void (echo's result)
	 *
	 **/
    function get_page_headers(string $for = 'frontend', bool $print_output = true, bool $individual = false)
    {
		// don't do this twice
        if (defined('LEP_HEADERS_SENT'))
		{
			return true;
		}

        if (!$for || $for == '' || ($for != 'frontend' && $for != 'backend'))
		{
			$for = 'frontend';
		} 
		
		$page_id = LEPTON_request::getPageID();

        LEPTON_handle::register("get_droplet_headers", "get_active_sections");
		
		/**	*****************
		 *	In some circumstances there is neither no page_id as constant nor inside the $_GET superglobal ...
		 *	In this case the module-css or -js files are not loaded.
		 *	So we are looking inside the $_POST superglobal ....
		 *
		 *  removed in L* 5.3
		 */
		
		// load headers.inc.php for backend theme
        if (($for === 'backend') && (file_exists(LEPTON_PATH . '/templates/' . DEFAULT_THEME . '/headers.inc.php')))
		{
            LEPTON_core::addItems($for, LEPTON_PATH . '/templates/' . DEFAULT_THEME);
		} 

		else // it is for the frontend
		{
			// Search results are comming up with own template!
            if ((defined("TEMPLATE")) && (TEMPLATE != DEFAULT_TEMPLATE))
			{
                if (file_exists(LEPTON_PATH . '/templates/' . TEMPLATE . '/headers.inc.php'))
			    {
                    LEPTON_core::addItems($for, LEPTON_PATH . '/templates/' . TEMPLATE);
			    }
			}
			elseif (file_exists( LEPTON_PATH . '/templates/' . DEFAULT_TEMPLATE . '/headers.inc.php' ) )
			{
				LEPTON_core::addItems( $for, LEPTON_PATH . '/templates/' . DEFAULT_TEMPLATE );
			}			
		}
		
		// handle search
		/**
		 *	Modifiy to get the css and js files from the frontend-template or the module itself
		 *	Even if we are not only displaying the search-results.
		 *
		 */

        // the page is called from the LEPTON SEARCH
        if ($for == "frontend")
        {
            $css_loaded = false;
            $js_loaded = false;
        
            global $oLEPTON;
            
            $current_template = ((isset($oLEPTON->page['template'])) && ($oLEPTON->page['template'] != ""))
                ? $oLEPTON->page['template']
                : DEFAULT_TEMPLATE
                ;
            
            $lookup_file = "templates/" . $current_template . "/frontend/lib_search";
            
            foreach ([$lookup_file, 'modules/lib_search/templates'] as $directory )
            {
                $file = $directory . '/' . $for . '.css';
                if ((file_exists(LEPTON_PATH . '/' . $file)) && (false === $css_loaded))
                {
                    LEPTON_core::$HEADERS[ $for ][ 'css' ][] = array(
                        'media' => 'all',
                        'file' => $file 
                    );
                    $css_loaded = true;
                }
                
                $file = $directory . '/' . $for . '.js';
                if ((file_exists(LEPTON_PATH . '/' . $file)) && (false === $js_loaded))
                {         
                    LEPTON_core::$HEADERS[ $for ][ 'js' ][] = $file;
                    $js_loaded = true;
                }
            }
                    
            /**
             *	Add css files for frontend-login, -preferences, -forgot-form etc.
             */
            if (stripos($_SERVER['REQUEST_URI'], "/account/") !== FALSE ) {
                
                $lookup_files = array(
                    "templates/" . $current_template . "/frontend/login/css/frontend.css",
                    "account/css/frontend.css"
                );

                foreach ($lookup_files as &$lookup_file) {
                    if (file_exists(LEPTON_PATH . "/" . $lookup_file)) {
                        LEPTON_core::$HEADERS['frontend']['css'][] = array(
                            'media'	=> 'all',
                            'file'	=> $lookup_file
                        );
                        break;
                    }
                }
                unset($lookup_file);
            }
        }
	
		// load CSS and JS for droplets
		if (    ( $for == 'frontend' )
		    &&  ( isset( $page_id ) )
		    &&  ( is_numeric( $page_id ) ) 
		    &&  ( file_exists( LEPTON_PATH . '/framework/summary.droplets.php' ) )
		    )
		{
            get_droplet_headers( $page_id );
		} 
		
		$css_subdirs = [];
		$js_subdirs  = [];
		
		// it's an admin tool ...
		// Aldus:: Test for L* 5.3
		$sToolName = (LEPTON_request::getRequest("tool") ?? "");
		
		if ( $for == 'backend' && ( $sToolName !== "" ) && file_exists( LEPTON_PATH . '/modules/' . $sToolName . '/tool.php' ) )
		{
			// css part
			$css_subdirs[] = array(
                'modules/' . $sToolName,
                'modules/' . $sToolName . '/css' 
			);
			//  Aldus (2017-08-10): looking into the backend-theme for module css
			$temp_lookup_path = LEPTON_PATH."/templates/".DEFAULT_THEME."/backend/".$sToolName."/";
			if( file_exists($temp_lookup_path) )
			{ 
			    $ref = &$css_subdirs[ (count($css_subdirs)-1) ]; // !
			    $ref[] = "templates/".DEFAULT_THEME."/backend/".$sToolName;
			    $ref[] = "templates/".DEFAULT_THEME."/backend/".$sToolName."/css";
			    $ref = array_reverse($ref);
			}
			
			// js part
			$js_subdirs[]  = array(
                '/modules/' . $sToolName,
                '/modules/' . $sToolName . '/js' 
			);
			//  Aldus (2017-08-10): looking into the backend-theme for module java-scripts
			if( file_exists($temp_lookup_path) )
			{ 
			    $ref = &$js_subdirs[ (count($js_subdirs)-1) ]; // !
			    $ref[] = "templates/".DEFAULT_THEME."/backend/".$sToolName;
			    $ref[] = "templates/".DEFAULT_THEME."/backend/".$sToolName."/js";
			    $ref = array_reverse($ref);
			}
			
			// headers.inc part
			if ( file_exists( LEPTON_PATH . '/modules/' . $sToolName . '/headers.inc.php' ) )
			{
				LEPTON_core::addItems( $for, LEPTON_PATH . '/modules/' . $sToolName );
			} 
		} 
		
		// if we have a page id...
		elseif ( $page_id && is_numeric( $page_id ) )
		{
			// ... get active sections
			$sections = get_active_sections( $page_id, NULL, ($for === "backend") );
			
			if ( ( is_array( $sections ) ) && ( count( $sections ) > 0 ) )
			{
				global $current_section;
				global $mod_headers;
				
				//	local storage to avoid to load css/js twice
				$processed_modules = array();
				
				foreach ( $sections as $section )
				{
					$module       = $section[ 'module' ];
					
					if(in_array($module, $processed_modules)) {
						//	still processed
						continue;
					} else {
						$processed_modules[] = $module;
					}
					
					$headers_path = LEPTON_PATH . '/modules/' . $module;
					// special case: 'wysiwyg'
					if ( $for == 'backend' && !strcasecmp( $module, 'wysiwyg' ) )
					{
						// get the currently used WYSIWYG module
						if ( defined( 'WYSIWYG_EDITOR' ) && WYSIWYG_EDITOR != "none" )
						{
							$headers_path = LEPTON_PATH . '/modules/' . WYSIWYG_EDITOR;
						} 
					} 
					// find header definition file
					if ( file_exists( $headers_path . '/headers.inc.php' ) )
					{
						$current_section = $section[ 'section_id' ];
						LEPTON_core::addItems( $for, $headers_path );
					} 
					else
					{
						/**
						 *	Aldus - 2014-11-02
						 *	Frontend - patch
						 */
						 global $oLEPTON;
						 if (is_object($oLEPTON)) {
						 	$current_template = ((isset($oLEPTON->page['template'])) && ($oLEPTON->page['template'] != ""))
						 	    ? $oLEPTON->page['template']
						 	    : DEFAULT_TEMPLATE
						 	    ;
						 	
						 	$lookup_file = LEPTON_PATH."/templates/".$current_template."/frontend/".$module;
						 	if (file_exists($lookup_file."/headers.inc.php")) {
						 		LEPTON_core::addItems( $for,$lookup_file );
						 	}
						 }
						 // End Aldus
					}
					
					$temp_css = array(
						'modules/' . $module,
						'modules/' . $module . '/css' 
					);
					
					$temp_js = array(
						'modules/' . $module,
						'modules/' . $module . '/js' 
					);
			
					// add css/js search subdirs for frontend only; page based CSS/JS
					// does not make sense in BE
                    if ($for == 'frontend')
					{
						// Aldus:
						$current_template = $oLEPTON->page['template'] != "" ? $oLEPTON->page['template'] : DEFAULT_TEMPLATE;
						$lookup_file = "templates/".$current_template."/frontend/".$module;
						
						$temp_css[] = $lookup_file;
						$temp_css[] = $lookup_file."/css";
						
						$temp_js[] = $lookup_file;
						$temp_js[] = $lookup_file."/js";
						
						// End Aldus
				
					} // $for == 'frontend' 
					else {
						// Aldus:
						$current_theme = DEFAULT_THEME;
						$lookup_file = "templates/".$current_theme."/backend/".$module;
						$temp_css[] = $lookup_file;
						$temp_css[] = $lookup_file."/css";
						
						$temp_js[] = $lookup_file;
						$temp_js[] = $lookup_file."/js";
						
						// End Aldus
					}
					
					$css_subdirs[]= array_reverse($temp_css);
					$js_subdirs[]= array_reverse($temp_js);
					
				}
			}
		}

		// automatically add CSS files
		/**
		 *	We are taking the first file (-link) we found.
		 *	Keep in mind that an optional additional css file in the frontend-template
		 *	is loaded INSTEAD of the module-internal one!
		 */
        foreach ($css_subdirs as $first_level_ref)
		{
			$css_found = false;

			foreach( $first_level_ref as $directory )
			{
				// frontend.css / backend.css
				$file = $directory . '/' . $for . '.css';
                if ((file_exists(LEPTON_PATH . '/' . $file)) && ($css_found === false))
				{
                    LEPTON_core::$HEADERS[ $for ][ 'css' ][] = array(
                        'media' => 'all',
                        'file' => $file 
                    );
                    $css_found = true;
				}

			}
		}
		
		/**
		 *	Try to get a frontend "<page_id>.css" if there is one	
		 *
		 */
		if ( $for == 'frontend' ) {
			$current_template = $oLEPTON->page['template'] != "" ? $oLEPTON->page['template'] : DEFAULT_TEMPLATE;
			$lookup_files = array(
				"templates/".$current_template."/css/".$page_id.".css",
				"templates/".$current_template."/".$page_id.".css"
			);
			
			foreach($lookup_files as &$file) {
				if ( file_exists( LEPTON_PATH . '/' . $file ) ) {
					LEPTON_core::$HEADERS[ $for ][ 'css' ][] = array(
						'media' => 'all',
							'file' => $file 
					);
					break;
				}
			}
			unset($file);
		}
			
		// Automatically add JS files
		
		foreach( $js_subdirs as &$first_level_ref )
		{
			$got_js = false;
			foreach( $first_level_ref as $directory )
			{
				$file = $directory . '/' . $for . '.js';
				if( ( file_exists( LEPTON_PATH . '/' . $file ) ) && ($got_js === false) )
				{
                    LEPTON_core::$HEADERS[ $for ][ 'js' ][] = $file;
                    $got_js = true;
				}
			}
		}
		$output = null;

        $HEADERS = &LEPTON_core::$HEADERS;

		foreach (['css', 'jquery', 'js'] as $key )
		{
			if ( !isset( $HEADERS[ $for ][ $key ] ) || !is_array( $HEADERS[ $for ][ $key ] ) )
			{
				continue;
			}
			
			foreach ( $HEADERS[ $for ][ $key ] as $i => $arr )
			{
				switch ( $key )
				{					
					case 'css':
						if( file_exists( LEPTON_PATH."/".$arr['file'] ) )
						{
						    // make sure we have an URI (LEPTON_URL included)
						    $file = ( preg_match( '#' . LEPTON_URL . '#i', $arr[ 'file' ] ) ? $arr[ 'file' ] : LEPTON_URL . '/' . $arr[ 'file' ] );
						    $output .= '<link rel="stylesheet" type="text/css" href="' . $file . '" media="' . ( isset( $arr[ 'media' ] ) ? $arr[ 'media' ] : 'all' ) . '" />' . "\n";
						}
						break;
					
					case 'js':
						$output .= '<script src="' . LEPTON_URL . '/' . $arr . '"></script>' . "\n";
						break;
						
					default:
						trigger_error( 'Unknown header type [' . $key . '] [index '.$i.']!', E_USER_NOTICE );
						break;
				}
			}
		}
				
		if ( true === $print_output )
		{
			echo $output;
			define( 'LEP_HEADERS_SENT', true );
		}
		else
		{
			return $output;
		}
		
	}
