/*
KKART
http://kkart.com/
(c) Kkart Team
*/

jQuery(document).ready(function(){
	//kkart_setup_open_props();
	
	// Image gallery upload handler
	jQuery('.kkart-upload-gallery-handler').on('click', function(){
		kkart_image_gallery_upload_handler(jQuery(this));
	});
  
});

// Save data or meta of the post
function kkart_update_post_data(key, val){
	
	// Add post meta to pagelayer object
	pagelayer_update_post_data(key, val)
	
	// Add nonce
	pagelayer_update_post_data('kkart_meta_nonce', kkart_meta_nonce);
	pagelayer_update_post_data('post_ID', pagelayer_postID);
  
}

// Image gallery upload handler
function kkart_image_gallery_upload_handler(jEle){
	
	var ids = new Array();
	var idHolder = jEle.closest('.pagelayer-ele');
	var idVal = idHolder.attr('kkart-gallary-ids');
	var pHolder = idHolder.find('.kkart-primary-image-container');
	var gHolder = idHolder.find('.kkart-product-gallery-container .kkart-product-gallery-ul');
	
	// Any IDs ?
	if(!pagelayer_empty(idVal)){
		ids = idVal.split(',');
	}
	
	var state = 'gallery';
	if(ids.length > 0){
		if(isNaN(ids[0])){
			state = 'embed';
		}else{
			state = 'gallery-library';
		}
	}
	
	//console.log(ids);
	var frame = wp.media({
		id: 'pagelayer-wp-multi-image-library',
		frame: 'post',
		state: state,
		title: pagelayer_l('frame_multi_image'),
		multiple: true,
		library: wp.media.query({type: 'image'}), // TODO: for video
		button: {
			text: pagelayer_l('insert')
		},
		
	});
	
	// Load the frame
	frame.on({
		
		// Set the current selection if any
		'open': function(){
			
			// Do we have anything
			if(ids.length > 0){
				
				var selection = '';
				
				if(state == 'gallery-edit'){
					selection = frame.state().get('library');
				}else if(state == 'gallery-library'){
					selection = frame.state().get('selection');
				}
				
				// Add to current selection
				if(!pagelayer_empty(selection)){
					for(var x in ids){
						attachment = wp.media.attachment(ids[x]);
						attachment.fetch();
						selection.add(attachment ? [ attachment ] : [] );
					}
				}
			}
		},
		
		// When images are selected
		'update': function(selection){
			
			//console.log(selection);
			
			// Remove thumbnails
			pHolder.empty();
			
			// Remove gallery-handler
			gHolder.empty();
			
			//Fetch selected images
			var attachments = selection.map(function(attachment){
				attachment.toJSON();
				return attachment;
			});
			
			//console.log(attachments);
			
			var img_ids = [];
			var group_ids = [];
			var urls = {};
			var img_urls = {};
			var titles = {};
			var links = {};
			var captions = {};	
			var img_id = -1;
			var url = '';
			var attLength = attachments.length;
			
			for(var i = 0; i < attLength; ++i){
				
				// Add Id and urls to array
				var active_class = '';
				var id = attachments[i].id;
				var _id = 'i'+id;
				img_ids.push(id);
				
				// Create thumbnails
				if(i === 0){
					// Add thumbnail
					active_class = 'kkart-product-active';
					url = attachments[i].attributes.url;
					img_id = id;
					pHolder.append('<img class="kkart-product-pimage" src="'+url+'">');
					
				}
				
				if(attLength > 1){
					// Add gallery
					gHolder.append('<li class="kkart-gallery-item"><a data-href="'+attachments[i].attributes.url+'" href="javascript:void(0);" class="kkart-ele-link"> <img class="kkart-product-gimage '+ active_class +'" src="'+attachments[i].attributes.url+'"> </a></li>');
				}
				
				if(i !== 0){
					group_ids.push(id);
					urls[_id] = attachments[i].attributes.url;
					//get title
					titles[_id] = attachments[i].attributes.title;
					links[_id] = attachments[i].attributes.link;
					captions[_id] = attachments[i].attributes.caption;
					
					// Create a URL
					img_urls[_id] = {}
					
					for(var x in attachments[i].attributes.sizes){
						img_urls[_id][x] = attachments[i].attributes.sizes[x].url;
					}
				}
			}
			
			// Add upload holder
			gHolder.append('<li class="kkart-gallery-item"><img class="kkart-product-gimage kkart-upload-gallery-handler" src="'+pagelayer.blank_img+'"></li>');
			
			// Update the IDs incase the user clicks on it again
			ids = img_ids;
			
			// Save and render
			// Set featured image
			pagelayer_post_props_atts('featured_image-url', url, true);

			pagelayer_post_props_atts('product_image_gallery-urls', JSON.stringify(urls), true);
			pagelayer_post_props_atts('product_image_gallery-all-urls', JSON.stringify(img_urls), true);
			pagelayer_post_props_atts('product_image_gallery-all-titles', JSON.stringify(titles), true);
			pagelayer_post_props_atts('product_image_gallery-all-links', JSON.stringify(links), true);
			pagelayer_post_props_atts('product_image_gallery-all-captions', JSON.stringify(captions), true);
			
			pagelayer_post_props_atts('featured_image', img_id);
			pagelayer_post_props_atts('product_image_gallery', group_ids);
			idHolder.attr('kkart-gallary-ids', ids); // TODO update on change props

			// On click 
			gHolder.find('.kkart-upload-gallery-handler').on('click', function(){
				kkart_image_gallery_upload_handler(jQuery(this));
			});
			
			// Re-setup gallery
			kkart_pl_product_slider(idHolder);
			if(!pagelayer_empty(pagelayer_active.el) && pagelayer_active.el.tag == 'pl_post_props'){
				pagelayer.$$('.pagelayer-settings').click();
			}
		}
		
	});
	
	frame.open();
	
	return false;				
	
}

// Setup for open body props
/* function kkart_setup_open_props(){

	jQuery('.kkart-open-props[data-props-fields]').each(function(){
		var jEle = jQuery(this);
		var interval = '';
		
		jEle.on('click', function(){
			var field = jQuery(this).data('props-fields');
			pagelayer.$$('.pagelayer-settings-icon').click();
			var frame = pagelayer.$$('.pagelayer-meta-iframe');

			var open_props = function(){
				
				var contents = frame.contents();
				var origFiels = contents.find('[name="'+field+'"]');
				var accItem = origFiels.closest('.kkart-accordion-item');
				contents.find('.pagelayer-sidebar-items[data-tab="kkart_props"]').click();
				
				if(!accItem.hasClass('kkart-accordion-open')){
					accItem.find('.kkart-accordion-title').click();
				}
				
				origFiels.focus();
				
			}
			
			frame.load(open_props);
			open_props();
		});
	});
	
} */

function pagelayer_render_pl_kkart_cart_price_holder(el){
	el['atts']['show_coupon'] = pagelayer_empty(el.atts['hide_coupon']);
}

function pagelayer_render_end_pl_kkart_cart_price_holder(el){
	kkart_coupon_toggle(el.$);
}

// Price handler
function  pagelayer_render_pl_kkart_price(el){
	var currency = kkart_currency_symbol || '$';
	el.atts['currency'] = currency;
	el.atts['regular_price'] = 20;
	el.atts['sale_price'] = 10;
	el.atts['show_reg_price'] = true;
	el.atts['show_sale_price'] = true;
}

// Cart Price handler
function pagelayer_render_pl_kkart_cart_price(el){
	var currency = kkart_currency_symbol || '$';
	el.atts['item_price'] = currency+'20';
}

// Cart quantity handler
function pagelayer_render_pl_kkart_cart_item_quantity(el){
	el.atts['form_html'] = `<div class="kkart-product-quantity">
		<i class="fas fa-minus kkart-minus"></i>
		<input type="number" class="kkart-quantity-input input-text qty text" min="1" name="{{field_name}}" value="1" />
		<i class="fas fa-plus kkart-plus"></i>
	</div>`;
}

// Cart update handler
function pagelayer_render_pl_kkart_cart_update(el){
	el.atts['not_sold_individually'] = true;
}

// Cart variable details handler
function pagelayer_render_pl_kkart_cart_variable(el){
	
	el.atts['variable_meta'] = `<div class="kkart-variations">
			<div class="kkart-variation-holder">
				<strong class="variation-color">color:</strong>
				<span class="variation-color">Red</span>
			</div>
			<div class="kkart-variation-holder">
				<strong class="variation-size">size:</strong>
				<span class="variation-size">S</span>
			</div>
	</div>`;
}

// Add to cart handler
function  pagelayer_render_pl_kkart_add_to_cart(el){
	
	el['atts']['kkart_cart_form'] = `<form class="kkart-add-to-cart-form" method="post" enctype="multipart/form-data">
		<div class="kkart-product-quantity-holder">`;
			
		if(!pagelayer_empty(el.atts['show_quantity'])){
			el['atts']['kkart_cart_form'] += `<div class="kkart-product-quantity">
				<i class="fas fa-minus kkart-minus"></i> 
				<input type="number" class="kkart-quantity-input" min="1" name="quantity" value="1">
				<i class="fas fa-plus kkart-plus"></i>
			</div>`;
		}
	el['atts']['kkart_cart_form'] += `</div>
		<button class="kkart-cart-btn-holder" type="submit" name="add-to-cart" value="${pagelayer_postID}">`;
		if(!pagelayer_empty(el.atts['cart_icon'])){
			el['atts']['kkart_cart_form'] += `<i class="${el.atts['cart_icon']} kkart-cart-btn-icon"></i>`;
		}
		
		if(!pagelayer_empty(el.atts['cart_text'])){
			el['atts']['kkart_cart_form'] += `<span class="kkart-cart-btn-text">${el.atts['cart_text']}</span>`;
		}
		
		if(!pagelayer_empty(el.atts['cart_icon'])){
			el['atts']['kkart_cart_form'] += `<i class="${el.atts['cart_icon']} kkart-cart-btn-icon"></i>`;
		}
	el['atts']['kkart_cart_form'] += `</button>
</form>`;
}

function pagelayer_render_end_pl_kkart_add_to_cart(el){
	kkart_pl_product_quantity(el.$);
}

//Product Gallery
function pagelayer_render_pl_kkart_img_gallery(el){
	
	var default_img = [];
	
	// Set default image for the editor
	for(var i=1; i < 6; i++){
		default_img['i1.'+i] = pagelayer.blank_img;
	}
	
	//The URLs
	var img_urls = !pagelayer_empty(el.tmp['ids-urls']) ? JSON.parse(el.tmp['ids-urls']) : default_img;
	var all_urls = !pagelayer_empty(el.tmp['ids-all-urls']) ? JSON.parse(el.tmp['ids-all-urls']) : [];
	var img_title = !pagelayer_empty(el.tmp['ids-all-titles']) ? JSON.parse(el.tmp['ids-all-titles']) : [];
	var img_links = !pagelayer_empty(el.tmp['ids-all-links']) ? JSON.parse(el.tmp['ids-all-links']) : [];
	//console.log(all_urls);
		
	var  primary_image = '';
	var gallery_html = '';
	var i=0;
	
	for (var x in img_urls){
  
		var active_class = "";
    
		//Use the default URL first
		var url = img_urls[x];
		
		if(i == 0){
			primary_image = '<img class="kkart-product-pimage" src="'+url+'" title="'+img_title[x]+'" alt="'+img_title[x]+'">';
		}
		
		//But if we have a custom size, use that
		if(el.atts['size'] != 'custom' && x in all_urls && el.atts['size'] in all_urls[x]){
			url = all_urls[x][el.atts['size']];
		}
    
		if(i == 0){
			active_class = "kkart-product-active";
		}
    
		gallery_html += '<li class="kkart-gallery-item"><a data-href="'+img_urls[x]+'" href="javascript:void(0);" class="kkart-ele-link""><img class="kkart-product-gimage '+active_class+'" src="'+url+'" title="'+img_title[x]+'" alt="'+img_title[x]+'"></a></li>';
		
		i++;	
	}
	
	el.atts['primary_image'] = primary_image;
	el.atts['gallery_html'] = gallery_html;
}

// Render the image slider
function pagelayer_render_end_pl_kkart_img_gallery(el){

	if(pagelayer_empty(el.atts['pzoom'])){
		el.$.unbind('mousemove mouseenter mouseleave');
	}
  
	kkart_pl_product_slider(el.$);
	
}

// Billing fields handler
function pagelayer_render_pl_kkart_billing_fields(el){
	
	var fields_html = '';
	var name = el.atts['field_name'];
	
	if(el.atts['type'] == 'number'){
		fields_html = '<input name="'+name+'" type="number" />';
	}else if(el.atts['type'] == 'email'){
		fields_html = '<input name="'+name+'" type="email" />';
	}else if(el.atts['type'] == 'url'){
		fields_html = '<input name="'+name+'" type="url" />';
	}else{
		fields_html = '<input name="'+name+'" type="text" />';
	}
	
	el.atts['fields_html'] = fields_html;
}

// Shipping fields handler
function pagelayer_render_pl_kkart_shipping_fields(el){
	
	var fields_html = '';
	var name = el.atts['field_name'];
	
	if(el.atts['type'] == 'number'){
		fields_html = '<input name="'+name+'" type="number" />';
	}else if(el.atts['type'] == 'email'){
		fields_html = '<input name="'+name+'" type="email" />';
	}else if(el.atts['type'] == 'url'){
		fields_html = '<input name="'+name+'" type="url" />';
	}else{
		fields_html = '<input name="'+name+'" type="text" />';
	}
	
	el.atts['fields_html'] = fields_html;
}

////////////////////////////////////////////
//// Copied from pagelayer
////////////////////////////////////////////

// Render the related product
function pagelayer_render_pl_kkart_product_related(el){
	
	el.atts['related_products'] = '';
	
	// if is related
	if(el['atts']['select_product'] == 'related'){
		
		var args = {
			'posts_per_page' : 4,
			'columns' : 4,
			'orderby' : el.atts['orderby'],
			'order' : el.atts['order'],
		};
		
		if ( ! pagelayer_empty( el['atts']['posts_per_page'] ) ) {
			args['posts_per_page'] =  el['atts']['posts_per_page'];
		}

		if ( ! pagelayer_empty( el['atts']['columns'] ) ) {
			args['columns'] = el['atts']['columns'];
		}
		// Clear any previous timeout
		clearTimeout(product_data_timer[el.id]);
		
		// Set a timer for constant change
		product_data_timer[el.id] = setTimeout(function(){

			jQuery.ajax({
				url: pagelayer_ajax_url+'&action=pagelayer_product_related&postID='+pagelayer_postID,
				type: 'post',
				data: {
					pagelayer_nonce: pagelayer_ajax_nonce,
					pagelayer_args: args,
				},
				success: function(response){
					el.$.find('.pagelayer-product-related-container').html(response);
				}
			});
			
		}, 200);
		
	// If is upsell
	}else if(el['atts']['select_product'] == 'upsell'){
		
		var limit = '-1';
		var columns = 4;
		var orderby = el.atts['orderby'];
		var order =  el.atts['order'];

		if ( ! pagelayer_empty( el.atts['columns'] ) ) {
			columns = el.atts['columns'];
		}
		
		// Clear any previous timeout
		clearTimeout(product_data_timer[el.id]);
		
		// Set a timer for constant change
		product_data_timer[el.id] = setTimeout(function(){
		
			jQuery.ajax({
				url: pagelayer_ajax_url+'&action=pagelayer_product_upsell&postID='+pagelayer_postID,
				type: 'post',
				data: {
					pagelayer_nonce: pagelayer_ajax_nonce,
					limit: limit,
					columns: columns,
					orderby: orderby,
					order: order,
				},
				success: function(response){
					el.$.find('.pagelayer-product-related-container').html(response);
				}
			});
		
		}, 200);
	}
	
}

// Render the kkart pages
function pagelayer_render_pl_kkart_pages(el){
	
	el.atts['page_content'] = '';
	var shortcode ='';
	
	// if is not empty
	if( !pagelayer_empty(el.atts['pages']) ){
		shortcode = '['+ el.atts['pages'] +']';
	}
	
	jQuery.ajax({
		url: pagelayer_ajax_url+'&action=pagelayer_do_shortcodes',
		type: 'post',
		data: {
			pagelayer_nonce: pagelayer_ajax_nonce,
			shortcode_data: shortcode,
		},
		success: function(response){
						
			// If the content is empty
			if(pagelayer_empty(response)){
				response = '<div class="kkart">Content not found</div>';
			}
			
			// if is checkout page
			if ( 'kkart_checkout' === el.atts['pages'] && '<div class="kkart"></div>' ==  $content ) {
				response = '<div class="kkart">Your cart is currently empty.</div>';
			}
			
			el.$.find('.pagelayer-woo-pages-container').html(response);
		}
	});
	
}

// Render the kkart pages
function pagelayer_render_pl_kkart_product_categories(el){
	
	el.atts['product_categories'] = '';
	
	// Clear any previous timeout
	clearTimeout(product_data_timer[el.id]);
	
	// Set a timer for constant change
	product_data_timer[el.id] = setTimeout(function(){
			
		jQuery.ajax({
			url: pagelayer_ajax_url+'&action=pagelayer_product_categories',
			type: 'post',
			data: {
				pagelayer_nonce: pagelayer_ajax_nonce,
				atts: el.atts,
			},
			success: function(response){				
				el.$.find('.pagelayer-product-categories-container').html(response);
			}
		});
		
	}, 200);
	
}

// Render the archive products
function pagelayer_render_pl_kkart_product_archives(el){
	
	return;
	el.atts['product_archives'] = '';
	
	// Clear any previous timeout
	clearTimeout(product_data_timer[el.id]);
	
	// Set a timer for constant change
	product_data_timer[el.id] = setTimeout(function(){
			
		jQuery.ajax({
			url: pagelayer_ajax_url+'&action=kkart_product_archives',
			type: 'post',
			data: {
				pagelayer_nonce: pagelayer_ajax_nonce,
				atts: el.atts,
			},
			success: function(response){		
				el.$.find('.pagelayer-product-archives-container').html(response);
			}
		});
		
	}, 200);
	
}

// Render the products
function pagelayer_render_end_pl_kkart_products(el){

	pagelayer_owl_destroy(el.$, '.pagelayer-products-container');
	kkart_products_handler(el.$);
	
}

// Render the Demo Description handler
function  pagelayer_render_pl_kkart_short_desc(el){
	el.atts['product_short_desc'] = 'Demo Description';
}

// Render the products
function pagelayer_render_end_pl_kkart_menu_cart(el){
	pagelayer_woo_menu_cart(el.$);
}

// Render the product thumbnail
function pagelayer_render_pl_kkart_archive_thumb(el){
	
	var default_img = [];
	var thumb = '';
	
	// Set default image for the editor
	if(el.atts['gallery']){
  
		for(var i=0; i < 5; i++){
			default_img[i] = [];
			default_img[i]['url'] = pagelayer.blank_img;
		}
    
	}else{
		default_img['url'] = pagelayer.blank_img;
	}
  
	var img_urls = !pagelayer_empty(el.tmp['ids-urls']) ? JSON.parse(el.tmp['ids-urls']) : default_img;
	var all_urls = !pagelayer_empty(el.tmp['ids-all-urls']) ? JSON.parse(el.tmp['ids-all-urls']) : [];
	
	if(el.atts['gallery']){
		
		thumb = '<ul class="kkart-thumbnail-gallery pagelayer-owl-holder pagelayer-owl-carousel pagelayer-owl-theme">';
	
  	for(var i=0; i < 5; i++){
			var url = '';
      
			if(i in img_urls){
				url = img_urls[i]['url'];
        
				if(el.atts['size'] != 'custom' && i in all_urls && el.atts['size'] in all_urls[i]){
					url = all_urls[i][el.atts['size']];
				}
        
			}else{
				url = img_urls['url'];
        
				if(el.atts['size'] != 'custom' && el.atts['size'] in all_urls){
					url = all_urls[el.atts['size']];
				}
        
			}
      
			thumb += '<li class="kkart-thumb-gallery-item"><img src="'+url+'"/></li>';
		}
    
		thumb += '</ul>';
	}else{
		var x = 0;
		var url = '';
    
		if(x in img_urls){
			url = img_urls[x]['url'];
      
			if(el.atts['size'] != 'custom' && x in all_urls && el.atts['size'] in all_urls[x]){
				url = all_urls[x][el.atts['size']];
			}
      
		}else{
			url = img_urls['url'];
      
			if(el.atts['size'] != 'custom' && el.atts['size'] in all_urls){
				url = all_urls[el.atts['size']];
			}
      
		}
    
		thumb = '<img class="kkart-thumb-img" src="'+url+'"/>';
	}
	
	el['atts']['product_thumb'] = thumb;
	
	if('controls' in el.atts && (el.atts['controls'] == 'arrows' || el.atts['controls'] == 'none')){
		el.CSS.attr.push({'sel': '.kkart-thumbnail-gallery', 'val': 'data-pager="false"'});
	}
	
	if('controls' in el.atts && (el.atts['controls'] == 'pager' || el.atts['controls'] == 'none')){
		el.CSS.attr.push({'sel': '.kkart-thumbnail-gallery', 'val': 'data-controls="false"'});
	}
  
}

// Render the archive thumbnail
function pagelayer_render_end_pl_kkart_archive_thumb(el){

	if(el.atts['gallery']){
		pagelayer_owl_destroy(el.$, '.kkart-thumbnail-gallery');
		kkart_thumbnail_img_slider(el.$);
	}
  
}

// Render the product Title
function pagelayer_render_pl_kkart_title(el){
	el.atts['product_title'] = 'Product Title';
}

// Render the product Rating
function pagelayer_render_pl_kkart_product_rating(el){
	el.atts['product_rating'] = 2.5;
	el.atts['product_review_count'] = 1;
}

function pagelayer_render_end_pl_kkart_product_rating(el){
	var jEle = el.$.find('.pagelayer-stars-container');
	pagelayer_stars(jEle);
}

function pagelayer_render_pl_kkart_sale(el){
	el.atts['is_on_sale'] = true;
	if(el.atts['show_discount']){
		el.atts['sale_discount'] = '13%';
	}
}

// Cart item count
function pagelayer_render_pl_kkart_cart_item_count(el){
	el.atts['item_count'] = '1';
}

function pagelayer_render_pl_kkart_addi_info(el){
	el.atts['product_addi_info_heading'] = 'Additional Information';
	el.atts['product_addi_info'] = '<tr class="kkart-product-attributes-item kkart-product attributes-item--label"><th class="kkart-product-attributes-item__label">label</th><td class="kkart-product-attributes-item__value">value</td></tr>';
}

function pagelayer_render_pl_kkart_meta(el){
	el.atts['sku_value'] = 'SKU1234';
	el.atts['category_label'] = 'Category: ';
	el.atts['category_value'] = '<a href="" rel="tag">product</a>';
	el.atts['tag_label'] = 'Tag: ';
	el.atts['tag_value'] = '<a href="" rel="tag">shop</a>';
}

function pagelayer_render_pl_kkart_billing_form(el){
	
	var billing_here = el.atts['billing_here'];
	
	if(!pagelayer_empty(el.atts['form_type'])){
		 billing_here = el.atts['shipping_here'];
	}
	
	el.atts['address_details_div'] = '<div class="kkart-address-details">'+
		'<div class="kkart-billing-detail">'+el.atts['address_details']+'</div>'+
		'<button class="kkart-billing-here">'+billing_here+'</button>'+
		'<button class="kkart-billing-edit">'+el.atts['billing_edit']+'</button>'+
		'<button class="kkart-billing-delete">'+el.atts['billing_delete']+'</button>'+
	'</div>';
}

var kkart_tabholder_content = '';
var kkart_tabcontent_content = '';
function pagelayer_render_pl_kkart_myaccount_tabs(el){
	
	var jEle = el.$;
	
	if(kkart_tabholder_content != '' || kkart_tabcontent_content != ''){
		el['atts']['tab_holder'] = kkart_tabholder_content;
		el['atts']['tab_content'] = kkart_tabcontent_content;
		kkart_myaccount_tabs(jEle);
		return;
	}
	
	el['atts']['tab_holder'] = 'tabholder';
	el['atts']['tab_content'] = 'tabcontainer';
	
	var shortcode_data = pagelayer_generate_sc(jEle, true);
	//console.log(shortcode_data);
	
	// Make the call
	jQuery.ajax({
		url: pagelayer_ajax_url+'&action=pagelayer_do_shortcodes',
		type: 'POST',
		data: {
			pagelayer_nonce: pagelayer_ajax_nonce,
			shortcode_data: shortcode_data
		},
		success:function(data) {
		
			kkart_tabholder_content = jQuery(data).find('.kkart-myaccount-tabholder').html();
			kkart_tabcontent_content = jQuery(data).find('.kkart-myaccount-tabcontainer').html();
			
			jEle.find('.kkart-myaccount-tabholder').html(kkart_tabholder_content);
			jEle.find('.kkart-myaccount-tabcontainer').html(kkart_tabcontent_content);
			
			kkart_myaccount_tabs(jEle);
		}
	});
	
}

// my account tabs holder
function pagelayer_render_end_pl_kkart_myaccount_tabs(el){
	kkart_myaccount_tabs(el.$);
}

kkart_checkout_form_content = '';
kkart_shortcodes_timer = '';
// Checkout form handler
function pagelayer_render_pl_kkart_checkout_form(el){
	
	var jEle = el.$;
	var time = 100;
	
	if(kkart_checkout_form_content != ''){
		el['atts']['checkout_form'] = kkart_checkout_form_content;
		jEle.find('.kkart-checkout-tab').each(function(){
			kkart_checkout_tabs(jQuery(this));
		});
		return;
	}
	
	// Clear any previous timeout
	clearTimeout(kkart_shortcodes_timer);
	
	// Set a timer for constant change
	kkart_shortcodes_timer = setTimeout(function(){
		
		var shortcode_data = pagelayer_generate_sc(jEle, true);
	
		// Make the call
		jQuery.ajax({
			url: pagelayer_ajax_url+'&action=pagelayer_do_shortcodes',
			type: 'POST',
			data: {
				pagelayer_nonce: pagelayer_ajax_nonce,
				shortcode_data: shortcode_data
			},
			success:function(data) {
				
				var content = jQuery(data).find('.kkart-checkout-holder').html();
				
				jEle.find('.kkart-checkout-holder').html(content);
				jEle.find('.kkart-checkout-tab').each(function(){
					kkart_checkout_tabs(jQuery(this));
				});
				
				kkart_checkout_form_content = jEle.find('.kkart-checkout-holder').html();
			}
		});
	
	}, time);
	
}

// Checkout order recieved info handler
function pagelayer_render_pl_kkart_order_info(el){

	if(el['atts']['editor_view'] == 'failed'){
		el['atts']['show_failed'] = true;
		el['atts']['failed_text'] += '<p class="kkart-notice kkart-notice--error kkart-thankyou-order-failed-actions">'+
			'<a href="#" class="button pay">Pay</a>'+
			'<a href="#" class="button pay">My account</a>'+
		'</p>';
	}else if(el['atts']['editor_view'] == 'not_found'	){
		el['atts']['show_not_found'] = true;
	}else{
		el['atts']['show_info'] = true;
	}
  
}

// Checkout order recieved info handler
function pagelayer_render_pl_kkart_buy_now(el){
	el['atts']['buy_now_show'] = true;
}

function pagelayer_render_pl_kkart_archive_crt_btn(el){
	
	if(!pagelayer_empty(el.atts['show_quantity_holder'])){
		
		el.atts['kkart_quantity_holder'] = '<div class="kkart-quantity">'+''+'<i class="fas fa-minus kkart-minus"></i>'+''+'<input type="number" min="1" class="kkart-quantity-input" name="quantity" value="1">'+''+'<i class="fas fa-plus kkart-plus"></i>'+
		''+'</div>'+''+'<div class="kkart-quantity-close">'+''+'<i class="fas fa-times kkart-close"></i>'+''+'</div>';
	}
	if(!pagelayer_empty(el.atts['show_view_cart'])){
		el.atts['kkart_view_cart'] = '<a href="'+kkart_add_to_cart_params.cart_url+'" class="kkart-view-btn" title="'+el['atts']['view_crt_btn_text']+'">'+el['atts']['view_crt_btn_text']+'</a>';
	}
}

function pagelayer_render_end_pl_kkart_archive_crt_btn(el){
	kkart_archive_crt_btn_holder(el.$);
}
