<?php
/**
 * Edit address form
 *
 * This template can be overridden by copying it to yourtheme/kkart/myaccount/form-edit-address.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

$page_title = ( 'billing' === $load_address ) ? esc_html__( 'Billing address', 'kkart' ) : esc_html__( 'Shipping address', 'kkart' );

do_action( 'kkart_before_edit_account_address_form' ); ?>

<?php if ( ! $load_address ) : ?>
	<?php kkart_get_template( 'myaccount/my-address.php' ); ?>
<?php else : ?>

	<form method="post">

		<h3><?php echo apply_filters( 'kkart_my_account_edit_address_title', $page_title, $load_address ); ?></h3><?php // @codingStandardsIgnoreLine ?>

		<div class="kkart-address-fields">
			<?php do_action( "kkart_before_edit_address_form_{$load_address}" ); ?>

			<div class="kkart-address-fields__field-wrapper">
				<?php
				foreach ( $address as $key => $field ) {
					kkart_form_field( $key, $field, kkart_get_post_data_by_key( $key, $field['value'] ) );
				}
				?>
			</div>

			<?php do_action( "kkart_after_edit_address_form_{$load_address}" ); ?>

			<p>
				<button type="submit" class="button" name="save_address" value="<?php esc_attr_e( 'Save address', 'kkart' ); ?>"><?php esc_html_e( 'Save address', 'kkart' ); ?></button>
				<?php wp_nonce_field( 'kkart-edit_address', 'kkart-edit-address-nonce' ); ?>
				<input type="hidden" name="action" value="edit_address" />
			</p>
		</div>

	</form>

<?php endif; ?>

<?php do_action( 'kkart_after_edit_account_address_form' ); ?>
